'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = mergeRules;

var _hasAllProps = require('./hasAllProps');

var _hasAllProps2 = _interopRequireDefault(_hasAllProps);

var _getDecls = require('./getDecls');

var _getDecls2 = _interopRequireDefault(_getDecls);

var _getRules = require('./getRules');

var _getRules2 = _interopRequireDefault(_getRules);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function mergeRules(rule, properties, callback) {
    let decls = (0, _getDecls2.default)(rule, properties);
    while (decls.length) {
        const last = decls[decls.length - 1];
        const props = decls.filter(node => node.important === last.important);
        const rules = (0, _getRules2.default)(props, properties);
        if ((0, _hasAllProps2.default)(rules, ...properties)) {
            if (callback(rules, last, props)) {
                decls = decls.filter(node => !~rules.indexOf(node));
            }
        }
        decls = decls.filter(node => node !== last);
    }
}
module.exports = exports['default'];