'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _postcss = require('postcss');

var _postcss2 = _interopRequireDefault(_postcss);

var _postcssValueParser = require('postcss-value-parser');

var _postcssValueParser2 = _interopRequireDefault(_postcssValueParser);

var _cssnanoUtilGetArguments = require('cssnano-util-get-arguments');

var _cssnanoUtilGetArguments2 = _interopRequireDefault(_cssnanoUtilGetArguments);

var _isColorStop = require('is-color-stop');

var _isColorStop2 = _interopRequireDefault(_isColorStop);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var angles = {
    top: '0deg',
    right: '90deg',
    bottom: '180deg',
    left: '270deg'
};

function isLessThan(a, b) {
    return a.unit === b.unit && parseFloat(a.number) >= parseFloat(b.number);
}

function optimise(decl) {
    if (!~decl.value.indexOf('gradient')) {
        return;
    }
    decl.value = (0, _postcssValueParser2.default)(decl.value).walk(function (node) {
        if (node.type !== 'function' || !node.nodes.length) {
            return false;
        }
        if (node.value === 'linear-gradient' || node.value === 'repeating-linear-gradient' || node.value === '-webkit-linear-gradient' || node.value === '-webkit-repeating-linear-gradient') {
            var args = (0, _cssnanoUtilGetArguments2.default)(node);
            if (node.nodes[0].value === 'to' && args[0].length === 3) {
                node.nodes = node.nodes.slice(2);
                node.nodes[0].value = angles[node.nodes[0].value];
            }
            var lastStop = null;
            args.forEach(function (arg, index) {
                if (!arg[2]) {
                    return;
                }
                var isFinalStop = index === args.length - 1;
                var thisStop = (0, _postcssValueParser.unit)(arg[2].value);
                if (lastStop === null) {
                    lastStop = thisStop;
                    if (!isFinalStop && lastStop && lastStop.number === '0' && lastStop.unit !== 'deg') {
                        arg[1].value = arg[2].value = '';
                    }
                    return;
                }
                if (isLessThan(lastStop, thisStop)) {
                    arg[2].value = 0;
                }
                lastStop = thisStop;
                if (isFinalStop && arg[2].value === '100%') {
                    arg[1].value = arg[2].value = '';
                }
            });
            return false;
        }
        if (node.value === 'radial-gradient' || node.value === 'repeating-radial-gradient') {
            var _args = (0, _cssnanoUtilGetArguments2.default)(node);
            var _lastStop = void 0;
            var hasAt = _args[0].find(function (n) {
                return n.value === 'at';
            });
            _args.forEach(function (arg, index) {
                if (!arg[2] || !index && hasAt) {
                    return;
                }
                var thisStop = (0, _postcssValueParser.unit)(arg[2].value);
                if (!_lastStop) {
                    _lastStop = thisStop;
                    return;
                }
                if (isLessThan(_lastStop, thisStop)) {
                    arg[2].value = 0;
                }
                _lastStop = thisStop;
            });
            return false;
        }
        if (node.value === '-webkit-radial-gradient' || node.value === '-webkit-repeating-radial-gradient') {
            var _args2 = (0, _cssnanoUtilGetArguments2.default)(node);
            var _lastStop2 = void 0;
            _args2.forEach(function (arg) {
                var color = void 0;
                var stop = void 0;
                if (arg[2] !== undefined) {
                    if (arg[0].type === 'function') {
                        color = `${arg[0].value}(${(0, _postcssValueParser.stringify)(arg[0].nodes)})`;
                    } else {
                        color = arg[0].value;
                    }
                    if (arg[2].type === 'function') {
                        stop = `${arg[2].value}(${(0, _postcssValueParser.stringify)(arg[2].nodes)})`;
                    } else {
                        stop = arg[2].value;
                    }
                } else {
                    if (arg[0].type === 'function') {
                        color = `${arg[0].value}(${(0, _postcssValueParser.stringify)(arg[0].nodes)})`;
                    }
                    color = arg[0].value;
                }
                var colorStop = stop || stop === 0 ? (0, _isColorStop2.default)(color, stop) : (0, _isColorStop2.default)(color);

                if (!colorStop || !arg[2]) {
                    return;
                }
                var thisStop = (0, _postcssValueParser.unit)(arg[2].value);
                if (!_lastStop2) {
                    _lastStop2 = thisStop;
                    return;
                }
                if (isLessThan(_lastStop2, thisStop)) {
                    arg[2].value = 0;
                }
                _lastStop2 = thisStop;
            });
            return false;
        }
    }).toString();
}

exports.default = _postcss2.default.plugin('postcss-minify-gradients', function () {
    return function (css) {
        return css.walkDecls(optimise);
    };
});
module.exports = exports['default'];