'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _postcss = require('postcss');

var _postcss2 = _interopRequireDefault(_postcss);

var _postcssValueParser = require('postcss-value-parser');

var _postcssValueParser2 = _interopRequireDefault(_postcssValueParser);

var _alphanumSort = require('alphanum-sort');

var _alphanumSort2 = _interopRequireDefault(_alphanumSort);

var _uniqs = require('uniqs');

var _uniqs2 = _interopRequireDefault(_uniqs);

var _cssnanoUtilGetArguments = require('cssnano-util-get-arguments');

var _cssnanoUtilGetArguments2 = _interopRequireDefault(_cssnanoUtilGetArguments);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Return the greatest common divisor
 * of two numbers.
 */

function gcd(a, b) {
    return b ? gcd(b, a % b) : a;
}

function aspectRatio(a, b) {
    var divisor = gcd(a, b);

    return [a / divisor, b / divisor];
}

function split(args) {
    return args.map(function (arg) {
        return (0, _postcssValueParser.stringify)(arg);
    }).join('');
}

function removeNode(node) {
    node.value = '';
    node.type = 'word';
}

function transform(rule) {
    // We should not re-arrange parameters for css-modules' @value
    // at-rule. For example:
    //
    // @value vertical, center from "./foo.css";
    if (!rule.params || rule.name === 'value') {
        return;
    }

    var params = (0, _postcssValueParser2.default)(rule.params);

    params.walk(function (node, index) {
        if (node.type === 'div' || node.type === 'function') {
            node.before = node.after = '';
            if (node.type === 'function' && node.nodes[4] && node.nodes[0].value.indexOf('-aspect-ratio') === 3) {
                var _aspectRatio = aspectRatio(node.nodes[2].value, node.nodes[4].value),
                    _aspectRatio2 = _slicedToArray(_aspectRatio, 2),
                    a = _aspectRatio2[0],
                    b = _aspectRatio2[1];

                node.nodes[2].value = a;
                node.nodes[4].value = b;
            }
        } else if (node.type === 'space') {
            node.value = ' ';
        } else {
            var prevWord = params.nodes[index - 2];
            if (node.value === 'all' && rule.name === 'media' && !prevWord) {
                var nextSpace = params.nodes[index + 1];
                var nextWord = params.nodes[index + 2];
                var secondSpace = params.nodes[index + 3];
                if (nextWord && nextWord.value === 'and') {
                    removeNode(nextWord);
                    removeNode(nextSpace);
                    removeNode(secondSpace);
                }
                removeNode(node);
            }
        }
    }, true);

    rule.params = (0, _alphanumSort2.default)((0, _uniqs2.default)((0, _cssnanoUtilGetArguments2.default)(params).map(split)), {
        insensitive: true
    }).join();

    if (!rule.params.length) {
        rule.raws.afterName = '';
    }
}

exports.default = _postcss2.default.plugin('postcss-minify-params', function () {
    return function (css) {
        return css.walkAtRules(transform);
    };
});
module.exports = exports['default'];