'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _postcss = require('postcss');

var _postcss2 = _interopRequireDefault(_postcss);

var _postcssValueParser = require('postcss-value-parser');

var _postcssValueParser2 = _interopRequireDefault(_postcssValueParser);

var _cssnanoUtilGetArguments = require('cssnano-util-get-arguments');

var _cssnanoUtilGetArguments2 = _interopRequireDefault(_cssnanoUtilGetArguments);

var _cssnanoUtilGetMatch = require('cssnano-util-get-match');

var _cssnanoUtilGetMatch2 = _interopRequireDefault(_cssnanoUtilGetMatch);

var _map = require('./lib/map');

var _map2 = _interopRequireDefault(_map);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function evenValues(list, index) {
    return index % 2 === 0;
}

var repeatKeywords = _map2.default.map(function (mapping) {
    return mapping[0];
});

var getMatch = (0, _cssnanoUtilGetMatch2.default)(_map2.default);

function transform(decl) {
    var values = (0, _postcssValueParser2.default)(decl.value);
    if (values.nodes.length === 1) {
        return;
    }
    var args = (0, _cssnanoUtilGetArguments2.default)(values);
    var relevant = [];
    args.forEach(function (arg) {
        relevant.push({
            start: null,
            end: null
        });
        arg.forEach(function (part, index) {
            var isRepeat = ~repeatKeywords.indexOf(part.value);
            var len = relevant.length - 1;
            if (relevant[len].start === null && isRepeat) {
                relevant[len].start = index;
                relevant[len].end = index;
                return;
            }
            if (relevant[len].start !== null) {
                if (part.type === 'space') {
                    return;
                } else if (isRepeat) {
                    relevant[len].end = index;
                    return;
                }
                return;
            }
        });
    });
    relevant.forEach(function (range, index) {
        if (range.start === null) {
            return;
        }
        var val = args[index].slice(range.start, range.end + 1);
        if (val.length !== 3) {
            return;
        }
        var match = getMatch(val.filter(evenValues).map(function (n) {
            return n.value;
        }));
        if (match) {
            args[index][range.start].value = match;
            args[index][range.start + 1].value = '';
            args[index][range.end].value = '';
        }
    });
    decl.value = values.toString();
}

exports.default = _postcss2.default.plugin('postcss-normalize-repeat-style', function () {
    return function (css) {
        return css.walkDecls(/background(-repeat)?|(-webkit-)?mask-repeat/, transform);
    };
});
module.exports = exports['default'];