'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = normalizeBorder;

var _postcssValueParser = require('postcss-value-parser');

// border: <line-width> || <line-style> || <color>
// outline: <outline-color> || <outline-style> || <outline-width>

var borderWidths = ['thin', 'medium', 'thick'];

var borderStyles = ['none', 'auto', // only in outline-style
'hidden', 'dotted', 'dashed', 'solid', 'double', 'groove', 'ridge', 'inset', 'outset'];

function normalizeBorder(decl, border) {
    var order = { width: '', style: '', color: '' };
    border.walk(function (node) {
        var type = node.type,
            value = node.value;

        if (type === 'word') {
            if (~borderStyles.indexOf(value)) {
                order.style = value;
                return false;
            }
            if (~borderWidths.indexOf(value) || (0, _postcssValueParser.unit)(value)) {
                order.width = value;
                return false;
            }
            order.color = value;
            return false;
        }
        if (type === 'function') {
            if (value === 'calc') {
                order.width = (0, _postcssValueParser.stringify)(node);
            } else {
                order.color = (0, _postcssValueParser.stringify)(node);
            }
            return false;
        }
    });
    decl.value = `${order.width} ${order.style} ${order.color}`.trim();
};
module.exports = exports['default'];