'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = normalizeBoxShadow;

var _postcssValueParser = require('postcss-value-parser');

var _cssnanoUtilGetArguments = require('cssnano-util-get-arguments');

var _cssnanoUtilGetArguments2 = _interopRequireDefault(_cssnanoUtilGetArguments);

var _addSpace = require('../lib/addSpace');

var _addSpace2 = _interopRequireDefault(_addSpace);

var _getValue = require('../lib/getValue');

var _getValue2 = _interopRequireDefault(_getValue);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

// box-shadow: inset? && <length>{2,4} && <color>?

function normalizeBoxShadow(decl, parsed) {
    var args = (0, _cssnanoUtilGetArguments2.default)(parsed);
    var abort = false;

    var values = args.reduce(function (list, arg) {
        var val = [];
        var state = {
            inset: [],
            color: []
        };
        arg.forEach(function (node) {
            var type = node.type,
                value = node.value;

            if (type === 'function' && ~value.indexOf('calc')) {
                abort = true;
                return;
            }
            if (type === 'space') {
                return;
            }
            if ((0, _postcssValueParser.unit)(value)) {
                val = [].concat(_toConsumableArray(val), [node, (0, _addSpace2.default)()]);
            } else if (value === 'inset') {
                state.inset = [].concat(_toConsumableArray(state.inset), [node, (0, _addSpace2.default)()]);
            } else {
                state.color = [].concat(_toConsumableArray(state.color), [node, (0, _addSpace2.default)()]);
            }
        });
        return [].concat(_toConsumableArray(list), [[].concat(_toConsumableArray(state.inset), _toConsumableArray(val), _toConsumableArray(state.color))]);
    }, []);

    if (abort) {
        return;
    }

    decl.value = (0, _getValue2.default)(values);
}
module.exports = exports['default'];