'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = normalizeFlexFlow;
// flex-flow: <flex-direction> || <flex-wrap>

var flexDirection = ['row', 'row-reverse', 'column', 'column-reverse'];

var flexWrap = ['nowrap', 'wrap', 'wrap-reverse'];

function normalizeFlexFlow(decl, flexFlow) {
    var order = {
        direction: '',
        wrap: ''
    };
    flexFlow.walk(function (_ref) {
        var value = _ref.value;

        if (~flexDirection.indexOf(value)) {
            order.direction = value;
            return;
        }
        if (~flexWrap.indexOf(value)) {
            order.wrap = value;
            return;
        }
    });
    decl.value = `${order.direction} ${order.wrap}`.trim();
};
module.exports = exports['default'];