'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = normalizeTransition;

var _postcssValueParser = require('postcss-value-parser');

var _cssnanoUtilGetArguments = require('cssnano-util-get-arguments');

var _cssnanoUtilGetArguments2 = _interopRequireDefault(_cssnanoUtilGetArguments);

var _addSpace = require('../lib/addSpace');

var _addSpace2 = _interopRequireDefault(_addSpace);

var _getValue = require('../lib/getValue');

var _getValue2 = _interopRequireDefault(_getValue);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

// transition: [ none | <single-transition-property> ] || <time> || <single-transition-timing-function> || <time>

var timingFunctions = ['ease', 'linear', 'ease-in', 'ease-out', 'ease-in-out', 'step-start', 'step-end'];

function normalizeTransition(decl, parsed) {
    var args = (0, _cssnanoUtilGetArguments2.default)(parsed);

    var values = args.reduce(function (list, arg) {
        var state = {
            timingFunction: [],
            property: [],
            time1: [],
            time2: []
        };
        arg.forEach(function (node) {
            var type = node.type,
                value = node.value;

            if (type === 'space') {
                return;
            }
            if (type === 'function' && ~['steps', 'cubic-bezier'].indexOf(value)) {
                state.timingFunction = [].concat(_toConsumableArray(state.timingFunction), [node, (0, _addSpace2.default)()]);
            } else if ((0, _postcssValueParser.unit)(value)) {
                if (!state.time1.length) {
                    state.time1 = [].concat(_toConsumableArray(state.time1), [node, (0, _addSpace2.default)()]);
                } else {
                    state.time2 = [].concat(_toConsumableArray(state.time2), [node, (0, _addSpace2.default)()]);
                }
            } else if (~timingFunctions.indexOf(value)) {
                state.timingFunction = [].concat(_toConsumableArray(state.timingFunction), [node, (0, _addSpace2.default)()]);
            } else {
                state.property = [].concat(_toConsumableArray(state.property), [node, (0, _addSpace2.default)()]);
            }
        });
        return [].concat(_toConsumableArray(list), [[].concat(_toConsumableArray(state.property), _toConsumableArray(state.time1), _toConsumableArray(state.timingFunction), _toConsumableArray(state.time2))]);
    }, []);

    decl.value = (0, _getValue2.default)(values);
}
module.exports = exports['default'];