'use strict';

exports.__esModule = true;
exports.default = scssTokenize;
var SINGLE_QUOTE = 39;
var DOUBLE_QUOTE = 34;
var BACKSLASH = 92;
var SLASH = 47;
var NEWLINE = 10;
var SPACE = 32;
var FEED = 12;
var TAB = 9;
var CR = 13;
var OPEN_SQUARE = 91;
var CLOSE_SQUARE = 93;
var OPEN_PARENTHESES = 40;
var CLOSE_PARENTHESES = 41;
var OPEN_CURLY = 123;
var CLOSE_CURLY = 125;
var SEMICOLON = 59;
var ASTERICK = 42;
var COLON = 58;
var AT = 64;

// SCSS PATCH {
var COMMA = 44;
var HASH = 35;
// } SCSS PATCH

var RE_AT_END = /[ \n\t\r\f\{\(\)'"\\;/\[\]#]/g;
var RE_WORD_END = /[ \n\t\r\f\(\)\{\}:;@!'"\\\]\[#]|\/(?=\*)/g;
var RE_BAD_BRACKET = /.[\\\/\("'\n]/;

var RE_NEW_LINE = /[\r\f\n]/g; // SCSS PATCH

// SCSS PATCH function name was changed
function scssTokenize(input) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    var tokens = [];
    var css = input.css.valueOf();

    var ignore = options.ignoreErrors;

    var code = void 0,
        next = void 0,
        quote = void 0,
        lines = void 0,
        last = void 0,
        content = void 0,
        escape = void 0,
        nextLine = void 0,
        nextOffset = void 0,
        escaped = void 0,
        escapePos = void 0,
        prev = void 0,
        n = void 0;

    var brackets = void 0; // SCSS PATCH

    var length = css.length;
    var offset = -1;
    var line = 1;
    var pos = 0;

    function unclosed(what) {
        throw input.error('Unclosed ' + what, line, pos - offset);
    }

    while (pos < length) {
        code = css.charCodeAt(pos);

        if (code === NEWLINE || code === FEED || code === CR && css.charCodeAt(pos + 1) !== NEWLINE) {
            offset = pos;
            line += 1;
        }

        switch (code) {
            case NEWLINE:
            case SPACE:
            case TAB:
            case CR:
            case FEED:
                next = pos;
                do {
                    next += 1;
                    code = css.charCodeAt(next);
                    if (code === NEWLINE) {
                        offset = next;
                        line += 1;
                    }
                } while (code === SPACE || code === NEWLINE || code === TAB || code === CR || code === FEED);

                tokens.push(['space', css.slice(pos, next)]);
                pos = next - 1;
                break;

            case OPEN_SQUARE:
                tokens.push(['[', '[', line, pos - offset]);
                break;

            case CLOSE_SQUARE:
                tokens.push([']', ']', line, pos - offset]);
                break;

            case OPEN_CURLY:
                tokens.push(['{', '{', line, pos - offset]);
                break;

            case CLOSE_CURLY:
                tokens.push(['}', '}', line, pos - offset]);
                break;

            // SCSS PATCH {
            case COMMA:
                tokens.push(['word', ',', line, pos - offset, line, pos - offset + 1]);
                break;
            // } SCSS PATCH

            case COLON:
                tokens.push([':', ':', line, pos - offset]);
                break;

            case SEMICOLON:
                tokens.push([';', ';', line, pos - offset]);
                break;

            case OPEN_PARENTHESES:
                prev = tokens.length ? tokens[tokens.length - 1][1] : '';
                n = css.charCodeAt(pos + 1);
                if (prev === 'url' && n !== SINGLE_QUOTE && n !== DOUBLE_QUOTE && n !== SPACE && n !== NEWLINE && n !== TAB && n !== FEED && n !== CR) {
                    // SCSS PATCH {
                    brackets = 1;
                    escaped = false;
                    next = pos + 1;
                    while (next <= css.length - 1) {
                        n = css.charCodeAt(next);
                        if (n === BACKSLASH) {
                            escaped = !escaped;
                        } else if (n === OPEN_PARENTHESES) {
                            brackets += 1;
                        } else if (n === CLOSE_PARENTHESES) {
                            brackets -= 1;
                            if (brackets === 0) break;
                        }
                        next += 1;
                    }
                    // } SCSS PATCH

                    tokens.push(['brackets', css.slice(pos, next + 1), line, pos - offset, line, next - offset]);
                    pos = next;
                } else {
                    next = css.indexOf(')', pos + 1);
                    content = css.slice(pos, next + 1);

                    if (next === -1 || RE_BAD_BRACKET.test(content)) {
                        tokens.push(['(', '(', line, pos - offset]);
                    } else {
                        tokens.push(['brackets', content, line, pos - offset, line, next - offset]);
                        pos = next;
                    }
                }

                break;

            case CLOSE_PARENTHESES:
                tokens.push([')', ')', line, pos - offset]);
                break;

            case SINGLE_QUOTE:
            case DOUBLE_QUOTE:
                quote = code === SINGLE_QUOTE ? '\'' : '"';
                next = pos;
                do {
                    escaped = false;
                    next = css.indexOf(quote, next + 1);
                    if (next === -1) {
                        if (ignore) {
                            next = pos + 1;
                            break;
                        } else {
                            unclosed('quote');
                        }
                    }
                    escapePos = next;
                    while (css.charCodeAt(escapePos - 1) === BACKSLASH) {
                        escapePos -= 1;
                        escaped = !escaped;
                    }
                } while (escaped);

                content = css.slice(pos, next + 1);
                lines = content.split('\n');
                last = lines.length - 1;

                if (last > 0) {
                    nextLine = line + last;
                    nextOffset = next - lines[last].length;
                } else {
                    nextLine = line;
                    nextOffset = offset;
                }

                tokens.push(['string', css.slice(pos, next + 1), line, pos - offset, nextLine, next - nextOffset]);

                offset = nextOffset;
                line = nextLine;
                pos = next;
                break;

            case AT:
                RE_AT_END.lastIndex = pos + 1;
                RE_AT_END.test(css);
                if (RE_AT_END.lastIndex === 0) {
                    next = css.length - 1;
                } else {
                    next = RE_AT_END.lastIndex - 2;
                }
                tokens.push(['at-word', css.slice(pos, next + 1), line, pos - offset, line, next - offset]);
                pos = next;
                break;

            case BACKSLASH:
                next = pos;
                escape = true;
                while (css.charCodeAt(next + 1) === BACKSLASH) {
                    next += 1;
                    escape = !escape;
                }
                code = css.charCodeAt(next + 1);
                if (escape && code !== SLASH && code !== SPACE && code !== NEWLINE && code !== TAB && code !== CR && code !== FEED) {
                    next += 1;
                }
                tokens.push(['word', css.slice(pos, next + 1), line, pos - offset, line, next - offset]);
                pos = next;
                break;

            default:
                // SCSS PATCH {
                n = css.charCodeAt(pos + 1);

                if (code === HASH && n === OPEN_CURLY) {
                    var deep = 1;
                    next = pos;
                    while (deep > 0) {
                        next += 1;
                        if (css.length <= next) unclosed('interpolation');

                        code = css.charCodeAt(next);
                        n = css.charCodeAt(next + 1);

                        if (code === CLOSE_CURLY) {
                            deep -= 1;
                        } else if (code === HASH && n === OPEN_CURLY) {
                            deep += 1;
                        }
                    }

                    content = css.slice(pos, next + 1);
                    lines = content.split('\n');
                    last = lines.length - 1;

                    if (last > 0) {
                        nextLine = line + last;
                        nextOffset = next - lines[last].length;
                    } else {
                        nextLine = line;
                        nextOffset = offset;
                    }

                    tokens.push(['word', content, line, pos - offset, nextLine, next - nextOffset]);

                    offset = nextOffset;
                    line = nextLine;
                    pos = next;
                } else if (code === SLASH && n === ASTERICK) {
                    // } SCSS PATCH

                    next = css.indexOf('*/', pos + 2) + 1;
                    if (next === 0) {
                        if (ignore) {
                            next = css.length;
                        } else {
                            unclosed('comment');
                        }
                    }

                    content = css.slice(pos, next + 1);
                    lines = content.split('\n');
                    last = lines.length - 1;

                    if (last > 0) {
                        nextLine = line + last;
                        nextOffset = next - lines[last].length;
                    } else {
                        nextLine = line;
                        nextOffset = offset;
                    }

                    tokens.push(['comment', content, line, pos - offset, nextLine, next - nextOffset]);

                    offset = nextOffset;
                    line = nextLine;
                    pos = next;

                    // SCSS PATCH {
                } else if (code === SLASH && n === SLASH) {
                    RE_NEW_LINE.lastIndex = pos + 1;
                    RE_NEW_LINE.test(css);
                    if (RE_NEW_LINE.lastIndex === 0) {
                        next = css.length - 1;
                    } else {
                        next = RE_NEW_LINE.lastIndex - 2;
                    }

                    content = css.slice(pos, next + 1);

                    tokens.push(['comment', content, line, pos - offset, line, next - offset, 'inline']);

                    pos = next;
                    // } SCSS PATCH
                } else {
                    RE_WORD_END.lastIndex = pos + 1;
                    RE_WORD_END.test(css);
                    if (RE_WORD_END.lastIndex === 0) {
                        next = css.length - 1;
                    } else {
                        next = RE_WORD_END.lastIndex - 2;
                    }

                    tokens.push(['word', css.slice(pos, next + 1), line, pos - offset, line, next - offset]);
                    pos = next;
                }

                break;
        }

        pos++;
    }

    return tokens;
}
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;base64,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
