'use strict';

var SINGLE_QUOTE = 39;
var DOUBLE_QUOTE = 34;
var BACKSLASH = 92;
var SLASH = 47;
var NEWLINE = 10;
var SPACE = 32;
var FEED = 12;
var TAB = 9;
var CR = 13;
var OPEN_SQUARE = 91;
var CLOSE_SQUARE = 93;
var OPEN_PARENTHESES = 40;
var CLOSE_PARENTHESES = 41;
var OPEN_CURLY = 123;
var CLOSE_CURLY = 125;
var SEMICOLON = 59;
var ASTERISK = 42;
var COLON = 58;
var AT = 64;

// SCSS PATCH {
var COMMA = 44;
var HASH = 35;
// } SCSS PATCH

var RE_AT_END = /[ \n\t\r\f{}()'"\\;/[\]#]/g;
var RE_WORD_END = /[ \n\t\r\f(){}:;@!'"\\\][#]|\/(?=\*)/g;
var RE_BAD_BRACKET = /.[\\/("'\n]/;
var RE_HEX_ESCAPE = /[a-f0-9]/i;

var RE_NEW_LINE = /[\r\f\n]/g; // SCSS PATCH

// SCSS PATCH function name was changed
module.exports = function scssTokenize(input) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

  var css = input.css.valueOf();
  var ignore = options.ignoreErrors;

  var code = void 0,
      next = void 0,
      quote = void 0,
      lines = void 0,
      last = void 0,
      content = void 0,
      escape = void 0,
      nextLine = void 0,
      nextOffset = void 0,
      escaped = void 0,
      prev = void 0,
      n = void 0,
      currentToken = void 0;

  var brackets = void 0; // SCSS PATCH

  var length = css.length;
  var offset = -1;
  var line = 1;
  var pos = 0;
  var buffer = [];
  var returned = [];

  function unclosed(what) {
    throw input.error('Unclosed ' + what, line, pos - offset);
  }

  function endOfFile() {
    return returned.length === 0 && pos >= length;
  }

  // SCSS PATCH {
  function interpolation() {
    var deep = 1;
    var stringQuote = false;
    var stringEscaped = false;
    while (deep > 0) {
      next += 1;
      if (css.length <= next) unclosed('interpolation');

      code = css.charCodeAt(next);
      n = css.charCodeAt(next + 1);

      if (stringQuote) {
        if (!stringEscaped && code === stringQuote) {
          stringQuote = false;
          stringEscaped = false;
        } else if (code === BACKSLASH) {
          stringEscaped = !escaped;
        } else if (stringEscaped) {
          stringEscaped = false;
        }
      } else if (code === SINGLE_QUOTE || code === DOUBLE_QUOTE) {
        stringQuote = code;
      } else if (code === CLOSE_CURLY) {
        deep -= 1;
      } else if (code === HASH && n === OPEN_CURLY) {
        deep += 1;
      }
    }
  }
  // } SCSS PATCH

  function nextToken() {
    if (returned.length) return returned.pop();
    if (pos >= length) return;

    code = css.charCodeAt(pos);
    if (code === NEWLINE || code === FEED || code === CR && css.charCodeAt(pos + 1) !== NEWLINE) {
      offset = pos;
      line += 1;
    }

    switch (code) {
      case NEWLINE:
      case SPACE:
      case TAB:
      case CR:
      case FEED:
        next = pos;
        do {
          next += 1;
          code = css.charCodeAt(next);
          if (code === NEWLINE) {
            offset = next;
            line += 1;
          }
        } while (code === SPACE || code === NEWLINE || code === TAB || code === CR || code === FEED);

        currentToken = ['space', css.slice(pos, next)];
        pos = next - 1;
        break;

      case OPEN_SQUARE:
        currentToken = ['[', '[', line, pos - offset];
        break;

      case CLOSE_SQUARE:
        currentToken = [']', ']', line, pos - offset];
        break;

      case OPEN_CURLY:
        currentToken = ['{', '{', line, pos - offset];
        break;

      case CLOSE_CURLY:
        currentToken = ['}', '}', line, pos - offset];
        break;

      // SCSS PATCH {
      case COMMA:
        currentToken = ['word', ',', line, pos - offset, line, pos - offset + 1];
        break;
      // } SCSS PATCH

      case COLON:
        currentToken = [':', ':', line, pos - offset];
        break;

      case SEMICOLON:
        currentToken = [';', ';', line, pos - offset];
        break;

      case OPEN_PARENTHESES:
        prev = buffer.length ? buffer.pop()[1] : '';
        n = css.charCodeAt(pos + 1);

        // SCSS PATCH {
        if (prev === 'url' && n !== SINGLE_QUOTE && n !== DOUBLE_QUOTE) {
          brackets = 1;
          escaped = false;
          next = pos + 1;
          while (next <= css.length - 1) {
            n = css.charCodeAt(next);
            if (n === BACKSLASH) {
              escaped = !escaped;
            } else if (n === OPEN_PARENTHESES) {
              brackets += 1;
            } else if (n === CLOSE_PARENTHESES) {
              brackets -= 1;
              if (brackets === 0) break;
            }
            next += 1;
          }

          content = css.slice(pos, next + 1);
          lines = content.split('\n');
          last = lines.length - 1;

          if (last > 0) {
            nextLine = line + last;
            nextOffset = next - lines[last].length;
          } else {
            nextLine = line;
            nextOffset = offset;
          }

          currentToken = ['brackets', content, line, pos - offset, nextLine, next - nextOffset];

          offset = nextOffset;
          line = nextLine;
          pos = next;
          // } SCSS PATCH
        } else {
          next = css.indexOf(')', pos + 1);
          content = css.slice(pos, next + 1);

          if (next === -1 || RE_BAD_BRACKET.test(content)) {
            currentToken = ['(', '(', line, pos - offset];
          } else {
            currentToken = ['brackets', content, line, pos - offset, line, next - offset];
            pos = next;
          }
        }

        break;

      case CLOSE_PARENTHESES:
        currentToken = [')', ')', line, pos - offset];
        break;

      case SINGLE_QUOTE:
      case DOUBLE_QUOTE:
        // SCSS PATCH {
        quote = code;
        next = pos;

        escaped = false;
        while (next < length) {
          next++;
          if (next === length) unclosed('string');

          code = css.charCodeAt(next);
          n = css.charCodeAt(next + 1);

          if (!escaped && code === quote) {
            break;
          } else if (code === BACKSLASH) {
            escaped = !escaped;
          } else if (escaped) {
            escaped = false;
          } else if (code === HASH && n === OPEN_CURLY) {
            interpolation();
          }
        }
        // } SCSS PATCH

        content = css.slice(pos, next + 1);
        lines = content.split('\n');
        last = lines.length - 1;

        if (last > 0) {
          nextLine = line + last;
          nextOffset = next - lines[last].length;
        } else {
          nextLine = line;
          nextOffset = offset;
        }

        currentToken = ['string', css.slice(pos, next + 1), line, pos - offset, nextLine, next - nextOffset];

        offset = nextOffset;
        line = nextLine;
        pos = next;
        break;

      case AT:
        RE_AT_END.lastIndex = pos + 1;
        RE_AT_END.test(css);
        if (RE_AT_END.lastIndex === 0) {
          next = css.length - 1;
        } else {
          next = RE_AT_END.lastIndex - 2;
        }

        currentToken = ['at-word', css.slice(pos, next + 1), line, pos - offset, line, next - offset];

        pos = next;
        break;

      case BACKSLASH:
        next = pos;
        escape = true;
        while (css.charCodeAt(next + 1) === BACKSLASH) {
          next += 1;
          escape = !escape;
        }
        code = css.charCodeAt(next + 1);
        if (escape && code !== SLASH && code !== SPACE && code !== NEWLINE && code !== TAB && code !== CR && code !== FEED) {
          next += 1;
          if (RE_HEX_ESCAPE.test(css.charAt(next))) {
            while (RE_HEX_ESCAPE.test(css.charAt(next + 1))) {
              next += 1;
            }
            if (css.charCodeAt(next + 1) === SPACE) {
              next += 1;
            }
          }
        }

        currentToken = ['word', css.slice(pos, next + 1), line, pos - offset, line, next - offset];

        pos = next;
        break;

      default:
        // SCSS PATCH {
        n = css.charCodeAt(pos + 1);

        if (code === HASH && n === OPEN_CURLY) {
          next = pos;
          interpolation();

          content = css.slice(pos, next + 1);
          lines = content.split('\n');
          last = lines.length - 1;

          if (last > 0) {
            nextLine = line + last;
            nextOffset = next - lines[last].length;
          } else {
            nextLine = line;
            nextOffset = offset;
          }

          currentToken = ['word', content, line, pos - offset, nextLine, next - nextOffset];

          offset = nextOffset;
          line = nextLine;
          pos = next;
        } else if (code === SLASH && n === ASTERISK) {
          // } SCSS PATCH
          next = css.indexOf('*/', pos + 2) + 1;
          if (next === 0) {
            if (ignore) {
              next = css.length;
            } else {
              unclosed('comment');
            }
          }

          content = css.slice(pos, next + 1);
          lines = content.split('\n');
          last = lines.length - 1;

          if (last > 0) {
            nextLine = line + last;
            nextOffset = next - lines[last].length;
          } else {
            nextLine = line;
            nextOffset = offset;
          }

          currentToken = ['comment', content, line, pos - offset, nextLine, next - nextOffset];

          offset = nextOffset;
          line = nextLine;
          pos = next;

          // SCSS PATCH {
        } else if (code === SLASH && n === SLASH) {
          RE_NEW_LINE.lastIndex = pos + 1;
          RE_NEW_LINE.test(css);
          if (RE_NEW_LINE.lastIndex === 0) {
            next = css.length - 1;
          } else {
            next = RE_NEW_LINE.lastIndex - 2;
          }

          content = css.slice(pos, next + 1);

          currentToken = ['comment', content, line, pos - offset, line, next - offset, 'inline'];

          pos = next;
          // } SCSS PATCH
        } else {
          RE_WORD_END.lastIndex = pos + 1;
          RE_WORD_END.test(css);
          if (RE_WORD_END.lastIndex === 0) {
            next = css.length - 1;
          } else {
            next = RE_WORD_END.lastIndex - 2;
          }

          currentToken = ['word', css.slice(pos, next + 1), line, pos - offset, line, next - offset];

          buffer.push(currentToken);

          pos = next;
        }

        break;
    }

    pos++;
    return currentToken;
  }

  function back(token) {
    returned.push(token);
  }

  return {
    back: back,
    nextToken: nextToken,
    endOfFile: endOfFile
  };
};
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
