'use strict';

Object.defineProperty(exports, '__esModule', {
    value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; desc = parent = getter = undefined; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _node = require('./node');

var _node2 = _interopRequireDefault(_node);

var Container = (function (_Node) {
    _inherits(Container, _Node);

    function Container(opts) {
        _classCallCheck(this, Container);

        _get(Object.getPrototypeOf(Container.prototype), 'constructor', this).call(this, opts);
        if (!this.nodes) {
            this.nodes = [];
        }
    }

    _createClass(Container, [{
        key: 'append',
        value: function append(selector) {
            selector.parent = this;
            this.nodes.push(selector);
            return this;
        }
    }, {
        key: 'prepend',
        value: function prepend(selector) {
            selector.parent = this;
            this.nodes.unshift(selector);
            return this;
        }
    }, {
        key: 'at',
        value: function at(index) {
            return this.nodes[index];
        }
    }, {
        key: 'index',
        value: function index(child) {
            if (typeof child === 'number') {
                return child;
            }
            return this.nodes.indexOf(child);
        }
    }, {
        key: 'remove',
        value: function remove(child) {
            child = this.index(child);
            this.at(child).parent = undefined;
            this.nodes.splice(child, 1);

            var index = undefined;
            for (var id in this.indexes) {
                index = this.indexes[id];
                if (index >= child) {
                    this.indexes[id] = index - 1;
                }
            }

            return this;
        }
    }, {
        key: 'removeAll',
        value: function removeAll() {
            var _iteratorNormalCompletion = true;
            var _didIteratorError = false;
            var _iteratorError = undefined;

            try {
                for (var _iterator = this.nodes[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                    var node = _step.value;
                    node.parent = undefined;
                }
            } catch (err) {
                _didIteratorError = true;
                _iteratorError = err;
            } finally {
                try {
                    if (!_iteratorNormalCompletion && _iterator['return']) {
                        _iterator['return']();
                    }
                } finally {
                    if (_didIteratorError) {
                        throw _iteratorError;
                    }
                }
            }

            this.nodes = [];
            return this;
        }
    }, {
        key: 'empty',
        value: function empty() {
            return this.removeAll();
        }
    }, {
        key: 'insertAfter',
        value: function insertAfter(oldNode, newNode) {
            var oldIndex = this.index(oldNode);
            this.nodes.splice(oldIndex + 1, 0, newNode);

            var index = undefined;
            for (var id in this.indexes) {
                index = this.indexes[id];
                if (oldIndex <= index) {
                    this.indexes[id] = index + this.nodes.length;
                }
            }

            return this;
        }
    }, {
        key: 'insertBefore',
        value: function insertBefore(oldNode, newNode) {
            var oldIndex = this.index(oldNode);
            this.nodes.splice(oldIndex, 0, newNode);

            var index = undefined;
            for (var id in this.indexes) {
                index = this.indexes[id];
                if (oldIndex <= index) {
                    this.indexes[id] = index + this.nodes.length;
                }
            }

            return this;
        }
    }, {
        key: 'each',
        value: function each(callback) {
            if (!this.lastEach) {
                this.lastEach = 0;
            }
            if (!this.indexes) {
                this.indexes = {};
            }

            this.lastEach++;
            var id = this.lastEach;
            this.indexes[id] = 0;

            if (!this.length) return undefined;

            var index = undefined,
                result = undefined;
            while (this.indexes[id] < this.length) {
                index = this.indexes[id];
                result = callback(this.at(index), index);
                if (result === false) {
                    break;
                }

                this.indexes[id] += 1;
            }

            delete this.indexes[id];

            if (result === false) {
                return false;
            }
        }
    }, {
        key: 'eachInside',
        value: function eachInside(callback) {
            return this.each(function (node, i) {
                var result = callback(node, i);

                if (result !== false && node.length) {
                    result = node.eachInside(callback);
                }

                if (result === false) {
                    return false;
                }
            });
        }
    }, {
        key: 'eachAttribute',
        value: function eachAttribute(callback) {
            var _this = this;

            return this.eachInside(function (selector) {
                if (selector.type === 'attribute') {
                    return callback.call(_this, selector);
                }
            });
        }
    }, {
        key: 'eachClass',
        value: function eachClass(callback) {
            var _this2 = this;

            return this.eachInside(function (selector) {
                if (selector.type === 'class') {
                    return callback.call(_this2, selector);
                }
            });
        }
    }, {
        key: 'eachCombinator',
        value: function eachCombinator(callback) {
            var _this3 = this;

            return this.eachInside(function (selector) {
                if (selector.type === 'combinator') {
                    return callback.call(_this3, selector);
                }
            });
        }
    }, {
        key: 'eachComment',
        value: function eachComment(callback) {
            var _this4 = this;

            return this.eachInside(function (selector) {
                if (selector.type === 'comment') {
                    return callback.call(_this4, selector);
                }
            });
        }
    }, {
        key: 'eachId',
        value: function eachId(callback) {
            var _this5 = this;

            return this.eachInside(function (selector) {
                if (selector.type === 'id') {
                    return callback.call(_this5, selector);
                }
            });
        }
    }, {
        key: 'eachPseudo',
        value: function eachPseudo(callback) {
            var _this6 = this;

            return this.eachInside(function (selector) {
                if (selector.type === 'pseudo') {
                    return callback.call(_this6, selector);
                }
            });
        }
    }, {
        key: 'eachTag',
        value: function eachTag(callback) {
            var _this7 = this;

            return this.eachInside(function (selector) {
                if (selector.type === 'tag') {
                    return callback.call(_this7, selector);
                }
            });
        }
    }, {
        key: 'eachUniversal',
        value: function eachUniversal(callback) {
            var _this8 = this;

            return this.eachInside(function (selector) {
                if (selector.type === 'universal') {
                    return callback.call(_this8, selector);
                }
            });
        }
    }, {
        key: 'split',
        value: function split(callback) {
            var _this9 = this;

            var current = [];
            return this.reduce(function (memo, node, index) {
                var split = callback.call(_this9, node);
                current.push(node);
                if (split) {
                    memo.push(current);
                    current = [];
                } else if (index === _this9.length - 1) {
                    memo.push(current);
                }
                return memo;
            }, []);
        }
    }, {
        key: 'map',
        value: function map(callback) {
            return this.nodes.map(callback);
        }
    }, {
        key: 'reduce',
        value: function reduce(callback, memo) {
            return this.nodes.reduce(callback, memo);
        }
    }, {
        key: 'every',
        value: function every(callback) {
            return this.nodes.every(callback);
        }
    }, {
        key: 'some',
        value: function some(callback) {
            return this.nodes.some(callback);
        }
    }, {
        key: 'filter',
        value: function filter(callback) {
            return this.nodes.filter(callback);
        }
    }, {
        key: 'sort',
        value: function sort(callback) {
            return this.nodes.sort(callback);
        }
    }, {
        key: 'toString',
        value: function toString() {
            return this.map(String).join('');
        }
    }, {
        key: 'first',
        get: function get() {
            return this.at(0);
        }
    }, {
        key: 'last',
        get: function get() {
            return this.at(this.length - 1);
        }
    }, {
        key: 'length',
        get: function get() {
            return this.nodes.length;
        }
    }]);

    return Container;
})(_node2['default']);

exports['default'] = Container;
module.exports = exports['default'];