'use strict';

var _ava = require('ava');

var _ava2 = _interopRequireDefault(_ava);

var _postcss = require('postcss');

var _postcss2 = _interopRequireDefault(_postcss);

var _ = require('..');

var _2 = _interopRequireDefault(_);

var _package = require('../../package.json');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var tests = [{
    message: 'should deduplicate selectors',
    fixture: 'h1,h1,h1,h1{color:red}',
    expected: 'h1{color:red}'
}, {
    message: 'should natural sort selectors',
    fixture: 'h1,h10,H2,h7{color:red}',
    expected: 'h1,H2,h7,h10{color:red}'
}];

tests.forEach(function (_ref) {
    var message = _ref.message,
        fixture = _ref.fixture,
        expected = _ref.expected,
        _ref$options = _ref.options,
        options = _ref$options === undefined ? {} : _ref$options;

    (0, _ava2.default)(message, function (t) {
        return (0, _postcss2.default)([(0, _2.default)(options)]).process(fixture).then(function (result) {
            t.deepEqual(result.css, expected);
        });
    });
});

(0, _ava2.default)('should use the postcss plugin api', function (t) {
    t.truthy((0, _2.default)().postcssVersion, 'should be able to access version');
    t.deepEqual((0, _2.default)().postcssPlugin, _package.name, 'should be able to access name');
});