---
layout: post

title: PouchDB 3.0.3

author: Nolan Lawson

---

Another week, another PouchDB patch release!

This week we present [PouchDB 3.0.3](https://github.com/pouchdb/pouchdb/releases/tag/3.0.3), which fixes some ornery issues with replication that were introduced by recent performance optimizations ([#2685](https://github.com/pouchdb/pouchdb/issues/2685)).

In fact, those performance optimizations have been rolled back. The current implementation appears to be the fastest possible given CouchDB's replication protocol, and the clever tricks introduced in 3.0.0 actually pushed conflicts into CouchDB's revision history, which is bad news for apps that rely on custom conflict resolution. (If you just use the default "pick a random winner," you probably didn't notice anything.)

And although "custom conflict resolution" may only describe a minority of apps, we felt it's better to be correct 100% of the time than to be speedy.

### Dealing with slow replication

If you experience slow replications after upgrading to 3.0.3, here are some suggestions:

1. Avoid CORS if you can, because it uses twice as many HTTP requests. Some tips for doing this:
    * If you are using IrisCouch, you can [create a couchapp](https://github.com/couchapp/couchapp) (i.e. let CouchDB serve your HTML/CSS/JS).
    * If you are running your own CouchDB, you can set up a reverse proxy with Apache or Nginx that allows you to serve your app and CouchDB from the same domain. Or create a couchapp.
2. Try using the "every doc is a delta" pattern, as described in [this blog post](http://atypical.net/archive/2014/04/17/understanding-race-induced-conflicts-in-bigcouch) and exemplified in [the delta-pouch plugin](https://github.com/redgeoff/delta-pouch). Your replications will be much faster, because PouchDB is able to use an optimization for generation-1 documents, and in this setup, every document is a generation-1 document.
3. Otherwise, just minimize the number of documents you create. Or minimize the number of documents you sync to the client. Views can be helpful with this, although the low performance of the `query()` API relative to the `allDocs()` API should be balanced with that.

### Other fixes in 3.0.3

* Auto-compaction is no longer experimental! It's fully supported. ([#2655](https://github.com/pouchdb/pouchdb/issues/2655))
* `'change'` listeners aren't called after replication is canceled. ([#2478](https://github.com/pouchdb/pouchdb/issues/2478))
* Bower package is smaller. ([#2659](https://github.com/pouchdb/pouchdb/issues/2659))