---
layout: post

title: PouchDB 3.0.6&#58; Safari Madness

author: Nolan Lawson

---

As Cupertino fans snuggle up to their bigger and better iDevices, PouchDB users will appreciate [PouchDB 3.0.6](https://github.com/pouchdb/pouchdb/releases/tag/3.0.6). This release contains a workaround for [some unforeseen hiccups](https://github.com/pouchdb/pouchdb/issues/2533) in Apple's new implementation of IndexedDB for Safari 7.1 and iOS 8.

{% include img.html src="apple-indexeddb.png" alt="Apple introduces IndexedDB support" %}

All joking aside, we are happy to welcome Apple to the IndexedDB party (better late than never!), and [we are working with the WebKit devs](https://bugs.webkit.org/show_bug.cgi?id=136888) to resolve the issue. In the meantime, PouchDB 3.0.6 provides a workaround where we fall back to Web SQL on Apple browsers.

Other fixes in this release:
------

* `db.compact()` performance improvements ([#2623](https://github.com/pouchdb/pouchdb/pull/2623))
* Ensure attachments work after Chrome 38 upgrade ([#2773](https://github.com/pouchdb/pouchdb/issues/2773))
* Invalid/unauthorized documents no longer halt replication ([#2268](https://github.com/pouchdb/pouchdb/issues/2268))
* Filtering no longer halts replication ([#2689](https://github.com/pouchdb/pouchdb/issues/2689))
* Update lie dependency to [2.8.0](https://github.com/calvinmetcalf/lie/releases/tag/2.8.0)

New features in this release:
--------

* `db.info()` shows whether `auto_compaction` is set ([#2744](https://github.com/pouchdb/pouchdb/issues/2744))

An aside on browser compatibility
--------

From the get-go, PouchDB's goal was to work seamlessly on every browser, with one API to rule them all. I like to call it the "jQuery for databases" approach.

In practice, this is pretty tough to achieve. I poke fun at Apple, but there are also bugs in IE's implementation of IndexedDB ([here](https://connect.microsoft.com/IE/feedbackdetail/view/866495) [are](https://connect.microsoft.com/IE/feedbackdetail/view/866489) [three](https://connect.microsoft.com/IE/feedbackdetail/view/866474)), Firefox's implementation ([this one](https://bugzilla.mozilla.org/show_bug.cgi?id=701634)), and Chrome's implementation ([these](https://code.google.com/p/chromium/issues/detail?id=408120) [two](https://code.google.com/p/chromium/issues/detail?id=108012)). Additionally, some Android devices ship with [an outdated version of IndexedDB](https://github.com/pouchdb/pouchdb/issues/1207) in the notoriously non-evergreen "stock" browser.

And that's just IndexedDB! Don't even get me started on Web SQL. Here's just a small taste:

 * [UTF-8 vs UTF-16 encoding on Chrome vs Safari](https://github.com/pouchdb/pouchdb/pull/1733#issuecomment-38723096)
 * [Null character causes string truncation](https://github.com/pouchdb/pouchdb/pull/1731#issuecomment-38622342)
 * [Cannot use Promises, or the transaction ends early](https://github.com/pouchdb/pouchdb/pull/2536#issuecomment-50435837)

We've written workarounds for all these issues in PouchDB, so that you, dear developer, need never worry your pretty head about them.

So this new Safari/iOS bug doesn't phase us. If we were keeping score, this would probably be workaround #72 by now. We're used to it.

However, that doesn't mean we should get complacent. All of these bugs are opportunities to hold browser vendors' feet to the fire, so that eventually the hacks and workarounds are no longer necessary. You don't want to have to download 10KB of workarounds just to use the native HTML5 APIs. And nobody wants to see HTML5 sink under the weight of browser quirks and non-compliance.

We look forward to removing most of these workarounds from PouchDB (including Web SQL support!), so making some noise in the Microsoft/Mozilla/Chromium/WebKit bug trackers is a great way to get there. Submitting test cases and pull requests is even better.

Thanks to [Elmer Bulthuis](https://github.com/elmerbulthuis) and [Kyaw Tun](https://github.com/yathit) for finding reproducible test cases to submit to the WebKit devs. Let's move the web forward!

And as always, thanks to [our new and existing contributors](https://github.com/pouchdb/pouchdb/graphs/contributors).
