---
layout: post

title: PouchDB 3.1.0&#58; A Guide to Recognizing Your Marsupials (The PouchDB Guide)

author: Dale Harvey

---

Today marks the dawn of a new PouchDB release, [3.1.0](https://github.com/pouchdb/pouchdb/releases/tag/3.1.0) is released today with a whole bunch of goodness. Here are some of the highlights:

{% include alert/start.html variant="warning"%}
This release includes a migration. Your existing database will be updated automatically, but you cannot downgrade to a previous version of PouchDB once you've upgraded.
{% include alert/end.html %}

### PouchDB Guides ([#2766](https://github.com/pouchdb/pouchdb/issues/2766))

Nolan Lawson and Nick Colley worked together to produce some excellent guides to PouchDB which you can see @ [http://pouchdb.com/guides/](http://pouchdb.com/guides/). They cover a lot of the issues surrounding building PouchDB applications including conflicts and promises vs callbacks. As a bonus the guides as well as the rest of the website [now work offline](https://github.com/pouchdb/pouchdb/issues/2957).

### Compaction removes orphaned attachments ([#2818](https://github.com/pouchdb/pouchdb/issues/2818))

If you have been using attachments in your PouchDB databases, you may have noticed that it was a bit bigger round the waist than it should have been. We now work harder to ensure there isnt any extra things lying around the database taking up space that you no longer need. This change came along with a lot of compaction and attachment related fixes: [#2890](https://github.com/pouchdb/pouchdb/issues/2890), [#2905](https://github.com/pouchdb/pouchdb/issues/2905), [#2951](https://github.com/pouchdb/pouchdb/issues/2951)

### Test against CouchDB master ([#2850](https://github.com/pouchdb/pouchdb/issues/2850))

There is a big change brewing in CouchDB world, [https://issues.apache.org/jira/browse/COUCHDB-1843](https://issues.apache.org/jira/browse/COUCHDB-1843) is in progress to merge the clustered 'BigCouch' merge from Cloudant into CouchDB master. This will represent a big change towards CouchDB however there is no need to worry, we now run all of our tests against the current master CouchDB (and they are all green!) so when the big CouchDB 2.0 release comes, your PouchDB applications will continue to work as well as before.

### In related news

We keep a list of [plugins and related external projects](http://pouchdb.com/external.html) to PouchDB, here are a few new ones we added during this month:

 * PouchDB [Dump](https://github.com/nolanlawson/pouchdb-dump-cli) and [Load](https://github.com/nolanlawson/pouchdb-load) are designed to help you load data into your newly started PouchDB app faster than replication will do currently.
 * If you want to use PouchDB with Angular, you are in luck, there are now 4! adapters to help you integrate them: [angular-pouchdb](https://github.com/wspringer/angular-pouchdb), [Factoryng](https://github.com/redgeoff/factoryng), [ngPouch](https://github.com/jrhicks/ngPouch), [ng-pouchdb](https://github.com/danielzen/ng-pouchdb).
 * Ember users arent left in the wild: [ember-pouchdb](https://github.com/taras/ember-pouchdb) should get you going with PouchDB and Ember.
 * If you are using Blobs with PouchDB, you probably want to take a look at [blob-util](https://github.com/nolanlawson/blob-util).

### Bug fixes Galore

Some of the other important fixes include:

 * ([#2951](https://github.com/pouchdb/pouchdb/issues/2951)) - fix concurrency in leveldb.js
 * ([#2935](https://github.com/pouchdb/pouchdb/issues/2935)) - new_edits=false works regardless of order
 * ([#2867](https://github.com/pouchdb/pouchdb/issues/2867)) - do not stack notify change listeners
 * ([#2779](https://github.com/pouchdb/pouchdb/issues/2779)) - fix undeletion with wrong rev
 * ([#2794](https://github.com/pouchdb/pouchdb/issues/2794)) - explain normal 404s in console.info
 * ([#2841](https://github.com/pouchdb/pouchdb/issues/2841)) - respect options when making dependent dbs
 * ([#2844](https://github.com/pouchdb/pouchdb/issues/2844)) - Encode attachment names
 * ([#2807](https://github.com/pouchdb/pouchdb/issues/2807)) - auto_compaction properly trims tree
 * ([#2708](https://github.com/pouchdb/pouchdb/issues/2708)) - implement attachment stub length

Please [file issues](https://github.com/pouchdb/pouchdb/issues) or [tell us what you think](https://github.com/pouchdb/pouchdb/blob/master/CONTRIBUTING.md#get-in-touch). We would also like to give a huge thanks to our [new and existing contributors](https://github.com/pouchdb/pouchdb/graphs/contributors).
