---
layout: 2ColLeft
title: Who's using PouchDB?
sidebar: nav.html
---

A list of known products and services that are using PouchDB. [Fork this page](https://github.com/pouchdb/pouchdb/blob/master/docs/users.md) to add your own!

## Cozy Cloud

{% include img.html width=125 src="cozy.png" alt="Cozy Cloud" %}

[Cozy](https://cozy.io/en/) is a personal cloud that you can host, customize, and fully control. It syncs contacts, calendars, and files between your personal devices and server. Under the hood, it leverages CouchDB and PouchDB.

## eHealth Africa

{% include img.html width=200 src="ehealth_africa.png" alt="eHealth Africa" %}

[eHealth Africa](http://ehealthafrica.org/) is an American-Nigerian NGO specialising in the development and deployment of tech for health. To tackle the Ebola outbreak, they built [software to manage applications](https://github.com/eHealthAfrica), which is based on CouchDB and PouchDB.

## Cloudwall

{% include img.html width=200 src="cloudwall.png" alt="Cloudwall" %}

[Cloudwall](http://cloudwall.me/) is an operating system for noBackend webapps, based on CouchDB and PouchDB.

## MBTA Alerts

{% include img.html width=100 src="mbta_alerts.jpeg" alt="MBTA Alerts" %}

[MBTA Alerts](https://twitter.com/MBTA_Alerts) is a Twitter bot that thousands of Bostonians depend upon to be notified of delays in the MBTA transit system. Uses Node.js, PouchDB, and CouchDB.

## Squarespace Blog

{% include img.html width=100 src="squarespace_blog.png" alt="Squarespace Blog" %}

Squarespace Blog is an [Android](https://play.google.com/store/apps/details?id=com.squarespace.android.blog) and [iOS app](https://itunes.apple.com/us/app/squarespace-blog/id715084234) that gives you the tools you need to write and edit posts on multiple Squarespace websites. It uses PouchDB attachments inside a WebView for fast offline images.

## Thali project

[Thali](http://thaliproject.org/) is a Microsoft-sponsored open-source platform for creating apps that exploit the power of personal devices and put people in control of their data. It uses Cordova, PouchDB, OpenSSL, and Tor.

## BikeCommute

[BikeCommute](https://github.com/autonome/bikecommute) is a FirefoxOS app that registers an NFC tag to track bike commuters in the Mozilla Portland office. Built using Famo.us, PouchDB, and CouchDB. See [a video of it in action](https://youtu.be/3BVZYcQ-TYA) or [read about it on Mozilla Hacks](https://hacks.mozilla.org/2014/11/nfc-in-firefox-os/).

## NPM Browser

[NPM Browser](http://www.npm-browser.com/#/) is a fully offline cache of NPM packages, which runs in your browser, using Angular.js, PouchDB, and the pouchdb-load plugin.

## Local NPM

[Local NPM](https://github.com/nolanlawson/local-npm) allows you to easily set up a local NPM server that caches data from the real NPM and updates in realtime. The goal is to cut down network request time by moving data closer to the client. Built using Node.js, LevelDB, and PouchDB.

