'use strict';

// IndexedDB requires a versioned database structure, so we use the
// version here to manage migrations.
exports.ADAPTER_VERSION = 5;

// The object stores created for each database
// DOC_STORE stores the document meta data, its revision history and state
// Keyed by document id
exports. DOC_STORE = 'document-store';
// BY_SEQ_STORE stores a particular version of a document, keyed by its
// sequence id
exports.BY_SEQ_STORE = 'by-sequence';
// Where we store attachments
exports.ATTACH_STORE = 'attach-store';
// Where we store many-to-many relations
// between attachment digests and seqs
exports.ATTACH_AND_SEQ_STORE = 'attach-seq-store';

// Where we store database-wide meta data in a single record
// keyed by id: META_STORE
exports.META_STORE = 'meta-store';
// Where we store local documents
exports.LOCAL_STORE = 'local-store';
// Where we detect blob support
exports.DETECT_BLOB_SUPPORT_STORE = 'detect-blob-support';