import { hasLeadingComments, hasTrailingComments } from "./comments-utils.js";
export function handleCommentsBinaryExpression(ctx) {
    moveOperatorLeadingCommentsToNextExpression(ctx);
    moveExpressionTrailingCommentsToNextOperator(ctx);
}
export function handleCommentsParameters(lBrace, parameters, rBrace) {
    var _a, _b, _c;
    const lBraceTrailingComments = lBrace.trailingComments;
    const firstParameter = parameters.at(0);
    if (lBraceTrailingComments && firstParameter) {
        delete lBrace.trailingComments;
        firstParameter.leadingComments = [
            ...lBraceTrailingComments,
            ...((_a = firstParameter.leadingComments) !== null && _a !== void 0 ? _a : [])
        ];
    }
    const lastParameter = parameters.at(-1);
    const rBraceLeadingComments = rBrace.leadingComments;
    if (rBraceLeadingComments) {
        delete rBrace.leadingComments;
        if (lastParameter) {
            lastParameter.trailingComments = [
                ...((_b = lastParameter.trailingComments) !== null && _b !== void 0 ? _b : []),
                ...rBraceLeadingComments
            ];
        }
        else {
            lBrace.trailingComments = [
                ...((_c = lBrace.trailingComments) !== null && _c !== void 0 ? _c : []),
                ...rBraceLeadingComments
            ];
        }
    }
}
function moveOperatorLeadingCommentsToNextExpression(ctx) {
    var _a;
    let unaryExpressionIndex = 1;
    (_a = ctx.BinaryOperator) === null || _a === void 0 ? void 0 : _a.forEach(binaryOperator => {
        if (hasLeadingComments(binaryOperator)) {
            while (ctx.unaryExpression[unaryExpressionIndex].location.startOffset <
                binaryOperator.endOffset) {
                unaryExpressionIndex++;
            }
            // Adapt the position of the operator and its leading comments
            const shiftUp = binaryOperator.leadingComments[0].startLine -
                1 -
                binaryOperator.startLine;
            if (binaryOperator.startLine !==
                ctx.unaryExpression[unaryExpressionIndex].location.startLine) {
                binaryOperator.leadingComments.forEach(comment => {
                    comment.startLine += 1;
                    comment.endLine += 1;
                });
            }
            binaryOperator.startLine += shiftUp;
            binaryOperator.endLine += shiftUp;
            // Move binaryOperator's leading comments to the following
            // unaryExpression
            ctx.unaryExpression[unaryExpressionIndex].leadingComments =
                ctx.unaryExpression[unaryExpressionIndex].leadingComments || [];
            ctx.unaryExpression[unaryExpressionIndex].leadingComments.unshift(...binaryOperator.leadingComments);
            delete binaryOperator.leadingComments;
        }
    });
}
function moveExpressionTrailingCommentsToNextOperator(ctx) {
    const binaryOperators = ctx.BinaryOperator;
    let binaryOperatorIndex = 1;
    if (binaryOperators === null || binaryOperators === void 0 ? void 0 : binaryOperators.length) {
        ctx.unaryExpression.forEach(unaryExpression => {
            var _a;
            if (hasTrailingComments(unaryExpression)) {
                while (binaryOperatorIndex < binaryOperators.length &&
                    unaryExpression.location.endOffset &&
                    binaryOperators[binaryOperatorIndex].startOffset <
                        unaryExpression.location.endOffset) {
                    binaryOperatorIndex++;
                }
                const binaryOperator = binaryOperators[binaryOperatorIndex];
                // Adapt the position of the expression and its trailing comments
                const shiftUp = unaryExpression.trailingComments[0].startLine -
                    1 -
                    unaryExpression.location.startLine;
                if (unaryExpression.location.startLine !== binaryOperator.startLine) {
                    unaryExpression.trailingComments.forEach(comment => {
                        comment.startLine += 1;
                        comment.endLine += 1;
                    });
                }
                unaryExpression.location.startLine += shiftUp;
                if (unaryExpression.location.endLine !== undefined) {
                    unaryExpression.location.endLine += shiftUp;
                }
                // Move unaryExpression's trailing comments to the following
                // binaryOperator
                binaryOperator.trailingComments = (_a = binaryOperator.trailingComments) !== null && _a !== void 0 ? _a : [];
                binaryOperator.trailingComments.unshift(...unaryExpression.trailingComments);
                delete unaryExpression.trailingComments;
            }
        });
    }
}
