import { printTokenWithComments } from "./comments/format-comments.js";
import { join } from "./prettier-builder.js";
import { BaseCstPrettierPrinter } from "../base-cst-printer.js";
import { builders } from "prettier/doc";
const { hardline } = builders;
export class LexicalStructurePrettierVisitor extends BaseCstPrettierPrinter {
    literal(ctx) {
        if (ctx.TextBlock) {
            const lines = ctx.TextBlock[0].image.split("\n");
            const open = lines.shift();
            const baseIndent = Math.min(...lines.map(line => line.search(/\S/)).filter(indent => indent >= 0));
            return join(hardline, [
                open,
                ...lines.map(line => line.slice(baseIndent))
            ]);
        }
        if (ctx.CharLiteral || ctx.StringLiteral || ctx.Null) {
            return printTokenWithComments(this.getSingle(ctx));
        }
        return this.visitSingle(ctx);
    }
    integerLiteral(ctx) {
        return printTokenWithComments(this.getSingle(ctx));
    }
    floatingPointLiteral(ctx) {
        return printTokenWithComments(this.getSingle(ctx));
    }
    booleanLiteral(ctx) {
        return printTokenWithComments(this.getSingle(ctx));
    }
}
