import { buildFqn } from "./printer-utils.js";
import { printTokenWithComments } from "./comments/format-comments.js";
import { BaseCstPrettierPrinter } from "../base-cst-printer.js";
export class NamesPrettierVisitor extends BaseCstPrettierPrinter {
    typeIdentifier(ctx) {
        return printTokenWithComments(ctx.Identifier[0]);
    }
    moduleName(ctx) {
        return buildFqn(ctx.Identifier, ctx.Dot);
    }
    packageName(ctx) {
        return buildFqn(ctx.Identifier, ctx.Dot);
    }
    typeName(ctx) {
        return buildFqn(ctx.Identifier, ctx.Dot);
    }
    expressionName(ctx) {
        return buildFqn(ctx.Identifier, ctx.Dot);
    }
    methodName(ctx) {
        return printTokenWithComments(ctx.Identifier[0]);
    }
    packageOrTypeName(ctx) {
        return buildFqn(ctx.Identifier, ctx.Dot);
    }
    ambiguousName(ctx) {
        return buildFqn(ctx.Identifier, ctx.Dot);
    }
}
