import { builders } from "prettier/doc";
import * as formatComments from "./comments/format-comments.js";
const processComments = formatComments.processComments;
/*
 * ------------------------------------------------------------------
 * Wraps the Prettier builder functions to print tokens with comments
 * ------------------------------------------------------------------
 */
export function concat(docs) {
    const concatenation = processComments(docs);
    if (!Array.isArray(docs)) {
        return "";
    }
    return concatenation;
}
export function join(sep, docs) {
    return builders.join(processComments(sep), processComments(docs));
}
export function group(docs, opts) {
    const group = builders.group(processComments(docs), opts);
    return group.contents === undefined ? "" : group;
}
export function fill(docs) {
    return builders.fill(processComments(docs));
}
export function indent(doc) {
    const processedDoc = processComments(doc);
    if (processedDoc.length === 0) {
        return "";
    }
    return builders.indent(processedDoc);
}
export function dedent(doc) {
    const processedDoc = processComments(doc);
    if (processedDoc.length === 0) {
        return "";
    }
    return builders.dedent(processComments(doc));
}
export function ifBreak(breakContents, flatContents) {
    return builders.ifBreak(processComments(breakContents), processComments(flatContents));
}
export function indentIfBreak(contents, opts) {
    return builders.indentIfBreak(processComments(contents), opts);
}
