import { builders } from "prettier/doc";
import { handleCommentsParameters } from "../printers/comments/handle-comments.js";
import { indent } from "../printers/prettier-builder.js";
import { rejectAndConcat } from "../printers/printer-utils.js";
const { lineSuffixBoundary, softline } = builders;
export default function printArgumentListWithBraces(argumentListNodes, rBrace, lBrace) {
    var _a, _b, _c;
    const argumentListNode = argumentListNodes === null || argumentListNodes === void 0 ? void 0 : argumentListNodes[0];
    const expressions = (_a = argumentListNode === null || argumentListNode === void 0 ? void 0 : argumentListNode.children.expression) !== null && _a !== void 0 ? _a : [];
    if (argumentListNode) {
        const { leadingComments, trailingComments } = argumentListNode;
        delete argumentListNode.leadingComments;
        delete argumentListNode.trailingComments;
        if (leadingComments) {
            const firstExpression = expressions[0];
            firstExpression.leadingComments = [
                ...leadingComments,
                ...((_b = firstExpression.leadingComments) !== null && _b !== void 0 ? _b : [])
            ];
        }
        if (trailingComments) {
            const lastExpression = expressions.at(-1);
            lastExpression.trailingComments = [
                ...((_c = lastExpression.trailingComments) !== null && _c !== void 0 ? _c : []),
                ...trailingComments
            ];
        }
    }
    handleCommentsParameters(lBrace, expressions, rBrace);
    const argumentList = this.visit(argumentListNodes);
    const contents = argumentList
        ? [argumentList]
        : lBrace.trailingComments
            ? [softline, lineSuffixBoundary]
            : [];
    return rejectAndConcat([indent(lBrace), ...contents, rBrace]);
}
