import { EventEmitter } from '@angular/core';
export interface SortMeta {
    field: string;
    order: number;
}
export interface LazyLoadEvent {
    first?: number;
    rows?: number;
    sortField?: string;
    sortOrder?: number;
    multiSortMeta?: SortMeta[];
    filters?: {
        [s: string]: FilterMetadata;
    };
}
export interface FilterMetadata {
    value?: string;
    matchMode?: string;
}
export interface MenuItem {
    label?: string;
    icon?: string;
    command?: (event?: any) => void;
    url?: string;
    routerLink?: any;
    eventEmitter?: EventEmitter<any>;
    items?: MenuItem[];
    expanded?: boolean;
}
export interface Message {
    severity?: string;
    summary?: string;
    detail?: string;
}
export interface SelectItem {
    label: string;
    value: any;
}
export interface TreeNode {
    label?: string;
    data?: any;
    icon?: any;
    expandedIcon?: any;
    collapsedIcon?: any;
    children?: TreeNode[];
    leaf?: boolean;
}
