import { ElementRef, OnInit, AfterViewInit, AfterViewChecked, DoCheck, OnDestroy, Renderer, EventEmitter, TemplateRef, IterableDiffers } from '@angular/core';
import { SelectItem } from '../common/api';
import { DomHandler } from '../dom/domhandler';
import { ControlValueAccessor } from '@angular/forms';
export declare class Dropdown implements OnInit, AfterViewInit, AfterViewChecked, DoCheck, OnDestroy, ControlValueAccessor {
    protected el: ElementRef;
    protected domHandler: DomHandler;
    protected renderer: Renderer;
    options: SelectItem[];
    onChange: EventEmitter<any>;
    scrollHeight: string;
    filter: boolean;
    style: any;
    styleClass: string;
    disabled: boolean;
    autoWidth: boolean;
    required: boolean;
    editable: boolean;
    itemTemplate: TemplateRef<any>;
    constructor(el: ElementRef, domHandler: DomHandler, renderer: Renderer, differs: IterableDiffers);
    selectedOption: SelectItem;
    value: any;
    onModelChange: Function;
    onModelTouched: Function;
    optionsToDisplay: SelectItem[];
    hover: boolean;
    focus: boolean;
    differ: any;
    protected panelVisible: boolean;
    protected documentClickListener: any;
    protected optionsChanged: boolean;
    protected panel: any;
    protected container: any;
    protected itemsWrapper: any;
    protected initialized: boolean;
    protected selfClick: boolean;
    protected itemClick: boolean;
    protected hoveredItem: any;
    protected selectedOptionUpdated: boolean;
    ngOnInit(): void;
    ngDoCheck(): void;
    ngAfterViewInit(): void;
    label: string;
    onItemClick(event: any, option: any): void;
    selectItem(event: any, option: any): void;
    ngAfterViewChecked(): void;
    writeValue(value: any): void;
    updateSelectedOption(val: any): void;
    registerOnChange(fn: Function): void;
    registerOnTouched(fn: Function): void;
    updateDimensions(): void;
    onMouseenter(event: any): void;
    onMouseleave(event: any): void;
    onMouseclick(event: any, input: any): void;
    onInputClick(event: any): void;
    onInputChange(event: any): void;
    show(panel: any, container: any): void;
    hide(): void;
    onFocus(event: any): void;
    onBlur(event: any): void;
    onKeydown(event: any): void;
    findListItem(element: any): any;
    findOptionIndex(val: any, opts: SelectItem[]): number;
    findOption(val: any, opts: SelectItem[]): SelectItem;
    onFilter(event: any): void;
    ngOnDestroy(): void;
}
export declare class DropdownModule {
}
