import { ElementRef, AfterViewInit, AfterViewChecked, OnInit, DoCheck, EventEmitter, Renderer, IterableDiffers, QueryList, TemplateRef } from 'angular2/core';
import { Column } from '../column/column';
import { LazyLoadEvent } from '../api/lazyload';
import { SortMeta } from '../api/sortmeta';
import { DomHandler } from '../dom/domhandler';
export declare class DataTable implements AfterViewChecked, AfterViewInit, OnInit, DoCheck {
    private el;
    private domHandler;
    private renderer;
    value: any[];
    paginator: boolean;
    rows: number;
    totalRecords: number;
    pageLinks: number;
    rowsPerPageOptions: number[];
    responsive: boolean;
    stacked: boolean;
    selectionMode: string;
    selection: any;
    selectionChange: EventEmitter<any>;
    editable: boolean;
    onRowSelect: EventEmitter<any>;
    onRowUnselect: EventEmitter<any>;
    onRowDblclick: EventEmitter<any>;
    onContextMenuSelect: EventEmitter<any>;
    filterDelay: number;
    lazy: boolean;
    onLazyLoad: EventEmitter<any>;
    resizableColumns: boolean;
    columnResizeMode: string;
    onColResize: EventEmitter<any>;
    reorderableColumns: boolean;
    onColReorder: EventEmitter<any>;
    scrollable: boolean;
    scrollHeight: any;
    scrollWidth: any;
    headerRows: any;
    footerRows: any;
    style: string;
    styleClass: string;
    globalFilter: any;
    sortMode: string;
    sortField: string;
    sortOrder: number;
    multiSortMeta: SortMeta[];
    contextMenu: any;
    onEditInit: EventEmitter<any>;
    onEditComplete: EventEmitter<any>;
    onEdit: EventEmitter<any>;
    onEditCancel: EventEmitter<any>;
    onPage: EventEmitter<any>;
    onSort: EventEmitter<any>;
    onFilter: EventEmitter<any>;
    header: any;
    footer: any;
    expandableRows: boolean;
    rowExpansionTemplate: TemplateRef;
    private dataToRender;
    private first;
    private page;
    private filterTimeout;
    private filters;
    private filteredValue;
    private columns;
    private columnsUpdated;
    private sortByDefault;
    private sortColumn;
    private expandedRows;
    differ: any;
    globalFilterFunction: any;
    preventBlurOnEdit: boolean;
    constructor(el: ElementRef, domHandler: DomHandler, differs: IterableDiffers, cols: QueryList<Column>, renderer: Renderer);
    ngOnInit(): void;
    ngAfterViewChecked(): void;
    ngAfterViewInit(): void;
    ngDoCheck(): void;
    resolveFieldData(data: any, field: string): any;
    updatePaginator(): void;
    paginate(event: any): void;
    updateDataToRender(datasource: any): void;
    sort(event: any, column: Column): void;
    sortSingle(): void;
    sortMultiple(): void;
    multisortField(data1: any, data2: any, multiSortMeta: any, index: any): any;
    addSortMeta(meta: any): void;
    isSorted(column: Column): boolean;
    getSortOrder(column: Column): number;
    onRowClick(event: any, rowData: any): void;
    onRowRightClick(event: any, rowData: any): void;
    rowDblclick(event: any, rowData: any): void;
    isSingleSelectionMode(): boolean;
    isMultipleSelectionMode(): boolean;
    findIndexInSelection(rowData: any): number;
    isSelected(rowData: any): boolean;
    onFilterKeyup(value: any, field: any, matchMode: any): void;
    filter(): void;
    hasFilter(): boolean;
    onFilterInputClick(event: any): void;
    filterConstraints: {
        startsWith(value: any, filter: any): boolean;
        contains(value: any, filter: any): boolean;
        endsWith(value: any, filter: any): boolean;
    };
    switchCellToEditMode(element: any, column: Column, rowData: any): void;
    switchCellToViewMode(element: any, column: Column, rowData: any, complete: boolean): void;
    onCellEditorKeydown(event: any, column: Column, rowData: any): void;
    findCell(element: any): any;
    initResizableColumns(): void;
    initColumnReordering(): void;
    initScrolling(): void;
    hasFooter(): boolean;
    isEmpty(): boolean;
    createLazyLoadMetadata(): LazyLoadEvent;
    toggleRow(row: any): void;
    findExpandedRowIndex(row: any): number;
    isRowExpanded(row: any): boolean;
    reset(): void;
    ngOnDestroy(): void;
}
