import { ElementRef, OnInit, AfterViewInit, AfterViewChecked, DoCheck, OnDestroy, Renderer, EventEmitter, TemplateRef, IterableDiffers } from '@angular/core';
import { SelectItem } from '../common/api';
import { DomHandler } from '../dom/domhandler';
import { ControlValueAccessor } from '@angular/forms';
export declare const DROPDOWN_VALUE_ACCESSOR: any;
export declare class Dropdown implements OnInit, AfterViewInit, AfterViewChecked, DoCheck, OnDestroy, ControlValueAccessor {
    el: ElementRef;
    domHandler: DomHandler;
    renderer: Renderer;
    options: SelectItem[];
    scrollHeight: string;
    filter: boolean;
    style: any;
    styleClass: string;
    disabled: boolean;
    autoWidth: boolean;
    required: boolean;
    editable: boolean;
    appendTo: any;
    onChange: EventEmitter<any>;
    onFocus: EventEmitter<any>;
    onBlur: EventEmitter<any>;
    itemTemplate: TemplateRef<any>;
    containerViewChild: ElementRef;
    panelViewChild: ElementRef;
    itemsWrapperViewChild: ElementRef;
    constructor(el: ElementRef, domHandler: DomHandler, renderer: Renderer, differs: IterableDiffers);
    selectedOption: SelectItem;
    value: any;
    onModelChange: Function;
    onModelTouched: Function;
    optionsToDisplay: SelectItem[];
    hover: boolean;
    focus: boolean;
    differ: any;
    panelVisible: boolean;
    documentClickListener: any;
    optionsChanged: boolean;
    panel: HTMLDivElement;
    container: HTMLDivElement;
    itemsWrapper: HTMLDivElement;
    initialized: boolean;
    selfClick: boolean;
    itemClick: boolean;
    hoveredItem: any;
    selectedOptionUpdated: boolean;
    ngOnInit(): void;
    ngDoCheck(): void;
    ngAfterViewInit(): void;
    readonly label: string;
    onItemClick(event: any, option: any): void;
    selectItem(event: any, option: any): void;
    ngAfterViewChecked(): void;
    writeValue(value: any): void;
    updateSelectedOption(val: any): void;
    registerOnChange(fn: Function): void;
    registerOnTouched(fn: Function): void;
    setDisabledState(val: boolean): void;
    updateDimensions(): void;
    onMouseenter(event: any): void;
    onMouseleave(event: any): void;
    onMouseclick(event: any, input: any): void;
    onEditableInputClick(event: any): void;
    onEditableInputFocus(event: any): void;
    onEditableInputChange(event: any): void;
    show(panel: any, container: any): void;
    hide(): void;
    onInputFocus(event: any): void;
    onInputBlur(event: any): void;
    onKeydown(event: any): void;
    findListItem(element: any): any;
    findOptionIndex(val: any, opts: SelectItem[]): number;
    findOption(val: any, opts: SelectItem[]): SelectItem;
    onFilter(event: any): void;
    applyFocus(): void;
    ngOnDestroy(): void;
}
export declare class DropdownModule {
}
