!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("@angular/core"),require("@angular/common"),require("@angular/platform-browser"),require("primeng/button"),require("primeng/messages"),require("primeng/progressbar"),require("primeng/dom"),require("primeng/api"),require("primeng/ripple"),require("@angular/common/http")):"function"==typeof define&&define.amd?define("primeng/fileupload",["exports","@angular/core","@angular/common","@angular/platform-browser","primeng/button","primeng/messages","primeng/progressbar","primeng/dom","primeng/api","primeng/ripple","@angular/common/http"],t):t(((e="undefined"!=typeof globalThis?globalThis:e||self).primeng=e.primeng||{},e.primeng.fileupload={}),e.ng.core,e.ng.common,e.ng.platformBrowser,e.primeng.button,e.primeng.messages,e.primeng.progressbar,e.primeng.dom,e.primeng.api,e.primeng.ripple,e.ng.common.http)}(this,(function(e,t,i,n,o,s,l,a,p,r,u){"use strict";
/*! *****************************************************************************
    Copyright (c) Microsoft Corporation.

    Permission to use, copy, modify, and/or distribute this software for any
    purpose with or without fee is hereby granted.

    THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
    REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
    AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
    INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
    LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
    OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
    PERFORMANCE OF THIS SOFTWARE.
    ***************************************************************************** */Object.create;function d(e){var t="function"==typeof Symbol&&Symbol.iterator,i=t&&e[t],n=0;if(i)return i.call(e);if(e&&"number"==typeof e.length)return{next:function(){return e&&n>=e.length&&(e=void 0),{value:e&&e[n++],done:!e}}};throw new TypeError(t?"Object is not iterable.":"Symbol.iterator is not defined.")}Object.create;var c=function(){function e(e,i,n,o,s){this.el=e,this.sanitizer=i,this.zone=n,this.http=o,this.cd=s,this.method="POST",this.invalidFileSizeMessageSummary="{0}: Invalid file size, ",this.invalidFileSizeMessageDetail="maximum upload size is {0}.",this.invalidFileTypeMessageSummary="{0}: Invalid file type, ",this.invalidFileTypeMessageDetail="allowed file types: {0}.",this.invalidFileLimitMessageDetail="limit is {0} at most.",this.invalidFileLimitMessageSummary="Maximum number of files exceeded, ",this.previewWidth=50,this.chooseLabel="Choose",this.uploadLabel="Upload",this.cancelLabel="Cancel",this.chooseIcon="pi pi-plus",this.uploadIcon="pi pi-upload",this.cancelIcon="pi pi-times",this.showUploadButton=!0,this.showCancelButton=!0,this.mode="advanced",this.onBeforeUpload=new t.EventEmitter,this.onSend=new t.EventEmitter,this.onUpload=new t.EventEmitter,this.onError=new t.EventEmitter,this.onClear=new t.EventEmitter,this.onRemove=new t.EventEmitter,this.onSelect=new t.EventEmitter,this.onProgress=new t.EventEmitter,this.uploadHandler=new t.EventEmitter,this._files=[],this.progress=0,this.uploadedFileCount=0}return Object.defineProperty(e.prototype,"files",{get:function(){return this._files},set:function(e){this._files=[];for(var t=0;t<e.length;t++){var i=e[t];this.validate(i)&&(this.isImage(i)&&(i.objectURL=this.sanitizer.bypassSecurityTrustUrl(window.URL.createObjectURL(e[t]))),this._files.push(e[t]))}},enumerable:!1,configurable:!0}),e.prototype.ngAfterContentInit=function(){var e=this;this.templates.forEach((function(t){switch(t.getType()){case"file":e.fileTemplate=t.template;break;case"content":e.contentTemplate=t.template;break;case"toolbar":e.toolbarTemplate=t.template;break;default:e.fileTemplate=t.template}}))},e.prototype.ngAfterViewInit=function(){var e=this;"advanced"===this.mode&&this.zone.runOutsideAngular((function(){e.content&&e.content.nativeElement.addEventListener("dragover",e.onDragOver.bind(e))}))},e.prototype.choose=function(){this.advancedFileInput.nativeElement.click()},e.prototype.onFileSelect=function(e){if("drop"!==e.type&&this.isIE11()&&this.duplicateIEEvent)this.duplicateIEEvent=!1;else{this.msgs=[],this.multiple||(this.files=[]);for(var t=e.dataTransfer?e.dataTransfer.files:e.target.files,i=0;i<t.length;i++){var n=t[i];this.isFileSelected(n)||this.validate(n)&&(this.isImage(n)&&(n.objectURL=this.sanitizer.bypassSecurityTrustUrl(window.URL.createObjectURL(t[i]))),this.files.push(t[i]))}this.onSelect.emit({originalEvent:e,files:t,currentFiles:this.files}),this.fileLimit&&"advanced"==this.mode&&this.checkFileLimit(),!this.hasFiles()||!this.auto||"advanced"===this.mode&&this.isFileLimitExceeded()||this.upload(),"drop"!==e.type&&this.isIE11()?this.clearIEInput():this.clearInputElement()}},e.prototype.isFileSelected=function(e){var t,i;try{for(var n=d(this.files),o=n.next();!o.done;o=n.next()){var s=o.value;if(s.name+s.type+s.size===e.name+e.type+e.size)return!0}}catch(e){t={error:e}}finally{try{o&&!o.done&&(i=n.return)&&i.call(n)}finally{if(t)throw t.error}}return!1},e.prototype.isIE11=function(){return!!window.MSInputMethodContext&&!!document.documentMode},e.prototype.validate=function(e){return this.accept&&!this.isFileTypeValid(e)?(this.msgs.push({severity:"error",summary:this.invalidFileTypeMessageSummary.replace("{0}",e.name),detail:this.invalidFileTypeMessageDetail.replace("{0}",this.accept)}),!1):!(this.maxFileSize&&e.size>this.maxFileSize)||(this.msgs.push({severity:"error",summary:this.invalidFileSizeMessageSummary.replace("{0}",e.name),detail:this.invalidFileSizeMessageDetail.replace("{0}",this.formatSize(this.maxFileSize))}),!1)},e.prototype.isFileTypeValid=function(e){var t,i,n=this.accept.split(",").map((function(e){return e.trim()}));try{for(var o=d(n),s=o.next();!s.done;s=o.next()){var l=s.value;if(this.isWildcard(l)?this.getTypeClass(e.type)===this.getTypeClass(l):e.type==l||this.getFileExtension(e).toLowerCase()===l.toLowerCase())return!0}}catch(e){t={error:e}}finally{try{s&&!s.done&&(i=o.return)&&i.call(o)}finally{if(t)throw t.error}}return!1},e.prototype.getTypeClass=function(e){return e.substring(0,e.indexOf("/"))},e.prototype.isWildcard=function(e){return-1!==e.indexOf("*")},e.prototype.getFileExtension=function(e){return"."+e.name.split(".").pop()},e.prototype.isImage=function(e){return/^image\//.test(e.type)},e.prototype.onImageLoad=function(e){window.URL.revokeObjectURL(e.src)},e.prototype.upload=function(){var e=this;if(this.customUpload)this.fileLimit&&(this.uploadedFileCount+=this.files.length),this.uploadHandler.emit({files:this.files}),this.cd.markForCheck();else{this.uploading=!0,this.msgs=[];var t=new FormData;this.onBeforeUpload.emit({formData:t});for(var i=0;i<this.files.length;i++)t.append(this.name,this.files[i],this.files[i].name);this.http.post(this.url,t,{headers:this.headers,reportProgress:!0,observe:"events",withCredentials:this.withCredentials}).subscribe((function(i){switch(i.type){case u.HttpEventType.Sent:e.onSend.emit({originalEvent:i,formData:t});break;case u.HttpEventType.Response:e.uploading=!1,e.progress=0,i.status>=200&&i.status<300?(e.fileLimit&&(e.uploadedFileCount+=e.files.length),e.onUpload.emit({originalEvent:i,files:e.files})):e.onError.emit({files:e.files}),e.clear();break;case u.HttpEventType.UploadProgress:i.loaded&&(e.progress=Math.round(100*i.loaded/i.total)),e.onProgress.emit({originalEvent:i,progress:e.progress})}e.cd.markForCheck()}),(function(t){e.uploading=!1,e.onError.emit({files:e.files,error:t})}))}},e.prototype.clear=function(){this.files=[],this.onClear.emit(),this.clearInputElement(),this.cd.markForCheck()},e.prototype.remove=function(e,t){this.clearInputElement(),this.onRemove.emit({originalEvent:e,file:this.files[t]}),this.files.splice(t,1)},e.prototype.isFileLimitExceeded=function(){return this.fileLimit&&this.fileLimit<=this.files.length+this.uploadedFileCount&&this.focus&&(this.focus=!1),this.fileLimit&&this.fileLimit<this.files.length+this.uploadedFileCount},e.prototype.isChooseDisabled=function(){return this.fileLimit&&this.fileLimit<=this.files.length+this.uploadedFileCount},e.prototype.checkFileLimit=function(){this.isFileLimitExceeded()&&this.msgs.push({severity:"error",summary:this.invalidFileLimitMessageSummary.replace("{0}",this.fileLimit.toString()),detail:this.invalidFileLimitMessageDetail.replace("{0}",this.fileLimit.toString())})},e.prototype.clearInputElement=function(){this.advancedFileInput&&this.advancedFileInput.nativeElement&&(this.advancedFileInput.nativeElement.value=""),this.basicFileInput&&this.basicFileInput.nativeElement&&(this.basicFileInput.nativeElement.value="")},e.prototype.clearIEInput=function(){this.advancedFileInput&&this.advancedFileInput.nativeElement&&(this.duplicateIEEvent=!0,this.advancedFileInput.nativeElement.value="")},e.prototype.hasFiles=function(){return this.files&&this.files.length>0},e.prototype.onDragEnter=function(e){this.disabled||(e.stopPropagation(),e.preventDefault())},e.prototype.onDragOver=function(e){this.disabled||(a.DomHandler.addClass(this.content.nativeElement,"p-fileupload-highlight"),this.dragHighlight=!0,e.stopPropagation(),e.preventDefault())},e.prototype.onDragLeave=function(e){this.disabled||a.DomHandler.removeClass(this.content.nativeElement,"p-fileupload-highlight")},e.prototype.onDrop=function(e){if(!this.disabled){a.DomHandler.removeClass(this.content.nativeElement,"p-fileupload-highlight"),e.stopPropagation(),e.preventDefault();var t=e.dataTransfer?e.dataTransfer.files:e.target.files;(this.multiple||t&&1===t.length)&&this.onFileSelect(e)}},e.prototype.onFocus=function(){this.focus=!0},e.prototype.onBlur=function(){this.focus=!1},e.prototype.formatSize=function(e){if(0==e)return"0 B";var t=Math.floor(Math.log(e)/Math.log(1024));return parseFloat((e/Math.pow(1024,t)).toFixed(3))+" "+["B","KB","MB","GB","TB","PB","EB","ZB","YB"][t]},e.prototype.onBasicUploaderClick=function(){this.hasFiles()?this.upload():this.basicFileInput.nativeElement.click()},e.prototype.getBlockableElement=function(){return this.el.nativeElement.children[0]},e.prototype.ngOnDestroy=function(){this.content&&this.content.nativeElement&&this.content.nativeElement.removeEventListener("dragover",this.onDragOver)},e}();c.decorators=[{type:t.Component,args:[{selector:"p-fileUpload",template:'\n        <div [ngClass]="\'p-fileupload p-fileupload-advanced p-component\'" [ngStyle]="style" [class]="styleClass" *ngIf="mode === \'advanced\'">\n            <div class="p-fileupload-buttonbar">\n                <span class="p-button p-component p-fileupload-choose" [ngClass]="{\'p-focus\': focus, \'p-disabled\':disabled || isChooseDisabled()}" (focus)="onFocus()" (blur)="onBlur()" pRipple\n                    (click)="choose()" (keydown.enter)="choose()" tabindex="0"> \n                    <input #advancedfileinput type="file" (change)="onFileSelect($event)" [multiple]="multiple" [accept]="accept" [disabled]="disabled || isChooseDisabled()" [attr.title]="\'\'">\n                    <span [ngClass]="\'p-button-icon p-button-icon-left\'" [class]="chooseIcon"></span>\n                    <span class="p-button-label">{{chooseLabel}}</span>\n                </span>\n\n                <p-button *ngIf="!auto&&showUploadButton" type="button" [label]="uploadLabel" [icon]="uploadIcon" (onClick)="upload()" [disabled]="!hasFiles() || isFileLimitExceeded()"></p-button>\n                <p-button *ngIf="!auto&&showCancelButton" type="button" [label]="cancelLabel" [icon]="cancelIcon" (onClick)="clear()" [disabled]="!hasFiles() || uploading"></p-button>\n\n                <ng-container *ngTemplateOutlet="toolbarTemplate"></ng-container>\n            </div>\n            <div #content class="p-fileupload-content" (dragenter)="onDragEnter($event)" (dragleave)="onDragLeave($event)" (drop)="onDrop($event)">\n                <p-progressBar [value]="progress" [showValue]="false" *ngIf="hasFiles()"></p-progressBar>\n\n                <p-messages [value]="msgs" [enableService]="false"></p-messages>\n\n                <div class="p-fileupload-files" *ngIf="hasFiles()">\n                    <div *ngIf="!fileTemplate">\n                        <div class="p-fileupload-row" *ngFor="let file of files; let i = index;">\n                            <div><img [src]="file.objectURL" *ngIf="isImage(file)" [width]="previewWidth" /></div>\n                            <div>{{file.name}}</div>\n                            <div>{{formatSize(file.size)}}</div>\n                            <div>\n                                <button type="button" icon="pi pi-times" pButton (click)="remove($event,i)" [disabled]="uploading"></button>\n                            </div>\n                        </div>\n                    </div>\n                    <div *ngIf="fileTemplate">\n                        <ng-template ngFor [ngForOf]="files" [ngForTemplate]="fileTemplate"></ng-template>\n                    </div>\n                </div>\n                <ng-container *ngTemplateOutlet="contentTemplate; context: {$implicit: files}"></ng-container>\n            </div>\n        </div>\n        <div class="p-fileupload p-fileupload-basic p-component" *ngIf="mode === \'basic\'">\n            <p-messages [value]="msgs" [enableService]="false"></p-messages>\n            <span [ngClass]="{\'p-button p-component p-fileupload-choose\': true, \'p-fil(eupload-choose-selected\': hasFiles(),\'p-focus\': focus, \'p-disabled\':disabled}"\n                [ngStyle]="style" [class]="styleClass" (mouseup)="onBasicUploaderClick()" (keydown)="onBasicUploaderClick()" tabindex="0" pRipple>\n                <span class="p-button-icon p-button-icon-left pi" [ngClass]="hasFiles()&&!auto ? uploadIcon : chooseIcon"></span>\n                <span class="p-button-label">{{auto ? chooseLabel : hasFiles() ? files[0].name : chooseLabel}}</span>\n                <input #basicfileinput type="file" [accept]="accept" [multiple]="multiple" [disabled]="disabled"\n                    (change)="onFileSelect($event)" *ngIf="!hasFiles()" (focus)="onFocus()" (blur)="onBlur()">\n            </span>\n        </div>\n    ',changeDetection:t.ChangeDetectionStrategy.OnPush,encapsulation:t.ViewEncapsulation.None,styles:[".p-fileupload-content{position:relative}.p-fileupload-row{-ms-flex-align:center;align-items:center;display:-ms-flexbox;display:flex}.p-fileupload-row>div{-ms-flex:1 1 auto;flex:1 1 auto;width:25%}.p-fileupload-row>div:last-child{text-align:right}.p-fileupload-content .p-progressbar{left:0;position:absolute;top:0;width:100%}.p-button.p-fileupload-choose{overflow:hidden;position:relative}.p-button.p-fileupload-choose input[type=file],.p-fileupload-choose.p-fileupload-choose-selected input[type=file]{display:none}.p-fluid .p-fileupload .p-button{width:auto}"]}]}],c.ctorParameters=function(){return[{type:t.ElementRef},{type:n.DomSanitizer},{type:t.NgZone},{type:u.HttpClient},{type:t.ChangeDetectorRef}]},c.propDecorators={name:[{type:t.Input}],url:[{type:t.Input}],method:[{type:t.Input}],multiple:[{type:t.Input}],accept:[{type:t.Input}],disabled:[{type:t.Input}],auto:[{type:t.Input}],withCredentials:[{type:t.Input}],maxFileSize:[{type:t.Input}],invalidFileSizeMessageSummary:[{type:t.Input}],invalidFileSizeMessageDetail:[{type:t.Input}],invalidFileTypeMessageSummary:[{type:t.Input}],invalidFileTypeMessageDetail:[{type:t.Input}],invalidFileLimitMessageDetail:[{type:t.Input}],invalidFileLimitMessageSummary:[{type:t.Input}],style:[{type:t.Input}],styleClass:[{type:t.Input}],previewWidth:[{type:t.Input}],chooseLabel:[{type:t.Input}],uploadLabel:[{type:t.Input}],cancelLabel:[{type:t.Input}],chooseIcon:[{type:t.Input}],uploadIcon:[{type:t.Input}],cancelIcon:[{type:t.Input}],showUploadButton:[{type:t.Input}],showCancelButton:[{type:t.Input}],mode:[{type:t.Input}],headers:[{type:t.Input}],customUpload:[{type:t.Input}],fileLimit:[{type:t.Input}],onBeforeUpload:[{type:t.Output}],onSend:[{type:t.Output}],onUpload:[{type:t.Output}],onError:[{type:t.Output}],onClear:[{type:t.Output}],onRemove:[{type:t.Output}],onSelect:[{type:t.Output}],onProgress:[{type:t.Output}],uploadHandler:[{type:t.Output}],templates:[{type:t.ContentChildren,args:[p.PrimeTemplate]}],advancedFileInput:[{type:t.ViewChild,args:["advancedfileinput"]}],basicFileInput:[{type:t.ViewChild,args:["basicfileinput"]}],content:[{type:t.ViewChild,args:["content"]}],files:[{type:t.Input}]};var h=function(){};h.decorators=[{type:t.NgModule,args:[{imports:[i.CommonModule,p.SharedModule,o.ButtonModule,l.ProgressBarModule,s.MessagesModule,r.RippleModule],exports:[c,p.SharedModule,o.ButtonModule,l.ProgressBarModule,s.MessagesModule],declarations:[c]}]}],e.FileUpload=c,e.FileUploadModule=h,Object.defineProperty(e,"__esModule",{value:!0})}));
//# sourceMappingURL=primeng-fileupload.umd.min.js.map