import { ElementRef, OnInit, AfterContentInit, EventEmitter, QueryList, TemplateRef, OnChanges, SimpleChanges, ChangeDetectorRef } from '@angular/core';
import { BlockableUI } from 'primeng/api';
export declare class DataView implements OnInit, AfterContentInit, BlockableUI, OnChanges {
    el: ElementRef;
    cd: ChangeDetectorRef;
    layout: string;
    paginator: boolean;
    rows: number;
    totalRecords: number;
    pageLinks: number;
    rowsPerPageOptions: any[];
    paginatorPosition: string;
    alwaysShowPaginator: boolean;
    paginatorDropdownAppendTo: any;
    paginatorDropdownScrollHeight: string;
    currentPageReportTemplate: string;
    showCurrentPageReport: boolean;
    showJumpToPageDropdown: boolean;
    showPageLinks: boolean;
    lazy: boolean;
    emptyMessage: string;
    onLazyLoad: EventEmitter<any>;
    style: any;
    styleClass: string;
    trackBy: Function;
    filterBy: string;
    filterLocale: string;
    loading: boolean;
    loadingIcon: string;
    first: number;
    sortField: string;
    sortOrder: number;
    value: any[];
    onPage: EventEmitter<any>;
    onSort: EventEmitter<any>;
    onChangeLayout: EventEmitter<any>;
    header: any;
    footer: any;
    templates: QueryList<any>;
    _value: any[];
    listItemTemplate: TemplateRef<any>;
    gridItemTemplate: TemplateRef<any>;
    itemTemplate: TemplateRef<any>;
    headerTemplate: TemplateRef<any>;
    footerTemplate: TemplateRef<any>;
    paginatorLeftTemplate: TemplateRef<any>;
    paginatorRightTemplate: TemplateRef<any>;
    filteredValue: any[];
    filterValue: string;
    initialized: boolean;
    constructor(el: ElementRef, cd: ChangeDetectorRef);
    ngOnInit(): void;
    ngOnChanges(simpleChanges: SimpleChanges): void;
    ngAfterContentInit(): void;
    updateItemTemplate(): void;
    changeLayout(layout: string): void;
    updateTotalRecords(): void;
    paginate(event: any): void;
    sort(): void;
    isEmpty(): boolean;
    createLazyLoadMetadata(): any;
    getBlockableElement(): HTMLElement;
    filter(filter: string, filterMatchMode?: string): void;
    hasFilter(): boolean;
}
export declare class DataViewLayoutOptions {
    dv: DataView;
    style: any;
    styleClass: string;
    constructor(dv: DataView);
    changeLayout(event: Event, layout: string): void;
}
export declare class DataViewModule {
}
