import { ElementRef, OnDestroy, EventEmitter, Renderer2, QueryList, NgZone, ChangeDetectorRef, AfterContentInit, TemplateRef } from '@angular/core';
import { AnimationEvent } from '@angular/animations';
import { Header, Footer } from 'primeng/api';
export declare class Dialog implements AfterContentInit, OnDestroy {
    el: ElementRef;
    renderer: Renderer2;
    zone: NgZone;
    private cd;
    header: string;
    draggable: boolean;
    resizable: boolean;
    get positionLeft(): number;
    set positionLeft(_positionLeft: number);
    get positionTop(): number;
    set positionTop(_positionTop: number);
    contentStyle: any;
    contentStyleClass: string;
    modal: boolean;
    closeOnEscape: boolean;
    dismissableMask: boolean;
    rtl: boolean;
    closable: boolean;
    get responsive(): boolean;
    set responsive(_responsive: boolean);
    appendTo: any;
    styleClass: string;
    maskStyleClass: string;
    showHeader: boolean;
    get breakpoint(): number;
    set breakpoint(_breakpoint: number);
    blockScroll: boolean;
    autoZIndex: boolean;
    baseZIndex: number;
    minX: number;
    minY: number;
    focusOnShow: boolean;
    maximizable: boolean;
    keepInViewport: boolean;
    focusTrap: boolean;
    transitionOptions: string;
    closeIcon: string;
    minimizeIcon: string;
    maximizeIcon: string;
    headerFacet: QueryList<Header>;
    footerFacet: QueryList<Footer>;
    templates: QueryList<any>;
    headerViewChild: ElementRef;
    contentViewChild: ElementRef;
    footerViewChild: ElementRef;
    onShow: EventEmitter<any>;
    onHide: EventEmitter<any>;
    visibleChange: EventEmitter<any>;
    onResizeInit: EventEmitter<any>;
    onResizeEnd: EventEmitter<any>;
    onDragEnd: EventEmitter<any>;
    headerTemplate: TemplateRef<any>;
    contentTemplate: TemplateRef<any>;
    footerTemplate: TemplateRef<any>;
    _visible: boolean;
    maskVisible: boolean;
    container: HTMLDivElement;
    wrapper: HTMLElement;
    dragging: boolean;
    documentDragListener: any;
    documentDragEndListener: any;
    resizing: boolean;
    documentResizeListener: any;
    documentResizeEndListener: any;
    documentEscapeListener: Function;
    maskClickListener: Function;
    lastPageX: number;
    lastPageY: number;
    preventVisibleChangePropagation: boolean;
    maximized: boolean;
    preMaximizeContentHeight: number;
    preMaximizeContainerWidth: number;
    preMaximizeContainerHeight: number;
    preMaximizePageX: number;
    preMaximizePageY: number;
    id: string;
    _style: any;
    _position: string;
    originalStyle: any;
    transformOptions: any;
    constructor(el: ElementRef, renderer: Renderer2, zone: NgZone, cd: ChangeDetectorRef);
    ngAfterContentInit(): void;
    get visible(): any;
    set visible(value: any);
    get style(): any;
    set style(value: any);
    get position(): string;
    set position(value: string);
    focus(): void;
    close(event: Event): void;
    enableModality(): void;
    disableModality(): void;
    maximize(): void;
    unbindMaskClickListener(): void;
    moveOnTop(): void;
    initDrag(event: MouseEvent): void;
    onKeydown(event: KeyboardEvent): void;
    onDrag(event: MouseEvent): void;
    endDrag(event: MouseEvent): void;
    resetPosition(): void;
    center(): void;
    initResize(event: MouseEvent): void;
    onResize(event: MouseEvent): void;
    resizeEnd(event: any): void;
    bindGlobalListeners(): void;
    unbindGlobalListeners(): void;
    bindDocumentDragListener(): void;
    unbindDocumentDragListener(): void;
    bindDocumentDragEndListener(): void;
    unbindDocumentDragEndListener(): void;
    bindDocumentResizeListeners(): void;
    unbindDocumentResizeListeners(): void;
    bindDocumentEscapeListener(): void;
    unbindDocumentEscapeListener(): void;
    appendContainer(): void;
    restoreAppend(): void;
    onAnimationStart(event: AnimationEvent): void;
    onAnimationEnd(event: AnimationEvent): void;
    onContainerDestroy(): void;
    ngOnDestroy(): void;
}
export declare class DialogModule {
}
