import { CdkVirtualScrollViewport } from '@angular/cdk/scrolling';
import { ElementRef, OnInit, AfterViewInit, AfterContentInit, AfterViewChecked, OnDestroy, Renderer2, EventEmitter, QueryList, TemplateRef, ChangeDetectorRef, NgZone } from '@angular/core';
import { AnimationEvent } from '@angular/animations';
import { SelectItem } from 'primeng/api';
import { ControlValueAccessor } from '@angular/forms';
export declare const DROPDOWN_VALUE_ACCESSOR: any;
export declare class DropdownItem {
    option: SelectItem;
    selected: boolean;
    disabled: boolean;
    visible: boolean;
    itemSize: number;
    template: TemplateRef<any>;
    onClick: EventEmitter<any>;
    onOptionClick(event: Event): void;
}
export declare class Dropdown implements OnInit, AfterViewInit, AfterContentInit, AfterViewChecked, OnDestroy, ControlValueAccessor {
    el: ElementRef;
    renderer: Renderer2;
    cd: ChangeDetectorRef;
    zone: NgZone;
    scrollHeight: string;
    filter: boolean;
    name: string;
    style: any;
    panelStyle: any;
    styleClass: string;
    panelStyleClass: string;
    readonly: boolean;
    required: boolean;
    editable: boolean;
    appendTo: any;
    tabindex: number;
    placeholder: string;
    filterPlaceholder: string;
    filterLocale: string;
    inputId: string;
    selectId: string;
    dataKey: string;
    filterBy: string;
    autofocus: boolean;
    resetFilterOnHide: boolean;
    dropdownIcon: string;
    optionLabel: string;
    autoDisplayFirst: boolean;
    group: boolean;
    showClear: boolean;
    emptyFilterMessage: string;
    virtualScroll: boolean;
    itemSize: number;
    autoZIndex: boolean;
    baseZIndex: number;
    showTransitionOptions: string;
    hideTransitionOptions: string;
    ariaFilterLabel: string;
    ariaLabelledBy: string;
    filterMatchMode: string;
    maxlength: number;
    tooltip: string;
    tooltipPosition: string;
    tooltipPositionStyle: string;
    tooltipStyleClass: string;
    autofocusFilter: boolean;
    onChange: EventEmitter<any>;
    onFocus: EventEmitter<any>;
    onBlur: EventEmitter<any>;
    onClick: EventEmitter<any>;
    onShow: EventEmitter<any>;
    onHide: EventEmitter<any>;
    containerViewChild: ElementRef;
    filterViewChild: ElementRef;
    accessibleViewChild: ElementRef;
    viewPort: CdkVirtualScrollViewport;
    editableInputViewChild: ElementRef;
    templates: QueryList<any>;
    private _disabled;
    get disabled(): boolean;
    set disabled(_disabled: boolean);
    overlay: HTMLDivElement;
    itemsWrapper: HTMLDivElement;
    itemTemplate: TemplateRef<any>;
    groupTemplate: TemplateRef<any>;
    selectedItemTemplate: TemplateRef<any>;
    selectedOption: any;
    _options: any[];
    value: any;
    onModelChange: Function;
    onModelTouched: Function;
    optionsToDisplay: any[];
    hover: boolean;
    focused: boolean;
    filled: boolean;
    overlayVisible: boolean;
    documentClickListener: any;
    scrollHandler: any;
    optionsChanged: boolean;
    panel: HTMLDivElement;
    dimensionsUpdated: boolean;
    hoveredItem: any;
    selectedOptionUpdated: boolean;
    filterValue: string;
    searchValue: string;
    searchIndex: number;
    searchTimeout: any;
    previousSearchChar: string;
    currentSearchChar: string;
    documentResizeListener: any;
    virtualAutoScrolled: boolean;
    virtualScrollSelectedIndex: number;
    viewPortOffsetTop: number;
    preventModelTouched: boolean;
    constructor(el: ElementRef, renderer: Renderer2, cd: ChangeDetectorRef, zone: NgZone);
    ngAfterContentInit(): void;
    ngOnInit(): void;
    get options(): any[];
    set options(val: any[]);
    ngAfterViewInit(): void;
    get label(): string;
    updateEditableLabel(): void;
    onItemClick(event: any): void;
    selectItem(event: any, option: any): void;
    ngAfterViewChecked(): void;
    writeValue(value: any): void;
    resetFilter(): void;
    updateSelectedOption(val: any): void;
    registerOnChange(fn: Function): void;
    registerOnTouched(fn: Function): void;
    setDisabledState(val: boolean): void;
    onMouseclick(event: any): void;
    isInputClick(event: any): boolean;
    isOutsideClicked(event: Event): boolean;
    onEditableInputClick(): void;
    onEditableInputFocus(event: any): void;
    onEditableInputChange(event: any): void;
    show(): void;
    onOverlayAnimationStart(event: AnimationEvent): void;
    scrollToSelectedVirtualScrollElement(): void;
    updateVirtualScrollSelectedIndex(resetOffset: any): void;
    appendOverlay(): void;
    restoreOverlayAppend(): void;
    hide(event: any): void;
    alignOverlay(): void;
    onInputFocus(event: any): void;
    onInputBlur(event: any): void;
    findPrevEnabledOption(index: any): any;
    findNextEnabledOption(index: any): any;
    onKeydown(event: KeyboardEvent, search: boolean): void;
    search(event: any): void;
    searchOption(index: any): any;
    searchOptionInRange(start: any, end: any): any;
    searchOptionWithinGroup(index: any): any;
    findOptionIndex(val: any, opts: any[]): number;
    findOptionGroupIndex(val: any, opts: any[]): any;
    findOption(val: any, opts: any[], inGroup?: boolean): SelectItem;
    onFilter(event: any): void;
    activateFilter(): void;
    applyFocus(): void;
    focus(): void;
    bindDocumentClickListener(): void;
    unbindDocumentClickListener(): void;
    bindDocumentResizeListener(): void;
    unbindDocumentResizeListener(): void;
    onWindowResize(): void;
    bindScrollListener(): void;
    unbindScrollListener(): void;
    updateFilledState(): void;
    clear(event: Event): void;
    onOverlayHide(): void;
    ngOnDestroy(): void;
}
export declare class DropdownModule {
}
