import { Subject } from 'rxjs';
export class DynamicDialogRef {
    constructor() {
        this._onClose = new Subject();
        this.onClose = this._onClose.asObservable();
        this._onDestroy = new Subject();
        this.onDestroy = this._onDestroy.asObservable();
    }
    close(result) {
        this._onClose.next(result);
    }
    destroy() {
        this._onDestroy.next();
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZHluYW1pY2RpYWxvZy1yZWYuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvYXBwL2NvbXBvbmVudHMvZHluYW1pY2RpYWxvZy9keW5hbWljZGlhbG9nLXJlZi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLEVBQWMsT0FBTyxFQUFFLE1BQU0sTUFBTSxDQUFDO0FBRTNDLE1BQU0sT0FBTyxnQkFBZ0I7SUFDNUI7UUFVaUIsYUFBUSxHQUFHLElBQUksT0FBTyxFQUFPLENBQUM7UUFDNUMsWUFBTyxHQUFvQixJQUFJLENBQUMsUUFBUSxDQUFDLFlBQVksRUFBRSxDQUFDO1FBRXZDLGVBQVUsR0FBRyxJQUFJLE9BQU8sRUFBTyxDQUFDO1FBQ3BELGNBQVMsR0FBb0IsSUFBSSxDQUFDLFVBQVUsQ0FBQyxZQUFZLEVBQUUsQ0FBQztJQWQ1QyxDQUFDO0lBRWpCLEtBQUssQ0FBQyxNQUFZO1FBQ2pCLElBQUksQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQ3pCLENBQUM7SUFFRCxPQUFPO1FBQ1QsSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLEVBQUUsQ0FBQztJQUN4QixDQUFDO0NBT0QiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBPYnNlcnZhYmxlLCBTdWJqZWN0IH0gZnJvbSAncnhqcyc7XHJcblxyXG5leHBvcnQgY2xhc3MgRHluYW1pY0RpYWxvZ1JlZiB7XHJcblx0Y29uc3RydWN0b3IoKSB7IH1cclxuXHJcblx0Y2xvc2UocmVzdWx0PzogYW55KSB7XHJcblx0XHR0aGlzLl9vbkNsb3NlLm5leHQocmVzdWx0KTtcclxuICAgIH1cclxuICAgIFxyXG4gICAgZGVzdHJveSgpIHtcclxuXHRcdHRoaXMuX29uRGVzdHJveS5uZXh0KCk7XHJcblx0fVxyXG5cclxuXHRwcml2YXRlIHJlYWRvbmx5IF9vbkNsb3NlID0gbmV3IFN1YmplY3Q8YW55PigpO1xyXG4gICAgb25DbG9zZTogT2JzZXJ2YWJsZTxhbnk+ID0gdGhpcy5fb25DbG9zZS5hc09ic2VydmFibGUoKTtcclxuXHJcbiAgICBwcml2YXRlIHJlYWRvbmx5IF9vbkRlc3Ryb3kgPSBuZXcgU3ViamVjdDxhbnk+KCk7XHJcblx0b25EZXN0cm95OiBPYnNlcnZhYmxlPGFueT4gPSB0aGlzLl9vbkRlc3Ryb3kuYXNPYnNlcnZhYmxlKCk7XHJcbn1cclxuIl19