export class ObjectUtils {
    static equals(obj1, obj2, field) {
        if (field)
            return (this.resolveFieldData(obj1, field) === this.resolveFieldData(obj2, field));
        else
            return this.equalsByValue(obj1, obj2);
    }
    static equalsByValue(obj1, obj2) {
        if (obj1 === obj2)
            return true;
        if (obj1 && obj2 && typeof obj1 == 'object' && typeof obj2 == 'object') {
            var arrA = Array.isArray(obj1), arrB = Array.isArray(obj2), i, length, key;
            if (arrA && arrB) {
                length = obj1.length;
                if (length != obj2.length)
                    return false;
                for (i = length; i-- !== 0;)
                    if (!this.equalsByValue(obj1[i], obj2[i]))
                        return false;
                return true;
            }
            if (arrA != arrB)
                return false;
            var dateA = obj1 instanceof Date, dateB = obj2 instanceof Date;
            if (dateA != dateB)
                return false;
            if (dateA && dateB)
                return obj1.getTime() == obj2.getTime();
            var regexpA = obj1 instanceof RegExp, regexpB = obj2 instanceof RegExp;
            if (regexpA != regexpB)
                return false;
            if (regexpA && regexpB)
                return obj1.toString() == obj2.toString();
            var keys = Object.keys(obj1);
            length = keys.length;
            if (length !== Object.keys(obj2).length)
                return false;
            for (i = length; i-- !== 0;)
                if (!Object.prototype.hasOwnProperty.call(obj2, keys[i]))
                    return false;
            for (i = length; i-- !== 0;) {
                key = keys[i];
                if (!this.equalsByValue(obj1[key], obj2[key]))
                    return false;
            }
            return true;
        }
        return obj1 !== obj1 && obj2 !== obj2;
    }
    static resolveFieldData(data, field) {
        if (data && field) {
            if (this.isFunction(field)) {
                return field(data);
            }
            else if (field.indexOf('.') == -1) {
                return data[field];
            }
            else {
                let fields = field.split('.');
                let value = data;
                for (let i = 0, len = fields.length; i < len; ++i) {
                    if (value == null) {
                        return null;
                    }
                    value = value[fields[i]];
                }
                return value;
            }
        }
        else {
            return null;
        }
    }
    static isFunction(obj) {
        return !!(obj && obj.constructor && obj.call && obj.apply);
    }
    static reorderArray(value, from, to) {
        let target;
        if (value && from !== to) {
            if (to >= value.length) {
                to %= value.length;
                from %= value.length;
            }
            value.splice(to, 0, value.splice(from, 1)[0]);
        }
    }
    static generateSelectItems(val, field) {
        let selectItems;
        if (val && val.length) {
            selectItems = [];
            for (let item of val) {
                selectItems.push({ label: this.resolveFieldData(item, field), value: item });
            }
        }
        return selectItems;
    }
    static insertIntoOrderedArray(item, index, arr, sourceArr) {
        if (arr.length > 0) {
            let injected = false;
            for (let i = 0; i < arr.length; i++) {
                let currentItemIndex = this.findIndexInList(arr[i], sourceArr);
                if (currentItemIndex > index) {
                    arr.splice(i, 0, item);
                    injected = true;
                    break;
                }
            }
            if (!injected) {
                arr.push(item);
            }
        }
        else {
            arr.push(item);
        }
    }
    static findIndexInList(item, list) {
        let index = -1;
        if (list) {
            for (let i = 0; i < list.length; i++) {
                if (list[i] == item) {
                    index = i;
                    break;
                }
            }
        }
        return index;
    }
    static removeAccents(str) {
        if (str && str.search(/[\xC0-\xFF]/g) > -1) {
            str = str
                .replace(/[\xC0-\xC5]/g, "A")
                .replace(/[\xC6]/g, "AE")
                .replace(/[\xC7]/g, "C")
                .replace(/[\xC8-\xCB]/g, "E")
                .replace(/[\xCC-\xCF]/g, "I")
                .replace(/[\xD0]/g, "D")
                .replace(/[\xD1]/g, "N")
                .replace(/[\xD2-\xD6\xD8]/g, "O")
                .replace(/[\xD9-\xDC]/g, "U")
                .replace(/[\xDD]/g, "Y")
                .replace(/[\xDE]/g, "P")
                .replace(/[\xE0-\xE5]/g, "a")
                .replace(/[\xE6]/g, "ae")
                .replace(/[\xE7]/g, "c")
                .replace(/[\xE8-\xEB]/g, "e")
                .replace(/[\xEC-\xEF]/g, "i")
                .replace(/[\xF1]/g, "n")
                .replace(/[\xF2-\xF6\xF8]/g, "o")
                .replace(/[\xF9-\xFC]/g, "u")
                .replace(/[\xFE]/g, "p")
                .replace(/[\xFD\xFF]/g, "y");
        }
        return str;
    }
}
//# sourceMappingURL=data:application/json;base64,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