import { ElementRef, OnInit, AfterViewInit, AfterContentInit, AfterViewChecked, OnDestroy, Renderer2, EventEmitter, ChangeDetectorRef, TemplateRef, QueryList } from '@angular/core';
import { AnimationEvent } from '@angular/animations';
import { SelectItem } from 'primeng/api';
import { ControlValueAccessor } from '@angular/forms';
export declare const MULTISELECT_VALUE_ACCESSOR: any;
export declare class MultiSelectItem {
    option: any;
    selected: boolean;
    disabled: boolean;
    itemSize: number;
    template: TemplateRef<any>;
    maxSelectionLimitReached: boolean;
    onClick: EventEmitter<any>;
    onKeydown: EventEmitter<any>;
    onOptionClick(event: Event): void;
    onOptionKeydown(event: Event): void;
}
export declare class MultiSelect implements OnInit, AfterViewInit, AfterContentInit, AfterViewChecked, OnDestroy, ControlValueAccessor {
    el: ElementRef;
    renderer: Renderer2;
    cd: ChangeDetectorRef;
    scrollHeight: string;
    _defaultLabel: string;
    set defaultLabel(val: string);
    get defaultLabel(): string;
    _placeholder: string;
    set placeholder(val: string);
    get placeholder(): string;
    style: any;
    styleClass: string;
    panelStyle: any;
    panelStyleClass: string;
    inputId: string;
    disabled: boolean;
    readonly: boolean;
    filter: boolean;
    filterPlaceHolder: string;
    filterLocale: string;
    overlayVisible: boolean;
    tabindex: number;
    appendTo: any;
    dataKey: string;
    name: string;
    ariaLabelledBy: string;
    displaySelectedLabel: boolean;
    maxSelectedLabels: number;
    selectionLimit: number;
    selectedItemsLabel: string;
    showToggleAll: boolean;
    emptyFilterMessage: string;
    resetFilterOnHide: boolean;
    dropdownIcon: string;
    optionLabel: string;
    showHeader: boolean;
    autoZIndex: boolean;
    baseZIndex: number;
    filterBy: string;
    virtualScroll: boolean;
    itemSize: number;
    showTransitionOptions: string;
    hideTransitionOptions: string;
    ariaFilterLabel: string;
    filterMatchMode: string;
    tooltip: string;
    tooltipPosition: string;
    tooltipPositionStyle: string;
    tooltipStyleClass: string;
    autofocusFilter: boolean;
    containerViewChild: ElementRef;
    filterInputChild: ElementRef;
    accessibleViewChild: ElementRef;
    footerFacet: any;
    headerFacet: any;
    templates: QueryList<any>;
    onChange: EventEmitter<any>;
    onFocus: EventEmitter<any>;
    onBlur: EventEmitter<any>;
    onClick: EventEmitter<any>;
    onPanelShow: EventEmitter<any>;
    onPanelHide: EventEmitter<any>;
    value: any[];
    onModelChange: Function;
    onModelTouched: Function;
    overlay: HTMLDivElement;
    valuesAsString: string;
    focus: boolean;
    filled: boolean;
    documentClickListener: any;
    filterValue: string;
    visibleOptions: SelectItem[];
    disabledSelectedOptions: SelectItem[];
    filtered: boolean;
    itemTemplate: TemplateRef<any>;
    headerTemplate: TemplateRef<any>;
    footerTemplate: TemplateRef<any>;
    selectedItemsTemplate: TemplateRef<any>;
    headerCheckboxFocus: boolean;
    _options: any[];
    maxSelectionLimitReached: boolean;
    scrollHandler: any;
    documentResizeListener: any;
    preventModelTouched: boolean;
    constructor(el: ElementRef, renderer: Renderer2, cd: ChangeDetectorRef);
    get options(): any[];
    set options(val: any[]);
    ngOnInit(): void;
    ngAfterContentInit(): void;
    ngAfterViewInit(): void;
    ngAfterViewChecked(): void;
    writeValue(value: any): void;
    checkSelectionLimit(): void;
    updateFilledState(): void;
    registerOnChange(fn: Function): void;
    registerOnTouched(fn: Function): void;
    setDisabledState(val: boolean): void;
    onOptionClick(event: any): void;
    isSelected(value: any): boolean;
    findSelectionIndex(val: any): number;
    toggleAll(event: Event): void;
    isAllChecked(): boolean;
    isAllVisibleOptionsChecked(): boolean;
    getEnabledOptionCount(): number;
    setDisabledSelectedOptions(): void;
    show(): void;
    onOverlayAnimationStart(event: AnimationEvent): void;
    appendOverlay(): void;
    restoreOverlayAppend(): void;
    alignOverlay(): void;
    hide(): void;
    close(event: any): void;
    onMouseclick(event: any, input: any): void;
    isOverlayClick(event: any): boolean;
    isOutsideClicked(event: Event): boolean;
    onInputFocus(event: any): void;
    onInputBlur(event: any): void;
    onOptionKeydown(event: any): void;
    findNextItem(item: any): any;
    findPrevItem(item: any): any;
    onKeydown(event: KeyboardEvent): void;
    updateLabel(): void;
    findLabelByValue(val: any): string;
    onFilter(): void;
    activateFilter(): void;
    getVisibleOptions(): SelectItem[];
    onHeaderCheckboxFocus(): void;
    onHeaderCheckboxBlur(): void;
    bindDocumentClickListener(): void;
    unbindDocumentClickListener(): void;
    bindDocumentResizeListener(): void;
    unbindDocumentResizeListener(): void;
    onWindowResize(): void;
    bindScrollListener(): void;
    unbindScrollListener(): void;
    onOverlayHide(): void;
    ngOnDestroy(): void;
}
export declare class MultiSelectModule {
}
