import { AfterViewInit, AfterViewChecked, OnDestroy, EventEmitter, ElementRef, Renderer2, QueryList, AfterContentInit, TemplateRef, ChangeDetectorRef } from '@angular/core';
export declare class Sidebar implements AfterViewInit, AfterContentInit, AfterViewChecked, OnDestroy {
    el: ElementRef;
    renderer: Renderer2;
    cd: ChangeDetectorRef;
    position: string;
    fullScreen: boolean;
    appendTo: string;
    blockScroll: boolean;
    style: any;
    styleClass: string;
    ariaCloseLabel: string;
    autoZIndex: boolean;
    baseZIndex: number;
    modal: boolean;
    dismissible: boolean;
    showCloseIcon: boolean;
    closeOnEscape: boolean;
    containerViewChild: ElementRef;
    templates: QueryList<any>;
    onShow: EventEmitter<any>;
    onHide: EventEmitter<any>;
    visibleChange: EventEmitter<any>;
    initialized: boolean;
    _visible: boolean;
    preventVisibleChangePropagation: boolean;
    mask: HTMLDivElement;
    maskClickListener: Function;
    documentEscapeListener: Function;
    executePostDisplayActions: boolean;
    contentTemplate: TemplateRef<any>;
    constructor(el: ElementRef, renderer: Renderer2, cd: ChangeDetectorRef);
    ngAfterViewInit(): void;
    ngAfterContentInit(): void;
    get visible(): boolean;
    set visible(val: boolean);
    ngAfterViewChecked(): void;
    show(): void;
    hide(): void;
    close(event: Event): void;
    enableModality(): void;
    disableModality(): void;
    onAnimationStart(event: any): void;
    bindDocumentEscapeListener(): void;
    unbindDocumentEscapeListener(): void;
    unbindMaskClickListener(): void;
    unbindGlobalListeners(): void;
    ngOnDestroy(): void;
}
export declare class SidebarModule {
}
