import { ElementRef, AfterViewChecked, AfterContentInit, OnDestroy, EventEmitter, QueryList, TemplateRef, Renderer2, ChangeDetectorRef, IterableDiffers } from '@angular/core';
import { AnimationEvent } from '@angular/animations';
import { PrimeNGConfig } from 'primeng/api';
import { ControlValueAccessor } from '@angular/forms';
import { CdkVirtualScrollViewport } from '@angular/cdk/scrolling';
export declare const AUTOCOMPLETE_VALUE_ACCESSOR: any;
export declare class AutoComplete implements AfterViewChecked, AfterContentInit, OnDestroy, ControlValueAccessor {
    el: ElementRef;
    renderer: Renderer2;
    cd: ChangeDetectorRef;
    differs: IterableDiffers;
    config: PrimeNGConfig;
    minLength: number;
    delay: number;
    style: any;
    panelStyle: any;
    styleClass: string;
    panelStyleClass: string;
    inputStyle: any;
    inputId: string;
    inputStyleClass: string;
    placeholder: string;
    readonly: boolean;
    disabled: boolean;
    virtualScroll: boolean;
    itemSize: number;
    maxlength: number;
    name: string;
    required: boolean;
    size: number;
    appendTo: any;
    autoHighlight: boolean;
    forceSelection: boolean;
    type: string;
    autoZIndex: boolean;
    baseZIndex: number;
    ariaLabel: string;
    ariaLabelledBy: string;
    dropdownIcon: string;
    unique: boolean;
    group: boolean;
    completeOnFocus: boolean;
    completeMethod: EventEmitter<any>;
    onSelect: EventEmitter<any>;
    onUnselect: EventEmitter<any>;
    onFocus: EventEmitter<any>;
    onBlur: EventEmitter<any>;
    onDropdownClick: EventEmitter<any>;
    onClear: EventEmitter<any>;
    onKeyUp: EventEmitter<any>;
    onShow: EventEmitter<any>;
    onHide: EventEmitter<any>;
    field: string;
    scrollHeight: string;
    dropdown: boolean;
    showEmptyMessage: boolean;
    dropdownMode: string;
    multiple: boolean;
    tabindex: number;
    dataKey: string;
    emptyMessage: string;
    showTransitionOptions: string;
    hideTransitionOptions: string;
    autofocus: boolean;
    autocomplete: string;
    optionGroupChildren: string;
    optionGroupLabel: string;
    containerEL: ElementRef;
    inputEL: ElementRef;
    multiInputEL: ElementRef;
    multiContainerEL: ElementRef;
    dropdownButton: ElementRef;
    viewPort: CdkVirtualScrollViewport;
    templates: QueryList<any>;
    overlay: HTMLDivElement;
    itemsWrapper: HTMLDivElement;
    itemTemplate: TemplateRef<any>;
    emptyTemplate: TemplateRef<any>;
    headerTemplate: TemplateRef<any>;
    footerTemplate: TemplateRef<any>;
    selectedItemTemplate: TemplateRef<any>;
    groupTemplate: TemplateRef<any>;
    value: any;
    _suggestions: any[];
    onModelChange: Function;
    onModelTouched: Function;
    timeout: any;
    overlayVisible: boolean;
    documentClickListener: any;
    suggestionsUpdated: boolean;
    highlightOption: any;
    highlightOptionChanged: boolean;
    focus: boolean;
    filled: boolean;
    inputClick: boolean;
    inputKeyDown: boolean;
    noResults: boolean;
    differ: any;
    inputFieldValue: string;
    loading: boolean;
    scrollHandler: any;
    documentResizeListener: any;
    forceSelectionUpdateModelTimeout: any;
    listId: string;
    itemClicked: boolean;
    virtualScrollSelectedIndex: number;
    constructor(el: ElementRef, renderer: Renderer2, cd: ChangeDetectorRef, differs: IterableDiffers, config: PrimeNGConfig);
    get suggestions(): any[];
    set suggestions(val: any[]);
    ngAfterViewChecked(): void;
    handleSuggestionsChange(): void;
    ngAfterContentInit(): void;
    updateVirtualScrollSelectedIndex(): void;
    writeValue(value: any): void;
    getOptionGroupChildren(optionGroup: any): any;
    getOptionGroupLabel(optionGroup: any): any;
    registerOnChange(fn: Function): void;
    registerOnTouched(fn: Function): void;
    setDisabledState(val: boolean): void;
    onInput(event: Event): void;
    onInputClick(event: MouseEvent): void;
    search(event: any, query: string): void;
    selectItem(option: any, focus?: boolean): void;
    show(): void;
    onOverlayAnimationStart(event: AnimationEvent): void;
    appendOverlay(): void;
    resolveFieldData(value: any): any;
    restoreOverlayAppend(): void;
    alignOverlay(): void;
    hide(): void;
    handleDropdownClick(event: any): void;
    focusInput(): void;
    get emptyMessageLabel(): string;
    removeItem(item: any): void;
    onKeydown(event: any): void;
    onKeyup(event: any): void;
    onInputFocus(event: any): void;
    onInputBlur(event: any): void;
    onInputChange(event: any): void;
    onInputPaste(event: ClipboardEvent): void;
    isSelected(val: any): boolean;
    findOptionIndex(option: any, suggestions: any): number;
    findOptionGroupIndex(val: any, opts: any[]): any;
    updateFilledState(): void;
    updateInputField(): void;
    bindDocumentClickListener(): void;
    isDropdownClick(event: any): boolean;
    unbindDocumentClickListener(): void;
    bindDocumentResizeListener(): void;
    unbindDocumentResizeListener(): void;
    onWindowResize(): void;
    bindScrollListener(): void;
    unbindScrollListener(): void;
    onOverlayHide(): void;
    ngOnDestroy(): void;
}
export declare class AutoCompleteModule {
}
