!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports,require("@angular/core"),require("@angular/common"),require("@angular/forms")):"function"==typeof define&&define.amd?define("primeng/knob",["exports","@angular/core","@angular/common","@angular/forms"],e):e(((t="undefined"!=typeof globalThis?globalThis:t||self).primeng=t.primeng||{},t.primeng.knob={}),t.ng.core,t.ng.common,t.ng.forms)}(this,(function(t,e,i,n){"use strict";var o={provide:n.NG_VALUE_ACCESSOR,useExisting:e.forwardRef((function(){return s})),multi:!0},s=function(){function t(t,i){this.cd=t,this.el=i,this.valueColor="var(--primary-color, Black)",this.rangeColor="var(--surface-d, LightGray)",this.textColor="var(--text-color-secondary, Black)",this.valueTemplate="{value}",this.size=100,this.step=1,this.min=0,this.max=100,this.strokeWidth=14,this.showValue=!0,this.readonly=!1,this.onChange=new e.EventEmitter,this.radius=40,this.midX=50,this.midY=50,this.minRadians=4*Math.PI/3,this.maxRadians=-Math.PI/3,this.value=null,this.onModelChange=function(){},this.onModelTouched=function(){}}return t.prototype.mapRange=function(t,e,i,n,o){return(t-e)*(o-n)/(i-e)+n},t.prototype.onClick=function(t){this.disabled||this.readonly||this.updateValue(t.offsetX,t.offsetY)},t.prototype.updateValue=function(t,e){var i=t-this.size/2,n=this.size/2-e,o=Math.atan2(n,i),s=-Math.PI/2-Math.PI/6;this.updateModel(o,s)},t.prototype.updateModel=function(t,e){var i;if(t>this.maxRadians)i=this.mapRange(t,this.minRadians,this.maxRadians,this.min,this.max);else{if(!(t<e))return;i=this.mapRange(t+2*Math.PI,this.minRadians,this.maxRadians,this.min,this.max)}var n=Math.round((i-this.min)/this.step)*this.step+this.min;this.value=n,this.onModelChange(this.value),this.onChange.emit(this.value)},t.prototype.onMouseDown=function(t){this.disabled||this.readonly||(this.windowMouseMoveListener=this.onMouseMove.bind(this),this.windowMouseUpListener=this.onMouseUp.bind(this),window.addEventListener("mousemove",this.windowMouseMoveListener),window.addEventListener("mouseup",this.windowMouseUpListener),t.preventDefault())},t.prototype.onMouseUp=function(t){this.disabled||this.readonly||(window.removeEventListener("mousemove",this.windowMouseMoveListener),window.removeEventListener("mouseup",this.windowMouseUpListener),this.windowMouseUpListener=null,this.windowMouseMoveListener=null,t.preventDefault())},t.prototype.onTouchStart=function(t){this.disabled||this.readonly||(this.windowTouchMoveListener=this.onTouchMove.bind(this),this.windowTouchEndListener=this.onTouchEnd.bind(this),window.addEventListener("touchmove",this.windowTouchMoveListener),window.addEventListener("touchend",this.windowTouchEndListener),t.preventDefault())},t.prototype.onTouchEnd=function(t){this.disabled||this.readonly||(window.removeEventListener("touchmove",this.windowTouchMoveListener),window.removeEventListener("touchend",this.windowTouchEndListener),this.windowTouchMoveListener=null,this.windowTouchEndListener=null,t.preventDefault())},t.prototype.onMouseMove=function(t){this.disabled||this.readonly||(this.updateValue(t.offsetX,t.offsetY),t.preventDefault())},t.prototype.onTouchMove=function(t){if(!this.disabled&&!this.readonly&&1==t.touches.length){var e=this.el.nativeElement.children[0].getBoundingClientRect(),i=t.targetTouches.item(0),n=i.clientX-e.left,o=i.clientY-e.top;this.updateValue(n,o)}},t.prototype.writeValue=function(t){this.value=t,this.cd.markForCheck()},t.prototype.registerOnChange=function(t){this.onModelChange=t},t.prototype.registerOnTouched=function(t){this.onModelTouched=t},t.prototype.setDisabledState=function(t){this.disabled=t,this.cd.markForCheck()},t.prototype.containerClass=function(){return{"p-knob p-component":!0,"p-disabled":this.disabled}},t.prototype.rangePath=function(){return"M "+this.minX()+" "+this.minY()+" A "+this.radius+" "+this.radius+" 0 1 1 "+this.maxX()+" "+this.maxY()},t.prototype.valuePath=function(){return"M "+this.zeroX()+" "+this.zeroY()+" A "+this.radius+" "+this.radius+" 0 "+this.largeArc()+" "+this.sweep()+" "+this.valueX()+" "+this.valueY()},t.prototype.zeroRadians=function(){return this.min>0&&this.max>0?this.mapRange(this.min,this.min,this.max,this.minRadians,this.maxRadians):this.mapRange(0,this.min,this.max,this.minRadians,this.maxRadians)},t.prototype.valueRadians=function(){return this.mapRange(this._value,this.min,this.max,this.minRadians,this.maxRadians)},t.prototype.minX=function(){return this.midX+Math.cos(this.minRadians)*this.radius},t.prototype.minY=function(){return this.midY-Math.sin(this.minRadians)*this.radius},t.prototype.maxX=function(){return this.midX+Math.cos(this.maxRadians)*this.radius},t.prototype.maxY=function(){return this.midY-Math.sin(this.maxRadians)*this.radius},t.prototype.zeroX=function(){return this.midX+Math.cos(this.zeroRadians())*this.radius},t.prototype.zeroY=function(){return this.midY-Math.sin(this.zeroRadians())*this.radius},t.prototype.valueX=function(){return this.midX+Math.cos(this.valueRadians())*this.radius},t.prototype.valueY=function(){return this.midY-Math.sin(this.valueRadians())*this.radius},t.prototype.largeArc=function(){return Math.abs(this.zeroRadians()-this.valueRadians())<Math.PI?0:1},t.prototype.sweep=function(){return this.valueRadians()>this.zeroRadians()?0:1},t.prototype.valueToDisplay=function(){return this.valueTemplate.replace("{value}",this._value.toString())},Object.defineProperty(t.prototype,"_value",{get:function(){return null!=this.value?this.value:this.min},enumerable:!1,configurable:!0}),t}();s.decorators=[{type:e.Component,args:[{selector:"p-knob",template:'\n        <div [ngClass]="containerClass()" [class]="styleClass" [ngStyle]="style">\n        <svg viewBox="0 0 100 100" [style.width]="size + \'px\'" [style.height]="size + \'px\'" (click)="onClick($event)" (mousedown)="onMouseDown($event)" (mouseup)="onMouseUp($event)"\n            (touchstart)="onTouchStart($event)" (touchend)="onTouchEnd($event)">\n            <path [attr.d]="rangePath()" [attr.stroke-width]="strokeWidth" [attr.stroke]="rangeColor" class="p-knob-range"></path>\n            <path [attr.d]="valuePath()" [attr.stroke-width]="strokeWidth" [attr.stroke]="valueColor" class="p-knob-value"></path>\n            <text *ngIf="showValue" [attr.x]="50" [attr.y]="57" text-anchor="middle" [attr.fill]="textColor" class="p-knob-text" [attr.name]="name">{{valueToDisplay()}}</text>\n        </svg>\n        </div>\n    ',providers:[o],changeDetection:e.ChangeDetectionStrategy.OnPush,encapsulation:e.ViewEncapsulation.None,styles:["@keyframes dash-frame{to{stroke-dashoffset:0}}.p-knob-range{fill:none;transition:stroke .1s ease-in}.p-knob-value{animation-fill-mode:forwards;animation-name:dash-frame;fill:none}.p-knob-text{font-size:1.3rem;text-align:center}"]}]}],s.ctorParameters=function(){return[{type:e.ChangeDetectorRef},{type:e.ElementRef}]},s.propDecorators={styleClass:[{type:e.Input}],style:[{type:e.Input}],severity:[{type:e.Input}],valueColor:[{type:e.Input}],rangeColor:[{type:e.Input}],textColor:[{type:e.Input}],valueTemplate:[{type:e.Input}],name:[{type:e.Input}],size:[{type:e.Input}],step:[{type:e.Input}],min:[{type:e.Input}],max:[{type:e.Input}],strokeWidth:[{type:e.Input}],disabled:[{type:e.Input}],showValue:[{type:e.Input}],readonly:[{type:e.Input}],onChange:[{type:e.Output}]};var a=function(){};a.decorators=[{type:e.NgModule,args:[{imports:[i.CommonModule],exports:[s],declarations:[s]}]}],t.KNOB_VALUE_ACCESSOR=o,t.Knob=s,t.KnobModule=a,Object.defineProperty(t,"__esModule",{value:!0})}));
//# sourceMappingURL=primeng-knob.umd.min.js.map