!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("@angular/core"),require("@angular/common"),require("@angular/animations"),require("@angular/forms"),require("primeng/dom"),require("primeng/api"),require("primeng/inputtext")):"function"==typeof define&&define.amd?define("primeng/password",["exports","@angular/core","@angular/common","@angular/animations","@angular/forms","primeng/dom","primeng/api","primeng/inputtext"],t):t(((e="undefined"!=typeof globalThis?globalThis:e||self).primeng=e.primeng||{},e.primeng.password={}),e.ng.core,e.ng.common,e.ng.animations,e.ng.forms,e.primeng.dom,e.primeng.api,e.primeng.inputtext)}(this,(function(e,t,n,i,s,o,r,a){"use strict";var l=function(){function e(e,t){this.el=e,this.zone=t,this.promptLabel="Enter a password",this.weakLabel="Weak",this.mediumLabel="Medium",this.strongLabel="Strong",this.feedback=!0}return Object.defineProperty(e.prototype,"showPassword",{set:function(e){this.el.nativeElement.type=e?"text":"password"},enumerable:!1,configurable:!0}),e.prototype.ngDoCheck=function(){this.updateFilledState()},e.prototype.onInput=function(e){this.updateFilledState()},e.prototype.updateFilledState=function(){this.filled=this.el.nativeElement.value&&this.el.nativeElement.value.length},e.prototype.createPanel=function(){this.panel=document.createElement("div"),this.panel.className="p-password-panel p-component p-password-panel-overlay p-connected-overlay",this.meter=document.createElement("div"),this.meter.className="p-password-meter",this.info=document.createElement("div"),this.info.className="p-password-info",this.info.textContent=this.promptLabel,this.panel.appendChild(this.meter),this.panel.appendChild(this.info),this.panel.style.minWidth=o.DomHandler.getOuterWidth(this.el.nativeElement)+"px",document.body.appendChild(this.panel)},e.prototype.showOverlay=function(){var e=this;this.feedback&&(this.panel||this.createPanel(),this.panel.style.zIndex=String(++o.DomHandler.zindex),this.panel.style.display="block",this.zone.runOutsideAngular((function(){setTimeout((function(){o.DomHandler.addClass(e.panel,"p-connected-overlay-visible"),e.bindScrollListener(),e.bindDocumentResizeListener()}),1)})),o.DomHandler.absolutePosition(this.panel,this.el.nativeElement))},e.prototype.hideOverlay=function(){var e=this;this.feedback&&this.panel&&(o.DomHandler.addClass(this.panel,"p-connected-overlay-hidden"),o.DomHandler.removeClass(this.panel,"p-connected-overlay-visible"),this.unbindScrollListener(),this.unbindDocumentResizeListener(),this.zone.runOutsideAngular((function(){setTimeout((function(){e.ngOnDestroy()}),150)})))},e.prototype.onFocus=function(){this.showOverlay()},e.prototype.onBlur=function(){this.hideOverlay()},e.prototype.onKeyup=function(e){if(this.feedback){var t=e.target.value,n=null,i=null;if(0===t.length)n=this.promptLabel,i="0px 0px";else{var s=this.testStrength(t);s<30?(n=this.weakLabel,i="0px -10px"):s>=30&&s<80?(n=this.mediumLabel,i="0px -20px"):s>=80&&(n=this.strongLabel,i="0px -30px")}this.panel&&o.DomHandler.hasClass(this.panel,"p-connected-overlay-visible")||this.showOverlay(),this.meter.style.backgroundPosition=i,this.info.textContent=n}},e.prototype.testStrength=function(e){var t,n=0;return t=e.match("[0-9]"),n+=25*this.normalize(t?t.length:1/4,1),t=e.match("[a-zA-Z]"),n+=10*this.normalize(t?t.length:.5,3),t=e.match("[!@#$%^&*?_~.,;=]"),n+=35*this.normalize(t?t.length:1/6,1),t=e.match("[A-Z]"),n+=30*this.normalize(t?t.length:1/6,1),(n*=e.length/8)>100?100:n},e.prototype.normalize=function(e,t){return e-t<=0?e/t:1+e/(e+t/4)*.5},Object.defineProperty(e.prototype,"disabled",{get:function(){return this.el.nativeElement.disabled},enumerable:!1,configurable:!0}),e.prototype.bindScrollListener=function(){var e=this;this.scrollHandler||(this.scrollHandler=new o.ConnectedOverlayScrollHandler(this.el.nativeElement,(function(){o.DomHandler.hasClass(e.panel,"p-connected-overlay-visible")&&e.hideOverlay()}))),this.scrollHandler.bindScrollListener()},e.prototype.unbindScrollListener=function(){this.scrollHandler&&this.scrollHandler.unbindScrollListener()},e.prototype.bindDocumentResizeListener=function(){this.documentResizeListener=this.onWindowResize.bind(this),window.addEventListener("resize",this.documentResizeListener)},e.prototype.unbindDocumentResizeListener=function(){this.documentResizeListener&&(window.removeEventListener("resize",this.documentResizeListener),this.documentResizeListener=null)},e.prototype.onWindowResize=function(){this.hideOverlay()},e.prototype.ngOnDestroy=function(){this.panel&&(this.scrollHandler&&(this.scrollHandler.destroy(),this.scrollHandler=null),this.unbindDocumentResizeListener(),document.body.removeChild(this.panel),this.panel=null,this.meter=null,this.info=null)},e}();l.decorators=[{type:t.Directive,args:[{selector:"[pPassword]",host:{"[class.p-inputtext]":"true","[class.p-component]":"true","[class.p-filled]":"filled"}}]}],l.ctorParameters=function(){return[{type:t.ElementRef},{type:t.NgZone}]},l.propDecorators={promptLabel:[{type:t.Input}],weakLabel:[{type:t.Input}],mediumLabel:[{type:t.Input}],strongLabel:[{type:t.Input}],feedback:[{type:t.Input}],showPassword:[{type:t.Input}],onInput:[{type:t.HostListener,args:["input",["$event"]]}],onFocus:[{type:t.HostListener,args:["focus"]}],onBlur:[{type:t.HostListener,args:["blur"]}],onKeyup:[{type:t.HostListener,args:["keyup",["$event"]]}]};var p={provide:s.NG_VALUE_ACCESSOR,useExisting:t.forwardRef((function(){return u})),multi:!0},u=function(){function e(e,t){this.cd=e,this.config=t,this.mediumRegex="^(((?=.*[a-z])(?=.*[A-Z]))|((?=.*[a-z])(?=.*[0-9]))|((?=.*[A-Z])(?=.*[0-9])))(?=.{6,})",this.strongRegex="^(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9])(?=.{8,})",this.feedback=!0,this.showTransitionOptions=".12s cubic-bezier(0, 0, 0.2, 1)",this.hideTransitionOptions=".1s linear",this.overlayVisible=!1,this.focused=!1,this.unmasked=!1,this.value=null,this.onModelChange=function(){},this.onModelTouched=function(){}}return e.prototype.ngAfterContentInit=function(){var e=this;this.templates.forEach((function(t){switch(t.getType()){case"content":e.contentTemplate=t.template;break;case"header":e.headerTemplate=t.template;break;case"footer":e.footerTemplate=t.template;break;default:e.contentTemplate=t.template}}))},e.prototype.ngOnInit=function(){this.infoText=this.promptText(),this.mediumCheckRegExp=new RegExp(this.mediumRegex),this.strongCheckRegExp=new RegExp(this.strongRegex)},e.prototype.onAnimationStart=function(e){switch(e.toState){case"visible":this.overlay=e.element,this.overlay.style.zIndex=String(o.DomHandler.generateZIndex()),this.appendContainer(),this.alignOverlay(),this.bindScrollListener(),this.bindResizeListener();break;case"void":this.unbindScrollListener(),this.unbindResizeListener(),this.overlay=null}},e.prototype.appendContainer=function(){this.appendTo&&("body"===this.appendTo?document.body.appendChild(this.overlay):document.getElementById(this.appendTo).appendChild(this.overlay))},e.prototype.alignOverlay=function(){this.appendTo?(this.overlay.style.minWidth=o.DomHandler.getOuterWidth(this.input.nativeElement)+"px",o.DomHandler.absolutePosition(this.overlay,this.input.nativeElement)):o.DomHandler.relativePosition(this.overlay,this.input.nativeElement)},e.prototype.onInput=function(e){this.value=e.target.value,this.onModelChange(this.value),this.onModelTouched()},e.prototype.onFocus=function(){this.focused=!0,this.feedback&&(this.overlayVisible=!0)},e.prototype.onBlur=function(){this.focused=!1,this.feedback&&(this.overlayVisible=!1)},e.prototype.onKeyUp=function(e){if(this.feedback){var t=e.target.value;this.updateUI(t),this.overlayVisible||(this.overlayVisible=!0)}},e.prototype.updateUI=function(e){var t=null,n=null;switch(this.testStrength(e)){case 1:t=this.weakText(),n={strength:"weak",width:"33.33%"};break;case 2:t=this.mediumText(),n={strength:"medium",width:"66.66%"};break;case 3:t=this.strongText(),n={strength:"strong",width:"100%"};break;default:t=this.promptText(),n=null}this.meter=n,this.infoText=t},e.prototype.onMaskToggle=function(){this.unmasked=!this.unmasked},e.prototype.testStrength=function(e){var t=0;return this.strongCheckRegExp.test(e)?t=3:this.mediumCheckRegExp.test(e)?t=2:e.length&&(t=1),t},e.prototype.writeValue=function(e){this.value=void 0===e?null:e,this.feedback&&this.updateUI(this.value||""),this.cd.markForCheck()},e.prototype.registerOnChange=function(e){this.onModelChange=e},e.prototype.registerOnTouched=function(e){this.onModelTouched=e},e.prototype.setDisabledState=function(e){this.disabled=e},e.prototype.bindScrollListener=function(){var e=this;this.scrollHandler||(this.scrollHandler=new o.ConnectedOverlayScrollHandler(this.input.nativeElement,(function(){e.overlayVisible&&(e.overlayVisible=!1)}))),this.scrollHandler.bindScrollListener()},e.prototype.bindResizeListener=function(){var e=this;this.resizeListener||(this.resizeListener=function(){e.overlayVisible&&(e.overlayVisible=!1)},window.addEventListener("resize",this.resizeListener))},e.prototype.unbindScrollListener=function(){this.scrollHandler&&this.scrollHandler.unbindScrollListener()},e.prototype.unbindResizeListener=function(){this.resizeListener&&(window.removeEventListener("resize",this.resizeListener),this.resizeListener=null)},e.prototype.unbindOutsideClickListener=function(){this.outsideClickListener&&(document.removeEventListener("click",this.outsideClickListener),this.outsideClickListener=null)},e.prototype.containerClass=function(){return{"p-password p-component p-inputwrapper":!0,"p-input-icon-right":this.toggleMask}},e.prototype.inputFieldClass=function(){return{"p-password-input":!0,"p-disabled":this.disabled}},e.prototype.toggleIconClass=function(){return this.unmasked?"pi pi-eye-slash":"pi pi-eye"},e.prototype.strengthClass=function(){return"p-password-strength "+(this.meter?this.meter.strength:"")},e.prototype.filled=function(){return null!=this.value&&this.value.toString().length>0},e.prototype.promptText=function(){return this.promptLabel||this.getTranslation(r.TranslationKeys.PASSWORD_PROMPT)},e.prototype.weakText=function(){return this.weakLabel||this.getTranslation(r.TranslationKeys.WEAK)},e.prototype.mediumText=function(){return this.mediumLabel||this.getTranslation(r.TranslationKeys.MEDIUM)},e.prototype.strongText=function(){return this.strongLabel||this.getTranslation(r.TranslationKeys.STRONG)},e.prototype.restoreAppend=function(){this.overlay&&this.appendTo&&("body"===this.appendTo?document.body.removeChild(this.overlay):document.getElementById(this.appendTo).removeChild(this.overlay))},e.prototype.inputType=function(){return this.unmasked?"text":"password"},e.prototype.getTranslation=function(e){return this.config.getTranslation(e)},e.prototype.ngOnDestroy=function(){this.restoreAppend(),this.unbindResizeListener(),this.scrollHandler&&(this.scrollHandler.destroy(),this.scrollHandler=null)},e}();u.decorators=[{type:t.Component,args:[{selector:"p-password",template:'\n        <div [ngClass]="containerClass()" [ngStyle]="style" [class]="styleClass">\n            <input #input [attr.id]="inputId" pInputText [ngClass]="inputFieldClass()" [ngStyle]="inputStyle" [class]="inputStyleClass" [attr.type]="inputType()" [attr.placeholder]="placeholder" [value]="value" (input)="onInput($event)" (focus)="onFocus()" \n                (blur)="onBlur()" (keyup)="onKeyUp($event)" />\n            <i *ngIf="toggleMask" [ngClass]="toggleIconClass()" (click)="onMaskToggle()"></i>\n            <div #overlay *ngIf="overlayVisible" [ngClass]="\'p-password-panel p-component\'" \n                [@overlayAnimation]="{value: \'visible\', params: {showTransitionParams: showTransitionOptions, hideTransitionParams: hideTransitionOptions}}" (@overlayAnimation.start)="onAnimationStart($event)">\n                <ng-container *ngTemplateOutlet="headerTemplate"></ng-container>\n                <ng-container *ngIf="contentTemplate; else content">\n                    <ng-container *ngTemplateOutlet="contentTemplate"></ng-container>\n                </ng-container>\n                <ng-template #content>\n                    <div class="p-password-meter">\n                        <div [ngClass]="strengthClass()" [ngStyle]="{\'width\': meter ? meter.width : \'\'}"></div>\n                    </div>\n                    <div className="p-password-info">{{infoText}}</div>\n                </ng-template>\n                <ng-container *ngTemplateOutlet="footerTemplate"></ng-container>\n            </div>\n        </div>\n    ',animations:[i.trigger("overlayAnimation",[i.transition(":enter",[i.style({opacity:0,transform:"scaleY(0.8)"}),i.animate("{{showTransitionParams}}")]),i.transition(":leave",[i.animate("{{hideTransitionParams}}",i.style({opacity:0}))])])],host:{"[class.p-inputwrapper-filled]":"filled()","[class.p-inputwrapper-focus]":"focused"},providers:[p],changeDetection:t.ChangeDetectionStrategy.OnPush,encapsulation:t.ViewEncapsulation.None,styles:[".p-password{display:inline-flex;position:relative}.p-password-panel{position:absolute}.p-password .p-password-panel{min-width:100%}.p-password-meter{height:10px}.p-password-strength{height:100%;transition:width 1s ease-in-out;width:0}.p-fluid .p-password{display:flex}"]}]}],u.ctorParameters=function(){return[{type:t.ChangeDetectorRef},{type:r.PrimeNGConfig}]},u.propDecorators={disabled:[{type:t.Input}],promptLabel:[{type:t.Input}],mediumRegex:[{type:t.Input}],strongRegex:[{type:t.Input}],weakLabel:[{type:t.Input}],mediumLabel:[{type:t.Input}],strongLabel:[{type:t.Input}],inputId:[{type:t.Input}],feedback:[{type:t.Input}],appendTo:[{type:t.Input}],toggleMask:[{type:t.Input}],inputStyleClass:[{type:t.Input}],styleClass:[{type:t.Input}],style:[{type:t.Input}],inputStyle:[{type:t.Input}],showTransitionOptions:[{type:t.Input}],hideTransitionOptions:[{type:t.Input}],placeholder:[{type:t.Input}],input:[{type:t.ViewChild,args:["input"]}],templates:[{type:t.ContentChildren,args:[r.PrimeTemplate]}]};var d=function(){};d.decorators=[{type:t.NgModule,args:[{imports:[n.CommonModule,a.InputTextModule],exports:[l,u],declarations:[l,u]}]}],e.Password=u,e.PasswordDirective=l,e.PasswordModule=d,e.Password_VALUE_ACCESSOR=p,Object.defineProperty(e,"__esModule",{value:!0})}));
//# sourceMappingURL=primeng-password.umd.min.js.map