!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("@angular/core"),require("@angular/common"),require("primeng/tooltip"),require("primeng/ripple"),require("primeng/api"),require("primeng/dom")):"function"==typeof define&&define.amd?define("primeng/tabview",["exports","@angular/core","@angular/common","primeng/tooltip","primeng/ripple","primeng/api","primeng/dom"],t):t(((e="undefined"!=typeof globalThis?globalThis:e||self).primeng=e.primeng||{},e.primeng.tabview={}),e.ng.core,e.ng.common,e.primeng.tooltip,e.primeng.ripple,e.primeng.api,e.primeng.dom)}(this,(function(e,t,n,i,a,o,s){"use strict";var r=0,l=function(){function e(e,t,n){this.viewContainer=t,this.cd=n,this.cache=!0,this.tooltipPosition="top",this.tooltipPositionStyle="absolute",this.id="p-tabpanel-"+r++,this.tabView=e}return e.prototype.ngAfterContentInit=function(){var e=this;this.templates.forEach((function(t){switch(t.getType()){case"header":e.headerTemplate=t.template;break;case"content":default:e.contentTemplate=t.template}}))},Object.defineProperty(e.prototype,"selected",{get:function(){return this._selected},set:function(e){this._selected=e,this.loaded||this.cd.detectChanges(),e&&(this.loaded=!0)},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"disabled",{get:function(){return this._disabled},set:function(e){this._disabled=e,this.tabView.cd.markForCheck()},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"header",{get:function(){return this._header},set:function(e){this._header=e,this.tabView.cd.markForCheck()},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"leftIcon",{get:function(){return this._leftIcon},set:function(e){this._leftIcon=e,this.tabView.cd.markForCheck()},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"rightIcon",{get:function(){return this._rightIcon},set:function(e){this._rightIcon=e,this.tabView.cd.markForCheck()},enumerable:!1,configurable:!0}),e.prototype.ngOnDestroy=function(){this.view=null},e}();l.decorators=[{type:t.Component,args:[{selector:"p-tabPanel",template:'\n        <div [attr.id]="id" class="p-tabview-panel" [hidden]="!selected"\n            role="tabpanel" [attr.aria-hidden]="!selected" [attr.aria-labelledby]="id + \'-label\'" *ngIf="!closed">\n            <ng-content></ng-content>\n            <ng-container *ngIf="contentTemplate && (cache ? loaded : selected)">\n                <ng-container *ngTemplateOutlet="contentTemplate"></ng-container>\n            </ng-container>\n        </div>\n    '}]}],l.ctorParameters=function(){return[{type:void 0,decorators:[{type:t.Inject,args:[t.forwardRef((function(){return p}))]}]},{type:t.ViewContainerRef},{type:t.ChangeDetectorRef}]},l.propDecorators={closable:[{type:t.Input}],headerStyle:[{type:t.Input}],headerStyleClass:[{type:t.Input}],cache:[{type:t.Input}],tooltip:[{type:t.Input}],tooltipPosition:[{type:t.Input}],tooltipPositionStyle:[{type:t.Input}],tooltipStyleClass:[{type:t.Input}],templates:[{type:t.ContentChildren,args:[o.PrimeTemplate]}],selected:[{type:t.Input}],disabled:[{type:t.Input}],header:[{type:t.Input}],leftIcon:[{type:t.Input}],rightIcon:[{type:t.Input}]};var p=function(){function e(e,n){this.el=e,this.cd=n,this.orientation="top",this.onChange=new t.EventEmitter,this.onClose=new t.EventEmitter,this.activeIndexChange=new t.EventEmitter}return e.prototype.ngAfterContentInit=function(){var e=this;this.initTabs(),this.tabPanels.changes.subscribe((function(t){e.initTabs()}))},e.prototype.ngAfterViewChecked=function(){this.tabChanged&&(this.updateInkBar(),this.tabChanged=!1)},e.prototype.initTabs=function(){this.tabs=this.tabPanels.toArray(),!this.findSelectedTab()&&this.tabs.length&&(null!=this.activeIndex&&this.tabs.length>this.activeIndex?this.tabs[this.activeIndex].selected=!0:this.tabs[0].selected=!0,this.tabChanged=!0),this.cd.markForCheck()},e.prototype.open=function(e,t){if(t.disabled)e&&e.preventDefault();else{if(!t.selected){var n=this.findSelectedTab();n&&(n.selected=!1),this.tabChanged=!0,t.selected=!0;var i=this.findTabIndex(t);this.preventActiveIndexPropagation=!0,this.activeIndexChange.emit(i),this.onChange.emit({originalEvent:e,index:i})}e&&e.preventDefault()}},e.prototype.close=function(e,t){var n=this;this.controlClose?this.onClose.emit({originalEvent:e,index:this.findTabIndex(t),close:function(){n.closeTab(t)}}):(this.closeTab(t),this.onClose.emit({originalEvent:e,index:this.findTabIndex(t)})),e.stopPropagation()},e.prototype.closeTab=function(e){if(!e.disabled){if(e.selected){this.tabChanged=!0,e.selected=!1;for(var t=0;t<this.tabs.length;t++){var n=this.tabs[t];if(!n.closed&&!e.disabled){n.selected=!0;break}}}e.closed=!0}},e.prototype.findSelectedTab=function(){for(var e=0;e<this.tabs.length;e++)if(this.tabs[e].selected)return this.tabs[e];return null},e.prototype.findTabIndex=function(e){for(var t=-1,n=0;n<this.tabs.length;n++)if(this.tabs[n]==e){t=n;break}return t},e.prototype.getBlockableElement=function(){return this.el.nativeElement.children[0]},Object.defineProperty(e.prototype,"activeIndex",{get:function(){return this._activeIndex},set:function(e){this._activeIndex=e,this.preventActiveIndexPropagation?this.preventActiveIndexPropagation=!1:this.tabs&&this.tabs.length&&null!=this._activeIndex&&this.tabs.length>this._activeIndex&&(this.findSelectedTab().selected=!1,this.tabs[this._activeIndex].selected=!0,this.tabChanged=!0)},enumerable:!1,configurable:!0}),e.prototype.updateInkBar=function(){var e=s.DomHandler.findSingle(this.navbar.nativeElement,"li.p-highlight");this.inkbar.nativeElement.style.width=s.DomHandler.getWidth(e)+"px",this.inkbar.nativeElement.style.left=s.DomHandler.getOffset(e).left-s.DomHandler.getOffset(this.navbar.nativeElement).left+"px"},e}();p.decorators=[{type:t.Component,args:[{selector:"p-tabView",template:'\n        <div [ngClass]="\'p-tabview p-component\'" [ngStyle]="style" [class]="styleClass">\n            <ul #navbar class="p-tabview-nav" role="tablist">\n                <ng-template ngFor let-tab [ngForOf]="tabs">\n                    <li role="presentation" [ngClass]="{\'p-highlight\': tab.selected, \'p-disabled\': tab.disabled}" [ngStyle]="tab.headerStyle" [class]="tab.headerStyleClass" *ngIf="!tab.closed">\n                        <a role="tab" class="p-tabview-nav-link" [attr.id]="tab.id + \'-label\'" [attr.aria-selected]="tab.selected" [attr.aria-controls]="tab.id" [pTooltip]="tab.tooltip" [tooltipPosition]="tab.tooltipPosition"\n                            [attr.aria-selected]="tab.selected" [positionStyle]="tab.tooltipPositionStyle" [tooltipStyleClass]="tab.tooltipStyleClass"\n                            (click)="open($event,tab)" (keydown.enter)="open($event,tab)" pRipple [attr.tabindex]="tab.disabled ? null : \'0\'">\n                            <ng-container *ngIf="!tab.headerTemplate">\n                                <span class="p-tabview-left-icon" [ngClass]="tab.leftIcon" *ngIf="tab.leftIcon"></span>\n                                <span class="p-tabview-title">{{tab.header}}</span>\n                                <span class="p-tabview-right-icon" [ngClass]="tab.rightIcon" *ngIf="tab.rightIcon"></span>\n                            </ng-container>\n                            <ng-container *ngTemplateOutlet="tab.headerTemplate"></ng-container>\n                            <span *ngIf="tab.closable" class="p-tabview-close pi pi-times" (click)="close($event,tab)"></span>\n                        </a>\n                    </li>\n                </ng-template>\n                <li #inkbar class="p-tabview-ink-bar"></li>\n            </ul>\n            <div class="p-tabview-panels">\n                <ng-content></ng-content>\n            </div>\n        </div>\n    ',changeDetection:t.ChangeDetectionStrategy.OnPush,encapsulation:t.ViewEncapsulation.None,styles:[".p-tabview-nav{display:flex;flex-wrap:wrap;list-style-type:none;margin:0;padding:0}.p-tabview-nav-link{-ms-user-select:none;-webkit-user-select:none;align-items:center;cursor:pointer;display:flex;overflow:hidden;position:relative;text-decoration:none;user-select:none}.p-tabview-ink-bar{display:none;z-index:1}.p-tabview-nav-link:focus{z-index:1}.p-tabview-title{line-height:1}.p-tabview-close{z-index:1}"]}]}],p.ctorParameters=function(){return[{type:t.ElementRef},{type:t.ChangeDetectorRef}]},p.propDecorators={orientation:[{type:t.Input}],style:[{type:t.Input}],styleClass:[{type:t.Input}],controlClose:[{type:t.Input}],navbar:[{type:t.ViewChild,args:["navbar"]}],inkbar:[{type:t.ViewChild,args:["inkbar"]}],tabPanels:[{type:t.ContentChildren,args:[l]}],onChange:[{type:t.Output}],onClose:[{type:t.Output}],activeIndexChange:[{type:t.Output}],activeIndex:[{type:t.Input}]};var c=function(){};c.decorators=[{type:t.NgModule,args:[{imports:[n.CommonModule,o.SharedModule,i.TooltipModule,a.RippleModule],exports:[p,l,o.SharedModule],declarations:[p,l]}]}],e.TabPanel=l,e.TabView=p,e.TabViewModule=c,Object.defineProperty(e,"__esModule",{value:!0})}));
//# sourceMappingURL=primeng-tabview.umd.min.js.map