import { ElementRef, OnInit, AfterContentInit, EventEmitter, QueryList, TemplateRef, OnChanges, SimpleChanges, ChangeDetectorRef, OnDestroy } from '@angular/core';
import { FilterService, PrimeNGConfig } from 'primeng/api';
import { BlockableUI } from 'primeng/api';
import { Subscription } from 'rxjs';
export declare class DataView implements OnInit, AfterContentInit, OnDestroy, BlockableUI, OnChanges {
    el: ElementRef;
    cd: ChangeDetectorRef;
    filterService: FilterService;
    config: PrimeNGConfig;
    paginator: boolean;
    rows: number;
    totalRecords: number;
    pageLinks: number;
    rowsPerPageOptions: any[];
    paginatorPosition: string;
    alwaysShowPaginator: boolean;
    paginatorDropdownAppendTo: any;
    paginatorDropdownScrollHeight: string;
    currentPageReportTemplate: string;
    showCurrentPageReport: boolean;
    showJumpToPageDropdown: boolean;
    showFirstLastIcon: boolean;
    showPageLinks: boolean;
    lazy: boolean;
    emptyMessage: string;
    onLazyLoad: EventEmitter<any>;
    style: any;
    styleClass: string;
    trackBy: Function;
    filterBy: string;
    filterLocale: string;
    loading: boolean;
    loadingIcon: string;
    first: number;
    sortField: string;
    sortOrder: number;
    value: any[];
    onPage: EventEmitter<any>;
    onSort: EventEmitter<any>;
    onChangeLayout: EventEmitter<any>;
    header: any;
    footer: any;
    templates: QueryList<any>;
    _value: any[];
    listItemTemplate: TemplateRef<any>;
    gridItemTemplate: TemplateRef<any>;
    itemTemplate: TemplateRef<any>;
    headerTemplate: TemplateRef<any>;
    emptyMessageTemplate: TemplateRef<any>;
    footerTemplate: TemplateRef<any>;
    paginatorLeftTemplate: TemplateRef<any>;
    paginatorRightTemplate: TemplateRef<any>;
    paginatorDropdownItemTemplate: TemplateRef<any>;
    filteredValue: any[];
    filterValue: string;
    initialized: boolean;
    _layout: string;
    translationSubscription: Subscription;
    get layout(): string;
    set layout(layout: string);
    constructor(el: ElementRef, cd: ChangeDetectorRef, filterService: FilterService, config: PrimeNGConfig);
    ngOnInit(): void;
    ngOnChanges(simpleChanges: SimpleChanges): void;
    ngAfterContentInit(): void;
    updateItemTemplate(): void;
    changeLayout(layout: string): void;
    updateTotalRecords(): void;
    paginate(event: any): void;
    sort(): void;
    isEmpty(): boolean;
    createLazyLoadMetadata(): any;
    getBlockableElement(): HTMLElement;
    get emptyMessageLabel(): string;
    filter(filter: string, filterMatchMode?: string): void;
    hasFilter(): boolean;
    ngOnDestroy(): void;
}
export declare class DataViewLayoutOptions {
    dv: DataView;
    style: any;
    styleClass: string;
    constructor(dv: DataView);
    changeLayout(event: Event, layout: string): void;
}
export declare class DataViewModule {
}
