import { ElementRef, AfterViewChecked, AfterContentInit, QueryList, TemplateRef, EventEmitter, ChangeDetectorRef } from '@angular/core';
import { FilterService } from 'primeng/api';
import { CdkDragDrop } from '@angular/cdk/drag-drop';
export declare class OrderList implements AfterViewChecked, AfterContentInit {
    el: ElementRef;
    cd: ChangeDetectorRef;
    filterService: FilterService;
    header: string;
    style: any;
    styleClass: string;
    listStyle: any;
    responsive: boolean;
    filterBy: string;
    filterPlaceholder: string;
    filterLocale: string;
    metaKeySelection: boolean;
    dragdrop: boolean;
    controlsPosition: string;
    ariaFilterLabel: string;
    filterMatchMode: string;
    breakpoint: string;
    selectionChange: EventEmitter<any>;
    trackBy: Function;
    onReorder: EventEmitter<any>;
    onSelectionChange: EventEmitter<any>;
    onFilterEvent: EventEmitter<any>;
    listViewChild: ElementRef;
    templates: QueryList<any>;
    itemTemplate: TemplateRef<any>;
    headerTemplate: TemplateRef<any>;
    emptyMessageTemplate: TemplateRef<any>;
    emptyFilterMessageTemplate: TemplateRef<any>;
    _selection: any[];
    movedUp: boolean;
    movedDown: boolean;
    itemTouched: boolean;
    styleElement: any;
    id: string;
    filterValue: string;
    visibleOptions: any[];
    _value: any[];
    constructor(el: ElementRef, cd: ChangeDetectorRef, filterService: FilterService);
    get selection(): any[];
    set selection(val: any[]);
    ngOnInit(): void;
    ngAfterContentInit(): void;
    ngAfterViewChecked(): void;
    get value(): any[];
    set value(val: any[]);
    onItemClick(event: any, item: any, index: any): void;
    onFilterKeyup(event: any): void;
    filter(): void;
    isItemVisible(item: any): boolean;
    onItemTouchEnd(): void;
    isSelected(item: any): boolean;
    isEmpty(): boolean;
    moveUp(): void;
    moveTop(): void;
    moveDown(): void;
    moveBottom(): void;
    onDrop(event: CdkDragDrop<string[]>): void;
    onItemKeydown(event: KeyboardEvent, item: any, index: Number): void;
    findNextItem(item: any): any;
    findPrevItem(item: any): any;
    createStyle(): void;
    destroyStyle(): void;
    ngOnDestroy(): void;
}
export declare class OrderListModule {
}
