import { ElementRef, AfterViewInit, AfterViewChecked, EventEmitter, QueryList, TemplateRef, Renderer, ChangeDetectorRef } from '@angular/core';
import { DomHandler } from '../dom/domhandler';
import { ObjectUtils } from '../utils/ObjectUtils';
import { ControlValueAccessor } from '@angular/forms';
export declare const AUTOCOMPLETE_VALUE_ACCESSOR: any;
export declare class AutoComplete implements AfterViewInit, AfterViewChecked, ControlValueAccessor {
    el: ElementRef;
    domHandler: DomHandler;
    renderer: Renderer;
    objectUtils: ObjectUtils;
    cd: ChangeDetectorRef;
    minLength: number;
    delay: number;
    style: any;
    styleClass: string;
    inputStyle: any;
    inputId: string;
    inputStyleClass: string;
    placeholder: string;
    readonly: boolean;
    disabled: boolean;
    maxlength: number;
    size: number;
    appendTo: any;
    autoHighlight: boolean;
    type: string;
    completeMethod: EventEmitter<any>;
    onSelect: EventEmitter<any>;
    onUnselect: EventEmitter<any>;
    onFocus: EventEmitter<any>;
    onBlur: EventEmitter<any>;
    onDropdownClick: EventEmitter<any>;
    field: string;
    scrollHeight: string;
    dropdown: boolean;
    multiple: boolean;
    tabindex: number;
    dataKey: string;
    emptyMessage: string;
    inputEL: ElementRef;
    multiInputEL: ElementRef;
    panelEL: ElementRef;
    multiContainerEL: ElementRef;
    templates: QueryList<any>;
    itemTemplate: TemplateRef<any>;
    selectedItemTemplate: TemplateRef<any>;
    value: any;
    _suggestions: any[];
    onModelChange: Function;
    onModelTouched: Function;
    timeout: any;
    differ: any;
    panelVisible: boolean;
    documentClickListener: any;
    suggestionsUpdated: boolean;
    highlightOption: any;
    highlightOptionChanged: boolean;
    focus: boolean;
    filled: boolean;
    inputClick: boolean;
    noResults: boolean;
    constructor(el: ElementRef, domHandler: DomHandler, renderer: Renderer, objectUtils: ObjectUtils, cd: ChangeDetectorRef);
    suggestions: any[];
    ngAfterContentInit(): void;
    ngAfterViewInit(): void;
    ngAfterViewChecked(): void;
    writeValue(value: any): void;
    registerOnChange(fn: Function): void;
    registerOnTouched(fn: Function): void;
    setDisabledState(val: boolean): void;
    onInput(event: KeyboardEvent): void;
    onInputClick(event: MouseEvent): void;
    search(event: any, query: string): void;
    selectItem(option: any): void;
    show(): void;
    align(): void;
    hide(): void;
    handleDropdownClick(event: any): void;
    focusInput(): void;
    removeItem(item: any): void;
    onKeydown(event: any): void;
    onInputFocus(event: any): void;
    onInputBlur(event: any): void;
    isSelected(val: any): boolean;
    findOptionIndex(option: any): number;
    updateFilledState(): void;
    ngOnDestroy(): void;
}
export declare class AutoCompleteModule {
}
