import { ElementRef, AfterViewChecked, AfterContentInit, QueryList, TemplateRef, EventEmitter } from '@angular/core';
import { DomHandler } from '../dom/domhandler';
import { ObjectUtils } from '../utils/objectutils';
export declare class OrderList implements AfterViewChecked, AfterContentInit {
    el: ElementRef;
    domHandler: DomHandler;
    objectUtils: ObjectUtils;
    header: string;
    style: any;
    styleClass: string;
    listStyle: any;
    responsive: boolean;
    filterBy: string;
    filterPlaceholder: string;
    metaKeySelection: boolean;
    dragdrop: boolean;
    dragdropScope: string;
    onReorder: EventEmitter<any>;
    onSelectionChange: EventEmitter<any>;
    onFilterEvent: EventEmitter<any>;
    listViewChild: ElementRef;
    templates: QueryList<any>;
    itemTemplate: TemplateRef<any>;
    selectedItems: any[];
    movedUp: boolean;
    movedDown: boolean;
    listContainer: any;
    itemTouched: boolean;
    draggedItemIndex: number;
    dragOverItemIndex: number;
    dragging: boolean;
    filterValue: string;
    visibleOptions: any[];
    _value: any[];
    constructor(el: ElementRef, domHandler: DomHandler, objectUtils: ObjectUtils);
    ngAfterViewInit(): void;
    ngAfterContentInit(): void;
    ngAfterViewChecked(): void;
    value: any[];
    onItemClick(event: any, item: any, index: any): void;
    selectItem(item: any, index: any): void;
    onFilterKeyup(event: any): void;
    filter(): void;
    isItemVisible(item: any): boolean;
    onItemTouchEnd(event: any): void;
    isSelected(item: any): boolean;
    moveUp(event: any, listElement: any): void;
    moveTop(event: any, listElement: any): void;
    moveDown(event: any, listElement: any): void;
    moveBottom(event: any, listElement: any): void;
    onDragStart(event: DragEvent, index: number): void;
    onDragOver(event: DragEvent, index: number): void;
    onDragLeave(event: DragEvent, index: number): void;
    onDrop(event: DragEvent, index: number): void;
    onDragEnd(event: DragEvent): void;
    onListMouseMove(event: MouseEvent): void;
}
export declare class OrderListModule {
}
