import { OnInit, OnDestroy, EventEmitter, TemplateRef, AfterViewInit, AfterContentInit, QueryList, ElementRef, NgZone } from '@angular/core';
import { DomSanitizer } from '@angular/platform-browser';
import { DomHandler } from '../dom/domhandler';
import { Message } from '../common/message';
import { BlockableUI } from '../common/blockableui';
export declare class FileUpload implements OnInit, AfterViewInit, AfterContentInit, OnDestroy, BlockableUI {
    private el;
    domHandler: DomHandler;
    sanitizer: DomSanitizer;
    zone: NgZone;
    name: string;
    url: string;
    method: string;
    multiple: boolean;
    accept: string;
    disabled: boolean;
    auto: boolean;
    withCredentials: boolean;
    maxFileSize: number;
    invalidFileSizeMessageSummary: string;
    invalidFileSizeMessageDetail: string;
    invalidFileTypeMessageSummary: string;
    invalidFileTypeMessageDetail: string;
    style: string;
    styleClass: string;
    previewWidth: number;
    chooseLabel: string;
    uploadLabel: string;
    cancelLabel: string;
    showUploadButton: boolean;
    showCancelButton: boolean;
    mode: string;
    customUpload: boolean;
    onBeforeUpload: EventEmitter<any>;
    onBeforeSend: EventEmitter<any>;
    onUpload: EventEmitter<any>;
    onError: EventEmitter<any>;
    onClear: EventEmitter<any>;
    onRemove: EventEmitter<any>;
    onSelect: EventEmitter<any>;
    onProgress: EventEmitter<any>;
    uploadHandler: EventEmitter<any>;
    templates: QueryList<any>;
    advancedFileInput: ElementRef;
    basicFileInput: ElementRef;
    content: ElementRef;
    files: File[];
    progress: number;
    dragHighlight: boolean;
    msgs: Message[];
    fileTemplate: TemplateRef<any>;
    contentTemplate: TemplateRef<any>;
    toolbarTemplate: TemplateRef<any>;
    focus: boolean;
    duplicateIEEvent: boolean;
    constructor(el: ElementRef, domHandler: DomHandler, sanitizer: DomSanitizer, zone: NgZone);
    ngOnInit(): void;
    ngAfterContentInit(): void;
    ngAfterViewInit(): void;
    onFileSelect(event: any): void;
    isFileSelected(file: File): boolean;
    isIE11(): boolean;
    validate(file: File): boolean;
    private isFileTypeValid(file);
    getTypeClass(fileType: string): string;
    isWildcard(fileType: string): boolean;
    getFileExtension(file: File): string;
    isImage(file: File): boolean;
    onImageLoad(img: any): void;
    upload(): void;
    clear(): void;
    remove(event: Event, index: number): void;
    clearInputElement(): void;
    clearIEInput(): void;
    hasFiles(): boolean;
    onDragEnter(e: any): void;
    onDragOver(e: any): void;
    onDragLeave(event: any): void;
    onDrop(event: any): void;
    onFocus(): void;
    onBlur(): void;
    formatSize(bytes: any): string;
    onSimpleUploaderClick(event: Event): void;
    getBlockableElement(): HTMLElement;
    ngOnDestroy(): void;
}
export declare class FileUploadModule {
}
