# @primer/css

## 17.9.0

### Minor Changes

- [#1575](https://github.com/primer/css/pull/1575) [`c7ea6448`](https://github.com/primer/css/commit/c7ea6448c114065627299db7ba65418799d4a59b) Thanks [@jonrohan](https://github.com/jonrohan)! - Replacing deprecated variables with color v2 variables

* [#1573](https://github.com/primer/css/pull/1573) [`386dfa01`](https://github.com/primer/css/commit/386dfa0145a64e2c6edbdf8ab09d9fc3f7151f6a) Thanks [@simurai](https://github.com/simurai)! - Improve the font stack on Windows

  - `Segoe UI Variable` -> `Segoe UI Variable Text`.
    - "Segoe UI Variable Text" seems to be the better option for a lot of text (markdown). In the future we might can consider having a UI and a "text" font stack.
  - Add `Meiryo` before `system-ui`.
    - This should have the effect that the browser will use `Meiryo` instead of `Yu Gothic UI` and should improve font rendering, especially for Japanese.
    - Note: In an earlier version, `Yu Gothic` was used. But with great [feedback](https://twitter.com/448jp/status/1435087523185758212) from @448jp and @hiloki https://github.com/primer/css/pull/1573#issuecomment-913973890 it seems `Meiryo` is the better default.

- [#1581](https://github.com/primer/css/pull/1581) [`be518b80`](https://github.com/primer/css/commit/be518b8023b56802b1fc67ccc8a5b8398d1b279c) Thanks [@jonrohan](https://github.com/jonrohan)! - Updating deprecations.js file to be more straightforward

* [#1579](https://github.com/primer/css/pull/1579) [`c3b4a0c3`](https://github.com/primer/css/commit/c3b4a0c36302af7bb06ca996f37a63470ab99c62) Thanks [@jonrohan](https://github.com/jonrohan)! - Removing v2 color mode css var fallbacks. `var(--color-v2, var(--color-v1))` becomes `var(--color-v2)`

## 17.8.0

### Minor Changes

- [#1567](https://github.com/primer/css/pull/1567) [`ab72486f`](https://github.com/primer/css/commit/ab72486f62d0f7e2397e3f0953fbcc4c46f5ef25) Thanks [@colebemis](https://github.com/colebemis)! - Remove `base/modes-v2.scss` file

* [#1567](https://github.com/primer/css/pull/1567) [`ab72486f`](https://github.com/primer/css/commit/ab72486f62d0f7e2397e3f0953fbcc4c46f5ef25) Thanks [@colebemis](https://github.com/colebemis)! - Bumps `@primer/primitives` to [v4.7.0](https://github.com/primer/primitives/releases/tag/v4.7.0) which includes new [functional color system variables]

- [#1567](https://github.com/primer/css/pull/1567) [`ab72486f`](https://github.com/primer/css/commit/ab72486f62d0f7e2397e3f0953fbcc4c46f5ef25) Thanks [@colebemis](https://github.com/colebemis)! - Output `dark_high_contrast` theme variables from `base/modes.scss`

## 17.7.0

### Minor Changes

- [#1555](https://github.com/primer/css/pull/1555) [`4ae2174e`](https://github.com/primer/css/commit/4ae2174e33d3bd9be418176af4de75dd97b761c5) Thanks [@jonrohan](https://github.com/jonrohan)! - Add `.wb-break-word` class to existing `.break-word`

### Patch Changes

- [#1563](https://github.com/primer/css/pull/1563) [`679d70b5`](https://github.com/primer/css/commit/679d70b579c5203079e6a0559fe9dccbfcf0acae) Thanks [@simurai](https://github.com/simurai)! - Revert `TimelineItem-badge` fix

## 17.6.2

### Patch Changes

- [#1556](https://github.com/primer/css/pull/1556) [`3ad13aba`](https://github.com/primer/css/commit/3ad13abac3deccc768af0ba5eb90f1365eb977f3) Thanks [@simurai](https://github.com/simurai)! - Fix TimelineItem--condensed background

* [#1552](https://github.com/primer/css/pull/1552) [`966de4ee`](https://github.com/primer/css/commit/966de4ee0f1cfcd5f5a9f75560460adaafd47f06) Thanks [@simurai](https://github.com/simurai)! - Fix `code` in headers

## 17.6.1

### Patch Changes

- [#1550](https://github.com/primer/css/pull/1550) [`8a684ee4`](https://github.com/primer/css/commit/8a684ee4d1572de543aef2f11d4756f6fdfda638) Thanks [@simurai](https://github.com/simurai)! - Add gradient hack to TimelineItem-badge

## 17.6.0

### Minor Changes

- [#1529](https://github.com/primer/css/pull/1529) [`dca8e0ae`](https://github.com/primer/css/commit/dca8e0aeccb326c2bafff1ec86a912987b224f32) Thanks [@vdepizzol](https://github.com/vdepizzol)! - Improve font rendering on Linux

### Patch Changes

- [#1540](https://github.com/primer/css/pull/1540) [`6b6e89a8`](https://github.com/primer/css/commit/6b6e89a8bff2319ef75d25217dafc272a5e597f0) Thanks [@joelhawksley](https://github.com/joelhawksley)! - Use standard lifecyle milestones for statuses.

* [#1528](https://github.com/primer/css/pull/1528) [`303cacae`](https://github.com/primer/css/commit/303cacae77244a9e0de02b4caee2a8c01097aced) Thanks [@koddsson](https://github.com/koddsson)! - Convert package to a ES module

## 17.5.2

### Patch Changes

- [#1519](https://github.com/primer/css/pull/1519) [`8bfe2b7e`](https://github.com/primer/css/commit/8bfe2b7e410bb2a9e5f5d480b36ef885be1d98da) Thanks [@jonrohan](https://github.com/jonrohan)! - Fix bug where outline was showing up on hover

* [#1525](https://github.com/primer/css/pull/1525) [`06f83622`](https://github.com/primer/css/commit/06f8362209ccb9d0bf8cc47f9ef76a1237a2dfd0) Thanks [@joelhawksley](https://github.com/joelhawksley)! - Render `code` at 100% font size irregardless of direct descension from `pre`.

## 17.5.1

### Patch Changes

- [#1517](https://github.com/primer/css/pull/1517) [`7011d046`](https://github.com/primer/css/commit/7011d0469ee012b93a29eff5c4f0f45357aa02fc) Thanks [@simurai](https://github.com/simurai)! - Remove background from .note

## 17.5.0

### Minor Changes

- [#1506](https://github.com/primer/css/pull/1506) [`13cda226`](https://github.com/primer/css/commit/13cda22638cefe6847b1d718ba87a3f62a8ec3bb) Thanks [@jonrohan](https://github.com/jonrohan)! - Creating `.Header-input` class for dark header inputs. This `Header-input` will be used with a `form-control` class.

### Patch Changes

- [#1507](https://github.com/primer/css/pull/1507) [`30523d64`](https://github.com/primer/css/commit/30523d6436e7ea06fa511fa9ba8407429e667b42) Thanks [@simurai](https://github.com/simurai)! - Fix form tooltip transparency

* [#1510](https://github.com/primer/css/pull/1510) [`d1ea5c2c`](https://github.com/primer/css/commit/d1ea5c2c738ae4763dadf7994a9e78c196842bc3) Thanks [@jonrohan](https://github.com/jonrohan)! - Adding focus outline to the invisible buttons `.btn-invisible` and `.close-button`.

## 17.4.0

### Minor Changes

- [#1497](https://github.com/primer/css/pull/1497) [`84bbd501`](https://github.com/primer/css/commit/84bbd501a41c455031d4a1b4d25df6fc6db6e1d8) Thanks [@tobiasahlin](https://github.com/tobiasahlin)! - Add font-weight-medium to marketing styles, and use it in the type scale.

* [#1487](https://github.com/primer/css/pull/1487) [`0298b69b`](https://github.com/primer/css/commit/0298b69bda4c25ed252fbeb6ba2e3fcf4ff096d2) Thanks [@arzg](https://github.com/arzg)! - Move Menlo before Consolas in monospace font stack

### Patch Changes

- [#1483](https://github.com/primer/css/pull/1483) [`84488397`](https://github.com/primer/css/commit/84488397f4a7bce115e2c81b388de959fff20296) Thanks [@jonrohan](https://github.com/jonrohan)! - Make sure truncate is a direct child

* [#1486](https://github.com/primer/css/pull/1486) [`f52d40cc`](https://github.com/primer/css/commit/f52d40cce57bca5a713d0b9d1136f144577cf66d) Thanks [@manuelpuyol](https://github.com/manuelpuyol)! - Prevents main content to blowout and cause an horizontal scroll

- [#1488](https://github.com/primer/css/pull/1488) [`c345bd38`](https://github.com/primer/css/commit/c345bd3819cf8d42552409baf3ec4ccb59c50107) Thanks [@cheshire137](https://github.com/cheshire137)! - Fix unreadable text when utility is used in dropdown item.

* [#1501](https://github.com/primer/css/pull/1501) [`e072734a`](https://github.com/primer/css/commit/e072734aa18813622ea22e8f9c3e602ec7309105) Thanks [@tobiasahlin](https://github.com/tobiasahlin)! - Documentation: Remove deprecated faded borders documentation

- [#1472](https://github.com/primer/css/pull/1472) [`8541ed1d`](https://github.com/primer/css/commit/8541ed1db1e0d9c4551ea76ba400d6d0cf682897) Thanks [@simurai](https://github.com/simurai)! - Use variable for the active border of the UnderlineNav

* [#1475](https://github.com/primer/css/pull/1475) [`105296c6`](https://github.com/primer/css/commit/105296c6b4b33d9e84038173bf9af09889a99dcd) Thanks [@simurai](https://github.com/simurai)! - Make `TimelineItem-badge--success` ready for Color Modes V2

- [#1452](https://github.com/primer/css/pull/1452) [`8838a3ac`](https://github.com/primer/css/commit/8838a3ac48ec1589594291313349f49737317b5d) Thanks [@mktcode](https://github.com/mktcode)! - Division using / is deprecated. Replaced it with multiplications.

* [#1499](https://github.com/primer/css/pull/1499) [`2e580a7e`](https://github.com/primer/css/commit/2e580a7ed46fb06786b84f5b1900c8e0cd7450f5) Thanks [@mjacobus](https://github.com/mjacobus)! - Fix label contrast when inside a dropdown

## 17.3.0

### Minor Changes

- [#1451](https://github.com/primer/css/pull/1451) [`9181b479`](https://github.com/primer/css/commit/9181b479a812bf0b4cbf89d838abf53ffba7932d) Thanks [@simurai](https://github.com/simurai)! - Support SF Mono font in Firefox and Safari

* [#1441](https://github.com/primer/css/pull/1441) [`3b552c77`](https://github.com/primer/css/commit/3b552c77af931ba67920a97dbea59acf5d800335) Thanks [@jonrohan](https://github.com/jonrohan)! - Adding anim-hover-grow to replace hover-grow

### Patch Changes

- [#1450](https://github.com/primer/css/pull/1450) [`1d366c4b`](https://github.com/primer/css/commit/1d366c4b2c11f9541063bb62e7a8ad389b3d6567) Thanks [@jonrohan](https://github.com/jonrohan)! - Adding fill mode forwards to anim-fade-out

* [#1448](https://github.com/primer/css/pull/1448) [`8175f884`](https://github.com/primer/css/commit/8175f884474b5e5139cb1647df71200a69c48535) Thanks [@simurai](https://github.com/simurai)! - Replace auto and fade variables

- [#1432](https://github.com/primer/css/pull/1432) [`55ca5f2f`](https://github.com/primer/css/commit/55ca5f2f7300e016516f9457248b055b2c56f7fd) Thanks [@manuelpuyol](https://github.com/manuelpuyol)! - Fix Layout ordering when using dividers with custom sidebar placement

* [#1443](https://github.com/primer/css/pull/1443) [`c65b5f9c`](https://github.com/primer/css/commit/c65b5f9cf01f024f5f7120a5e80c2acd1d2584f6) Thanks [@jdanyow](https://github.com/jdanyow)! - Fix octicon color for disabled .btn-danger

- [#1442](https://github.com/primer/css/pull/1442) [`6c22133a`](https://github.com/primer/css/commit/6c22133ae1652bafb16ba443169c179b95bf4330) Thanks [@jdanyow](https://github.com/jdanyow)! - Fix octicon color for disabled .btn-primary

## 17.2.1

### Patch Changes

- [#1430](https://github.com/primer/css/pull/1430) [`5bc54f9e`](https://github.com/primer/css/commit/5bc54f9e3b5e764e44f34072a00208870c518f11) Thanks [@jonrohan](https://github.com/jonrohan)! - Revert "Support SF Mono font in Firefox and Safari"

## 17.2.0

### Minor Changes

- [#992](https://github.com/primer/css/pull/992) [`90f95693`](https://github.com/primer/css/commit/90f95693f5cbfb9f6b7b84735bf5dce2e382601b) Thanks [@simurai](https://github.com/simurai)! - Support SF Mono font in Firefox & Safari

### Patch Changes

- [#1423](https://github.com/primer/css/pull/1423) [`6f79bfaa`](https://github.com/primer/css/commit/6f79bfaa7a6fab551fe3e795eda24908c2bf0d2e) Thanks [@jonrohan](https://github.com/jonrohan)! - Properly calculating the variables computed value for dist folder

* [#1427](https://github.com/primer/css/pull/1427) [`6dad1784`](https://github.com/primer/css/commit/6dad17845f1ea345c692f56ecbf8edd60187f80d) Thanks [@jonrohan](https://github.com/jonrohan)! - Don't require direct version of primitives

- [#1422](https://github.com/primer/css/pull/1422) [`882c570f`](https://github.com/primer/css/commit/882c570f9ac38dc213e213b2e98ef4686eb693e2) Thanks [@manuelpuyol](https://github.com/manuelpuyol)! - Improve dividers and allow sidebar positioning when `Layout` is flowing as row.

* [#1420](https://github.com/primer/css/pull/1420) [`55302dc2`](https://github.com/primer/css/commit/55302dc232cb5cd28c52047a0776549f298a90ce) Thanks [@hpalacio](https://github.com/hpalacio)! - lists.scss: reset `<ol>` without 'type' attr to "decimal"

- [#1424](https://github.com/primer/css/pull/1424) [`30597af9`](https://github.com/primer/css/commit/30597af94da40875a2741f9f4ecc786f8916167c) Thanks [@khiga8](https://github.com/khiga8)! - Ensures that the visual slash separator for breadcrumbs is not announced by screenreaders.

## 17.1.1

### Patch Changes

- [#1418](https://github.com/primer/css/pull/1418) [`a9a61ee6`](https://github.com/primer/css/commit/a9a61ee690f4fff3a7e2e932dc8da5e9cd6cf702) Thanks [@simurai](https://github.com/simurai)! - Undeprecate .css-truncate

## 17.1.0

### Minor Changes

- [#1409](https://github.com/primer/css/pull/1409) [`49981dfc`](https://github.com/primer/css/commit/49981dfc29131e6ad25cef6538abd9308700b48a) Thanks [@manuelpuyol](https://github.com/manuelpuyol)! - Adding new Layout component

* [#1358](https://github.com/primer/css/pull/1358) [`6b51e877`](https://github.com/primer/css/commit/6b51e877bc3b1a1ae4925edc4fcb5d45907b110e) Thanks [@jonrohan](https://github.com/jonrohan)! - Adding new .Truncate class and deprecating css-truncate

### Patch Changes

- [#1415](https://github.com/primer/css/pull/1415) [`fb6a7e3d`](https://github.com/primer/css/commit/fb6a7e3dc112fc637003ca13dca978e7d8a54d4c) Thanks [@simurai](https://github.com/simurai)! - Bump primer/primitives@4.3.5

## 17.0.3

### Patch Changes

- [#1410](https://github.com/primer/css/pull/1410) [`d5e425e4`](https://github.com/primer/css/commit/d5e425e40900102b5b728a516de71e4094b7e138) Thanks [@simurai](https://github.com/simurai)! - Bump @primer/primitives@4.3.4

## 17.0.2

### Patch Changes

- [#1408](https://github.com/primer/css/pull/1408) [`1eea5575`](https://github.com/primer/css/commit/1eea557506241412de068c0f2570a0e9606fd6c2) Thanks [@colebemis](https://github.com/colebemis)! - Bump @primer/primitives version

* [#1403](https://github.com/primer/css/pull/1403) [`5ef399cf`](https://github.com/primer/css/commit/5ef399cff004fc30d0b98750af889ffdc4bf8f3b) Thanks [@tobiasahlin](https://github.com/tobiasahlin)! - Remove !important for base styles for body utilities

## 17.0.1

### Patch Changes

- [#1391](https://github.com/primer/css/pull/1391) [`534c8f66`](https://github.com/primer/css/commit/534c8f66f5a433aaf6daa308e0354d8eeca25f3a) Thanks [@simurai](https://github.com/simurai)! - Improve focus state for .SideNav and .menu

* [#1398](https://github.com/primer/css/pull/1398) [`5ef7bd6e`](https://github.com/primer/css/commit/5ef7bd6ef0eb43f2bb5765c0f3cfd30db3924ec4) Thanks [@colebemis](https://github.com/colebemis)! - Add experimental color variables. **Warning: Do not use these color variables**

- [#1394](https://github.com/primer/css/pull/1394) [`42223f0b`](https://github.com/primer/css/commit/42223f0b219b6213e2d11f99988acdfd47ab9591) Thanks [@tobiasahlin](https://github.com/tobiasahlin)! - Marketing: Fix letter spacing for headers not being correctly overridden at break points

## 17.0.0

### Major Changes

- [#1370](https://github.com/primer/css/pull/1370) [`cc0049c2`](https://github.com/primer/css/commit/cc0049c2ad1ad609dc672e12f751245fbecc5d65) Thanks [@simurai](https://github.com/simurai)! - Replace border-overlay with border-primary

* [#1371](https://github.com/primer/css/pull/1371) [`0c6bfc22`](https://github.com/primer/css/commit/0c6bfc22b523545120bea39dc201760d8a9e8b01) Thanks [@tobiasahlin](https://github.com/tobiasahlin)! - Marketing: Deprecate bg-shade-gradient

- [#1379](https://github.com/primer/css/pull/1379) [`22a98b5c`](https://github.com/primer/css/commit/22a98b5c87031584c5349f49835e013e8a7e460b) Thanks [@tobiasahlin](https://github.com/tobiasahlin)! - Add new marketing type scale

* [#1369](https://github.com/primer/css/pull/1369) [`2ae2ae57`](https://github.com/primer/css/commit/2ae2ae5795f68a6004fb4a14eb56bba41828173d) Thanks [@tobiasahlin](https://github.com/tobiasahlin)! - Marketing: Removing Inter font files and folder

- [#1339](https://github.com/primer/css/pull/1339) [`0ca2648e`](https://github.com/primer/css/commit/0ca2648e5982f0d21137a556e083d77af33eee36) Thanks [@jonrohan](https://github.com/jonrohan)! - Changeset change supported browsers.

* [#1373](https://github.com/primer/css/pull/1373) [`aeae963d`](https://github.com/primer/css/commit/aeae963d93e273f08fbf47d582316811bbd8eac5) Thanks [@tobiasahlin](https://github.com/tobiasahlin)! - Remove redundant marketing layout selectors

- [#1380](https://github.com/primer/css/pull/1380) [`4ac39740`](https://github.com/primer/css/commit/4ac39740f27842c625da084f1d03b8e2ec6084f8) Thanks [@tobiasahlin](https://github.com/tobiasahlin)! - Marketing: use size modifiers that don't look like breakpoints modifiers

* [#1352](https://github.com/primer/css/pull/1352) [`b4950e39`](https://github.com/primer/css/commit/b4950e395867b558e63b5bb4d46d93f75f35e38e) Thanks [@tobiasahlin](https://github.com/tobiasahlin)! - Update marketing button styles

- [#1356](https://github.com/primer/css/pull/1356) [`3b7e5d8c`](https://github.com/primer/css/commit/3b7e5d8c0def7975cc6714abe4b60d8efc746f8f) Thanks [@jonrohan](https://github.com/jonrohan)! - Remove dependency on primer/octicons and force overflow visible

* [#1372](https://github.com/primer/css/pull/1372) [`e24b7cb0`](https://github.com/primer/css/commit/e24b7cb024ca2c6bb06cda92ccefa1aff3208131) Thanks [@tobiasahlin](https://github.com/tobiasahlin)! - Merge overlapping marketing spacing utilities into primer core

### Minor Changes

- [#1357](https://github.com/primer/css/pull/1357) [`3dfb910f`](https://github.com/primer/css/commit/3dfb910fc39ae889fb4c2c3c783aead6ac768d0d) Thanks [@hpalacio](https://github.com/hpalacio)! - typography-base: process 'type' attribute of HTML <ol> tag

### Patch Changes

- [#1368](https://github.com/primer/css/pull/1368) [`95b9f0f0`](https://github.com/primer/css/commit/95b9f0f051bf34be5bcc60e2f2d29a262059c420) Thanks [@simurai](https://github.com/simurai)! - Use `--color-icon-secondary` for `.blankslate-icon`

* [#1350](https://github.com/primer/css/pull/1350) [`2dbc6143`](https://github.com/primer/css/commit/2dbc6143a66b56b29e12d5ae3e7afeaed95373ab) Thanks [@simurai](https://github.com/simurai)! - Bump @primer/primitives

- [#1385](https://github.com/primer/css/pull/1385) [`1cfff7a4`](https://github.com/primer/css/commit/1cfff7a4a39e5612c3f98357bfa2edc1460f2e04) Thanks [@tobiasahlin](https://github.com/tobiasahlin)! - Marketing typography: 64px → 68px for third size step

* [#1382](https://github.com/primer/css/pull/1382) [`18bb377b`](https://github.com/primer/css/commit/18bb377bef8f65cc75cd1faea9b2264a4061cfd0) Thanks [@tobiasahlin](https://github.com/tobiasahlin)! - Marketing: optimize body typography inheritance

- [#1392](https://github.com/primer/css/pull/1392) [`0fea11a7`](https://github.com/primer/css/commit/0fea11a74b05196c17e2e300b66c93c24d6c9844) Thanks [@tobiasahlin](https://github.com/tobiasahlin)! - Marketing: Enable body content utilities to have their font-weight overwritten

## 16.3.0

### Minor Changes

- [#1306](https://github.com/primer/css/pull/1306) [`5d42f1c5`](https://github.com/primer/css/commit/5d42f1c5c36d9732fd69541585a8d8ba4221b978) Thanks [@jonrohan](https://github.com/jonrohan)! - Adding a min-height to input-sm

### Patch Changes

- [#1340](https://github.com/primer/css/pull/1340) [`8506c374`](https://github.com/primer/css/commit/8506c3747fc3d4bfa216e0fbb1d2835db4a9baf4) Thanks [@simurai](https://github.com/simurai)! - Bump @primer/primitives

* [#1302](https://github.com/primer/css/pull/1302) [`90902e1a`](https://github.com/primer/css/commit/90902e1a6044f4b9fde049105f5aec7e09d52777) Thanks [@jonrohan](https://github.com/jonrohan)! - Moving the /fonts/ folder to /src/fonts/

## 16.2.0

### Minor Changes

- [#1294](https://github.com/primer/css/pull/1294) [`7609a074`](https://github.com/primer/css/commit/7609a0742cbb69b2c48af5a2d583c94a14a2d0c6) Thanks [@jonrohan](https://github.com/jonrohan)! - Adding a color text link on hover that will change a color utility class

* [#1295](https://github.com/primer/css/pull/1295) [`fea6ea69`](https://github.com/primer/css/commit/fea6ea692013cbf13b4d93dff1601bb0805beb73) Thanks [@jonrohan](https://github.com/jonrohan)! - Adding text-semibold and text-light utility classes

### Patch Changes

- [#1297](https://github.com/primer/css/pull/1297) [`7a374784`](https://github.com/primer/css/commit/7a37478499c6dbdd30082442abec9dccdfc9efa4) Thanks [@simurai](https://github.com/simurai)! - Separate active and selected states for `.btn`

## 16.1.2

### Patch Changes

- [#1282](https://github.com/primer/css/pull/1282) [`5ee52dfe`](https://github.com/primer/css/commit/5ee52dfe59f1b209ca6c1f2489db0e32660388e9) Thanks [@simurai](https://github.com/simurai)! - Add bg to UnderlineNav Counter

* [#1286](https://github.com/primer/css/pull/1286) [`9044eecf`](https://github.com/primer/css/commit/9044eecf4ef7a1c6ad9ccf0b51def53c52d0def4) Thanks [@jonrohan](https://github.com/jonrohan)! - color-mode mixin fix for keyboard toggle

## 16.1.1

### Patch Changes

- [#1278](https://github.com/primer/css/pull/1278) [`fa4a7c71`](https://github.com/primer/css/commit/fa4a7c714c2666cd339dbf4c77b684e67030af60) Thanks [@jonrohan](https://github.com/jonrohan)! - revert Fixing workflow for rc publishing

## 16.1.0

### Minor Changes

- [#1254](https://github.com/primer/css/pull/1254) [`5d2f0beb`](https://github.com/primer/css/commit/5d2f0beb58b6fab795d5b720e9a14da2f649265c) Thanks [@tobiasahlin](https://github.com/tobiasahlin)! - Add common marketing utilities to primer/marketing

* [#1201](https://github.com/primer/css/pull/1201) [`29a83bdc`](https://github.com/primer/css/commit/29a83bdcfdc3d647932bfe97c9b3f24f91688280) Thanks [@vdepizzol](https://github.com/vdepizzol)! - Change TableObject status to deprecated

### Patch Changes

- [#1197](https://github.com/primer/css/pull/1197) [`a355160a`](https://github.com/primer/css/commit/a355160a30654327f9e51bf677f9b069a46e95a1) Thanks [@neildaniels](https://github.com/neildaniels)! - Fix .btn-with-count documentation

* [#1274](https://github.com/primer/css/pull/1274) [`322379fe`](https://github.com/primer/css/commit/322379fe273c53c94190177b62dd5deed10beb32) Thanks [@tobiasahlin](https://github.com/tobiasahlin)! - Marketing buttons: don't animate everything

- [#1272](https://github.com/primer/css/pull/1272) [`88bcd1bf`](https://github.com/primer/css/commit/88bcd1bfd0258c416addf4c943dfbde593a11b7f) Thanks [@simurai](https://github.com/simurai)! - Update `Counter--secondary` bg

* [#1261](https://github.com/primer/css/pull/1261) [`b1346678`](https://github.com/primer/css/commit/b1346678f4119f384ac49b0c63c355f56968071a) Thanks [@jonrohan](https://github.com/jonrohan)! - Fixing the `color-mode-theme` mixin. Currently the mixin doesn't take into account when `mode="light"` and `light-theme="dark"`. This fix allows dark themes to be set as light themes and to toggle into single light mode.

## 16.0.2

### Patch Changes

- [#1258](https://github.com/primer/css/pull/1258) [`c6945cd5`](https://github.com/primer/css/commit/c6945cd50c297b621a69aecb619440bfb2bf4c32) Thanks [@jonrohan](https://github.com/jonrohan)! - Removing post publish storybook hook

## 16.0.1

### Patch Changes

- [#1247](https://github.com/primer/css/pull/1247) [`1b6ba39c`](https://github.com/primer/css/commit/1b6ba39c733433fc5488d60b0b8b384b6d2b4d7d) Thanks [@jonrohan](https://github.com/jonrohan)! - Adding changesets to release workflow

## 16.0.0

### :boom: Breaking Change

- Update to Primer Primitives `4.0.0` [primer/primitives#43](https://github.com/primer/primitives/pull/43)
- Add color modes [#1131](https://github.com/primer/css/pull/1131)

### :rocket: Enhancement

- Add `flex-shrink: 0` to `.avatar` [#1183](https://github.com/primer/css/pull/1183)
- Adding timeline-badge success border [#1246](https://github.com/primer/css/pull/1246)
- Add `.anim-rotate` utility class [#1251](https://github.com/primer/css/pull/1251)

### :nail_care: Polish

- Move marketing `@font-face` declarations from vars to type [#1238](https://github.com/primer/css/pull/1238)

### :memo: Documentation

- Update documentation with color modes [#1186](https://github.com/primer/css/pull/1186)

## 15.2.0

### :rocket: Enhancements

- [#1145](https://github.com/primer/css/pull/1145) Make final position responsive
- [#1148](https://github.com/primer/css/pull/1148) flex wrap reverse added
- [#1157](https://github.com/primer/css/pull/1157) Overflow responsive variants
- [#1156](https://github.com/primer/css/pull/1156) Add missing rounded-3 utility

### :memo: Documentation

- [#1160](https://github.com/primer/css/pull/1160) Remove custom emoji from SelectMenu docs
- [#1165](https://github.com/primer/css/pull/1165) Replaced old octicons in examples
- [#1146](https://github.com/primer/css/pull/1146) Corrected a few typos
- [#1142](https://github.com/primer/css/pull/1142) Fix typo in Box documentation
- [#1125](https://github.com/primer/css/pull/1125) Remove reference to Crema
- [#1155](https://github.com/primer/css/pull/1155) Place search subnav example on new line

### :nail_care: Polish

- [#1147](https://github.com/primer/css/pull/1147) Increase input font-size on iOS
- [#1152](https://github.com/primer/css/pull/1152) Remove .autocomplete-results inset border that is occluded by items

### Committers

- [@MauricioHernanCabrera](https://github.com/MauricioHernanCabrera)
- [@ashygee](https://github.com/ashygee)
- [@esdraspavon](https://github.com/esdraspavon)
- [@neildaniels](https://github.com/neildaniels)
- [@nicksloan](https://github.com/nicksloan)

## 15.1.0

### :rocket: Enhancements

- [#1062](https://github.com/primer/css/pull/1062) Make tabnav responsive
- [#1128](https://github.com/primer/css/pull/1128) Add support for table border
- [#1132](https://github.com/primer/css/pull/1132) Add .bg-orange to the list of colors

### :memo: Documentation

- [#1122](https://github.com/primer/css/pull/1122) fix comment typo

### :nail_care: Polish

- [#1121](https://github.com/primer/css/pull/1121) Update layout when the Counter is empty
- [#1126](https://github.com/primer/css/pull/1126) Increase border contrast for Label--yellow

### Committers

- [@colinkeany](https://github.com/colinkeany)
- [@garman](https://github.com/garman)
- [@nikolasveneti](https://github.com/nikolasveneti)
- [@nuthinking](https://github.com/nuthinking)
- [@simurai](https://github.com/simurai)

## 15.0.0

### :rocket: Enhancements

- [#1116](https://github.com/primer/css/pull/1116) Improve accessibility
- [#1083](https://github.com/primer/css/pull/1083) Make sure autocomplete resets button styles
- [#1074](https://github.com/primer/css/pull/1074) Update pagination
- [#1071](https://github.com/primer/css/pull/1071) Update flash alert
- [#1064](https://github.com/primer/css/pull/1064) Update SelectMenu
- [#1040](https://github.com/primer/css/pull/1040) Update box-shadow and borders
- [#1038](https://github.com/primer/css/pull/1038) Update navigation
- [#1034](https://github.com/primer/css/pull/1034) Update labels
- [#1029](https://github.com/primer/css/pull/1029) Update inputs
- [#1027](https://github.com/primer/css/pull/1027) Update buttons
- [#1022](https://github.com/primer/css/pull/1022) Update border radius

### :nail_care: Polish

- [#1109](https://github.com/primer/css/pull/1109) Polish 9
- [#1090](https://github.com/primer/css/pull/1090) Polish 8
- [#1077](https://github.com/primer/css/pull/1077) Polish 7
- [#1055](https://github.com/primer/css/pull/1055) Polish 3
- [#1047](https://github.com/primer/css/pull/1047) Polish 2
- [#1045](https://github.com/primer/css/pull/1045) Polish 1
- [#1041](https://github.com/primer/css/pull/1041) Polish

### Committers

- [@muan](https://github.com/muan)
- [@simurai](https://github.com/simurai)

## 14.4.0

### :rocket: Enhancements

- [#1089](https://github.com/primer/css/pull/1089) Accessible Progress

### :bug: Bug fixes

- [#1060](https://github.com/primer/css/pull/1060) Add support for aria-current=false

### :memo: Documentation

- [#1059](https://github.com/primer/css/pull/1059) Typo in scss.md
- [#1065](https://github.com/primer/css/pull/1065) Convert markdown page to one big example
- [#1075](https://github.com/primer/css/pull/1075) chore: add missing link to color utilities
- [#1067](https://github.com/primer/css/pull/1067) Add .text-gray-light to docs

### Committers

- [@daniseguraf](https://github.com/daniseguraf)
- [@metonym](https://github.com/metonym)
- [@simurai](https://github.com/simurai)

## 14.3.0

### :rocket: Enhancements

- [#1044](https://github.com/primer/css/pull/1044) Accessible form validation
- [#1028](https://github.com/primer/css/pull/1028) Improve .form-group accessibility

### :bug: Bug fixes

- [#670](https://github.com/primer/css/pull/670) Fix Box row top border
- [#1042](https://github.com/primer/css/pull/1042) Fix UnderlineNav in Safari
- [#1035](https://github.com/primer/css/pull/1035) Update UnderlineNav-item to not wrap counter & icon

### :memo: Documentation

- [#1018](https://github.com/primer/css/pull/1018) Update MIGRATING.md

### Committers

- [@emplums](https://github.com/emplums)
- [@jonrohan](https://github.com/jonrohan)
- [@simurai](https://github.com/simurai)

## 14.2.0

### :rocket: Enhancements

- [#1006](https://github.com/primer/css/pull/1006) Use ARIA attributes for states
- [#1014](https://github.com/primer/css/pull/1014) Add aria-disabled state
- [#1001](https://github.com/primer/css/pull/1001) Add Inter bold font file
- [#982](https://github.com/primer/css/pull/982) Applies .selected styles to [aria-selected=true]

### :bug: Bug fixes

- [#1002](https://github.com/primer/css/pull/1002) Fix marketing utilities
- [#1005](https://github.com/primer/css/pull/1005) Add .selected back to the .UnderlineNav

### :memo: Documentation

- [#1012](https://github.com/primer/css/pull/1012) Improve margin/padding docs
- [#1013](https://github.com/primer/css/pull/1013) Fix docs links
- [#1004](https://github.com/primer/css/pull/1004) rm deprecated flash-banner component from docs

### Committers

- [@flavianunes](https://github.com/flavianunes)
- [@ktravers](https://github.com/ktravers)
- [@simurai](https://github.com/simurai)

## 14.1.0

### :rocket: Enhancements

- [#994](https://github.com/primer/css/pull/994) Responsive line-height utilities
- [#995](https://github.com/primer/css/pull/995) Add bold weight to marketing font variables

### :bug: Bug fixes

- [#998](https://github.com/primer/css/pull/998) Use a gray background when hovering SelectMenu items

### :memo: Documentation

- [#989](https://github.com/primer/css/pull/989) Add link to the Stylelint guide
- [#1000](https://github.com/primer/css/pull/1000) Update contributing guide for a general audience
- [#972](https://github.com/primer/css/pull/972) Variables page

### :house: Internal

- [#997](https://github.com/primer/css/pull/997) Fix CHANGELOG links

### Committers

- [@shawnbot](https://github.com/shawnbot)
- [@simurai](https://github.com/simurai)
- [@skullface](https://github.com/skullface)

## 14.0.0

### :boom: Breaking changes

- [#922](https://github.com/primer/css/pull/922) More SelectMenu improvements
- [#966](https://github.com/primer/css/pull/966) Rename `.flex-item-equal` to `.flex-1`
- [#973](https://github.com/primer/css/pull/973) Deprecate variables in 14.0.0

### :rocket: Enhancements

- [#987](https://github.com/primer/css/pull/987) Add .position-sticky utility
- [#979](https://github.com/primer/css/pull/979) Add `.radio-group` component
- [#981](https://github.com/primer/css/pull/981) Autocomplete + Suggester components
- [#978](https://github.com/primer/css/pull/978) Add `.css-truncate-overflow`
- [#974](https://github.com/primer/css/pull/974) Add Animated Ellipsis
- [#971](https://github.com/primer/css/pull/971) Add variable deprecation data and tests

### :memo: Documentation

- [#988](https://github.com/primer/css/pull/988) Add docs for flexbug no. 9
- [#977](https://github.com/primer/css/pull/977) Update spacing.md

### :house: Internal

- [#952](https://github.com/primer/css/pull/952) Async/awaitify script/dist.js
- [#963](https://github.com/primer/css/pull/963) Generate changelog with semantic-release
- [#968](https://github.com/primer/css/pull/968) Stylelint update

### Committers

- [@BinaryMuse](https://github.com/BinaryMuse)
- [@danchristian](https://github.com/danchristian)
- [@shawnbot](https://github.com/shawnbot)
- [@simurai](https://github.com/simurai)

# 13.2.0

### :rocket: Enhancements

- [#959](https://github.com/primer/css/pull/959) More buttons
- [#950](https://github.com/primer/css/pull/950) Add Diffstat component
- [#913](https://github.com/primer/css/pull/913) Importing TimelineItem from .com and creating matching docs
- [#953](https://github.com/primer/css/pull/953) Add IssueLabel component

### :bug: Bug fixes

- [#945](https://github.com/primer/css/pull/945) Add `[role=tab][aria-selected=true]` to `.UnderlineNav-item.selected`

### :memo: Documentation

- [#939](https://github.com/primer/css/pull/939) Fix `Box--overlay` example
- [#943](https://github.com/primer/css/pull/943) Fix broken links to typography utilities

### :house: Internal

- [#946](https://github.com/primer/css/pull/946) Add `TODO@version` stylelint rule (local)

### Committers

- [@MohamedElidrissi](https://github.com/MohamedElidrissi)
- [@jonrohan](https://github.com/jonrohan)
- [@shawnbot](https://github.com/shawnbot)
- [@simurai](https://github.com/simurai)

# 13.1.0

### :rocket: Enhancement

- [#904](https://github.com/primer/css/pull/904) Add Keyboard Shortcuts `kbd` from github/github
- [#926](https://github.com/primer/css/pull/926) Add Flash Banner `.flash-banner` from github/github
- [#927](https://github.com/primer/css/pull/927) Add `.flex-column-reverse` utilities

### :memo: Documentation

- [#932](https://github.com/primer/css/pull/932) Fix CDN links in documentation
- [#933](https://github.com/primer/css/pull/933) Convert most ERB examples to HTML

### Committers

- [@shawnbot](https://github.com/shawnbot)
- [@simurai](https://github.com/simurai)

# 13.0.2

### :memo: Documentation

- Use inline octicon in branch name example [#886](https://github.com/primer/css/pull/886)
- Move select menu list into the modal div [#903](https://github.com/primer/css/pull/903)
- Improve SelectMenu docs [#923](https://github.com/primer/css/pull/923)

### :house: Internal

- Update "Ship checklist" [#902](https://github.com/primer/css/pull/902)
- Bump stylelint, et al; add CI tests and script for removing needless disables [#912](https://github.com/primer/css/pull/912)

### Committers

- [@colebemis](https://github.com/colebemis)
- [@mxie](https://github.com/mxie)
- [@shawnbot](https://github.com/shawnbot)
- [@simurai](https://github.com/simurai)

# 13.0.1

### :bug: Bug Fix

- Remove "Segoe UI Symbol" from font stack [#906](https://github.com/primer/css/pull/906)

### Committers

- [@simurai](https://github.com/simurai)

# 13.0.0

### :boom: Breaking Change

- Remove `.container`, `.columns`, `.column`, and related classes [#662](https://github.com/primer/css/pull/662)
- Remove `.btn-purple` [#736](https://github.com/primer/css/pull/736) :wave: 💜
- Remove `.text-pending` and `.bg-pending` [#888](https://github.com/primer/css/pull/888)
- Remove `.dropdown-menu-content` [#884](https://github.com/primer/css/pull/884)

### :nail_care: Polish

- Select menu improvements [#893](https://github.com/primer/css/pull/893)

### :memo: Documentation

- The layout docs, formerly available at `/css/objects/layout`, are gone and will redirect to `/css/objects/grid`.

### :house: Internal

- Add deprecations test script [#889](https://github.com/primer/css/pull/889)
- Clean up scripts and dev dependencies [#890](https://github.com/primer/css/pull/890)
- Upgrade stylelint-config-primer to v8.0.0 [#892](https://github.com/primer/css/pull/892)
- Upgrade doctocat, live code wrappers [#895](https://github.com/primer/css/pull/895)

### Committers

- [@jonrohan](https://github.com/jonrohan)
- [@shawnbot](https://github.com/shawnbot)
- [@simurai](https://github.com/simurai)
- [@sophshep](https://github.com/sophshep)

# 12.7.0

### :rocket: Enhancement

- Import Dropdown component; add dark variants for dropdown and text fields [#862](https://github.com/primer/css/pull/862)
- Add `.break-word` utility and improve word-break docs [#880](https://github.com/primer/css/pull/880)
- Publish deprecation data [#883](https://github.com/primer/css/pull/883)

### :memo: Documentation

- Fix mistake in flex-justify-start explanation [#877](https://github.com/primer/css/pull/877)

### :house: Internal

- Fix CSS bundle size report when adding bundles [#879](https://github.com/primer/css/pull/879)
- Migrate to GitHub Actions v2 [#881](https://github.com/primer/css/pull/881)

### Committers

- [@dcastil](https://github.com/dcastil)
- [@shawnbot](https://github.com/shawnbot)
- [@simurai](https://github.com/simurai)
- [@vdepizzol](https://github.com/vdepizzol)

# 12.6.2

### :nail_care: Polish

- Add default background-color to SideNav https://github.com/primer/css/pull/873

### :house: Internal

- Change order in RELEASING.md https://github.com/primer/css/pull/875

### Committers

- [@shawnbot](https://github.com/shawnbot)
- [@simurai](https://github.com/simurai)

# 12.6.1

### :bug: Bug Fix

- Remove non-ascii characters (en dashes?) from SCSS comments [#870](https://github.com/primer/css/pull/870)
- Fix SideNav "jumping" in Safari [#868](https://github.com/primer/css/pull/868)

### :nail_care: Polish

- Improve Select Menu spacing [#844](https://github.com/primer/css/pull/844)

### :memo: Documentation

- Update colorable URL [#867](https://github.com/primer/css/pull/867)

### :house: Internal

- Update changelog for 12.6.0 [#866](https://github.com/primer/css/pull/866)

### Committers

- [@jonrohan](https://github.com/jonrohan)
- [@kiendang](https://github.com/kiendang)
- [@shawnbot](https://github.com/shawnbot)
- [@shreve](https://github.com/shreve)
- [@simurai](https://github.com/simurai)

# 12.6.0

### 🚀 Enhancements

- Loading toast styles [#852](https://github.com/primer/css/pull/852)
- Header component [#845](https://github.com/primer/css/pull/845)
- Import `.octicon` CSS in the core bundle [#857](https://github.com/primer/css/pull/857)
- Design update for blankslates [#861](https://github.com/primer/css/pull/861)
- Don't let State labels wrap [#863](https://github.com/primer/css/pull/863)

### 📝 Documentation

- Fix some links in linting docs [#856](https://github.com/primer/css/pull/856)
- Updates to the development docs [#855](https://github.com/primer/css/pull/855)
- Generate bundle source READMEs from a template [#859](https://github.com/primer/css/pull/859)
- Render Octicon Ruby helper in docs [#847](https://github.com/primer/css/pull/847)

### 🏠 Internal

- Add GitHub `styleguide.css` to Storybook [#849](https://github.com/primer/css/pull/849)

### Committers

- [@ashygee](https://github.com/ashygee)
- [@emilybrick](https://github.com/emilybrick)
- [@jonrohan](https://github.com/jonrohan)
- [@shawnbot](https://github.com/shawnbot)
- [@vdepizzol](https://github.com/vdepizzol)

# 12.5.0

### :rocket: Enhancement

- Add `.Toast` component [#831](https://github.com/primer/css/pull/831)
- Add `.SideNav` component [#827](https://github.com/primer/css/pull/827)
- Add `.SelectMenu` component [#808](https://github.com/primer/css/pull/808)
- Add `font-display: swap` to `@font-face` declarations [#780](https://github.com/primer/css/pull/780)
- Add `flex-grow-0`, `flex-order-[1,2,none]` and `width-auto` utilities [#763](https://github.com/primer/css/pull/763)
- Change default for `$marketing-font-path` to `/fonts/` [#837](https://github.com/primer/css/pull/837)

### :bug: Bug Fix

- Improve monospaced font on Chrome Android [#812](https://github.com/primer/css/pull/812)

### :memo: Documentation

- Add multi-word naming conventions to BEM docs [#836](https://github.com/primer/css/pull/836)
- Color system docs updates [#811](https://github.com/primer/css/pull/811)
- Color utility table tweaks [#842](https://github.com/primer/css/pull/842)
- Fix markdown typos in Contributing docs page [#846](https://github.com/primer/css/pull/846)

### Committers

- [@ampinsk](https://github.com/ampinsk)
- [@emilybrick](https://github.com/emilybrick)
- [@emplums](https://github.com/emplums)
- [@jonrohan](https://github.com/jonrohan)
- [@shawnbot](https://github.com/shawnbot)
- [@simurai](https://github.com/simurai)
- [@skullface](https://github.com/skullface)
- [@vdepizzol](https://github.com/vdepizzol)

# 12.4.1

### :bug: Bug fixes

- Fix [#822](https://github.com/primer/css/issues/822) (`.border-dashed` issues) via [#824](https://github.com/primer/css/issues/824)

### :memo: Documentation

- Typos fixed in [#802](https://github.com/primer/css/issues/802) (thank you, [@The-Compiler](https://github.com/The-Compiler)!)
- Nav updates [#803](https://github.com/primer/css/issues/803)
- Fix tables of contents [#762](https://github.com/primer/css/issues/762)
- Add deprecation warning for `.btn-purple`, due to disappear in 13.0.0 via [#736](https://github.com/primer/css/issues/736)
- Lots more documentation updates in [#814](https://github.com/primer/css/issues/814)

### :house: Internal

- Decommission `primer/deploy` [#809](https://github.com/primer/css/issues/809)

### Committers

- [@emplums](https://github.com/emplums)
- [@shawnbot](https://github.com/shawnbot)
- [@simurai](https://github.com/simurai)
- [@The-Compiler](https://github.com/The-Compiler)

# 12.4.0

### :rocket: Enhancement

- More responsive border utilities [#775](https://github.com/primer/css/pull/775)
- Add `overflow: visible` utilities [#798](https://github.com/primer/css/pull/798)
- Add `yellow` color utilities that will replace `pending` [#737](https://github.com/primer/css/pull/737)

### :bug: Bug Fix

- Fix Ruby Sass compiler warnings by quoting keys in `$hue-maps` declaration [#794](https://github.com/primer/css/pull/794)

### :house: Internal

- Remove `test-all-modules` scripts and old monorepo test scripts [#795](https://github.com/primer/css/pull/795)
- Resolve all but one ([#796](https://github.com/primer/css/pull/796)) vulnerability in npm dev dependencies [#797](https://github.com/primer/css/pull/797)

### Committers

- [@broccolini](https://github.com/broccolini)
- [@shawnbot](https://github.com/shawnbot)
- [@simurai](https://github.com/simurai)

# 12.3.1

### 🐛 Bug Fix

- Add `aria-selected="true"` support to tabbed navigation styles to play nicely with [`<tab-container>`](https://github.com/github/tab-container-element)

### 🏠 Internal

- Resolve the vulnerability alert with `tar@<4.4.2` in [CVE-2018-20834](https://nvd.nist.gov/vuln/detail/CVE-2018-20834)

### Committers

- [@shawnbot](https://github.com/shawnbot)

# 12.3.0

### :rocket: Enhancement

- More color utilities! [#760](https://github.com/primer/css/pull/760) ([@shawnbot](https://github.com/shawnbot))
- Add pink to Primer! 💖🌸💕🌷💞🎀💗🌺💝 [#776](https://github.com/primer/css/pull/776), [#778](https://github.com/primer/css/pull/778) ([@emplums](https://github.com/emplums)))

### :house: Internal

- Update storybook [#777](https://github.com/primer/css/pull/777) ([@emplums](https://github.com/emplums))
- Add bundle size report [#772](https://github.com/primer/css/pull/772) ([@shawnbot](https://github.com/shawnbot))

### :memo: Documentation

- Update Primer references to Primer CSS [#771](https://github.com/primer/css/pull/771) ([@emplums](https://github.com/emplums))
- Add Edit on GitHub links to docs [#770](https://github.com/primer/css/pull/770) ([@emplums](https://github.com/emplums))
- Anchor Link in Docs [#768](https://github.com/primer/css/pull/768) ([@emplums](https://github.com/emplums))

### :house: Internal

- Update RELEASING [#757](https://github.com/primer/css/pull/757) ([@simurai](https://github.com/simurai))

### Committers

- [@emplums](https://github.com/emplums)
- [@shawnbot](https://github.com/shawnbot)
- [@simurai](https://github.com/simurai)

# 12.2.3

### :bug: Bug Fix

- Remove references to a non-existent `Progress-value` class https://github.com/primer/css/pull/751

### :house: Internal

- Upgrade stylelint config https://github.com/primer/css/pull/753

#### Committers: 1

- Shawn Allen ([shawnbot](https://github.com/shawnbot))

# 12.2.2

### :bug: Bug Fix

- Fix hide utilities when toggling between breakpoints [#746](https://github.com/primer/css/pull/746)

### :house: Internal

- Prevent Storybook publish failures from breaking builds on `main` [#728](https://github.com/primer/css/pull/728)
- Upgrade to [cssstats v3.3.0](https://github.com/cssstats/cssstats/releases/tag/v3.3.0), which fixes our selector stats JSON files

#### Committers: 2

- Shawn Allen ([shawnbot](https://github.com/shawnbot))
- Simurai ([simurai](https://github.com/simurai))

# 12.2.1

### :bug: Bug Fix

- Fix source order of directional border utilities [#727](https://github.com/primer/css/pull/727)
- Fix UnderlineNav selected border width [#733](https://github.com/primer/css/pull/733)

### :memo: Documentation

- Fix changelog committers listings for versions 12.0.1 and 12.0.2 [#729](https://github.com/primer/css/pull/729)
- Fix code examples from being cut off [#725](https://github.com/primer/css/pull/725)

#### Committers: 2

- Shawn Allen ([shawnbot](https://github.com/shawnbot))
- Simurai ([simurai](https://github.com/simurai))

# 12.2.0

### :rocket: Enhancement

- Add more `.border-white-fade` utilities [#713](https://github.com/primer/css/pull/713)

### :nail_care: Polish

- Fix `<details>` spacing [#675](https://github.com/primer/css/pull/675)

### :bug: Bug Fixes

- Accessibility fixes for marketing buttons [#716](https://github.com/primer/css/pull/716)

### :memo: Documentation

- Fix scrolling of code examples [#717](https://github.com/primer/css/pull/717)

### :house: Internal

- Fix `npm link` ([#715](https://github.com/primer/css/issue/715)) by removing `prepare` npm script [#718](https://github.com/primer/css/pull/718)

#### Committers: 4

- Diana Mounter ([broccolini](https://github.com/broccolini))
- Max Stoiber ([mxstbr](https://github.com/mxstbr))
- Shawn Allen ([shawnbot](https://github.com/shawnbot))
- Simurai ([simurai](https://github.com/simurai))

# 12.1.1

### :bug: Bug Fix

- Remove UI from font file path [#709](https://github.com/primer/css/pull/709)

### :memo: Documentation

- Removes sync functionality from docs [#710](https://github.com/primer/css/pull/710)

### :house: Internal

- Fixes Storybook [#707](https://github.com/primer/css/pull/707) and [#711](https://github.com/primer/css/pull/711)

#### Committers: 3

- Catherine Bui ([gladwearefriends](https://github.com/gladwearefriends))
- Shawn Allen ([shawnbot](https://github.com/shawnbot))
- Emily Plummer ([emplums](https://github.com/emplums))

# 12.1.0

### :rocket: Enhancement

- Per-axis overflow utilities [#701](https://github.com/primer/css/pull/701)
- Add `0` to responsive marketing positioning utilities (`top-lg-0`, et al) [#697](https://github.com/primer/css/pull/697)
- Add negative offset utilities to marketing/utilities/layout [#639](https://github.com/primer/css/pull/639)

### :memo: Documentation

- Fix changelog committers list for 12.0.2 (accidentally listed under 12.0.1)

### :house: Internal

- Remove a bunch of unused dev dependencies [#703](https://github.com/primer/css/pull/703)
- Update `script/selector-diff-report` to compare against `@primer/css` (not `primer`!)

#### Committers: 3

- Catherine Bui ([gladwearefriends](https://github.com/gladwearefriends))
- Shawn Allen ([shawnbot](https://github.com/shawnbot))
- Tyson Rosage ([trosage](https://github.com/trosage))

# 12.0.2

### :bug: Bug fix

- Restore missing marketing padding utilities [#695](https://github.com/primer/css/pull/695)

### :memo: Documentation

- Explain why `.tooltipped` should be used sparingly [#676](https://github.com/primer/css/pull/676)
- Fix trailing slash errors in Next.js [#681](https://github.com/primer/css/pull/681)
- Add static assets to Now deployments [#687](https://github.com/primer/css/pull/687)
- Shiny new social and README header by @ashygee [#689](https://github.com/primer/css/pull/689)

### :house: Internal

- Remove `postversion` script from `package.json` and update the [PR template](https://github.com/primer/css/blob/main/RELEASING.md#in-this-repo)
- Rename InterUI font to "Inter", per [inter v3.3](https://github.com/rsms/inter/releases/tag/v3.3) [#696](https://github.com/primer/css/pull/696)

#### Committers: 4

- Ash Guillaume ([ashygee](https://github.com/ashygee))
- David Graham ([dgraham](https://github.com/dgraham))
- Mu-An Chiou ([muan](https://github.com/muan))
- Shawn Allen ([shawnbot](https://github.com/shawnbot))

# 12.0.1

### :bug: Bug Fix

- Add missing `h000-mktg` class [#667](https://github.com/primer/css/pull/667)
- Fix UnderlineNav overflow issues [#684](https://github.com/primer/css/pull/684)
- Fix double borders on Box-header [#686](https://github.com/primer/css/pull/686)

### :house: Internal

- Add `postversion` npm script that commits `package.json` and `package-lock.json` with consistent commit messages (`chore: v<version>`)

#### Committers: 2

- Catherine Bui ([gladwearefriends](https://github.com/gladwearefriends))
- Shawn Allen ([shawnbot](https://github.com/shawnbot))

# 12.0.0

:rotating_light: **Starting with version 12.0.0, the `primer` package is now known as `@primer/css`**. See [MIGRATING.md](https://github.com/primer/css/tree/main/MIGRATING.md) for more info.

#### :boom: Breaking Change

- [#666](https://github.com/primer/css/pull/666) Reorganize into a single `@primer/css` package ([@shawnbot](https://github.com/shawnbot))

#### Committers: 2

- Shawn Allen ([shawnbot](https://github.com/shawnbot))
- Catherine Bui ([gladwearefriends](https://github.com/gladwearefriends))

# 11.0.0

#### :boom: Breaking Change

- [#438](https://github.com/primer/primer/pull/438) Remove `primer-page-sections` package. ([@sophshep](https://github.com/sophshep))
- [#439](https://github.com/primer/primer/pull/439) Remove `primer-page-headers` package. ([@sophshep](https://github.com/sophshep))
- [#440](https://github.com/primer/primer/pull/440) Remove `primer-tables` package. ([@sophshep](https://github.com/sophshep))
- [#459](https://github.com/primer/primer/pull/459) Move responsive position utilities from marketing to core. ([@sophshep](https://github.com/sophshep))
- [#656](https://github.com/primer/primer/pull/656) Remove colorizeTooltip mixin. ([@shawnbot](https://github.com/shawnbot))
- [#657](https://github.com/primer/primer/pull/657) Remove `BtnGroup-form` class. ([@shawnbot](https://github.com/shawnbot))
- [#658](https://github.com/primer/primer/pull/658) Remove `.avatar-stack` in favor of `.AvatarStack`. ([@shawnbot](https://github.com/shawnbot))

#### :rocket: Enhancement

- [#583](https://github.com/primer/primer/pull/583) Updates to Marketing Typography. ([@sophshep](https://github.com/sophshep))
- [#660](https://github.com/primer/primer/pull/660) Add `$marketing-font-path`. ([@shawnbot](https://github.com/shawnbot))
- [#661](https://github.com/primer/primer/pull/661) Spacer variable refactor. ([@shawnbot](https://github.com/shawnbot))
- [#663](https://github.com/primer/primer/pull/663) Add deprecation warning for column grid classes and add `container-sm` utility class. ([@jonrohan](https://github.com/jonrohan))

#### :bug: Bug Fix

- [#654](https://github.com/primer/primer/pull/654) Fix typo ("Chroma") in `primer-base` comment. ([@Jiang-Xuan](https://github.com/Jiang-Xuan))
- [#655](https://github.com/primer/primer/pull/655) Fix typo ("conditonally") in `docs/src/SideNav.js` comment. ([@0xflotus](https://github.com/0xflotus))

### :house: Internal

- [#659](https://github.com/primer/primer/pull/659) Generate CSS selector diff report on Travis. ([@shawnbot](https://github.com/shawnbot))

#### Committers: 4

- 0xflotus ([0xflotus](https://github.com/0xflotus))
- Jiang-Xuan ([Jiang-Xuan](https://github.com/Jiang-Xuan))
- Jon Rohan ([jonrohan](https://github.com/jonrohan))
- Shawn Allen ([shawnbot](https://github.com/shawnbot))
- Sophie Shepherd ([sophshep](https://github.com/sophshep))

# 10.10.5

#### :bug: Bug Fix

- [#650](https://github.com/primer/primer/pull/650) Fix border radius edge utility specificity. ([@shawnbot](https://github.com/shawnbot))

#### :memo: Documentation

- [#649](https://github.com/primer/primer/pull/649) Sandboxed code examples. ([@shawnbot](https://github.com/shawnbot))

#### :house: Internal

- Only check links on Travis if `[check-links]` is included in the commit message
- a5658d3 Run `now alias` without the branch name on merge to `main`

#### Committers: 1

- Shawn Allen ([shawnbot](https://github.com/shawnbot))

# 10.10.4

#### :memo: Documentation

- [#642](https://github.com/primer/primer/pull/642) docs: add Ash's new header illustration. ([@shawnbot](https://github.com/shawnbot))

#### :house: Internal

- [#641](https://github.com/primer/primer/pull/641) test(docs): improve style guide URL path test. ([@shawnbot](https://github.com/shawnbot))
- [#635](https://github.com/primer/primer/pull/635) docs: Releases link, Status key page move. ([@shawnbot](https://github.com/shawnbot))

#### Committers: 1

- Shawn Allen ([shawnbot](https://github.com/shawnbot))

# 10.10.3

#### :memo: Documentation

- [#632](https://github.com/primer/primer/pull/632) Happy new year! ([@shawnbot](https://github.com/shawnbot))
- [#626](https://github.com/primer/primer/pull/626) Branch deployment, docs for the docs. ([@shawnbot](https://github.com/shawnbot))
- [#616](https://github.com/primer/primer/pull/616) Start up the docs directory. ([@shawnbot](https://github.com/shawnbot))

#### :house: Internal

- [#631](https://github.com/primer/primer/pull/631) Docs release fixes. ([@shawnbot](https://github.com/shawnbot))

#### Committers: 2

- Emily Brick ([emilybrick](https://github.com/emilybrick))
- Shawn Allen ([shawnbot](https://github.com/shawnbot))

# 10.10.2

#### :memo: Documentation

- [#614](https://github.com/primer/primer/pull/614) fix broken border-radius helper example. ([@joelhawksley](https://github.com/joelhawksley))

#### :house: Internal

- [#615](https://github.com/primer/primer/pull/615) pin npm-run-all@4.1.5. ([@shawnbot](https://github.com/shawnbot))

#### Committers: 2

- Joel Hawksley ([joelhawksley](https://github.com/joelhawksley))
- Shawn Allen ([shawnbot](https://github.com/shawnbot))

# 10.10.1

#### :memo: Documentation

- [#606](https://github.com/primer/primer/pull/606) Fix for Progress Broken Package Link. ([@emilybrick](https://github.com/emilybrick))

#### :house: Internal

- [#608](https://github.com/primer/primer/pull/608) Update releasing docs. ([@shawnbot](https://github.com/shawnbot))

#### Committers: 2

- Emily Brick ([emilybrick](https://github.com/emilybrick))
- Shawn Allen ([shawnbot](https://github.com/shawnbot))

# 10.10.0

#### :rocket: Enhancement

- [#573](https://github.com/primer/primer/pull/573) Add Progress component. ([@emilybrick](https://github.com/emilybrick))
- [#561](https://github.com/primer/primer/pull/561) Add HTML `hidden` attribute docs, increase `[hidden]` selector specificity. ([@shawnbot](https://github.com/shawnbot) h/t @jonrohan)

#### :bug: Bug Fix

- [#604](https://github.com/primer/primer/pull/604) Fix Button group focus ring z-index issues. ([@shawnbot](https://github.com/shawnbot))
- [#570](https://github.com/primer/primer/pull/570) Make `.blankslate-narrow` responsive. ([@crhallberg](https://github.com/crhallberg))
- [#591](https://github.com/primer/primer/pull/591) Add fs-extra to `primer-module-build.dependencies`. ([@shawnbot](https://github.com/shawnbot))

#### :memo: Documentation

- [#585](https://github.com/primer/primer/pull/585) Improve contributing docs and add DEVELOP.md. ([@shawnbot](https://github.com/shawnbot))

#### :house: Internal

- [#597](https://github.com/primer/primer/pull/597) Fix primerize, add "fresh" run-script, etc. ([@shawnbot](https://github.com/shawnbot))

#### Committers: 3

- Chris Hallberg ([crhallberg](https://github.com/crhallberg))
- Emily Brick ([emilybrick](https://github.com/emilybrick))
- Shawn Allen ([shawnbot](https://github.com/shawnbot))

# 10.9.0

#### :rocket: Enhancement

- [#586](https://github.com/primer/primer/pull/586) Hiding .Counter component when it's empty.. ([@jonrohan](https://github.com/jonrohan))
- [#545](https://github.com/primer/primer/pull/545) Simplify responsive utilities with \$responsive-variants. ([@shawnbot](https://github.com/shawnbot))
- [#557](https://github.com/primer/primer/pull/557) Add !important to [hidden]. ([@muan](https://github.com/muan))

#### :memo: Documentation

- [#580](https://github.com/primer/primer/pull/580) Remove invalid button classes. ([@shawnbot](https://github.com/shawnbot))

#### :house: Internal

- [#581](https://github.com/primer/primer/pull/581) Use code-blocks. ([@shawnbot](https://github.com/shawnbot))
- [#530](https://github.com/primer/primer/pull/530) Adding user details to storybook publish script. ([@jonrohan](https://github.com/jonrohan))
- [#579](https://github.com/primer/primer/pull/579) Upgrade to lerna@2.11, rebuild package-lock. ([@shawnbot](https://github.com/shawnbot))

#### Committers: 5

- Jon Rohan ([jonrohan](https://github.com/jonrohan))
- Mickaël Derriey ([mderriey](https://github.com/mderriey))
- Mu-An Chiou ([muan](https://github.com/muan))
- Shawn Allen ([shawnbot](https://github.com/shawnbot))
- Sophie Shepherd ([sophshep](https://github.com/sophshep))

# 10.8.1

#### :bug: Bug Fix

- [#554](https://github.com/primer/primer/pull/554) Fixes peer dependency issues ([@emplums](https://github.com/emplums))

#### :memo: Documentation

- [#554](https://github.com/primer/primer/pull/554) Updates releasing documentation ([@emplums](https://github.com/emplums))

#### :rocket: Enhancement

- [#555](https://github.com/primer/primer/pull/555) Add version check to CI ([@shawnbot](https://github.com/shawnbot))

# 10.8.0

#### :rocket: Enhancement

- [#525](https://github.com/primer/primer/pull/525) Add \$spacer-0 alias. ([@AustinPaquette](https://github.com/AustinPaquette))
- [#522](https://github.com/primer/primer/pull/522) Add .BtnGroup-parent, deprecate .BtnGroup-form. ([@muan](https://github.com/muan))
- [#544](https://github.com/primer/primer/pull/544) Add lh-0 utility class. ([@shawnbot](https://github.com/shawnbot))
- [#548](https://github.com/primer/primer/pull/548) Add text underline utility. ([@AustinPaquette](https://github.com/AustinPaquette))
- [#549](https://github.com/primer/primer/pull/549) Add .user-select-none utility class. ([@AustinPaquette](https://github.com/AustinPaquette))

#### :memo: Documentation

- [#528](https://github.com/primer/primer/pull/528) Update release docs. ([@emplums](https://github.com/emplums))

#### Committers: 3

- Austin Paquette ([AustinPaquette](https://github.com/AustinPaquette))
- Shawn Allen ([shawnbot](https://github.com/shawnbot))
- Mu-An Chiou ([@muan](https://github.com/muan))
- Emily Plummer ([@emplums](https://github.com/emplums))

# 10.7.0

#### :nail_care: Polish

- [#511](https://github.com/primer/primer/pull/511) change double quotes to single quotes in Avatar stack stories. ([@AustinPaquette](https://github.com/AustinPaquette))

#### :memo: Documentation

- [#520](https://github.com/primer/primer/pull/520) Update issue templates. ([@broccolini](https://github.com/broccolini))
- [#516](https://github.com/primer/primer/pull/516) Fix modules/primer-product/README.md. ([@9585999](https://github.com/9585999))
- [#513](https://github.com/primer/primer/pull/513) Deleting the dev branch workflow instructions. ([@jonrohan](https://github.com/jonrohan))
- [#507](https://github.com/primer/primer/pull/507) Moving the color docs to the style guide. ([@jonrohan](https://github.com/jonrohan))

#### :house: Internal

- [#517](https://github.com/primer/primer/pull/517) Modifying notify script to publish from each package. ([@jonrohan](https://github.com/jonrohan))
- [#515](https://github.com/primer/primer/pull/515) Auto publish storybook. ([@jonrohan](https://github.com/jonrohan))
- [#510](https://github.com/primer/primer/pull/510) [WIP] Patch release 10.6.2. ([@shawnbot](https://github.com/shawnbot))

#### Committers: 5

- Austin Paquette ([AustinPaquette](https://github.com/AustinPaquette))
- Diana Mounter ([broccolini](https://github.com/broccolini))
- DieGOs ([9585999](https://github.com/9585999))
- Jon Rohan ([jonrohan](https://github.com/jonrohan))
- Shawn Allen ([shawnbot](https://github.com/shawnbot))

# 10.6.1

#### :bug: Bug Fix

- [#506](https://github.com/primer/primer/pull/506) Fix white border on last avatar in AvatarStack (take two). ([@shawnbot](https://github.com/shawnbot))
- [#501](https://github.com/primer/primer/pull/501) Set different z-index for .details-overlay. ([@muan](https://github.com/muan))

#### Committers: 2

- Shawn Allen ([shawnbot](https://github.com/shawnbot))
- [muan](https://github.com/muan)

# 10.6.0

#### :bug: Bug Fix

- [#491](https://github.com/primer/primer/pull/491) Add `backface-visibility` to `.hover-grow`. ([@brandonrosage](https://github.com/brandonrosage))

#### :memo: Documentation

- [#490](https://github.com/primer/primer/pull/490) Add release documentation. ([@emplums](https://github.com/emplums))

#### :house: Internal

- [#475](https://github.com/primer/primer/pull/475) Import primer-module-build to the monorepo. ([@shawnbot](https://github.com/shawnbot))
- [#479](https://github.com/primer/primer/pull/479) Add "scoreboard" test suite. ([@shawnbot](https://github.com/shawnbot))

#### Committers: 4

- Brandon Rosage ([brandonrosage](https://github.com/brandonrosage))
- Emily ([emplums](https://github.com/emplums))
- Shawn Allen ([shawnbot](https://github.com/shawnbot))
- [muan](https://github.com/muan)

# 10.5.0

#### :rocket: Enhancement

- [#487](https://github.com/primer/primer/pull/487) Import Pagination Component. ([@emplums](https://github.com/emplums))
- [#474](https://github.com/primer/primer/pull/474) Add text-mono utility class. ([@emplums](https://github.com/emplums))
- [#456](https://github.com/primer/primer/pull/456) Adding height-fit utility class. ([@jonrohan](https://github.com/jonrohan))

#### :bug: Bug Fix

- [#465](https://github.com/primer/primer/pull/465) Fix Popover--right-bottom caret positioning. ([@shawnbot](https://github.com/shawnbot))
- [#458](https://github.com/primer/primer/pull/458) Fix broken pointer from packages to modules. ([@tysongach](https://github.com/tysongach))

#### :memo: Documentation

- [#486](https://github.com/primer/primer/pull/486) Documenting the text-inheritance color utility. ([@jonrohan](https://github.com/jonrohan))
- [#481](https://github.com/primer/primer/pull/481) Styleguide Polish. ([@emplums](https://github.com/emplums))
- [#464](https://github.com/primer/primer/pull/464) Fix markdown stories. ([@shawnbot](https://github.com/shawnbot))
- [#455](https://github.com/primer/primer/pull/455) Add colorizeTooltip deprecation warning. ([@jonrohan](https://github.com/jonrohan))
- [#452](https://github.com/primer/primer/pull/452) Update dead links in CONTRIBUTING.md. ([@agisilaos](https://github.com/agisilaos))

#### Committers: 7

- Agisilaos Tsaraboulidis ([agisilaos](https://github.com/agisilaos))
- Catherine Bui ([gladwearefriends](https://github.com/gladwearefriends))
- Emily ([emplums](https://github.com/emplums))
- Jon Rohan ([jonrohan](https://github.com/jonrohan))
- Shawn Allen ([shawnbot](https://github.com/shawnbot))
- Tyson Gach ([tysongach](https://github.com/tysongach))
- [muan](https://github.com/muan)

# 10.4.0 (2018-03-14)

#### :rocket: Enhancement

- [#456](https://github.com/primer/primer/pull/456) Adding height-fit utility class. ([@jonrohan](https://github.com/jonrohan))

#### :memo: Documentation

- [#455](https://github.com/primer/primer/pull/455) Add colorizeTooltip deprecation warning. ([@jonrohan](https://github.com/jonrohan))
- [#452](https://github.com/primer/primer/pull/452) Update dead links in CONTRIBUTING.md. ([@agisilaos](https://github.com/agisilaos))

#### Committers: 3

- Agisilaos Tsaraboulidis ([agisilaos](https://github.com/agisilaos))
- Jon Rohan ([jonrohan](https://github.com/jonrohan))
- [muan](https://github.com/muan)

# 10.3.0 (2018-01-17)

#### :rocket: Enhancement

- [#426](https://github.com/primer/primer/pull/426) Add em spacer variables. ([@broccolini](https://github.com/broccolini))
- [#430](https://github.com/primer/primer/pull/430) Increase input font-size to 16px on mobile. ([@broccolini](https://github.com/broccolini))

#### :bug: Bug Fix

- [#416](https://github.com/primer/primer/pull/416) Point style field to build file in subhead component. ([@muan](https://github.com/muan))
- [#424](https://github.com/primer/primer/pull/424) Add missing $spacer-12 in $marketingSpacers variable. ([@gladwearefriends](https://github.com/gladwearefriends))

#### :nail_care: Polish

- [#418](https://github.com/primer/primer/pull/418) Button color contrast improvements. ([@broccolini](https://github.com/broccolini))

#### :memo: Documentation

- [#427](https://github.com/primer/primer/pull/427) Adding stories from markdown for the other modules that didn't have any stories. ([@jonrohan](https://github.com/jonrohan))

#### :house: Internal

- [#420](https://github.com/primer/primer/pull/420) Update licenses to 2018 🎊. ([@jonrohan](https://github.com/jonrohan))

#### Committers: 4

- Catherine Bui ([gladwearefriends](https://github.com/gladwearefriends))
- Diana Mounter ([broccolini](https://github.com/broccolini))
- Jon Rohan ([jonrohan](https://github.com/jonrohan))
- [muan](https://github.com/muan)

# 10.2.0 (2017-12-11)

#### :rocket: Enhancement

- [#376](https://github.com/primer/primer/pull/376) Extend spacing scale for marketing. ([@gladwearefriends](https://github.com/gladwearefriends))
- [#409](https://github.com/primer/primer/pull/409) Add Sass key to package.json. ([@broccolini](https://github.com/broccolini))
- [#358](https://github.com/primer/primer/pull/358) automatically style first and last breadcrumb. ([@gronke](https://github.com/gronke))
- [#394](https://github.com/primer/primer/pull/394) Point style field to built css. ([@koddsson](https://github.com/koddsson))

#### :memo: Documentation

- [#411](https://github.com/primer/primer/pull/411) Updates to stylelint package links/docs for new structure. ([@jonrohan](https://github.com/jonrohan))

#### Committers: 4

- Catherine Bui ([gladwearefriends](https://github.com/gladwearefriends))
- Diana Mounter ([broccolini](https://github.com/broccolini))
- Jon Rohan ([jonrohan](https://github.com/jonrohan))
- Kristján Oddsson ([koddsson](https://github.com/koddsson))
- Stefan Grönke ([gronke](https://github.com/gronke))

# 10.1.0 (2017-11-15)

#### :rocket: Enhancement

- [#385](https://github.com/primer/primer/pull/385) New Avatar stack. ([@califa](https://github.com/califa) & [@sophshep](https://github.com/sophshep))
- [#404](https://github.com/primer/primer/pull/404) Tooltip component updates ([@broccolini](https://github.com/broccolini))

#### :memo: Documentation

- [#405](https://github.com/primer/primer/pull/405) Add deprecation warning for `.avatar-stack`. ([@jonrohan](https://github.com/jonrohan))
- [#391](https://github.com/primer/primer/pull/391) Update shields.io url to https. ([@NuttasitBoonwat](https://github.com/NuttasitBoonwat))

#### Committers: 5

- Diana Mounter ([broccolini](https://github.com/broccolini))
- Joel Califa ([califa](https://github.com/califa))
- Jon Rohan ([jonrohan](https://github.com/jonrohan))
- Sophie Shepherd ([sophshep](https://github.com/sophshep))
- [NuttasitBoonwat](https://github.com/NuttasitBoonwat)

# 10.0.1 (2017-11-14)

#### :bug: Bug Fix

- Fixing `peerDependencies` to be greater than equal to versions. Fixing version mismatch with buttons and box.

# 10.0.0 (2017-11-13)

#### :boom: Breaking Change

- [#395](https://github.com/primer/primer/pull/395) Renaming primer-css to primer. ([@jonrohan](https://github.com/jonrohan))
- [#379](https://github.com/primer/primer/pull/379) Deprecating primer-cards and form-cards. ([@jonrohan](https://github.com/jonrohan))
- [#336](https://github.com/primer/primer/pull/336) Move `primer-breadcrumbs` from marketing to core ([@jonrohan](<(https://github.com/jonrohan)>)

#### :rocket: Enhancement

- [#371](https://github.com/primer/primer/pull/371) Add .details-reset. ([@muan](https://github.com/muan))
- [#375](https://github.com/primer/primer/pull/375) New utilities & docs - fade out, hover grow, border white fade, responsive positioning, and circle. ([@sophshep](https://github.com/sophshep))
- [#383](https://github.com/primer/primer/pull/383) Add 'Popover' component. ([@brandonrosage](https://github.com/brandonrosage))
- [#377](https://github.com/primer/primer/pull/377) Refactor and add underline nav component. ([@ampinsk](https://github.com/ampinsk))
- [#337](https://github.com/primer/primer/pull/337) Add marketing buttons to primer-marketing. ([@gladwearefriends](https://github.com/gladwearefriends))
- [#342](https://github.com/primer/primer/pull/342) Add Subhead component. ([@shawnbot](https://github.com/shawnbot))
- [#341](https://github.com/primer/primer/pull/341) Add branch-name component from github/github. ([@shawnbot](https://github.com/shawnbot))

#### :bug: Bug Fix

- [#360](https://github.com/primer/primer/pull/360) Remove ::before ::after padding hack on markdown. ([@jonrohan](https://github.com/jonrohan))
- [#320](https://github.com/primer/primer/pull/320) Remove -webkit-text-decoration-skip override. ([@antons](https://github.com/antons))
- [#359](https://github.com/primer/primer/pull/359) Change markdown li break to handle Safari 10.x user stylesheet bug. ([@feministy](https://github.com/feministy))
- [#388](https://github.com/primer/primer/pull/388) Button border-radius fix to override Chroma 62. ([@broccolini](https://github.com/broccolini))
- [#307](https://github.com/primer/primer/pull/307) Do not suppress opacity transition for tooltipped-no-delay. ([@astorije](https://github.com/astorije))

#### :house: Internal

- [#396](https://github.com/primer/primer/pull/396) Use lerna-changelog to generate a changelog. ([@jonrohan](https://github.com/jonrohan))
- [#382](https://github.com/primer/primer/pull/382) Update Button docs. ([@JasonEtco](https://github.com/JasonEtco))
- [#390](https://github.com/primer/primer/pull/390) Updating `storiesFromMarkdown` to read in rails Octicons helper and replace with react component. ([@jonrohan](https://github.com/jonrohan))
- [#389](https://github.com/primer/primer/pull/389) Publish alpha release any time we're not on a release branch or main. ([@jonrohan](https://github.com/jonrohan))
- [#384](https://github.com/primer/primer/pull/384) Add test to check for the current year in the license and source. ([@jonrohan](https://github.com/jonrohan))
- [#374](https://github.com/primer/primer/pull/374) Improve Pull Request template. ([@agisilaos](https://github.com/agisilaos))

#### Committers: 13

- Agisilaos Tsaraboulidis ([agisilaos](https://github.com/agisilaos))
- Amanda Pinsker ([ampinsk](https://github.com/ampinsk))
- Anton Sotkov ([antons](https://github.com/antons))
- Brandon Rosage ([brandonrosage](https://github.com/brandonrosage))
- Catherine Bui ([gladwearefriends](https://github.com/gladwearefriends))
- Diana Mounter ([broccolini](https://github.com/broccolini))
- Jason Etcovitch ([JasonEtco](https://github.com/JasonEtco))
- Jon Rohan ([jonrohan](https://github.com/jonrohan))
- Jérémie Astori ([astorije](https://github.com/astorije))
- Mu-An ✌️ Chiou ([muan](https://github.com/muan))
- Shawn Allen ([shawnbot](https://github.com/shawnbot))
- Sophie Shepherd ([sophshep](https://github.com/sophshep))
- liz abinante! ([feministy](https://github.com/feministy))

**Special thanks to @shaharke for transferring ownership of the Primer npm package to us so that we could make the rename happen!** :heart:

# 9.6.0

### Added

- Storybook. We've added a storybook prototyping environment for testing components in seclusion. To start the server run `npm start`
- Adding yeoman generator for creating a primer module. `generator-primer-module`
- Importing `stylelint-config-primer` from https://github.com/primer/stylelint-config-primer/ into monorepo.
- Importing `stylelint-selector-no-utility` from https://github.com/primer/stylelint-selector-no-utility into monorepo.

### Changes

- Deployment and publishing scripts refinements.

# 9.5.0

### Added

- It's now possible to style `<summary>` elements as buttons and have them appear in the active/selected state when the enclosing [`<details>` element](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/details) is open. #346

### Changes

- Updates our release candidate versioning logic so that prerelease increments are done on a per-module basis, fixing #350.

# 9.4.0

### Added

- Add `v-align-baseline` class to `primer-utilities` #324
- Add deprecation warnings for `primer-cards` and `primer-forms/lib/form-validation.scss` #347 (these will be removed in v10.0.0)

### Changes

- Update npm metadata for `primer`, `primer-core`, `primer-product`, and `primer-marketing` #328
- Remove `HEAD` heading from the changelog #327

# 9.3.0

## Added

- Docs for `primer-layout` (grid), `primer-support`, `primer-utilities`, and `primer-marketing-utilities`
- Primer keys for `category` and `module_type` to `package.json` (for use in documentation and gathering stats)

## Changes

- Removes `docs` from `gitignore`
- Removes the `^` from all dependencies so that we can publish exact versions
- Consolidates release notes from various sources into one changelog located in `/modules/primer/CHANGELOG.md`

# 9.2.0

## Added

- Add `test-docs` npm script in each module to check that every CSS class is documented (or at least mentioned) in the module's own markdown docs

## Changes

- Remove per-module configurations (`.gitignore`, `.postcss.json`, `.stylelintrc.json`) and `CHANGELOG.md` files in #284
- Replace most static `font-size`, `font-weight`, and `line-height` CSS property values with their [SCSS variable equivalents](https://github.com/primer/primer/blob/c9ea37316fbb73c4d9931c52b42bc197260c0bf6/modules/primer-support/lib/variables/typography.scss#L12-L33) in #252
- Refactor CI scripts to use Travis conditional deployment for release candidate and final release publish steps in #290

# 9.1.1

This release updates primer modules to use variables for spacing units instead of pixel values.

## Changes

- primer-alerts: 1.2.0 => 1.2.1
- primer-avatars: 1.1.0 => 1.1.1
- primer-base: 1.2.0 => 1.2.1
- primer-blankslate: 1.1.0 => 1.1.1
- primer-box: 2.2.0 => 2.2.1
- primer-breadcrumb: 1.1.0 => 1.1.1
- primer-buttons: 2.1.0 => 2.1.1
- primer-cards: 0.2.0 => 0.2.1
- primer-core: 6.1.0 => 6.1.1
- primer-css: 9.1.0 => 9.1.1
- primer-forms: 1.1.0 => 1.1.1
- primer-labels: 1.2.0 => 1.2.1
- primer-layout: 1.1.0 => 1.1.1
- primer-markdown: 3.4.0 => 3.4.1
- primer-marketing-type: 1.1.0 => 1.1.1
- primer-marketing-utilities: 1.1.0 => 1.1.1
- primer-marketing: 5.1.0 => 5.1.1
- primer-navigation: 1.1.0 => 1.1.1
- primer-page-headers: 1.1.0 => 1.1.1
- primer-page-sections: 1.1.0 => 1.1.1
- primer-product: 5.1.0 => 5.1.1
- primer-support: 4.1.0 => 4.1.1
- primer-table-object: 1.1.0 => 1.1.1
- primer-tables: 1.1.0 => 1.1.1
- primer-tooltips: 1.1.0 => 1.1.1
- primer-truncate: 1.1.0 => 1.1.1
- primer-utilities: 4.4.0 => 4.4.1

# 9.1.0

This release updates our [stylelint config](/primer/stylelint-config-primer) to [v2.0.0](https://github.com/primer/stylelint-config-primer/releases/tag/v2.0.0), and to stylelint v7.13.0. Each module also now has a `lint` npm script, and there are top-level `test` and `lint` scripts that you can use to lint and test all modules in one go.

This release also includes major improvements to our Travis build scripts to automatically publish PR builds, release candidates, and the "final" versions to npm.

# 9.0.0 - Core dependency & repo urls

We discovered that `primer-core` specified and outdated version of `primer-base` in it's dependencies. The outdated version did not have `normalize.scss` included which could cause some issues. This has issue occurred during v7.0.0 when creating the new monorepo. Also fixes repo urls in `package.json` for individual packages.

See PR [#243](https://github.com/primer/primer/pull/243)

## Changes

### Primer Core v6.0.0

- Fixed `primer-base` dependency to point to latest version

**Repo urls corrected from `packages` to `modules` in:**

- primer-base v1.1.5
- primer-box v2.1.8
- primer-buttons v2.0.6
- primer-forms v1.0.13
- primer-layout v1.0.5
- primer-navigation v1.0.6
- primer-support v4.0.7
- primer-table-object v1.0.9
- primer-tooltips v1.0.2
- primer-truncate v1.0.2
- primer-utilities v4.3.5

### Primer Product v5.0.2

**Repo urls corrected from `packages` to `modules` in:**

- primer-alerts v1.1.8
- primer-avatars v1.0.2
- primer-blankslate v1.0.2
- primer-labels v1.1.6
- primer-markdown v3.3.13
- primer-support v4.0.7

### Primer Marketing v5.0.2

**Repo urls corrected from `packages` to `modules` in:**

- primer-breadcrumb v1.0.2
- primer-cards v0.1.8
- primer-marketing-support v1.0.2
- primer-marketing-type v1.0.2
- primer-marketing-utilities v1.0.2
- primer-page-headers v1.0.2
- primer-page-sections v1.0.2
- primer-support v4.0.7
- primer-tables v1.0.2

# 8.0.0 - Imports

Fixes issues with the ordering of imports in each of our meta-packages. See PR [#239](https://github.com/primer/primer/pull/239)

## Changes

### Primer Core v5.0.1

- Re-ordered imports in `index.scss` to ensure utilities come last in the cascade

### Primer Product v5.0.1

- Re-ordered imports in `index.scss` to move markdown import to end of list to match former setup in GitHub.com

### Primer Marketing v5.0.1

- Re-ordered imports in `index.scss` to ensure marketing utilities come last in the cascade

# 7.0.0 - Monorepo

In an effort to improve our publishing workflow we turned Primer into a monorepo, made this repo the source of truth for Primer by removing Primer modules from GitHub, and setup Lerna for managing multiple packages and maintaining independent versioning for all our modules.

This is exciting because:

- we can spend less time hunting down the cause of a broken build and more time focussing on making Primer more useful and robust for everyone to use
- we can be more confident that changes we publish won't cause unexpected problems on GitHub.com and many other GitHub websites that use Primer
- we no longer have files like package.json, scripts, and readme's in the GitHub app that don't really belong there
- **we can accept pull requests from external contributors** again!

See PR for more details on this change: https://github.com/primer/primer/pull/230

## Other changes:

### Primer Core v4.0.3

#### primer-support v4.0.5

- Update fade color variables to use rgba instead of transparentize color function for better Sass readability
- Update support variables and mixins to use new color variables

#### primer-layout v1.0.3

- Update grid gutter styles naming convention and add responsive modifiers
- Deprecate `single-column` and `table-column` from layout module
- Remove `@include clearfix` from responsive container classes

#### primer-utilities v4.3.3

- Add `show-on-focus` utility class for accessibility
- Update typography utilities to use new color variables
- Add `.p-responsive` class

#### primer-base v1.1.3

- Update `b` tag font weight to use variable in base styles

### Primer Marketing v4.0.3

#### primer-tables

- Update marketing table colors to use new variables

# 6.0.0

- Add `State--small` to labels module
- Fix responsive border utilities
- Added and updated typography variables and mixins; updated variables used in typography utilities; updated margin, padding, and typography readmes
- Darken `.box-shadow-extra-large` shadow
- Update `.tooltip-multiline` to remove `word-break: break-word` property
- Add `.border-purple` utility class
- Add responsive border utilities to primer-marketing
- Add `ws-normal` utility for `whitespace: normal`
- Updated syntax and classnames for `Counters` and `Labels`, moved into combined module with states.

# 5.1.0

- Add negative margin utilities
- Move `.d-flex` & `.d-flex-inline` to be with other display utility classes in `visibility-display.scss`
- Delete `.shade-gradient` in favor of `.bg-shade-gradient`
- Removed alt-body-font variable from primer-marketing
- Removed un-used `alt` typography styles from primer-marketing
- Add green border utility

# 5.0.0

- Added new border variable and utility, replaced deprecated flash border variables
- Updated variable name in form validation
- Updated `.sr-only` to not use negative margin
- Added and removed border variables and utilities
- Add filter utility to Primer Marketing
- Removed all custom color variables within Primer-marketing in favor of the new color system
- Updated style for form group error display so it is positioned properly
- Updated state closed color and text and background pending utilities
- Removed local font css file from primer-marketing/support
- Updated all color variables and replaced 579 hex refs across modules with new variables, added additional shades to start introducing a new color system which required updating nearly all primer modules
- Added layout utility `.sr-only` for creating screen reader only elements
- Added `.flex{-infix}-item-equal` utilities for creating equal width and equal height flex items.
- Added `.flex{-infix}-row-reverse` utility for reversing rows of content
- Updated `.select-menu-button-large` to use `em` units for sizing of the CSS triangle.
- Added `.box-shadow-extra-large` utility for large, diffused shadow
- Updated: removed background color from markdown body
- Updated: remove background on the only item in an avatar stack
- Added form utility `.form-checkbox-details` to allow content to be shown/hidden based on a radio button being checked
- Added form utility to override Webkit's incorrect assumption of where to try to autofill contact information

# 4.7.0

- Update primer modules to use bold variable applying `font-weight: 600`

# 4.6.0

- Added `CircleBadge` component for badge-like displays within product/components/avatars
- Added Box shadow utilities `box-shadow`, `box-shadow-medium`, `box-shadow-large`, `box-shadow-none`
- Moved visibility and display utilities to separate partial at the end of the imports list, moved flexbox to it's own partial
- Added `flex-shrink-0` to address Flexbox Safari bug
- Updated: Using spacing variables in the `.flash` component
- Updated Box component styles and documentation
- Added `.wb-break-all` utility

# 4.4.0

- Adding primer-marketing module to primer
- Added red and blue border color variables and utilities
- Updated: `$spacer-5` has been changed to `32px` from `36px`
- Updated: `$spacer-6` has been changed to `40px` from `48px`
- Deprecated `link-blue`, updated `link-gray` and `link-gray-dark`, added `link-hover-blue` - Updated: blankslate module to use support variables for sizing

# 4.3.0

- Renamed `.flex-table` to `.TableObject`
- Updated: `$spacer-1` has been changed to `4px` from `3px`
- Updated: `$spacer-2` has been changed to `6px` from `8px`
- Added: `.text-shadow-dark` & `.text-shadow-light` utilities
- Updated: Moved non-framework CSS out of Primer modules. Added `box.scss` to `primer-core`. Added `discussion-timeline.scss` to `primer-product`, and moved `blob-csv.scss` into `/primer-product/markdown` directory
- Added: Flex utilities
- Refactor: Site typography to use Primer Marketing styles
- Added: `.list-style-none` utility
- Refactor: Button groups into some cleaner CSS
- Updated: Reorganizing how we separate primer-core, primer-product, primer-marketing css

# 4.2.0

- Added: Responsive styles for margin and padding utilities, display, float, and new responsive hide utility, and updates to make typography responsive
- Added: new container styles and grid styles with responsive options
- Added: updated underline nav styles
- Deprecate: Deprecating a lot of color and layout utilities
- Added: More type utilities for different weights and larger sizes.
- Added: Well defined browser support

# 4.1.0

- Added: [primer-markdown](https://github.com/primer/markdown) to the build
- Fixes: Pointing "style" package.json to `build/build.css` file.
- Added: Update font stack to system fonts
- Added: Updated type scale as part of system font update
- Added: `.Box` component for replacing boxed groups, simple box, and table-list styles
- Added: New type utilities for headings and line-height
- Deprecated: `vertical-middle` was replaced with `v-align-middle`.
- Added: Layout utilities for vertical alignment, overflow, width and height, visibility, and display table
- Added: Changing from font icons to SVG

# 4.0.2

- Added npm build scripts to add `build/build.css` to the npm package

# 4.0.1

- Fixed: missing primer-layout from build

# 4.0.0

- Whole new npm build system, pulling in the code from separate component repos

# 3.0.0

- Added: Animation utilities
- Added: Whitespace scale, and margin and padding utilities
- Added: Border utilities
