'use client';
import { ObjectUtils } from 'primereact/utils';
import React, { useState } from 'react';

var FilterMatchMode = Object.freeze({
  STARTS_WITH: 'startsWith',
  CONTAINS: 'contains',
  NOT_CONTAINS: 'notContains',
  ENDS_WITH: 'endsWith',
  EQUALS: 'equals',
  NOT_EQUALS: 'notEquals',
  IN: 'in',
  LESS_THAN: 'lt',
  LESS_THAN_OR_EQUAL_TO: 'lte',
  GREATER_THAN: 'gt',
  GREATER_THAN_OR_EQUAL_TO: 'gte',
  BETWEEN: 'between',
  DATE_IS: 'dateIs',
  DATE_IS_NOT: 'dateIsNot',
  DATE_BEFORE: 'dateBefore',
  DATE_AFTER: 'dateAfter',
  CUSTOM: 'custom'
});

var FilterOperator = Object.freeze({
  AND: 'and',
  OR: 'or'
});

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray$1(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray$1(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray$1(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$1(o, minLen); }
function _arrayLikeToArray$1(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
var FilterService = {
  filter: function filter(value, fields, filterValue, filterMatchMode, filterLocale) {
    var filteredItems = [];
    if (!value) {
      return filteredItems;
    }
    var _iterator = _createForOfIteratorHelper(value),
      _step;
    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var item = _step.value;
        if (typeof item === 'string') {
          if (this.filters[filterMatchMode](item, filterValue, filterLocale)) {
            filteredItems.push(item);
            continue;
          }
        } else {
          var _iterator2 = _createForOfIteratorHelper(fields),
            _step2;
          try {
            for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
              var field = _step2.value;
              var fieldValue = ObjectUtils.resolveFieldData(item, field);
              if (this.filters[filterMatchMode](fieldValue, filterValue, filterLocale)) {
                filteredItems.push(item);
                break;
              }
            }
          } catch (err) {
            _iterator2.e(err);
          } finally {
            _iterator2.f();
          }
        }
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }
    return filteredItems;
  },
  filters: {
    startsWith: function startsWith(value, filter, filterLocale) {
      if (filter === undefined || filter === null || filter.trim() === '') {
        return true;
      }
      if (value === undefined || value === null) {
        return false;
      }
      var filterValue = ObjectUtils.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);
      var stringValue = ObjectUtils.removeAccents(value.toString()).toLocaleLowerCase(filterLocale);
      return stringValue.slice(0, filterValue.length) === filterValue;
    },
    contains: function contains(value, filter, filterLocale) {
      if (filter === undefined || filter === null || typeof filter === 'string' && filter.trim() === '') {
        return true;
      }
      if (value === undefined || value === null) {
        return false;
      }
      var filterValue = ObjectUtils.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);
      var stringValue = ObjectUtils.removeAccents(value.toString()).toLocaleLowerCase(filterLocale);
      return stringValue.indexOf(filterValue) !== -1;
    },
    notContains: function notContains(value, filter, filterLocale) {
      if (filter === undefined || filter === null || typeof filter === 'string' && filter.trim() === '') {
        return true;
      }
      if (value === undefined || value === null) {
        return false;
      }
      var filterValue = ObjectUtils.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);
      var stringValue = ObjectUtils.removeAccents(value.toString()).toLocaleLowerCase(filterLocale);
      return stringValue.indexOf(filterValue) === -1;
    },
    endsWith: function endsWith(value, filter, filterLocale) {
      if (filter === undefined || filter === null || filter.trim() === '') {
        return true;
      }
      if (value === undefined || value === null) {
        return false;
      }
      var filterValue = ObjectUtils.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);
      var stringValue = ObjectUtils.removeAccents(value.toString()).toLocaleLowerCase(filterLocale);
      return stringValue.indexOf(filterValue, stringValue.length - filterValue.length) !== -1;
    },
    equals: function equals(value, filter, filterLocale) {
      if (filter === undefined || filter === null || typeof filter === 'string' && filter.trim() === '') {
        return true;
      }
      if (value === undefined || value === null) {
        return false;
      }
      if (value.getTime && filter.getTime) return value.getTime() === filter.getTime();else return ObjectUtils.removeAccents(value.toString()).toLocaleLowerCase(filterLocale) === ObjectUtils.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);
    },
    notEquals: function notEquals(value, filter, filterLocale) {
      if (filter === undefined || filter === null || typeof filter === 'string' && filter.trim() === '') {
        return true;
      }
      if (value === undefined || value === null) {
        return true;
      }
      if (value.getTime && filter.getTime) return value.getTime() !== filter.getTime();else return ObjectUtils.removeAccents(value.toString()).toLocaleLowerCase(filterLocale) !== ObjectUtils.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);
    },
    "in": function _in(value, filter) {
      if (filter === undefined || filter === null || filter.length === 0) {
        return true;
      }
      for (var i = 0; i < filter.length; i++) {
        if (ObjectUtils.equals(value, filter[i])) {
          return true;
        }
      }
      return false;
    },
    between: function between(value, filter) {
      if (filter == null || filter[0] == null || filter[1] == null) {
        return true;
      }
      if (value === undefined || value === null) {
        return false;
      }
      if (value.getTime) return filter[0].getTime() <= value.getTime() && value.getTime() <= filter[1].getTime();else return filter[0] <= value && value <= filter[1];
    },
    lt: function lt(value, filter) {
      if (filter === undefined || filter === null) {
        return true;
      }
      if (value === undefined || value === null) {
        return false;
      }
      if (value.getTime && filter.getTime) return value.getTime() < filter.getTime();else return value < filter;
    },
    lte: function lte(value, filter) {
      if (filter === undefined || filter === null) {
        return true;
      }
      if (value === undefined || value === null) {
        return false;
      }
      if (value.getTime && filter.getTime) return value.getTime() <= filter.getTime();else return value <= filter;
    },
    gt: function gt(value, filter) {
      if (filter === undefined || filter === null) {
        return true;
      }
      if (value === undefined || value === null) {
        return false;
      }
      if (value.getTime && filter.getTime) return value.getTime() > filter.getTime();else return value > filter;
    },
    gte: function gte(value, filter) {
      if (filter === undefined || filter === null) {
        return true;
      }
      if (value === undefined || value === null) {
        return false;
      }
      if (value.getTime && filter.getTime) return value.getTime() >= filter.getTime();else return value >= filter;
    },
    dateIs: function dateIs(value, filter) {
      if (filter === undefined || filter === null) {
        return true;
      }
      if (value === undefined || value === null) {
        return false;
      }
      return value.toDateString() === filter.toDateString();
    },
    dateIsNot: function dateIsNot(value, filter) {
      if (filter === undefined || filter === null) {
        return true;
      }
      if (value === undefined || value === null) {
        return false;
      }
      return value.toDateString() !== filter.toDateString();
    },
    dateBefore: function dateBefore(value, filter) {
      if (filter === undefined || filter === null) {
        return true;
      }
      if (value === undefined || value === null) {
        return false;
      }
      return value.getTime() < filter.getTime();
    },
    dateAfter: function dateAfter(value, filter) {
      if (filter === undefined || filter === null) {
        return true;
      }
      if (value === undefined || value === null) {
        return false;
      }
      return value.getTime() > filter.getTime();
    }
  },
  register: function register(rule, fn) {
    this.filters[rule] = fn;
  }
};

function _typeof(o) {
  "@babel/helpers - typeof";

  return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) {
    return typeof o;
  } : function (o) {
    return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o;
  }, _typeof(o);
}

function _toPrimitive(input, hint) {
  if (_typeof(input) !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== undefined) {
    var res = prim.call(input, hint || "default");
    if (_typeof(res) !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}

function _toPropertyKey(arg) {
  var key = _toPrimitive(arg, "string");
  return _typeof(key) === "symbol" ? key : String(key);
}

function _defineProperty(obj, key, value) {
  key = _toPropertyKey(key);
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }
  return obj;
}

function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;
    Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor);
  }
}
function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties(Constructor, staticProps);
  Object.defineProperty(Constructor, "prototype", {
    writable: false
  });
  return Constructor;
}

function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}

/**
 * @deprecated please use PrimeReactContext
 */
var PrimeReact$1 = /*#__PURE__*/_createClass(function PrimeReact() {
  _classCallCheck(this, PrimeReact);
});
_defineProperty(PrimeReact$1, "ripple", false);
_defineProperty(PrimeReact$1, "inputStyle", 'outlined');
_defineProperty(PrimeReact$1, "locale", 'en');
_defineProperty(PrimeReact$1, "appendTo", null);
_defineProperty(PrimeReact$1, "cssTransition", true);
_defineProperty(PrimeReact$1, "autoZIndex", true);
_defineProperty(PrimeReact$1, "hideOverlaysOnDocumentScrolling", false);
_defineProperty(PrimeReact$1, "nonce", null);
_defineProperty(PrimeReact$1, "nullSortOrder", 1);
_defineProperty(PrimeReact$1, "zIndex", {
  modal: 1100,
  overlay: 1000,
  menu: 1000,
  tooltip: 1100,
  toast: 1200
});
_defineProperty(PrimeReact$1, "pt", undefined);
_defineProperty(PrimeReact$1, "filterMatchModeOptions", {
  text: [FilterMatchMode.STARTS_WITH, FilterMatchMode.CONTAINS, FilterMatchMode.NOT_CONTAINS, FilterMatchMode.ENDS_WITH, FilterMatchMode.EQUALS, FilterMatchMode.NOT_EQUALS],
  numeric: [FilterMatchMode.EQUALS, FilterMatchMode.NOT_EQUALS, FilterMatchMode.LESS_THAN, FilterMatchMode.LESS_THAN_OR_EQUAL_TO, FilterMatchMode.GREATER_THAN, FilterMatchMode.GREATER_THAN_OR_EQUAL_TO],
  date: [FilterMatchMode.DATE_IS, FilterMatchMode.DATE_IS_NOT, FilterMatchMode.DATE_BEFORE, FilterMatchMode.DATE_AFTER]
});
_defineProperty(PrimeReact$1, "changeTheme", function (currentTheme, newTheme, linkElementId, callback) {
  var _linkElement$parentNo;
  var linkElement = document.getElementById(linkElementId);
  var cloneLinkElement = linkElement.cloneNode(true);
  var newThemeUrl = linkElement.getAttribute('href').replace(currentTheme, newTheme);
  cloneLinkElement.setAttribute('id', linkElementId + '-clone');
  cloneLinkElement.setAttribute('href', newThemeUrl);
  cloneLinkElement.addEventListener('load', function () {
    linkElement.remove();
    cloneLinkElement.setAttribute('id', linkElementId);
    if (callback) {
      callback();
    }
  });
  (_linkElement$parentNo = linkElement.parentNode) === null || _linkElement$parentNo === void 0 || _linkElement$parentNo.insertBefore(cloneLinkElement, linkElement.nextSibling);
});

function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var locales = {
  en: {
    startsWith: 'Starts with',
    contains: 'Contains',
    notContains: 'Not contains',
    endsWith: 'Ends with',
    equals: 'Equals',
    notEquals: 'Not equals',
    noFilter: 'No Filter',
    filter: 'Filter',
    lt: 'Less than',
    lte: 'Less than or equal to',
    gt: 'Greater than',
    gte: 'Greater than or equal to',
    dateIs: 'Date is',
    dateIsNot: 'Date is not',
    dateBefore: 'Date is before',
    dateAfter: 'Date is after',
    custom: 'Custom',
    clear: 'Clear',
    close: 'Close',
    apply: 'Apply',
    matchAll: 'Match All',
    matchAny: 'Match Any',
    addRule: 'Add Rule',
    removeRule: 'Remove Rule',
    accept: 'Yes',
    reject: 'No',
    choose: 'Choose',
    upload: 'Upload',
    cancel: 'Cancel',
    completed: 'Completed',
    pending: 'Pending',
    fileSizeTypes: ['B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'],
    dayNames: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'],
    dayNamesShort: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
    dayNamesMin: ['Su', 'Mo', 'Tu', 'We', 'Th', 'Fr', 'Sa'],
    monthNames: ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'],
    monthNamesShort: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
    today: 'Today',
    weekHeader: 'Wk',
    firstDayOfWeek: 0,
    showMonthAfterYear: false,
    dateFormat: 'mm/dd/yy',
    weak: 'Weak',
    medium: 'Medium',
    strong: 'Strong',
    passwordPrompt: 'Enter a password',
    emptyFilterMessage: 'No available options',
    emptyMessage: 'No results found',
    aria: {
      trueLabel: 'True',
      falseLabel: 'False',
      nullLabel: 'Not Selected',
      star: '1 star',
      stars: '{star} stars',
      selectAll: 'All items selected',
      unselectAll: 'All items unselected',
      close: 'Close',
      previous: 'Previous',
      next: 'Next',
      navigation: 'Navigation',
      scrollTop: 'Scroll Top',
      moveTop: 'Move Top',
      moveUp: 'Move Up',
      moveDown: 'Move Down',
      moveBottom: 'Move Bottom',
      moveToTarget: 'Move to Target',
      moveToSource: 'Move to Source',
      moveAllToTarget: 'Move All to Target',
      moveAllToSource: 'Move All to Source',
      pageLabel: 'Page {page}',
      firstPageLabel: 'First Page',
      lastPageLabel: 'Last Page',
      nextPageLabel: 'Next Page',
      previousPageLabel: 'Previous Page',
      rowsPerPageLabel: 'Rows per page',
      jumpToPageDropdownLabel: 'Jump to Page Dropdown',
      jumpToPageInputLabel: 'Jump to Page Input',
      selectRow: 'Row Selected',
      unselectRow: 'Row Unselected',
      expandRow: 'Row Expanded',
      collapseRow: 'Row Collapsed',
      showFilterMenu: 'Show Filter Menu',
      hideFilterMenu: 'Hide Filter Menu',
      filterOperator: 'Filter Operator',
      filterConstraint: 'Filter Constraint',
      editRow: 'Row Edit',
      saveEdit: 'Save Edit',
      cancelEdit: 'Cancel Edit',
      listView: 'List View',
      gridView: 'Grid View',
      slide: 'Slide',
      slideNumber: '{slideNumber}',
      zoomImage: 'Zoom Image',
      zoomIn: 'Zoom In',
      zoomOut: 'Zoom Out',
      rotateRight: 'Rotate Right',
      rotateLeft: 'Rotate Left',
      selectLabel: 'Select',
      unselectLabel: 'Unselect',
      expandLabel: 'Expand',
      collapseLabel: 'Collapse'
    }
  }
};
function locale(locale) {
  locale && (PrimeReact$1.locale = locale);
  return {
    locale: PrimeReact$1.locale,
    options: locales[PrimeReact$1.locale]
  };
}
function addLocale(locale, options) {
  locales[locale] = _objectSpread(_objectSpread({}, locales['en']), options);
}
function updateLocaleOption(key, value, locale) {
  localeOptions(locale)[key] = value;
}
function updateLocaleOptions(options, locale) {
  var _locale = locale || PrimeReact$1.locale;
  locales[_locale] = _objectSpread(_objectSpread({}, locales[_locale]), options);
}
function localeOption(key, locale) {
  var _locale = locale || PrimeReact$1.locale;
  try {
    return localeOptions(_locale)[key];
  } catch (error) {
    throw new Error("The ".concat(key, " option is not found in the current locale('").concat(_locale, "')."));
  }
}

/**
 * Find an ARIA label in the locale by key.  If options are passed it will replace all options:
 * ```ts
 * const ariaValue = "Page {page}, User {user}, Role {role}";
 * const options = { page: 2, user: "John", role: "Admin" };
 * const result = ariaLabel('yourLabel', { page: 2, user: "John", role: "Admin" })
 * console.log(result); // Output: Page 2, User John, Role Admin
 * ```
 * @param {string} ariaKey key of the ARIA label to look up in locale.
 * @param {any} options JSON options like { page: 2, user: "John", role: "Admin" }
 * @returns the ARIA label with replaced values
 */
function ariaLabel(ariaKey, options) {
  var _locale = PrimeReact$1.locale;
  try {
    var _ariaLabel = localeOptions(_locale)['aria'][ariaKey];
    if (_ariaLabel) {
      for (var key in options) {
        if (options.hasOwnProperty(key)) {
          _ariaLabel = _ariaLabel.replace("{".concat(key, "}"), options[key]);
        }
      }
    }
    return _ariaLabel;
  } catch (error) {
    throw new Error("The ".concat(ariaKey, " option is not found in the current locale('").concat(_locale, "')."));
  }
}
function localeOptions(locale) {
  var _locale = locale || PrimeReact$1.locale;
  return locales[_locale];
}

var MessageSeverity = Object.freeze({
  SUCCESS: 'success',
  INFO: 'info',
  WARN: 'warn',
  ERROR: 'error'
});

var PrimeIcons = Object.freeze({
  ALIGN_CENTER: 'pi pi-align-center',
  ALIGN_JUSTIFY: 'pi pi-align-justify',
  ALIGN_LEFT: 'pi pi-align-left',
  ALIGN_RIGHT: 'pi pi-align-right',
  AMAZON: 'pi pi-amazon',
  ANDROID: 'pi pi-android',
  ANGLE_DOUBLE_DOWN: 'pi pi-angle-double-down',
  ANGLE_DOUBLE_LEFT: 'pi pi-angle-double-left',
  ANGLE_DOUBLE_RIGHT: 'pi pi-angle-double-right',
  ANGLE_DOUBLE_UP: 'pi pi-angle-double-up',
  ANGLE_DOWN: 'pi pi-angle-down',
  ANGLE_LEFT: 'pi pi-angle-left',
  ANGLE_RIGHT: 'pi pi-angle-right',
  ANGLE_UP: 'pi pi-angle-up',
  APPLE: 'pi pi-apple',
  ARROW_CIRCLE_DOWN: 'pi pi-arrow-circle-down',
  ARROW_CIRCLE_LEFT: 'pi pi-arrow-circle-left',
  ARROW_CIRCLE_RIGHT: 'pi pi-arrow-circle-right',
  ARROW_CIRCLE_UP: 'pi pi-arrow-circle-up',
  ARROW_DOWN: 'pi pi-arrow-down',
  ARROW_DOWN_LEFT: 'pi pi-arrow-down-left',
  ARROW_DOWN_RIGHT: 'pi pi-arrow-down-right',
  ARROW_LEFT: 'pi pi-arrow-left',
  ARROW_RIGHT: 'pi pi-arrow-right',
  ARROW_RIGHT_ARROW_LEFT: 'pi pi-arrow-right-arrow-left',
  ARROW_UP: 'pi pi-arrow-up',
  ARROW_UP_LEFT: 'pi pi-arrow-up-left',
  ARROW_UP_RIGHT: 'pi pi-arrow-up-right',
  ARROWS_ALT: 'pi pi-arrows-alt',
  ARROWS_H: 'pi pi-arrows-h',
  ARROWS_V: 'pi pi-arrows-v',
  AT: 'pi pi-at',
  BACKWARD: 'pi pi-backward',
  BAN: 'pi pi-ban',
  BARS: 'pi pi-bars',
  BELL: 'pi pi-bell',
  BITCOIN: 'pi pi-bitcoin',
  BOLT: 'pi pi-bolt',
  BOOK: 'pi pi-book',
  BOOKMARK: 'pi pi-bookmark',
  BOOKMARK_FILL: 'pi pi-bookmark-fill',
  BOX: 'pi pi-box',
  BRIEFCASE: 'pi pi-briefcase',
  BUILDING: 'pi pi-building',
  CALCULATOR: 'pi pi-calculator',
  CALENDAR: 'pi pi-calendar',
  CALENDAR_MINUS: 'pi pi-calendar-minus',
  CALENDAR_PLUS: 'pi pi-calendar-plus',
  CALENDAR_TIMES: 'pi pi-calendar-times',
  CAMERA: 'pi pi-camera',
  CAR: 'pi pi-car',
  CARET_DOWN: 'pi pi-caret-down',
  CARET_LEFT: 'pi pi-caret-left',
  CARET_RIGHT: 'pi pi-caret-right',
  CARET_UP: 'pi pi-caret-up',
  CART_PLUS: 'pi pi-cart-plus',
  CHART_BAR: 'pi pi-chart-bar',
  CHART_LINE: 'pi pi-chart-line',
  CHART_PIE: 'pi pi-chart-pie',
  CHECK: 'pi pi-check',
  CHECK_CIRCLE: 'pi pi-check-circle',
  CHECK_SQUARE: 'pi pi-check-square',
  CHEVRON_CIRCLE_DOWN: 'pi pi-chevron-circle-down',
  CHEVRON_CIRCLE_LEFT: 'pi pi-chevron-circle-left',
  CHEVRON_CIRCLE_RIGHT: 'pi pi-chevron-circle-right',
  CHEVRON_CIRCLE_UP: 'pi pi-chevron-circle-up',
  CHEVRON_DOWN: 'pi pi-chevron-down',
  CHEVRON_LEFT: 'pi pi-chevron-left',
  CHEVRON_RIGHT: 'pi pi-chevron-right',
  CHEVRON_UP: 'pi pi-chevron-up',
  CIRCLE: 'pi pi-circle',
  CIRCLE_FILL: 'pi pi-circle-fill',
  CIRCLE_OFF: 'pi pi-circle-off',
  CIRCLE_ON: 'pi pi-circle-on',
  CLOCK: 'pi pi-clock',
  CLONE: 'pi pi-clone',
  CLOUD: 'pi pi-cloud',
  CLOUD_DOWNLOAD: 'pi pi-cloud-download',
  CLOUD_UPLOAD: 'pi pi-cloud-upload',
  CODE: 'pi pi-code',
  COG: 'pi pi-cog',
  COMMENT: 'pi pi-comment',
  COMMENTS: 'pi pi-comments',
  COMPASS: 'pi pi-compass',
  COPY: 'pi pi-copy',
  CREDIT_CARD: 'pi pi-credit-card',
  DATABASE: 'pi pi-database',
  DELETE_LEFT: 'pi pi-delete-left',
  DESKTOP: 'pi pi-desktop',
  DIRECTIONS: 'pi pi-directions',
  DIRECTIONS_ALT: 'pi pi-directions-alt',
  DISCORD: 'pi pi-discord',
  DOLLAR: 'pi pi-dollar',
  DOWNLOAD: 'pi pi-download',
  EJECT: 'pi pi-eject',
  ELLIPSIS_H: 'pi pi-ellipsis-h',
  ELLIPSIS_V: 'pi pi-ellipsis-v',
  ENVELOPE: 'pi pi-envelope',
  ERASER: 'pi pi-eraser',
  EURO: 'pi pi-euro',
  EXCLAMATION_CIRCLE: 'pi pi-exclamation-circle',
  EXCLAMATION_TRIANGLE: 'pi pi-exclamation-triangle',
  EXTERNAL_LINK: 'pi pi-external-link',
  EYE: 'pi pi-eye',
  EYE_SLASH: 'pi pi-eye-slash',
  FACEBOOK: 'pi pi-facebook',
  FAST_BACKWARD: 'pi pi-fast-backward',
  FAST_FORWARD: 'pi pi-fast-forward',
  FILE: 'pi pi-file',
  FILE_EDIT: 'pi pi-file-edit',
  FILE_EXCEL: 'pi pi-file-excel',
  FILE_EXPORT: 'pi pi-file-export',
  FILE_IMPORT: 'pi pi-file-import',
  FILE_O: 'pi pi-file-o',
  FILE_PDF: 'pi pi-file-pdf',
  FILE_WORD: 'pi pi-file-word',
  FILTER: 'pi pi-filter',
  FILTER_FILL: 'pi pi-filter-fill',
  FILTER_SLASH: 'pi pi-filter-slash',
  FLAG: 'pi pi-flag',
  FLAG_FILL: 'pi pi-flag-fill',
  FOLDER: 'pi pi-folder',
  FOLDER_OPEN: 'pi pi-folder-open',
  FORWARD: 'pi pi-forward',
  GIFT: 'pi pi-gift',
  GITHUB: 'pi pi-github',
  GLOBE: 'pi pi-globe',
  GOOGLE: 'pi pi-google',
  HASHTAG: 'pi pi-hashtag',
  HEART: 'pi pi-heart',
  HEART_FILL: 'pi pi-heart-fill',
  HISTORY: 'pi pi-history',
  HOME: 'pi pi-home',
  HOURGLASS: 'pi pi-hourglass',
  ID_CARD: 'pi pi-id-card',
  IMAGE: 'pi pi-image',
  IMAGES: 'pi pi-images',
  INBOX: 'pi pi-inbox',
  INFO: 'pi pi-info',
  INFO_CIRCLE: 'pi pi-info-circle',
  INSTAGRAM: 'pi pi-instagram',
  KEY: 'pi pi-key',
  LANGUAGE: 'pi pi-language',
  LINK: 'pi pi-link',
  LINKEDIN: 'pi pi-linkedin',
  LIST: 'pi pi-list',
  LOCK: 'pi pi-lock',
  LOCK_OPEN: 'pi pi-lock-open',
  MAP: 'pi pi-map',
  MAP_MARKER: 'pi pi-map-marker',
  MEGAPHONE: 'pi pi-megaphone',
  MICROPHONE: 'pi pi-microphone',
  MICROSOFT: 'pi pi-microsoft',
  MINUS: 'pi pi-minus',
  MINUS_CIRCLE: 'pi pi-minus-circle',
  MOBILE: 'pi pi-mobile',
  MONEY_BILL: 'pi pi-money-bill',
  MOON: 'pi pi-moon',
  PALETTE: 'pi pi-palette',
  PAPERCLIP: 'pi pi-paperclip',
  PAUSE: 'pi pi-pause',
  PAYPAL: 'pi pi-paypal',
  PENCIL: 'pi pi-pencil',
  PERCENTAGE: 'pi pi-percentage',
  PHONE: 'pi pi-phone',
  PLAY: 'pi pi-play',
  PLUS: 'pi pi-plus',
  PLUS_CIRCLE: 'pi pi-plus-circle',
  POUND: 'pi pi-pound',
  POWER_OFF: 'pi pi-power-off',
  PRIME: 'pi pi-prime',
  PRINT: 'pi pi-print',
  QRCODE: 'pi pi-qrcode',
  QUESTION: 'pi pi-question',
  QUESTION_CIRCLE: 'pi pi-question-circle',
  REDDIT: 'pi pi-reddit',
  REFRESH: 'pi pi-refresh',
  REPLAY: 'pi pi-replay',
  REPLY: 'pi pi-reply',
  SAVE: 'pi pi-save',
  SEARCH: 'pi pi-search',
  SEARCH_MINUS: 'pi pi-search-minus',
  SEARCH_PLUS: 'pi pi-search-plus',
  SEND: 'pi pi-send',
  SERVER: 'pi pi-server',
  SHARE_ALT: 'pi pi-share-alt',
  SHIELD: 'pi pi-shield',
  SHOPPING_BAG: 'pi pi-shopping-bag',
  SHOPPING_CART: 'pi pi-shopping-cart',
  SIGN_IN: 'pi pi-sign-in',
  SIGN_OUT: 'pi pi-sign-out',
  SITEMAP: 'pi pi-sitemap',
  SLACK: 'pi pi-slack',
  SLIDERS_H: 'pi pi-sliders-h',
  SLIDERS_V: 'pi pi-sliders-v',
  SORT: 'pi pi-sort',
  SORT_ALPHA_DOWN: 'pi pi-sort-alpha-down',
  SORT_ALPHA_DOWN_ALT: 'pi pi-sort-alpha-down-alt',
  SORT_ALPHA_UP: 'pi pi-sort-alpha-up',
  SORT_ALPHA_UP_ALT: 'pi pi-sort-alpha-up-alt',
  SORT_ALT: 'pi pi-sort-alt',
  SORT_ALT_SLASH: 'pi pi-sort-alt-slash',
  SORT_AMOUNT_DOWN: 'pi pi-sort-amount-down',
  SORT_AMOUNT_DOWN_ALT: 'pi pi-sort-amount-down-alt',
  SORT_AMOUNT_UP: 'pi pi-sort-amount-up',
  SORT_AMOUNT_UP_ALT: 'pi pi-sort-amount-up-alt',
  SORT_DOWN: 'pi pi-sort-down',
  SORT_NUMERIC_DOWN: 'pi pi-sort-numeric-down',
  SORT_NUMERIC_DOWN_ALT: 'pi pi-sort-numeric-down-alt',
  SORT_NUMERIC_UP: 'pi pi-sort-numeric-up',
  SORT_NUMERIC_UP_ALT: 'pi pi-sort-numeric-up-alt',
  SORT_UP: 'pi pi-sort-up',
  SPINNER: 'pi pi-spinner',
  STAR: 'pi pi-star',
  STAR_FILL: 'pi pi-star-fill',
  STEP_BACKWARD: 'pi pi-step-backward',
  STEP_BACKWARD_ALT: 'pi pi-step-backward-alt',
  STEP_FORWARD: 'pi pi-step-forward',
  STEP_FORWARD_ALT: 'pi pi-step-forward-alt',
  STOP: 'pi pi-stop',
  STOP_CIRCLE: 'pi pi-stop-circle',
  STOPWATCH: 'pi pi-stopwatch',
  SUN: 'pi pi-sun',
  SYNC: 'pi pi-sync',
  TABLE: 'pi pi-table',
  TABLET: 'pi pi-tablet',
  TAG: 'pi pi-tag',
  TAGS: 'pi pi-tags',
  TELEGRAM: 'pi pi-telegram',
  TH_LARGE: 'pi pi-th-large',
  THUMBS_DOWN: 'pi pi-thumbs-down',
  THUMBS_DOWN_FILL: 'pi pi-thumbs-down-fill',
  THUMBS_UP: 'pi pi-thumbs-up',
  THUMBS_UP_FILL: 'pi pi-thumbs-up-fill',
  TICKET: 'pi pi-ticket',
  TIMES: 'pi pi-times',
  TIMES_CIRCLE: 'pi pi-times-circle',
  TRASH: 'pi pi-trash',
  TRUCK: 'pi pi-truck',
  TWITTER: 'pi pi-twitter',
  UNDO: 'pi pi-undo',
  UNLOCK: 'pi pi-unlock',
  UPLOAD: 'pi pi-upload',
  USER: 'pi pi-user',
  USER_EDIT: 'pi pi-user-edit',
  USER_MINUS: 'pi pi-user-minus',
  USER_PLUS: 'pi pi-user-plus',
  USERS: 'pi pi-users',
  VERIFIED: 'pi pi-verified',
  VIDEO: 'pi pi-video',
  VIMEO: 'pi pi-vimeo',
  VOLUME_DOWN: 'pi pi-volume-down',
  VOLUME_OFF: 'pi pi-volume-off',
  VOLUME_UP: 'pi pi-volume-up',
  WALLET: 'pi pi-wallet',
  WHATSAPP: 'pi pi-whatsapp',
  WIFI: 'pi pi-wifi',
  WINDOW_MAXIMIZE: 'pi pi-window-maximize',
  WINDOW_MINIMIZE: 'pi pi-window-minimize',
  WRENCH: 'pi pi-wrench',
  YOUTUBE: 'pi pi-youtube'
});

var SortOrder = Object.freeze({
  DESC: -1,
  UNSORTED: 0,
  ASC: 1
});

function _arrayWithHoles(arr) {
  if (Array.isArray(arr)) return arr;
}

function _iterableToArrayLimit(r, l) {
  var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"];
  if (null != t) {
    var e,
      n,
      i,
      u,
      a = [],
      f = !0,
      o = !1;
    try {
      if (i = (t = t.call(r)).next, 0 === l) {
        if (Object(t) !== t) return;
        f = !1;
      } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0);
    } catch (r) {
      o = !0, n = r;
    } finally {
      try {
        if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return;
      } finally {
        if (o) throw n;
      }
    }
    return a;
  }
}

function _arrayLikeToArray(arr, len) {
  if (len == null || len > arr.length) len = arr.length;
  for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];
  return arr2;
}

function _unsupportedIterableToArray(o, minLen) {
  if (!o) return;
  if (typeof o === "string") return _arrayLikeToArray(o, minLen);
  var n = Object.prototype.toString.call(o).slice(8, -1);
  if (n === "Object" && o.constructor) n = o.constructor.name;
  if (n === "Map" || n === "Set") return Array.from(o);
  if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
}

function _nonIterableRest() {
  throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}

function _slicedToArray(arr, i) {
  return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest();
}

var PrimeReactContext = /*#__PURE__*/React.createContext();
var PrimeReactProvider = function PrimeReactProvider(props) {
  var propsValue = props.value || {};
  var _useState = useState(propsValue.ripple || false),
    _useState2 = _slicedToArray(_useState, 2),
    ripple = _useState2[0],
    setRipple = _useState2[1];
  var _useState3 = useState(propsValue.inputStyle || 'outlined'),
    _useState4 = _slicedToArray(_useState3, 2),
    inputStyle = _useState4[0],
    setInputStyle = _useState4[1];
  var _useState5 = useState(propsValue.locale || 'en'),
    _useState6 = _slicedToArray(_useState5, 2),
    locale = _useState6[0],
    setLocale = _useState6[1];
  var _useState7 = useState(propsValue.appendTo || null),
    _useState8 = _slicedToArray(_useState7, 2),
    appendTo = _useState8[0],
    setAppendTo = _useState8[1];
  var _useState9 = useState(propsValue.styleContainer || null),
    _useState10 = _slicedToArray(_useState9, 2),
    styleContainer = _useState10[0],
    setStyleContainer = _useState10[1];
  var _useState11 = useState(propsValue.cssTransition || true),
    _useState12 = _slicedToArray(_useState11, 2),
    cssTransition = _useState12[0],
    setCssTransition = _useState12[1];
  var _useState13 = useState(propsValue.autoZIndex || true),
    _useState14 = _slicedToArray(_useState13, 2),
    autoZIndex = _useState14[0],
    setAutoZIndex = _useState14[1];
  var _useState15 = useState(propsValue.hideOverlaysOnDocumentScrolling || false),
    _useState16 = _slicedToArray(_useState15, 2),
    hideOverlaysOnDocumentScrolling = _useState16[0],
    setHideOverlaysOnDocumentScrolling = _useState16[1];
  var _useState17 = useState(propsValue.nonce || null),
    _useState18 = _slicedToArray(_useState17, 2),
    nonce = _useState18[0],
    setNonce = _useState18[1];
  var _useState19 = useState(propsValue.nullSortOrder || 1),
    _useState20 = _slicedToArray(_useState19, 2),
    nullSortOrder = _useState20[0],
    setNullSortOrder = _useState20[1];
  var _useState21 = useState(propsValue.zIndex || {
      modal: 1100,
      overlay: 1000,
      menu: 1000,
      tooltip: 1100,
      toast: 1200
    }),
    _useState22 = _slicedToArray(_useState21, 2),
    zIndex = _useState22[0],
    setZIndex = _useState22[1];
  var _useState23 = useState(propsValue.ptOptions || {
      mergeSections: true,
      mergeProps: true
    }),
    _useState24 = _slicedToArray(_useState23, 2),
    ptOptions = _useState24[0],
    setPtOptions = _useState24[1];
  var _useState25 = useState(propsValue.pt || undefined),
    _useState26 = _slicedToArray(_useState25, 2),
    pt = _useState26[0],
    setPt = _useState26[1];
  var _useState27 = useState(propsValue.unstyled || false),
    _useState28 = _slicedToArray(_useState27, 2),
    unstyled = _useState28[0],
    setUnstyled = _useState28[1];
  var _useState29 = useState(propsValue.filterMatchModeOptions || {
      text: [FilterMatchMode.STARTS_WITH, FilterMatchMode.CONTAINS, FilterMatchMode.NOT_CONTAINS, FilterMatchMode.ENDS_WITH, FilterMatchMode.EQUALS, FilterMatchMode.NOT_EQUALS],
      numeric: [FilterMatchMode.EQUALS, FilterMatchMode.NOT_EQUALS, FilterMatchMode.LESS_THAN, FilterMatchMode.LESS_THAN_OR_EQUAL_TO, FilterMatchMode.GREATER_THAN, FilterMatchMode.GREATER_THAN_OR_EQUAL_TO],
      date: [FilterMatchMode.DATE_IS, FilterMatchMode.DATE_IS_NOT, FilterMatchMode.DATE_BEFORE, FilterMatchMode.DATE_AFTER]
    }),
    _useState30 = _slicedToArray(_useState29, 2),
    filterMatchModeOptions = _useState30[0],
    setFilterMatchModeOptions = _useState30[1];
  var changeTheme = function changeTheme(currentTheme, newTheme, linkElementId, callback) {
    var _linkElement$parentNo;
    var linkElement = document.getElementById(linkElementId);
    var cloneLinkElement = linkElement.cloneNode(true);
    var newThemeUrl = linkElement.getAttribute('href').replace(currentTheme, newTheme);
    cloneLinkElement.setAttribute('id', linkElementId + '-clone');
    cloneLinkElement.setAttribute('href', newThemeUrl);
    cloneLinkElement.addEventListener('load', function () {
      linkElement.remove();
      cloneLinkElement.setAttribute('id', linkElementId);
      if (callback) {
        callback();
      }
    });
    (_linkElement$parentNo = linkElement.parentNode) === null || _linkElement$parentNo === void 0 || _linkElement$parentNo.insertBefore(cloneLinkElement, linkElement.nextSibling);
  };

  /**
   * @deprecated
   */
  React.useEffect(function () {
    PrimeReact$1.ripple = ripple;
  }, [ripple]);

  /**
   * @deprecated
   */
  React.useEffect(function () {
    PrimeReact$1.inputStyle = inputStyle;
  }, [inputStyle]);

  /**
   * @deprecated
   */
  React.useEffect(function () {
    PrimeReact$1.locale = locale;
  }, [locale]);
  var value = {
    changeTheme: changeTheme,
    ripple: ripple,
    setRipple: setRipple,
    inputStyle: inputStyle,
    setInputStyle: setInputStyle,
    locale: locale,
    setLocale: setLocale,
    appendTo: appendTo,
    setAppendTo: setAppendTo,
    styleContainer: styleContainer,
    setStyleContainer: setStyleContainer,
    cssTransition: cssTransition,
    setCssTransition: setCssTransition,
    autoZIndex: autoZIndex,
    setAutoZIndex: setAutoZIndex,
    hideOverlaysOnDocumentScrolling: hideOverlaysOnDocumentScrolling,
    setHideOverlaysOnDocumentScrolling: setHideOverlaysOnDocumentScrolling,
    nonce: nonce,
    setNonce: setNonce,
    nullSortOrder: nullSortOrder,
    setNullSortOrder: setNullSortOrder,
    zIndex: zIndex,
    setZIndex: setZIndex,
    ptOptions: ptOptions,
    setPtOptions: setPtOptions,
    pt: pt,
    setPt: setPt,
    filterMatchModeOptions: filterMatchModeOptions,
    setFilterMatchModeOptions: setFilterMatchModeOptions,
    unstyled: unstyled,
    setUnstyled: setUnstyled
  };
  return /*#__PURE__*/React.createElement(PrimeReactContext.Provider, {
    value: value
  }, props.children);
};

var PrimeReact = PrimeReact$1;

export { FilterMatchMode, FilterOperator, FilterService, MessageSeverity, PrimeIcons, PrimeReactContext, PrimeReactProvider, SortOrder, addLocale, ariaLabel, PrimeReact as default, locale, localeOption, localeOptions, updateLocaleOption, updateLocaleOptions };
