var primereact = (function (exports, React, reactTransitionGroup, ReactDOM) {
  'use strict';

  function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

  function _interopNamespace(e) {
    if (e && e.__esModule) return e;
    var n = Object.create(null);
    if (e) {
      Object.keys(e).forEach(function (k) {
        if (k !== 'default') {
          var d = Object.getOwnPropertyDescriptor(e, k);
          Object.defineProperty(n, k, d.get ? d : {
            enumerable: true,
            get: function () { return e[k]; }
          });
        }
      });
    }
    n["default"] = e;
    return Object.freeze(n);
  }

  var React__namespace = /*#__PURE__*/_interopNamespace(React);
  var React__default = /*#__PURE__*/_interopDefaultLegacy(React);
  var ReactDOM__default = /*#__PURE__*/_interopDefaultLegacy(ReactDOM);

  function _extends() {
    _extends = Object.assign ? Object.assign.bind() : function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];
        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }
      return target;
    };
    return _extends.apply(this, arguments);
  }

  function _arrayLikeToArray$i(arr, len) {
    if (len == null || len > arr.length) len = arr.length;
    for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];
    return arr2;
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) return _arrayLikeToArray$i(arr);
  }

  function _iterableToArray(iter) {
    if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter);
  }

  function _unsupportedIterableToArray$i(o, minLen) {
    if (!o) return;
    if (typeof o === "string") return _arrayLikeToArray$i(o, minLen);
    var n = Object.prototype.toString.call(o).slice(8, -1);
    if (n === "Object" && o.constructor) n = o.constructor.name;
    if (n === "Map" || n === "Set") return Array.from(o);
    if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$i(o, minLen);
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray$i(arr) || _nonIterableSpread();
  }

  function _typeof(o) {
    "@babel/helpers - typeof";

    return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) {
      return typeof o;
    } : function (o) {
      return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o;
    }, _typeof(o);
  }

  function _toPrimitive(input, hint) {
    if (_typeof(input) !== "object" || input === null) return input;
    var prim = input[Symbol.toPrimitive];
    if (prim !== undefined) {
      var res = prim.call(input, hint || "default");
      if (_typeof(res) !== "object") return res;
      throw new TypeError("@@toPrimitive must return a primitive value.");
    }
    return (hint === "string" ? String : Number)(input);
  }

  function _toPropertyKey(arg) {
    var key = _toPrimitive(arg, "string");
    return _typeof(key) === "symbol" ? key : String(key);
  }

  function _defineProperty(obj, key, value) {
    key = _toPropertyKey(key);
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }
    return obj;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function _iterableToArrayLimit(r, l) {
    var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"];
    if (null != t) {
      var e,
        n,
        i,
        u,
        a = [],
        f = !0,
        o = !1;
      try {
        if (i = (t = t.call(r)).next, 0 === l) {
          if (Object(t) !== t) return;
          f = !1;
        } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0);
      } catch (r) {
        o = !0, n = r;
      } finally {
        try {
          if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return;
        } finally {
          if (o) throw n;
        }
      }
      return a;
    }
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray$i(arr, i) || _nonIterableRest();
  }

  var FilterMatchMode = Object.freeze({
    STARTS_WITH: 'startsWith',
    CONTAINS: 'contains',
    NOT_CONTAINS: 'notContains',
    ENDS_WITH: 'endsWith',
    EQUALS: 'equals',
    NOT_EQUALS: 'notEquals',
    IN: 'in',
    LESS_THAN: 'lt',
    LESS_THAN_OR_EQUAL_TO: 'lte',
    GREATER_THAN: 'gt',
    GREATER_THAN_OR_EQUAL_TO: 'gte',
    BETWEEN: 'between',
    DATE_IS: 'dateIs',
    DATE_IS_NOT: 'dateIsNot',
    DATE_BEFORE: 'dateBefore',
    DATE_AFTER: 'dateAfter',
    CUSTOM: 'custom'
  });

  var FilterOperator = Object.freeze({
    AND: 'and',
    OR: 'or'
  });

  function classNames() {
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    if (args) {
      var classes = [];
      for (var i = 0; i < args.length; i++) {
        var className = args[i];
        if (!className) continue;
        var type = _typeof(className);
        if (type === 'string' || type === 'number') {
          classes.push(className);
        } else if (type === 'object') {
          var _classes = Array.isArray(className) ? className : Object.entries(className).map(function (_ref) {
            var _ref2 = _slicedToArray(_ref, 2),
              key = _ref2[0],
              value = _ref2[1];
            return !!value ? key : null;
          });
          classes = _classes.length ? classes.concat(_classes.filter(function (c) {
            return !!c;
          })) : classes;
        }
      }
      return classes.join(' ').trim();
    }
    return undefined;
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor);
    }
  }
  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties(Constructor, staticProps);
    Object.defineProperty(Constructor, "prototype", {
      writable: false
    });
    return Constructor;
  }

  function _createForOfIteratorHelper$h(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray$h(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
  function _unsupportedIterableToArray$h(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray$h(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$h(o, minLen); }
  function _arrayLikeToArray$h(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
  var DomHandler = /*#__PURE__*/function () {
    function DomHandler() {
      _classCallCheck(this, DomHandler);
    }
    _createClass(DomHandler, null, [{
      key: "innerWidth",
      value: function innerWidth(el) {
        if (el) {
          var width = el.offsetWidth;
          var style = getComputedStyle(el);
          width += parseFloat(style.paddingLeft) + parseFloat(style.paddingRight);
          return width;
        }
        return 0;
      }
    }, {
      key: "width",
      value: function width(el) {
        if (el) {
          var width = el.offsetWidth;
          var style = getComputedStyle(el);
          width -= parseFloat(style.paddingLeft) + parseFloat(style.paddingRight);
          return width;
        }
        return 0;
      }
    }, {
      key: "getBrowserLanguage",
      value: function getBrowserLanguage() {
        return navigator.userLanguage || navigator.languages && navigator.languages.length && navigator.languages[0] || navigator.language || navigator.browserLanguage || navigator.systemLanguage || 'en';
      }
    }, {
      key: "getWindowScrollTop",
      value: function getWindowScrollTop() {
        var doc = document.documentElement;
        return (window.pageYOffset || doc.scrollTop) - (doc.clientTop || 0);
      }
    }, {
      key: "getWindowScrollLeft",
      value: function getWindowScrollLeft() {
        var doc = document.documentElement;
        return (window.pageXOffset || doc.scrollLeft) - (doc.clientLeft || 0);
      }
    }, {
      key: "getOuterWidth",
      value: function getOuterWidth(el, margin) {
        if (el) {
          var width = el.getBoundingClientRect().width || el.offsetWidth;
          if (margin) {
            var style = getComputedStyle(el);
            width += parseFloat(style.marginLeft) + parseFloat(style.marginRight);
          }
          return width;
        }
        return 0;
      }
    }, {
      key: "getOuterHeight",
      value: function getOuterHeight(el, margin) {
        if (el) {
          var height = el.getBoundingClientRect().height || el.offsetHeight;
          if (margin) {
            var style = getComputedStyle(el);
            height += parseFloat(style.marginTop) + parseFloat(style.marginBottom);
          }
          return height;
        }
        return 0;
      }
    }, {
      key: "getClientHeight",
      value: function getClientHeight(el, margin) {
        if (el) {
          var height = el.clientHeight;
          if (margin) {
            var style = getComputedStyle(el);
            height += parseFloat(style.marginTop) + parseFloat(style.marginBottom);
          }
          return height;
        }
        return 0;
      }
    }, {
      key: "getClientWidth",
      value: function getClientWidth(el, margin) {
        if (el) {
          var width = el.clientWidth;
          if (margin) {
            var style = getComputedStyle(el);
            width += parseFloat(style.marginLeft) + parseFloat(style.marginRight);
          }
          return width;
        }
        return 0;
      }
    }, {
      key: "getViewport",
      value: function getViewport() {
        var win = window,
          d = document,
          e = d.documentElement,
          g = d.getElementsByTagName('body')[0],
          w = win.innerWidth || e.clientWidth || g.clientWidth,
          h = win.innerHeight || e.clientHeight || g.clientHeight;
        return {
          width: w,
          height: h
        };
      }
    }, {
      key: "getOffset",
      value: function getOffset(el) {
        if (el) {
          var rect = el.getBoundingClientRect();
          return {
            top: rect.top + (window.pageYOffset || document.documentElement.scrollTop || document.body.scrollTop || 0),
            left: rect.left + (window.pageXOffset || document.documentElement.scrollLeft || document.body.scrollLeft || 0)
          };
        }
        return {
          top: 'auto',
          left: 'auto'
        };
      }
    }, {
      key: "index",
      value: function index(element) {
        if (element) {
          var children = element.parentNode.childNodes;
          var num = 0;
          for (var i = 0; i < children.length; i++) {
            if (children[i] === element) return num;
            if (children[i].nodeType === 1) num++;
          }
        }
        return -1;
      }
    }, {
      key: "addMultipleClasses",
      value: function addMultipleClasses(element, className) {
        if (element && className) {
          if (element.classList) {
            var styles = className.split(' ');
            for (var i = 0; i < styles.length; i++) {
              element.classList.add(styles[i]);
            }
          } else {
            var _styles = className.split(' ');
            for (var _i = 0; _i < _styles.length; _i++) {
              element.className += ' ' + _styles[_i];
            }
          }
        }
      }
    }, {
      key: "removeMultipleClasses",
      value: function removeMultipleClasses(element, className) {
        if (element && className) {
          if (element.classList) {
            var styles = className.split(' ');
            for (var i = 0; i < styles.length; i++) {
              element.classList.remove(styles[i]);
            }
          } else {
            var _styles2 = className.split(' ');
            for (var _i2 = 0; _i2 < _styles2.length; _i2++) {
              element.className = element.className.replace(new RegExp('(^|\\b)' + _styles2[_i2].split(' ').join('|') + '(\\b|$)', 'gi'), ' ');
            }
          }
        }
      }
    }, {
      key: "addClass",
      value: function addClass(element, className) {
        if (element && className) {
          if (element.classList) element.classList.add(className);else element.className += ' ' + className;
        }
      }
    }, {
      key: "removeClass",
      value: function removeClass(element, className) {
        if (element && className) {
          if (element.classList) element.classList.remove(className);else element.className = element.className.replace(new RegExp('(^|\\b)' + className.split(' ').join('|') + '(\\b|$)', 'gi'), ' ');
        }
      }
    }, {
      key: "hasClass",
      value: function hasClass(element, className) {
        if (element) {
          if (element.classList) return element.classList.contains(className);else return new RegExp('(^| )' + className + '( |$)', 'gi').test(element.className);
        }
        return false;
      }
    }, {
      key: "addStyles",
      value: function addStyles(element) {
        var styles = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        if (element) {
          Object.entries(styles).forEach(function (_ref) {
            var _ref2 = _slicedToArray(_ref, 2),
              key = _ref2[0],
              value = _ref2[1];
            return element.style[key] = value;
          });
        }
      }
    }, {
      key: "find",
      value: function find(element, selector) {
        return element ? Array.from(element.querySelectorAll(selector)) : [];
      }
    }, {
      key: "findSingle",
      value: function findSingle(element, selector) {
        if (element) {
          return element.querySelector(selector);
        }
        return null;
      }
    }, {
      key: "setAttributes",
      value: function setAttributes(element) {
        var _this = this;
        var attributes = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        if (element) {
          var computedStyles = function computedStyles(rule, value) {
            var _element$$attrs, _element$$attrs2;
            var styles = element !== null && element !== void 0 && (_element$$attrs = element.$attrs) !== null && _element$$attrs !== void 0 && _element$$attrs[rule] ? [element === null || element === void 0 || (_element$$attrs2 = element.$attrs) === null || _element$$attrs2 === void 0 ? void 0 : _element$$attrs2[rule]] : [];
            return [value].flat().reduce(function (cv, v) {
              if (v !== null && v !== undefined) {
                var type = _typeof(v);
                if (type === 'string' || type === 'number') {
                  cv.push(v);
                } else if (type === 'object') {
                  var _cv = Array.isArray(v) ? computedStyles(rule, v) : Object.entries(v).map(function (_ref3) {
                    var _ref4 = _slicedToArray(_ref3, 2),
                      _k = _ref4[0],
                      _v = _ref4[1];
                    return rule === 'style' && (!!_v || _v === 0) ? "".concat(_k.replace(/([a-z])([A-Z])/g, '$1-$2').toLowerCase(), ":").concat(_v) : !!_v ? _k : undefined;
                  });
                  cv = _cv.length ? cv.concat(_cv.filter(function (c) {
                    return !!c;
                  })) : cv;
                }
              }
              return cv;
            }, styles);
          };
          Object.entries(attributes).forEach(function (_ref5) {
            var _ref6 = _slicedToArray(_ref5, 2),
              key = _ref6[0],
              value = _ref6[1];
            if (value !== undefined && value !== null) {
              var matchedEvent = key.match(/^on(.+)/);
              if (matchedEvent) {
                element.addEventListener(matchedEvent[1].toLowerCase(), value);
              } else if (key === 'p-bind') {
                _this.setAttributes(element, value);
              } else {
                value = key === 'class' ? _toConsumableArray(new Set(computedStyles('class', value))).join(' ').trim() : key === 'style' ? computedStyles('style', value).join(';').trim() : value;
                (element.$attrs = element.$attrs || {}) && (element.$attrs[key] = value);
                element.setAttribute(key, value);
              }
            }
          });
        }
      }
    }, {
      key: "getAttribute",
      value: function getAttribute(element, name) {
        if (element) {
          var value = element.getAttribute(name);
          if (!isNaN(value)) {
            return +value;
          }
          if (value === 'true' || value === 'false') {
            return value === 'true';
          }
          return value;
        }
        return undefined;
      }
    }, {
      key: "isAttributeEquals",
      value: function isAttributeEquals(element, name, value) {
        return element ? this.getAttribute(element, name) === value : false;
      }
    }, {
      key: "isAttributeNotEquals",
      value: function isAttributeNotEquals(element, name, value) {
        return !this.isAttributeEquals(element, name, value);
      }
    }, {
      key: "getHeight",
      value: function getHeight(el) {
        if (el) {
          var height = el.offsetHeight;
          var style = getComputedStyle(el);
          height -= parseFloat(style.paddingTop) + parseFloat(style.paddingBottom) + parseFloat(style.borderTopWidth) + parseFloat(style.borderBottomWidth);
          return height;
        }
        return 0;
      }
    }, {
      key: "getWidth",
      value: function getWidth(el) {
        if (el) {
          var width = el.offsetWidth;
          var style = getComputedStyle(el);
          width -= parseFloat(style.paddingLeft) + parseFloat(style.paddingRight) + parseFloat(style.borderLeftWidth) + parseFloat(style.borderRightWidth);
          return width;
        }
        return 0;
      }
    }, {
      key: "alignOverlay",
      value: function alignOverlay(overlay, target, appendTo) {
        var calculateMinWidth = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : true;
        if (overlay && target) {
          if (appendTo === 'self') {
            this.relativePosition(overlay, target);
          } else {
            calculateMinWidth && (overlay.style.minWidth = DomHandler.getOuterWidth(target) + 'px');
            this.absolutePosition(overlay, target);
          }
        }
      }
    }, {
      key: "absolutePosition",
      value: function absolutePosition(element, target) {
        var align = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'left';
        if (element && target) {
          var elementDimensions = element.offsetParent ? {
            width: element.offsetWidth,
            height: element.offsetHeight
          } : this.getHiddenElementDimensions(element);
          var elementOuterHeight = elementDimensions.height;
          var elementOuterWidth = elementDimensions.width;
          var targetOuterHeight = target.offsetHeight;
          var targetOuterWidth = target.offsetWidth;
          var targetOffset = target.getBoundingClientRect();
          var windowScrollTop = this.getWindowScrollTop();
          var windowScrollLeft = this.getWindowScrollLeft();
          var viewport = this.getViewport();
          var top, left;
          if (targetOffset.top + targetOuterHeight + elementOuterHeight > viewport.height) {
            top = targetOffset.top + windowScrollTop - elementOuterHeight;
            if (top < 0) {
              top = windowScrollTop;
            }
            element.style.transformOrigin = 'bottom';
          } else {
            top = targetOuterHeight + targetOffset.top + windowScrollTop;
            element.style.transformOrigin = 'top';
          }
          var targetOffsetPx = targetOffset.left;
          var alignOffset = align === 'left' ? 0 : elementOuterWidth - targetOuterWidth;
          if (targetOffsetPx + targetOuterWidth + elementOuterWidth > viewport.width) left = Math.max(0, targetOffsetPx + windowScrollLeft + targetOuterWidth - elementOuterWidth);else left = targetOffsetPx - alignOffset + windowScrollLeft;
          element.style.top = top + 'px';
          element.style.left = left + 'px';
        }
      }
    }, {
      key: "relativePosition",
      value: function relativePosition(element, target) {
        if (element && target) {
          var elementDimensions = element.offsetParent ? {
            width: element.offsetWidth,
            height: element.offsetHeight
          } : this.getHiddenElementDimensions(element);
          var targetHeight = target.offsetHeight;
          var targetOffset = target.getBoundingClientRect();
          var viewport = this.getViewport();
          var top, left;
          if (targetOffset.top + targetHeight + elementDimensions.height > viewport.height) {
            top = -1 * elementDimensions.height;
            if (targetOffset.top + top < 0) {
              top = -1 * targetOffset.top;
            }
            element.style.transformOrigin = 'bottom';
          } else {
            top = targetHeight;
            element.style.transformOrigin = 'top';
          }
          if (elementDimensions.width > viewport.width) {
            // element wider then viewport and cannot fit on screen (align at left side of viewport)
            left = targetOffset.left * -1;
          } else if (targetOffset.left + elementDimensions.width > viewport.width) {
            // element wider then viewport but can be fit on screen (align at right side of viewport)
            left = (targetOffset.left + elementDimensions.width - viewport.width) * -1;
          } else {
            // element fits on screen (align with target)
            left = 0;
          }
          element.style.top = top + 'px';
          element.style.left = left + 'px';
        }
      }
    }, {
      key: "flipfitCollision",
      value: function flipfitCollision(element, target) {
        var _this2 = this;
        var my = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'left top';
        var at = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 'left bottom';
        var callback = arguments.length > 4 ? arguments[4] : undefined;
        if (element && target) {
          var targetOffset = target.getBoundingClientRect();
          var viewport = this.getViewport();
          var myArr = my.split(' ');
          var atArr = at.split(' ');
          var getPositionValue = function getPositionValue(arr, isOffset) {
            return isOffset ? +arr.substring(arr.search(/(\+|-)/g)) || 0 : arr.substring(0, arr.search(/(\+|-)/g)) || arr;
          };
          var position = {
            my: {
              x: getPositionValue(myArr[0]),
              y: getPositionValue(myArr[1] || myArr[0]),
              offsetX: getPositionValue(myArr[0], true),
              offsetY: getPositionValue(myArr[1] || myArr[0], true)
            },
            at: {
              x: getPositionValue(atArr[0]),
              y: getPositionValue(atArr[1] || atArr[0]),
              offsetX: getPositionValue(atArr[0], true),
              offsetY: getPositionValue(atArr[1] || atArr[0], true)
            }
          };
          var myOffset = {
            left: function left() {
              var totalOffset = position.my.offsetX + position.at.offsetX;
              return totalOffset + targetOffset.left + (position.my.x === 'left' ? 0 : -1 * (position.my.x === 'center' ? _this2.getOuterWidth(element) / 2 : _this2.getOuterWidth(element)));
            },
            top: function top() {
              var totalOffset = position.my.offsetY + position.at.offsetY;
              return totalOffset + targetOffset.top + (position.my.y === 'top' ? 0 : -1 * (position.my.y === 'center' ? _this2.getOuterHeight(element) / 2 : _this2.getOuterHeight(element)));
            }
          };
          var alignWithAt = {
            count: {
              x: 0,
              y: 0
            },
            left: function left() {
              var left = myOffset.left();
              var scrollLeft = DomHandler.getWindowScrollLeft();
              element.style.left = left + scrollLeft + 'px';
              if (this.count.x === 2) {
                element.style.left = scrollLeft + 'px';
                this.count.x = 0;
              } else if (left < 0) {
                this.count.x++;
                position.my.x = 'left';
                position.at.x = 'right';
                position.my.offsetX *= -1;
                position.at.offsetX *= -1;
                this.right();
              }
            },
            right: function right() {
              var left = myOffset.left() + DomHandler.getOuterWidth(target);
              var scrollLeft = DomHandler.getWindowScrollLeft();
              element.style.left = left + scrollLeft + 'px';
              if (this.count.x === 2) {
                element.style.left = viewport.width - DomHandler.getOuterWidth(element) + scrollLeft + 'px';
                this.count.x = 0;
              } else if (left + DomHandler.getOuterWidth(element) > viewport.width) {
                this.count.x++;
                position.my.x = 'right';
                position.at.x = 'left';
                position.my.offsetX *= -1;
                position.at.offsetX *= -1;
                this.left();
              }
            },
            top: function top() {
              var top = myOffset.top();
              var scrollTop = DomHandler.getWindowScrollTop();
              element.style.top = top + scrollTop + 'px';
              if (this.count.y === 2) {
                element.style.left = scrollTop + 'px';
                this.count.y = 0;
              } else if (top < 0) {
                this.count.y++;
                position.my.y = 'top';
                position.at.y = 'bottom';
                position.my.offsetY *= -1;
                position.at.offsetY *= -1;
                this.bottom();
              }
            },
            bottom: function bottom() {
              var top = myOffset.top() + DomHandler.getOuterHeight(target);
              var scrollTop = DomHandler.getWindowScrollTop();
              element.style.top = top + scrollTop + 'px';
              if (this.count.y === 2) {
                element.style.left = viewport.height - DomHandler.getOuterHeight(element) + scrollTop + 'px';
                this.count.y = 0;
              } else if (top + DomHandler.getOuterHeight(target) > viewport.height) {
                this.count.y++;
                position.my.y = 'bottom';
                position.at.y = 'top';
                position.my.offsetY *= -1;
                position.at.offsetY *= -1;
                this.top();
              }
            },
            center: function center(axis) {
              if (axis === 'y') {
                var top = myOffset.top() + DomHandler.getOuterHeight(target) / 2;
                element.style.top = top + DomHandler.getWindowScrollTop() + 'px';
                if (top < 0) {
                  this.bottom();
                } else if (top + DomHandler.getOuterHeight(target) > viewport.height) {
                  this.top();
                }
              } else {
                var left = myOffset.left() + DomHandler.getOuterWidth(target) / 2;
                element.style.left = left + DomHandler.getWindowScrollLeft() + 'px';
                if (left < 0) {
                  this.left();
                } else if (left + DomHandler.getOuterWidth(element) > viewport.width) {
                  this.right();
                }
              }
            }
          };
          alignWithAt[position.at.x]('x');
          alignWithAt[position.at.y]('y');
          if (this.isFunction(callback)) {
            callback(position);
          }
        }
      }
    }, {
      key: "findCollisionPosition",
      value: function findCollisionPosition(position) {
        if (position) {
          var isAxisY = position === 'top' || position === 'bottom';
          var myXPosition = position === 'left' ? 'right' : 'left';
          var myYPosition = position === 'top' ? 'bottom' : 'top';
          if (isAxisY) {
            return {
              axis: 'y',
              my: "center ".concat(myYPosition),
              at: "center ".concat(position)
            };
          }
          return {
            axis: 'x',
            my: "".concat(myXPosition, " center"),
            at: "".concat(position, " center")
          };
        }
      }
    }, {
      key: "getParents",
      value: function getParents(element) {
        var parents = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
        return element['parentNode'] === null ? parents : this.getParents(element.parentNode, parents.concat([element.parentNode]));
      }
    }, {
      key: "getScrollableParents",
      value: function getScrollableParents(element) {
        var hideOverlaysOnDocumentScrolling = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
        var scrollableParents = [];
        if (element) {
          var parents = this.getParents(element);
          var overflowRegex = /(auto|scroll)/;
          var overflowCheck = function overflowCheck(node) {
            var styleDeclaration = node ? getComputedStyle(node) : null;
            return styleDeclaration && (overflowRegex.test(styleDeclaration.getPropertyValue('overflow')) || overflowRegex.test(styleDeclaration.getPropertyValue('overflowX')) || overflowRegex.test(styleDeclaration.getPropertyValue('overflowY')));
          };
          var addScrollableParent = function addScrollableParent(node) {
            if (hideOverlaysOnDocumentScrolling) {
              // nodeType 9 is for document element
              scrollableParents.push(node.nodeName === 'BODY' || node.nodeName === 'HTML' || node.nodeType === 9 ? window : node);
            } else {
              scrollableParents.push(node);
            }
          };
          var _iterator = _createForOfIteratorHelper$h(parents),
            _step;
          try {
            for (_iterator.s(); !(_step = _iterator.n()).done;) {
              var parent = _step.value;
              var scrollSelectors = parent.nodeType === 1 && parent.dataset['scrollselectors'];
              if (scrollSelectors) {
                var selectors = scrollSelectors.split(',');
                var _iterator2 = _createForOfIteratorHelper$h(selectors),
                  _step2;
                try {
                  for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
                    var selector = _step2.value;
                    var el = this.findSingle(parent, selector);
                    if (el && overflowCheck(el)) {
                      addScrollableParent(el);
                    }
                  }
                } catch (err) {
                  _iterator2.e(err);
                } finally {
                  _iterator2.f();
                }
              }

              // BODY
              if (parent.nodeType === 1 && overflowCheck(parent)) {
                addScrollableParent(parent);
              }
            }
          } catch (err) {
            _iterator.e(err);
          } finally {
            _iterator.f();
          }
        }

        // we should always at least have the body or window
        if (!scrollableParents.some(function (node) {
          return node === document.body || node === window;
        })) {
          scrollableParents.push(window);
        }
        return scrollableParents;
      }
    }, {
      key: "getHiddenElementOuterHeight",
      value: function getHiddenElementOuterHeight(element) {
        if (element) {
          element.style.visibility = 'hidden';
          element.style.display = 'block';
          var elementHeight = element.offsetHeight;
          element.style.display = 'none';
          element.style.visibility = 'visible';
          return elementHeight;
        }
        return 0;
      }
    }, {
      key: "getHiddenElementOuterWidth",
      value: function getHiddenElementOuterWidth(element) {
        if (element) {
          element.style.visibility = 'hidden';
          element.style.display = 'block';
          var elementWidth = element.offsetWidth;
          element.style.display = 'none';
          element.style.visibility = 'visible';
          return elementWidth;
        }
        return 0;
      }
    }, {
      key: "getHiddenElementDimensions",
      value: function getHiddenElementDimensions(element) {
        var dimensions = {};
        if (element) {
          element.style.visibility = 'hidden';
          element.style.display = 'block';
          dimensions.width = element.offsetWidth;
          dimensions.height = element.offsetHeight;
          element.style.display = 'none';
          element.style.visibility = 'visible';
        }
        return dimensions;
      }
    }, {
      key: "fadeIn",
      value: function fadeIn(element, duration) {
        if (element) {
          element.style.opacity = 0;
          var last = +new Date();
          var opacity = 0;
          var tick = function tick() {
            opacity = +element.style.opacity + (new Date().getTime() - last) / duration;
            element.style.opacity = opacity;
            last = +new Date();
            if (+opacity < 1) {
              window.requestAnimationFrame && requestAnimationFrame(tick) || setTimeout(tick, 16);
            }
          };
          tick();
        }
      }
    }, {
      key: "fadeOut",
      value: function fadeOut(element, duration) {
        if (element) {
          var opacity = 1,
            interval = 50,
            gap = interval / duration;
          var fading = setInterval(function () {
            opacity -= gap;
            if (opacity <= 0) {
              opacity = 0;
              clearInterval(fading);
            }
            element.style.opacity = opacity;
          }, interval);
        }
      }
    }, {
      key: "getUserAgent",
      value: function getUserAgent() {
        return navigator.userAgent;
      }
    }, {
      key: "isIOS",
      value: function isIOS() {
        return /iPad|iPhone|iPod/.test(navigator.userAgent) && !window['MSStream'];
      }
    }, {
      key: "isAndroid",
      value: function isAndroid() {
        return /(android)/i.test(navigator.userAgent);
      }
    }, {
      key: "isChrome",
      value: function isChrome() {
        return /(chrome)/i.test(navigator.userAgent);
      }
    }, {
      key: "isClient",
      value: function isClient() {
        return !!(typeof window !== 'undefined' && window.document && window.document.createElement);
      }
    }, {
      key: "isTouchDevice",
      value: function isTouchDevice() {
        return 'ontouchstart' in window || navigator.maxTouchPoints > 0 || navigator.msMaxTouchPoints > 0;
      }
    }, {
      key: "isFunction",
      value: function isFunction(obj) {
        return !!(obj && obj.constructor && obj.call && obj.apply);
      }
    }, {
      key: "appendChild",
      value: function appendChild(element, target) {
        if (this.isElement(target)) target.appendChild(element);else if (target.el && target.el.nativeElement) target.el.nativeElement.appendChild(element);else throw new Error('Cannot append ' + target + ' to ' + element);
      }
    }, {
      key: "removeChild",
      value: function removeChild(element, target) {
        if (this.isElement(target)) target.removeChild(element);else if (target.el && target.el.nativeElement) target.el.nativeElement.removeChild(element);else throw new Error('Cannot remove ' + element + ' from ' + target);
      }
    }, {
      key: "isElement",
      value: function isElement(obj) {
        return (typeof HTMLElement === "undefined" ? "undefined" : _typeof(HTMLElement)) === 'object' ? obj instanceof HTMLElement : obj && _typeof(obj) === 'object' && obj !== null && obj.nodeType === 1 && typeof obj.nodeName === 'string';
      }
    }, {
      key: "scrollInView",
      value: function scrollInView(container, item) {
        var borderTopValue = getComputedStyle(container).getPropertyValue('borderTopWidth');
        var borderTop = borderTopValue ? parseFloat(borderTopValue) : 0;
        var paddingTopValue = getComputedStyle(container).getPropertyValue('paddingTop');
        var paddingTop = paddingTopValue ? parseFloat(paddingTopValue) : 0;
        var containerRect = container.getBoundingClientRect();
        var itemRect = item.getBoundingClientRect();
        var offset = itemRect.top + document.body.scrollTop - (containerRect.top + document.body.scrollTop) - borderTop - paddingTop;
        var scroll = container.scrollTop;
        var elementHeight = container.clientHeight;
        var itemHeight = this.getOuterHeight(item);
        if (offset < 0) {
          container.scrollTop = scroll + offset;
        } else if (offset + itemHeight > elementHeight) {
          container.scrollTop = scroll + offset - elementHeight + itemHeight;
        }
      }
    }, {
      key: "clearSelection",
      value: function clearSelection() {
        if (window.getSelection) {
          if (window.getSelection().empty) {
            window.getSelection().empty();
          } else if (window.getSelection().removeAllRanges && window.getSelection().rangeCount > 0 && window.getSelection().getRangeAt(0).getClientRects().length > 0) {
            window.getSelection().removeAllRanges();
          }
        } else if (document['selection'] && document['selection'].empty) {
          try {
            document['selection'].empty();
          } catch (error) {
            //ignore IE bug
          }
        }
      }
    }, {
      key: "calculateScrollbarWidth",
      value: function calculateScrollbarWidth(el) {
        if (el) {
          var style = getComputedStyle(el);
          return el.offsetWidth - el.clientWidth - parseFloat(style.borderLeftWidth) - parseFloat(style.borderRightWidth);
        } else {
          if (this.calculatedScrollbarWidth != null) return this.calculatedScrollbarWidth;
          var scrollDiv = document.createElement('div');
          scrollDiv.className = 'p-scrollbar-measure';
          document.body.appendChild(scrollDiv);
          var scrollbarWidth = scrollDiv.offsetWidth - scrollDiv.clientWidth;
          document.body.removeChild(scrollDiv);
          this.calculatedScrollbarWidth = scrollbarWidth;
          return scrollbarWidth;
        }
      }
    }, {
      key: "calculateBodyScrollbarWidth",
      value: function calculateBodyScrollbarWidth() {
        return window.innerWidth - document.documentElement.offsetWidth;
      }
    }, {
      key: "getBrowser",
      value: function getBrowser() {
        if (!this.browser) {
          var matched = this.resolveUserAgent();
          this.browser = {};
          if (matched.browser) {
            this.browser[matched.browser] = true;
            this.browser['version'] = matched.version;
          }
          if (this.browser['chrome']) {
            this.browser['webkit'] = true;
          } else if (this.browser['webkit']) {
            this.browser['safari'] = true;
          }
        }
        return this.browser;
      }
    }, {
      key: "resolveUserAgent",
      value: function resolveUserAgent() {
        var ua = navigator.userAgent.toLowerCase();
        var match = /(chrome)[ ]([\w.]+)/.exec(ua) || /(webkit)[ ]([\w.]+)/.exec(ua) || /(opera)(?:.*version|)[ ]([\w.]+)/.exec(ua) || /(msie) ([\w.]+)/.exec(ua) || ua.indexOf('compatible') < 0 && /(mozilla)(?:.*? rv:([\w.]+)|)/.exec(ua) || [];
        return {
          browser: match[1] || '',
          version: match[2] || '0'
        };
      }
    }, {
      key: "blockBodyScroll",
      value: function blockBodyScroll() {
        var className = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'p-overflow-hidden';
        /* PR Ref: https://github.com/primefaces/primereact/pull/4976
         * @todo This method is called several times after this PR. Refactors will be made to prevent this in future releases.
         */
        var hasScrollbarWidth = !!document.body.style.getPropertyValue('--scrollbar-width');
        !hasScrollbarWidth && document.body.style.setProperty('--scrollbar-width', this.calculateBodyScrollbarWidth() + 'px');
        this.addClass(document.body, className);
      }
    }, {
      key: "unblockBodyScroll",
      value: function unblockBodyScroll() {
        var className = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'p-overflow-hidden';
        document.body.style.removeProperty('--scrollbar-width');
        this.removeClass(document.body, className);
      }
    }, {
      key: "isVisible",
      value: function isVisible(element) {
        // https://stackoverflow.com/a/59096915/502366 (in future use IntersectionObserver)
        return element && (element.clientHeight !== 0 || element.getClientRects().length !== 0 || getComputedStyle(element).display !== 'none');
      }
    }, {
      key: "isExist",
      value: function isExist(element) {
        return !!(element !== null && typeof element !== 'undefined' && element.nodeName && element.parentNode);
      }
    }, {
      key: "getFocusableElements",
      value: function getFocusableElements(element) {
        var selector = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
        var focusableElements = DomHandler.find(element, "button:not([tabindex = \"-1\"]):not([disabled]):not([style*=\"display:none\"]):not([hidden])".concat(selector, ",\n                [href][clientHeight][clientWidth]:not([tabindex = \"-1\"]):not([disabled]):not([style*=\"display:none\"]):not([hidden])").concat(selector, ",\n                input:not([tabindex = \"-1\"]):not([disabled]):not([style*=\"display:none\"]):not([hidden])").concat(selector, ",\n                select:not([tabindex = \"-1\"]):not([disabled]):not([style*=\"display:none\"]):not([hidden])").concat(selector, ",\n                textarea:not([tabindex = \"-1\"]):not([disabled]):not([style*=\"display:none\"]):not([hidden])").concat(selector, ",\n                [tabIndex]:not([tabIndex = \"-1\"]):not([disabled]):not([style*=\"display:none\"]):not([hidden])").concat(selector, ",\n                [contenteditable]:not([tabIndex = \"-1\"]):not([disabled]):not([style*=\"display:none\"]):not([hidden])").concat(selector));
        var visibleFocusableElements = [];
        var _iterator3 = _createForOfIteratorHelper$h(focusableElements),
          _step3;
        try {
          for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
            var focusableElement = _step3.value;
            if (getComputedStyle(focusableElement).display !== 'none' && getComputedStyle(focusableElement).visibility !== 'hidden') visibleFocusableElements.push(focusableElement);
          }
        } catch (err) {
          _iterator3.e(err);
        } finally {
          _iterator3.f();
        }
        return visibleFocusableElements;
      }
    }, {
      key: "getFirstFocusableElement",
      value: function getFirstFocusableElement(element, selector) {
        var focusableElements = DomHandler.getFocusableElements(element, selector);
        return focusableElements.length > 0 ? focusableElements[0] : null;
      }
    }, {
      key: "getLastFocusableElement",
      value: function getLastFocusableElement(element, selector) {
        var focusableElements = DomHandler.getFocusableElements(element, selector);
        return focusableElements.length > 0 ? focusableElements[focusableElements.length - 1] : null;
      }

      /**
       * Focus an input element if it does not already have focus.
       *
       * @param {HTMLElement} el a HTML element
       * @param {boolean} scrollTo flag to control whether to scroll to the element, false by default
       */
    }, {
      key: "focus",
      value: function focus(el, scrollTo) {
        var preventScroll = scrollTo === undefined ? true : !scrollTo;
        el && document.activeElement !== el && el.focus({
          preventScroll: preventScroll
        });
      }

      /**
       * Focus the first focusable element if it does not already have focus.
       *
       * @param {HTMLElement} el a HTML element
       * @param {boolean} scrollTo flag to control whether to scroll to the element, false by default
       * @return {HTMLElement | undefined} the first focusable HTML element found
       */
    }, {
      key: "focusFirstElement",
      value: function focusFirstElement(el, scrollTo) {
        if (!el) return;
        var firstFocusableElement = DomHandler.getFirstFocusableElement(el);
        firstFocusableElement && DomHandler.focus(firstFocusableElement, scrollTo);
        return firstFocusableElement;
      }
    }, {
      key: "getCursorOffset",
      value: function getCursorOffset(el, prevText, nextText, currentText) {
        if (el) {
          var style = getComputedStyle(el);
          var ghostDiv = document.createElement('div');
          ghostDiv.style.position = 'absolute';
          ghostDiv.style.top = '0px';
          ghostDiv.style.left = '0px';
          ghostDiv.style.visibility = 'hidden';
          ghostDiv.style.pointerEvents = 'none';
          ghostDiv.style.overflow = style.overflow;
          ghostDiv.style.width = style.width;
          ghostDiv.style.height = style.height;
          ghostDiv.style.padding = style.padding;
          ghostDiv.style.border = style.border;
          ghostDiv.style.overflowWrap = style.overflowWrap;
          ghostDiv.style.whiteSpace = style.whiteSpace;
          ghostDiv.style.lineHeight = style.lineHeight;
          ghostDiv.innerHTML = prevText.replace(/\r\n|\r|\n/g, '<br />');
          var ghostSpan = document.createElement('span');
          ghostSpan.textContent = currentText;
          ghostDiv.appendChild(ghostSpan);
          var text = document.createTextNode(nextText);
          ghostDiv.appendChild(text);
          document.body.appendChild(ghostDiv);
          var offsetLeft = ghostSpan.offsetLeft,
            offsetTop = ghostSpan.offsetTop,
            clientHeight = ghostSpan.clientHeight;
          document.body.removeChild(ghostDiv);
          return {
            left: Math.abs(offsetLeft - el.scrollLeft),
            top: Math.abs(offsetTop - el.scrollTop) + clientHeight
          };
        }
        return {
          top: 'auto',
          left: 'auto'
        };
      }
    }, {
      key: "invokeElementMethod",
      value: function invokeElementMethod(element, methodName, args) {
        element[methodName].apply(element, args);
      }
    }, {
      key: "isClickable",
      value: function isClickable(element) {
        var targetNode = element.nodeName;
        var parentNode = element.parentElement && element.parentElement.nodeName;
        return targetNode === 'INPUT' || targetNode === 'TEXTAREA' || targetNode === 'BUTTON' || targetNode === 'A' || parentNode === 'INPUT' || parentNode === 'TEXTAREA' || parentNode === 'BUTTON' || parentNode === 'A' || this.hasClass(element, 'p-button') || this.hasClass(element.parentElement, 'p-button') || this.hasClass(element.parentElement, 'p-checkbox') || this.hasClass(element.parentElement, 'p-radiobutton');
      }
    }, {
      key: "applyStyle",
      value: function applyStyle(element, style) {
        if (typeof style === 'string') {
          element.style.cssText = this.style;
        } else {
          for (var prop in this.style) {
            element.style[prop] = style[prop];
          }
        }
      }
    }, {
      key: "exportCSV",
      value: function exportCSV(csv, filename) {
        var blob = new Blob([csv], {
          type: 'application/csv;charset=utf-8;'
        });
        if (window.navigator.msSaveOrOpenBlob) {
          navigator.msSaveOrOpenBlob(blob, filename + '.csv');
        } else {
          var isDownloaded = DomHandler.saveAs({
            name: filename + '.csv',
            src: URL.createObjectURL(blob)
          });
          if (!isDownloaded) {
            csv = 'data:text/csv;charset=utf-8,' + csv;
            window.open(encodeURI(csv));
          }
        }
      }
    }, {
      key: "saveAs",
      value: function saveAs(file) {
        if (file) {
          var link = document.createElement('a');
          if (link.download !== undefined) {
            var name = file.name,
              src = file.src;
            link.setAttribute('href', src);
            link.setAttribute('download', name);
            link.style.display = 'none';
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
            return true;
          }
        }
        return false;
      }
    }, {
      key: "createInlineStyle",
      value: function createInlineStyle(nonce, styleContainer) {
        var styleElement = document.createElement('style');
        DomHandler.addNonce(styleElement, nonce);
        if (!styleContainer) {
          styleContainer = document.head;
        }
        styleContainer.appendChild(styleElement);
        return styleElement;
      }
    }, {
      key: "removeInlineStyle",
      value: function removeInlineStyle(styleElement) {
        if (this.isExist(styleElement)) {
          try {
            styleElement.parentNode.removeChild(styleElement);
          } catch (error) {
            // style element may have already been removed in a fast refresh
          }
          styleElement = null;
        }
        return styleElement;
      }
    }, {
      key: "addNonce",
      value: function addNonce(styleElement, nonce) {
        try {
          if (!nonce) {
            nonce = process.env.REACT_APP_CSS_NONCE;
          }
        } catch (error) {
          // NOOP
        }
        nonce && styleElement.setAttribute('nonce', nonce);
      }
    }, {
      key: "getTargetElement",
      value: function getTargetElement(target) {
        if (!target) return null;
        if (target === 'document') {
          return document;
        } else if (target === 'window') {
          return window;
        } else if (_typeof(target) === 'object' && target.hasOwnProperty('current')) {
          return this.isExist(target.current) ? target.current : null;
        } else {
          var isFunction = function isFunction(obj) {
            return !!(obj && obj.constructor && obj.call && obj.apply);
          };
          var element = isFunction(target) ? target() : target;
          return element && element.nodeType === 9 || this.isExist(element) ? element : null;
        }
      }

      /**
       * Get the attribute names for an element and sorts them alpha for comparison
       */
    }, {
      key: "getAttributeNames",
      value: function getAttributeNames(node) {
        var index, rv, attrs;
        rv = [];
        attrs = node.attributes;
        for (index = 0; index < attrs.length; ++index) {
          rv.push(attrs[index].nodeName);
        }
        rv.sort();
        return rv;
      }

      /**
       * Compare two elements for equality.  Even will compare if the style element
       * is out of order for example:
       *
       * elem1 = style="color: red; font-size: 28px"
       * elem2 = style="font-size: 28px; color: red"
       */
    }, {
      key: "isEqualElement",
      value: function isEqualElement(elm1, elm2) {
        var attrs1, attrs2, name, node1, node2;

        // Compare attributes without order sensitivity
        attrs1 = DomHandler.getAttributeNames(elm1);
        attrs2 = DomHandler.getAttributeNames(elm2);
        if (attrs1.join(',') !== attrs2.join(',')) {
          // console.log("Found nodes with different sets of attributes; not equiv");
          return false;
        }

        // ...and values
        // unless you want to compare DOM0 event handlers
        // (onclick="...")
        for (var index = 0; index < attrs1.length; ++index) {
          name = attrs1[index];
          if (name === 'style') {
            var astyle = elm1.style;
            var bstyle = elm2.style;
            var rexDigitsOnly = /^\d+$/;
            for (var _i3 = 0, _Object$keys = Object.keys(astyle); _i3 < _Object$keys.length; _i3++) {
              var key = _Object$keys[_i3];
              if (!rexDigitsOnly.test(key) && astyle[key] !== bstyle[key]) {
                // Not equivalent, stop
                //console.log("Found nodes with mis-matched values for attribute '" + name + "'; not equiv");
                return false;
              }
            }
          } else {
            if (elm1.getAttribute(name) !== elm2.getAttribute(name)) {
              // console.log("Found nodes with mis-matched values for attribute '" + name + "'; not equiv");
              return false;
            }
          }
        }

        // Walk the children
        for (node1 = elm1.firstChild, node2 = elm2.firstChild; node1 && node2; node1 = node1.nextSibling, node2 = node2.nextSibling) {
          if (node1.nodeType !== node2.nodeType) {
            // display("Found nodes of different types; not equiv");
            return false;
          }
          if (node1.nodeType === 1) {
            // Element
            if (!DomHandler.isEqualElement(node1, node2)) {
              return false;
            }
          } else if (node1.nodeValue !== node2.nodeValue) {
            // console.log("Found nodes with mis-matched nodeValues; not equiv");
            return false;
          }
        }
        if (node1 || node2) {
          // One of the elements had more nodes than the other
          // console.log("Found more children of one element than the other; not equivalent");
          return false;
        }

        // Seem the same
        return true;
      }
    }]);
    return DomHandler;
  }();
  /**
   * All data- properties like data-test-id
   */
  _defineProperty(DomHandler, "DATA_PROPS", ['data-']);
  /**
   * All ARIA properties like aria-label and focus-target for https://www.npmjs.com/package/@q42/floating-focus-a11y
   */
  _defineProperty(DomHandler, "ARIA_PROPS", ['aria', 'focus-target']);

  function EventBus() {
    var allHandlers = new Map();
    return {
      on: function on(type, handler) {
        var handlers = allHandlers.get(type);
        if (!handlers) handlers = [handler];else handlers.push(handler);
        allHandlers.set(type, handlers);
      },
      off: function off(type, handler) {
        var handlers = allHandlers.get(type);
        handlers && handlers.splice(handlers.indexOf(handler) >>> 0, 1);
      },
      emit: function emit(type, evt) {
        var handlers = allHandlers.get(type);
        handlers && handlers.slice().forEach(function (handler) {
          return handler(evt);
        });
      }
    };
  }

  function _createForOfIteratorHelper$g(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray$g(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
  function _unsupportedIterableToArray$g(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray$g(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$g(o, minLen); }
  function _arrayLikeToArray$g(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
  var ObjectUtils = /*#__PURE__*/function () {
    function ObjectUtils() {
      _classCallCheck(this, ObjectUtils);
    }
    _createClass(ObjectUtils, null, [{
      key: "equals",
      value: function equals(obj1, obj2, field) {
        if (field && obj1 && _typeof(obj1) === 'object' && obj2 && _typeof(obj2) === 'object') {
          return this.deepEquals(this.resolveFieldData(obj1, field), this.resolveFieldData(obj2, field));
        }
        return this.deepEquals(obj1, obj2);
      }

      /**
       * Compares two JSON objects for deep equality recursively comparing both objects.
       * @param {*} a the first JSON object
       * @param {*} b the second JSON object
       * @returns true if equals, false it not
       */
    }, {
      key: "deepEquals",
      value: function deepEquals(a, b) {
        if (a === b) return true;
        if (a && b && _typeof(a) == 'object' && _typeof(b) == 'object') {
          var arrA = Array.isArray(a),
            arrB = Array.isArray(b),
            i,
            length,
            key;
          if (arrA && arrB) {
            length = a.length;
            if (length !== b.length) return false;
            for (i = length; i-- !== 0;) if (!this.deepEquals(a[i], b[i])) return false;
            return true;
          }
          if (arrA !== arrB) return false;
          var dateA = a instanceof Date,
            dateB = b instanceof Date;
          if (dateA !== dateB) return false;
          if (dateA && dateB) return a.getTime() === b.getTime();
          var regexpA = a instanceof RegExp,
            regexpB = b instanceof RegExp;
          if (regexpA !== regexpB) return false;
          if (regexpA && regexpB) return a.toString() === b.toString();
          var keys = Object.keys(a);
          length = keys.length;
          if (length !== Object.keys(b).length) return false;
          for (i = length; i-- !== 0;) if (!Object.prototype.hasOwnProperty.call(b, keys[i])) return false;
          for (i = length; i-- !== 0;) {
            key = keys[i];
            if (!this.deepEquals(a[key], b[key])) return false;
          }
          return true;
        }

        /*eslint no-self-compare: "off"*/
        return a !== a && b !== b;
      }
    }, {
      key: "resolveFieldData",
      value: function resolveFieldData(data, field) {
        if (!data || !field) {
          // short circuit if there is nothing to resolve
          return null;
        }
        try {
          var value = data[field];
          if (this.isNotEmpty(value)) return value;
        } catch (_unused) {
          // Performance optimization: https://github.com/primefaces/primereact/issues/4797
          // do nothing and continue to other methods to resolve field data
        }
        if (Object.keys(data).length) {
          if (this.isFunction(field)) {
            return field(data);
          } else if (this.isNotEmpty(data[field])) {
            return data[field];
          } else if (field.indexOf('.') === -1) {
            return data[field];
          } else {
            var fields = field.split('.');
            var _value = data;
            for (var i = 0, len = fields.length; i < len; ++i) {
              if (_value == null) {
                return null;
              }
              _value = _value[fields[i]];
            }
            return _value;
          }
        }
        return null;
      }
    }, {
      key: "findDiffKeys",
      value: function findDiffKeys(obj1, obj2) {
        if (!obj1 || !obj2) {
          return {};
        }
        return Object.keys(obj1).filter(function (key) {
          return !obj2.hasOwnProperty(key);
        }).reduce(function (result, current) {
          result[current] = obj1[current];
          return result;
        }, {});
      }

      /**
       * Removes keys from a JSON object that start with a string such as "data" to get all "data-id" type properties.
       *
       * @param {any} obj the JSON object to reduce
       * @param {string[]} startsWiths the string(s) to check if the property starts with this key
       * @returns the JSON object containing only the key/values that match the startsWith string
       */
    }, {
      key: "reduceKeys",
      value: function reduceKeys(obj, startsWiths) {
        var result = {};
        if (!obj || !startsWiths || startsWiths.length === 0) {
          return result;
        }
        Object.keys(obj).filter(function (key) {
          return startsWiths.some(function (value) {
            return key.startsWith(value);
          });
        }).forEach(function (key) {
          result[key] = obj[key];
          delete obj[key];
        });
        return result;
      }
    }, {
      key: "reorderArray",
      value: function reorderArray(value, from, to) {
        if (value && from !== to) {
          if (to >= value.length) {
            to %= value.length;
            from %= value.length;
          }
          value.splice(to, 0, value.splice(from, 1)[0]);
        }
      }
    }, {
      key: "findIndexInList",
      value: function findIndexInList(value, list, dataKey) {
        var _this = this;
        if (list) {
          return dataKey ? list.findIndex(function (item) {
            return _this.equals(item, value, dataKey);
          }) : list.findIndex(function (item) {
            return item === value;
          });
        }
        return -1;
      }
    }, {
      key: "getJSXElement",
      value: function getJSXElement(obj) {
        for (var _len = arguments.length, params = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
          params[_key - 1] = arguments[_key];
        }
        return this.isFunction(obj) ? obj.apply(void 0, params) : obj;
      }
    }, {
      key: "getItemValue",
      value: function getItemValue(obj) {
        for (var _len2 = arguments.length, params = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
          params[_key2 - 1] = arguments[_key2];
        }
        return this.isFunction(obj) ? obj.apply(void 0, params) : obj;
      }
    }, {
      key: "getProp",
      value: function getProp(props) {
        var prop = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
        var defaultProps = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
        var value = props ? props[prop] : undefined;
        return value === undefined ? defaultProps[prop] : value;
      }
    }, {
      key: "getPropCaseInsensitive",
      value: function getPropCaseInsensitive(props, prop) {
        var defaultProps = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
        var fkey = this.toFlatCase(prop);
        for (var key in props) {
          if (props.hasOwnProperty(key) && this.toFlatCase(key) === fkey) {
            return props[key];
          }
        }
        for (var _key3 in defaultProps) {
          if (defaultProps.hasOwnProperty(_key3) && this.toFlatCase(_key3) === fkey) {
            return defaultProps[_key3];
          }
        }
        return undefined; // Property not found
      }
    }, {
      key: "getMergedProps",
      value: function getMergedProps(props, defaultProps) {
        return Object.assign({}, defaultProps, props);
      }
    }, {
      key: "getDiffProps",
      value: function getDiffProps(props, defaultProps) {
        return this.findDiffKeys(props, defaultProps);
      }
    }, {
      key: "getPropValue",
      value: function getPropValue(obj) {
        for (var _len3 = arguments.length, params = new Array(_len3 > 1 ? _len3 - 1 : 0), _key4 = 1; _key4 < _len3; _key4++) {
          params[_key4 - 1] = arguments[_key4];
        }
        return this.isFunction(obj) ? obj.apply(void 0, params) : obj;
      }
    }, {
      key: "getComponentProp",
      value: function getComponentProp(component) {
        var prop = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
        var defaultProps = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
        return this.isNotEmpty(component) ? this.getProp(component.props, prop, defaultProps) : undefined;
      }
    }, {
      key: "getComponentProps",
      value: function getComponentProps(component, defaultProps) {
        return this.isNotEmpty(component) ? this.getMergedProps(component.props, defaultProps) : undefined;
      }
    }, {
      key: "getComponentDiffProps",
      value: function getComponentDiffProps(component, defaultProps) {
        return this.isNotEmpty(component) ? this.getDiffProps(component.props, defaultProps) : undefined;
      }
    }, {
      key: "isValidChild",
      value: function isValidChild(child, type, validTypes) {
        /* eslint-disable */
        if (child) {
          var _child$type;
          var childType = this.getComponentProp(child, '__TYPE') || (child.type ? child.type.displayName : undefined);

          // for App Router in Next.js ^14,
          if (!childType && child !== null && child !== void 0 && (_child$type = child.type) !== null && _child$type !== void 0 && (_child$type = _child$type._payload) !== null && _child$type !== void 0 && _child$type.value) {
            childType = child.type._payload.value.find(function (v) {
              return v === type;
            });
          }
          var isValid = childType === type;
          try {
            var messageTypes; if ("production" !== 'production' && !isValid) ;
          } catch (error) {
            // NOOP
          }
          return isValid;
        }
        return false;
        /* eslint-enable */
      }
    }, {
      key: "getRefElement",
      value: function getRefElement(ref) {
        if (ref) {
          return _typeof(ref) === 'object' && ref.hasOwnProperty('current') ? ref.current : ref;
        }
        return null;
      }
    }, {
      key: "combinedRefs",
      value: function combinedRefs(innerRef, forwardRef) {
        if (innerRef && forwardRef) {
          if (typeof forwardRef === 'function') {
            forwardRef(innerRef.current);
          } else {
            forwardRef.current = innerRef.current;
          }
        }
      }
    }, {
      key: "removeAccents",
      value: function removeAccents(str) {
        if (str && str.search(/[\xC0-\xFF]/g) > -1) {
          str = str.replace(/[\xC0-\xC5]/g, 'A').replace(/[\xC6]/g, 'AE').replace(/[\xC7]/g, 'C').replace(/[\xC8-\xCB]/g, 'E').replace(/[\xCC-\xCF]/g, 'I').replace(/[\xD0]/g, 'D').replace(/[\xD1]/g, 'N').replace(/[\xD2-\xD6\xD8]/g, 'O').replace(/[\xD9-\xDC]/g, 'U').replace(/[\xDD]/g, 'Y').replace(/[\xDE]/g, 'P').replace(/[\xE0-\xE5]/g, 'a').replace(/[\xE6]/g, 'ae').replace(/[\xE7]/g, 'c').replace(/[\xE8-\xEB]/g, 'e').replace(/[\xEC-\xEF]/g, 'i').replace(/[\xF1]/g, 'n').replace(/[\xF2-\xF6\xF8]/g, 'o').replace(/[\xF9-\xFC]/g, 'u').replace(/[\xFE]/g, 'p').replace(/[\xFD\xFF]/g, 'y');
        }
        return str;
      }
    }, {
      key: "toFlatCase",
      value: function toFlatCase(str) {
        // convert snake, kebab, camel and pascal cases to flat case
        return this.isNotEmpty(str) && this.isString(str) ? str.replace(/(-|_)/g, '').toLowerCase() : str;
      }
    }, {
      key: "toCapitalCase",
      value: function toCapitalCase(str) {
        return this.isNotEmpty(str) && this.isString(str) ? str[0].toUpperCase() + str.slice(1) : str;
      }
    }, {
      key: "trim",
      value: function trim(value) {
        // trim only if the value is actually a string
        return this.isNotEmpty(value) && this.isString(value) ? value.trim() : value;
      }
    }, {
      key: "isEmpty",
      value: function isEmpty(value) {
        return value === null || value === undefined || value === '' || Array.isArray(value) && value.length === 0 || !(value instanceof Date) && _typeof(value) === 'object' && Object.keys(value).length === 0;
      }
    }, {
      key: "isNotEmpty",
      value: function isNotEmpty(value) {
        return !this.isEmpty(value);
      }
    }, {
      key: "isFunction",
      value: function isFunction(value) {
        return !!(value && value.constructor && value.call && value.apply);
      }
    }, {
      key: "isObject",
      value: function isObject(value) {
        return value !== null && value instanceof Object && value.constructor === Object;
      }
    }, {
      key: "isDate",
      value: function isDate(value) {
        return value !== null && value instanceof Date && value.constructor === Date;
      }
    }, {
      key: "isArray",
      value: function isArray(value) {
        return value !== null && Array.isArray(value);
      }
    }, {
      key: "isString",
      value: function isString(value) {
        return value !== null && typeof value === 'string';
      }
    }, {
      key: "isPrintableCharacter",
      value: function isPrintableCharacter() {
        var _char = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
        return this.isNotEmpty(_char) && _char.length === 1 && _char.match(/\S| /);
      }
    }, {
      key: "isLetter",
      value: function isLetter(_char2) {
        return /^[a-zA-Z\u00C0-\u017F]$/.test(_char2);
      }

      /**
       * Firefox-v103 does not currently support the "findLast" method. It is stated that this method will be supported with Firefox-v104.
       * https://caniuse.com/mdn-javascript_builtins_array_findlast
       */
    }, {
      key: "findLast",
      value: function findLast(arr, callback) {
        var item;
        if (this.isNotEmpty(arr)) {
          try {
            item = arr.findLast(callback);
          } catch (_unused2) {
            item = _toConsumableArray(arr).reverse().find(callback);
          }
        }
        return item;
      }

      /**
       * Firefox-v103 does not currently support the "findLastIndex" method. It is stated that this method will be supported with Firefox-v104.
       * https://caniuse.com/mdn-javascript_builtins_array_findlastindex
       */
    }, {
      key: "findLastIndex",
      value: function findLastIndex(arr, callback) {
        var index = -1;
        if (this.isNotEmpty(arr)) {
          try {
            index = arr.findLastIndex(callback);
          } catch (_unused3) {
            index = arr.lastIndexOf(_toConsumableArray(arr).reverse().find(callback));
          }
        }
        return index;
      }
    }, {
      key: "sort",
      value: function sort(value1, value2) {
        var order = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 1;
        var comparator = arguments.length > 3 ? arguments[3] : undefined;
        var nullSortOrder = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 1;
        var result = this.compare(value1, value2, comparator, order);
        var finalSortOrder = order;

        // nullSortOrder == 1 means Excel like sort nulls at bottom
        if (this.isEmpty(value1) || this.isEmpty(value2)) {
          finalSortOrder = nullSortOrder === 1 ? order : nullSortOrder;
        }
        return finalSortOrder * result;
      }
    }, {
      key: "compare",
      value: function compare(value1, value2, comparator) {
        var order = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 1;
        var result = -1;
        var emptyValue1 = this.isEmpty(value1);
        var emptyValue2 = this.isEmpty(value2);
        if (emptyValue1 && emptyValue2) result = 0;else if (emptyValue1) result = order;else if (emptyValue2) result = -order;else if (typeof value1 === 'string' && typeof value2 === 'string') result = comparator(value1, value2);else result = value1 < value2 ? -1 : value1 > value2 ? 1 : 0;
        return result;
      }
    }, {
      key: "localeComparator",
      value: function localeComparator(locale) {
        //performance gain using Int.Collator. It is not recommended to use localeCompare against large arrays.
        return new Intl.Collator(locale, {
          numeric: true
        }).compare;
      }
    }, {
      key: "findChildrenByKey",
      value: function findChildrenByKey(data, key) {
        var _iterator = _createForOfIteratorHelper$g(data),
          _step;
        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var item = _step.value;
            if (item.key === key) {
              return item.children || [];
            } else if (item.children) {
              var result = this.findChildrenByKey(item.children, key);
              if (result.length > 0) {
                return result;
              }
            }
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }
        return [];
      }

      /**
       * This function takes mutates and object with a new value given
       * a specific field. This will handle deeply nested fields that
       * need to be modified or created.
       *
       * e.g:
       * data = {
       *  nested: {
       *      foo: "bar"
       *  }
       * }
       *
       * field = "nested.foo"
       * value = "baz"
       *
       * The function will mutate data to be
       * e.g:
       * data = {
       *  nested: {
       *      foo: "baz"
       *  }
       * }
       *
       * @param {object} data the object to be modified
       * @param {string} field the field in the object to replace
       * @param {any} value the value to have replaced in the field
       */
    }, {
      key: "mutateFieldData",
      value: function mutateFieldData(data, field, value) {
        if (_typeof(data) !== 'object' || typeof field !== 'string') {
          // short circuit if there is nothing to resolve
          return;
        }
        var fields = field.split('.');
        var obj = data;
        for (var i = 0, len = fields.length; i < len; ++i) {
          // Check if we are on the last field
          if (i + 1 - len === 0) {
            obj[fields[i]] = value;
            break;
          }
          if (!obj[fields[i]]) {
            obj[fields[i]] = {};
          }
          obj = obj[fields[i]];
        }
      }
    }]);
    return ObjectUtils;
  }();

  function ownKeys$1T(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1T(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1T(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1T(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var IconUtils = /*#__PURE__*/function () {
    function IconUtils() {
      _classCallCheck(this, IconUtils);
    }
    _createClass(IconUtils, null, [{
      key: "getJSXIcon",
      value: function getJSXIcon(icon) {
        var iconProps = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
        var content = null;
        if (icon !== null) {
          var iconType = _typeof(icon);
          var className = classNames(iconProps.className, iconType === 'string' && icon);
          content = /*#__PURE__*/React__namespace.createElement("span", _extends({}, iconProps, {
            className: className
          }));
          if (iconType !== 'string') {
            var defaultContentOptions = _objectSpread$1T({
              iconProps: iconProps,
              element: content
            }, options);
            return ObjectUtils.getJSXElement(icon, defaultContentOptions);
          }
        }
        return content;
      }
    }]);
    return IconUtils;
  }();

  function ownKeys$1S(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1S(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1S(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1S(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  function mask(el, options) {
    var defaultOptions = {
      mask: null,
      slotChar: '_',
      autoClear: true,
      unmask: false,
      readOnly: false,
      onComplete: null,
      onChange: null,
      onFocus: null,
      onBlur: null
    };
    options = _objectSpread$1S(_objectSpread$1S({}, defaultOptions), options);
    var tests, partialPosition, len, firstNonMaskPos, defs, androidChrome, lastRequiredNonMaskPos, oldVal, focusText, caretTimeoutId, buffer, defaultBuffer;
    var caret = function caret(first, last) {
      var range, begin, end;
      if (!el.offsetParent || el !== document.activeElement) {
        return;
      }
      if (typeof first === 'number') {
        begin = first;
        end = typeof last === 'number' ? last : begin;
        if (el.setSelectionRange) {
          el.setSelectionRange(begin, end);
        } else if (el['createTextRange']) {
          range = el['createTextRange']();
          range.collapse(true);
          range.moveEnd('character', end);
          range.moveStart('character', begin);
          range.select();
        }
      } else {
        if (el.setSelectionRange) {
          begin = el.selectionStart;
          end = el.selectionEnd;
        } else if (document['selection'] && document['selection'].createRange) {
          range = document['selection'].createRange();
          begin = 0 - range.duplicate().moveStart('character', -100000);
          end = begin + range.text.length;
        }
        return {
          begin: begin,
          end: end
        };
      }
    };
    var isCompleted = function isCompleted() {
      for (var i = firstNonMaskPos; i <= lastRequiredNonMaskPos; i++) {
        if (tests[i] && buffer[i] === getPlaceholder(i)) {
          return false;
        }
      }
      return true;
    };
    var getPlaceholder = function getPlaceholder(i) {
      if (i < options.slotChar.length) {
        return options.slotChar.charAt(i);
      }
      return options.slotChar.charAt(0);
    };
    var getValue = function getValue() {
      return options.unmask ? getUnmaskedValue() : el && el.value;
    };
    var seekNext = function seekNext(pos) {
      while (++pos < len && !tests[pos]);
      return pos;
    };
    var seekPrev = function seekPrev(pos) {
      while (--pos >= 0 && !tests[pos]);
      return pos;
    };
    var shiftL = function shiftL(begin, end) {
      var i, j;
      if (begin < 0) {
        return;
      }
      for (i = begin, j = seekNext(end); i < len; i++) {
        if (tests[i]) {
          if (j < len && tests[i].test(buffer[j])) {
            buffer[i] = buffer[j];
            buffer[j] = getPlaceholder(j);
          } else {
            break;
          }
          j = seekNext(j);
        }
      }
      writeBuffer();
      caret(Math.max(firstNonMaskPos, begin));
    };
    var shiftR = function shiftR(pos) {
      var i, c, j, t;
      for (i = pos, c = getPlaceholder(pos); i < len; i++) {
        if (tests[i]) {
          j = seekNext(i);
          t = buffer[i];
          buffer[i] = c;
          if (j < len && tests[j].test(t)) {
            c = t;
          } else {
            break;
          }
        }
      }
    };
    var handleAndroidInput = function handleAndroidInput(e) {
      var curVal = el.value;
      var pos = caret();
      if (oldVal && oldVal.length && oldVal.length > curVal.length) {
        // a deletion or backspace happened
        checkVal(true);
        while (pos.begin > 0 && !tests[pos.begin - 1]) pos.begin--;
        if (pos.begin === 0) {
          while (pos.begin < firstNonMaskPos && !tests[pos.begin]) pos.begin++;
        }
        caret(pos.begin, pos.begin);
      } else {
        checkVal(true);
        while (pos.begin < len && !tests[pos.begin]) pos.begin++;
        caret(pos.begin, pos.begin);
      }
      if (options.onComplete && isCompleted()) {
        options.onComplete({
          originalEvent: e,
          value: getValue()
        });
      }
    };
    var onBlur = function onBlur(e) {
      checkVal();
      options.onBlur && options.onBlur(e);
      updateModel(e);
      if (el.value !== focusText) {
        var event = document.createEvent('HTMLEvents');
        event.initEvent('change', true, false);
        el.dispatchEvent(event);
      }
    };
    var onKeyDown = function onKeyDown(e) {
      if (options.readOnly) {
        return;
      }
      var k = e.which || e.keyCode,
        pos,
        begin,
        end;
      oldVal = el.value;

      //backspace, delete, and escape get special treatment
      if (k === 8 || k === 46 || DomHandler.isIOS() && k === 127) {
        pos = caret();
        begin = pos.begin;
        end = pos.end;
        if (end - begin === 0) {
          begin = k !== 46 ? seekPrev(begin) : end = seekNext(begin - 1);
          end = k === 46 ? seekNext(end) : end;
        }
        clearBuffer(begin, end);
        shiftL(begin, end - 1);
        updateModel(e);
        e.preventDefault();
      } else if (k === 13) {
        // enter
        onBlur(e);
        updateModel(e);
      } else if (k === 27) {
        // escape
        el.value = focusText;
        caret(0, checkVal());
        updateModel(e);
        e.preventDefault();
      }
    };
    var onKeyPress = function onKeyPress(e) {
      if (options.readOnly) {
        return;
      }
      var k = e.which || e.keyCode,
        pos = caret(),
        p,
        c,
        next,
        completed;
      if (e.ctrlKey || e.altKey || e.metaKey || k < 32) {
        //Ignore
        return;
      } else if (k && k !== 13) {
        if (pos.end - pos.begin !== 0) {
          clearBuffer(pos.begin, pos.end);
          shiftL(pos.begin, pos.end - 1);
        }
        p = seekNext(pos.begin - 1);
        if (p < len) {
          c = String.fromCharCode(k);
          if (tests[p].test(c)) {
            shiftR(p);
            buffer[p] = c;
            writeBuffer();
            next = seekNext(p);
            if (DomHandler.isAndroid()) {
              //Path for CSP Violation on FireFox OS 1.1
              var proxy = function proxy() {
                caret(next);
              };
              setTimeout(proxy, 0);
            } else {
              caret(next);
            }
            if (pos.begin <= lastRequiredNonMaskPos) {
              completed = isCompleted();
            }
          }
        }
        e.preventDefault();
      }
      updateModel(e);
      if (options.onComplete && completed) {
        options.onComplete({
          originalEvent: e,
          value: getValue()
        });
      }
    };
    var clearBuffer = function clearBuffer(start, end) {
      var i;
      for (i = start; i < end && i < len; i++) {
        if (tests[i]) {
          buffer[i] = getPlaceholder(i);
        }
      }
    };
    var writeBuffer = function writeBuffer() {
      el.value = buffer.join('');
    };
    var checkVal = function checkVal(allow) {
      //try to place characters where they belong
      var test = el.value,
        lastMatch = -1,
        i,
        c,
        pos;
      for (i = 0, pos = 0; i < len; i++) {
        if (tests[i]) {
          buffer[i] = getPlaceholder(i);
          while (pos++ < test.length) {
            c = test.charAt(pos - 1);
            if (tests[i].test(c)) {
              buffer[i] = c;
              lastMatch = i;
              break;
            }
          }
          if (pos > test.length) {
            clearBuffer(i + 1, len);
            break;
          }
        } else {
          if (buffer[i] === test.charAt(pos)) {
            pos++;
          }
          if (i < partialPosition) {
            lastMatch = i;
          }
        }
      }
      if (allow) {
        writeBuffer();
      } else if (lastMatch + 1 < partialPosition) {
        if (options.autoClear || buffer.join('') === defaultBuffer) {
          // Invalid value. Remove it and replace it with the
          // mask, which is the default behavior.
          if (el.value) el.value = '';
          clearBuffer(0, len);
        } else {
          // Invalid value, but we opt to show the value to the
          // user and allow them to correct their mistake.
          writeBuffer();
        }
      } else {
        writeBuffer();
        el.value = el.value.substring(0, lastMatch + 1);
      }
      return partialPosition ? i : firstNonMaskPos;
    };
    var onFocus = function onFocus(e) {
      if (options.readOnly) {
        return;
      }
      clearTimeout(caretTimeoutId);
      var pos;
      focusText = el.value;
      pos = checkVal();
      caretTimeoutId = setTimeout(function () {
        if (el !== document.activeElement) {
          return;
        }
        writeBuffer();
        if (pos === options.mask.replace('?', '').length) {
          caret(0, pos);
        } else {
          caret(pos);
        }
      }, 100);
      if (options.onFocus) {
        options.onFocus(e);
      }
    };
    var onInput = function onInput(event) {
      if (androidChrome) handleAndroidInput(event);else handleInputChange(event);
    };
    var handleInputChange = function handleInputChange(e) {
      if (options.readOnly) {
        return;
      }
      var pos = checkVal(true);
      caret(pos);
      updateModel(e);
      if (options.onComplete && isCompleted()) {
        options.onComplete({
          originalEvent: e,
          value: getValue()
        });
      }
    };
    var getUnmaskedValue = function getUnmaskedValue() {
      var unmaskedBuffer = [];
      for (var i = 0; i < buffer.length; i++) {
        var c = buffer[i];
        if (tests[i] && c !== getPlaceholder(i)) {
          unmaskedBuffer.push(c);
        }
      }
      return unmaskedBuffer.join('');
    };
    var updateModel = function updateModel(e) {
      if (options.onChange) {
        var val = getValue();
        options.onChange({
          originalEvent: e,
          value: defaultBuffer !== val ? val : '',
          stopPropagation: function stopPropagation() {
            e.stopPropagation();
          },
          preventDefault: function preventDefault() {
            e.preventDefault();
          },
          target: {
            value: defaultBuffer !== val ? val : ''
          }
        });
      }
    };
    var bindEvents = function bindEvents() {
      el.addEventListener('focus', onFocus);
      el.addEventListener('blur', onBlur);
      el.addEventListener('keydown', onKeyDown);
      el.addEventListener('keypress', onKeyPress);
      el.addEventListener('input', onInput);
      el.addEventListener('paste', handleInputChange);
    };
    var unbindEvents = function unbindEvents() {
      el.removeEventListener('focus', onFocus);
      el.removeEventListener('blur', onBlur);
      el.removeEventListener('keydown', onKeyDown);
      el.removeEventListener('keypress', onKeyPress);
      el.removeEventListener('input', onInput);
      el.removeEventListener('paste', handleInputChange);
    };
    var init = function init() {
      tests = [];
      partialPosition = options.mask.length;
      len = options.mask.length;
      firstNonMaskPos = null;
      defs = {
        9: '[0-9]',
        a: '[A-Za-z]',
        '*': '[A-Za-z0-9]'
      };
      androidChrome = DomHandler.isChrome() && DomHandler.isAndroid();
      var maskTokens = options.mask.split('');
      for (var i = 0; i < maskTokens.length; i++) {
        var c = maskTokens[i];
        if (c === '?') {
          len--;
          partialPosition = i;
        } else if (defs[c]) {
          tests.push(new RegExp(defs[c]));
          if (firstNonMaskPos === null) {
            firstNonMaskPos = tests.length - 1;
          }
          if (i < partialPosition) {
            lastRequiredNonMaskPos = tests.length - 1;
          }
        } else {
          tests.push(null);
        }
      }
      buffer = [];
      for (var _i = 0; _i < maskTokens.length; _i++) {
        var _c = maskTokens[_i];
        if (_c !== '?') {
          if (defs[_c]) buffer.push(getPlaceholder(_i));else buffer.push(_c);
        }
      }
      defaultBuffer = buffer.join('');
    };
    if (el && options.mask) {
      init();
      bindEvents();
    }
    return {
      init: init,
      bindEvents: bindEvents,
      unbindEvents: unbindEvents,
      updateModel: updateModel,
      getValue: getValue
    };
  }

  function ownKeys$1R(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1R(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1R(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1R(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  function mergeProps() {
    for (var _len = arguments.length, props = new Array(_len), _key = 0; _key < _len; _key++) {
      props[_key] = arguments[_key];
    }
    if (props) {
      var isFn = function isFn(o) {
        return !!(o && o.constructor && o.call && o.apply);
      };
      return props.reduce(function (merged, ps) {
        var _loop = function _loop() {
          var value = ps[key];
          if (key === 'style') {
            merged['style'] = _objectSpread$1R(_objectSpread$1R({}, merged['style']), ps['style']);
          } else if (key === 'className') {
            var newClassname = [merged['className'], ps['className']].join(' ').trim();
            var isEmpty = newClassname === null || newClassname === undefined || newClassname === '';
            merged['className'] = isEmpty ? undefined : newClassname;
          } else if (isFn(value)) {
            var fn = merged[key];
            merged[key] = fn ? function () {
              fn.apply(void 0, arguments);
              value.apply(void 0, arguments);
            } : value;
          } else {
            merged[key] = value;
          }
        };
        for (var key in ps) {
          _loop();
        }
        return merged;
      }, {});
    }
    return undefined;
  }

  var lastId = 0;
  function UniqueComponentId() {
    var prefix = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'pr_id_';
    lastId++;
    return "".concat(prefix).concat(lastId);
  }

  function handler() {
    var zIndexes = [];
    var generateZIndex = function generateZIndex(key, autoZIndex) {
      var baseZIndex = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 999;
      var lastZIndex = getLastZIndex(key, autoZIndex, baseZIndex);
      var newZIndex = lastZIndex.value + (lastZIndex.key === key ? 0 : baseZIndex) + 1;
      zIndexes.push({
        key: key,
        value: newZIndex
      });
      return newZIndex;
    };
    var revertZIndex = function revertZIndex(zIndex) {
      zIndexes = zIndexes.filter(function (obj) {
        return obj.value !== zIndex;
      });
    };
    var getCurrentZIndex = function getCurrentZIndex(key, autoZIndex) {
      return getLastZIndex(key, autoZIndex).value;
    };
    var getLastZIndex = function getLastZIndex(key, autoZIndex) {
      var baseZIndex = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
      return _toConsumableArray(zIndexes).reverse().find(function (obj) {
        return autoZIndex ? true : obj.key === key;
      }) || {
        key: key,
        value: baseZIndex
      };
    };
    var getZIndex = function getZIndex(el) {
      return el ? parseInt(el.style.zIndex, 10) || 0 : 0;
    };
    return {
      get: getZIndex,
      set: function set(key, el, autoZIndex, baseZIndex) {
        if (el) {
          el.style.zIndex = String(generateZIndex(key, autoZIndex, baseZIndex));
        }
      },
      clear: function clear(el) {
        if (el) {
          revertZIndex(ZIndexUtils.get(el));
          el.style.zIndex = '';
        }
      },
      getCurrent: function getCurrent(key, autoZIndex) {
        return getCurrentZIndex(key, autoZIndex);
      }
    };
  }
  var ZIndexUtils = handler();

  function _createForOfIteratorHelper$f(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray$f(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
  function _unsupportedIterableToArray$f(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray$f(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$f(o, minLen); }
  function _arrayLikeToArray$f(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
  var FilterService = {
    filter: function filter(value, fields, filterValue, filterMatchMode, filterLocale) {
      var filteredItems = [];
      if (!value) {
        return filteredItems;
      }
      var _iterator = _createForOfIteratorHelper$f(value),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var item = _step.value;
          if (typeof item === 'string') {
            if (this.filters[filterMatchMode](item, filterValue, filterLocale)) {
              filteredItems.push(item);
              continue;
            }
          } else {
            var _iterator2 = _createForOfIteratorHelper$f(fields),
              _step2;
            try {
              for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
                var field = _step2.value;
                var fieldValue = ObjectUtils.resolveFieldData(item, field);
                if (this.filters[filterMatchMode](fieldValue, filterValue, filterLocale)) {
                  filteredItems.push(item);
                  break;
                }
              }
            } catch (err) {
              _iterator2.e(err);
            } finally {
              _iterator2.f();
            }
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
      return filteredItems;
    },
    filters: {
      startsWith: function startsWith(value, filter, filterLocale) {
        if (filter === undefined || filter === null || filter.trim() === '') {
          return true;
        }
        if (value === undefined || value === null) {
          return false;
        }
        var filterValue = ObjectUtils.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);
        var stringValue = ObjectUtils.removeAccents(value.toString()).toLocaleLowerCase(filterLocale);
        return stringValue.slice(0, filterValue.length) === filterValue;
      },
      contains: function contains(value, filter, filterLocale) {
        if (filter === undefined || filter === null || typeof filter === 'string' && filter.trim() === '') {
          return true;
        }
        if (value === undefined || value === null) {
          return false;
        }
        var filterValue = ObjectUtils.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);
        var stringValue = ObjectUtils.removeAccents(value.toString()).toLocaleLowerCase(filterLocale);
        return stringValue.indexOf(filterValue) !== -1;
      },
      notContains: function notContains(value, filter, filterLocale) {
        if (filter === undefined || filter === null || typeof filter === 'string' && filter.trim() === '') {
          return true;
        }
        if (value === undefined || value === null) {
          return false;
        }
        var filterValue = ObjectUtils.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);
        var stringValue = ObjectUtils.removeAccents(value.toString()).toLocaleLowerCase(filterLocale);
        return stringValue.indexOf(filterValue) === -1;
      },
      endsWith: function endsWith(value, filter, filterLocale) {
        if (filter === undefined || filter === null || filter.trim() === '') {
          return true;
        }
        if (value === undefined || value === null) {
          return false;
        }
        var filterValue = ObjectUtils.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);
        var stringValue = ObjectUtils.removeAccents(value.toString()).toLocaleLowerCase(filterLocale);
        return stringValue.indexOf(filterValue, stringValue.length - filterValue.length) !== -1;
      },
      equals: function equals(value, filter, filterLocale) {
        if (filter === undefined || filter === null || typeof filter === 'string' && filter.trim() === '') {
          return true;
        }
        if (value === undefined || value === null) {
          return false;
        }
        if (value.getTime && filter.getTime) return value.getTime() === filter.getTime();else return ObjectUtils.removeAccents(value.toString()).toLocaleLowerCase(filterLocale) === ObjectUtils.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);
      },
      notEquals: function notEquals(value, filter, filterLocale) {
        if (filter === undefined || filter === null || typeof filter === 'string' && filter.trim() === '') {
          return true;
        }
        if (value === undefined || value === null) {
          return true;
        }
        if (value.getTime && filter.getTime) return value.getTime() !== filter.getTime();else return ObjectUtils.removeAccents(value.toString()).toLocaleLowerCase(filterLocale) !== ObjectUtils.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);
      },
      "in": function _in(value, filter) {
        if (filter === undefined || filter === null || filter.length === 0) {
          return true;
        }
        for (var i = 0; i < filter.length; i++) {
          if (ObjectUtils.equals(value, filter[i])) {
            return true;
          }
        }
        return false;
      },
      between: function between(value, filter) {
        if (filter == null || filter[0] == null || filter[1] == null) {
          return true;
        }
        if (value === undefined || value === null) {
          return false;
        }
        if (value.getTime) return filter[0].getTime() <= value.getTime() && value.getTime() <= filter[1].getTime();else return filter[0] <= value && value <= filter[1];
      },
      lt: function lt(value, filter) {
        if (filter === undefined || filter === null) {
          return true;
        }
        if (value === undefined || value === null) {
          return false;
        }
        if (value.getTime && filter.getTime) return value.getTime() < filter.getTime();else return value < filter;
      },
      lte: function lte(value, filter) {
        if (filter === undefined || filter === null) {
          return true;
        }
        if (value === undefined || value === null) {
          return false;
        }
        if (value.getTime && filter.getTime) return value.getTime() <= filter.getTime();else return value <= filter;
      },
      gt: function gt(value, filter) {
        if (filter === undefined || filter === null) {
          return true;
        }
        if (value === undefined || value === null) {
          return false;
        }
        if (value.getTime && filter.getTime) return value.getTime() > filter.getTime();else return value > filter;
      },
      gte: function gte(value, filter) {
        if (filter === undefined || filter === null) {
          return true;
        }
        if (value === undefined || value === null) {
          return false;
        }
        if (value.getTime && filter.getTime) return value.getTime() >= filter.getTime();else return value >= filter;
      },
      dateIs: function dateIs(value, filter) {
        if (filter === undefined || filter === null) {
          return true;
        }
        if (value === undefined || value === null) {
          return false;
        }
        return value.toDateString() === filter.toDateString();
      },
      dateIsNot: function dateIsNot(value, filter) {
        if (filter === undefined || filter === null) {
          return true;
        }
        if (value === undefined || value === null) {
          return false;
        }
        return value.toDateString() !== filter.toDateString();
      },
      dateBefore: function dateBefore(value, filter) {
        if (filter === undefined || filter === null) {
          return true;
        }
        if (value === undefined || value === null) {
          return false;
        }
        return value.getTime() < filter.getTime();
      },
      dateAfter: function dateAfter(value, filter) {
        if (filter === undefined || filter === null) {
          return true;
        }
        if (value === undefined || value === null) {
          return false;
        }
        return value.getTime() > filter.getTime();
      }
    },
    register: function register(rule, fn) {
      this.filters[rule] = fn;
    }
  };

  /**
   * @deprecated please use PrimeReactContext
   */
  var PrimeReact$1 = /*#__PURE__*/_createClass(function PrimeReact() {
    _classCallCheck(this, PrimeReact);
  });
  _defineProperty(PrimeReact$1, "ripple", false);
  _defineProperty(PrimeReact$1, "inputStyle", 'outlined');
  _defineProperty(PrimeReact$1, "locale", 'en');
  _defineProperty(PrimeReact$1, "appendTo", null);
  _defineProperty(PrimeReact$1, "cssTransition", true);
  _defineProperty(PrimeReact$1, "autoZIndex", true);
  _defineProperty(PrimeReact$1, "hideOverlaysOnDocumentScrolling", false);
  _defineProperty(PrimeReact$1, "nonce", null);
  _defineProperty(PrimeReact$1, "nullSortOrder", 1);
  _defineProperty(PrimeReact$1, "zIndex", {
    modal: 1100,
    overlay: 1000,
    menu: 1000,
    tooltip: 1100,
    toast: 1200
  });
  _defineProperty(PrimeReact$1, "pt", undefined);
  _defineProperty(PrimeReact$1, "filterMatchModeOptions", {
    text: [FilterMatchMode.STARTS_WITH, FilterMatchMode.CONTAINS, FilterMatchMode.NOT_CONTAINS, FilterMatchMode.ENDS_WITH, FilterMatchMode.EQUALS, FilterMatchMode.NOT_EQUALS],
    numeric: [FilterMatchMode.EQUALS, FilterMatchMode.NOT_EQUALS, FilterMatchMode.LESS_THAN, FilterMatchMode.LESS_THAN_OR_EQUAL_TO, FilterMatchMode.GREATER_THAN, FilterMatchMode.GREATER_THAN_OR_EQUAL_TO],
    date: [FilterMatchMode.DATE_IS, FilterMatchMode.DATE_IS_NOT, FilterMatchMode.DATE_BEFORE, FilterMatchMode.DATE_AFTER]
  });
  _defineProperty(PrimeReact$1, "changeTheme", function (currentTheme, newTheme, linkElementId, callback) {
    var _linkElement$parentNo;
    var linkElement = document.getElementById(linkElementId);
    var cloneLinkElement = linkElement.cloneNode(true);
    var newThemeUrl = linkElement.getAttribute('href').replace(currentTheme, newTheme);
    cloneLinkElement.setAttribute('id', linkElementId + '-clone');
    cloneLinkElement.setAttribute('href', newThemeUrl);
    cloneLinkElement.addEventListener('load', function () {
      linkElement.remove();
      cloneLinkElement.setAttribute('id', linkElementId);
      if (callback) {
        callback();
      }
    });
    (_linkElement$parentNo = linkElement.parentNode) === null || _linkElement$parentNo === void 0 || _linkElement$parentNo.insertBefore(cloneLinkElement, linkElement.nextSibling);
  });

  function ownKeys$1Q(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1Q(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1Q(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1Q(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var locales = {
    en: {
      startsWith: 'Starts with',
      contains: 'Contains',
      notContains: 'Not contains',
      endsWith: 'Ends with',
      equals: 'Equals',
      notEquals: 'Not equals',
      noFilter: 'No Filter',
      filter: 'Filter',
      lt: 'Less than',
      lte: 'Less than or equal to',
      gt: 'Greater than',
      gte: 'Greater than or equal to',
      dateIs: 'Date is',
      dateIsNot: 'Date is not',
      dateBefore: 'Date is before',
      dateAfter: 'Date is after',
      custom: 'Custom',
      clear: 'Clear',
      close: 'Close',
      apply: 'Apply',
      matchAll: 'Match All',
      matchAny: 'Match Any',
      addRule: 'Add Rule',
      removeRule: 'Remove Rule',
      accept: 'Yes',
      reject: 'No',
      choose: 'Choose',
      upload: 'Upload',
      cancel: 'Cancel',
      completed: 'Completed',
      pending: 'Pending',
      fileSizeTypes: ['B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'],
      dayNames: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'],
      dayNamesShort: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
      dayNamesMin: ['Su', 'Mo', 'Tu', 'We', 'Th', 'Fr', 'Sa'],
      monthNames: ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'],
      monthNamesShort: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
      today: 'Today',
      weekHeader: 'Wk',
      firstDayOfWeek: 0,
      showMonthAfterYear: false,
      dateFormat: 'mm/dd/yy',
      weak: 'Weak',
      medium: 'Medium',
      strong: 'Strong',
      passwordPrompt: 'Enter a password',
      emptyFilterMessage: 'No available options',
      emptyMessage: 'No results found',
      aria: {
        trueLabel: 'True',
        falseLabel: 'False',
        nullLabel: 'Not Selected',
        star: '1 star',
        stars: '{star} stars',
        selectAll: 'All items selected',
        unselectAll: 'All items unselected',
        close: 'Close',
        previous: 'Previous',
        next: 'Next',
        navigation: 'Navigation',
        scrollTop: 'Scroll Top',
        moveTop: 'Move Top',
        moveUp: 'Move Up',
        moveDown: 'Move Down',
        moveBottom: 'Move Bottom',
        moveToTarget: 'Move to Target',
        moveToSource: 'Move to Source',
        moveAllToTarget: 'Move All to Target',
        moveAllToSource: 'Move All to Source',
        pageLabel: 'Page {page}',
        firstPageLabel: 'First Page',
        lastPageLabel: 'Last Page',
        nextPageLabel: 'Next Page',
        previousPageLabel: 'Previous Page',
        rowsPerPageLabel: 'Rows per page',
        jumpToPageDropdownLabel: 'Jump to Page Dropdown',
        jumpToPageInputLabel: 'Jump to Page Input',
        selectRow: 'Row Selected',
        unselectRow: 'Row Unselected',
        expandRow: 'Row Expanded',
        collapseRow: 'Row Collapsed',
        showFilterMenu: 'Show Filter Menu',
        hideFilterMenu: 'Hide Filter Menu',
        filterOperator: 'Filter Operator',
        filterConstraint: 'Filter Constraint',
        editRow: 'Row Edit',
        saveEdit: 'Save Edit',
        cancelEdit: 'Cancel Edit',
        listView: 'List View',
        gridView: 'Grid View',
        slide: 'Slide',
        slideNumber: '{slideNumber}',
        zoomImage: 'Zoom Image',
        zoomIn: 'Zoom In',
        zoomOut: 'Zoom Out',
        rotateRight: 'Rotate Right',
        rotateLeft: 'Rotate Left',
        selectLabel: 'Select',
        unselectLabel: 'Unselect',
        expandLabel: 'Expand',
        collapseLabel: 'Collapse'
      }
    }
  };
  function locale(locale) {
    locale && (PrimeReact$1.locale = locale);
    return {
      locale: PrimeReact$1.locale,
      options: locales[PrimeReact$1.locale]
    };
  }
  function addLocale(locale, options) {
    locales[locale] = _objectSpread$1Q(_objectSpread$1Q({}, locales['en']), options);
  }
  function updateLocaleOption(key, value, locale) {
    localeOptions(locale)[key] = value;
  }
  function updateLocaleOptions(options, locale) {
    var _locale = locale || PrimeReact$1.locale;
    locales[_locale] = _objectSpread$1Q(_objectSpread$1Q({}, locales[_locale]), options);
  }
  function localeOption(key, locale) {
    var _locale = locale || PrimeReact$1.locale;
    try {
      return localeOptions(_locale)[key];
    } catch (error) {
      throw new Error("The ".concat(key, " option is not found in the current locale('").concat(_locale, "')."));
    }
  }

  /**
   * Find an ARIA label in the locale by key.  If options are passed it will replace all options:
   * ```ts
   * const ariaValue = "Page {page}, User {user}, Role {role}";
   * const options = { page: 2, user: "John", role: "Admin" };
   * const result = ariaLabel('yourLabel', { page: 2, user: "John", role: "Admin" })
   * console.log(result); // Output: Page 2, User John, Role Admin
   * ```
   * @param {string} ariaKey key of the ARIA label to look up in locale.
   * @param {any} options JSON options like { page: 2, user: "John", role: "Admin" }
   * @returns the ARIA label with replaced values
   */
  function ariaLabel(ariaKey, options) {
    var _locale = PrimeReact$1.locale;
    try {
      var _ariaLabel = localeOptions(_locale)['aria'][ariaKey];
      if (_ariaLabel) {
        for (var key in options) {
          if (options.hasOwnProperty(key)) {
            _ariaLabel = _ariaLabel.replace("{".concat(key, "}"), options[key]);
          }
        }
      }
      return _ariaLabel;
    } catch (error) {
      throw new Error("The ".concat(ariaKey, " option is not found in the current locale('").concat(_locale, "')."));
    }
  }
  function localeOptions(locale) {
    var _locale = locale || PrimeReact$1.locale;
    return locales[_locale];
  }

  var MessageSeverity = Object.freeze({
    SUCCESS: 'success',
    INFO: 'info',
    WARN: 'warn',
    ERROR: 'error'
  });

  var PrimeIcons = Object.freeze({
    ALIGN_CENTER: 'pi pi-align-center',
    ALIGN_JUSTIFY: 'pi pi-align-justify',
    ALIGN_LEFT: 'pi pi-align-left',
    ALIGN_RIGHT: 'pi pi-align-right',
    AMAZON: 'pi pi-amazon',
    ANDROID: 'pi pi-android',
    ANGLE_DOUBLE_DOWN: 'pi pi-angle-double-down',
    ANGLE_DOUBLE_LEFT: 'pi pi-angle-double-left',
    ANGLE_DOUBLE_RIGHT: 'pi pi-angle-double-right',
    ANGLE_DOUBLE_UP: 'pi pi-angle-double-up',
    ANGLE_DOWN: 'pi pi-angle-down',
    ANGLE_LEFT: 'pi pi-angle-left',
    ANGLE_RIGHT: 'pi pi-angle-right',
    ANGLE_UP: 'pi pi-angle-up',
    APPLE: 'pi pi-apple',
    ARROW_CIRCLE_DOWN: 'pi pi-arrow-circle-down',
    ARROW_CIRCLE_LEFT: 'pi pi-arrow-circle-left',
    ARROW_CIRCLE_RIGHT: 'pi pi-arrow-circle-right',
    ARROW_CIRCLE_UP: 'pi pi-arrow-circle-up',
    ARROW_DOWN: 'pi pi-arrow-down',
    ARROW_DOWN_LEFT: 'pi pi-arrow-down-left',
    ARROW_DOWN_RIGHT: 'pi pi-arrow-down-right',
    ARROW_LEFT: 'pi pi-arrow-left',
    ARROW_RIGHT: 'pi pi-arrow-right',
    ARROW_RIGHT_ARROW_LEFT: 'pi pi-arrow-right-arrow-left',
    ARROW_UP: 'pi pi-arrow-up',
    ARROW_UP_LEFT: 'pi pi-arrow-up-left',
    ARROW_UP_RIGHT: 'pi pi-arrow-up-right',
    ARROWS_ALT: 'pi pi-arrows-alt',
    ARROWS_H: 'pi pi-arrows-h',
    ARROWS_V: 'pi pi-arrows-v',
    AT: 'pi pi-at',
    BACKWARD: 'pi pi-backward',
    BAN: 'pi pi-ban',
    BARS: 'pi pi-bars',
    BELL: 'pi pi-bell',
    BITCOIN: 'pi pi-bitcoin',
    BOLT: 'pi pi-bolt',
    BOOK: 'pi pi-book',
    BOOKMARK: 'pi pi-bookmark',
    BOOKMARK_FILL: 'pi pi-bookmark-fill',
    BOX: 'pi pi-box',
    BRIEFCASE: 'pi pi-briefcase',
    BUILDING: 'pi pi-building',
    CALCULATOR: 'pi pi-calculator',
    CALENDAR: 'pi pi-calendar',
    CALENDAR_MINUS: 'pi pi-calendar-minus',
    CALENDAR_PLUS: 'pi pi-calendar-plus',
    CALENDAR_TIMES: 'pi pi-calendar-times',
    CAMERA: 'pi pi-camera',
    CAR: 'pi pi-car',
    CARET_DOWN: 'pi pi-caret-down',
    CARET_LEFT: 'pi pi-caret-left',
    CARET_RIGHT: 'pi pi-caret-right',
    CARET_UP: 'pi pi-caret-up',
    CART_PLUS: 'pi pi-cart-plus',
    CHART_BAR: 'pi pi-chart-bar',
    CHART_LINE: 'pi pi-chart-line',
    CHART_PIE: 'pi pi-chart-pie',
    CHECK: 'pi pi-check',
    CHECK_CIRCLE: 'pi pi-check-circle',
    CHECK_SQUARE: 'pi pi-check-square',
    CHEVRON_CIRCLE_DOWN: 'pi pi-chevron-circle-down',
    CHEVRON_CIRCLE_LEFT: 'pi pi-chevron-circle-left',
    CHEVRON_CIRCLE_RIGHT: 'pi pi-chevron-circle-right',
    CHEVRON_CIRCLE_UP: 'pi pi-chevron-circle-up',
    CHEVRON_DOWN: 'pi pi-chevron-down',
    CHEVRON_LEFT: 'pi pi-chevron-left',
    CHEVRON_RIGHT: 'pi pi-chevron-right',
    CHEVRON_UP: 'pi pi-chevron-up',
    CIRCLE: 'pi pi-circle',
    CIRCLE_FILL: 'pi pi-circle-fill',
    CIRCLE_OFF: 'pi pi-circle-off',
    CIRCLE_ON: 'pi pi-circle-on',
    CLOCK: 'pi pi-clock',
    CLONE: 'pi pi-clone',
    CLOUD: 'pi pi-cloud',
    CLOUD_DOWNLOAD: 'pi pi-cloud-download',
    CLOUD_UPLOAD: 'pi pi-cloud-upload',
    CODE: 'pi pi-code',
    COG: 'pi pi-cog',
    COMMENT: 'pi pi-comment',
    COMMENTS: 'pi pi-comments',
    COMPASS: 'pi pi-compass',
    COPY: 'pi pi-copy',
    CREDIT_CARD: 'pi pi-credit-card',
    DATABASE: 'pi pi-database',
    DELETE_LEFT: 'pi pi-delete-left',
    DESKTOP: 'pi pi-desktop',
    DIRECTIONS: 'pi pi-directions',
    DIRECTIONS_ALT: 'pi pi-directions-alt',
    DISCORD: 'pi pi-discord',
    DOLLAR: 'pi pi-dollar',
    DOWNLOAD: 'pi pi-download',
    EJECT: 'pi pi-eject',
    ELLIPSIS_H: 'pi pi-ellipsis-h',
    ELLIPSIS_V: 'pi pi-ellipsis-v',
    ENVELOPE: 'pi pi-envelope',
    ERASER: 'pi pi-eraser',
    EURO: 'pi pi-euro',
    EXCLAMATION_CIRCLE: 'pi pi-exclamation-circle',
    EXCLAMATION_TRIANGLE: 'pi pi-exclamation-triangle',
    EXTERNAL_LINK: 'pi pi-external-link',
    EYE: 'pi pi-eye',
    EYE_SLASH: 'pi pi-eye-slash',
    FACEBOOK: 'pi pi-facebook',
    FAST_BACKWARD: 'pi pi-fast-backward',
    FAST_FORWARD: 'pi pi-fast-forward',
    FILE: 'pi pi-file',
    FILE_EDIT: 'pi pi-file-edit',
    FILE_EXCEL: 'pi pi-file-excel',
    FILE_EXPORT: 'pi pi-file-export',
    FILE_IMPORT: 'pi pi-file-import',
    FILE_O: 'pi pi-file-o',
    FILE_PDF: 'pi pi-file-pdf',
    FILE_WORD: 'pi pi-file-word',
    FILTER: 'pi pi-filter',
    FILTER_FILL: 'pi pi-filter-fill',
    FILTER_SLASH: 'pi pi-filter-slash',
    FLAG: 'pi pi-flag',
    FLAG_FILL: 'pi pi-flag-fill',
    FOLDER: 'pi pi-folder',
    FOLDER_OPEN: 'pi pi-folder-open',
    FORWARD: 'pi pi-forward',
    GIFT: 'pi pi-gift',
    GITHUB: 'pi pi-github',
    GLOBE: 'pi pi-globe',
    GOOGLE: 'pi pi-google',
    HASHTAG: 'pi pi-hashtag',
    HEART: 'pi pi-heart',
    HEART_FILL: 'pi pi-heart-fill',
    HISTORY: 'pi pi-history',
    HOME: 'pi pi-home',
    HOURGLASS: 'pi pi-hourglass',
    ID_CARD: 'pi pi-id-card',
    IMAGE: 'pi pi-image',
    IMAGES: 'pi pi-images',
    INBOX: 'pi pi-inbox',
    INFO: 'pi pi-info',
    INFO_CIRCLE: 'pi pi-info-circle',
    INSTAGRAM: 'pi pi-instagram',
    KEY: 'pi pi-key',
    LANGUAGE: 'pi pi-language',
    LINK: 'pi pi-link',
    LINKEDIN: 'pi pi-linkedin',
    LIST: 'pi pi-list',
    LOCK: 'pi pi-lock',
    LOCK_OPEN: 'pi pi-lock-open',
    MAP: 'pi pi-map',
    MAP_MARKER: 'pi pi-map-marker',
    MEGAPHONE: 'pi pi-megaphone',
    MICROPHONE: 'pi pi-microphone',
    MICROSOFT: 'pi pi-microsoft',
    MINUS: 'pi pi-minus',
    MINUS_CIRCLE: 'pi pi-minus-circle',
    MOBILE: 'pi pi-mobile',
    MONEY_BILL: 'pi pi-money-bill',
    MOON: 'pi pi-moon',
    PALETTE: 'pi pi-palette',
    PAPERCLIP: 'pi pi-paperclip',
    PAUSE: 'pi pi-pause',
    PAYPAL: 'pi pi-paypal',
    PENCIL: 'pi pi-pencil',
    PERCENTAGE: 'pi pi-percentage',
    PHONE: 'pi pi-phone',
    PLAY: 'pi pi-play',
    PLUS: 'pi pi-plus',
    PLUS_CIRCLE: 'pi pi-plus-circle',
    POUND: 'pi pi-pound',
    POWER_OFF: 'pi pi-power-off',
    PRIME: 'pi pi-prime',
    PRINT: 'pi pi-print',
    QRCODE: 'pi pi-qrcode',
    QUESTION: 'pi pi-question',
    QUESTION_CIRCLE: 'pi pi-question-circle',
    REDDIT: 'pi pi-reddit',
    REFRESH: 'pi pi-refresh',
    REPLAY: 'pi pi-replay',
    REPLY: 'pi pi-reply',
    SAVE: 'pi pi-save',
    SEARCH: 'pi pi-search',
    SEARCH_MINUS: 'pi pi-search-minus',
    SEARCH_PLUS: 'pi pi-search-plus',
    SEND: 'pi pi-send',
    SERVER: 'pi pi-server',
    SHARE_ALT: 'pi pi-share-alt',
    SHIELD: 'pi pi-shield',
    SHOPPING_BAG: 'pi pi-shopping-bag',
    SHOPPING_CART: 'pi pi-shopping-cart',
    SIGN_IN: 'pi pi-sign-in',
    SIGN_OUT: 'pi pi-sign-out',
    SITEMAP: 'pi pi-sitemap',
    SLACK: 'pi pi-slack',
    SLIDERS_H: 'pi pi-sliders-h',
    SLIDERS_V: 'pi pi-sliders-v',
    SORT: 'pi pi-sort',
    SORT_ALPHA_DOWN: 'pi pi-sort-alpha-down',
    SORT_ALPHA_DOWN_ALT: 'pi pi-sort-alpha-down-alt',
    SORT_ALPHA_UP: 'pi pi-sort-alpha-up',
    SORT_ALPHA_UP_ALT: 'pi pi-sort-alpha-up-alt',
    SORT_ALT: 'pi pi-sort-alt',
    SORT_ALT_SLASH: 'pi pi-sort-alt-slash',
    SORT_AMOUNT_DOWN: 'pi pi-sort-amount-down',
    SORT_AMOUNT_DOWN_ALT: 'pi pi-sort-amount-down-alt',
    SORT_AMOUNT_UP: 'pi pi-sort-amount-up',
    SORT_AMOUNT_UP_ALT: 'pi pi-sort-amount-up-alt',
    SORT_DOWN: 'pi pi-sort-down',
    SORT_NUMERIC_DOWN: 'pi pi-sort-numeric-down',
    SORT_NUMERIC_DOWN_ALT: 'pi pi-sort-numeric-down-alt',
    SORT_NUMERIC_UP: 'pi pi-sort-numeric-up',
    SORT_NUMERIC_UP_ALT: 'pi pi-sort-numeric-up-alt',
    SORT_UP: 'pi pi-sort-up',
    SPINNER: 'pi pi-spinner',
    STAR: 'pi pi-star',
    STAR_FILL: 'pi pi-star-fill',
    STEP_BACKWARD: 'pi pi-step-backward',
    STEP_BACKWARD_ALT: 'pi pi-step-backward-alt',
    STEP_FORWARD: 'pi pi-step-forward',
    STEP_FORWARD_ALT: 'pi pi-step-forward-alt',
    STOP: 'pi pi-stop',
    STOP_CIRCLE: 'pi pi-stop-circle',
    STOPWATCH: 'pi pi-stopwatch',
    SUN: 'pi pi-sun',
    SYNC: 'pi pi-sync',
    TABLE: 'pi pi-table',
    TABLET: 'pi pi-tablet',
    TAG: 'pi pi-tag',
    TAGS: 'pi pi-tags',
    TELEGRAM: 'pi pi-telegram',
    TH_LARGE: 'pi pi-th-large',
    THUMBS_DOWN: 'pi pi-thumbs-down',
    THUMBS_DOWN_FILL: 'pi pi-thumbs-down-fill',
    THUMBS_UP: 'pi pi-thumbs-up',
    THUMBS_UP_FILL: 'pi pi-thumbs-up-fill',
    TICKET: 'pi pi-ticket',
    TIMES: 'pi pi-times',
    TIMES_CIRCLE: 'pi pi-times-circle',
    TRASH: 'pi pi-trash',
    TRUCK: 'pi pi-truck',
    TWITTER: 'pi pi-twitter',
    UNDO: 'pi pi-undo',
    UNLOCK: 'pi pi-unlock',
    UPLOAD: 'pi pi-upload',
    USER: 'pi pi-user',
    USER_EDIT: 'pi pi-user-edit',
    USER_MINUS: 'pi pi-user-minus',
    USER_PLUS: 'pi pi-user-plus',
    USERS: 'pi pi-users',
    VERIFIED: 'pi pi-verified',
    VIDEO: 'pi pi-video',
    VIMEO: 'pi pi-vimeo',
    VOLUME_DOWN: 'pi pi-volume-down',
    VOLUME_OFF: 'pi pi-volume-off',
    VOLUME_UP: 'pi pi-volume-up',
    WALLET: 'pi pi-wallet',
    WHATSAPP: 'pi pi-whatsapp',
    WIFI: 'pi pi-wifi',
    WINDOW_MAXIMIZE: 'pi pi-window-maximize',
    WINDOW_MINIMIZE: 'pi pi-window-minimize',
    WRENCH: 'pi pi-wrench',
    YOUTUBE: 'pi pi-youtube'
  });

  var SortOrder = Object.freeze({
    DESC: -1,
    UNSORTED: 0,
    ASC: 1
  });

  var PrimeReactContext = /*#__PURE__*/React__default["default"].createContext();
  var PrimeReactProvider = function PrimeReactProvider(props) {
    var propsValue = props.value || {};
    var _useState = React.useState(propsValue.ripple || false),
      _useState2 = _slicedToArray(_useState, 2),
      ripple = _useState2[0],
      setRipple = _useState2[1];
    var _useState3 = React.useState(propsValue.inputStyle || 'outlined'),
      _useState4 = _slicedToArray(_useState3, 2),
      inputStyle = _useState4[0],
      setInputStyle = _useState4[1];
    var _useState5 = React.useState(propsValue.locale || 'en'),
      _useState6 = _slicedToArray(_useState5, 2),
      locale = _useState6[0],
      setLocale = _useState6[1];
    var _useState7 = React.useState(propsValue.appendTo || null),
      _useState8 = _slicedToArray(_useState7, 2),
      appendTo = _useState8[0],
      setAppendTo = _useState8[1];
    var _useState9 = React.useState(propsValue.styleContainer || null),
      _useState10 = _slicedToArray(_useState9, 2),
      styleContainer = _useState10[0],
      setStyleContainer = _useState10[1];
    var _useState11 = React.useState(propsValue.cssTransition || true),
      _useState12 = _slicedToArray(_useState11, 2),
      cssTransition = _useState12[0],
      setCssTransition = _useState12[1];
    var _useState13 = React.useState(propsValue.autoZIndex || true),
      _useState14 = _slicedToArray(_useState13, 2),
      autoZIndex = _useState14[0],
      setAutoZIndex = _useState14[1];
    var _useState15 = React.useState(propsValue.hideOverlaysOnDocumentScrolling || false),
      _useState16 = _slicedToArray(_useState15, 2),
      hideOverlaysOnDocumentScrolling = _useState16[0],
      setHideOverlaysOnDocumentScrolling = _useState16[1];
    var _useState17 = React.useState(propsValue.nonce || null),
      _useState18 = _slicedToArray(_useState17, 2),
      nonce = _useState18[0],
      setNonce = _useState18[1];
    var _useState19 = React.useState(propsValue.nullSortOrder || 1),
      _useState20 = _slicedToArray(_useState19, 2),
      nullSortOrder = _useState20[0],
      setNullSortOrder = _useState20[1];
    var _useState21 = React.useState(propsValue.zIndex || {
        modal: 1100,
        overlay: 1000,
        menu: 1000,
        tooltip: 1100,
        toast: 1200
      }),
      _useState22 = _slicedToArray(_useState21, 2),
      zIndex = _useState22[0],
      setZIndex = _useState22[1];
    var _useState23 = React.useState(propsValue.ptOptions || {
        mergeSections: true,
        mergeProps: true
      }),
      _useState24 = _slicedToArray(_useState23, 2),
      ptOptions = _useState24[0],
      setPtOptions = _useState24[1];
    var _useState25 = React.useState(propsValue.pt || undefined),
      _useState26 = _slicedToArray(_useState25, 2),
      pt = _useState26[0],
      setPt = _useState26[1];
    var _useState27 = React.useState(propsValue.unstyled || false),
      _useState28 = _slicedToArray(_useState27, 2),
      unstyled = _useState28[0],
      setUnstyled = _useState28[1];
    var _useState29 = React.useState(propsValue.filterMatchModeOptions || {
        text: [FilterMatchMode.STARTS_WITH, FilterMatchMode.CONTAINS, FilterMatchMode.NOT_CONTAINS, FilterMatchMode.ENDS_WITH, FilterMatchMode.EQUALS, FilterMatchMode.NOT_EQUALS],
        numeric: [FilterMatchMode.EQUALS, FilterMatchMode.NOT_EQUALS, FilterMatchMode.LESS_THAN, FilterMatchMode.LESS_THAN_OR_EQUAL_TO, FilterMatchMode.GREATER_THAN, FilterMatchMode.GREATER_THAN_OR_EQUAL_TO],
        date: [FilterMatchMode.DATE_IS, FilterMatchMode.DATE_IS_NOT, FilterMatchMode.DATE_BEFORE, FilterMatchMode.DATE_AFTER]
      }),
      _useState30 = _slicedToArray(_useState29, 2),
      filterMatchModeOptions = _useState30[0],
      setFilterMatchModeOptions = _useState30[1];
    var changeTheme = function changeTheme(currentTheme, newTheme, linkElementId, callback) {
      var _linkElement$parentNo;
      var linkElement = document.getElementById(linkElementId);
      var cloneLinkElement = linkElement.cloneNode(true);
      var newThemeUrl = linkElement.getAttribute('href').replace(currentTheme, newTheme);
      cloneLinkElement.setAttribute('id', linkElementId + '-clone');
      cloneLinkElement.setAttribute('href', newThemeUrl);
      cloneLinkElement.addEventListener('load', function () {
        linkElement.remove();
        cloneLinkElement.setAttribute('id', linkElementId);
        if (callback) {
          callback();
        }
      });
      (_linkElement$parentNo = linkElement.parentNode) === null || _linkElement$parentNo === void 0 || _linkElement$parentNo.insertBefore(cloneLinkElement, linkElement.nextSibling);
    };

    /**
     * @deprecated
     */
    React__default["default"].useEffect(function () {
      PrimeReact$1.ripple = ripple;
    }, [ripple]);

    /**
     * @deprecated
     */
    React__default["default"].useEffect(function () {
      PrimeReact$1.inputStyle = inputStyle;
    }, [inputStyle]);

    /**
     * @deprecated
     */
    React__default["default"].useEffect(function () {
      PrimeReact$1.locale = locale;
    }, [locale]);
    var value = {
      changeTheme: changeTheme,
      ripple: ripple,
      setRipple: setRipple,
      inputStyle: inputStyle,
      setInputStyle: setInputStyle,
      locale: locale,
      setLocale: setLocale,
      appendTo: appendTo,
      setAppendTo: setAppendTo,
      styleContainer: styleContainer,
      setStyleContainer: setStyleContainer,
      cssTransition: cssTransition,
      setCssTransition: setCssTransition,
      autoZIndex: autoZIndex,
      setAutoZIndex: setAutoZIndex,
      hideOverlaysOnDocumentScrolling: hideOverlaysOnDocumentScrolling,
      setHideOverlaysOnDocumentScrolling: setHideOverlaysOnDocumentScrolling,
      nonce: nonce,
      setNonce: setNonce,
      nullSortOrder: nullSortOrder,
      setNullSortOrder: setNullSortOrder,
      zIndex: zIndex,
      setZIndex: setZIndex,
      ptOptions: ptOptions,
      setPtOptions: setPtOptions,
      pt: pt,
      setPt: setPt,
      filterMatchModeOptions: filterMatchModeOptions,
      setFilterMatchModeOptions: setFilterMatchModeOptions,
      unstyled: unstyled,
      setUnstyled: setUnstyled
    };
    return /*#__PURE__*/React__default["default"].createElement(PrimeReactContext.Provider, {
      value: value
    }, props.children);
  };

  var PrimeReact = PrimeReact$1;

  var usePrevious = function usePrevious(newValue) {
    var ref = React__namespace.useRef(undefined);
    React__namespace.useEffect(function () {
      ref.current = newValue;
    });
    return ref.current;
  };

  /* eslint-disable */
  var useUnmountEffect = function useUnmountEffect(fn) {
    return React__namespace.useEffect(function () {
      return fn;
    }, []);
  };
  /* eslint-enable */

  /* eslint-disable */
  var useEventListener = function useEventListener(_ref) {
    var _ref$target = _ref.target,
      target = _ref$target === void 0 ? 'document' : _ref$target,
      type = _ref.type,
      listener = _ref.listener,
      options = _ref.options,
      _ref$when = _ref.when,
      when = _ref$when === void 0 ? true : _ref$when;
    var targetRef = React__namespace.useRef(null);
    var listenerRef = React__namespace.useRef(null);
    var prevListener = usePrevious(listener);
    var prevOptions = usePrevious(options);
    var bind = function bind() {
      var bindOptions = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      if (ObjectUtils.isNotEmpty(bindOptions.target)) {
        unbind();
        (bindOptions.when || when) && (targetRef.current = DomHandler.getTargetElement(bindOptions.target));
      }
      if (!listenerRef.current && targetRef.current) {
        listenerRef.current = function (event) {
          return listener && listener(event);
        };
        targetRef.current.addEventListener(type, listenerRef.current, options);
      }
    };
    var unbind = function unbind() {
      if (listenerRef.current) {
        targetRef.current.removeEventListener(type, listenerRef.current, options);
        listenerRef.current = null;
      }
    };
    React__namespace.useEffect(function () {
      if (when) {
        targetRef.current = DomHandler.getTargetElement(target);
      } else {
        unbind();
        targetRef.current = null;
      }
    }, [target, when]);
    React__namespace.useEffect(function () {
      // to properly compare functions we can implicitly converting the function to it's body's text as a String
      if (listenerRef.current && ('' + prevListener !== '' + listener || prevOptions !== options)) {
        unbind();
        when && bind();
      }
    }, [listener, options, when]);
    useUnmountEffect(function () {
      unbind();
    });
    return [bind, unbind];
  };
  /* eslint-enable */

  var useClickOutside = function useClickOutside(ref, callback) {
    var isOutsideClicked = function isOutsideClicked(event) {
      if (!ref.current || ref.current.contains(event.target)) {
        return;
      }
      callback(event);
    };
    var _useEventListener = useEventListener({
        type: 'mousedown',
        listener: isOutsideClicked
      }),
      _useEventListener2 = _slicedToArray(_useEventListener, 2),
      bindMouseDownListener = _useEventListener2[0],
      unbindMouseDownListener = _useEventListener2[1];
    var _useEventListener3 = useEventListener({
        type: 'touchstart',
        listener: isOutsideClicked
      }),
      _useEventListener4 = _slicedToArray(_useEventListener3, 2),
      bindTouchStartListener = _useEventListener4[0],
      unbindTouchStartListener = _useEventListener4[1];
    React__namespace.useEffect(function () {
      if (!ref.current) {
        return;
      }
      bindMouseDownListener();
      bindTouchStartListener();
      return function () {
        unbindMouseDownListener();
        unbindTouchStartListener();
      };
    });
    return [ref, callback];
  };

  var useCounter = function useCounter() {
    var initialValue = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {
      step: 1
    };
    var _React$useState = React__namespace.useState(initialValue),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      count = _React$useState2[0],
      setCount = _React$useState2[1];
    var increment = function increment() {
      if (options.max && count >= options.max) {
        return;
      }
      setCount(count + options.step);
    };
    var decrement = function decrement() {
      if (options.min || options.min === 0 && count <= options.min) {
        return null;
      }
      setCount(count - options.step);
    };
    var reset = function reset() {
      setCount(0);
    };
    return {
      count: count,
      increment: increment,
      decrement: decrement,
      reset: reset
    };
  };

  var useDebounce = function useDebounce(initialValue, delay) {
    var _React$useState = React__namespace.useState(initialValue),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      inputValue = _React$useState2[0],
      setInputValue = _React$useState2[1];
    var _React$useState3 = React__namespace.useState(initialValue),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      debouncedValue = _React$useState4[0],
      setDebouncedValue = _React$useState4[1];
    var mountedRef = React__namespace.useRef(false);
    var timeoutRef = React__namespace.useRef(null);
    var cancelTimer = function cancelTimer() {
      return window.clearTimeout(timeoutRef.current);
    };
    useMountEffect(function () {
      mountedRef.current = true;
    });
    useUnmountEffect(function () {
      cancelTimer();
    });
    React__namespace.useEffect(function () {
      if (!mountedRef.current) {
        return;
      }
      cancelTimer();
      timeoutRef.current = window.setTimeout(function () {
        setDebouncedValue(inputValue);
      }, delay);
    }, [inputValue, delay]);
    return [inputValue, debouncedValue, setInputValue];
  };

  var groupToDisplayedElements = {};
  var useDisplayOrder = function useDisplayOrder(group) {
    var isVisible = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
    var _React$useState = React__namespace.useState(function () {
        return UniqueComponentId();
      }),
      _React$useState2 = _slicedToArray(_React$useState, 1),
      uid = _React$useState2[0];
    var _React$useState3 = React__namespace.useState(),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      displayOrder = _React$useState4[0],
      setDisplayOrder = _React$useState4[1];
    React__namespace.useEffect(function () {
      if (isVisible) {
        if (!(group in groupToDisplayedElements)) {
          groupToDisplayedElements[group] = [];
        }
        var newDisplayOrder = groupToDisplayedElements[group].length;
        groupToDisplayedElements[group].push(uid);
        setDisplayOrder(newDisplayOrder);
        return function () {
          delete groupToDisplayedElements[group][newDisplayOrder];
          var lastOrder = groupToDisplayedElements[group].findLastIndex(function (el) {
            return el !== undefined;
          });

          // Reduce array length, by removing undefined elements at the end of array:
          groupToDisplayedElements[group].splice(lastOrder + 1);
          setDisplayOrder(undefined);
        };
      }
    }, [group, uid, isVisible]);
    return displayOrder;
  };

  var TYPE_MAP = {
    ico: 'image/x-icon',
    png: 'image/png',
    svg: 'image/svg+xml',
    gif: 'image/gif'
  };
  var useFavicon = function useFavicon() {
    var newIcon = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
    var rel = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'shortcut icon';
    React__namespace.useLayoutEffect(function () {
      if (newIcon) {
        var linkElements = document.querySelectorAll("link[rel*='icon']");
        linkElements.forEach(function (linkEl) {
          document.head.removeChild(linkEl);
        });
        var link = document.createElement('link');
        link.setAttribute('type', TYPE_MAP[newIcon.split('.').pop()]);
        link.setAttribute('rel', rel);
        link.setAttribute('href', newIcon);
        document.head.appendChild(link);
      }
    }, [newIcon, rel]);
  };

  /**
   * Priorities of different components (bigger number handled first)
   */
  var ESC_KEY_HANDLING_PRIORITIES = {
    SIDEBAR: 100,
    SLIDE_MENU: 200,
    DIALOG: 300,
    IMAGE: 400,
    MENU: 500,
    OVERLAY_PANEL: 600,
    PASSWORD: 700,
    CASCADE_SELECT: 800,
    SPLIT_BUTTON: 900,
    SPEED_DIAL: 1000
  };

  /**
   * Object, that manages global escape key handling logic
   */
  var globalEscKeyHandlingLogic = {
    /**
     * Mapping from ESC_KEY_HANDLING_PRIORITY to array of related listeners, grouped by priority
     * @example
     * Map<{
     *     [ESC_KEY_HANDLING_PRIORITIES.SIDEBAR]: Map<{
     *         1: () => {...},
     *         2: () => {...}
     *     }>,
     *     [ESC_KEY_HANDLING_PRIORITIES.DIALOG]: Map<{
     *         1: () => {...},
     *         2: () => {...}
     *     }>
     * }>;
     */
    escKeyListeners: new Map(),
    /**
     * Keydown handler (attached to any keydown)
     */
    onGlobalKeyDown: function onGlobalKeyDown(event) {
      // Do nothing if not an "esc" key is pressed:
      if (event.key !== 'Esc' && event.key !== 'Escape') return;
      var escKeyListeners = globalEscKeyHandlingLogic.escKeyListeners;
      var maxPrimaryPriority = Math.max.apply(Math, _toConsumableArray(escKeyListeners.keys()));
      var theMostImportantEscHandlersSet = escKeyListeners.get(maxPrimaryPriority);
      var maxSecondaryPriority = Math.max.apply(Math, _toConsumableArray(theMostImportantEscHandlersSet.keys()));
      var theMostImportantEscHandler = theMostImportantEscHandlersSet.get(maxSecondaryPriority);
      theMostImportantEscHandler(event);
    },
    /**
     * Attach global keydown listener if there are any "esc" key handlers assigned,
     * otherwise detach.
     */
    refreshGlobalKeyDownListener: function refreshGlobalKeyDownListener() {
      var document = DomHandler.getTargetElement('document');
      if (this.escKeyListeners.size > 0) {
        document.addEventListener('keydown', this.onGlobalKeyDown);
      } else {
        document.removeEventListener('keydown', this.onGlobalKeyDown);
      }
    },
    /**
     * Add "Esc" key handler
     */
    addListener: function addListener(callback, _ref) {
      var _this = this;
      var _ref2 = _slicedToArray(_ref, 2),
        primaryPriority = _ref2[0],
        secondaryPriority = _ref2[1];
      var escKeyListeners = this.escKeyListeners;
      if (!escKeyListeners.has(primaryPriority)) {
        escKeyListeners.set(primaryPriority, new Map());
      }
      var primaryPriorityListeners = escKeyListeners.get(primaryPriority);

      // To prevent unexpected override of callback:
      if (primaryPriorityListeners.has(secondaryPriority)) {
        throw new Error("Unexpected: global esc key listener with priority [".concat(primaryPriority, ", ").concat(secondaryPriority, "] already exists."));
      }
      primaryPriorityListeners.set(secondaryPriority, callback);
      this.refreshGlobalKeyDownListener();
      return function () {
        primaryPriorityListeners["delete"](secondaryPriority);
        if (primaryPriorityListeners.size === 0) {
          escKeyListeners["delete"](primaryPriority);
        }
        _this.refreshGlobalKeyDownListener();
      };
    }
  };
  var useGlobalOnEscapeKey = function useGlobalOnEscapeKey(_ref3) {
    var callback = _ref3.callback,
      when = _ref3.when,
      priority = _ref3.priority;
    React.useEffect(function () {
      if (!when) return;
      return globalEscKeyHandlingLogic.addListener(callback, priority);
    }, [when, callback, priority]);
  };

  var useIntersectionObserver = function useIntersectionObserver(ref) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var _React$useState = React__namespace.useState(false),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      isElementVisible = _React$useState2[0],
      setIsElementVisible = _React$useState2[1];
    React__namespace.useEffect(function () {
      if (!ref.current) return;
      var observer = new IntersectionObserver(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 1),
          entry = _ref2[0];
        setIsElementVisible(entry.isIntersecting);
      }, options);
      observer.observe(ref.current);
      return function () {
        observer.disconnect();
      };
    }, [options, ref]);
    return isElementVisible;
  };

  /* eslint-disable */
  var useInterval = function useInterval(fn) {
    var delay = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
    var when = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
    var timeout = React__namespace.useRef(null);
    var savedCallback = React__namespace.useRef(null);
    var clear = React__namespace.useCallback(function () {
      return clearInterval(timeout.current);
    }, [timeout.current]);
    React__namespace.useEffect(function () {
      savedCallback.current = fn;
    });
    React__namespace.useEffect(function () {
      function callback() {
        savedCallback.current();
      }
      if (when) {
        timeout.current = setInterval(callback, delay);
        return clear;
      } else {
        clear();
      }
    }, [delay, when]);
    useUnmountEffect(function () {
      clear();
    });
    return [clear];
  };
  /* eslint-enable */

  var useMatchMedia = function useMatchMedia(query) {
    var when = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
    var _React$useState = React__namespace.useState(false),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      matches = _React$useState2[0],
      setMatches = _React$useState2[1];
    var matchMedia = React__namespace.useRef(null);
    var handleChange = function handleChange(e) {
      return setMatches(e.matches);
    };
    var bind = function bind() {
      return matchMedia.current && matchMedia.current.addEventListener('change', handleChange);
    };
    var unbind = function unbind() {
      return matchMedia.current && matchMedia.current.removeEventListener('change', handleChange) && (matchMedia.current = null);
    };
    React__namespace.useEffect(function () {
      if (when) {
        matchMedia.current = window.matchMedia(query);
        setMatches(matchMedia.current.matches);
        bind();
      }
      return unbind;
    }, [query, when]);
    return matches;
  };
  /* eslint-enable */

  /* eslint-disable */

  /**
   * Custom hook to run a mount effect only once.
   * @param {*} fn the callback function
   * @returns the hook
   */
  var useMountEffect = function useMountEffect(fn) {
    var mounted = React__namespace.useRef(false);
    return React__namespace.useEffect(function () {
      if (!mounted.current) {
        mounted.current = true;
        return fn && fn();
      }
    }, []);
  };
  /* eslint-enable */

  function ownKeys$1P(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1P(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1P(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1P(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var useMouse = function useMouse() {
    var _React$useState = React__namespace.useState({
        x: 0,
        y: 0
      }),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      position = _React$useState2[0],
      setPosition = _React$useState2[1];
    var ref = React__namespace.useRef(null);
    var handleMouseMove = React__namespace.useCallback(function (event) {
      var x, y;
      if (ref.current) {
        var rect = event.currentTarget.getBoundingClientRect();
        x = event.pageX - rect.left - (window.pageXOffset || window.scrollX);
        y = event.pageY - rect.top - (window.pageYOffset || window.scrollY);
      } else {
        x = event.clientX;
        y = event.clientY;
      }
      setPosition({
        x: Math.max(0, Math.round(x)),
        y: Math.max(0, Math.round(y))
      });
    }, []);
    var _useEventListener = useEventListener({
        target: ref,
        type: 'mousemove',
        listener: handleMouseMove
      }),
      _useEventListener2 = _slicedToArray(_useEventListener, 2),
      bindMouseMoveEventListener = _useEventListener2[0],
      unbindMouseMoveEventListener = _useEventListener2[1];
    var _useEventListener3 = useEventListener({
        type: 'mousemove',
        listener: handleMouseMove
      }),
      _useEventListener4 = _slicedToArray(_useEventListener3, 2),
      bindDocumentMoveEventListener = _useEventListener4[0],
      unbindDocumentMoveEventListener = _useEventListener4[1];
    var reset = function reset() {
      return setPosition({
        x: 0,
        y: 0
      });
    };
    React__namespace.useEffect(function () {
      bindMouseMoveEventListener();
      if (!ref.current) {
        bindDocumentMoveEventListener();
      }
      return function () {
        unbindMouseMoveEventListener();

        // eslint-disable-next-line react-hooks/exhaustive-deps
        if (!ref.current) {
          unbindDocumentMoveEventListener();
        }
      };
    }, [bindDocumentMoveEventListener, bindMouseMoveEventListener, unbindDocumentMoveEventListener, unbindMouseMoveEventListener]);
    return _objectSpread$1P(_objectSpread$1P({
      ref: ref
    }, position), {}, {
      reset: reset
    });
  };

  function ownKeys$1O(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1O(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1O(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1O(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  function useMove(_ref) {
    var _ref$mode = _ref.mode,
      mode = _ref$mode === void 0 ? 'both' : _ref$mode,
      _ref$initialValue = _ref.initialValue,
      initialValue = _ref$initialValue === void 0 ? {
        x: 0,
        y: 0
      } : _ref$initialValue;
    var _React$useState = React__namespace.useState(initialValue),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      positions = _React$useState2[0],
      setPositions = _React$useState2[1];
    var _React$useState3 = React__namespace.useState(false),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      active = _React$useState4[0],
      setActive = _React$useState4[1];
    var isMounted = React__namespace.useRef(false);
    var isSliding = React__namespace.useRef(false);
    var ref = React__namespace.useRef(null);
    var onMouseMove = function onMouseMove(event) {
      return updateMousePosition({
        x: event.clientX,
        y: event.clientY
      });
    };
    var handlePositionChange = function handlePositionChange(_ref2) {
      var clampedX = _ref2.clampedX,
        clampedY = _ref2.clampedY;
      if (mode === 'vertical') {
        setPositions({
          y: 1 - clampedY
        });
      } else if (mode === 'horizontal') {
        setPositions({
          x: clampedX
        });
      } else if (mode === 'both') {
        setPositions({
          x: clampedX,
          y: clampedY
        });
      }
    };
    var onMouseDown = function onMouseDown(event) {
      startScrubbing();
      event.preventDefault();
      onMouseMove(event);
    };
    var stopScrubbing = function stopScrubbing() {
      if (isSliding.current && isMounted.current) {
        isSliding.current = false;
        setActive(false);
        unbindListeners();
      }
    };
    var onTouchMove = function onTouchMove(event) {
      if (event.cancelable) {
        event.preventDefault();
      }
      updateMousePosition({
        x: event.changedTouches[0].clientX,
        y: event.changedTouches[0].clientY
      });
    };
    var onTouchStart = function onTouchStart(event) {
      if (event.cancelable) {
        event.preventDefault();
      }
      startScrubbing();
      onTouchMove(event);
    };
    var _useEventListener = useEventListener({
        type: 'mousemove',
        listener: onMouseMove
      }),
      _useEventListener2 = _slicedToArray(_useEventListener, 2),
      bindDocumentMouseMoveListener = _useEventListener2[0],
      unbindDocumentMouseMoveListener = _useEventListener2[1];
    var _useEventListener3 = useEventListener({
        type: 'mouseup',
        listener: stopScrubbing
      }),
      _useEventListener4 = _slicedToArray(_useEventListener3, 2),
      bindDocumentMouseUpListener = _useEventListener4[0],
      unbindDocumentMouseUpListener = _useEventListener4[1];
    var _useEventListener5 = useEventListener({
        type: 'touchmove',
        listener: onTouchMove
      }),
      _useEventListener6 = _slicedToArray(_useEventListener5, 2),
      bindDocumentTouchMoveListener = _useEventListener6[0],
      unbindDocumentTouchMoveListener = _useEventListener6[1];
    var _useEventListener7 = useEventListener({
        type: 'touchend',
        listener: stopScrubbing
      }),
      _useEventListener8 = _slicedToArray(_useEventListener7, 2),
      bindDocumentTouchEndListener = _useEventListener8[0],
      unbindDocumentTouchEndListener = _useEventListener8[1];
    var _useEventListener9 = useEventListener({
        target: ref,
        type: 'mousedown',
        listener: onMouseDown
      }),
      _useEventListener10 = _slicedToArray(_useEventListener9, 2),
      bindMouseDownListener = _useEventListener10[0],
      unbindMouseDownListener = _useEventListener10[1];
    var _useEventListener11 = useEventListener({
        target: ref,
        type: 'touchstart',
        listener: onTouchStart,
        options: {
          passive: false
        }
      }),
      _useEventListener12 = _slicedToArray(_useEventListener11, 2),
      bindTouchStartListener = _useEventListener12[0],
      unbindTouchStartListener = _useEventListener12[1];
    var clamp = function clamp(value, min, max) {
      return Math.min(Math.max(value, min), max);
    };
    var clampPositions = function clampPositions(_ref3) {
      var x = _ref3.x,
        y = _ref3.y;
      return {
        clampedX: clamp(x, 0, 1),
        clampedY: clamp(y, 0, 1)
      };
    };
    var bindListeners = function bindListeners() {
      bindDocumentMouseMoveListener();
      bindDocumentMouseUpListener();
      bindDocumentTouchMoveListener();
      bindDocumentTouchEndListener();
    };
    var unbindListeners = function unbindListeners() {
      unbindDocumentMouseMoveListener();
      unbindDocumentMouseUpListener();
      unbindDocumentTouchMoveListener();
      unbindDocumentTouchEndListener();
    };
    var reset = function reset() {
      setPositions(initialValue);
    };
    React__namespace.useEffect(function () {
      isMounted.current = true;
    }, []);
    var startScrubbing = function startScrubbing() {
      if (!isSliding.current && isMounted.current) {
        isSliding.current = true;
        setActive(true);
        bindListeners();
      }
    };
    var updateMousePosition = function updateMousePosition(_ref4) {
      var x = _ref4.x,
        y = _ref4.y;
      if (isSliding.current) {
        var rect = ref.current.getBoundingClientRect();
        var _clampPositions = clampPositions({
            x: (x - rect.left) / rect.width,
            y: (y - rect.top) / rect.height
          }),
          clampedX = _clampPositions.clampedX,
          clampedY = _clampPositions.clampedY;
        handlePositionChange({
          clampedX: clampedX,
          clampedY: clampedY
        });
      }
    };
    React__namespace.useEffect(function () {
      if (ref.current) {
        bindMouseDownListener();
        bindTouchStartListener();
      }
      return function () {
        if (ref.current) {
          unbindMouseDownListener();
          unbindTouchStartListener();
        }
      };
    }, [bindMouseDownListener, bindTouchStartListener, positions, unbindMouseDownListener, unbindTouchStartListener]);
    return _objectSpread$1O(_objectSpread$1O({
      ref: ref
    }, positions), {}, {
      active: active,
      reset: reset
    });
  }

  /* eslint-disable */
  var useOverlayScrollListener = function useOverlayScrollListener(_ref) {
    var target = _ref.target,
      listener = _ref.listener,
      options = _ref.options,
      _ref$when = _ref.when,
      when = _ref$when === void 0 ? true : _ref$when;
    var targetRef = React__namespace.useRef(null);
    var listenerRef = React__namespace.useRef(null);
    var scrollableParents = React__namespace.useRef([]);
    var prevOptions = usePrevious(options);
    var context = React__namespace.useContext(PrimeReactContext);
    var bind = function bind() {
      var bindOptions = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      if (ObjectUtils.isNotEmpty(bindOptions.target)) {
        unbind();
        (bindOptions.when || when) && (targetRef.current = DomHandler.getTargetElement(bindOptions.target));
      }
      if (!listenerRef.current && targetRef.current) {
        var hideOnScroll = context ? context.hideOverlaysOnDocumentScrolling : PrimeReact.hideOverlaysOnDocumentScrolling;
        var nodes = scrollableParents.current = DomHandler.getScrollableParents(targetRef.current, hideOnScroll);
        listenerRef.current = function (event) {
          return listener && listener(event);
        };
        nodes.forEach(function (node) {
          return node.addEventListener('scroll', listenerRef.current, options);
        });
      }
    };
    var unbind = function unbind() {
      if (listenerRef.current) {
        var nodes = scrollableParents.current;
        nodes.forEach(function (node) {
          return node.removeEventListener('scroll', listenerRef.current, options);
        });
        listenerRef.current = null;
      }
    };
    React__namespace.useEffect(function () {
      if (when) {
        targetRef.current = DomHandler.getTargetElement(target);
      } else {
        unbind();
        targetRef.current = null;
      }
    }, [target, when]);
    React__namespace.useEffect(function () {
      if (listenerRef.current && (listenerRef.current !== listener || prevOptions !== options)) {
        unbind();
        when && bind();
      }
    }, [listener, options]);
    useUnmountEffect(function () {
      unbind();
    });
    return [bind, unbind];
  };
  /* eslint-enable */

  var useResizeListener = function useResizeListener(_ref) {
    var listener = _ref.listener,
      _ref$when = _ref.when,
      when = _ref$when === void 0 ? true : _ref$when;
    return useEventListener({
      target: 'window',
      type: 'resize',
      listener: listener,
      when: when
    });
  };

  var useOverlayListener = function useOverlayListener(_ref) {
    var target = _ref.target,
      overlay = _ref.overlay,
      _listener = _ref.listener,
      _ref$when = _ref.when,
      when = _ref$when === void 0 ? true : _ref$when;
    var targetRef = React__namespace.useRef(null);
    var overlayRef = React__namespace.useRef(null);

    /**
     * The parameters of the 'listener' method in the following event handlers;
     * @param {Event} event A click event of the document.
     * @param {string} options.type The custom type to detect event.
     * @param {boolean} options.valid It is controlled by PrimeReact. It is determined whether it is valid or not according to some custom validation.
     */
    var _useEventListener = useEventListener({
        target: 'window',
        type: 'click',
        listener: function listener(event) {
          _listener && _listener(event, {
            type: 'outside',
            valid: event.which !== 3 && isOutsideClicked(event)
          });
        }
      }),
      _useEventListener2 = _slicedToArray(_useEventListener, 2),
      bindDocumentClickListener = _useEventListener2[0],
      unbindDocumentClickListener = _useEventListener2[1];
    var _useResizeListener = useResizeListener({
        target: 'window',
        listener: function listener(event) {
          _listener && _listener(event, {
            type: 'resize',
            valid: !DomHandler.isTouchDevice()
          });
        }
      }),
      _useResizeListener2 = _slicedToArray(_useResizeListener, 2),
      bindWindowResizeListener = _useResizeListener2[0],
      unbindWindowResizeListener = _useResizeListener2[1];
    var _useEventListener3 = useEventListener({
        target: 'window',
        type: 'orientationchange',
        listener: function listener(event) {
          _listener && _listener(event, {
            type: 'orientationchange',
            valid: true
          });
        }
      }),
      _useEventListener4 = _slicedToArray(_useEventListener3, 2),
      bindWindowOrientationChangeListener = _useEventListener4[0],
      unbindWindowOrientationChangeListener = _useEventListener4[1];
    var _useOverlayScrollList = useOverlayScrollListener({
        target: target,
        listener: function listener(event) {
          _listener && _listener(event, {
            type: 'scroll',
            valid: true
          });
        }
      }),
      _useOverlayScrollList2 = _slicedToArray(_useOverlayScrollList, 2),
      bindOverlayScrollListener = _useOverlayScrollList2[0],
      unbindOverlayScrollListener = _useOverlayScrollList2[1];
    var isOutsideClicked = function isOutsideClicked(event) {
      return targetRef.current && !(targetRef.current.isSameNode(event.target) || targetRef.current.contains(event.target) || overlayRef.current && overlayRef.current.contains(event.target));
    };
    var bind = function bind() {
      bindDocumentClickListener();
      bindWindowResizeListener();
      bindWindowOrientationChangeListener();
      bindOverlayScrollListener();
    };
    var unbind = function unbind() {
      unbindDocumentClickListener();
      unbindWindowResizeListener();
      unbindWindowOrientationChangeListener();
      unbindOverlayScrollListener();
    };
    React__namespace.useEffect(function () {
      if (when) {
        targetRef.current = DomHandler.getTargetElement(target);
        overlayRef.current = DomHandler.getTargetElement(overlay);
      } else {
        unbind();
        targetRef.current = overlayRef.current = null;
      }
    }, [target, overlay, when]);
    React__namespace.useEffect(function () {
      unbind();
    }, [when]);
    useUnmountEffect(function () {
      unbind();
    });
    return [bind, unbind];
  };
  /* eslint-enable */

  /**
   * Hook to wrap around useState that stores the value in the browser local/session storage.
   *
   * @param {any} initialValue the initial value to store
   * @param {string} key the key to store the value in local/session storage
   * @param {string} storage either 'local' or 'session' for what type of storage
   * @returns a stateful value, and a function to update it.
   */
  var useStorage = function useStorage(initialValue, key) {
    var storage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'local';
    // Since the local storage API isn't available in server-rendering environments,
    // we check that typeof window !== 'undefined' to make SSR and SSG work properly.
    var storageAvailable = typeof window !== 'undefined';

    // subscribe to window storage event so changes in one tab to a stored value
    // are properly reflected in all tabs
    var _useEventListener = useEventListener({
        target: 'window',
        type: 'storage',
        listener: function listener(event) {
          var area = storage === 'local' ? window.localStorage : window.sessionStorage;
          if (event.storageArea === area && event.key === key) {
            var newValue = event.newValue ? JSON.parse(event.newValue) : undefined;
            setStoredValue(newValue);
          }
        }
      }),
      _useEventListener2 = _slicedToArray(_useEventListener, 2),
      bindWindowStorageListener = _useEventListener2[0],
      unbindWindowStorageListener = _useEventListener2[1];
    var _React$useState = React__namespace.useState(initialValue),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      storedValue = _React$useState2[0],
      setStoredValue = _React$useState2[1];
    var setValue = function setValue(value) {
      try {
        // Allow value to be a function so we have same API as useState
        var valueToStore = value instanceof Function ? value(storedValue) : value;
        setStoredValue(valueToStore);
        if (storageAvailable) {
          var serializedValue = JSON.stringify(valueToStore);
          storage === 'local' ? window.localStorage.setItem(key, serializedValue) : window.sessionStorage.setItem(key, serializedValue);
        }
      } catch (error) {
        throw new Error("PrimeReact useStorage: Failed to serialize the value at key: ".concat(key));
      }
    };
    React__namespace.useEffect(function () {
      if (!storageAvailable) {
        setStoredValue(initialValue);
      }
      try {
        var item = storage === 'local' ? window.localStorage.getItem(key) : window.sessionStorage.getItem(key);
        setStoredValue(item ? JSON.parse(item) : initialValue);
      } catch (error) {
        // If error also return initialValue
        setStoredValue(initialValue);
      }
      bindWindowStorageListener();
      return function () {
        return unbindWindowStorageListener();
      };
    }, []);
    return [storedValue, setValue];
  };

  /**
   * Hook to wrap around useState that stores the value in the browser local storage.
   *
   * @param {any} initialValue the initial value to store
   * @param {string} key the key to store the value in local storage
   * @returns a stateful value, and a function to update it.
   */
  var useLocalStorage = function useLocalStorage(initialValue, key) {
    return useStorage(initialValue, key, 'local');
  };

  /**
   * Hook to wrap around useState that stores the value in the browser session storage.
   *
   * @param {any} initialValue the initial value to store
   * @param {string} key the key to store the value in session storage
   * @returns a stateful value, and a function to update it.
   */
  var useSessionStorage = function useSessionStorage(initialValue, key) {
    return useStorage(initialValue, key, 'session');
  };
  /* eslint-enable */

  var _id = 0;
  var useStyle = function useStyle(css) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var _useState = React.useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      isLoaded = _useState2[0],
      setIsLoaded = _useState2[1];
    var styleRef = React.useRef(null);
    var context = React.useContext(PrimeReactContext);
    var defaultDocument = DomHandler.isClient() ? window.document : undefined;
    var _options$document = options.document,
      document = _options$document === void 0 ? defaultDocument : _options$document,
      _options$manual = options.manual,
      manual = _options$manual === void 0 ? false : _options$manual,
      _options$name = options.name,
      name = _options$name === void 0 ? "style_".concat(++_id) : _options$name,
      _options$id = options.id,
      id = _options$id === void 0 ? undefined : _options$id,
      _options$media = options.media,
      media = _options$media === void 0 ? undefined : _options$media;
    var update = function update(newCSS) {
      isLoaded && css !== newCSS && (styleRef.current.textContent = newCSS);
    };
    var load = function load() {
      if (!document || isLoaded) return;
      var styleContainer = (context === null || context === void 0 ? void 0 : context.styleContainer) || document.head;
      styleRef.current = styleContainer.querySelector("style[data-primereact-style-id=\"".concat(name, "\"]")) || document.getElementById(id) || document.createElement('style');
      if (!styleRef.current.isConnected) {
        styleRef.current.type = 'text/css';
        id && (styleRef.current.id = id);
        media && (styleRef.current.media = media);
        DomHandler.addNonce(styleRef.current, context && context.nonce || PrimeReact.nonce);
        styleContainer.appendChild(styleRef.current);
        name && styleRef.current.setAttribute('data-primereact-style-id', name);
      }
      styleRef.current.textContent = css;
      setIsLoaded(true);
    };
    var unload = function unload() {
      if (!document || !styleRef.current) return;
      DomHandler.removeInlineStyle(styleRef.current);
      setIsLoaded(false);
    };
    React.useEffect(function () {
      if (!manual) load();

      // return () => {if (!manual) unload()}; /* @todo */
      // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [manual]);
    return {
      id: id,
      name: name,
      update: update,
      unload: unload,
      load: load,
      isLoaded: isLoaded
    };
  };

  /* eslint-disable */
  var useTimeout = function useTimeout(fn) {
    var delay = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
    var when = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
    var timeout = React__namespace.useRef(null);
    var savedCallback = React__namespace.useRef(null);
    var clear = React__namespace.useCallback(function () {
      return clearTimeout(timeout.current);
    }, [timeout.current]);
    React__namespace.useEffect(function () {
      savedCallback.current = fn;
    });
    React__namespace.useEffect(function () {
      function callback() {
        savedCallback.current();
      }
      if (when) {
        timeout.current = setTimeout(callback, delay);
        return clear;
      } else {
        clear();
      }
    }, [delay, when]);
    useUnmountEffect(function () {
      clear();
    });
    return [clear];
  };
  /* eslint-enable */

  /* eslint-disable */
  var useUpdateEffect = function useUpdateEffect(fn, deps) {
    var mounted = React__namespace.useRef(false);
    return React__namespace.useEffect(function () {
      if (!mounted.current) {
        mounted.current = true;
        return;
      }
      return fn && fn();
    }, deps);
  };
  /* eslint-enable */

  function ownKeys$1N(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1N(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1N(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1N(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var baseStyle = "\n.p-hidden-accessible {\n    border: 0;\n    clip: rect(0 0 0 0);\n    height: 1px;\n    margin: -1px;\n    overflow: hidden;\n    padding: 0;\n    position: absolute;\n    width: 1px;\n}\n\n.p-hidden-accessible input,\n.p-hidden-accessible select {\n    transform: scale(0);\n}\n\n.p-overflow-hidden {\n    overflow: hidden;\n    padding-right: var(--scrollbar-width);\n}\n";
  var buttonStyles = "\n.p-button {\n    margin: 0;\n    display: inline-flex;\n    cursor: pointer;\n    user-select: none;\n    align-items: center;\n    vertical-align: bottom;\n    text-align: center;\n    overflow: hidden;\n    position: relative;\n}\n\n.p-button-label {\n    flex: 1 1 auto;\n}\n\n.p-button-icon-right {\n    order: 1;\n}\n\n.p-button:disabled {\n    cursor: default;\n}\n\n.p-button-icon-only {\n    justify-content: center;\n}\n\n.p-button-icon-only .p-button-label {\n    visibility: hidden;\n    width: 0;\n    flex: 0 0 auto;\n}\n\n.p-button-vertical {\n    flex-direction: column;\n}\n\n.p-button-icon-bottom {\n    order: 2;\n}\n\n.p-buttonset .p-button {\n    margin: 0;\n}\n\n.p-buttonset .p-button:not(:last-child) {\n    border-right: 0 none;\n}\n\n.p-buttonset .p-button:not(:first-of-type):not(:last-of-type) {\n    border-radius: 0;\n}\n\n.p-buttonset .p-button:first-of-type {\n    border-top-right-radius: 0;\n    border-bottom-right-radius: 0;\n}\n\n.p-buttonset .p-button:last-of-type {\n    border-top-left-radius: 0;\n    border-bottom-left-radius: 0;\n}\n\n.p-buttonset .p-button:focus {\n    position: relative;\n    z-index: 1;\n}\n";
  var checkboxStyles = "\n.p-checkbox {\n    display: inline-flex;\n    cursor: pointer;\n    user-select: none;\n    vertical-align: bottom;\n    position: relative;\n}\n\n.p-checkbox.p-checkbox-disabled {\n    cursor: auto;\n}\n\n.p-checkbox-box {\n    display: flex;\n    justify-content: center;\n    align-items: center;\n}\n";
  var inputTextStyles = "\n.p-inputtext {\n    margin: 0;\n}\n\n.p-fluid .p-inputtext {\n    width: 100%;\n}\n\n/* InputGroup */\n.p-inputgroup {\n    display: flex;\n    align-items: stretch;\n    width: 100%;\n}\n\n.p-inputgroup-addon {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n}\n\n.p-inputgroup .p-float-label {\n    display: flex;\n    align-items: stretch;\n    width: 100%;\n}\n\n.p-inputgroup .p-inputtext,\n.p-fluid .p-inputgroup .p-inputtext,\n.p-inputgroup .p-inputwrapper,\n.p-fluid .p-inputgroup .p-input {\n    flex: 1 1 auto;\n    width: 1%;\n}\n\n/* Floating Label */\n.p-float-label {\n    display: block;\n    position: relative;\n}\n\n.p-float-label label {\n    position: absolute;\n    pointer-events: none;\n    top: 50%;\n    margin-top: -0.5rem;\n    transition-property: all;\n    transition-timing-function: ease;\n    line-height: 1;\n}\n\n.p-float-label textarea ~ label,\n.p-float-label .p-mention ~ label {\n    top: 1rem;\n}\n\n.p-float-label input:focus ~ label,\n.p-float-label input:-webkit-autofill ~ label,\n.p-float-label input.p-filled ~ label,\n.p-float-label textarea:focus ~ label,\n.p-float-label textarea.p-filled ~ label,\n.p-float-label .p-inputwrapper-focus ~ label,\n.p-float-label .p-inputwrapper-filled ~ label,\n.p-float-label .p-tooltip-target-wrapper ~ label {\n    top: -0.75rem;\n    font-size: 12px;\n}\n\n.p-float-label .p-placeholder,\n.p-float-label input::placeholder,\n.p-float-label .p-inputtext::placeholder {\n    opacity: 0;\n    transition-property: all;\n    transition-timing-function: ease;\n}\n\n.p-float-label .p-focus .p-placeholder,\n.p-float-label input:focus::placeholder,\n.p-float-label .p-inputtext:focus::placeholder {\n    opacity: 1;\n    transition-property: all;\n    transition-timing-function: ease;\n}\n\n.p-input-icon-left,\n.p-input-icon-right {\n    position: relative;\n    display: inline-block;\n}\n\n.p-input-icon-left > i,\n.p-input-icon-right > i,\n.p-input-icon-left > svg,\n.p-input-icon-right > svg,\n.p-input-icon-left > .p-input-prefix,\n.p-input-icon-right > .p-input-suffix {\n    position: absolute;\n    top: 50%;\n    margin-top: -0.5rem;\n}\n\n.p-fluid .p-input-icon-left,\n.p-fluid .p-input-icon-right {\n    display: block;\n    width: 100%;\n}\n";
  var radioButtonStyles = "\n.p-radiobutton {\n    display: inline-flex;\n    cursor: pointer;\n    user-select: none;\n    vertical-align: bottom;\n}\n\n.p-radiobutton-box {\n    display: flex;\n    justify-content: center;\n    align-items: center;\n}\n\n.p-radiobutton-icon {\n    -webkit-backface-visibility: hidden;\n    backface-visibility: hidden;\n    transform: translateZ(0) scale(.1);\n    border-radius: 50%;\n    visibility: hidden;\n}\n\n.p-radiobutton-box.p-highlight .p-radiobutton-icon {\n    transform: translateZ(0) scale(1.0, 1.0);\n    visibility: visible;\n}\n\n";
  var iconStyles = "\n.p-icon {\n    display: inline-block;\n}\n\n.p-icon-spin {\n    -webkit-animation: p-icon-spin 2s infinite linear;\n    animation: p-icon-spin 2s infinite linear;\n}\n\nsvg.p-icon {\n    pointer-events: auto;\n}\n\nsvg.p-icon g,\n.p-disabled svg.p-icon {\n    pointer-events: none;\n}\n\n@-webkit-keyframes p-icon-spin {\n    0% {\n        -webkit-transform: rotate(0deg);\n        transform: rotate(0deg);\n    }\n    100% {\n        -webkit-transform: rotate(359deg);\n        transform: rotate(359deg);\n    }\n}\n\n@keyframes p-icon-spin {\n    0% {\n        -webkit-transform: rotate(0deg);\n        transform: rotate(0deg);\n    }\n    100% {\n        -webkit-transform: rotate(359deg);\n        transform: rotate(359deg);\n    }\n}\n";
  var commonStyle = "\n@layer primereact {\n    .p-component, .p-component * {\n        box-sizing: border-box;\n    }\n\n    .p-hidden {\n        display: none;\n    }\n\n    .p-hidden-space {\n        visibility: hidden;\n    }\n\n    .p-reset {\n        margin: 0;\n        padding: 0;\n        border: 0;\n        outline: 0;\n        text-decoration: none;\n        font-size: 100%;\n        list-style: none;\n    }\n\n    .p-disabled, .p-disabled * {\n        cursor: default;\n        pointer-events: none;\n        user-select: none;\n    }\n\n    .p-component-overlay {\n        position: fixed;\n        top: 0;\n        left: 0;\n        width: 100%;\n        height: 100%;\n    }\n\n    .p-unselectable-text {\n        user-select: none;\n    }\n\n    .p-scrollbar-measure {\n        width: 100px;\n        height: 100px;\n        overflow: scroll;\n        position: absolute;\n        top: -9999px;\n    }\n\n    @-webkit-keyframes p-fadein {\n      0%   { opacity: 0; }\n      100% { opacity: 1; }\n    }\n    @keyframes p-fadein {\n      0%   { opacity: 0; }\n      100% { opacity: 1; }\n    }\n\n    .p-link {\n        text-align: left;\n        background-color: transparent;\n        margin: 0;\n        padding: 0;\n        border: none;\n        cursor: pointer;\n        user-select: none;\n    }\n\n    .p-link:disabled {\n        cursor: default;\n    }\n\n    /* Non react overlay animations */\n    .p-connected-overlay {\n        opacity: 0;\n        transform: scaleY(0.8);\n        transition: transform .12s cubic-bezier(0, 0, 0.2, 1), opacity .12s cubic-bezier(0, 0, 0.2, 1);\n    }\n\n    .p-connected-overlay-visible {\n        opacity: 1;\n        transform: scaleY(1);\n    }\n\n    .p-connected-overlay-hidden {\n        opacity: 0;\n        transform: scaleY(1);\n        transition: opacity .1s linear;\n    }\n\n    /* React based overlay animations */\n    .p-connected-overlay-enter {\n        opacity: 0;\n        transform: scaleY(0.8);\n    }\n\n    .p-connected-overlay-enter-active {\n        opacity: 1;\n        transform: scaleY(1);\n        transition: transform .12s cubic-bezier(0, 0, 0.2, 1), opacity .12s cubic-bezier(0, 0, 0.2, 1);\n    }\n\n    .p-connected-overlay-enter-done {\n        transform: none;\n    }\n\n    .p-connected-overlay-exit {\n        opacity: 1;\n    }\n\n    .p-connected-overlay-exit-active {\n        opacity: 0;\n        transition: opacity .1s linear;\n    }\n\n    /* Toggleable Content */\n    .p-toggleable-content-enter {\n        max-height: 0;\n    }\n\n    .p-toggleable-content-enter-active {\n        overflow: hidden;\n        max-height: 1000px;\n        transition: max-height 1s ease-in-out;\n    }\n\n    .p-toggleable-content-enter-done {\n        transform: none;\n    }\n\n    .p-toggleable-content-exit {\n        max-height: 1000px;\n    }\n\n    .p-toggleable-content-exit-active {\n        overflow: hidden;\n        max-height: 0;\n        transition: max-height 0.45s cubic-bezier(0, 1, 0, 1);\n    }\n\n    .p-sr-only {\n        border: 0;\n        clip: rect(1px, 1px, 1px, 1px);\n        clip-path: inset(50%);\n        height: 1px;\n        margin: -1px;\n        overflow: hidden;\n        padding: 0;\n        position: absolute;\n        width: 1px;\n        word-wrap: normal;\n    }\n\n    /* @todo Refactor */\n    .p-menu .p-menuitem-link {\n        cursor: pointer;\n        display: flex;\n        align-items: center;\n        text-decoration: none;\n        overflow: hidden;\n        position: relative;\n    }\n\n    ".concat(buttonStyles, "\n    ").concat(checkboxStyles, "\n    ").concat(inputTextStyles, "\n    ").concat(radioButtonStyles, "\n    ").concat(iconStyles, "\n}\n");
  var ComponentBase = {
    cProps: undefined,
    cParams: undefined,
    cName: undefined,
    defaultProps: {
      pt: undefined,
      ptOptions: undefined,
      unstyled: false
    },
    context: {},
    globalCSS: undefined,
    classes: {},
    styles: '',
    extend: function extend() {
      var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var css = props.css;
      var defaultProps = _objectSpread$1N(_objectSpread$1N({}, props.defaultProps), ComponentBase.defaultProps);
      var inlineStyles = {};
      var getProps = function getProps(props) {
        var context = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        ComponentBase.context = context;
        ComponentBase.cProps = props;
        return ObjectUtils.getMergedProps(props, defaultProps);
      };
      var getOtherProps = function getOtherProps(props) {
        return ObjectUtils.getDiffProps(props, defaultProps);
      };
      var getPTValue = function getPTValue() {
        var obj = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        var key = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
        var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
        var searchInDefaultPT = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : true;
        // obj either is the passthrough options or has a .pt property.
        if (obj.hasOwnProperty('pt') && obj.pt !== undefined) {
          obj = obj.pt;
        }
        var originalkey = key;
        var isNestedParam = /./g.test(originalkey) && !!params[originalkey.split('.')[0]];
        var fkey = isNestedParam ? ObjectUtils.toFlatCase(originalkey.split('.')[1]) : ObjectUtils.toFlatCase(originalkey);
        var hostName = params.hostName && ObjectUtils.toFlatCase(params.hostName);
        var componentName = hostName || params.props && params.props.__TYPE && ObjectUtils.toFlatCase(params.props.__TYPE) || '';
        var isTransition = fkey === 'transition';
        var datasetPrefix = 'data-pc-';
        var getHostInstance = function getHostInstance(params) {
          return params !== null && params !== void 0 && params.props ? params.hostName ? params.props.__TYPE === params.hostName ? params.props : getHostInstance(params.parent) : params.parent : undefined;
        };
        var getPropValue = function getPropValue(name) {
          var _params$props, _getHostInstance;
          return ((_params$props = params.props) === null || _params$props === void 0 ? void 0 : _params$props[name]) || ((_getHostInstance = getHostInstance(params)) === null || _getHostInstance === void 0 ? void 0 : _getHostInstance[name]);
        };
        ComponentBase.cParams = params;
        ComponentBase.cName = componentName;
        var _ref = getPropValue('ptOptions') || ComponentBase.context.ptOptions || {},
          _ref$mergeSections = _ref.mergeSections,
          mergeSections = _ref$mergeSections === void 0 ? true : _ref$mergeSections,
          _ref$mergeProps = _ref.mergeProps,
          useMergeProps = _ref$mergeProps === void 0 ? false : _ref$mergeProps;
        var getPTClassValue = function getPTClassValue() {
          var value = getOptionValue.apply(void 0, arguments);
          if (Array.isArray(value)) return {
            className: classNames.apply(void 0, _toConsumableArray(value))
          };
          if (ObjectUtils.isString(value)) return {
            className: value
          };
          if (value !== null && value !== void 0 && value.hasOwnProperty('className') && Array.isArray(value.className)) {
            return {
              className: classNames.apply(void 0, _toConsumableArray(value.className))
            };
          }
          return value;
        };
        var globalPT = searchInDefaultPT ? isNestedParam ? _useGlobalPT(getPTClassValue, originalkey, params) : _useDefaultPT(getPTClassValue, originalkey, params) : undefined;
        var self = isNestedParam ? undefined : _usePT(_getPT(obj, componentName), getPTClassValue, originalkey, params);
        var datasetProps = !isTransition && _objectSpread$1N(_objectSpread$1N({}, fkey === 'root' && _defineProperty({}, "".concat(datasetPrefix, "name"), params.props && params.props.__parentMetadata ? ObjectUtils.toFlatCase(params.props.__TYPE) : componentName)), {}, _defineProperty({}, "".concat(datasetPrefix, "section"), fkey));
        return mergeSections || !mergeSections && self ? useMergeProps ? mergeProps(globalPT, self, Object.keys(datasetProps).length ? datasetProps : {}) : _objectSpread$1N(_objectSpread$1N(_objectSpread$1N({}, globalPT), self), Object.keys(datasetProps).length ? datasetProps : {}) : _objectSpread$1N(_objectSpread$1N({}, self), Object.keys(datasetProps).length ? datasetProps : {});
      };
      var setMetaData = function setMetaData() {
        var metadata = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        var props = metadata.props,
          state = metadata.state;
        var ptm = function ptm() {
          var key = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
          var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
          return getPTValue((props || {}).pt, key, _objectSpread$1N(_objectSpread$1N({}, metadata), params));
        };
        var ptmo = function ptmo() {
          var obj = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
          var key = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
          var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
          return getPTValue(obj, key, params, false);
        };
        var isUnstyled = function isUnstyled() {
          return ComponentBase.context.unstyled || PrimeReact.unstyled || props.unstyled;
        };
        var cx = function cx() {
          var key = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
          var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
          return !isUnstyled() ? getOptionValue(css && css.classes, key, _objectSpread$1N({
            props: props,
            state: state
          }, params)) : undefined;
        };
        var sx = function sx() {
          var key = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
          var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
          var when = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
          if (when) {
            var self = getOptionValue(css && css.inlineStyles, key, _objectSpread$1N({
              props: props,
              state: state
            }, params));
            var base = getOptionValue(inlineStyles, key, _objectSpread$1N({
              props: props,
              state: state
            }, params));
            return mergeProps(base, self);
          }
          return undefined;
        };
        return {
          ptm: ptm,
          ptmo: ptmo,
          sx: sx,
          cx: cx,
          isUnstyled: isUnstyled
        };
      };
      return _objectSpread$1N(_objectSpread$1N({
        getProps: getProps,
        getOtherProps: getOtherProps,
        setMetaData: setMetaData
      }, props), {}, {
        defaultProps: defaultProps
      });
    }
  };
  var getOptionValue = function getOptionValue(obj) {
    var key = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
    var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var fKeys = String(ObjectUtils.toFlatCase(key)).split('.');
    var fKey = fKeys.shift();
    var matchedPTOption = ObjectUtils.isNotEmpty(obj) ? Object.keys(obj).find(function (k) {
      return ObjectUtils.toFlatCase(k) === fKey;
    }) : '';
    return fKey ? ObjectUtils.isObject(obj) ? getOptionValue(ObjectUtils.getItemValue(obj[matchedPTOption], params), fKeys.join('.'), params) : undefined : ObjectUtils.getItemValue(obj, params);
  };
  var _getPT = function _getPT(pt) {
    var key = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
    var callback = arguments.length > 2 ? arguments[2] : undefined;
    var _usept = pt === null || pt === void 0 ? void 0 : pt['_usept'];
    var getValue = function getValue(value) {
      var _ref3;
      var checkSameKey = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var _value = callback ? callback(value) : value;
      var _key = ObjectUtils.toFlatCase(key);
      return (_ref3 = checkSameKey ? _key !== ComponentBase.cName ? _value === null || _value === void 0 ? void 0 : _value[_key] : undefined : _value === null || _value === void 0 ? void 0 : _value[_key]) !== null && _ref3 !== void 0 ? _ref3 : _value;
    };
    return ObjectUtils.isNotEmpty(_usept) ? {
      _usept: _usept,
      originalValue: getValue(pt.originalValue),
      value: getValue(pt.value)
    } : getValue(pt, true);
  };
  var _usePT = function _usePT(pt, callback, key, params) {
    var fn = function fn(value) {
      return callback(value, key, params);
    };
    if (pt !== null && pt !== void 0 && pt.hasOwnProperty('_usept')) {
      var _ref4 = pt['_usept'] || ComponentBase.context.ptOptions || {},
        _ref4$mergeSections = _ref4.mergeSections,
        mergeSections = _ref4$mergeSections === void 0 ? true : _ref4$mergeSections,
        _ref4$mergeProps = _ref4.mergeProps,
        useMergeProps = _ref4$mergeProps === void 0 ? false : _ref4$mergeProps;
      var originalValue = fn(pt.originalValue);
      var value = fn(pt.value);
      if (originalValue === undefined && value === undefined) return undefined;else if (ObjectUtils.isString(value)) return value;else if (ObjectUtils.isString(originalValue)) return originalValue;
      return mergeSections || !mergeSections && value ? useMergeProps ? mergeProps(originalValue, value) : _objectSpread$1N(_objectSpread$1N({}, originalValue), value) : value;
    }
    return fn(pt);
  };
  var getGlobalPT = function getGlobalPT() {
    return _getPT(ComponentBase.context.pt || PrimeReact.pt, undefined, function (value) {
      return ObjectUtils.getItemValue(value, ComponentBase.cParams);
    });
  };
  var getDefaultPT = function getDefaultPT() {
    return _getPT(ComponentBase.context.pt || PrimeReact.pt, undefined, function (value) {
      return getOptionValue(value, ComponentBase.cName, ComponentBase.cParams) || ObjectUtils.getItemValue(value, ComponentBase.cParams);
    });
  };
  var _useGlobalPT = function _useGlobalPT(callback, key, params) {
    return _usePT(getGlobalPT(), callback, key, params);
  };
  var _useDefaultPT = function _useDefaultPT(callback, key, params) {
    return _usePT(getDefaultPT(), callback, key, params);
  };
  var useHandleStyle = function useHandleStyle(styles) {
    var config = arguments.length > 2 ? arguments[2] : undefined;
    var name = config.name,
      _config$styled = config.styled,
      styled = _config$styled === void 0 ? false : _config$styled,
      _config$hostName = config.hostName,
      hostName = _config$hostName === void 0 ? '' : _config$hostName;
    var globalCSS = _useGlobalPT(getOptionValue, 'global.css', ComponentBase.cParams);
    var componentName = ObjectUtils.toFlatCase(name);
    var _useStyle = useStyle(baseStyle, {
        name: 'base',
        manual: true
      }),
      loadBaseStyle = _useStyle.load;
    var _useStyle2 = useStyle(commonStyle, {
        name: 'common',
        manual: true
      }),
      loadCommonStyle = _useStyle2.load;
    var _useStyle3 = useStyle(globalCSS, {
        name: 'global',
        manual: true
      }),
      loadGlobalStyle = _useStyle3.load;
    var _useStyle4 = useStyle(styles, {
        name: name,
        manual: true
      }),
      load = _useStyle4.load;
    var hook = function hook(hookName) {
      if (!hostName) {
        var selfHook = _usePT(_getPT((ComponentBase.cProps || {}).pt, componentName), getOptionValue, "hooks.".concat(hookName));
        var defaultHook = _useDefaultPT(getOptionValue, "hooks.".concat(hookName));
        selfHook === null || selfHook === void 0 || selfHook();
        defaultHook === null || defaultHook === void 0 || defaultHook();
      }
    };
    hook('useMountEffect');
    useMountEffect(function () {
      loadBaseStyle();
      loadGlobalStyle();
      loadCommonStyle();
      if (!styled) load();
    });
    useUpdateEffect(function () {
      hook('useUpdateEffect');
    });
    useUnmountEffect(function () {
      hook('useUnmountEffect');
    });
  };

  var CSSTransitionBase = {
    defaultProps: {
      __TYPE: 'CSSTransition',
      children: undefined
    },
    getProps: function getProps(props) {
      return ObjectUtils.getMergedProps(props, CSSTransitionBase.defaultProps);
    },
    getOtherProps: function getOtherProps(props) {
      return ObjectUtils.getDiffProps(props, CSSTransitionBase.defaultProps);
    }
  };

  function ownKeys$1M(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1M(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1M(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1M(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var CSSTransition = /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var props = CSSTransitionBase.getProps(inProps);
    var context = React__namespace.useContext(PrimeReactContext);
    var disabled = props.disabled || props.options && props.options.disabled || context && !context.cssTransition || !PrimeReact.cssTransition;
    var onEnter = function onEnter(node, isAppearing) {
      props.onEnter && props.onEnter(node, isAppearing); // component
      props.options && props.options.onEnter && props.options.onEnter(node, isAppearing); // user option
    };

    var onEntering = function onEntering(node, isAppearing) {
      props.onEntering && props.onEntering(node, isAppearing); // component
      props.options && props.options.onEntering && props.options.onEntering(node, isAppearing); // user option
    };

    var onEntered = function onEntered(node, isAppearing) {
      props.onEntered && props.onEntered(node, isAppearing); // component
      props.options && props.options.onEntered && props.options.onEntered(node, isAppearing); // user option
    };

    var onExit = function onExit(node) {
      props.onExit && props.onExit(node); // component
      props.options && props.options.onExit && props.options.onExit(node); // user option
    };

    var onExiting = function onExiting(node) {
      props.onExiting && props.onExiting(node); // component
      props.options && props.options.onExiting && props.options.onExiting(node); // user option
    };

    var onExited = function onExited(node) {
      props.onExited && props.onExited(node); // component
      props.options && props.options.onExited && props.options.onExited(node); // user option
    };

    useUpdateEffect(function () {
      if (disabled) {
        // no animation
        var node = ObjectUtils.getRefElement(props.nodeRef);
        if (props["in"]) {
          onEnter(node, true);
          onEntering(node, true);
          onEntered(node, true);
        } else {
          onExit(node);
          onExiting(node);
          onExited(node);
        }
      }
    }, [props["in"]]);
    if (disabled) {
      return props["in"] ? props.children : null;
    } else {
      var immutableProps = {
        nodeRef: props.nodeRef,
        "in": props["in"],
        onEnter: onEnter,
        onEntering: onEntering,
        onEntered: onEntered,
        onExit: onExit,
        onExiting: onExiting,
        onExited: onExited
      };
      var mutableProps = {
        classNames: props.classNames,
        timeout: props.timeout,
        unmountOnExit: props.unmountOnExit
      };
      var mergedProps = _objectSpread$1M(_objectSpread$1M(_objectSpread$1M({}, mutableProps), props.options || {}), immutableProps);
      return /*#__PURE__*/React__namespace.createElement(reactTransitionGroup.CSSTransition, mergedProps, props.children);
    }
  });
  CSSTransition.displayName = 'CSSTransition';

  var IconBase = {
    defaultProps: {
      __TYPE: 'IconBase',
      className: null,
      label: null,
      spin: false
    },
    getProps: function getProps(props) {
      return ObjectUtils.getMergedProps(props, IconBase.defaultProps);
    },
    getOtherProps: function getOtherProps(props) {
      return ObjectUtils.getDiffProps(props, IconBase.defaultProps);
    },
    getPTI: function getPTI(props) {
      var isLabelEmpty = ObjectUtils.isEmpty(props.label);
      var otherProps = IconBase.getOtherProps(props);
      var ptiProps = {
        className: classNames('p-icon', {
          'p-icon-spin': props.spin
        }, props.className),
        role: !isLabelEmpty ? 'img' : undefined,
        'aria-label': !isLabelEmpty ? props.label : undefined,
        'aria-hidden': isLabelEmpty
      };
      return ObjectUtils.getMergedProps(otherProps, ptiProps);
    }
  };

  var ChevronDownIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("path", {
      d: "M7.01744 10.398C6.91269 10.3985 6.8089 10.378 6.71215 10.3379C6.61541 10.2977 6.52766 10.2386 6.45405 10.1641L1.13907 4.84913C1.03306 4.69404 0.985221 4.5065 1.00399 4.31958C1.02276 4.13266 1.10693 3.95838 1.24166 3.82747C1.37639 3.69655 1.55301 3.61742 1.74039 3.60402C1.92777 3.59062 2.11386 3.64382 2.26584 3.75424L7.01744 8.47394L11.769 3.75424C11.9189 3.65709 12.097 3.61306 12.2748 3.62921C12.4527 3.64535 12.6199 3.72073 12.7498 3.84328C12.8797 3.96582 12.9647 4.12842 12.9912 4.30502C13.0177 4.48162 12.9841 4.662 12.8958 4.81724L7.58083 10.1322C7.50996 10.2125 7.42344 10.2775 7.32656 10.3232C7.22968 10.3689 7.12449 10.3944 7.01744 10.398Z",
      fill: "currentColor"
    }));
  }));
  ChevronDownIcon.displayName = 'ChevronDownIcon';

  var ChevronRightIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("path", {
      d: "M4.38708 13C4.28408 13.0005 4.18203 12.9804 4.08691 12.9409C3.99178 12.9014 3.9055 12.8433 3.83313 12.7701C3.68634 12.6231 3.60388 12.4238 3.60388 12.2161C3.60388 12.0084 3.68634 11.8091 3.83313 11.6622L8.50507 6.99022L3.83313 2.31827C3.69467 2.16968 3.61928 1.97313 3.62287 1.77005C3.62645 1.56698 3.70872 1.37322 3.85234 1.22959C3.99596 1.08597 4.18972 1.00371 4.3928 1.00012C4.59588 0.996539 4.79242 1.07192 4.94102 1.21039L10.1669 6.43628C10.3137 6.58325 10.3962 6.78249 10.3962 6.99022C10.3962 7.19795 10.3137 7.39718 10.1669 7.54416L4.94102 12.7701C4.86865 12.8433 4.78237 12.9014 4.68724 12.9409C4.59212 12.9804 4.49007 13.0005 4.38708 13Z",
      fill: "currentColor"
    }));
  }));
  ChevronRightIcon.displayName = 'ChevronRightIcon';

  var classes$1c = {
    root: 'p-accordion p-component',
    tab: {
      root: function root(_ref) {
        var selected = _ref.selected;
        return classNames('p-accordion-tab', {
          'p-accordion-tab-active': selected
        });
      },
      content: 'p-accordion-content',
      header: function header(_ref2) {
        var selected = _ref2.selected,
          getTabProp = _ref2.getTabProp,
          tab = _ref2.tab;
        return classNames('p-accordion-header', {
          'p-highlight': selected,
          'p-disabled': getTabProp(tab, 'disabled')
        });
      },
      headeraction: 'p-accordion-header-link',
      headericon: 'p-accordion-toggle-icon',
      headertitle: 'p-accordion-header-text',
      toggleablecontent: 'p-toggleable-content',
      transition: 'p-toggleable-content'
    }
  };
  var styles$16 = "\n@layer primereact {\n    .p-accordion-header-link {\n        cursor: pointer;\n        display: flex;\n        align-items: center;\n        user-select: none;\n        position: relative;\n        text-decoration: none;\n    }\n    \n    .p-accordion-header-link:focus {\n        z-index: 1;\n    }\n    \n    .p-accordion-header-text {\n        line-height: 1;\n        width: 100%;\n    }\n}\n";
  var AccordionBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'Accordion',
      id: null,
      activeIndex: null,
      className: null,
      style: null,
      multiple: false,
      expandIcon: null,
      collapseIcon: null,
      transitionOptions: null,
      onTabOpen: null,
      onTabClose: null,
      onTabChange: null,
      children: undefined
    },
    css: {
      classes: classes$1c,
      styles: styles$16
    }
  });
  var AccordionTabBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'AccordionTab',
      className: null,
      contentClassName: null,
      contentStyle: null,
      disabled: false,
      header: null,
      headerClassName: null,
      headerStyle: null,
      headerTemplate: null,
      style: null,
      tabIndex: 0,
      children: undefined
    },
    getCProp: function getCProp(tab, name) {
      return ObjectUtils.getComponentProp(tab, name, AccordionTabBase.defaultProps);
    },
    getCProps: function getCProps(tab) {
      return ObjectUtils.getComponentProps(tab, AccordionTabBase.defaultProps);
    },
    getCOtherProps: function getCOtherProps(tab) {
      return ObjectUtils.getComponentDiffProps(tab, AccordionTabBase.defaultProps);
    }
  });

  function ownKeys$1L(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1L(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1L(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1L(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var AccordionTab = function AccordionTab() {};
  var Accordion = /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var context = React__namespace.useContext(PrimeReactContext);
    var props = AccordionBase.getProps(inProps, context);
    var _React$useState = React__namespace.useState(props.id),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      idState = _React$useState2[0],
      setIdState = _React$useState2[1];
    var _React$useState3 = React__namespace.useState(props.activeIndex),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      activeIndexState = _React$useState4[0],
      setActiveIndexState = _React$useState4[1];
    var elementRef = React__namespace.useRef(null);
    var activeIndex = props.onTabChange ? props.activeIndex : activeIndexState;
    var count = React__namespace.Children.count(props.children);
    var metaData = {
      props: props,
      state: {
        id: idState,
        activeIndex: activeIndexState
      }
    };
    var _AccordionBase$setMet = AccordionBase.setMetaData(_objectSpread$1L({}, metaData)),
      ptm = _AccordionBase$setMet.ptm,
      ptmo = _AccordionBase$setMet.ptmo,
      cx = _AccordionBase$setMet.cx;
      _AccordionBase$setMet.sx;
      var isUnstyled = _AccordionBase$setMet.isUnstyled;
    useHandleStyle(AccordionBase.css.styles, isUnstyled, {
      name: 'accordion'
    });
    var getTabPT = function getTabPT(tab, key, index) {
      AccordionTabBase.getCProps(tab);
      var tabMetaData = {
        // props: atProps, /* @todo */
        parent: metaData,
        context: {
          index: index,
          count: count,
          first: index === 0,
          last: index === count - 1,
          selected: isSelected(index),
          disabled: getTabProp(tab, 'disabled')
        }
      };
      return mergeProps(ptm("accordion.".concat(key), {
        tab: tabMetaData
      }), ptm("tab.".concat(key), {
        accordiontab: tabMetaData
      }), ptm("tab.".concat(key), tabMetaData), ptmo(getTabProp(tab, 'pt'), key, tabMetaData));
    };
    var getTabProp = function getTabProp(tab, name) {
      return AccordionTabBase.getCProp(tab, name);
    };
    var onTabHeaderClick = function onTabHeaderClick(event, tab, index) {
      changeActiveIndex(event, tab, index);
    };
    var changeActiveIndex = function changeActiveIndex(event, tab, index) {
      if (!getTabProp(tab, 'disabled')) {
        var selected = isSelected(index);
        var newActiveIndex = null;
        if (props.multiple) {
          var indexes = activeIndex || [];
          newActiveIndex = selected ? indexes.filter(function (i) {
            return i !== index;
          }) : [].concat(_toConsumableArray(indexes), [index]);
        } else {
          newActiveIndex = selected ? null : index;
        }
        var callback = selected ? props.onTabClose : props.onTabOpen;
        callback && callback({
          originalEvent: event,
          index: index
        });
        if (props.onTabChange) {
          props.onTabChange({
            originalEvent: event,
            index: newActiveIndex
          });
        } else {
          setActiveIndexState(newActiveIndex);
        }
      }
      event.preventDefault();
    };
    var onTabHeaderKeyDown = function onTabHeaderKeyDown(event, tab, index) {
      switch (event.code) {
        case 'ArrowDown':
          onTabArrowDownKey(event);
          break;
        case 'ArrowUp':
          onTabArrowUpKey(event);
          break;
        case 'Home':
          onTabHomeKey(event);
          break;
        case 'End':
          onTabEndKey(event);
          break;
        case 'Enter':
        case 'Space':
          onTabEnterKey(event, tab, index);
          break;
      }
    };
    var onTabArrowDownKey = function onTabArrowDownKey(event) {
      var nextHeaderAction = findNextHeaderAction(event.target.parentElement.parentElement);
      nextHeaderAction ? changeFocusedTab(nextHeaderAction) : onTabHomeKey(event);
      event.preventDefault();
    };
    var onTabArrowUpKey = function onTabArrowUpKey(event) {
      var prevHeaderAction = findPrevHeaderAction(event.target.parentElement.parentElement);
      prevHeaderAction ? changeFocusedTab(prevHeaderAction) : onTabEndKey(event);
      event.preventDefault();
    };
    var onTabHomeKey = function onTabHomeKey(event) {
      var firstHeaderAction = findFirstHeaderAction();
      changeFocusedTab(firstHeaderAction);
      event.preventDefault();
    };
    var onTabEndKey = function onTabEndKey(event) {
      var lastHeaderAction = findLastHeaderAction();
      changeFocusedTab(lastHeaderAction);
      event.preventDefault();
    };
    var onTabEnterKey = function onTabEnterKey(event, tab, index) {
      changeActiveIndex(event, tab, index);
      event.preventDefault();
    };
    var findNextHeaderAction = function findNextHeaderAction(tabElement) {
      var selfCheck = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var nextTabElement = selfCheck ? tabElement : tabElement.nextElementSibling;
      var headerElement = DomHandler.findSingle(nextTabElement, '[data-pc-section="header"]');
      return headerElement ? DomHandler.getAttribute(headerElement, 'data-p-disabled') ? findNextHeaderAction(headerElement.parentElement) : DomHandler.findSingle(headerElement, '[data-pc-section="headeraction"]') : null;
    };
    var findPrevHeaderAction = function findPrevHeaderAction(tabElement) {
      var selfCheck = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var prevTabElement = selfCheck ? tabElement : tabElement.previousElementSibling;
      var headerElement = DomHandler.findSingle(prevTabElement, '[data-pc-section="header"]');
      return headerElement ? DomHandler.getAttribute(headerElement, 'data-p-disabled') ? findPrevHeaderAction(headerElement.parentElement) : DomHandler.findSingle(headerElement, '[data-pc-section="headeraction"]') : null;
    };
    var findFirstHeaderAction = function findFirstHeaderAction() {
      return findNextHeaderAction(elementRef.current.firstElementChild, true);
    };
    var findLastHeaderAction = function findLastHeaderAction() {
      return findPrevHeaderAction(elementRef.current.lastElementChild, true);
    };
    var changeFocusedTab = function changeFocusedTab(element) {
      if (element) {
        DomHandler.focus(element);
      }
    };
    var isSelected = function isSelected(index) {
      return props.multiple && Array.isArray(activeIndex) ? activeIndex && activeIndex.some(function (i) {
        return i === index;
      }) : activeIndex === index;
    };
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        getElement: function getElement() {
          return elementRef.current;
        }
      };
    });
    useMountEffect(function () {
      if (!idState) {
        setIdState(UniqueComponentId());
      }
    });
    if (!idState) {
      return null;
    }
    var createTabHeader = function createTabHeader(tab, selected, index) {
      var style = _objectSpread$1L(_objectSpread$1L({}, getTabProp(tab, 'style') || {}), getTabProp(tab, 'headerStyle') || {});
      var headerId = idState + '_header_' + index;
      var ariaControls = idState + '_content_' + index;
      var tabIndex = getTabProp(tab, 'disabled') ? -1 : getTabProp(tab, 'tabIndex');
      var headerTitleProps = mergeProps({
        className: cx('tab.headertitle')
      }, getTabPT(tab, 'headertitle', index));
      var tabCProps = AccordionTabBase.getCProps(tab);
      var header = getTabProp(tab, 'headerTemplate') ? ObjectUtils.getJSXElement(getTabProp(tab, 'headerTemplate'), tabCProps) : /*#__PURE__*/React__namespace.createElement("span", headerTitleProps, ObjectUtils.getJSXElement(getTabProp(tab, 'header'), tabCProps));
      var headerIconProps = mergeProps({
        'aria-hidden': 'true',
        className: cx('tab.headericon')
      }, getTabPT(tab, 'headericon', index));
      var icon = selected ? props.collapseIcon || /*#__PURE__*/React__namespace.createElement(ChevronDownIcon, headerIconProps) : props.expandIcon || /*#__PURE__*/React__namespace.createElement(ChevronRightIcon, headerIconProps);
      var toggleIcon = IconUtils.getJSXIcon(icon, _objectSpread$1L({}, headerIconProps), {
        props: props,
        selected: selected
      });
      var headerProps = mergeProps({
        className: classNames(getTabProp(tab, 'headerClassName'), getTabProp(tab, 'className'), cx('tab.header', {
          selected: selected,
          getTabProp: getTabProp,
          tab: tab
        })),
        style: style,
        'data-p-highlight': selected,
        'data-p-disabled': getTabProp(tab, 'disabled')
      }, getTabPT(tab, 'header', index));
      var headerActionProps = mergeProps({
        id: headerId,
        href: '#' + ariaControls,
        className: cx('tab.headeraction'),
        role: 'button',
        tabIndex: tabIndex,
        onClick: function onClick(e) {
          return onTabHeaderClick(e, tab, index);
        },
        onKeyDown: function onKeyDown(e) {
          return onTabHeaderKeyDown(e, tab, index);
        },
        'aria-disabled': getTabProp(tab, 'disabled'),
        'aria-controls': ariaControls,
        'aria-expanded': selected
      }, getTabPT(tab, 'headeraction', index));
      return /*#__PURE__*/React__namespace.createElement("div", headerProps, /*#__PURE__*/React__namespace.createElement("a", headerActionProps, toggleIcon, header));
    };
    var createTabContent = function createTabContent(tab, selected, index) {
      var style = _objectSpread$1L(_objectSpread$1L({}, getTabProp(tab, 'style') || {}), getTabProp(tab, 'contentStyle') || {});
      var contentId = idState + '_content_' + index;
      var ariaLabelledby = idState + '_header_' + index;
      var contentRef = /*#__PURE__*/React__namespace.createRef();
      var toggleableContentProps = mergeProps({
        id: contentId,
        ref: contentRef,
        className: classNames(getTabProp(tab, 'contentClassName'), getTabProp(tab, 'className'), cx('tab.toggleablecontent')),
        style: style,
        role: 'region',
        'aria-labelledby': ariaLabelledby
      }, getTabPT(tab, 'toggleablecontent', index));
      var contentProps = mergeProps({
        className: cx('tab.content')
      }, getTabPT(tab, 'content', index));
      var transitionProps = mergeProps({
        classNames: cx('tab.transition'),
        timeout: {
          enter: 1000,
          exit: 450
        },
        "in": selected,
        unmountOnExit: true,
        options: props.transitionOptions
      }, getTabPT(tab, 'transition', index));
      return /*#__PURE__*/React__namespace.createElement(CSSTransition, _extends({
        nodeRef: contentRef
      }, transitionProps), /*#__PURE__*/React__namespace.createElement("div", toggleableContentProps, /*#__PURE__*/React__namespace.createElement("div", contentProps, getTabProp(tab, 'children'))));
    };
    var createTab = function createTab(tab, index) {
      if (ObjectUtils.isValidChild(tab, 'AccordionTab')) {
        var key = idState + '_' + index;
        var selected = isSelected(index);
        var tabHeader = createTabHeader(tab, selected, index);
        var tabContent = createTabContent(tab, selected, index);
        var _rootProps = mergeProps({
          key: key,
          className: cx('tab.root', {
            selected: selected
          })
        }, AccordionTabBase.getCOtherProps(tab), getTabPT(tab, 'root', index));
        return /*#__PURE__*/React__namespace.createElement("div", _rootProps, tabHeader, tabContent);
      }
      return null;
    };
    var createTabs = function createTabs() {
      return React__namespace.Children.map(props.children, createTab);
    };
    var tabs = createTabs();
    var rootProps = mergeProps({
      className: classNames(props.className, cx('root')),
      style: props.style
    }, AccordionBase.getOtherProps(props), ptm('root'));
    return /*#__PURE__*/React__namespace.createElement("div", _extends({
      id: idState,
      ref: elementRef
    }, rootProps), tabs);
  });
  AccordionTab.displayName = 'AccordionTab';
  Accordion.displayName = 'Accordion';

  var AngleDoubleDownIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("path", {
      fillRule: "evenodd",
      clipRule: "evenodd",
      d: "M6.70786 6.59831C6.80043 6.63674 6.89974 6.65629 6.99997 6.65581C7.19621 6.64081 7.37877 6.54953 7.50853 6.40153L11.0685 2.8416C11.1364 2.69925 11.1586 2.53932 11.132 2.38384C11.1053 2.22837 11.0311 2.08498 10.9195 1.97343C10.808 1.86188 10.6646 1.78766 10.5091 1.76099C10.3536 1.73431 10.1937 1.75649 10.0513 1.82448L6.99997 4.87585L3.9486 1.82448C3.80625 1.75649 3.64632 1.73431 3.49084 1.76099C3.33536 1.78766 3.19197 1.86188 3.08043 1.97343C2.96888 2.08498 2.89466 2.22837 2.86798 2.38384C2.84131 2.53932 2.86349 2.69925 2.93147 2.8416L6.46089 6.43205C6.53132 6.50336 6.61528 6.55989 6.70786 6.59831ZM6.70786 12.1925C6.80043 12.2309 6.89974 12.2505 6.99997 12.25C7.10241 12.2465 7.20306 12.2222 7.29575 12.1785C7.38845 12.1348 7.47124 12.0726 7.53905 11.9957L11.0685 8.46629C11.1614 8.32292 11.2036 8.15249 11.1881 7.98233C11.1727 7.81216 11.1005 7.6521 10.9833 7.52781C10.866 7.40353 10.7104 7.3222 10.5415 7.29688C10.3725 7.27155 10.1999 7.30369 10.0513 7.38814L6.99997 10.4395L3.9486 7.38814C3.80006 7.30369 3.62747 7.27155 3.45849 7.29688C3.28951 7.3222 3.13393 7.40353 3.01667 7.52781C2.89942 7.6521 2.82729 7.81216 2.81184 7.98233C2.79639 8.15249 2.83852 8.32292 2.93148 8.46629L6.4609 12.0262C6.53133 12.0975 6.61529 12.1541 6.70786 12.1925Z",
      fill: "currentColor"
    }));
  }));
  AngleDoubleDownIcon.displayName = 'AngleDoubleDownIcon';

  var AngleDoubleLeftIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("path", {
      fillRule: "evenodd",
      clipRule: "evenodd",
      d: "M5.71602 11.164C5.80782 11.2021 5.9063 11.2215 6.00569 11.221C6.20216 11.2301 6.39427 11.1612 6.54025 11.0294C6.68191 10.8875 6.76148 10.6953 6.76148 10.4948C6.76148 10.2943 6.68191 10.1021 6.54025 9.96024L3.51441 6.9344L6.54025 3.90855C6.624 3.76126 6.65587 3.59011 6.63076 3.42254C6.60564 3.25498 6.525 3.10069 6.40175 2.98442C6.2785 2.86815 6.11978 2.79662 5.95104 2.7813C5.78229 2.76598 5.61329 2.80776 5.47112 2.89994L1.97123 6.39983C1.82957 6.54167 1.75 6.73393 1.75 6.9344C1.75 7.13486 1.82957 7.32712 1.97123 7.46896L5.47112 10.9991C5.54096 11.0698 5.62422 11.1259 5.71602 11.164ZM11.0488 10.9689C11.1775 11.1156 11.3585 11.2061 11.5531 11.221C11.7477 11.2061 11.9288 11.1156 12.0574 10.9689C12.1815 10.8302 12.25 10.6506 12.25 10.4645C12.25 10.2785 12.1815 10.0989 12.0574 9.96024L9.03158 6.93439L12.0574 3.90855C12.1248 3.76739 12.1468 3.60881 12.1204 3.45463C12.0939 3.30045 12.0203 3.15826 11.9097 3.04765C11.7991 2.93703 11.6569 2.86343 11.5027 2.83698C11.3486 2.81053 11.19 2.83252 11.0488 2.89994L7.51865 6.36957C7.37699 6.51141 7.29742 6.70367 7.29742 6.90414C7.29742 7.1046 7.37699 7.29686 7.51865 7.4387L11.0488 10.9689Z",
      fill: "currentColor"
    }));
  }));
  AngleDoubleLeftIcon.displayName = 'AngleDoubleLeftIcon';

  var AngleDoubleRightIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("path", {
      fillRule: "evenodd",
      clipRule: "evenodd",
      d: "M7.68757 11.1451C7.7791 11.1831 7.8773 11.2024 7.9764 11.2019C8.07769 11.1985 8.17721 11.1745 8.26886 11.1312C8.36052 11.088 8.44238 11.0265 8.50943 10.9505L12.0294 7.49085C12.1707 7.34942 12.25 7.15771 12.25 6.95782C12.25 6.75794 12.1707 6.56622 12.0294 6.42479L8.50943 2.90479C8.37014 2.82159 8.20774 2.78551 8.04633 2.80192C7.88491 2.81833 7.73309 2.88635 7.6134 2.99588C7.4937 3.10541 7.41252 3.25061 7.38189 3.40994C7.35126 3.56927 7.37282 3.73423 7.44337 3.88033L10.4605 6.89748L7.44337 9.91463C7.30212 10.0561 7.22278 10.2478 7.22278 10.4477C7.22278 10.6475 7.30212 10.8393 7.44337 10.9807C7.51301 11.0512 7.59603 11.1071 7.68757 11.1451ZM1.94207 10.9505C2.07037 11.0968 2.25089 11.1871 2.44493 11.2019C2.63898 11.1871 2.81949 11.0968 2.94779 10.9505L6.46779 7.49085C6.60905 7.34942 6.68839 7.15771 6.68839 6.95782C6.68839 6.75793 6.60905 6.56622 6.46779 6.42479L2.94779 2.90479C2.80704 2.83757 2.6489 2.81563 2.49517 2.84201C2.34143 2.86839 2.19965 2.94178 2.08936 3.05207C1.97906 3.16237 1.90567 3.30415 1.8793 3.45788C1.85292 3.61162 1.87485 3.76975 1.94207 3.9105L4.95922 6.92765L1.94207 9.9448C1.81838 10.0831 1.75 10.2621 1.75 10.4477C1.75 10.6332 1.81838 10.8122 1.94207 10.9505Z",
      fill: "currentColor"
    }));
  }));
  AngleDoubleRightIcon.displayName = 'AngleDoubleRightIcon';

  var AngleDoubleUpIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("path", {
      fillRule: "evenodd",
      clipRule: "evenodd",
      d: "M10.1504 6.67719C10.2417 6.71508 10.3396 6.73436 10.4385 6.73389C10.6338 6.74289 10.8249 6.67441 10.97 6.54334C11.1109 6.4023 11.19 6.21112 11.19 6.01178C11.19 5.81245 11.1109 5.62127 10.97 5.48023L7.45977 1.96998C7.31873 1.82912 7.12755 1.75 6.92821 1.75C6.72888 1.75 6.5377 1.82912 6.39666 1.96998L2.9165 5.45014C2.83353 5.58905 2.79755 5.751 2.81392 5.91196C2.83028 6.07293 2.89811 6.22433 3.00734 6.34369C3.11656 6.46306 3.26137 6.54402 3.42025 6.57456C3.57914 6.60511 3.74364 6.5836 3.88934 6.51325L6.89813 3.50446L9.90691 6.51325C9.97636 6.58357 10.0592 6.6393 10.1504 6.67719ZM9.93702 11.9993C10.065 12.1452 10.245 12.2352 10.4385 12.25C10.632 12.2352 10.812 12.1452 10.9399 11.9993C11.0633 11.8614 11.1315 11.6828 11.1315 11.4978C11.1315 11.3128 11.0633 11.1342 10.9399 10.9963L7.48987 7.48609C7.34883 7.34523 7.15765 7.26611 6.95832 7.26611C6.75899 7.26611 6.5678 7.34523 6.42677 7.48609L2.91652 10.9963C2.84948 11.1367 2.82761 11.2944 2.85391 11.4477C2.88022 11.601 2.9534 11.7424 3.06339 11.8524C3.17338 11.9624 3.31477 12.0356 3.46808 12.0619C3.62139 12.0882 3.77908 12.0663 3.91945 11.9993L6.92823 8.99048L9.93702 11.9993Z",
      fill: "currentColor"
    }));
  }));
  AngleDoubleUpIcon.displayName = 'AngleDoubleUpIcon';

  var AngleDownIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("path", {
      d: "M3.58659 4.5007C3.68513 4.50023 3.78277 4.51945 3.87379 4.55723C3.9648 4.59501 4.04735 4.65058 4.11659 4.7207L7.11659 7.7207L10.1166 4.7207C10.2619 4.65055 10.4259 4.62911 10.5843 4.65956C10.7427 4.69002 10.8871 4.77074 10.996 4.88976C11.1049 5.00877 11.1726 5.15973 11.1889 5.32022C11.2052 5.48072 11.1693 5.6422 11.0866 5.7807L7.58659 9.2807C7.44597 9.42115 7.25534 9.50004 7.05659 9.50004C6.85784 9.50004 6.66722 9.42115 6.52659 9.2807L3.02659 5.7807C2.88614 5.64007 2.80725 5.44945 2.80725 5.2507C2.80725 5.05195 2.88614 4.86132 3.02659 4.7207C3.09932 4.64685 3.18675 4.58911 3.28322 4.55121C3.37969 4.51331 3.48305 4.4961 3.58659 4.5007Z",
      fill: "currentColor"
    }));
  }));
  AngleDownIcon.displayName = 'AngleDownIcon';

  var AngleLeftIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("path", {
      d: "M8.75 11.185C8.65146 11.1854 8.55381 11.1662 8.4628 11.1284C8.37179 11.0906 8.28924 11.0351 8.22 10.965L4.72 7.46496C4.57955 7.32433 4.50066 7.13371 4.50066 6.93496C4.50066 6.73621 4.57955 6.54558 4.72 6.40496L8.22 2.93496C8.36095 2.84357 8.52851 2.80215 8.69582 2.81733C8.86312 2.83252 9.02048 2.90344 9.14268 3.01872C9.26487 3.134 9.34483 3.28696 9.36973 3.4531C9.39463 3.61924 9.36303 3.78892 9.28 3.93496L6.28 6.93496L9.28 9.93496C9.42045 10.0756 9.49934 10.2662 9.49934 10.465C9.49934 10.6637 9.42045 10.8543 9.28 10.995C9.13526 11.1257 8.9448 11.1939 8.75 11.185Z",
      fill: "currentColor"
    }));
  }));
  AngleLeftIcon.displayName = 'AngleLeftIcon';

  var AngleRightIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("path", {
      d: "M5.25 11.1728C5.14929 11.1694 5.05033 11.1455 4.9592 11.1025C4.86806 11.0595 4.78666 10.9984 4.72 10.9228C4.57955 10.7822 4.50066 10.5916 4.50066 10.3928C4.50066 10.1941 4.57955 10.0035 4.72 9.86283L7.72 6.86283L4.72 3.86283C4.66067 3.71882 4.64765 3.55991 4.68275 3.40816C4.71785 3.25642 4.79932 3.11936 4.91585 3.01602C5.03238 2.91268 5.17819 2.84819 5.33305 2.83149C5.4879 2.81479 5.64411 2.84671 5.78 2.92283L9.28 6.42283C9.42045 6.56346 9.49934 6.75408 9.49934 6.95283C9.49934 7.15158 9.42045 7.34221 9.28 7.48283L5.78 10.9228C5.71333 10.9984 5.63193 11.0595 5.5408 11.1025C5.44966 11.1455 5.35071 11.1694 5.25 11.1728Z",
      fill: "currentColor"
    }));
  }));
  AngleRightIcon.displayName = 'AngleRightIcon';

  var AngleUpIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("path", {
      d: "M10.4134 9.49931C10.3148 9.49977 10.2172 9.48055 10.1262 9.44278C10.0352 9.405 9.95263 9.34942 9.88338 9.27931L6.88338 6.27931L3.88338 9.27931C3.73811 9.34946 3.57409 9.3709 3.41567 9.34044C3.25724 9.30999 3.11286 9.22926 3.00395 9.11025C2.89504 8.99124 2.82741 8.84028 2.8111 8.67978C2.79478 8.51928 2.83065 8.35781 2.91338 8.21931L6.41338 4.71931C6.55401 4.57886 6.74463 4.49997 6.94338 4.49997C7.14213 4.49997 7.33276 4.57886 7.47338 4.71931L10.9734 8.21931C11.1138 8.35994 11.1927 8.55056 11.1927 8.74931C11.1927 8.94806 11.1138 9.13868 10.9734 9.27931C10.9007 9.35315 10.8132 9.41089 10.7168 9.44879C10.6203 9.48669 10.5169 9.5039 10.4134 9.49931Z",
      fill: "currentColor"
    }));
  }));
  AngleUpIcon.displayName = 'AngleUpIcon';

  var ArrowDownIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    var _React$useState = React__namespace.useState(inProps.id),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      pathId = _React$useState2[0],
      setPathId = _React$useState2[1];
    React__namespace.useEffect(function () {
      if (ObjectUtils.isEmpty(pathId)) {
        setPathId(UniqueComponentId('pr_icon_clip_'));
      }
    }, [pathId]);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("g", {
      clipPath: "url(#".concat(pathId, ")")
    }, /*#__PURE__*/React__namespace.createElement("path", {
      fillRule: "evenodd",
      clipRule: "evenodd",
      d: "M6.99994 14C6.91097 14.0004 6.82281 13.983 6.74064 13.9489C6.65843 13.9148 6.58387 13.8646 6.52133 13.8013L1.10198 8.38193C0.982318 8.25351 0.917175 8.08367 0.920272 7.90817C0.923368 7.73267 0.994462 7.56523 1.11858 7.44111C1.24269 7.317 1.41014 7.2459 1.58563 7.2428C1.76113 7.23971 1.93098 7.30485 2.0594 7.42451L6.32263 11.6877V0.677419C6.32263 0.497756 6.394 0.325452 6.52104 0.198411C6.64808 0.0713706 6.82039 0 7.00005 0C7.17971 0 7.35202 0.0713706 7.47906 0.198411C7.6061 0.325452 7.67747 0.497756 7.67747 0.677419V11.6877L11.9407 7.42451C12.0691 7.30485 12.2389 7.23971 12.4144 7.2428C12.5899 7.2459 12.7574 7.317 12.8815 7.44111C13.0056 7.56523 13.0767 7.73267 13.0798 7.90817C13.0829 8.08367 13.0178 8.25351 12.8981 8.38193L7.47875 13.8013C7.41621 13.8646 7.34164 13.9148 7.25944 13.9489C7.17727 13.983 7.08912 14.0004 7.00015 14C7.00012 14 7.00009 14 7.00005 14C7.00001 14 6.99998 14 6.99994 14Z",
      fill: "currentColor"
    })), /*#__PURE__*/React__namespace.createElement("defs", null, /*#__PURE__*/React__namespace.createElement("clipPath", {
      id: pathId
    }, /*#__PURE__*/React__namespace.createElement("rect", {
      width: "14",
      height: "14",
      fill: "white"
    }))));
  }));
  ArrowDownIcon.displayName = 'ArrowDownIcon';

  var ArrowUpIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    var _React$useState = React__namespace.useState(inProps.id),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      pathId = _React$useState2[0],
      setPathId = _React$useState2[1];
    React__namespace.useEffect(function () {
      if (ObjectUtils.isEmpty(pathId)) {
        setPathId(UniqueComponentId('pr_icon_clip_'));
      }
    }, [pathId]);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("g", {
      clipPath: "url(#".concat(pathId, ")")
    }, /*#__PURE__*/React__namespace.createElement("path", {
      fillRule: "evenodd",
      clipRule: "evenodd",
      d: "M6.51551 13.799C6.64205 13.9255 6.813 13.9977 6.99193 14C7.17087 13.9977 7.34182 13.9255 7.46835 13.799C7.59489 13.6725 7.66701 13.5015 7.66935 13.3226V2.31233L11.9326 6.57554C11.9951 6.63887 12.0697 6.68907 12.1519 6.72319C12.2341 6.75731 12.3223 6.77467 12.4113 6.77425C12.5003 6.77467 12.5885 6.75731 12.6707 6.72319C12.7529 6.68907 12.8274 6.63887 12.89 6.57554C13.0168 6.44853 13.0881 6.27635 13.0881 6.09683C13.0881 5.91732 13.0168 5.74514 12.89 5.61812L7.48846 0.216594C7.48274 0.210436 7.4769 0.204374 7.47094 0.198411C7.3439 0.0713707 7.1716 0 6.99193 0C6.81227 0 6.63997 0.0713707 6.51293 0.198411C6.50704 0.204296 6.50128 0.210278 6.49563 0.216354L1.09386 5.61812C0.974201 5.74654 0.909057 5.91639 0.912154 6.09189C0.91525 6.26738 0.986345 6.43483 1.11046 6.55894C1.23457 6.68306 1.40202 6.75415 1.57752 6.75725C1.75302 6.76035 1.92286 6.6952 2.05128 6.57554L6.31451 2.31231V13.3226C6.31685 13.5015 6.38898 13.6725 6.51551 13.799Z",
      fill: "currentColor"
    })), /*#__PURE__*/React__namespace.createElement("defs", null, /*#__PURE__*/React__namespace.createElement("clipPath", {
      id: pathId
    }, /*#__PURE__*/React__namespace.createElement("rect", {
      width: "14",
      height: "14",
      fill: "white"
    }))));
  }));
  ArrowUpIcon.displayName = 'ArrowUpIcon';

  var BanIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    var _React$useState = React__namespace.useState(inProps.id),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      pathId = _React$useState2[0],
      setPathId = _React$useState2[1];
    React__namespace.useEffect(function () {
      if (ObjectUtils.isEmpty(pathId)) {
        setPathId(UniqueComponentId('pr_icon_clip_'));
      }
    }, [pathId]);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("g", {
      clipPath: "url(#".concat(pathId, ")")
    }, /*#__PURE__*/React__namespace.createElement("path", {
      d: "M7 0C5.61553 0 4.26215 0.410543 3.11101 1.17971C1.95987 1.94888 1.06266 3.04213 0.532846 4.32122C0.00303296 5.6003 -0.13559 7.00776 0.134506 8.36563C0.404603 9.7235 1.07129 10.9708 2.05026 11.9497C3.02922 12.9287 4.2765 13.5954 5.63437 13.8655C6.99224 14.1356 8.3997 13.997 9.67879 13.4672C10.9579 12.9373 12.0511 12.0401 12.8203 10.889C13.5895 9.73785 14 8.38447 14 7C14 5.14348 13.2625 3.36301 11.9497 2.05025C10.637 0.737498 8.85652 0 7 0ZM1.16667 7C1.16549 5.65478 1.63303 4.35118 2.48889 3.31333L10.6867 11.5111C9.83309 12.2112 8.79816 12.6544 7.70243 12.789C6.60669 12.9236 5.49527 12.744 4.49764 12.2713C3.50001 11.7986 2.65724 11.0521 2.06751 10.1188C1.47778 9.18558 1.16537 8.10397 1.16667 7ZM11.5111 10.6867L3.31334 2.48889C4.43144 1.57388 5.84966 1.10701 7.29265 1.1789C8.73565 1.2508 10.1004 1.85633 11.1221 2.87795C12.1437 3.89956 12.7492 5.26435 12.8211 6.70735C12.893 8.15034 12.4261 9.56856 11.5111 10.6867Z",
      fill: "currentColor"
    })), /*#__PURE__*/React__namespace.createElement("defs", null, /*#__PURE__*/React__namespace.createElement("clipPath", {
      id: pathId
    }, /*#__PURE__*/React__namespace.createElement("rect", {
      width: "14",
      height: "14",
      fill: "white"
    }))));
  }));
  BanIcon.displayName = 'BanIcon';

  var BarsIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("path", {
      fillRule: "evenodd",
      clipRule: "evenodd",
      d: "M13.3226 3.6129H0.677419C0.497757 3.6129 0.325452 3.54152 0.198411 3.41448C0.0713707 3.28744 0 3.11514 0 2.93548C0 2.75581 0.0713707 2.58351 0.198411 2.45647C0.325452 2.32943 0.497757 2.25806 0.677419 2.25806H13.3226C13.5022 2.25806 13.6745 2.32943 13.8016 2.45647C13.9286 2.58351 14 2.75581 14 2.93548C14 3.11514 13.9286 3.28744 13.8016 3.41448C13.6745 3.54152 13.5022 3.6129 13.3226 3.6129ZM13.3226 7.67741H0.677419C0.497757 7.67741 0.325452 7.60604 0.198411 7.479C0.0713707 7.35196 0 7.17965 0 6.99999C0 6.82033 0.0713707 6.64802 0.198411 6.52098C0.325452 6.39394 0.497757 6.32257 0.677419 6.32257H13.3226C13.5022 6.32257 13.6745 6.39394 13.8016 6.52098C13.9286 6.64802 14 6.82033 14 6.99999C14 7.17965 13.9286 7.35196 13.8016 7.479C13.6745 7.60604 13.5022 7.67741 13.3226 7.67741ZM0.677419 11.7419H13.3226C13.5022 11.7419 13.6745 11.6706 13.8016 11.5435C13.9286 11.4165 14 11.2442 14 11.0645C14 10.8848 13.9286 10.7125 13.8016 10.5855C13.6745 10.4585 13.5022 10.3871 13.3226 10.3871H0.677419C0.497757 10.3871 0.325452 10.4585 0.198411 10.5855C0.0713707 10.7125 0 10.8848 0 11.0645C0 11.2442 0.0713707 11.4165 0.198411 11.5435C0.325452 11.6706 0.497757 11.7419 0.677419 11.7419Z",
      fill: "currentColor"
    }));
  }));
  BarsIcon.displayName = 'BarsIcon';

  var CalendarIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("path", {
      d: "M10.7838 1.51351H9.83783V0.567568C9.83783 0.417039 9.77804 0.272676 9.6716 0.166237C9.56516 0.0597971 9.42079 0 9.27027 0C9.11974 0 8.97538 0.0597971 8.86894 0.166237C8.7625 0.272676 8.7027 0.417039 8.7027 0.567568V1.51351H5.29729V0.567568C5.29729 0.417039 5.2375 0.272676 5.13106 0.166237C5.02462 0.0597971 4.88025 0 4.72973 0C4.5792 0 4.43484 0.0597971 4.3284 0.166237C4.22196 0.272676 4.16216 0.417039 4.16216 0.567568V1.51351H3.21621C2.66428 1.51351 2.13494 1.73277 1.74467 2.12305C1.35439 2.51333 1.13513 3.04266 1.13513 3.59459V11.9189C1.13513 12.4709 1.35439 13.0002 1.74467 13.3905C2.13494 13.7807 2.66428 14 3.21621 14H10.7838C11.3357 14 11.865 13.7807 12.2553 13.3905C12.6456 13.0002 12.8649 12.4709 12.8649 11.9189V3.59459C12.8649 3.04266 12.6456 2.51333 12.2553 2.12305C11.865 1.73277 11.3357 1.51351 10.7838 1.51351ZM3.21621 2.64865H4.16216V3.59459C4.16216 3.74512 4.22196 3.88949 4.3284 3.99593C4.43484 4.10237 4.5792 4.16216 4.72973 4.16216C4.88025 4.16216 5.02462 4.10237 5.13106 3.99593C5.2375 3.88949 5.29729 3.74512 5.29729 3.59459V2.64865H8.7027V3.59459C8.7027 3.74512 8.7625 3.88949 8.86894 3.99593C8.97538 4.10237 9.11974 4.16216 9.27027 4.16216C9.42079 4.16216 9.56516 4.10237 9.6716 3.99593C9.77804 3.88949 9.83783 3.74512 9.83783 3.59459V2.64865H10.7838C11.0347 2.64865 11.2753 2.74831 11.4527 2.92571C11.6301 3.10311 11.7297 3.34371 11.7297 3.59459V5.67568H2.27027V3.59459C2.27027 3.34371 2.36993 3.10311 2.54733 2.92571C2.72473 2.74831 2.96533 2.64865 3.21621 2.64865ZM10.7838 12.8649H3.21621C2.96533 12.8649 2.72473 12.7652 2.54733 12.5878C2.36993 12.4104 2.27027 12.1698 2.27027 11.9189V6.81081H11.7297V11.9189C11.7297 12.1698 11.6301 12.4104 11.4527 12.5878C11.2753 12.7652 11.0347 12.8649 10.7838 12.8649Z",
      fill: "currentColor"
    }));
  }));
  CalendarIcon.displayName = 'CalendarIcon';

  var CheckIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("path", {
      d: "M4.86199 11.5948C4.78717 11.5923 4.71366 11.5745 4.64596 11.5426C4.57826 11.5107 4.51779 11.4652 4.46827 11.4091L0.753985 7.69483C0.683167 7.64891 0.623706 7.58751 0.580092 7.51525C0.536478 7.44299 0.509851 7.36177 0.502221 7.27771C0.49459 7.19366 0.506156 7.10897 0.536046 7.03004C0.565935 6.95111 0.613367 6.88 0.674759 6.82208C0.736151 6.76416 0.8099 6.72095 0.890436 6.69571C0.970973 6.67046 1.05619 6.66385 1.13966 6.67635C1.22313 6.68886 1.30266 6.72017 1.37226 6.76792C1.44186 6.81567 1.4997 6.8786 1.54141 6.95197L4.86199 10.2503L12.6397 2.49483C12.7444 2.42694 12.8689 2.39617 12.9932 2.40745C13.1174 2.41873 13.2343 2.47141 13.3251 2.55705C13.4159 2.64268 13.4753 2.75632 13.4938 2.87973C13.5123 3.00315 13.4888 3.1292 13.4271 3.23768L5.2557 11.4091C5.20618 11.4652 5.14571 11.5107 5.07801 11.5426C5.01031 11.5745 4.9368 11.5923 4.86199 11.5948Z",
      fill: "currentColor"
    }));
  }));
  CheckIcon.displayName = 'CheckIcon';

  var ChevronLeftIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("path", {
      d: "M9.61296 13C9.50997 13.0005 9.40792 12.9804 9.3128 12.9409C9.21767 12.9014 9.13139 12.8433 9.05902 12.7701L3.83313 7.54416C3.68634 7.39718 3.60388 7.19795 3.60388 6.99022C3.60388 6.78249 3.68634 6.58325 3.83313 6.43628L9.05902 1.21039C9.20762 1.07192 9.40416 0.996539 9.60724 1.00012C9.81032 1.00371 10.0041 1.08597 10.1477 1.22959C10.2913 1.37322 10.3736 1.56698 10.3772 1.77005C10.3808 1.97313 10.3054 2.16968 10.1669 2.31827L5.49496 6.99022L10.1669 11.6622C10.3137 11.8091 10.3962 12.0084 10.3962 12.2161C10.3962 12.4238 10.3137 12.6231 10.1669 12.7701C10.0945 12.8433 10.0083 12.9014 9.91313 12.9409C9.81801 12.9804 9.71596 13.0005 9.61296 13Z",
      fill: "currentColor"
    }));
  }));
  ChevronLeftIcon.displayName = 'ChevronLeftIcon';

  var ChevronUpIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("path", {
      d: "M12.2097 10.4113C12.1057 10.4118 12.0027 10.3915 11.9067 10.3516C11.8107 10.3118 11.7237 10.2532 11.6506 10.1792L6.93602 5.46461L2.22139 10.1476C2.07272 10.244 1.89599 10.2877 1.71953 10.2717C1.54307 10.2556 1.3771 10.1808 1.24822 10.0593C1.11933 9.93766 1.035 9.77633 1.00874 9.6011C0.982477 9.42587 1.0158 9.2469 1.10338 9.09287L6.37701 3.81923C6.52533 3.6711 6.72639 3.58789 6.93602 3.58789C7.14565 3.58789 7.3467 3.6711 7.49502 3.81923L12.7687 9.09287C12.9168 9.24119 13 9.44225 13 9.65187C13 9.8615 12.9168 10.0626 12.7687 10.2109C12.616 10.3487 12.4151 10.4207 12.2097 10.4113Z",
      fill: "currentColor"
    }));
  }));
  ChevronUpIcon.displayName = 'ChevronUpIcon';

  var ExclamationTriangleIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    var _React$useState = React__namespace.useState(inProps.id),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      pathId = _React$useState2[0],
      setPathId = _React$useState2[1];
    React__namespace.useEffect(function () {
      if (ObjectUtils.isEmpty(pathId)) {
        setPathId(UniqueComponentId('pr_icon_clip_'));
      }
    }, [pathId]);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("g", {
      clipPath: "url(#".concat(pathId, ")")
    }, /*#__PURE__*/React__namespace.createElement("path", {
      d: "M13.4018 13.1893H0.598161C0.49329 13.189 0.390283 13.1615 0.299143 13.1097C0.208003 13.0578 0.131826 12.9832 0.0780112 12.8932C0.0268539 12.8015 0 12.6982 0 12.5931C0 12.4881 0.0268539 12.3848 0.0780112 12.293L6.47985 1.08982C6.53679 1.00399 6.61408 0.933574 6.70484 0.884867C6.7956 0.836159 6.897 0.810669 7 0.810669C7.103 0.810669 7.2044 0.836159 7.29516 0.884867C7.38592 0.933574 7.46321 1.00399 7.52015 1.08982L13.922 12.293C13.9731 12.3848 14 12.4881 14 12.5931C14 12.6982 13.9731 12.8015 13.922 12.8932C13.8682 12.9832 13.792 13.0578 13.7009 13.1097C13.6097 13.1615 13.5067 13.189 13.4018 13.1893ZM1.63046 11.989H12.3695L7 2.59425L1.63046 11.989Z",
      fill: "currentColor"
    }), /*#__PURE__*/React__namespace.createElement("path", {
      d: "M6.99996 8.78801C6.84143 8.78594 6.68997 8.72204 6.57787 8.60993C6.46576 8.49782 6.40186 8.34637 6.39979 8.18784V5.38703C6.39979 5.22786 6.46302 5.0752 6.57557 4.96265C6.68813 4.85009 6.84078 4.78686 6.99996 4.78686C7.15914 4.78686 7.31179 4.85009 7.42435 4.96265C7.5369 5.0752 7.60013 5.22786 7.60013 5.38703V8.18784C7.59806 8.34637 7.53416 8.49782 7.42205 8.60993C7.30995 8.72204 7.15849 8.78594 6.99996 8.78801Z",
      fill: "currentColor"
    }), /*#__PURE__*/React__namespace.createElement("path", {
      d: "M6.99996 11.1887C6.84143 11.1866 6.68997 11.1227 6.57787 11.0106C6.46576 10.8985 6.40186 10.7471 6.39979 10.5885V10.1884C6.39979 10.0292 6.46302 9.87658 6.57557 9.76403C6.68813 9.65147 6.84078 9.58824 6.99996 9.58824C7.15914 9.58824 7.31179 9.65147 7.42435 9.76403C7.5369 9.87658 7.60013 10.0292 7.60013 10.1884V10.5885C7.59806 10.7471 7.53416 10.8985 7.42205 11.0106C7.30995 11.1227 7.15849 11.1866 6.99996 11.1887Z",
      fill: "currentColor"
    })), /*#__PURE__*/React__namespace.createElement("defs", null, /*#__PURE__*/React__namespace.createElement("clipPath", {
      id: pathId
    }, /*#__PURE__*/React__namespace.createElement("rect", {
      width: "14",
      height: "14",
      fill: "white"
    }))));
  }));
  ExclamationTriangleIcon.displayName = 'ExclamationTriangleIcon';

  var EyeIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("path", {
      fillRule: "evenodd",
      clipRule: "evenodd",
      d: "M0.0535499 7.25213C0.208567 7.59162 2.40413 12.4 7 12.4C11.5959 12.4 13.7914 7.59162 13.9465 7.25213C13.9487 7.2471 13.9506 7.24304 13.952 7.24001C13.9837 7.16396 14 7.08239 14 7.00001C14 6.91762 13.9837 6.83605 13.952 6.76001C13.9506 6.75697 13.9487 6.75292 13.9465 6.74788C13.7914 6.4084 11.5959 1.60001 7 1.60001C2.40413 1.60001 0.208567 6.40839 0.0535499 6.74788C0.0512519 6.75292 0.0494023 6.75697 0.048 6.76001C0.0163137 6.83605 0 6.91762 0 7.00001C0 7.08239 0.0163137 7.16396 0.048 7.24001C0.0494023 7.24304 0.0512519 7.2471 0.0535499 7.25213ZM7 11.2C3.664 11.2 1.736 7.92001 1.264 7.00001C1.736 6.08001 3.664 2.80001 7 2.80001C10.336 2.80001 12.264 6.08001 12.736 7.00001C12.264 7.92001 10.336 11.2 7 11.2ZM5.55551 9.16182C5.98308 9.44751 6.48576 9.6 7 9.6C7.68891 9.59789 8.349 9.32328 8.83614 8.83614C9.32328 8.349 9.59789 7.68891 9.59999 7C9.59999 6.48576 9.44751 5.98308 9.16182 5.55551C8.87612 5.12794 8.47006 4.7947 7.99497 4.59791C7.51988 4.40112 6.99711 4.34963 6.49276 4.44995C5.98841 4.55027 5.52513 4.7979 5.16152 5.16152C4.7979 5.52513 4.55027 5.98841 4.44995 6.49276C4.34963 6.99711 4.40112 7.51988 4.59791 7.99497C4.7947 8.47006 5.12794 8.87612 5.55551 9.16182ZM6.2222 5.83594C6.45243 5.6821 6.7231 5.6 7 5.6C7.37065 5.6021 7.72553 5.75027 7.98762 6.01237C8.24972 6.27446 8.39789 6.62934 8.4 7C8.4 7.27689 8.31789 7.54756 8.16405 7.77779C8.01022 8.00802 7.79157 8.18746 7.53575 8.29343C7.27994 8.39939 6.99844 8.42711 6.72687 8.37309C6.4553 8.31908 6.20584 8.18574 6.01005 7.98994C5.81425 7.79415 5.68091 7.54469 5.6269 7.27312C5.57288 7.00155 5.6006 6.72006 5.70656 6.46424C5.81253 6.20842 5.99197 5.98977 6.2222 5.83594Z",
      fill: "currentColor"
    }));
  }));
  EyeIcon.displayName = 'EyeIcon';

  var EyeSlashIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    var _React$useState = React__namespace.useState(inProps.id),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      pathId = _React$useState2[0],
      setPathId = _React$useState2[1];
    React__namespace.useEffect(function () {
      if (ObjectUtils.isEmpty(pathId)) {
        setPathId(UniqueComponentId('pr_icon_clip_'));
      }
    }, [pathId]);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("g", {
      clipPath: "url(#".concat(pathId, ")")
    }, /*#__PURE__*/React__namespace.createElement("path", {
      fillRule: "evenodd",
      clipRule: "evenodd",
      d: "M13.9414 6.74792C13.9437 6.75295 13.9455 6.757 13.9469 6.76003C13.982 6.8394 14.0001 6.9252 14.0001 7.01195C14.0001 7.0987 13.982 7.1845 13.9469 7.26386C13.6004 8.00059 13.1711 8.69549 12.6674 9.33515C12.6115 9.4071 12.54 9.46538 12.4582 9.50556C12.3765 9.54574 12.2866 9.56678 12.1955 9.56707C12.0834 9.56671 11.9737 9.53496 11.8788 9.47541C11.7838 9.41586 11.7074 9.3309 11.6583 9.23015C11.6092 9.12941 11.5893 9.01691 11.6008 8.90543C11.6124 8.79394 11.6549 8.68793 11.7237 8.5994C12.1065 8.09726 12.4437 7.56199 12.7313 6.99995C12.2595 6.08027 10.3402 2.8014 6.99732 2.8014C6.63723 2.80218 6.27816 2.83969 5.92569 2.91336C5.77666 2.93304 5.62568 2.89606 5.50263 2.80972C5.37958 2.72337 5.29344 2.59398 5.26125 2.44714C5.22907 2.30031 5.2532 2.14674 5.32885 2.01685C5.40451 1.88696 5.52618 1.79021 5.66978 1.74576C6.10574 1.64961 6.55089 1.60134 6.99732 1.60181C11.5916 1.60181 13.7864 6.40856 13.9414 6.74792ZM2.20333 1.61685C2.35871 1.61411 2.5091 1.67179 2.6228 1.77774L12.2195 11.3744C12.3318 11.4869 12.3949 11.6393 12.3949 11.7983C12.3949 11.9572 12.3318 12.1097 12.2195 12.2221C12.107 12.3345 11.9546 12.3976 11.7956 12.3976C11.6367 12.3976 11.4842 12.3345 11.3718 12.2221L10.5081 11.3584C9.46549 12.0426 8.24432 12.4042 6.99729 12.3981C2.403 12.3981 0.208197 7.59135 0.0532336 7.25198C0.0509364 7.24694 0.0490875 7.2429 0.0476856 7.23986C0.0162332 7.16518 3.05176e-05 7.08497 3.05176e-05 7.00394C3.05176e-05 6.92291 0.0162332 6.8427 0.0476856 6.76802C0.631261 5.47831 1.46902 4.31959 2.51084 3.36119L1.77509 2.62545C1.66914 2.51175 1.61146 2.36136 1.61421 2.20597C1.61695 2.05059 1.6799 1.90233 1.78979 1.79244C1.89968 1.68254 2.04794 1.6196 2.20333 1.61685ZM7.45314 8.35147L5.68574 6.57609V6.5361C5.5872 6.78938 5.56498 7.06597 5.62183 7.33173C5.67868 7.59749 5.8121 7.84078 6.00563 8.03158C6.19567 8.21043 6.43052 8.33458 6.68533 8.39089C6.94014 8.44721 7.20543 8.43359 7.45314 8.35147ZM1.26327 6.99994C1.7351 7.91163 3.64645 11.1985 6.99729 11.1985C7.9267 11.2048 8.8408 10.9618 9.64438 10.4947L8.35682 9.20718C7.86027 9.51441 7.27449 9.64491 6.69448 9.57752C6.11446 9.51014 5.57421 9.24881 5.16131 8.83592C4.74842 8.42303 4.4871 7.88277 4.41971 7.30276C4.35232 6.72274 4.48282 6.13697 4.79005 5.64041L3.35855 4.2089C2.4954 5.00336 1.78523 5.94935 1.26327 6.99994Z",
      fill: "currentColor"
    })), /*#__PURE__*/React__namespace.createElement("defs", null, /*#__PURE__*/React__namespace.createElement("clipPath", {
      id: pathId
    }, /*#__PURE__*/React__namespace.createElement("rect", {
      width: "14",
      height: "14",
      fill: "white"
    }))));
  }));
  EyeSlashIcon.displayName = 'EyeSlashIcon';

  var FilterIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    var _React$useState = React__namespace.useState(inProps.id),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      pathId = _React$useState2[0],
      setPathId = _React$useState2[1];
    React__namespace.useEffect(function () {
      if (ObjectUtils.isEmpty(pathId)) {
        setPathId(UniqueComponentId('pr_icon_clip_'));
      }
    }, [pathId]);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("g", {
      clipPath: "url(#".concat(pathId, ")")
    }, /*#__PURE__*/React__namespace.createElement("path", {
      d: "M8.64708 14H5.35296C5.18981 13.9979 5.03395 13.9321 4.91858 13.8167C4.8032 13.7014 4.73745 13.5455 4.73531 13.3824V7L0.329431 0.98C0.259794 0.889466 0.217389 0.780968 0.20718 0.667208C0.19697 0.553448 0.219379 0.439133 0.271783 0.337647C0.324282 0.236453 0.403423 0.151519 0.500663 0.0920138C0.597903 0.0325088 0.709548 0.000692754 0.823548 0H13.1765C13.2905 0.000692754 13.4021 0.0325088 13.4994 0.0920138C13.5966 0.151519 13.6758 0.236453 13.7283 0.337647C13.7807 0.439133 13.8031 0.553448 13.7929 0.667208C13.7826 0.780968 13.7402 0.889466 13.6706 0.98L9.26472 7V13.3824C9.26259 13.5455 9.19683 13.7014 9.08146 13.8167C8.96609 13.9321 8.81022 13.9979 8.64708 14ZM5.97061 12.7647H8.02943V6.79412C8.02878 6.66289 8.07229 6.53527 8.15296 6.43177L11.9412 1.23529H2.05884L5.86355 6.43177C5.94422 6.53527 5.98773 6.66289 5.98708 6.79412L5.97061 12.7647Z",
      fill: "currentColor"
    })), /*#__PURE__*/React__namespace.createElement("defs", null, /*#__PURE__*/React__namespace.createElement("clipPath", {
      id: pathId
    }, /*#__PURE__*/React__namespace.createElement("rect", {
      width: "14",
      height: "14",
      fill: "white"
    }))));
  }));
  FilterIcon.displayName = 'FilterIcon';

  var FilterSlashIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    var _React$useState = React__namespace.useState(inProps.id),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      pathId = _React$useState2[0],
      setPathId = _React$useState2[1];
    React__namespace.useEffect(function () {
      if (ObjectUtils.isEmpty(pathId)) {
        setPathId(UniqueComponentId('pr_icon_clip_'));
      }
    }, [pathId]);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("g", {
      clipPath: "url(#".concat(pathId, ")")
    }, /*#__PURE__*/React__namespace.createElement("path", {
      fillRule: "evenodd",
      clipRule: "evenodd",
      d: "M13.4994 0.0920138C13.5967 0.151519 13.6758 0.236453 13.7283 0.337647C13.7807 0.439133 13.8031 0.553448 13.7929 0.667208C13.7827 0.780968 13.7403 0.889466 13.6707 0.98L11.406 4.06823C11.3099 4.19928 11.1656 4.28679 11.005 4.3115C10.8444 4.33621 10.6805 4.2961 10.5495 4.2C10.4184 4.1039 10.3309 3.95967 10.3062 3.79905C10.2815 3.63843 10.3216 3.47458 10.4177 3.34353L11.9412 1.23529H7.41184C7.24803 1.23529 7.09093 1.17022 6.97509 1.05439C6.85926 0.938558 6.79419 0.781457 6.79419 0.617647C6.79419 0.453837 6.85926 0.296736 6.97509 0.180905C7.09093 0.0650733 7.24803 0 7.41184 0H13.1765C13.2905 0.000692754 13.4022 0.0325088 13.4994 0.0920138ZM4.20008 0.181168H4.24126L13.2013 9.03411C13.3169 9.14992 13.3819 9.3069 13.3819 9.47058C13.3819 9.63426 13.3169 9.79124 13.2013 9.90705C13.1445 9.96517 13.0766 10.0112 13.0016 10.0423C12.9266 10.0735 12.846 10.0891 12.7648 10.0882C12.6836 10.0886 12.6032 10.0728 12.5283 10.0417C12.4533 10.0106 12.3853 9.96479 12.3283 9.90705L9.3142 6.92587L9.26479 6.99999V13.3823C9.26265 13.5455 9.19689 13.7014 9.08152 13.8167C8.96615 13.9321 8.81029 13.9979 8.64714 14H5.35302C5.18987 13.9979 5.03401 13.9321 4.91864 13.8167C4.80327 13.7014 4.73751 13.5455 4.73537 13.3823V6.99999L0.329492 1.02117C0.259855 0.930634 0.21745 0.822137 0.207241 0.708376C0.197031 0.594616 0.21944 0.480301 0.271844 0.378815C0.324343 0.277621 0.403484 0.192687 0.500724 0.133182C0.597964 0.073677 0.709609 0.041861 0.823609 0.0411682H3.86243C3.92448 0.0461551 3.9855 0.060022 4.04361 0.0823446C4.10037 0.10735 4.15311 0.140655 4.20008 0.181168ZM8.02949 6.79411C8.02884 6.66289 8.07235 6.53526 8.15302 6.43176L8.42478 6.05293L3.55773 1.23529H2.0589L5.84714 6.43176C5.92781 6.53526 5.97132 6.66289 5.97067 6.79411V12.7647H8.02949V6.79411Z",
      fill: "currentColor"
    })), /*#__PURE__*/React__namespace.createElement("defs", null, /*#__PURE__*/React__namespace.createElement("clipPath", {
      id: pathId
    }, /*#__PURE__*/React__namespace.createElement("rect", {
      width: "14",
      height: "14",
      fill: "white"
    }))));
  }));
  FilterSlashIcon.displayName = 'FilterSlashIcon';

  var InfoCircleIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    var _React$useState = React__namespace.useState(inProps.id),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      pathId = _React$useState2[0],
      setPathId = _React$useState2[1];
    React__namespace.useEffect(function () {
      if (ObjectUtils.isEmpty(pathId)) {
        setPathId(UniqueComponentId('pr_icon_clip_'));
      }
    }, [pathId]);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("g", {
      clipPath: "url(#".concat(pathId, ")")
    }, /*#__PURE__*/React__namespace.createElement("path", {
      fillRule: "evenodd",
      clipRule: "evenodd",
      d: "M3.11101 12.8203C4.26215 13.5895 5.61553 14 7 14C8.85652 14 10.637 13.2625 11.9497 11.9497C13.2625 10.637 14 8.85652 14 7C14 5.61553 13.5895 4.26215 12.8203 3.11101C12.0511 1.95987 10.9579 1.06266 9.67879 0.532846C8.3997 0.00303296 6.99224 -0.13559 5.63437 0.134506C4.2765 0.404603 3.02922 1.07129 2.05026 2.05026C1.07129 3.02922 0.404603 4.2765 0.134506 5.63437C-0.13559 6.99224 0.00303296 8.3997 0.532846 9.67879C1.06266 10.9579 1.95987 12.0511 3.11101 12.8203ZM3.75918 2.14976C4.71846 1.50879 5.84628 1.16667 7 1.16667C8.5471 1.16667 10.0308 1.78125 11.1248 2.87521C12.2188 3.96918 12.8333 5.45291 12.8333 7C12.8333 8.15373 12.4912 9.28154 11.8502 10.2408C11.2093 11.2001 10.2982 11.9478 9.23232 12.3893C8.16642 12.8308 6.99353 12.9463 5.86198 12.7212C4.73042 12.4962 3.69102 11.9406 2.87521 11.1248C2.05941 10.309 1.50384 9.26958 1.27876 8.13803C1.05367 7.00647 1.16919 5.83358 1.61071 4.76768C2.05222 3.70178 2.79989 2.79074 3.75918 2.14976ZM7.00002 4.8611C6.84594 4.85908 6.69873 4.79698 6.58977 4.68801C6.48081 4.57905 6.4187 4.43185 6.41669 4.27776V3.88888C6.41669 3.73417 6.47815 3.58579 6.58754 3.4764C6.69694 3.367 6.84531 3.30554 7.00002 3.30554C7.15473 3.30554 7.3031 3.367 7.4125 3.4764C7.52189 3.58579 7.58335 3.73417 7.58335 3.88888V4.27776C7.58134 4.43185 7.51923 4.57905 7.41027 4.68801C7.30131 4.79698 7.1541 4.85908 7.00002 4.8611ZM7.00002 10.6945C6.84594 10.6925 6.69873 10.6304 6.58977 10.5214C6.48081 10.4124 6.4187 10.2652 6.41669 10.1111V6.22225C6.41669 6.06754 6.47815 5.91917 6.58754 5.80977C6.69694 5.70037 6.84531 5.63892 7.00002 5.63892C7.15473 5.63892 7.3031 5.70037 7.4125 5.80977C7.52189 5.91917 7.58335 6.06754 7.58335 6.22225V10.1111C7.58134 10.2652 7.51923 10.4124 7.41027 10.5214C7.30131 10.6304 7.1541 10.6925 7.00002 10.6945Z",
      fill: "currentColor"
    })), /*#__PURE__*/React__namespace.createElement("defs", null, /*#__PURE__*/React__namespace.createElement("clipPath", {
      id: pathId
    }, /*#__PURE__*/React__namespace.createElement("rect", {
      width: "14",
      height: "14",
      fill: "white"
    }))));
  }));
  InfoCircleIcon.displayName = 'InfoCircleIcon';

  var MinusIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("path", {
      d: "M13.2222 7.77778H0.777778C0.571498 7.77778 0.373667 7.69584 0.227806 7.54998C0.0819442 7.40412 0 7.20629 0 7.00001C0 6.79373 0.0819442 6.5959 0.227806 6.45003C0.373667 6.30417 0.571498 6.22223 0.777778 6.22223H13.2222C13.4285 6.22223 13.6263 6.30417 13.7722 6.45003C13.9181 6.5959 14 6.79373 14 7.00001C14 7.20629 13.9181 7.40412 13.7722 7.54998C13.6263 7.69584 13.4285 7.77778 13.2222 7.77778Z",
      fill: "currentColor"
    }));
  }));
  MinusIcon.displayName = 'MinusIcon';

  var PencilIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    var _React$useState = React__namespace.useState(inProps.id),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      pathId = _React$useState2[0],
      setPathId = _React$useState2[1];
    React__namespace.useEffect(function () {
      if (ObjectUtils.isEmpty(pathId)) {
        setPathId(UniqueComponentId('pr_icon_clip_'));
      }
    }, [pathId]);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("g", {
      clipPath: "url(#".concat(pathId, ")")
    }, /*#__PURE__*/React__namespace.createElement("path", {
      d: "M0.609628 13.959C0.530658 13.9599 0.452305 13.9451 0.379077 13.9156C0.305849 13.8861 0.239191 13.8424 0.18294 13.787C0.118447 13.7234 0.0688234 13.6464 0.0376166 13.5614C0.00640987 13.4765 -0.00560954 13.3857 0.00241768 13.2956L0.25679 10.1501C0.267698 10.0041 0.331934 9.86709 0.437312 9.76516L9.51265 0.705715C10.0183 0.233014 10.6911 -0.0203041 11.3835 0.00127367C12.0714 0.00660201 12.7315 0.27311 13.2298 0.746671C13.7076 1.23651 13.9824 1.88848 13.9992 2.57201C14.0159 3.25554 13.7733 3.92015 13.32 4.4327L4.23648 13.5331C4.13482 13.6342 4.0017 13.6978 3.85903 13.7133L0.667067 14L0.609628 13.959ZM1.43018 10.4696L1.25787 12.714L3.50619 12.5092L12.4502 3.56444C12.6246 3.35841 12.7361 3.10674 12.7714 2.83933C12.8067 2.57193 12.7644 2.30002 12.6495 2.05591C12.5346 1.8118 12.3519 1.60575 12.1231 1.46224C11.8943 1.31873 11.6291 1.2438 11.3589 1.24633C11.1813 1.23508 11.0033 1.25975 10.8355 1.31887C10.6677 1.37798 10.5136 1.47033 10.3824 1.59036L1.43018 10.4696Z",
      fill: "currentColor"
    })), /*#__PURE__*/React__namespace.createElement("defs", null, /*#__PURE__*/React__namespace.createElement("clipPath", {
      id: pathId
    }, /*#__PURE__*/React__namespace.createElement("rect", {
      width: "14",
      height: "14",
      fill: "white"
    }))));
  }));
  PencilIcon.displayName = 'PencilIcon';

  var PlusIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    var _React$useState = React__namespace.useState(inProps.id),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      pathId = _React$useState2[0],
      setPathId = _React$useState2[1];
    React__namespace.useEffect(function () {
      if (ObjectUtils.isEmpty(pathId)) {
        setPathId(UniqueComponentId('pr_icon_clip_'));
      }
    }, [pathId]);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("g", {
      clipPath: "url(#".concat(pathId, ")")
    }, /*#__PURE__*/React__namespace.createElement("path", {
      d: "M7.67742 6.32258V0.677419C7.67742 0.497757 7.60605 0.325452 7.47901 0.198411C7.35197 0.0713707 7.17966 0 7 0C6.82034 0 6.64803 0.0713707 6.52099 0.198411C6.39395 0.325452 6.32258 0.497757 6.32258 0.677419V6.32258H0.677419C0.497757 6.32258 0.325452 6.39395 0.198411 6.52099C0.0713707 6.64803 0 6.82034 0 7C0 7.17966 0.0713707 7.35197 0.198411 7.47901C0.325452 7.60605 0.497757 7.67742 0.677419 7.67742H6.32258V13.3226C6.32492 13.5015 6.39704 13.6725 6.52358 13.799C6.65012 13.9255 6.82106 13.9977 7 14C7.17966 14 7.35197 13.9286 7.47901 13.8016C7.60605 13.6745 7.67742 13.5022 7.67742 13.3226V7.67742H13.3226C13.5022 7.67742 13.6745 7.60605 13.8016 7.47901C13.9286 7.35197 14 7.17966 14 7C13.9977 6.82106 13.9255 6.65012 13.799 6.52358C13.6725 6.39704 13.5015 6.32492 13.3226 6.32258H7.67742Z",
      fill: "currentColor"
    })), /*#__PURE__*/React__namespace.createElement("defs", null, /*#__PURE__*/React__namespace.createElement("clipPath", {
      id: pathId
    }, /*#__PURE__*/React__namespace.createElement("rect", {
      width: "14",
      height: "14",
      fill: "white"
    }))));
  }));
  PlusIcon.displayName = 'PlusIcon';

  var RefreshIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    var _React$useState = React__namespace.useState(inProps.id),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      pathId = _React$useState2[0],
      setPathId = _React$useState2[1];
    React__namespace.useEffect(function () {
      if (ObjectUtils.isEmpty(pathId)) {
        setPathId(UniqueComponentId('pr_icon_clip_'));
      }
    }, [pathId]);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("g", {
      clipPath: "url(#".concat(pathId, ")")
    }, /*#__PURE__*/React__namespace.createElement("path", {
      fillRule: "evenodd",
      clipRule: "evenodd",
      d: "M6.77051 5.96336C6.84324 5.99355 6.92127 6.00891 7.00002 6.00854C7.07877 6.00891 7.1568 5.99355 7.22953 5.96336C7.30226 5.93317 7.36823 5.88876 7.42357 5.83273L9.82101 3.43529C9.93325 3.32291 9.99629 3.17058 9.99629 3.01175C9.99629 2.85292 9.93325 2.70058 9.82101 2.5882L7.42357 0.190763C7.3687 0.131876 7.30253 0.0846451 7.22901 0.0518865C7.15549 0.019128 7.07612 0.00151319 6.99564 9.32772e-05C6.91517 -0.00132663 6.83523 0.0134773 6.7606 0.0436218C6.68597 0.0737664 6.61817 0.118634 6.56126 0.175548C6.50435 0.232462 6.45948 0.300257 6.42933 0.374888C6.39919 0.449519 6.38439 0.529456 6.38581 0.609933C6.38722 0.690409 6.40484 0.769775 6.4376 0.843296C6.47036 0.916817 6.51759 0.982986 6.57647 1.03786L7.95103 2.41241H6.99998C5.46337 2.41241 3.98969 3.02283 2.90314 4.10938C1.81659 5.19593 1.20618 6.66961 1.20618 8.20622C1.20618 9.74283 1.81659 11.2165 2.90314 12.3031C3.98969 13.3896 5.46337 14 6.99998 14C8.53595 13.9979 10.0084 13.3868 11.0945 12.3007C12.1806 11.2146 12.7917 9.74218 12.7938 8.20622C12.7938 8.04726 12.7306 7.89481 12.6182 7.78241C12.5058 7.67001 12.3534 7.60686 12.1944 7.60686C12.0355 7.60686 11.883 7.67001 11.7706 7.78241C11.6582 7.89481 11.5951 8.04726 11.5951 8.20622C11.5951 9.11504 11.3256 10.0035 10.8207 10.7591C10.3157 11.5148 9.59809 12.1037 8.75845 12.4515C7.9188 12.7993 6.99489 12.8903 6.10353 12.713C5.21217 12.5357 4.3934 12.0981 3.75077 11.4554C3.10813 10.8128 2.67049 9.99404 2.49319 9.10268C2.31589 8.21132 2.40688 7.2874 2.75468 6.44776C3.10247 5.60811 3.69143 4.89046 4.44709 4.38554C5.20275 3.88063 6.09116 3.61113 6.99998 3.61113H7.95098L6.57647 4.98564C6.46423 5.09802 6.40119 5.25035 6.40119 5.40918C6.40119 5.56801 6.46423 5.72035 6.57647 5.83273C6.63181 5.88876 6.69778 5.93317 6.77051 5.96336Z",
      fill: "currentColor"
    })), /*#__PURE__*/React__namespace.createElement("defs", null, /*#__PURE__*/React__namespace.createElement("clipPath", {
      id: pathId
    }, /*#__PURE__*/React__namespace.createElement("rect", {
      width: "14",
      height: "14",
      fill: "white"
    }))));
  }));
  RefreshIcon.displayName = 'RefreshIcon';

  var SearchIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    var _React$useState = React__namespace.useState(inProps.id),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      pathId = _React$useState2[0],
      setPathId = _React$useState2[1];
    React__namespace.useEffect(function () {
      if (ObjectUtils.isEmpty(pathId)) {
        setPathId(UniqueComponentId('pr_icon_clip_'));
      }
    }, [pathId]);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("g", {
      clipPath: "url(#".concat(pathId, ")")
    }, /*#__PURE__*/React__namespace.createElement("path", {
      fillRule: "evenodd",
      clipRule: "evenodd",
      d: "M2.67602 11.0265C3.6661 11.688 4.83011 12.0411 6.02086 12.0411C6.81149 12.0411 7.59438 11.8854 8.32483 11.5828C8.87005 11.357 9.37808 11.0526 9.83317 10.6803L12.9769 13.8241C13.0323 13.8801 13.0983 13.9245 13.171 13.9548C13.2438 13.985 13.3219 14.0003 13.4007 14C13.4795 14.0003 13.5575 13.985 13.6303 13.9548C13.7031 13.9245 13.7691 13.8801 13.8244 13.8241C13.9367 13.7116 13.9998 13.5592 13.9998 13.4003C13.9998 13.2414 13.9367 13.089 13.8244 12.9765L10.6807 9.8328C11.053 9.37773 11.3573 8.86972 11.5831 8.32452C11.8857 7.59408 12.0414 6.81119 12.0414 6.02056C12.0414 4.8298 11.6883 3.66579 11.0268 2.67572C10.3652 1.68564 9.42494 0.913972 8.32483 0.45829C7.22472 0.00260857 6.01418 -0.116618 4.84631 0.115686C3.67844 0.34799 2.60568 0.921393 1.76369 1.76338C0.921698 2.60537 0.348296 3.67813 0.115991 4.84601C-0.116313 6.01388 0.00291375 7.22441 0.458595 8.32452C0.914277 9.42464 1.68595 10.3649 2.67602 11.0265ZM3.35565 2.0158C4.14456 1.48867 5.07206 1.20731 6.02086 1.20731C7.29317 1.20731 8.51338 1.71274 9.41304 2.6124C10.3127 3.51206 10.8181 4.73226 10.8181 6.00457C10.8181 6.95337 10.5368 7.88088 10.0096 8.66978C9.48251 9.45868 8.73328 10.0736 7.85669 10.4367C6.98011 10.7997 6.01554 10.8947 5.08496 10.7096C4.15439 10.5245 3.2996 10.0676 2.62869 9.39674C1.95778 8.72583 1.50089 7.87104 1.31579 6.94046C1.13068 6.00989 1.22568 5.04532 1.58878 4.16874C1.95187 3.29215 2.56675 2.54292 3.35565 2.0158Z",
      fill: "currentColor"
    })), /*#__PURE__*/React__namespace.createElement("defs", null, /*#__PURE__*/React__namespace.createElement("clipPath", {
      id: pathId
    }, /*#__PURE__*/React__namespace.createElement("rect", {
      width: "14",
      height: "14",
      fill: "white"
    }))));
  }));
  SearchIcon.displayName = 'SearchIcon';

  var SearchMinusIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    var _React$useState = React__namespace.useState(inProps.id),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      pathId = _React$useState2[0],
      setPathId = _React$useState2[1];
    React__namespace.useEffect(function () {
      if (ObjectUtils.isEmpty(pathId)) {
        setPathId(UniqueComponentId('pr_icon_clip_'));
      }
    }, [pathId]);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("g", {
      clipPath: "url(#".concat(pathId, ")")
    }, /*#__PURE__*/React__namespace.createElement("path", {
      fillRule: "evenodd",
      clipRule: "evenodd",
      d: "M6.0208 12.0411C4.83005 12.0411 3.66604 11.688 2.67596 11.0265C1.68589 10.3649 0.914216 9.42464 0.458534 8.32452C0.00285271 7.22441 -0.116374 6.01388 0.11593 4.84601C0.348235 3.67813 0.921637 2.60537 1.76363 1.76338C2.60562 0.921393 3.67838 0.34799 4.84625 0.115686C6.01412 -0.116618 7.22466 0.00260857 8.32477 0.45829C9.42488 0.913972 10.3652 1.68564 11.0267 2.67572C11.6883 3.66579 12.0414 4.8298 12.0414 6.02056C12.0395 7.41563 11.5542 8.76029 10.6783 9.8305L13.8244 12.9765C13.9367 13.089 13.9997 13.2414 13.9997 13.4003C13.9997 13.5592 13.9367 13.7116 13.8244 13.8241C13.769 13.8801 13.703 13.9245 13.6302 13.9548C13.5575 13.985 13.4794 14.0003 13.4006 14C13.3218 14.0003 13.2437 13.985 13.171 13.9548C13.0982 13.9245 13.0322 13.8801 12.9768 13.8241L9.83082 10.678C8.76059 11.5539 7.4159 12.0393 6.0208 12.0411ZM6.0208 1.20731C5.07199 1.20731 4.14449 1.48867 3.35559 2.0158C2.56669 2.54292 1.95181 3.29215 1.58872 4.16874C1.22562 5.04532 1.13062 6.00989 1.31572 6.94046C1.50083 7.87104 1.95772 8.72583 2.62863 9.39674C3.29954 10.0676 4.15433 10.5245 5.0849 10.7096C6.01548 10.8947 6.98005 10.7997 7.85663 10.4367C8.73322 10.0736 9.48244 9.45868 10.0096 8.66978C10.5367 7.88088 10.8181 6.95337 10.8181 6.00457C10.8181 4.73226 10.3126 3.51206 9.41297 2.6124C8.51331 1.71274 7.29311 1.20731 6.0208 1.20731ZM4.00591 6.60422H8.00362C8.16266 6.60422 8.31518 6.54104 8.42764 6.42859C8.5401 6.31613 8.60328 6.1636 8.60328 6.00456C8.60328 5.84553 8.5401 5.693 8.42764 5.58054C8.31518 5.46809 8.16266 5.40491 8.00362 5.40491H4.00591C3.84687 5.40491 3.69434 5.46809 3.58189 5.58054C3.46943 5.693 3.40625 5.84553 3.40625 6.00456C3.40625 6.1636 3.46943 6.31613 3.58189 6.42859C3.69434 6.54104 3.84687 6.60422 4.00591 6.60422Z",
      fill: "currentColor"
    })), /*#__PURE__*/React__namespace.createElement("defs", null, /*#__PURE__*/React__namespace.createElement("clipPath", {
      id: pathId
    }, /*#__PURE__*/React__namespace.createElement("rect", {
      width: "14",
      height: "14",
      fill: "white"
    }))));
  }));
  SearchMinusIcon.displayName = 'SearchMinusIcon';

  var SearchPlusIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    var _React$useState = React__namespace.useState(inProps.id),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      pathId = _React$useState2[0],
      setPathId = _React$useState2[1];
    React__namespace.useEffect(function () {
      if (ObjectUtils.isEmpty(pathId)) {
        setPathId(UniqueComponentId('pr_icon_clip_'));
      }
    }, [pathId]);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("g", {
      clipPath: "url(#".concat(pathId, ")")
    }, /*#__PURE__*/React__namespace.createElement("path", {
      fillRule: "evenodd",
      clipRule: "evenodd",
      d: "M2.67596 11.0265C3.66604 11.688 4.83005 12.0411 6.0208 12.0411C6.81143 12.0411 7.59432 11.8854 8.32477 11.5828C8.86999 11.357 9.37802 11.0526 9.83311 10.6803L12.9768 13.8241C13.0322 13.8801 13.0982 13.9245 13.171 13.9548C13.2437 13.985 13.3218 14.0003 13.4006 14C13.4794 14.0003 13.5575 13.985 13.6302 13.9548C13.703 13.9245 13.769 13.8801 13.8244 13.8241C13.9367 13.7116 13.9997 13.5592 13.9997 13.4003C13.9997 13.2414 13.9367 13.089 13.8244 12.9765L10.6806 9.8328C11.0529 9.37773 11.3572 8.86972 11.5831 8.32452C11.8856 7.59408 12.0414 6.81119 12.0414 6.02056C12.0414 4.8298 11.6883 3.66579 11.0267 2.67572C10.3652 1.68564 9.42488 0.913972 8.32477 0.45829C7.22466 0.00260857 6.01412 -0.116618 4.84625 0.115686C3.67838 0.34799 2.60562 0.921393 1.76363 1.76338C0.921637 2.60537 0.348235 3.67813 0.11593 4.84601C-0.116374 6.01388 0.00285271 7.22441 0.458534 8.32452C0.914216 9.42464 1.68589 10.3649 2.67596 11.0265ZM3.35559 2.0158C4.14449 1.48867 5.07199 1.20731 6.0208 1.20731C7.29311 1.20731 8.51331 1.71274 9.41297 2.6124C10.3126 3.51206 10.8181 4.73226 10.8181 6.00457C10.8181 6.95337 10.5367 7.88088 10.0096 8.66978C9.48244 9.45868 8.73322 10.0736 7.85663 10.4367C6.98005 10.7997 6.01548 10.8947 5.0849 10.7096C4.15433 10.5245 3.29954 10.0676 2.62863 9.39674C1.95772 8.72583 1.50083 7.87104 1.31572 6.94046C1.13062 6.00989 1.22562 5.04532 1.58872 4.16874C1.95181 3.29215 2.56669 2.54292 3.35559 2.0158ZM6.00481 8.60309C5.84641 8.60102 5.69509 8.53718 5.58308 8.42517C5.47107 8.31316 5.40722 8.16183 5.40515 8.00344V6.60422H4.00591C3.84687 6.60422 3.69434 6.54104 3.58189 6.42859C3.46943 6.31613 3.40625 6.1636 3.40625 6.00456C3.40625 5.84553 3.46943 5.693 3.58189 5.58054C3.69434 5.46809 3.84687 5.40491 4.00591 5.40491H5.40515V4.00572C5.40515 3.84668 5.46833 3.69416 5.58079 3.5817C5.69324 3.46924 5.84577 3.40607 6.00481 3.40607C6.16385 3.40607 6.31637 3.46924 6.42883 3.5817C6.54129 3.69416 6.60447 3.84668 6.60447 4.00572V5.40491H8.00362C8.16266 5.40491 8.31518 5.46809 8.42764 5.58054C8.5401 5.693 8.60328 5.84553 8.60328 6.00456C8.60328 6.1636 8.5401 6.31613 8.42764 6.42859C8.31518 6.54104 8.16266 6.60422 8.00362 6.60422H6.60447V8.00344C6.60239 8.16183 6.53855 8.31316 6.42654 8.42517C6.31453 8.53718 6.1632 8.60102 6.00481 8.60309Z",
      fill: "currentColor"
    })), /*#__PURE__*/React__namespace.createElement("defs", null, /*#__PURE__*/React__namespace.createElement("clipPath", {
      id: pathId
    }, /*#__PURE__*/React__namespace.createElement("rect", {
      width: "14",
      height: "14",
      fill: "white"
    }))));
  }));
  SearchPlusIcon.displayName = 'SearchPlusIcon';

  var SortAltIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    var _React$useState = React__namespace.useState(inProps.id),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      pathId = _React$useState2[0],
      setPathId = _React$useState2[1];
    React__namespace.useEffect(function () {
      if (ObjectUtils.isEmpty(pathId)) {
        setPathId(UniqueComponentId('pr_icon_clip_'));
      }
    }, [pathId]);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("g", {
      clipPath: "url(#".concat(pathId, ")")
    }, /*#__PURE__*/React__namespace.createElement("path", {
      d: "M5.64515 3.61291C5.47353 3.61291 5.30192 3.54968 5.16644 3.4142L3.38708 1.63484L1.60773 3.4142C1.34579 3.67613 0.912244 3.67613 0.650309 3.4142C0.388374 3.15226 0.388374 2.71871 0.650309 2.45678L2.90837 0.198712C3.17031 -0.0632236 3.60386 -0.0632236 3.86579 0.198712L6.12386 2.45678C6.38579 2.71871 6.38579 3.15226 6.12386 3.4142C5.98837 3.54968 5.81676 3.61291 5.64515 3.61291Z",
      fill: "currentColor"
    }), /*#__PURE__*/React__namespace.createElement("path", {
      d: "M3.38714 14C3.01681 14 2.70972 13.6929 2.70972 13.3226V0.677419C2.70972 0.307097 3.01681 0 3.38714 0C3.75746 0 4.06456 0.307097 4.06456 0.677419V13.3226C4.06456 13.6929 3.75746 14 3.38714 14Z",
      fill: "currentColor"
    }), /*#__PURE__*/React__namespace.createElement("path", {
      d: "M10.6129 14C10.4413 14 10.2697 13.9368 10.1342 13.8013L7.87611 11.5432C7.61418 11.2813 7.61418 10.8477 7.87611 10.5858C8.13805 10.3239 8.5716 10.3239 8.83353 10.5858L10.6129 12.3652L12.3922 10.5858C12.6542 10.3239 13.0877 10.3239 13.3497 10.5858C13.6116 10.8477 13.6116 11.2813 13.3497 11.5432L11.0916 13.8013C10.9561 13.9368 10.7845 14 10.6129 14Z",
      fill: "currentColor"
    }), /*#__PURE__*/React__namespace.createElement("path", {
      d: "M10.6129 14C10.2426 14 9.93552 13.6929 9.93552 13.3226V0.677419C9.93552 0.307097 10.2426 0 10.6129 0C10.9833 0 11.2904 0.307097 11.2904 0.677419V13.3226C11.2904 13.6929 10.9832 14 10.6129 14Z",
      fill: "currentColor"
    })), /*#__PURE__*/React__namespace.createElement("defs", null, /*#__PURE__*/React__namespace.createElement("clipPath", {
      id: pathId
    }, /*#__PURE__*/React__namespace.createElement("rect", {
      width: "14",
      height: "14",
      fill: "white"
    }))));
  }));
  SortAltIcon.displayName = 'SortAltIcon';

  var SortAmountDownIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    var _React$useState = React__namespace.useState(inProps.id),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      pathId = _React$useState2[0],
      setPathId = _React$useState2[1];
    React__namespace.useEffect(function () {
      if (ObjectUtils.isEmpty(pathId)) {
        setPathId(UniqueComponentId('pr_icon_clip_'));
      }
    }, [pathId]);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("g", {
      clipPath: "url(#".concat(pathId, ")")
    }, /*#__PURE__*/React__namespace.createElement("path", {
      d: "M2.59836 13.2009C2.44634 13.2009 2.29432 13.1449 2.1743 13.0248L0.174024 11.0246C-0.0580081 10.7925 -0.0580081 10.4085 0.174024 10.1764C0.406057 9.94441 0.79011 9.94441 1.02214 10.1764L2.59836 11.7527L4.17458 10.1764C4.40662 9.94441 4.79067 9.94441 5.0227 10.1764C5.25473 10.4085 5.25473 10.7925 5.0227 11.0246L3.02242 13.0248C2.90241 13.1449 2.75038 13.2009 2.59836 13.2009Z",
      fill: "currentColor"
    }), /*#__PURE__*/React__namespace.createElement("path", {
      d: "M2.59836 13.2009C2.27032 13.2009 1.99833 12.9288 1.99833 12.6008V1.39922C1.99833 1.07117 2.27036 0.799133 2.59841 0.799133C2.92646 0.799133 3.19849 1.07117 3.19849 1.39922V12.6008C3.19849 12.9288 2.92641 13.2009 2.59836 13.2009Z",
      fill: "currentColor"
    }), /*#__PURE__*/React__namespace.createElement("path", {
      d: "M13.3999 11.2006H6.99902C6.67098 11.2006 6.39894 10.9285 6.39894 10.6005C6.39894 10.2725 6.67098 10.0004 6.99902 10.0004H13.3999C13.728 10.0004 14 10.2725 14 10.6005C14 10.9285 13.728 11.2006 13.3999 11.2006Z",
      fill: "currentColor"
    }), /*#__PURE__*/React__namespace.createElement("path", {
      d: "M10.1995 6.39991H6.99902C6.67098 6.39991 6.39894 6.12788 6.39894 5.79983C6.39894 5.47179 6.67098 5.19975 6.99902 5.19975H10.1995C10.5275 5.19975 10.7996 5.47179 10.7996 5.79983C10.7996 6.12788 10.5275 6.39991 10.1995 6.39991Z",
      fill: "currentColor"
    }), /*#__PURE__*/React__namespace.createElement("path", {
      d: "M8.59925 3.99958H6.99902C6.67098 3.99958 6.39894 3.72754 6.39894 3.3995C6.39894 3.07145 6.67098 2.79941 6.99902 2.79941H8.59925C8.92729 2.79941 9.19933 3.07145 9.19933 3.3995C9.19933 3.72754 8.92729 3.99958 8.59925 3.99958Z",
      fill: "currentColor"
    }), /*#__PURE__*/React__namespace.createElement("path", {
      d: "M11.7997 8.80025H6.99902C6.67098 8.80025 6.39894 8.52821 6.39894 8.20017C6.39894 7.87212 6.67098 7.60008 6.99902 7.60008H11.7997C12.1277 7.60008 12.3998 7.87212 12.3998 8.20017C12.3998 8.52821 12.1277 8.80025 11.7997 8.80025Z",
      fill: "currentColor"
    })), /*#__PURE__*/React__namespace.createElement("defs", null, /*#__PURE__*/React__namespace.createElement("clipPath", {
      id: pathId
    }, /*#__PURE__*/React__namespace.createElement("rect", {
      width: "14",
      height: "14",
      fill: "white"
    }))));
  }));
  SortAmountDownIcon.displayName = 'SortAmountDownIcon';

  var SortAmountUpAltIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    var _React$useState = React__namespace.useState(inProps.id),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      pathId = _React$useState2[0],
      setPathId = _React$useState2[1];
    React__namespace.useEffect(function () {
      if (ObjectUtils.isEmpty(pathId)) {
        setPathId(UniqueComponentId('pr_icon_clip_'));
      }
    }, [pathId]);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("g", {
      clipPath: "url(#".concat(pathId, ")")
    }, /*#__PURE__*/React__namespace.createElement("path", {
      d: "M4.59864 3.99958C4.44662 3.99958 4.2946 3.94357 4.17458 3.82356L2.59836 2.24734L1.02214 3.82356C0.79011 4.05559 0.406057 4.05559 0.174024 3.82356C-0.0580081 3.59152 -0.0580081 3.20747 0.174024 2.97544L2.1743 0.97516C2.40634 0.743127 2.79039 0.743127 3.02242 0.97516L5.0227 2.97544C5.25473 3.20747 5.25473 3.59152 5.0227 3.82356C4.90268 3.94357 4.75066 3.99958 4.59864 3.99958Z",
      fill: "currentColor"
    }), /*#__PURE__*/React__namespace.createElement("path", {
      d: "M2.59841 13.2009C2.27036 13.2009 1.99833 12.9288 1.99833 12.6008V1.39922C1.99833 1.07117 2.27036 0.799133 2.59841 0.799133C2.92646 0.799133 3.19849 1.07117 3.19849 1.39922V12.6008C3.19849 12.9288 2.92646 13.2009 2.59841 13.2009Z",
      fill: "currentColor"
    }), /*#__PURE__*/React__namespace.createElement("path", {
      d: "M13.3999 11.2006H6.99902C6.67098 11.2006 6.39894 10.9285 6.39894 10.6005C6.39894 10.2725 6.67098 10.0004 6.99902 10.0004H13.3999C13.728 10.0004 14 10.2725 14 10.6005C14 10.9285 13.728 11.2006 13.3999 11.2006Z",
      fill: "currentColor"
    }), /*#__PURE__*/React__namespace.createElement("path", {
      d: "M10.1995 6.39991H6.99902C6.67098 6.39991 6.39894 6.12788 6.39894 5.79983C6.39894 5.47179 6.67098 5.19975 6.99902 5.19975H10.1995C10.5275 5.19975 10.7996 5.47179 10.7996 5.79983C10.7996 6.12788 10.5275 6.39991 10.1995 6.39991Z",
      fill: "currentColor"
    }), /*#__PURE__*/React__namespace.createElement("path", {
      d: "M8.59925 3.99958H6.99902C6.67098 3.99958 6.39894 3.72754 6.39894 3.3995C6.39894 3.07145 6.67098 2.79941 6.99902 2.79941H8.59925C8.92729 2.79941 9.19933 3.07145 9.19933 3.3995C9.19933 3.72754 8.92729 3.99958 8.59925 3.99958Z",
      fill: "currentColor"
    }), /*#__PURE__*/React__namespace.createElement("path", {
      d: "M11.7997 8.80025H6.99902C6.67098 8.80025 6.39894 8.52821 6.39894 8.20017C6.39894 7.87212 6.67098 7.60008 6.99902 7.60008H11.7997C12.1277 7.60008 12.3998 7.87212 12.3998 8.20017C12.3998 8.52821 12.1277 8.80025 11.7997 8.80025Z",
      fill: "currentColor"
    })), /*#__PURE__*/React__namespace.createElement("defs", null, /*#__PURE__*/React__namespace.createElement("clipPath", {
      id: pathId
    }, /*#__PURE__*/React__namespace.createElement("rect", {
      width: "14",
      height: "14",
      fill: "white"
    }))));
  }));
  SortAmountUpAltIcon.displayName = 'SortAmountUpAltIcon';

  var SpinnerIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    var _React$useState = React__namespace.useState(inProps.id),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      pathId = _React$useState2[0],
      setPathId = _React$useState2[1];
    React__namespace.useEffect(function () {
      if (ObjectUtils.isEmpty(pathId)) {
        setPathId(UniqueComponentId('pr_icon_clip_'));
      }
    }, [pathId]);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("g", {
      clipPath: "url(#".concat(pathId, ")")
    }, /*#__PURE__*/React__namespace.createElement("path", {
      d: "M6.99701 14C5.85441 13.999 4.72939 13.7186 3.72012 13.1832C2.71084 12.6478 1.84795 11.8737 1.20673 10.9284C0.565504 9.98305 0.165424 8.89526 0.041387 7.75989C-0.0826496 6.62453 0.073125 5.47607 0.495122 4.4147C0.917119 3.35333 1.59252 2.4113 2.46241 1.67077C3.33229 0.930247 4.37024 0.413729 5.4857 0.166275C6.60117 -0.0811796 7.76026 -0.0520535 8.86188 0.251112C9.9635 0.554278 10.9742 1.12227 11.8057 1.90555C11.915 2.01493 11.9764 2.16319 11.9764 2.31778C11.9764 2.47236 11.915 2.62062 11.8057 2.73C11.7521 2.78503 11.688 2.82877 11.6171 2.85864C11.5463 2.8885 11.4702 2.90389 11.3933 2.90389C11.3165 2.90389 11.2404 2.8885 11.1695 2.85864C11.0987 2.82877 11.0346 2.78503 10.9809 2.73C9.9998 1.81273 8.73246 1.26138 7.39226 1.16876C6.05206 1.07615 4.72086 1.44794 3.62279 2.22152C2.52471 2.99511 1.72683 4.12325 1.36345 5.41602C1.00008 6.70879 1.09342 8.08723 1.62775 9.31926C2.16209 10.5513 3.10478 11.5617 4.29713 12.1803C5.48947 12.7989 6.85865 12.988 8.17414 12.7157C9.48963 12.4435 10.6711 11.7264 11.5196 10.6854C12.3681 9.64432 12.8319 8.34282 12.8328 7C12.8328 6.84529 12.8943 6.69692 13.0038 6.58752C13.1132 6.47812 13.2616 6.41667 13.4164 6.41667C13.5712 6.41667 13.7196 6.47812 13.8291 6.58752C13.9385 6.69692 14 6.84529 14 7C14 8.85651 13.2622 10.637 11.9489 11.9497C10.6356 13.2625 8.85432 14 6.99701 14Z",
      fill: "currentColor"
    })), /*#__PURE__*/React__namespace.createElement("defs", null, /*#__PURE__*/React__namespace.createElement("clipPath", {
      id: pathId
    }, /*#__PURE__*/React__namespace.createElement("rect", {
      width: "14",
      height: "14",
      fill: "white"
    }))));
  }));
  SpinnerIcon.displayName = 'SpinnerIcon';

  var StarIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    var _React$useState = React__namespace.useState(inProps.id),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      pathId = _React$useState2[0],
      setPathId = _React$useState2[1];
    React__namespace.useEffect(function () {
      if (ObjectUtils.isEmpty(pathId)) {
        setPathId(UniqueComponentId('pr_icon_clip_'));
      }
    }, [pathId]);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("g", {
      clipPath: "url(#".concat(pathId, ")")
    }, /*#__PURE__*/React__namespace.createElement("path", {
      d: "M10.9741 13.6721C10.8806 13.6719 10.7886 13.6483 10.7066 13.6033L7.00002 11.6545L3.29345 13.6033C3.19926 13.6539 3.09281 13.6771 2.98612 13.6703C2.87943 13.6636 2.77676 13.6271 2.6897 13.5651C2.60277 13.5014 2.53529 13.4147 2.4948 13.3148C2.45431 13.215 2.44241 13.1058 2.46042 12.9995L3.17881 8.87264L0.167699 5.95324C0.0922333 5.8777 0.039368 5.78258 0.0150625 5.67861C-0.00924303 5.57463 -0.00402231 5.46594 0.030136 5.36477C0.0621323 5.26323 0.122141 5.17278 0.203259 5.10383C0.284377 5.03488 0.383311 4.99023 0.488681 4.97501L4.63087 4.37126L6.48797 0.618832C6.54083 0.530159 6.61581 0.456732 6.70556 0.405741C6.79532 0.35475 6.89678 0.327942 7.00002 0.327942C7.10325 0.327942 7.20471 0.35475 7.29447 0.405741C7.38422 0.456732 7.4592 0.530159 7.51206 0.618832L9.36916 4.37126L13.5114 4.97501C13.6167 4.99023 13.7157 5.03488 13.7968 5.10383C13.8779 5.17278 13.9379 5.26323 13.9699 5.36477C14.0041 5.46594 14.0093 5.57463 13.985 5.67861C13.9607 5.78258 13.9078 5.8777 13.8323 5.95324L10.8212 8.87264L11.532 12.9995C11.55 13.1058 11.5381 13.215 11.4976 13.3148C11.4571 13.4147 11.3896 13.5014 11.3027 13.5651C11.2059 13.632 11.0917 13.6692 10.9741 13.6721ZM7.00002 10.4393C7.09251 10.4404 7.18371 10.4613 7.2675 10.5005L10.2098 12.029L9.65193 8.75036C9.6368 8.6584 9.64343 8.56418 9.6713 8.47526C9.69918 8.38633 9.74751 8.30518 9.81242 8.23832L12.1969 5.94559L8.90298 5.45648C8.81188 5.44198 8.72555 5.406 8.65113 5.35152C8.57671 5.29703 8.51633 5.2256 8.475 5.14314L7.00002 2.1626L5.52503 5.15078C5.4837 5.23324 5.42332 5.30467 5.3489 5.35916C5.27448 5.41365 5.18815 5.44963 5.09705 5.46412L1.80318 5.94559L4.18761 8.23832C4.25252 8.30518 4.30085 8.38633 4.32873 8.47526C4.3566 8.56418 4.36323 8.6584 4.3481 8.75036L3.7902 12.0519L6.73253 10.5234C6.81451 10.4762 6.9058 10.4475 7.00002 10.4393Z",
      fill: "currentColor"
    })), /*#__PURE__*/React__namespace.createElement("defs", null, /*#__PURE__*/React__namespace.createElement("clipPath", {
      id: pathId
    }, /*#__PURE__*/React__namespace.createElement("rect", {
      width: "14",
      height: "14",
      fill: "white"
    }))));
  }));
  StarIcon.displayName = 'StarIcon';

  var StarFillIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    var _React$useState = React__namespace.useState(inProps.id),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      pathId = _React$useState2[0],
      setPathId = _React$useState2[1];
    React__namespace.useEffect(function () {
      if (ObjectUtils.isEmpty(pathId)) {
        setPathId(UniqueComponentId('pr_icon_clip_'));
      }
    }, [pathId]);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("g", {
      clipPath: "url(#".concat(pathId, ")")
    }, /*#__PURE__*/React__namespace.createElement("path", {
      d: "M13.9718 5.36453C13.9398 5.26298 13.8798 5.17252 13.7986 5.10356C13.7175 5.0346 13.6186 4.98994 13.5132 4.97472L9.37043 4.37088L7.51307 0.617955C7.46021 0.529271 7.38522 0.455834 7.29545 0.404836C7.20568 0.353838 7.1042 0.327026 7.00096 0.327026C6.89771 0.327026 6.79624 0.353838 6.70647 0.404836C6.6167 0.455834 6.54171 0.529271 6.48885 0.617955L4.63149 4.37088L0.488746 4.97472C0.383363 4.98994 0.284416 5.0346 0.203286 5.10356C0.122157 5.17252 0.0621407 5.26298 0.03014 5.36453C-0.00402286 5.46571 -0.00924428 5.57442 0.0150645 5.67841C0.0393733 5.7824 0.0922457 5.87753 0.167722 5.95308L3.17924 8.87287L2.4684 13.0003C2.45038 13.1066 2.46229 13.2158 2.50278 13.3157C2.54328 13.4156 2.61077 13.5022 2.6977 13.5659C2.78477 13.628 2.88746 13.6644 2.99416 13.6712C3.10087 13.678 3.20733 13.6547 3.30153 13.6042L7.00096 11.6551L10.708 13.6042C10.79 13.6491 10.882 13.6728 10.9755 13.673C11.0958 13.6716 11.2129 13.6343 11.3119 13.5659C11.3988 13.5022 11.4663 13.4156 11.5068 13.3157C11.5473 13.2158 11.5592 13.1066 11.5412 13.0003L10.8227 8.87287L13.8266 5.95308C13.9033 5.87835 13.9577 5.7836 13.9833 5.67957C14.009 5.57554 14.005 5.4664 13.9718 5.36453Z",
      fill: "currentColor"
    })), /*#__PURE__*/React__namespace.createElement("defs", null, /*#__PURE__*/React__namespace.createElement("clipPath", {
      id: pathId
    }, /*#__PURE__*/React__namespace.createElement("rect", {
      width: "14",
      height: "14",
      fill: "white"
    }))));
  }));
  StarFillIcon.displayName = 'StarFillIcon';

  var ThLargeIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    var _React$useState = React__namespace.useState(inProps.id),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      pathId = _React$useState2[0],
      setPathId = _React$useState2[1];
    React__namespace.useEffect(function () {
      if (ObjectUtils.isEmpty(pathId)) {
        setPathId(UniqueComponentId('pr_icon_clip_'));
      }
    }, [pathId]);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("g", {
      clipPath: "url(#".concat(pathId, ")")
    }, /*#__PURE__*/React__namespace.createElement("path", {
      fillRule: "evenodd",
      clipRule: "evenodd",
      d: "M1.90909 6.36364H4.45455C4.96087 6.36364 5.44645 6.1625 5.80448 5.80448C6.1625 5.44645 6.36364 4.96087 6.36364 4.45455V1.90909C6.36364 1.40277 6.1625 0.917184 5.80448 0.55916C5.44645 0.201136 4.96087 0 4.45455 0H1.90909C1.40277 0 0.917184 0.201136 0.55916 0.55916C0.201136 0.917184 0 1.40277 0 1.90909V4.45455C0 4.96087 0.201136 5.44645 0.55916 5.80448C0.917184 6.1625 1.40277 6.36364 1.90909 6.36364ZM1.46154 1.46154C1.58041 1.34268 1.741 1.27492 1.90909 1.27273H4.45455C4.62264 1.27492 4.78322 1.34268 4.90209 1.46154C5.02096 1.58041 5.08871 1.741 5.09091 1.90909V4.45455C5.08871 4.62264 5.02096 4.78322 4.90209 4.90209C4.78322 5.02096 4.62264 5.08871 4.45455 5.09091H1.90909C1.741 5.08871 1.58041 5.02096 1.46154 4.90209C1.34268 4.78322 1.27492 4.62264 1.27273 4.45455V1.90909C1.27492 1.741 1.34268 1.58041 1.46154 1.46154ZM1.90909 14H4.45455C4.96087 14 5.44645 13.7989 5.80448 13.4408C6.1625 13.0828 6.36364 12.5972 6.36364 12.0909V9.54544C6.36364 9.03912 6.1625 8.55354 5.80448 8.19551C5.44645 7.83749 4.96087 7.63635 4.45455 7.63635H1.90909C1.40277 7.63635 0.917184 7.83749 0.55916 8.19551C0.201136 8.55354 0 9.03912 0 9.54544V12.0909C0 12.5972 0.201136 13.0828 0.55916 13.4408C0.917184 13.7989 1.40277 14 1.90909 14ZM1.46154 9.0979C1.58041 8.97903 1.741 8.91128 1.90909 8.90908H4.45455C4.62264 8.91128 4.78322 8.97903 4.90209 9.0979C5.02096 9.21677 5.08871 9.37735 5.09091 9.54544V12.0909C5.08871 12.259 5.02096 12.4196 4.90209 12.5384C4.78322 12.6573 4.62264 12.7251 4.45455 12.7273H1.90909C1.741 12.7251 1.58041 12.6573 1.46154 12.5384C1.34268 12.4196 1.27492 12.259 1.27273 12.0909V9.54544C1.27492 9.37735 1.34268 9.21677 1.46154 9.0979ZM12.0909 6.36364H9.54544C9.03912 6.36364 8.55354 6.1625 8.19551 5.80448C7.83749 5.44645 7.63635 4.96087 7.63635 4.45455V1.90909C7.63635 1.40277 7.83749 0.917184 8.19551 0.55916C8.55354 0.201136 9.03912 0 9.54544 0H12.0909C12.5972 0 13.0828 0.201136 13.4408 0.55916C13.7989 0.917184 14 1.40277 14 1.90909V4.45455C14 4.96087 13.7989 5.44645 13.4408 5.80448C13.0828 6.1625 12.5972 6.36364 12.0909 6.36364ZM9.54544 1.27273C9.37735 1.27492 9.21677 1.34268 9.0979 1.46154C8.97903 1.58041 8.91128 1.741 8.90908 1.90909V4.45455C8.91128 4.62264 8.97903 4.78322 9.0979 4.90209C9.21677 5.02096 9.37735 5.08871 9.54544 5.09091H12.0909C12.259 5.08871 12.4196 5.02096 12.5384 4.90209C12.6573 4.78322 12.7251 4.62264 12.7273 4.45455V1.90909C12.7251 1.741 12.6573 1.58041 12.5384 1.46154C12.4196 1.34268 12.259 1.27492 12.0909 1.27273H9.54544ZM9.54544 14H12.0909C12.5972 14 13.0828 13.7989 13.4408 13.4408C13.7989 13.0828 14 12.5972 14 12.0909V9.54544C14 9.03912 13.7989 8.55354 13.4408 8.19551C13.0828 7.83749 12.5972 7.63635 12.0909 7.63635H9.54544C9.03912 7.63635 8.55354 7.83749 8.19551 8.19551C7.83749 8.55354 7.63635 9.03912 7.63635 9.54544V12.0909C7.63635 12.5972 7.83749 13.0828 8.19551 13.4408C8.55354 13.7989 9.03912 14 9.54544 14ZM9.0979 9.0979C9.21677 8.97903 9.37735 8.91128 9.54544 8.90908H12.0909C12.259 8.91128 12.4196 8.97903 12.5384 9.0979C12.6573 9.21677 12.7251 9.37735 12.7273 9.54544V12.0909C12.7251 12.259 12.6573 12.4196 12.5384 12.5384C12.4196 12.6573 12.259 12.7251 12.0909 12.7273H9.54544C9.37735 12.7251 9.21677 12.6573 9.0979 12.5384C8.97903 12.4196 8.91128 12.259 8.90908 12.0909V9.54544C8.91128 9.37735 8.97903 9.21677 9.0979 9.0979Z",
      fill: "currentColor"
    })), /*#__PURE__*/React__namespace.createElement("defs", null, /*#__PURE__*/React__namespace.createElement("clipPath", {
      id: pathId
    }, /*#__PURE__*/React__namespace.createElement("rect", {
      width: "14",
      height: "14",
      fill: "white"
    }))));
  }));
  ThLargeIcon.displayName = 'ThLargeIcon';

  var TimesIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("path", {
      d: "M8.01186 7.00933L12.27 2.75116C12.341 2.68501 12.398 2.60524 12.4375 2.51661C12.4769 2.42798 12.4982 2.3323 12.4999 2.23529C12.5016 2.13827 12.4838 2.0419 12.4474 1.95194C12.4111 1.86197 12.357 1.78024 12.2884 1.71163C12.2198 1.64302 12.138 1.58893 12.0481 1.55259C11.9581 1.51625 11.8617 1.4984 11.7647 1.50011C11.6677 1.50182 11.572 1.52306 11.4834 1.56255C11.3948 1.60204 11.315 1.65898 11.2488 1.72997L6.99067 5.98814L2.7325 1.72997C2.59553 1.60234 2.41437 1.53286 2.22718 1.53616C2.03999 1.53946 1.8614 1.61529 1.72901 1.74767C1.59663 1.88006 1.5208 2.05865 1.5175 2.24584C1.5142 2.43303 1.58368 2.61419 1.71131 2.75116L5.96948 7.00933L1.71131 11.2675C1.576 11.403 1.5 11.5866 1.5 11.7781C1.5 11.9696 1.576 12.1532 1.71131 12.2887C1.84679 12.424 2.03043 12.5 2.2219 12.5C2.41338 12.5 2.59702 12.424 2.7325 12.2887L6.99067 8.03052L11.2488 12.2887C11.3843 12.424 11.568 12.5 11.7594 12.5C11.9509 12.5 12.1346 12.424 12.27 12.2887C12.4053 12.1532 12.4813 11.9696 12.4813 11.7781C12.4813 11.5866 12.4053 11.403 12.27 11.2675L8.01186 7.00933Z",
      fill: "currentColor"
    }));
  }));
  TimesIcon.displayName = 'TimesIcon';

  var TimesCircleIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    var _React$useState = React__namespace.useState(inProps.id),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      pathId = _React$useState2[0],
      setPathId = _React$useState2[1];
    React__namespace.useEffect(function () {
      if (ObjectUtils.isEmpty(pathId)) {
        setPathId(UniqueComponentId('pr_icon_clip_'));
      }
    }, [pathId]);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("g", {
      clipPath: "url(#".concat(pathId, ")")
    }, /*#__PURE__*/React__namespace.createElement("path", {
      fillRule: "evenodd",
      clipRule: "evenodd",
      d: "M7 14C5.61553 14 4.26215 13.5895 3.11101 12.8203C1.95987 12.0511 1.06266 10.9579 0.532846 9.67879C0.00303296 8.3997 -0.13559 6.99224 0.134506 5.63437C0.404603 4.2765 1.07129 3.02922 2.05026 2.05026C3.02922 1.07129 4.2765 0.404603 5.63437 0.134506C6.99224 -0.13559 8.3997 0.00303296 9.67879 0.532846C10.9579 1.06266 12.0511 1.95987 12.8203 3.11101C13.5895 4.26215 14 5.61553 14 7C14 8.85652 13.2625 10.637 11.9497 11.9497C10.637 13.2625 8.85652 14 7 14ZM7 1.16667C5.84628 1.16667 4.71846 1.50879 3.75918 2.14976C2.79989 2.79074 2.05222 3.70178 1.61071 4.76768C1.16919 5.83358 1.05367 7.00647 1.27876 8.13803C1.50384 9.26958 2.05941 10.309 2.87521 11.1248C3.69102 11.9406 4.73042 12.4962 5.86198 12.7212C6.99353 12.9463 8.16642 12.8308 9.23232 12.3893C10.2982 11.9478 11.2093 11.2001 11.8502 10.2408C12.4912 9.28154 12.8333 8.15373 12.8333 7C12.8333 5.45291 12.2188 3.96918 11.1248 2.87521C10.0308 1.78125 8.5471 1.16667 7 1.16667ZM4.66662 9.91668C4.58998 9.91704 4.51404 9.90209 4.44325 9.87271C4.37246 9.84333 4.30826 9.8001 4.2544 9.74557C4.14516 9.6362 4.0838 9.48793 4.0838 9.33335C4.0838 9.17876 4.14516 9.0305 4.2544 8.92113L6.17553 7L4.25443 5.07891C4.15139 4.96832 4.09529 4.82207 4.09796 4.67094C4.10063 4.51982 4.16185 4.37563 4.26872 4.26876C4.3756 4.16188 4.51979 4.10066 4.67091 4.09799C4.82204 4.09532 4.96829 4.15142 5.07887 4.25446L6.99997 6.17556L8.92106 4.25446C9.03164 4.15142 9.1779 4.09532 9.32903 4.09799C9.48015 4.10066 9.62434 4.16188 9.73121 4.26876C9.83809 4.37563 9.89931 4.51982 9.90198 4.67094C9.90464 4.82207 9.84855 4.96832 9.74551 5.07891L7.82441 7L9.74554 8.92113C9.85478 9.0305 9.91614 9.17876 9.91614 9.33335C9.91614 9.48793 9.85478 9.6362 9.74554 9.74557C9.69168 9.8001 9.62748 9.84333 9.55669 9.87271C9.4859 9.90209 9.40996 9.91704 9.33332 9.91668C9.25668 9.91704 9.18073 9.90209 9.10995 9.87271C9.03916 9.84333 8.97495 9.8001 8.9211 9.74557L6.99997 7.82444L5.07884 9.74557C5.02499 9.8001 4.96078 9.84333 4.88999 9.87271C4.81921 9.90209 4.74326 9.91704 4.66662 9.91668Z",
      fill: "currentColor"
    })), /*#__PURE__*/React__namespace.createElement("defs", null, /*#__PURE__*/React__namespace.createElement("clipPath", {
      id: pathId
    }, /*#__PURE__*/React__namespace.createElement("rect", {
      width: "14",
      height: "14",
      fill: "white"
    }))));
  }));
  TimesCircleIcon.displayName = 'TimesCircleIcon';

  var TrashIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    var _React$useState = React__namespace.useState(inProps.id),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      pathId = _React$useState2[0],
      setPathId = _React$useState2[1];
    React__namespace.useEffect(function () {
      if (ObjectUtils.isEmpty(pathId)) {
        setPathId(UniqueComponentId('pr_icon_clip_'));
      }
    }, [pathId]);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("g", {
      clipPath: "url(#".concat(pathId, ")")
    }, /*#__PURE__*/React__namespace.createElement("path", {
      fillRule: "evenodd",
      clipRule: "evenodd",
      d: "M3.44802 13.9955H10.552C10.8056 14.0129 11.06 13.9797 11.3006 13.898C11.5412 13.8163 11.7632 13.6877 11.9537 13.5196C12.1442 13.3515 12.2995 13.1473 12.4104 12.9188C12.5213 12.6903 12.5858 12.442 12.6 12.1884V4.36041H13.4C13.5591 4.36041 13.7117 4.29722 13.8243 4.18476C13.9368 4.07229 14 3.91976 14 3.76071C14 3.60166 13.9368 3.44912 13.8243 3.33666C13.7117 3.22419 13.5591 3.16101 13.4 3.16101H12.0537C12.0203 3.1557 11.9863 3.15299 11.952 3.15299C11.9178 3.15299 11.8838 3.1557 11.8503 3.16101H11.2285C11.2421 3.10893 11.2487 3.05513 11.248 3.00106V1.80966C11.2171 1.30262 10.9871 0.828306 10.608 0.48989C10.229 0.151475 9.73159 -0.0236625 9.22402 0.00257442H4.77602C4.27251 -0.0171866 3.78126 0.160868 3.40746 0.498617C3.03365 0.836366 2.807 1.30697 2.77602 1.80966V3.00106C2.77602 3.0556 2.78346 3.10936 2.79776 3.16101H0.6C0.521207 3.16101 0.443185 3.17652 0.37039 3.20666C0.297595 3.2368 0.231451 3.28097 0.175736 3.33666C0.120021 3.39235 0.0758251 3.45846 0.0456722 3.53121C0.0155194 3.60397 0 3.68196 0 3.76071C0 3.83946 0.0155194 3.91744 0.0456722 3.9902C0.0758251 4.06296 0.120021 4.12907 0.175736 4.18476C0.231451 4.24045 0.297595 4.28462 0.37039 4.31476C0.443185 4.3449 0.521207 4.36041 0.6 4.36041H1.40002V12.1884C1.41426 12.442 1.47871 12.6903 1.58965 12.9188C1.7006 13.1473 1.85582 13.3515 2.04633 13.5196C2.23683 13.6877 2.45882 13.8163 2.69944 13.898C2.94005 13.9797 3.1945 14.0129 3.44802 13.9955ZM2.60002 4.36041H11.304V12.1884C11.304 12.5163 10.952 12.7961 10.504 12.7961H3.40002C2.97602 12.7961 2.60002 12.5163 2.60002 12.1884V4.36041ZM3.95429 3.16101C3.96859 3.10936 3.97602 3.0556 3.97602 3.00106V1.80966C3.97602 1.48183 4.33602 1.20197 4.77602 1.20197H9.24802C9.66403 1.20197 10.048 1.48183 10.048 1.80966V3.00106C10.0473 3.05515 10.054 3.10896 10.0678 3.16101H3.95429ZM5.57571 10.997C5.41731 10.995 5.26597 10.9311 5.15395 10.8191C5.04193 10.7071 4.97808 10.5558 4.97601 10.3973V6.77517C4.97601 6.61612 5.0392 6.46359 5.15166 6.35112C5.26413 6.23866 5.41666 6.17548 5.57571 6.17548C5.73476 6.17548 5.8873 6.23866 5.99976 6.35112C6.11223 6.46359 6.17541 6.61612 6.17541 6.77517V10.3894C6.17647 10.4688 6.16174 10.5476 6.13208 10.6213C6.10241 10.695 6.05841 10.762 6.00261 10.8186C5.94682 10.8751 5.88035 10.92 5.80707 10.9506C5.73378 10.9813 5.65514 10.9971 5.57571 10.997ZM7.99968 10.8214C8.11215 10.9339 8.26468 10.997 8.42373 10.997C8.58351 10.9949 8.73604 10.93 8.84828 10.8163C8.96052 10.7025 9.02345 10.5491 9.02343 10.3894V6.77517C9.02343 6.61612 8.96025 6.46359 8.84778 6.35112C8.73532 6.23866 8.58278 6.17548 8.42373 6.17548C8.26468 6.17548 8.11215 6.23866 7.99968 6.35112C7.88722 6.46359 7.82404 6.61612 7.82404 6.77517V10.3973C7.82404 10.5564 7.88722 10.7089 7.99968 10.8214Z",
      fill: "currentColor"
    })), /*#__PURE__*/React__namespace.createElement("defs", null, /*#__PURE__*/React__namespace.createElement("clipPath", {
      id: pathId
    }, /*#__PURE__*/React__namespace.createElement("rect", {
      width: "14",
      height: "14",
      fill: "white"
    }))));
  }));
  TrashIcon.displayName = 'TrashIcon';

  var UndoIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    var _React$useState = React__namespace.useState(inProps.id),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      pathId = _React$useState2[0],
      setPathId = _React$useState2[1];
    React__namespace.useEffect(function () {
      if (ObjectUtils.isEmpty(pathId)) {
        setPathId(UniqueComponentId('pr_icon_clip_'));
      }
    }, [pathId]);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("g", {
      clipPath: "url(#".concat(pathId, ")")
    }, /*#__PURE__*/React__namespace.createElement("path", {
      fillRule: "evenodd",
      clipRule: "evenodd",
      d: "M6.77042 5.96336C6.84315 5.99355 6.92118 6.00891 6.99993 6.00854C7.07868 6.00891 7.15671 5.99355 7.22944 5.96336C7.30217 5.93317 7.36814 5.88876 7.42348 5.83273C7.53572 5.72035 7.59876 5.56801 7.59876 5.40918C7.59876 5.25035 7.53572 5.09802 7.42348 4.98564L6.04897 3.61113H6.99998C7.9088 3.61113 8.79722 3.88063 9.55288 4.38554C10.3085 4.89046 10.8975 5.60811 11.2453 6.44776C11.5931 7.2874 11.6841 8.21132 11.5068 9.10268C11.3295 9.99404 10.8918 10.8128 10.2492 11.4554C9.60657 12.0981 8.7878 12.5357 7.89644 12.713C7.00508 12.8903 6.08116 12.7993 5.24152 12.4515C4.40188 12.1037 3.68422 11.5148 3.17931 10.7591C2.67439 10.0035 2.4049 9.11504 2.4049 8.20622C2.4049 8.04726 2.34175 7.89481 2.22935 7.78241C2.11695 7.67001 1.9645 7.60686 1.80554 7.60686C1.64658 7.60686 1.49413 7.67001 1.38172 7.78241C1.26932 7.89481 1.20618 8.04726 1.20618 8.20622C1.20829 9.74218 1.81939 11.2146 2.90548 12.3007C3.99157 13.3868 5.46402 13.9979 6.99998 14C8.5366 14 10.0103 13.3896 11.0968 12.3031C12.1834 11.2165 12.7938 9.74283 12.7938 8.20622C12.7938 6.66961 12.1834 5.19593 11.0968 4.10938C10.0103 3.02283 8.5366 2.41241 6.99998 2.41241H6.04892L7.42348 1.03786C7.48236 0.982986 7.5296 0.916817 7.56235 0.843296C7.59511 0.769775 7.61273 0.690409 7.61415 0.609933C7.61557 0.529456 7.60076 0.449519 7.57062 0.374888C7.54047 0.300257 7.49561 0.232462 7.43869 0.175548C7.38178 0.118634 7.31398 0.0737664 7.23935 0.0436218C7.16472 0.0134773 7.08478 -0.00132663 7.00431 9.32772e-05C6.92383 0.00151319 6.84447 0.019128 6.77095 0.0518865C6.69742 0.0846451 6.63126 0.131876 6.57638 0.190763L4.17895 2.5882C4.06671 2.70058 4.00366 2.85292 4.00366 3.01175C4.00366 3.17058 4.06671 3.32291 4.17895 3.43529L6.57638 5.83273C6.63172 5.88876 6.69769 5.93317 6.77042 5.96336Z",
      fill: "currentColor"
    })), /*#__PURE__*/React__namespace.createElement("defs", null, /*#__PURE__*/React__namespace.createElement("clipPath", {
      id: pathId
    }, /*#__PURE__*/React__namespace.createElement("rect", {
      width: "14",
      height: "14",
      fill: "white"
    }))));
  }));
  UndoIcon.displayName = 'UndoIcon';

  var UploadIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    var _React$useState = React__namespace.useState(inProps.id),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      pathId = _React$useState2[0],
      setPathId = _React$useState2[1];
    React__namespace.useEffect(function () {
      if (ObjectUtils.isEmpty(pathId)) {
        setPathId(UniqueComponentId('pr_icon_clip_'));
      }
    }, [pathId]);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("g", {
      clipPath: "url(#".concat(pathId, ")")
    }, /*#__PURE__*/React__namespace.createElement("path", {
      fillRule: "evenodd",
      clipRule: "evenodd",
      d: "M6.58942 9.82197C6.70165 9.93405 6.85328 9.99793 7.012 10C7.17071 9.99793 7.32234 9.93405 7.43458 9.82197C7.54681 9.7099 7.61079 9.55849 7.61286 9.4V2.04798L9.79204 4.22402C9.84752 4.28011 9.91365 4.32457 9.98657 4.35479C10.0595 4.38502 10.1377 4.40039 10.2167 4.40002C10.2956 4.40039 10.3738 4.38502 10.4467 4.35479C10.5197 4.32457 10.5858 4.28011 10.6413 4.22402C10.7538 4.11152 10.817 3.95902 10.817 3.80002C10.817 3.64102 10.7538 3.48852 10.6413 3.37602L7.45127 0.190618C7.44656 0.185584 7.44176 0.180622 7.43687 0.175736C7.32419 0.063214 7.17136 0 7.012 0C6.85264 0 6.69981 0.063214 6.58712 0.175736C6.58181 0.181045 6.5766 0.186443 6.5715 0.191927L3.38282 3.37602C3.27669 3.48976 3.2189 3.6402 3.22165 3.79564C3.2244 3.95108 3.28746 4.09939 3.39755 4.20932C3.50764 4.31925 3.65616 4.38222 3.81182 4.38496C3.96749 4.3877 4.11814 4.33001 4.23204 4.22402L6.41113 2.04807V9.4C6.41321 9.55849 6.47718 9.7099 6.58942 9.82197ZM11.9952 14H2.02883C1.751 13.9887 1.47813 13.9228 1.22584 13.8061C0.973545 13.6894 0.746779 13.5241 0.558517 13.3197C0.370254 13.1154 0.22419 12.876 0.128681 12.6152C0.0331723 12.3545 -0.00990605 12.0775 0.0019109 11.8V9.40005C0.0019109 9.24092 0.065216 9.08831 0.1779 8.97579C0.290584 8.86326 0.443416 8.80005 0.602775 8.80005C0.762134 8.80005 0.914966 8.86326 1.02765 8.97579C1.14033 9.08831 1.20364 9.24092 1.20364 9.40005V11.8C1.18295 12.0376 1.25463 12.274 1.40379 12.4602C1.55296 12.6463 1.76817 12.7681 2.00479 12.8H11.9952C12.2318 12.7681 12.447 12.6463 12.5962 12.4602C12.7453 12.274 12.817 12.0376 12.7963 11.8V9.40005C12.7963 9.24092 12.8596 9.08831 12.9723 8.97579C13.085 8.86326 13.2378 8.80005 13.3972 8.80005C13.5565 8.80005 13.7094 8.86326 13.8221 8.97579C13.9347 9.08831 13.998 9.24092 13.998 9.40005V11.8C14.022 12.3563 13.8251 12.8996 13.45 13.3116C13.0749 13.7236 12.552 13.971 11.9952 14Z",
      fill: "currentColor"
    })), /*#__PURE__*/React__namespace.createElement("defs", null, /*#__PURE__*/React__namespace.createElement("clipPath", {
      id: pathId
    }, /*#__PURE__*/React__namespace.createElement("rect", {
      width: "14",
      height: "14",
      fill: "white"
    }))));
  }));
  UploadIcon.displayName = 'UploadIcon';

  var WindowMaximizeIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    var _React$useState = React__namespace.useState(inProps.id),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      pathId = _React$useState2[0],
      setPathId = _React$useState2[1];
    React__namespace.useEffect(function () {
      if (ObjectUtils.isEmpty(pathId)) {
        setPathId(UniqueComponentId('pr_icon_clip_'));
      }
    }, [pathId]);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("g", {
      clipPath: "url(#".concat(pathId, ")")
    }, /*#__PURE__*/React__namespace.createElement("path", {
      fillRule: "evenodd",
      clipRule: "evenodd",
      d: "M7 14H11.8C12.3835 14 12.9431 13.7682 13.3556 13.3556C13.7682 12.9431 14 12.3835 14 11.8V2.2C14 1.61652 13.7682 1.05694 13.3556 0.644365C12.9431 0.231785 12.3835 0 11.8 0H2.2C1.61652 0 1.05694 0.231785 0.644365 0.644365C0.231785 1.05694 0 1.61652 0 2.2V7C0 7.15913 0.063214 7.31174 0.175736 7.42426C0.288258 7.53679 0.44087 7.6 0.6 7.6C0.75913 7.6 0.911742 7.53679 1.02426 7.42426C1.13679 7.31174 1.2 7.15913 1.2 7V2.2C1.2 1.93478 1.30536 1.68043 1.49289 1.49289C1.68043 1.30536 1.93478 1.2 2.2 1.2H11.8C12.0652 1.2 12.3196 1.30536 12.5071 1.49289C12.6946 1.68043 12.8 1.93478 12.8 2.2V11.8C12.8 12.0652 12.6946 12.3196 12.5071 12.5071C12.3196 12.6946 12.0652 12.8 11.8 12.8H7C6.84087 12.8 6.68826 12.8632 6.57574 12.9757C6.46321 13.0883 6.4 13.2409 6.4 13.4C6.4 13.5591 6.46321 13.7117 6.57574 13.8243C6.68826 13.9368 6.84087 14 7 14ZM9.77805 7.42192C9.89013 7.534 10.0415 7.59788 10.2 7.59995C10.3585 7.59788 10.5099 7.534 10.622 7.42192C10.7341 7.30985 10.798 7.15844 10.8 6.99995V3.94242C10.8066 3.90505 10.8096 3.86689 10.8089 3.82843C10.8079 3.77159 10.7988 3.7157 10.7824 3.6623C10.756 3.55552 10.701 3.45698 10.622 3.37798C10.5099 3.2659 10.3585 3.20202 10.2 3.19995H7.00002C6.84089 3.19995 6.68828 3.26317 6.57576 3.37569C6.46324 3.48821 6.40002 3.64082 6.40002 3.79995C6.40002 3.95908 6.46324 4.11169 6.57576 4.22422C6.68828 4.33674 6.84089 4.39995 7.00002 4.39995H8.80006L6.19997 7.00005C6.10158 7.11005 6.04718 7.25246 6.04718 7.40005C6.04718 7.54763 6.10158 7.69004 6.19997 7.80005C6.30202 7.91645 6.44561 7.98824 6.59997 8.00005C6.75432 7.98824 6.89791 7.91645 6.99997 7.80005L9.60002 5.26841V6.99995C9.6021 7.15844 9.66598 7.30985 9.77805 7.42192ZM1.4 14H3.8C4.17066 13.9979 4.52553 13.8498 4.78763 13.5877C5.04973 13.3256 5.1979 12.9707 5.2 12.6V10.2C5.1979 9.82939 5.04973 9.47452 4.78763 9.21242C4.52553 8.95032 4.17066 8.80215 3.8 8.80005H1.4C1.02934 8.80215 0.674468 8.95032 0.412371 9.21242C0.150274 9.47452 0.00210008 9.82939 0 10.2V12.6C0.00210008 12.9707 0.150274 13.3256 0.412371 13.5877C0.674468 13.8498 1.02934 13.9979 1.4 14ZM1.25858 10.0586C1.29609 10.0211 1.34696 10 1.4 10H3.8C3.85304 10 3.90391 10.0211 3.94142 10.0586C3.97893 10.0961 4 10.147 4 10.2V12.6C4 12.6531 3.97893 12.704 3.94142 12.7415C3.90391 12.779 3.85304 12.8 3.8 12.8H1.4C1.34696 12.8 1.29609 12.779 1.25858 12.7415C1.22107 12.704 1.2 12.6531 1.2 12.6V10.2C1.2 10.147 1.22107 10.0961 1.25858 10.0586Z",
      fill: "currentColor"
    })), /*#__PURE__*/React__namespace.createElement("defs", null, /*#__PURE__*/React__namespace.createElement("clipPath", {
      id: pathId
    }, /*#__PURE__*/React__namespace.createElement("rect", {
      width: "14",
      height: "14",
      fill: "white"
    }))));
  }));
  WindowMaximizeIcon.displayName = 'WindowMaximizeIcon';

  var WindowMinimizeIcon = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    var _React$useState = React__namespace.useState(inProps.id),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      pathId = _React$useState2[0],
      setPathId = _React$useState2[1];
    React__namespace.useEffect(function () {
      if (ObjectUtils.isEmpty(pathId)) {
        setPathId(UniqueComponentId('pr_icon_clip_'));
      }
    }, [pathId]);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("g", {
      clipPath: "url(#".concat(pathId, ")")
    }, /*#__PURE__*/React__namespace.createElement("path", {
      fillRule: "evenodd",
      clipRule: "evenodd",
      d: "M11.8 0H2.2C1.61652 0 1.05694 0.231785 0.644365 0.644365C0.231785 1.05694 0 1.61652 0 2.2V7C0 7.15913 0.063214 7.31174 0.175736 7.42426C0.288258 7.53679 0.44087 7.6 0.6 7.6C0.75913 7.6 0.911742 7.53679 1.02426 7.42426C1.13679 7.31174 1.2 7.15913 1.2 7V2.2C1.2 1.93478 1.30536 1.68043 1.49289 1.49289C1.68043 1.30536 1.93478 1.2 2.2 1.2H11.8C12.0652 1.2 12.3196 1.30536 12.5071 1.49289C12.6946 1.68043 12.8 1.93478 12.8 2.2V11.8C12.8 12.0652 12.6946 12.3196 12.5071 12.5071C12.3196 12.6946 12.0652 12.8 11.8 12.8H7C6.84087 12.8 6.68826 12.8632 6.57574 12.9757C6.46321 13.0883 6.4 13.2409 6.4 13.4C6.4 13.5591 6.46321 13.7117 6.57574 13.8243C6.68826 13.9368 6.84087 14 7 14H11.8C12.3835 14 12.9431 13.7682 13.3556 13.3556C13.7682 12.9431 14 12.3835 14 11.8V2.2C14 1.61652 13.7682 1.05694 13.3556 0.644365C12.9431 0.231785 12.3835 0 11.8 0ZM6.368 7.952C6.44137 7.98326 6.52025 7.99958 6.6 8H9.8C9.95913 8 10.1117 7.93678 10.2243 7.82426C10.3368 7.71174 10.4 7.55913 10.4 7.4C10.4 7.24087 10.3368 7.08826 10.2243 6.97574C10.1117 6.86321 9.95913 6.8 9.8 6.8H8.048L10.624 4.224C10.73 4.11026 10.7877 3.95982 10.7849 3.80438C10.7822 3.64894 10.7192 3.50063 10.6093 3.3907C10.4994 3.28077 10.3511 3.2178 10.1956 3.21506C10.0402 3.21232 9.88974 3.27002 9.776 3.376L7.2 5.952V4.2C7.2 4.04087 7.13679 3.88826 7.02426 3.77574C6.91174 3.66321 6.75913 3.6 6.6 3.6C6.44087 3.6 6.28826 3.66321 6.17574 3.77574C6.06321 3.88826 6 4.04087 6 4.2V7.4C6.00042 7.47975 6.01674 7.55862 6.048 7.632C6.07656 7.70442 6.11971 7.7702 6.17475 7.82524C6.2298 7.88029 6.29558 7.92344 6.368 7.952ZM1.4 8.80005H3.8C4.17066 8.80215 4.52553 8.95032 4.78763 9.21242C5.04973 9.47452 5.1979 9.82939 5.2 10.2V12.6C5.1979 12.9707 5.04973 13.3256 4.78763 13.5877C4.52553 13.8498 4.17066 13.9979 3.8 14H1.4C1.02934 13.9979 0.674468 13.8498 0.412371 13.5877C0.150274 13.3256 0.00210008 12.9707 0 12.6V10.2C0.00210008 9.82939 0.150274 9.47452 0.412371 9.21242C0.674468 8.95032 1.02934 8.80215 1.4 8.80005ZM3.94142 12.7415C3.97893 12.704 4 12.6531 4 12.6V10.2C4 10.147 3.97893 10.0961 3.94142 10.0586C3.90391 10.0211 3.85304 10 3.8 10H1.4C1.34696 10 1.29609 10.0211 1.25858 10.0586C1.22107 10.0961 1.2 10.147 1.2 10.2V12.6C1.2 12.6531 1.22107 12.704 1.25858 12.7415C1.29609 12.779 1.34696 12.8 1.4 12.8H3.8C3.85304 12.8 3.90391 12.779 3.94142 12.7415Z",
      fill: "currentColor"
    })), /*#__PURE__*/React__namespace.createElement("defs", null, /*#__PURE__*/React__namespace.createElement("clipPath", {
      id: pathId
    }, /*#__PURE__*/React__namespace.createElement("rect", {
      width: "14",
      height: "14",
      fill: "white"
    }))));
  }));
  WindowMinimizeIcon.displayName = 'WindowMinimizeIcon';

  var classes$1b = {
    root: function root(_ref) {
      var props = _ref.props;
      return classNames('p-badge p-component', _defineProperty({
        'p-badge-no-gutter': ObjectUtils.isNotEmpty(props.value) && String(props.value).length === 1,
        'p-badge-dot': ObjectUtils.isEmpty(props.value),
        'p-badge-lg': props.size === 'large',
        'p-badge-xl': props.size === 'xlarge'
      }, "p-badge-".concat(props.severity), props.severity !== null));
    }
  };
  var styles$15 = "\n@layer primereact {\n    .p-badge {\n        display: inline-block;\n        border-radius: 10px;\n        text-align: center;\n        padding: 0 .5rem;\n    }\n    \n    .p-overlay-badge {\n        position: relative;\n    }\n    \n    .p-overlay-badge .p-badge {\n        position: absolute;\n        top: 0;\n        right: 0;\n        transform: translate(50%,-50%);\n        transform-origin: 100% 0;\n        margin: 0;\n    }\n    \n    .p-badge-dot {\n        width: .5rem;\n        min-width: .5rem;\n        height: .5rem;\n        border-radius: 50%;\n        padding: 0;\n    }\n    \n    .p-badge-no-gutter {\n        padding: 0;\n        border-radius: 50%;\n    }\n}\n";
  var BadgeBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'Badge',
      __parentMetadata: null,
      value: null,
      severity: null,
      size: null,
      style: null,
      className: null,
      children: undefined
    },
    css: {
      classes: classes$1b,
      styles: styles$15
    }
  });

  function ownKeys$1K(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1K(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1K(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1K(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var Badge = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var context = React__namespace.useContext(PrimeReactContext);
    var props = BadgeBase.getProps(inProps, context);
    var _BadgeBase$setMetaDat = BadgeBase.setMetaData(_objectSpread$1K({
        props: props
      }, props.__parentMetadata)),
      ptm = _BadgeBase$setMetaDat.ptm,
      cx = _BadgeBase$setMetaDat.cx,
      isUnstyled = _BadgeBase$setMetaDat.isUnstyled;
    useHandleStyle(BadgeBase.css.styles, isUnstyled, {
      name: 'badge'
    });
    var elementRef = React__namespace.useRef(null);
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        getElement: function getElement() {
          return elementRef.current;
        }
      };
    });
    var rootProps = mergeProps({
      ref: elementRef,
      style: props.style,
      className: classNames(props.className, cx('root'))
    }, BadgeBase.getOtherProps(props), ptm('root'));
    return /*#__PURE__*/React__namespace.createElement("span", rootProps, props.value);
  }));
  Badge.displayName = 'Badge';

  var styles$14 = "\n@layer primereact {\n    .p-ripple {\n        overflow: hidden;\n        position: relative;\n    }\n    \n    .p-ink {\n        display: block;\n        position: absolute;\n        background: rgba(255, 255, 255, 0.5);\n        border-radius: 100%;\n        transform: scale(0);\n    }\n    \n    .p-ink-active {\n        animation: ripple 0.4s linear;\n    }\n    \n    .p-ripple-disabled .p-ink {\n        display: none;\n    }\n}\n\n@keyframes ripple {\n    100% {\n        opacity: 0;\n        transform: scale(2.5);\n    }\n}\n\n";
  var classes$1a = {
    root: 'p-ink'
  };
  var RippleBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'Ripple',
      children: undefined
    },
    css: {
      styles: styles$14,
      classes: classes$1a
    },
    getProps: function getProps(props) {
      return ObjectUtils.getMergedProps(props, RippleBase.defaultProps);
    },
    getOtherProps: function getOtherProps(props) {
      return ObjectUtils.getDiffProps(props, RippleBase.defaultProps);
    }
  });

  function ownKeys$1J(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1J(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1J(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1J(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var Ripple = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var _React$useState = React__namespace.useState(false),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      isMounted = _React$useState2[0],
      setMounted = _React$useState2[1];
    var inkRef = React__namespace.useRef(null);
    var targetRef = React__namespace.useRef(null);
    var context = React__namespace.useContext(PrimeReactContext);
    var props = RippleBase.getProps(inProps, context);
    var isRippleActive = context && context.ripple || PrimeReact.ripple;
    var metaData = {
      props: props
    };
    useStyle(RippleBase.css.styles, {
      name: 'ripple',
      manual: !isRippleActive
    });
    var _RippleBase$setMetaDa = RippleBase.setMetaData(_objectSpread$1J({}, metaData)),
      ptm = _RippleBase$setMetaDa.ptm,
      cx = _RippleBase$setMetaDa.cx;
    var getTarget = function getTarget() {
      return inkRef.current && inkRef.current.parentElement;
    };
    var bindEvents = function bindEvents() {
      if (targetRef.current) {
        targetRef.current.addEventListener('pointerdown', onPointerDown);
      }
    };
    var unbindEvents = function unbindEvents() {
      if (targetRef.current) {
        targetRef.current.removeEventListener('pointerdown', onPointerDown);
      }
    };
    var onPointerDown = function onPointerDown(event) {
      var offset = DomHandler.getOffset(targetRef.current);
      var offsetX = event.pageX - offset.left + document.body.scrollTop - DomHandler.getWidth(inkRef.current) / 2;
      var offsetY = event.pageY - offset.top + document.body.scrollLeft - DomHandler.getHeight(inkRef.current) / 2;
      activateRipple(offsetX, offsetY);
    };
    var activateRipple = function activateRipple(offsetX, offsetY) {
      if (!inkRef.current || getComputedStyle(inkRef.current, null).display === 'none') {
        return;
      }
      DomHandler.removeClass(inkRef.current, 'p-ink-active');
      setDimensions();
      inkRef.current.style.top = offsetY + 'px';
      inkRef.current.style.left = offsetX + 'px';
      DomHandler.addClass(inkRef.current, 'p-ink-active');
    };
    var onAnimationEnd = function onAnimationEnd(event) {
      DomHandler.removeClass(event.currentTarget, 'p-ink-active');
    };
    var setDimensions = function setDimensions() {
      if (inkRef.current && !DomHandler.getHeight(inkRef.current) && !DomHandler.getWidth(inkRef.current)) {
        var d = Math.max(DomHandler.getOuterWidth(targetRef.current), DomHandler.getOuterHeight(targetRef.current));
        inkRef.current.style.height = d + 'px';
        inkRef.current.style.width = d + 'px';
      }
    };
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        getInk: function getInk() {
          return inkRef.current;
        },
        getTarget: function getTarget() {
          return targetRef.current;
        }
      };
    });
    useMountEffect(function () {
      // for App Router in Next.js ^14
      setMounted(true);
    });
    useUpdateEffect(function () {
      if (isMounted && inkRef.current) {
        targetRef.current = getTarget();
        setDimensions();
        bindEvents();
      }
    }, [isMounted]);
    useUpdateEffect(function () {
      if (inkRef.current && !targetRef.current) {
        targetRef.current = getTarget();
        setDimensions();
        bindEvents();
      }
    });
    useUnmountEffect(function () {
      if (inkRef.current) {
        targetRef.current = null;
        unbindEvents();
      }
    });
    if (!isRippleActive) return null;
    var rootProps = mergeProps({
      'aria-hidden': true,
      className: classNames(cx('root'))
    }, RippleBase.getOtherProps(props), ptm('root'));
    return /*#__PURE__*/React__namespace.createElement("span", _extends({
      role: "presentation",
      ref: inkRef
    }, rootProps, {
      onAnimationEnd: onAnimationEnd
    }));
  }));
  Ripple.displayName = 'Ripple';

  var PortalBase = {
    defaultProps: {
      __TYPE: 'Portal',
      element: null,
      appendTo: null,
      visible: false,
      onMounted: null,
      onUnmounted: null,
      children: undefined
    },
    getProps: function getProps(props) {
      return ObjectUtils.getMergedProps(props, PortalBase.defaultProps);
    },
    getOtherProps: function getOtherProps(props) {
      return ObjectUtils.getDiffProps(props, PortalBase.defaultProps);
    }
  };

  var Portal = /*#__PURE__*/React__namespace.memo(function (inProps) {
    var props = PortalBase.getProps(inProps);
    var context = React__namespace.useContext(PrimeReactContext);
    var _React$useState = React__namespace.useState(props.visible && DomHandler.isClient()),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      mountedState = _React$useState2[0],
      setMountedState = _React$useState2[1];
    useMountEffect(function () {
      if (DomHandler.isClient() && !mountedState) {
        setMountedState(true);
        props.onMounted && props.onMounted();
      }
    });
    useUpdateEffect(function () {
      props.onMounted && props.onMounted();
    }, [mountedState]);
    useUnmountEffect(function () {
      props.onUnmounted && props.onUnmounted();
    });
    var element = props.element || props.children;
    if (element && mountedState) {
      var appendTo = props.appendTo || context && context.appendTo || PrimeReact.appendTo;
      if (ObjectUtils.isFunction(appendTo)) {
        appendTo = appendTo();
      }
      if (!appendTo) {
        appendTo = document.body;
      }
      return appendTo === 'self' ? element : /*#__PURE__*/ReactDOM__default["default"].createPortal(element, appendTo);
    }
    return null;
  });
  Portal.displayName = 'Portal';

  var classes$19 = {
    root: function root(_ref) {
      var positionState = _ref.positionState,
        classNameState = _ref.classNameState;
      return classNames('p-tooltip p-component', _defineProperty({}, "p-tooltip-".concat(positionState), true), classNameState);
    },
    arrow: 'p-tooltip-arrow',
    text: 'p-tooltip-text'
  };
  var inlineStyles$m = {
    arrow: function arrow(_ref2) {
      var context = _ref2.context;
      return {
        top: context.bottom ? '0' : context.right || context.left || !context.right && !context.left && !context.top && !context.bottom ? '50%' : null,
        bottom: context.top ? '0' : null,
        left: context.right || !context.right && !context.left && !context.top && !context.bottom ? '0' : context.top || context.bottom ? '50%' : null,
        right: context.left ? '0' : null
      };
    }
  };
  var styles$13 = "\n@layer primereact {\n    .p-tooltip {\n        position: absolute;\n        padding: .25em .5rem;\n        /* #3687: Tooltip prevent scrollbar flickering */\n        top: -9999px;\n        left: -9999px;\n    }\n    \n    .p-tooltip.p-tooltip-right,\n    .p-tooltip.p-tooltip-left {\n        padding: 0 .25rem;\n    }\n    \n    .p-tooltip.p-tooltip-top,\n    .p-tooltip.p-tooltip-bottom {\n        padding:.25em 0;\n    }\n    \n    .p-tooltip .p-tooltip-text {\n       white-space: pre-line;\n       word-break: break-word;\n    }\n    \n    .p-tooltip-arrow {\n        position: absolute;\n        width: 0;\n        height: 0;\n        border-color: transparent;\n        border-style: solid;\n    }\n    \n    .p-tooltip-right .p-tooltip-arrow {\n        top: 50%;\n        left: 0;\n        margin-top: -.25rem;\n        border-width: .25em .25em .25em 0;\n    }\n    \n    .p-tooltip-left .p-tooltip-arrow {\n        top: 50%;\n        right: 0;\n        margin-top: -.25rem;\n        border-width: .25em 0 .25em .25rem;\n    }\n    \n    .p-tooltip.p-tooltip-top {\n        padding: .25em 0;\n    }\n    \n    .p-tooltip-top .p-tooltip-arrow {\n        bottom: 0;\n        left: 50%;\n        margin-left: -.25rem;\n        border-width: .25em .25em 0;\n    }\n    \n    .p-tooltip-bottom .p-tooltip-arrow {\n        top: 0;\n        left: 50%;\n        margin-left: -.25rem;\n        border-width: 0 .25em .25rem;\n    }\n\n    .p-tooltip-target-wrapper {\n        display: inline-flex;\n    }\n}\n";
  var TooltipBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'Tooltip',
      appendTo: null,
      at: null,
      autoHide: true,
      autoZIndex: true,
      baseZIndex: 0,
      className: null,
      content: null,
      disabled: false,
      event: null,
      hideDelay: 0,
      hideEvent: 'mouseleave',
      id: null,
      mouseTrack: false,
      mouseTrackLeft: 5,
      mouseTrackTop: 5,
      my: null,
      onBeforeHide: null,
      onBeforeShow: null,
      onHide: null,
      onShow: null,
      position: 'right',
      showDelay: 0,
      showEvent: 'mouseenter',
      showOnDisabled: false,
      style: null,
      target: null,
      updateDelay: 0,
      children: undefined
    },
    css: {
      classes: classes$19,
      styles: styles$13,
      inlineStyles: inlineStyles$m
    }
  });

  function ownKeys$1I(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1I(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1I(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1I(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var Tooltip = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var context = React__namespace.useContext(PrimeReactContext);
    var props = TooltipBase.getProps(inProps, context);
    var _React$useState = React__namespace.useState(false),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      visibleState = _React$useState2[0],
      setVisibleState = _React$useState2[1];
    var _React$useState3 = React__namespace.useState(props.position),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      positionState = _React$useState4[0],
      setPositionState = _React$useState4[1];
    var _React$useState5 = React__namespace.useState(''),
      _React$useState6 = _slicedToArray(_React$useState5, 2),
      classNameState = _React$useState6[0],
      setClassNameState = _React$useState6[1];
    var metaData = {
      props: props,
      state: {
        visible: visibleState,
        position: positionState,
        className: classNameState
      },
      context: {
        right: positionState === 'right',
        left: positionState === 'left',
        top: positionState === 'top',
        bottom: positionState === 'bottom'
      }
    };
    var _TooltipBase$setMetaD = TooltipBase.setMetaData(metaData),
      ptm = _TooltipBase$setMetaD.ptm,
      cx = _TooltipBase$setMetaD.cx,
      sx = _TooltipBase$setMetaD.sx,
      isUnstyled = _TooltipBase$setMetaD.isUnstyled;
    useHandleStyle(TooltipBase.css.styles, isUnstyled, {
      name: 'tooltip'
    });
    var elementRef = React__namespace.useRef(null);
    var textRef = React__namespace.useRef(null);
    var currentTargetRef = React__namespace.useRef(null);
    var containerSize = React__namespace.useRef(null);
    var allowHide = React__namespace.useRef(true);
    var timeouts = React__namespace.useRef({});
    var currentMouseEvent = React__namespace.useRef(null);
    var _useResizeListener = useResizeListener({
        listener: function listener(event) {
          !DomHandler.isTouchDevice() && hide(event);
        }
      }),
      _useResizeListener2 = _slicedToArray(_useResizeListener, 2),
      bindWindowResizeListener = _useResizeListener2[0],
      unbindWindowResizeListener = _useResizeListener2[1];
    var _useOverlayScrollList = useOverlayScrollListener({
        target: currentTargetRef.current,
        listener: function listener(event) {
          hide(event);
        },
        when: visibleState
      }),
      _useOverlayScrollList2 = _slicedToArray(_useOverlayScrollList, 2),
      bindOverlayScrollListener = _useOverlayScrollList2[0],
      unbindOverlayScrollListener = _useOverlayScrollList2[1];
    var isTargetContentEmpty = function isTargetContentEmpty(target) {
      return !(props.content || getTargetOption(target, 'tooltip'));
    };
    var isContentEmpty = function isContentEmpty(target) {
      return !(props.content || getTargetOption(target, 'tooltip') || props.children);
    };
    var isMouseTrack = function isMouseTrack(target) {
      return getTargetOption(target, 'mousetrack') || props.mouseTrack;
    };
    var isDisabled = function isDisabled(target) {
      return getTargetOption(target, 'disabled') === 'true' || hasTargetOption(target, 'disabled') || props.disabled;
    };
    var isShowOnDisabled = function isShowOnDisabled(target) {
      return getTargetOption(target, 'showondisabled') || props.showOnDisabled;
    };
    var isAutoHide = function isAutoHide() {
      return getTargetOption(currentTargetRef.current, 'autohide') || props.autoHide;
    };
    var getTargetOption = function getTargetOption(target, option) {
      return hasTargetOption(target, "data-pr-".concat(option)) ? target.getAttribute("data-pr-".concat(option)) : null;
    };
    var hasTargetOption = function hasTargetOption(target, option) {
      return target && target.hasAttribute(option);
    };
    var getEvents = function getEvents(target) {
      var showEvents = [getTargetOption(target, 'showevent') || props.showEvent];
      var hideEvents = [getTargetOption(target, 'hideevent') || props.hideEvent];
      if (isMouseTrack(target)) {
        showEvents = ['mousemove'];
        hideEvents = ['mouseleave'];
      } else {
        var event = getTargetOption(target, 'event') || props.event;
        if (event === 'focus') {
          showEvents = ['focus'];
          hideEvents = ['blur'];
        }
        if (event === 'both') {
          showEvents = ['focus', 'mouseenter'];
          hideEvents = ['blur', 'mouseleave'];
        }
      }
      return {
        showEvents: showEvents,
        hideEvents: hideEvents
      };
    };
    var getPosition = function getPosition(target) {
      return getTargetOption(target, 'position') || positionState;
    };
    var getMouseTrackPosition = function getMouseTrackPosition(target) {
      var top = getTargetOption(target, 'mousetracktop') || props.mouseTrackTop;
      var left = getTargetOption(target, 'mousetrackleft') || props.mouseTrackLeft;
      return {
        top: top,
        left: left
      };
    };
    var updateText = function updateText(target, callback) {
      if (textRef.current) {
        var content = getTargetOption(target, 'tooltip') || props.content;
        if (content) {
          textRef.current.innerHTML = ''; // remove children
          textRef.current.appendChild(document.createTextNode(content));
          callback();
        } else if (props.children) {
          callback();
        }
      }
    };
    var updateTooltipState = function updateTooltipState(position) {
      updateText(currentTargetRef.current, function () {
        var _currentMouseEvent$cu = currentMouseEvent.current,
          x = _currentMouseEvent$cu.pageX,
          y = _currentMouseEvent$cu.pageY;
        if (props.autoZIndex && !ZIndexUtils.get(elementRef.current)) {
          ZIndexUtils.set('tooltip', elementRef.current, context && context.autoZIndex || PrimeReact.autoZIndex, props.baseZIndex || context && context.zIndex['tooltip'] || PrimeReact.zIndex['tooltip']);
        }
        elementRef.current.style.left = '';
        elementRef.current.style.top = '';

        // GitHub #2695 disable pointer events when autohiding
        if (isAutoHide()) {
          elementRef.current.style.pointerEvents = 'none';
        }
        var mouseTrackCheck = isMouseTrack(currentTargetRef.current) || position === 'mouse';
        if (mouseTrackCheck && !containerSize.current || mouseTrackCheck) {
          containerSize.current = {
            width: DomHandler.getOuterWidth(elementRef.current),
            height: DomHandler.getOuterHeight(elementRef.current)
          };
        }
        align(currentTargetRef.current, {
          x: x,
          y: y
        }, position);
      });
    };
    var show = function show(e) {
      currentTargetRef.current = e.currentTarget;
      var disabled = isDisabled(currentTargetRef.current);
      var empty = isContentEmpty(isShowOnDisabled(currentTargetRef.current) && disabled ? currentTargetRef.current.firstChild : currentTargetRef.current);
      if (empty || disabled) {
        return;
      }
      currentMouseEvent.current = e;
      if (visibleState) {
        applyDelay('updateDelay', updateTooltipState);
      } else {
        // #2653 give the callback a chance to return false and not continue with display
        var success = sendCallback(props.onBeforeShow, {
          originalEvent: e,
          target: currentTargetRef.current
        });
        if (success) {
          applyDelay('showDelay', function () {
            setVisibleState(true);
            sendCallback(props.onShow, {
              originalEvent: e,
              target: currentTargetRef.current
            });
          });
        }
      }
    };
    var hide = function hide(e) {
      clearTimeouts();
      if (visibleState) {
        var success = sendCallback(props.onBeforeHide, {
          originalEvent: e,
          target: currentTargetRef.current
        });
        if (success) {
          applyDelay('hideDelay', function () {
            if (!isAutoHide() && allowHide.current === false) {
              return;
            }
            ZIndexUtils.clear(elementRef.current);
            DomHandler.removeClass(elementRef.current, 'p-tooltip-active');
            setVisibleState(false);
            sendCallback(props.onHide, {
              originalEvent: e,
              target: currentTargetRef.current
            });
          });
        }
      }
    };
    var align = function align(target, coordinate, position) {
      var left = 0,
        top = 0,
        currentPosition = position || positionState;
      if ((isMouseTrack(target) || currentPosition == 'mouse') && coordinate) {
        var _containerSize = {
          width: DomHandler.getOuterWidth(elementRef.current),
          height: DomHandler.getOuterHeight(elementRef.current)
        };
        left = coordinate.x;
        top = coordinate.y;
        var _getMouseTrackPositio = getMouseTrackPosition(target),
          mouseTrackTop = _getMouseTrackPositio.top,
          mouseTrackLeft = _getMouseTrackPositio.left;
        switch (currentPosition) {
          case 'left':
            left -= _containerSize.width + mouseTrackLeft;
            top -= _containerSize.height / 2 - mouseTrackTop;
            break;
          case 'right':
          case 'mouse':
            left += mouseTrackLeft;
            top -= _containerSize.height / 2 - mouseTrackTop;
            break;
          case 'top':
            left -= _containerSize.width / 2 - mouseTrackLeft;
            top -= _containerSize.height + mouseTrackTop;
            break;
          case 'bottom':
            left -= _containerSize.width / 2 - mouseTrackLeft;
            top += mouseTrackTop;
            break;
        }
        if (left <= 0 || containerSize.current.width > _containerSize.width) {
          elementRef.current.style.left = '0px';
          elementRef.current.style.right = window.innerWidth - _containerSize.width - left + 'px';
        } else {
          elementRef.current.style.right = '';
          elementRef.current.style.left = left + 'px';
        }
        elementRef.current.style.top = top + 'px';
        DomHandler.addClass(elementRef.current, 'p-tooltip-active');
      } else {
        var pos = DomHandler.findCollisionPosition(currentPosition);
        var my = getTargetOption(target, 'my') || props.my || pos.my;
        var at = getTargetOption(target, 'at') || props.at || pos.at;
        elementRef.current.style.padding = '0px';
        DomHandler.flipfitCollision(elementRef.current, target, my, at, function (calculatedPosition) {
          var _calculatedPosition$a = calculatedPosition.at,
            atX = _calculatedPosition$a.x,
            atY = _calculatedPosition$a.y;
          var myX = calculatedPosition.my.x;
          var newPosition = props.at ? atX !== 'center' && atX !== myX ? atX : atY : calculatedPosition.at["".concat(pos.axis)];
          elementRef.current.style.padding = '';
          setPositionState(newPosition);
          updateContainerPosition(newPosition);
          DomHandler.addClass(elementRef.current, 'p-tooltip-active');
        });
      }
    };
    var updateContainerPosition = function updateContainerPosition(position) {
      if (elementRef.current) {
        var style = getComputedStyle(elementRef.current);
        if (position === 'left') elementRef.current.style.left = parseFloat(style.left) - parseFloat(style.paddingLeft) * 2 + 'px';else if (position === 'top') elementRef.current.style.top = parseFloat(style.top) - parseFloat(style.paddingTop) * 2 + 'px';
      }
    };
    var _onMouseEnter = function onMouseEnter() {
      if (!isAutoHide()) {
        allowHide.current = false;
      }
    };
    var _onMouseLeave = function onMouseLeave(e) {
      if (!isAutoHide()) {
        allowHide.current = true;
        hide(e);
      }
    };
    var bindTargetEvent = function bindTargetEvent(target) {
      if (target) {
        var _getEvents = getEvents(target),
          showEvents = _getEvents.showEvents,
          hideEvents = _getEvents.hideEvents;
        var currentTarget = getTarget(target);
        showEvents.forEach(function (event) {
          return currentTarget === null || currentTarget === void 0 ? void 0 : currentTarget.addEventListener(event, show);
        });
        hideEvents.forEach(function (event) {
          return currentTarget === null || currentTarget === void 0 ? void 0 : currentTarget.addEventListener(event, hide);
        });
      }
    };
    var unbindTargetEvent = function unbindTargetEvent(target) {
      if (target) {
        var _getEvents2 = getEvents(target),
          showEvents = _getEvents2.showEvents,
          hideEvents = _getEvents2.hideEvents;
        var currentTarget = getTarget(target);
        showEvents.forEach(function (event) {
          return currentTarget === null || currentTarget === void 0 ? void 0 : currentTarget.removeEventListener(event, show);
        });
        hideEvents.forEach(function (event) {
          return currentTarget === null || currentTarget === void 0 ? void 0 : currentTarget.removeEventListener(event, hide);
        });
      }
    };
    var applyDelay = function applyDelay(delayProp, callback) {
      clearTimeouts();
      var delay = getTargetOption(currentTargetRef.current, delayProp.toLowerCase()) || props[delayProp];
      !!delay ? timeouts.current["".concat(delayProp)] = setTimeout(function () {
        return callback();
      }, delay) : callback();
    };
    var sendCallback = function sendCallback(callback) {
      if (callback) {
        for (var _len = arguments.length, params = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
          params[_key - 1] = arguments[_key];
        }
        var result = callback.apply(void 0, params);
        if (result === undefined) {
          result = true;
        }
        return result;
      }
      return true;
    };
    var clearTimeouts = function clearTimeouts() {
      Object.values(timeouts.current).forEach(function (t) {
        return clearTimeout(t);
      });
    };
    var getTarget = function getTarget(target) {
      if (target) {
        if (isShowOnDisabled(target)) {
          if (!target.hasWrapper) {
            var wrapper = document.createElement('div');
            var isInputElement = target.nodeName === 'INPUT';
            if (isInputElement) {
              DomHandler.addMultipleClasses(wrapper, "p-tooltip-target-wrapper p-inputwrapper");
            } else {
              DomHandler.addClass(wrapper, 'p-tooltip-target-wrapper');
            }
            target.parentNode.insertBefore(wrapper, target);
            wrapper.appendChild(target);
            target.hasWrapper = true;
            return wrapper;
          } else {
            return target.parentElement;
          }
        } else if (target.hasWrapper) {
          var _target$parentElement;
          (_target$parentElement = target.parentElement).replaceWith.apply(_target$parentElement, _toConsumableArray(target.parentElement.childNodes));
          delete target.hasWrapper;
        }
        return target;
      }
      return null;
    };
    var updateTargetEvents = function updateTargetEvents(target) {
      unloadTargetEvents(target);
      loadTargetEvents(target);
    };
    var loadTargetEvents = function loadTargetEvents(target) {
      setTargetEventOperations(target || props.target, bindTargetEvent);
    };
    var unloadTargetEvents = function unloadTargetEvents(target) {
      setTargetEventOperations(target || props.target, unbindTargetEvent);
    };
    var setTargetEventOperations = function setTargetEventOperations(target, operation) {
      target = ObjectUtils.getRefElement(target);
      if (target) {
        if (DomHandler.isElement(target)) {
          operation(target);
        } else {
          var setEvent = function setEvent(target) {
            var element = DomHandler.find(document, target);
            element.forEach(function (el) {
              operation(el);
            });
          };
          if (target instanceof Array) {
            target.forEach(function (t) {
              setEvent(t);
            });
          } else {
            setEvent(target);
          }
        }
      }
    };
    useMountEffect(function () {
      if (visibleState && currentTargetRef.current && isDisabled(currentTargetRef.current)) {
        hide();
      }
    });
    useUpdateEffect(function () {
      loadTargetEvents();
      return function () {
        unloadTargetEvents();
      };
    }, [show, hide, props.target]);
    useUpdateEffect(function () {
      if (visibleState) {
        var position = getPosition(currentTargetRef.current);
        var classname = getTargetOption(currentTargetRef.current, 'classname');
        setPositionState(position);
        setClassNameState(classname);
        updateTooltipState(position);
        bindWindowResizeListener();
        bindOverlayScrollListener();
      } else {
        setPositionState(props.position);
        setClassNameState('');
        currentTargetRef.current = null;
        containerSize.current = null;
        allowHide.current = true;
      }
      return function () {
        unbindWindowResizeListener();
        unbindOverlayScrollListener();
      };
    }, [visibleState]);
    useUpdateEffect(function () {
      if (visibleState) {
        applyDelay('updateDelay', function () {
          updateText(currentTargetRef.current, function () {
            align(currentTargetRef.current);
          });
        });
      }
    }, [props.content]);
    useUnmountEffect(function () {
      hide();
      ZIndexUtils.clear(elementRef.current);
    });
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        updateTargetEvents: updateTargetEvents,
        loadTargetEvents: loadTargetEvents,
        unloadTargetEvents: unloadTargetEvents,
        show: show,
        hide: hide,
        getElement: function getElement() {
          return elementRef.current;
        },
        getTarget: function getTarget() {
          return currentTargetRef.current;
        }
      };
    });
    var createElement = function createElement() {
      var empty = isTargetContentEmpty(currentTargetRef.current);
      var rootProps = mergeProps({
        id: props.id,
        className: classNames(props.className, cx('root', {
          positionState: positionState,
          classNameState: classNameState
        })),
        style: props.style,
        role: 'tooltip',
        'aria-hidden': visibleState,
        onMouseEnter: function onMouseEnter(e) {
          return _onMouseEnter();
        },
        onMouseLeave: function onMouseLeave(e) {
          return _onMouseLeave(e);
        }
      }, TooltipBase.getOtherProps(props), ptm('root'));
      var arrowProps = mergeProps({
        className: cx('arrow'),
        style: sx('arrow', _objectSpread$1I({}, metaData))
      }, ptm('arrow'));
      var textProps = mergeProps({
        className: cx('text')
      }, ptm('text'));
      return /*#__PURE__*/React__namespace.createElement("div", _extends({
        ref: elementRef
      }, rootProps), /*#__PURE__*/React__namespace.createElement("div", arrowProps), /*#__PURE__*/React__namespace.createElement("div", _extends({
        ref: textRef
      }, textProps), empty && props.children));
    };
    if (visibleState) {
      var element = createElement();
      return /*#__PURE__*/React__namespace.createElement(Portal, {
        element: element,
        appendTo: props.appendTo,
        visible: true
      });
    }
    return null;
  }));
  Tooltip.displayName = 'Tooltip';

  var classes$18 = {
    icon: function icon(_ref) {
      var props = _ref.props;
      return classNames('p-button-icon p-c', _defineProperty({}, "p-button-icon-".concat(props.iconPos), props.label));
    },
    loadingIcon: function loadingIcon(_ref2) {
      var props = _ref2.props,
        className = _ref2.className;
      return classNames(className, {
        'p-button-loading-icon': props.loading
      });
    },
    label: 'p-button-label p-c',
    root: function root(_ref3) {
      var props = _ref3.props,
        size = _ref3.size,
        disabled = _ref3.disabled;
      return classNames('p-button p-component', _defineProperty(_defineProperty(_defineProperty(_defineProperty({
        'p-button-icon-only': (props.icon || props.loading) && !props.label && !props.children,
        'p-button-vertical': (props.iconPos === 'top' || props.iconPos === 'bottom') && props.label,
        'p-disabled': disabled,
        'p-button-loading': props.loading,
        'p-button-outlined': props.outlined,
        'p-button-raised': props.raised,
        'p-button-link': props.link,
        'p-button-text': props.text,
        'p-button-rounded': props.rounded,
        'p-button-loading-label-only': props.loading && !props.icon && props.label
      }, "p-button-loading-".concat(props.iconPos), props.loading && props.label), "p-button-".concat(size), size), "p-button-".concat(props.severity), props.severity), 'p-button-plain', props.plain));
    }
  };
  var ButtonBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'Button',
      __parentMetadata: null,
      badge: null,
      badgeClassName: null,
      className: null,
      children: undefined,
      disabled: false,
      icon: null,
      iconPos: 'left',
      label: null,
      link: false,
      loading: false,
      loadingIcon: null,
      outlined: false,
      plain: false,
      raised: false,
      rounded: false,
      severity: null,
      size: null,
      text: false,
      tooltip: null,
      tooltipOptions: null,
      visible: true
    },
    css: {
      classes: classes$18
    }
  });

  function ownKeys$1H(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1H(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1H(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1H(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var Button = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var context = React__namespace.useContext(PrimeReactContext);
    var props = ButtonBase.getProps(inProps, context);
    var disabled = props.disabled || props.loading;
    var metaData = _objectSpread$1H(_objectSpread$1H({
      props: props
    }, props.__parentMetadata), {}, {
      context: {
        disabled: disabled
      }
    });
    var _ButtonBase$setMetaDa = ButtonBase.setMetaData(metaData),
      ptm = _ButtonBase$setMetaDa.ptm,
      cx = _ButtonBase$setMetaDa.cx,
      isUnstyled = _ButtonBase$setMetaDa.isUnstyled;
    useHandleStyle(ButtonBase.css.styles, isUnstyled, {
      name: 'button',
      styled: true
    });
    var elementRef = React__namespace.useRef(ref);
    React__namespace.useEffect(function () {
      ObjectUtils.combinedRefs(elementRef, ref);
    }, [elementRef, ref]);
    if (props.visible === false) {
      return null;
    }
    var createIcon = function createIcon() {
      var className = classNames('p-button-icon p-c', _defineProperty({}, "p-button-icon-".concat(props.iconPos), props.label));
      var iconsProps = mergeProps({
        className: cx('icon')
      }, ptm('icon'));
      className = classNames(className, {
        'p-button-loading-icon': props.loading
      });
      var loadingIconProps = mergeProps({
        className: cx('loadingIcon', {
          className: className
        })
      }, ptm('loadingIcon'));
      var icon = props.loading ? props.loadingIcon || /*#__PURE__*/React__namespace.createElement(SpinnerIcon, _extends({}, loadingIconProps, {
        spin: true
      })) : props.icon;
      return IconUtils.getJSXIcon(icon, _objectSpread$1H({}, iconsProps), {
        props: props
      });
    };
    var createLabel = function createLabel() {
      var labelProps = mergeProps({
        className: cx('label')
      }, ptm('label'));
      if (props.label) {
        return /*#__PURE__*/React__namespace.createElement("span", labelProps, props.label);
      }
      return !props.children && !props.label && /*#__PURE__*/React__namespace.createElement("span", _extends({}, labelProps, {
        dangerouslySetInnerHTML: {
          __html: '&nbsp;'
        }
      }));
    };
    var createBadge = function createBadge() {
      if (props.badge) {
        var badgeProps = mergeProps({
          className: classNames(props.badgeClassName),
          value: props.badge,
          unstyled: props.unstyled,
          __parentMetadata: {
            parent: metaData
          }
        }, ptm('badge'));
        return /*#__PURE__*/React__namespace.createElement(Badge, badgeProps, props.badge);
      }
      return null;
    };
    var showTooltip = !disabled || props.tooltipOptions && props.tooltipOptions.showOnDisabled;
    var hasTooltip = ObjectUtils.isNotEmpty(props.tooltip) && showTooltip;
    var sizeMapping = {
      large: 'lg',
      small: 'sm'
    };
    var size = sizeMapping[props.size];
    var icon = createIcon();
    var label = createLabel();
    var badge = createBadge();
    var defaultAriaLabel = props.label ? props.label + (props.badge ? ' ' + props.badge : '') : props['aria-label'];
    var rootProps = mergeProps({
      ref: elementRef,
      'aria-label': defaultAriaLabel,
      className: classNames(props.className, cx('root', {
        size: size,
        disabled: disabled
      })),
      disabled: disabled
    }, ButtonBase.getOtherProps(props), ptm('root'));
    return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, null, /*#__PURE__*/React__namespace.createElement("button", rootProps, icon, label, props.children, badge, /*#__PURE__*/React__namespace.createElement(Ripple, null)), hasTooltip && /*#__PURE__*/React__namespace.createElement(Tooltip, _extends({
      target: elementRef,
      content: props.tooltip
    }, props.tooltipOptions, {
      pt: ptm('tooltip')
    })));
  }));
  Button.displayName = 'Button';

  var KeyFilter = {
    /* eslint-disable */
    DEFAULT_MASKS: {
      pint: /[\d]/,
      "int": /[\d\-]/,
      pnum: /[\d\.]/,
      money: /[\d\.\s,]/,
      num: /[\d\-\.]/,
      hex: /[0-9a-f]/i,
      email: /[a-z0-9_\.\-@]/i,
      alpha: /[a-z_]/i,
      alphanum: /[a-z0-9_]/i
    },
    /* eslint-enable */getRegex: function getRegex(keyfilter) {
      return KeyFilter.DEFAULT_MASKS[keyfilter] ? KeyFilter.DEFAULT_MASKS[keyfilter] : keyfilter;
    },
    onBeforeInput: function onBeforeInput(e, keyfilter, validateOnly) {
      // android devices must use beforeinput https://stackoverflow.com/questions/36753548/keycode-on-android-is-always-229
      if (validateOnly || !DomHandler.isAndroid()) {
        return;
      }
      this.validateKey(e, e.data, keyfilter);
    },
    onKeyPress: function onKeyPress(e, keyfilter, validateOnly) {
      // non android devices use keydown
      if (validateOnly || DomHandler.isAndroid()) {
        return;
      }
      if (e.ctrlKey || e.altKey) {
        return;
      }
      this.validateKey(e, e.key, keyfilter);
    },
    onPaste: function onPaste(e, keyfilter, validateOnly) {
      if (validateOnly) {
        return;
      }
      var regex = this.getRegex(keyfilter);
      var clipboard = e.clipboardData.getData('text');

      // loop over each letter pasted and if any fail prevent the paste
      _toConsumableArray(clipboard).forEach(function (c) {
        if (!regex.test(c)) {
          e.preventDefault();
          return false;
        }
      });
    },
    validateKey: function validateKey(e, key, keyfilter) {
      if (key === null || key === undefined) {
        return;
      }
      var isPrintableKey = key.length === 1;
      if (!isPrintableKey) {
        return;
      }
      var regex = this.getRegex(keyfilter);
      if (!regex.test(key)) {
        e.preventDefault();
      }
    },
    validate: function validate(e, keyfilter) {
      var value = e.target.value,
        validatePattern = true;
      var regex = this.getRegex(keyfilter);
      if (value && !regex.test(value)) {
        validatePattern = false;
      }
      return validatePattern;
    }
  };

  var classes$17 = {
    root: function root(_ref) {
      var props = _ref.props,
        isFilled = _ref.isFilled;
      return classNames('p-inputtext p-component', {
        'p-disabled': props.disabled,
        'p-filled': isFilled
      }, props.className);
    }
  };
  var InputTextBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'InputText',
      __parentMetadata: null,
      children: undefined,
      className: null,
      keyfilter: null,
      onBeforeInput: null,
      onInput: null,
      onKeyDown: null,
      onPaste: null,
      tooltip: null,
      tooltipOptions: null,
      validateOnly: false
    },
    css: {
      classes: classes$17
    }
  });

  function ownKeys$1G(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1G(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1G(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1G(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var InputText = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var context = React__namespace.useContext(PrimeReactContext);
    var props = InputTextBase.getProps(inProps, context);
    var _InputTextBase$setMet = InputTextBase.setMetaData(_objectSpread$1G(_objectSpread$1G({
        props: props
      }, props.__parentMetadata), {}, {
        context: {
          disabled: props.disabled
        }
      })),
      ptm = _InputTextBase$setMet.ptm,
      cx = _InputTextBase$setMet.cx,
      isUnstyled = _InputTextBase$setMet.isUnstyled;
    useHandleStyle(InputTextBase.css.styles, isUnstyled, {
      name: 'inputtext',
      styled: true
    });
    var elementRef = React__namespace.useRef(ref);
    var onKeyDown = function onKeyDown(event) {
      props.onKeyDown && props.onKeyDown(event);
      if (props.keyfilter) {
        KeyFilter.onKeyPress(event, props.keyfilter, props.validateOnly);
      }
    };
    var onBeforeInput = function onBeforeInput(event) {
      props.onBeforeInput && props.onBeforeInput(event);
      if (props.keyfilter) {
        KeyFilter.onBeforeInput(event, props.keyfilter, props.validateOnly);
      }
    };
    var onInput = function onInput(event) {
      var target = event.target;
      var validatePattern = true;
      if (props.keyfilter && props.validateOnly) {
        validatePattern = KeyFilter.validate(event, props.keyfilter);
      }
      props.onInput && props.onInput(event, validatePattern);

      // for uncontrolled changes
      ObjectUtils.isNotEmpty(target.value) ? DomHandler.addClass(target, 'p-filled') : DomHandler.removeClass(target, 'p-filled');
    };
    var onPaste = function onPaste(event) {
      props.onPaste && props.onPaste(event);
      if (props.keyfilter) {
        KeyFilter.onPaste(event, props.keyfilter, props.validateOnly);
      }
    };
    React__namespace.useEffect(function () {
      ObjectUtils.combinedRefs(elementRef, ref);
    }, [elementRef, ref]);
    var isFilled = React__namespace.useMemo(function () {
      return ObjectUtils.isNotEmpty(props.value) || ObjectUtils.isNotEmpty(props.defaultValue);
    }, [props.value, props.defaultValue]);
    var hasTooltip = ObjectUtils.isNotEmpty(props.tooltip);
    var rootProps = mergeProps({
      className: classNames(props.className, cx('root', {
        isFilled: isFilled
      })),
      onBeforeInput: onBeforeInput,
      onInput: onInput,
      onKeyDown: onKeyDown,
      onPaste: onPaste
    }, InputTextBase.getOtherProps(props), ptm('root'));
    return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, null, /*#__PURE__*/React__namespace.createElement("input", _extends({
      ref: elementRef
    }, rootProps)), hasTooltip && /*#__PURE__*/React__namespace.createElement(Tooltip, _extends({
      target: elementRef,
      content: props.tooltip
    }, props.tooltipOptions, {
      pt: ptm('tooltip')
    })));
  }));
  InputText.displayName = 'InputText';

  var OverlayService = EventBus();

  var classes$16 = {
    root: function root(_ref) {
      var props = _ref.props,
        focusedState = _ref.focusedState;
      return classNames('p-autocomplete p-component p-inputwrapper', {
        'p-autocomplete-dd': props.dropdown,
        'p-autocomplete-multiple': props.multiple,
        'p-inputwrapper-filled': props.value,
        'p-inputwrapper-focus': focusedState
      });
    },
    container: function container(_ref2) {
      var props = _ref2.props;
      return classNames('p-autocomplete-multiple-container p-component p-inputtext', {
        'p-disabled': props.disabled
      });
    },
    loadingIcon: 'p-autocomplete-loader',
    dropdownButton: 'p-autocomplete-dropdown',
    removeTokenIcon: 'p-autocomplete-token-icon',
    token: 'p-autocomplete-token p-highlight',
    tokenLabel: 'p-autocomplete-token-label',
    inputToken: 'p-autocomplete-input-token',
    input: function input(_ref3) {
      var props = _ref3.props;
      return classNames('p-autocomplete-input', {
        'p-autocomplete-dd-input': props.dropdown
      });
    },
    panel: function panel(_ref4) {
      var context = _ref4.context;
      return classNames('p-autocomplete-panel p-component', {
        'p-input-filled': context && context.inputStyle === 'filled' || PrimeReact.inputStyle === 'filled',
        'p-ripple-disabled': context && context.ripple === false || PrimeReact.ripple === false
      });
    },
    listWrapper: 'p-autocomplete-items-wrapper',
    list: function list(_ref5) {
      var virtualScrollerOptions = _ref5.virtualScrollerOptions,
        options = _ref5.options;
      return virtualScrollerOptions ? classNames('p-autocomplete-items', options.className) : 'p-autocomplete-items';
    },
    emptyMessage: 'p-autocomplete-item',
    item: function item(_ref6) {
      var suggestion = _ref6.suggestion,
        optionGroupLabel = _ref6.optionGroupLabel;
      return optionGroupLabel ? classNames('p-autocomplete-item', {
        'p-disabled': suggestion.disabled
      }) : classNames('p-autocomplete-item', {
        'p-disabled': suggestion.disabled
      });
    },
    itemGroup: 'p-autocomplete-item-group',
    footer: 'p-autocomplete-footer',
    transition: 'p-connected-overlay'
  };
  var styles$12 = "\n@layer primereact {\n    .p-autocomplete {\n        display: inline-flex;\n        position: relative;\n    }\n    \n    .p-autocomplete-loader {\n        position: absolute;\n        top: 50%;\n        margin-top: -.5rem;\n    }\n    \n    .p-autocomplete-dd .p-autocomplete-input {\n        flex: 1 1 auto;\n        width: 1%;\n    }\n    \n    .p-autocomplete-dd .p-autocomplete-input,\n    .p-autocomplete-dd .p-autocomplete-multiple-container {\n         border-top-right-radius: 0;\n         border-bottom-right-radius: 0;\n     }\n    \n    .p-autocomplete-dd .p-autocomplete-dropdown {\n         border-top-left-radius: 0;\n         border-bottom-left-radius: 0px;\n    }\n    \n    .p-autocomplete .p-autocomplete-panel {\n        min-width: 100%;\n    }\n    \n    .p-autocomplete-panel {\n        position: absolute;\n        top: 0;\n        left: 0;\n    }\n    \n    .p-autocomplete-items {\n        margin: 0;\n        padding: 0;\n        list-style-type: none;\n    }\n    \n    .p-autocomplete-item {\n        cursor: pointer;\n        white-space: nowrap;\n        position: relative;\n        overflow: hidden;\n    }\n    \n    .p-autocomplete-multiple-container {\n        margin: 0;\n        padding: 0;\n        list-style-type: none;\n        cursor: text;\n        overflow: hidden;\n        display: flex;\n        align-items: center;\n        flex-wrap: wrap;\n    }\n    \n    .p-autocomplete-token {\n        cursor: default;\n        display: inline-flex;\n        align-items: center;\n        flex: 0 0 auto;\n    }\n    \n    .p-autocomplete-token-icon {\n        cursor: pointer;\n    }\n    \n    .p-autocomplete-input-token {\n        flex: 1 1 auto;\n        display: inline-flex;\n    }\n    \n    .p-autocomplete-input-token input {\n        border: 0 none;\n        outline: 0 none;\n        background-color: transparent;\n        margin: 0;\n        padding: 0;\n        box-shadow: none;\n        border-radius: 0;\n        width: 100%;\n    }\n    \n    .p-fluid .p-autocomplete {\n        display: flex;\n    }\n    \n    .p-fluid .p-autocomplete-dd .p-autocomplete-input {\n        width: 1%;\n    }\n    \n    .p-autocomplete-items-wrapper {\n        overflow: auto;\n    } \n}\n";
  var AutoCompleteBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'AutoComplete',
      id: null,
      appendTo: null,
      autoFocus: false,
      autoHighlight: false,
      className: null,
      completeMethod: null,
      delay: 300,
      disabled: false,
      dropdown: false,
      dropdownAriaLabel: null,
      dropdownAutoFocus: true,
      dropdownIcon: null,
      dropdownMode: 'blank',
      emptyMessage: null,
      field: null,
      forceSelection: false,
      inputClassName: null,
      inputId: null,
      inputRef: null,
      inputStyle: null,
      itemTemplate: null,
      loadingIcon: null,
      maxLength: null,
      minLength: 1,
      multiple: false,
      name: null,
      onBlur: null,
      onChange: null,
      onClear: null,
      onClick: null,
      onContextMenu: null,
      onDblClick: null,
      onDropdownClick: null,
      onFocus: null,
      onHide: null,
      onKeyPress: null,
      onKeyUp: null,
      onMouseDown: null,
      onSelect: null,
      onShow: null,
      onUnselect: null,
      optionGroupChildren: null,
      optionGroupLabel: null,
      optionGroupTemplate: null,
      panelClassName: null,
      panelFooterTemplate: null,
      panelStyle: null,
      placeholder: null,
      readOnly: false,
      removeTokenIcon: null,
      scrollHeight: '200px',
      selectedItemTemplate: null,
      selectionLimit: null,
      showEmptyMessage: false,
      size: null,
      style: null,
      suggestions: null,
      tabIndex: null,
      tooltip: null,
      tooltipOptions: null,
      transitionOptions: null,
      type: 'text',
      value: null,
      virtualScrollerOptions: null,
      children: undefined
    },
    css: {
      classes: classes$16,
      styles: styles$12
    }
  });

  var styles$11 = "\n.p-virtualscroller {\n    position: relative;\n    overflow: auto;\n    contain: strict;\n    transform: translateZ(0);\n    will-change: scroll-position;\n    outline: 0 none;\n}\n\n.p-virtualscroller-content {\n    position: absolute;\n    top: 0;\n    left: 0;\n    /*contain: content;*/\n    min-height: 100%;\n    min-width: 100%;\n    will-change: transform;\n}\n\n.p-virtualscroller-spacer {\n    position: absolute;\n    top: 0;\n    left: 0;\n    height: 1px;\n    width: 1px;\n    transform-origin: 0 0;\n    pointer-events: none;\n}\n\n.p-virtualscroller-loader {\n    position: sticky;\n    top: 0;\n    left: 0;\n    width: 100%;\n    height: 100%;\n}\n\n.p-virtualscroller-loader.p-component-overlay {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n}\n\n.p-virtualscroller-loading-icon {\n    font-size: 2rem;\n}\n\n.p-virtualscroller-horizontal > .p-virtualscroller-content {\n    display: flex;\n}\n\n/* Inline */\n.p-virtualscroller-inline .p-virtualscroller-content {\n    position: static;\n}\n";
  var VirtualScrollerBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'VirtualScroller',
      __parentMetadata: null,
      id: null,
      style: null,
      className: null,
      tabIndex: 0,
      items: null,
      itemSize: 0,
      scrollHeight: null,
      scrollWidth: null,
      orientation: 'vertical',
      step: 0,
      numToleratedItems: null,
      delay: 0,
      resizeDelay: 10,
      appendOnly: false,
      inline: false,
      lazy: false,
      disabled: false,
      loaderDisabled: false,
      loadingIcon: null,
      columns: null,
      loading: undefined,
      autoSize: false,
      showSpacer: true,
      showLoader: false,
      loadingTemplate: null,
      loaderIconTemplate: null,
      itemTemplate: null,
      contentTemplate: null,
      onScroll: null,
      onScrollIndexChange: null,
      onLazyLoad: null,
      children: undefined
    },
    css: {
      styles: styles$11
    }
  });

  function ownKeys$1F(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1F(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1F(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1F(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var VirtualScroller = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var context = React__namespace.useContext(PrimeReactContext);
    var props = VirtualScrollerBase.getProps(inProps, context);
    var prevProps = usePrevious(inProps) || {};
    var vertical = props.orientation === 'vertical';
    var horizontal = props.orientation === 'horizontal';
    var both = props.orientation === 'both';
    var _React$useState = React__namespace.useState(both ? {
        rows: 0,
        cols: 0
      } : 0),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      firstState = _React$useState2[0],
      setFirstState = _React$useState2[1];
    var _React$useState3 = React__namespace.useState(both ? {
        rows: 0,
        cols: 0
      } : 0),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      lastState = _React$useState4[0],
      setLastState = _React$useState4[1];
    var _React$useState5 = React__namespace.useState(0),
      _React$useState6 = _slicedToArray(_React$useState5, 2),
      pageState = _React$useState6[0],
      setPageState = _React$useState6[1];
    var _React$useState7 = React__namespace.useState(both ? {
        rows: 0,
        cols: 0
      } : 0),
      _React$useState8 = _slicedToArray(_React$useState7, 2),
      numItemsInViewportState = _React$useState8[0],
      setNumItemsInViewportState = _React$useState8[1];
    var _React$useState9 = React__namespace.useState(props.numToleratedItems),
      _React$useState10 = _slicedToArray(_React$useState9, 2),
      numToleratedItemsState = _React$useState10[0],
      setNumToleratedItemsState = _React$useState10[1];
    var _React$useState11 = React__namespace.useState(props.loading || false),
      _React$useState12 = _slicedToArray(_React$useState11, 2),
      loadingState = _React$useState12[0],
      setLoadingState = _React$useState12[1];
    var _React$useState13 = React__namespace.useState([]),
      _React$useState14 = _slicedToArray(_React$useState13, 2),
      loaderArrState = _React$useState14[0],
      setLoaderArrState = _React$useState14[1];
    var _VirtualScrollerBase$ = VirtualScrollerBase.setMetaData({
        props: props,
        state: {
          first: firstState,
          last: lastState,
          page: pageState,
          numItemsInViewport: numItemsInViewportState,
          numToleratedItems: numToleratedItemsState,
          loading: loadingState,
          loaderArr: loaderArrState
        }
      }),
      ptm = _VirtualScrollerBase$.ptm;
    useStyle(VirtualScrollerBase.css.styles, {
      name: 'virtualscroller'
    });
    var elementRef = React__namespace.useRef(null);
    var _contentRef = React__namespace.useRef(null);
    var _spacerRef = React__namespace.useRef(null);
    var _stickyRef = React__namespace.useRef(null);
    var lastScrollPos = React__namespace.useRef(both ? {
      top: 0,
      left: 0
    } : 0);
    var scrollTimeout = React__namespace.useRef(null);
    var resizeTimeout = React__namespace.useRef(null);
    var contentStyle = React__namespace.useRef({});
    var spacerStyle = React__namespace.useRef({});
    var defaultWidth = React__namespace.useRef(null);
    var defaultHeight = React__namespace.useRef(null);
    var defaultContentWidth = React__namespace.useRef(null);
    var defaultContentHeight = React__namespace.useRef(null);
    var isItemRangeChanged = React__namespace.useRef(false);
    var lazyLoadState = React__namespace.useRef(null);
    var _useResizeListener = useResizeListener({
        listener: function listener(event) {
          return onResize();
        },
        when: !props.disabled
      }),
      _useResizeListener2 = _slicedToArray(_useResizeListener, 1),
      bindWindowResizeListener = _useResizeListener2[0];
    var _useEventListener = useEventListener({
        target: 'window',
        type: 'orientationchange',
        listener: function listener(event) {
          return onResize();
        },
        when: !props.disabled
      }),
      _useEventListener2 = _slicedToArray(_useEventListener, 1),
      bindOrientationChangeListener = _useEventListener2[0];
    var getElementRef = function getElementRef() {
      return elementRef;
    };
    var getPageByFirst = function getPageByFirst(first) {
      return Math.floor((first + numToleratedItemsState * 4) / (props.step || 1));
    };
    var setContentElement = function setContentElement(element) {
      _contentRef.current = element || _contentRef.current || DomHandler.findSingle(elementRef.current, '.p-virtualscroller-content');
    };
    var isPageChanged = function isPageChanged(first) {
      return props.step ? pageState !== getPageByFirst(first) : true;
    };
    var scrollTo = function scrollTo(options) {
      lastScrollPos.current = both ? {
        top: 0,
        left: 0
      } : 0;
      elementRef.current && elementRef.current.scrollTo(options);
    };
    var scrollToIndex = function scrollToIndex(index) {
      var behavior = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'auto';
      var _calculateNumItems = calculateNumItems(),
        numToleratedItems = _calculateNumItems.numToleratedItems;
      var contentPos = getContentPosition();
      var calculateFirst = function calculateFirst() {
        var _index = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
        var _numT = arguments.length > 1 ? arguments[1] : undefined;
        return _index <= _numT ? 0 : _index;
      };
      var calculateCoord = function calculateCoord(_first, _size, _cpos) {
        return _first * _size + _cpos;
      };
      var scrollToItem = function scrollToItem() {
        var left = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
        var top = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
        return scrollTo({
          left: left,
          top: top,
          behavior: behavior
        });
      };
      var newFirst = both ? {
        rows: 0,
        cols: 0
      } : 0;
      var isRangeChanged = false;
      if (both) {
        newFirst = {
          rows: calculateFirst(index[0], numToleratedItems[0]),
          cols: calculateFirst(index[1], numToleratedItems[1])
        };
        scrollToItem(calculateCoord(newFirst.cols, props.itemSize[1], contentPos.left), calculateCoord(newFirst.rows, props.itemSize[0], contentPos.top));
        isRangeChanged = firstState.rows !== newFirst.rows || firstState.cols !== newFirst.cols;
      } else {
        newFirst = calculateFirst(index, numToleratedItems);
        horizontal ? scrollToItem(calculateCoord(newFirst, props.itemSize, contentPos.left), 0) : scrollToItem(0, calculateCoord(newFirst, props.itemSize, contentPos.top));
        isRangeChanged = firstState !== newFirst;
      }
      isItemRangeChanged.current = isRangeChanged;
      setFirstState(newFirst);
    };
    var scrollInView = function scrollInView(index, to) {
      var behavior = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'auto';
      if (to) {
        var _getRenderedRange = getRenderedRange(),
          first = _getRenderedRange.first,
          viewport = _getRenderedRange.viewport;
        var scrollToItem = function scrollToItem() {
          var left = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
          var top = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
          return scrollTo({
            left: left,
            top: top,
            behavior: behavior
          });
        };
        var isToStart = to === 'to-start';
        var isToEnd = to === 'to-end';
        if (isToStart) {
          if (both) {
            if (viewport.first.rows - first.rows > index[0]) {
              scrollToItem(viewport.first.cols * props.itemSize[1], (viewport.first.rows - 1) * props.itemSize[0]);
            } else if (viewport.first.cols - first.cols > index[1]) {
              scrollToItem((viewport.first.cols - 1) * props.itemSize[1], viewport.first.rows * props.itemSize[0]);
            }
          } else {
            if (viewport.first - first > index) {
              var pos = (viewport.first - 1) * props.itemSize;
              horizontal ? scrollToItem(pos, 0) : scrollToItem(0, pos);
            }
          }
        } else if (isToEnd) {
          if (both) {
            if (viewport.last.rows - first.rows <= index[0] + 1) {
              scrollToItem(viewport.first.cols * props.itemSize[1], (viewport.first.rows + 1) * props.itemSize[0]);
            } else if (viewport.last.cols - first.cols <= index[1] + 1) {
              scrollToItem((viewport.first.cols + 1) * props.itemSize[1], viewport.first.rows * props.itemSize[0]);
            }
          } else {
            if (viewport.last - first <= index + 1) {
              var _pos2 = (viewport.first + 1) * props.itemSize;
              horizontal ? scrollToItem(_pos2, 0) : scrollToItem(0, _pos2);
            }
          }
        }
      } else {
        scrollToIndex(index, behavior);
      }
    };
    var getRows = function getRows() {
      return loadingState ? props.loaderDisabled ? loaderArrState : [] : loadedItems();
    };
    var getColumns = function getColumns() {
      if (props.columns && both || horizontal) {
        return loadingState && props.loaderDisabled ? both ? loaderArrState[0] : loaderArrState : props.columns.slice(both ? firstState.cols : firstState, both ? lastState.cols : lastState);
      }
      return props.columns;
    };
    var getRenderedRange = function getRenderedRange() {
      var calculateFirstInViewport = function calculateFirstInViewport(_pos, _size) {
        return Math.floor(_pos / (_size || _pos));
      };
      var firstInViewport = firstState;
      var lastInViewport = 0;
      if (elementRef.current) {
        var _elementRef$current = elementRef.current,
          scrollTop = _elementRef$current.scrollTop,
          scrollLeft = _elementRef$current.scrollLeft;
        if (both) {
          firstInViewport = {
            rows: calculateFirstInViewport(scrollTop, props.itemSize[0]),
            cols: calculateFirstInViewport(scrollLeft, props.itemSize[1])
          };
          lastInViewport = {
            rows: firstInViewport.rows + numItemsInViewportState.rows,
            cols: firstInViewport.cols + numItemsInViewportState.cols
          };
        } else {
          var scrollPos = horizontal ? scrollLeft : scrollTop;
          firstInViewport = calculateFirstInViewport(scrollPos, props.itemSize);
          lastInViewport = firstInViewport + numItemsInViewportState;
        }
      }
      return {
        first: firstState,
        last: lastState,
        viewport: {
          first: firstInViewport,
          last: lastInViewport
        }
      };
    };
    var calculateNumItems = function calculateNumItems() {
      var contentPos = getContentPosition();
      var contentWidth = elementRef.current ? elementRef.current.offsetWidth - contentPos.left : 0;
      var contentHeight = elementRef.current ? elementRef.current.offsetHeight - contentPos.top : 0;
      var calculateNumItemsInViewport = function calculateNumItemsInViewport(_contentSize, _itemSize) {
        return Math.ceil(_contentSize / (_itemSize || _contentSize));
      };
      var calculateNumToleratedItems = function calculateNumToleratedItems(_numItems) {
        return Math.ceil(_numItems / 2);
      };
      var numItemsInViewport = both ? {
        rows: calculateNumItemsInViewport(contentHeight, props.itemSize[0]),
        cols: calculateNumItemsInViewport(contentWidth, props.itemSize[1])
      } : calculateNumItemsInViewport(horizontal ? contentWidth : contentHeight, props.itemSize);
      var numToleratedItems = numToleratedItemsState || (both ? [calculateNumToleratedItems(numItemsInViewport.rows), calculateNumToleratedItems(numItemsInViewport.cols)] : calculateNumToleratedItems(numItemsInViewport));
      return {
        numItemsInViewport: numItemsInViewport,
        numToleratedItems: numToleratedItems
      };
    };
    var calculateOptions = function calculateOptions() {
      var _calculateNumItems2 = calculateNumItems(),
        numItemsInViewport = _calculateNumItems2.numItemsInViewport,
        numToleratedItems = _calculateNumItems2.numToleratedItems;
      var calculateLast = function calculateLast(_first, _num, _numT) {
        var _isCols = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
        return getLast(_first + _num + (_first < _numT ? 2 : 3) * _numT, _isCols);
      };
      var last = both ? {
        rows: calculateLast(firstState.rows, numItemsInViewport.rows, numToleratedItems[0]),
        cols: calculateLast(firstState.cols, numItemsInViewport.cols, numToleratedItems[1], true)
      } : calculateLast(firstState, numItemsInViewport, numToleratedItems);
      setNumItemsInViewportState(numItemsInViewport);
      setNumToleratedItemsState(numToleratedItems);
      setLastState(last);
      if (props.showLoader) {
        setLoaderArrState(both ? Array.from({
          length: numItemsInViewport.rows
        }).map(function () {
          return Array.from({
            length: numItemsInViewport.cols
          });
        }) : Array.from({
          length: numItemsInViewport
        }));
      }
      if (props.lazy) {
        Promise.resolve().then(function () {
          lazyLoadState.current = {
            first: props.step ? both ? {
              rows: 0,
              cols: firstState.cols
            } : 0 : firstState,
            last: Math.min(props.step ? props.step : last, props.items.length)
          };
          props.onLazyLoad && props.onLazyLoad(lazyLoadState.current);
        });
      }
    };
    var calculateAutoSize = function calculateAutoSize(loading) {
      if (props.autoSize && !loading) {
        Promise.resolve().then(function () {
          if (_contentRef.current) {
            _contentRef.current.style.minHeight = _contentRef.current.style.minWidth = 'auto';
            _contentRef.current.style.position = 'relative';
            elementRef.current.style.contain = 'none';

            /*const [contentWidth, contentHeight] = [DomHandler.getWidth(contentRef.current), DomHandler.getHeight(contentRef.current)];
             contentWidth !== defaultContentWidth.current && (elementRef.current.style.width = '');
            contentHeight !== defaultContentHeight.current && (elementRef.current.style.height = '');*/

            var _ref = [DomHandler.getWidth(elementRef.current), DomHandler.getHeight(elementRef.current)],
              width = _ref[0],
              height = _ref[1];
            (both || horizontal) && (elementRef.current.style.width = (width < defaultWidth.current ? width : props.scrollWidth || defaultWidth.current) + 'px');
            (both || vertical) && (elementRef.current.style.height = (height < defaultHeight.current ? height : props.scrollHeight || defaultHeight.current) + 'px');
            _contentRef.current.style.minHeight = _contentRef.current.style.minWidth = '';
            _contentRef.current.style.position = '';
            elementRef.current.style.contain = '';
          }
        });
      }
    };
    var getLast = function getLast() {
      var last = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
      var isCols = arguments.length > 1 ? arguments[1] : undefined;
      return props.items ? Math.min(isCols ? (props.columns || props.items[0]).length : props.items.length, last) : 0;
    };
    var getContentPosition = function getContentPosition() {
      if (_contentRef.current) {
        var style = getComputedStyle(_contentRef.current);
        var left = parseFloat(style.paddingLeft) + Math.max(parseFloat(style.left) || 0, 0);
        var right = parseFloat(style.paddingRight) + Math.max(parseFloat(style.right) || 0, 0);
        var top = parseFloat(style.paddingTop) + Math.max(parseFloat(style.top) || 0, 0);
        var bottom = parseFloat(style.paddingBottom) + Math.max(parseFloat(style.bottom) || 0, 0);
        return {
          left: left,
          right: right,
          top: top,
          bottom: bottom,
          x: left + right,
          y: top + bottom
        };
      }
      return {
        left: 0,
        right: 0,
        top: 0,
        bottom: 0,
        x: 0,
        y: 0
      };
    };
    var setSize = function setSize() {
      if (elementRef.current) {
        var parentElement = elementRef.current.parentElement;
        var width = props.scrollWidth || "".concat(elementRef.current.offsetWidth || parentElement.offsetWidth, "px");
        var height = props.scrollHeight || "".concat(elementRef.current.offsetHeight || parentElement.offsetHeight, "px");
        var setProp = function setProp(_name, _value) {
          return elementRef.current.style[_name] = _value;
        };
        if (both || horizontal) {
          setProp('height', height);
          setProp('width', width);
        } else {
          setProp('height', height);
        }
      }
    };
    var setSpacerSize = function setSpacerSize() {
      var items = props.items;
      if (items) {
        var contentPos = getContentPosition();
        var setProp = function setProp(_name, _value, _size) {
          var _cpos = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
          return spacerStyle.current = _objectSpread$1F(_objectSpread$1F({}, spacerStyle.current), _defineProperty({}, "".concat(_name), (_value || []).length * _size + _cpos + 'px'));
        };
        if (both) {
          setProp('height', items, props.itemSize[0], contentPos.y);
          setProp('width', props.columns || items[1], props.itemSize[1], contentPos.x);
        } else {
          horizontal ? setProp('width', props.columns || items, props.itemSize, contentPos.x) : setProp('height', items, props.itemSize, contentPos.y);
        }
      }
    };
    var setContentPosition = function setContentPosition(pos) {
      if (_contentRef.current && !props.appendOnly) {
        var first = pos ? pos.first : firstState;
        var calculateTranslateVal = function calculateTranslateVal(_first, _size) {
          return _first * _size;
        };
        var setTransform = function setTransform() {
          var _x = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
          var _y = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
          _stickyRef.current && (_stickyRef.current.style.top = "-".concat(_y, "px"));
          contentStyle.current = _objectSpread$1F(_objectSpread$1F({}, contentStyle.current), {
            transform: "translate3d(".concat(_x, "px, ").concat(_y, "px, 0)")
          });
        };
        if (both) {
          setTransform(calculateTranslateVal(first.cols, props.itemSize[1]), calculateTranslateVal(first.rows, props.itemSize[0]));
        } else {
          var translateVal = calculateTranslateVal(first, props.itemSize);
          horizontal ? setTransform(translateVal, 0) : setTransform(0, translateVal);
        }
      }
    };
    var onScrollPositionChange = function onScrollPositionChange(event) {
      var target = event.target;
      var contentPos = getContentPosition();
      var calculateScrollPos = function calculateScrollPos(_pos, _cpos) {
        return _pos ? _pos > _cpos ? _pos - _cpos : _pos : 0;
      };
      var calculateCurrentIndex = function calculateCurrentIndex(_pos, _size) {
        return Math.floor(_pos / (_size || _pos));
      };
      var calculateTriggerIndex = function calculateTriggerIndex(_currentIndex, _first, _last, _num, _numT, _isScrollDownOrRight) {
        return _currentIndex <= _numT ? _numT : _isScrollDownOrRight ? _last - _num - _numT : _first + _numT - 1;
      };
      var calculateFirst = function calculateFirst(_currentIndex, _triggerIndex, _first, _last, _num, _numT, _isScrollDownOrRight) {
        if (_currentIndex <= _numT) return 0;else return Math.max(0, _isScrollDownOrRight ? _currentIndex < _triggerIndex ? _first : _currentIndex - _numT : _currentIndex > _triggerIndex ? _first : _currentIndex - 2 * _numT);
      };
      var calculateLast = function calculateLast(_currentIndex, _first, _last, _num, _numT, _isCols) {
        var lastValue = _first + _num + 2 * _numT;
        if (_currentIndex >= _numT) {
          lastValue += _numT + 1;
        }
        return getLast(lastValue, _isCols);
      };
      var scrollTop = calculateScrollPos(target.scrollTop, contentPos.top);
      var scrollLeft = calculateScrollPos(target.scrollLeft, contentPos.left);
      var newFirst = both ? {
        rows: 0,
        cols: 0
      } : 0;
      var newLast = lastState;
      var isRangeChanged = false;
      var newScrollPos = lastScrollPos.current;
      if (both) {
        var isScrollDown = lastScrollPos.current.top <= scrollTop;
        var isScrollRight = lastScrollPos.current.left <= scrollLeft;
        if (!props.appendOnly || props.appendOnly && (isScrollDown || isScrollRight)) {
          var currentIndex = {
            rows: calculateCurrentIndex(scrollTop, props.itemSize[0]),
            cols: calculateCurrentIndex(scrollLeft, props.itemSize[1])
          };
          var triggerIndex = {
            rows: calculateTriggerIndex(currentIndex.rows, firstState.rows, lastState.rows, numItemsInViewportState.rows, numToleratedItemsState[0], isScrollDown),
            cols: calculateTriggerIndex(currentIndex.cols, firstState.cols, lastState.cols, numItemsInViewportState.cols, numToleratedItemsState[1], isScrollRight)
          };
          newFirst = {
            rows: calculateFirst(currentIndex.rows, triggerIndex.rows, firstState.rows, lastState.rows, numItemsInViewportState.rows, numToleratedItemsState[0], isScrollDown),
            cols: calculateFirst(currentIndex.cols, triggerIndex.cols, firstState.cols, lastState.cols, numItemsInViewportState.cols, numToleratedItemsState[1], isScrollRight)
          };
          newLast = {
            rows: calculateLast(currentIndex.rows, newFirst.rows, lastState.rows, numItemsInViewportState.rows, numToleratedItemsState[0]),
            cols: calculateLast(currentIndex.cols, newFirst.cols, lastState.cols, numItemsInViewportState.cols, numToleratedItemsState[1], true)
          };
          isRangeChanged = newFirst.rows !== firstState.rows || newLast.rows !== lastState.rows || newFirst.cols !== firstState.cols || newLast.cols !== lastState.cols || isItemRangeChanged.current;
          newScrollPos = {
            top: scrollTop,
            left: scrollLeft
          };
        }
      } else {
        var scrollPos = horizontal ? scrollLeft : scrollTop;
        var isScrollDownOrRight = lastScrollPos.current <= scrollPos;
        if (!props.appendOnly || props.appendOnly && isScrollDownOrRight) {
          var _currentIndex2 = calculateCurrentIndex(scrollPos, props.itemSize);
          var _triggerIndex2 = calculateTriggerIndex(_currentIndex2, firstState, lastState, numItemsInViewportState, numToleratedItemsState, isScrollDownOrRight);
          newFirst = calculateFirst(_currentIndex2, _triggerIndex2, firstState, lastState, numItemsInViewportState, numToleratedItemsState, isScrollDownOrRight);
          newLast = calculateLast(_currentIndex2, newFirst, lastState, numItemsInViewportState, numToleratedItemsState);
          isRangeChanged = newFirst !== firstState || newLast !== lastState || isItemRangeChanged.current;
          newScrollPos = scrollPos;
        }
      }
      return {
        first: newFirst,
        last: newLast,
        isRangeChanged: isRangeChanged,
        scrollPos: newScrollPos
      };
    };
    var onScrollChange = function onScrollChange(event) {
      var _onScrollPositionChan = onScrollPositionChange(event),
        first = _onScrollPositionChan.first,
        last = _onScrollPositionChan.last,
        isRangeChanged = _onScrollPositionChan.isRangeChanged,
        scrollPos = _onScrollPositionChan.scrollPos;
      if (isRangeChanged) {
        var newState = {
          first: first,
          last: last
        };
        setContentPosition(newState);
        setFirstState(first);
        setLastState(last);
        lastScrollPos.current = scrollPos;
        props.onScrollIndexChange && props.onScrollIndexChange(newState);
        if (props.lazy && isPageChanged(first)) {
          var newLazyLoadState = {
            first: props.step ? Math.min(getPageByFirst(first) * props.step, props.items.length - props.step) : first,
            last: Math.min(props.step ? (getPageByFirst(first) + 1) * props.step : last, props.items.length)
          };
          var isLazyStateChanged = !lazyLoadState.current || lazyLoadState.current.first !== newLazyLoadState.first || lazyLoadState.current.last !== newLazyLoadState.last;
          isLazyStateChanged && props.onLazyLoad && props.onLazyLoad(newLazyLoadState);
          lazyLoadState.current = newLazyLoadState;
        }
      }
    };
    var _onScroll = function onScroll(event) {
      props.onScroll && props.onScroll(event);
      if (props.delay) {
        if (scrollTimeout.current) {
          clearTimeout(scrollTimeout.current);
        }
        if (isPageChanged(firstState)) {
          if (!loadingState && props.showLoader) {
            var _onScrollPositionChan2 = onScrollPositionChange(event),
              isRangeChanged = _onScrollPositionChan2.isRangeChanged;
            var changed = isRangeChanged || (props.step ? isPageChanged(firstState) : false);
            changed && setLoadingState(true);
          }
          scrollTimeout.current = setTimeout(function () {
            onScrollChange(event);
            if (loadingState && props.showLoader && (!props.lazy || props.loading === undefined)) {
              setLoadingState(false);
              setPageState(getPageByFirst(firstState));
            }
          }, props.delay);
        }
      } else {
        onScrollChange(event);
      }
    };
    var onResize = function onResize() {
      if (resizeTimeout.current) {
        clearTimeout(resizeTimeout.current);
      }
      resizeTimeout.current = setTimeout(function () {
        if (elementRef.current) {
          var _ref2 = [DomHandler.getWidth(elementRef.current), DomHandler.getHeight(elementRef.current)],
            width = _ref2[0],
            height = _ref2[1];
          var isDiffWidth = width !== defaultWidth.current,
            isDiffHeight = height !== defaultHeight.current;
          var reinit = both ? isDiffWidth || isDiffHeight : horizontal ? isDiffWidth : vertical ? isDiffHeight : false;
          if (reinit) {
            setNumToleratedItemsState(props.numToleratedItems);
            defaultWidth.current = width;
            defaultHeight.current = height;
            defaultContentWidth.current = DomHandler.getWidth(_contentRef.current);
            defaultContentHeight.current = DomHandler.getHeight(_contentRef.current);
          }
        }
      }, props.resizeDelay);
    };
    var getOptions = function getOptions(renderedIndex) {
      var count = (props.items || []).length;
      var index = both ? firstState.rows + renderedIndex : firstState + renderedIndex;
      return {
        index: index,
        count: count,
        first: index === 0,
        last: index === count - 1,
        even: index % 2 === 0,
        odd: index % 2 !== 0,
        props: props
      };
    };
    var loaderOptions = function loaderOptions(index, extOptions) {
      var count = loaderArrState.length;
      return _objectSpread$1F({
        index: index,
        count: count,
        first: index === 0,
        last: index === count - 1,
        even: index % 2 === 0,
        odd: index % 2 !== 0,
        props: props
      }, extOptions);
    };
    var loadedItems = function loadedItems() {
      var items = props.items;
      if (items && !loadingState) {
        if (both) return items.slice(props.appendOnly ? 0 : firstState.rows, lastState.rows).map(function (item) {
          return props.columns ? item : item.slice(props.appendOnly ? 0 : firstState.cols, lastState.cols);
        });else if (horizontal && props.columns) return items;else return items.slice(props.appendOnly ? 0 : firstState, lastState);
      }
      return [];
    };
    var viewInit = function viewInit() {
      if (elementRef.current && DomHandler.isVisible(elementRef.current)) {
        setContentElement(_contentRef.current);
        init();
        bindWindowResizeListener();
        bindOrientationChangeListener();
        defaultWidth.current = DomHandler.getWidth(elementRef.current);
        defaultHeight.current = DomHandler.getHeight(elementRef.current);
        defaultContentWidth.current = DomHandler.getWidth(_contentRef.current);
        defaultContentHeight.current = DomHandler.getHeight(_contentRef.current);
      }
    };
    var init = function init() {
      if (!props.disabled) {
        setSize();
        calculateOptions();
        setSpacerSize();
      }
    };
    useMountEffect(function () {
      viewInit();
    });
    useUpdateEffect(function () {
      init();
    }, [props.itemSize, props.scrollHeight, props.scrollWidth]);
    useUpdateEffect(function () {
      if (props.numToleratedItems !== numToleratedItemsState) {
        setNumToleratedItemsState(props.numToleratedItems);
      }
    }, [props.numToleratedItems]);
    useUpdateEffect(function () {
      if (props.numToleratedItems === numToleratedItemsState) {
        init(); // reinit after resizing
      }
    }, [numToleratedItemsState]);
    useUpdateEffect(function () {
      if (!prevProps.items || prevProps.items.length !== (props.items || []).length) {
        init();
      }
      var loading = loadingState;
      if (props.lazy && prevProps.loading !== props.loading && props.loading !== loadingState) {
        setLoadingState(props.loading);
        loading = props.loading;
      }
      calculateAutoSize(loading);
    });
    useUpdateEffect(function () {
      lastScrollPos.current = both ? {
        top: 0,
        left: 0
      } : 0;
    }, [props.orientation]);
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        getElementRef: getElementRef,
        scrollTo: scrollTo,
        scrollToIndex: scrollToIndex,
        scrollInView: scrollInView,
        getRenderedRange: getRenderedRange
      };
    });
    var createLoaderItem = function createLoaderItem(index) {
      var extOptions = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var options = loaderOptions(index, extOptions);
      var content = ObjectUtils.getJSXElement(props.loadingTemplate, options);
      return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, {
        key: index
      }, content);
    };
    var createLoader = function createLoader() {
      var iconClassName = 'p-virtualscroller-loading-icon';
      var loadingIconProps = mergeProps({
        className: iconClassName
      }, ptm('loadingIcon'));
      var icon = props.loadingIcon || /*#__PURE__*/React__namespace.createElement(SpinnerIcon, _extends({}, loadingIconProps, {
        spin: true
      }));
      var loadingIcon = IconUtils.getJSXIcon(icon, _objectSpread$1F({}, loadingIconProps), {
        props: props
      });
      if (!props.loaderDisabled && props.showLoader && loadingState) {
        var className = classNames('p-virtualscroller-loader', {
          'p-component-overlay': !props.loadingTemplate
        });
        var content = loadingIcon;
        if (props.loadingTemplate) {
          content = loaderArrState.map(function (_, index) {
            return createLoaderItem(index, both && {
              numCols: numItemsInViewportState.cols
            });
          });
        } else if (props.loaderIconTemplate) {
          var defaultContentOptions = {
            iconClassName: iconClassName,
            element: content,
            props: props
          };
          content = ObjectUtils.getJSXElement(props.loaderIconTemplate, defaultContentOptions);
        }
        var loaderProps = mergeProps({
          className: className
        }, ptm('loader'));
        return /*#__PURE__*/React__namespace.createElement("div", loaderProps, content);
      }
      return null;
    };
    var createSpacer = function createSpacer() {
      if (props.showSpacer) {
        var spacerProps = mergeProps({
          ref: _spacerRef,
          style: spacerStyle.current,
          className: 'p-virtualscroller-spacer'
        }, ptm('spacer'));
        return /*#__PURE__*/React__namespace.createElement("div", spacerProps);
      }
      return null;
    };
    var createItem = function createItem(item, index) {
      var options = getOptions(index);
      var content = ObjectUtils.getJSXElement(props.itemTemplate, item, options);
      return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, {
        key: options.index
      }, content);
    };
    var createItems = function createItems() {
      var items = loadedItems();
      return items.map(createItem);
    };
    var createContent = function createContent() {
      var items = createItems();
      var className = classNames('p-virtualscroller-content', {
        'p-virtualscroller-loading': loadingState
      });
      var contentProps = mergeProps({
        ref: _contentRef,
        style: contentStyle.current,
        className: className
      }, ptm('content'));
      var content = /*#__PURE__*/React__namespace.createElement("div", contentProps, items);
      if (props.contentTemplate) {
        var defaultOptions = {
          style: contentStyle.current,
          className: className,
          spacerStyle: spacerStyle.current,
          contentRef: function contentRef(el) {
            return _contentRef.current = ObjectUtils.getRefElement(el);
          },
          spacerRef: function spacerRef(el) {
            return _spacerRef.current = ObjectUtils.getRefElement(el);
          },
          stickyRef: function stickyRef(el) {
            return _stickyRef.current = ObjectUtils.getRefElement(el);
          },
          items: loadedItems(),
          getItemOptions: function getItemOptions(index) {
            return getOptions(index);
          },
          children: items,
          element: content,
          props: props,
          loading: loadingState,
          getLoaderOptions: function getLoaderOptions(index, ext) {
            return loaderOptions(index, ext);
          },
          loadingTemplate: props.loadingTemplate,
          itemSize: props.itemSize,
          rows: getRows(),
          columns: getColumns(),
          vertical: vertical,
          horizontal: horizontal,
          both: both
        };
        return ObjectUtils.getJSXElement(props.contentTemplate, defaultOptions);
      }
      return content;
    };
    if (props.disabled) {
      var content = ObjectUtils.getJSXElement(props.contentTemplate, {
        items: props.items,
        rows: props.items,
        columns: props.columns
      });
      return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, null, props.children, content);
    } else {
      var className = classNames('p-virtualscroller', {
        'p-virtualscroller-inline': props.inline,
        'p-virtualscroller-both p-both-scroll': both,
        'p-virtualscroller-horizontal p-horizontal-scroll': horizontal
      }, props.className);
      var loader = createLoader();
      var _content = createContent();
      var spacer = createSpacer();
      var rootProps = mergeProps({
        ref: elementRef,
        className: className,
        tabIndex: props.tabIndex,
        style: props.style,
        onScroll: function onScroll(e) {
          return _onScroll(e);
        }
      }, VirtualScrollerBase.getOtherProps(props), ptm('root'));
      return /*#__PURE__*/React__namespace.createElement("div", rootProps, _content, spacer, loader);
    }
  }));
  VirtualScroller.displayName = 'VirtualScroller';

  function ownKeys$1E(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1E(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1E(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1E(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var AutoCompletePanel = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (props, ref) {
    var ptm = props.ptm,
      cx = props.cx;
    var context = React__namespace.useContext(PrimeReactContext);
    var _ptm = function _ptm(key, options) {
      return ptm(key, _objectSpread$1E({
        hostName: props.hostName
      }, options));
    };
    var getPTOptions = function getPTOptions(item, key) {
      return _ptm(key, {
        context: {
          selected: props.selectedItem.current === item,
          disabled: item.disabled
        }
      });
    };
    var getOptionGroupRenderKey = function getOptionGroupRenderKey(optionGroup) {
      return ObjectUtils.resolveFieldData(optionGroup, props.optionGroupLabel);
    };
    var createFooter = function createFooter() {
      if (props.panelFooterTemplate) {
        var content = ObjectUtils.getJSXElement(props.panelFooterTemplate, props, props.onOverlayHide);
        var footerProps = mergeProps({
          className: cx('footer')
        }, _ptm('footer'));
        return /*#__PURE__*/React__namespace.createElement("div", footerProps, content);
      }
      return null;
    };
    var createGroupChildren = function createGroupChildren(optionGroup, i, style) {
      var groupChildren = props.getOptionGroupChildren(optionGroup);
      return groupChildren.map(function (item, j) {
        var key = i + '_' + j;
        var selected = props.selectedItem === item;
        var content = props.itemTemplate ? ObjectUtils.getJSXElement(props.itemTemplate, item, j) : props.field ? ObjectUtils.resolveFieldData(item, props.field) : item;
        var itemProps = mergeProps({
          role: 'option',
          className: cx('item', {
            optionGroupLabel: props.optionGroupLabel,
            suggestion: item
          }),
          style: style,
          onClick: function onClick(e) {
            return props.onItemClick(e, item);
          },
          'aria-selected': selected,
          'data-group': i,
          'data-index': j,
          'data-p-disabled': item.disabled
        }, getPTOptions(item, 'item'));
        return /*#__PURE__*/React__namespace.createElement("li", _extends({
          key: key
        }, itemProps), content, /*#__PURE__*/React__namespace.createElement(Ripple, null));
      });
    };
    var createItem = function createItem(suggestion, index) {
      var scrollerOptions = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
      var style = {
        height: scrollerOptions.props ? scrollerOptions.props.itemSize : undefined
      };
      if (props.optionGroupLabel) {
        var content = props.optionGroupTemplate ? ObjectUtils.getJSXElement(props.optionGroupTemplate, suggestion, index) : props.getOptionGroupLabel(suggestion);
        var childrenContent = createGroupChildren(suggestion, index, style);
        var key = index + '_' + getOptionGroupRenderKey(suggestion);
        var itemGroupProps = mergeProps({
          className: cx('itemGroup'),
          style: style,
          'data-p-highlight': false
        }, _ptm('itemGroup'));
        return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, {
          key: key
        }, /*#__PURE__*/React__namespace.createElement("li", itemGroupProps, content), childrenContent);
      } else {
        var _content = props.itemTemplate ? ObjectUtils.getJSXElement(props.itemTemplate, suggestion, index) : props.field ? ObjectUtils.resolveFieldData(suggestion, props.field) : suggestion;
        var itemProps = mergeProps({
          index: index,
          role: 'option',
          className: cx('item', {
            suggestion: suggestion
          }),
          style: style,
          onClick: function onClick(e) {
            return props.onItemClick(e, suggestion);
          },
          'aria-selected': props.selectedItem.current === suggestion,
          'data-p-disabled': suggestion.disabled
        }, getPTOptions(suggestion, 'item'));
        return /*#__PURE__*/React__namespace.createElement("li", _extends({
          key: index
        }, itemProps), _content, /*#__PURE__*/React__namespace.createElement(Ripple, null));
      }
    };
    var createItems = function createItems() {
      return props.suggestions ? props.suggestions.map(createItem) : null;
    };
    var createContent = function createContent() {
      if (props.showEmptyMessage && ObjectUtils.isEmpty(props.suggestions)) {
        var emptyMessage = props.emptyMessage || localeOption('emptyMessage');
        var emptyMessageProps = mergeProps({
          className: cx('emptyMessage')
        }, _ptm('emptyMesage'));
        var listProps = mergeProps({
          className: cx('list')
        }, _ptm('list'));
        return /*#__PURE__*/React__namespace.createElement("ul", listProps, /*#__PURE__*/React__namespace.createElement("li", emptyMessageProps, emptyMessage));
      }
      if (props.virtualScrollerOptions) {
        var virtualScrollerProps = _objectSpread$1E(_objectSpread$1E({}, props.virtualScrollerOptions), {
          style: _objectSpread$1E(_objectSpread$1E({}, props.virtualScrollerOptions.style), {
            height: props.scrollHeight
          }),
          autoSize: true,
          items: props.suggestions,
          itemTemplate: function itemTemplate(item, options) {
            return item && createItem(item, options.index, options);
          },
          contentTemplate: function contentTemplate(options) {
            var listProps = mergeProps({
              id: props.listId,
              ref: options.contentRef,
              style: options.style,
              className: cx('list', {
                virtualScrollerProps: virtualScrollerProps,
                options: options
              }),
              role: 'listbox'
            }, _ptm('list'));
            return /*#__PURE__*/React__namespace.createElement("ul", listProps, options.children);
          }
        });
        return /*#__PURE__*/React__namespace.createElement(VirtualScroller, _extends({
          ref: props.virtualScrollerRef
        }, virtualScrollerProps, {
          pt: _ptm('virtualScroller'),
          __parentMetadata: {
            parent: props.metaData
          }
        }));
      } else {
        var items = createItems();
        var _listProps = mergeProps({
          id: props.listId,
          className: cx('list'),
          role: 'listbox'
        }, _ptm('list'));
        var listWrapperProps = mergeProps({
          className: cx('listWrapper'),
          style: {
            maxHeight: props.scrollHeight || 'auto'
          }
        }, _ptm('listWrapper'));
        return /*#__PURE__*/React__namespace.createElement("div", listWrapperProps, /*#__PURE__*/React__namespace.createElement("ul", _listProps, items));
      }
    };
    var createElement = function createElement() {
      var style = _objectSpread$1E({}, props.panelStyle || {});
      var content = createContent();
      var footer = createFooter();
      var panelProps = mergeProps({
        className: classNames(props.panelClassName, cx('panel', {
          context: context
        })),
        style: style,
        onClick: function onClick(e) {
          return props.onClick(e);
        }
      }, _ptm('panel'));
      var transitionProps = mergeProps({
        classNames: cx('transition'),
        "in": props["in"],
        timeout: {
          enter: 120,
          exit: 100
        },
        options: props.transitionOptions,
        unmountOnExit: true,
        onEnter: props.onEnter,
        onEntering: props.onEntering,
        onEntered: props.onEntered,
        onExit: props.onExit,
        onExited: props.onExited
      }, _ptm('transition'));
      return /*#__PURE__*/React__namespace.createElement(CSSTransition, _extends({
        nodeRef: ref
      }, transitionProps), /*#__PURE__*/React__namespace.createElement("div", _extends({
        ref: ref
      }, panelProps), content, footer));
    };
    var element = createElement();
    return /*#__PURE__*/React__namespace.createElement(Portal, {
      element: element,
      appendTo: props.appendTo
    });
  }));
  AutoCompletePanel.displayName = 'AutoCompletePanel';

  function ownKeys$1D(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1D(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1D(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1D(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var AutoComplete = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var context = React__namespace.useContext(PrimeReactContext);
    var props = AutoCompleteBase.getProps(inProps, context);
    var _React$useState = React__namespace.useState(props.id),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      idState = _React$useState2[0],
      setIdState = _React$useState2[1];
    var _React$useState3 = React__namespace.useState(false),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      searchingState = _React$useState4[0],
      setSearchingState = _React$useState4[1];
    var _React$useState5 = React__namespace.useState(false),
      _React$useState6 = _slicedToArray(_React$useState5, 2),
      focusedState = _React$useState6[0],
      setFocusedState = _React$useState6[1];
    var _React$useState7 = React__namespace.useState(false),
      _React$useState8 = _slicedToArray(_React$useState7, 2),
      overlayVisibleState = _React$useState8[0],
      setOverlayVisibleState = _React$useState8[1];
    var metaData = {
      props: props,
      state: {
        id: idState,
        searching: searchingState,
        focused: focusedState,
        overlayVisible: overlayVisibleState
      }
    };
    var _AutoCompleteBase$set = AutoCompleteBase.setMetaData(metaData),
      ptm = _AutoCompleteBase$set.ptm,
      cx = _AutoCompleteBase$set.cx,
      sx = _AutoCompleteBase$set.sx,
      isUnstyled = _AutoCompleteBase$set.isUnstyled;
    useHandleStyle(AutoCompleteBase.css.styles, isUnstyled, {
      name: 'autocomplete'
    });
    var elementRef = React__namespace.useRef(null);
    var overlayRef = React__namespace.useRef(null);
    var inputRef = React__namespace.useRef(props.inputRef);
    var multiContainerRef = React__namespace.useRef(null);
    var virtualScrollerRef = React__namespace.useRef(null);
    var timeout = React__namespace.useRef(null);
    var selectedItem = React__namespace.useRef(null);
    var _useOverlayListener = useOverlayListener({
        target: elementRef,
        overlay: overlayRef,
        listener: function listener(event, _ref) {
          var type = _ref.type,
            valid = _ref.valid;
          if (valid) {
            type === 'outside' ? !isInputClicked(event) && hide() : hide();
          }
        },
        when: overlayVisibleState
      }),
      _useOverlayListener2 = _slicedToArray(_useOverlayListener, 2),
      bindOverlayListener = _useOverlayListener2[0],
      unbindOverlayListener = _useOverlayListener2[1];
    var isInputClicked = function isInputClicked(event) {
      return props.multiple ? event.target === multiContainerRef.current || multiContainerRef.current.contains(event.target) : event.target === inputRef.current;
    };
    var onInputChange = function onInputChange(event) {
      //Cancel the search request if user types within the timeout
      if (timeout.current) {
        clearTimeout(timeout.current);
      }
      var query = event.target.value;
      if (!props.multiple) {
        updateModel(event, query);
      }
      if (ObjectUtils.isEmpty(query)) {
        hide();
        props.onClear && props.onClear(event);
      } else {
        if (query.length >= props.minLength) {
          timeout.current = setTimeout(function () {
            search(event, query, 'input');
          }, props.delay);
        } else {
          hide();
        }
      }
    };
    var search = function search(event, query, source) {
      //allow empty string but not undefined or null
      if (query === undefined || query === null) {
        return;
      }

      //do not search blank values on input change
      if (source === 'input' && query.trim().length === 0) {
        return;
      }
      if (props.completeMethod) {
        setSearchingState(true);
        props.completeMethod({
          originalEvent: event,
          query: query
        });
      }
    };
    var selectItem = function selectItem(event, option, preventInputFocus) {
      if (props.multiple) {
        inputRef.current.value = '';

        // allows empty value/selectionlimit and within sectionlimit
        if (!isSelected(option) && isAllowMoreValues()) {
          var newValue = props.value ? [].concat(_toConsumableArray(props.value), [option]) : [option];
          updateModel(event, newValue);
        }
      } else {
        updateInputField(option);
        updateModel(event, option);
      }
      if (props.onSelect) {
        props.onSelect({
          originalEvent: event,
          value: option
        });
      }
      if (!preventInputFocus) {
        DomHandler.focus(inputRef.current);
        hide();
      }
    };
    var updateModel = function updateModel(event, value) {
      // #2176 only call change if value actually changed
      if (selectedItem && ObjectUtils.deepEquals(selectedItem.current, value)) {
        return;
      }
      if (props.onChange) {
        props.onChange({
          originalEvent: event,
          value: value,
          stopPropagation: function stopPropagation() {
            event.stopPropagation();
          },
          preventDefault: function preventDefault() {
            event.preventDefault();
          },
          target: {
            name: props.name,
            id: idState,
            value: value
          }
        });
      }
      selectedItem.current = ObjectUtils.isNotEmpty(value) ? value : null;
    };
    var formatValue = function formatValue(value) {
      if (ObjectUtils.isNotEmpty(value)) {
        if (typeof value === 'string') {
          return value;
        } else if (props.selectedItemTemplate) {
          var resolvedFieldData = ObjectUtils.getJSXElement(props.selectedItemTemplate, value);
          return resolvedFieldData ? resolvedFieldData : value;
        } else if (props.field) {
          var _resolvedFieldData = ObjectUtils.resolveFieldData(value, props.field);
          return _resolvedFieldData !== null && _resolvedFieldData !== undefined ? _resolvedFieldData : value;
        } else {
          return value;
        }
      }
      return '';
    };
    var updateInputField = function updateInputField(value) {
      inputRef.current.value = formatValue(value);
    };
    var show = function show() {
      setOverlayVisibleState(true);
    };
    var hide = function hide() {
      setOverlayVisibleState(false);
      setSearchingState(false);
    };
    var onOverlayEnter = function onOverlayEnter() {
      ZIndexUtils.set('overlay', overlayRef.current, context && context.autoZIndex || PrimeReact.autoZIndex, context && context.zIndex['overlay'] || PrimeReact.zIndex['overlay']);
      DomHandler.addStyles(overlayRef.current, {
        position: 'absolute',
        top: '0',
        left: '0'
      });
      alignOverlay();
    };
    var onOverlayEntering = function onOverlayEntering() {
      if (props.autoHighlight && props.suggestions && props.suggestions.length) {
        var element = getScrollableElement().firstChild.firstChild;
        if (element) {
          !isUnstyled() && DomHandler.addClass(element, 'p-highlight');
          element.setAttribute('data-p-highlight', true);
        }
      }
    };
    var onOverlayEntered = function onOverlayEntered() {
      bindOverlayListener();
      props.onShow && props.onShow();
    };
    var onOverlayExit = function onOverlayExit() {
      unbindOverlayListener();
    };
    var onOverlayExited = function onOverlayExited() {
      ZIndexUtils.clear(overlayRef.current);
      props.onHide && props.onHide();
    };
    var alignOverlay = function alignOverlay() {
      var target = props.multiple ? multiContainerRef.current : inputRef.current;
      DomHandler.alignOverlay(overlayRef.current, target, props.appendTo || context && context.appendTo || PrimeReact.appendTo);
    };
    var onPanelClick = function onPanelClick(event) {
      OverlayService.emit('overlay-click', {
        originalEvent: event,
        target: elementRef.current
      });
    };
    var onDropdownClick = function onDropdownClick(event) {
      if (props.dropdownAutoFocus) {
        DomHandler.focus(inputRef.current, props.dropdownAutoFocus);
      }
      if (props.dropdownMode === 'blank') search(event, '', 'dropdown');else if (props.dropdownMode === 'current') search(event, inputRef.current.value, 'dropdown');
      if (props.onDropdownClick) {
        props.onDropdownClick({
          originalEvent: event,
          query: inputRef.current.value
        });
      }
    };
    var removeItem = function removeItem(event, index) {
      var removedValue = props.value[index];
      var newValue = props.value.filter(function (_, i) {
        return index !== i;
      });
      updateModel(event, newValue);
      if (props.onUnselect) {
        props.onUnselect({
          originalEvent: event,
          value: removedValue
        });
      }
    };
    var onInputKeyDown = function onInputKeyDown(event) {
      if (overlayVisibleState) {
        var highlightItem = DomHandler.findSingle(overlayRef.current, 'li[data-p-highlight="true"]');
        switch (event.which) {
          //down
          case 40:
            if (highlightItem) {
              var nextElement = findNextItem(highlightItem);
              if (nextElement) {
                !isUnstyled() && DomHandler.addClass(nextElement, 'p-highlight');
                nextElement.setAttribute('data-p-highlight', true);
                !isUnstyled() && DomHandler.removeClass(highlightItem, 'p-highlight');
                highlightItem.setAttribute('data-p-highlight', false);
                DomHandler.scrollInView(getScrollableElement(), nextElement);
              }
            } else {
              highlightItem = DomHandler.findSingle(overlayRef.current, 'li');
              if (DomHandler.getAttribute(highlightItem, 'data-pc-section') === 'itemgroup') {
                highlightItem = findNextItem(highlightItem);
              }
              if (highlightItem) {
                !isUnstyled() && DomHandler.addClass(highlightItem, 'p-highlight');
                highlightItem.setAttribute('data-p-highlight', true);
              }
            }
            event.preventDefault();
            break;

          //up
          case 38:
            if (highlightItem) {
              var previousElement = findPrevItem(highlightItem);
              if (previousElement) {
                !isUnstyled() && DomHandler.addClass(previousElement, 'p-highlight');
                previousElement.setAttribute('data-p-highlight', true);
                !isUnstyled() && DomHandler.removeClass(highlightItem, 'p-highlight');
                highlightItem.setAttribute('data-p-highlight', false);
                DomHandler.scrollInView(getScrollableElement(), previousElement);
              }
            }
            event.preventDefault();
            break;

          //enter
          case 13:
            if (highlightItem) {
              selectHighlightItem(event, highlightItem);
              hide();
              event.preventDefault();
            }
            break;

          //escape
          case 27:
            hide();
            event.preventDefault();
            break;

          //tab
          case 9:
            if (highlightItem) {
              selectHighlightItem(event, highlightItem);
            }
            hide();
            break;
        }
      }
      if (props.multiple) {
        switch (event.which) {
          //backspace
          case 8:
            if (props.value && props.value.length && !inputRef.current.value) {
              var removedValue = props.value[props.value.length - 1];
              var newValue = props.value.slice(0, -1);
              updateModel(event, newValue);
              if (props.onUnselect) {
                props.onUnselect({
                  originalEvent: event,
                  value: removedValue
                });
              }
            }
            break;
        }
      }
    };
    var selectHighlightItem = function selectHighlightItem(event, item) {
      if (props.optionGroupLabel) {
        var optionGroup = props.suggestions[item.dataset.group];
        selectItem(event, getOptionGroupChildren(optionGroup)[item.dataset.index]);
      } else {
        selectItem(event, props.suggestions[item.getAttribute('index')]);
      }
    };
    var findNextItem = function findNextItem(item) {
      var nextItem = item.nextElementSibling;
      return nextItem ? DomHandler.getAttribute(nextItem, 'data-pc-section') === 'itemgroup' ? findNextItem(nextItem) : nextItem : null;
    };
    var findPrevItem = function findPrevItem(item) {
      var prevItem = item.previousElementSibling;
      return prevItem ? DomHandler.getAttribute(prevItem, 'data-pc-section') === 'itemgroup' ? findPrevItem(prevItem) : prevItem : null;
    };
    var onInputFocus = function onInputFocus(event) {
      setFocusedState(true);
      props.onFocus && props.onFocus(event);
    };
    var forceItemSelection = function forceItemSelection(event) {
      if (props.multiple) {
        inputRef.current.value = '';
        return;
      }
      var inputValue = ObjectUtils.trim(event.target.value);
      var item = (props.suggestions || []).find(function (it) {
        var value = props.field ? ObjectUtils.resolveFieldData(it, props.field) : it;
        return value && inputValue === ObjectUtils.trim(value);
      });
      if (item) {
        selectItem(event, item, true);
      } else {
        inputRef.current.value = '';
        updateModel(event, null);
        props.onClear && props.onClear(event);
      }
    };
    var onInputBlur = function onInputBlur(event) {
      setFocusedState(false);
      if (props.forceSelection) {
        forceItemSelection(event);
      }
      props.onBlur && props.onBlur(event);
    };
    var onMultiContainerClick = function onMultiContainerClick(event) {
      DomHandler.focus(inputRef.current);
      props.onClick && props.onClick(event);
    };
    var onMultiInputFocus = function onMultiInputFocus(event) {
      onInputFocus(event);
      !isUnstyled() && DomHandler.addClass(multiContainerRef.current, 'p-focus');
      multiContainerRef.current.setAttribute('data-p-focus', true);
    };
    var onMultiInputBlur = function onMultiInputBlur(event) {
      onInputBlur(event);
      !isUnstyled() && DomHandler.removeClass(multiContainerRef.current, 'p-focus');
      multiContainerRef.current.setAttribute('data-p-focus', false);
    };
    var isSelected = function isSelected(val) {
      return props.value ? props.value.some(function (v) {
        return ObjectUtils.equals(v, val);
      }) : false;
    };
    var getScrollableElement = function getScrollableElement() {
      return overlayRef.current.firstChild;
    };
    var getOptionGroupLabel = function getOptionGroupLabel(optionGroup) {
      return props.optionGroupLabel ? ObjectUtils.resolveFieldData(optionGroup, props.optionGroupLabel) : optionGroup;
    };
    var getOptionGroupChildren = function getOptionGroupChildren(optionGroup) {
      return ObjectUtils.resolveFieldData(optionGroup, props.optionGroupChildren);
    };
    var isAllowMoreValues = function isAllowMoreValues() {
      return !props.value || !props.selectionLimit || props.value.length < props.selectionLimit;
    };
    React__namespace.useEffect(function () {
      ObjectUtils.combinedRefs(inputRef, props.inputRef);
    }, [inputRef, props.inputRef]);
    useMountEffect(function () {
      if (!idState) {
        setIdState(UniqueComponentId());
      }
      if (props.autoFocus) {
        DomHandler.focus(inputRef.current, props.autoFocus);
      }
      alignOverlay();
    });
    useUpdateEffect(function () {
      if (searchingState) {
        ObjectUtils.isNotEmpty(props.suggestions) || props.showEmptyMessage ? show() : hide();
        setSearchingState(false);
      }
    }, [props.suggestions]);
    useUpdateEffect(function () {
      if (inputRef.current && !props.multiple) {
        updateInputField(props.value);
      }
      if (overlayVisibleState) {
        alignOverlay();
      }
    });
    useUnmountEffect(function () {
      if (timeout.current) {
        clearTimeout(timeout.current);
      }
      ZIndexUtils.clear(overlayRef.current);
    });
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        search: search,
        show: show,
        hide: hide,
        focus: function focus() {
          return DomHandler.focus(inputRef.current);
        },
        getElement: function getElement() {
          return elementRef.current;
        },
        getOverlay: function getOverlay() {
          return overlayRef.current;
        },
        getInput: function getInput() {
          return inputRef.current;
        },
        getVirtualScroller: function getVirtualScroller() {
          return virtualScrollerRef.current;
        }
      };
    });
    var createSimpleAutoComplete = function createSimpleAutoComplete() {
      var value = formatValue(props.value);
      var ariaControls = overlayVisibleState ? idState + '_list' : null;
      return /*#__PURE__*/React__namespace.createElement(InputText, _extends({
        ref: inputRef,
        id: props.inputId,
        type: props.type,
        name: props.name,
        defaultValue: value,
        role: "combobox",
        "aria-autocomplete": "list",
        "aria-controls": ariaControls,
        "aria-haspopup": "listbox",
        "aria-expanded": overlayVisibleState,
        className: classNames(props.inputClassName, cx('input')),
        style: props.inputStyle,
        autoComplete: "off",
        readOnly: props.readOnly,
        required: props.required,
        disabled: props.disabled,
        placeholder: props.placeholder,
        size: props.size,
        maxLength: props.maxLength,
        tabIndex: props.tabIndex,
        onBlur: onInputBlur,
        onFocus: onInputFocus,
        onChange: onInputChange,
        onMouseDown: props.onMouseDown,
        onKeyUp: props.onKeyUp,
        onKeyDown: onInputKeyDown,
        onKeyPress: props.onKeyPress,
        onContextMenu: props.onContextMenu,
        onClick: props.onClick,
        onDoubleClick: props.onDblClick,
        pt: ptm('input')
      }, ariaProps, {
        __parentMetadata: {
          parent: metaData
        }
      }));
    };
    var createChips = function createChips() {
      if (ObjectUtils.isNotEmpty(props.value)) {
        return props.value.map(function (val, index) {
          var key = index + 'multi-item';
          var removeTokenIconProps = mergeProps({
            className: cx('removeTokenIcon'),
            onClick: function onClick(e) {
              return removeItem(e, index);
            }
          }, ptm('removeTokenIcon'));
          var icon = props.removeTokenIcon || /*#__PURE__*/React__namespace.createElement(TimesCircleIcon, removeTokenIconProps);
          var removeTokenIcon = !props.disabled && IconUtils.getJSXIcon(icon, _objectSpread$1D({}, removeTokenIconProps), {
            props: props
          });
          var tokenProps = mergeProps({
            className: cx('token')
          }, ptm('token'));
          var tokenLabelProps = mergeProps({
            className: cx('tokenLabel')
          }, ptm('tokenLabel'));
          return /*#__PURE__*/React__namespace.createElement("li", _extends({
            key: key
          }, tokenProps), /*#__PURE__*/React__namespace.createElement("span", tokenLabelProps, formatValue(val)), removeTokenIcon);
        });
      }
      return null;
    };
    var createMultiInput = function createMultiInput(allowMoreValues) {
      var ariaControls = overlayVisibleState ? idState + '_list' : null;
      var inputTokenProps = mergeProps({
        className: cx('inputToken')
      }, ptm('inputToken'));
      var inputProps = mergeProps(_objectSpread$1D({
        id: props.inputId,
        ref: inputRef,
        'aria-autocomplete': 'list',
        'aria-controls': ariaControls,
        'aria-expanded': overlayVisibleState,
        'aria-haspopup': 'listbox',
        autoComplete: 'off',
        className: props.inputClassName,
        disabled: props.disabled,
        maxLength: props.maxLength,
        name: props.name,
        onBlur: onMultiInputBlur,
        onChange: allowMoreValues ? onInputChange : undefined,
        onFocus: onMultiInputFocus,
        onKeyDown: allowMoreValues ? onInputKeyDown : undefined,
        onKeyPress: props.onKeyPress,
        onKeyUp: props.onKeyUp,
        placeholder: allowMoreValues ? props.placeholder : undefined,
        readOnly: props.readOnly || !allowMoreValues,
        required: props.required,
        role: 'combobox',
        style: props.inputStyle,
        tabIndex: props.tabIndex,
        type: props.type
      }, ariaProps), ptm('input'));
      return /*#__PURE__*/React__namespace.createElement("li", inputTokenProps, /*#__PURE__*/React__namespace.createElement("input", inputProps));
    };
    var createMultipleAutoComplete = function createMultipleAutoComplete() {
      var allowMoreValues = isAllowMoreValues();
      var tokens = createChips();
      var input = createMultiInput(allowMoreValues);
      var containerProps = mergeProps({
        ref: multiContainerRef,
        className: cx('container'),
        onClick: allowMoreValues ? onMultiContainerClick : undefined,
        onContextMenu: props.onContextMenu,
        onMouseDown: props.onMouseDown,
        onDoubleClick: props.onDblClick,
        'data-p-focus': focusedState,
        'data-p-disabled': props.disabled
      }, ptm('container'));
      return /*#__PURE__*/React__namespace.createElement("ul", containerProps, tokens, input);
    };
    var createDropdown = function createDropdown() {
      if (props.dropdown) {
        var ariaLabel = props.dropdownAriaLabel || props.placeholder || localeOption('choose');
        return /*#__PURE__*/React__namespace.createElement(Button, {
          type: "button",
          icon: props.dropdownIcon || /*#__PURE__*/React__namespace.createElement(ChevronDownIcon, null),
          className: cx('dropdownButton'),
          disabled: props.disabled,
          onClick: onDropdownClick,
          "aria-label": ariaLabel,
          pt: ptm('dropdownButton'),
          __parentMetadata: {
            parent: metaData
          }
        });
      }
      return null;
    };
    var createLoader = function createLoader() {
      if (searchingState) {
        var loadingIconProps = mergeProps({
          className: cx('loadingIcon')
        }, ptm('loadingIcon'));
        var icon = props.loadingIcon || /*#__PURE__*/React__namespace.createElement(SpinnerIcon, _extends({}, loadingIconProps, {
          spin: true
        }));
        var loaderIcon = IconUtils.getJSXIcon(icon, _objectSpread$1D({}, loadingIconProps), {
          props: props
        });
        return loaderIcon;
      }
      return null;
    };
    var createInput = function createInput() {
      return props.multiple ? createMultipleAutoComplete() : createSimpleAutoComplete();
    };
    var listId = idState + '_list';
    var hasTooltip = ObjectUtils.isNotEmpty(props.tooltip);
    var otherProps = AutoCompleteBase.getOtherProps(props);
    var ariaProps = ObjectUtils.reduceKeys(otherProps, DomHandler.ARIA_PROPS);
    var loader = createLoader();
    var input = createInput();
    var dropdown = createDropdown();
    var rootProps = mergeProps({
      id: idState,
      ref: elementRef,
      style: props.style,
      className: classNames(props.className, cx('root', {
        focusedState: focusedState
      }))
    }, otherProps, ptm('root'));
    return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, null, /*#__PURE__*/React__namespace.createElement("span", rootProps, input, loader, dropdown, /*#__PURE__*/React__namespace.createElement(AutoCompletePanel, _extends({
      hostName: "AutoComplete",
      ref: overlayRef,
      virtualScrollerRef: virtualScrollerRef
    }, props, {
      listId: listId,
      onItemClick: selectItem,
      selectedItem: selectedItem,
      onClick: onPanelClick,
      getOptionGroupLabel: getOptionGroupLabel,
      getOptionGroupChildren: getOptionGroupChildren,
      "in": overlayVisibleState,
      onEnter: onOverlayEnter,
      onEntering: onOverlayEntering,
      onEntered: onOverlayEntered,
      onExit: onOverlayExit,
      onExited: onOverlayExited,
      ptm: ptm,
      cx: cx,
      sx: sx
    }))), hasTooltip && /*#__PURE__*/React__namespace.createElement(Tooltip, _extends({
      target: elementRef,
      content: props.tooltip
    }, props.tooltipOptions, {
      pt: ptm('tooltip')
    })));
  }));
  AutoComplete.displayName = 'AutoComplete';

  var classes$15 = {
    root: function root(_ref) {
      var props = _ref.props,
        state = _ref.state;
      return classNames('p-avatar p-component', {
        'p-avatar-image': ObjectUtils.isNotEmpty(props.image) && !state.imageFailed,
        'p-avatar-circle': props.shape === 'circle',
        'p-avatar-lg': props.size === 'large',
        'p-avatar-xl': props.size === 'xlarge',
        'p-avatar-clickable': !!props.onClick
      });
    },
    label: 'p-avatar-text',
    icon: 'p-avatar-icon'
  };
  var styles$10 = "\n@layer primereact {\n    .p-avatar {\n        display: inline-flex;\n        align-items: center;\n        justify-content: center;\n        width: 2rem;\n        height: 2rem;\n        font-size: 1rem;\n    }\n    \n    .p-avatar.p-avatar-image {\n        background-color: transparent;\n    }\n    \n    .p-avatar.p-avatar-circle {\n        border-radius: 50%;\n    }\n    \n    .p-avatar.p-avatar-circle img {\n        border-radius: 50%;\n    }\n    \n    .p-avatar .p-avatar-icon {\n        font-size: 1rem;\n    }\n    \n    .p-avatar img {\n        width: 100%;\n        height: 100%;\n    }\n    \n    .p-avatar-clickable {\n        cursor: pointer;\n    }\n}\n";
  var AvatarBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'Avatar',
      className: null,
      icon: null,
      image: null,
      imageAlt: 'avatar',
      imageFallback: 'default',
      label: null,
      onImageError: null,
      shape: 'square',
      size: 'normal',
      style: null,
      template: null,
      children: undefined
    },
    css: {
      classes: classes$15,
      styles: styles$10
    }
  });

  function ownKeys$1C(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1C(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1C(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1C(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var Avatar = /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var context = React__namespace.useContext(PrimeReactContext);
    var props = AvatarBase.getProps(inProps, context);
    var elementRef = React__namespace.useRef(null);
    var _React$useState = React__namespace.useState(false),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      imageFailed = _React$useState2[0],
      setImageFailed = _React$useState2[1];
    var _React$useState3 = React__namespace.useState(false),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      nested = _React$useState4[0],
      setNested = _React$useState4[1];
    var _AvatarBase$setMetaDa = AvatarBase.setMetaData({
        props: props,
        state: {
          imageFailed: imageFailed,
          nested: nested
        }
      }),
      ptm = _AvatarBase$setMetaDa.ptm,
      cx = _AvatarBase$setMetaDa.cx,
      isUnstyled = _AvatarBase$setMetaDa.isUnstyled;
    useHandleStyle(AvatarBase.css.styles, isUnstyled, {
      name: 'avatar'
    });
    var createContent = function createContent() {
      if (ObjectUtils.isNotEmpty(props.image) && !imageFailed) {
        var imageProps = mergeProps({
          src: props.image,
          onError: onImageError
        }, ptm('image'));
        return /*#__PURE__*/React__namespace.createElement("img", _extends({
          alt: props.imageAlt
        }, imageProps));
      } else if (props.label) {
        var labelProps = mergeProps({
          className: cx('label')
        }, ptm('label'));
        return /*#__PURE__*/React__namespace.createElement("span", labelProps, props.label);
      } else if (props.icon) {
        var iconProps = mergeProps({
          className: cx('icon')
        }, ptm('icon'));
        return IconUtils.getJSXIcon(props.icon, _objectSpread$1C({}, iconProps), {
          props: props
        });
      }
      return null;
    };
    var onImageError = function onImageError(event) {
      if (props.imageFallback === 'default') {
        if (!props.onImageError) {
          // fallback to label or icon
          setImageFailed(true);
          event.target.src = null;
        }
      } else {
        // try fallback as an image
        event.target.src = props.imageFallback;
      }
      props.onImageError && props.onImageError(event);
    };
    React__namespace.useEffect(function () {
      var nested = DomHandler.isAttributeEquals(elementRef.current.parentElement, 'data-pc-name', 'avatargroup');
      setNested(nested);
    }, []);
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        getElement: function getElement() {
          return elementRef.current;
        }
      };
    });
    var rootProps = mergeProps({
      ref: elementRef,
      style: props.style,
      className: classNames(props.className, cx('root', {
        imageFailed: imageFailed
      }))
    }, AvatarBase.getOtherProps(props), ptm('root'));
    var content = props.template ? ObjectUtils.getJSXElement(props.template, props) : createContent();
    return /*#__PURE__*/React__namespace.createElement("div", rootProps, content, props.children);
  });
  Avatar.displayName = 'Avatar';

  var classes$14 = {
    root: 'p-avatar-group p-component'
  };
  var styles$$ = "\n@layer primereact {\n    .p-avatar-group .p-avatar + .p-avatar {\n        margin-left: -1rem;\n    }\n    \n    .p-avatar-group {\n        display: flex;\n        align-items: center;\n    }\n}\n";
  var AvatarGroupBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'AvatarGroup',
      style: null,
      className: null,
      children: undefined
    },
    css: {
      classes: classes$14,
      styles: styles$$
    }
  });

  var AvatarGroup = /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var context = React__namespace.useContext(PrimeReactContext);
    var props = AvatarGroupBase.getProps(inProps, context);
    var _AvatarGroupBase$setM = AvatarGroupBase.setMetaData({
        props: props
      }),
      ptm = _AvatarGroupBase$setM.ptm,
      cx = _AvatarGroupBase$setM.cx,
      isUnstyled = _AvatarGroupBase$setM.isUnstyled;
    useHandleStyle(AvatarGroupBase.css.styles, isUnstyled, {
      name: 'avatargroup'
    });
    var elementRef = React__namespace.useRef(null);
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        getElement: function getElement() {
          return elementRef.current;
        }
      };
    });
    var rootProps = mergeProps({
      ref: elementRef,
      style: props.style,
      className: classNames(props.className, cx('root'))
    }, AvatarGroupBase.getOtherProps(props), ptm('root'));
    return /*#__PURE__*/React__namespace.createElement("div", rootProps, props.children);
  });
  AvatarGroup.displayName = 'AvatarGroup';

  var classes$13 = {
    root: function root(_ref) {
      var props = _ref.props;
      return classNames('p-blockui-container', props.containerClassName);
    },
    mask: function mask(_ref2) {
      var props = _ref2.props;
      return classNames('p-blockui p-component-overlay p-component-overlay-enter', {
        'p-blockui-document': props.fullScreen
      });
    }
  };
  var styles$_ = "\n@layer primereact {\n    .p-blockui-container {\n        position: relative;\n    }\n    \n    .p-blockui {\n        opacity: 1;\n        display: flex;\n        align-items: center;\n        justify-content: center;\n    }\n    \n    .p-blockui.p-component-overlay {\n        position: absolute;\n    }\n    \n    .p-blockui-document.p-component-overlay {\n        position: fixed;\n    }\n}\n";
  var BlockUIBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'BlockUI',
      autoZIndex: true,
      baseZIndex: 0,
      blocked: false,
      className: null,
      containerClassName: null,
      containerStyle: null,
      fullScreen: false,
      id: null,
      onBlocked: null,
      onUnblocked: null,
      style: null,
      template: null,
      children: undefined
    },
    css: {
      classes: classes$13,
      styles: styles$_
    }
  });

  function ownKeys$1B(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1B(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1B(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1B(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var BlockUI = /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var context = React__namespace.useContext(PrimeReactContext);
    var props = BlockUIBase.getProps(inProps, context);
    var _React$useState = React__namespace.useState(props.blocked),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      visibleState = _React$useState2[0],
      setVisibleState = _React$useState2[1];
    var elementRef = React__namespace.useRef(null);
    var maskRef = React__namespace.useRef(null);
    var activeElementRef = React__namespace.useRef(null);
    var _BlockUIBase$setMetaD = BlockUIBase.setMetaData({
        props: props
      }),
      ptm = _BlockUIBase$setMetaD.ptm,
      cx = _BlockUIBase$setMetaD.cx,
      isUnstyled = _BlockUIBase$setMetaD.isUnstyled;
    useHandleStyle(BlockUIBase.css.styles, isUnstyled, {
      name: 'blockui'
    });
    var block = function block() {
      setVisibleState(true);
      activeElementRef.current = document.activeElement;
    };
    var unblock = function unblock() {
      var callback = function callback() {
        setVisibleState(false);
        if (props.fullScreen) {
          DomHandler.unblockBodyScroll();
          activeElementRef.current && activeElementRef.current.focus();
        }
        props.onUnblocked && props.onUnblocked();
      };
      if (maskRef.current) {
        DomHandler.addClass(maskRef.current, 'p-component-overlay-leave');
        maskRef.current.addEventListener('animationend', function () {
          ZIndexUtils.clear(maskRef.current);
          callback();
        });
      } else {
        callback();
      }
    };
    var onPortalMounted = function onPortalMounted() {
      if (props.fullScreen) {
        DomHandler.blockBodyScroll();
        activeElementRef.current && activeElementRef.current.blur();
      }
      if (props.autoZIndex) {
        var key = props.fullScreen ? 'modal' : 'overlay';
        ZIndexUtils.set(key, maskRef.current, context && context.autoZIndex || PrimeReact.autoZIndex, props.baseZIndex || context && context.zIndex[key] || PrimeReact.zIndex[key]);
      }
      props.onBlocked && props.onBlocked();
    };
    useMountEffect(function () {
      visibleState && block();
    });
    useUpdateEffect(function () {
      props.blocked ? block() : unblock();
    }, [props.blocked]);
    useUnmountEffect(function () {
      props.fullScreen && DomHandler.unblockBodyScroll();
      ZIndexUtils.clear(maskRef.current);
    });
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        block: block,
        unblock: unblock,
        getElement: function getElement() {
          return elementRef.current;
        }
      };
    });
    var createMask = function createMask() {
      if (visibleState) {
        var appendTo = props.fullScreen ? document.body : 'self';
        var maskProps = mergeProps({
          className: classNames(props.className, cx('mask')),
          style: _objectSpread$1B(_objectSpread$1B({}, props.style), {}, {
            position: props.fullScreen ? 'fixed' : 'absolute',
            top: '0',
            left: '0',
            width: '100%',
            height: '100%'
          })
        }, ptm('mask'));
        var content = props.template ? ObjectUtils.getJSXElement(props.template, props) : null;
        var _mask = /*#__PURE__*/React__namespace.createElement("div", _extends({
          ref: maskRef
        }, maskProps), content);
        return /*#__PURE__*/React__namespace.createElement(Portal, {
          element: _mask,
          appendTo: appendTo,
          onMounted: onPortalMounted
        });
      }
      return null;
    };
    var mask = createMask();
    var rootProps = mergeProps({
      id: props.id,
      ref: elementRef,
      style: props.containerStyle,
      className: cx('root'),
      'aria-busy': props.blocked
    }, BlockUIBase.getOtherProps(props), ptm('root'));
    return /*#__PURE__*/React__namespace.createElement("div", rootProps, props.children, mask);
  });
  BlockUI.displayName = 'BlockUI';

  var classes$12 = {
    icon: 'p-menuitem-icon',
    action: 'p-menuitem-link',
    label: 'p-menuitem-text',
    home: function home(_ref) {
      var _className = _ref._className,
        disabled = _ref.disabled;
      return classNames('p-breadcrumb-home p-menuitem', {
        'p-disabled': disabled
      }, _className);
    },
    separatorIcon: 'p-breadcrumb-chevron',
    separator: 'p-menuitem-separator',
    menuitem: function menuitem(_ref2) {
      var item = _ref2.item;
      return classNames('p-menuitem', item.className, {
        'p-disabled': item.disabled
      });
    },
    menu: 'p-breadcrumb-list',
    root: function root(_ref3) {
      var props = _ref3.props;
      return classNames('p-breadcrumb p-component', props.className);
    }
  };
  var styles$Z = "\n@layer primereact {\n    .p-breadcrumb {\n        overflow-x: auto;\n    }\n\n    .p-breadcrumb ol {\n        margin: 0;\n        padding: 0;\n        list-style-type: none;\n        display: flex;\n        align-items: center;\n        flex-wrap: nowrap;\n    }\n\n    .p-breadcrumb .p-menuitem-text {\n        line-height: 1;\n    }\n\n    .p-breadcrumb .p-menuitem-link {\n        text-decoration: none;\n        display: flex;\n        align-items: center;\n    }\n\n    .p-breadcrumb .p-menuitem-separator {\n        display: flex;\n        align-items: center;\n    }\n\n    .p-breadcrumb::-webkit-scrollbar {\n        display: none;\n    }\n}\n";
  var BreadCrumbBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'BreadCrumb',
      id: null,
      model: null,
      home: null,
      separatorIcon: null,
      style: null,
      className: null,
      children: undefined
    },
    css: {
      classes: classes$12,
      styles: styles$Z
    }
  });

  function ownKeys$1A(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1A(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1A(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1A(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var BreadCrumb = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var context = React__namespace.useContext(PrimeReactContext);
    var props = BreadCrumbBase.getProps(inProps, context);
    var _React$useState = React__namespace.useState(props.id),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      idState = _React$useState2[0],
      setIdState = _React$useState2[1];
    var elementRef = React__namespace.useRef(null);
    var _BreadCrumbBase$setMe = BreadCrumbBase.setMetaData({
        props: props,
        state: {
          id: idState
        }
      }),
      ptm = _BreadCrumbBase$setMe.ptm,
      cx = _BreadCrumbBase$setMe.cx,
      isUnstyled = _BreadCrumbBase$setMe.isUnstyled;
    useHandleStyle(BreadCrumbBase.css.styles, isUnstyled, {
      name: 'breadcrumb'
    });
    var itemClick = function itemClick(event, item) {
      if (item.disabled) {
        event.preventDefault();
        return;
      }
      if (!item.url) {
        event.preventDefault();
      }
      if (item.command) {
        item.command({
          originalEvent: event,
          item: item
        });
      }
    };
    var isCurrent = function isCurrent(url) {
      var lastPath = typeof window !== 'undefined' ? window.location.pathname : '';
      return url === lastPath ? 'page' : undefined;
    };
    var createHome = function createHome(index) {
      var home = props.home;
      if (home) {
        if (home.visible === false) {
          return null;
        }
        var _icon = home.icon,
          target = home.target,
          url = home.url,
          disabled = home.disabled,
          style = home.style,
          _className = home.className,
          template = home.template,
          _label = home.label;
        var iconProps = mergeProps({
          className: cx('icon')
        }, ptm('icon'));
        var icon = IconUtils.getJSXIcon(_icon, _objectSpread$1A({}, iconProps), {
          props: props
        });
        var actionProps = mergeProps({
          href: url || '#',
          className: cx('action'),
          'aria-disabled': disabled,
          'aria-current': isCurrent(url),
          target: target,
          onClick: function onClick(event) {
            return itemClick(event, home);
          }
        }, ptm('action'));
        var labelProps = mergeProps({
          className: cx('label')
        }, ptm('label'));
        var label = _label && /*#__PURE__*/React__namespace.createElement("span", labelProps, _label);
        var content = /*#__PURE__*/React__namespace.createElement("a", actionProps, icon, label);
        if (template) {
          var defaultContentOptions = {
            onClick: function onClick(event) {
              return itemClick(event, home);
            },
            className: 'p-menuitem-link',
            labelClassName: 'p-menuitem-text',
            element: content,
            props: props
          };
          content = ObjectUtils.getJSXElement(template, home, defaultContentOptions);
        }
        var key = idState + '_home';
        var menuitemProps = mergeProps({
          id: key,
          key: key,
          className: cx('home', {
            _className: _className,
            disabled: disabled
          }),
          style: style
        }, ptm('home'));
        return /*#__PURE__*/React__namespace.createElement("li", menuitemProps, content);
      }
      return null;
    };
    var createSeparator = function createSeparator(index) {
      var key = idState + '_sep_' + index;
      var separatorIconProps = mergeProps({
        className: cx('separatorIcon'),
        'aria-hidden': 'true'
      }, ptm('separatorIcon'));
      var icon = props.separatorIcon || /*#__PURE__*/React__namespace.createElement(ChevronRightIcon, separatorIconProps);
      var separatorIcon = IconUtils.getJSXIcon(icon, _objectSpread$1A({}, separatorIconProps), {
        props: props
      });
      var separatorProps = mergeProps({
        id: key,
        key: key,
        className: cx('separator'),
        role: 'separator'
      }, ptm('separator'));
      return /*#__PURE__*/React__namespace.createElement("li", separatorProps, separatorIcon);
    };
    var createMenuitem = function createMenuitem(item, index) {
      if (item.visible === false) {
        return null;
      }
      var labelProps = mergeProps({
        className: cx('label')
      }, ptm('label'));
      var label = item.label && /*#__PURE__*/React__namespace.createElement("span", labelProps, item.label);
      var actionProps = mergeProps({
        href: item.url || '#',
        className: cx('action'),
        target: item.target,
        'aria-current': isCurrent(item.url),
        onClick: function onClick(event) {
          return itemClick(event, item);
        },
        'aria-disabled': item.disabled
      }, ptm('action'));
      var content = /*#__PURE__*/React__namespace.createElement("a", actionProps, label);
      if (item.template) {
        var defaultContentOptions = {
          onClick: function onClick(event) {
            return itemClick(event, item);
          },
          className: 'p-menuitem-link',
          labelClassName: 'p-menuitem-text',
          element: content,
          props: props
        };
        content = ObjectUtils.getJSXElement(item.template, item, defaultContentOptions);
      }
      var key = item.id || idState + '_' + index;
      var menuitemProps = mergeProps({
        id: key,
        key: key,
        className: cx('menuitem', {
          item: item
        }),
        style: item.style
      }, ptm('menuitem'));
      return /*#__PURE__*/React__namespace.createElement("li", menuitemProps, content);
    };
    var createMenuitems = function createMenuitems() {
      if (props.model) {
        var _items = props.model.map(function (item, index) {
          if (item.visible === false) {
            return null;
          }
          var menuitem = createMenuitem(item, index);
          var separator = index === props.model.length - 1 ? null : createSeparator(index);
          var key = idState + '_' + index;
          return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, {
            key: key
          }, menuitem, separator);
        });
        return _items;
      }
      return null;
    };
    useMountEffect(function () {
      if (!idState) {
        setIdState(UniqueComponentId());
      }
    });
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        getElement: function getElement() {
          return elementRef.current;
        }
      };
    });
    var home = createHome();
    var items = createMenuitems();
    var separator = createSeparator('home');
    var menuProps = mergeProps({
      className: cx('menu')
    }, ptm('menu'));
    var rootProps = mergeProps({
      id: props.id,
      ref: elementRef,
      className: cx('root'),
      style: props.style
    }, BreadCrumbBase.getOtherProps(props), ptm('root'));
    return /*#__PURE__*/React__namespace.createElement("nav", rootProps, /*#__PURE__*/React__namespace.createElement("ol", menuProps, home, separator, items));
  }));
  BreadCrumb.displayName = 'BreadCrumb';

  var styles$Y = "\n@layer primereact {\n    .p-calendar {\n        position: relative;\n        display: inline-flex;\n        max-width: 100%;\n    }\n    \n    .p-calendar .p-inputtext {\n        flex: 1 1 auto;\n        width: 1%;\n    }\n    \n    .p-calendar-w-btn-right .p-inputtext {\n        border-top-right-radius: 0;\n        border-bottom-right-radius: 0;\n    }\n    \n    .p-calendar-w-btn-right .p-datepicker-trigger {\n        border-top-left-radius: 0;\n        border-bottom-left-radius: 0;\n    }\n    \n    .p-calendar-w-btn-left .p-inputtext {\n        border-top-left-radius: 0;\n        border-bottom-left-radius: 0;\n    }\n    \n    .p-calendar-w-btn-left .p-datepicker-trigger {\n        border-top-right-radius: 0;\n        border-bottom-right-radius: 0;\n    }\n    \n    /* Fluid */\n    .p-fluid .p-calendar {\n        display: flex;\n    }\n    \n    .p-fluid .p-calendar .p-inputtext {\n        width: 1%;\n    }\n    \n    /* Datepicker */\n    .p-calendar .p-datepicker {\n        min-width: 100%;\n    }\n    \n    .p-datepicker {\n        width: auto;\n        position: absolute;\n        top: 0;\n        left: 0;\n    }\n    \n    .p-datepicker-inline {\n        display: inline-block;\n        position: static;\n        overflow-x: auto;\n    }\n    \n    /* Header */\n    .p-datepicker-header {\n        display: flex;\n        align-items: center;\n        justify-content: space-between;\n    }\n    \n    .p-datepicker-header .p-datepicker-title {\n        margin: 0 auto;\n    }\n    \n    .p-datepicker-prev,\n    .p-datepicker-next {\n        cursor: pointer;\n        display: inline-flex;\n        justify-content: center;\n        align-items: center;\n        overflow: hidden;\n        position: relative;\n    }\n    \n    /* Multiple Month DatePicker */\n    .p-datepicker-multiple-month .p-datepicker-group-container {\n        display: flex;\n    }\n    \n    .p-datepicker-multiple-month .p-datepicker-group-container .p-datepicker-group {\n        flex: 1 1 auto;\n    }\n    \n    /* Multiple Month DatePicker */\n    .p-datepicker-multiple-month .p-datepicker-group-container {\n        display: flex;\n    }\n    \n    /* DatePicker Table */\n    .p-datepicker table {\n        width: 100%;\n        border-collapse: collapse;\n    }\n    \n    .p-datepicker td > span {\n        display: flex;\n        justify-content: center;\n        align-items: center;\n        cursor: pointer;\n        margin: 0 auto;\n        overflow: hidden;\n        position: relative;\n    }\n    \n    /* Month Picker */\n    .p-monthpicker-month {\n        width: 33.3%;\n        display: inline-flex;\n        align-items: center;\n        justify-content: center;\n        cursor: pointer;\n        overflow: hidden;\n        position: relative;\n    }\n    \n    /*  Button Bar */\n    .p-datepicker-buttonbar {\n        display: flex;\n        justify-content: space-between;\n        align-items: center;\n    }\n    \n    /* Time Picker */\n    .p-timepicker {\n        display: flex;\n        justify-content: center;\n        align-items: center;\n    }\n    \n    .p-timepicker button {\n        display: flex;\n        align-items: center;\n        justify-content: center;\n        cursor: pointer;\n        overflow: hidden;\n        position: relative;\n    }\n    \n    .p-timepicker > div {\n        display: flex;\n        align-items: center;\n        flex-direction: column;\n    }\n    \n    /* Touch UI */\n    .p-datepicker-touch-ui,\n    .p-calendar .p-datepicker-touch-ui {\n        position: fixed;\n        top: 50%;\n        left: 50%;\n        min-width: 80vw;\n        transform: translate(-50%, -50%);\n    }\n    \n    /* Year Picker */\n    .p-yearpicker-year {\n        width: 50%;\n        display: inline-flex;\n        align-items: center;\n        justify-content: center;\n        cursor: pointer;\n        overflow: hidden;\n        position: relative;\n    }\n}\n";
  var classes$11 = {
    root: function root(_ref) {
      var props = _ref.props,
        focusedState = _ref.focusedState,
        isFilled = _ref.isFilled;
      return classNames('p-calendar p-component p-inputwrapper', _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty({}, "p-calendar-w-btn p-calendar-w-btn-".concat(props.iconPos), props.showIcon), 'p-calendar-disabled', props.disabled), 'p-calendar-timeonly', props.timeOnly), 'p-inputwrapper-filled', props.value || isFilled), 'p-inputwrapper-focus', focusedState));
    },
    dropdownButton: 'p-datepicker-trigger',
    buttonbar: 'p-datepicker-buttonbar',
    todayButton: 'p-button-text',
    clearButton: 'p-button-text',
    footer: 'p-datepicker-footer',
    yearPicker: 'p-yearpicker',
    year: function year(_ref2) {
      var isYearSelected = _ref2.isYearSelected,
        y = _ref2.y,
        isMonthYearDisabled = _ref2.isMonthYearDisabled;
      return classNames('p-yearpicker-year', {
        'p-highlight': isYearSelected(y),
        'p-disabled': isMonthYearDisabled(-1, y)
      });
    },
    monthPicker: 'p-monthpicker',
    month: function month(_ref3) {
      var isMonthSelected = _ref3.isMonthSelected,
        isMonthYearDisabled = _ref3.isMonthYearDisabled,
        i = _ref3.i,
        currentYear = _ref3.currentYear;
      return classNames('p-monthpicker-month', {
        'p-highlight': isMonthSelected(i),
        'p-disabled': isMonthYearDisabled(i, currentYear)
      });
    },
    hourPicker: 'p-hour-picker',
    secondPicker: 'p-second-picker',
    minutePicker: 'p-minute-picker',
    millisecondPicker: 'p-millisecond-picker',
    ampmPicker: 'p-ampm-picker',
    separatorContainer: 'p-separator',
    dayLabel: function dayLabel(_ref4) {
      var className = _ref4.className;
      return className;
    },
    day: function day(_ref5) {
      var date = _ref5.date;
      return classNames({
        'p-datepicker-other-month': date.otherMonth,
        'p-datepicker-today': date.today
      });
    },
    panel: function panel(_ref6) {
      var panelClassName = _ref6.panelClassName;
      return panelClassName;
    },
    previousIcon: 'p-datepicker-prev-icon',
    previousButton: 'p-datepicker-prev',
    nextIcon: 'p-datepicker-next-icon',
    nextButton: 'p-datepicker-next',
    incrementButton: 'p-link',
    decrementButton: 'p-link',
    title: 'p-datepicker-title',
    timePicker: 'p-timepicker',
    monthTitle: 'p-datepicker-month p-link',
    yearTitle: 'p-datepicker-year p-link',
    decadeTitle: 'p-datepicker-decade',
    header: 'p-datepicker-header',
    groupContainer: 'p-datepicker-group-container',
    group: 'p-datepicker-group',
    select: function select(_ref7) {
      var props = _ref7.props;
      return props.monthNavigator && props.view !== 'month' ? 'p-datepicker-month' : props.yearNavigator ? 'p-datepicker-year' : undefined;
    },
    weekHeader: 'p-datepicker-weekheader p-disabled',
    weekNumber: 'p-datepicker-weeknumber',
    weekLabelContainer: 'p-disabled',
    container: 'p-datepicker-calendar-container',
    table: 'p-datepicker-calendar',
    transition: 'p-connected-overlay'
  };
  var CalendarBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'Calendar',
      appendTo: null,
      ariaLabelledBy: null,
      autoZIndex: true,
      autoFocus: false,
      baseZIndex: 0,
      className: null,
      clearButtonClassName: 'p-button-secondary',
      dateFormat: null,
      dateTemplate: null,
      decadeTemplate: null,
      decrementIcon: null,
      disabled: false,
      disabledDates: null,
      disabledDays: null,
      enabledDates: null,
      footerTemplate: null,
      formatDateTime: null,
      headerTemplate: null,
      hideOnDateTimeSelect: false,
      hourFormat: '24',
      icon: null,
      iconPos: 'right',
      id: null,
      incrementIcon: null,
      inline: false,
      inputClassName: null,
      inputId: null,
      inputMode: 'none',
      inputRef: null,
      inputStyle: null,
      keepInvalid: false,
      locale: null,
      mask: null,
      maskSlotChar: '_',
      maxDate: null,
      maxDateCount: null,
      minDate: null,
      monthNavigator: false,
      monthNavigatorTemplate: null,
      name: null,
      nextIcon: null,
      numberOfMonths: 1,
      onBlur: null,
      onChange: null,
      onClearButtonClick: null,
      onFocus: null,
      onHide: null,
      onInput: null,
      onMonthChange: null,
      onSelect: null,
      onShow: null,
      onTodayButtonClick: null,
      onViewDateChange: null,
      onVisibleChange: null,
      panelClassName: null,
      panelStyle: null,
      parseDateTime: null,
      placeholder: null,
      prevIcon: null,
      readOnlyInput: false,
      required: false,
      selectOtherMonths: false,
      selectionMode: 'single',
      shortYearCutoff: '+10',
      showButtonBar: false,
      showIcon: false,
      showMillisec: false,
      showMinMaxRange: false,
      showOnFocus: true,
      showOtherMonths: true,
      showSeconds: false,
      showTime: false,
      showWeek: false,
      stepHour: 1,
      stepMillisec: 1,
      stepMinute: 1,
      stepSecond: 1,
      style: null,
      tabIndex: null,
      timeOnly: false,
      todayButtonClassName: 'p-button-secondary',
      tooltip: null,
      tooltipOptions: null,
      touchUI: false,
      transitionOptions: null,
      value: null,
      view: 'date',
      viewDate: null,
      visible: false,
      yearNavigator: false,
      yearNavigatorTemplate: null,
      yearRange: null,
      children: undefined
    },
    css: {
      classes: classes$11,
      styles: styles$Y
    }
  });

  var CalendarPanel = /*#__PURE__*/React__namespace.forwardRef(function (props, ref) {
    var cx = props.cx;
    var createElement = function createElement() {
      var panelProps = mergeProps({
        className: cx('panel', {
          panelClassName: props.className
        }),
        style: props.style,
        onClick: props.onClick,
        onMouseUp: props.onMouseUp
      }, props.ptm('panel', {
        hostName: props.hostName
      }));
      var transitionProps = mergeProps({
        classNames: cx('transition'),
        "in": props["in"],
        timeout: {
          enter: 120,
          exit: 100
        },
        options: props.transitionOptions,
        unmountOnExit: true,
        onEnter: props.onEnter,
        onEntered: props.onEntered,
        onExit: props.onExit,
        onExited: props.onExited
      }, props.ptm('transition', {
        hostName: props.hostName
      }));
      return /*#__PURE__*/React__namespace.createElement(CSSTransition, _extends({
        nodeRef: ref
      }, transitionProps), /*#__PURE__*/React__namespace.createElement("div", _extends({
        ref: ref
      }, panelProps), props.children));
    };
    var element = createElement();
    return props.inline ? element : /*#__PURE__*/React__namespace.createElement(Portal, {
      element: element,
      appendTo: props.appendTo
    });
  });
  CalendarPanel.displayName = 'CalendarPanel';

  function ownKeys$1z(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1z(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1z(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1z(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  function _createForOfIteratorHelper$e(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray$e(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
  function _unsupportedIterableToArray$e(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray$e(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$e(o, minLen); }
  function _arrayLikeToArray$e(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
  var Calendar = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var context = React__namespace.useContext(PrimeReactContext);
    var props = CalendarBase.getProps(inProps, context);
    var _React$useState = React__namespace.useState(false),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      focusedState = _React$useState2[0],
      setFocusedState = _React$useState2[1];
    var _React$useState3 = React__namespace.useState(false),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      overlayVisibleState = _React$useState4[0],
      setOverlayVisibleState = _React$useState4[1];
    var _React$useState5 = React__namespace.useState(null),
      _React$useState6 = _slicedToArray(_React$useState5, 2),
      viewDateState = _React$useState6[0],
      setViewDateState = _React$useState6[1];
    var metaData = {
      props: props,
      state: {
        focused: focusedState,
        overlayVisible: overlayVisibleState,
        viewDate: viewDateState
      }
    };
    var _CalendarBase$setMeta = CalendarBase.setMetaData(metaData),
      ptm = _CalendarBase$setMeta.ptm,
      cx = _CalendarBase$setMeta.cx,
      isUnstyled = _CalendarBase$setMeta.isUnstyled;
    useHandleStyle(CalendarBase.css.styles, isUnstyled, {
      name: 'calendar'
    });
    var elementRef = React__namespace.useRef(null);
    var overlayRef = React__namespace.useRef(null);
    var inputRef = React__namespace.useRef(props.inputRef);
    var navigation = React__namespace.useRef(null);
    var ignoreFocusFunctionality = React__namespace.useRef(false);
    var timePickerTimer = React__namespace.useRef(null);
    var viewStateChanged = React__namespace.useRef(false);
    var touchUIMask = React__namespace.useRef(null);
    var overlayEventListener = React__namespace.useRef(null);
    var touchUIMaskClickListener = React__namespace.useRef(null);
    var isOverlayClicked = React__namespace.useRef(false);
    var previousButton = React__namespace.useRef(false);
    var nextButton = React__namespace.useRef(false);
    var onChangeRef = React__namespace.useRef(null);
    var _React$useState7 = React__namespace.useState('date'),
      _React$useState8 = _slicedToArray(_React$useState7, 2),
      currentView = _React$useState8[0],
      setCurrentView = _React$useState8[1];
    var _React$useState9 = React__namespace.useState(null),
      _React$useState10 = _slicedToArray(_React$useState9, 2),
      currentMonth = _React$useState10[0],
      setCurrentMonth = _React$useState10[1];
    var _React$useState11 = React__namespace.useState(null),
      _React$useState12 = _slicedToArray(_React$useState11, 2),
      currentYear = _React$useState12[0],
      setCurrentYear = _React$useState12[1];
    var _React$useState13 = React__namespace.useState([]),
      _React$useState14 = _slicedToArray(_React$useState13, 2),
      yearOptions = _React$useState14[0],
      setYearOptions = _React$useState14[1];
    var previousValue = usePrevious(props.value);
    var visible = props.inline || (props.onVisibleChange ? props.visible : overlayVisibleState);
    var attributeSelector = UniqueComponentId();
    var _useOverlayListener = useOverlayListener({
        target: elementRef,
        overlay: overlayRef,
        listener: function listener(event, _ref) {
          var type = _ref.type,
            valid = _ref.valid;
          if (valid) {
            type === 'outside' ? !isOverlayClicked.current && !isNavIconClicked(event.target) && hide('outside') : hide();
          }
          isOverlayClicked.current = false;
        },
        when: !(props.touchUI || props.inline) && visible
      }),
      _useOverlayListener2 = _slicedToArray(_useOverlayListener, 2),
      bindOverlayListener = _useOverlayListener2[0],
      unbindOverlayListener = _useOverlayListener2[1];
    var getDateFormat = function getDateFormat() {
      return props.dateFormat || localeOption('dateFormat', props.locale);
    };
    var onInputFocus = function onInputFocus(event) {
      if (ignoreFocusFunctionality.current) {
        setFocusedState(true);
        ignoreFocusFunctionality.current = false;
      } else {
        if (props.showOnFocus && !visible) {
          show();
        }
        setFocusedState(true);
        props.onFocus && props.onFocus(event);
      }
    };
    var onInputBlur = function onInputBlur(event) {
      !props.keepInvalid && updateInputfield(props.value);
      props.onBlur && props.onBlur(event);
      setFocusedState(false);
    };
    var onInputKeyDown = function onInputKeyDown(event) {
      switch (event.which) {
        //escape
        case 27:
          {
            hide();
            break;
          }

        //tab
        case 9:
          {
            visible && trapFocus(event);
            props.touchUI && disableModality();
            break;
          }
      }
    };
    var onUserInput = function onUserInput(event) {
      updateValueOnInput(event, event.target.value);
      props.onInput && props.onInput(event);
    };
    var updateValueOnInput = function updateValueOnInput(event, rawValue, invalidCallback) {
      try {
        var value = parseValueFromString(rawValue);
        if (isValidSelection(value)) {
          updateModel(event, value);
          updateViewDate(event, value.length ? value[0] : value);
        }
      } catch (err) {
        //invalid date
        if (invalidCallback) {
          invalidCallback();
        } else {
          var _value = props.keepInvalid ? rawValue : null;
          updateModel(event, _value);
        }
      }
    };
    var reFocusInputField = function reFocusInputField() {
      if (!props.inline && inputRef.current) {
        ignoreFocusFunctionality.current = true;
        DomHandler.focus(inputRef.current);
      }
    };
    var isValidSelection = function isValidSelection(value) {
      var isValid = true;
      if (isSingleSelection()) {
        if (!(isSelectable(value.getDate(), value.getMonth(), value.getFullYear(), false) && isSelectableTime(value))) {
          isValid = false;
        }
      } else if (value.every(function (v) {
        return isSelectable(v.getDate(), v.getMonth(), v.getFullYear(), false) && isSelectableTime(v);
      })) {
        if (isRangeSelection()) {
          isValid = value.length > 1 && value[1] > value[0] ? true : false;
        }
      }
      return isValid;
    };
    var onButtonClick = function onButtonClick() {
      visible ? hide() : show();
    };
    var onPrevButtonClick = function onPrevButtonClick(event) {
      navigation.current = {
        backward: true,
        button: true
      };
      navBackward(event);
    };
    var onNextButtonClick = function onNextButtonClick(event) {
      navigation.current = {
        backward: false,
        button: true
      };
      navForward(event);
    };
    var onContainerButtonKeydown = function onContainerButtonKeydown(event) {
      switch (event.which) {
        //tab
        case 9:
          trapFocus(event);
          break;

        //escape
        case 27:
          hide(null, reFocusInputField);
          event.preventDefault();
          break;
      }
    };
    var trapFocus = function trapFocus(event) {
      event.preventDefault();
      var focusableElements = DomHandler.getFocusableElements(overlayRef.current);
      if (focusableElements && focusableElements.length > 0) {
        if (!document.activeElement) {
          focusableElements[0].focus();
        } else {
          var focusedIndex = focusableElements.indexOf(document.activeElement);
          if (event.shiftKey) {
            if (focusedIndex === -1 || focusedIndex === 0) focusableElements[focusableElements.length - 1].focus();else focusableElements[focusedIndex - 1].focus();
          } else {
            if (focusedIndex === -1 || focusedIndex === focusableElements.length - 1) focusableElements[0].focus();else focusableElements[focusedIndex + 1].focus();
          }
        }
      }
    };
    var updateFocus = function updateFocus() {
      if (navigation.current) {
        if (navigation.current.button) {
          initFocusableCell();
          if (navigation.current.backward) previousButton.current.focus();else nextButton.current.focus();
        } else {
          var cell;
          if (navigation.current.backward) {
            var cells = DomHandler.find(overlayRef.current, 'table td span:not([data-p-disabled="true"])');
            cell = cells[cells.length - 1];
          } else {
            cell = DomHandler.findSingle(overlayRef.current, 'table td span:not([data-p-disabled="true"])');
          }
          if (cell) {
            cell.tabIndex = '0';
            cell.focus();
          }
        }
        navigation.current = null;
      } else {
        initFocusableCell();
      }
    };
    var initFocusableCell = function initFocusableCell() {
      var cell;
      if (props.view === 'month') {
        var cells = DomHandler.find(overlayRef.current, '[data-pc-section="monthpicker"] [data-pc-section="month"]');
        var selectedCell = DomHandler.findSingle(overlayRef.current, '[data-pc-section="monthpicker"] [data-pc-section="month"][data-p-highlight="true"]');
        cells.forEach(function (cell) {
          return cell.tabIndex = -1;
        });
        cell = selectedCell || cells[0];
      } else {
        cell = DomHandler.findSingle(overlayRef.current, 'span[data-p-highlight="true"]');
        if (!cell) {
          var todayCell = DomHandler.findSingle(overlayRef.current, 'td.p-datepicker-today span:not(.p-disabled)');
          cell = todayCell || DomHandler.findSingle(overlayRef.current, 'table td span:not([data-p-disabled="true"])');
        }
      }
      if (cell) {
        cell.tabIndex = '0';
      }
    };
    var navBackward = function navBackward(event) {
      if (props.disabled) {
        event.preventDefault();
        return;
      }
      var newViewDate = cloneDate(getViewDate());
      newViewDate.setDate(1);
      if (currentView === 'date') {
        if (newViewDate.getMonth() === 0) {
          newViewDate.setMonth(11);
          newViewDate.setFullYear(decrementYear());
          setCurrentMonth(11);
        } else {
          newViewDate.setMonth(newViewDate.getMonth() - 1);
          setCurrentMonth(function (prevState) {
            return prevState - 1;
          });
        }
      } else if (currentView === 'month') {
        var newYear = newViewDate.getFullYear() - 1;
        if (props.yearNavigator) {
          var minYear = parseInt(props.yearRange.split(':')[0], 10);
          if (newYear < minYear) {
            newYear = minYear;
          }
        }
        newViewDate.setFullYear(newYear);
      }
      if (currentView === 'month') {
        newViewDate.setFullYear(decrementYear());
      } else if (currentView === 'year') {
        newViewDate.setFullYear(decrementDecade());
      }
      updateViewDate(event, newViewDate);
      event.preventDefault();
    };
    var navForward = function navForward(event) {
      if (props.disabled) {
        event.preventDefault();
        return;
      }
      var newViewDate = cloneDate(getViewDate());
      newViewDate.setDate(1);
      if (currentView === 'date') {
        if (newViewDate.getMonth() === 11) {
          newViewDate.setMonth(0);
          newViewDate.setFullYear(incrementYear());
          setCurrentMonth(0);
        } else {
          newViewDate.setMonth(newViewDate.getMonth() + 1);
          setCurrentMonth(function (prevState) {
            return prevState + 1;
          });
        }
      } else if (currentView === 'month') {
        var newYear = newViewDate.getFullYear() + 1;
        if (props.yearNavigator) {
          var maxYear = parseInt(props.yearRange.split(':')[1], 10);
          if (newYear > maxYear) {
            newYear = maxYear;
          }
        }
        newViewDate.setFullYear(newYear);
      }
      if (currentView === 'month') {
        newViewDate.setFullYear(incrementYear());
      } else if (currentView === 'year') {
        newViewDate.setFullYear(incrementDecade());
      }
      updateViewDate(event, newViewDate);
      event.preventDefault();
    };
    var populateYearOptions = function populateYearOptions(start, end) {
      var _yearOptions = [];
      for (var i = start; i <= end; i++) {
        yearOptions.push(i);
      }
      setYearOptions(_yearOptions);
    };
    var decrementYear = function decrementYear() {
      var _currentYear = currentYear - 1;
      setCurrentYear(_currentYear);
      if (props.yearNavigator && _currentYear < yearOptions[0]) {
        var difference = yearOptions[yearOptions.length - 1] - yearOptions[0];
        populateYearOptions(yearOptions[0] - difference, yearOptions[yearOptions.length - 1] - difference);
      }
      return _currentYear;
    };
    var incrementYear = function incrementYear() {
      var _currentYear = currentYear + 1;
      setCurrentYear(_currentYear);
      if (props.yearNavigator && _currentYear.current > yearOptions[yearOptions.length - 1]) {
        var difference = yearOptions[yearOptions.length - 1] - yearOptions[0];
        populateYearOptions(yearOptions[0] + difference, yearOptions[yearOptions.length - 1] + difference);
      }
      return _currentYear;
    };
    var onMonthDropdownChange = function onMonthDropdownChange(event, value) {
      var currentViewDate = getViewDate();
      var newViewDate = cloneDate(currentViewDate);
      newViewDate.setMonth(parseInt(value, 10));
      updateViewDate(event, newViewDate);
    };
    var onYearDropdownChange = function onYearDropdownChange(event, value) {
      var currentViewDate = getViewDate();
      var newViewDate = cloneDate(currentViewDate);
      newViewDate.setFullYear(parseInt(value, 10));
      updateViewDate(event, newViewDate);
    };
    var onTodayButtonClick = function onTodayButtonClick(event) {
      var today = new Date();
      var dateMeta = {
        day: today.getDate(),
        month: today.getMonth(),
        year: today.getFullYear(),
        today: true,
        selectable: true
      };
      var timeMeta = {
        hours: today.getHours(),
        minutes: today.getMinutes(),
        seconds: today.getSeconds(),
        milliseconds: today.getMilliseconds()
      };
      updateViewDate(event, today);
      onDateSelect(event, dateMeta, timeMeta);
      props.onTodayButtonClick && props.onTodayButtonClick(event);
    };
    var onClearButtonClick = function onClearButtonClick(event) {
      updateModel(event, null);
      updateInputfield(null);
      hide();
      props.onClearButtonClick && props.onClearButtonClick(event);
    };
    var onPanelClick = function onPanelClick(event) {
      if (!props.inline) {
        OverlayService.emit('overlay-click', {
          originalEvent: event,
          target: elementRef.current
        });
      }
    };
    var onPanelMouseUp = function onPanelMouseUp(event) {
      onPanelClick(event);
    };
    var onTimePickerElementMouseDown = function onTimePickerElementMouseDown(event, type, direction) {
      if (!props.disabled) {
        repeat(event, null, type, direction);
        event.preventDefault();
      }
    };
    var onTimePickerElementMouseUp = function onTimePickerElementMouseUp() {
      if (!props.disabled) {
        clearTimePickerTimer();
      }
    };
    var onTimePickerElementMouseLeave = function onTimePickerElementMouseLeave() {
      if (!props.disabled) {
        clearTimePickerTimer();
      }
    };
    var repeat = function repeat(event, interval, type, direction) {
      clearTimePickerTimer();
      timePickerTimer.current = setTimeout(function () {
        repeat(event, 100, type, direction);
      }, interval || 500);
      switch (type) {
        case 0:
          if (direction === 1) incrementHour(event);else decrementHour(event);
          break;
        case 1:
          if (direction === 1) incrementMinute(event);else decrementMinute(event);
          break;
        case 2:
          if (direction === 1) incrementSecond(event);else decrementSecond(event);
          break;
        case 3:
          if (direction === 1) incrementMilliSecond(event);else decrementMilliSecond(event);
          break;
      }
    };
    var clearTimePickerTimer = function clearTimePickerTimer() {
      if (timePickerTimer.current) {
        clearTimeout(timePickerTimer.current);
      }
    };
    var incrementHour = function incrementHour(event) {
      var currentTime = getCurrentDateTime();
      var currentHour = currentTime.getHours();
      var newHour = currentHour + props.stepHour;
      newHour = newHour >= 24 ? newHour - 24 : newHour;
      if (validateHour(newHour, currentTime)) {
        if (props.maxDate && props.maxDate.toDateString() === currentTime.toDateString() && props.maxDate.getHours() === newHour) {
          if (props.maxDate.getMinutes() < currentTime.getMinutes()) {
            if (props.maxDate.getSeconds() < currentTime.getSeconds()) {
              if (props.maxDate.getMilliseconds() < currentTime.getMilliseconds()) {
                updateTime(event, newHour, props.maxDate.getMinutes(), props.maxDate.getSeconds(), props.maxDate.getMilliseconds());
              } else {
                updateTime(event, newHour, props.maxDate.getMinutes(), props.maxDate.getSeconds(), currentTime.getMilliseconds());
              }
            } else {
              updateTime(event, newHour, props.maxDate.getMinutes(), currentTime.getSeconds(), currentTime.getMilliseconds());
            }
          } else if (props.maxDate.getMinutes() === currentTime.getMinutes()) {
            if (props.maxDate.getSeconds() < currentTime.getSeconds()) {
              if (props.maxDate.getMilliseconds() < currentTime.getMilliseconds()) {
                updateTime(event, newHour, props.maxDate.getMinutes(), props.maxDate.getSeconds(), props.maxDate.getMilliseconds());
              } else {
                updateTime(event, newHour, props.maxDate.getMinutes(), props.maxDate.getSeconds(), currentTime.getMilliseconds());
              }
            } else {
              updateTime(event, newHour, props.maxDate.getMinutes(), currentTime.getSeconds(), currentTime.getMilliseconds());
            }
          } else {
            updateTime(event, newHour, currentTime.getMinutes(), currentTime.getSeconds(), currentTime.getMilliseconds());
          }
        } else {
          updateTime(event, newHour, currentTime.getMinutes(), currentTime.getSeconds(), currentTime.getMilliseconds());
        }
      }
      event.preventDefault();
    };
    var decrementHour = function decrementHour(event) {
      var currentTime = getCurrentDateTime();
      var currentHour = currentTime.getHours();
      var newHour = currentHour - props.stepHour;
      newHour = newHour < 0 ? newHour + 24 : newHour;
      if (validateHour(newHour, currentTime)) {
        if (props.minDate && props.minDate.toDateString() === currentTime.toDateString() && props.minDate.getHours() === newHour) {
          if (props.minDate.getMinutes() > currentTime.getMinutes()) {
            if (props.minDate.getSeconds() > currentTime.getSeconds()) {
              if (props.minDate.getMilliseconds() > currentTime.getMilliseconds()) {
                updateTime(event, newHour, props.minDate.getMinutes(), props.minDate.getSeconds(), props.minDate.getMilliseconds());
              } else {
                updateTime(event, newHour, props.minDate.getMinutes(), props.minDate.getSeconds(), currentTime.getMilliseconds());
              }
            } else {
              updateTime(event, newHour, props.minDate.getMinutes(), currentTime.getSeconds(), currentTime.getMilliseconds());
            }
          } else if (props.minDate.getMinutes() === currentTime.getMinutes()) {
            if (props.minDate.getSeconds() > currentTime.getSeconds()) {
              if (props.minDate.getMilliseconds() > currentTime.getMilliseconds()) {
                updateTime(event, newHour, props.minDate.getMinutes(), props.minDate.getSeconds(), props.minDate.getMilliseconds());
              } else {
                updateTime(event, newHour, props.minDate.getMinutes(), props.minDate.getSeconds(), currentTime.getMilliseconds());
              }
            } else {
              updateTime(event, newHour, props.minDate.getMinutes(), currentTime.getSeconds(), currentTime.getMilliseconds());
            }
          } else {
            updateTime(event, newHour, currentTime.getMinutes(), currentTime.getSeconds(), currentTime.getMilliseconds());
          }
        } else {
          updateTime(event, newHour, currentTime.getMinutes(), currentTime.getSeconds(), currentTime.getMilliseconds());
        }
      }
      event.preventDefault();
    };
    var doStepMinute = function doStepMinute(currentMinute, step) {
      if (props.stepMinute <= 1) {
        return step ? currentMinute + step : currentMinute;
      }
      if (!step) {
        step = props.stepMinute;
        if (currentMinute % step === 0) {
          return currentMinute;
        }
      }
      return Math.floor((currentMinute + step) / step) * step;
    };
    var incrementMinute = function incrementMinute(event) {
      var currentTime = getCurrentDateTime();
      var currentMinute = currentTime.getMinutes();
      var newMinute = doStepMinute(currentMinute, props.stepMinute);
      newMinute = newMinute > 59 ? newMinute - 60 : newMinute;
      if (validateMinute(newMinute, currentTime)) {
        if (props.maxDate && props.maxDate.toDateString() === currentTime.toDateString() && props.maxDate.getMinutes() === newMinute) {
          if (props.maxDate.getSeconds() < currentTime.getSeconds()) {
            if (props.maxDate.getMilliseconds() < currentTime.getMilliseconds()) {
              updateTime(event, currentTime.getHours(), newMinute, props.maxDate.getSeconds(), props.maxDate.getMilliseconds());
            } else {
              updateTime(event, currentTime.getHours(), newMinute, props.maxDate.getSeconds(), currentTime.getMilliseconds());
            }
          } else {
            updateTime(event, currentTime.getHours(), newMinute, currentTime.getSeconds(), currentTime.getMilliseconds());
          }
        } else {
          updateTime(event, currentTime.getHours(), newMinute, currentTime.getSeconds(), currentTime.getMilliseconds());
        }
      }
      event.preventDefault();
    };
    var decrementMinute = function decrementMinute(event) {
      var currentTime = getCurrentDateTime();
      var currentMinute = currentTime.getMinutes();
      var newMinute = doStepMinute(currentMinute, -props.stepMinute);
      newMinute = newMinute < 0 ? newMinute + 60 : newMinute;
      if (validateMinute(newMinute, currentTime)) {
        if (props.minDate && props.minDate.toDateString() === currentTime.toDateString() && props.minDate.getMinutes() === newMinute) {
          if (props.minDate.getSeconds() > currentTime.getSeconds()) {
            if (props.minDate.getMilliseconds() > currentTime.getMilliseconds()) {
              updateTime(event, currentTime.getHours(), newMinute, props.minDate.getSeconds(), props.minDate.getMilliseconds());
            } else {
              updateTime(event, currentTime.getHours(), newMinute, props.minDate.getSeconds(), currentTime.getMilliseconds());
            }
          } else {
            updateTime(event, currentTime.getHours(), newMinute, currentTime.getSeconds(), currentTime.getMilliseconds());
          }
        } else {
          updateTime(event, currentTime.getHours(), newMinute, currentTime.getSeconds(), currentTime.getMilliseconds());
        }
      }
      event.preventDefault();
    };
    var incrementSecond = function incrementSecond(event) {
      var currentTime = getCurrentDateTime();
      var currentSecond = currentTime.getSeconds();
      var newSecond = currentSecond + props.stepSecond;
      newSecond = newSecond > 59 ? newSecond - 60 : newSecond;
      if (validateSecond(newSecond, currentTime)) {
        if (props.maxDate && props.maxDate.toDateString() === currentTime.toDateString() && props.maxDate.getSeconds() === newSecond) {
          if (props.maxDate.getMilliseconds() < currentTime.getMilliseconds()) {
            updateTime(event, currentTime.getHours(), currentTime.getMinutes(), newSecond, props.maxDate.getMilliseconds());
          } else {
            updateTime(event, currentTime.getHours(), currentTime.getMinutes(), newSecond, currentTime.getMilliseconds());
          }
        } else {
          updateTime(event, currentTime.getHours(), currentTime.getMinutes(), newSecond, currentTime.getMilliseconds());
        }
      }
      event.preventDefault();
    };
    var decrementSecond = function decrementSecond(event) {
      var currentTime = getCurrentDateTime();
      var currentSecond = currentTime.getSeconds();
      var newSecond = currentSecond - props.stepSecond;
      newSecond = newSecond < 0 ? newSecond + 60 : newSecond;
      if (validateSecond(newSecond, currentTime)) {
        if (props.minDate && props.minDate.toDateString() === currentTime.toDateString() && props.minDate.getSeconds() === newSecond) {
          if (props.minDate.getMilliseconds() > currentTime.getMilliseconds()) {
            updateTime(event, currentTime.getHours(), currentTime.getMinutes(), newSecond, props.minDate.getMilliseconds());
          } else {
            updateTime(event, currentTime.getHours(), currentTime.getMinutes(), newSecond, currentTime.getMilliseconds());
          }
        } else {
          updateTime(event, currentTime.getHours(), currentTime.getMinutes(), newSecond, currentTime.getMilliseconds());
        }
      }
      event.preventDefault();
    };
    var incrementMilliSecond = function incrementMilliSecond(event) {
      var currentTime = getCurrentDateTime();
      var currentMillisecond = currentTime.getMilliseconds();
      var newMillisecond = currentMillisecond + props.stepMillisec;
      newMillisecond = newMillisecond > 999 ? newMillisecond - 1000 : newMillisecond;
      if (validateMillisecond(newMillisecond, currentTime)) {
        updateTime(event, currentTime.getHours(), currentTime.getMinutes(), currentTime.getSeconds(), newMillisecond);
      }
      event.preventDefault();
    };
    var decrementMilliSecond = function decrementMilliSecond(event) {
      var currentTime = getCurrentDateTime();
      var currentMillisecond = currentTime.getMilliseconds();
      var newMillisecond = currentMillisecond - props.stepMillisec;
      newMillisecond = newMillisecond < 0 ? newMillisecond + 999 : newMillisecond;
      if (validateMillisecond(newMillisecond, currentTime)) {
        updateTime(event, currentTime.getHours(), currentTime.getMinutes(), currentTime.getSeconds(), newMillisecond);
      }
      event.preventDefault();
    };
    var toggleAmPm = function toggleAmPm(event) {
      var currentTime = getCurrentDateTime();
      var currentHour = currentTime.getHours();
      var newHour = currentHour >= 12 ? currentHour - 12 : currentHour + 12;
      if (validateHour(convertTo24Hour(newHour, !(currentHour > 11)), currentTime)) {
        updateTime(event, newHour, currentTime.getMinutes(), currentTime.getSeconds(), currentTime.getMilliseconds());
      }
      event.preventDefault();
    };
    var getViewDate = function getViewDate(date) {
      var propValue = props.value;
      var viewDate = date || (props.onViewDateChange ? props.viewDate : viewDateState);
      if (Array.isArray(propValue)) {
        propValue = propValue[0];
      }
      return viewDate && isValidDate(viewDate) ? viewDate : propValue && isValidDate(propValue) ? propValue : new Date();
    };
    var getCurrentDateTime = function getCurrentDateTime() {
      if (isSingleSelection()) {
        return props.value && props.value instanceof Date ? cloneDate(props.value) : getViewDate();
      } else if (isMultipleSelection()) {
        if (props.value && props.value.length) {
          return cloneDate(props.value[props.value.length - 1]);
        }
      } else if (isRangeSelection()) {
        if (props.value && props.value.length) {
          var startDate = cloneDate(props.value[0]);
          var endDate = cloneDate(props.value[1]);
          return endDate || startDate;
        }
      }
      return new Date();
    };
    var cloneDate = function cloneDate(date) {
      return isValidDate(date) ? new Date(date.valueOf()) : date;
    };
    var isValidDate = function isValidDate(date) {
      return date instanceof Date && !isNaN(date);
    };
    var convertTo24Hour = function convertTo24Hour(hour, pm) {
      if (props.hourFormat == '12') {
        return hour === 12 ? pm ? 12 : 0 : pm ? hour + 12 : hour;
      }
      return hour;
    };
    var validateHour = function validateHour(hour, value) {
      var valid = true;
      var valueDateString = value ? value.toDateString() : null;
      if (props.minDate && valueDateString && props.minDate.toDateString() === valueDateString) {
        if (props.minDate.getHours() > hour) {
          valid = false;
        }
      }
      if (props.maxDate && valueDateString && props.maxDate.toDateString() === valueDateString) {
        if (props.maxDate.getHours() < hour) {
          valid = false;
        }
      }
      return valid;
    };
    var validateMinute = function validateMinute(minute, value) {
      var valid = true;
      var valueDateString = value ? value.toDateString() : null;
      if (props.minDate && valueDateString && props.minDate.toDateString() === valueDateString) {
        if (value.getHours() === props.minDate.getHours()) {
          if (props.minDate.getMinutes() > minute) {
            valid = false;
          }
        }
      }
      if (props.maxDate && valueDateString && props.maxDate.toDateString() === valueDateString) {
        if (value.getHours() === props.maxDate.getHours()) {
          if (props.maxDate.getMinutes() < minute) {
            valid = false;
          }
        }
      }
      return valid;
    };
    var validateSecond = function validateSecond(second, value) {
      var valid = true;
      var valueDateString = value ? value.toDateString() : null;
      if (props.minDate && valueDateString && props.minDate.toDateString() === valueDateString) {
        if (value.getHours() === props.minDate.getHours() && value.getMinutes() === props.minDate.getMinutes()) {
          if (props.minDate.getSeconds() > second) {
            valid = false;
          }
        }
      }
      if (props.maxDate && valueDateString && props.maxDate.toDateString() === valueDateString) {
        if (value.getHours() === props.maxDate.getHours() && value.getMinutes() === props.maxDate.getMinutes()) {
          if (props.maxDate.getSeconds() < second) {
            valid = false;
          }
        }
      }
      return valid;
    };
    var validateMillisecond = function validateMillisecond(millisecond, value) {
      var valid = true;
      var valueDateString = value ? value.toDateString() : null;
      if (props.minDate && valueDateString && props.minDate.toDateString() === valueDateString) {
        if (value.getHours() === props.minDate.getHours() && value.getSeconds() === props.minDate.getSeconds() && value.getMinutes() === props.minDate.getMinutes()) {
          if (props.minDate.getMilliseconds() > millisecond) {
            valid = false;
          }
        }
      }
      if (props.maxDate && valueDateString && props.maxDate.toDateString() === valueDateString) {
        if (value.getHours() === props.maxDate.getHours() && value.getSeconds() === props.maxDate.getSeconds() && value.getMinutes() === props.maxDate.getMinutes()) {
          if (props.maxDate.getMilliseconds() < millisecond) {
            valid = false;
          }
        }
      }
      return valid;
    };
    var validateDate = function validateDate(value) {
      if (props.yearNavigator) {
        var viewYear = value.getFullYear();
        var minRangeYear = props.yearRange ? parseInt(props.yearRange.split(':')[0], 10) : null;
        var maxRangeYear = props.yearRange ? parseInt(props.yearRange.split(':')[1], 10) : null;
        var minYear = props.minDate && minRangeYear != null ? Math.max(props.minDate.getFullYear(), minRangeYear) : props.minDate || minRangeYear;
        var maxYear = props.maxDate && maxRangeYear != null ? Math.min(props.maxDate.getFullYear(), maxRangeYear) : props.maxDate || maxRangeYear;
        if (minYear && minYear > viewYear) {
          viewYear = minYear;
        }
        if (maxYear && maxYear < viewYear) {
          viewYear = maxYear;
        }
        value.setFullYear(viewYear);
      }
      if (renderMonthsNavigator(0)) {
        var viewMonth = value.getMonth();
        var viewMonthWithMinMax = parseInt(isInMinYear(value) && Math.max(props.minDate.getMonth(), viewMonth).toString() || isInMaxYear(value) && Math.min(props.maxDate.getMonth(), viewMonth).toString() || viewMonth);
        value.setMonth(viewMonthWithMinMax);
      }
    };
    var updateTime = function updateTime(event, hour, minute, second, millisecond) {
      var newDateTime = getCurrentDateTime();
      newDateTime.setHours(hour);
      newDateTime.setMinutes(minute);
      newDateTime.setSeconds(second);
      newDateTime.setMilliseconds(millisecond);
      if (isMultipleSelection()) {
        if (props.value && props.value.length) {
          var value = _toConsumableArray(props.value);
          value[value.length - 1] = newDateTime;
          newDateTime = value;
        } else {
          newDateTime = [newDateTime];
        }
      } else if (isRangeSelection()) {
        if (props.value && props.value.length) {
          var startDate = props.value[0];
          var endDate = props.value[1];
          newDateTime = endDate ? [startDate, newDateTime] : [newDateTime, null];
        } else {
          newDateTime = [newDateTime, null];
        }
      }
      updateModel(event, newDateTime);
      if (props.onSelect) {
        props.onSelect({
          originalEvent: event,
          value: newDateTime
        });
      }
      updateInputfield(newDateTime);
    };
    var updateViewDate = function updateViewDate(event, value) {
      validateDate(value);
      if (props.onViewDateChange && event) {
        props.onViewDateChange({
          originalEvent: event,
          value: value
        });
      } else {
        viewStateChanged.current = true;
        setViewDateState(value);
      }
      setCurrentMonth(value.getMonth());
      setCurrentYear(value.getFullYear());
    };
    var setNavigationState = function setNavigationState(newViewDate) {
      if (!newViewDate || !props.showMinMaxRange || props.view !== 'date' || !overlayRef.current) {
        return;
      }
      var navPrev = DomHandler.findSingle(overlayRef.current, '[data-pc-section="previousbutton"]');
      var navNext = DomHandler.findSingle(overlayRef.current, '[data-pc-section="nextbutton"]');
      if (props.disabled) {
        !isUnstyled() && DomHandler.addClass(navPrev, 'p-disabled');
        navPrev.setAttribute('data-p-disabled', true);
        !isUnstyled() && DomHandler.addClass(navNext, 'p-disabled');
        navNext.setAttribute('data-p-disabled', true);
        return;
      }

      // previous (check first day of month at 00:00:00)
      if (props.minDate) {
        var firstDayOfMonth = cloneDate(newViewDate);
        if (firstDayOfMonth.getMonth() === 0) {
          firstDayOfMonth.setMonth(11, 1);
          firstDayOfMonth.setFullYear(firstDayOfMonth.getFullYear() - 1);
        } else {
          firstDayOfMonth.setMonth(firstDayOfMonth.getMonth(), 1);
        }
        firstDayOfMonth.setHours(0);
        firstDayOfMonth.setMinutes(0);
        firstDayOfMonth.setSeconds(0);
        if (props.minDate > firstDayOfMonth) {
          DomHandler.addClass(navPrev, 'p-disabled');
        } else {
          DomHandler.removeClass(navPrev, 'p-disabled');
        }
      }

      // next (check last day of month at 11:59:59)
      if (props.maxDate) {
        var lastDayOfMonth = cloneDate(newViewDate);
        if (lastDayOfMonth.getMonth() === 11) {
          lastDayOfMonth.setMonth(0, 1);
          lastDayOfMonth.setFullYear(lastDayOfMonth.getFullYear() + 1);
        } else {
          lastDayOfMonth.setMonth(lastDayOfMonth.getMonth() + 1, 1);
        }
        lastDayOfMonth.setHours(0);
        lastDayOfMonth.setMinutes(0);
        lastDayOfMonth.setSeconds(0);
        lastDayOfMonth.setSeconds(-1);
        if (props.maxDate < lastDayOfMonth) {
          DomHandler.addClass(navNext, 'p-disabled');
        } else {
          DomHandler.removeClass(navNext, 'p-disabled');
        }
      }
    };
    var onDateCellKeydown = function onDateCellKeydown(event, date, groupIndex) {
      var cellContent = event.currentTarget;
      var cell = cellContent.parentElement;
      switch (event.which) {
        //down arrow
        case 40:
          {
            cellContent.tabIndex = '-1';
            var cellIndex = DomHandler.index(cell);
            var nextRow = cell.parentElement.nextElementSibling;
            if (nextRow) {
              var focusCell = nextRow.children[cellIndex].children[0];
              if (DomHandler.hasClass(focusCell, 'p-disabled')) {
                navigation.current = {
                  backward: false
                };
                navForward(event);
              } else {
                nextRow.children[cellIndex].children[0].tabIndex = '0';
                nextRow.children[cellIndex].children[0].focus();
              }
            } else {
              navigation.current = {
                backward: false
              };
              navForward(event);
            }
            event.preventDefault();
            break;
          }

        //up arrow
        case 38:
          {
            cellContent.tabIndex = '-1';
            var _cellIndex = DomHandler.index(cell);
            var prevRow = cell.parentElement.previousElementSibling;
            if (prevRow) {
              var _focusCell = prevRow.children[_cellIndex].children[0];
              if (DomHandler.hasClass(_focusCell, 'p-disabled')) {
                navigation.current = {
                  backward: true
                };
                navBackward(event);
              } else {
                _focusCell.tabIndex = '0';
                _focusCell.focus();
              }
            } else {
              navigation.current = {
                backward: true
              };
              navBackward(event);
            }
            event.preventDefault();
            break;
          }

        //left arrow
        case 37:
          {
            cellContent.tabIndex = '-1';
            var prevCell = cell.previousElementSibling;
            if (prevCell) {
              var _focusCell2 = prevCell.children[0];
              if (DomHandler.hasClass(_focusCell2, 'p-disabled')) {
                navigateToMonth(true, groupIndex, event);
              } else {
                _focusCell2.tabIndex = '0';
                _focusCell2.focus();
              }
            } else {
              navigateToMonth(true, groupIndex, event);
            }
            event.preventDefault();
            break;
          }

        //right arrow
        case 39:
          {
            cellContent.tabIndex = '-1';
            var nextCell = cell.nextElementSibling;
            if (nextCell) {
              var _focusCell3 = nextCell.children[0];
              if (DomHandler.hasClass(_focusCell3, 'p-disabled')) {
                navigateToMonth(false, groupIndex, event);
              } else {
                _focusCell3.tabIndex = '0';
                _focusCell3.focus();
              }
            } else {
              navigateToMonth(false, groupIndex, event);
            }
            event.preventDefault();
            break;
          }

        //enter
        case 13:
          {
            onDateSelect(event, date);
            event.preventDefault();
            break;
          }

        //escape
        case 27:
          {
            hide(null, reFocusInputField);
            event.preventDefault();
            break;
          }

        //tab
        case 9:
          {
            trapFocus(event);
            break;
          }
      }
    };
    var navigateToMonth = function navigateToMonth(prev, groupIndex, event) {
      if (prev) {
        if (props.numberOfMonths === 1 || groupIndex === 0) {
          navigation.current = {
            backward: true
          };
          navBackward(event);
        } else {
          var prevMonthContainer = overlayRef.current.children[groupIndex - 1];
          var cells = DomHandler.find(prevMonthContainer, 'table td span:not([data-p-disabled="true"])');
          var focusCell = cells[cells.length - 1];
          focusCell.tabIndex = '0';
          focusCell.focus();
        }
      } else {
        if (props.numberOfMonths === 1 || groupIndex === props.numberOfMonths - 1) {
          navigation.current = {
            backward: false
          };
          navForward(event);
        } else {
          var nextMonthContainer = overlayRef.current.children[groupIndex + 1];
          var _focusCell4 = DomHandler.findSingle(nextMonthContainer, 'table td span:not([data-p-disabled="true"])');
          _focusCell4.tabIndex = '0';
          _focusCell4.focus();
        }
      }
    };
    var onMonthCellKeydown = function onMonthCellKeydown(event, index) {
      var cell = event.currentTarget;
      switch (event.which) {
        //arrows
        case 38:
        case 40:
          {
            cell.tabIndex = '-1';
            var cells = cell.parentElement.children;
            var cellIndex = DomHandler.index(cell);
            var nextCell = cells[event.which === 40 ? cellIndex + 3 : cellIndex - 3];
            if (nextCell) {
              nextCell.tabIndex = '0';
              nextCell.focus();
            }
            event.preventDefault();
            break;
          }

        //left arrow
        case 37:
          {
            cell.tabIndex = '-1';
            var prevCell = cell.previousElementSibling;
            if (prevCell) {
              prevCell.tabIndex = '0';
              prevCell.focus();
            }
            event.preventDefault();
            break;
          }

        //right arrow
        case 39:
          {
            cell.tabIndex = '-1';
            var _nextCell = cell.nextElementSibling;
            if (_nextCell) {
              _nextCell.tabIndex = '0';
              _nextCell.focus();
            }
            event.preventDefault();
            break;
          }

        //enter
        case 13:
          {
            onMonthSelect(event, index);
            event.preventDefault();
            break;
          }

        //escape
        case 27:
          {
            hide(null, reFocusInputField);
            event.preventDefault();
            break;
          }

        //tab
        case 9:
          {
            trapFocus(event);
            break;
          }
      }
    };
    var onDateSelect = function onDateSelect(event, dateMeta, timeMeta) {
      if (props.disabled || !dateMeta.selectable) {
        event.preventDefault();
        return;
      }
      DomHandler.find(overlayRef.current, 'table td span:not([data-p-disabled="true"])').forEach(function (cell) {
        return cell.tabIndex = -1;
      });
      event.currentTarget.focus();
      if (isMultipleSelection()) {
        if (isSelected(dateMeta)) {
          var value = props.value.filter(function (date, i) {
            return !isDateEquals(date, dateMeta);
          });
          updateModel(event, value);
          updateInputfield(value);
        } else if (!props.maxDateCount || !props.value || props.maxDateCount > props.value.length) {
          selectDate(event, dateMeta, timeMeta);
        }
      } else {
        selectDate(event, dateMeta, timeMeta);
      }
      if (!props.inline && isSingleSelection() && (!props.showTime || props.hideOnDateTimeSelect)) {
        setTimeout(function () {
          hide('dateselect');
        }, 100);
        if (touchUIMask.current) {
          disableModality();
        }
      }
      event.preventDefault();
    };
    var selectTime = function selectTime(date, timeMeta) {
      if (props.showTime) {
        var hours, minutes, seconds, milliseconds;
        if (timeMeta) {
          hours = timeMeta.hours;
          minutes = timeMeta.minutes;
          seconds = timeMeta.seconds;
          milliseconds = timeMeta.milliseconds;
        } else {
          var time = getCurrentDateTime();
          var _ref2 = [time.getHours(), time.getMinutes(), time.getSeconds(), time.getMilliseconds()];
          hours = _ref2[0];
          minutes = _ref2[1];
          seconds = _ref2[2];
          milliseconds = _ref2[3];
        }
        date.setHours(hours);
        date.setMinutes(doStepMinute(minutes));
        date.setSeconds(seconds);
        date.setMilliseconds(milliseconds);
      }
    };
    var selectDate = function selectDate(event, dateMeta, timeMeta) {
      var date = new Date(dateMeta.year, dateMeta.month, dateMeta.day);
      selectTime(date, timeMeta);
      if (props.minDate && props.minDate > date) {
        date = props.minDate;
      }
      if (props.maxDate && props.maxDate < date) {
        date = props.maxDate;
      }
      var selectedValues = date;
      if (isSingleSelection()) {
        updateModel(event, date);
      } else if (isMultipleSelection()) {
        selectedValues = props.value ? [].concat(_toConsumableArray(props.value), [date]) : [date];
        updateModel(event, selectedValues);
      } else if (isRangeSelection()) {
        if (props.value && props.value.length) {
          var startDate = props.value[0];
          var endDate = props.value[1];
          if (!endDate) {
            if (date.getTime() >= startDate.getTime()) {
              endDate = date;
            } else {
              endDate = startDate;
              startDate = date;
            }
          } else {
            startDate = date;
            endDate = null;
          }
          selectedValues = [startDate, endDate];
          updateModel(event, selectedValues);
        } else {
          selectedValues = [date, null];
          updateModel(event, selectedValues);
        }
      }
      if (props.onSelect) {
        props.onSelect({
          originalEvent: event,
          value: date
        });
      }
      updateInputfield(selectedValues);
    };
    var decrementDecade = function decrementDecade() {
      var _currentYear = currentYear - 10;
      setCurrentYear(_currentYear);
      return _currentYear;
    };
    var incrementDecade = function incrementDecade() {
      var _currentYear = currentYear + 10;
      setCurrentYear(_currentYear);
      return _currentYear;
    };
    var switchToMonthView = function switchToMonthView(event) {
      setCurrentView('month');
      event.preventDefault();
    };
    var switchToYearView = function switchToYearView(event) {
      setCurrentView('year');
      event.preventDefault();
    };
    var onMonthSelect = function onMonthSelect(event, month) {
      if (props.view === 'month') {
        onDateSelect(event, {
          year: currentYear,
          month: month,
          day: 1,
          selectable: true
        });
        event.preventDefault();
      } else {
        setCurrentMonth(month);
        createMonthsMeta(month, currentYear);
        var currentDate = cloneDate(getCurrentDateTime());
        currentDate.setDate(1); // #2948 always set to 1st of month
        currentDate.setMonth(month);
        currentDate.setYear(currentYear);
        setViewDateState(currentDate);
        setCurrentView('date');
        props.onMonthChange && props.onMonthChange({
          month: month + 1,
          year: currentYear
        });
      }
    };
    var onYearSelect = function onYearSelect(event, year) {
      if (props.view === 'year') {
        onDateSelect(event, {
          year: year,
          month: 0,
          day: 1,
          selectable: true
        });
      } else {
        setCurrentYear(year);
        setCurrentView('month');
        props.onMonthChange && props.onMonthChange({
          month: currentMonth + 1,
          year: year
        });
      }
    };
    var updateModel = function updateModel(event, value) {
      if (props.onChange) {
        var newValue = cloneDate(value);
        viewStateChanged.current = true;
        onChangeRef.current({
          originalEvent: event,
          value: newValue,
          stopPropagation: function stopPropagation() {
            event.stopPropagation();
          },
          preventDefault: function preventDefault() {
            event.preventDefault();
          },
          target: {
            name: props.name,
            id: props.id,
            value: newValue
          }
        });
      }
    };
    var show = function show(type) {
      if (props.onVisibleChange) {
        props.onVisibleChange({
          visible: true,
          type: type
        });
      } else {
        setOverlayVisibleState(true);
        overlayEventListener.current = function (e) {
          if (!isOutsideClicked(e)) {
            isOverlayClicked.current = true;
          }
        };
        OverlayService.on('overlay-click', overlayEventListener.current);
      }
    };
    var hide = function hide(type, callback) {
      var _hideCallback = function _hideCallback() {
        viewStateChanged.current = false;
        ignoreFocusFunctionality.current = false;
        isOverlayClicked.current = false;
        callback && callback();
        OverlayService.off('overlay-click', overlayEventListener.current);
        overlayEventListener.current = null;
      };
      props.touchUI && disableModality();
      if (props.onVisibleChange) {
        props.onVisibleChange({
          visible: type !== 'dateselect',
          // false only if selecting a value to close panel
          type: type,
          callback: _hideCallback
        });
      } else {
        setOverlayVisibleState(false);
        _hideCallback();
      }
    };
    var onOverlayEnter = function onOverlayEnter() {
      var styles = props.touchUI ? {
        position: 'fixed',
        top: '50%',
        left: '50%',
        transform: 'translate(-50%, -50%)'
      } : !props.inline ? {
        position: 'absolute',
        top: '0',
        left: '0'
      } : undefined;
      DomHandler.addStyles(overlayRef.current, styles);
      if (props.autoZIndex) {
        var key = props.touchUI ? 'modal' : 'overlay';
        ZIndexUtils.set(key, overlayRef.current, context && context.autoZIndex || PrimeReact.autoZIndex, props.baseZIndex || context && context.zIndex[key] || PrimeReact.zIndex[key]);
      }
      if (!props.touchUI && overlayRef && overlayRef.current && inputRef && inputRef.current && !appendDisabled()) {
        var inputWidth = DomHandler.getOuterWidth(inputRef.current);

        // #5435 must have reasonable width if input is too small
        if (inputWidth < 220) {
          inputWidth = 220;
        }
        if (props.view === 'date') {
          overlayRef.current.style.width = DomHandler.getOuterWidth(overlayRef.current) + 'px';
          overlayRef.current.style.minWidth = inputWidth + 'px';
        } else {
          overlayRef.current.style.minWidth = inputWidth + 'px';
          overlayRef.current.style.width = inputWidth + 'px';
        }
      }
      alignOverlay();
    };
    var onOverlayEntered = function onOverlayEntered() {
      bindOverlayListener();
      props.onShow && props.onShow();
      DomHandler.focusFirstElement(overlayRef.current);
      setFocusedState(false);
    };
    var onOverlayExit = function onOverlayExit() {
      unbindOverlayListener();
    };
    var onOverlayExited = function onOverlayExited() {
      ZIndexUtils.clear(overlayRef.current);
      props.onHide && props.onHide();
    };
    var appendDisabled = function appendDisabled() {
      var appendTo = props.appendTo || context && context.appendTo || PrimeReact.appendTo;
      return appendTo === 'self' || props.inline;
    };
    var alignOverlay = function alignOverlay() {
      if (props.touchUI) {
        enableModality();
      } else if (overlayRef && overlayRef.current && inputRef && inputRef.current) {
        DomHandler.alignOverlay(overlayRef.current, inputRef.current, props.appendTo || context && context.appendTo || PrimeReact.appendTo);
        if (appendDisabled()) {
          DomHandler.relativePosition(overlayRef.current, inputRef.current);
        } else {
          DomHandler.absolutePosition(overlayRef.current, inputRef.current);
        }
      }
    };
    var enableModality = function enableModality() {
      if (!touchUIMask.current) {
        touchUIMask.current = document.createElement('div');
        touchUIMask.current.style.zIndex = String(ZIndexUtils.get(overlayRef.current) - 1);
        !isUnstyled() && DomHandler.addMultipleClasses(touchUIMask.current, 'p-component-overlay p-datepicker-mask p-datepicker-mask-scrollblocker p-component-overlay-enter');
        touchUIMaskClickListener.current = function () {
          disableModality();
          hide();
        };
        touchUIMask.current.addEventListener('click', touchUIMaskClickListener.current);
        document.body.appendChild(touchUIMask.current);
        DomHandler.blockBodyScroll();
      }
    };
    var disableModality = function disableModality() {
      if (touchUIMask.current) {
        if (isUnstyled) {
          destroyMask();
        } else {
          DomHandler.addClass(touchUIMask.current, 'p-component-overlay-leave');
          touchUIMask.current.addEventListener('animationend', function () {
            destroyMask();
          });
        }
      }
    };
    var destroyMask = function destroyMask() {
      if (touchUIMask.current) {
        touchUIMask.current.removeEventListener('click', touchUIMaskClickListener.current);
        touchUIMaskClickListener.current = null;
        document.body.removeChild(touchUIMask.current);
        touchUIMask.current = null;
      }
      var bodyChildren = document.body.children;
      var hasBlockerMasks;
      for (var i = 0; i < bodyChildren.length; i++) {
        var bodyChild = bodyChildren[i];
        if (DomHandler.hasClass(bodyChild, 'p-datepicker-mask-scrollblocker')) {
          hasBlockerMasks = true;
          break;
        }
      }
      if (!hasBlockerMasks) {
        DomHandler.unblockBodyScroll();
      }
    };
    var isOutsideClicked = function isOutsideClicked(event) {
      return elementRef.current && !(elementRef.current.isSameNode(event.target) || isNavIconClicked(event.target) || elementRef.current.contains(event.target) || overlayRef.current && overlayRef.current.contains(event.target));
    };
    var isNavIconClicked = function isNavIconClicked(target) {
      return previousButton.current && (previousButton.current.isSameNode(target) || previousButton.current.contains(target)) || nextButton.current && (nextButton.current.isSameNode(target) || nextButton.current.contains(target));
    };
    var getFirstDayOfMonthIndex = function getFirstDayOfMonthIndex(month, year) {
      var day = new Date();
      day.setDate(1);
      day.setMonth(month);
      day.setFullYear(year);
      var dayIndex = day.getDay() + getSundayIndex();
      return dayIndex >= 7 ? dayIndex - 7 : dayIndex;
    };
    var getDaysCountInMonth = function getDaysCountInMonth(month, year) {
      return 32 - daylightSavingAdjust(new Date(year, month, 32)).getDate();
    };
    var getDaysCountInPrevMonth = function getDaysCountInPrevMonth(month, year) {
      var prev = getPreviousMonthAndYear(month, year);
      return getDaysCountInMonth(prev.month, prev.year);
    };
    var daylightSavingAdjust = function daylightSavingAdjust(date) {
      if (!date) {
        return null;
      }
      date.setHours(date.getHours() > 12 ? date.getHours() + 2 : 0);
      return date;
    };
    var getPreviousMonthAndYear = function getPreviousMonthAndYear(month, year) {
      var m, y;
      if (month === 0) {
        m = 11;
        y = year - 1;
      } else {
        m = month - 1;
        y = year;
      }
      return {
        month: m,
        year: y
      };
    };
    var getNextMonthAndYear = function getNextMonthAndYear(month, year) {
      var m, y;
      if (month === 11) {
        m = 0;
        y = year + 1;
      } else {
        m = month + 1;
        y = year;
      }
      return {
        month: m,
        year: y
      };
    };
    var getSundayIndex = function getSundayIndex() {
      var firstDayOfWeek = localeOption('firstDayOfWeek', props.locale);
      return firstDayOfWeek > 0 ? 7 - firstDayOfWeek : 0;
    };
    var createWeekDaysMeta = function createWeekDaysMeta() {
      var weekDays = [];
      var _localeOptions = localeOptions(props.locale),
        dayIndex = _localeOptions.firstDayOfWeek,
        dayNamesMin = _localeOptions.dayNamesMin;
      for (var i = 0; i < 7; i++) {
        weekDays.push(dayNamesMin[dayIndex]);
        dayIndex = dayIndex === 6 ? 0 : ++dayIndex;
      }
      return weekDays;
    };
    var createMonthsMeta = function createMonthsMeta(month, year) {
      var months = [];
      for (var i = 0; i < props.numberOfMonths; i++) {
        var m = month + i;
        var y = year;
        if (m > 11) {
          m = m % 11 - 1;
          y = year + 1;
        }
        months.push(createMonthMeta(m, y));
      }
      return months;
    };
    var createMonthMeta = function createMonthMeta(month, year) {
      var dates = [];
      var firstDay = getFirstDayOfMonthIndex(month, year);
      var daysLength = getDaysCountInMonth(month, year);
      var prevMonthDaysLength = getDaysCountInPrevMonth(month, year);
      var dayNo = 1;
      var today = new Date();
      var weekNumbers = [];
      var monthRows = Math.ceil((daysLength + firstDay) / 7);
      for (var i = 0; i < monthRows; i++) {
        var week = [];
        if (i === 0) {
          for (var j = prevMonthDaysLength - firstDay + 1; j <= prevMonthDaysLength; j++) {
            var prev = getPreviousMonthAndYear(month, year);
            week.push({
              day: j,
              month: prev.month,
              year: prev.year,
              otherMonth: true,
              today: isToday(today, j, prev.month, prev.year),
              selectable: isSelectable(j, prev.month, prev.year, true)
            });
          }
          var remainingDaysLength = 7 - week.length;
          for (var _j = 0; _j < remainingDaysLength; _j++) {
            week.push({
              day: dayNo,
              month: month,
              year: year,
              today: isToday(today, dayNo, month, year),
              selectable: isSelectable(dayNo, month, year, false)
            });
            dayNo++;
          }
        } else {
          for (var _j2 = 0; _j2 < 7; _j2++) {
            if (dayNo > daysLength) {
              var next = getNextMonthAndYear(month, year);
              week.push({
                day: dayNo - daysLength,
                month: next.month,
                year: next.year,
                otherMonth: true,
                today: isToday(today, dayNo - daysLength, next.month, next.year),
                selectable: isSelectable(dayNo - daysLength, next.month, next.year, true)
              });
            } else {
              week.push({
                day: dayNo,
                month: month,
                year: year,
                today: isToday(today, dayNo, month, year),
                selectable: isSelectable(dayNo, month, year, false)
              });
            }
            dayNo++;
          }
        }
        if (props.showWeek) {
          weekNumbers.push(getWeekNumber(new Date(week[0].year, week[0].month, week[0].day)));
        }
        dates.push(week);
      }
      return {
        month: month,
        year: year,
        dates: dates,
        weekNumbers: weekNumbers
      };
    };
    var getWeekNumber = function getWeekNumber(date) {
      var checkDate = cloneDate(date);
      checkDate.setDate(checkDate.getDate() + 4 - (checkDate.getDay() || 7));
      var time = checkDate.getTime();
      checkDate.setMonth(0);
      checkDate.setDate(1);
      return Math.floor(Math.round((time - checkDate.getTime()) / 86400000) / 7) + 1;
    };
    var isSelectable = function isSelectable(day, month, year, otherMonth) {
      var validMin = true;
      var validMax = true;
      var validDate = true;
      var validDay = true;
      var validMonth = true;
      if (props.minDate) {
        if (props.minDate.getFullYear() > year) {
          validMin = false;
        } else if (props.minDate.getFullYear() === year) {
          if (month > -1 && props.minDate.getMonth() > month) {
            validMin = false;
          } else if (month > -1 && props.minDate.getMonth() === month) {
            if (day > 0 && props.minDate.getDate() > day) {
              validMin = false;
            }
          }
        }
      }
      if (props.maxDate) {
        if (props.maxDate.getFullYear() < year) {
          validMax = false;
        } else if (props.maxDate.getFullYear() === year) {
          if (month > -1 && props.maxDate.getMonth() < month) {
            validMax = false;
          } else if (month > -1 && props.maxDate.getMonth() === month) {
            if (day > 0 && props.maxDate.getDate() < day) {
              validMax = false;
            }
          }
        }
      }
      if (props.disabledDates || props.enabledDates || props.disabledDays) {
        validDay = !isDayDisabled(day, month, year);
      }
      if (props.selectOtherMonths === false && otherMonth) {
        validMonth = false;
      }
      return validMin && validMax && validDate && validDay && validMonth;
    };
    var isSelectableTime = function isSelectableTime(value) {
      var validMin = true;
      var validMax = true;
      if (props.minDate && props.minDate.toDateString() === value.toDateString()) {
        if (props.minDate.getHours() > value.getHours()) {
          validMin = false;
        } else if (props.minDate.getHours() === value.getHours()) {
          if (props.minDate.getMinutes() > value.getMinutes()) {
            validMin = false;
          } else if (props.minDate.getMinutes() === value.getMinutes()) {
            if (props.minDate.getSeconds() > value.getSeconds()) {
              validMin = false;
            } else if (props.minDate.getSeconds() === value.getSeconds()) {
              if (props.minDate.getMilliseconds() > value.getMilliseconds()) {
                validMin = false;
              }
            }
          }
        }
      }
      if (props.maxDate && props.maxDate.toDateString() === value.toDateString()) {
        if (props.maxDate.getHours() < value.getHours()) {
          validMax = false;
        } else if (props.maxDate.getHours() === value.getHours()) {
          if (props.maxDate.getMinutes() < value.getMinutes()) {
            validMax = false;
          } else if (props.maxDate.getMinutes() === value.getMinutes()) {
            if (props.maxDate.getSeconds() < value.getSeconds()) {
              validMax = false;
            } else if (props.maxDate.getSeconds() === value.getSeconds()) {
              if (props.maxDate.getMilliseconds() < value.getMilliseconds()) {
                validMax = false;
              }
            }
          }
        }
      }
      return validMin && validMax;
    };
    var isSelected = function isSelected(dateMeta) {
      if (props.value) {
        if (isSingleSelection()) {
          return isDateEquals(props.value, dateMeta);
        } else if (isMultipleSelection()) {
          var selected = false;
          var _iterator = _createForOfIteratorHelper$e(props.value),
            _step;
          try {
            for (_iterator.s(); !(_step = _iterator.n()).done;) {
              var date = _step.value;
              selected = isDateEquals(date, dateMeta);
              if (selected) {
                break;
              }
            }
          } catch (err) {
            _iterator.e(err);
          } finally {
            _iterator.f();
          }
          return selected;
        } else if (isRangeSelection()) {
          if (props.value[1]) return isDateEquals(props.value[0], dateMeta) || isDateEquals(props.value[1], dateMeta) || isDateBetween(props.value[0], props.value[1], dateMeta);else {
            return isDateEquals(props.value[0], dateMeta);
          }
        }
      } else {
        return false;
      }
    };
    var isComparable = function isComparable() {
      return props.value != null && typeof props.value !== 'string';
    };
    var isMonthSelected = function isMonthSelected(month) {
      if (isComparable()) {
        var value = isRangeSelection() ? props.value[0] : props.value;
        if (isMultipleSelection()) {
          return value.some(function (currentValue) {
            return currentValue.getMonth() === month && currentValue.getFullYear() === currentYear;
          });
        } else {
          return value.getMonth() === month && value.getFullYear() === currentYear;
        }
      }
      return false;
    };
    var isYearSelected = function isYearSelected(year) {
      if (isComparable()) {
        var value = isRangeSelection() ? props.value[0] : props.value;
        if (isMultipleSelection()) {
          return value.some(function (currentValue) {
            return currentValue.getFullYear() === year;
          });
        } else {
          return value.getFullYear() === year;
        }
      }
      return false;
    };
    var switchViewButtonDisabled = function switchViewButtonDisabled() {
      return props.numberOfMonths > 1 || props.disabled;
    };
    var isDateEquals = function isDateEquals(value, dateMeta) {
      if (value && value instanceof Date) return value.getDate() === dateMeta.day && value.getMonth() === dateMeta.month && value.getFullYear() === dateMeta.year;else return false;
    };
    var isDateBetween = function isDateBetween(start, end, dateMeta) {
      var between = false;
      if (start && end) {
        var date = new Date(dateMeta.year, dateMeta.month, dateMeta.day);
        return start.getTime() <= date.getTime() && end.getTime() >= date.getTime();
      }
      return between;
    };
    var isSingleSelection = function isSingleSelection() {
      return props.selectionMode === 'single';
    };
    var isRangeSelection = function isRangeSelection() {
      return props.selectionMode === 'range';
    };
    var isMultipleSelection = function isMultipleSelection() {
      return props.selectionMode === 'multiple';
    };
    var isToday = function isToday(today, day, month, year) {
      return today.getDate() === day && today.getMonth() === month && today.getFullYear() === year;
    };
    var isDayDisabled = function isDayDisabled(day, month, year) {
      if (props.disabledDates) {
        if (props.disabledDates.some(function (d) {
          return d.getFullYear() === year && d.getMonth() === month && d.getDate() === day;
        })) {
          return true;
        }
      } else if (props.enabledDates) {
        if (!props.enabledDates.some(function (d) {
          return d.getFullYear() === year && d.getMonth() === month && d.getDate() === day;
        })) {
          return true;
        }
      }
      if (props.disabledDays && currentView === 'date') {
        var weekday = new Date(year, month, day);
        var weekdayNumber = weekday.getDay();
        if (props.disabledDays.indexOf(weekdayNumber) !== -1) {
          return true;
        }
      }
      return false;
    };
    var isMonthYearDisabled = function isMonthYearDisabled(month, year) {
      var daysCountInAllMonth = month === -1 ? new Array(12).fill(0).map(function (_, i) {
        return getDaysCountInMonth(i, year);
      }) : [getDaysCountInMonth(month, year)];
      for (var i = 0; i < daysCountInAllMonth.length; i++) {
        var monthDays = daysCountInAllMonth[i];
        var _month = month === -1 ? i : month;
        for (var day = 1; day <= monthDays; day++) {
          var isDateSelectable = isSelectable(day, _month, year);
          if (isDateSelectable) {
            return false;
          }
        }
      }
      return true;
    };
    var updateInputfield = function updateInputfield(value) {
      if (!inputRef.current) {
        return;
      }
      var formattedValue = '';
      if (value) {
        try {
          if (isSingleSelection()) {
            formattedValue = isValidDate(value) ? formatDateTime(value) : props.keepInvalid ? value : '';
          } else if (isMultipleSelection()) {
            for (var i = 0; i < value.length; i++) {
              var selectedValue = value[i];
              var dateAsString = isValidDate(selectedValue) ? formatDateTime(selectedValue) : '';
              formattedValue += dateAsString;
              if (i !== value.length - 1) {
                formattedValue += ', ';
              }
            }
          } else if (isRangeSelection()) {
            if (value && value.length) {
              var startDate = value[0];
              var endDate = value[1];
              formattedValue = isValidDate(startDate) ? formatDateTime(startDate) : '';
              if (endDate) {
                formattedValue += isValidDate(endDate) ? ' - ' + formatDateTime(endDate) : '';
              }
            }
          }
        } catch (err) {
          formattedValue = value;
        }
      }
      inputRef.current.value = formattedValue;
    };
    var formatDateTime = function formatDateTime(date) {
      if (props.formatDateTime) {
        return props.formatDateTime(date);
      }
      var formattedValue = null;
      if (date) {
        if (props.timeOnly) {
          formattedValue = formatTime(date);
        } else {
          formattedValue = formatDate(date, getDateFormat());
          if (props.showTime) {
            formattedValue += ' ' + formatTime(date);
          }
        }
      }
      return formattedValue;
    };
    var formatDate = function formatDate(date, format) {
      if (!date) {
        return '';
      }
      var iFormat;
      var lookAhead = function lookAhead(match) {
          var matches = iFormat + 1 < format.length && format.charAt(iFormat + 1) === match;
          if (matches) {
            iFormat++;
          }
          return matches;
        },
        formatNumber = function formatNumber(match, value, len) {
          var num = '' + value;
          if (lookAhead(match)) {
            while (num.length < len) {
              num = '0' + num;
            }
          }
          return num;
        },
        formatName = function formatName(match, value, shortNames, longNames) {
          return lookAhead(match) ? longNames[value] : shortNames[value];
        };
      var output = '';
      var literal = false;
      var _localeOptions2 = localeOptions(props.locale),
        dayNamesShort = _localeOptions2.dayNamesShort,
        dayNames = _localeOptions2.dayNames,
        monthNamesShort = _localeOptions2.monthNamesShort,
        monthNames = _localeOptions2.monthNames;
      if (date) {
        for (iFormat = 0; iFormat < format.length; iFormat++) {
          if (literal) {
            if (format.charAt(iFormat) === "'" && !lookAhead("'")) {
              literal = false;
            } else {
              output += format.charAt(iFormat);
            }
          } else {
            switch (format.charAt(iFormat)) {
              case 'd':
                output += formatNumber('d', date.getDate(), 2);
                break;
              case 'D':
                output += formatName('D', date.getDay(), dayNamesShort, dayNames);
                break;
              case 'o':
                output += formatNumber('o', Math.round((new Date(date.getFullYear(), date.getMonth(), date.getDate()).getTime() - new Date(date.getFullYear(), 0, 0).getTime()) / 86400000), 3);
                break;
              case 'm':
                output += formatNumber('m', date.getMonth() + 1, 2);
                break;
              case 'M':
                output += formatName('M', date.getMonth(), monthNamesShort, monthNames);
                break;
              case 'y':
                output += lookAhead('y') ? date.getFullYear() : (date.getFullYear() % 100 < 10 ? '0' : '') + date.getFullYear() % 100;
                break;
              case '@':
                output += date.getTime();
                break;
              case '!':
                output += date.getTime() * 10000 + ticksTo1970;
                break;
              case "'":
                if (lookAhead("'")) {
                  output += "'";
                } else {
                  literal = true;
                }
                break;
              default:
                output += format.charAt(iFormat);
            }
          }
        }
      }
      return output;
    };
    var formatTime = function formatTime(date) {
      if (!date) {
        return '';
      }
      var output = '';
      var hours = date.getHours();
      var minutes = date.getMinutes();
      var seconds = date.getSeconds();
      var milliseconds = date.getMilliseconds();
      if (props.hourFormat === '12' && hours > 11 && hours !== 12) {
        hours -= 12;
      }
      if (props.hourFormat === '12') {
        output += hours === 0 ? 12 : hours < 10 ? '0' + hours : hours;
      } else {
        output += hours < 10 ? '0' + hours : hours;
      }
      output += ':';
      output += minutes < 10 ? '0' + minutes : minutes;
      if (props.showSeconds) {
        output += ':';
        output += seconds < 10 ? '0' + seconds : seconds;
      }
      if (props.showMillisec) {
        output += '.';
        output += milliseconds < 100 ? (milliseconds < 10 ? '00' : '0') + milliseconds : milliseconds;
      }
      if (props.hourFormat === '12') {
        output += date.getHours() > 11 ? ' PM' : ' AM';
      }
      return output;
    };
    var parseValueFromString = function parseValueFromString(text) {
      if (!text || text.trim().length === 0) {
        return null;
      }
      var value;
      if (isSingleSelection()) {
        value = parseDateTime(text);
      } else if (isMultipleSelection()) {
        var tokens = text.split(',');
        value = [];
        var _iterator2 = _createForOfIteratorHelper$e(tokens),
          _step2;
        try {
          for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
            var token = _step2.value;
            value.push(parseDateTime(token.trim()));
          }
        } catch (err) {
          _iterator2.e(err);
        } finally {
          _iterator2.f();
        }
      } else if (isRangeSelection()) {
        var _tokens = text.split(' - ');
        value = [];
        for (var i = 0; i < _tokens.length; i++) {
          value[i] = parseDateTime(_tokens[i].trim());
        }
      }
      return value;
    };
    var parseDateTime = function parseDateTime(text) {
      if (props.parseDateTime) {
        return props.parseDateTime(text);
      }
      var date;
      var parts = text.split(' ');
      if (props.timeOnly) {
        date = new Date();
        populateTime(date, parts[0], parts[1]);
      } else {
        if (props.showTime) {
          date = parseDate(parts[0], getDateFormat());
          populateTime(date, parts[1], parts[2]);
        } else {
          date = parseDate(text, getDateFormat());
        }
      }
      return date;
    };
    var populateTime = function populateTime(value, timeString, ampm) {
      if (props.hourFormat === '12' && ampm !== 'PM' && ampm !== 'AM') {
        throw new Error('Invalid Time');
      }
      var time = parseTime(timeString, ampm);
      value.setHours(time.hour);
      value.setMinutes(time.minute);
      value.setSeconds(time.second);
      value.setMilliseconds(time.millisecond);
    };
    var parseTime = function parseTime(value, ampm) {
      value = props.showMillisec ? value.replace('.', ':') : value;
      var tokens = value.split(':');
      var validTokenLength = props.showSeconds ? 3 : 2;
      validTokenLength = props.showMillisec ? validTokenLength + 1 : validTokenLength;
      if (tokens.length !== validTokenLength || tokens[0].length !== 2 || tokens[1].length !== 2 || props.showSeconds && tokens[2].length !== 2 || props.showMillisec && tokens[3].length !== 3) {
        throw new Error('Invalid time');
      }
      var h = parseInt(tokens[0], 10);
      var m = parseInt(tokens[1], 10);
      var s = props.showSeconds ? parseInt(tokens[2], 10) : null;
      var ms = props.showMillisec ? parseInt(tokens[3], 10) : null;
      if (isNaN(h) || isNaN(m) || h > 23 || m > 59 || props.hourFormat === '12' && h > 12 || props.showSeconds && (isNaN(s) || s > 59) || props.showMillisec && (isNaN(s) || s > 1000)) {
        throw new Error('Invalid time');
      } else {
        if (props.hourFormat === '12' && h !== 12 && ampm === 'PM') {
          h += 12;
        }
        return {
          hour: h,
          minute: m,
          second: s,
          millisecond: ms
        };
      }
    };

    // Ported from jquery-ui datepicker parseDate
    var parseDate = function parseDate(value, format) {
      if (format == null || value == null) {
        throw new Error('Invalid arguments');
      }
      value = _typeof(value) === 'object' ? value.toString() : value + '';
      if (value === '') {
        return null;
      }
      var iFormat,
        dim,
        extra,
        iValue = 0,
        shortYearCutoff = typeof props.shortYearCutoff !== 'string' ? props.shortYearCutoff : new Date().getFullYear() % 100 + parseInt(props.shortYearCutoff, 10),
        year = -1,
        month = -1,
        day = -1,
        doy = -1,
        literal = false,
        date,
        lookAhead = function lookAhead(match) {
          var matches = iFormat + 1 < format.length && format.charAt(iFormat + 1) === match;
          if (matches) {
            iFormat++;
          }
          return matches;
        },
        getNumber = function getNumber(match) {
          var isDoubled = lookAhead(match),
            size = match === '@' ? 14 : match === '!' ? 20 : match === 'y' && isDoubled ? 4 : match === 'o' ? 3 : 2,
            minSize = match === 'y' ? size : 1,
            digits = new RegExp('^\\d{' + minSize + ',' + size + '}'),
            num = value.substring(iValue).match(digits);
          if (!num) {
            throw new Error('Missing number at position ' + iValue);
          }
          iValue += num[0].length;
          return parseInt(num[0], 10);
        },
        getName = function getName(match, shortNames, longNames) {
          var index = -1;
          var arr = lookAhead(match) ? longNames : shortNames;
          var names = [];
          for (var i = 0; i < arr.length; i++) {
            names.push([i, arr[i]]);
          }
          names.sort(function (a, b) {
            return -(a[1].length - b[1].length);
          });
          for (var _i = 0; _i < names.length; _i++) {
            var name = names[_i][1];
            if (value.substr(iValue, name.length).toLowerCase() === name.toLowerCase()) {
              index = names[_i][0];
              iValue += name.length;
              break;
            }
          }
          if (index !== -1) {
            return index + 1;
          } else {
            throw new Error('Unknown name at position ' + iValue);
          }
        },
        checkLiteral = function checkLiteral() {
          if (value.charAt(iValue) !== format.charAt(iFormat)) {
            throw new Error('Unexpected literal at position ' + iValue);
          }
          iValue++;
        };
      if (props.view === 'month') {
        day = 1;
      }
      if (props.view === 'year') {
        day = 1;
        month = 1;
      }
      var _localeOptions3 = localeOptions(props.locale),
        dayNamesShort = _localeOptions3.dayNamesShort,
        dayNames = _localeOptions3.dayNames,
        monthNamesShort = _localeOptions3.monthNamesShort,
        monthNames = _localeOptions3.monthNames;
      for (iFormat = 0; iFormat < format.length; iFormat++) {
        if (literal) {
          if (format.charAt(iFormat) === "'" && !lookAhead("'")) {
            literal = false;
          } else {
            checkLiteral();
          }
        } else {
          switch (format.charAt(iFormat)) {
            case 'd':
              day = getNumber('d');
              break;
            case 'D':
              getName('D', dayNamesShort, dayNames);
              break;
            case 'o':
              doy = getNumber('o');
              break;
            case 'm':
              month = getNumber('m');
              break;
            case 'M':
              month = getName('M', monthNamesShort, monthNames);
              break;
            case 'y':
              year = getNumber('y');
              break;
            case '@':
              date = new Date(getNumber('@'));
              year = date.getFullYear();
              month = date.getMonth() + 1;
              day = date.getDate();
              break;
            case '!':
              date = new Date((getNumber('!') - ticksTo1970) / 10000);
              year = date.getFullYear();
              month = date.getMonth() + 1;
              day = date.getDate();
              break;
            case "'":
              if (lookAhead("'")) {
                checkLiteral();
              } else {
                literal = true;
              }
              break;
            default:
              checkLiteral();
          }
        }
      }
      if (iValue < value.length) {
        extra = value.substr(iValue);
        if (!/^\s+/.test(extra)) {
          throw new Error('Extra/unparsed characters found in date: ' + extra);
        }
      }
      if (year === -1) {
        year = new Date().getFullYear();
      } else if (year < 100) {
        year += new Date().getFullYear() - new Date().getFullYear() % 100 + (year <= shortYearCutoff ? 0 : -100);
      }
      if (doy > -1) {
        month = 1;
        day = doy;
        do {
          dim = getDaysCountInMonth(year, month - 1);
          if (day <= dim) {
            break;
          }
          month++;
          day -= dim;
        } while (true);
      }
      date = daylightSavingAdjust(new Date(year, month - 1, day));
      if (date.getFullYear() !== year || date.getMonth() + 1 !== month || date.getDate() !== day) {
        throw new Error('Invalid date'); // E.g. 31/02/00
      }

      return date;
    };
    var isInMinYear = function isInMinYear(viewDate) {
      return props.minDate && props.minDate.getFullYear() === viewDate.getFullYear();
    };
    var isInMaxYear = function isInMaxYear(viewDate) {
      return props.maxDate && props.maxDate.getFullYear() === viewDate.getFullYear();
    };
    React__namespace.useEffect(function () {
      ObjectUtils.combinedRefs(inputRef, props.inputRef);
    }, [inputRef, props.inputRef]);
    useMountEffect(function () {
      var viewDate = getViewDate(props.viewDate);
      validateDate(viewDate);
      setViewDateState(viewDate);
      setCurrentMonth(viewDate.getMonth());
      setCurrentYear(viewDate.getFullYear());
      setCurrentView(props.view);
      if (props.inline) {
        overlayRef && overlayRef.current.setAttribute(attributeSelector, '');
        if (!props.disabled) {
          initFocusableCell();
          if (props.numberOfMonths === 1) {
            overlayRef.current.style.width = DomHandler.getOuterWidth(overlayRef.current) + 'px';
          }
        }
      }
      if (props.value) {
        updateInputfield(props.value);
        setValue(props.value);
      }
      if (props.autoFocus) {
        // delay showing until rendered so `alignPanel()` method aligns the popup in the right location
        setTimeout(function () {
          return DomHandler.focus(inputRef.current, props.autoFocus);
        }, 200);
      }
    });
    React__namespace.useEffect(function () {
      // see https://github.com/primefaces/primereact/issues/4030
      onChangeRef.current = props.onChange;
    }, [props.onChange]);
    React__namespace.useEffect(function () {
      var unbindMaskEvents = null;
      if (props.mask) {
        unbindMaskEvents = mask(inputRef.current, {
          mask: props.mask,
          slotChar: props.maskSlotChar,
          readOnly: props.readOnlyInput || props.disabled,
          onChange: function onChange(e) {
            updateValueOnInput(e.originalEvent, e.value, function () {
              return false;
            });
          },
          onBlur: function onBlur(e) {
            updateValueOnInput(e, e.target.value);
          }
        }).unbindEvents;
      }
      return function () {
        props.mask && unbindMaskEvents && unbindMaskEvents();
      };
      // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [props.disabled, props.mask, props.readOnlyInput]);
    useUpdateEffect(function () {
      setCurrentView(props.view);
    }, [props.view]);
    useUpdateEffect(function () {
      if (!props.onViewDateChange && !viewStateChanged.current) {
        setValue(props.value);
      }
      if (props.viewDate) {
        updateViewDate(null, getViewDate(props.viewDate));
      }
    }, [props.onViewDateChange, props.value, props.viewDate]);
    useUpdateEffect(function () {
      if (overlayVisibleState || props.visible) {
        // Github #5529
        setTimeout(function () {
          alignOverlay();
        });
      }
    }, [currentView, overlayVisibleState, props.visible]);
    useUpdateEffect(function () {
      var newDate = props.value;
      if (previousValue !== newDate) {
        updateInputfield(newDate);

        // #3516 view date not updated when value set programatically
        if (!visible && newDate) {
          var viewDate = newDate;
          if (isMultipleSelection()) {
            if (newDate.length) {
              viewDate = newDate[newDate.length - 1];
            }
          } else if (isRangeSelection()) {
            if (newDate.length) {
              var startDate = newDate[0];
              var endDate = newDate[1];
              viewDate = endDate || startDate;
            }
          }
          if (viewDate instanceof Date) {
            validateDate(viewDate);
            setViewDateState(viewDate);
            setCurrentMonth(viewDate.getMonth());
            setCurrentYear(viewDate.getFullYear());
          }
        }
      }
    }, [props.value, visible]);
    useUpdateEffect(function () {
      updateInputfield(props.value);
    }, [props.dateFormat, props.hourFormat, props.timeOnly, props.showSeconds, props.showMillisec, props.showTime, props.locale]);
    useUpdateEffect(function () {
      if (overlayRef.current) {
        setNavigationState(viewDateState);
        updateFocus();
      }
    });
    useUnmountEffect(function () {
      if (touchUIMask.current) {
        disableModality();
        touchUIMask.current = null;
      }
      ZIndexUtils.clear(overlayRef.current);
    });
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        show: show,
        hide: hide,
        getCurrentDateTime: getCurrentDateTime,
        getViewDate: getViewDate,
        updateViewDate: updateViewDate,
        focus: function focus() {
          return DomHandler.focus(inputRef.current);
        },
        getElement: function getElement() {
          return elementRef.current;
        },
        getOverlay: function getOverlay() {
          return overlayRef.current;
        },
        getInput: function getInput() {
          return inputRef.current;
        }
      };
    });
    var setValue = function setValue(propValue) {
      if (Array.isArray(propValue)) {
        propValue = propValue[0];
      }
      var prevPropValue = previousValue;
      if (Array.isArray(prevPropValue)) {
        prevPropValue = prevPropValue[0];
      }
      if (!prevPropValue && propValue || propValue && propValue instanceof Date && propValue.getTime() !== prevPropValue.getTime()) {
        var viewDate = props.viewDate && isValidDate(props.viewDate) ? props.viewDate : propValue && isValidDate(propValue) ? propValue : new Date();
        validateDate(viewDate);
        setViewDateState(viewDate);
        viewStateChanged.current = true;
      }
    };
    var createBackwardNavigator = function createBackwardNavigator(isVisible) {
      var navigatorProps = isVisible ? {
        onClick: onPrevButtonClick,
        onKeyDown: function onKeyDown(e) {
          return onContainerButtonKeydown(e);
        }
      } : {
        style: {
          visibility: 'hidden'
        }
      };
      var previousIconProps = mergeProps({
        className: cx('previousIcon')
      }, ptm('previousIcon'));
      var icon = props.prevIcon || /*#__PURE__*/React__namespace.createElement(ChevronLeftIcon, previousIconProps);
      var backwardNavigatorIcon = IconUtils.getJSXIcon(icon, _objectSpread$1z({}, previousIconProps), {
        props: props
      });
      var previousButtonProps = mergeProps(_objectSpread$1z({
        type: 'button',
        className: cx('previousButton')
      }, navigatorProps), ptm('previousButton'));
      return /*#__PURE__*/React__namespace.createElement("button", _extends({
        ref: previousButton
      }, previousButtonProps), backwardNavigatorIcon, /*#__PURE__*/React__namespace.createElement(Ripple, null));
    };
    var createForwardNavigator = function createForwardNavigator(isVisible) {
      var navigatorProps = isVisible ? {
        onClick: onNextButtonClick,
        onKeyDown: function onKeyDown(e) {
          return onContainerButtonKeydown(e);
        }
      } : {
        style: {
          visibility: 'hidden'
        }
      };
      var nextIconProps = mergeProps({
        className: cx('nextIcon')
      }, ptm('nextIcon'));
      var icon = props.nextIcon || /*#__PURE__*/React__namespace.createElement(ChevronRightIcon, nextIconProps);
      var forwardNavigatorIcon = IconUtils.getJSXIcon(icon, _objectSpread$1z({}, nextIconProps), {
        props: props
      });
      var nextButtonProps = mergeProps(_objectSpread$1z({
        type: 'button',
        className: cx('nextButton')
      }, navigatorProps), ptm('nextButton'));
      return /*#__PURE__*/React__namespace.createElement("button", _extends({
        ref: nextButton
      }, nextButtonProps), forwardNavigatorIcon, /*#__PURE__*/React__namespace.createElement(Ripple, null));
    };
    var renderMonthsNavigator = function renderMonthsNavigator(index) {
      return props.monthNavigator && props.view !== 'month' && (props.numberOfMonths === 1 || index === 0);
    };
    var createTitleMonthElement = function createTitleMonthElement(month, monthIndex) {
      var monthNames = localeOption('monthNames', props.locale);
      if (renderMonthsNavigator(monthIndex)) {
        var viewDate = getViewDate();
        var viewMonth = viewDate.getMonth();
        var displayedMonthOptions = monthNames.map(function (month, index) {
          return (!isInMinYear(viewDate) || index >= props.minDate.getMonth()) && (!isInMaxYear(viewDate) || index <= props.maxDate.getMonth()) ? {
            label: month,
            value: index,
            index: index
          } : null;
        }).filter(function (option) {
          return !!option;
        });
        var displayedMonthNames = displayedMonthOptions.map(function (option) {
          return option.label;
        });
        var selectProps = mergeProps({
          className: cx('select'),
          onChange: function onChange(e) {
            return onMonthDropdownChange(e, e.target.value);
          },
          value: viewMonth
        }, ptm('select'));
        var _content = /*#__PURE__*/React__namespace.createElement("select", selectProps, displayedMonthOptions.map(function (option) {
          var optionProps = mergeProps({
            value: option.value
          }, ptm('option'));
          return /*#__PURE__*/React__namespace.createElement("option", _extends({}, optionProps, {
            key: option.label
          }), option.label);
        }));
        if (props.monthNavigatorTemplate) {
          var defaultContentOptions = {
            onChange: onMonthDropdownChange,
            className: 'p-datepicker-month',
            value: viewMonth,
            names: displayedMonthNames,
            options: displayedMonthOptions,
            element: _content,
            props: props
          };
          return ObjectUtils.getJSXElement(props.monthNavigatorTemplate, defaultContentOptions);
        }
        return _content;
      }
      var monthTitleProps = mergeProps({
        className: cx('monthTitle'),
        onClick: switchToMonthView,
        disabled: switchViewButtonDisabled()
      }, ptm('monthTitle'));
      return currentView === 'date' && /*#__PURE__*/React__namespace.createElement("button", monthTitleProps, monthNames[month]);
    };
    var createTitleYearElement = function createTitleYearElement(metaYear) {
      if (props.yearNavigator) {
        var _yearOptions2 = [];
        var years = props.yearRange.split(':');
        var yearStart = parseInt(years[0], 10);
        var yearEnd = parseInt(years[1], 10);
        for (var i = yearStart; i <= yearEnd; i++) {
          _yearOptions2.push(i);
        }
        var viewDate = getViewDate();
        var viewYear = viewDate.getFullYear();
        var displayedYearNames = _yearOptions2.filter(function (year) {
          return !(props.minDate && props.minDate.getFullYear() > year) && !(props.maxDate && props.maxDate.getFullYear() < year);
        });
        var selectProps = mergeProps({
          className: cx('select'),
          onChange: function onChange(e) {
            return onYearDropdownChange(e, e.target.value);
          },
          value: viewYear
        }, ptm('select'));
        var _content2 = /*#__PURE__*/React__namespace.createElement("select", selectProps, displayedYearNames.map(function (year) {
          var optionProps = mergeProps({
            value: year
          }, ptm('option'));
          return /*#__PURE__*/React__namespace.createElement("option", _extends({}, optionProps, {
            key: year
          }), year);
        }));
        if (props.yearNavigatorTemplate) {
          var options = displayedYearNames.map(function (name, i) {
            return {
              label: name,
              value: name,
              index: i
            };
          });
          var defaultContentOptions = {
            onChange: onYearDropdownChange,
            className: 'p-datepicker-year',
            value: viewYear,
            names: displayedYearNames,
            options: options,
            element: _content2,
            props: props
          };
          return ObjectUtils.getJSXElement(props.yearNavigatorTemplate, defaultContentOptions);
        }
        return _content2;
      }
      var displayYear = props.numberOfMonths > 1 ? metaYear : currentYear;
      var yearTitleProps = mergeProps({
        className: cx('yearTitle'),
        onClick: function onClick(e) {
          return switchToYearView(e);
        },
        disabled: switchViewButtonDisabled()
      }, ptm('yearTitle'));
      return currentView !== 'year' && /*#__PURE__*/React__namespace.createElement("button", yearTitleProps, displayYear);
    };
    var createTitleDecadeElement = function createTitleDecadeElement() {
      var years = yearPickerValues();
      var decadeTitleProps = mergeProps({
        className: cx('decadeTitle')
      }, ptm('decadeTitle'));
      if (currentView === 'year') {
        var decadeTitleTextProps = mergeProps(ptm('decadeTitleText'));
        return /*#__PURE__*/React__namespace.createElement("span", decadeTitleProps, props.decadeTemplate ? props.decadeTemplate(years) : /*#__PURE__*/React__namespace.createElement("span", decadeTitleTextProps, "".concat(yearPickerValues()[0], " - ").concat(yearPickerValues()[yearPickerValues().length - 1])));
      }
      return null;
    };
    var createTitle = function createTitle(monthMetaData, index) {
      var month = createTitleMonthElement(monthMetaData.month, index);
      var year = createTitleYearElement(monthMetaData.year);
      var decade = createTitleDecadeElement();
      var titleProps = mergeProps({
        className: cx('title')
      }, ptm('title'));
      var showMonthAfterYear = localeOption('showMonthAfterYear', props.locale);
      return /*#__PURE__*/React__namespace.createElement("div", titleProps, showMonthAfterYear ? year : month, showMonthAfterYear ? month : year, decade);
    };
    var createDayNames = function createDayNames(weekDays) {
      var weekDayProps = mergeProps(ptm('weekDay'));
      var tableHeaderCellProps = mergeProps({
        scope: 'col'
      }, ptm('tableHeaderCell'));
      var dayNames = weekDays.map(function (weekDay, index) {
        return /*#__PURE__*/React__namespace.createElement("th", _extends({}, tableHeaderCellProps, {
          key: "".concat(weekDay, "-").concat(index)
        }), /*#__PURE__*/React__namespace.createElement("span", weekDayProps, weekDay));
      });
      if (props.showWeek) {
        var weekHeaderProps = mergeProps({
          scope: 'col',
          className: cx('weekHeader'),
          'data-p-disabled': props.showWeek
        }, ptm('weekHeader', {
          context: {
            disabled: props.showWeek
          }
        }));
        var weekLabel = mergeProps(ptm('weekLabel'));
        var weekHeader = /*#__PURE__*/React__namespace.createElement("th", _extends({}, weekHeaderProps, {
          key: "wn"
        }), /*#__PURE__*/React__namespace.createElement("span", weekLabel, localeOption('weekHeader', props.locale)));
        return [weekHeader].concat(_toConsumableArray(dayNames));
      }
      return dayNames;
    };
    var createDateCellContent = function createDateCellContent(date, className, groupIndex) {
      var content = props.dateTemplate ? props.dateTemplate(date) : date.day;
      var dayLabelProps = mergeProps({
        className: cx('dayLabel', {
          className: className
        }),
        onClick: function onClick(e) {
          return onDateSelect(e, date);
        },
        onKeyDown: function onKeyDown(e) {
          return onDateCellKeydown(e, date, groupIndex);
        },
        'data-p-highlight': isSelected(date),
        'data-p-disabled': !date.selectable
      }, ptm('dayLabel', {
        context: {
          selected: isSelected(date),
          disabled: !date.selectable
        }
      }));
      return /*#__PURE__*/React__namespace.createElement("span", dayLabelProps, content);
    };
    var createWeek = function createWeek(weekDates, weekNumber, groupIndex) {
      var week = weekDates.map(function (date) {
        var selected = isSelected(date);
        var dateClassName = classNames({
          'p-highlight': selected,
          'p-disabled': !date.selectable
        });
        var content = date.otherMonth && !props.showOtherMonths ? null : createDateCellContent(date, dateClassName, groupIndex);
        var dayProps = mergeProps({
          className: cx('day', {
            date: date
          }),
          'data-p-today': date.today,
          'data-p-other-month': date.otherMonth
        }, ptm('day', {
          context: {
            date: date,
            today: date.today,
            otherMonth: date.otherMonth
          }
        }));
        return /*#__PURE__*/React__namespace.createElement("td", _extends({}, dayProps, {
          key: date.day
        }), content);
      });
      if (props.showWeek) {
        var weekNumberProps = mergeProps({
          className: cx('weekNumber')
        }, ptm('weekNumber'));
        var weekLabelContainerProps = mergeProps({
          className: cx('weekLabelContainer'),
          'data-p-disabled': props.showWeek
        }, ptm('weekLabelContainer', {
          context: {
            disabled: props.showWeek
          }
        }));
        var weekNumberCell = /*#__PURE__*/React__namespace.createElement("td", _extends({}, weekNumberProps, {
          key: 'wn' + weekNumber
        }), /*#__PURE__*/React__namespace.createElement("span", weekLabelContainerProps, weekNumber));
        return [weekNumberCell].concat(_toConsumableArray(week));
      }
      return week;
    };
    var createDates = function createDates(monthMetaData, groupIndex) {
      var tableBodyRowProps = mergeProps(ptm('tableBodyRowProps'));
      return monthMetaData.dates.map(function (weekDates, index) {
        return /*#__PURE__*/React__namespace.createElement("tr", _extends({}, tableBodyRowProps, {
          key: index
        }), createWeek(weekDates, monthMetaData.weekNumbers[index], groupIndex));
      });
    };
    var createDateViewGrid = function createDateViewGrid(monthMetaData, weekDays, groupIndex) {
      var dayNames = createDayNames(weekDays);
      var dates = createDates(monthMetaData, groupIndex);
      var containerProps = mergeProps({
        className: cx('container'),
        key: UniqueComponentId('calendar_container_')
      }, ptm('container'));
      var tableProps = mergeProps({
        className: cx('table')
      }, ptm('table'));
      var tableHeaderProps = mergeProps(ptm('tableHeader'));
      var tableHeaderRowProps = mergeProps(ptm('tableHeaderRow'));
      var tableBodyProps = mergeProps(ptm('tableBody'));
      return currentView === 'date' && /*#__PURE__*/React__namespace.createElement("div", containerProps, /*#__PURE__*/React__namespace.createElement("table", tableProps, /*#__PURE__*/React__namespace.createElement("thead", tableHeaderProps, /*#__PURE__*/React__namespace.createElement("tr", tableHeaderRowProps, dayNames)), /*#__PURE__*/React__namespace.createElement("tbody", tableBodyProps, dates)));
    };
    var createMonth = function createMonth(monthMetaData, index) {
      var weekDays = createWeekDaysMeta();
      var backwardNavigator = createBackwardNavigator(index === 0);
      var forwardNavigator = createForwardNavigator(props.numberOfMonths === 1 || index === props.numberOfMonths - 1);
      var title = createTitle(monthMetaData, index);
      var dateViewGrid = createDateViewGrid(monthMetaData, weekDays, index);
      var header = props.headerTemplate ? props.headerTemplate() : null;
      var monthKey = monthMetaData.month + '-' + monthMetaData.year;
      var groupProps = mergeProps({
        className: cx('group')
      }, ptm('group'));
      var headerProps = mergeProps({
        className: cx('header'),
        key: index
      }, ptm('header'));
      return /*#__PURE__*/React__namespace.createElement("div", _extends({}, groupProps, {
        key: monthKey
      }), /*#__PURE__*/React__namespace.createElement("div", headerProps, header, backwardNavigator, title, forwardNavigator), dateViewGrid);
    };
    var createMonths = function createMonths(monthsMetaData) {
      var groups = monthsMetaData.map(createMonth);
      var groupContainerProps = mergeProps({
        className: cx('groupContainer')
      }, ptm('groupContainer'));
      return /*#__PURE__*/React__namespace.createElement("div", groupContainerProps, groups);
    };
    var createDateView = function createDateView() {
      var viewDate = getViewDate();
      var monthsMetaData = createMonthsMeta(viewDate.getMonth(), viewDate.getFullYear());
      var months = createMonths(monthsMetaData);
      return months;
    };
    var monthPickerValues = function monthPickerValues() {
      var monthPickerValues = [];
      var monthNamesShort = localeOption('monthNamesShort', props.locale);
      for (var i = 0; i <= 11; i++) {
        monthPickerValues.push(monthNamesShort[i]);
      }
      return monthPickerValues;
    };
    var yearPickerValues = function yearPickerValues() {
      var yearPickerValues = [];
      var base = currentYear - currentYear % 10;
      for (var i = 0; i < 10; i++) {
        yearPickerValues.push(base + i);
      }
      return yearPickerValues;
    };
    var createMonthYearView = function createMonthYearView() {
      var backwardNavigator = createBackwardNavigator(true);
      var forwardNavigator = createForwardNavigator(true);
      var yearElement = createTitleYearElement(getViewDate().getFullYear());
      var decade = createTitleDecadeElement();
      var groupContainerProps = mergeProps({
        className: cx('groupContainer')
      }, ptm('groupContainer'));
      var groupProps = mergeProps({
        className: cx('group')
      }, ptm('group'));
      var headerProps = mergeProps({
        className: cx('header')
      }, ptm('header'));
      var titleProps = mergeProps({
        className: cx('title')
      }, ptm('title'));
      return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, null, /*#__PURE__*/React__namespace.createElement("div", groupContainerProps, /*#__PURE__*/React__namespace.createElement("div", groupProps, /*#__PURE__*/React__namespace.createElement("div", headerProps, backwardNavigator, /*#__PURE__*/React__namespace.createElement("div", titleProps, yearElement, decade), forwardNavigator))));
    };
    var createDatePicker = function createDatePicker() {
      if (!props.timeOnly) {
        if (props.view === 'date') {
          return createDateView();
        } else {
          return createMonthYearView();
        }
      }
      return null;
    };
    var incrementIconProps = mergeProps(ptm('incrementIcon'));
    var decrementIconProps = mergeProps(ptm('decrementIcon'));
    var incrementIcon = IconUtils.getJSXIcon(props.incrementIcon || /*#__PURE__*/React__namespace.createElement(ChevronUpIcon, incrementIconProps), _objectSpread$1z({}, incrementIconProps), {
      props: props
    });
    var decrementIcon = IconUtils.getJSXIcon(props.decrementIcon || /*#__PURE__*/React__namespace.createElement(ChevronDownIcon, decrementIconProps), _objectSpread$1z({}, decrementIconProps), {
      props: props
    });
    var createHourPicker = function createHourPicker() {
      var currentTime = getCurrentDateTime();
      var minute = doStepMinute(currentTime.getMinutes());
      var hour = currentTime.getHours();

      // #3770 account for step minutes rolling to next hour
      hour = minute > 59 ? hour + 1 : hour;
      if (props.hourFormat === '12') {
        if (hour === 0) hour = 12;else if (hour > 11 && hour !== 12) hour = hour - 12;
      }
      var hourProps = mergeProps(ptm('hour'));
      var hourDisplay = hour < 10 ? '0' + hour : hour;
      var hourPickerProps = mergeProps({
        className: cx('hourPicker')
      }, ptm('hourPicker'));
      var incrementButtonProps = mergeProps({
        type: 'button',
        className: cx('incrementButton'),
        onMouseDown: function onMouseDown(e) {
          return onTimePickerElementMouseDown(e, 0, 1);
        },
        onMouseUp: onTimePickerElementMouseUp,
        onMouseLeave: onTimePickerElementMouseLeave,
        onKeyDown: function onKeyDown(e) {
          return onContainerButtonKeydown(e);
        }
      }, ptm('incrementButton'));
      var decrementButtonProps = mergeProps({
        type: 'button',
        className: cx('decrementButton'),
        onMouseDown: function onMouseDown(e) {
          return onTimePickerElementMouseDown(e, 0, -1);
        },
        onMouseUp: onTimePickerElementMouseUp,
        onMouseLeave: onTimePickerElementMouseLeave,
        onKeyDown: function onKeyDown(e) {
          return onContainerButtonKeydown(e);
        }
      }, ptm('decrementButton'));
      return /*#__PURE__*/React__namespace.createElement("div", hourPickerProps, /*#__PURE__*/React__namespace.createElement("button", incrementButtonProps, incrementIcon, /*#__PURE__*/React__namespace.createElement(Ripple, null)), /*#__PURE__*/React__namespace.createElement("span", hourProps, hourDisplay), /*#__PURE__*/React__namespace.createElement("button", decrementButtonProps, decrementIcon, /*#__PURE__*/React__namespace.createElement(Ripple, null)));
    };
    var createMinutePicker = function createMinutePicker() {
      var currentTime = getCurrentDateTime();
      var minute = doStepMinute(currentTime.getMinutes());
      minute = minute > 59 ? minute - 60 : minute;
      var minuteProps = mergeProps(ptm('minute'));
      var minuteDisplay = minute < 10 ? '0' + minute : minute;
      var minutePickerProps = mergeProps({
        className: cx('minutePicker')
      }, ptm('minutePicker'));
      var incrementButtonProps = mergeProps({
        type: 'button',
        className: cx('incrementButton'),
        onMouseDown: function onMouseDown(e) {
          return onTimePickerElementMouseDown(e, 1, 1);
        },
        onMouseUp: onTimePickerElementMouseUp,
        onMouseLeave: onTimePickerElementMouseLeave,
        onKeyDown: function onKeyDown(e) {
          return onContainerButtonKeydown(e);
        }
      }, ptm('incrementButton'));
      var decrementButtonProps = mergeProps({
        type: 'button',
        className: cx('decrementButton'),
        onMouseDown: function onMouseDown(e) {
          return onTimePickerElementMouseDown(e, 1, -1);
        },
        onMouseUp: onTimePickerElementMouseUp,
        onMouseLeave: onTimePickerElementMouseLeave,
        onKeyDown: function onKeyDown(e) {
          return onContainerButtonKeydown(e);
        }
      }, ptm('decrementButton'));
      return /*#__PURE__*/React__namespace.createElement("div", minutePickerProps, /*#__PURE__*/React__namespace.createElement("button", incrementButtonProps, incrementIcon, /*#__PURE__*/React__namespace.createElement(Ripple, null)), /*#__PURE__*/React__namespace.createElement("span", minuteProps, minuteDisplay), /*#__PURE__*/React__namespace.createElement("button", decrementButtonProps, decrementIcon, /*#__PURE__*/React__namespace.createElement(Ripple, null)));
    };
    var createSecondPicker = function createSecondPicker() {
      if (props.showSeconds) {
        var currentTime = getCurrentDateTime();
        var secondProps = mergeProps(ptm('second'));
        var second = currentTime.getSeconds();
        var secondDisplay = second < 10 ? '0' + second : second;
        var secondPickerProps = mergeProps({
          className: cx('secondPicker')
        }, ptm('secondPicker'));
        var incrementButtonProps = mergeProps({
          type: 'button',
          className: cx('incrementButton'),
          onMouseDown: function onMouseDown(e) {
            return onTimePickerElementMouseDown(e, 2, 1);
          },
          onMouseUp: onTimePickerElementMouseUp,
          onMouseLeave: onTimePickerElementMouseLeave,
          onKeyDown: function onKeyDown(e) {
            return onContainerButtonKeydown(e);
          }
        }, ptm('incrementButton'));
        var decrementButtonProps = mergeProps({
          type: 'button',
          className: cx('decrementButton'),
          onMouseDown: function onMouseDown(e) {
            return onTimePickerElementMouseDown(e, 2, -1);
          },
          onMouseUp: onTimePickerElementMouseUp,
          onMouseLeave: onTimePickerElementMouseLeave,
          onKeyDown: function onKeyDown(e) {
            return onContainerButtonKeydown(e);
          }
        }, ptm('decrementButton'));
        return /*#__PURE__*/React__namespace.createElement("div", secondPickerProps, /*#__PURE__*/React__namespace.createElement("button", incrementButtonProps, incrementIcon, /*#__PURE__*/React__namespace.createElement(Ripple, null)), /*#__PURE__*/React__namespace.createElement("span", secondProps, secondDisplay), /*#__PURE__*/React__namespace.createElement("button", decrementButtonProps, decrementIcon, /*#__PURE__*/React__namespace.createElement(Ripple, null)));
      }
      return null;
    };
    var createMiliSecondPicker = function createMiliSecondPicker() {
      if (props.showMillisec) {
        var currentTime = getCurrentDateTime();
        var millisecondProps = mergeProps(ptm('millisecond'));
        var millisecond = currentTime.getMilliseconds();
        var millisecondDisplay = millisecond < 100 ? (millisecond < 10 ? '00' : '0') + millisecond : millisecond;
        var millisecondPickerProps = mergeProps({
          className: cx('millisecondPicker')
        }, ptm('millisecondPicker'));
        var incrementButtonProps = mergeProps({
          type: 'button',
          className: cx('incrementButton'),
          onMouseDown: function onMouseDown(e) {
            return onTimePickerElementMouseDown(e, 3, 1);
          },
          onMouseUp: onTimePickerElementMouseUp,
          onMouseLeave: onTimePickerElementMouseLeave,
          onKeyDown: function onKeyDown(e) {
            return onContainerButtonKeydown(e);
          }
        }, ptm('incrementButton'));
        var decrementButtonProps = mergeProps({
          type: 'button',
          className: cx('decrementButton'),
          onMouseDown: function onMouseDown(e) {
            return onTimePickerElementMouseDown(e, 3, -1);
          },
          onMouseUp: onTimePickerElementMouseUp,
          onMouseLeave: onTimePickerElementMouseLeave,
          onKeyDown: function onKeyDown(e) {
            return onContainerButtonKeydown(e);
          }
        }, ptm('decrementButton'));
        return /*#__PURE__*/React__namespace.createElement("div", millisecondPickerProps, /*#__PURE__*/React__namespace.createElement("button", incrementButtonProps, incrementIcon, /*#__PURE__*/React__namespace.createElement(Ripple, null)), /*#__PURE__*/React__namespace.createElement("span", millisecondProps, millisecondDisplay), /*#__PURE__*/React__namespace.createElement("button", decrementButtonProps, decrementIcon, /*#__PURE__*/React__namespace.createElement(Ripple, null)));
      }
      return null;
    };
    var createAmPmPicker = function createAmPmPicker() {
      if (props.hourFormat === '12') {
        var currentTime = getCurrentDateTime();
        var hour = currentTime.getHours();
        var display = hour > 11 ? 'PM' : 'AM';
        var ampmProps = mergeProps(ptm('ampm'));
        var ampmPickerProps = mergeProps({
          className: cx('ampmPicker')
        }, ptm('ampmPicker'));
        var incrementButtonProps = mergeProps({
          type: 'button',
          className: cx('incrementButton'),
          onClick: function onClick(e) {
            return toggleAmPm(e);
          }
        }, ptm('incrementButton'));
        var decrementButtonProps = mergeProps({
          type: 'button',
          className: cx('decrementButton'),
          onClick: function onClick(e) {
            return toggleAmPm(e);
          }
        }, ptm('decrementButton'));
        return /*#__PURE__*/React__namespace.createElement("div", ampmPickerProps, /*#__PURE__*/React__namespace.createElement("button", incrementButtonProps, incrementIcon, /*#__PURE__*/React__namespace.createElement(Ripple, null)), /*#__PURE__*/React__namespace.createElement("span", ampmProps, display), /*#__PURE__*/React__namespace.createElement("button", decrementButtonProps, decrementIcon, /*#__PURE__*/React__namespace.createElement(Ripple, null)));
      }
      return null;
    };
    var createSeparator = function createSeparator(separator) {
      var separatorContainerProps = mergeProps({
        className: cx('separatorContainer')
      }, ptm('separatorContainer'));
      var separatorProps = mergeProps(ptm('separator'));
      return /*#__PURE__*/React__namespace.createElement("div", separatorContainerProps, /*#__PURE__*/React__namespace.createElement("span", separatorProps, separator));
    };
    var createTimePicker = function createTimePicker() {
      if ((props.showTime || props.timeOnly) && currentView === 'date') {
        var timePickerProps = mergeProps({
          className: cx('timePicker')
        }, ptm('timePicker'));
        return /*#__PURE__*/React__namespace.createElement("div", timePickerProps, createHourPicker(), createSeparator(':'), createMinutePicker(), props.showSeconds && createSeparator(':'), createSecondPicker(), props.showMillisec && createSeparator('.'), createMiliSecondPicker(), props.hourFormat === '12' && createSeparator(':'), createAmPmPicker());
      }
      return null;
    };
    var createInputElement = function createInputElement() {
      if (!props.inline) {
        return /*#__PURE__*/React__namespace.createElement(InputText, {
          ref: inputRef,
          id: props.inputId,
          name: props.name,
          type: "text",
          className: props.inputClassName,
          style: props.inputStyle,
          readOnly: props.readOnlyInput,
          disabled: props.disabled,
          required: props.required,
          autoComplete: "off",
          placeholder: props.placeholder,
          tabIndex: props.tabIndex,
          onInput: onUserInput,
          onFocus: onInputFocus,
          onBlur: onInputBlur,
          onKeyDown: onInputKeyDown,
          "aria-labelledby": props.ariaLabelledBy,
          inputMode: props.inputMode,
          tooltip: props.tooltip,
          tooltipOptions: props.tooltipOptions,
          pt: ptm('input'),
          __parentMetadata: {
            parent: metaData
          }
        });
      }
      return null;
    };
    var createButton = function createButton() {
      if (props.showIcon) {
        return /*#__PURE__*/React__namespace.createElement(Button, {
          type: "button",
          icon: props.icon || /*#__PURE__*/React__namespace.createElement(CalendarIcon, null),
          onClick: onButtonClick,
          tabIndex: "-1",
          disabled: props.disabled,
          className: cx('dropdownButton'),
          pt: ptm('dropdownButton'),
          __parentMetadata: {
            parent: metaData
          }
        });
      }
      return null;
    };
    var createContent = function createContent() {
      var input = createInputElement();
      var button = createButton();
      if (props.iconPos === 'left') {
        return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, null, button, input);
      }
      return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, null, input, button);
    };
    var createButtonBar = function createButtonBar() {
      if (props.showButtonBar) {
        var _localeOptions4 = localeOptions(props.locale),
          today = _localeOptions4.today,
          clear = _localeOptions4.clear;
        var buttonbarProps = mergeProps({
          className: cx('buttonbar')
        }, ptm('buttonbar'));
        return /*#__PURE__*/React__namespace.createElement("div", buttonbarProps, /*#__PURE__*/React__namespace.createElement(Button, {
          type: "button",
          label: today,
          onClick: onTodayButtonClick,
          onKeyDown: function onKeyDown(e) {
            return onContainerButtonKeydown(e);
          },
          className: classNames(props.todayButtonClassName, cx('todayButton')),
          pt: ptm('todayButton')
        }), /*#__PURE__*/React__namespace.createElement(Button, {
          type: "button",
          label: clear,
          onClick: onClearButtonClick,
          onKeyDown: function onKeyDown(e) {
            return onContainerButtonKeydown(e);
          },
          className: classNames(props.clearButtonClassName, cx('clearButton')),
          pt: ptm('clearButton')
        }));
      }
      return null;
    };
    var createFooter = function createFooter() {
      if (props.footerTemplate) {
        var _content3 = props.footerTemplate();
        var footerProps = mergeProps({
          className: cx('footer')
        }, ptm('footer'));
        return /*#__PURE__*/React__namespace.createElement("div", footerProps, _content3);
      }
      return null;
    };
    var createMonthPicker = function createMonthPicker() {
      if (currentView === 'month') {
        var monthPickerProps = mergeProps({
          className: cx('monthPicker')
        }, ptm('monthPicker'));
        return /*#__PURE__*/React__namespace.createElement("div", monthPickerProps, monthPickerValues().map(function (m, i) {
          var monthProps = mergeProps({
            className: cx('month', {
              isMonthSelected: isMonthSelected,
              isMonthYearDisabled: isMonthYearDisabled,
              i: i,
              currentYear: currentYear
            }),
            onClick: function onClick(event) {
              return onMonthSelect(event, i);
            },
            onKeyDown: function onKeyDown(event) {
              return onMonthCellKeydown(event, i);
            },
            'data-p-disabled': isMonthYearDisabled(i, currentYear),
            'data-p-highlight': isMonthSelected(i)
          }, ptm('month', {
            context: {
              month: m,
              monthIndex: i,
              selected: isMonthSelected(i),
              disabled: isMonthYearDisabled(i, currentYear)
            }
          }));
          return /*#__PURE__*/React__namespace.createElement("span", _extends({}, monthProps, {
            key: "month".concat(i + 1)
          }), m);
        }));
      }
      return null;
    };
    var createYearPicker = function createYearPicker() {
      if (currentView === 'year') {
        var yearPickerProps = mergeProps({
          className: cx('yearPicker')
        }, ptm('yearPicker'));
        return /*#__PURE__*/React__namespace.createElement("div", yearPickerProps, yearPickerValues().map(function (y, i) {
          var yearProps = mergeProps({
            className: cx('year', {
              isYearSelected: isYearSelected,
              isMonthYearDisabled: isMonthYearDisabled,
              y: y
            }),
            onClick: function onClick(event) {
              return onYearSelect(event, y);
            },
            'data-p-highlight': isYearSelected(y),
            'data-p-disabled': isMonthYearDisabled(-1, y)
          }, ptm('year', {
            context: {
              year: y,
              yearIndex: i,
              selected: isYearSelected(i),
              disabled: isMonthYearDisabled(-1, y)
            }
          }));
          return /*#__PURE__*/React__namespace.createElement("span", _extends({}, yearProps, {
            key: "year".concat(i + 1)
          }), y);
        }));
      }
      return null;
    };
    var panelClassName = classNames('p-datepicker p-component', props.panelClassName, {
      'p-datepicker-inline': props.inline,
      'p-disabled': props.disabled,
      'p-datepicker-timeonly': props.timeOnly,
      'p-datepicker-multiple-month': props.numberOfMonths > 1,
      'p-datepicker-monthpicker': currentView === 'month',
      'p-datepicker-touch-ui': props.touchUI,
      'p-input-filled': context && context.inputStyle === 'filled' || PrimeReact.inputStyle === 'filled',
      'p-ripple-disabled': context && context.ripple === false || PrimeReact.ripple === false
    });
    var content = createContent();
    var datePicker = createDatePicker();
    var timePicker = createTimePicker();
    var buttonBar = createButtonBar();
    var footer = createFooter();
    var monthPicker = createMonthPicker();
    var yearPicker = createYearPicker();
    var isFilled = DomHandler.hasClass(inputRef.current, 'p-filled') && inputRef.current.value !== '';
    var rootProps = mergeProps({
      id: props.id,
      className: classNames(props.className, cx('root', {
        focusedState: focusedState,
        isFilled: isFilled
      })),
      style: props.style
    }, CalendarBase.getOtherProps(props), ptm('root'));
    return /*#__PURE__*/React__namespace.createElement("span", _extends({
      ref: elementRef
    }, rootProps), content, /*#__PURE__*/React__namespace.createElement(CalendarPanel, {
      hostName: "Calendar",
      ref: overlayRef,
      className: panelClassName,
      style: props.panelStyle,
      appendTo: props.appendTo,
      inline: props.inline,
      onClick: onPanelClick,
      onMouseUp: onPanelMouseUp,
      "in": visible,
      onEnter: onOverlayEnter,
      onEntered: onOverlayEntered,
      onExit: onOverlayExit,
      onExited: onOverlayExited,
      transitionOptions: props.transitionOptions,
      ptm: ptm,
      cx: cx
    }, datePicker, timePicker, monthPicker, yearPicker, buttonBar, footer));
  }));
  Calendar.displayName = 'Calendar';

  var classes$10 = {
    root: function root(_ref) {
      var props = _ref.props;
      return classNames('p-card p-component', props.className);
    },
    header: 'p-card-header',
    title: 'p-card-title',
    subTitle: 'p-card-subtitle',
    content: 'p-card-content',
    footer: 'p-card-footer',
    body: 'p-card-body'
  };
  var styles$X = "\n@layer primereact {\n    .p-card-header img {\n        width: 100%;\n    }\n}\n";
  var CardBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'Card',
      id: null,
      header: null,
      footer: null,
      title: null,
      subTitle: null,
      style: null,
      className: null,
      children: undefined
    },
    css: {
      classes: classes$10,
      styles: styles$X
    }
  });

  var Card = /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var context = React__namespace.useContext(PrimeReactContext);
    var props = CardBase.getProps(inProps, context);
    var elementRef = React__namespace.useRef(ref);
    var _CardBase$setMetaData = CardBase.setMetaData({
        props: props
      }),
      ptm = _CardBase$setMetaData.ptm,
      cx = _CardBase$setMetaData.cx,
      isUnstyled = _CardBase$setMetaData.isUnstyled;
    useHandleStyle(CardBase.css.styles, isUnstyled, {
      name: 'card'
    });
    var createHeader = function createHeader() {
      var headerProps = mergeProps({
        className: cx('header')
      }, ptm('header'));
      if (props.header) {
        return /*#__PURE__*/React__namespace.createElement("div", headerProps, ObjectUtils.getJSXElement(props.header, props));
      }
      return null;
    };
    var createBody = function createBody() {
      var titleProps = mergeProps({
        className: cx('title')
      }, ptm('title'));
      var title = props.title && /*#__PURE__*/React__namespace.createElement("div", titleProps, ObjectUtils.getJSXElement(props.title, props));
      var subTitleProps = mergeProps({
        className: cx('subTitle')
      }, ptm('subTitle'));
      var subTitle = props.subTitle && /*#__PURE__*/React__namespace.createElement("div", subTitleProps, ObjectUtils.getJSXElement(props.subTitle, props));
      var contentProps = mergeProps({
        className: cx('content')
      }, ptm('content'));
      var children = props.children && /*#__PURE__*/React__namespace.createElement("div", contentProps, props.children);
      var footerProps = mergeProps({
        className: cx('footer')
      }, ptm('footer'));
      var footer = props.footer && /*#__PURE__*/React__namespace.createElement("div", footerProps, ObjectUtils.getJSXElement(props.footer, props));
      var bodyProps = mergeProps({
        className: cx('body')
      }, ptm('body'));
      return /*#__PURE__*/React__namespace.createElement("div", bodyProps, title, subTitle, children, footer);
    };
    React__namespace.useEffect(function () {
      ObjectUtils.combinedRefs(elementRef, ref);
    }, [elementRef, ref]);
    var rootProps = mergeProps({
      id: props.id,
      ref: elementRef,
      style: props.style,
      className: cx('root')
    }, CardBase.getOtherProps(props), ptm('root'));
    var header = createHeader();
    var body = createBody();
    return /*#__PURE__*/React__namespace.createElement("div", rootProps, header, body);
  });
  Card.displayName = 'Card';

  var styles$W = "\n@layer primereact {\n    .p-carousel {\n        display: flex;\n        flex-direction: column;\n    }\n    \n    .p-carousel-content {\n        display: flex;\n        flex-direction: column;\n        overflow: auto;\n    }\n    \n    .p-carousel-prev,\n    .p-carousel-next {\n        align-self: center;\n        flex-grow: 0;\n        flex-shrink: 0;\n        display: flex;\n        justify-content: center;\n        align-items: center;\n        overflow: hidden;\n        position: relative;\n    }\n    \n    .p-carousel-container {\n        display: flex;\n        flex-direction: row;\n    }\n    \n    .p-carousel-items-content {\n        overflow: hidden;\n        width: 100%;\n    }\n    \n    .p-carousel-items-container {\n        display: flex;\n        flex-direction: row;\n    }\n    \n    .p-carousel-indicators {\n        display: flex;\n        flex-direction: row;\n        justify-content: center;\n        flex-wrap: wrap;\n    }\n    \n    .p-carousel-indicator > button {\n        display: flex;\n        align-items: center;\n        justify-content: center;\n    }\n    \n    /* Vertical */\n    .p-carousel-vertical .p-carousel-container {\n        flex-direction: column;\n    }\n    \n    .p-carousel-vertical .p-carousel-items-container {\n        flex-direction: column;\n        height: 100%;\n    }\n    \n    /* Keyboard Support */\n    .p-items-hidden .p-carousel-item {\n        visibility: hidden;\n    }\n    \n    .p-items-hidden .p-carousel-item.p-carousel-item-active {\n        visibility: visible;\n    }\n}\n";
  var classes$$ = {
    root: function root(_ref) {
      var isVertical = _ref.isVertical;
      return classNames('p-carousel p-component', {
        'p-carousel-vertical': isVertical,
        'p-carousel-horizontal': !isVertical
      });
    },
    container: 'p-carousel-container',
    content: 'p-carousel-content',
    indicators: 'p-carousel-indicators p-reset',
    header: 'p-carousel-header',
    footer: 'p-carousel-footer',
    itemsContainer: 'p-carousel-items-container',
    itemsContent: 'p-carousel-items-content',
    previousButton: function previousButton(_ref2) {
      var isDisabled = _ref2.isDisabled;
      return classNames('p-carousel-prev p-link', {
        'p-disabled': isDisabled
      });
    },
    previousButtonIcon: 'p-carousel-prev-icon',
    nextButton: function nextButton(_ref3) {
      var isDisabled = _ref3.isDisabled;
      return classNames('p-carousel-next p-link', {
        'p-disabled': isDisabled
      });
    },
    nextButtonIcon: 'p-carousel-next-icon',
    indicator: function indicator(_ref4) {
      var isActive = _ref4.isActive;
      return classNames('p-carousel-indicator', {
        'p-highlight': isActive
      });
    },
    indicatorButton: 'p-link',
    itemCloned: function itemCloned(_ref5) {
      var props = _ref5.itemProps;
      return classNames(props.className, 'p-carousel-item', {
        'p-carousel-item-active': props.active,
        'p-carousel-item-start': props.start,
        'p-carousel-item-end': props.end
      });
    },
    item: function item(_ref6) {
      var props = _ref6.itemProps;
      return classNames(props.className, 'p-carousel-item', {
        'p-carousel-item-active': props.active,
        'p-carousel-item-start': props.start,
        'p-carousel-item-end': props.end
      });
    }
  };
  var inlineStyles$l = {
    itemsContent: function itemsContent(_ref7) {
      var height = _ref7.height;
      return {
        height: height
      };
    }
  };
  var CarouselBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'Carousel',
      id: null,
      value: null,
      page: 0,
      header: null,
      footer: null,
      style: null,
      className: null,
      itemTemplate: null,
      circular: false,
      showIndicators: true,
      showNavigators: true,
      autoplayInterval: 0,
      numVisible: 1,
      numScroll: 1,
      prevIcon: null,
      nextIcon: null,
      responsiveOptions: null,
      orientation: 'horizontal',
      verticalViewPortHeight: '300px',
      contentClassName: null,
      containerClassName: null,
      indicatorsContentClassName: null,
      onPageChange: null,
      children: undefined
    },
    css: {
      classes: classes$$,
      styles: styles$W,
      inlineStyles: inlineStyles$l
    }
  });

  function ownKeys$1y(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1y(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1y(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1y(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var CarouselItem = /*#__PURE__*/React__namespace.memo(function (props) {
    var ptm = props.ptm,
      cx = props.cx;
    var key = props.className && props.className === 'p-carousel-item-cloned' ? 'itemCloned' : 'item';
    var content = props.template(props.item);
    var itemClonedProps = mergeProps({
      className: cx(key, {
        itemProps: props
      }),
      role: props.role,
      'aria-roledescription': props.ariaRoledescription,
      'aria-label': props.ariaLabel,
      'aria-hidden': props.ariaHidden,
      'data-p-carousel-item-active': props.active,
      'data-p-carousel-item-start': props.start,
      'data-p-carousel-item-end': props.end
    }, ptm(key));
    return /*#__PURE__*/React__namespace.createElement("div", itemClonedProps, content);
  });
  var Carousel = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var context = React__namespace.useContext(PrimeReactContext);
    var props = CarouselBase.getProps(inProps, context);
    var _React$useState = React__namespace.useState(props.numVisible),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      numVisibleState = _React$useState2[0],
      setNumVisibleState = _React$useState2[1];
    var _React$useState3 = React__namespace.useState(props.numScroll),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      numScrollState = _React$useState4[0],
      setNumScrollState = _React$useState4[1];
    var _React$useState5 = React__namespace.useState(props.page * props.numScroll * -1),
      _React$useState6 = _slicedToArray(_React$useState5, 2),
      totalShiftedItemsState = _React$useState6[0],
      setTotalShiftedItemsState = _React$useState6[1];
    var _React$useState7 = React__namespace.useState(props.page),
      _React$useState8 = _slicedToArray(_React$useState7, 2),
      pageState = _React$useState8[0],
      setPageState = _React$useState8[1];
    var _CarouselBase$setMeta = CarouselBase.setMetaData({
        props: props,
        state: {
          numVisible: numVisibleState,
          numScroll: numScrollState,
          totalShiftedItems: totalShiftedItemsState,
          page: pageState
        }
      }),
      ptm = _CarouselBase$setMeta.ptm,
      cx = _CarouselBase$setMeta.cx,
      sx = _CarouselBase$setMeta.sx,
      isUnstyled = _CarouselBase$setMeta.isUnstyled;
    useHandleStyle(CarouselBase.css.styles, isUnstyled, {
      name: 'carousel'
    });
    var elementRef = React__namespace.useRef(null);
    var itemsContainerRef = React__namespace.useRef(null);
    var remainingItems = React__namespace.useRef(0);
    var allowAutoplay = React__namespace.useRef(!!props.autoplayInterval);
    var attributeSelector = React__namespace.useRef('');
    var swipeThreshold = React__namespace.useRef(20);
    var startPos = React__namespace.useRef(null);
    var interval = React__namespace.useRef(null);
    var carouselStyle = React__namespace.useRef(null);
    var indicatorContent = React__namespace.useRef(null);
    var isRemainingItemsAdded = React__namespace.useRef(false);
    var responsiveOptions = React__namespace.useRef(null);
    var prevNumScroll = usePrevious(numScrollState);
    var prevNumVisible = usePrevious(numVisibleState);
    var prevValue = usePrevious(props.value);
    var prevPage = usePrevious(props.page);
    var isVertical = props.orientation === 'vertical';
    var circular = props.circular || !!props.autoplayInterval;
    var isCircular = circular && props.value && props.value.length >= numVisibleState;
    var totalIndicators = props.value ? Math.max(Math.ceil((props.value.length - numVisibleState) / numScrollState) + 1, 0) : 0;
    var isAutoplay = totalIndicators && props.autoplayInterval && allowAutoplay.current;
    var isControlled = props.onPageChange && !isAutoplay;
    var currentPage = isControlled ? props.page : pageState;
    var _useResizeListener = useResizeListener({
        listener: function listener() {
          calculatePosition();
        },
        when: props.responsiveOptions
      }),
      _useResizeListener2 = _slicedToArray(_useResizeListener, 1),
      bindWindowResizeListener = _useResizeListener2[0];
    var step = function step(dir, page) {
      var totalShiftedItems = totalShiftedItemsState;
      if (page != null) {
        totalShiftedItems = numScrollState * page * -1;
        if (isCircular) {
          totalShiftedItems -= numVisibleState;
        }
        isRemainingItemsAdded.current = false;
      } else {
        totalShiftedItems += numScrollState * dir;
        if (isRemainingItemsAdded.current) {
          totalShiftedItems += remainingItems.current - numScrollState * dir;
          isRemainingItemsAdded.current = false;
        }
        var originalShiftedItems = isCircular ? totalShiftedItems + numVisibleState : totalShiftedItems;
        page = Math.abs(Math.floor(originalShiftedItems / numScrollState));
      }
      if (isCircular && pageState === totalIndicators - 1 && dir === -1) {
        totalShiftedItems = -1 * (props.value.length + numVisibleState);
        page = 0;
      } else if (isCircular && pageState === 0 && dir === 1) {
        totalShiftedItems = 0;
        page = totalIndicators - 1;
      } else if (page === totalIndicators - 1 && remainingItems.current > 0) {
        totalShiftedItems += remainingItems.current * -1 - numScrollState * dir;
        isRemainingItemsAdded.current = true;
      }
      if (itemsContainerRef.current) {
        !isUnstyled() && DomHandler.removeClass(itemsContainerRef.current, 'p-items-hidden');
        changePosition(totalShiftedItems);
        itemsContainerRef.current.style.transition = 'transform 500ms ease 0s';
      }
      changePage(page);
      setTotalShiftedItemsState(totalShiftedItems);
    };
    var calculatePosition = function calculatePosition() {
      if (itemsContainerRef.current && responsiveOptions.current) {
        var windowWidth = window.innerWidth;
        var matchedResponsiveData = {
          numVisible: props.numVisible,
          numScroll: props.numScroll
        };
        for (var i = 0; i < responsiveOptions.current.length; i++) {
          var res = responsiveOptions.current[i];
          if (parseInt(res.breakpoint, 10) >= windowWidth) {
            matchedResponsiveData = res;
          }
        }
        if (numScrollState !== matchedResponsiveData.numScroll) {
          var page = Math.floor(currentPage * numScrollState / matchedResponsiveData.numScroll);
          var totalShiftedItems = matchedResponsiveData.numScroll * page * -1;
          if (isCircular) {
            totalShiftedItems -= matchedResponsiveData.numVisible;
          }
          setTotalShiftedItemsState(totalShiftedItems);
          setNumScrollState(matchedResponsiveData.numScroll);
          changePage(page);
        }
        if (numVisibleState !== matchedResponsiveData.numVisible) {
          setNumVisibleState(matchedResponsiveData.numVisible);
        }
      }
    };
    var navBackward = function navBackward(e, page) {
      if (circular || currentPage !== 0) {
        step(1, page);
      }
      allowAutoplay.current = false;
      if (e.cancelable) {
        e.preventDefault();
      }
    };
    var navForward = function navForward(e, page) {
      if (circular || currentPage < totalIndicators - 1) {
        step(-1, page);
      }
      allowAutoplay.current = false;
      if (e.cancelable) {
        e.preventDefault();
      }
    };
    var onIndicatorClick = function onIndicatorClick(e, page) {
      if (page > currentPage) {
        navForward(e, page);
      } else if (page < currentPage) {
        navBackward(e, page);
      }
    };
    var onTransitionEnd = function onTransitionEnd(e) {
      if (itemsContainerRef.current && e.propertyName === 'transform') {
        DomHandler.addClass(itemsContainerRef.current, 'p-items-hidden');
        itemsContainerRef.current.style.transition = '';
        if ((pageState === 0 || pageState === totalIndicators - 1) && isCircular) {
          changePosition(totalShiftedItemsState);
        }
      }
    };
    var _onTouchStart = function onTouchStart(e) {
      var touchobj = e.changedTouches[0];
      startPos.current = {
        x: touchobj.pageX,
        y: touchobj.pageY
      };
    };
    var _onTouchMove = function onTouchMove(e) {
      if (e.cancelable) {
        e.preventDefault();
      }
    };
    var _onTouchEnd = function onTouchEnd(e) {
      var touchobj = e.changedTouches[0];
      if (isVertical) {
        changePageOnTouch(e, touchobj.pageY - startPos.current.y);
      } else {
        changePageOnTouch(e, touchobj.pageX - startPos.current.x);
      }
    };
    var changePageOnTouch = function changePageOnTouch(e, diff) {
      if (Math.abs(diff) > swipeThreshold.current) {
        if (diff < 0) {
          // left
          navForward(e);
        } else {
          // right
          navBackward(e);
        }
      }
    };
    var onIndicatorKeydown = function onIndicatorKeydown(event) {
      switch (event.code) {
        case 'ArrowRight':
          onRightKey();
          break;
        case 'ArrowLeft':
          onLeftKey();
          break;
        case 'Home':
          onHomeKey();
          event.preventDefault();
          break;
        case 'End':
          onEndKey();
          event.preventDefault();
          break;
        case 'ArrowUp':
        case 'ArrowDown':
          event.preventDefault();
          break;
        case 'Tab':
          onTabKey();
          break;
      }
    };
    var onRightKey = function onRightKey() {
      var indicators = _toConsumableArray(DomHandler.find(indicatorContent.current, '[data-pc-section="indicator"]'));
      var activeIndex = findFocusedIndicatorIndex();
      changedFocusedIndicator(activeIndex, activeIndex + 1 === indicators.length ? indicators.length - 1 : activeIndex + 1);
    };
    var onLeftKey = function onLeftKey() {
      var activeIndex = findFocusedIndicatorIndex();
      changedFocusedIndicator(activeIndex, activeIndex - 1 <= 0 ? 0 : activeIndex - 1);
    };
    var onHomeKey = function onHomeKey() {
      var activeIndex = findFocusedIndicatorIndex();
      changedFocusedIndicator(activeIndex, 0);
    };
    var onEndKey = function onEndKey() {
      var indicators = _toConsumableArray(DomHandler.find(indicatorContent.current, '[data-pc-section="indicator"]r'));
      var activeIndex = findFocusedIndicatorIndex();
      changedFocusedIndicator(activeIndex, indicators.length - 1);
    };
    var onTabKey = function onTabKey() {
      var indicators = _toConsumableArray(DomHandler.find(indicatorContent.current, '[data-pc-section="indicator"]'));
      var highlightedIndex = indicators.findIndex(function (ind) {
        return DomHandler.getAttribute(ind, 'data-p-highlight') === true;
      });
      var activeIndicator = DomHandler.findSingle(indicatorContent.current, '[data-pc-section="indicator"] > button[tabindex="0"]');
      var activeIndex = indicators.findIndex(function (ind) {
        return ind === activeIndicator.parentElement;
      });
      indicators[activeIndex].children[0].tabIndex = '-1';
      indicators[highlightedIndex].children[0].tabIndex = '0';
    };
    var findFocusedIndicatorIndex = function findFocusedIndicatorIndex() {
      var indicators = _toConsumableArray(DomHandler.find(indicatorContent.current, '[data-pc-section="indicator"]'));
      var activeIndicator = DomHandler.findSingle(indicatorContent.current, '[data-pc-section="indicator"] > button[tabindex="0"]');
      return indicators.findIndex(function (ind) {
        return ind === activeIndicator.parentElement;
      });
    };
    var changedFocusedIndicator = function changedFocusedIndicator(prevInd, nextInd) {
      var indicators = _toConsumableArray(DomHandler.find(indicatorContent.current, '[data-pc-section="indicator"]'));
      indicators[prevInd].children[0].tabIndex = '-1';
      indicators[nextInd].children[0].tabIndex = '0';
      indicators[nextInd].children[0].focus();
    };
    var startAutoplay = function startAutoplay() {
      if (props.autoplayInterval > 0) {
        interval.current = setInterval(function () {
          if (pageState === totalIndicators - 1) {
            step(-1, 0);
          } else {
            step(-1, pageState + 1);
          }
        }, props.autoplayInterval);
      }
    };
    var stopAutoplay = function stopAutoplay() {
      if (interval.current) {
        clearInterval(interval.current);
      }
    };
    var createStyle = function createStyle() {
      if (!carouselStyle.current) {
        carouselStyle.current = DomHandler.createInlineStyle(context && context.nonce || PrimeReact.nonce, context && context.styleContainer);
      }
      var innerHTML = "\n            .p-carousel[".concat(attributeSelector.current, "] .p-carousel-item {\n                flex: 1 0 ").concat(100 / numVisibleState, "%\n            }\n        ");
      if (props.responsiveOptions) {
        var comparator = ObjectUtils.localeComparator(context && context.locale || PrimeReact.locale);
        responsiveOptions.current = _toConsumableArray(props.responsiveOptions);
        responsiveOptions.current.sort(function (data1, data2) {
          var value1 = data1.breakpoint;
          var value2 = data2.breakpoint;
          return ObjectUtils.sort(value1, value2, -1, comparator, context && context.nullSortOrder || PrimeReact.nullSortOrder);
        });
        for (var i = 0; i < responsiveOptions.current.length; i++) {
          var res = responsiveOptions.current[i];
          innerHTML += "\n                    @media screen and (max-width: ".concat(res.breakpoint, ") {\n                        .p-carousel[").concat(attributeSelector.current, "] .p-carousel-item {\n                            flex: 1 0 ").concat(100 / res.numVisible, "%\n                        }\n                    }\n                ");
        }
      }
      carouselStyle.current.innerHTML = innerHTML;
    };
    var destroyStyle = function destroyStyle() {
      carouselStyle.current = DomHandler.removeInlineStyle(carouselStyle.current);
    };
    var changePosition = function changePosition(totalShiftedItems) {
      if (itemsContainerRef.current) {
        itemsContainerRef.current.style.transform = isVertical ? "translate3d(0, ".concat(totalShiftedItems * (100 / numVisibleState), "%, 0)") : "translate3d(".concat(totalShiftedItems * (100 / numVisibleState), "%, 0, 0)");
      }
    };
    var changePage = function changePage(page) {
      !isControlled && setPageState(page);
      props.onPageChange && props.onPageChange({
        page: page
      });
    };
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        startAutoplay: startAutoplay,
        stopAutoplay: stopAutoplay,
        getElement: function getElement() {
          return elementRef.current;
        }
      };
    });
    useMountEffect(function () {
      if (elementRef.current) {
        attributeSelector.current = UniqueComponentId();
        elementRef.current.setAttribute(attributeSelector.current, '');
      }
      if (!carouselStyle.current) {
        calculatePosition();
        changePosition(totalShiftedItemsState);
        bindWindowResizeListener();
      }
    });
    useUpdateEffect(function () {
      var stateChanged = false;
      var totalShiftedItems = totalShiftedItemsState;
      createStyle();
      if (props.autoplayInterval) {
        stopAutoplay();
      }
      if (prevNumScroll !== numScrollState || prevNumVisible !== numVisibleState || props.value && prevValue && prevValue.length !== props.value.length) {
        remainingItems.current = (props.value.length - numVisibleState) % numScrollState;
        var page = currentPage;
        if (totalIndicators !== 0 && page >= totalIndicators) {
          page = totalIndicators - 1;
          changePage(page);
          stateChanged = true;
        }
        totalShiftedItems = page * numScrollState * -1;
        if (isCircular) {
          totalShiftedItems -= numVisibleState;
        }
        if (page === totalIndicators - 1 && remainingItems.current > 0) {
          totalShiftedItems += -1 * remainingItems.current + numScrollState;
          isRemainingItemsAdded.current = true;
        } else {
          isRemainingItemsAdded.current = false;
        }
        if (totalShiftedItems !== totalShiftedItemsState) {
          setTotalShiftedItemsState(totalShiftedItems);
          stateChanged = true;
        }
        changePosition(totalShiftedItems);
      }
      if (isCircular) {
        if (pageState === 0) {
          totalShiftedItems = -1 * numVisibleState;
        } else if (totalShiftedItems === 0) {
          totalShiftedItems = -1 * props.value.length;
          if (remainingItems.current > 0) {
            isRemainingItemsAdded.current = true;
          }
        }
        if (totalShiftedItems !== totalShiftedItemsState) {
          setTotalShiftedItemsState(totalShiftedItems);
          stateChanged = true;
        }
      }
      if (prevPage !== props.page) {
        if (props.page > prevPage && props.page <= totalIndicators - 1) {
          step(-1, props.page);
        } else if (props.page < prevPage) {
          step(1, props.page);
        }
      }
      if (!stateChanged && isAutoplay) {
        startAutoplay();
      }
      return function () {
        if (props.autoplayInterval) {
          stopAutoplay();
        }
        destroyStyle();
      };
    });
    var ariaSlideNumber = function ariaSlideNumber(value) {
      return localeOption('aria') ? localeOption('aria').slideNumber.replace(/{slideNumber}/g, value) : undefined;
    };
    var createItems = function createItems() {
      if (props.value && props.value.length) {
        var clonedItemsForStarting = null;
        var clonedItemsForFinishing = null;
        if (isCircular) {
          var clonedElements = null;
          clonedElements = props.value.slice(-1 * numVisibleState);
          clonedItemsForStarting = clonedElements.map(function (item, index) {
            var isActive = totalShiftedItemsState * -1 === props.value.length + numVisibleState;
            var start = index === 0;
            var end = index === clonedElements.length - 1;
            var key = index + '_scloned';
            return /*#__PURE__*/React__namespace.createElement(CarouselItem, {
              key: key,
              className: "p-carousel-item-cloned",
              template: props.itemTemplate,
              item: item,
              active: isActive,
              start: start,
              end: end,
              ptm: ptm,
              cx: cx
            });
          });
          clonedElements = props.value.slice(0, numVisibleState);
          clonedItemsForFinishing = clonedElements.map(function (item, index) {
            var isActive = totalShiftedItemsState === 0;
            var start = index === 0;
            var end = index === clonedElements.length - 1;
            var key = index + '_fcloned';
            return /*#__PURE__*/React__namespace.createElement(CarouselItem, {
              key: key,
              className: "p-carousel-item-cloned",
              template: props.itemTemplate,
              item: item,
              active: isActive,
              start: start,
              end: end,
              ptm: ptm,
              cx: cx
            });
          });
        }
        var items = props.value.map(function (item, index) {
          var firstIndex = isCircular ? -1 * (totalShiftedItemsState + numVisibleState) : totalShiftedItemsState * -1;
          var lastIndex = firstIndex + numVisibleState - 1;
          var isActive = firstIndex <= index && lastIndex >= index;
          var start = firstIndex === index;
          var end = lastIndex === index;
          var ariaHidden = firstIndex > index || lastIndex < index ? true : undefined;
          var ariaLabel = ariaSlideNumber(index);
          var ariaRoledescription = localeOption('aria') ? localeOption('aria').slide : undefined;
          return /*#__PURE__*/React__namespace.createElement(CarouselItem, {
            key: index,
            template: props.itemTemplate,
            item: item,
            active: isActive,
            start: start,
            ariaHidden: ariaHidden,
            ariaLabel: ariaLabel,
            ariaRoledescription: ariaRoledescription,
            role: "group",
            end: end,
            ptm: ptm,
            cx: cx
          });
        });
        return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, null, clonedItemsForStarting, items, clonedItemsForFinishing);
      }
    };
    var createHeader = function createHeader() {
      if (props.header) {
        var headerProps = mergeProps({
          className: cx('header')
        }, ptm('header'));
        return /*#__PURE__*/React__namespace.createElement("div", headerProps, props.header);
      }
      return null;
    };
    var createFooter = function createFooter() {
      if (props.footer) {
        var footerProps = mergeProps({
          className: cx('footer')
        }, ptm('footer'));
        return /*#__PURE__*/React__namespace.createElement("div", footerProps, props.footer);
      }
      return null;
    };
    var createContent = function createContent() {
      var items = createItems();
      var height = isVertical ? props.verticalViewPortHeight : 'auto';
      var backwardNavigator = createBackwardNavigator();
      var forwardNavigator = createForwardNavigator();
      var itemsContentProps = mergeProps({
        className: cx('itemsContent'),
        style: sx('itemsContent', {
          height: height
        }),
        onTouchStart: function onTouchStart(e) {
          return _onTouchStart(e);
        },
        onTouchMove: function onTouchMove(e) {
          return _onTouchMove(e);
        },
        onTouchEnd: function onTouchEnd(e) {
          return _onTouchEnd(e);
        }
      }, ptm('itemsContent'));
      var containerProps = mergeProps({
        className: classNames(props.containerClassName, cx('container')),
        'aria-live': allowAutoplay.current ? 'polite' : 'off'
      }, ptm('container'));
      var itemsContainerProps = mergeProps({
        className: cx('itemsContainer'),
        onTransitionEnd: onTransitionEnd
      }, ptm('itemsContainer'));
      return /*#__PURE__*/React__namespace.createElement("div", containerProps, backwardNavigator, /*#__PURE__*/React__namespace.createElement("div", itemsContentProps, /*#__PURE__*/React__namespace.createElement("div", _extends({
        ref: itemsContainerRef
      }, itemsContainerProps), items)), forwardNavigator);
    };
    var createBackwardNavigator = function createBackwardNavigator() {
      if (props.showNavigators) {
        var isDisabled = (!circular || props.value && props.value.length < numVisibleState) && currentPage === 0;
        var previousButtonIconProps = mergeProps({
          className: cx('previousButtonIcon')
        }, ptm('previousButtonIcon'));
        var icon = isVertical ? props.prevIcon || /*#__PURE__*/React__namespace.createElement(ChevronUpIcon, previousButtonIconProps) : props.prevIcon || /*#__PURE__*/React__namespace.createElement(ChevronLeftIcon, previousButtonIconProps);
        var backwardNavigatorIcon = IconUtils.getJSXIcon(icon, _objectSpread$1y({}, previousButtonIconProps), {
          props: props
        });
        var previousButtonProps = mergeProps({
          type: 'button',
          className: cx('previousButton', {
            isDisabled: isDisabled
          }),
          onClick: function onClick(e) {
            return navBackward(e);
          },
          disabled: isDisabled,
          'aria-label': localeOption('aria') ? localeOption('aria').previousPageLabel : undefined,
          'data-pc-group-section': 'navigator'
        }, ptm('previousButton'));
        return /*#__PURE__*/React__namespace.createElement("button", previousButtonProps, backwardNavigatorIcon, /*#__PURE__*/React__namespace.createElement(Ripple, null));
      }
      return null;
    };
    var createForwardNavigator = function createForwardNavigator() {
      if (props.showNavigators) {
        var isDisabled = (!circular || props.value && props.value.length < numVisibleState) && (currentPage === totalIndicators - 1 || totalIndicators === 0);
        var nextButtonIconProps = mergeProps({
          className: cx('nextButtonIcon')
        }, ptm('nextButtonIcon'));
        var icon = isVertical ? props.nextIcon || /*#__PURE__*/React__namespace.createElement(ChevronDownIcon, nextButtonIconProps) : props.nextIcon || /*#__PURE__*/React__namespace.createElement(ChevronRightIcon, nextButtonIconProps);
        var forwardNavigatorIcon = IconUtils.getJSXIcon(icon, _objectSpread$1y({}, nextButtonIconProps), {
          props: props
        });
        var nextButtonProps = mergeProps({
          type: 'button',
          className: cx('nextButton', {
            isDisabled: isDisabled
          }),
          onClick: function onClick(e) {
            return navForward(e);
          },
          disabled: isDisabled,
          'aria-label': localeOption('aria') ? localeOption('aria').nextPageLabel : undefined,
          'data-pc-group-section': 'navigator'
        }, ptm('nextButton'));
        return /*#__PURE__*/React__namespace.createElement("button", nextButtonProps, forwardNavigatorIcon, /*#__PURE__*/React__namespace.createElement(Ripple, null));
      }
      return null;
    };
    var ariaPageLabel = function ariaPageLabel(value) {
      return localeOption('aria') ? localeOption('aria').pageLabel.replace(/{page}/g, value) : undefined;
    };
    var createIndicator = function createIndicator(index) {
      var isActive = currentPage === index;
      var getPTOptions = function getPTOptions(key) {
        return ptm(key, {
          context: {
            active: isActive
          }
        });
      };
      var key = 'carousel-indicator-' + index;
      var indicatorProps = mergeProps({
        key: key,
        className: cx('indicator', {
          isActive: isActive
        }),
        'data-p-highlight': isActive
      }, getPTOptions('indicator'));
      var indicatorButtonProps = mergeProps({
        type: 'button',
        className: cx('indicatorButton'),
        tabIndex: currentPage === index ? '0' : '-1',
        onClick: function onClick(e) {
          return onIndicatorClick(e, index);
        },
        'aria-label': ariaPageLabel(index + 1),
        'aria-current': currentPage === index ? 'page' : undefined
      }, getPTOptions('indicatorButton'));
      return /*#__PURE__*/React__namespace.createElement("li", indicatorProps, /*#__PURE__*/React__namespace.createElement("button", indicatorButtonProps, /*#__PURE__*/React__namespace.createElement(Ripple, null)));
    };
    var createIndicators = function createIndicators() {
      if (props.showIndicators) {
        var _indicators = [];
        for (var i = 0; i < totalIndicators; i++) {
          _indicators.push(createIndicator(i));
        }
        var indicatorsProps = mergeProps({
          ref: indicatorContent,
          className: classNames(props.indicatorsContentClassName, cx('indicators')),
          onKeyDown: onIndicatorKeydown
        }, ptm('indicators'));
        return /*#__PURE__*/React__namespace.createElement("ul", indicatorsProps, _indicators);
      }
      return null;
    };
    var content = createContent();
    var indicators = createIndicators();
    var header = createHeader();
    var footer = createFooter();
    var rootProps = mergeProps({
      id: props.id,
      ref: elementRef,
      className: classNames(props.className, cx('root', {
        isVertical: isVertical
      })),
      style: props.style,
      role: 'region'
    }, CarouselBase.getOtherProps(props), ptm('root'));
    var contentProps = mergeProps({
      className: classNames(props.contentClassName, cx('content'))
    }, ptm('content'));
    return /*#__PURE__*/React__namespace.createElement("div", rootProps, header, /*#__PURE__*/React__namespace.createElement("div", contentProps, content, indicators), footer);
  }));
  CarouselItem.displayName = 'CarouselItem';
  Carousel.displayName = 'Carousel';

  var classes$_ = {
    root: function root(_ref) {
      var props = _ref.props,
        focusedState = _ref.focusedState,
        overlayVisibleState = _ref.overlayVisibleState;
      return classNames('p-cascadeselect p-component p-inputwrapper', {
        'p-disabled': props.disabled,
        'p-focus': focusedState,
        'p-inputwrapper-filled': props.value,
        'p-inputwrapper-focus': focusedState || overlayVisibleState
      }, props.className);
    },
    label: function label(_ref2) {
      var props = _ref2.props,
        _label = _ref2.label;
      return classNames('p-cascadeselect-label ', {
        'p-placeholder': _label === props.placeholder,
        'p-cascadeselect-label-empty': !props.value && _label === 'p-emptylabel'
      });
    },
    list: function list(_ref3) {
      var context = _ref3.context;
      return classNames('p-cascadeselect-panel p-cascadeselect-items', {
        'p-input-filled': context && context.inputStyle === 'filled' || PrimeReact.inputStyle === 'filled',
        'p-ripple-disabled': context && context.ripple === false || PrimeReact.ripple === false
      });
    },
    sublist: 'p-cascadeselect-panel p-cascadeselect-items p-cascadeselect-sublist',
    item: function item(_ref4) {
      _ref4.option;
        var isGroup = _ref4.isGroup,
        isSelected = _ref4.isSelected;
      return classNames('p-cascadeselect-item', {
        'p-cascadeselect-item-group': isGroup,
        'p-cascadeselect-item-active p-highlight': isSelected
      });
    },
    dropdownIcon: 'p-cascadeselect-trigger-icon',
    loadingIcon: 'p-cascadeselect-trigger-icon',
    dropdownButton: 'p-cascadeselect-trigger',
    loadingButton: 'p-cascadeselect-trigger',
    wrapper: 'p-cascadeselect-items-wrapper',
    panel: 'p-cascadeselect-panel p-component',
    content: 'p-cascadeselect-item-content',
    optionGroupIcon: 'p-cascadeselect-group-icon',
    text: 'p-cascadeselect-item-text',
    transition: 'p-connected-overlay'
  };
  var styles$V = "\n@layer primereact {\n    .p-cascadeselect {\n        display: inline-flex;\n        cursor: pointer;\n        position: relative;\n        user-select: none;\n    }\n    \n    .p-cascadeselect-trigger {\n        display: flex;\n        align-items: center;\n        justify-content: center;\n        flex-shrink: 0;\n    }\n    \n    .p-cascadeselect-label {\n        display: block;\n        white-space: nowrap;\n        overflow: hidden;\n        flex: 1 1 auto;\n        width: 1%;\n        text-overflow: ellipsis;\n        cursor: pointer;\n    }\n    \n    .p-cascadeselect-label-empty {\n        overflow: hidden;\n        visibility: hidden;\n    }\n    \n    .p-cascadeselect .p-cascadeselect-panel {\n        min-width: 100%;\n    }\n    \n    .p-cascadeselect-panel {\n        position: absolute;\n        top: 0;\n        left: 0;\n    }\n    \n    .p-cascadeselect-item {\n        cursor: pointer;\n        font-weight: normal;\n        white-space: nowrap;\n    }\n    \n    .p-cascadeselect-item-content {\n        display: flex;\n        align-items: center;\n        overflow: hidden;\n        position: relative;\n    }\n    \n    .p-cascadeselect-group-icon {\n        margin-left: auto;\n    }\n    \n    .p-cascadeselect-items {\n        margin: 0;\n        padding: 0;\n        list-style-type: none;\n        min-width: 100%;\n    }\n    \n    .p-fluid .p-cascadeselect {\n        display: flex;\n    }\n    \n    .p-fluid .p-cascadeselect .p-cascadeselect-label {\n        width: 1%;\n    }\n    \n    .p-cascadeselect-sublist {\n        position: absolute;\n        min-width: 100%;\n        z-index: 1;\n        display: none;\n    }\n    \n    .p-cascadeselect-item-active {\n        overflow: visible;\n    }\n    \n    .p-cascadeselect-item-active > .p-cascadeselect-sublist {\n        display: block;\n        left: 100%;\n        top: 0;\n    }\n}\n";
  var CascadeSelectBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'CascadeSelect',
      appendTo: null,
      ariaLabelledBy: null,
      autoFocus: false,
      breakpoint: undefined,
      className: null,
      dataKey: null,
      disabled: false,
      loadingIcon: null,
      dropdownIcon: null,
      id: null,
      inputId: null,
      inputRef: null,
      itemTemplate: null,
      name: null,
      onBeforeHide: null,
      onBeforeShow: null,
      onChange: null,
      onGroupChange: null,
      onHide: null,
      onShow: null,
      optionGroupChildren: null,
      optionGroupIcon: null,
      optionGroupLabel: null,
      optionLabel: null,
      optionValue: null,
      options: null,
      placeholder: null,
      scrollHeight: '400px',
      style: null,
      tabIndex: null,
      transitionOptions: null,
      value: null,
      children: undefined
    },
    css: {
      classes: classes$_,
      styles: styles$V
    }
  });

  function ownKeys$1x(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1x(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1x(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1x(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var CascadeSelectSub = /*#__PURE__*/React__namespace.memo(function (props) {
    var _React$useState = React__namespace.useState(null),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      activeOptionState = _React$useState2[0],
      setActiveOptionState = _React$useState2[1];
    var elementRef = React__namespace.useRef(null);
    var context = React__namespace.useContext(PrimeReactContext);
    var ptm = props.ptm,
      cx = props.cx;
    var getPTOptions = function getPTOptions(key, options) {
      return ptm(key, {
        hostName: props.hostName,
        state: _objectSpread$1x({}, options)
      });
    };
    var position = function position() {
      var parentItem = elementRef.current.parentElement;
      var containerOffset = DomHandler.getOffset(parentItem);
      var viewport = DomHandler.getViewport();
      var sublistWidth = elementRef.current.offsetParent ? elementRef.current.offsetWidth : DomHandler.getHiddenElementOuterWidth(element);
      var itemOuterWidth = DomHandler.getOuterWidth(parentItem.children[0]);
      if (parseInt(containerOffset.left, 10) + itemOuterWidth + sublistWidth > viewport.width - DomHandler.calculateScrollbarWidth()) {
        elementRef.current.style.left = '-100%';
      }
    };
    var onOptionSelect = function onOptionSelect(event) {
      props.onOptionSelect && props.onOptionSelect(event);
    };
    var _onKeyDown = function onKeyDown(event, option) {
      var listItem = event.currentTarget.parentElement;
      switch (event.key) {
        case 'Down':
        case 'ArrowDown':
          var nextItem = findNextItem(listItem);
          if (nextItem) {
            nextItem.children[0].focus();
          }
          break;
        case 'Up':
        case 'ArrowUp':
          var prevItem = findPrevItem(listItem);
          if (prevItem) {
            prevItem.children[0].focus();
          }
          break;
        case 'Right':
        case 'ArrowRight':
          if (isOptionGroup(option)) {
            if (activeOptionState === option) {
              listItem.children[1].children[0].children[0].focus();
            } else {
              setActiveOptionState(option);
            }
          }
          break;
        case 'Left':
        case 'ArrowLeft':
          setActiveOptionState(null);
          var parentList = event.currentTarget.parentElement.parentElement.previousElementSibling;
          if (parentList) {
            parentList.focus();
          }
          break;
        case 'Enter':
          onOptionClick(event, option);
          break;
        case 'Tab':
        case 'Escape':
          if (props.onPanelHide) {
            props.onPanelHide();
            event.preventDefault();
          }
          break;
      }
      event.preventDefault();
    };
    var findNextItem = function findNextItem(item) {
      var nextItem = item.nextElementSibling;
      return nextItem ? DomHandler.hasClass(nextItem, 'p-disabled') || !DomHandler.hasClass(nextItem, 'p-cascadeselect-item') ? findNextItem(nextItem) : nextItem : null;
    };
    var findPrevItem = function findPrevItem(item) {
      var prevItem = item.previousElementSibling;
      return prevItem ? DomHandler.hasClass(prevItem, 'p-disabled') || !DomHandler.hasClass(prevItem, 'p-cascadeselect-item') ? findPrevItem(prevItem) : prevItem : null;
    };
    var onOptionClick = function onOptionClick(event, option) {
      if (isOptionGroup(option)) {
        setActiveOptionState(function (prevActiveOption) {
          return prevActiveOption === option ? null : option;
        });
        if (props.onOptionGroupSelect) {
          props.onOptionGroupSelect({
            originalEvent: event,
            value: option
          });
        }
      } else {
        if (props.onOptionSelect) {
          props.onOptionSelect({
            originalEvent: event,
            value: getOptionValue(option)
          });
        }
      }
    };
    var onOptionGroupSelect = function onOptionGroupSelect(event) {
      props.onOptionGroupSelect && props.onOptionGroupSelect(event);
    };
    var getOptionLabel = function getOptionLabel(option) {
      return props.optionLabel ? ObjectUtils.resolveFieldData(option, props.optionLabel) : option;
    };
    var getOptionValue = function getOptionValue(option) {
      return props.optionValue ? ObjectUtils.resolveFieldData(option, props.optionValue) : option;
    };
    var getOptionGroupLabel = function getOptionGroupLabel(optionGroup) {
      return props.optionGroupLabel ? ObjectUtils.resolveFieldData(optionGroup, props.optionGroupLabel) : null;
    };
    var getOptionGroupChildren = function getOptionGroupChildren(optionGroup) {
      return ObjectUtils.resolveFieldData(optionGroup, props.optionGroupChildren[props.level]);
    };
    var isOptionGroup = function isOptionGroup(option) {
      return Object.prototype.hasOwnProperty.call(option, props.optionGroupChildren[props.level]);
    };
    var getOptionLabelToRender = function getOptionLabelToRender(option) {
      return isOptionGroup(option) ? getOptionGroupLabel(option) : getOptionLabel(option);
    };
    useMountEffect(function () {
      if (props.selectionPath && props.options && !props.dirty) {
        var activeOption = props.options.find(function (o) {
          return props.selectionPath.includes(o);
        });
        activeOption && setActiveOptionState(activeOption);
      }
      if (!props.root) {
        position();
      }
    });
    useUpdateEffect(function () {
      if (!props.parentActive) {
        setActiveOptionState(null);
      }
    }, [props.parentActive]);
    var createSubmenu = function createSubmenu(option) {
      if (isOptionGroup(option) && activeOptionState === option) {
        var options = getOptionGroupChildren(option);
        var parentActive = activeOptionState === option;
        var level = props.level + 1;
        return /*#__PURE__*/React__namespace.createElement(CascadeSelectSub, {
          hostName: props.hostName,
          options: options,
          className: cx('sublist'),
          selectionPath: props.selectionPath,
          optionLabel: props.optionLabel,
          optionValue: props.optionValue,
          level: level,
          onOptionSelect: onOptionSelect,
          onOptionGroupSelect: onOptionGroupSelect,
          parentActive: parentActive,
          optionGroupLabel: props.optionGroupLabel,
          optionGroupChildren: props.optionGroupChildren,
          dirty: props.dirty,
          template: props.template,
          onPanelHide: props.onPanelHide,
          ptm: ptm,
          cx: cx
        });
      }
      return null;
    };
    var createOption = function createOption(option, index) {
      var submenu = createSubmenu(option);
      var textProps = mergeProps({
        className: cx('text')
      }, getPTOptions('text'));
      var content = props.template ? ObjectUtils.getJSXElement(props.template, getOptionValue(option)) : /*#__PURE__*/React__namespace.createElement("span", textProps, getOptionLabelToRender(option));
      var optionGroupIconProps = mergeProps({
        className: cx('optionGroupIcon')
      }, getPTOptions('optionGroupIcon'));
      var icon = props.optionGroupIcon || /*#__PURE__*/React__namespace.createElement(AngleRightIcon, optionGroupIconProps);
      var optionGroup = isOptionGroup(option) && IconUtils.getJSXIcon(icon, _objectSpread$1x({}, optionGroupIconProps), {
        props: props
      });
      var key = getOptionLabelToRender(option) + '_' + index;
      var contentProps = mergeProps({
        className: cx('content'),
        onClick: function onClick(event) {
          return onOptionClick(event, option);
        },
        tabIndex: 0,
        onKeyDown: function onKeyDown(event) {
          return _onKeyDown(event, option);
        }
      }, getPTOptions('content'));
      var isSelected = activeOptionState === option;
      var isGroup = isOptionGroup(option);
      var itemProps = mergeProps({
        className: classNames(option.className, cx('item', {
          option: option,
          isGroup: isGroup,
          isSelected: isSelected
        })),
        style: option.style,
        role: 'none',
        'data-p-item-group': isGroup,
        'data-p-highlight': isSelected
      }, getPTOptions('item', {
        selected: isSelected,
        group: isGroup
      }));
      return /*#__PURE__*/React__namespace.createElement("li", _extends({
        key: key
      }, itemProps), /*#__PURE__*/React__namespace.createElement("div", contentProps, content, optionGroup, /*#__PURE__*/React__namespace.createElement(Ripple, null)), submenu);
    };
    var createMenu = function createMenu() {
      return props.options ? props.options.map(createOption) : null;
    };
    var submenu = createMenu();
    var listProps = mergeProps({
      ref: elementRef,
      className: cx(props.level === 0 ? 'list' : 'sublist', {
        context: context
      }),
      role: 'listbox',
      'aria-orientation': 'horizontal'
    }, props.level === 0 ? getPTOptions('list') : getPTOptions('sublist'));
    return /*#__PURE__*/React__namespace.createElement("ul", listProps, submenu);
  });

  function _createForOfIteratorHelper$d(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray$d(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
  function _unsupportedIterableToArray$d(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray$d(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$d(o, minLen); }
  function _arrayLikeToArray$d(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
  function ownKeys$1w(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1w(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1w(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1w(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var CascadeSelect = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var context = React__namespace.useContext(PrimeReactContext);
    var props = CascadeSelectBase.getProps(inProps, context);
    var _React$useState = React__namespace.useState(false),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      focusedState = _React$useState2[0],
      setFocusedState = _React$useState2[1];
    var _React$useState3 = React__namespace.useState(false),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      overlayVisibleState = _React$useState4[0],
      setOverlayVisibleState = _React$useState4[1];
    var _React$useState5 = React__namespace.useState(null),
      _React$useState6 = _slicedToArray(_React$useState5, 2),
      attributeSelectorState = _React$useState6[0],
      setAttributeSelectorState = _React$useState6[1];
    var _CascadeSelectBase$se = CascadeSelectBase.setMetaData({
        props: props,
        state: {
          focused: focusedState,
          overlayVisible: overlayVisibleState,
          attributeSelector: attributeSelectorState
        },
        context: _objectSpread$1w({}, context)
      }),
      ptm = _CascadeSelectBase$se.ptm,
      cx = _CascadeSelectBase$se.cx,
      isUnstyled = _CascadeSelectBase$se.isUnstyled;
    useHandleStyle(CascadeSelectBase.css.styles, isUnstyled, {
      name: 'cascadeselect'
    });
    var elementRef = React__namespace.useRef(null);
    var overlayRef = React__namespace.useRef(null);
    var inputRef = React__namespace.useRef(null);
    var labelRef = React__namespace.useRef(null);
    var styleElementRef = React__namespace.useRef(null);
    var dirty = React__namespace.useRef(false);
    var selectionPath = React__namespace.useRef(null);
    var _useOverlayListener = useOverlayListener({
        target: elementRef,
        overlay: overlayRef,
        listener: function listener(event, _ref) {
          var valid = _ref.valid;
          valid && hide();
        },
        when: overlayVisibleState
      }),
      _useOverlayListener2 = _slicedToArray(_useOverlayListener, 2),
      bindOverlayListener = _useOverlayListener2[0],
      unbindOverlayListener = _useOverlayListener2[1];
    var cascadeSelectOverlayDisplayOrder = useDisplayOrder('cascade-select', overlayVisibleState);
    useGlobalOnEscapeKey({
      callback: function callback() {
        hide();
      },
      when: overlayVisibleState,
      priority: [ESC_KEY_HANDLING_PRIORITIES.CASCADE_SELECT, cascadeSelectOverlayDisplayOrder]
    });
    var onOptionSelect = function onOptionSelect(event) {
      if (props.onChange) {
        props.onChange({
          originalEvent: event,
          value: event.value
        });
      }
      updateSelectionPath();
      hide();
      DomHandler.focus(inputRef.current);
    };
    var onOptionGroupSelect = function onOptionGroupSelect(event) {
      dirty.current = true;
      props.onGroupChange && props.onGroupChange(event);
    };
    var getOptionLabel = function getOptionLabel(option) {
      var label = props.optionLabel ? ObjectUtils.resolveFieldData(option, props.optionLabel) : option;
      return label || option;
    };
    var getOptionValue = function getOptionValue(option) {
      return props.optionValue ? ObjectUtils.resolveFieldData(option, props.optionValue) : option;
    };
    var getOptionGroupChildren = function getOptionGroupChildren(optionGroup, level) {
      return ObjectUtils.resolveFieldData(optionGroup, props.optionGroupChildren[level]);
    };
    var isOptionGroup = function isOptionGroup(option, level) {
      return Object.prototype.hasOwnProperty.call(option, props.optionGroupChildren[level]);
    };
    var updateSelectionPath = function updateSelectionPath() {
      var path;
      if (props.value != null && props.options) {
        var _iterator = _createForOfIteratorHelper$d(props.options),
          _step;
        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var option = _step.value;
            path = findModelOptionInGroup(option, 0);
            if (path) {
              break;
            }
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }
      }
      selectionPath.current = path;
    };
    var findModelOptionInGroup = function findModelOptionInGroup(option, level) {
      if (isOptionGroup(option, level)) {
        var selectedOption;
        var _iterator2 = _createForOfIteratorHelper$d(getOptionGroupChildren(option, level)),
          _step2;
        try {
          for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
            var childOption = _step2.value;
            selectedOption = findModelOptionInGroup(childOption, level + 1);
            if (selectedOption) {
              selectedOption.unshift(option);
              return selectedOption;
            }
          }
        } catch (err) {
          _iterator2.e(err);
        } finally {
          _iterator2.f();
        }
      } else if (ObjectUtils.equals(props.value, getOptionValue(option), props.dataKey)) {
        return [option];
      }
      return null;
    };
    var _onClick = function onClick(event) {
      if (props.disabled || props.loading) {
        return;
      }
      if (!overlayRef.current || !overlayRef.current.contains(event.target)) {
        DomHandler.focus(inputRef.current);
        overlayVisibleState ? hide() : show();
      }
    };
    var onInputFocus = function onInputFocus() {
      setFocusedState(true);
    };
    var onInputBlur = function onInputBlur() {
      setFocusedState(false);
    };
    var onInputKeyDown = function onInputKeyDown(event) {
      switch (event.which) {
        //down
        case 40:
          if (overlayVisibleState) {
            DomHandler.findSingle(overlayRef.current, '[data-pc-section="item"]').children[0].focus();
          } else if (event.altKey && props.options && props.options.length) {
            show();
          }
          event.preventDefault();
          break;

        //space
        case 32:
          overlayVisibleState ? hide() : show();
          event.preventDefault();
          break;

        //tab
        case 9:
          hide();
          break;
      }
    };
    var onPanelClick = function onPanelClick(event) {
      OverlayService.emit('overlay-click', {
        originalEvent: event,
        target: elementRef.current
      });
    };
    var show = function show() {
      props.onBeforeShow && props.onBeforeShow();
      setOverlayVisibleState(true);
    };
    var hide = function hide() {
      props.onBeforeHide && props.onBeforeHide();
      setOverlayVisibleState(false);
      DomHandler.focus(inputRef.current);
    };
    var onOverlayEnter = function onOverlayEnter() {
      ZIndexUtils.set('overlay', overlayRef.current, context && context.autoZIndex || PrimeReact.autoZIndex, context && context.zIndex['overlay'] || PrimeReact.zIndex['overlay']);
      DomHandler.addStyles(overlayRef.current, {
        position: 'absolute',
        top: '0',
        left: '0'
      });
      alignOverlay();
      if (attributeSelectorState && props.breakpoint) {
        overlayRef.current.setAttribute(attributeSelectorState + '_panel', '');
        createStyle();
      }
    };
    var onOverlayEntered = function onOverlayEntered() {
      bindOverlayListener();
      props.onShow && props.onShow();
    };
    var onOverlayExit = function onOverlayExit() {
      unbindOverlayListener();
      dirty.current = false;
    };
    var onOverlayExited = function onOverlayExited() {
      ZIndexUtils.clear(overlayRef.current);
      props.onHide && props.onHide();
      destroyStyle();
    };
    var alignOverlay = function alignOverlay() {
      DomHandler.alignOverlay(overlayRef.current, labelRef.current.parentElement, props.appendTo || context && context.appendTo || PrimeReact.appendTo);
    };
    var createStyle = function createStyle() {
      if (!styleElementRef.current) {
        styleElementRef.current = DomHandler.createInlineStyle(context && context.nonce || PrimeReact.nonce, context && context.styleContainer);
        var selector = "".concat(attributeSelectorState, "_panel");
        var innerHTML = "\n@media screen and (max-width: ".concat(props.breakpoint, ") {\n    .p-cascadeselect-panel[").concat(selector, "] .p-cascadeselect-items-wrapper > ul {\n        max-height: ").concat(props.scrollHeight, ";\n        overflow: ").concat(props.scrollHeight ? 'auto' : '', ";\n    }\n\n    .p-cascadeselect-panel[").concat(selector, "] .p-cascadeselect-sublist {\n        position: relative;\n    }\n\n    .p-cascadeselect-panel[").concat(selector, "] .p-cascadeselect-item-active > .p-cascadeselect-sublist {\n        left: 0;\n        box-shadow: none;\n        border-radius: 0;\n        padding: 0 0 0 calc(var(--inline-spacing) * 2); /* @todo */\n    }\n\n    .p-cascadeselect-panel[").concat(selector, "] .p-cascadeselect-group-icon:before {\n        content: \"\\e930\";\n    }\n}\n");
        styleElementRef.current.innerHTML = innerHTML;
      }
    };
    var destroyStyle = function destroyStyle() {
      styleElementRef.current = DomHandler.removeInlineStyle(styleElementRef.current);
    };
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        getElement: function getElement() {
          return elementRef.current;
        },
        getOverlay: function getOverlay() {
          return overlayRef.current;
        },
        getInput: function getInput() {
          return inputRef.current;
        },
        getLabel: function getLabel() {
          return labelRef.current;
        },
        focus: function focus() {
          return DomHandler.focus(inputRef.current);
        }
      };
    });
    useMountEffect(function () {
      if (props.breakpoint) {
        !attributeSelectorState && setAttributeSelectorState(UniqueComponentId());
      }
      if (props.autoFocus) {
        DomHandler.focus(inputRef.current, props.autoFocus);
      }
      alignOverlay();
    });
    React__namespace.useEffect(function () {
      ObjectUtils.combinedRefs(inputRef, props.inputRef);
    }, [inputRef, props.inputRef]);
    useUpdateEffect(function () {
      updateSelectionPath();
    }, [props.value]);
    useUnmountEffect(function () {
      ZIndexUtils.clear(overlayRef.current);
    });
    var createKeyboardHelper = function createKeyboardHelper() {
      var value = props.value ? getOptionLabel(props.value) : undefined;
      var hiddenSelectedMessageProps = mergeProps({
        className: 'p-hidden-accessible'
      }, ptm('hiddenSelectedMessage'));
      var inputProps = mergeProps(_objectSpread$1w({
        ref: inputRef,
        type: 'text',
        id: props.inputId,
        name: props.name,
        defaultValue: value,
        readOnly: true,
        disabled: props.disabled,
        onFocus: onInputFocus,
        onBlur: onInputBlur,
        onKeyDown: function onKeyDown(e) {
          return onInputKeyDown(e);
        },
        tabIndex: props.tabIndex,
        'aria-haspopup': 'listbox'
      }, ariaProps), ptm('input'));
      return /*#__PURE__*/React__namespace.createElement("div", hiddenSelectedMessageProps, /*#__PURE__*/React__namespace.createElement("input", inputProps));
    };
    var createLabel = function createLabel() {
      var label = props.value ? getOptionLabel(props.value) : props.placeholder || 'p-emptylabel';
      var labelProps = mergeProps({
        ref: labelRef,
        className: cx('label', {
          label: label
        })
      }, ptm('label', {
        context: _objectSpread$1w({
          label: label
        }, context)
      }));
      return /*#__PURE__*/React__namespace.createElement("span", labelProps, label);
    };
    var createLoadingIcon = function createLoadingIcon() {
      var loadingIconProps = mergeProps({
        className: cx('loadingIcon')
      }, ptm('loadingIcon'));
      var icon = props.loadingIcon || /*#__PURE__*/React__namespace.createElement(SpinnerIcon, {
        spin: true
      });
      var loadingIcon = IconUtils.getJSXIcon(icon, _objectSpread$1w({}, loadingIconProps), {
        props: props
      });
      var loadingButtonProps = mergeProps({
        className: cx('loadingButton'),
        role: 'button',
        'aria-haspopup': 'listbox',
        'aria-expanded': overlayVisibleState
      }, ptm('dropdownButton'));
      return /*#__PURE__*/React__namespace.createElement("div", loadingButtonProps, loadingIcon);
    };
    var createDropdownIcon = function createDropdownIcon() {
      var dropdownIconProps = mergeProps({
        className: cx('dropdownIcon')
      }, ptm('dropdownIcon'));
      var icon = props.dropdownIcon || /*#__PURE__*/React__namespace.createElement(ChevronDownIcon, dropdownIconProps);
      var dropdownIcon = IconUtils.getJSXIcon(icon, _objectSpread$1w({}, dropdownIconProps), {
        props: props
      });
      var dropdownButtonProps = mergeProps({
        className: cx('dropdownButton'),
        role: 'button',
        'aria-haspopup': 'listbox',
        'aria-expanded': overlayVisibleState
      }, ptm('dropdownButton'));
      return /*#__PURE__*/React__namespace.createElement("div", dropdownButtonProps, dropdownIcon);
    };
    var wrapperProps = mergeProps({
      className: cx('wrapper')
    }, ptm('wrapper'));
    var panelProps = mergeProps({
      ref: overlayRef,
      className: cx('panel'),
      onClick: function onClick(e) {
        return onPanelClick(e);
      }
    }, ptm('panel'));
    var createOverlay = function createOverlay() {
      var transitionProps = mergeProps({
        classNames: cx('transition'),
        "in": overlayVisibleState,
        timeout: {
          enter: 120,
          exit: 100
        },
        options: props.transitionOptions,
        unmountOnExit: true,
        onEnter: onOverlayEnter,
        onEntered: onOverlayEntered,
        onExit: onOverlayExit,
        onExited: onOverlayExited
      }, ptm('transition'));
      var overlay = /*#__PURE__*/React__namespace.createElement(CSSTransition, _extends({
        nodeRef: overlayRef
      }, transitionProps), /*#__PURE__*/React__namespace.createElement("div", panelProps, /*#__PURE__*/React__namespace.createElement("div", wrapperProps, /*#__PURE__*/React__namespace.createElement(CascadeSelectSub, {
        hostName: "CascadeSelect",
        options: props.options,
        selectionPath: selectionPath.current,
        optionGroupIcon: props.optionGroupIcon,
        optionLabel: props.optionLabel,
        optionValue: props.optionValue,
        parentActive: props.value != null,
        level: 0,
        optionGroupLabel: props.optionGroupLabel,
        optionGroupChildren: props.optionGroupChildren,
        onOptionSelect: onOptionSelect,
        onOptionGroupSelect: onOptionGroupSelect,
        root: true,
        template: props.itemTemplate,
        onPanelHide: hide,
        ptm: ptm,
        cx: cx
      }))));
      return /*#__PURE__*/React__namespace.createElement(Portal, {
        element: overlay,
        appendTo: props.appendTo
      });
    };
    var createElement = function createElement() {
      var keyboardHelper = createKeyboardHelper();
      var labelElement = createLabel();
      var dropdownIcon = props.loading ? createLoadingIcon() : createDropdownIcon();
      var overlay = createOverlay();
      var rootProps = mergeProps({
        id: props.id,
        ref: elementRef,
        className: cx('root', {
          focusedState: focusedState,
          overlayVisibleState: overlayVisibleState
        }),
        style: props.style,
        onClick: function onClick(e) {
          return _onClick(e);
        }
      }, otherProps, ptm('root'));
      return /*#__PURE__*/React__namespace.createElement("div", rootProps, keyboardHelper, labelElement, dropdownIcon, overlay);
    };
    var otherProps = CascadeSelectBase.getOtherProps(props);
    ObjectUtils.reduceKeys(otherProps, DomHandler.DATA_PROPS);
    var ariaProps = ObjectUtils.reduceKeys(otherProps, DomHandler.ARIA_PROPS);
    var element = createElement();
    return element;
  }));
  CascadeSelect.displayName = 'CascadeSelect';

  var ChartBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'Chart',
      id: null,
      type: null,
      data: null,
      options: null,
      plugins: null,
      width: null,
      height: null,
      style: null,
      className: null,
      children: undefined
    },
    css: {
      classes: {
        root: function root(_ref) {
          var props = _ref.props;
          return classNames('p-chart', props.className);
        }
      },
      inlineStyles: {
        root: function root(_ref2) {
          var props = _ref2.props;
          return Object.assign({
            width: props.width,
            height: props.height
          }, props.style);
        }
      },
      styles: "\n        @layer primereact {\n            .p-chart {\n                position: relative\n            }\n        }\n        "
    }
  });

  // GitHub #3059 wrapper if loaded by script tag
  var ChartJS = function () {
    try {
      return Chart;
    } catch (_unused) {
      return null;
    }
  }();
  var PrimeReactChart = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var context = React__namespace.useContext(PrimeReactContext);
    var props = ChartBase.getProps(inProps, context);
    var _ChartBase$setMetaDat = ChartBase.setMetaData({
        props: props
      }),
      ptm = _ChartBase$setMetaDat.ptm,
      cx = _ChartBase$setMetaDat.cx,
      sx = _ChartBase$setMetaDat.sx,
      isUnstyled = _ChartBase$setMetaDat.isUnstyled;
    useHandleStyle(ChartBase.css.styles, isUnstyled, {
      name: 'chart'
    });
    var elementRef = React__namespace.useRef(null);
    var chartRef = React__namespace.useRef(null);
    var canvasRef = React__namespace.useRef(null);
    var initChart = function initChart() {
      destroyChart();
      var configuration = {
        type: props.type,
        data: props.data,
        options: props.options,
        plugins: props.plugins
      };
      if (ChartJS) {
        // GitHub #3059 loaded by script only
        chartRef.current = new ChartJS(canvasRef.current, configuration);
      } else {
        import('chart.js/auto').then(function (module) {
          destroyChart();

          // In case that the Chart component has been unmounted during asynchronous loading of ChartJS,
          // the canvasRef will not be available anymore, and no Chart should be created.
          if (!canvasRef.current) {
            return;
          }
          if (module) {
            if (module["default"]) {
              // WebPack
              chartRef.current = new module["default"](canvasRef.current, configuration);
            } else {
              // ParcelJS
              chartRef.current = new module(canvasRef.current, configuration);
            }
          }
        });
      }
    };
    var destroyChart = function destroyChart() {
      if (chartRef.current) {
        chartRef.current.destroy();
        chartRef.current = null;
      }
    };
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        getCanvas: function getCanvas() {
          return canvasRef.current;
        },
        getChart: function getChart() {
          return chartRef.current;
        },
        getBase64Image: function getBase64Image() {
          return chartRef.current.toBase64Image();
        },
        getElement: function getElement() {
          return elementRef.current;
        },
        generateLegend: function generateLegend() {
          return chartRef.current && chartRef.current.generateLegend();
        },
        refresh: function refresh() {
          return chartRef.current && chartRef.current.update();
        }
      };
    });
    React__namespace.useEffect(function () {
      initChart();
    });
    useUnmountEffect(function () {
      destroyChart();
    });
    var title = props.options && props.options.plugins && props.options.plugins.title && props.options.plugins.title.text;
    var ariaLabel = props.ariaLabel || title;
    var rootProps = mergeProps({
      id: props.id,
      ref: elementRef,
      style: sx('root'),
      className: cx('root')
    }, ChartBase.getOtherProps(props), ptm('root'));
    var canvasProps = mergeProps({
      ref: canvasRef,
      width: props.width,
      height: props.height,
      role: 'img',
      'aria-label': ariaLabel
    }, ptm('canvas'));
    return /*#__PURE__*/React__namespace.createElement("div", rootProps, /*#__PURE__*/React__namespace.createElement("canvas", canvasProps));
  }), function (prevProps, nextProps) {
    return prevProps.data === nextProps.data && prevProps.options === nextProps.options && prevProps.type === nextProps.type;
  });
  PrimeReactChart.displayName = 'Chart';

  var classes$Z = {
    icon: 'p-checkbox-icon p-c',
    input: function input(_ref) {
      var props = _ref.props,
        checked = _ref.checked,
        focusedState = _ref.focusedState;
      return classNames('p-checkbox-box', {
        'p-highlight': checked,
        'p-disabled': props.disabled,
        'p-focus': focusedState
      });
    },
    root: function root(_ref2) {
      var props = _ref2.props,
        checked = _ref2.checked,
        focusedState = _ref2.focusedState;
      return classNames('p-checkbox p-component', {
        'p-checkbox-checked': checked,
        'p-checkbox-disabled': props.disabled,
        'p-checkbox-focused': focusedState
      });
    }
  };
  var styles$U = "\n.p-checkbox {\n    display: inline-flex;\n    cursor: pointer;\n    user-select: none;\n    vertical-align: bottom;\n    position: relative;\n}\n\n.p-checkbox.p-checkbox-disabled {\n    cursor: auto;\n}\n\n.p-checkbox-box {\n    display: flex;\n    justify-content: center;\n    align-items: center;\n}        \n";
  var CheckboxBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'Checkbox',
      autoFocus: false,
      checked: false,
      className: null,
      disabled: false,
      falseValue: false,
      icon: null,
      id: null,
      inputId: null,
      inputRef: null,
      name: null,
      onChange: null,
      onClick: null,
      onContextMenu: null,
      onMouseDown: null,
      readOnly: false,
      required: false,
      style: null,
      tabIndex: null,
      tooltip: null,
      tooltipOptions: null,
      trueValue: true,
      value: null,
      children: undefined
    },
    css: {
      classes: classes$Z,
      styles: styles$U
    }
  });

  function ownKeys$1v(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1v(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1v(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1v(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var Checkbox = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var context = React__namespace.useContext(PrimeReactContext);
    var props = CheckboxBase.getProps(inProps, context);
    var _React$useState = React__namespace.useState(false),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      focusedState = _React$useState2[0],
      setFocusedState = _React$useState2[1];
    var _CheckboxBase$setMeta = CheckboxBase.setMetaData({
        props: props,
        state: {
          focused: focusedState
        },
        context: {
          checked: props.checked === props.trueValue,
          disabled: props.disabled
        }
      }),
      ptm = _CheckboxBase$setMeta.ptm,
      cx = _CheckboxBase$setMeta.cx,
      isUnstyled = _CheckboxBase$setMeta.isUnstyled;
    useHandleStyle(CheckboxBase.css.styles, isUnstyled, {
      name: 'checkbox',
      styled: true
    });
    var elementRef = React__namespace.useRef(null);
    var inputRef = React__namespace.useRef(props.inputRef);
    var _onClick = function onClick(event) {
      if (props.disabled || props.readOnly) {
        return;
      }
      if (props.onChange || props.onClick) {
        var _checked = isChecked();
        var checkboxClicked = event.target instanceof HTMLDivElement || event.target instanceof HTMLSpanElement || event.target instanceof Object;
        var isInputToggled = event.target === inputRef.current;
        var isCheckboxToggled = checkboxClicked && event.target.checked !== _checked;
        var value = _checked ? props.falseValue : props.trueValue;
        var eventData = {
          originalEvent: event,
          value: props.value,
          checked: value,
          stopPropagation: function stopPropagation() {
            event.stopPropagation();
          },
          preventDefault: function preventDefault() {
            event.preventDefault();
          },
          target: {
            type: 'checkbox',
            name: props.name,
            id: props.id,
            value: props.value,
            checked: value
          }
        };
        props.onClick && props.onClick(eventData);

        // do not continue if the user defined click wants to prevent
        if (event.defaultPrevented) {
          return;
        }
        if (isInputToggled || isCheckboxToggled) {
          props.onChange && props.onChange(eventData);
        }
        DomHandler.focus(inputRef.current);
        event.preventDefault();
      }
    };
    var _onFocus = function onFocus() {
      setFocusedState(true);
    };
    var _onBlur = function onBlur() {
      setFocusedState(false);
    };
    var _onKeyDown = function onKeyDown(event) {
      if (event.code === 'Space' || event.key === ' ') {
        // event.key is for Android support
        _onClick(event);
      }
    };
    var isChecked = function isChecked() {
      return props.checked === props.trueValue;
    };
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        focus: function focus() {
          return DomHandler.focus(inputRef.current);
        },
        getElement: function getElement() {
          return elementRef.current;
        },
        getInput: function getInput() {
          return inputRef.current;
        }
      };
    });
    React__namespace.useEffect(function () {
      ObjectUtils.combinedRefs(inputRef, props.inputRef);
    }, [inputRef, props.inputRef]);
    useUpdateEffect(function () {
      inputRef.current.checked = isChecked();
    }, [props.checked, props.trueValue]);
    useMountEffect(function () {
      if (props.autoFocus) {
        DomHandler.focus(inputRef.current, props.autoFocus);
      }
    });
    var checked = isChecked();
    var hasTooltip = ObjectUtils.isNotEmpty(props.tooltip);
    var otherProps = CheckboxBase.getOtherProps(props);
    var ariaProps = ObjectUtils.reduceKeys(otherProps, DomHandler.ARIA_PROPS);
    var iconProps = mergeProps({
      className: cx('icon')
    }, ptm('icon'));
    var icon = checked ? props.icon || /*#__PURE__*/React__namespace.createElement(CheckIcon, iconProps) : null;
    var checkboxIcon = IconUtils.getJSXIcon(icon, _objectSpread$1v({}, iconProps), {
      props: props,
      checked: checked
    });
    var rootProps = mergeProps({
      id: props.id,
      className: classNames(props.className, cx('root', {
        checked: checked,
        focusedState: focusedState
      })),
      style: props.style,
      onClick: function onClick(e) {
        return _onClick(e);
      },
      onContextMenu: props.onContextMenu,
      onMouseDown: props.onMouseDown
    }, otherProps, ptm('root'));
    var hiddenInputWrapperProps = mergeProps({
      className: 'p-hidden-accessible'
    }, ptm('hiddenInputWrapper'));
    var hiddenInputProps = mergeProps(_objectSpread$1v({
      id: props.inputId,
      type: 'checkbox',
      name: props.name,
      tabIndex: props.tabIndex,
      defaultChecked: checked,
      onFocus: function onFocus(e) {
        return _onFocus();
      },
      onBlur: function onBlur(e) {
        return _onBlur();
      },
      onKeyDown: function onKeyDown(e) {
        return _onKeyDown(e);
      },
      disabled: props.disabled,
      readOnly: props.readOnly,
      required: props.required
    }, ariaProps), ptm('hiddenInput'));
    var inputProps = mergeProps({
      className: cx('input', {
        checked: checked,
        focusedState: focusedState
      }),
      'data-p-highlight': checked,
      'data-p-disabled': props.disabled,
      'data-p-focus': focusedState
    }, ptm('input'));
    return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, null, /*#__PURE__*/React__namespace.createElement("div", _extends({
      ref: elementRef
    }, rootProps), /*#__PURE__*/React__namespace.createElement("div", hiddenInputWrapperProps, /*#__PURE__*/React__namespace.createElement("input", _extends({
      ref: inputRef
    }, hiddenInputProps))), /*#__PURE__*/React__namespace.createElement("div", inputProps, checkboxIcon)), hasTooltip && /*#__PURE__*/React__namespace.createElement(Tooltip, _extends({
      target: elementRef,
      content: props.tooltip
    }, props.tooltipOptions, {
      pt: ptm('tooltip')
    })));
  }));
  Checkbox.displayName = 'Checkbox';

  var classes$Y = {
    root: function root(_ref) {
      var props = _ref.props;
      return classNames('p-chip p-component', {
        'p-chip-image': props.image != null
      });
    },
    removeIcon: 'p-chip-remove-icon',
    icon: 'p-chip-icon',
    label: 'p-chip-text'
  };
  var styles$T = "\n@layer primereact {\n    .p-chip {\n        display: inline-flex;\n        align-items: center;\n    }\n    \n    .p-chip-text {\n        line-height: 1.5;\n    }\n    \n    .p-chip-icon.pi {\n        line-height: 1.5;\n    }\n    \n    .p-chip .p-chip-remove-icon {\n        line-height: 1.5;\n        cursor: pointer;\n    }\n    \n    .p-chip img {\n        border-radius: 50%;\n    }\n}\n";
  var ChipBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'Chip',
      label: null,
      icon: null,
      image: null,
      removable: false,
      removeIcon: null,
      className: null,
      style: null,
      template: null,
      imageAlt: 'chip',
      onImageError: null,
      onRemove: null,
      children: undefined
    },
    css: {
      classes: classes$Y,
      styles: styles$T
    }
  });

  function ownKeys$1u(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1u(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1u(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1u(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var Chip = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var context = React__namespace.useContext(PrimeReactContext);
    var props = ChipBase.getProps(inProps, context);
    var elementRef = React__namespace.useRef(null);
    var _React$useState = React__namespace.useState(true),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      visibleState = _React$useState2[0],
      setVisibleState = _React$useState2[1];
    var _ChipBase$setMetaData = ChipBase.setMetaData({
        props: props
      }),
      ptm = _ChipBase$setMetaData.ptm,
      cx = _ChipBase$setMetaData.cx,
      isUnstyled = _ChipBase$setMetaData.isUnstyled;
    useHandleStyle(ChipBase.css.styles, isUnstyled, {
      name: 'chip'
    });
    var onKeyDown = function onKeyDown(event) {
      if (event.key === 'Enter' || event.key === 'Backspace') {
        close(event);
      }
    };
    var close = function close(event) {
      setVisibleState(false);
      if (props.onRemove) {
        props.onRemove({
          originalEvent: event,
          value: props.label || props.image || props.icon
        });
      }
    };
    var createContent = function createContent() {
      var content = [];
      var removeIconProps = mergeProps({
        key: 'removeIcon',
        role: 'button',
        tabIndex: 0,
        className: cx('removeIcon'),
        onClick: close,
        onKeyDown: onKeyDown
      }, ptm('removeIcon'));
      var icon = props.removeIcon || /*#__PURE__*/React__namespace.createElement(TimesCircleIcon, removeIconProps);
      if (props.image) {
        var imageProps = mergeProps({
          key: 'image',
          src: props.image,
          onError: props.onImageError
        }, ptm('image'));
        content.push( /*#__PURE__*/React__namespace.createElement("img", _extends({
          alt: props.imageAlt
        }, imageProps)));
      } else if (props.icon) {
        var chipIconProps = mergeProps({
          key: 'icon',
          className: cx('icon')
        }, ptm('icon'));
        content.push(IconUtils.getJSXIcon(props.icon, _objectSpread$1u({}, chipIconProps), {
          props: props
        }));
      }
      if (props.label) {
        var labelProps = mergeProps({
          key: 'label',
          className: cx('label')
        }, ptm('label'));
        content.push( /*#__PURE__*/React__namespace.createElement("span", labelProps, props.label));
      }
      if (props.removable) {
        content.push(IconUtils.getJSXIcon(icon, _objectSpread$1u({}, removeIconProps), {
          props: props
        }));
      }
      return content;
    };
    var createElement = function createElement() {
      var content = props.template ? ObjectUtils.getJSXElement(props.template, props) : createContent();
      var rootProps = mergeProps({
        ref: elementRef,
        style: props.style,
        className: classNames(props.className, cx('root')),
        'aria-label': props.label
      }, ChipBase.getOtherProps(props), ptm('root'));
      return /*#__PURE__*/React__namespace.createElement("div", rootProps, content);
    };
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        getElement: function getElement() {
          return elementRef.current;
        }
      };
    });
    return visibleState && createElement();
  }));
  Chip.displayName = 'Chip';

  var styles$S = "\n@layer primereact {\n    .p-chips {\n        display: inline-flex;\n    }\n    \n    .p-chips-multiple-container {\n        margin: 0;\n        padding: 0;\n        list-style-type: none;\n        cursor: text;\n        overflow: hidden;\n        display: flex;\n        align-items: center;\n        flex-wrap: wrap;\n    }\n    \n    .p-chips-token {\n        cursor: default;\n        display: inline-flex;\n        align-items: center;\n        flex: 0 0 auto;\n    }\n    \n    .p-chips-input-token {\n        flex: 1 1 auto;\n        display: inline-flex;\n    }\n    \n    .p-chips-token-icon {\n        cursor: pointer;\n    }\n    \n    .p-chips-input-token input {\n        border: 0 none;\n        outline: 0 none;\n        background-color: transparent;\n        margin: 0;\n        padding: 0;\n        box-shadow: none;\n        border-radius: 0;\n        width: 100%;\n    }\n    \n    .p-fluid .p-chips {\n        display: flex;\n    }\n    \n    .p-chips-icon-left,\n    .p-chips-icon-right {\n        position: relative;\n        display: inline-block;\n    }\n    \n    .p-chips-icon-left > i,\n    .p-chips-icon-right > i,\n    .p-chips-icon-left > svg,\n    .p-chips-icon-right > svg,\n    .p-chips-icon-left > .p-chips-prefix,\n    .p-chips-icon-right > .p-chips-suffix {\n        position: absolute;\n        top: 50%;\n        margin-top: -0.5rem;\n    }\n    \n    .p-fluid .p-chips-icon-left,\n    .p-fluid .p-chips-icon-right {\n        display: block;\n        width: 100%;\n    }\n}\n";
  var classes$X = {
    removeTokenIcon: 'p-chips-token-icon',
    label: 'p-chips-token-label',
    token: 'p-chips-token p-highlight',
    inputToken: 'p-chips-input-token',
    container: function container(_ref) {
      var props = _ref.props,
        focusedState = _ref.focusedState;
      return classNames('p-inputtext p-chips-multiple-container', {
        'p-disabled': props.disabled,
        'p-focus': focusedState
      });
    },
    root: function root(_ref2) {
      var isFilled = _ref2.isFilled,
        focusedState = _ref2.focusedState;
      return classNames('p-chips p-component p-inputwrapper', {
        'p-inputwrapper-filled': isFilled,
        'p-inputwrapper-focus': focusedState
      });
    }
  };
  var ChipsBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'Chips',
      addOnBlur: null,
      allowDuplicate: true,
      ariaLabelledBy: null,
      autoFocus: false,
      className: null,
      disabled: null,
      id: null,
      inputId: null,
      inputRef: null,
      itemTemplate: null,
      keyfilter: null,
      max: null,
      name: null,
      onAdd: null,
      onBlur: null,
      onChange: null,
      onFocus: null,
      onKeyDown: null,
      onRemove: null,
      placeholder: null,
      readOnly: false,
      removable: true,
      removeIcon: null,
      separator: null,
      style: null,
      tooltip: null,
      tooltipOptions: null,
      value: null,
      children: undefined
    },
    css: {
      classes: classes$X,
      styles: styles$S
    }
  });

  function ownKeys$1t(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1t(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1t(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1t(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var Chips = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var context = React__namespace.useContext(PrimeReactContext);
    var props = ChipsBase.getProps(inProps, context);
    var _React$useState = React__namespace.useState(false),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      focusedState = _React$useState2[0],
      setFocusedState = _React$useState2[1];
    var _ChipsBase$setMetaDat = ChipsBase.setMetaData({
        props: props,
        state: {
          focused: focusedState
        }
      }),
      ptm = _ChipsBase$setMetaDat.ptm,
      cx = _ChipsBase$setMetaDat.cx,
      isUnstyled = _ChipsBase$setMetaDat.isUnstyled;
    useHandleStyle(ChipsBase.css.styles, isUnstyled, {
      name: 'chips'
    });
    var elementRef = React__namespace.useRef(null);
    var listRef = React__namespace.useRef(null);
    var inputRef = React__namespace.useRef(props.inputRef);
    var removeItem = function removeItem(event, index) {
      if (props.disabled && props.readOnly) {
        return;
      }
      var values = _toConsumableArray(props.value);
      var removedItem = values.splice(index, 1);
      if (!isRemovable(removedItem, index)) {
        return;
      }
      if (props.onRemove) {
        props.onRemove({
          originalEvent: event,
          value: removedItem
        });
      }
      if (props.onChange) {
        props.onChange({
          originalEvent: event,
          value: values,
          stopPropagation: function stopPropagation() {
            event.stopPropagation();
          },
          preventDefault: function preventDefault() {
            event.preventDefault();
          },
          target: {
            name: props.name,
            id: props.id,
            value: values
          }
        });
      }
    };
    var addItem = function addItem(event, item, preventDefault) {
      if (item && item.trim().length) {
        var values = props.value ? _toConsumableArray(props.value) : [];
        if (props.allowDuplicate || values.indexOf(item) === -1) {
          var allowAddition = true;
          if (props.onAdd) {
            allowAddition = props.onAdd({
              originalEvent: event,
              value: item
            });
          }
          if (allowAddition !== false) {
            values.push(item);
          }
        }
        updateInput(event, values, preventDefault);
      }
    };
    var onWrapperClick = function onWrapperClick() {
      DomHandler.focus(inputRef.current);
    };
    var _onKeyDown = function onKeyDown(event) {
      var inputValue = event.target.value;
      var values = props.value || [];
      props.onKeyDown && props.onKeyDown(event);

      // do not continue if the user defined keydown wants to prevent
      if (event.defaultPrevented) {
        return;
      }
      switch (event.key) {
        case 'Backspace':
          if (inputRef.current.value.length === 0 && values.length > 0) {
            removeItem(event, values.length - 1);
          }
          break;
        case 'Enter':
          if (inputValue && inputValue.trim().length && (!props.max || props.max > values.length)) {
            addItem(event, inputValue, true);
          }
          break;
        default:
          if (props.keyfilter) {
            KeyFilter.onKeyPress(event, props.keyfilter);
          }
          if (isMaxedOut()) {
            event.preventDefault();
          } else if (props.separator === ',') {
            // GitHub #3885 Android Opera gives strange code 229 for comma
            if (event.key === props.separator || DomHandler.isAndroid() && event.which === 229) {
              addItem(event, inputValue, true);
            }
          }
          break;
      }
    };
    var updateInput = function updateInput(event, items, preventDefault) {
      if (props.onChange) {
        props.onChange({
          originalEvent: event,
          value: items,
          stopPropagation: function stopPropagation() {
            event.stopPropagation();
          },
          preventDefault: function preventDefault() {
            event.preventDefault();
          },
          target: {
            name: props.name,
            id: props.id,
            value: items
          }
        });
      }
      inputRef.current.value = '';
      preventDefault && event.preventDefault();
    };
    var _onPaste = function onPaste(event) {
      if (props.separator) {
        var pastedData = (event.clipboardData || window['clipboardData']).getData('Text');
        if (props.keyfilter) {
          KeyFilter.onPaste(event, props.keyfilter);
        }
        if (pastedData) {
          var values = props.value || [];
          var pastedValues = pastedData.split(props.separator);
          pastedValues = pastedValues.filter(function (val) {
            return (props.allowDuplicate || values.indexOf(val) === -1) && val.trim().length;
          });
          values = [].concat(_toConsumableArray(values), _toConsumableArray(pastedValues));
          updateInput(event, values, true);
        }
      }
    };
    var _onFocus = function onFocus(event) {
      setFocusedState(true);
      props.onFocus && props.onFocus(event);
    };
    var _onBlur = function onBlur(event) {
      if (props.addOnBlur) {
        var inputValue = event.target.value;
        var values = props.value || [];
        if (inputValue && inputValue.trim().length && (!props.max || props.max > values.length)) {
          addItem(event, inputValue, true);
        }
      }
      setFocusedState(false);
      props.onBlur && props.onBlur(event);
    };
    var isMaxedOut = function isMaxedOut() {
      return props.max && props.value && props.max === props.value.length;
    };
    var currentValue = inputRef.current && inputRef.current.value;
    var isFilled = React__namespace.useMemo(function () {
      return ObjectUtils.isNotEmpty(props.value) || ObjectUtils.isNotEmpty(currentValue);
    }, [props.value, currentValue]);
    var isRemovable = function isRemovable(value, index) {
      return ObjectUtils.getPropValue(props.removable, {
        value: value,
        index: index,
        props: props
      });
    };
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        focus: function focus() {
          return DomHandler.focus(inputRef.current);
        },
        getElement: function getElement() {
          return elementRef.current;
        },
        getInput: function getInput() {
          return inputRef.current;
        }
      };
    });
    React__namespace.useEffect(function () {
      ObjectUtils.combinedRefs(inputRef, props.inputRef);
    }, [inputRef, props.inputRef]);
    useMountEffect(function () {
      if (props.autoFocus) {
        DomHandler.focus(inputRef.current, props.autoFocus);
      }
    });
    var createRemoveIcon = function createRemoveIcon(value, index) {
      var iconProps = mergeProps({
        className: cx('removeTokenIcon'),
        onClick: function onClick(event) {
          return removeItem(event, index);
        },
        'aria-hidden': 'true'
      }, ptm('removeTokenIcon'));
      var icon = props.removeIcon || /*#__PURE__*/React__namespace.createElement(TimesCircleIcon, iconProps);
      var removeIcon = IconUtils.getJSXIcon(icon, _objectSpread$1t({}, iconProps), {
        props: props
      });
      if (!props.disabled && !props.readOnly && isRemovable(value, index)) {
        return removeIcon;
      }
      return null;
    };
    var createItem = function createItem(value, index) {
      var content = props.itemTemplate ? props.itemTemplate(value) : value;
      var labelProps = mergeProps({
        className: cx('label')
      }, ptm('label'));
      var label = /*#__PURE__*/React__namespace.createElement("span", labelProps, content);
      var icon = createRemoveIcon(value, index);
      var tokenProps = mergeProps({
        key: index,
        className: cx('token'),
        'data-p-highlight': true
      }, ptm('token'));
      return /*#__PURE__*/React__namespace.createElement("li", tokenProps, label, icon);
    };
    var createInput = function createInput() {
      var inputTokenProps = mergeProps({
        className: cx('inputToken')
      }, ptm('inputToken'));
      var inputProps = mergeProps(_objectSpread$1t({
        id: props.inputId,
        ref: inputRef,
        placeholder: props.placeholder,
        type: 'text',
        name: props.name,
        disabled: props.disabled || isMaxedOut(),
        onKeyDown: function onKeyDown(e) {
          return _onKeyDown(e);
        },
        onPaste: function onPaste(e) {
          return _onPaste(e);
        },
        onFocus: function onFocus(e) {
          return _onFocus(e);
        },
        onBlur: function onBlur(e) {
          return _onBlur(e);
        },
        readOnly: props.readOnly
      }, ariaProps), ptm('input'));
      return /*#__PURE__*/React__namespace.createElement("li", inputTokenProps, /*#__PURE__*/React__namespace.createElement("input", inputProps));
    };
    var createItems = function createItems() {
      return props.value ? props.value.map(createItem) : null;
    };
    var createList = function createList() {
      var items = createItems();
      var input = createInput();
      var containerProps = mergeProps({
        ref: listRef,
        className: cx('container', {
          focusedState: focusedState
        }),
        onClick: function onClick(e) {
          return onWrapperClick();
        },
        'data-p-disabled': props.disabled,
        'data-p-focus': focusedState
      }, ptm('container'));
      return /*#__PURE__*/React__namespace.createElement("ul", containerProps, items, input);
    };
    var hasTooltip = ObjectUtils.isNotEmpty(props.tooltip);
    var otherProps = ChipsBase.getOtherProps(props);
    var ariaProps = ObjectUtils.reduceKeys(otherProps, DomHandler.ARIA_PROPS);
    var list = createList();
    var rootProps = mergeProps({
      id: props.id,
      ref: elementRef,
      className: classNames(props.className, cx('root', {
        isFilled: isFilled,
        focusedState: focusedState
      })),
      style: props.style
    }, ptm('root'));
    return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, null, /*#__PURE__*/React__namespace.createElement("div", rootProps, list), hasTooltip && /*#__PURE__*/React__namespace.createElement(Tooltip, _extends({
      target: inputRef,
      content: props.tooltip
    }, props.tooltipOptions, {
      pt: ptm('tooltip')
    })));
  }));
  Chips.displayName = 'Chips';

  var classes$W = {
    root: function root(_ref) {
      var props = _ref.props;
      return classNames('p-colorpicker p-component', {
        'p-colorpicker-overlay': !props.inline
      }, props.className);
    },
    input: function input(_ref2) {
      var props = _ref2.props;
      return classNames('p-colorpicker-preview p-inputtext', props.inputClassName, {
        'p-disabled': props.disabled
      });
    },
    panel: function panel(_ref3) {
      var panelProps = _ref3.panelProps,
        context = _ref3.context;
      return classNames('p-colorpicker-panel', panelProps.panelClassName, {
        'p-colorpicker-overlay-panel': !panelProps.inline,
        'p-disabled': panelProps.disabled,
        'p-input-filled': context && context.inputStyle === 'filled' || PrimeReact.inputStyle === 'filled',
        'p-ripple-disabled': context && context.ripple === false || PrimeReact.ripple === false
      });
    },
    content: 'p-colorpicker-content',
    hueHandle: 'p-colorpicker-hue-handle',
    hue: 'p-colorpicker-hue',
    colorHandle: 'p-colorpicker-color-handle',
    color: 'p-colorpicker-color',
    selector: 'p-colorpicker-color-selector',
    transition: 'p-connected-overlay'
  };
  var styles$R = "\n@layer primereact {\n    .p-colorpicker {\n        display: inline-block;\n    }\n    \n    .p-colorpicker-dragging {\n        cursor: pointer;\n    }\n    \n    .p-colorpicker-overlay {\n        position: relative;\n    }\n    \n    .p-colorpicker-panel {\n        position: relative;\n        width: 193px;\n        height: 166px;\n    }\n    \n    .p-colorpicker-overlay-panel {\n        position: absolute;\n        top: 0;\n        left: 0;\n    }\n    \n    .p-colorpicker-preview {\n        cursor: pointer;\n    }\n    \n    .p-colorpicker-panel .p-colorpicker-content {\n        position: relative;\n    }\n    \n    .p-colorpicker-panel .p-colorpicker-color-selector {\n        width: 150px;\n        height: 150px;\n        top: 8px;\n        left: 8px;\n        position: absolute;\n    }\n    \n    .p-colorpicker-panel .p-colorpicker-color {\n        width: 150px;\n        height: 150px;\n    }\n    \n    .p-colorpicker-panel .p-colorpicker-color-handle {\n        position: absolute;\n        top: 0px;\n        left: 150px;\n        border-radius: 100%;\n        width: 10px;\n        height: 10px;\n        border-width: 1px;\n        border-style: solid;\n        margin: -5px 0 0 -5px;\n        cursor: pointer;\n        opacity: 0.85;\n    }\n    \n    .p-colorpicker-panel .p-colorpicker-hue {\n        width: 17px;\n        height: 150px;\n        top: 8px;\n        left: 167px;\n        position: absolute;\n        opacity: 0.85;\n    }\n    \n    .p-colorpicker-panel .p-colorpicker-hue-handle {\n        position: absolute;\n        top: 150px;\n        left: 0px;\n        width: 21px;\n        margin-left: -2px;\n        margin-top: -5px;\n        height: 10px;\n        border-width: 2px;\n        border-style: solid;\n        opacity: 0.85;\n        cursor: pointer;\n    }\n    \n    .p-colorpicker-panel .p-colorpicker-color {\n        background: linear-gradient(to top, #000 0%, rgb(0 0 0 / 0) 100%), linear-gradient(to right, #fff 0%, rgb(255 255 255 / 0) 100%)\n    }\n    .p-colorpicker-panel .p-colorpicker-hue {\n        background: linear-gradient(0deg, red 0, #ff0 17%, #0f0 33%, #0ff 50%, #00f 67%, #f0f 83%, red)\n    }\n}\n";
  var ColorPickerBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'ColorPicker',
      appendTo: null,
      autoFocus: false,
      children: undefined,
      className: null,
      defaultColor: 'ff0000',
      disabled: false,
      format: 'hex',
      id: null,
      inline: false,
      inputClassName: null,
      inputId: null,
      inputRef: null,
      inputStyle: null,
      onChange: null,
      onHide: null,
      onShow: null,
      panelClassName: null,
      panelStyle: null,
      style: null,
      tabIndex: null,
      tooltip: null,
      tooltipOptions: null,
      transitionOptions: null,
      value: null
    },
    css: {
      classes: classes$W,
      styles: styles$R
    }
  });

  var ColorPickerPanel = /*#__PURE__*/React__namespace.forwardRef(function (props, ref) {
    var context = React__namespace.useContext(PrimeReactContext);
    var ptm = props.ptm,
      cx = props.cx;
    var createElement = function createElement() {
      var panelProps = mergeProps({
        className: cx('panel', {
          panelProps: props,
          context: context
        }),
        style: props.panelStyle,
        onClick: props.onClick
      }, ptm('panel', {
        hostName: props.hostName
      }));
      var transitionProps = mergeProps({
        classNames: cx('transition'),
        "in": props["in"],
        timeout: {
          enter: 120,
          exit: 100
        },
        options: props.transitionOptions,
        unmountOnExit: true,
        onEnter: props.onEnter,
        onEntered: props.onEntered,
        onExit: props.onExit,
        onExited: props.onExited
      }, ptm('transition', {
        hostName: props.hostName
      }));
      return /*#__PURE__*/React__namespace.createElement(CSSTransition, _extends({
        nodeRef: ref
      }, transitionProps), /*#__PURE__*/React__namespace.createElement("div", _extends({
        ref: ref
      }, panelProps), props.children));
    };
    var element = createElement();
    return props.inline ? element : /*#__PURE__*/React__namespace.createElement(Portal, {
      element: element,
      appendTo: props.appendTo
    });
  });
  ColorPickerPanel.displayName = 'ColorPickerPanel';

  function ownKeys$1s(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1s(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1s(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1s(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var ColorPicker = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var context = React__namespace.useContext(PrimeReactContext);
    var props = ColorPickerBase.getProps(inProps, context);
    var _React$useState = React__namespace.useState(false),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      overlayVisibleState = _React$useState2[0],
      setOverlayVisibleState = _React$useState2[1];
    var _ColorPickerBase$setM = ColorPickerBase.setMetaData({
        props: props,
        state: {
          overlayVisible: overlayVisibleState
        }
      }),
      ptm = _ColorPickerBase$setM.ptm,
      cx = _ColorPickerBase$setM.cx,
      isUnstyled = _ColorPickerBase$setM.isUnstyled;
    useHandleStyle(ColorPickerBase.css.styles, isUnstyled, {
      name: 'colorpicker'
    });
    var elementRef = React__namespace.useRef(null);
    var overlayRef = React__namespace.useRef(null);
    var inputRef = React__namespace.useRef(props.inputRef);
    var colorSelectorRef = React__namespace.useRef(null);
    var colorHandleRef = React__namespace.useRef(null);
    var hueHandleRef = React__namespace.useRef(null);
    var hueViewRef = React__namespace.useRef(null);
    var hueDragging = React__namespace.useRef(false);
    var hsbValue = React__namespace.useRef(null);
    var colorDragging = React__namespace.useRef(false);
    var _useOverlayListener = useOverlayListener({
        target: elementRef,
        overlay: overlayRef,
        listener: function listener(event, _ref) {
          var valid = _ref.valid;
          valid && hide();
        },
        when: overlayVisibleState
      }),
      _useOverlayListener2 = _slicedToArray(_useOverlayListener, 2),
      bindOverlayListener = _useOverlayListener2[0],
      unbindOverlayListener = _useOverlayListener2[1];
    var _useEventListener = useEventListener({
        type: 'mousemove',
        listener: function listener(event) {
          colorDragging.current && pickColor(event);
          hueDragging.current && pickHue(event);
        }
      }),
      _useEventListener2 = _slicedToArray(_useEventListener, 2),
      bindDocumentMouseMoveListener = _useEventListener2[0],
      unbindDocumentMouseMoveListener = _useEventListener2[1];
    var _useEventListener3 = useEventListener({
        type: 'mouseup',
        listener: function listener() {
          colorDragging.current = hueDragging.current = false;
          DomHandler.removeClass(elementRef.current, 'p-colorpicker-dragging');
          unbindDocumentMouseMoveListener();
          unbindDocumentMouseUpListener();
        }
      }),
      _useEventListener4 = _slicedToArray(_useEventListener3, 2),
      bindDocumentMouseUpListener = _useEventListener4[0],
      unbindDocumentMouseUpListener = _useEventListener4[1];
    var onPanelClick = function onPanelClick(event) {
      if (!props.inline) {
        OverlayService.emit('overlay-click', {
          originalEvent: event,
          target: elementRef.current
        });
      }
    };
    var onHueMousedown = function onHueMousedown(event) {
      if (props.disabled) {
        return;
      }
      bindDragListeners();
      onHueDragStart(event);
    };
    var onHueDragStart = function onHueDragStart(event) {
      if (props.disabled) {
        return;
      }
      hueDragging.current = true;
      pickHue(event);
      !isUnstyled && DomHandler.addClass(elementRef.current, 'p-colorpicker-dragging');
    };
    var pickHue = function pickHue(event) {
      var top = hueViewRef.current.getBoundingClientRect().top + (window.pageYOffset || document.documentElement.scrollTop || document.body.scrollTop || 0);
      hsbValue.current = validateHSB({
        h: Math.floor(360 * (150 - Math.max(0, Math.min(150, (event.pageY || event.changedTouches[0].pageY) - top))) / 150),
        s: 100,
        b: 100
      });
      updateColorSelector();
      updateHue();
      updateModel();
    };
    var onColorMousedown = function onColorMousedown(event) {
      if (props.disabled) {
        return;
      }
      bindDragListeners();
      onColorDragStart(event);
    };
    var onColorDragStart = function onColorDragStart(event) {
      if (props.disabled) {
        return;
      }
      colorDragging.current = true;
      pickColor(event);
      !isUnstyled && DomHandler.addClass(elementRef.current, 'p-colorpicker-dragging');
      event.preventDefault();
    };
    var onDrag = function onDrag(event) {
      if (colorDragging.current) {
        pickColor(event);
        event.preventDefault();
      }
      if (hueDragging.current) {
        pickHue(event);
        event.preventDefault();
      }
    };
    var onDragEnd = function onDragEnd() {
      colorDragging.current = false;
      hueDragging.current = false;
      !isUnstyled && DomHandler.removeClass(elementRef.current, 'p-colorpicker-dragging');
      unbindDragListeners();
    };
    var bindDragListeners = function bindDragListeners() {
      bindDocumentMouseMoveListener();
      bindDocumentMouseUpListener();
    };
    var unbindDragListeners = function unbindDragListeners() {
      unbindDocumentMouseMoveListener();
      unbindDocumentMouseUpListener();
    };
    var pickColor = function pickColor(event) {
      var rect = colorSelectorRef.current.getBoundingClientRect();
      var top = rect.top + (window.pageYOffset || document.documentElement.scrollTop || document.body.scrollTop || 0);
      var left = rect.left + document.body.scrollLeft;
      var saturation = Math.floor(100 * Math.max(0, Math.min(150, (event.pageX || event.changedTouches[0].pageX) - left)) / 150);
      var brightness = Math.floor(100 * (150 - Math.max(0, Math.min(150, (event.pageY || event.changedTouches[0].pageY) - top))) / 150);
      hsbValue.current = validateHSB({
        h: hsbValue.current.h,
        s: saturation,
        b: brightness
      });
      updateColorHandle();
      updateInput();
      updateModel();
    };
    var updateModel = function updateModel() {
      switch (props.format) {
        case 'hex':
          onChange(HSBtoHEX(hsbValue.current));
          break;
        case 'rgb':
          onChange(HSBtoRGB(hsbValue.current));
          break;
        case 'hsb':
          onChange(hsbValue.current);
          break;
      }
    };
    var toHSB = function toHSB(value) {
      var hsb;
      if (value) {
        switch (props.format) {
          case 'hex':
            hsb = HEXtoHSB(value);
            break;
          case 'rgb':
            hsb = RGBtoHSB(value);
            break;
          case 'hsb':
            hsb = value;
            break;
        }
      } else {
        hsb = HEXtoHSB(props.defaultColor);
      }
      return hsb;
    };
    var updateHSBValue = function updateHSBValue(value) {
      hsbValue.current = toHSB(value);
    };
    var onChange = function onChange(value) {
      if (props.onChange) {
        props.onChange({
          value: value,
          stopPropagation: function stopPropagation() {},
          preventDefault: function preventDefault() {},
          target: {
            name: props.name,
            id: props.id,
            value: value
          }
        });
      }
    };
    var updateColorSelector = function updateColorSelector() {
      if (colorSelectorRef.current) {
        var newHsbValue = validateHSB({
          h: hsbValue.current.h,
          s: 100,
          b: 100
        });
        colorSelectorRef.current.style.backgroundColor = '#' + HSBtoHEX(newHsbValue);
      }
    };
    var updateColorHandle = function updateColorHandle() {
      if (colorHandleRef.current) {
        colorHandleRef.current.style.left = Math.floor(150 * hsbValue.current.s / 100) + 'px';
        colorHandleRef.current.style.top = Math.floor(150 * (100 - hsbValue.current.b) / 100) + 'px';
      }
    };
    var updateHue = function updateHue() {
      if (hueHandleRef.current) {
        hueHandleRef.current.style.top = Math.floor(150 - 150 * hsbValue.current.h / 360) + 'px';
      }
    };
    var updateInput = function updateInput() {
      if (inputRef.current) {
        inputRef.current.style.backgroundColor = '#' + HSBtoHEX(hsbValue.current);
      }
    };
    var show = function show() {
      setOverlayVisibleState(true);
    };
    var hide = function hide() {
      setOverlayVisibleState(false);
    };
    var onOverlayEnter = function onOverlayEnter() {
      var styles = !props.inline ? {
        position: 'absolute',
        top: '0',
        left: '0'
      } : undefined;
      ZIndexUtils.set('overlay', overlayRef.current, context && context.autoZIndex || PrimeReact.autoZIndex, context && context.zIndex['overlay'] || PrimeReact.zIndex['overlay']);
      DomHandler.addStyles(overlayRef.current, styles);
      alignOverlay();
    };
    var onOverlayEntered = function onOverlayEntered() {
      bindOverlayListener();
      props.onShow && props.onShow();
    };
    var onOverlayExit = function onOverlayExit() {
      unbindOverlayListener();
    };
    var onOverlayExited = function onOverlayExited() {
      ZIndexUtils.clear(overlayRef.current);
      props.onHide && props.onHide();
    };
    var onInputClick = function onInputClick() {
      togglePanel();
    };
    var togglePanel = function togglePanel() {
      overlayVisibleState ? hide() : show();
    };
    var onInputKeydown = function onInputKeydown(event) {
      switch (event.which) {
        //space
        case 32:
          togglePanel();
          event.preventDefault();
          break;

        //escape and tab
        case 27:
        case 9:
          hide();
          break;
      }
    };
    var validateHSB = function validateHSB(hsb) {
      return {
        h: Math.min(360, Math.max(0, hsb.h)),
        s: Math.min(100, Math.max(0, hsb.s)),
        b: Math.min(100, Math.max(0, hsb.b))
      };
    };
    var HEXtoRGB = function HEXtoRGB(hex) {
      var hexValue = parseInt(hex.indexOf('#') > -1 ? hex.substring(1) : hex, 16);
      return {
        r: hexValue >> 16,
        g: (hexValue & 0x00ff00) >> 8,
        b: hexValue & 0x0000ff
      };
    };
    var HEXtoHSB = function HEXtoHSB(hex) {
      return RGBtoHSB(HEXtoRGB(hex));
    };
    var RGBtoHSB = function RGBtoHSB(rgb) {
      var hsb = {
        h: 0,
        s: 0,
        b: 0
      };
      var min = Math.min(rgb.r, rgb.g, rgb.b);
      var max = Math.max(rgb.r, rgb.g, rgb.b);
      var delta = max - min;
      hsb.b = max;
      hsb.s = max !== 0 ? 255 * delta / max : 0;
      if (hsb.s !== 0) {
        if (rgb.r === max) {
          hsb.h = (rgb.g - rgb.b) / delta;
        } else if (rgb.g === max) {
          hsb.h = 2 + (rgb.b - rgb.r) / delta;
        } else {
          hsb.h = 4 + (rgb.r - rgb.g) / delta;
        }
      } else {
        hsb.h = -1;
      }
      hsb.h *= 60;
      if (hsb.h < 0) {
        hsb.h += 360;
      }
      hsb.s *= 100 / 255;
      hsb.b *= 100 / 255;
      return hsb;
    };
    var HSBtoRGB = function HSBtoRGB(hsb) {
      var rgb = {
        r: null,
        g: null,
        b: null
      };
      var h = Math.round(hsb.h);
      var s = Math.round(hsb.s * 255 / 100);
      var v = Math.round(hsb.b * 255 / 100);
      if (s === 0) {
        rgb = {
          r: v,
          g: v,
          b: v
        };
      } else {
        var t1 = v;
        var t2 = (255 - s) * v / 255;
        var t3 = (t1 - t2) * (h % 60) / 60;
        if (h === 360) h = 0;
        if (h < 60) {
          rgb.r = t1;
          rgb.b = t2;
          rgb.g = t2 + t3;
        } else if (h < 120) {
          rgb.g = t1;
          rgb.b = t2;
          rgb.r = t1 - t3;
        } else if (h < 180) {
          rgb.g = t1;
          rgb.r = t2;
          rgb.b = t2 + t3;
        } else if (h < 240) {
          rgb.b = t1;
          rgb.r = t2;
          rgb.g = t1 - t3;
        } else if (h < 300) {
          rgb.b = t1;
          rgb.g = t2;
          rgb.r = t2 + t3;
        } else if (h < 360) {
          rgb.r = t1;
          rgb.g = t2;
          rgb.b = t1 - t3;
        } else {
          rgb.r = 0;
          rgb.g = 0;
          rgb.b = 0;
        }
      }
      return {
        r: Math.round(rgb.r),
        g: Math.round(rgb.g),
        b: Math.round(rgb.b)
      };
    };
    var RGBtoHEX = function RGBtoHEX(rgb) {
      var hex = [rgb.r.toString(16), rgb.g.toString(16), rgb.b.toString(16)];
      for (var key in hex) {
        if (hex[key].length === 1) {
          hex[key] = '0' + hex[key];
        }
      }
      return hex.join('');
    };
    var HSBtoHEX = function HSBtoHEX(hsb) {
      return RGBtoHEX(HSBtoRGB(hsb));
    };
    var updateUI = function updateUI() {
      updateHue();
      updateColorHandle();
      updateInput();
      updateColorSelector();
    };
    var alignOverlay = function alignOverlay() {
      if (inputRef.current) {
        DomHandler.alignOverlay(overlayRef.current, inputRef.current.parentElement, props.appendTo || context && context.appendTo || PrimeReact.appendTo);
      }
    };
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        show: show,
        hide: hide,
        focus: function focus() {
          return DomHandler.focus(inputRef.current);
        },
        getElement: function getElement() {
          return elementRef.current;
        },
        getOverlay: function getOverlay() {
          return overlayRef.current;
        },
        getInput: function getInput() {
          return inputRef.current;
        }
      };
    });
    React__namespace.useEffect(function () {
      ObjectUtils.combinedRefs(inputRef, props.inputRef);
    }, [inputRef, props.inputRef]);
    useMountEffect(function () {
      updateHSBValue(props.value);
      updateUI();
      if (props.autoFocus) {
        DomHandler.focus(inputRef.current, props.autoFocus);
      }
      alignOverlay();
    });
    useUpdateEffect(function () {
      if (!colorDragging.current && !hueDragging.current) {
        updateHSBValue(props.value);
      }
    }, [props.value]);
    useUpdateEffect(function () {
      updateUI();
    });
    useUnmountEffect(function () {
      ZIndexUtils.clear(overlayRef.current);
    });
    var createColorSelector = function createColorSelector() {
      var selectorProps = mergeProps({
        ref: colorSelectorRef,
        className: cx('selector'),
        onMouseDown: function onMouseDown(e) {
          return onColorMousedown(e);
        },
        onTouchStart: function onTouchStart(e) {
          return onColorDragStart(e);
        },
        onTouchMove: function onTouchMove(e) {
          return onDrag(e);
        },
        onTouchEnd: onDragEnd
      }, ptm('selector'));
      var colorProps = mergeProps({
        className: cx('color')
      }, ptm('color'));
      var colorHandlerProps = mergeProps({
        ref: colorHandleRef,
        className: cx('colorHandle')
      }, ptm('colorHandle'));
      return /*#__PURE__*/React__namespace.createElement("div", selectorProps, /*#__PURE__*/React__namespace.createElement("div", colorProps, /*#__PURE__*/React__namespace.createElement("div", colorHandlerProps)));
    };
    var createHue = function createHue() {
      var hueProps = mergeProps({
        className: cx('hue'),
        onMouseDown: function onMouseDown(e) {
          return onHueMousedown(e);
        },
        onTouchStart: function onTouchStart(e) {
          return onHueDragStart(e);
        },
        onTouchMove: function onTouchMove(e) {
          return onDrag(e);
        },
        onTouchEnd: onDragEnd
      }, ptm('hue'));
      var hueHandlerProps = mergeProps({
        className: cx('hueHandle')
      }, ptm('hueHandle'));
      return /*#__PURE__*/React__namespace.createElement("div", _extends({
        ref: hueViewRef
      }, hueProps), /*#__PURE__*/React__namespace.createElement("div", _extends({
        ref: hueHandleRef
      }, hueHandlerProps)));
    };
    var createContent = function createContent() {
      var colorSelector = createColorSelector();
      var hue = createHue();
      var contentProps = mergeProps({
        className: cx('content')
      }, ptm('content'));
      return /*#__PURE__*/React__namespace.createElement("div", contentProps, colorSelector, hue);
    };
    var createInput = function createInput() {
      if (!props.inline) {
        var inputProps = ColorPickerBase.getOtherProps(props);
        var _inputProps = mergeProps(_objectSpread$1s({
          ref: inputRef,
          type: 'text',
          readOnly: true,
          className: cx('input'),
          style: props.inputStyle,
          id: props.inputId,
          tabIndex: props.tabIndex,
          disabled: props.disabled,
          onClick: onInputClick,
          onKeyDown: onInputKeydown
        }, inputProps), ptm('input'));
        return /*#__PURE__*/React__namespace.createElement("input", _inputProps);
      }
      return null;
    };
    var hasTooltip = ObjectUtils.isNotEmpty(props.tooltip);
    var content = createContent();
    var input = createInput();
    var rootProps = mergeProps({
      id: props.id,
      ref: elementRef,
      style: props.style,
      className: cx('root')
    }, ColorPickerBase.getOtherProps(props), ptm('root'));
    return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, null, /*#__PURE__*/React__namespace.createElement("div", rootProps, input, /*#__PURE__*/React__namespace.createElement(ColorPickerPanel, {
      hostName: "ColorPicker",
      ref: overlayRef,
      appendTo: props.appendTo,
      inline: props.inline,
      disabled: props.disabled,
      panelStyle: props.panelStyle,
      panelClassName: props.panelClassName,
      onClick: onPanelClick,
      "in": props.inline || overlayVisibleState,
      onEnter: onOverlayEnter,
      onEntered: onOverlayEntered,
      onExit: onOverlayExit,
      onExited: onOverlayExited,
      transitionOptions: props.transitionOptions,
      ptm: ptm,
      cx: cx
    }, content)), hasTooltip && /*#__PURE__*/React__namespace.createElement(Tooltip, _extends({
      target: elementRef,
      content: props.tooltip
    }, props.tooltipOptions, {
      pt: ptm('tooltip')
    })));
  }));
  ColorPicker.displayName = 'ColorPicker';

  var Column = function Column() {};
  //@todo Pass Parent MetaData

  Column.displayName = 'Column';

  var ColumnGroup = function ColumnGroup() {};
  ColumnGroup.displayName = 'ColumnGroup';

  function ownKeys$1r(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1r(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1r(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1r(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var classes$V = {
    closeButtonIcon: 'p-dialog-header-close-icon',
    closeButton: 'p-dialog-header-icon p-dialog-header-close p-link',
    maximizableIcon: 'p-dialog-header-maximize-icon',
    maximizableButton: 'p-dialog-header-icon p-dialog-header-maximize p-link',
    header: function header(_ref) {
      var props = _ref.props;
      return classNames('p-dialog-header', props.headerClassName);
    },
    headerTitle: 'p-dialog-title',
    headerIcons: 'p-dialog-header-icons',
    content: function content(_ref2) {
      var props = _ref2.props;
      return classNames('p-dialog-content', props.contentClassName);
    },
    footer: function footer(_ref3) {
      var props = _ref3.props;
      return classNames('p-dialog-footer', props.footerClassName);
    },
    mask: function mask(_ref4) {
      var props = _ref4.props,
        maskVisibleState = _ref4.maskVisibleState;
      var positions = ['center', 'left', 'right', 'top', 'top-left', 'top-right', 'bottom', 'bottom-left', 'bottom-right'];
      var pos = positions.find(function (item) {
        return item === props.position || item.replace('-', '') === props.position;
      });
      return classNames('p-dialog-mask', pos ? "p-dialog-".concat(pos) : '', {
        'p-component-overlay p-component-overlay-enter': props.modal,
        'p-dialog-visible': maskVisibleState,
        'p-dialog-draggable': props.draggable,
        'p-dialog-resizable': props.resizable
      }, props.maskClassName);
    },
    root: function root(_ref5) {
      var props = _ref5.props,
        maximized = _ref5.maximized,
        context = _ref5.context;
      return classNames('p-dialog p-component', props.className, {
        'p-dialog-rtl': props.rtl,
        'p-dialog-maximized': maximized,
        'p-dialog-default': !maximized,
        'p-input-filled': context && context.inputStyle === 'filled' || PrimeReact.inputStyle === 'filled',
        'p-ripple-disabled': context && context.ripple === false || PrimeReact.ripple === false
      });
    },
    transition: 'p-dialog'
  };
  var styles$Q = "\n@layer primereact {\n    .p-dialog-mask {\n        background-color: transparent;\n        transition-property: background-color;\n    }\n    \n    .p-dialog-visible {\n        display: flex;\n    }\n    \n    .p-dialog-mask.p-component-overlay {\n        pointer-events: auto;\n    }\n    \n    .p-dialog {\n        display: flex;\n        flex-direction: column;\n        pointer-events: auto;\n        max-height: 90%;\n        transform: scale(1);\n        position: relative;\n    }\n    \n    .p-dialog-content {\n        overflow-y: auto;\n        flex-grow: 1;\n    }\n    \n    .p-dialog-header {\n        display: flex;\n        align-items: center;\n        flex-shrink: 0;\n    }\n    \n    .p-dialog-footer {\n        flex-shrink: 0;\n    }\n    \n    .p-dialog .p-dialog-header-icons {\n        display: flex;\n        align-items: center;\n        align-self: flex-start;\n        flex-shrink: 0;\n    }\n    \n    .p-dialog .p-dialog-header-icon {\n        display: flex;\n        align-items: center;\n        justify-content: center;\n        overflow: hidden;\n        position: relative;\n    }\n    \n    .p-dialog .p-dialog-title {\n        flex-grow: 1;\n    }\n    \n    /* Fluid */\n    .p-fluid .p-dialog-footer .p-button {\n        width: auto;\n    }\n    \n    /* Animation */\n    /* Center */\n    .p-dialog-enter {\n        opacity: 0;\n        transform: scale(0.7);\n    }\n    \n    .p-dialog-enter-active {\n        opacity: 1;\n        transform: scale(1);\n        transition: all 150ms cubic-bezier(0, 0, 0.2, 1);\n    }\n    \n    .p-dialog-enter-done {\n        transform: none;\n    }\n    \n    .p-dialog-exit-active {\n        opacity: 0;\n        transform: scale(0.7);\n        transition: all 150ms cubic-bezier(0.4, 0, 0.2, 1);\n    }\n    \n    /* Top, Bottom, Left, Right, Top* and Bottom* */\n    .p-dialog-top .p-dialog,\n    .p-dialog-bottom .p-dialog,\n    .p-dialog-left .p-dialog,\n    .p-dialog-right .p-dialog,\n    .p-dialog-top-left .p-dialog,\n    .p-dialog-top-right .p-dialog,\n    .p-dialog-bottom-left .p-dialog,\n    .p-dialog-bottom-right .p-dialog {\n        margin: 0.75em;\n    }\n    \n    .p-dialog-top .p-dialog-enter,\n    .p-dialog-top .p-dialog-exit-active {\n        transform: translate3d(0px, -100%, 0px);\n    }\n    \n    .p-dialog-bottom .p-dialog-enter,\n    .p-dialog-bottom .p-dialog-exit-active {\n        transform: translate3d(0px, 100%, 0px);\n    }\n    \n    .p-dialog-left .p-dialog-enter,\n    .p-dialog-left .p-dialog-exit-active,\n    .p-dialog-top-left .p-dialog-enter,\n    .p-dialog-top-left .p-dialog-exit-active,\n    .p-dialog-bottom-left .p-dialog-enter,\n    .p-dialog-bottom-left .p-dialog-exit-active {\n        transform: translate3d(-100%, 0px, 0px);\n    }\n    \n    .p-dialog-right .p-dialog-enter,\n    .p-dialog-right .p-dialog-exit-active,\n    .p-dialog-top-right .p-dialog-enter,\n    .p-dialog-top-right .p-dialog-exit-active,\n    .p-dialog-bottom-right .p-dialog-enter,\n    .p-dialog-bottom-right .p-dialog-exit-active {\n        transform: translate3d(100%, 0px, 0px);\n    }\n    \n    .p-dialog-top .p-dialog-enter-active,\n    .p-dialog-bottom .p-dialog-enter-active,\n    .p-dialog-left .p-dialog-enter-active,\n    .p-dialog-top-left .p-dialog-enter-active,\n    .p-dialog-bottom-left .p-dialog-enter-active,\n    .p-dialog-right .p-dialog-enter-active,\n    .p-dialog-top-right .p-dialog-enter-active,\n    .p-dialog-bottom-right .p-dialog-enter-active {\n        transform: translate3d(0px, 0px, 0px);\n        transition: all 0.3s ease-out;\n    }\n    \n    .p-dialog-top .p-dialog-exit-active,\n    .p-dialog-bottom .p-dialog-exit-active,\n    .p-dialog-left .p-dialog-exit-active,\n    .p-dialog-top-left .p-dialog-exit-active,\n    .p-dialog-bottom-left .p-dialog-exit-active,\n    .p-dialog-right .p-dialog-exit-active,\n    .p-dialog-top-right .p-dialog-exit-active,\n    .p-dialog-bottom-right .p-dialog-exit-active {\n        transition: all 0.3s ease-out;\n    }\n    \n    /* Maximize */\n    .p-dialog-maximized {\n        transition: none;\n        transform: none;\n        margin: 0;\n        width: 100vw !important;\n        height: 100vh !important;\n        max-height: 100%;\n        top: 0px !important;\n        left: 0px !important;\n    }\n    \n    .p-dialog-maximized .p-dialog-content {\n        flex-grow: 1;\n    }\n    \n    .p-confirm-dialog .p-dialog-content {\n        display: flex;\n        align-items: center;\n    }\n    \n    /* Resizable */\n    .p-dialog .p-resizable-handle {\n        position: absolute;\n        font-size: 0.1px;\n        display: block;\n        cursor: se-resize;\n        width: 12px;\n        height: 12px;\n        right: 1px;\n        bottom: 1px;\n    }\n    \n    .p-dialog-draggable .p-dialog-header {\n        cursor: move;\n    }        \n}\n";
  var inlineStyles$k = {
    mask: function mask(_ref6) {
      var props = _ref6.props;
      return _objectSpread$1r({
        position: 'fixed',
        height: '100%',
        width: '100%',
        left: 0,
        top: 0,
        display: 'flex',
        justifyContent: props.position === 'left' || props.position === 'top-left' || props.position === 'bottom-left' ? 'flex-start' : props.position === 'right' || props.position === 'top-right' || props.position === 'bottom-right' ? 'flex-end' : 'center',
        alignItems: props.position === 'top' || props.position === 'top-left' || props.position === 'top-right' ? 'flex-start' : props.position === 'bottom' || props.position === 'bottom-left' || props.position === 'bottom-right' ? 'flex-end' : 'center',
        pointerEvents: !props.modal && 'none'
      }, props.maskStyle);
    }
  };
  var DialogBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'Dialog',
      __parentMetadata: null,
      appendTo: null,
      ariaCloseIconLabel: null,
      baseZIndex: 0,
      blockScroll: false,
      breakpoints: null,
      className: null,
      closable: true,
      closeIcon: null,
      closeOnEscape: true,
      contentClassName: null,
      contentStyle: null,
      dismissableMask: false,
      draggable: true,
      focusOnShow: true,
      footer: null,
      footerClassName: null,
      header: null,
      headerClassName: null,
      headerStyle: null,
      icons: null,
      id: null,
      keepInViewport: true,
      maskClassName: null,
      maskStyle: null,
      maximizable: false,
      maximizeIcon: null,
      maximized: false,
      minX: 0,
      minY: 0,
      minimizeIcon: null,
      modal: true,
      onClick: null,
      onDrag: null,
      onDragEnd: null,
      onDragStart: null,
      onHide: null,
      onMaskClick: null,
      onMaximize: null,
      onResize: null,
      onResizeEnd: null,
      onResizeStart: null,
      onShow: null,
      position: 'center',
      resizable: true,
      rtl: false,
      showHeader: true,
      style: null,
      transitionOptions: null,
      visible: false,
      children: undefined
    },
    css: {
      classes: classes$V,
      styles: styles$Q,
      inlineStyles: inlineStyles$k
    }
  });

  function ownKeys$1q(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1q(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1q(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1q(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var Dialog = /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var context = React__namespace.useContext(PrimeReactContext);
    var props = DialogBase.getProps(inProps, context);
    var uniqueId = props.id ? props.id : UniqueComponentId();
    var _React$useState = React__namespace.useState(uniqueId),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      idState = _React$useState2[0];
      _React$useState2[1];
    var _React$useState3 = React__namespace.useState(false),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      maskVisibleState = _React$useState4[0],
      setMaskVisibleState = _React$useState4[1];
    var _React$useState5 = React__namespace.useState(false),
      _React$useState6 = _slicedToArray(_React$useState5, 2),
      visibleState = _React$useState6[0],
      setVisibleState = _React$useState6[1];
    var _React$useState7 = React__namespace.useState(props.maximized),
      _React$useState8 = _slicedToArray(_React$useState7, 2),
      maximizedState = _React$useState8[0],
      setMaximizedState = _React$useState8[1];
    var dialogRef = React__namespace.useRef(null);
    var maskRef = React__namespace.useRef(null);
    var pointerRef = React__namespace.useRef(null);
    var contentRef = React__namespace.useRef(null);
    var headerRef = React__namespace.useRef(null);
    var footerRef = React__namespace.useRef(null);
    var closeRef = React__namespace.useRef(null);
    var dragging = React__namespace.useRef(false);
    var resizing = React__namespace.useRef(false);
    var lastPageX = React__namespace.useRef(null);
    var lastPageY = React__namespace.useRef(null);
    var styleElement = React__namespace.useRef(null);
    var attributeSelector = React__namespace.useRef(uniqueId);
    var focusElementOnHide = React__namespace.useRef(null);
    var maximized = props.onMaximize ? props.maximized : maximizedState;
    var shouldBlockScroll = visibleState && (props.blockScroll || props.maximizable && maximized);
    var displayOrder = useDisplayOrder('dialog', visibleState);
    var _DialogBase$setMetaDa = DialogBase.setMetaData(_objectSpread$1q(_objectSpread$1q({
        props: props
      }, props.__parentMetadata), {}, {
        state: {
          id: idState,
          maximized: maximized,
          containerVisible: maskVisibleState
        }
      })),
      ptm = _DialogBase$setMetaDa.ptm,
      cx = _DialogBase$setMetaDa.cx,
      sx = _DialogBase$setMetaDa.sx,
      isUnstyled = _DialogBase$setMetaDa.isUnstyled;
    useHandleStyle(DialogBase.css.styles, isUnstyled, {
      name: 'dialog'
    });
    useGlobalOnEscapeKey({
      callback: function callback(event) {
        if (props.closable && props.closeOnEscape) {
          onClose(event);
        }
      },
      when: visibleState,
      priority: [ESC_KEY_HANDLING_PRIORITIES.DIALOG, displayOrder]
    });
    var _useEventListener = useEventListener({
        type: 'keydown',
        listener: function listener(event) {
          return onKeyDown(event);
        }
      }),
      _useEventListener2 = _slicedToArray(_useEventListener, 2),
      bindDocumentKeyDownListener = _useEventListener2[0],
      unbindDocumentKeyDownListener = _useEventListener2[1];
    var _useEventListener3 = useEventListener({
        type: 'mousemove',
        target: function target() {
          return window.document;
        },
        listener: function listener(event) {
          return onResize(event);
        }
      }),
      _useEventListener4 = _slicedToArray(_useEventListener3, 2),
      bindDocumentResizeListener = _useEventListener4[0],
      unbindDocumentResizeListener = _useEventListener4[1];
    var _useEventListener5 = useEventListener({
        type: 'mouseup',
        target: function target() {
          return window.document;
        },
        listener: function listener(event) {
          return onResizeEnd(event);
        }
      }),
      _useEventListener6 = _slicedToArray(_useEventListener5, 2),
      bindDocumentResizeEndListener = _useEventListener6[0],
      unbindDocumentResizEndListener = _useEventListener6[1];
    var _useEventListener7 = useEventListener({
        type: 'mousemove',
        target: function target() {
          return window.document;
        },
        listener: function listener(event) {
          return onDrag(event);
        }
      }),
      _useEventListener8 = _slicedToArray(_useEventListener7, 2),
      bindDocumentDragListener = _useEventListener8[0],
      unbindDocumentDragListener = _useEventListener8[1];
    var _useEventListener9 = useEventListener({
        type: 'mouseup',
        target: function target() {
          return window.document;
        },
        listener: function listener(event) {
          return onDragEnd(event);
        }
      }),
      _useEventListener10 = _slicedToArray(_useEventListener9, 2),
      bindDocumentDragEndListener = _useEventListener10[0],
      unbindDocumentDragEndListener = _useEventListener10[1];
    var onClose = function onClose(event) {
      props.onHide();
      event.preventDefault();
    };
    var focus = function focus() {
      var activeElement = document.activeElement;
      var isActiveElementInDialog = activeElement && dialogRef.current && dialogRef.current.contains(activeElement);
      if (!isActiveElementInDialog && props.closable && props.showHeader && closeRef.current) {
        closeRef.current.focus();
      }
    };
    var onDialogPointerDown = function onDialogPointerDown(event) {
      pointerRef.current = event.target;
      props.onPointerDown && props.onPointerDown(event);
    };
    var onMaskPointerUp = function onMaskPointerUp(event) {
      if (props.dismissableMask && props.modal && maskRef.current === event.target && !pointerRef.current) {
        onClose(event);
      }
      props.onMaskClick && props.onMaskClick(event);
      pointerRef.current = null;
    };
    var toggleMaximize = function toggleMaximize(event) {
      if (props.onMaximize) {
        props.onMaximize({
          originalEvent: event,
          maximized: !maximized
        });
      } else {
        setMaximizedState(function (prevMaximized) {
          return !prevMaximized;
        });
      }
      event.preventDefault();
    };
    var onKeyDown = function onKeyDown(event) {
      var currentTarget = event.currentTarget;
      if (!currentTarget || !currentTarget.primeDialogParams) {
        return;
      }
      var params = currentTarget.primeDialogParams;
      var paramLength = params.length;
      var dialogId = params[paramLength - 1] ? params[paramLength - 1].id : undefined;
      if (dialogId !== idState) {
        return;
      }
      var dialog = document.getElementById(dialogId);
      if (event.key === 'Tab') {
        event.preventDefault();
        var focusableElements = DomHandler.getFocusableElements(dialog);
        if (focusableElements && focusableElements.length > 0) {
          if (!document.activeElement) {
            focusableElements[0].focus();
          } else {
            var focusedIndex = focusableElements.indexOf(document.activeElement);
            if (event.shiftKey) {
              if (focusedIndex === -1 || focusedIndex === 0) focusableElements[focusableElements.length - 1].focus();else focusableElements[focusedIndex - 1].focus();
            } else {
              if (focusedIndex === -1 || focusedIndex === focusableElements.length - 1) focusableElements[0].focus();else focusableElements[focusedIndex + 1].focus();
            }
          }
        }
      }
    };
    var onDragStart = function onDragStart(event) {
      if (DomHandler.hasClass(event.target, 'p-dialog-header-icon') || DomHandler.hasClass(event.target.parentElement, 'p-dialog-header-icon')) {
        return;
      }
      if (props.draggable) {
        dragging.current = true;
        lastPageX.current = event.pageX;
        lastPageY.current = event.pageY;
        dialogRef.current.style.margin = '0';
        DomHandler.addClass(document.body, 'p-unselectable-text');
        props.onDragStart && props.onDragStart(event);
      }
    };
    var onDrag = function onDrag(event) {
      if (dragging.current) {
        var width = DomHandler.getOuterWidth(dialogRef.current);
        var height = DomHandler.getOuterHeight(dialogRef.current);
        var deltaX = event.pageX - lastPageX.current;
        var deltaY = event.pageY - lastPageY.current;
        var offset = dialogRef.current.getBoundingClientRect();
        var leftPos = offset.left + deltaX;
        var topPos = offset.top + deltaY;
        var viewport = DomHandler.getViewport();
        var computedStyle = getComputedStyle(dialogRef.current);
        var leftMargin = parseFloat(computedStyle.marginLeft);
        var topMargin = parseFloat(computedStyle.marginTop);
        dialogRef.current.style.position = 'fixed';
        if (props.keepInViewport) {
          if (leftPos >= props.minX && leftPos + width < viewport.width) {
            lastPageX.current = event.pageX;
            dialogRef.current.style.left = leftPos - leftMargin + 'px';
          }
          if (topPos >= props.minY && topPos + height < viewport.height) {
            lastPageY.current = event.pageY;
            dialogRef.current.style.top = topPos - topMargin + 'px';
          }
        } else {
          lastPageX.current = event.pageX;
          dialogRef.current.style.left = leftPos - leftMargin + 'px';
          lastPageY.current = event.pageY;
          dialogRef.current.style.top = topPos - topMargin + 'px';
        }
        props.onDrag && props.onDrag(event);
      }
    };
    var onDragEnd = function onDragEnd(event) {
      if (dragging.current) {
        dragging.current = false;
        DomHandler.removeClass(document.body, 'p-unselectable-text');
        props.onDragEnd && props.onDragEnd(event);
      }
    };
    var onResizeStart = function onResizeStart(event) {
      if (props.resizable) {
        resizing.current = true;
        lastPageX.current = event.pageX;
        lastPageY.current = event.pageY;
        DomHandler.addClass(document.body, 'p-unselectable-text');
        props.onResizeStart && props.onResizeStart(event);
      }
    };
    var convertToPx = function convertToPx(value, property, viewport) {
      !viewport && (viewport = DomHandler.getViewport());
      var val = parseInt(value);
      if (/^(\d+|(\.\d+))(\.\d+)?%$/.test(value)) {
        return val * (viewport[property] / 100);
      }
      return val;
    };
    var onResize = function onResize(event) {
      if (resizing.current) {
        var deltaX = event.pageX - lastPageX.current;
        var deltaY = event.pageY - lastPageY.current;
        var width = DomHandler.getOuterWidth(dialogRef.current);
        var height = DomHandler.getOuterHeight(dialogRef.current);
        var offset = dialogRef.current.getBoundingClientRect();
        var viewport = DomHandler.getViewport();
        var hasBeenDragged = !parseInt(dialogRef.current.style.top) || !parseInt(dialogRef.current.style.left);
        var minWidth = convertToPx(dialogRef.current.style.minWidth, 'width', viewport);
        var minHeight = convertToPx(dialogRef.current.style.minHeight, 'height', viewport);
        var newWidth = width + deltaX;
        var newHeight = height + deltaY;
        if (hasBeenDragged) {
          newWidth += deltaX;
          newHeight += deltaY;
        }
        if ((!minWidth || newWidth > minWidth) && offset.left + newWidth < viewport.width) {
          dialogRef.current.style.width = newWidth + 'px';
        }
        if ((!minHeight || newHeight > minHeight) && offset.top + newHeight < viewport.height) {
          dialogRef.current.style.height = newHeight + 'px';
        }
        lastPageX.current = event.pageX;
        lastPageY.current = event.pageY;
        props.onResize && props.onResize(event);
      }
    };
    var onResizeEnd = function onResizeEnd(event) {
      if (resizing.current) {
        resizing.current = false;
        DomHandler.removeClass(document.body, 'p-unselectable-text');
        props.onResizeEnd && props.onResizeEnd(event);
      }
    };
    var resetPosition = function resetPosition() {
      dialogRef.current.style.position = '';
      dialogRef.current.style.left = '';
      dialogRef.current.style.top = '';
      dialogRef.current.style.margin = '';
    };
    var onEnter = function onEnter() {
      dialogRef.current.setAttribute(attributeSelector.current, '');
    };
    var onEntered = function onEntered() {
      props.onShow && props.onShow();
      if (props.focusOnShow) {
        focus();
      }
      enableDocumentSettings();
    };
    var onExiting = function onExiting() {
      if (props.modal) {
        DomHandler.addClass(maskRef.current, 'p-component-overlay-leave');
      }
    };
    var onExited = function onExited() {
      dragging.current = false;
      ZIndexUtils.clear(maskRef.current);
      setMaskVisibleState(false);
      disableDocumentSettings();

      // return focus to element before dialog was open
      DomHandler.focus(focusElementOnHide.current);
      focusElementOnHide.current = null;
    };
    var enableDocumentSettings = function enableDocumentSettings() {
      bindGlobalListeners();
    };
    var disableDocumentSettings = function disableDocumentSettings() {
      unbindGlobalListeners();
    };
    var updateScrollBlocker = function updateScrollBlocker() {
      // Scroll should be unblocked if there is at least one dialog that blocks scrolling:
      var isThereAnyDialogThatBlocksScrolling = document.primeDialogParams && document.primeDialogParams.some(function (i) {
        return i.hasBlockScroll;
      });
      if (isThereAnyDialogThatBlocksScrolling) {
        DomHandler.blockBodyScroll();
      } else {
        DomHandler.unblockBodyScroll();
      }
    };
    var updateGlobalDialogsRegistry = function updateGlobalDialogsRegistry(isMounted) {
      // Update current dialog info in global registry if it is mounted and visible:
      if (isMounted && visibleState) {
        var newParam = {
          id: idState,
          hasBlockScroll: shouldBlockScroll
        };

        // Create registry if not yet created:
        if (!document.primeDialogParams) {
          document.primeDialogParams = [];
        }
        var currentDialogIndexInRegistry = document.primeDialogParams.findIndex(function (dialogInRegistry) {
          return dialogInRegistry.id === idState;
        });
        if (currentDialogIndexInRegistry === -1) {
          document.primeDialogParams = [].concat(_toConsumableArray(document.primeDialogParams), [newParam]);
        } else {
          document.primeDialogParams = document.primeDialogParams.toSpliced(currentDialogIndexInRegistry, 1, newParam);
        }
      }
      // Or remove it from global registry if unmounted or invisible:
      else {
        document.primeDialogParams = document.primeDialogParams && document.primeDialogParams.filter(function (param) {
          return param.id !== idState;
        });
      }

      // Always update scroll blocker after dialog registry - this way we ensure that
      // p-overflow-hidden class is properly added/removed:
      updateScrollBlocker();
    };
    var bindGlobalListeners = function bindGlobalListeners() {
      if (props.draggable) {
        bindDocumentDragListener();
        bindDocumentDragEndListener();
      }
      if (props.resizable) {
        bindDocumentResizeListener();
        bindDocumentResizeEndListener();
      }
      bindDocumentKeyDownListener();
    };
    var unbindGlobalListeners = function unbindGlobalListeners() {
      unbindDocumentDragListener();
      unbindDocumentDragEndListener();
      unbindDocumentResizeListener();
      unbindDocumentResizEndListener();
      unbindDocumentKeyDownListener();
    };
    var createStyle = function createStyle() {
      styleElement.current = DomHandler.createInlineStyle(context && context.nonce || PrimeReact.nonce, context && context.styleContainer);
      var innerHTML = '';
      for (var breakpoint in props.breakpoints) {
        innerHTML += "\n                @media screen and (max-width: ".concat(breakpoint, ") {\n                     [data-pc-name=\"dialog\"][").concat(attributeSelector.current, "] {\n                        width: ").concat(props.breakpoints[breakpoint], " !important;\n                    }\n                }\n            ");
      }
      styleElement.current.innerHTML = innerHTML;
    };
    var destroyStyle = function destroyStyle() {
      styleElement.current = DomHandler.removeInlineStyle(styleElement.current);
    };
    useMountEffect(function () {
      updateGlobalDialogsRegistry(true);
      if (props.visible) {
        setMaskVisibleState(true);
      }
    });
    React__namespace.useEffect(function () {
      if (props.breakpoints) {
        createStyle();
      }
      return function () {
        destroyStyle();
      };
      // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [props.breakpoints]);
    useUpdateEffect(function () {
      if (props.visible && !maskVisibleState) {
        setMaskVisibleState(true);
      }
      if (props.visible !== visibleState && maskVisibleState) {
        setVisibleState(props.visible);
      }
      if (props.visible) {
        // Remember the focused element before we opened the dialog
        // so we can return focus to it once we close the dialog.
        focusElementOnHide.current = document.activeElement;
      }
    }, [props.visible, maskVisibleState]);
    useUpdateEffect(function () {
      if (maskVisibleState) {
        ZIndexUtils.set('modal', maskRef.current, context && context.autoZIndex || PrimeReact.autoZIndex, props.baseZIndex || context && context.zIndex['modal'] || PrimeReact.zIndex['modal']);
        setVisibleState(true);
      }
    }, [maskVisibleState]);
    useUpdateEffect(function () {
      updateGlobalDialogsRegistry(true);
    }, [shouldBlockScroll, visibleState]);
    useUnmountEffect(function () {
      disableDocumentSettings();
      updateGlobalDialogsRegistry(false);
      DomHandler.removeInlineStyle(styleElement.current);
      ZIndexUtils.clear(maskRef.current);
    });
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        resetPosition: resetPosition,
        getElement: function getElement() {
          return dialogRef.current;
        },
        getMask: function getMask() {
          return maskRef.current;
        },
        getContent: function getContent() {
          return contentRef.current;
        },
        getHeader: function getHeader() {
          return headerRef.current;
        },
        getFooter: function getFooter() {
          return footerRef.current;
        },
        getCloseButton: function getCloseButton() {
          return closeRef.current;
        }
      };
    });
    var createCloseIcon = function createCloseIcon() {
      if (props.closable) {
        var ariaLabel = props.ariaCloseIconLabel || localeOption('close');
        var closeButtonIconProps = mergeProps({
          className: cx('closeButtonIcon'),
          'aria-hidden': true
        }, ptm('closeButtonIcon'));
        var icon = props.closeIcon || /*#__PURE__*/React__namespace.createElement(TimesIcon, closeButtonIconProps);
        var headerCloseIcon = IconUtils.getJSXIcon(icon, _objectSpread$1q({}, closeButtonIconProps), {
          props: props
        });
        var closeButtonProps = mergeProps({
          ref: closeRef,
          type: 'button',
          className: cx('closeButton'),
          'aria-label': ariaLabel,
          onClick: onClose
        }, ptm('closeButton'));
        return /*#__PURE__*/React__namespace.createElement("button", closeButtonProps, headerCloseIcon, /*#__PURE__*/React__namespace.createElement(Ripple, null));
      }
      return null;
    };
    var createMaximizeIcon = function createMaximizeIcon() {
      var icon;
      var maximizableIconProps = mergeProps({
        className: cx('maximizableIcon')
      }, ptm('maximizableIcon'));
      if (!maximized) {
        icon = props.maximizeIcon || /*#__PURE__*/React__namespace.createElement(WindowMaximizeIcon, maximizableIconProps);
      } else {
        icon = props.minimizeIcon || /*#__PURE__*/React__namespace.createElement(WindowMinimizeIcon, maximizableIconProps);
      }
      var toggleIcon = IconUtils.getJSXIcon(icon, maximizableIconProps, {
        props: props
      });
      if (props.maximizable) {
        var maximizableButtonProps = mergeProps({
          type: 'button',
          className: cx('maximizableButton'),
          onClick: toggleMaximize
        }, ptm('maximizableButton'));
        return /*#__PURE__*/React__namespace.createElement("button", maximizableButtonProps, toggleIcon, /*#__PURE__*/React__namespace.createElement(Ripple, null));
      }
      return null;
    };
    var createHeader = function createHeader() {
      if (props.showHeader) {
        var closeIcon = createCloseIcon();
        var maximizeIcon = createMaximizeIcon();
        var icons = ObjectUtils.getJSXElement(props.icons, props);
        var header = ObjectUtils.getJSXElement(props.header, props);
        var headerId = idState + '_header';
        var headerProps = mergeProps({
          ref: headerRef,
          style: props.headerStyle,
          className: cx('header'),
          onMouseDown: onDragStart
        }, ptm('header'));
        var headerTitleProps = mergeProps({
          id: headerId,
          className: cx('headerTitle')
        }, ptm('headerTitle'));
        var headerIconsProps = mergeProps({
          className: cx('headerIcons')
        }, ptm('headerIcons'));
        return /*#__PURE__*/React__namespace.createElement("div", headerProps, /*#__PURE__*/React__namespace.createElement("div", headerTitleProps, header), /*#__PURE__*/React__namespace.createElement("div", headerIconsProps, icons, maximizeIcon, closeIcon));
      }
      return null;
    };
    var createContent = function createContent() {
      var contentId = idState + '_content';
      var contentProps = mergeProps({
        id: contentId,
        ref: contentRef,
        style: props.contentStyle,
        className: cx('content')
      }, ptm('content'));
      return /*#__PURE__*/React__namespace.createElement("div", contentProps, props.children);
    };
    var createFooter = function createFooter() {
      var footer = ObjectUtils.getJSXElement(props.footer, props);
      var footerProps = mergeProps({
        ref: footerRef,
        className: cx('footer')
      }, ptm('footer'));
      return footer && /*#__PURE__*/React__namespace.createElement("div", footerProps, footer);
    };
    var createResizer = function createResizer() {
      if (props.resizable) {
        return /*#__PURE__*/React__namespace.createElement("span", {
          className: "p-resizable-handle",
          style: {
            zIndex: 90
          },
          onMouseDown: onResizeStart
        });
      }
      return null;
    };
    var createTemplateElement = function createTemplateElement(_ref) {
      var _props$children;
      var maskProps = _ref.maskProps,
        rootProps = _ref.rootProps,
        transitionProps = _ref.transitionProps;
      var messageProps = {
        header: props.header,
        content: props.message,
        message: props === null || props === void 0 || (_props$children = props.children) === null || _props$children === void 0 || (_props$children = _props$children[1]) === null || _props$children === void 0 || (_props$children = _props$children.props) === null || _props$children === void 0 ? void 0 : _props$children.children
      };
      var templateElementProps = {
        headerRef: headerRef,
        contentRef: contentRef,
        footerRef: footerRef,
        closeRef: closeRef,
        hide: onClose,
        message: messageProps
      };
      return /*#__PURE__*/React__namespace.createElement("div", maskProps, /*#__PURE__*/React__namespace.createElement(CSSTransition, _extends({
        nodeRef: dialogRef
      }, transitionProps), /*#__PURE__*/React__namespace.createElement("div", rootProps, ObjectUtils.getJSXElement(inProps.content, templateElementProps))));
    };
    var createElement = function createElement(_ref2) {
      var maskProps = _ref2.maskProps,
        rootProps = _ref2.rootProps,
        transitionProps = _ref2.transitionProps;
      var header = createHeader();
      var content = createContent();
      var footer = createFooter();
      var resizer = createResizer();
      return /*#__PURE__*/React__namespace.createElement("div", maskProps, /*#__PURE__*/React__namespace.createElement(CSSTransition, _extends({
        nodeRef: dialogRef
      }, transitionProps), /*#__PURE__*/React__namespace.createElement("div", rootProps, header, content, footer, resizer)));
    };
    var createDialog = function createDialog() {
      var headerId = idState + '_header';
      var contentId = idState + '_content';
      var transitionTimeout = {
        enter: props.position === 'center' ? 150 : 300,
        exit: props.position === 'center' ? 150 : 300
      };
      var maskProps = mergeProps({
        ref: maskRef,
        style: sx('mask'),
        className: cx('mask'),
        onPointerUp: onMaskPointerUp
      }, ptm('mask'));
      var rootProps = mergeProps({
        ref: dialogRef,
        id: idState,
        className: cx('root', {
          props: props,
          maximized: maximized,
          context: context
        }),
        style: props.style,
        onClick: props.onClick,
        role: 'dialog',
        'aria-labelledby': headerId,
        'aria-describedby': contentId,
        'aria-modal': props.modal,
        onPointerDown: onDialogPointerDown
      }, DialogBase.getOtherProps(props), ptm('root'));
      var transitionProps = mergeProps({
        classNames: cx('transition'),
        timeout: transitionTimeout,
        "in": visibleState,
        options: props.transitionOptions,
        unmountOnExit: true,
        onEnter: onEnter,
        onEntered: onEntered,
        onExiting: onExiting,
        onExited: onExited
      }, ptm('transition'));
      if (inProps !== null && inProps !== void 0 && inProps.content) {
        var templateElement = createTemplateElement({
          maskProps: maskProps,
          rootProps: rootProps,
          transitionProps: transitionProps
        });
        return /*#__PURE__*/React__namespace.createElement(Portal, {
          element: templateElement,
          appendTo: props.appendTo,
          visible: true
        });
      } else {
        var element = createElement({
          maskProps: maskProps,
          rootProps: rootProps,
          transitionProps: transitionProps
        });
        return /*#__PURE__*/React__namespace.createElement(Portal, {
          element: element,
          appendTo: props.appendTo,
          visible: true
        });
      }
    };
    return maskVisibleState && createDialog();
  });
  Dialog.displayName = 'Dialog';

  var classes$U = {
    root: 'p-confirm-dialog',
    message: 'p-confirm-dialog-message',
    icon: 'p-confirm-dialog-icon',
    acceptButton: 'p-confirm-dialog-accept',
    rejectButton: function rejectButton(_ref) {
      var getPropValue = _ref.getPropValue;
      return classNames('p-confirm-dialog-reject', {
        'p-button-text': !getPropValue('rejectClassName')
      });
    }
  };
  var ConfirmDialogBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'ConfirmDialog',
      accept: null,
      acceptClassName: null,
      acceptIcon: null,
      acceptLabel: null,
      appendTo: null,
      breakpoints: null,
      children: undefined,
      className: null,
      defaultFocus: 'accept',
      footer: null,
      icon: null,
      message: null,
      onHide: null,
      reject: null,
      rejectClassName: null,
      rejectIcon: null,
      rejectLabel: null,
      tagKey: undefined,
      visible: undefined
    },
    css: {
      classes: classes$U
    }
  });

  function ownKeys$1p(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1p(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1p(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1p(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var confirmDialog = function confirmDialog() {
    var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    props = _objectSpread$1p(_objectSpread$1p({}, props), {
      visible: props.visible === undefined ? true : props.visible
    });
    props.visible && OverlayService.emit('confirm-dialog', props);
    var show = function show() {
      var updatedProps = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      OverlayService.emit('confirm-dialog', _objectSpread$1p(_objectSpread$1p(_objectSpread$1p({}, props), updatedProps), {
        visible: true
      }));
    };
    var hide = function hide() {
      OverlayService.emit('confirm-dialog', {
        visible: false
      });
    };
    return {
      show: show,
      hide: hide
    };
  };
  var ConfirmDialog = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var context = React__namespace.useContext(PrimeReactContext);
    var props = ConfirmDialogBase.getProps(inProps, context);
    var _React$useState = React__namespace.useState(props.visible),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      visibleState = _React$useState2[0],
      setVisibleState = _React$useState2[1];
    var _React$useState3 = React__namespace.useState(false),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      reshowState = _React$useState4[0],
      setReshowState = _React$useState4[1];
    var confirmProps = React__namespace.useRef(null);
    var isCallbackExecuting = React__namespace.useRef(false);
    var focusElementOnHide = React__namespace.useRef(null);
    var getCurrentProps = function getCurrentProps() {
      return confirmProps.current || props;
    };
    var getPropValue = function getPropValue(key) {
      return (confirmProps.current || props)[key];
    };
    var callbackFromProp = function callbackFromProp(key) {
      for (var _len = arguments.length, param = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        param[_key - 1] = arguments[_key];
      }
      return ObjectUtils.getPropValue(getPropValue(key), param);
    };
    var acceptLabel = getPropValue('acceptLabel') || localeOption('accept');
    var rejectLabel = getPropValue('rejectLabel') || localeOption('reject');
    var metaData = {
      props: props,
      state: {
        visible: visibleState
      }
    };
    var _ConfirmDialogBase$se = ConfirmDialogBase.setMetaData(metaData),
      ptm = _ConfirmDialogBase$se.ptm,
      cx = _ConfirmDialogBase$se.cx;
    var accept = function accept() {
      if (!isCallbackExecuting.current) {
        isCallbackExecuting.current = true;
        callbackFromProp('accept');
        hide('accept');
      }
    };
    var reject = function reject() {
      if (!isCallbackExecuting.current) {
        isCallbackExecuting.current = true;
        callbackFromProp('reject');
        hide('reject');
      }
    };
    var show = function show() {
      var currentProps = getCurrentProps();
      if (currentProps.group === props.group) {
        setVisibleState(true);
        isCallbackExecuting.current = false;

        // Remember the focused element before we opened the dialog
        // so we can return focus to it once we close the dialog.
        focusElementOnHide.current = document.activeElement;
      }
    };
    var hide = function hide() {
      var result = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'cancel';
      setVisibleState(false);
      callbackFromProp('onHide', {
        result: result
      });
      DomHandler.focus(focusElementOnHide.current);
      focusElementOnHide.current = null;
    };
    var confirm = function confirm(updatedProps) {
      if (updatedProps.tagKey === props.tagKey) {
        var isVisibleChanged = visibleState !== updatedProps.visible;
        var targetChanged = getPropValue('target') !== updatedProps.target;
        if (targetChanged && !props.target) {
          hide();
          confirmProps.current = updatedProps;
          setReshowState(true);
        } else if (isVisibleChanged) {
          confirmProps.current = updatedProps;
          updatedProps.visible ? show() : hide();
        }
      }
    };
    React__namespace.useEffect(function () {
      props.visible ? show() : hide();
      // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [props.visible]);
    React__namespace.useEffect(function () {
      if (!props.target && !props.message) {
        OverlayService.on('confirm-dialog', confirm);
      }
      return function () {
        OverlayService.off('confirm-dialog', confirm);
      };
      // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [props.target]);
    useUpdateEffect(function () {
      reshowState && show();
    }, [reshowState]);
    useUnmountEffect(function () {
      OverlayService.off('confirm-dialog', confirm);
    });
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        confirm: confirm
      };
    });
    var createFooter = function createFooter() {
      var defaultFocus = getPropValue('defaultFocus');
      var acceptClassName = classNames('p-confirm-dialog-accept', getPropValue('acceptClassName'));
      var rejectClassName = classNames('p-confirm-dialog-reject', {
        'p-button-text': !getPropValue('rejectClassName')
      }, getPropValue('rejectClassName'));
      var rejectButtonProps = {
        label: rejectLabel,
        autoFocus: defaultFocus === 'reject',
        icon: getPropValue('rejectIcon'),
        className: classNames(getPropValue('rejectClassName'), cx('rejectButton', {
          getPropValue: getPropValue
        })),
        onClick: reject,
        pt: ptm('rejectButton'),
        unstyled: props.unstyled,
        __parentMetadata: {
          parent: metaData
        }
      };
      var acceptButtonProps = mergeProps({
        label: acceptLabel,
        autoFocus: defaultFocus === undefined || defaultFocus === 'accept',
        icon: getPropValue('acceptIcon'),
        className: classNames(getPropValue('acceptClassName'), cx('acceptButton')),
        onClick: accept,
        pt: ptm('acceptButton'),
        unstyled: props.unstyled,
        __parentMetadata: {
          parent: metaData
        }
      }, ptm('acceptButton'));
      var content = /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, null, /*#__PURE__*/React__namespace.createElement(Button, rejectButtonProps), /*#__PURE__*/React__namespace.createElement(Button, acceptButtonProps));
      if (getPropValue('footer')) {
        var defaultContentOptions = {
          accept: accept,
          reject: reject,
          acceptClassName: acceptClassName,
          rejectClassName: rejectClassName,
          acceptLabel: acceptLabel,
          rejectLabel: rejectLabel,
          element: content,
          props: getCurrentProps()
        };
        return ObjectUtils.getJSXElement(getPropValue('footer'), defaultContentOptions);
      }
      return content;
    };
    var createElement = function createElement() {
      var currentProps = getCurrentProps();
      var message = ObjectUtils.getJSXElement(getPropValue('message'), currentProps);
      var iconProps = mergeProps({
        className: cx('icon')
      }, ptm('icon'));
      var icon = IconUtils.getJSXIcon(getPropValue('icon'), _objectSpread$1p({}, iconProps), {
        props: currentProps
      });
      var footer = createFooter();
      var messageProps = mergeProps({
        className: cx('message')
      }, ptm('message'));
      var rootProps = mergeProps({
        visible: visibleState,
        className: classNames(getPropValue('className'), cx('root')),
        footer: footer,
        onHide: hide,
        breakpoints: getPropValue('breakpoints'),
        pt: currentProps.pt,
        unstyled: props.unstyled,
        appendTo: getPropValue('appendTo'),
        __parentMetadata: {
          parent: metaData
        }
      }, ConfirmDialogBase.getOtherProps(currentProps));
      return /*#__PURE__*/React__namespace.createElement(Dialog, _extends({}, rootProps, {
        content: inProps === null || inProps === void 0 ? void 0 : inProps.content
      }), icon, /*#__PURE__*/React__namespace.createElement("span", messageProps, message));
    };
    var element = createElement();
    return /*#__PURE__*/React__namespace.createElement(Portal, {
      element: element,
      appendTo: getPropValue('appendTo')
    });
  }));
  ConfirmDialog.displayName = 'ConfirmDialog';

  var styles$P = "\n@layer primereact {\n    .p-confirm-popup-flipped {\n        margin-top: 0;\n        margin-bottom: 10px;\n    }\n    \n    .p-confirm-popup:after, .p-confirm-popup:before {\n        bottom: 100%;\n        left: calc(var(--overlayArrowLeft, 0) + 1.25rem);\n        content: \" \";\n        height: 0;\n        width: 0;\n        position: absolute;\n        pointer-events: none;\n    }\n    \n    .p-confirm-popup:after {\n        border-width: 8px;\n        margin-left: -8px;\n    }\n    \n    .p-confirm-popup:before {\n        border-width: 10px;\n        margin-left: -10px;\n    }\n    \n    .p-confirm-popup-flipped:after, .p-confirm-popup-flipped:before {\n        bottom: auto;\n        top: 100%;\n    }\n    \n    .p-confirm-popup.p-confirm-popup-flipped:after {\n        border-bottom-color: transparent;\n    }\n    \n    .p-confirm-popup.p-confirm-popup-flipped:before {\n        border-bottom-color: transparent\n    }\n    \n    .p-confirm-popup .p-confirm-popup-content {\n        display: flex;\n        align-items: center;\n    }\n}\n";
  var classes$T = {
    root: function root(_ref) {
      var context = _ref.context,
        getPropValue = _ref.getPropValue;
      return classNames('p-confirm-popup p-component', getPropValue('className'), {
        'p-input-filled': context && context.inputStyle === 'filled' || PrimeReact.inputStyle === 'filled',
        'p-ripple-disabled': context && context.ripple === false || PrimeReact.ripple === false
      });
    },
    acceptButton: function acceptButton(_ref2) {
      var getPropValue = _ref2.getPropValue;
      return classNames('p-confirm-popup-accept p-button-sm', getPropValue('acceptClassName'));
    },
    rejectButton: function rejectButton(_ref3) {
      var getPropValue = _ref3.getPropValue;
      return classNames('p-confirm-popup-reject p-button-sm', {
        'p-button-text': !getPropValue('rejectClassName')
      }, getPropValue('rejectClassName'));
    },
    content: 'p-confirm-popup-content',
    icon: 'p-confirm-popup-icon',
    message: 'p-confirm-popup-message',
    footer: 'p-confirm-popup-footer',
    transition: 'p-connected-overlay'
  };
  var ConfirmPopupBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'ConfirmPopup',
      accept: null,
      acceptClassName: null,
      acceptIcon: null,
      acceptLabel: null,
      appendTo: null,
      children: undefined,
      className: null,
      closeOnEscape: true,
      defaultFocus: 'accept',
      dismissable: true,
      footer: null,
      icon: null,
      message: null,
      onHide: null,
      onShow: null,
      reject: null,
      rejectClassName: null,
      rejectIcon: null,
      rejectLabel: null,
      style: null,
      tagKey: undefined,
      target: null,
      transitionOptions: null,
      visible: false
    },
    css: {
      classes: classes$T,
      styles: styles$P
    }
  });

  function ownKeys$1o(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1o(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1o(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1o(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var confirmPopup = function confirmPopup() {
    var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    props = _objectSpread$1o(_objectSpread$1o({}, props), {
      visible: props.visible === undefined ? true : props.visible
    });
    props.visible && OverlayService.emit('confirm-popup', props);
    var show = function show() {
      var updatedProps = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      OverlayService.emit('confirm-popup', _objectSpread$1o(_objectSpread$1o(_objectSpread$1o({}, props), updatedProps), {
        visible: true
      }));
    };
    var hide = function hide() {
      OverlayService.emit('confirm-popup', {
        visible: false
      });
    };
    return {
      show: show,
      hide: hide
    };
  };
  var ConfirmPopup = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var context = React__namespace.useContext(PrimeReactContext);
    var props = ConfirmPopupBase.getProps(inProps, context);
    var _React$useState = React__namespace.useState(props.visible),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      visibleState = _React$useState2[0],
      setVisibleState = _React$useState2[1];
    var _React$useState3 = React__namespace.useState(false),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      reshowState = _React$useState4[0],
      setReshowState = _React$useState4[1];
    var metaData = {
      props: props,
      state: {
        visible: visibleState,
        reshow: reshowState
      }
    };
    var _ConfirmPopupBase$set = ConfirmPopupBase.setMetaData(metaData),
      ptm = _ConfirmPopupBase$set.ptm,
      cx = _ConfirmPopupBase$set.cx,
      isUnstyled = _ConfirmPopupBase$set.isUnstyled;
    useHandleStyle(ConfirmPopupBase.css.styles, isUnstyled, {
      name: 'confirmpopup'
    });
    var overlayRef = React__namespace.useRef(null);
    var acceptBtnRef = React__namespace.useRef(null);
    var rejectBtnRef = React__namespace.useRef(null);
    var isPanelClicked = React__namespace.useRef(false);
    var overlayEventListener = React__namespace.useRef(null);
    var confirmProps = React__namespace.useRef(null);
    var focusElementOnHide = React__namespace.useRef(null);
    var isCallbackExecuting = React__namespace.useRef(false);
    var getCurrentProps = function getCurrentProps() {
      return confirmProps.current || props;
    };
    var getPropValue = function getPropValue(key) {
      return (confirmProps.current || props)[key];
    };
    var callbackFromProp = function callbackFromProp(key) {
      for (var _len = arguments.length, param = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        param[_key - 1] = arguments[_key];
      }
      return ObjectUtils.getPropValue(getPropValue(key), param);
    };
    var acceptLabel = getPropValue('acceptLabel') || localeOption('accept');
    var rejectLabel = getPropValue('rejectLabel') || localeOption('reject');
    var displayOrder = useDisplayOrder('dialog', visibleState);
    useGlobalOnEscapeKey({
      callback: function callback() {
        if (props.dismissable && props.closeOnEscape) {
          hide('hide');
        }
      },
      when: visibleState,
      priority: [ESC_KEY_HANDLING_PRIORITIES.DIALOG, displayOrder]
    });
    var _useOverlayListener = useOverlayListener({
        target: getPropValue('target'),
        overlay: overlayRef,
        listener: function listener(event, _ref) {
          var type = _ref.type,
            valid = _ref.valid;
          if (valid) {
            type === 'outside' ? props.dismissable && !isPanelClicked.current && hide('hide') : hide('hide');
          }
          isPanelClicked.current = false;
        },
        when: visibleState
      }),
      _useOverlayListener2 = _slicedToArray(_useOverlayListener, 2),
      bindOverlayListener = _useOverlayListener2[0],
      unbindOverlayListener = _useOverlayListener2[1];
    var onPanelClick = function onPanelClick(event) {
      isPanelClicked.current = true;
      OverlayService.emit('overlay-click', {
        originalEvent: event,
        target: getPropValue('target')
      });
    };
    var accept = function accept() {
      if (!isCallbackExecuting.current) {
        isCallbackExecuting.current = true;
        callbackFromProp('accept');
        hide('accept');
      }
    };
    var reject = function reject() {
      if (!isCallbackExecuting.current) {
        isCallbackExecuting.current = true;
        callbackFromProp('reject');
        hide('reject');
      }
    };
    var show = function show() {
      var currentProps = getCurrentProps();
      setReshowState(false);
      if (currentProps.group === props.group) {
        setVisibleState(true);
        isCallbackExecuting.current = false;
        overlayEventListener.current = function (e) {
          !isOutsideClicked(e.target) && (isPanelClicked.current = true);
        };
        OverlayService.on('overlay-click', overlayEventListener.current);

        // Remember the focused element before we opened the dialog
        // so we can return focus to it once we close the dialog.
        focusElementOnHide.current = document.activeElement;
      }
    };
    var hide = function hide(result) {
      setVisibleState(false);
      OverlayService.off('overlay-click', overlayEventListener.current);
      overlayEventListener.current = null;
      if (result) {
        callbackFromProp('onHide', result);
      }
      DomHandler.focus(focusElementOnHide.current);
      focusElementOnHide.current = null;
    };
    var onEnter = function onEnter() {
      ZIndexUtils.set('overlay', overlayRef.current, context && context.autoZIndex || PrimeReact.autoZIndex, context && context.zIndex['overlay'] || PrimeReact.zIndex['overlay']);
      DomHandler.addStyles(overlayRef.current, {
        position: 'absolute',
        top: '50%',
        left: '50%',
        marginTop: '10px'
      });
      align();
    };
    var onEntered = function onEntered() {
      bindOverlayListener();
      var defaultFocus = getPropValue('defaultFocus');
      if (defaultFocus === undefined || defaultFocus === 'accept') {
        acceptBtnRef.current && acceptBtnRef.current.focus();
      }
      if (defaultFocus === 'reject') {
        rejectBtnRef.current && rejectBtnRef.current.focus();
      }
      callbackFromProp('onShow');
    };
    var onExit = function onExit() {
      unbindOverlayListener();
    };
    var onExited = function onExited() {
      ZIndexUtils.clear(overlayRef.current);
      isPanelClicked.current = false;
    };
    var align = function align() {
      if (getPropValue('target')) {
        DomHandler.absolutePosition(overlayRef.current, getPropValue('target'));
        var containerOffset = DomHandler.getOffset(overlayRef.current);
        var targetOffset = DomHandler.getOffset(getPropValue('target'));
        var arrowLeft = 0;
        if (containerOffset.left < targetOffset.left) {
          arrowLeft = targetOffset.left - containerOffset.left;
        }
        overlayRef.current.style.setProperty('--overlayArrowLeft', "".concat(arrowLeft, "px"));
        if (containerOffset.top < targetOffset.top) {
          !isUnstyled() && DomHandler.addClass(overlayRef.current, 'p-confirm-popup-flipped');
        }
      }
    };
    var isOutsideClicked = function isOutsideClicked(target) {
      return overlayRef && overlayRef.current && !(overlayRef.current.isSameNode(target) || overlayRef.current.contains(target));
    };
    var confirm = function confirm(updatedProps) {
      if (updatedProps.tagKey === props.tagKey) {
        var isVisibleChanged = visibleState !== updatedProps.visible;
        var targetChanged = getPropValue('target') !== updatedProps.target;
        if (targetChanged && !props.target) {
          hide();
          confirmProps.current = updatedProps;
          setReshowState(true);
        } else if (isVisibleChanged) {
          confirmProps.current = updatedProps;
          updatedProps.visible ? show() : hide();
        }
      }
    };
    React__namespace.useEffect(function () {
      props.visible ? show() : hide();
      // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [props.visible]);
    React__namespace.useEffect(function () {
      if (!props.target && !props.message) {
        OverlayService.on('confirm-popup', confirm);
      }
      return function () {
        OverlayService.off('confirm-popup', confirm);
      };
      // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [props.target]);
    useUpdateEffect(function () {
      reshowState && show();
    }, [reshowState]);
    useUnmountEffect(function () {
      if (overlayEventListener.current) {
        OverlayService.off('overlay-click', overlayEventListener.current);
        overlayEventListener.current = null;
      }
      OverlayService.off('confirm-popup', confirm);
      ZIndexUtils.clear(overlayRef.current);
    });
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        confirm: confirm
      };
    });
    var createContent = function createContent() {
      var currentProps = getCurrentProps();
      var message = ObjectUtils.getJSXElement(getPropValue('message'), currentProps);
      var iconProps = mergeProps({
        className: cx('icon')
      }, ptm('icon'));
      var icon = IconUtils.getJSXIcon(getPropValue('icon'), _objectSpread$1o({}, iconProps), {
        props: currentProps
      });
      var messageProps = mergeProps({
        className: cx('message')
      }, ptm('message'));
      var contentProps = mergeProps({
        className: cx('content')
      }, ptm('content'));
      return /*#__PURE__*/React__namespace.createElement("div", contentProps, icon, /*#__PURE__*/React__namespace.createElement("span", messageProps, message));
    };
    var createFooter = function createFooter() {
      var acceptClassName = classNames('p-confirm-popup-accept p-button-sm', getPropValue('acceptClassName'));
      var rejectClassName = classNames('p-confirm-popup-reject p-button-sm', {
        'p-button-text': !getPropValue('rejectClassName')
      }, getPropValue('rejectClassName'));
      var footerProps = mergeProps({
        className: cx('footer')
      }, ptm('footer'));
      var rejectButtonProps = mergeProps({
        ref: rejectBtnRef,
        label: rejectLabel,
        icon: getPropValue('rejectIcon'),
        className: cx('rejectButton', {
          getPropValue: getPropValue
        }),
        onClick: reject,
        pt: ptm('rejectButton'),
        unstyled: props.unstyled,
        __parentMetadata: {
          parent: metaData
        }
      });
      var acceptButtonProps = mergeProps({
        ref: acceptBtnRef,
        label: acceptLabel,
        icon: getPropValue('acceptIcon'),
        className: cx('acceptButton', {
          getPropValue: getPropValue
        }),
        onClick: accept,
        pt: ptm('acceptButton'),
        unstyled: props.unstyled,
        __parentMetadata: {
          parent: metaData
        }
      });
      var content = /*#__PURE__*/React__namespace.createElement("div", footerProps, /*#__PURE__*/React__namespace.createElement(Button, rejectButtonProps), /*#__PURE__*/React__namespace.createElement(Button, acceptButtonProps));
      if (getPropValue('footer')) {
        var defaultContentOptions = {
          accept: accept,
          reject: reject,
          className: 'p-confirm-popup-footer',
          acceptClassName: acceptClassName,
          rejectClassName: rejectClassName,
          acceptLabel: acceptLabel,
          rejectLabel: rejectLabel,
          element: content,
          props: getCurrentProps()
        };
        return ObjectUtils.getJSXElement(getPropValue('footer'), defaultContentOptions);
      }
      return content;
    };
    var rootProps = mergeProps({
      ref: overlayRef,
      id: getPropValue('id'),
      className: cx('root', {
        context: context,
        getPropValue: getPropValue
      }),
      style: getPropValue('style'),
      onClick: onPanelClick
    }, ConfirmPopupBase.getOtherProps(props), ptm('root'));
    var transitionProps = mergeProps({
      classNames: cx('transition'),
      "in": visibleState,
      timeout: {
        enter: 120,
        exit: 100
      },
      options: getPropValue('transitionOptions'),
      unmountOnExit: true,
      onEnter: onEnter,
      onEntered: onEntered,
      onExit: onExit,
      onExited: onExited
    }, ptm('transition'));
    var createTemplateElement = function createTemplateElement() {
      var currentProps = getCurrentProps();
      var message = ObjectUtils.getJSXElement(getPropValue('message'), currentProps);
      var templateElementProps = {
        message: message,
        acceptBtnRef: acceptBtnRef,
        rejectBtnRef: rejectBtnRef,
        hide: hide
      };
      return /*#__PURE__*/React__namespace.createElement(CSSTransition, _extends({
        nodeRef: overlayRef
      }, transitionProps), /*#__PURE__*/React__namespace.createElement("div", rootProps, ObjectUtils.getJSXElement(inProps.content, templateElementProps)));
    };
    var createElement = function createElement() {
      var content = createContent();
      var footer = createFooter();
      return /*#__PURE__*/React__namespace.createElement(CSSTransition, _extends({
        nodeRef: overlayRef
      }, transitionProps), /*#__PURE__*/React__namespace.createElement("div", rootProps, content, footer));
    };
    var element = inProps !== null && inProps !== void 0 && inProps.content ? createTemplateElement() : createElement();
    return /*#__PURE__*/React__namespace.createElement(Portal, {
      element: element,
      appendTo: getPropValue('appendTo'),
      visible: getPropValue('visible')
    });
  }));
  ConfirmPopup.displayName = 'ConfirmPopup';

  var styles$O = "\n@layer primereact {\n    .p-contextmenu ul {\n        margin: 0;\n        padding: 0;\n        list-style: none;\n    }\n\n    .p-contextmenu .p-submenu-list {\n        position: absolute;\n        min-width: 100%;\n        z-index: 1;\n    }\n\n    .p-contextmenu .p-menuitem-link {\n        cursor: pointer;\n        display: flex;\n        align-items: center;\n        text-decoration: none;\n        overflow: hidden;\n        position: relative;\n    }\n\n    .p-contextmenu .p-menuitem-text {\n        line-height: 1;\n    }\n\n    .p-contextmenu .p-menuitem {\n        position: relative;\n    }\n\n    .p-contextmenu .p-menuitem-link .p-submenu-icon {\n        margin-left: auto;\n    }\n\n    .p-contextmenu-enter {\n        opacity: 0;\n    }\n\n    .p-contextmenu-enter-active {\n        opacity: 1;\n        transition: opacity 250ms;\n    }\n}\n";
  var classes$S = {
    root: function root(_ref) {
      var context = _ref.context;
      return classNames('p-contextmenu p-component', {
        'p-input-filled': context && context.inputStyle === 'filled' || PrimeReact.inputStyle === 'filled',
        'p-ripple-disabled': context && context.ripple === false || PrimeReact.ripple === false
      });
    },
    menu: function menu(_ref2) {
      var props = _ref2.menuProps;
      return classNames({
        ' p-contextmenu-root-list': props.root,
        'p-submenu-list': !props.root
      });
    },
    menuitem: function menuitem(_ref3) {
      var item = _ref3.item,
        active = _ref3.active,
        focused = _ref3.focused,
        disabled = _ref3.disabled;
      return classNames('p-menuitem', {
        'p-menuitem-active p-highlight': active,
        'p-focus': focused,
        'p-disabled': disabled
      }, item.className);
    },
    action: function action(_ref4) {
      var item = _ref4.item;
      return classNames('p-menuitem-link', {
        'p-disabled': item.disabled
      });
    },
    content: 'p-menuitem-content',
    icon: 'p-menuitem-icon',
    submenuIcon: 'p-submenu-icon',
    label: 'p-menuitem-text',
    separator: 'p-menuitem-separator',
    transition: 'p-contextmenu',
    submenuTransition: 'p-contextmenusub'
  };
  var ContextMenuBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'ContextMenu',
      id: null,
      ariaLabel: null,
      ariaLabelledby: null,
      model: null,
      style: null,
      className: null,
      global: false,
      autoZIndex: true,
      baseZIndex: 0,
      tabIndex: 0,
      breakpoint: undefined,
      scrollHeight: '400px',
      appendTo: null,
      transitionOptions: null,
      onFocus: null,
      onBlur: null,
      onShow: null,
      onHide: null,
      submenuIcon: null,
      children: undefined
    },
    css: {
      classes: classes$S,
      styles: styles$O
    }
  });

  function ownKeys$1n(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1n(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1n(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1n(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var ContextMenuSub = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (props, ref) {
    var submenuRef = React__namespace.useRef(null);
    var active = props.root || !props.resetMenu;
    var ptm = props.ptm,
      cx = props.cx;
    var getPTOptions = function getPTOptions(processedItem, key, index) {
      return ptm(key, {
        hostName: props.hostName,
        context: {
          active: isItemActive(processedItem),
          focused: isItemFocused(processedItem),
          disabled: isItemDisabled(processedItem),
          index: index
        }
      });
    };
    var onItemMouseEnter = function onItemMouseEnter(event, item) {
      if (item.disabled || props.isMobileMode) {
        event.preventDefault();
        return;
      }
      props.onItemMouseEnter({
        originalEvent: event,
        processedItem: item
      });
    };
    var onItemClick = function onItemClick(event, processedItem) {
      var item = processedItem.item;
      if (item.disabled) {
        event.preventDefault();
        return;
      }
      if (!item.url) {
        event.preventDefault();
      }
      if (item.command) {
        item.command({
          originalEvent: event,
          item: item
        });
      }
      props.onItemClick({
        originalEvent: event,
        processedItem: processedItem,
        isFocus: true
      });
      if (!item.items) {
        props.onLeafClick(event);
      }
    };
    var position = function position() {
      if (!props.isMobileMode) {
        var parentItem = submenuRef.current.parentElement;
        var containerOffset = DomHandler.getOffset(parentItem);
        var viewport = DomHandler.getViewport();
        var sublistWidth = submenuRef.current.offsetParent ? submenuRef.current.offsetWidth : DomHandler.getHiddenElementOuterWidth(submenuRef.current);
        var itemOuterWidth = DomHandler.getOuterWidth(parentItem.children[0]);
        var top = parseInt(containerOffset.top, 10) + submenuRef.current.offsetHeight - DomHandler.getWindowScrollTop();
        if (top > viewport.height) {
          submenuRef.current.style.top = viewport.height - top + 'px';
        } else {
          submenuRef.current.style.top = '0px';
        }
        if (parseInt(containerOffset.left, 10) + itemOuterWidth + sublistWidth > viewport.width - DomHandler.calculateScrollbarWidth()) {
          submenuRef.current.style.left = -1 * sublistWidth + 'px';
        } else {
          submenuRef.current.style.left = itemOuterWidth + 'px';
        }
      }
    };
    var onEnter = function onEnter() {
      position();
    };
    useUpdateEffect(function () {
      active && position();
    });
    var getItemId = function getItemId(processedItem) {
      return "".concat(props.menuId, "_").concat(processedItem.key);
    };
    var getItemProp = function getItemProp(processedItem, name, params) {
      return processedItem && processedItem.item ? ObjectUtils.getItemValue(processedItem.item[name], params) : undefined;
    };
    var isItemActive = function isItemActive(processedItem) {
      return props.activeItemPath && props.activeItemPath.some(function (path) {
        return path.key === processedItem.key;
      });
    };
    var isItemVisible = function isItemVisible(processedItem) {
      return getItemProp(processedItem, 'visible') !== false;
    };
    var isItemDisabled = function isItemDisabled(processedItem) {
      return getItemProp(processedItem, 'disabled');
    };
    var isItemFocused = function isItemFocused(processedItem) {
      return props.focusedItemId === getItemId(processedItem);
    };
    var isItemGroup = function isItemGroup(processedItem) {
      return ObjectUtils.isNotEmpty(processedItem.items);
    };
    var getAriaSetSize = function getAriaSetSize() {
      return props.model.filter(function (processedItem) {
        return isItemVisible(processedItem) && !getItemProp(processedItem, 'separator');
      }).length;
    };
    var getAriaPosInset = function getAriaPosInset(index) {
      return index - props.model.slice(0, index).filter(function (processedItem) {
        return isItemVisible(processedItem) && getItemProp(processedItem, 'separator');
      }).length + 1;
    };
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        getElement: function getElement() {
          return submenuRef.current;
        }
      };
    });
    var createSeparator = function createSeparator(index) {
      var key = props.id + '_separator_' + index;
      var separatorProps = mergeProps({
        id: key,
        key: key,
        className: cx('separator'),
        role: 'separator'
      }, ptm('separator', {
        hostName: props.hostName
      }));
      return /*#__PURE__*/React__namespace.createElement("li", separatorProps);
    };
    var createSubmenu = function createSubmenu(item, index) {
      if (isItemGroup(item)) {
        return /*#__PURE__*/React__namespace.createElement(ContextMenuSub, {
          id: props.id + '_' + index,
          role: "menu",
          menuId: props.menuId,
          focusedItemId: props.focusedItemId,
          activeItemPath: props.activeItemPath,
          level: props.level + 1,
          hostName: props.hostName,
          ariaLabelledby: getItemId(item),
          menuProps: props.menuProps,
          model: item.items,
          resetMenu: !isItemActive(item),
          onLeafClick: props.onLeafClick,
          onItemClick: props.onItemClick,
          onItemMouseEnter: props.onItemMouseEnter,
          isMobileMode: props.isMobileMode,
          submenuIcon: props.submenuIcon,
          ptm: ptm,
          cx: cx
        });
      }
      return null;
    };
    var createMenuItem = function createMenuItem(processedItem, index) {
      if (!isItemVisible(processedItem)) {
        return null;
      }
      var item = processedItem.item;
      var active = isItemActive(processedItem);
      var disabled = isItemDisabled(processedItem);
      var focused = isItemFocused(processedItem);
      var isGroup = isItemGroup(processedItem);
      var key = getItemId(processedItem);
      var iconProps = mergeProps({
        className: cx('icon')
      }, getPTOptions(processedItem, 'icon', index));
      var icon = IconUtils.getJSXIcon(item.icon, _objectSpread$1n({}, iconProps), {
        props: props.menuProps
      });
      var submenuIconProps = mergeProps({
        className: cx('submenuIcon')
      }, getPTOptions(processedItem, 'submenuIcon', index));
      var labelProps = mergeProps({
        className: cx('label')
      }, getPTOptions(processedItem, 'label', index));
      var items = getItemProp(processedItem, 'items');
      var submenuIcon = items && IconUtils.getJSXIcon(props.submenuIcon || /*#__PURE__*/React__namespace.createElement(AngleRightIcon, submenuIconProps), _objectSpread$1n({}, submenuIconProps), {
        props: props.menuProps
      });
      var label = item.label && /*#__PURE__*/React__namespace.createElement("span", labelProps, item.label);
      var submenu = createSubmenu(processedItem, index);
      var actionProps = mergeProps({
        href: item.url || '#',
        'aria-hidden': true,
        tabIndex: -1,
        className: cx('action', {
          item: item
        }),
        target: item.target
      }, getPTOptions(processedItem, 'action', index));
      var content = /*#__PURE__*/React__namespace.createElement("a", actionProps, icon, label, submenuIcon, /*#__PURE__*/React__namespace.createElement(Ripple, null));
      if (item.template) {
        var defaultContentOptions = {
          className: 'p-menuitem-link',
          labelClassName: 'p-menuitem-text',
          iconClassName: 'p-menuitem-icon',
          submenuIconClassName: cx('submenuIcon'),
          element: content,
          props: props,
          active: active
        };
        content = ObjectUtils.getJSXElement(item.template, item, defaultContentOptions);
      }
      var contentProps = mergeProps({
        onClick: function onClick(event) {
          return onItemClick(event, processedItem);
        },
        onMouseEnter: function onMouseEnter(event) {
          return onItemMouseEnter(event, processedItem);
        },
        className: cx('content')
      }, getPTOptions(processedItem, 'content', index));
      var menuitemProps = mergeProps(_defineProperty({
        id: key,
        key: key,
        role: 'menuitem',
        'aria-label': item.label,
        'aria-disabled': disabled,
        'aria-expanded': isGroup ? active : undefined,
        'aria-haspopup': isGroup && !item.url ? 'menu' : undefined,
        'aria-level': props.level + 1,
        'aria-setsize': getAriaSetSize(),
        'aria-posinset': getAriaPosInset(index),
        'data-p-highlight': active,
        'data-p-focused': focused,
        'data-p-disabled': disabled,
        className: cx('menuitem', {
          item: item,
          active: active,
          focused: focused,
          disabled: isItemDisabled(item)
        }),
        style: item.style
      }, "key", key), getPTOptions(processedItem, 'menuitem', index));
      return /*#__PURE__*/React__namespace.createElement("li", menuitemProps, /*#__PURE__*/React__namespace.createElement("div", contentProps, content), submenu);
    };
    var createItem = function createItem(processedItem, index) {
      return processedItem.separator ? createSeparator(index) : createMenuItem(processedItem, index);
    };
    var createMenu = function createMenu() {
      return props.model ? props.model.map(createItem) : null;
    };
    var submenu = createMenu();
    var menuProps = mergeProps({
      className: cx('menu', {
        menuProps: props
      }),
      onFocus: props.onFocus,
      onBlur: props.onBlur,
      onKeyDown: props.onKeyDown,
      'aria-label': props.ariaLabel,
      'aria-labelledby': props.ariaLabelledby,
      'aria-orientation': 'vertical',
      'aria-activedescendant': props.ariaActivedescendant,
      tabIndex: props.tabIndex,
      role: props.role
    }, ptm('menu', {
      hostName: props.hostName
    }));
    var transitionProps = mergeProps({
      classNames: cx('submenuTransition'),
      "in": active,
      timeout: {
        enter: 0,
        exit: 0
      },
      unmountOnExit: true,
      onEnter: onEnter
    }, ptm('menu.transition', {
      hostName: props.hostName
    }));
    return /*#__PURE__*/React__namespace.createElement(CSSTransition, _extends({
      nodeRef: submenuRef
    }, transitionProps), /*#__PURE__*/React__namespace.createElement("ul", _extends({
      ref: submenuRef
    }, menuProps), submenu));
  }));
  ContextMenuSub.displayName = 'ContextMenuSub';

  function ownKeys$1m(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1m(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1m(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1m(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var ContextMenu = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var context = React__namespace.useContext(PrimeReactContext);
    var props = ContextMenuBase.getProps(inProps, context);
    var _React$useState = React__namespace.useState(props.id),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      idState = _React$useState2[0],
      setIdState = _React$useState2[1];
    var _React$useState3 = React__namespace.useState(false),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      visibleState = _React$useState4[0],
      setVisibleState = _React$useState4[1];
    var _React$useState5 = React__namespace.useState(false),
      _React$useState6 = _slicedToArray(_React$useState5, 2),
      reshowState = _React$useState6[0],
      setReshowState = _React$useState6[1];
    var _React$useState7 = React__namespace.useState(false),
      _React$useState8 = _slicedToArray(_React$useState7, 2),
      resetMenuState = _React$useState8[0],
      setResetMenuState = _React$useState8[1];
    var _React$useState9 = React__namespace.useState(null),
      _React$useState10 = _slicedToArray(_React$useState9, 2),
      attributeSelectorState = _React$useState10[0],
      setAttributeSelectorState = _React$useState10[1];
    var _React$useState11 = React__namespace.useState(false),
      _React$useState12 = _slicedToArray(_React$useState11, 2),
      focused = _React$useState12[0],
      setFocused = _React$useState12[1];
    var _React$useState13 = React__namespace.useState(false),
      _React$useState14 = _slicedToArray(_React$useState13, 2),
      focusTrigger = _React$useState14[0],
      setFocusTrigger = _React$useState14[1];
    var _React$useState15 = React__namespace.useState({
        index: -1,
        level: 0,
        parentKey: ''
      }),
      _React$useState16 = _slicedToArray(_React$useState15, 2),
      focusedItemInfo = _React$useState16[0],
      setFocusedItemInfo = _React$useState16[1];
    var _React$useState17 = React__namespace.useState(''),
      _React$useState18 = _slicedToArray(_React$useState17, 2),
      activeItemPath = _React$useState18[0],
      setActiveItemPath = _React$useState18[1];
    var _React$useState19 = React__namespace.useState([]),
      _React$useState20 = _slicedToArray(_React$useState19, 2),
      processedItems = _React$useState20[0],
      setProcessedItems = _React$useState20[1];
    var _React$useState21 = React__namespace.useState([]),
      _React$useState22 = _slicedToArray(_React$useState21, 2),
      visibleItems = _React$useState22[0],
      setVisibleItems = _React$useState22[1];
    var _React$useState23 = React__namespace.useState(null),
      _React$useState24 = _slicedToArray(_React$useState23, 2),
      focusedItemId = _React$useState24[0],
      setFocusedItemId = _React$useState24[1];
    var _ContextMenuBase$setM = ContextMenuBase.setMetaData({
        props: props,
        state: {
          id: idState,
          visible: visibleState,
          reshow: reshowState,
          resetMenu: resetMenuState,
          attributeSelector: attributeSelectorState
        }
      }),
      ptm = _ContextMenuBase$setM.ptm,
      cx = _ContextMenuBase$setM.cx,
      isUnstyled = _ContextMenuBase$setM.isUnstyled;
    useHandleStyle(ContextMenuBase.css.styles, isUnstyled, {
      name: 'contextmenu'
    });
    var menuRef = React__namespace.useRef(null);
    var listRef = React__namespace.useRef(null);
    var currentEvent = React__namespace.useRef(null);
    var searchValue = React__namespace.useRef('');
    var searchTimeout = React__namespace.useRef(null);
    var styleElementRef = React__namespace.useRef(null);
    var isMobileMode = useMatchMedia("screen and (max-width: ".concat(props.breakpoint, ")"), !!props.breakpoint);
    var _useEventListener = useEventListener({
        type: 'click',
        listener: function listener(event) {
          if (isOutsideClicked(event) && event.button !== 2) {
            hide(event);
            setResetMenuState(true);
          }
        }
      }),
      _useEventListener2 = _slicedToArray(_useEventListener, 2),
      bindDocumentClickListener = _useEventListener2[0],
      unbindDocumentClickListener = _useEventListener2[1];
    var _useEventListener3 = useEventListener({
        type: 'contextmenu',
        when: props.global,
        listener: function listener(event) {
          show(event);
        }
      }),
      _useEventListener4 = _slicedToArray(_useEventListener3, 1),
      bindDocumentContextMenuListener = _useEventListener4[0];
    var _useResizeListener = useResizeListener({
        listener: function listener(event) {
          if (visibleState && !DomHandler.isTouchDevice()) {
            hide(event);
          }
        }
      }),
      _useResizeListener2 = _slicedToArray(_useResizeListener, 2),
      bindDocumentResizeListener = _useResizeListener2[0],
      unbindDocumentResizeListener = _useResizeListener2[1];
    var createStyle = function createStyle() {
      if (!styleElementRef.current) {
        styleElementRef.current = DomHandler.createInlineStyle(context && context.nonce || PrimeReact.nonce, context && context.styleContainer);
        var selector = "".concat(attributeSelectorState);
        var innerHTML = "\n@media screen and (max-width: ".concat(props.breakpoint, ") {\n    .p-contextmenu[").concat(selector, "] > ul {\n        max-height: ").concat(props.scrollHeight, ";\n        overflow: ").concat(props.scrollHeight ? 'auto' : '', ";\n    }\n\n    .p-contextmenu[").concat(selector, "] .p-submenu-list {\n        position: relative;\n    }\n\n    .p-contextmenu[").concat(selector, "] .p-menuitem-active > .p-submenu-list {\n        left: 0;\n        box-shadow: none;\n        border-radius: 0;\n        padding: 0 0 0 calc(var(--inline-spacing) * 2); /* @todo */\n    }\n\n    .p-contextmenu[").concat(selector, "] .p-menuitem-active > .p-menuitem-link > .p-submenu-icon {\n        transform: rotate(-180deg);\n    }\n\n    .p-contextmenu[").concat(selector, "] .p-submenu-icon:before {\n        content: \"\\e930\";\n    }\n}\n");
        styleElementRef.current.innerHTML = innerHTML;
      }
    };
    var destroyStyle = function destroyStyle() {
      styleElementRef.current = DomHandler.removeInlineStyle(styleElementRef.current);
    };
    var onMenuClick = function onMenuClick() {
      setResetMenuState(false);
    };
    var onMenuMouseEnter = function onMenuMouseEnter() {
      setResetMenuState(false);
    };
    var show = function show(event) {
      setActiveItemPath([]);
      setFocusedItemInfo({
        index: -1,
        level: 0,
        parentKey: ''
      });
      event.stopPropagation();
      event.preventDefault();
      currentEvent.current = event;
      if (visibleState) {
        setReshowState(true);
      } else {
        setVisibleState(true);
        props.onShow && props.onShow(currentEvent.current);
      }
      Promise.resolve().then(function () {
        listRef.current && DomHandler.focus(listRef.current.getElement());
      });
    };
    var hide = function hide(event) {
      currentEvent.current = event;
      setVisibleState(false);
      setReshowState(false);
      setActiveItemPath([]);
      setFocusedItemInfo({
        index: -1,
        level: 0,
        parentKey: ''
      });
      props.onHide && props.onHide(currentEvent.current);
    };
    var onEnter = function onEnter() {
      DomHandler.addStyles(menuRef.current, {
        position: 'absolute'
      });
      if (props.autoZIndex) {
        ZIndexUtils.set('menu', menuRef.current, context && context.autoZIndex || PrimeReact.autoZIndex, props.baseZIndex || context && context.zIndex['menu'] || PrimeReact.zIndex['menu']);
      }
      position(currentEvent.current);
      if (attributeSelectorState && props.breakpoint) {
        menuRef.current.setAttribute(attributeSelectorState, '');
        createStyle();
      }
    };
    var onEntered = function onEntered() {
      bindDocumentListeners();
    };
    var onExit = function onExit() {
      unbindDocumentListeners();
      ZIndexUtils.clear(menuRef.current);
    };
    var onExited = function onExited() {
      ZIndexUtils.clear(menuRef.current);
      destroyStyle();
    };
    var position = function position(event) {
      if (event) {
        var left = event.pageX + 1;
        var top = event.pageY + 1;
        var width = menuRef.current.offsetParent ? menuRef.current.offsetWidth : DomHandler.getHiddenElementOuterWidth(menuRef.current);
        var height = menuRef.current.offsetParent ? menuRef.current.offsetHeight : DomHandler.getHiddenElementOuterHeight(menuRef.current);
        var viewport = DomHandler.getViewport();

        //flip
        if (left + width - document.body.scrollLeft > viewport.width) {
          left -= width;
        }

        //flip
        if (top + height - document.body.scrollTop > viewport.height) {
          top -= height;
        }

        //fit
        if (left < document.body.scrollLeft) {
          left = document.body.scrollLeft;
        }

        //fit
        if (top < document.body.scrollTop) {
          top = document.body.scrollTop;
        }
        menuRef.current.style.left = left + 'px';
        menuRef.current.style.top = top + 'px';
      }
    };
    var createProcessedItems = function createProcessedItems(items, level) {
      var parent = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
      var parentKey = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : '';
      var processedItems = [];
      items && items.forEach(function (item, index) {
        var key = (parentKey !== '' ? parentKey + '_' : '') + index;
        var newItem = {
          item: item,
          index: index,
          level: level,
          separator: item.separator,
          key: key,
          parent: parent,
          parentKey: parentKey
        };
        newItem['items'] = createProcessedItems(item.items, level + 1, newItem, key);
        processedItems.push(newItem);
      });
      return processedItems;
    };
    var onLeafClick = function onLeafClick(event) {
      setResetMenuState(true);
      hide(event);
      event.stopPropagation();
    };
    var isOutsideClicked = function isOutsideClicked(event) {
      return menuRef && menuRef.current && !(menuRef.current.isSameNode(event.target) || menuRef.current.contains(event.target));
    };
    var bindDocumentListeners = function bindDocumentListeners() {
      bindDocumentResizeListener();
      bindDocumentClickListener();
    };
    var unbindDocumentListeners = function unbindDocumentListeners() {
      unbindDocumentResizeListener();
      unbindDocumentClickListener();
    };
    useMountEffect(function () {
      var uniqueId = UniqueComponentId();
      !idState && setIdState(uniqueId);
      if (props.global) {
        bindDocumentContextMenuListener();
      }
      if (props.breakpoint) {
        !attributeSelectorState && setAttributeSelectorState(uniqueId);
      }
    });
    useUpdateEffect(function () {
      props.global && bindDocumentContextMenuListener();
    }, [props.global]);
    useUpdateEffect(function () {
      if (attributeSelectorState && menuRef.current) {
        menuRef.current.setAttribute(attributeSelectorState, '');
        createStyle();
      }
      return function () {
        destroyStyle();
      };
    }, [attributeSelectorState, props.breakpoint]);
    useUpdateEffect(function () {
      if (visibleState) {
        setVisibleState(false);
        setReshowState(false);
        setResetMenuState(true);
      } else if (!reshowState && !visibleState && resetMenuState) {
        show(currentEvent.current);
      }
    }, [reshowState]);
    useUpdateEffect(function () {
      var itemsToProcess = props.model || [];
      var processed = createProcessedItems(itemsToProcess, 0, null, '');
      setProcessedItems(processed);
    }, [props.model]);
    useUpdateEffect(function () {
      var _focusedItemId = focusedItemInfo.index !== -1 ? "".concat(idState).concat(ObjectUtils.isNotEmpty(focusedItemInfo.parentKey) ? '_' + focusedItemInfo.parentKey : '', "_").concat(focusedItemInfo.index) : null;
      setFocusedItemId(_focusedItemId);
    }, [focusedItemInfo]);
    useUpdateEffect(function () {
      var processedItem = activeItemPath && activeItemPath.find(function (p) {
        return p.key === focusedItemInfo.parentKey;
      });
      var _visibleItems = processedItem ? processedItem.items : processedItems;
      setVisibleItems(_visibleItems);
    }, [activeItemPath, focusedItemInfo]);
    useUpdateEffect(function () {
      if (focusTrigger) {
        var itemIndex = focusedItemInfo.index !== -1 ? findNextItemIndex(focusedItemInfo.index) : findFirstFocusedItemIndex();
        changeFocusedItemIndex(itemIndex);
        setActiveItemPath(activeItemPath.filter(function (p) {
          return p.parentKey !== focusedItemInfo.parentKey;
        }));
        setFocusTrigger(false);
      }
    }, [focusTrigger]);
    useUnmountEffect(function () {
      ZIndexUtils.clear(menuRef.current);
    });
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        show: show,
        hide: hide,
        getElement: function getElement() {
          return menuRef.current;
        }
      };
    });
    var onFocus = function onFocus(event) {
      setFocused(true);
      setFocusedItemInfo(focusedItemInfo.index !== -1 ? focusedItemInfo : {
        index: -1,
        level: 0,
        parentKey: ''
      });
      props.onFocus && props.onFocus(event);
    };
    var onBlur = function onBlur(event) {
      setFocused(false);
      setFocusedItemInfo({
        index: -1,
        level: 0,
        parentKey: ''
      });
      searchValue.current = '';
      searchValue.current = '';
      props.onBlur && props.onBlur(event);
    };
    var onKeyDown = function onKeyDown(event) {
      var metaKey = event.metaKey || event.ctrlKey;
      switch (event.code) {
        case 'ArrowDown':
          onArrowDownKey(event);
          break;
        case 'ArrowUp':
          onArrowUpKey(event);
          break;
        case 'ArrowLeft':
          onArrowLeftKey(event);
          break;
        case 'ArrowRight':
          onArrowRightKey(event);
          break;
        case 'Home':
          onHomeKey(event);
          break;
        case 'End':
          onEndKey(event);
          break;
        case 'Space':
          onSpaceKey(event);
          break;
        case 'Enter':
          onEnterKey(event);
          break;
        case 'Escape':
          onEscapeKey(event);
          break;
        case 'Tab':
          onTabKey(event);
          break;
        case 'PageDown':
        case 'PageUp':
        case 'Backspace':
        case 'ShiftLeft':
        case 'ShiftRight':
          // NOOP
          break;
        default:
          if (!metaKey && ObjectUtils.isPrintableCharacter(event.key)) {
            searchItems(event, event.key);
          }
          break;
      }
    };
    var onItemChange = function onItemChange(event) {
      var processedItem = event.processedItem,
        isFocus = event.isFocus,
        _event$updateState = event.updateState,
        updateState = _event$updateState === void 0 ? true : _event$updateState;
      if (ObjectUtils.isEmpty(processedItem)) return;
      var index = processedItem.index,
        key = processedItem.key,
        level = processedItem.level,
        parentKey = processedItem.parentKey,
        items = processedItem.items;
      var grouped = ObjectUtils.isNotEmpty(items);
      var _activeItemPath = activeItemPath.filter(function (p) {
        return p.parentKey !== parentKey && p.parentKey !== key;
      });
      if (grouped && updateState) {
        _activeItemPath.push(processedItem);
        setVisibleState(true);
      }
      setFocusedItemInfo({
        index: index,
        level: level,
        parentKey: parentKey
      });
      setActiveItemPath(_activeItemPath);
      isFocus && DomHandler.focus(listRef.current.getElement());
    };
    var onItemClick = function onItemClick(event) {
      var processedItem = event.processedItem;
      var grouped = isProccessedItemGroup(processedItem);
      var selected = isSelected(processedItem);
      if (selected) {
        var index = processedItem.index,
          key = processedItem.key,
          level = processedItem.level,
          parentKey = processedItem.parentKey;
        setActiveItemPath(activeItemPath.filter(function (p) {
          return key !== p.key && key.startsWith(p.key);
        }));
        setFocusedItemInfo({
          index: index,
          level: level,
          parentKey: parentKey
        });
        DomHandler.focus(listRef.current.getElement());
      } else {
        grouped ? onItemChange(event) : hide();
      }
    };
    var onItemMouseEnter = function onItemMouseEnter(event) {
      onItemChange(event);
    };
    var onArrowDownKey = function onArrowDownKey(event) {
      var itemIndex = focusedItemInfo.index !== -1 ? findNextItemIndex(focusedItemInfo.index) : findFirstFocusedItemIndex();
      changeFocusedItemIndex(itemIndex);
      event.preventDefault();
    };
    var onArrowUpKey = function onArrowUpKey(event) {
      if (event.altKey) {
        if (focusedItemInfo.index !== -1) {
          var processedItem = visibleItems[focusedItemInfo.index];
          var grouped = isProccessedItemGroup(processedItem);
          !grouped && onItemChange({
            originalEvent: event,
            processedItem: processedItem
          });
        }
        event.preventDefault();
      } else {
        var itemIndex = focusedItemInfo.index !== -1 ? findPrevItemIndex(focusedItemInfo.index) : findLastFocusedItemIndex();
        changeFocusedItemIndex(itemIndex);
        event.preventDefault();
      }
    };
    var onArrowLeftKey = function onArrowLeftKey(event) {
      var processedItem = visibleItems[focusedItemInfo.index];
      var parentItem = activeItemPath.find(function (p) {
        return p.key === processedItem.parentKey;
      });
      var root = ObjectUtils.isEmpty(processedItem.parent);
      if (!root) {
        setFocusedItemInfo({
          index: -1,
          parentKey: parentItem ? parentItem.parentKey : ''
        });
        searchValue.current = '';
        setTimeout(function () {
          return setFocusTrigger(true);
        }, 0);
      }
      event.preventDefault();
    };
    var onArrowRightKey = function onArrowRightKey(event) {
      var processedItem = visibleItems[focusedItemInfo.index];
      var grouped = isProccessedItemGroup(processedItem);
      if (grouped) {
        onItemChange({
          originalEvent: event,
          processedItem: processedItem
        });
        setFocusedItemInfo({
          index: -1,
          parentKey: processedItem.key
        });
        searchValue.current = '';
        setTimeout(function () {
          return setFocusTrigger(true);
        }, 0);
      }
      event.preventDefault();
    };
    var onHomeKey = function onHomeKey(event) {
      changeFocusedItemIndex(findFirstItemIndex());
      event.preventDefault();
    };
    var onEndKey = function onEndKey(event) {
      changeFocusedItemIndex(findLastItemIndex());
      event.preventDefault();
    };
    var onEnterKey = function onEnterKey(event) {
      if (focusedItemInfo.index !== -1) {
        var _element = DomHandler.findSingle(listRef.current.getElement(), "li[id=\"".concat("".concat(focusedItemId), "\"]"));
        var anchorElement = _element && DomHandler.findSingle(_element, 'a[data-pc-section="action"]');
        anchorElement ? anchorElement.click() : _element && _element.click();
        var processedItem = visibleItems[focusedItemInfo.index];
        var grouped = isProccessedItemGroup(processedItem);
        !grouped && setFocusedItemInfo(_objectSpread$1m(_objectSpread$1m({}, focusedItemInfo), {}, {
          index: findFirstFocusedItemIndex()
        }));
      }
      event.preventDefault();
    };
    var onSpaceKey = function onSpaceKey(event) {
      onEnterKey(event);
    };
    var onEscapeKey = function onEscapeKey(event) {
      hide();
      setFocusedItemInfo({
        focusedItemInfo: focusedItemInfo,
        index: findFirstFocusedItemIndex()
      });
      event.preventDefault();
    };
    var onTabKey = function onTabKey(event) {
      if (focusedItemInfo.index !== -1) {
        var processedItem = visibleItems[focusedItemInfo.index];
        var grouped = isProccessedItemGroup(processedItem);
        !grouped && onItemChange({
          originalEvent: event,
          processedItem: processedItem
        });
      }
      hide();
    };
    var searchItems = function searchItems(event, _char) {
      searchValue.current = searchValue.current || '' + _char;
      var itemIndex = -1;
      var matched = false;
      if (focusedItemInfo.index !== -1) {
        itemIndex = visibleItems.slice(focusedItemInfo.index).findIndex(function (processedItem) {
          return isItemMatched(processedItem);
        });
        itemIndex = itemIndex === -1 ? visibleItems.slice(0, focusedItemInfo.index).findIndex(function (processedItem) {
          return isItemMatched(processedItem);
        }) : itemIndex + focusedItemInfo.index;
      } else {
        itemIndex = visibleItems.findIndex(function (processedItem) {
          return isItemMatched(processedItem);
        });
      }
      if (itemIndex !== -1) {
        matched = true;
      }
      if (itemIndex === -1 && focusedItemInfo.index === -1) {
        itemIndex = findFirstFocusedItemIndex();
      }
      if (itemIndex !== -1) {
        changeFocusedItemIndex(itemIndex);
      }
      if (searchTimeout.current) {
        clearTimeout(searchTimeout.current);
      }
      searchTimeout.current = setTimeout(function () {
        searchValue.current = '';
        searchTimeout.current = null;
      }, 500);
      return matched;
    };
    var changeFocusedItemIndex = function changeFocusedItemIndex(index) {
      if (focusedItemInfo.index !== index) {
        setFocusedItemInfo(_objectSpread$1m(_objectSpread$1m({}, focusedItemInfo), {}, {
          index: index
        }));
        scrollInView();
      }
    };
    var scrollInView = function scrollInView() {
      var index = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : -1;
      var _id = index !== -1 ? "".concat(idState, "_").concat(index) : focusedItemId;
      var element = DomHandler.findSingle(listRef.current.getElement(), "li[id=\"".concat(_id, "\"]"));
      if (element) {
        element.scrollIntoView && element.scrollIntoView({
          block: 'nearest',
          inline: 'start'
        });
      }
    };
    var getItemProp = function getItemProp(item, name) {
      return item ? ObjectUtils.getItemValue(item[name]) : undefined;
    };
    var getItemLabel = function getItemLabel(item) {
      return getItemProp(item, 'label');
    };
    var getProccessedItemLabel = function getProccessedItemLabel(processedItem) {
      return processedItem ? getItemLabel(processedItem.item) : undefined;
    };
    var isProccessedItemGroup = function isProccessedItemGroup(processedItem) {
      return processedItem && ObjectUtils.isNotEmpty(processedItem.items);
    };
    var isItemDisabled = function isItemDisabled(item) {
      return getItemProp(item, 'disabled');
    };
    var isItemSeparator = function isItemSeparator(item) {
      return getItemProp(item, 'separator');
    };
    var isValidItem = function isValidItem(processedItem) {
      return !!processedItem && !isItemDisabled(processedItem.item) && !isItemSeparator(processedItem.item);
    };
    var isItemMatched = function isItemMatched(processedItem) {
      return isValidItem(processedItem) && getProccessedItemLabel(processedItem).toLocaleLowerCase().startsWith(searchValue.current.toLocaleLowerCase());
    };
    var findNextItemIndex = function findNextItemIndex(index) {
      var matchedItemIndex = index < visibleItems.length - 1 ? visibleItems.slice(index + 1).findIndex(function (processedItem) {
        return isValidItem(processedItem);
      }) : -1;
      return matchedItemIndex > -1 ? matchedItemIndex + index + 1 : index;
    };
    var findPrevItemIndex = function findPrevItemIndex(index) {
      var matchedItemIndex = index > 0 ? ObjectUtils.findLastIndex(visibleItems.slice(0, index), function (processedItem) {
        return isValidItem(processedItem);
      }) : -1;
      return matchedItemIndex > -1 ? matchedItemIndex : index;
    };
    var isSelected = function isSelected(processedItem) {
      return activeItemPath && activeItemPath.some(function (p) {
        return p.key === processedItem.key;
      });
    };
    var isValidSelectedItem = function isValidSelectedItem(processedItem) {
      return isValidItem(processedItem) && isSelected(processedItem);
    };
    var findFirstItemIndex = function findFirstItemIndex() {
      return visibleItems.findIndex(function (processedItem) {
        return isValidItem(processedItem);
      });
    };
    var findLastItemIndex = function findLastItemIndex() {
      return ObjectUtils.findLastIndex(visibleItems, function (processedItem) {
        return isValidItem(processedItem);
      });
    };
    var findFirstFocusedItemIndex = function findFirstFocusedItemIndex() {
      var selectedIndex = findSelectedItemIndex();
      return selectedIndex < 0 ? findFirstItemIndex() : selectedIndex;
    };
    var findLastFocusedItemIndex = function findLastFocusedItemIndex() {
      var selectedIndex = findSelectedItemIndex();
      return selectedIndex < 0 ? findLastItemIndex() : selectedIndex;
    };
    var findSelectedItemIndex = function findSelectedItemIndex() {
      return visibleItems.findIndex(function (processedItem) {
        return isValidSelectedItem(processedItem);
      });
    };
    var createContextMenu = function createContextMenu() {
      var rootProps = mergeProps({
        id: props.id,
        className: classNames(props.className, cx('root', {
          context: context
        })),
        style: props.style,
        onClick: function onClick(e) {
          return onMenuClick();
        },
        onMouseEnter: function onMouseEnter(e) {
          return onMenuMouseEnter();
        }
      }, ContextMenuBase.getOtherProps(props), ptm('root'));
      var transitionProps = mergeProps({
        classNames: cx('transition'),
        "in": visibleState,
        timeout: {
          enter: 250,
          exit: 0
        },
        options: props.transitionOptions,
        unmountOnExit: true,
        onEnter: onEnter,
        onEntered: onEntered,
        onExit: onExit,
        onExited: onExited
      }, ptm('transition'));
      return /*#__PURE__*/React__namespace.createElement(CSSTransition, _extends({
        nodeRef: menuRef
      }, transitionProps), /*#__PURE__*/React__namespace.createElement("div", _extends({
        ref: menuRef
      }, rootProps), /*#__PURE__*/React__namespace.createElement(ContextMenuSub, {
        ref: listRef,
        ariaLabel: props.ariaLabel,
        ariaLabelledby: props.ariaLabelledby,
        activeItemPath: activeItemPath,
        hostName: "ContextMenu",
        id: idState + '_list',
        role: "menubar",
        tabIndex: props.tabIndex || 0,
        ariaActivedescendant: focused ? focusedItemId : undefined,
        menuId: idState,
        focusedItemId: focused ? focusedItemId : undefined,
        menuProps: props,
        model: processedItems,
        level: 0,
        root: true,
        onItemClick: onItemClick,
        onItemMouseEnter: onItemMouseEnter,
        onFocus: onFocus,
        onBlur: onBlur,
        onKeyDown: onKeyDown,
        resetMenu: resetMenuState,
        onLeafClick: onLeafClick,
        isMobileMode: isMobileMode,
        submenuIcon: props.submenuIcon,
        ptm: ptm,
        cx: cx
      })));
    };
    var element = createContextMenu();
    return /*#__PURE__*/React__namespace.createElement(Portal, {
      element: element,
      appendTo: props.appendTo
    });
  }));
  ContextMenu.displayName = 'ContextMenu';

  var classes$R = {
    header: 'p-datascroller-header',
    footer: 'p-datascroller-footer',
    content: 'p-datascroller-content',
    list: 'p-datascroller-list',
    root: function root(_ref) {
      var props = _ref.props;
      return classNames('p-datascroller p-component', {
        'p-datascroller-inline': props.inline
      });
    }
  };
  var styles$N = "\n@layer primereact {\n    .p-datascroller .p-datascroller-header {\n        text-align: center;\n        padding: .5em .75em;\n        border-bottom: 0 none;\n    }\n    \n    .p-datascroller .p-datascroller-footer {\n        text-align: center;\n        padding: .25em .625em;\n        border-top: 0px none;\n    }\n    \n    .p-datascroller .p-datascroller-content {\n        padding: .25em .625em;\n    }\n    \n    .p-datascroller-inline .p-datascroller-content {\n        overflow: auto;\n    }\n    \n    .p-datascroller .p-datascroller-list {\n        list-style-type: none; \n        margin: 0;\n        padding: 0;\n    }\n}\n";
  var inlineStyles$j = {
    content: function content(_ref2) {
      var props = _ref2.props;
      return {
        maxHeight: props.scrollHeight
      };
    }
  };
  var DataScrollerBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'DataScroller',
      id: null,
      value: null,
      rows: 0,
      inline: false,
      scrollHeight: null,
      loader: false,
      buffer: 0.9,
      style: null,
      className: null,
      onLazyLoad: null,
      emptyMessage: null,
      itemTemplate: null,
      header: null,
      footer: null,
      lazy: false,
      children: undefined
    },
    css: {
      classes: classes$R,
      styles: styles$N,
      inlineStyles: inlineStyles$j
    }
  });

  var DataScroller = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var context = React__namespace.useContext(PrimeReactContext);
    var props = DataScrollerBase.getProps(inProps, context);
    var _React$useState = React__namespace.useState([]),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      dataToRenderState = _React$useState2[0],
      setDataToRenderState = _React$useState2[1];
    var _DataScrollerBase$set = DataScrollerBase.setMetaData({
        props: props
      }),
      ptm = _DataScrollerBase$set.ptm,
      cx = _DataScrollerBase$set.cx,
      sx = _DataScrollerBase$set.sx,
      isUnstyled = _DataScrollerBase$set.isUnstyled;
    useHandleStyle(DataScrollerBase.css.styles, isUnstyled, {
      name: 'datascroller'
    });
    var elementRef = React__namespace.useRef(null);
    var contentRef = React__namespace.useRef(null);
    var value = React__namespace.useRef(props.value);
    var dataToRender = React__namespace.useRef([]);
    var first = React__namespace.useRef(0);
    var scrollFunction = React__namespace.useRef(null);
    var handleDataChange = function handleDataChange() {
      if (props.lazy) {
        dataToRender.current = value.current;
        setDataToRenderState(_toConsumableArray(dataToRender.current));
      } else {
        load();
      }
    };
    var load = function load() {
      if (props.lazy) {
        if (props.onLazyLoad) {
          props.onLazyLoad(createLazyLoadMetadata());
        }
        first.current += props.rows;
      } else {
        if (value.current) {
          for (var i = first.current; i < first.current + props.rows; i++) {
            if (i >= value.current.length) {
              break;
            }
            dataToRender.current.push(value.current[i]);
          }
          if (value.current.length !== 0) {
            first.current += props.rows;
          }
          setDataToRenderState(_toConsumableArray(dataToRender.current));
        }
      }
    };
    var reset = function reset() {
      first.current = 0;
      dataToRender.current = [];
      setDataToRenderState(_toConsumableArray(dataToRender.current));
      load();
    };
    var createLazyLoadMetadata = function createLazyLoadMetadata() {
      return {
        first: first.current,
        rows: props.rows
      };
    };
    var bindScrollListener = function bindScrollListener() {
      if (props.inline) {
        scrollFunction.current = function () {
          var scrollTop = contentRef.current.scrollTop,
            scrollHeight = contentRef.current.scrollHeight,
            viewportHeight = contentRef.current.clientHeight;
          if (scrollTop >= scrollHeight * props.buffer - viewportHeight) {
            load();
          }
        };
        contentRef.current.addEventListener('scroll', scrollFunction.current);
      } else {
        scrollFunction.current = function () {
          var docBody = document.body,
            docElement = document.documentElement,
            scrollTop = window.pageYOffset || document.documentElement.scrollTop,
            winHeight = docElement.clientHeight,
            docHeight = Math.max(docBody.scrollHeight, docBody.offsetHeight, winHeight, docElement.scrollHeight, docElement.offsetHeight);
          if (scrollTop >= docHeight * props.buffer - winHeight) {
            load();
          }
        };
        window.addEventListener('scroll', scrollFunction.current);
      }
    };
    var unbindScrollListener = function unbindScrollListener() {
      if (scrollFunction.current) {
        if (props.inline && contentRef.current) {
          contentRef.current.removeEventListener('scroll', scrollFunction.current);
        } else if (!props.loader) {
          window.removeEventListener('scroll', scrollFunction.current);
        }
      }
      scrollFunction.current = null;
    };
    useMountEffect(function () {
      load();
      if (!props.loader) {
        bindScrollListener();
      }
    });
    useUpdateEffect(function () {
      if (props.value) {
        value.current = props.value;
        if (!props.lazy) {
          first.current = 0;
        }
        dataToRender.current = [];
        handleDataChange();
      }
    }, [props.value]);
    useUpdateEffect(function () {
      if (props.loader) {
        unbindScrollListener();
      }
    }, [props.loader]);
    useUnmountEffect(function () {
      if (scrollFunction.current) {
        unbindScrollListener();
      }
    });
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        load: load,
        reset: reset,
        getElement: function getElement() {
          return elementRef.current;
        },
        getContent: function getContent() {
          return contentRef.current;
        }
      };
    });
    var createHeader = function createHeader() {
      var headerProps = mergeProps({
        className: cx('header')
      }, ptm('header'));
      if (props.header) {
        return /*#__PURE__*/React__namespace.createElement("div", headerProps, props.header);
      }
      return null;
    };
    var createFooter = function createFooter() {
      var footerProps = mergeProps({
        className: cx('footer')
      }, ptm('footer'));
      if (props.footer) {
        return /*#__PURE__*/React__namespace.createElement("div", footerProps, props.footer);
      }
      return null;
    };
    var createItem = function createItem(_value, index) {
      var itemProps = mergeProps({
        key: index + '_datascrollitem'
      }, ptm('item'));
      var content = props.itemTemplate ? props.itemTemplate(_value) : _value;
      return /*#__PURE__*/React__namespace.createElement("li", itemProps, content);
    };
    var createEmptyMessage = function createEmptyMessage() {
      var emptyMessageProps = mergeProps(ptm('emptyMessage'));
      var content = ObjectUtils.getJSXElement(props.emptyMessage, props) || localeOption('emptyMessage');
      return /*#__PURE__*/React__namespace.createElement("li", emptyMessageProps, content);
    };
    var createContent = function createContent() {
      var contentProps = mergeProps({
        ref: contentRef,
        className: cx('content'),
        style: sx('content')
      }, ptm('content'));
      var listProps = mergeProps({
        className: cx('list')
      }, ptm('list'));
      var content = ObjectUtils.isNotEmpty(dataToRenderState) ? dataToRenderState.map(createItem) : createEmptyMessage();
      return /*#__PURE__*/React__namespace.createElement("div", contentProps, /*#__PURE__*/React__namespace.createElement("ul", listProps, content));
    };
    var header = createHeader();
    var footer = createFooter();
    var content = createContent();
    var rootProps = mergeProps({
      id: props.id,
      ref: elementRef,
      className: classNames(props.className, cx('root'))
    }, DataScrollerBase.getOtherProps(props), ptm('root'));
    return /*#__PURE__*/React__namespace.createElement("div", rootProps, header, content, footer);
  }));
  DataScroller.displayName = 'DataScroller';

  var ColumnBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'Column',
      align: null,
      alignFrozen: 'left',
      alignHeader: null,
      body: null,
      bodyClassName: null,
      bodyStyle: null,
      cellEditValidator: null,
      cellEditValidatorEvent: 'click',
      className: null,
      colSpan: null,
      columnKey: null,
      dataType: 'text',
      editor: null,
      excludeGlobalFilter: false,
      expander: false,
      exportField: null,
      exportable: true,
      field: null,
      filter: false,
      filterApply: null,
      filterClear: null,
      filterElement: null,
      filterField: null,
      filterFooter: null,
      filterFunction: null,
      filterHeader: null,
      filterHeaderClassName: null,
      filterHeaderStyle: null,
      filterMatchMode: null,
      filterMatchModeOptions: null,
      filterMaxLength: null,
      filterMenuClassName: null,
      filterMenuStyle: null,
      filterPlaceholder: null,
      filterType: 'text',
      footer: null,
      footerClassName: null,
      footerStyle: null,
      frozen: false,
      header: null,
      headerClassName: null,
      headerStyle: null,
      headerTooltip: null,
      headerTooltipOptions: null,
      hidden: false,
      maxConstraints: 2,
      onBeforeCellEditHide: null,
      onBeforeCellEditShow: null,
      onCellEditCancel: null,
      onCellEditComplete: null,
      onCellEditInit: null,
      onFilterApplyClick: null,
      onFilterClear: null,
      onFilterConstraintAdd: null,
      onFilterConstraintRemove: null,
      onFilterMatchModeChange: null,
      onFilterOperatorChange: null,
      reorderable: true,
      resizeable: true,
      rowEditor: false,
      rowReorder: false,
      rowReorderIcon: null,
      rowSpan: null,
      selectionMode: null,
      showAddButton: true,
      showApplyButton: true,
      showClearButton: true,
      showFilterMatchModes: true,
      showFilterMenu: true,
      showFilterMenuOptions: true,
      showFilterOperator: true,
      sortField: null,
      sortFunction: null,
      sortable: false,
      sortableDisabled: false,
      style: null,
      children: undefined
    },
    getCProp: function getCProp(column, name) {
      return ObjectUtils.getComponentProp(column, name, ColumnBase.defaultProps);
    },
    getCProps: function getCProps(column) {
      return ObjectUtils.getComponentProps(column, ColumnBase.defaultProps);
    },
    getCOtherProps: function getCOtherProps(column) {
      return ObjectUtils.getComponentDiffProps(column, ColumnBase.defaultProps);
    }
  });

  var classes$Q = {
    root: 'p-paginator p-component',
    left: 'p-paginator-left-content',
    end: 'p-paginator-right-content',
    firstPageIcon: 'p-paginator-icon',
    firstPageButton: function firstPageButton(_ref) {
      var disabled = _ref.disabled;
      return classNames('p-paginator-first p-paginator-element p-link', {
        'p-disabled': disabled
      });
    },
    prevPageIcon: 'p-paginator-icon',
    prevPageButton: function prevPageButton(_ref2) {
      var disabled = _ref2.disabled;
      return classNames('p-paginator-prev p-paginator-element p-link', {
        'p-disabled': disabled
      });
    },
    nextPageIcon: 'p-paginator-icon',
    nextPageButton: function nextPageButton(_ref3) {
      var disabled = _ref3.disabled;
      return classNames('p-paginator-next p-paginator-element p-link', {
        'p-disabled': disabled
      });
    },
    lastPageIcon: 'p-paginator-icon',
    lastPageButton: function lastPageButton(_ref4) {
      var disabled = _ref4.disabled;
      return classNames('p-paginator-last p-paginator-element p-link', {
        'p-disabled': disabled
      });
    },
    pageButton: function pageButton(_ref5) {
      var pageLink = _ref5.pageLink,
        startPageInView = _ref5.startPageInView,
        endPageInView = _ref5.endPageInView,
        page = _ref5.page;
      return classNames('p-paginator-page p-paginator-element p-link', {
        'p-paginator-page-start': pageLink === startPageInView,
        'p-paginator-page-end': pageLink === endPageInView,
        'p-highlight': pageLink - 1 === page
      });
    },
    pages: 'p-paginator-pages'
  };
  var styles$M = "\n@layer primereact {\n    .p-paginator {\n        display: flex;\n        align-items: center;\n        justify-content: center;\n        flex-wrap: wrap;\n    }\n    \n    .p-paginator-left-content {\n        margin-right: auto;\n    }\n    \n    .p-paginator-right-content {\n        margin-left: auto;\n    }\n    \n    .p-paginator-page,\n    .p-paginator-next,\n    .p-paginator-last,\n    .p-paginator-first,\n    .p-paginator-prev,\n    .p-paginator-current {\n        cursor: pointer;\n        display: inline-flex;\n        align-items: center;\n        justify-content: center;\n        line-height: 1;\n        user-select: none;\n        overflow: hidden;\n        position: relative;\n    }\n    \n    .p-paginator-element:focus {\n        z-index: 1;\n        position: relative;\n    }\n}\n";
  var PaginatorBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'Paginator',
      __parentMetadata: null,
      totalRecords: 0,
      rows: 0,
      first: 0,
      pageLinkSize: 5,
      rowsPerPageOptions: null,
      alwaysShow: true,
      style: null,
      className: null,
      template: 'FirstPageLink PrevPageLink PageLinks NextPageLink LastPageLink RowsPerPageDropdown',
      onPageChange: null,
      leftContent: null,
      rightContent: null,
      dropdownAppendTo: null,
      currentPageReportTemplate: '({currentPage} of {totalPages})',
      children: undefined
    },
    css: {
      classes: classes$Q,
      styles: styles$M
    }
  });
  var CurrentPageReportBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'CurrentPageReport',
      pageCount: null,
      page: null,
      first: null,
      rows: null,
      totalRecords: null,
      reportTemplate: '({currentPage} of {totalPages})',
      template: null,
      children: undefined
    }
  });
  var FirstPageLinkBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'FirstPageLink',
      disabled: false,
      onClick: null,
      template: null,
      firstPageLinkIcon: null,
      children: undefined
    }
  });
  var JumpToPageInputBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'JumpToPageInput',
      page: null,
      rows: null,
      pageCount: null,
      disabled: false,
      template: null,
      onChange: null,
      children: undefined,
      metaData: null,
      ptm: null
    }
  });
  var LastPageLinkBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'LastPageLink',
      disabled: false,
      onClick: null,
      template: null,
      lastPageLinkIcon: null,
      children: undefined
    }
  });
  var NextPageLinkBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'NextPageLink',
      disabled: false,
      onClick: null,
      template: null,
      nextPageLinkIcon: null,
      children: undefined
    }
  });
  var PageLinksBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'PageLinks',
      value: null,
      page: null,
      rows: null,
      pageCount: null,
      links: null,
      template: null,
      children: undefined
    }
  });
  var PrevPageLinkBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'PrevPageLink',
      disabled: false,
      onClick: null,
      template: null,
      prevPageLinkIcon: null,
      children: undefined
    }
  });
  var RowsPerPageDropdownBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'RowsPerPageDropdown',
      options: null,
      value: null,
      page: null,
      pageCount: null,
      totalRecords: 0,
      appendTo: null,
      onChange: null,
      template: null,
      disabled: false,
      children: undefined
    }
  });

  function ownKeys$1l(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1l(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1l(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1l(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var CurrentPageReport = /*#__PURE__*/React__namespace.memo(function (inProps) {
    var context = React__namespace.useContext(PrimeReactContext);
    var props = CurrentPageReportBase.getProps(inProps, context);
    var report = {
      currentPage: props.page + 1,
      totalPages: props.pageCount,
      first: Math.min(props.first + 1, props.totalRecords),
      last: Math.min(props.first + props.rows, props.totalRecords),
      rows: props.rows,
      totalRecords: props.totalRecords
    };
    var text = props.reportTemplate.replace('{currentPage}', report.currentPage).replace('{totalPages}', report.totalPages).replace('{first}', report.first).replace('{last}', report.last).replace('{rows}', report.rows).replace('{totalRecords}', report.totalRecords);
    var currentProps = mergeProps({
      className: 'p-paginator-current'
    }, props.ptm('current', {
      hostName: props.hostName
    }));
    var element = /*#__PURE__*/React__namespace.createElement("span", currentProps, text);
    if (props.template) {
      var defaultOptions = _objectSpread$1l(_objectSpread$1l({}, report), {
        className: 'p-paginator-current',
        element: element,
        props: props
      });
      return ObjectUtils.getJSXElement(props.template, defaultOptions);
    }
    return element;
  });
  CurrentPageReport.displayName = 'CurrentPageReport';

  function ownKeys$1k(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1k(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1k(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1k(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var FirstPageLink = /*#__PURE__*/React__namespace.memo(function (inProps) {
    var context = React__namespace.useContext(PrimeReactContext);
    var props = FirstPageLinkBase.getProps(inProps, context);
    var ptm = props.ptm,
      cx = props.cx;
    var getPTOptions = function getPTOptions(key) {
      return ptm(key, {
        hostName: props.hostName,
        context: {
          disabled: props.disabled
        }
      });
    };
    var className = classNames('p-paginator-first p-paginator-element p-link', {
      'p-disabled': props.disabled
    });
    var iconClassName = 'p-paginator-icon';
    var firstPageIconProps = mergeProps({
      className: cx('firstPageIcon')
    }, getPTOptions('firstPageIcon'));
    var icon = props.firstPageLinkIcon || /*#__PURE__*/React__namespace.createElement(AngleDoubleLeftIcon, firstPageIconProps);
    var firstPageLinkIcon = IconUtils.getJSXIcon(icon, _objectSpread$1k({}, firstPageIconProps), {
      props: props
    });
    var firstPageButtonProps = mergeProps({
      type: 'button',
      className: cx('firstPageButton', {
        disabled: props.disabled
      }),
      onClick: props.onClick,
      disabled: props.disabled,
      'aria-label': ariaLabel('firstPageLabel')
    }, getPTOptions('firstPageButton'));
    var element = /*#__PURE__*/React__namespace.createElement("button", firstPageButtonProps, firstPageLinkIcon, /*#__PURE__*/React__namespace.createElement(Ripple, null));
    if (props.template) {
      var defaultOptions = {
        onClick: props.onClick,
        className: className,
        iconClassName: iconClassName,
        disabled: props.disabled,
        element: element,
        props: props
      };
      return ObjectUtils.getJSXElement(props.template, defaultOptions);
    }
    return element;
  });
  FirstPageLink.displayName = 'FirstPageLink';

  var classes$P = {
    root: function root(_ref) {
      var props = _ref.props,
        focusedState = _ref.focusedState,
        stacked = _ref.stacked,
        horizontal = _ref.horizontal,
        vertical = _ref.vertical;
      return classNames('p-inputnumber p-component p-inputwrapper', {
        'p-inputwrapper-filled': props.value != null && props.value.toString().length > 0,
        'p-inputwrapper-focus': focusedState,
        'p-inputnumber-buttons-stacked': stacked,
        'p-inputnumber-buttons-horizontal': horizontal,
        'p-inputnumber-buttons-vertical': vertical
      });
    },
    buttonGroup: 'p-inputnumber-button-group',
    incrementButton: function incrementButton(_ref2) {
      var props = _ref2.props;
      return classNames('p-inputnumber-button p-inputnumber-button-up p-button p-button-icon-only p-component', {
        'p-disabled': props.disabled
      });
    },
    incrementIcon: 'p-button-icon',
    decrementButton: function decrementButton(_ref3) {
      var props = _ref3.props;
      return classNames('p-inputnumber-button p-inputnumber-button-down p-button p-button-icon-only p-component', {
        'p-disabled': props.disabled
      });
    },
    decrementIcon: 'p-button-icon'
  };
  var styles$L = "\n@layer primereact {\n    .p-inputnumber {\n        display: inline-flex;\n    }\n    \n    .p-inputnumber-button {\n        display: flex;\n        align-items: center;\n        justify-content: center;\n        flex: 0 0 auto;\n    }\n    \n    .p-inputnumber-buttons-stacked .p-button.p-inputnumber-button .p-button-label,\n    .p-inputnumber-buttons-horizontal .p-button.p-inputnumber-button .p-button-label {\n        display: none;\n    }\n    \n    .p-inputnumber-buttons-stacked .p-button.p-inputnumber-button-up {\n        border-top-left-radius: 0;\n        border-bottom-left-radius: 0;\n        border-bottom-right-radius: 0;\n        padding: 0;\n    }\n    \n    .p-inputnumber-buttons-stacked .p-inputnumber-input {\n        border-top-right-radius: 0;\n        border-bottom-right-radius: 0;\n    }\n    \n    .p-inputnumber-buttons-stacked .p-button.p-inputnumber-button-down {\n        border-top-left-radius: 0;\n        border-top-right-radius: 0;\n        border-bottom-left-radius: 0;\n        padding: 0;\n    }\n    \n    .p-inputnumber-buttons-stacked .p-inputnumber-button-group {\n        display: flex;\n        flex-direction: column;\n    }\n    \n    .p-inputnumber-buttons-stacked .p-inputnumber-button-group .p-button.p-inputnumber-button {\n        flex: 1 1 auto;\n    }\n    \n    .p-inputnumber-buttons-horizontal .p-button.p-inputnumber-button-up {\n        order: 3;\n        border-top-left-radius: 0;\n        border-bottom-left-radius: 0;\n    }\n    \n    .p-inputnumber-buttons-horizontal .p-inputnumber-input {\n        order: 2;\n        border-radius: 0;\n    }\n    \n    .p-inputnumber-buttons-horizontal .p-button.p-inputnumber-button-down {\n        order: 1;\n        border-top-right-radius: 0;\n        border-bottom-right-radius: 0;\n    }\n    \n    .p-inputnumber-buttons-vertical {\n        flex-direction: column;\n    }\n    \n    .p-inputnumber-buttons-vertical .p-button.p-inputnumber-button-up {\n        order: 1;\n        border-bottom-left-radius: 0;\n        border-bottom-right-radius: 0;\n        width: 100%;\n    }\n    \n    .p-inputnumber-buttons-vertical .p-inputnumber-input {\n        order: 2;\n        border-radius: 0;\n        text-align: center;\n    }\n    \n    .p-inputnumber-buttons-vertical .p-button.p-inputnumber-button-down {\n        order: 3;\n        border-top-left-radius: 0;\n        border-top-right-radius: 0;\n        width: 100%;\n    }\n    \n    .p-inputnumber-input {\n        flex: 1 1 auto;\n    }\n    \n    .p-fluid .p-inputnumber {\n        width: 100%;\n    }\n    \n    .p-fluid .p-inputnumber .p-inputnumber-input {\n        width: 1%;\n    }\n    \n    .p-fluid .p-inputnumber-buttons-vertical .p-inputnumber-input {\n        width: 100%;\n    }\n}\n";
  var InputNumberBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'InputNumber',
      __parentMetadata: null,
      allowEmpty: true,
      ariaLabelledBy: null,
      autoFocus: false,
      buttonLayout: 'stacked',
      className: null,
      currency: undefined,
      currencyDisplay: undefined,
      decrementButtonClassName: null,
      decrementButtonIcon: null,
      disabled: false,
      format: true,
      id: null,
      incrementButtonClassName: null,
      incrementButtonIcon: null,
      inputClassName: null,
      inputId: null,
      inputMode: null,
      inputRef: null,
      inputStyle: null,
      locale: undefined,
      localeMatcher: undefined,
      max: null,
      maxFractionDigits: undefined,
      maxLength: null,
      min: null,
      minFractionDigits: undefined,
      mode: 'decimal',
      name: null,
      onBlur: null,
      onChange: null,
      onFocus: null,
      onKeyDown: null,
      onKeyUp: null,
      onValueChange: null,
      pattern: null,
      placeholder: null,
      prefix: null,
      readOnly: false,
      required: false,
      roundingMode: undefined,
      showButtons: false,
      size: null,
      step: 1,
      style: null,
      suffix: null,
      tabIndex: null,
      tooltip: null,
      tooltipOptions: null,
      type: 'text',
      useGrouping: true,
      value: null,
      children: undefined
    },
    css: {
      classes: classes$P,
      styles: styles$L
    }
  });

  function ownKeys$1j(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1j(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1j(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1j(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var InputNumber = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var context = React__namespace.useContext(PrimeReactContext);
    var props = InputNumberBase.getProps(inProps, context);
    var _React$useState = React__namespace.useState(false),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      focusedState = _React$useState2[0],
      setFocusedState = _React$useState2[1];
    var metaData = _objectSpread$1j(_objectSpread$1j({
      props: props
    }, props.__parentMetadata), {}, {
      state: {
        focused: focusedState
      }
    });
    var _InputNumberBase$setM = InputNumberBase.setMetaData(metaData),
      ptm = _InputNumberBase$setM.ptm,
      cx = _InputNumberBase$setM.cx,
      isUnstyled = _InputNumberBase$setM.isUnstyled;
    useHandleStyle(InputNumberBase.css.styles, isUnstyled, {
      name: 'inputnumber'
    });
    var elementRef = React__namespace.useRef(null);
    var inputRef = React__namespace.useRef(null);
    var timer = React__namespace.useRef(null);
    var lastValue = React__namespace.useRef(null);
    var numberFormat = React__namespace.useRef(null);
    var groupChar = React__namespace.useRef(null);
    var prefixChar = React__namespace.useRef(null);
    var suffixChar = React__namespace.useRef(null);
    var isSpecialChar = React__namespace.useRef(null);
    var _numeral = React__namespace.useRef(null);
    var _group = React__namespace.useRef(null);
    var _minusSign = React__namespace.useRef(null);
    var _currency = React__namespace.useRef(null);
    var _decimal = React__namespace.useRef(null);
    var _decimalSeparator = React__namespace.useRef(null);
    var _suffix = React__namespace.useRef(null);
    var _prefix = React__namespace.useRef(null);
    var _index = React__namespace.useRef(null);
    var isFocusedByClick = React__namespace.useRef(false);
    var _locale = props.locale || context && context.locale || PrimeReact.locale;
    var stacked = props.showButtons && props.buttonLayout === 'stacked';
    var horizontal = props.showButtons && props.buttonLayout === 'horizontal';
    var vertical = props.showButtons && props.buttonLayout === 'vertical';
    var inputMode = props.inputMode || (props.mode === 'decimal' && !props.minFractionDigits ? 'numeric' : 'decimal');
    var getOptions = function getOptions() {
      return {
        localeMatcher: props.localeMatcher,
        style: props.mode,
        currency: props.currency,
        currencyDisplay: props.currencyDisplay,
        useGrouping: props.useGrouping,
        minimumFractionDigits: props.minFractionDigits,
        maximumFractionDigits: props.maxFractionDigits,
        roundingMode: props.roundingMode
      };
    };
    var constructParser = function constructParser() {
      numberFormat.current = new Intl.NumberFormat(_locale, getOptions());
      var numerals = _toConsumableArray(new Intl.NumberFormat(_locale, {
        useGrouping: false
      }).format(9876543210)).reverse();
      var index = new Map(numerals.map(function (d, i) {
        return [d, i];
      }));
      _numeral.current = new RegExp("[".concat(numerals.join(''), "]"), 'g');
      _group.current = getGroupingExpression(); // regular expression /[,]/g, /[.]/g
      _minusSign.current = getMinusSignExpression(); // regular expression /[-]/g
      _currency.current = getCurrencyExpression(); // regular expression for currency (e.g. /[$]/g, /[€]/g, /[]/g and more)
      _decimal.current = getDecimalExpression(); // regular expression /[,]/g, /[.]/g, /[]/g
      _decimalSeparator.current = getDecimalSeparator(); // current decimal separator  '.', ','
      _suffix.current = getSuffixExpression(); // regular expression for suffix (e.g. /℃/g)
      _prefix.current = getPrefixExpression(); // regular expression for prefix (e.g. /\ days/g)
      _index.current = function (d) {
        return index.get(d);
      };
    };
    var escapeRegExp = function escapeRegExp(text) {
      return text.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, '\\$&');
    };

    /**
     * get decimal separator in current locale
     */
    var getDecimalSeparator = function getDecimalSeparator() {
      return new Intl.NumberFormat(_locale, {
        useGrouping: false
      }).format(1.1).trim().replace(_numeral.current, '');
    };
    var getDecimalExpression = function getDecimalExpression() {
      var formatter = new Intl.NumberFormat(_locale, _objectSpread$1j(_objectSpread$1j({}, getOptions()), {}, {
        useGrouping: false
      }));
      return new RegExp("[".concat(formatter.format(1.1).replace(_currency.current, '').trim().replace(_numeral.current, ''), "]"), 'g');
    };
    var getGroupingExpression = function getGroupingExpression() {
      var formatter = new Intl.NumberFormat(_locale, {
        useGrouping: true
      });
      groupChar.current = formatter.format(1000000).trim().replace(_numeral.current, '').charAt(0);
      return new RegExp("[".concat(groupChar.current, "]"), 'g');
    };
    var getMinusSignExpression = function getMinusSignExpression() {
      var formatter = new Intl.NumberFormat(_locale, {
        useGrouping: false
      });
      return new RegExp("[".concat(formatter.format(-1).trim().replace(_numeral.current, ''), "]"), 'g');
    };
    var getCurrencyExpression = function getCurrencyExpression() {
      if (props.currency) {
        var formatter = new Intl.NumberFormat(_locale, {
          style: 'currency',
          currency: props.currency,
          currencyDisplay: props.currencyDisplay,
          minimumFractionDigits: 0,
          maximumFractionDigits: 0,
          roundingMode: props.roundingMode
        });
        return new RegExp("[".concat(formatter.format(1).replace(/\s/g, '').replace(_numeral.current, '').replace(_group.current, ''), "]"), 'g');
      }
      return new RegExp("[]", 'g');
    };
    var getPrefixExpression = function getPrefixExpression() {
      if (props.prefix) {
        prefixChar.current = props.prefix;
      } else {
        var formatter = new Intl.NumberFormat(_locale, {
          style: props.mode,
          currency: props.currency,
          currencyDisplay: props.currencyDisplay
        });
        prefixChar.current = formatter.format(1).split('1')[0];
      }
      return new RegExp("".concat(escapeRegExp(prefixChar.current || '')), 'g');
    };
    var getSuffixExpression = function getSuffixExpression() {
      if (props.suffix) {
        suffixChar.current = props.suffix;
      } else {
        var formatter = new Intl.NumberFormat(_locale, {
          style: props.mode,
          currency: props.currency,
          currencyDisplay: props.currencyDisplay,
          minimumFractionDigits: 0,
          maximumFractionDigits: 0,
          roundingMode: props.roundingMode
        });
        suffixChar.current = formatter.format(1).split('1')[1];
      }
      return new RegExp("".concat(escapeRegExp(suffixChar.current || '')), 'g');
    };
    var formatValue = function formatValue(value) {
      if (value != null) {
        if (value === '-') {
          // Minus sign
          return value;
        }
        if (props.format) {
          var formatter = new Intl.NumberFormat(_locale, getOptions());
          var _formattedValue = formatter.format(value);
          if (props.prefix) {
            _formattedValue = props.prefix + _formattedValue;
          }
          if (props.suffix) {
            _formattedValue = _formattedValue + props.suffix;
          }
          return _formattedValue;
        }
        return value.toString();
      }
      return '';
    };
    var parseValue = function parseValue(text) {
      var filteredText = text.replace(_suffix.current, '').replace(_prefix.current, '').trim().replace(/\s/g, '').replace(_currency.current, '').replace(_group.current, '').replace(_minusSign.current, '-').replace(_decimal.current, '.').replace(_numeral.current, _index.current);
      if (filteredText) {
        if (filteredText === '-')
          // Minus sign
          return filteredText;
        var parsedValue = +filteredText;
        return isNaN(parsedValue) ? null : parsedValue;
      }
      return null;
    };
    var repeat = function repeat(event, interval, dir) {
      var i = interval || 500;
      clearTimer();
      timer.current = setTimeout(function () {
        repeat(event, 40, dir);
      }, i);
      spin(event, dir);
    };
    var spin = function spin(event, dir) {
      if (inputRef.current) {
        var step = props.step * dir;
        var currentValue = parseValue(inputRef.current.value) || 0;
        var newValue = validateValue(currentValue + step);
        if (props.maxLength && props.maxLength < formatValue(newValue).length) {
          return;
        }

        // #3913 onChange should be called before onValueChange
        handleOnChange(event, currentValue, newValue);
        // touch devices trigger the keyboard to display because of setSelectionRange
        !DomHandler.isTouchDevice() && updateInput(newValue, null, 'spin');
        updateModel(event, newValue);
      }
    };
    var onUpButtonMouseDown = function onUpButtonMouseDown(event) {
      if (!props.disabled && !props.readOnly) {
        DomHandler.focus(inputRef.current, props.autoFocus);
        repeat(event, null, 1);
        event.preventDefault();
      }
    };
    var onUpButtonMouseUp = function onUpButtonMouseUp() {
      if (!props.disabled && !props.readOnly) {
        clearTimer();
      }
    };
    var onUpButtonMouseLeave = function onUpButtonMouseLeave() {
      if (!props.disabled && !props.readOnly) {
        clearTimer();
      }
    };
    var onUpButtonKeyUp = function onUpButtonKeyUp() {
      if (!props.disabled && !props.readOnly) {
        clearTimer();
      }
    };
    var onUpButtonKeyDown = function onUpButtonKeyDown(event) {
      if (!props.disabled && !props.readOnly && (event.keyCode === 32 || event.keyCode === 13)) {
        repeat(event, null, 1);
      }
    };
    var onDownButtonMouseDown = function onDownButtonMouseDown(event) {
      if (!props.disabled && !props.readOnly) {
        DomHandler.focus(inputRef.current, props.autoFocus);
        repeat(event, null, -1);
        event.preventDefault();
      }
    };
    var onDownButtonMouseUp = function onDownButtonMouseUp() {
      if (!props.disabled && !props.readOnly) {
        clearTimer();
      }
    };
    var onDownButtonMouseLeave = function onDownButtonMouseLeave() {
      if (!props.disabled && !props.readOnly) {
        clearTimer();
      }
    };
    var onDownButtonKeyUp = function onDownButtonKeyUp() {
      if (!props.disabled && !props.readOnly) {
        clearTimer();
      }
    };
    var onDownButtonKeyDown = function onDownButtonKeyDown(event) {
      if (!props.disabled && !props.readOnly && (event.keyCode === 32 || event.keyCode === 13)) {
        repeat(event, null, -1);
      }
    };
    var onInput = function onInput(event) {
      if (props.disabled || props.readOnly) {
        return;
      }
      if (isSpecialChar.current) {
        event.target.value = lastValue.current;
      }
      isSpecialChar.current = false;
    };
    var onInputKeyDown = function onInputKeyDown(event) {
      if (props.disabled || props.readOnly) {
        return;
      }
      if (props.onKeyDown) {
        props.onKeyDown(event);

        // do not continue if the user defined event wants to prevent
        if (event.defaultPrevented) {
          return;
        }
      }
      lastValue.current = event.target.value;
      if (event.shiftKey || event.altKey) {
        isSpecialChar.current = true;
        return;
      }
      var selectionStart = event.target.selectionStart;
      var selectionEnd = event.target.selectionEnd;
      var inputValue = event.target.value;
      var newValueStr = null;
      if (event.altKey) {
        event.preventDefault();
      }
      switch (event.which) {
        //up
        case 38:
          spin(event, 1);
          event.preventDefault();
          break;

        //down
        case 40:
          spin(event, -1);
          event.preventDefault();
          break;

        //left
        case 37:
          if (!isNumeralChar(inputValue.charAt(selectionStart - 1))) {
            event.preventDefault();
          }
          break;

        //right
        case 39:
          if (!isNumeralChar(inputValue.charAt(selectionStart))) {
            event.preventDefault();
          }
          break;

        //enter and tab
        case 13:
        case 9:
          newValueStr = validateValue(parseValue(inputValue));
          inputRef.current.value = formatValue(newValueStr);
          inputRef.current.setAttribute('aria-valuenow', newValueStr);
          updateModel(event, newValueStr);
          break;

        //backspace
        case 8:
          event.preventDefault();
          if (selectionStart === selectionEnd) {
            var deleteChar = inputValue.charAt(selectionStart - 1);
            if (isNumeralChar(deleteChar)) {
              var _getDecimalCharIndexe = getDecimalCharIndexes(inputValue),
                decimalCharIndex = _getDecimalCharIndexe.decimalCharIndex,
                decimalCharIndexWithoutPrefix = _getDecimalCharIndexe.decimalCharIndexWithoutPrefix;
              var decimalLength = getDecimalLength(inputValue);
              if (_group.current.test(deleteChar)) {
                _group.current.lastIndex = 0;
                newValueStr = inputValue.slice(0, selectionStart - 2) + inputValue.slice(selectionStart - 1);
              } else if (_decimal.current.test(deleteChar)) {
                _decimal.current.lastIndex = 0;
                if (decimalLength) {
                  inputRef.current.setSelectionRange(selectionStart - 1, selectionStart - 1);
                } else {
                  newValueStr = inputValue.slice(0, selectionStart - 1) + inputValue.slice(selectionStart);
                }
              } else if (decimalCharIndex > 0 && selectionStart > decimalCharIndex) {
                var insertedText = isDecimalMode() && (props.minFractionDigits || 0) < decimalLength ? '' : '0';
                newValueStr = inputValue.slice(0, selectionStart - 1) + insertedText + inputValue.slice(selectionStart);
              } else if (decimalCharIndexWithoutPrefix === 1) {
                newValueStr = inputValue.slice(0, selectionStart - 1) + '0' + inputValue.slice(selectionStart);
                newValueStr = parseValue(newValueStr) > 0 ? newValueStr : '';
              } else {
                newValueStr = inputValue.slice(0, selectionStart - 1) + inputValue.slice(selectionStart);
              }
            } else if (_currency.current.test(deleteChar)) {
              var _getCharIndexes = getCharIndexes(inputValue),
                minusCharIndex = _getCharIndexes.minusCharIndex,
                currencyCharIndex = _getCharIndexes.currencyCharIndex;
              if (minusCharIndex === currencyCharIndex - 1) {
                newValueStr = inputValue.slice(0, minusCharIndex) + inputValue.slice(selectionStart);
              }
            }
            updateValue(event, newValueStr, null, 'delete-single');
          } else {
            newValueStr = deleteRange(inputValue, selectionStart, selectionEnd);
            updateValue(event, newValueStr, null, 'delete-range');
          }
          break;

        // del
        case 46:
          event.preventDefault();
          if (selectionStart === selectionEnd) {
            var _deleteChar = inputValue.charAt(selectionStart);
            var _getDecimalCharIndexe2 = getDecimalCharIndexes(inputValue),
              _decimalCharIndex = _getDecimalCharIndexe2.decimalCharIndex,
              _decimalCharIndexWithoutPrefix = _getDecimalCharIndexe2.decimalCharIndexWithoutPrefix;
            if (isNumeralChar(_deleteChar)) {
              var _decimalLength = getDecimalLength(inputValue);
              if (_group.current.test(_deleteChar)) {
                _group.current.lastIndex = 0;
                newValueStr = inputValue.slice(0, selectionStart) + inputValue.slice(selectionStart + 2);
              } else if (_decimal.current.test(_deleteChar)) {
                _decimal.current.lastIndex = 0;
                if (_decimalLength) {
                  inputRef.current.setSelectionRange(selectionStart + 1, selectionStart + 1);
                } else {
                  newValueStr = inputValue.slice(0, selectionStart) + inputValue.slice(selectionStart + 1);
                }
              } else if (_decimalCharIndex > 0 && selectionStart > _decimalCharIndex) {
                var _insertedText = isDecimalMode() && (props.minFractionDigits || 0) < _decimalLength ? '' : '0';
                newValueStr = inputValue.slice(0, selectionStart) + _insertedText + inputValue.slice(selectionStart + 1);
              } else if (_decimalCharIndexWithoutPrefix === 1) {
                newValueStr = inputValue.slice(0, selectionStart) + '0' + inputValue.slice(selectionStart + 1);
                newValueStr = parseValue(newValueStr) > 0 ? newValueStr : '';
              } else {
                newValueStr = inputValue.slice(0, selectionStart) + inputValue.slice(selectionStart + 1);
              }
            }
            updateValue(event, newValueStr, null, 'delete-back-single');
          } else {
            newValueStr = deleteRange(inputValue, selectionStart, selectionEnd);
            updateValue(event, newValueStr, null, 'delete-range');
          }
          break;
      }
    };
    var onInputKeyUp = function onInputKeyUp(event) {
      if (props.disabled || props.readOnly) {
        return;
      }
      if (props.onKeyUp) {
        props.onKeyUp(event);

        // do not continue if the user defined event wants to prevent
        if (event.defaultPrevented) {
          return;
        }
      }
      var code = event.which || event.keyCode;
      if (code !== 13) {
        // to submit a form
        event.preventDefault();
      }
      var _char = String.fromCharCode(code);
      var _isDecimalSign = isDecimalSign(_char);
      var _isMinusSign = isMinusSign(_char);
      if (48 <= code && code <= 57 || _isMinusSign || _isDecimalSign) {
        insert(event, _char, {
          isDecimalSign: _isDecimalSign,
          isMinusSign: _isMinusSign
        });
      }
    };
    var onPaste = function onPaste(event) {
      event.preventDefault();
      if (props.disabled || props.readOnly) {
        return;
      }
      var data = (event.clipboardData || window['clipboardData']).getData('Text');
      if (data) {
        var filteredData = parseValue(data);
        if (filteredData != null) {
          insert(event, filteredData.toString());
        }
      }
    };
    var allowMinusSign = function allowMinusSign() {
      return ObjectUtils.isEmpty(props.min) || props.min < 0;
    };
    var isMinusSign = function isMinusSign(_char2) {
      if (_minusSign.current.test(_char2) || _char2 === '-') {
        _minusSign.current.lastIndex = 0;
        return true;
      }
      return false;
    };
    var replaceDecimalSeparator = function replaceDecimalSeparator(val) {
      if (isFloat(val)) {
        return val.toString().replace(/\.(?=[^.]*$)/, _decimalSeparator.current);
      }
      return val;
    };
    var isDecimalSign = function isDecimalSign(_char3) {
      if (_decimal.current.test(_char3) || isFloat(_char3)) {
        _decimal.current.lastIndex = 0;
        return true;
      }
      return false;
    };
    var isDecimalMode = function isDecimalMode() {
      return props.mode === 'decimal';
    };
    var isFloat = function isFloat(val) {
      var formatter = new Intl.NumberFormat(_locale, getOptions());
      var parseVal = parseValue(formatter.format(val));
      if (parseVal === null) return false;
      return parseVal % 1 !== 0;
    };
    var getDecimalCharIndexes = function getDecimalCharIndexes(val) {
      var decimalCharIndex = val.search(_decimal.current);
      _decimal.current.lastIndex = 0;
      var filteredVal = val.replace(_prefix.current, '').trim().replace(/\s/g, '').replace(_currency.current, '');
      var decimalCharIndexWithoutPrefix = filteredVal.search(_decimal.current);
      _decimal.current.lastIndex = 0;
      return {
        decimalCharIndex: decimalCharIndex,
        decimalCharIndexWithoutPrefix: decimalCharIndexWithoutPrefix
      };
    };
    var getCharIndexes = function getCharIndexes(val) {
      var decimalCharIndex = val.search(_decimal.current);
      _decimal.current.lastIndex = 0;
      var minusCharIndex = val.search(_minusSign.current);
      _minusSign.current.lastIndex = 0;
      var suffixCharIndex = val.search(_suffix.current);
      _suffix.current.lastIndex = 0;
      var currencyCharIndex = val.search(_currency.current);
      if (currencyCharIndex === 0 && prefixChar.current && prefixChar.current.length > 1) {
        currencyCharIndex = prefixChar.current.trim().length;
      }
      _currency.current.lastIndex = 0;
      return {
        decimalCharIndex: decimalCharIndex,
        minusCharIndex: minusCharIndex,
        suffixCharIndex: suffixCharIndex,
        currencyCharIndex: currencyCharIndex
      };
    };
    var insert = function insert(event, text) {
      var sign = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {
        isDecimalSign: false,
        isMinusSign: false
      };
      var minusCharIndexOnText = text.search(_minusSign.current);
      _minusSign.current.lastIndex = 0;
      if (!allowMinusSign() && minusCharIndexOnText !== -1) {
        return;
      }
      var selectionStart = inputRef.current.selectionStart;
      var selectionEnd = inputRef.current.selectionEnd;
      var inputValue = inputRef.current.value.trim();
      var _getCharIndexes2 = getCharIndexes(inputValue),
        decimalCharIndex = _getCharIndexes2.decimalCharIndex,
        minusCharIndex = _getCharIndexes2.minusCharIndex,
        suffixCharIndex = _getCharIndexes2.suffixCharIndex,
        currencyCharIndex = _getCharIndexes2.currencyCharIndex;
      var newValueStr;
      if (sign.isMinusSign) {
        var isNewMinusSign = minusCharIndex === -1;
        if (isNewMinusSign && (selectionStart === 0 || selectionStart === currencyCharIndex + 1)) {
          newValueStr = inputValue;
          if (isNewMinusSign || selectionEnd !== 0) {
            newValueStr = insertText(inputValue, text, 0, selectionEnd);
          }
          updateValue(event, newValueStr, text, 'insert');
        }
      } else if (sign.isDecimalSign) {
        if (decimalCharIndex > 0 && selectionStart === decimalCharIndex) {
          updateValue(event, inputValue, text, 'insert');
        } else if (decimalCharIndex > selectionStart && decimalCharIndex < selectionEnd) {
          newValueStr = insertText(inputValue, text, selectionStart, selectionEnd);
          updateValue(event, newValueStr, text, 'insert');
        } else if (decimalCharIndex === -1 && props.maxFractionDigits) {
          newValueStr = insertText(inputValue, text, selectionStart, selectionEnd);
          updateValue(event, newValueStr, text, 'insert');
        }
      } else {
        var maxFractionDigits = numberFormat.current.resolvedOptions().maximumFractionDigits;
        var operation = selectionStart !== selectionEnd ? 'range-insert' : 'insert';
        if (decimalCharIndex > 0 && selectionStart > decimalCharIndex) {
          if (selectionStart + text.length - (decimalCharIndex + 1) <= maxFractionDigits) {
            var charIndex = currencyCharIndex >= selectionStart ? currencyCharIndex - 1 : suffixCharIndex >= selectionStart ? suffixCharIndex : inputValue.length;
            newValueStr = inputValue.slice(0, selectionStart) + text + inputValue.slice(selectionStart + text.length, charIndex) + inputValue.slice(charIndex);
            updateValue(event, newValueStr, text, operation);
          }
        } else {
          newValueStr = insertText(inputValue, text, selectionStart, selectionEnd);
          updateValue(event, newValueStr, text, operation);
        }
      }
    };
    var replaceSuffix = function replaceSuffix(value) {
      return value ? value.replace(_suffix.current, '').trim().replace(/\s/g, '').replace(_currency.current, '') : value;
    };
    var insertText = function insertText(value, text, start, end) {
      var textSplit = text === '.' ? text : text.split('.');
      if (textSplit.length === 2) {
        var decimalCharIndex = value.slice(start, end).search(_decimal.current);
        _decimal.current.lastIndex = 0;
        return decimalCharIndex > 0 ? value.slice(0, start) + formatValue(text) + replaceSuffix(value).slice(end) : value || formatValue(text);
      } else if (end - start === value.length) {
        return formatValue(text);
      } else if (start === 0) {
        var suffix = ObjectUtils.isLetter(value[end]) ? end - 1 : end;
        return text + value.slice(suffix);
      } else if (end === value.length) {
        return value.slice(0, start) + text;
      } else {
        var selectionValue = value.slice(start, end);
        // Fix: if the suffix starts with a space, the input will be cleared after pasting
        var space = /\s$/.test(selectionValue) ? ' ' : '';
        return value.slice(0, start) + text + space + value.slice(end);
      }
    };
    var deleteRange = function deleteRange(value, start, end) {
      var newValueStr;
      if (end - start === value.length) newValueStr = '';else if (start === 0) newValueStr = value.slice(end);else if (end === value.length) newValueStr = value.slice(0, start);else newValueStr = value.slice(0, start) + value.slice(end);
      return newValueStr;
    };
    var initCursor = function initCursor() {
      var selectionStart = inputRef.current.selectionStart;
      var inputValue = inputRef.current.value;
      var valueLength = inputValue.length;
      var index = null;

      // remove prefix
      var prefixLength = (prefixChar.current || '').length;
      inputValue = inputValue.replace(_prefix.current, '');
      selectionStart = selectionStart - prefixLength;
      var _char4 = inputValue.charAt(selectionStart);
      if (isNumeralChar(_char4)) {
        return selectionStart + prefixLength;
      }

      //left
      var i = selectionStart - 1;
      while (i >= 0) {
        _char4 = inputValue.charAt(i);
        if (isNumeralChar(_char4)) {
          index = i + prefixLength;
          break;
        } else {
          i--;
        }
      }
      if (index !== null) {
        inputRef.current.setSelectionRange(index + 1, index + 1);
      } else {
        i = selectionStart;
        while (i < valueLength) {
          _char4 = inputValue.charAt(i);
          if (isNumeralChar(_char4)) {
            index = i + prefixLength;
            break;
          } else {
            i++;
          }
        }
        if (index !== null) {
          inputRef.current.setSelectionRange(index, index);
        }
      }
      return index || 0;
    };
    var onInputPointerDown = function onInputPointerDown() {
      isFocusedByClick.current = true;
    };
    var onInputClick = function onInputClick() {
      initCursor();
    };
    var isNumeralChar = function isNumeralChar(_char5) {
      if (_char5.length === 1 && (_numeral.current.test(_char5) || _decimal.current.test(_char5) || _group.current.test(_char5) || _minusSign.current.test(_char5))) {
        resetRegex();
        return true;
      } else {
        return false;
      }
    };
    var resetRegex = function resetRegex() {
      _numeral.current.lastIndex = 0;
      _decimal.current.lastIndex = 0;
      _group.current.lastIndex = 0;
      _minusSign.current.lastIndex = 0;
    };
    var updateValue = function updateValue(event, valueStr, insertedValueStr, operation) {
      var currentValue = inputRef.current.value;
      var newValue = null;
      if (valueStr != null) {
        newValue = evaluateEmpty(parseValue(valueStr));
        updateInput(newValue, insertedValueStr, operation, valueStr);
        handleOnChange(event, currentValue, newValue);
      }
    };
    var evaluateEmpty = function evaluateEmpty(newValue) {
      return !newValue && !props.allowEmpty ? props.min || 0 : newValue;
    };
    var handleOnChange = function handleOnChange(event, currentValue, newValue) {
      if (props.onChange && isValueChanged(currentValue, newValue)) {
        props.onChange({
          originalEvent: event,
          value: newValue
        });
      }
    };
    var isValueChanged = function isValueChanged(currentValue, newValue) {
      if (newValue === null && currentValue !== null) {
        return true;
      }
      if (newValue != null) {
        var parsedCurrentValue = typeof currentValue === 'string' ? parseValue(currentValue) : currentValue;
        return newValue !== parsedCurrentValue;
      }
      return false;
    };
    var validateValue = function validateValue(value) {
      if (value === '-') {
        return null;
      }
      return validateValueByLimit(value);
    };
    var validateValueByLimit = function validateValueByLimit(value) {
      if (ObjectUtils.isEmpty(value)) {
        return null;
      }
      if (props.min !== null && value < props.min) {
        return props.min;
      }
      if (props.max !== null && value > props.max) {
        return props.max;
      }
      return value;
    };
    var updateInput = function updateInput(value, insertedValueStr, operation, valueStr) {
      insertedValueStr = insertedValueStr || '';
      var inputEl = inputRef.current;
      var inputValue = inputEl.value;
      var newValue = formatValue(value);
      var currentLength = inputValue.length;
      if (newValue !== valueStr) {
        newValue = concatValues(newValue, valueStr);
      }
      if (currentLength === 0) {
        inputEl.value = newValue;
        inputEl.setSelectionRange(0, 0);
        var index = initCursor();
        var selectionEnd = index + insertedValueStr.length;
        inputEl.setSelectionRange(selectionEnd, selectionEnd);
      } else {
        var selectionStart = inputEl.selectionStart;
        var _selectionEnd = inputEl.selectionEnd;
        if (props.maxLength && props.maxLength < newValue.length) {
          return;
        }
        inputEl.value = newValue;
        var newLength = newValue.length;
        if (operation === 'range-insert') {
          var startValue = parseValue((inputValue || '').slice(0, selectionStart));
          var startValueStr = startValue !== null ? startValue.toString() : '';
          var startExpr = startValueStr.split('').join("(".concat(groupChar.current, ")?"));
          var sRegex = new RegExp(startExpr, 'g');
          sRegex.test(newValue);
          var tExpr = insertedValueStr.split('').join("(".concat(groupChar.current, ")?"));
          var tRegex = new RegExp(tExpr, 'g');
          tRegex.test(newValue.slice(sRegex.lastIndex));
          _selectionEnd = sRegex.lastIndex + tRegex.lastIndex;
          inputEl.setSelectionRange(_selectionEnd, _selectionEnd);
        } else if (newLength === currentLength) {
          if (operation === 'insert' || operation === 'delete-back-single') {
            var newSelectionEnd = _selectionEnd + Number(isDecimalSign(value) || isDecimalSign(insertedValueStr));
            inputEl.setSelectionRange(newSelectionEnd, newSelectionEnd);
          } else if (operation === 'delete-single') {
            inputEl.setSelectionRange(_selectionEnd - 1, _selectionEnd - 1);
          } else if (operation === 'delete-range' || operation === 'spin') {
            inputEl.setSelectionRange(_selectionEnd, _selectionEnd);
          }
        } else if (operation === 'delete-back-single') {
          var prevChar = inputValue.charAt(_selectionEnd - 1);
          var nextChar = inputValue.charAt(_selectionEnd);
          var diff = currentLength - newLength;
          var isGroupChar = _group.current.test(nextChar);
          if (isGroupChar && diff === 1) {
            _selectionEnd += 1;
          } else if (!isGroupChar && isNumeralChar(prevChar)) {
            _selectionEnd += -1 * diff + 1;
          }
          _group.current.lastIndex = 0;
          inputEl.setSelectionRange(_selectionEnd, _selectionEnd);
        } else if (inputValue === '-' && operation === 'insert') {
          inputEl.setSelectionRange(0, 0);
          var _index2 = initCursor();
          var _selectionEnd2 = _index2 + insertedValueStr.length + 1;
          inputEl.setSelectionRange(_selectionEnd2, _selectionEnd2);
        } else {
          _selectionEnd = _selectionEnd + (newLength - currentLength);
          inputEl.setSelectionRange(_selectionEnd, _selectionEnd);
        }
      }
      inputEl.setAttribute('aria-valuenow', value);
    };
    var updateInputValue = function updateInputValue(newValue) {
      newValue = evaluateEmpty(newValue);
      var inputEl = inputRef.current;
      var value = inputEl.value;
      var _formattedValue = formattedValue(newValue);
      if (value !== _formattedValue) {
        inputEl.value = _formattedValue;
        inputEl.setAttribute('aria-valuenow', newValue);
      }
    };
    var formattedValue = function formattedValue(val) {
      return formatValue(evaluateEmpty(val));
    };
    var concatValues = function concatValues(val1, val2) {
      if (val1 && val2) {
        var decimalCharIndex = val2.search(_decimal.current);
        _decimal.current.lastIndex = 0;
        var newVal1 = replaceDecimalSeparator(val1).split(_decimal.current)[0].replace(_suffix.current, '').trim();
        return decimalCharIndex !== -1 ? newVal1 + val2.slice(decimalCharIndex) : val1;
      }
      return val1;
    };
    var getDecimalLength = function getDecimalLength(value) {
      if (value) {
        var valueSplit = value.split(_decimal.current);
        if (valueSplit.length === 2) {
          return replaceSuffix(valueSplit[1]).length;
        }
      }
      return 0;
    };
    var updateModel = function updateModel(event, value) {
      if (props.onValueChange) {
        props.onValueChange({
          originalEvent: event,
          value: value,
          stopPropagation: function stopPropagation() {
            event.stopPropagation();
          },
          preventDefault: function preventDefault() {
            event.preventDefault();
          },
          target: {
            name: props.name,
            id: props.id,
            value: value
          }
        });
      }
    };
    var onInputFocus = function onInputFocus(event) {
      setFocusedState(true);
      props.onFocus && props.onFocus(event);
      if ((props.suffix || props.currency || props.prefix) && inputRef.current && !isFocusedByClick.current) {
        // GitHub #1866,#5537
        var inputValue = inputRef.current.value;
        var prefixLength = (prefixChar.current || '').length;
        var suffixLength = (suffixChar.current || '').length;
        var end = inputValue.length === 0 ? 0 : inputValue.length - suffixLength;
        inputRef.current.setSelectionRange(prefixLength, end);
      }
    };
    var onInputBlur = function onInputBlur(event) {
      setFocusedState(false);
      isFocusedByClick.current = false;
      if (inputRef.current) {
        var currentValue = inputRef.current.value;
        if (isValueChanged(currentValue, props.value)) {
          var newValue = validateValue(parseValue(currentValue));
          updateInputValue(newValue);
          updateModel(event, newValue);
        }
      }
      props.onBlur && props.onBlur(event);
    };
    var clearTimer = function clearTimer() {
      if (timer.current) {
        clearInterval(timer.current);
      }
    };
    var changeValue = function changeValue() {
      var val = validateValueByLimit(props.value);
      updateInputValue(props.format ? val : replaceDecimalSeparator(val));
      var newValue = validateValue(props.value);
      if (props.value !== null && props.value !== newValue) {
        updateModel(null, newValue);
      }
    };
    var getFormatter = function getFormatter() {
      return numberFormat.current;
    };
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        focus: function focus() {
          return DomHandler.focus(inputRef.current);
        },
        getFormatter: getFormatter,
        getElement: function getElement() {
          return elementRef.current;
        },
        getInput: function getInput() {
          return inputRef.current;
        }
      };
    });
    React__namespace.useEffect(function () {
      ObjectUtils.combinedRefs(inputRef, props.inputRef);
    }, [inputRef, props.inputRef]);
    useMountEffect(function () {
      constructParser();
      var newValue = validateValue(props.value);
      if (props.value !== null && props.value !== newValue) {
        updateModel(null, newValue);
      }
    });
    useUpdateEffect(function () {
      constructParser();
      changeValue();
    }, [props.locale, props.localeMatcher, props.mode, props.currency, props.currencyDisplay, props.useGrouping, props.minFractionDigits, props.maxFractionDigits, props.suffix, props.prefix]);
    useUpdateEffect(function () {
      changeValue();
    }, [props.value]);
    useUpdateEffect(function () {
      // #5245 prevent infinite loop
      if (props.disabled) {
        clearTimer();
      }
    }, [props.disabled]);
    var createInputElement = function createInputElement() {
      var className = classNames('p-inputnumber-input', props.inputClassName);
      var valueToRender = formattedValue(props.value);
      return /*#__PURE__*/React__namespace.createElement(InputText, _extends({
        ref: inputRef,
        id: props.inputId,
        style: props.inputStyle,
        role: "spinbutton",
        className: className,
        defaultValue: valueToRender,
        type: props.type,
        size: props.size,
        tabIndex: props.tabIndex,
        inputMode: inputMode,
        maxLength: props.maxLength,
        disabled: props.disabled,
        required: props.required,
        pattern: props.pattern,
        placeholder: props.placeholder,
        readOnly: props.readOnly,
        name: props.name,
        autoFocus: props.autoFocus,
        onKeyDown: onInputKeyDown,
        onKeyPress: onInputKeyUp,
        onInput: onInput,
        onClick: onInputClick,
        onPointerDown: onInputPointerDown,
        onBlur: onInputBlur,
        onFocus: onInputFocus,
        onPaste: onPaste,
        min: props.min,
        max: props.max,
        "aria-valuemin": props.min,
        "aria-valuemax": props.max,
        "aria-valuenow": props.value
      }, ariaProps, dataProps, {
        pt: ptm('input'),
        __parentMetadata: {
          parent: metaData
        }
      }));
    };
    var createUpButton = function createUpButton() {
      var incrementIconProps = mergeProps({
        className: cx('incrementIcon')
      }, ptm('incrementIcon'));
      var icon = props.incrementButtonIcon || /*#__PURE__*/React__namespace.createElement(AngleUpIcon, incrementIconProps);
      var upButton = IconUtils.getJSXIcon(icon, _objectSpread$1j({}, incrementIconProps), {
        props: props
      });
      var incrementButtonProps = mergeProps({
        type: 'button',
        className: classNames(props.incrementButtonClassName, cx('incrementButton')),
        onPointerLeave: onUpButtonMouseLeave,
        onPointerDown: function onPointerDown(e) {
          return onUpButtonMouseDown(e);
        },
        onPointerUp: onUpButtonMouseUp,
        onKeyDown: function onKeyDown(e) {
          return onUpButtonKeyDown(e);
        },
        onKeyUp: onUpButtonKeyUp,
        disabled: props.disabled,
        tabIndex: -1,
        'aria-hidden': true
      }, ptm('incrementButton'));
      return /*#__PURE__*/React__namespace.createElement("button", incrementButtonProps, upButton, /*#__PURE__*/React__namespace.createElement(Ripple, null));
    };
    var createDownButton = function createDownButton() {
      var decrementIconProps = mergeProps({
        className: cx('decrementIcon')
      }, ptm('decrementIcon'));
      var icon = props.decrementButtonIcon || /*#__PURE__*/React__namespace.createElement(AngleDownIcon, decrementIconProps);
      var downButton = IconUtils.getJSXIcon(icon, _objectSpread$1j({}, decrementIconProps), {
        props: props
      });
      var decrementButtonProps = mergeProps({
        type: 'button',
        className: classNames(props.decrementButtonClassName, cx('decrementButton')),
        onPointerLeave: onDownButtonMouseLeave,
        onPointerDown: function onPointerDown(e) {
          return onDownButtonMouseDown(e);
        },
        onPointerUp: onDownButtonMouseUp,
        onKeyDown: function onKeyDown(e) {
          return onDownButtonKeyDown(e);
        },
        onKeyUp: onDownButtonKeyUp,
        disabled: props.disabled,
        tabIndex: -1,
        'aria-hidden': true
      }, ptm('decrementButton'));
      return /*#__PURE__*/React__namespace.createElement("button", decrementButtonProps, downButton, /*#__PURE__*/React__namespace.createElement(Ripple, null));
    };
    var createButtonGroup = function createButtonGroup() {
      var upButton = props.showButtons && createUpButton();
      var downButton = props.showButtons && createDownButton();
      var buttonGroupProps = mergeProps({
        className: cx('buttonGroup')
      }, ptm('buttonGroup'));
      if (stacked) {
        return /*#__PURE__*/React__namespace.createElement("span", buttonGroupProps, upButton, downButton);
      }
      return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, null, upButton, downButton);
    };
    var hasTooltip = ObjectUtils.isNotEmpty(props.tooltip);
    var otherProps = InputNumberBase.getOtherProps(props);
    var dataProps = ObjectUtils.reduceKeys(otherProps, DomHandler.DATA_PROPS);
    var ariaProps = ObjectUtils.reduceKeys(otherProps, DomHandler.ARIA_PROPS);
    var inputElement = createInputElement();
    var buttonGroup = createButtonGroup();
    var rootProps = mergeProps({
      id: props.id,
      className: classNames(props.className, cx('root', {
        focusedState: focusedState,
        stacked: stacked,
        horizontal: horizontal,
        vertical: vertical
      })),
      style: props.style
    }, otherProps, ptm('root'));
    return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, null, /*#__PURE__*/React__namespace.createElement("span", _extends({
      ref: elementRef
    }, rootProps), inputElement, buttonGroup), hasTooltip && /*#__PURE__*/React__namespace.createElement(Tooltip, _extends({
      target: elementRef,
      content: props.tooltip
    }, props.tooltipOptions, {
      pt: ptm('tooltip')
    })));
  }));
  InputNumber.displayName = 'InputNumber';

  var JumpToPageInput = /*#__PURE__*/React__namespace.memo(function (inProps) {
    var context = React__namespace.useContext(PrimeReactContext);
    var props = JumpToPageInputBase.getProps(inProps, context);
    var onChange = function onChange(event) {
      if (props.onChange) {
        props.onChange(props.rows * (event.value - 1), props.rows);
      }
    };
    var value = props.pageCount > 0 ? props.page + 1 : 0;
    var element = /*#__PURE__*/React__namespace.createElement(InputNumber, {
      value: value,
      onChange: onChange,
      className: "p-paginator-page-input",
      disabled: props.disabled,
      pt: props.ptm('JTPInput'),
      unstyled: props.unstyled,
      __parentMetadata: {
        parent: props.metaData
      }
    });
    if (props.template) {
      var defaultOptions = {
        value: value,
        onChange: onChange,
        disabled: props.disabled,
        className: 'p-paginator-page-input',
        element: element,
        props: props
      };
      return ObjectUtils.getJSXElement(props.template, defaultOptions);
    }
    return element;
  });
  JumpToPageInput.displayName = 'JumpToPageInput';

  function ownKeys$1i(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1i(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1i(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1i(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var LastPageLink = /*#__PURE__*/React__namespace.memo(function (inProps) {
    var context = React__namespace.useContext(PrimeReactContext);
    var props = LastPageLinkBase.getProps(inProps, context);
    var ptm = props.ptm,
      cx = props.cx;
    var getPTOptions = function getPTOptions(key) {
      return ptm(key, {
        hostName: props.hostName,
        context: {
          disabled: props.disabled
        }
      });
    };
    var className = classNames('p-paginator-last p-paginator-element p-link', {
      'p-disabled': props.disabled
    });
    var iconClassName = 'p-paginator-icon';
    var lastPageIconProps = mergeProps({
      className: cx('lastPageIcon')
    }, getPTOptions('lastPageIcon'));
    var icon = props.lastPageLinkIcon || /*#__PURE__*/React__namespace.createElement(AngleDoubleRightIcon, lastPageIconProps);
    var lastPageLinkIcon = IconUtils.getJSXIcon(icon, _objectSpread$1i({}, lastPageIconProps), {
      props: props
    });
    var lastPageButtonProps = mergeProps({
      type: 'button',
      className: cx('lastPageButton', {
        disabled: props.disabled
      }),
      onClick: props.onClick,
      disabled: props.disabled,
      'aria-label': ariaLabel('lastPageLabel')
    }, getPTOptions('lastPageButton'));
    var element = /*#__PURE__*/React__namespace.createElement("button", lastPageButtonProps, lastPageLinkIcon, /*#__PURE__*/React__namespace.createElement(Ripple, null));
    if (props.template) {
      var defaultOptions = {
        onClick: props.onClick,
        className: className,
        iconClassName: iconClassName,
        disabled: props.disabled,
        element: element,
        props: props
      };
      return ObjectUtils.getJSXElement(props.template, defaultOptions);
    }
    return element;
  });
  LastPageLink.displayName = 'LastPageLink';

  function ownKeys$1h(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1h(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1h(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1h(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var NextPageLink = /*#__PURE__*/React__namespace.memo(function (inProps) {
    var context = React__namespace.useContext(PrimeReactContext);
    var props = NextPageLinkBase.getProps(inProps, context);
    var ptm = props.ptm,
      cx = props.cx;
    var getPTOptions = function getPTOptions(key) {
      return ptm(key, {
        hostName: props.hostName,
        context: {
          disabled: props.disabled
        }
      });
    };
    var className = classNames('p-paginator-next p-paginator-element p-link', {
      'p-disabled': props.disabled
    });
    var iconClassName = 'p-paginator-icon';
    var nextPageIconProps = mergeProps({
      className: cx('nextPageIcon')
    }, getPTOptions('nextPageIcon'));
    var icon = props.nextPageLinkIcon || /*#__PURE__*/React__namespace.createElement(AngleRightIcon, nextPageIconProps);
    var nextPageLinkIcon = IconUtils.getJSXIcon(icon, _objectSpread$1h({}, nextPageIconProps), {
      props: props
    });
    var nextPageButtonProps = mergeProps({
      type: 'button',
      className: cx('nextPageButton', {
        disabled: props.disabled
      }),
      onClick: props.onClick,
      disabled: props.disabled,
      'aria-label': ariaLabel('nextPageLabel')
    }, getPTOptions('nextPageButton'));
    var element = /*#__PURE__*/React__namespace.createElement("button", nextPageButtonProps, nextPageLinkIcon, /*#__PURE__*/React__namespace.createElement(Ripple, null));
    if (props.template) {
      var defaultOptions = {
        onClick: props.onClick,
        className: className,
        iconClassName: iconClassName,
        disabled: props.disabled,
        element: element,
        nextPageLinkIcon: nextPageLinkIcon,
        props: props
      };
      return ObjectUtils.getJSXElement(props.template, defaultOptions);
    }
    return element;
  });
  NextPageLink.displayName = 'NextPageLink';

  var PageLinks = /*#__PURE__*/React__namespace.memo(function (inProps) {
    var context = React__namespace.useContext(PrimeReactContext);
    var props = PageLinksBase.getProps(inProps, context);
    var ptm = props.ptm,
      cx = props.cx;
    var getPTOptions = function getPTOptions(pageLink, key) {
      return ptm(key, {
        hostName: props.hostName,
        context: {
          active: pageLink - 1 === props.page
        }
      });
    };
    var onPageLinkClick = function onPageLinkClick(event, pageLink) {
      if (props.onClick) {
        props.onClick({
          originalEvent: event,
          value: pageLink
        });
      }
      event.preventDefault();
    };
    var elements;
    if (props.value) {
      var startPageInView = props.value[0];
      var endPageInView = props.value[props.value.length - 1];
      elements = props.value.map(function (pageLink) {
        var className = classNames('p-paginator-page p-paginator-element p-link', {
          'p-paginator-page-start': pageLink === startPageInView,
          'p-paginator-page-end': pageLink === endPageInView,
          'p-highlight': pageLink - 1 === props.page
        });
        var pageButtonProps = mergeProps({
          type: 'button',
          onClick: function onClick(e) {
            return onPageLinkClick(e, pageLink);
          },
          className: cx('pageButton', {
            pageLink: pageLink,
            startPageInView: startPageInView,
            endPageInView: endPageInView,
            page: props.page
          }),
          disabled: props.disabled,
          'aria-label': ariaLabel('pageLabel', {
            page: pageLink
          })
        }, getPTOptions(pageLink, 'pageButton'));
        var element = /*#__PURE__*/React__namespace.createElement("button", pageButtonProps, pageLink, /*#__PURE__*/React__namespace.createElement(Ripple, null));
        if (props.template) {
          var defaultOptions = {
            onClick: function onClick(e) {
              return onPageLinkClick(e, pageLink);
            },
            className: className,
            view: {
              startPage: startPageInView - 1,
              endPage: endPageInView - 1
            },
            page: pageLink - 1,
            currentPage: props.page,
            totalPages: props.pageCount,
            element: element,
            props: props
          };
          element = ObjectUtils.getJSXElement(props.template, defaultOptions);
        }
        return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, {
          key: pageLink
        }, element);
      });
    }
    var pagesProps = mergeProps({
      className: cx('pages')
    }, ptm('pages', {
      hostName: props.hostName
    }));
    return /*#__PURE__*/React__namespace.createElement("span", pagesProps, elements);
  });
  PageLinks.displayName = 'PageLinks';

  function ownKeys$1g(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1g(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1g(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1g(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var PrevPageLink = /*#__PURE__*/React__namespace.memo(function (inProps) {
    var context = React__namespace.useContext(PrimeReactContext);
    var props = PrevPageLinkBase.getProps(inProps, context);
    var ptm = props.ptm,
      cx = props.cx;
    var getPTOptions = function getPTOptions(key) {
      return ptm(key, {
        hostName: props.hostName,
        context: {
          disabled: props.disabled
        }
      });
    };
    var className = classNames('p-paginator-prev p-paginator-element p-link', {
      'p-disabled': props.disabled
    });
    var iconClassName = 'p-paginator-icon';
    var prevPageIconProps = mergeProps({
      className: cx('prevPageIcon')
    }, getPTOptions('prevPageIcon'));
    var icon = props.prevPageLinkIcon || /*#__PURE__*/React__namespace.createElement(AngleLeftIcon, prevPageIconProps);
    var prevPageLinkIcon = IconUtils.getJSXIcon(icon, _objectSpread$1g({}, prevPageIconProps), {
      props: props
    });
    var prevPageButtonProps = mergeProps({
      type: 'button',
      className: cx('prevPageButton', {
        disabled: props.disabled
      }),
      onClick: props.onClick,
      disabled: props.disabled,
      'aria-label': ariaLabel('previousPageLabel')
    }, getPTOptions('prevPageButton'));
    var element = /*#__PURE__*/React__namespace.createElement("button", prevPageButtonProps, prevPageLinkIcon, /*#__PURE__*/React__namespace.createElement(Ripple, null));
    if (props.template) {
      var defaultOptions = {
        onClick: props.onClick,
        className: className,
        iconClassName: iconClassName,
        disabled: props.disabled,
        element: element,
        props: props
      };
      return ObjectUtils.getJSXElement(props.template, defaultOptions);
    }
    return element;
  });
  PrevPageLink.displayName = 'PrevPageLink';

  var classes$O = {
    root: function root(_ref) {
      var props = _ref.props,
        focusedState = _ref.focusedState,
        overlayVisibleState = _ref.overlayVisibleState;
      return classNames('p-dropdown p-component p-inputwrapper', {
        'p-disabled': props.disabled,
        'p-focus': focusedState,
        'p-dropdown-clearable': props.showClear && !props.disabled,
        'p-inputwrapper-filled': ObjectUtils.isNotEmpty(props.value),
        'p-inputwrapper-focus': focusedState || overlayVisibleState
      });
    },
    input: function input(_ref2) {
      var props = _ref2.props,
        label = _ref2.label;
      return props.editable ? 'p-dropdown-label p-inputtext' : classNames('p-dropdown-label p-inputtext', {
        'p-placeholder': label === null && props.placeholder,
        'p-dropdown-label-empty': label === null && !props.placeholder
      });
    },
    trigger: 'p-dropdown-trigger',
    emptyMessage: 'p-dropdown-empty-message',
    itemGroup: function itemGroup(_ref3) {
      var optionGroupLabel = _ref3.optionGroupLabel;
      return classNames('p-dropdown-item-group', {
        'p-dropdown-item-empty': !optionGroupLabel || optionGroupLabel.length === 0
      });
    },
    dropdownIcon: 'p-dropdown-trigger-icon p-clickable',
    loadingIcon: 'p-dropdown-trigger-icon p-clickable',
    clearIcon: 'p-dropdown-clear-icon p-clickable',
    filterIcon: 'p-dropdown-filter-icon',
    filterContainer: function filterContainer(_ref4) {
      var clearIcon = _ref4.clearIcon;
      return classNames('p-dropdown-filter-container', {
        'p-dropdown-clearable-filter': !!clearIcon
      });
    },
    filterInput: 'p-dropdown-filter p-inputtext p-component',
    list: function list(_ref5) {
      var virtualScrollerOptions = _ref5.virtualScrollerOptions;
      return virtualScrollerOptions ? 'p-dropdown-items' : 'p-dropdown-items';
    },
    panel: function panel(_ref6) {
      var context = _ref6.context;
      return classNames('p-dropdown-panel p-component', {
        'p-input-filled': context && context.inputStyle === 'filled' || PrimeReact.inputStyle === 'filled',
        'p-ripple-disabled': context && context.ripple === false || PrimeReact.ripple === false
      });
    },
    item: function item(_ref7) {
      var selected = _ref7.selected,
        disabled = _ref7.disabled,
        label = _ref7.label;
      return classNames('p-dropdown-item', {
        'p-highlight': selected,
        'p-disabled': disabled,
        'p-dropdown-item-empty': !label || label.length === 0
      });
    },
    wrapper: 'p-dropdown-items-wrapper',
    header: 'p-dropdown-header',
    footer: 'p-dropdown-footer',
    transition: 'p-connected-overlay'
  };
  var styles$K = "\n@layer primereact {\n    .p-dropdown {\n        display: inline-flex;\n        cursor: pointer;\n        position: relative;\n        user-select: none;\n    }\n    \n    .p-dropdown-trigger {\n        display: flex;\n        align-items: center;\n        justify-content: center;\n        flex-shrink: 0;\n    }\n    \n    .p-dropdown-label {\n        display: block;\n        white-space: nowrap;\n        overflow: hidden;\n        flex: 1 1 auto;\n        width: 1%;\n        text-overflow: ellipsis;\n        cursor: pointer;\n    }\n    \n    .p-dropdown-label-empty {\n        overflow: hidden;\n        visibility: hidden;\n    }\n    \n    input.p-dropdown-label  {\n        cursor: default;\n    }\n    \n    .p-dropdown .p-dropdown-panel {\n        min-width: 100%;\n    }\n    \n    .p-dropdown-panel {\n        position: absolute;\n        top: 0;\n        left: 0;\n    }\n    \n    .p-dropdown-items-wrapper {\n        overflow: auto;\n    }\n    \n    .p-dropdown-item {\n        cursor: pointer;\n        font-weight: normal;\n        white-space: nowrap;\n        position: relative;\n        overflow: hidden;\n    }\n    \n    .p-dropdown-items {\n        margin: 0;\n        padding: 0;\n        list-style-type: none;\n    }\n    \n    .p-dropdown-filter {\n        width: 100%;\n    }\n    \n    .p-dropdown-filter-container {\n        position: relative;\n    }\n    \n    .p-dropdown-clear-icon,\n    .p-dropdown-filter-icon,\n    .p-dropdown-filter-clear-icon {\n        position: absolute;\n        top: 50%;\n        margin-top: -.5rem;\n    }\n    \n    .p-fluid .p-dropdown {\n        display: flex;\n    }\n    \n    .p-fluid .p-dropdown .p-dropdown-label {\n        width: 1%;\n    }\n}\n";
  var inlineStyles$i = {
    wrapper: function wrapper(_ref8) {
      var props = _ref8.props;
      return {
        maxHeight: props.scrollHeight || 'auto'
      };
    },
    panel: function panel(_ref9) {
      var props = _ref9.props;
      props.panelStyle;
    }
  };
  var DropdownBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'Dropdown',
      __parentMetadata: null,
      appendTo: null,
      ariaLabel: null,
      ariaLabelledBy: null,
      autoFocus: false,
      children: undefined,
      className: null,
      clearIcon: null,
      dataKey: null,
      disabled: false,
      dropdownIcon: null,
      editable: false,
      emptyFilterMessage: null,
      emptyMessage: null,
      filter: false,
      filterBy: null,
      filterClearIcon: null,
      filterIcon: null,
      filterInputAutoFocus: true,
      filterLocale: undefined,
      filterMatchMode: 'contains',
      filterPlaceholder: null,
      filterTemplate: null,
      focusInputRef: null,
      id: null,
      inputId: null,
      inputRef: null,
      itemTemplate: null,
      maxLength: null,
      name: null,
      onBlur: null,
      onChange: null,
      onContextMenu: null,
      onFilter: null,
      onFocus: null,
      onHide: null,
      onMouseDown: null,
      onShow: null,
      optionDisabled: null,
      optionGroupChildren: 'items',
      optionGroupLabel: null,
      optionGroupTemplate: null,
      optionLabel: null,
      optionValue: null,
      options: null,
      panelClassName: null,
      panelFooterTemplate: null,
      panelStyle: null,
      placeholder: null,
      required: false,
      resetFilterOnHide: false,
      scrollHeight: '200px',
      showClear: false,
      showFilterClear: false,
      showOnFocus: false,
      style: null,
      tabIndex: null,
      tooltip: null,
      tooltipOptions: null,
      transitionOptions: null,
      value: null,
      valueTemplate: null,
      virtualScrollerOptions: null
    },
    css: {
      classes: classes$O,
      styles: styles$K,
      inlineStyles: inlineStyles$i
    }
  });

  var DropdownItem = /*#__PURE__*/React__namespace.memo(function (props) {
    var ptm = props.ptm,
      cx = props.cx,
      selected = props.selected,
      disabled = props.disabled,
      option = props.option,
      label = props.label;
    var getPTOptions = function getPTOptions(key) {
      return ptm(key, {
        context: {
          selected: selected,
          disabled: disabled
        }
      });
    };
    var _onClick = function onClick(event) {
      if (props.onClick) {
        props.onClick({
          originalEvent: event,
          option: option
        });
      }
    };
    var content = props.template ? ObjectUtils.getJSXElement(props.template, props.option) : props.label;
    var itemProps = mergeProps({
      role: 'option',
      key: props.label,
      className: classNames(option.className, cx('item', {
        selected: selected,
        disabled: disabled,
        label: label
      })),
      style: props.style,
      onClick: function onClick(e) {
        return _onClick(e);
      },
      'aria-label': label,
      'aria-selected': selected,
      'data-p-highlight': selected,
      'data-p-disabled': disabled
    }, getPTOptions('item'));
    return /*#__PURE__*/React__namespace.createElement("li", itemProps, content, /*#__PURE__*/React__namespace.createElement(Ripple, null));
  });
  DropdownItem.displayName = 'DropdownItem';

  function ownKeys$1f(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1f(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1f(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1f(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var DropdownPanel = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (props, ref) {
    var ptm = props.ptm,
      cx = props.cx,
      sx = props.sx;
    var context = React__namespace.useContext(PrimeReactContext);
    React__namespace.useRef(null);
    var filterInputRef = React__namespace.useRef(null);
    var isEmptyFilter = !(props.visibleOptions && props.visibleOptions.length) && props.hasFilter;
    var filterOptions = {
      filter: function filter(e) {
        return onFilterInputChange(e);
      },
      reset: function reset() {
        return props.resetFilter();
      }
    };
    var getPTOptions = function getPTOptions(key, options) {
      return ptm(key, _objectSpread$1f({
        hostName: props.hostName
      }, options));
    };
    var onEnter = function onEnter() {
      props.onEnter(function () {
        if (props.virtualScrollerRef.current) {
          var selectedIndex = props.getSelectedOptionIndex();
          if (selectedIndex !== -1) {
            setTimeout(function () {
              return props.virtualScrollerRef.current.scrollToIndex(selectedIndex);
            }, 0);
          }
        }
      });
    };
    var onEntered = function onEntered() {
      props.onEntered(function () {
        if (props.filter && props.filterInputAutoFocus) {
          DomHandler.focus(filterInputRef.current, false);
        }
      });
    };
    var onFilterInputChange = function onFilterInputChange(event) {
      props.virtualScrollerRef.current && props.virtualScrollerRef.current.scrollToIndex(0);
      props.onFilterInputChange && props.onFilterInputChange(event);
    };
    var createFooter = function createFooter() {
      if (props.panelFooterTemplate) {
        var content = ObjectUtils.getJSXElement(props.panelFooterTemplate, props, props.onOverlayHide);
        var footerProps = mergeProps({
          className: cx('footer')
        }, getPTOptions('footer'));
        return /*#__PURE__*/React__namespace.createElement("div", footerProps, content);
      }
      return null;
    };
    var createGroupChildren = function createGroupChildren(optionGroup, style) {
      var groupChildren = props.getOptionGroupChildren(optionGroup);
      return groupChildren.map(function (option, j) {
        var optionLabel = props.getOptionLabel(option);
        var optionKey = j + '_' + props.getOptionRenderKey(option);
        var disabled = props.isOptionDisabled(option);
        return /*#__PURE__*/React__namespace.createElement(DropdownItem, {
          key: optionKey,
          label: optionLabel,
          option: option,
          style: style,
          template: props.itemTemplate,
          selected: props.isSelected(option),
          disabled: disabled,
          onClick: props.onOptionClick,
          ptm: ptm,
          cx: cx
        });
      });
    };
    var createEmptyMessage = function createEmptyMessage(emptyMessage, isFilter) {
      var message = ObjectUtils.getJSXElement(emptyMessage, props) || localeOption(isFilter ? 'emptyFilterMessage' : 'emptyMessage');
      var emptyMessageProps = mergeProps({
        className: cx('emptyMessage')
      }, getPTOptions('emptyMessage'));
      return /*#__PURE__*/React__namespace.createElement("li", emptyMessageProps, message);
    };
    var createItem = function createItem(option, index) {
      var scrollerOptions = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
      var style = {
        height: scrollerOptions.props ? scrollerOptions.props.itemSize : undefined
      };
      style = _objectSpread$1f(_objectSpread$1f({}, style), option.style);
      if (props.optionGroupLabel) {
        var optionGroupLabel = props.optionGroupLabel;
        var groupContent = props.optionGroupTemplate ? ObjectUtils.getJSXElement(props.optionGroupTemplate, option, index) : props.getOptionGroupLabel(option);
        var groupChildrenContent = createGroupChildren(option, style);
        var key = index + '_' + props.getOptionGroupRenderKey(option);
        var itemGroupProps = mergeProps({
          className: cx('itemGroup', {
            optionGroupLabel: optionGroupLabel
          }),
          style: style
        }, getPTOptions('itemGroup'));
        return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, {
          key: key
        }, /*#__PURE__*/React__namespace.createElement("li", itemGroupProps, groupContent), groupChildrenContent);
      } else {
        var optionLabel = props.getOptionLabel(option);
        var optionKey = index + '_' + props.getOptionRenderKey(option);
        var disabled = props.isOptionDisabled(option);
        return /*#__PURE__*/React__namespace.createElement(DropdownItem, {
          key: optionKey,
          label: optionLabel,
          option: option,
          style: style,
          template: props.itemTemplate,
          selected: props.isSelected(option),
          disabled: disabled,
          onClick: props.onOptionClick,
          ptm: ptm,
          cx: cx
        });
      }
    };
    var createItems = function createItems() {
      if (ObjectUtils.isNotEmpty(props.visibleOptions)) {
        return props.visibleOptions.map(createItem);
      } else if (props.hasFilter) {
        return createEmptyMessage(props.emptyFilterMessage, true);
      }
      return createEmptyMessage(props.emptyMessage);
    };
    var createFilterClearIcon = function createFilterClearIcon() {
      if (props.showFilterClear && props.filterValue) {
        var ariaLabel = localeOption('clear');
        var clearIconProps = mergeProps({
          className: cx('clearIcon'),
          'aria-label': ariaLabel,
          onClick: function onClick() {
            return props.onFilterClearIconClick(function () {
              return DomHandler.focus(filterInputRef.current);
            });
          }
        }, getPTOptions('clearIcon'));
        var icon = props.filterClearIcon || /*#__PURE__*/React__namespace.createElement(TimesIcon, clearIconProps);
        var filterClearIcon = IconUtils.getJSXIcon(icon, _objectSpread$1f({}, clearIconProps), {
          props: props
        });
        return filterClearIcon;
      }
      return null;
    };
    var createFilter = function createFilter() {
      if (props.filter) {
        var clearIcon = createFilterClearIcon();
        var filterIconProps = mergeProps({
          className: cx('filterIcon')
        }, getPTOptions('filterIcon'));
        var icon = props.filterIcon || /*#__PURE__*/React__namespace.createElement(SearchIcon, filterIconProps);
        var filterIcon = IconUtils.getJSXIcon(icon, _objectSpread$1f({}, filterIconProps), {
          props: props
        });
        var filterContainerProps = mergeProps({
          className: cx('filterContainer', {
            clearIcon: clearIcon
          })
        }, getPTOptions('filterContainer'));
        var filterInputProps = mergeProps({
          ref: filterInputRef,
          type: 'text',
          autoComplete: 'off',
          className: cx('filterInput'),
          placeholder: props.filterPlaceholder,
          onKeyDown: props.onFilterInputKeyDown,
          onChange: function onChange(e) {
            return onFilterInputChange(e);
          },
          value: props.filterValue
        }, getPTOptions('filterInput'));
        var content = /*#__PURE__*/React__namespace.createElement("div", filterContainerProps, /*#__PURE__*/React__namespace.createElement("input", filterInputProps), clearIcon, filterIcon);
        if (props.filterTemplate) {
          var defaultContentOptions = {
            className: classNames('p-dropdown-filter-container', {
              'p-dropdown-clearable-filter': !!clearIcon
            }),
            element: content,
            filterOptions: filterOptions,
            filterInputKeyDown: props.onFilterInputKeyDown,
            filterInputChange: onFilterInputChange,
            filterIconClassName: 'p-dropdown-filter-icon',
            clearIcon: clearIcon,
            props: props
          };
          content = ObjectUtils.getJSXElement(props.filterTemplate, defaultContentOptions);
        }
        var headerProps = mergeProps({
          className: cx('header')
        }, getPTOptions('header'));
        return /*#__PURE__*/React__namespace.createElement("div", headerProps, content);
      }
      return null;
    };
    var createContent = function createContent() {
      if (props.virtualScrollerOptions) {
        var virtualScrollerProps = _objectSpread$1f(_objectSpread$1f({}, props.virtualScrollerOptions), {
          style: _objectSpread$1f(_objectSpread$1f({}, props.virtualScrollerOptions.style), {
            height: props.scrollHeight
          }),
          className: classNames('p-dropdown-items-wrapper', props.virtualScrollerOptions.className),
          items: props.visibleOptions,
          autoSize: true,
          onLazyLoad: function onLazyLoad(event) {
            return props.virtualScrollerOptions.onLazyLoad(_objectSpread$1f(_objectSpread$1f({}, event), {
              filter: props.filterValue
            }));
          },
          itemTemplate: function itemTemplate(item, options) {
            return item && createItem(item, options.index, options);
          },
          contentTemplate: function contentTemplate(options) {
            var emptyMessage = props.hasFilter ? props.emptyFilterMessage : props.emptyMessage;
            var content = isEmptyFilter ? createEmptyMessage(emptyMessage) : options.children;
            var listProps = mergeProps({
              ref: options.contentRef,
              style: options.style,
              className: classNames(options.className, cx('list', {
                virtualScrollerProps: props.virtualScrollerOptions
              })),
              role: 'listbox'
            }, getPTOptions('list'));
            return /*#__PURE__*/React__namespace.createElement("ul", listProps, content);
          }
        });
        return /*#__PURE__*/React__namespace.createElement(VirtualScroller, _extends({
          ref: props.virtualScrollerRef
        }, virtualScrollerProps, {
          pt: ptm('virtualScroller')
        }));
      } else {
        var items = createItems();
        var wrapperProps = mergeProps({
          className: cx('wrapper'),
          style: sx('wrapper')
        }, getPTOptions('wrapper'));
        var listProps = mergeProps({
          className: cx('list'),
          role: 'listbox'
        }, getPTOptions('list'));
        return /*#__PURE__*/React__namespace.createElement("div", wrapperProps, /*#__PURE__*/React__namespace.createElement("ul", listProps, items));
      }
    };
    var createElement = function createElement() {
      var filter = createFilter();
      var content = createContent();
      var footer = createFooter();
      var panelProps = mergeProps({
        className: classNames(props.panelClassName, cx('panel', {
          context: context
        })),
        style: sx('panel'),
        onClick: props.onClick
      }, getPTOptions('panel'));
      var transitionProps = mergeProps({
        classNames: cx('transition'),
        "in": props["in"],
        timeout: {
          enter: 120,
          exit: 100
        },
        options: props.transitionOptions,
        unmountOnExit: true,
        onEnter: onEnter,
        onEntered: onEntered,
        onExit: props.onExit,
        onExited: props.onExited
      }, getPTOptions('transition'));
      return /*#__PURE__*/React__namespace.createElement(CSSTransition, _extends({
        nodeRef: ref
      }, transitionProps), /*#__PURE__*/React__namespace.createElement("div", _extends({
        ref: ref
      }, panelProps), filter, content, footer));
    };
    var element = createElement();
    return /*#__PURE__*/React__namespace.createElement(Portal, {
      element: element,
      appendTo: props.appendTo
    });
  }));
  DropdownPanel.displayName = 'DropdownPanel';

  function _createForOfIteratorHelper$c(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray$c(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
  function _unsupportedIterableToArray$c(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray$c(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$c(o, minLen); }
  function _arrayLikeToArray$c(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
  function ownKeys$1e(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1e(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1e(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1e(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var Dropdown = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var context = React__namespace.useContext(PrimeReactContext);
    var props = DropdownBase.getProps(inProps, context);
    var _React$useState = React__namespace.useState(''),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      filterState = _React$useState2[0],
      setFilterState = _React$useState2[1];
    var _React$useState3 = React__namespace.useState(false),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      focusedState = _React$useState4[0],
      setFocusedState = _React$useState4[1];
    var _React$useState5 = React__namespace.useState(false),
      _React$useState6 = _slicedToArray(_React$useState5, 2),
      overlayVisibleState = _React$useState6[0],
      setOverlayVisibleState = _React$useState6[1];
    var elementRef = React__namespace.useRef(null);
    var overlayRef = React__namespace.useRef(null);
    var inputRef = React__namespace.useRef(props.inputRef);
    var focusInputRef = React__namespace.useRef(props.focusInputRef);
    var virtualScrollerRef = React__namespace.useRef(null);
    var searchTimeout = React__namespace.useRef(null);
    var searchValue = React__namespace.useRef(null);
    var currentSearchChar = React__namespace.useRef(null);
    var isLazy = props.virtualScrollerOptions && props.virtualScrollerOptions.lazy;
    var hasFilter = ObjectUtils.isNotEmpty(filterState);
    var appendTo = props.appendTo || context && context.appendTo || PrimeReact.appendTo;
    var _DropdownBase$setMeta = DropdownBase.setMetaData(_objectSpread$1e(_objectSpread$1e({
        props: props
      }, props.__parentMetadata), {}, {
        state: {
          filter: filterState,
          focused: focusedState,
          overlayVisible: overlayVisibleState
        }
      })),
      ptm = _DropdownBase$setMeta.ptm,
      cx = _DropdownBase$setMeta.cx,
      sx = _DropdownBase$setMeta.sx,
      isUnstyled = _DropdownBase$setMeta.isUnstyled;
    useHandleStyle(DropdownBase.css.styles, isUnstyled, {
      name: 'dropdown'
    });
    var _useOverlayListener = useOverlayListener({
        target: elementRef,
        overlay: overlayRef,
        listener: function listener(event, _ref) {
          var type = _ref.type,
            valid = _ref.valid;
          if (valid) {
            type === 'outside' ? !isClearClicked(event) && hide() : hide();
          }
        },
        when: overlayVisibleState
      }),
      _useOverlayListener2 = _slicedToArray(_useOverlayListener, 2),
      bindOverlayListener = _useOverlayListener2[0],
      unbindOverlayListener = _useOverlayListener2[1];
    var getVisibleOptions = function getVisibleOptions() {
      if (hasFilter && !isLazy) {
        var filterValue = filterState.trim().toLocaleLowerCase(props.filterLocale);
        var searchFields = props.filterBy ? props.filterBy.split(',') : [props.optionLabel || 'label'];
        if (props.optionGroupLabel) {
          var filteredGroups = [];
          var _iterator = _createForOfIteratorHelper$c(props.options),
            _step;
          try {
            for (_iterator.s(); !(_step = _iterator.n()).done;) {
              var optgroup = _step.value;
              var filteredSubOptions = FilterService.filter(getOptionGroupChildren(optgroup), searchFields, filterValue, props.filterMatchMode, props.filterLocale);
              if (filteredSubOptions && filteredSubOptions.length) {
                filteredGroups.push(_objectSpread$1e(_objectSpread$1e({}, optgroup), _defineProperty({}, "".concat(props.optionGroupChildren), filteredSubOptions)));
              }
            }
          } catch (err) {
            _iterator.e(err);
          } finally {
            _iterator.f();
          }
          return filteredGroups;
        } else {
          return FilterService.filter(props.options, searchFields, filterValue, props.filterMatchMode, props.filterLocale);
        }
      } else {
        return props.options;
      }
    };
    var isClearClicked = function isClearClicked(event) {
      return DomHandler.hasClass(event.target, 'p-dropdown-clear-icon') || DomHandler.hasClass(event.target, 'p-dropdown-filter-clear-icon');
    };
    var _onClick = function onClick(event) {
      if (props.disabled || props.loading) {
        return;
      }
      props.onClick && props.onClick(event);

      // do not continue if the user defined click wants to prevent it
      if (event.defaultPrevented) {
        return;
      }
      if (DomHandler.hasClass(event.target, 'p-dropdown-clear-icon') || event.target.tagName === 'INPUT') {
        return;
      } else if (!overlayRef.current || !(overlayRef.current && overlayRef.current.contains(event.target))) {
        DomHandler.focus(focusInputRef.current);
        overlayVisibleState ? hide() : show();
      }
    };
    var onInputFocus = function onInputFocus(event) {
      if (props.showOnFocus && !overlayVisibleState) {
        show();
      }
      setFocusedState(true);
      props.onFocus && props.onFocus(event);
    };
    var onInputBlur = function onInputBlur(event) {
      setFocusedState(false);
      if (props.onBlur) {
        setTimeout(function () {
          var currentValue = inputRef.current ? inputRef.current.value : undefined;
          props.onBlur({
            originalEvent: event.originalEvent,
            value: currentValue,
            stopPropagation: function stopPropagation() {
              event.originalEvent.stopPropagation();
            },
            preventDefault: function preventDefault() {
              event.originalEvent.preventDefault();
            },
            target: {
              name: props.name,
              id: props.id,
              value: currentValue
            }
          });
        }, 200);
      }
    };
    var onPanelClick = function onPanelClick(event) {
      OverlayService.emit('overlay-click', {
        originalEvent: event,
        target: elementRef.current
      });
    };
    var onInputKeyDown = function onInputKeyDown(event) {
      switch (event.which) {
        //down
        case 40:
          onDownKey(event);
          break;

        //up
        case 38:
          onUpKey(event);
          break;

        //space and enter
        case 32:
        case 13:
          overlayVisibleState ? hide() : show();
          event.preventDefault();
          break;

        //escape and tab
        case 27:
        case 9:
          hide();
          break;
        default:
          search(event);
          break;
      }
    };
    var onFilterInputKeyDown = function onFilterInputKeyDown(event) {
      switch (event.which) {
        //down
        case 40:
          onDownKey(event);
          break;

        //up
        case 38:
          onUpKey(event);
          break;

        //enter and escape
        case 13:
        case 27:
          hide();
          event.preventDefault();
          break;
      }
    };
    var onUpKey = function onUpKey(event) {
      if (visibleOptions) {
        var prevOption = findPrevOption(getSelectedOptionIndex());
        if (prevOption) {
          selectItem({
            originalEvent: event,
            option: prevOption
          });
        }
      }
      event.preventDefault();
    };
    var onDownKey = function onDownKey(event) {
      if (visibleOptions) {
        if (!overlayVisibleState && event.altKey) {
          show();
        } else {
          var nextOption = findNextOption(getSelectedOptionIndex());
          if (nextOption) {
            selectItem({
              originalEvent: event,
              option: nextOption
            });
          }
        }
      }
      event.preventDefault();
    };
    var findNextOption = function findNextOption(index) {
      if (props.optionGroupLabel) {
        var groupIndex = index === -1 ? 0 : index.group;
        var optionIndex = index === -1 ? -1 : index.option;
        var option = findNextOptionInList(getOptionGroupChildren(visibleOptions[groupIndex]), optionIndex);
        if (option) return option;else if (groupIndex + 1 !== visibleOptions.length) return findNextOption({
          group: groupIndex + 1,
          option: -1
        });else return null;
      }
      return findNextOptionInList(visibleOptions, index);
    };
    var findNextOptionInList = function findNextOptionInList(list, index) {
      var i = index + 1;
      if (i === list.length) {
        return null;
      }
      var option = list[i];
      return isOptionDisabled(option) ? findNextOptionInList(i) : option;
    };
    var findPrevOption = function findPrevOption(index) {
      if (index === -1) {
        return null;
      }
      if (props.optionGroupLabel) {
        var groupIndex = index.group;
        var optionIndex = index.option;
        var option = findPrevOptionInList(getOptionGroupChildren(visibleOptions[groupIndex]), optionIndex);
        if (option) return option;else if (groupIndex > 0) return findPrevOption({
          group: groupIndex - 1,
          option: getOptionGroupChildren(visibleOptions[groupIndex - 1]).length
        });else return null;
      }
      return findPrevOptionInList(visibleOptions, index);
    };
    var findPrevOptionInList = function findPrevOptionInList(list, index) {
      var i = index - 1;
      if (i < 0) {
        return null;
      }
      var option = list[i];
      return isOptionDisabled(option) ? findPrevOption(i) : option;
    };
    var search = function search(event) {
      if (searchTimeout.current) {
        clearTimeout(searchTimeout.current);
      }
      var _char = event.key;
      if (_char === 'Shift' || _char === 'Control' || _char === 'Alt') {
        return;
      }
      if (currentSearchChar.current === _char) searchValue.current = _char;else searchValue.current = searchValue.current ? searchValue.current + _char : _char;
      currentSearchChar.current = _char;
      if (searchValue.current) {
        var searchIndex = getSelectedOptionIndex();
        var newOption = props.optionGroupLabel ? searchOptionInGroup(searchIndex) : searchOption(searchIndex + 1);
        if (newOption) {
          selectItem({
            originalEvent: event,
            option: newOption
          });
        }
      }
      searchTimeout.current = setTimeout(function () {
        searchValue.current = null;
      }, 250);
    };
    var searchOption = function searchOption(index) {
      if (searchValue.current) {
        return searchOptionInRange(index, visibleOptions.length) || searchOptionInRange(0, index);
      }
      return null;
    };
    var searchOptionInRange = function searchOptionInRange(start, end) {
      for (var i = start; i < end; i++) {
        var opt = visibleOptions[i];
        if (matchesSearchValue(opt)) {
          return opt;
        }
      }
      return null;
    };
    var searchOptionInGroup = function searchOptionInGroup(index) {
      var searchIndex = index === -1 ? {
        group: 0,
        option: -1
      } : index;
      for (var i = searchIndex.group; i < visibleOptions.length; i++) {
        var groupOptions = getOptionGroupChildren(visibleOptions[i]);
        for (var j = searchIndex.group === i ? searchIndex.option + 1 : 0; j < groupOptions.length; j++) {
          if (matchesSearchValue(groupOptions[j])) {
            return groupOptions[j];
          }
        }
      }
      for (var _i = 0; _i <= searchIndex.group; _i++) {
        var _groupOptions = getOptionGroupChildren(visibleOptions[_i]);
        for (var _j = 0; _j < (searchIndex.group === _i ? searchIndex.option : _groupOptions.length); _j++) {
          if (matchesSearchValue(_groupOptions[_j])) {
            return _groupOptions[_j];
          }
        }
      }
      return null;
    };
    var matchesSearchValue = function matchesSearchValue(option) {
      var label = getOptionLabel(option);
      if (!label) {
        return false;
      }
      label = label.toLocaleLowerCase(props.filterLocale);
      return label.startsWith(searchValue.current.toLocaleLowerCase(props.filterLocale));
    };
    var onEditableInputChange = function onEditableInputChange(event) {
      if (props.onChange) {
        props.onChange({
          originalEvent: event.originalEvent,
          value: event.target.value,
          stopPropagation: function stopPropagation() {
            event.originalEvent.stopPropagation();
          },
          preventDefault: function preventDefault() {
            event.originalEvent.preventDefault();
          },
          target: {
            name: props.name,
            id: props.id,
            value: event.target.value
          }
        });
      }
    };
    var onEditableInputFocus = function onEditableInputFocus(event) {
      setFocusedState(true);
      hide();
      props.onFocus && props.onFocus(event);
    };
    var onOptionClick = function onOptionClick(event) {
      var option = event.option;
      if (!option.disabled) {
        selectItem(event);
        DomHandler.focus(focusInputRef.current);
      }
      hide();
    };
    var onFilterInputChange = function onFilterInputChange(event) {
      var filter = event.target.value;
      setFilterState(filter);
      if (props.onFilter) {
        props.onFilter({
          originalEvent: event,
          filter: filter
        });
      }
    };
    var onFilterClearIconClick = function onFilterClearIconClick(callback) {
      resetFilter(callback);
    };
    var resetFilter = function resetFilter(callback) {
      setFilterState('');
      props.onFilter && props.onFilter({
        filter: ''
      });
      callback && callback();
    };
    var clear = function clear(event) {
      if (props.onChange) {
        props.onChange({
          originalEvent: event,
          value: undefined,
          stopPropagation: function stopPropagation() {
            event.stopPropagation();
          },
          preventDefault: function preventDefault() {
            event.preventDefault();
          },
          target: {
            name: props.name,
            id: props.id,
            value: undefined
          }
        });
      }
      updateEditableLabel();
    };
    var selectItem = function selectItem(event) {
      if (selectedOption !== event.option) {
        updateEditableLabel(event.option);
        var optionValue = getOptionValue(event.option);
        if (props.onChange) {
          props.onChange({
            originalEvent: event.originalEvent,
            value: optionValue,
            stopPropagation: function stopPropagation() {
              event.originalEvent.stopPropagation();
            },
            preventDefault: function preventDefault() {
              event.originalEvent.preventDefault();
            },
            target: {
              name: props.name,
              id: props.id,
              value: optionValue
            }
          });
        }
      }
    };
    var getSelectedOptionIndex = function getSelectedOptionIndex(options) {
      options = options || visibleOptions;
      if (props.value != null && options) {
        if (props.optionGroupLabel) {
          for (var i = 0; i < options.length; i++) {
            var selectedOptionIndex = findOptionIndexInList(props.value, getOptionGroupChildren(options[i]));
            if (selectedOptionIndex !== -1) {
              return {
                group: i,
                option: selectedOptionIndex
              };
            }
          }
        } else {
          return findOptionIndexInList(props.value, options);
        }
      }
      return -1;
    };
    var equalityKey = function equalityKey() {
      return props.optionValue ? null : props.dataKey;
    };
    var findOptionIndexInList = function findOptionIndexInList(value, list) {
      var key = equalityKey();
      return list.findIndex(function (item) {
        return ObjectUtils.equals(value, getOptionValue(item), key);
      });
    };
    var isSelected = function isSelected(option) {
      return ObjectUtils.equals(props.value, getOptionValue(option), equalityKey());
    };
    var show = function show() {
      setOverlayVisibleState(true);
    };
    var hide = function hide() {
      setOverlayVisibleState(false);
    };
    var onOverlayEnter = function onOverlayEnter(callback) {
      ZIndexUtils.set('overlay', overlayRef.current, context && context.autoZIndex || PrimeReact.autoZIndex, context && context.zIndex['overlay'] || PrimeReact.zIndex['overlay']);
      DomHandler.addStyles(overlayRef.current, {
        position: 'absolute',
        top: '0',
        left: '0'
      });
      alignOverlay();
      callback && callback();
    };
    var onOverlayEntered = function onOverlayEntered(callback) {
      callback && callback();
      bindOverlayListener();
      props.onShow && props.onShow();
    };
    var onOverlayExit = function onOverlayExit() {
      unbindOverlayListener();
    };
    var onOverlayExited = function onOverlayExited() {
      if (props.filter && props.resetFilterOnHide) {
        resetFilter();
      }
      ZIndexUtils.clear(overlayRef.current);
      props.onHide && props.onHide();
    };
    var alignOverlay = function alignOverlay() {
      DomHandler.alignOverlay(overlayRef.current, inputRef.current.parentElement, props.appendTo || context && context.appendTo || PrimeReact.appendTo);
    };
    var scrollInView = function scrollInView() {
      var highlightItem = DomHandler.findSingle(overlayRef.current, 'li.p-highlight');
      if (highlightItem && highlightItem.scrollIntoView) {
        highlightItem.scrollIntoView({
          block: 'nearest',
          inline: 'nearest'
        });
      }
    };
    var updateEditableLabel = function updateEditableLabel(option) {
      if (inputRef.current) {
        inputRef.current.value = option ? getOptionLabel(option) : props.value || '';
      }
    };
    var getOptionLabel = function getOptionLabel(option) {
      return props.optionLabel ? ObjectUtils.resolveFieldData(option, props.optionLabel) : option && option['label'] !== undefined ? option['label'] : option;
    };
    var getOptionValue = function getOptionValue(option) {
      return props.optionValue ? ObjectUtils.resolveFieldData(option, props.optionValue) : option && option['value'] !== undefined ? option['value'] : option;
    };
    var getOptionRenderKey = function getOptionRenderKey(option) {
      return props.dataKey ? ObjectUtils.resolveFieldData(option, props.dataKey) : getOptionLabel(option);
    };
    var isOptionDisabled = function isOptionDisabled(option) {
      if (props.optionDisabled) {
        return ObjectUtils.isFunction(props.optionDisabled) ? props.optionDisabled(option) : ObjectUtils.resolveFieldData(option, props.optionDisabled);
      }
      return option && option['disabled'] !== undefined ? option['disabled'] : false;
    };
    var getOptionGroupRenderKey = function getOptionGroupRenderKey(optionGroup) {
      return ObjectUtils.resolveFieldData(optionGroup, props.optionGroupLabel);
    };
    var getOptionGroupLabel = function getOptionGroupLabel(optionGroup) {
      return ObjectUtils.resolveFieldData(optionGroup, props.optionGroupLabel);
    };
    var getOptionGroupChildren = function getOptionGroupChildren(optionGroup) {
      return ObjectUtils.resolveFieldData(optionGroup, props.optionGroupChildren);
    };
    var updateInputField = function updateInputField() {
      if (props.editable && inputRef.current) {
        var label = selectedOption ? getOptionLabel(selectedOption) : null;
        var value = label || props.value || '';
        inputRef.current.value = value;
      }
    };
    var getSelectedOption = function getSelectedOption() {
      var index = getSelectedOptionIndex(props.options);
      return index !== -1 ? props.optionGroupLabel ? getOptionGroupChildren(props.options[index.group])[index.option] : props.options[index] : null;
    };
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        show: show,
        hide: hide,
        clear: clear,
        focus: function focus() {
          return DomHandler.focus(focusInputRef.current);
        },
        getElement: function getElement() {
          return elementRef.current;
        },
        getOverlay: function getOverlay() {
          return overlayRef.current;
        },
        getInput: function getInput() {
          return inputRef.current;
        },
        getFocusInput: function getFocusInput() {
          return focusInputRef.current;
        },
        getVirtualScroller: function getVirtualScroller() {
          return virtualScrollerRef.current;
        }
      };
    });
    React__namespace.useEffect(function () {
      ObjectUtils.combinedRefs(inputRef, props.inputRef);
      ObjectUtils.combinedRefs(focusInputRef, props.focusInputRef);
    }, [inputRef, props.inputRef, focusInputRef, props.focusInputRef]);
    useMountEffect(function () {
      if (props.autoFocus) {
        DomHandler.focus(focusInputRef.current, props.autoFocus);
      }
      alignOverlay();
    });
    useUpdateEffect(function () {
      if (overlayVisibleState && props.value) {
        scrollInView();
      }
    }, [overlayVisibleState, props.value]);
    useUpdateEffect(function () {
      if (overlayVisibleState && filterState && props.filter) {
        alignOverlay();
      }
    }, [overlayVisibleState, filterState, props.filter]);
    useUpdateEffect(function () {
      if (filterState && (!props.options || props.options.length === 0)) {
        setFilterState('');
      }
      updateInputField();
      if (inputRef.current) {
        inputRef.current.selectedIndex = 1;
      }
    });
    useUnmountEffect(function () {
      ZIndexUtils.clear(overlayRef.current);
    });
    var createHiddenSelect = function createHiddenSelect() {
      var option = {
        value: '',
        label: props.placeholder
      };
      if (selectedOption) {
        var optionValue = getOptionValue(selectedOption);
        option = {
          value: _typeof(optionValue) === 'object' ? props.options.findIndex(function (o) {
            return o === optionValue;
          }) : optionValue,
          label: getOptionLabel(selectedOption)
        };
      }
      var hiddenSelectedMessageProps = mergeProps({
        className: 'p-hidden-accessible p-dropdown-hidden-select'
      }, ptm('hiddenSelectedMessage'));
      var selectProps = mergeProps({
        ref: inputRef,
        required: props.required,
        defaultValue: option.value,
        name: props.name,
        tabIndex: -1,
        'aria-hidden': 'true'
      }, ptm('select'));
      var optionProps = mergeProps({
        value: option.value
      }, ptm('option'));
      return /*#__PURE__*/React__namespace.createElement("div", hiddenSelectedMessageProps, /*#__PURE__*/React__namespace.createElement("select", selectProps, /*#__PURE__*/React__namespace.createElement("option", optionProps, option.label)));
    };
    var createKeyboardHelper = function createKeyboardHelper() {
      var hiddenSelectedMessageProps = mergeProps({
        className: 'p-hidden-accessible'
      }, ptm('hiddenSelectedMessage'));
      var inputProps = mergeProps(_objectSpread$1e({
        ref: focusInputRef,
        id: props.inputId,
        type: 'text',
        readOnly: true,
        'aria-haspopup': 'listbox',
        onFocus: onInputFocus,
        onBlur: onInputBlur,
        onKeyDown: onInputKeyDown,
        disabled: props.disabled,
        tabIndex: props.tabIndex || 0
      }, ariaProps), ptm('input'));
      return /*#__PURE__*/React__namespace.createElement("div", hiddenSelectedMessageProps, /*#__PURE__*/React__namespace.createElement("input", inputProps));
    };
    var createLabel = function createLabel() {
      var label = ObjectUtils.isNotEmpty(selectedOption) ? getOptionLabel(selectedOption) : null;
      if (props.editable) {
        var value = label || props.value || '';
        var inputProps = mergeProps(_objectSpread$1e({
          ref: inputRef,
          type: 'text',
          defaultValue: value,
          className: cx('input', {
            label: label
          }),
          disabled: props.disabled,
          placeholder: props.placeholder,
          maxLength: props.maxLength,
          onInput: onEditableInputChange,
          onFocus: onEditableInputFocus,
          onBlur: onInputBlur,
          tabIndex: props.tabIndex || 0,
          'aria-haspopup': 'listbox'
        }, ariaProps), ptm('input'));
        return /*#__PURE__*/React__namespace.createElement("input", inputProps);
      } else {
        var content = props.valueTemplate ? ObjectUtils.getJSXElement(props.valueTemplate, selectedOption, props) : label || props.placeholder || 'empty';
        var _inputProps = mergeProps({
          ref: inputRef,
          className: cx('input', {
            label: label
          }),
          tabIndex: '-1'
        }, ptm('input'));
        return /*#__PURE__*/React__namespace.createElement("span", _inputProps, content);
      }
    };
    var createClearIcon = function createClearIcon() {
      if (props.value != null && props.showClear && !props.disabled) {
        var clearIconProps = mergeProps({
          className: cx('clearIcon'),
          onPointerUp: clear
        }, ptm('clearIcon'));
        var icon = props.clearIcon || /*#__PURE__*/React__namespace.createElement(TimesIcon, clearIconProps);
        return IconUtils.getJSXIcon(icon, _objectSpread$1e({}, clearIconProps), {
          props: props
        });
      }
      return null;
    };
    var createLoadingIcon = function createLoadingIcon() {
      var loadingIconProps = mergeProps({
        className: cx('loadingIcon'),
        'data-pr-overlay-visible': overlayVisibleState
      }, ptm('loadingIcon'));
      var icon = props.loadingIcon || /*#__PURE__*/React__namespace.createElement(SpinnerIcon, {
        spin: true
      });
      var loadingIcon = IconUtils.getJSXIcon(icon, _objectSpread$1e({}, loadingIconProps), {
        props: props
      });
      var ariaLabel = props.placeholder || props.ariaLabel;
      var loadingButtonProps = mergeProps({
        className: cx('trigger'),
        role: 'button',
        'aria-haspopup': 'listbox',
        'aria-expanded': overlayVisibleState,
        'aria-label': ariaLabel
      }, ptm('trigger'));
      return /*#__PURE__*/React__namespace.createElement("div", loadingButtonProps, loadingIcon);
    };
    var createDropdownIcon = function createDropdownIcon() {
      var dropdownIconProps = mergeProps({
        className: cx('dropdownIcon'),
        'data-pr-overlay-visible': overlayVisibleState
      }, ptm('dropdownIcon'));
      var icon = props.dropdownIcon || /*#__PURE__*/React__namespace.createElement(ChevronDownIcon, dropdownIconProps);
      var dropdownIcon = IconUtils.getJSXIcon(icon, _objectSpread$1e({}, dropdownIconProps), {
        props: props
      });
      var ariaLabel = props.placeholder || props.ariaLabel;
      var triggerProps = mergeProps({
        className: cx('trigger'),
        role: 'button',
        'aria-haspopup': 'listbox',
        'aria-expanded': overlayVisibleState,
        'aria-label': ariaLabel
      }, ptm('trigger'));
      return /*#__PURE__*/React__namespace.createElement("div", triggerProps, dropdownIcon);
    };
    var visibleOptions = getVisibleOptions();
    var selectedOption = getSelectedOption();
    var hasTooltip = ObjectUtils.isNotEmpty(props.tooltip);
    var otherProps = DropdownBase.getOtherProps(props);
    var ariaProps = ObjectUtils.reduceKeys(otherProps, DomHandler.ARIA_PROPS);
    var hiddenSelect = createHiddenSelect();
    var keyboardHelper = createKeyboardHelper();
    var labelElement = createLabel();
    var dropdownIcon = props.loading ? createLoadingIcon() : createDropdownIcon();
    var clearIcon = createClearIcon();
    var rootProps = mergeProps({
      id: props.id,
      ref: elementRef,
      className: classNames(props.className, cx('root', {
        focusedState: focusedState,
        overlayVisibleState: overlayVisibleState
      })),
      style: props.style,
      onClick: function onClick(e) {
        return _onClick(e);
      },
      onMouseDown: props.onMouseDown,
      onContextMenu: props.onContextMenu,
      'data-p-disabled': props.disabled,
      'data-p-focus': focusedState
    }, otherProps, ptm('root'));
    return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, null, /*#__PURE__*/React__namespace.createElement("div", rootProps, keyboardHelper, hiddenSelect, labelElement, clearIcon, dropdownIcon, /*#__PURE__*/React__namespace.createElement(DropdownPanel, _extends({
      hostName: "Dropdown",
      ref: overlayRef,
      visibleOptions: visibleOptions,
      virtualScrollerRef: virtualScrollerRef
    }, props, {
      appendTo: appendTo,
      onClick: onPanelClick,
      onOptionClick: onOptionClick,
      filterValue: filterState,
      hasFilter: hasFilter,
      onFilterClearIconClick: onFilterClearIconClick,
      resetFilter: resetFilter,
      onFilterInputKeyDown: onFilterInputKeyDown,
      onFilterInputChange: onFilterInputChange,
      getOptionLabel: getOptionLabel,
      getOptionRenderKey: getOptionRenderKey,
      isOptionDisabled: isOptionDisabled,
      getOptionGroupChildren: getOptionGroupChildren,
      getOptionGroupLabel: getOptionGroupLabel,
      getOptionGroupRenderKey: getOptionGroupRenderKey,
      isSelected: isSelected,
      getSelectedOptionIndex: getSelectedOptionIndex,
      "in": overlayVisibleState,
      onEnter: onOverlayEnter,
      onEntered: onOverlayEntered,
      onExit: onOverlayExit,
      onExited: onOverlayExited,
      ptm: ptm,
      cx: cx,
      sx: sx
    }))), hasTooltip && /*#__PURE__*/React__namespace.createElement(Tooltip, _extends({
      target: elementRef,
      content: props.tooltip
    }, props.tooltipOptions, {
      pt: ptm('tooltip')
    })));
  }));
  Dropdown.displayName = 'Dropdown';

  var RowsPerPageDropdown = /*#__PURE__*/React__namespace.memo(function (inProps) {
    var context = React__namespace.useContext(PrimeReactContext);
    var props = RowsPerPageDropdownBase.getProps(inProps, context);
    var hasOptions = props.options && props.options.length > 0;
    var options = hasOptions ? props.options.map(function (opt) {
      return {
        label: String(opt),
        value: opt
      };
    }) : [];
    var ariaLabel = localeOption('choose');
    var element = hasOptions ? /*#__PURE__*/React__namespace.createElement(Dropdown, {
      value: props.value,
      options: options,
      onChange: props.onChange,
      appendTo: props.appendTo,
      disabled: props.disabled,
      placeholder: ariaLabel,
      "aria-label": ariaLabel,
      pt: props.ptm('RPPDropdown'),
      unstyled: props.unstyled,
      __parentMetadata: {
        parent: props.metaData
      }
    }) : null;
    if (props.template) {
      var defaultOptions = {
        value: props.value,
        options: options,
        onChange: props.onChange,
        appendTo: props.appendTo,
        currentPage: props.page,
        totalPages: props.pageCount,
        totalRecords: props.totalRecords,
        disabled: props.disabled,
        element: element,
        props: props
      };
      return ObjectUtils.getJSXElement(props.template, defaultOptions);
    }
    return element;
  });
  RowsPerPageDropdown.displayName = 'RowsPerPageDropdown';

  function ownKeys$1d(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1d(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1d(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1d(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var Paginator = /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var context = React__namespace.useContext(PrimeReactContext);
    var props = PaginatorBase.getProps(inProps, context);
    var metaData = _objectSpread$1d({
      props: props
    }, props.__parentMetadata);
    var _PaginatorBase$setMet = PaginatorBase.setMetaData(metaData),
      ptm = _PaginatorBase$setMet.ptm,
      cx = _PaginatorBase$setMet.cx,
      isUnstyled = _PaginatorBase$setMet.isUnstyled;
    useHandleStyle(PaginatorBase.css.styles, isUnstyled, {
      name: 'paginator'
    });
    var elementRef = React__namespace.useRef(null);
    var page = Math.floor(props.first / props.rows);
    var pageCount = Math.ceil(props.totalRecords / props.rows);
    var isFirstPage = page === 0;
    var isLastPage = page === pageCount - 1;
    var isEmpty = pageCount === 0;
    var calculatePageLinkBoundaries = function calculatePageLinkBoundaries() {
      var numberOfPages = pageCount;
      var visiblePages = Math.min(props.pageLinkSize, numberOfPages);

      //calculate range, keep current in middle if necessary
      var start = Math.max(0, Math.ceil(page - visiblePages / 2));
      var end = Math.min(numberOfPages - 1, start + visiblePages - 1);

      //check when approaching to last page
      var delta = props.pageLinkSize - (end - start + 1);
      start = Math.max(0, start - delta);
      return [start, end];
    };
    var updatePageLinks = function updatePageLinks() {
      var pageLinks = [];
      var boundaries = calculatePageLinkBoundaries();
      var start = boundaries[0];
      var end = boundaries[1];
      for (var i = start; i <= end; i++) {
        pageLinks.push(i + 1);
      }
      return pageLinks;
    };
    var changePage = function changePage(first, rows) {
      var pc = pageCount;
      var p = Math.floor(first / rows);
      if (p >= 0 && p < pc) {
        var newPageState = {
          first: first,
          rows: rows,
          page: p,
          pageCount: pc
        };
        if (props.onPageChange) {
          props.onPageChange(newPageState);
        }
      }
    };
    var changePageToFirst = function changePageToFirst(event) {
      changePage(0, props.rows);
      event.preventDefault();
    };
    var changePageToPrev = function changePageToPrev(event) {
      changePage(props.first - props.rows, props.rows);
      event.preventDefault();
    };
    var onPageLinkClick = function onPageLinkClick(event) {
      changePage((event.value - 1) * props.rows, props.rows);
    };
    var changePageToNext = function changePageToNext(event) {
      changePage(props.first + props.rows, props.rows);
      event.preventDefault();
    };
    var changePageToLast = function changePageToLast(event) {
      changePage((pageCount - 1) * props.rows, props.rows);
      event.preventDefault();
    };
    var onRowsChange = function onRowsChange(event) {
      var rows = event.value;
      changePage(0, rows);
    };
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        getElement: function getElement() {
          return elementRef.current;
        }
      };
    });
    useUpdateEffect(function () {
      if (page > 0 && props.first >= props.totalRecords) {
        changePage((pageCount - 1) * props.rows, props.rows);
      }
    }, [props.totalRecords]);
    var createElement = function createElement(key, template) {
      var element;
      switch (key) {
        case 'FirstPageLink':
          element = /*#__PURE__*/React__namespace.createElement(FirstPageLink, {
            hostName: "Paginator",
            key: key,
            onClick: changePageToFirst,
            disabled: isFirstPage || isEmpty,
            template: template,
            firstPageLinkIcon: props.firstPageLinkIcon,
            ptm: ptm,
            cx: cx
          });
          break;
        case 'PrevPageLink':
          element = /*#__PURE__*/React__namespace.createElement(PrevPageLink, {
            hostName: "Paginator",
            key: key,
            onClick: changePageToPrev,
            disabled: isFirstPage || isEmpty,
            template: template,
            prevPageLinkIcon: props.prevPageLinkIcon,
            ptm: ptm,
            cx: cx
          });
          break;
        case 'NextPageLink':
          element = /*#__PURE__*/React__namespace.createElement(NextPageLink, {
            hostName: "Paginator",
            key: key,
            onClick: changePageToNext,
            disabled: isLastPage || isEmpty,
            template: template,
            nextPageLinkIcon: props.nextPageLinkIcon,
            ptm: ptm,
            cx: cx
          });
          break;
        case 'LastPageLink':
          element = /*#__PURE__*/React__namespace.createElement(LastPageLink, {
            hostName: "Paginator",
            key: key,
            onClick: changePageToLast,
            disabled: isLastPage || isEmpty,
            template: template,
            lastPageLinkIcon: props.lastPageLinkIcon,
            ptm: ptm,
            cx: cx
          });
          break;
        case 'PageLinks':
          element = /*#__PURE__*/React__namespace.createElement(PageLinks, {
            hostName: "Paginator",
            key: key,
            value: updatePageLinks(),
            page: page,
            rows: props.rows,
            pageCount: pageCount,
            onClick: onPageLinkClick,
            template: template,
            ptm: ptm,
            cx: cx
          });
          break;
        case 'RowsPerPageDropdown':
          element = /*#__PURE__*/React__namespace.createElement(RowsPerPageDropdown, {
            hostName: "Paginator",
            key: key,
            value: props.rows,
            page: page,
            pageCount: pageCount,
            totalRecords: props.totalRecords,
            options: props.rowsPerPageOptions,
            onChange: onRowsChange,
            appendTo: props.dropdownAppendTo,
            template: template,
            disabled: isEmpty,
            unstyled: props.unstyled,
            ptm: ptm,
            cx: cx,
            metaData: metaData
          });
          break;
        case 'CurrentPageReport':
          element = /*#__PURE__*/React__namespace.createElement(CurrentPageReport, {
            hostName: "Paginator",
            reportTemplate: props.currentPageReportTemplate,
            key: key,
            page: page,
            pageCount: pageCount,
            first: props.first,
            rows: props.rows,
            totalRecords: props.totalRecords,
            template: template,
            ptm: ptm
          });
          break;
        case 'JumpToPageInput':
          element = /*#__PURE__*/React__namespace.createElement(JumpToPageInput, {
            hostName: "Paginator",
            key: key,
            rows: props.rows,
            page: page,
            pageCount: pageCount,
            onChange: changePage,
            disabled: isEmpty,
            template: template,
            ptm: ptm,
            unstyled: props.unstyled,
            metaData: metaData
          });
          break;
        default:
          element = null;
          break;
      }
      return element;
    };
    var createElements = function createElements() {
      var template = props.template;
      if (template) {
        if (_typeof(template) === 'object') {
          return template.layout ? template.layout.split(' ').map(function (value) {
            var key = value.trim();
            return createElement(key, template[key]);
          }) : Object.entries(template).map(function (_ref) {
            var _ref2 = _slicedToArray(_ref, 2),
              key = _ref2[0],
              _template = _ref2[1];
            return createElement(key, _template);
          });
        }
        return template.split(' ').map(function (value) {
          return createElement(value.trim());
        });
      }
      return null;
    };
    if (!props.alwaysShow && pageCount <= 1) {
      return null;
    } else {
      var leftContent = ObjectUtils.getJSXElement(props.leftContent, props);
      var rightContent = ObjectUtils.getJSXElement(props.rightContent, props);
      var elements = createElements();
      var leftProps = mergeProps({
        className: cx('left')
      }, ptm('left'));
      var leftElement = leftContent && /*#__PURE__*/React__namespace.createElement("div", leftProps, leftContent);
      var endProps = mergeProps({
        className: cx('end')
      }, ptm('end'));
      var rightElement = rightContent && /*#__PURE__*/React__namespace.createElement("div", endProps, rightContent);
      var rootProps = mergeProps({
        ref: elementRef,
        className: classNames(props.className, cx('root')),
        style: props.style
      }, PaginatorBase.getOtherProps(props), ptm('root'));
      return /*#__PURE__*/React__namespace.createElement("div", rootProps, leftElement, elements, rightElement);
    }
  }));
  Paginator.displayName = 'Paginator';

  function ownKeys$1c(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1c(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1c(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1c(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var styles$J = "\n@layer primereact {\n    .p-datatable {\n        position: relative;\n    }\n\n    .p-datatable > .p-datatable-wrapper {\n        overflow: auto;\n    }\n\n    .p-datatable-table {\n        border-spacing: 0px;\n        width: 100%;\n    }\n\n    .p-datatable .p-sortable-disabled {\n        cursor: auto;\n    }\n\n    .p-datatable .p-sortable-column {\n        cursor: pointer;\n        user-select: none;\n    }\n\n    .p-datatable .p-sortable-column .p-column-title,\n    .p-datatable .p-sortable-column .p-sortable-column-icon,\n    .p-datatable .p-sortable-column .p-sortable-column-badge {\n        vertical-align: middle;\n    }\n\n    .p-datatable .p-sortable-column .p-sortable-column-badge {\n        display: inline-flex;\n        align-items: center;\n        justify-content: center;\n    }\n\n    .p-datatable-selectable .p-selectable-row,\n    .p-datatable-selectable-cell .p-selectable-cell {\n        cursor: pointer;\n    }\n\n    .p-datatable-drag-selection-helper {\n        position: absolute;\n        z-index: 99999999;\n    }\n\n    /* Scrollable */\n    .p-datatable-scrollable > .p-datatable-wrapper {\n        position: relative;\n    }\n\n    .p-datatable-scrollable-table > .p-datatable-thead {\n        position: sticky;\n        top: 0;\n        z-index: 1;\n    }\n\n    .p-datatable-scrollable-table > .p-datatable-frozen-tbody {\n        position: sticky;\n        z-index: 1;\n    }\n\n    .p-datatable-scrollable-table > .p-datatable-tfoot {\n        position: sticky;\n        bottom: 0;\n        z-index: 1;\n    }\n\n    .p-datatable-scrollable .p-frozen-column {\n        position: sticky;\n        background: inherit;\n    }\n\n    .p-datatable-scrollable th.p-frozen-column {\n        z-index: 1;\n    }\n\n    .p-datatable-flex-scrollable {\n        display: flex;\n        flex-direction: column;\n        height: 100%;\n    }\n\n    .p-datatable-flex-scrollable > .p-datatable-wrapper {\n        display: flex;\n        flex-direction: column;\n        flex: 1;\n        height: 100%;\n    }\n\n    .p-datatable-scrollable-table > .p-datatable-tbody > .p-rowgroup-header {\n        position: sticky;\n        z-index: 1;\n    }\n\n    /* Resizable */\n    .p-datatable-resizable-table > .p-datatable-thead > tr > th,\n    .p-datatable-resizable-table > .p-datatable-tfoot > tr > td,\n    .p-datatable-resizable-table > .p-datatable-tbody > tr > td {\n        overflow: hidden;\n        white-space: nowrap;\n    }\n\n    .p-datatable-resizable-table > .p-datatable-thead > tr > th.p-resizable-column:not(.p-frozen-column) {\n        background-clip: padding-box;\n        position: relative;\n    }\n\n    .p-datatable-resizable-table-fit > .p-datatable-thead > tr > th.p-resizable-column:last-child .p-column-resizer {\n        display: none;\n    }\n\n    .p-datatable .p-column-resizer {\n        display: block;\n        position: absolute;\n        top: 0;\n        right: 0;\n        margin: 0;\n        width: 0.5rem;\n        height: 100%;\n        padding: 0px;\n        cursor: col-resize;\n        border: 1px solid transparent;\n    }\n\n    .p-datatable .p-column-header-content {\n        display: flex;\n        align-items: center;\n    }\n\n    .p-datatable .p-column-resizer-helper {\n        width: 1px;\n        position: absolute;\n        z-index: 10;\n        display: none;\n    }\n\n    .p-datatable .p-row-editor-init,\n    .p-datatable .p-row-editor-save,\n    .p-datatable .p-row-editor-cancel {\n        display: inline-flex;\n        align-items: center;\n        justify-content: center;\n        overflow: hidden;\n        position: relative;\n    }\n\n    /* Expand */\n    .p-datatable .p-row-toggler {\n        display: inline-flex;\n        align-items: center;\n        justify-content: center;\n        overflow: hidden;\n        position: relative;\n    }\n\n    /* Reorder */\n    .p-datatable-reorder-indicator-up,\n    .p-datatable-reorder-indicator-down {\n        position: absolute;\n        display: none;\n    }\n\n    .p-reorderable-column,\n    .p-datatable-reorderablerow-handle {\n        cursor: move;\n    }\n\n    /* Loader */\n    .p-datatable .p-datatable-loading-overlay {\n        position: absolute;\n        display: flex;\n        align-items: center;\n        justify-content: center;\n        z-index: 2;\n    }\n\n    /* Filter */\n    .p-column-filter-row {\n        display: flex;\n        align-items: center;\n        width: 100%;\n    }\n\n    .p-column-filter-menu {\n        display: inline-flex;\n        margin-left: auto;\n    }\n\n    .p-column-filter-row .p-column-filter-element {\n        flex: 1 1 auto;\n        width: 1%;\n    }\n\n    .p-column-filter-menu-button,\n    .p-column-filter-clear-button {\n        display: inline-flex;\n        justify-content: center;\n        align-items: center;\n        cursor: pointer;\n        text-decoration: none;\n        overflow: hidden;\n        position: relative;\n    }\n\n    .p-column-filter-overlay {\n        position: absolute;\n        top: 0;\n        left: 0;\n    }\n\n    .p-column-filter-row-items {\n        margin: 0;\n        padding: 0;\n        list-style: none;\n    }\n\n    .p-column-filter-row-item {\n        cursor: pointer;\n    }\n\n    .p-column-filter-add-button,\n    .p-column-filter-remove-button {\n        justify-content: center;\n    }\n\n    .p-column-filter-add-button .p-button-label,\n    .p-column-filter-remove-button .p-button-label {\n        flex-grow: 0;\n    }\n\n    .p-column-filter-buttonbar {\n        display: flex;\n        align-items: center;\n        justify-content: space-between;\n    }\n\n    .p-column-filter-buttonbar .p-button:not(.p-button-icon-only) {\n        width: auto;\n    }\n\n    /* Responsive */\n    .p-datatable .p-datatable-tbody > tr > td > .p-column-title {\n        display: none;\n    }\n\n    /* VirtualScroller */\n    .p-datatable-virtualscroller-spacer {\n        display: flex;\n    }\n\n    .p-datatable .p-virtualscroller .p-virtualscroller-loading {\n        transform: none;\n        min-height: 0;\n        position: sticky;\n        top: 0;\n        left: 0;\n    }\n\n  