this.primereact = this.primereact || {};
this.primereact.messages = (function (exports, React, reactTransitionGroup, api, componentbase, csstransition, hooks, utils, check, exclamationtriangle, infocircle, times, timescircle, ripple) {
  'use strict';

  function _interopNamespace(e) {
    if (e && e.__esModule) return e;
    var n = Object.create(null);
    if (e) {
      Object.keys(e).forEach(function (k) {
        if (k !== 'default') {
          var d = Object.getOwnPropertyDescriptor(e, k);
          Object.defineProperty(n, k, d.get ? d : {
            enumerable: true,
            get: function () { return e[k]; }
          });
        }
      });
    }
    n["default"] = e;
    return Object.freeze(n);
  }

  var React__namespace = /*#__PURE__*/_interopNamespace(React);

  function _extends() {
    return _extends = Object.assign ? Object.assign.bind() : function (n) {
      for (var e = 1; e < arguments.length; e++) {
        var t = arguments[e];
        for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]);
      }
      return n;
    }, _extends.apply(null, arguments);
  }

  function _arrayLikeToArray(r, a) {
    (null == a || a > r.length) && (a = r.length);
    for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e];
    return n;
  }

  function _arrayWithoutHoles(r) {
    if (Array.isArray(r)) return _arrayLikeToArray(r);
  }

  function _iterableToArray(r) {
    if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r);
  }

  function _unsupportedIterableToArray(r, a) {
    if (r) {
      if ("string" == typeof r) return _arrayLikeToArray(r, a);
      var t = {}.toString.call(r).slice(8, -1);
      return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0;
    }
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }

  function _toConsumableArray(r) {
    return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread();
  }

  function _typeof(o) {
    "@babel/helpers - typeof";

    return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) {
      return typeof o;
    } : function (o) {
      return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o;
    }, _typeof(o);
  }

  function toPrimitive(t, r) {
    if ("object" != _typeof(t) || !t) return t;
    var e = t[Symbol.toPrimitive];
    if (void 0 !== e) {
      var i = e.call(t, r || "default");
      if ("object" != _typeof(i)) return i;
      throw new TypeError("@@toPrimitive must return a primitive value.");
    }
    return ("string" === r ? String : Number)(t);
  }

  function toPropertyKey(t) {
    var i = toPrimitive(t, "string");
    return "symbol" == _typeof(i) ? i : i + "";
  }

  function _defineProperty(e, r, t) {
    return (r = toPropertyKey(r)) in e ? Object.defineProperty(e, r, {
      value: t,
      enumerable: !0,
      configurable: !0,
      writable: !0
    }) : e[r] = t, e;
  }

  function _arrayWithHoles(r) {
    if (Array.isArray(r)) return r;
  }

  function _iterableToArrayLimit(r, l) {
    var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"];
    if (null != t) {
      var e,
        n,
        i,
        u,
        a = [],
        f = !0,
        o = !1;
      try {
        if (i = (t = t.call(r)).next, 0 === l) {
          if (Object(t) !== t) return;
          f = !1;
        } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0);
      } catch (r) {
        o = !0, n = r;
      } finally {
        try {
          if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return;
        } finally {
          if (o) throw n;
        }
      }
      return a;
    }
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }

  function _slicedToArray(r, e) {
    return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest();
  }

  var styles = "\n@layer primereact {\n    .p-message-wrapper {\n        display: flex;\n        align-items: center;\n    }\n\n    .p-message-icon {\n        flex-shrink: 0;\n    }\n    \n    .p-message-close {\n        display: flex;\n        align-items: center;\n        justify-content: center;\n    }\n    \n    .p-message-close.p-link {\n        margin-left: auto;\n        overflow: hidden;\n        position: relative;\n    }\n    \n    .p-message-enter {\n        opacity: 0;\n    }\n    \n    .p-message-enter-active {\n        opacity: 1;\n        transition: opacity .3s;\n    }\n    \n    .p-message-exit {\n        opacity: 1;\n        max-height: 1000px;\n    }\n    \n    .p-message-exit-active {\n        opacity: 0;\n        max-height: 0;\n        margin: 0;\n        overflow: hidden;\n        transition: max-height .3s cubic-bezier(0, 1, 0, 1), opacity .3s, margin .3s;\n    }\n    \n    .p-message-exit-active .p-message-close {\n        display: none;\n    }\n}\n";
  var classes = {
    uimessage: {
      root: function root(_ref) {
        var severity = _ref.severity;
        return utils.classNames('p-message p-component', _defineProperty({}, "p-message-".concat(severity), severity));
      },
      wrapper: 'p-message-wrapper',
      detail: 'p-message-detail',
      summary: 'p-message-summary',
      icon: 'p-message-icon',
      buttonicon: 'p-message-close-icon',
      button: 'p-message-close p-link',
      transition: 'p-message'
    }
  };
  var MessagesBase = componentbase.ComponentBase.extend({
    defaultProps: {
      __TYPE: 'Messages',
      __parentMetadata: null,
      id: null,
      className: null,
      style: null,
      transitionOptions: null,
      onRemove: null,
      onClick: null,
      children: undefined
    },
    css: {
      classes: classes,
      styles: styles
    }
  });

  function ownKeys$1(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var UIMessage = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (props, ref) {
    var mergeProps = hooks.useMergeProps();
    var messageInfo = props.message,
      parentMetaData = props.metaData,
      _props$ptCallbacks = props.ptCallbacks,
      ptm = _props$ptCallbacks.ptm,
      ptmo = _props$ptCallbacks.ptmo,
      cx = _props$ptCallbacks.cx,
      index = props.index;
    var _messageInfo$message = messageInfo.message,
      severity = _messageInfo$message.severity,
      content = _messageInfo$message.content,
      summary = _messageInfo$message.summary,
      detail = _messageInfo$message.detail,
      closable = _messageInfo$message.closable,
      life = _messageInfo$message.life,
      sticky = _messageInfo$message.sticky,
      _className = _messageInfo$message.className,
      style = _messageInfo$message.style,
      _contentClassName = _messageInfo$message.contentClassName,
      contentStyle = _messageInfo$message.contentStyle,
      _icon = _messageInfo$message.icon,
      _closeIcon = _messageInfo$message.closeIcon,
      pt = _messageInfo$message.pt;
    var params = {
      index: index
    };
    var parentParams = _objectSpread$1(_objectSpread$1({}, parentMetaData), params);
    var _useTimeout = hooks.useTimeout(function () {
        onClose(null);
      }, life || 3000, !sticky),
      _useTimeout2 = _slicedToArray(_useTimeout, 1),
      clearTimer = _useTimeout2[0];
    var getPTOptions = function getPTOptions(key, options) {
      return ptm(key, _objectSpread$1({
        hostName: props.hostName
      }, options));
    };
    var onClose = function onClose(event) {
      clearTimer();
      props.onClose && props.onClose(props.message);
      if (event) {
        event.preventDefault();
        event.stopPropagation();
      }
    };
    var onClick = function onClick() {
      props.onClick && props.onClick(props.message);
    };
    var createCloseIcon = function createCloseIcon() {
      if (closable !== false) {
        var buttonIconProps = mergeProps({
          className: cx('uimessage.buttonicon')
        }, getPTOptions('buttonicon', parentParams), ptmo(pt, 'buttonicon', _objectSpread$1(_objectSpread$1({}, params), {}, {
          hostName: props.hostName
        })));
        var icon = _closeIcon || /*#__PURE__*/React__namespace.createElement(times.TimesIcon, buttonIconProps);
        var _closeIcon2 = utils.IconUtils.getJSXIcon(icon, _objectSpread$1({}, buttonIconProps), {
          props: props
        });
        var buttonProps = mergeProps({
          type: 'button',
          className: cx('uimessage.button'),
          'aria-label': api.ariaLabel('close'),
          onClick: onClose
        }, getPTOptions('button', parentParams), ptmo(pt, 'button', _objectSpread$1(_objectSpread$1({}, params), {}, {
          hostName: props.hostName
        })));
        return /*#__PURE__*/React__namespace.createElement("button", buttonProps, _closeIcon2, /*#__PURE__*/React__namespace.createElement(ripple.Ripple, null));
      }
      return null;
    };
    var createMessage = function createMessage() {
      if (props.message) {
        var iconProps = mergeProps({
          className: cx('uimessage.icon')
        }, getPTOptions('icon', parentParams), ptmo(pt, 'icon', _objectSpread$1(_objectSpread$1({}, params), {}, {
          hostName: props.hostName
        })));
        var icon = _icon;
        if (!_icon) {
          switch (severity) {
            case 'info':
              icon = /*#__PURE__*/React__namespace.createElement(infocircle.InfoCircleIcon, iconProps);
              break;
            case 'warn':
              icon = /*#__PURE__*/React__namespace.createElement(exclamationtriangle.ExclamationTriangleIcon, iconProps);
              break;
            case 'error':
              icon = /*#__PURE__*/React__namespace.createElement(timescircle.TimesCircleIcon, iconProps);
              break;
            case 'success':
              icon = /*#__PURE__*/React__namespace.createElement(check.CheckIcon, iconProps);
              break;
          }
        }
        var iconContent = utils.IconUtils.getJSXIcon(icon, _objectSpread$1({}, iconProps), {
          props: props
        });
        var summaryProps = mergeProps({
          className: cx('uimessage.summary')
        }, getPTOptions('summary', parentParams), ptmo(pt, 'summary', _objectSpread$1(_objectSpread$1({}, params), {}, {
          hostName: props.hostName
        })));
        var detailProps = mergeProps({
          className: cx('uimessage.detail')
        }, getPTOptions('detail', parentParams), ptmo(pt, 'detail', _objectSpread$1(_objectSpread$1({}, params), {}, {
          hostName: props.hostName
        })));
        return content || /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, null, iconContent, /*#__PURE__*/React__namespace.createElement("span", summaryProps, summary), /*#__PURE__*/React__namespace.createElement("span", detailProps, detail));
      }
      return null;
    };
    var closeIcon = createCloseIcon();
    var message = createMessage();
    var wrapperProps = mergeProps({
      className: utils.classNames(_contentClassName, cx('uimessage.wrapper')),
      style: contentStyle
    }, getPTOptions('wrapper', parentParams), ptmo(pt, 'wrapper', _objectSpread$1(_objectSpread$1({}, params), {}, {
      hostName: props.hostName
    })));
    var rootProps = mergeProps({
      ref: ref,
      className: utils.classNames(_className, cx('uimessage.root', {
        severity: severity
      })),
      style: style,
      role: 'alert',
      'aria-live': 'assertive',
      'aria-atomic': 'true',
      onClick: onClick
    }, getPTOptions('root', parentParams), ptmo(pt, 'root', _objectSpread$1(_objectSpread$1({}, params), {}, {
      hostName: props.hostName
    })));
    return /*#__PURE__*/React__namespace.createElement("div", rootProps, /*#__PURE__*/React__namespace.createElement("div", wrapperProps, message, closeIcon));
  }));
  UIMessage.displayName = 'UIMessage';

  function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var messageIdx = 0;
  var Messages = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var mergeProps = hooks.useMergeProps();
    var context = React__namespace.useContext(api.PrimeReactContext);
    var props = MessagesBase.getProps(inProps, context);
    var _React$useState = React__namespace.useState([]),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      messagesState = _React$useState2[0],
      setMessagesState = _React$useState2[1];
    var elementRef = React__namespace.useRef(null);
    var metaData = _objectSpread(_objectSpread({
      props: props
    }, props.__parentMetadata), {}, {
      state: {
        messages: messagesState
      }
    });
    var ptCallbacks = MessagesBase.setMetaData(metaData);
    componentbase.useHandleStyle(MessagesBase.css.styles, ptCallbacks.isUnstyled, {
      name: 'messages'
    });
    var show = function show(messageInfo) {
      if (messageInfo) {
        setMessagesState(function (prev) {
          return assignIdentifiers(prev, messageInfo, true);
        });
      }
    };
    var assignIdentifiers = function assignIdentifiers(currentState, messageInfo, copy) {
      var messages;
      if (Array.isArray(messageInfo)) {
        var multipleMessages = messageInfo.reduce(function (acc, message) {
          acc.push({
            _pId: messageIdx++,
            message: message
          });
          return acc;
        }, []);
        if (copy) {
          messages = currentState ? [].concat(_toConsumableArray(currentState), _toConsumableArray(multipleMessages)) : multipleMessages;
        } else {
          messages = multipleMessages;
        }
      } else {
        var message = {
          _pId: messageIdx++,
          message: messageInfo
        };
        if (copy) {
          messages = currentState ? [].concat(_toConsumableArray(currentState), [message]) : [message];
        } else {
          messages = [message];
        }
      }
      return messages;
    };
    var clear = function clear() {
      setMessagesState([]);
    };
    var replace = function replace(messageInfo) {
      setMessagesState(function (prev) {
        return assignIdentifiers(prev, messageInfo, false);
      });
    };
    var remove = function remove(messageInfo) {
      // allow removal by ID or by message equality
      var removeMessage = utils.ObjectUtils.isNotEmpty(messageInfo._pId) ? messageInfo._pId : messageInfo.message || messageInfo;
      setMessagesState(function (prev) {
        return prev.filter(function (msg) {
          return msg._pId !== messageInfo._pId && !utils.ObjectUtils.deepEquals(msg.message, removeMessage);
        });
      });
      props.onRemove && props.onRemove(messageInfo.message || removeMessage);
    };
    var onClose = function onClose(messageInfo) {
      remove(messageInfo);
    };
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        show: show,
        replace: replace,
        remove: remove,
        clear: clear,
        getElement: function getElement() {
          return elementRef.current;
        }
      };
    });
    var rootProps = mergeProps({
      id: props.id,
      className: props.className,
      style: props.style
    }, MessagesBase.getOtherProps(props), ptCallbacks.ptm('root'));
    var transitionProps = mergeProps({
      classNames: ptCallbacks.cx('uimessage.transition'),
      unmountOnExit: true,
      timeout: {
        enter: 300,
        exit: 300
      },
      options: props.transitionOptions
    }, ptCallbacks.ptm('transition'));
    return /*#__PURE__*/React__namespace.createElement("div", _extends({
      ref: elementRef
    }, rootProps), /*#__PURE__*/React__namespace.createElement(reactTransitionGroup.TransitionGroup, null, messagesState && messagesState.map(function (message, index) {
      var messageRef = /*#__PURE__*/React__namespace.createRef();
      return /*#__PURE__*/React__namespace.createElement(csstransition.CSSTransition, _extends({
        nodeRef: messageRef,
        key: message._pId
      }, transitionProps), /*#__PURE__*/React__namespace.createElement(UIMessage, {
        hostName: "Messages",
        ref: messageRef,
        message: message,
        onClick: props.onClick,
        onClose: onClose,
        ptCallbacks: ptCallbacks,
        metaData: metaData,
        index: index
      }));
    })));
  }));
  Messages.displayName = 'Messages';

  exports.Messages = Messages;

  Object.defineProperty(exports, '__esModule', { value: true });

  return exports;

})({}, React, ReactTransitionGroup, primereact.api, primereact.componentbase, primereact.csstransition, primereact.hooks, primereact.utils, primereact.icons.check, primereact.icons.exclamationtriangle, primereact.icons.infocircle, primereact.icons.times, primereact.icons.timescircle, primereact.ripple);
