var primereact = (function (exports, React, reactTransitionGroup, ReactDOM) {
  'use strict';

  function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

  function _interopNamespace(e) {
    if (e && e.__esModule) return e;
    var n = Object.create(null);
    if (e) {
      Object.keys(e).forEach(function (k) {
        if (k !== 'default') {
          var d = Object.getOwnPropertyDescriptor(e, k);
          Object.defineProperty(n, k, d.get ? d : {
            enumerable: true,
            get: function () { return e[k]; }
          });
        }
      });
    }
    n["default"] = e;
    return Object.freeze(n);
  }

  var React__namespace = /*#__PURE__*/_interopNamespace(React);
  var React__default = /*#__PURE__*/_interopDefaultLegacy(React);
  var ReactDOM__default = /*#__PURE__*/_interopDefaultLegacy(ReactDOM);

  function _extends() {
    return _extends = Object.assign ? Object.assign.bind() : function (n) {
      for (var e = 1; e < arguments.length; e++) {
        var t = arguments[e];
        for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]);
      }
      return n;
    }, _extends.apply(null, arguments);
  }

  function _arrayLikeToArray$i(r, a) {
    (null == a || a > r.length) && (a = r.length);
    for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e];
    return n;
  }

  function _arrayWithoutHoles(r) {
    if (Array.isArray(r)) return _arrayLikeToArray$i(r);
  }

  function _iterableToArray(r) {
    if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r);
  }

  function _unsupportedIterableToArray$i(r, a) {
    if (r) {
      if ("string" == typeof r) return _arrayLikeToArray$i(r, a);
      var t = {}.toString.call(r).slice(8, -1);
      return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray$i(r, a) : void 0;
    }
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }

  function _toConsumableArray(r) {
    return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray$i(r) || _nonIterableSpread();
  }

  function _typeof(o) {
    "@babel/helpers - typeof";

    return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) {
      return typeof o;
    } : function (o) {
      return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o;
    }, _typeof(o);
  }

  function toPrimitive(t, r) {
    if ("object" != _typeof(t) || !t) return t;
    var e = t[Symbol.toPrimitive];
    if (void 0 !== e) {
      var i = e.call(t, r || "default");
      if ("object" != _typeof(i)) return i;
      throw new TypeError("@@toPrimitive must return a primitive value.");
    }
    return ("string" === r ? String : Number)(t);
  }

  function toPropertyKey(t) {
    var i = toPrimitive(t, "string");
    return "symbol" == _typeof(i) ? i : i + "";
  }

  function _defineProperty(e, r, t) {
    return (r = toPropertyKey(r)) in e ? Object.defineProperty(e, r, {
      value: t,
      enumerable: !0,
      configurable: !0,
      writable: !0
    }) : e[r] = t, e;
  }

  function _arrayWithHoles(r) {
    if (Array.isArray(r)) return r;
  }

  function _iterableToArrayLimit(r, l) {
    var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"];
    if (null != t) {
      var e,
        n,
        i,
        u,
        a = [],
        f = !0,
        o = !1;
      try {
        if (i = (t = t.call(r)).next, 0 === l) {
          if (Object(t) !== t) return;
          f = !1;
        } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0);
      } catch (r) {
        o = !0, n = r;
      } finally {
        try {
          if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return;
        } finally {
          if (o) throw n;
        }
      }
      return a;
    }
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }

  function _slicedToArray(r, e) {
    return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray$i(r, e) || _nonIterableRest();
  }

  var FilterMatchMode = Object.freeze({
    STARTS_WITH: 'startsWith',
    CONTAINS: 'contains',
    NOT_CONTAINS: 'notContains',
    ENDS_WITH: 'endsWith',
    EQUALS: 'equals',
    NOT_EQUALS: 'notEquals',
    IN: 'in',
    NOT_IN: 'notIn',
    LESS_THAN: 'lt',
    LESS_THAN_OR_EQUAL_TO: 'lte',
    GREATER_THAN: 'gt',
    GREATER_THAN_OR_EQUAL_TO: 'gte',
    BETWEEN: 'between',
    DATE_IS: 'dateIs',
    DATE_IS_NOT: 'dateIsNot',
    DATE_BEFORE: 'dateBefore',
    DATE_AFTER: 'dateAfter',
    CUSTOM: 'custom'
  });

  var FilterOperator = Object.freeze({
    AND: 'and',
    OR: 'or'
  });

  function classNames() {
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    if (args) {
      var classes = [];
      for (var i = 0; i < args.length; i++) {
        var className = args[i];
        if (!className) {
          continue;
        }
        var type = _typeof(className);
        if (type === 'string' || type === 'number') {
          classes.push(className);
        } else if (type === 'object') {
          var _classes = Array.isArray(className) ? className : Object.entries(className).map(function (_ref) {
            var _ref2 = _slicedToArray(_ref, 2),
              key = _ref2[0],
              value = _ref2[1];
            return value ? key : null;
          });
          classes = _classes.length ? classes.concat(_classes.filter(function (c) {
            return !!c;
          })) : classes;
        }
      }
      return classes.join(' ').trim();
    }
    return undefined;
  }

  function _classCallCheck(a, n) {
    if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function");
  }

  function _defineProperties(e, r) {
    for (var t = 0; t < r.length; t++) {
      var o = r[t];
      o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, toPropertyKey(o.key), o);
    }
  }
  function _createClass(e, r, t) {
    return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", {
      writable: !1
    }), e;
  }

  function _createForOfIteratorHelper$h(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray$h(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t["return"] || t["return"](); } finally { if (u) throw o; } } }; }
  function _unsupportedIterableToArray$h(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray$h(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray$h(r, a) : void 0; } }
  function _arrayLikeToArray$h(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
  var DomHandler = /*#__PURE__*/function () {
    function DomHandler() {
      _classCallCheck(this, DomHandler);
    }
    return _createClass(DomHandler, null, [{
      key: "innerWidth",
      value: function innerWidth(el) {
        if (el) {
          var width = el.offsetWidth;
          var style = getComputedStyle(el);
          width = width + (parseFloat(style.paddingLeft) + parseFloat(style.paddingRight));
          return width;
        }
        return 0;
      }
    }, {
      key: "width",
      value: function width(el) {
        if (el) {
          var _width = el.offsetWidth;
          var style = getComputedStyle(el);
          _width = _width - (parseFloat(style.paddingLeft) + parseFloat(style.paddingRight));
          return _width;
        }
        return 0;
      }
    }, {
      key: "getBrowserLanguage",
      value: function getBrowserLanguage() {
        return navigator.userLanguage || navigator.languages && navigator.languages.length && navigator.languages[0] || navigator.language || navigator.browserLanguage || navigator.systemLanguage || 'en';
      }
    }, {
      key: "getWindowScrollTop",
      value: function getWindowScrollTop() {
        var doc = document.documentElement;
        return (window.pageYOffset || doc.scrollTop) - (doc.clientTop || 0);
      }
    }, {
      key: "getWindowScrollLeft",
      value: function getWindowScrollLeft() {
        var doc = document.documentElement;
        return (window.pageXOffset || doc.scrollLeft) - (doc.clientLeft || 0);
      }
    }, {
      key: "getOuterWidth",
      value: function getOuterWidth(el, margin) {
        if (el) {
          var width = el.getBoundingClientRect().width || el.offsetWidth;
          if (margin) {
            var style = getComputedStyle(el);
            width = width + (parseFloat(style.marginLeft) + parseFloat(style.marginRight));
          }
          return width;
        }
        return 0;
      }
    }, {
      key: "getOuterHeight",
      value: function getOuterHeight(el, margin) {
        if (el) {
          var height = el.getBoundingClientRect().height || el.offsetHeight;
          if (margin) {
            var style = getComputedStyle(el);
            height = height + (parseFloat(style.marginTop) + parseFloat(style.marginBottom));
          }
          return height;
        }
        return 0;
      }
    }, {
      key: "getClientHeight",
      value: function getClientHeight(el, margin) {
        if (el) {
          var height = el.clientHeight;
          if (margin) {
            var style = getComputedStyle(el);
            height = height + (parseFloat(style.marginTop) + parseFloat(style.marginBottom));
          }
          return height;
        }
        return 0;
      }
    }, {
      key: "getClientWidth",
      value: function getClientWidth(el, margin) {
        if (el) {
          var width = el.clientWidth;
          if (margin) {
            var style = getComputedStyle(el);
            width = width + (parseFloat(style.marginLeft) + parseFloat(style.marginRight));
          }
          return width;
        }
        return 0;
      }
    }, {
      key: "getViewport",
      value: function getViewport() {
        var win = window;
        var d = document;
        var e = d.documentElement;
        var g = d.getElementsByTagName('body')[0];
        var w = win.innerWidth || e.clientWidth || g.clientWidth;
        var h = win.innerHeight || e.clientHeight || g.clientHeight;
        return {
          width: w,
          height: h
        };
      }
    }, {
      key: "getOffset",
      value: function getOffset(el) {
        if (el) {
          var rect = el.getBoundingClientRect();
          return {
            top: rect.top + (window.pageYOffset || document.documentElement.scrollTop || document.body.scrollTop || 0),
            left: rect.left + (window.pageXOffset || document.documentElement.scrollLeft || document.body.scrollLeft || 0)
          };
        }
        return {
          top: 'auto',
          left: 'auto'
        };
      }
    }, {
      key: "index",
      value: function index(element) {
        if (element) {
          var children = element.parentNode.childNodes;
          var num = 0;
          for (var i = 0; i < children.length; i++) {
            if (children[i] === element) {
              return num;
            }
            if (children[i].nodeType === 1) {
              num++;
            }
          }
        }
        return -1;
      }
    }, {
      key: "addMultipleClasses",
      value: function addMultipleClasses(element, className) {
        if (element && className) {
          if (element.classList) {
            var styles = className.split(' ');
            for (var i = 0; i < styles.length; i++) {
              element.classList.add(styles[i]);
            }
          } else {
            var _styles = className.split(' ');
            for (var _i = 0; _i < _styles.length; _i++) {
              element.className = element.className + (' ' + _styles[_i]);
            }
          }
        }
      }
    }, {
      key: "removeMultipleClasses",
      value: function removeMultipleClasses(element, className) {
        if (element && className) {
          if (element.classList) {
            var styles = className.split(' ');
            for (var i = 0; i < styles.length; i++) {
              element.classList.remove(styles[i]);
            }
          } else {
            var _styles2 = className.split(' ');
            for (var _i2 = 0; _i2 < _styles2.length; _i2++) {
              element.className = element.className.replace(new RegExp('(^|\\b)' + _styles2[_i2].split(' ').join('|') + '(\\b|$)', 'gi'), ' ');
            }
          }
        }
      }
    }, {
      key: "addClass",
      value: function addClass(element, className) {
        if (element && className) {
          if (element.classList) {
            element.classList.add(className);
          } else {
            element.className = element.className + (' ' + className);
          }
        }
      }
    }, {
      key: "removeClass",
      value: function removeClass(element, className) {
        if (element && className) {
          if (element.classList) {
            element.classList.remove(className);
          } else {
            element.className = element.className.replace(new RegExp('(^|\\b)' + className.split(' ').join('|') + '(\\b|$)', 'gi'), ' ');
          }
        }
      }
    }, {
      key: "hasClass",
      value: function hasClass(element, className) {
        if (element) {
          if (element.classList) {
            return element.classList.contains(className);
          }
          return new RegExp('(^| )' + className + '( |$)', 'gi').test(element.className);
        }
        return false;
      }
    }, {
      key: "addStyles",
      value: function addStyles(element) {
        var styles = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        if (element) {
          Object.entries(styles).forEach(function (_ref) {
            var _ref2 = _slicedToArray(_ref, 2),
              key = _ref2[0],
              value = _ref2[1];
            return element.style[key] = value;
          });
        }
      }
    }, {
      key: "find",
      value: function find(element, selector) {
        return element ? Array.from(element.querySelectorAll(selector)) : [];
      }
    }, {
      key: "findSingle",
      value: function findSingle(element, selector) {
        if (element) {
          return element.querySelector(selector);
        }
        return null;
      }
    }, {
      key: "setAttributes",
      value: function setAttributes(element) {
        var _this = this;
        var attributes = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        if (element) {
          var _computedStyles = function computedStyles(rule, value) {
            var _element$$attrs, _element$$attrs2;
            var styles = element !== null && element !== void 0 && (_element$$attrs = element.$attrs) !== null && _element$$attrs !== void 0 && _element$$attrs[rule] ? [element === null || element === void 0 || (_element$$attrs2 = element.$attrs) === null || _element$$attrs2 === void 0 ? void 0 : _element$$attrs2[rule]] : [];
            return [value].flat().reduce(function (cv, v) {
              if (v !== null && v !== undefined) {
                var type = _typeof(v);
                if (type === 'string' || type === 'number') {
                  cv.push(v);
                } else if (type === 'object') {
                  var _cv = Array.isArray(v) ? _computedStyles(rule, v) : Object.entries(v).map(function (_ref3) {
                    var _ref4 = _slicedToArray(_ref3, 2),
                      _k = _ref4[0],
                      _v = _ref4[1];
                    return rule === 'style' && (!!_v || _v === 0) ? "".concat(_k.replace(/([a-z])([A-Z])/g, '$1-$2').toLowerCase(), ":").concat(_v) : _v ? _k : undefined;
                  });
                  cv = _cv.length ? cv.concat(_cv.filter(function (c) {
                    return !!c;
                  })) : cv;
                }
              }
              return cv;
            }, styles);
          };
          Object.entries(attributes).forEach(function (_ref5) {
            var _ref6 = _slicedToArray(_ref5, 2),
              key = _ref6[0],
              value = _ref6[1];
            if (value !== undefined && value !== null) {
              var matchedEvent = key.match(/^on(.+)/);
              if (matchedEvent) {
                element.addEventListener(matchedEvent[1].toLowerCase(), value);
              } else if (key === 'p-bind') {
                _this.setAttributes(element, value);
              } else {
                value = key === 'class' ? _toConsumableArray(new Set(_computedStyles('class', value))).join(' ').trim() : key === 'style' ? _computedStyles('style', value).join(';').trim() : value;
                (element.$attrs = element.$attrs || {}) && (element.$attrs[key] = value);
                element.setAttribute(key, value);
              }
            }
          });
        }
      }
    }, {
      key: "getAttribute",
      value: function getAttribute(element, name) {
        if (element) {
          var value = element.getAttribute(name);
          if (!isNaN(value)) {
            return +value;
          }
          if (value === 'true' || value === 'false') {
            return value === 'true';
          }
          return value;
        }
        return undefined;
      }
    }, {
      key: "isAttributeEquals",
      value: function isAttributeEquals(element, name, value) {
        return element ? this.getAttribute(element, name) === value : false;
      }
    }, {
      key: "isAttributeNotEquals",
      value: function isAttributeNotEquals(element, name, value) {
        return !this.isAttributeEquals(element, name, value);
      }
    }, {
      key: "getHeight",
      value: function getHeight(el) {
        if (el) {
          var height = el.offsetHeight;
          var style = getComputedStyle(el);
          height = height - (parseFloat(style.paddingTop) + parseFloat(style.paddingBottom) + parseFloat(style.borderTopWidth) + parseFloat(style.borderBottomWidth));
          return height;
        }
        return 0;
      }
    }, {
      key: "getWidth",
      value: function getWidth(el) {
        if (el) {
          var width = el.offsetWidth;
          var style = getComputedStyle(el);
          width = width - (parseFloat(style.paddingLeft) + parseFloat(style.paddingRight) + parseFloat(style.borderLeftWidth) + parseFloat(style.borderRightWidth));
          return width;
        }
        return 0;
      }
    }, {
      key: "alignOverlay",
      value: function alignOverlay(overlay, target, appendTo) {
        var calculateMinWidth = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : true;
        if (overlay && target) {
          if (appendTo === 'self') {
            this.relativePosition(overlay, target);
          } else {
            calculateMinWidth && (overlay.style.minWidth = DomHandler.getOuterWidth(target) + 'px');
            this.absolutePosition(overlay, target);
          }
        }
      }
    }, {
      key: "absolutePosition",
      value: function absolutePosition(element, target) {
        var align = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'left';
        if (element && target) {
          var elementDimensions = element.offsetParent ? {
            width: element.offsetWidth,
            height: element.offsetHeight
          } : this.getHiddenElementDimensions(element);
          var elementOuterHeight = elementDimensions.height;
          var elementOuterWidth = elementDimensions.width;
          var targetOuterHeight = target.offsetHeight;
          var targetOuterWidth = target.offsetWidth;
          var targetOffset = target.getBoundingClientRect();
          var windowScrollTop = this.getWindowScrollTop();
          var windowScrollLeft = this.getWindowScrollLeft();
          var viewport = this.getViewport();
          var top;
          var left;
          if (targetOffset.top + targetOuterHeight + elementOuterHeight > viewport.height) {
            top = targetOffset.top + windowScrollTop - elementOuterHeight;
            if (top < 0) {
              top = windowScrollTop;
            }
            element.style.transformOrigin = 'bottom';
          } else {
            top = targetOuterHeight + targetOffset.top + windowScrollTop;
            element.style.transformOrigin = 'top';
          }
          var targetOffsetPx = targetOffset.left;
          if (align === 'left') {
            if (targetOffsetPx + elementOuterWidth > viewport.width) {
              left = Math.max(0, targetOffsetPx + windowScrollLeft + targetOuterWidth - elementOuterWidth);
            } else {
              left = targetOffsetPx + windowScrollLeft;
            }
          } else {
            if (targetOffsetPx + targetOuterWidth - elementOuterWidth < 0) {
              left = windowScrollLeft;
            } else {
              left = targetOffsetPx + targetOuterWidth - elementOuterWidth + windowScrollLeft;
            }
          }
          element.style.top = top + 'px';
          element.style.left = left + 'px';
        }
      }
    }, {
      key: "relativePosition",
      value: function relativePosition(element, target) {
        if (element && target) {
          var elementDimensions = element.offsetParent ? {
            width: element.offsetWidth,
            height: element.offsetHeight
          } : this.getHiddenElementDimensions(element);
          var targetHeight = target.offsetHeight;
          var targetOffset = target.getBoundingClientRect();
          var viewport = this.getViewport();
          var top;
          var left;
          if (targetOffset.top + targetHeight + elementDimensions.height > viewport.height) {
            top = -1 * elementDimensions.height;
            if (targetOffset.top + top < 0) {
              top = -1 * targetOffset.top;
            }
            element.style.transformOrigin = 'bottom';
          } else {
            top = targetHeight;
            element.style.transformOrigin = 'top';
          }
          if (elementDimensions.width > viewport.width) {
            // element wider then viewport and cannot fit on screen (align at left side of viewport)
            left = targetOffset.left * -1;
          } else if (targetOffset.left + elementDimensions.width > viewport.width) {
            // element wider then viewport but can be fit on screen (align at right side of viewport)
            left = (targetOffset.left + elementDimensions.width - viewport.width) * -1;
          } else {
            // element fits on screen (align with target)
            left = 0;
          }
          element.style.top = top + 'px';
          element.style.left = left + 'px';
        }
      }
    }, {
      key: "flipfitCollision",
      value: function flipfitCollision(element, target) {
        var _this2 = this;
        var my = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'left top';
        var at = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 'left bottom';
        var callback = arguments.length > 4 ? arguments[4] : undefined;
        if (element && target) {
          var targetOffset = target.getBoundingClientRect();
          var viewport = this.getViewport();
          var myArr = my.split(' ');
          var atArr = at.split(' ');
          var getPositionValue = function getPositionValue(arr, isOffset) {
            return isOffset ? +arr.substring(arr.search(/(\+|-)/g)) || 0 : arr.substring(0, arr.search(/(\+|-)/g)) || arr;
          };
          var position = {
            my: {
              x: getPositionValue(myArr[0]),
              y: getPositionValue(myArr[1] || myArr[0]),
              offsetX: getPositionValue(myArr[0], true),
              offsetY: getPositionValue(myArr[1] || myArr[0], true)
            },
            at: {
              x: getPositionValue(atArr[0]),
              y: getPositionValue(atArr[1] || atArr[0]),
              offsetX: getPositionValue(atArr[0], true),
              offsetY: getPositionValue(atArr[1] || atArr[0], true)
            }
          };
          var myOffset = {
            left: function left() {
              var totalOffset = position.my.offsetX + position.at.offsetX;
              return totalOffset + targetOffset.left + (position.my.x === 'left' ? 0 : -1 * (position.my.x === 'center' ? _this2.getOuterWidth(element) / 2 : _this2.getOuterWidth(element)));
            },
            top: function top() {
              var totalOffset = position.my.offsetY + position.at.offsetY;
              return totalOffset + targetOffset.top + (position.my.y === 'top' ? 0 : -1 * (position.my.y === 'center' ? _this2.getOuterHeight(element) / 2 : _this2.getOuterHeight(element)));
            }
          };
          var alignWithAt = {
            count: {
              x: 0,
              y: 0
            },
            left: function left() {
              var left = myOffset.left();
              var scrollLeft = DomHandler.getWindowScrollLeft();
              element.style.left = left + scrollLeft + 'px';
              if (this.count.x === 2) {
                element.style.left = scrollLeft + 'px';
                this.count.x = 0;
              } else if (left < 0) {
                this.count.x++;
                position.my.x = 'left';
                position.at.x = 'right';
                position.my.offsetX *= -1;
                position.at.offsetX *= -1;
                this.right();
              }
            },
            right: function right() {
              var left = myOffset.left() + DomHandler.getOuterWidth(target);
              var scrollLeft = DomHandler.getWindowScrollLeft();
              element.style.left = left + scrollLeft + 'px';
              if (this.count.x === 2) {
                element.style.left = viewport.width - DomHandler.getOuterWidth(element) + scrollLeft + 'px';
                this.count.x = 0;
              } else if (left + DomHandler.getOuterWidth(element) > viewport.width) {
                this.count.x++;
                position.my.x = 'right';
                position.at.x = 'left';
                position.my.offsetX *= -1;
                position.at.offsetX *= -1;
                this.left();
              }
            },
            top: function top() {
              var top = myOffset.top();
              var scrollTop = DomHandler.getWindowScrollTop();
              element.style.top = top + scrollTop + 'px';
              if (this.count.y === 2) {
                element.style.left = scrollTop + 'px';
                this.count.y = 0;
              } else if (top < 0) {
                this.count.y++;
                position.my.y = 'top';
                position.at.y = 'bottom';
                position.my.offsetY *= -1;
                position.at.offsetY *= -1;
                this.bottom();
              }
            },
            bottom: function bottom() {
              var top = myOffset.top() + DomHandler.getOuterHeight(target);
              var scrollTop = DomHandler.getWindowScrollTop();
              element.style.top = top + scrollTop + 'px';
              if (this.count.y === 2) {
                element.style.left = viewport.height - DomHandler.getOuterHeight(element) + scrollTop + 'px';
                this.count.y = 0;
              } else if (top + DomHandler.getOuterHeight(target) > viewport.height) {
                this.count.y++;
                position.my.y = 'bottom';
                position.at.y = 'top';
                position.my.offsetY *= -1;
                position.at.offsetY *= -1;
                this.top();
              }
            },
            center: function center(axis) {
              if (axis === 'y') {
                var top = myOffset.top() + DomHandler.getOuterHeight(target) / 2;
                element.style.top = top + DomHandler.getWindowScrollTop() + 'px';
                if (top < 0) {
                  this.bottom();
                } else if (top + DomHandler.getOuterHeight(target) > viewport.height) {
                  this.top();
                }
              } else {
                var left = myOffset.left() + DomHandler.getOuterWidth(target) / 2;
                element.style.left = left + DomHandler.getWindowScrollLeft() + 'px';
                if (left < 0) {
                  this.left();
                } else if (left + DomHandler.getOuterWidth(element) > viewport.width) {
                  this.right();
                }
              }
            }
          };
          alignWithAt[position.at.x]('x');
          alignWithAt[position.at.y]('y');
          if (this.isFunction(callback)) {
            callback(position);
          }
        }
      }
    }, {
      key: "findCollisionPosition",
      value: function findCollisionPosition(position) {
        if (position) {
          var isAxisY = position === 'top' || position === 'bottom';
          var myXPosition = position === 'left' ? 'right' : 'left';
          var myYPosition = position === 'top' ? 'bottom' : 'top';
          if (isAxisY) {
            return {
              axis: 'y',
              my: "center ".concat(myYPosition),
              at: "center ".concat(position)
            };
          }
          return {
            axis: 'x',
            my: "".concat(myXPosition, " center"),
            at: "".concat(position, " center")
          };
        }
      }
    }, {
      key: "getParents",
      value: function getParents(element) {
        var parents = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
        return element.parentNode === null ? parents : this.getParents(element.parentNode, parents.concat([element.parentNode]));
      }

      /**
       * Gets all scrollable parent elements of a given element
       * @param {HTMLElement} element - The element to find scrollable parents for
       * @returns {Array} Array of scrollable parent elements
       */
    }, {
      key: "getScrollableParents",
      value: function getScrollableParents(element) {
        var _this3 = this;
        var scrollableParents = [];
        if (element) {
          // Get all parent elements
          var parents = this.getParents(element);
          // Regex to match auto or scroll overflow values
          var overflowRegex = /(auto|scroll)/;

          /**
           * Checks if an element has overflow scroll/auto in any direction
           * @param {HTMLElement} node - Element to check
           * @returns {boolean} True if element has overflow scroll/auto
           */
          var overflowCheck = function overflowCheck(node) {
            var styleDeclaration = node ? getComputedStyle(node) : null;
            return styleDeclaration && (overflowRegex.test(styleDeclaration.getPropertyValue('overflow')) || overflowRegex.test(styleDeclaration.getPropertyValue('overflow-x')) || overflowRegex.test(styleDeclaration.getPropertyValue('overflow-y')));
          };

          /**
           * Adds a scrollable parent element to the collection
           * @param {HTMLElement} node - Element to add
           */
          var addScrollableParent = function addScrollableParent(node) {
            // For document/body/html elements, add window instead
            scrollableParents.push(node.nodeName === 'BODY' || node.nodeName === 'HTML' || _this3.isDocument(node) ? window : node);
          };

          // Iterate through all parent elements
          var _iterator = _createForOfIteratorHelper$h(parents),
            _step;
          try {
            for (_iterator.s(); !(_step = _iterator.n()).done;) {
              var _parent$dataset;
              var parent = _step.value;
              // Check for custom scroll selectors in data attribute
              var scrollSelectors = parent.nodeType === 1 && ((_parent$dataset = parent.dataset) === null || _parent$dataset === void 0 ? void 0 : _parent$dataset.scrollselectors);
              if (scrollSelectors) {
                var selectors = scrollSelectors.split(',');

                // Check each selector
                var _iterator2 = _createForOfIteratorHelper$h(selectors),
                  _step2;
                try {
                  for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
                    var selector = _step2.value;
                    var el = this.findSingle(parent, selector);
                    if (el && overflowCheck(el)) {
                      addScrollableParent(el);
                    }
                  }
                } catch (err) {
                  _iterator2.e(err);
                } finally {
                  _iterator2.f();
                }
              }

              // Check if the parent itself is scrollable
              if (parent.nodeType === 1 && overflowCheck(parent)) {
                addScrollableParent(parent);
              }
            }
          } catch (err) {
            _iterator.e(err);
          } finally {
            _iterator.f();
          }
        }
        return scrollableParents;
      }
    }, {
      key: "getHiddenElementOuterHeight",
      value: function getHiddenElementOuterHeight(element) {
        if (element) {
          element.style.visibility = 'hidden';
          element.style.display = 'block';
          var elementHeight = element.offsetHeight;
          element.style.display = 'none';
          element.style.visibility = 'visible';
          return elementHeight;
        }
        return 0;
      }
    }, {
      key: "getHiddenElementOuterWidth",
      value: function getHiddenElementOuterWidth(element) {
        if (element) {
          element.style.visibility = 'hidden';
          element.style.display = 'block';
          var elementWidth = element.offsetWidth;
          element.style.display = 'none';
          element.style.visibility = 'visible';
          return elementWidth;
        }
        return 0;
      }
    }, {
      key: "getHiddenElementDimensions",
      value: function getHiddenElementDimensions(element) {
        var dimensions = {};
        if (element) {
          element.style.visibility = 'hidden';
          element.style.display = 'block';
          dimensions.width = element.offsetWidth;
          dimensions.height = element.offsetHeight;
          element.style.display = 'none';
          element.style.visibility = 'visible';
        }
        return dimensions;
      }
    }, {
      key: "fadeIn",
      value: function fadeIn(element, duration) {
        if (element) {
          element.style.opacity = 0;
          var last = +new Date();
          var opacity = 0;
          var _tick = function tick() {
            opacity = +element.style.opacity + (new Date().getTime() - last) / duration;
            element.style.opacity = opacity;
            last = +new Date();
            if (+opacity < 1) {
              window.requestAnimationFrame && requestAnimationFrame(_tick) || setTimeout(_tick, 16);
            }
          };
          _tick();
        }
      }
    }, {
      key: "fadeOut",
      value: function fadeOut(element, duration) {
        if (element) {
          var opacity = 1;
          var interval = 50;
          var gap = interval / duration;
          var fading = setInterval(function () {
            opacity = opacity - gap;
            if (opacity <= 0) {
              opacity = 0;
              clearInterval(fading);
            }
            element.style.opacity = opacity;
          }, interval);
        }
      }
    }, {
      key: "getUserAgent",
      value: function getUserAgent() {
        return navigator.userAgent;
      }
    }, {
      key: "isIOS",
      value: function isIOS() {
        return /iPad|iPhone|iPod/.test(navigator.userAgent) && !window.MSStream;
      }
    }, {
      key: "isAndroid",
      value: function isAndroid() {
        return /(android)/i.test(navigator.userAgent);
      }
    }, {
      key: "isChrome",
      value: function isChrome() {
        return /(chrome)/i.test(navigator.userAgent);
      }
    }, {
      key: "isClient",
      value: function isClient() {
        return !!(typeof window !== 'undefined' && window.document && window.document.createElement);
      }
    }, {
      key: "isTouchDevice",
      value: function isTouchDevice() {
        return 'ontouchstart' in window || navigator.maxTouchPoints > 0 || navigator.msMaxTouchPoints > 0;
      }
    }, {
      key: "isFunction",
      value: function isFunction(obj) {
        return !!(obj && obj.constructor && obj.call && obj.apply);
      }
    }, {
      key: "appendChild",
      value: function appendChild(element, target) {
        if (this.isElement(target)) {
          target.appendChild(element);
        } else if (target.el && target.el.nativeElement) {
          target.el.nativeElement.appendChild(element);
        } else {
          throw new Error('Cannot append ' + target + ' to ' + element);
        }
      }
    }, {
      key: "removeChild",
      value: function removeChild(element, target) {
        if (this.isElement(target)) {
          target.removeChild(element);
        } else if (target.el && target.el.nativeElement) {
          target.el.nativeElement.removeChild(element);
        } else {
          throw new Error('Cannot remove ' + element + ' from ' + target);
        }
      }
    }, {
      key: "isElement",
      value: function isElement(obj) {
        return (typeof HTMLElement === "undefined" ? "undefined" : _typeof(HTMLElement)) === 'object' ? obj instanceof HTMLElement : obj && _typeof(obj) === 'object' && obj !== null && obj.nodeType === 1 && typeof obj.nodeName === 'string';
      }
    }, {
      key: "isDocument",
      value: function isDocument(obj) {
        return (typeof Document === "undefined" ? "undefined" : _typeof(Document)) === 'object' ? obj instanceof Document : obj && _typeof(obj) === 'object' && obj !== null && obj.nodeType === 9;
      }
    }, {
      key: "scrollInView",
      value: function scrollInView(container, item) {
        var borderTopValue = getComputedStyle(container).getPropertyValue('border-top-width');
        var borderTop = borderTopValue ? parseFloat(borderTopValue) : 0;
        var paddingTopValue = getComputedStyle(container).getPropertyValue('padding-top');
        var paddingTop = paddingTopValue ? parseFloat(paddingTopValue) : 0;
        var containerRect = container.getBoundingClientRect();
        var itemRect = item.getBoundingClientRect();
        var offset = itemRect.top + document.body.scrollTop - (containerRect.top + document.body.scrollTop) - borderTop - paddingTop;
        var scroll = container.scrollTop;
        var elementHeight = container.clientHeight;
        var itemHeight = this.getOuterHeight(item);
        if (offset < 0) {
          container.scrollTop = scroll + offset;
        } else if (offset + itemHeight > elementHeight) {
          container.scrollTop = scroll + offset - elementHeight + itemHeight;
        }
      }
    }, {
      key: "clearSelection",
      value: function clearSelection() {
        if (window.getSelection) {
          if (window.getSelection().empty) {
            window.getSelection().empty();
          } else if (window.getSelection().removeAllRanges && window.getSelection().rangeCount > 0 && window.getSelection().getRangeAt(0).getClientRects().length > 0) {
            window.getSelection().removeAllRanges();
          }
        } else if (document.selection && document.selection.empty) {
          try {
            document.selection.empty();
          } catch (error) {
            //ignore IE bug
          }
        }
      }
    }, {
      key: "calculateScrollbarWidth",
      value: function calculateScrollbarWidth(el) {
        if (el) {
          var style = getComputedStyle(el);
          return el.offsetWidth - el.clientWidth - parseFloat(style.borderLeftWidth) - parseFloat(style.borderRightWidth);
        }
        if (this.calculatedScrollbarWidth != null) {
          return this.calculatedScrollbarWidth;
        }
        var scrollDiv = document.createElement('div');
        scrollDiv.className = 'p-scrollbar-measure';
        document.body.appendChild(scrollDiv);
        var scrollbarWidth = scrollDiv.offsetWidth - scrollDiv.clientWidth;
        document.body.removeChild(scrollDiv);
        this.calculatedScrollbarWidth = scrollbarWidth;
        return scrollbarWidth;
      }
    }, {
      key: "calculateBodyScrollbarWidth",
      value: function calculateBodyScrollbarWidth() {
        return window.innerWidth - document.documentElement.offsetWidth;
      }
    }, {
      key: "getBrowser",
      value: function getBrowser() {
        if (!this.browser) {
          var matched = this.resolveUserAgent();
          this.browser = {};
          if (matched.browser) {
            this.browser[matched.browser] = true;
            this.browser.version = matched.version;
          }
          if (this.browser.chrome) {
            this.browser.webkit = true;
          } else if (this.browser.webkit) {
            this.browser.safari = true;
          }
        }
        return this.browser;
      }
    }, {
      key: "resolveUserAgent",
      value: function resolveUserAgent() {
        var ua = navigator.userAgent.toLowerCase();
        var match = /(chrome)[ ]([\w.]+)/.exec(ua) || /(webkit)[ ]([\w.]+)/.exec(ua) || /(opera)(?:.*version|)[ ]([\w.]+)/.exec(ua) || /(msie) ([\w.]+)/.exec(ua) || ua.indexOf('compatible') < 0 && /(mozilla)(?:.*? rv:([\w.]+)|)/.exec(ua) || [];
        return {
          browser: match[1] || '',
          version: match[2] || '0'
        };
      }
    }, {
      key: "blockBodyScroll",
      value: function blockBodyScroll() {
        var className = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'p-overflow-hidden';
        /* PR Ref: https://github.com/primefaces/primereact/pull/4976
         * @todo This method is called several times after this PR. Refactors will be made to prevent this in future releases.
         */
        var hasScrollbarWidth = !!document.body.style.getPropertyValue('--scrollbar-width');
        !hasScrollbarWidth && document.body.style.setProperty('--scrollbar-width', this.calculateBodyScrollbarWidth() + 'px');
        this.addClass(document.body, className);
      }
    }, {
      key: "unblockBodyScroll",
      value: function unblockBodyScroll() {
        var className = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'p-overflow-hidden';
        document.body.style.removeProperty('--scrollbar-width');
        this.removeClass(document.body, className);
      }
    }, {
      key: "isVisible",
      value: function isVisible(element) {
        // https://stackoverflow.com/a/59096915/502366 (in future use IntersectionObserver)
        return element && (element.clientHeight !== 0 || element.getClientRects().length !== 0 || getComputedStyle(element).display !== 'none');
      }
    }, {
      key: "isExist",
      value: function isExist(element) {
        return !!(element !== null && typeof element !== 'undefined' && element.nodeName && element.parentNode);
      }
    }, {
      key: "getFocusableElements",
      value: function getFocusableElements(element) {
        var selector = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
        var focusableElements = DomHandler.find(element, "button:not([tabindex = \"-1\"]):not([disabled]):not([style*=\"display:none\"]):not([hidden])".concat(selector, ",\n                [href][clientHeight][clientWidth]:not([tabindex = \"-1\"]):not([disabled]):not([style*=\"display:none\"]):not([hidden])").concat(selector, ",\n                input:not([tabindex = \"-1\"]):not([disabled]):not([style*=\"display:none\"]):not([hidden])").concat(selector, ",\n                select:not([tabindex = \"-1\"]):not([disabled]):not([style*=\"display:none\"]):not([hidden])").concat(selector, ",\n                textarea:not([tabindex = \"-1\"]):not([disabled]):not([style*=\"display:none\"]):not([hidden])").concat(selector, ",\n                [tabIndex]:not([tabIndex = \"-1\"]):not([disabled]):not([style*=\"display:none\"]):not([hidden])").concat(selector, ",\n                [contenteditable]:not([tabIndex = \"-1\"]):not([disabled]):not([style*=\"display:none\"]):not([hidden])").concat(selector));
        var visibleFocusableElements = [];
        var _iterator3 = _createForOfIteratorHelper$h(focusableElements),
          _step3;
        try {
          for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
            var focusableElement = _step3.value;
            if (getComputedStyle(focusableElement).display !== 'none' && getComputedStyle(focusableElement).visibility !== 'hidden') {
              visibleFocusableElements.push(focusableElement);
            }
          }
        } catch (err) {
          _iterator3.e(err);
        } finally {
          _iterator3.f();
        }
        return visibleFocusableElements;
      }
    }, {
      key: "getFirstFocusableElement",
      value: function getFirstFocusableElement(element, selector) {
        var focusableElements = DomHandler.getFocusableElements(element, selector);
        return focusableElements.length > 0 ? focusableElements[0] : null;
      }
    }, {
      key: "getLastFocusableElement",
      value: function getLastFocusableElement(element, selector) {
        var focusableElements = DomHandler.getFocusableElements(element, selector);
        return focusableElements.length > 0 ? focusableElements[focusableElements.length - 1] : null;
      }

      /**
       * Focus an input element if it does not already have focus.
       *
       * @param {HTMLElement} el a HTML element
       * @param {boolean} scrollTo flag to control whether to scroll to the element, false by default
       */
    }, {
      key: "focus",
      value: function focus(el, scrollTo) {
        var preventScroll = scrollTo === undefined ? true : !scrollTo;
        el && document.activeElement !== el && el.focus({
          preventScroll: preventScroll
        });
      }

      /**
       * Focus the first focusable element if it does not already have focus.
       *
       * @param {HTMLElement} el a HTML element
       * @param {boolean} scrollTo flag to control whether to scroll to the element, false by default
       * @return {HTMLElement | undefined} the first focusable HTML element found
       */
    }, {
      key: "focusFirstElement",
      value: function focusFirstElement(el, scrollTo) {
        if (!el) {
          return;
        }
        var firstFocusableElement = DomHandler.getFirstFocusableElement(el);
        firstFocusableElement && DomHandler.focus(firstFocusableElement, scrollTo);
        return firstFocusableElement;
      }
    }, {
      key: "getCursorOffset",
      value: function getCursorOffset(el, prevText, nextText, currentText) {
        if (el) {
          var style = getComputedStyle(el);
          var ghostDiv = document.createElement('div');
          ghostDiv.style.position = 'absolute';
          ghostDiv.style.top = '0px';
          ghostDiv.style.left = '0px';
          ghostDiv.style.visibility = 'hidden';
          ghostDiv.style.pointerEvents = 'none';
          ghostDiv.style.overflow = style.overflow;
          ghostDiv.style.width = style.width;
          ghostDiv.style.height = style.height;
          ghostDiv.style.padding = style.padding;
          ghostDiv.style.border = style.border;
          ghostDiv.style.overflowWrap = style.overflowWrap;
          ghostDiv.style.whiteSpace = style.whiteSpace;
          ghostDiv.style.lineHeight = style.lineHeight;
          ghostDiv.innerHTML = prevText.replace(/\r\n|\r|\n/g, '<br />');
          var ghostSpan = document.createElement('span');
          ghostSpan.textContent = currentText;
          ghostDiv.appendChild(ghostSpan);
          var text = document.createTextNode(nextText);
          ghostDiv.appendChild(text);
          document.body.appendChild(ghostDiv);
          var offsetLeft = ghostSpan.offsetLeft,
            offsetTop = ghostSpan.offsetTop,
            clientHeight = ghostSpan.clientHeight;
          document.body.removeChild(ghostDiv);
          return {
            left: Math.abs(offsetLeft - el.scrollLeft),
            top: Math.abs(offsetTop - el.scrollTop) + clientHeight
          };
        }
        return {
          top: 'auto',
          left: 'auto'
        };
      }
    }, {
      key: "invokeElementMethod",
      value: function invokeElementMethod(element, methodName, args) {
        element[methodName].apply(element, args);
      }
    }, {
      key: "isClickable",
      value: function isClickable(element) {
        var targetNode = element.nodeName;
        var parentNode = element.parentElement && element.parentElement.nodeName;
        return targetNode === 'INPUT' || targetNode === 'TEXTAREA' || targetNode === 'BUTTON' || targetNode === 'A' || parentNode === 'INPUT' || parentNode === 'TEXTAREA' || parentNode === 'BUTTON' || parentNode === 'A' || this.hasClass(element, 'p-button') || this.hasClass(element.parentElement, 'p-button') || this.hasClass(element.parentElement, 'p-checkbox') || this.hasClass(element.parentElement, 'p-radiobutton');
      }
    }, {
      key: "applyStyle",
      value: function applyStyle(element, style) {
        if (typeof style === 'string') {
          element.style.cssText = style;
        } else {
          for (var prop in style) {
            element.style[prop] = style[prop];
          }
        }
      }
    }, {
      key: "exportCSV",
      value: function exportCSV(csv, filename) {
        var blob = new Blob([csv], {
          type: 'application/csv;charset=utf-8;'
        });
        if (window.navigator.msSaveOrOpenBlob) {
          navigator.msSaveOrOpenBlob(blob, filename + '.csv');
        } else {
          var isDownloaded = DomHandler.saveAs({
            name: filename + '.csv',
            src: URL.createObjectURL(blob)
          });
          if (!isDownloaded) {
            csv = 'data:text/csv;charset=utf-8,' + csv;
            window.open(encodeURI(csv));
          }
        }
      }
    }, {
      key: "saveAs",
      value: function saveAs(file) {
        if (file) {
          var link = document.createElement('a');
          if (link.download !== undefined) {
            var name = file.name,
              src = file.src;
            link.setAttribute('href', src);
            link.setAttribute('download', name);
            link.style.display = 'none';
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
            return true;
          }
        }
        return false;
      }
    }, {
      key: "createInlineStyle",
      value: function createInlineStyle(nonce, styleContainer) {
        var styleElement = document.createElement('style');
        DomHandler.addNonce(styleElement, nonce);
        if (!styleContainer) {
          styleContainer = document.head;
        }
        styleContainer.appendChild(styleElement);
        return styleElement;
      }
    }, {
      key: "removeInlineStyle",
      value: function removeInlineStyle(styleElement) {
        if (this.isExist(styleElement)) {
          try {
            styleElement.parentNode.removeChild(styleElement);
          } catch (error) {
            // style element may have already been removed in a fast refresh
          }
          styleElement = null;
        }
        return styleElement;
      }
    }, {
      key: "addNonce",
      value: function addNonce(styleElement, nonce) {
        try {
          if (!nonce) {
            nonce = process.env.REACT_APP_CSS_NONCE;
          }
        } catch (error) {
          // NOOP
        }
        nonce && styleElement.setAttribute('nonce', nonce);
      }
    }, {
      key: "getTargetElement",
      value: function getTargetElement(target) {
        if (!target) {
          return null;
        }
        if (target === 'document') {
          return document;
        } else if (target === 'window') {
          return window;
        } else if (_typeof(target) === 'object' && target.hasOwnProperty('current')) {
          return this.isExist(target.current) ? target.current : null;
        }
        var isFunction = function isFunction(obj) {
          return !!(obj && obj.constructor && obj.call && obj.apply);
        };
        var element = isFunction(target) ? target() : target;
        return this.isDocument(element) || this.isExist(element) ? element : null;
      }

      /**
       * Get the attribute names for an element and sorts them alpha for comparison
       */
    }, {
      key: "getAttributeNames",
      value: function getAttributeNames(node) {
        var index;
        var rv;
        var attrs;
        rv = [];
        attrs = node.attributes;
        for (index = 0; index < attrs.length; ++index) {
          rv.push(attrs[index].nodeName);
        }
        rv.sort();
        return rv;
      }

      /**
       * Compare two elements for equality.  Even will compare if the style element
       * is out of order for example:
       *
       * elem1 = style="color: red; font-size: 28px"
       * elem2 = style="font-size: 28px; color: red"
       */
    }, {
      key: "isEqualElement",
      value: function isEqualElement(elm1, elm2) {
        var attrs1;
        var attrs2;
        var name;
        var node1;
        var node2;

        // Compare attributes without order sensitivity
        attrs1 = DomHandler.getAttributeNames(elm1);
        attrs2 = DomHandler.getAttributeNames(elm2);
        if (attrs1.join(',') !== attrs2.join(',')) {
          // console.log("Found nodes with different sets of attributes; not equiv");
          return false;
        }

        // ...and values
        // unless you want to compare DOM0 event handlers
        // (onclick="...")
        for (var index = 0; index < attrs1.length; ++index) {
          name = attrs1[index];
          if (name === 'style') {
            var astyle = elm1.style;
            var bstyle = elm2.style;
            var rexDigitsOnly = /^\d+$/;
            for (var _i3 = 0, _Object$keys = Object.keys(astyle); _i3 < _Object$keys.length; _i3++) {
              var key = _Object$keys[_i3];
              if (!rexDigitsOnly.test(key) && astyle[key] !== bstyle[key]) {
                // Not equivalent, stop
                //console.log("Found nodes with mis-matched values for attribute '" + name + "'; not equiv");
                return false;
              }
            }
          } else if (elm1.getAttribute(name) !== elm2.getAttribute(name)) {
            // console.log("Found nodes with mis-matched values for attribute '" + name + "'; not equiv");
            return false;
          }
        }

        // Walk the children
        for (node1 = elm1.firstChild, node2 = elm2.firstChild; node1 && node2; node1 = node1.nextSibling, node2 = node2.nextSibling) {
          if (node1.nodeType !== node2.nodeType) {
            // display("Found nodes of different types; not equiv");
            return false;
          }
          if (node1.nodeType === 1) {
            // Element
            if (!DomHandler.isEqualElement(node1, node2)) {
              return false;
            }
          } else if (node1.nodeValue !== node2.nodeValue) {
            // console.log("Found nodes with mis-matched nodeValues; not equiv");
            return false;
          }
        }
        if (node1 || node2) {
          // One of the elements had more nodes than the other
          // console.log("Found more children of one element than the other; not equivalent");
          return false;
        }

        // Seem the same
        return true;
      }
    }, {
      key: "hasCSSAnimation",
      value: function hasCSSAnimation(element) {
        if (element) {
          var style = getComputedStyle(element);
          var animationDuration = parseFloat(style.getPropertyValue('animation-duration') || '0');
          return animationDuration > 0;
        }
        return false;
      }
    }, {
      key: "hasCSSTransition",
      value: function hasCSSTransition(element) {
        if (element) {
          var style = getComputedStyle(element);
          var transitionDuration = parseFloat(style.getPropertyValue('transition-duration') || '0');
          return transitionDuration > 0;
        }
        return false;
      }
    }]);
  }();
  /**
   * All data- properties like data-test-id
   */
  _defineProperty(DomHandler, "DATA_PROPS", ['data-']);
  /**
   * All ARIA properties like aria-label and focus-target for https://www.npmjs.com/package/@q42/floating-focus-a11y
   */
  _defineProperty(DomHandler, "ARIA_PROPS", ['aria', 'focus-target']);

  function EventBus() {
    var allHandlers = new Map();
    return {
      on: function on(type, handler) {
        var handlers = allHandlers.get(type);
        if (!handlers) {
          handlers = [handler];
        } else {
          handlers.push(handler);
        }
        allHandlers.set(type, handlers);
      },
      off: function off(type, handler) {
        var handlers = allHandlers.get(type);
        handlers && handlers.splice(handlers.indexOf(handler) >>> 0, 1);
      },
      emit: function emit(type, evt) {
        var handlers = allHandlers.get(type);
        handlers && handlers.slice().forEach(function (handler) {
          return handler(evt);
        });
      }
    };
  }

  function _createForOfIteratorHelper$g(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray$g(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t["return"] || t["return"](); } finally { if (u) throw o; } } }; }
  function _unsupportedIterableToArray$g(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray$g(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray$g(r, a) : void 0; } }
  function _arrayLikeToArray$g(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
  var ObjectUtils = /*#__PURE__*/function () {
    function ObjectUtils() {
      _classCallCheck(this, ObjectUtils);
    }
    return _createClass(ObjectUtils, null, [{
      key: "equals",
      value: function equals(obj1, obj2, field) {
        if (field && obj1 && _typeof(obj1) === 'object' && obj2 && _typeof(obj2) === 'object') {
          return this.deepEquals(this.resolveFieldData(obj1, field), this.resolveFieldData(obj2, field));
        }
        return this.deepEquals(obj1, obj2);
      }

      /**
       * Compares two JSON objects for deep equality recursively comparing both objects.
       * @param {*} a the first JSON object
       * @param {*} b the second JSON object
       * @returns true if equals, false it not
       */
    }, {
      key: "deepEquals",
      value: function deepEquals(a, b) {
        if (a === b) {
          return true;
        }
        if (a && b && _typeof(a) === 'object' && _typeof(b) === 'object') {
          var arrA = Array.isArray(a);
          var arrB = Array.isArray(b);
          var i;
          var length;
          var key;
          if (arrA && arrB) {
            length = a.length;
            if (length !== b.length) {
              return false;
            }
            for (i = length; i-- !== 0;) {
              if (!this.deepEquals(a[i], b[i])) {
                return false;
              }
            }
            return true;
          }
          if (arrA !== arrB) {
            return false;
          }
          var dateA = a instanceof Date;
          var dateB = b instanceof Date;
          if (dateA !== dateB) {
            return false;
          }
          if (dateA && dateB) {
            return a.getTime() === b.getTime();
          }
          var regexpA = a instanceof RegExp;
          var regexpB = b instanceof RegExp;
          if (regexpA !== regexpB) {
            return false;
          }
          if (regexpA && regexpB) {
            return a.toString() === b.toString();
          }
          var keys = Object.keys(a);
          length = keys.length;
          if (length !== Object.keys(b).length) {
            return false;
          }
          for (i = length; i-- !== 0;) {
            if (!Object.prototype.hasOwnProperty.call(b, keys[i])) {
              return false;
            }
          }
          for (i = length; i-- !== 0;) {
            key = keys[i];
            if (!this.deepEquals(a[key], b[key])) {
              return false;
            }
          }
          return true;
        }

        /*eslint no-self-compare: "off"*/
        return a !== a && b !== b;
      }
    }, {
      key: "resolveFieldData",
      value: function resolveFieldData(data, field) {
        if (!data || !field) {
          // short circuit if there is nothing to resolve
          return null;
        }
        try {
          var value = data[field];
          if (this.isNotEmpty(value)) {
            return value;
          }
        } catch (_unused) {
          // Performance optimization: https://github.com/primefaces/primereact/issues/4797
          // do nothing and continue to other methods to resolve field data
        }
        if (Object.keys(data).length) {
          if (this.isFunction(field)) {
            return field(data);
          } else if (this.isNotEmpty(data[field])) {
            return data[field];
          } else if (field.indexOf('.') === -1) {
            return data[field];
          }
          var fields = field.split('.');
          var _value = data;
          for (var i = 0, len = fields.length; i < len; ++i) {
            if (_value == null) {
              return null;
            }
            _value = _value[fields[i]];
          }
          return _value;
        }
        return null;
      }
    }, {
      key: "findDiffKeys",
      value: function findDiffKeys(obj1, obj2) {
        if (!obj1 || !obj2) {
          return {};
        }
        return Object.keys(obj1).filter(function (key) {
          return !obj2.hasOwnProperty(key);
        }).reduce(function (result, current) {
          result[current] = obj1[current];
          return result;
        }, {});
      }

      /**
       * Removes keys from a JSON object that start with a string such as "data" to get all "data-id" type properties.
       *
       * @param {any} obj the JSON object to reduce
       * @param {string[]} startsWiths the string(s) to check if the property starts with this key
       * @returns the JSON object containing only the key/values that match the startsWith string
       */
    }, {
      key: "reduceKeys",
      value: function reduceKeys(obj, startsWiths) {
        var result = {};
        if (!obj || !startsWiths || startsWiths.length === 0) {
          return result;
        }
        Object.keys(obj).filter(function (key) {
          return startsWiths.some(function (value) {
            return key.startsWith(value);
          });
        }).forEach(function (key) {
          result[key] = obj[key];
          delete obj[key];
        });
        return result;
      }
    }, {
      key: "reorderArray",
      value: function reorderArray(value, from, to) {
        if (value && from !== to) {
          if (to >= value.length) {
            to = to % value.length;
            from = from % value.length;
          }
          value.splice(to, 0, value.splice(from, 1)[0]);
        }
      }
    }, {
      key: "findIndexInList",
      value: function findIndexInList(value, list, dataKey) {
        var _this = this;
        if (list) {
          return dataKey ? list.findIndex(function (item) {
            return _this.equals(item, value, dataKey);
          }) : list.findIndex(function (item) {
            return item === value;
          });
        }
        return -1;
      }
    }, {
      key: "getJSXElement",
      value: function getJSXElement(obj) {
        for (var _len = arguments.length, params = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
          params[_key - 1] = arguments[_key];
        }
        return this.isFunction(obj) ? obj.apply(void 0, params) : obj;
      }
    }, {
      key: "getItemValue",
      value: function getItemValue(obj) {
        for (var _len2 = arguments.length, params = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
          params[_key2 - 1] = arguments[_key2];
        }
        return this.isFunction(obj) ? obj.apply(void 0, params) : obj;
      }
    }, {
      key: "getProp",
      value: function getProp(props) {
        var prop = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
        var defaultProps = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
        var value = props ? props[prop] : undefined;
        return value === undefined ? defaultProps[prop] : value;
      }
    }, {
      key: "getPropCaseInsensitive",
      value: function getPropCaseInsensitive(props, prop) {
        var defaultProps = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
        var fkey = this.toFlatCase(prop);
        for (var key in props) {
          if (props.hasOwnProperty(key) && this.toFlatCase(key) === fkey) {
            return props[key];
          }
        }
        for (var _key3 in defaultProps) {
          if (defaultProps.hasOwnProperty(_key3) && this.toFlatCase(_key3) === fkey) {
            return defaultProps[_key3];
          }
        }
        return undefined; // Property not found
      }
    }, {
      key: "getMergedProps",
      value: function getMergedProps(props, defaultProps) {
        return Object.assign({}, defaultProps, props);
      }
    }, {
      key: "getDiffProps",
      value: function getDiffProps(props, defaultProps) {
        return this.findDiffKeys(props, defaultProps);
      }

      /**
       * Gets the value of a property which can be a function or a direct value.
       * If the property is a function, it will be invoked with the provided parameters.
       * @param {*} obj - The object to get the value from
       * @param {...*} params - Parameters to pass to the function if obj is a function
       * @returns {*} The resolved value
       */
    }, {
      key: "getPropValue",
      value: function getPropValue(obj) {
        // If obj is not a function, return it directly
        if (!this.isFunction(obj)) {
          return obj;
        }

        // Handle function invocation
        for (var _len3 = arguments.length, params = new Array(_len3 > 1 ? _len3 - 1 : 0), _key4 = 1; _key4 < _len3; _key4++) {
          params[_key4 - 1] = arguments[_key4];
        }
        if (params.length === 1) {
          // For single parameter case, unwrap array if needed to avoid extra nesting
          var param = params[0];
          return obj(Array.isArray(param) ? param[0] : param);
        }

        // Pass all parameters to function
        return obj.apply(void 0, params);
      }
    }, {
      key: "getComponentProp",
      value: function getComponentProp(component) {
        var prop = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
        var defaultProps = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
        return this.isNotEmpty(component) ? this.getProp(component.props, prop, defaultProps) : undefined;
      }
    }, {
      key: "getComponentProps",
      value: function getComponentProps(component, defaultProps) {
        return this.isNotEmpty(component) ? this.getMergedProps(component.props, defaultProps) : undefined;
      }
    }, {
      key: "getComponentDiffProps",
      value: function getComponentDiffProps(component, defaultProps) {
        return this.isNotEmpty(component) ? this.getDiffProps(component.props, defaultProps) : undefined;
      }
    }, {
      key: "isValidChild",
      value: function isValidChild(child, type, validTypes) {
        /* eslint-disable */
        if (child) {
          var _child$type;
          var childType = this.getComponentProp(child, '__TYPE') || (child.type ? child.type.displayName : undefined);

          // for App Router in Next.js ^14,
          if (!childType && child !== null && child !== void 0 && (_child$type = child.type) !== null && _child$type !== void 0 && (_child$type = _child$type._payload) !== null && _child$type !== void 0 && _child$type.value) {
            childType = child.type._payload.value.find(function (v) {
              return v === type;
            });
          }
          var isValid = childType === type;
          try {
            var messageTypes; if ("production" !== 'production' && !isValid) ;
          } catch (error) {
            // NOOP
          }
          return isValid;
        }
        return false;
        /* eslint-enable */
      }
    }, {
      key: "getRefElement",
      value: function getRefElement(ref) {
        if (ref) {
          return _typeof(ref) === 'object' && ref.hasOwnProperty('current') ? ref.current : ref;
        }
        return null;
      }
    }, {
      key: "combinedRefs",
      value: function combinedRefs(innerRef, forwardRef) {
        if (innerRef && forwardRef) {
          if (typeof forwardRef === 'function') {
            forwardRef(innerRef.current);
          } else {
            forwardRef.current = innerRef.current;
          }
        }
      }
    }, {
      key: "removeAccents",
      value: function removeAccents(str) {
        if (str && str.search(/[\xC0-\xFF]/g) > -1) {
          str = str.replace(/[\xC0-\xC5]/g, 'A').replace(/[\xC6]/g, 'AE').replace(/[\xC7]/g, 'C').replace(/[\xC8-\xCB]/g, 'E').replace(/[\xCC-\xCF]/g, 'I').replace(/[\xD0]/g, 'D').replace(/[\xD1]/g, 'N').replace(/[\xD2-\xD6\xD8]/g, 'O').replace(/[\xD9-\xDC]/g, 'U').replace(/[\xDD]/g, 'Y').replace(/[\xDE]/g, 'P').replace(/[\xE0-\xE5]/g, 'a').replace(/[\xE6]/g, 'ae').replace(/[\xE7]/g, 'c').replace(/[\xE8-\xEB]/g, 'e').replace(/[\xEC-\xEF]/g, 'i').replace(/[\xF1]/g, 'n').replace(/[\xF2-\xF6\xF8]/g, 'o').replace(/[\xF9-\xFC]/g, 'u').replace(/[\xFE]/g, 'p').replace(/[\xFD\xFF]/g, 'y');
        }
        return str;
      }
    }, {
      key: "toFlatCase",
      value: function toFlatCase(str) {
        // convert snake, kebab, camel and pascal cases to flat case
        return this.isNotEmpty(str) && this.isString(str) ? str.replace(/(-|_)/g, '').toLowerCase() : str;
      }
    }, {
      key: "toCapitalCase",
      value: function toCapitalCase(str) {
        return this.isNotEmpty(str) && this.isString(str) ? str[0].toUpperCase() + str.slice(1) : str;
      }
    }, {
      key: "trim",
      value: function trim(value) {
        // trim only if the value is actually a string
        return this.isNotEmpty(value) && this.isString(value) ? value.trim() : value;
      }
    }, {
      key: "isEmpty",
      value: function isEmpty(value) {
        return value === null || value === undefined || value === '' || Array.isArray(value) && value.length === 0 || !(value instanceof Date) && _typeof(value) === 'object' && Object.keys(value).length === 0;
      }
    }, {
      key: "isNotEmpty",
      value: function isNotEmpty(value) {
        return !this.isEmpty(value);
      }
    }, {
      key: "isFunction",
      value: function isFunction(value) {
        return !!(value && value.constructor && value.call && value.apply);
      }
    }, {
      key: "isObject",
      value: function isObject(value) {
        return value !== null && value instanceof Object && value.constructor === Object;
      }
    }, {
      key: "isDate",
      value: function isDate(value) {
        return value !== null && value instanceof Date && value.constructor === Date;
      }
    }, {
      key: "isArray",
      value: function isArray(value) {
        return value !== null && Array.isArray(value);
      }
    }, {
      key: "isString",
      value: function isString(value) {
        return value !== null && typeof value === 'string';
      }
    }, {
      key: "isPrintableCharacter",
      value: function isPrintableCharacter() {
        var _char = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
        return this.isNotEmpty(_char) && _char.length === 1 && _char.match(/\S| /);
      }
    }, {
      key: "isLetter",
      value: function isLetter(_char2) {
        return /^[a-zA-Z\u00C0-\u017F]$/.test(_char2);
      }
    }, {
      key: "isScalar",
      value: function isScalar(value) {
        return value != null && (typeof value === 'string' || typeof value === 'number' || typeof value === 'bigint' || typeof value === 'boolean');
      }

      /**
       * Firefox-v103 does not currently support the "findLast" method. It is stated that this method will be supported with Firefox-v104.
       * https://caniuse.com/mdn-javascript_builtins_array_findlast
       */
    }, {
      key: "findLast",
      value: function findLast(arr, callback) {
        var item;
        if (this.isNotEmpty(arr)) {
          try {
            item = arr.findLast(callback);
          } catch (_unused2) {
            item = _toConsumableArray(arr).reverse().find(callback);
          }
        }
        return item;
      }

      /**
       * Firefox-v103 does not currently support the "findLastIndex" method. It is stated that this method will be supported with Firefox-v104.
       * https://caniuse.com/mdn-javascript_builtins_array_findlastindex
       */
    }, {
      key: "findLastIndex",
      value: function findLastIndex(arr, callback) {
        var index = -1;
        if (this.isNotEmpty(arr)) {
          try {
            index = arr.findLastIndex(callback);
          } catch (_unused3) {
            index = arr.lastIndexOf(_toConsumableArray(arr).reverse().find(callback));
          }
        }
        return index;
      }
    }, {
      key: "sort",
      value: function sort(value1, value2) {
        var order = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 1;
        var comparator = arguments.length > 3 ? arguments[3] : undefined;
        var nullSortOrder = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 1;
        var result = this.compare(value1, value2, comparator, order);
        var finalSortOrder = order;

        // nullSortOrder == 1 means Excel like sort nulls at bottom
        if (this.isEmpty(value1) || this.isEmpty(value2)) {
          finalSortOrder = nullSortOrder === 1 ? order : nullSortOrder;
        }
        return finalSortOrder * result;
      }
    }, {
      key: "compare",
      value: function compare(value1, value2, comparator) {
        var order = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 1;
        var result = -1;
        var emptyValue1 = this.isEmpty(value1);
        var emptyValue2 = this.isEmpty(value2);
        if (emptyValue1 && emptyValue2) {
          result = 0;
        } else if (emptyValue1) {
          result = order;
        } else if (emptyValue2) {
          result = -order;
        } else if (typeof value1 === 'string' && typeof value2 === 'string') {
          result = comparator(value1, value2);
        } else {
          result = value1 < value2 ? -1 : value1 > value2 ? 1 : 0;
        }
        return result;
      }
    }, {
      key: "localeComparator",
      value: function localeComparator(locale) {
        //performance gain using Int.Collator. It is not recommended to use localeCompare against large arrays.
        return new Intl.Collator(locale, {
          numeric: true
        }).compare;
      }
    }, {
      key: "findChildrenByKey",
      value: function findChildrenByKey(data, key) {
        var _iterator = _createForOfIteratorHelper$g(data),
          _step;
        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var item = _step.value;
            if (item.key === key) {
              return item.children || [];
            } else if (item.children) {
              var result = this.findChildrenByKey(item.children, key);
              if (result.length > 0) {
                return result;
              }
            }
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }
        return [];
      }

      /**
       * This function takes mutates and object with a new value given
       * a specific field. This will handle deeply nested fields that
       * need to be modified or created.
       *
       * e.g:
       * data = {
       *  nested: {
       *      foo: "bar"
       *  }
       * }
       *
       * field = "nested.foo"
       * value = "baz"
       *
       * The function will mutate data to be
       * e.g:
       * data = {
       *  nested: {
       *      foo: "baz"
       *  }
       * }
       *
       * @param {object} data the object to be modified
       * @param {string} field the field in the object to replace
       * @param {any} value the value to have replaced in the field
       */
    }, {
      key: "mutateFieldData",
      value: function mutateFieldData(data, field, value) {
        if (_typeof(data) !== 'object' || typeof field !== 'string') {
          // short circuit if there is nothing to resolve
          return;
        }
        var fields = field.split('.');
        var obj = data;
        for (var i = 0, len = fields.length; i < len; ++i) {
          // Check if we are on the last field
          if (i + 1 - len === 0) {
            obj[fields[i]] = value;
            break;
          }
          if (!obj[fields[i]]) {
            obj[fields[i]] = {};
          }
          obj = obj[fields[i]];
        }
      }

      /**
       * This helper function takes an object and a dot-separated key path. It traverses the object based on the path,
       * returning the value at the specified depth. If any part of the path is missing or undefined, it returns undefined.
       *
       * Example:
       * const obj = { name: 'Alice', address: { city: 'Wonderland', zip: 12345 } };
       * const path = 'address.city';
       * const result = ObjectUtils.getNestedValue(obj, path);
       * console.log(result); // Output: "Wonderland"
       *
       * @param {object} obj - The object to traverse.
       * @param {string} path - The dot-separated key path.
       * @returns {*} The value at the specified depth, or undefined if any part of the path is missing or undefined.
       */
    }, {
      key: "getNestedValue",
      value: function getNestedValue(obj, path) {
        return path.split('.').reduce(function (acc, part) {
          return acc && acc[part] !== undefined ? acc[part] : undefined;
        }, obj);
      }

      /**
       * This function takes an object and a dot-separated key path. It traverses the object based on the path,
       * returning the value at the specified depth. If any part of the path is missing or undefined, it returns undefined.
       *
       * Example:
       * const objA = { name: 'Alice', address: { city: 'Wonderland', zip: 12345 } };
       * const objB = { name: 'Alice', address: { city: 'Wonderland', zip: 12345 } };
       * const result = ObjectUtils.absoluteCompare(objA, objB);
       * console.log(result); // Output: true
       *
       * const objC = { name: 'Alice', address: { city: 'Wonderland', zip: 12346 } };
       * const result2 = ObjectUtils.absoluteCompare(objA, objC);
       * console.log(result2); // Output: false
       *
       * @param {object} objA - The first object to compare.
       * @param {object} objB - The second object to compare.
       * @param {number} [maxDepth=1] - The maximum depth to compare.
       * @param {number} [currentDepth=0] - The current depth (used internally for recursion).
       * @returns {boolean} True if the objects are equal within the specified depth, false otherwise.
       *
       */
    }, {
      key: "absoluteCompare",
      value: function absoluteCompare(objA, objB) {
        var maxDepth = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 1;
        var currentDepth = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
        if (!objA || !objB) return true;
        if (currentDepth > maxDepth) return true;
        if (_typeof(objA) !== _typeof(objB)) return false;
        var aKeys = Object.keys(objA);
        var bKeys = Object.keys(objB);
        if (aKeys.length !== bKeys.length) return false;
        for (var _i = 0, _aKeys = aKeys; _i < _aKeys.length; _i++) {
          var key = _aKeys[_i];
          var aValue = objA[key];
          var bValue = objB[key];

          // Skip comparison if values are objects
          var isObject = ObjectUtils.isObject(aValue) && ObjectUtils.isObject(bValue);
          var isFunction = ObjectUtils.isFunction(aValue) && ObjectUtils.isFunction(bValue);
          if ((isObject || isFunction) && !this.absoluteCompare(aValue, bValue, maxDepth, currentDepth + 1)) return false;
          if (!isObject && aValue !== bValue) return false;
        }
        return true;
      }

      /**
       * This helper function takes two objects and a list of keys to compare. It compares the values of the specified keys
       * in both objects. If any comparison fails, it returns false. If all specified properties are equal, it returns true.
       * It performs a shallow comparison using absoluteCompare if no keys are provided.
       *
       * Example:
       * const objA = { name: 'Alice', address: { city: 'Wonderland', zip: 12345 } };
       * const objB = { name: 'Alice', address: { city: 'Wonderland', zip: 12345 } };
       * const keysToCompare = ['name', 'address.city', 'address.zip'];
       * const result = ObjectUtils.selectiveCompare(objA, objB, keysToCompare);
       * console.log(result); // Output: true
       *
       * const objC = { name: 'Alice', address: { city: 'Wonderland', zip: 12346 } };
       * const result2 = ObjectUtils.selectiveCompare(objA, objC, keysToCompare);
       * console.log(result2); // Output: false
       *
       * @param {object} a - The first object to compare.
       * @param {object} b - The second object to compare.
       * @param {string[]} [keysToCompare] - The keys to compare. If not provided, performs a shallow comparison using absoluteCompare.
       * @param {number} [maxDepth=1] - The maximum depth to compare if the variables are objects.
       * @returns {boolean} True if all specified properties are equal, false otherwise.
       */
    }, {
      key: "selectiveCompare",
      value: function selectiveCompare(a, b, keysToCompare) {
        var maxDepth = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 1;
        if (a === b) return true;
        if (!a || !b || _typeof(a) !== 'object' || _typeof(b) !== 'object') return false;
        if (!keysToCompare) return this.absoluteCompare(a, b, 1); // If no keys are provided, the comparison is limited to one depth level.
        var _iterator2 = _createForOfIteratorHelper$g(keysToCompare),
          _step2;
        try {
          for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
            var key = _step2.value;
            var aValue = this.getNestedValue(a, key);
            var bValue = this.getNestedValue(b, key);
            var isObject = _typeof(aValue) === 'object' && aValue !== null && _typeof(bValue) === 'object' && bValue !== null;

            // If the current key is an object, they are compared in one further level only.
            if (isObject && !this.absoluteCompare(aValue, bValue, maxDepth)) return false;
            if (!isObject && aValue !== bValue) return false;
          }
        } catch (err) {
          _iterator2.e(err);
        } finally {
          _iterator2.f();
        }
        return true;
      }
    }]);
  }();

  var lastId = 0;
  function UniqueComponentId() {
    var prefix = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'pr_id_';
    lastId++;
    return "".concat(prefix).concat(lastId);
  }

  function ownKeys$22(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$22(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$22(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$22(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var IconUtils = /*#__PURE__*/function () {
    function IconUtils() {
      _classCallCheck(this, IconUtils);
    }
    return _createClass(IconUtils, null, [{
      key: "getJSXIcon",
      value: function getJSXIcon(icon) {
        var iconProps = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
        var content = null;
        if (icon !== null) {
          var iconType = _typeof(icon);
          var className = classNames(iconProps.className, iconType === 'string' && icon);
          content = /*#__PURE__*/React__namespace.createElement("span", _extends({}, iconProps, {
            className: className,
            key: UniqueComponentId('icon')
          }));
          if (iconType !== 'string') {
            var defaultContentOptions = _objectSpread$22({
              iconProps: iconProps,
              element: content
            }, options);
            return ObjectUtils.getJSXElement(icon, defaultContentOptions);
          }
        }
        return content;
      }
    }]);
  }();

  function ownKeys$21(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$21(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$21(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$21(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  function mask(el, options) {
    var defaultOptions = {
      mask: null,
      slotChar: '_',
      autoClear: true,
      unmask: false,
      readOnly: false,
      onComplete: null,
      onChange: null,
      onFocus: null,
      onBlur: null
    };
    options = _objectSpread$21(_objectSpread$21({}, defaultOptions), options);
    var tests;
    var partialPosition;
    var len;
    var firstNonMaskPos;
    var defs;
    var androidChrome;
    var lastRequiredNonMaskPos;
    var oldVal;
    var focusText;
    var caretTimeoutId;
    var buffer;
    var defaultBuffer;
    var caret = function caret(first, last) {
      var range;
      var begin;
      var end;
      if (!el.offsetParent || el !== document.activeElement) {
        return;
      }
      if (typeof first === 'number') {
        begin = first;
        end = typeof last === 'number' ? last : begin;
        if (el.setSelectionRange) {
          el.setSelectionRange(begin, end);
        } else if (el.createTextRange) {
          range = el.createTextRange();
          range.collapse(true);
          range.moveEnd('character', end);
          range.moveStart('character', begin);
          range.select();
        }
      } else {
        if (el.setSelectionRange) {
          begin = el.selectionStart;
          end = el.selectionEnd;
        } else if (document.selection && document.selection.createRange) {
          range = document.selection.createRange();
          begin = 0 - range.duplicate().moveStart('character', -100000);
          end = begin + range.text.length;
        }
        return {
          begin: begin,
          end: end
        };
      }
    };
    var isCompleted = function isCompleted() {
      for (var i = firstNonMaskPos; i <= lastRequiredNonMaskPos; i++) {
        if (tests[i] && buffer[i] === getPlaceholder(i)) {
          return false;
        }
      }
      return true;
    };
    var getPlaceholder = function getPlaceholder(i) {
      if (i < options.slotChar.length) {
        return options.slotChar.charAt(i);
      }
      return options.slotChar.charAt(0);
    };
    var getValue = function getValue() {
      return options.unmask ? getUnmaskedValue() : el && el.value;
    };
    var seekNext = function seekNext(pos) {
      while (++pos < len && !tests[pos]) {}
      return pos;
    };
    var seekPrev = function seekPrev(pos) {
      while (--pos >= 0 && !tests[pos]) {}
      return pos;
    };
    var shiftL = function shiftL(begin, end) {
      var i;
      var j;
      if (begin < 0) {
        return;
      }
      for (i = begin, j = seekNext(end); i < len; i++) {
        if (tests[i]) {
          if (j < len && tests[i].test(buffer[j])) {
            buffer[i] = buffer[j];
            buffer[j] = getPlaceholder(j);
          } else {
            break;
          }
          j = seekNext(j);
        }
      }
      writeBuffer();
      caret(Math.max(firstNonMaskPos, begin));
    };
    var shiftR = function shiftR(pos) {
      var i;
      var c;
      var j;
      var t;
      for (i = pos, c = getPlaceholder(pos); i < len; i++) {
        if (tests[i]) {
          j = seekNext(i);
          t = buffer[i];
          buffer[i] = c;
          if (j < len && tests[j].test(t)) {
            c = t;
          } else {
            break;
          }
        }
      }
    };
    var handleAndroidInput = function handleAndroidInput(e) {
      var curVal = el.value;
      var pos = caret();
      if (oldVal && oldVal.length && oldVal.length > curVal.length) {
        // a deletion or backspace happened
        checkVal(true);
        while (pos.begin > 0 && !tests[pos.begin - 1]) {
          pos.begin--;
        }
        if (pos.begin === 0) {
          while (pos.begin < firstNonMaskPos && !tests[pos.begin]) {
            pos.begin++;
          }
        }
        caret(pos.begin, pos.begin);
      } else {
        checkVal(true);
        while (pos.begin < len && !tests[pos.begin]) {
          pos.begin++;
        }
        caret(pos.begin, pos.begin);
      }
      if (options.onComplete && isCompleted()) {
        options.onComplete({
          originalEvent: e,
          value: getValue()
        });
      }
    };
    var onBlur = function onBlur(e) {
      checkVal();
      options.onBlur && options.onBlur(e);
      updateModel(e);
      if (el.value !== focusText) {
        var event = document.createEvent('HTMLEvents');
        event.initEvent('change', true, false);
        el.dispatchEvent(event);
      }
    };
    var onKeyDown = function onKeyDown(e) {
      if (options.readOnly) {
        return;
      }
      var k = e.which || e.keyCode;
      var pos;
      var begin;
      var end;
      oldVal = el.value;

      //backspace, delete, and escape get special treatment
      if (k === 8 || k === 46 || DomHandler.isIOS() && k === 127) {
        pos = caret();
        begin = pos.begin;
        end = pos.end;
        if (end - begin === 0) {
          begin = k !== 46 ? seekPrev(begin) : end = seekNext(begin - 1);
          end = k === 46 ? seekNext(end) : end;
        }
        clearBuffer(begin, end);
        shiftL(begin, end - 1);
        updateModel(e);
        e.preventDefault();
      } else if (k === 13) {
        // enter
        onBlur(e);
        updateModel(e);
      } else if (k === 27) {
        // escape
        el.value = focusText;
        caret(0, checkVal());
        updateModel(e);
        e.preventDefault();
      }
    };
    var onKeyPress = function onKeyPress(e) {
      if (options.readOnly) {
        return;
      }
      var k = e.which || e.keyCode;
      var pos = caret();
      var p;
      var c;
      var next;
      var completed;
      if (e.ctrlKey || e.altKey || e.metaKey || k < 32) {
        //Ignore
        return;
      } else if (k && k !== 13) {
        if (pos.end - pos.begin !== 0) {
          clearBuffer(pos.begin, pos.end);
          shiftL(pos.begin, pos.end - 1);
        }
        p = seekNext(pos.begin - 1);
        if (p < len) {
          c = String.fromCharCode(k);
          if (tests[p].test(c)) {
            shiftR(p);
            buffer[p] = c;
            writeBuffer();
            next = seekNext(p);
            if (DomHandler.isAndroid()) {
              //Path for CSP Violation on FireFox OS 1.1
              var proxy = function proxy() {
                caret(next);
              };
              setTimeout(proxy, 0);
            } else {
              caret(next);
            }
            if (pos.begin <= lastRequiredNonMaskPos) {
              completed = isCompleted();
            }
          }
        }
        e.preventDefault();
      }
      updateModel(e);
      if (options.onComplete && completed) {
        options.onComplete({
          originalEvent: e,
          value: getValue()
        });
      }
    };
    var clearBuffer = function clearBuffer(start, end) {
      var i;
      for (i = start; i < end && i < len; i++) {
        if (tests[i]) {
          buffer[i] = getPlaceholder(i);
        }
      }
    };
    var writeBuffer = function writeBuffer() {
      el.value = buffer.join('');
    };
    var checkVal = function checkVal(allow) {
      //try to place characters where they belong
      var test = el.value;
      var lastMatch = -1;
      var i;
      var c;
      var pos;
      for (i = 0, pos = 0; i < len; i++) {
        if (tests[i]) {
          buffer[i] = getPlaceholder(i);
          while (pos++ < test.length) {
            c = test.charAt(pos - 1);
            if (tests[i].test(c)) {
              buffer[i] = c;
              lastMatch = i;
              break;
            }
          }
          if (pos > test.length) {
            clearBuffer(i + 1, len);
            break;
          }
        } else {
          if (buffer[i] === test.charAt(pos)) {
            pos++;
          }
          if (i < partialPosition) {
            lastMatch = i;
          }
        }
      }
      if (allow) {
        writeBuffer();
      } else if (lastMatch + 1 < partialPosition) {
        if (options.autoClear || buffer.join('') === defaultBuffer) {
          // Invalid value. Remove it and replace it with the
          // mask, which is the default behavior.
          if (el.value) {
            el.value = '';
          }
          clearBuffer(0, len);
        } else {
          // Invalid value, but we opt to show the value to the
          // user and allow them to correct their mistake.
          writeBuffer();
        }
      } else {
        writeBuffer();
        el.value = el.value.substring(0, lastMatch + 1);
      }
      return partialPosition ? i : firstNonMaskPos;
    };
    var onFocus = function onFocus(e) {
      if (options.readOnly) {
        return;
      }
      clearTimeout(caretTimeoutId);
      var pos;
      focusText = el.value;
      pos = checkVal();
      caretTimeoutId = setTimeout(function () {
        if (el !== document.activeElement) {
          return;
        }
        writeBuffer();
        if (pos === options.mask.replace('?', '').length) {
          caret(0, pos);
        } else {
          caret(pos);
        }
      }, 100);
      if (options.onFocus) {
        options.onFocus(e);
      }
    };
    var onInput = function onInput(event) {
      if (androidChrome) {
        handleAndroidInput(event);
      } else {
        handleInputChange(event);
      }
    };
    var handleInputChange = function handleInputChange(e) {
      if (options.readOnly) {
        return;
      }
      var pos = checkVal(true);
      caret(pos);
      updateModel(e);
      if (options.onComplete && isCompleted()) {
        options.onComplete({
          originalEvent: e,
          value: getValue()
        });
      }
    };
    var getUnmaskedValue = function getUnmaskedValue() {
      var unmaskedBuffer = [];
      for (var i = 0; i < buffer.length; i++) {
        var c = buffer[i];
        if (tests[i] && c !== getPlaceholder(i)) {
          unmaskedBuffer.push(c);
        }
      }
      return unmaskedBuffer.join('');
    };
    var updateModel = function updateModel(e) {
      if (options.onChange) {
        var val = getValue();
        options.onChange({
          originalEvent: e,
          value: defaultBuffer !== val ? val : '',
          stopPropagation: function stopPropagation() {
            e.stopPropagation();
          },
          preventDefault: function preventDefault() {
            e.preventDefault();
          },
          target: {
            value: defaultBuffer !== val ? val : ''
          }
        });
      }
    };
    var bindEvents = function bindEvents() {
      el.addEventListener('focus', onFocus);
      el.addEventListener('blur', onBlur);
      el.addEventListener('keydown', onKeyDown);
      el.addEventListener('keypress', onKeyPress);
      el.addEventListener('input', onInput);
      el.addEventListener('paste', handleInputChange);
    };
    var unbindEvents = function unbindEvents() {
      el.removeEventListener('focus', onFocus);
      el.removeEventListener('blur', onBlur);
      el.removeEventListener('keydown', onKeyDown);
      el.removeEventListener('keypress', onKeyPress);
      el.removeEventListener('input', onInput);
      el.removeEventListener('paste', handleInputChange);
    };
    var init = function init() {
      tests = [];
      partialPosition = options.mask.length;
      len = options.mask.length;
      firstNonMaskPos = null;
      defs = {
        9: '[0-9]',
        a: '[A-Za-z]',
        '*': '[A-Za-z0-9]'
      };
      androidChrome = DomHandler.isChrome() && DomHandler.isAndroid();
      var maskTokens = options.mask.split('');
      for (var i = 0; i < maskTokens.length; i++) {
        var c = maskTokens[i];
        if (c === '?') {
          len--;
          partialPosition = i;
        } else if (defs[c]) {
          tests.push(new RegExp(defs[c]));
          if (firstNonMaskPos === null) {
            firstNonMaskPos = tests.length - 1;
          }
          if (i < partialPosition) {
            lastRequiredNonMaskPos = tests.length - 1;
          }
        } else {
          tests.push(null);
        }
      }
      buffer = [];
      for (var _i = 0; _i < maskTokens.length; _i++) {
        var _c = maskTokens[_i];
        if (_c !== '?') {
          if (defs[_c]) {
            buffer.push(getPlaceholder(_i));
          } else {
            buffer.push(_c);
          }
        }
      }
      defaultBuffer = buffer.join('');
    };
    if (el && options.mask) {
      init();
      bindEvents();
    }
    return {
      init: init,
      bindEvents: bindEvents,
      unbindEvents: unbindEvents,
      updateModel: updateModel,
      getValue: getValue
    };
  }

  function ownKeys$20(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$20(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$20(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$20(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  /**
   * Merges properties together taking an Array of props and merging into one single set of
   * properties. The options can contain a "classNameMergeFunction" which can be something
   * like Tailwind Merge for properly merging Tailwind classes.
   *
   * @param {object[]} props the array of object properties to merge
   * @param {*} options either empty or could contain a custom merge function like TailwindMerge
   * @returns the single properties value after merging
   */
  function mergeProps(props) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    if (!props) {
      return undefined;
    }
    var isFunction = function isFunction(obj) {
      return typeof obj === 'function';
    };
    var classNameMergeFunction = options.classNameMergeFunction;
    var hasMergeFunction = isFunction(classNameMergeFunction);
    return props.reduce(function (merged, ps) {
      if (!ps) {
        return merged;
      }
      var _loop = function _loop() {
        var value = ps[key];
        if (key === 'style') {
          merged.style = _objectSpread$20(_objectSpread$20({}, merged.style), ps.style);
        } else if (key === 'className') {
          var newClassName = '';
          if (hasMergeFunction) {
            newClassName = classNameMergeFunction(merged.className, ps.className);
          } else {
            newClassName = [merged.className, ps.className].join(' ').trim();
          }
          merged.className = newClassName || undefined;
        } else if (isFunction(value)) {
          var existingFn = merged[key];
          merged[key] = existingFn ? function () {
            existingFn.apply(void 0, arguments);
            value.apply(void 0, arguments);
          } : value;
        } else {
          merged[key] = value;
        }
      };
      for (var key in ps) {
        _loop();
      }
      return merged;
    }, {});
  }

  function handler() {
    var zIndexes = [];
    var generateZIndex = function generateZIndex(key, autoZIndex) {
      var baseZIndex = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 999;
      var lastZIndex = getLastZIndex(key, autoZIndex, baseZIndex);
      var newZIndex = lastZIndex.value + (lastZIndex.key === key ? 0 : baseZIndex) + 1;
      zIndexes.push({
        key: key,
        value: newZIndex
      });
      return newZIndex;
    };
    var revertZIndex = function revertZIndex(zIndex) {
      zIndexes = zIndexes.filter(function (obj) {
        return obj.value !== zIndex;
      });
    };
    var getCurrentZIndex = function getCurrentZIndex(key, autoZIndex) {
      return getLastZIndex(key, autoZIndex).value;
    };
    var getLastZIndex = function getLastZIndex(key, autoZIndex) {
      var baseZIndex = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
      return _toConsumableArray(zIndexes).reverse().find(function (obj) {
        return autoZIndex ? true : obj.key === key;
      }) || {
        key: key,
        value: baseZIndex
      };
    };
    var getZIndex = function getZIndex(el) {
      return el ? parseInt(el.style.zIndex, 10) || 0 : 0;
    };
    return {
      get: getZIndex,
      set: function set(key, el, autoZIndex, baseZIndex) {
        if (el) {
          el.style.zIndex = String(generateZIndex(key, autoZIndex, baseZIndex));
        }
      },
      clear: function clear(el) {
        if (el) {
          revertZIndex(ZIndexUtils.get(el));
          el.style.zIndex = '';
        }
      },
      getCurrent: function getCurrent(key, autoZIndex) {
        return getCurrentZIndex(key, autoZIndex);
      }
    };
  }
  var ZIndexUtils = handler();

  function _createForOfIteratorHelper$f(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray$f(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t["return"] || t["return"](); } finally { if (u) throw o; } } }; }
  function _unsupportedIterableToArray$f(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray$f(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray$f(r, a) : void 0; } }
  function _arrayLikeToArray$f(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
  var FilterService = {
    filter: function filter(value, fields, filterValue, filterMatchMode, filterLocale) {
      var filteredItems = [];
      if (!value) {
        return filteredItems;
      }
      var _iterator = _createForOfIteratorHelper$f(value),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var item = _step.value;
          if (typeof item === 'string') {
            if (this.filters[filterMatchMode](item, filterValue, filterLocale)) {
              filteredItems.push(item);
              continue;
            }
          } else {
            var _iterator2 = _createForOfIteratorHelper$f(fields),
              _step2;
            try {
              for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
                var field = _step2.value;
                var fieldValue = ObjectUtils.resolveFieldData(item, field);
                if (this.filters[filterMatchMode](fieldValue, filterValue, filterLocale)) {
                  filteredItems.push(item);
                  break;
                }
              }
            } catch (err) {
              _iterator2.e(err);
            } finally {
              _iterator2.f();
            }
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
      return filteredItems;
    },
    filters: {
      startsWith: function startsWith(value, filter, filterLocale) {
        if (filter === undefined || filter === null || filter.trim() === '') {
          return true;
        }
        if (value === undefined || value === null) {
          return false;
        }
        var filterValue = ObjectUtils.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);
        var stringValue = ObjectUtils.removeAccents(value.toString()).toLocaleLowerCase(filterLocale);
        return stringValue.slice(0, filterValue.length) === filterValue;
      },
      contains: function contains(value, filter, filterLocale) {
        if (filter === undefined || filter === null || typeof filter === 'string' && filter.trim() === '') {
          return true;
        }
        if (value === undefined || value === null) {
          return false;
        }
        var filterValue = ObjectUtils.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);
        var stringValue = ObjectUtils.removeAccents(value.toString()).toLocaleLowerCase(filterLocale);
        return stringValue.indexOf(filterValue) !== -1;
      },
      notContains: function notContains(value, filter, filterLocale) {
        if (filter === undefined || filter === null || typeof filter === 'string' && filter.trim() === '') {
          return true;
        }
        if (value === undefined || value === null) {
          return false;
        }
        var filterValue = ObjectUtils.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);
        var stringValue = ObjectUtils.removeAccents(value.toString()).toLocaleLowerCase(filterLocale);
        return stringValue.indexOf(filterValue) === -1;
      },
      endsWith: function endsWith(value, filter, filterLocale) {
        if (filter === undefined || filter === null || filter.trim() === '') {
          return true;
        }
        if (value === undefined || value === null) {
          return false;
        }
        var filterValue = ObjectUtils.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);
        var stringValue = ObjectUtils.removeAccents(value.toString()).toLocaleLowerCase(filterLocale);
        return stringValue.indexOf(filterValue, stringValue.length - filterValue.length) !== -1;
      },
      equals: function equals(value, filter, filterLocale) {
        if (filter === undefined || filter === null || typeof filter === 'string' && filter.trim() === '') {
          return true;
        }
        if (value === undefined || value === null) {
          return false;
        }
        if (value.getTime && filter.getTime) {
          return value.getTime() === filter.getTime();
        }
        return ObjectUtils.removeAccents(value.toString()).toLocaleLowerCase(filterLocale) === ObjectUtils.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);
      },
      notEquals: function notEquals(value, filter, filterLocale) {
        if (filter === undefined || filter === null || typeof filter === 'string' && filter.trim() === '') {
          return true;
        }
        if (value === undefined || value === null) {
          return true;
        }
        if (value.getTime && filter.getTime) {
          return value.getTime() !== filter.getTime();
        }
        return ObjectUtils.removeAccents(value.toString()).toLocaleLowerCase(filterLocale) !== ObjectUtils.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);
      },
      "in": function _in(value, filter) {
        if (filter === undefined || filter === null || filter.length === 0) {
          return true;
        }
        for (var i = 0; i < filter.length; i++) {
          if (ObjectUtils.equals(value, filter[i])) {
            return true;
          }
        }
        return false;
      },
      notIn: function notIn(value, filter) {
        if (filter === undefined || filter === null || filter.length === 0) {
          return true;
        }
        for (var i = 0; i < filter.length; i++) {
          if (ObjectUtils.equals(value, filter[i])) {
            return false;
          }
        }
        return true;
      },
      between: function between(value, filter) {
        if (filter == null || filter[0] == null || filter[1] == null) {
          return true;
        }
        if (value === undefined || value === null) {
          return false;
        }
        if (value.getTime) {
          return filter[0].getTime() <= value.getTime() && value.getTime() <= filter[1].getTime();
        }
        return filter[0] <= value && value <= filter[1];
      },
      lt: function lt(value, filter) {
        if (filter === undefined || filter === null) {
          return true;
        }
        if (value === undefined || value === null) {
          return false;
        }
        if (value.getTime && filter.getTime) {
          return value.getTime() < filter.getTime();
        }
        return value < filter;
      },
      lte: function lte(value, filter) {
        if (filter === undefined || filter === null) {
          return true;
        }
        if (value === undefined || value === null) {
          return false;
        }
        if (value.getTime && filter.getTime) {
          return value.getTime() <= filter.getTime();
        }
        return value <= filter;
      },
      gt: function gt(value, filter) {
        if (filter === undefined || filter === null) {
          return true;
        }
        if (value === undefined || value === null) {
          return false;
        }
        if (value.getTime && filter.getTime) {
          return value.getTime() > filter.getTime();
        }
        return value > filter;
      },
      gte: function gte(value, filter) {
        if (filter === undefined || filter === null) {
          return true;
        }
        if (value === undefined || value === null) {
          return false;
        }
        if (value.getTime && filter.getTime) {
          return value.getTime() >= filter.getTime();
        }
        return value >= filter;
      },
      dateIs: function dateIs(value, filter) {
        if (filter === undefined || filter === null) {
          return true;
        }
        if (value === undefined || value === null) {
          return false;
        }
        return value.toDateString() === filter.toDateString();
      },
      dateIsNot: function dateIsNot(value, filter) {
        if (filter === undefined || filter === null) {
          return true;
        }
        if (value === undefined || value === null) {
          return false;
        }
        return value.toDateString() !== filter.toDateString();
      },
      dateBefore: function dateBefore(value, filter) {
        if (filter === undefined || filter === null) {
          return true;
        }
        if (value === undefined || value === null) {
          return false;
        }
        return value.getTime() < filter.getTime();
      },
      dateAfter: function dateAfter(value, filter) {
        if (filter === undefined || filter === null) {
          return true;
        }
        if (value === undefined || value === null) {
          return false;
        }
        return value.getTime() > filter.getTime();
      }
    },
    register: function register(rule, fn) {
      this.filters[rule] = fn;
    }
  };

  /**
   * @deprecated please use PrimeReactContext
   */
  var PrimeReact$1 = /*#__PURE__*/_createClass(function PrimeReact() {
    _classCallCheck(this, PrimeReact);
  });
  _defineProperty(PrimeReact$1, "ripple", false);
  _defineProperty(PrimeReact$1, "inputStyle", 'outlined');
  _defineProperty(PrimeReact$1, "locale", 'en');
  _defineProperty(PrimeReact$1, "appendTo", null);
  _defineProperty(PrimeReact$1, "cssTransition", true);
  _defineProperty(PrimeReact$1, "autoZIndex", true);
  _defineProperty(PrimeReact$1, "hideOverlaysOnDocumentScrolling", false);
  _defineProperty(PrimeReact$1, "nonce", null);
  _defineProperty(PrimeReact$1, "nullSortOrder", 1);
  _defineProperty(PrimeReact$1, "zIndex", {
    modal: 1100,
    overlay: 1000,
    menu: 1000,
    tooltip: 1100,
    toast: 1200
  });
  _defineProperty(PrimeReact$1, "pt", undefined);
  _defineProperty(PrimeReact$1, "filterMatchModeOptions", {
    text: [FilterMatchMode.STARTS_WITH, FilterMatchMode.CONTAINS, FilterMatchMode.NOT_CONTAINS, FilterMatchMode.ENDS_WITH, FilterMatchMode.EQUALS, FilterMatchMode.NOT_EQUALS],
    numeric: [FilterMatchMode.EQUALS, FilterMatchMode.NOT_EQUALS, FilterMatchMode.LESS_THAN, FilterMatchMode.LESS_THAN_OR_EQUAL_TO, FilterMatchMode.GREATER_THAN, FilterMatchMode.GREATER_THAN_OR_EQUAL_TO],
    date: [FilterMatchMode.DATE_IS, FilterMatchMode.DATE_IS_NOT, FilterMatchMode.DATE_BEFORE, FilterMatchMode.DATE_AFTER]
  });
  _defineProperty(PrimeReact$1, "changeTheme", function (currentTheme, newTheme, linkElementId, callback) {
    var _linkElement$parentNo;
    var linkElement = document.getElementById(linkElementId);
    if (!linkElement) {
      throw Error("Element with id ".concat(linkElementId, " not found."));
    }
    var newThemeUrl = linkElement.getAttribute('href').replace(currentTheme, newTheme);
    var newLinkElement = document.createElement('link');
    newLinkElement.setAttribute('rel', 'stylesheet');
    newLinkElement.setAttribute('id', linkElementId);
    newLinkElement.setAttribute('href', newThemeUrl);
    newLinkElement.addEventListener('load', function () {
      if (callback) {
        callback();
      }
    });
    (_linkElement$parentNo = linkElement.parentNode) === null || _linkElement$parentNo === void 0 || _linkElement$parentNo.replaceChild(newLinkElement, linkElement);
  });

  function ownKeys$1$(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1$(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1$(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1$(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var locales = {
    en: {
      accept: 'Yes',
      addRule: 'Add Rule',
      am: 'AM',
      apply: 'Apply',
      cancel: 'Cancel',
      choose: 'Choose',
      chooseDate: 'Choose Date',
      chooseMonth: 'Choose Month',
      chooseYear: 'Choose Year',
      clear: 'Clear',
      completed: 'Completed',
      contains: 'Contains',
      custom: 'Custom',
      dateAfter: 'Date is after',
      dateBefore: 'Date is before',
      dateFormat: 'mm/dd/yy',
      dateIs: 'Date is',
      dateIsNot: 'Date is not',
      dayNames: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'],
      dayNamesMin: ['Su', 'Mo', 'Tu', 'We', 'Th', 'Fr', 'Sa'],
      dayNamesShort: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
      emptyFilterMessage: 'No results found',
      emptyMessage: 'No available options',
      emptySearchMessage: 'No results found',
      emptySelectionMessage: 'No selected item',
      endsWith: 'Ends with',
      equals: 'Equals',
      fileChosenMessage: '{0} files',
      fileSizeTypes: ['B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'],
      filter: 'Filter',
      firstDayOfWeek: 0,
      gt: 'Greater than',
      gte: 'Greater than or equal to',
      lt: 'Less than',
      lte: 'Less than or equal to',
      matchAll: 'Match All',
      matchAny: 'Match Any',
      medium: 'Medium',
      monthNames: ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'],
      monthNamesShort: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
      nextDecade: 'Next Decade',
      nextHour: 'Next Hour',
      nextMinute: 'Next Minute',
      nextMonth: 'Next Month',
      nextSecond: 'Next Second',
      nextYear: 'Next Year',
      noFileChosenMessage: 'No file chosen',
      noFilter: 'No Filter',
      notContains: 'Not contains',
      notEquals: 'Not equals',
      now: 'Now',
      passwordPrompt: 'Enter a password',
      pending: 'Pending',
      pm: 'PM',
      prevDecade: 'Previous Decade',
      prevHour: 'Previous Hour',
      prevMinute: 'Previous Minute',
      prevMonth: 'Previous Month',
      prevSecond: 'Previous Second',
      prevYear: 'Previous Year',
      reject: 'No',
      removeRule: 'Remove Rule',
      searchMessage: '{0} results are available',
      selectionMessage: '{0} items selected',
      showMonthAfterYear: false,
      startsWith: 'Starts with',
      strong: 'Strong',
      today: 'Today',
      upload: 'Upload',
      weak: 'Weak',
      weekHeader: 'Wk',
      aria: {
        cancelEdit: 'Cancel Edit',
        close: 'Close',
        collapseLabel: 'Collapse',
        collapseRow: 'Row Collapsed',
        editRow: 'Edit Row',
        expandLabel: 'Expand',
        expandRow: 'Row Expanded',
        falseLabel: 'False',
        filterConstraint: 'Filter Constraint',
        filterOperator: 'Filter Operator',
        firstPageLabel: 'First Page',
        gridView: 'Grid View',
        hideFilterMenu: 'Hide Filter Menu',
        jumpToPageDropdownLabel: 'Jump to Page Dropdown',
        jumpToPageInputLabel: 'Jump to Page Input',
        lastPageLabel: 'Last Page',
        listLabel: 'Option List',
        listView: 'List View',
        moveAllToSource: 'Move All to Source',
        moveAllToTarget: 'Move All to Target',
        moveBottom: 'Move Bottom',
        moveDown: 'Move Down',
        moveToSource: 'Move to Source',
        moveToTarget: 'Move to Target',
        moveTop: 'Move Top',
        moveUp: 'Move Up',
        navigation: 'Navigation',
        next: 'Next',
        nextPageLabel: 'Next Page',
        nullLabel: 'Not Selected',
        otpLabel: 'Please enter one time password character {0}',
        pageLabel: 'Page {page}',
        passwordHide: 'Hide Password',
        passwordShow: 'Show Password',
        previous: 'Previous',
        prevPageLabel: 'Previous Page',
        removeLabel: 'Remove',
        rotateLeft: 'Rotate Left',
        rotateRight: 'Rotate Right',
        rowsPerPageLabel: 'Rows per page',
        saveEdit: 'Save Edit',
        scrollTop: 'Scroll Top',
        selectAll: 'All items selected',
        selectLabel: 'Select',
        selectRow: 'Row Selected',
        showFilterMenu: 'Show Filter Menu',
        slide: 'Slide',
        slideNumber: '{slideNumber}',
        star: '1 star',
        stars: '{star} stars',
        trueLabel: 'True',
        unselectAll: 'All items unselected',
        unselectLabel: 'Unselect',
        unselectRow: 'Row Unselected',
        zoomImage: 'Zoom Image',
        zoomIn: 'Zoom In',
        zoomOut: 'Zoom Out'
      }
    }
  };
  function locale(locale) {
    locale && (PrimeReact$1.locale = locale);
    return {
      locale: PrimeReact$1.locale,
      options: locales[PrimeReact$1.locale]
    };
  }
  function addLocale(locale, options) {
    if (locale.includes('__proto__') || locale.includes('prototype')) {
      throw new Error('Unsafe locale detected');
    }
    locales[locale] = _objectSpread$1$(_objectSpread$1$({}, locales.en), options);
  }
  function updateLocaleOption(key, value, locale) {
    if (key.includes('__proto__') || key.includes('prototype')) {
      throw new Error('Unsafe key detected');
    }
    localeOptions(locale)[key] = value;
  }
  function updateLocaleOptions(options, locale) {
    if (locale.includes('__proto__') || locale.includes('prototype')) {
      throw new Error('Unsafe locale detected');
    }
    var _locale = locale || PrimeReact$1.locale;
    locales[_locale] = _objectSpread$1$(_objectSpread$1$({}, locales[_locale]), options);
  }
  function localeOption(key, locale) {
    if (key.includes('__proto__') || key.includes('prototype')) {
      throw new Error('Unsafe key detected');
    }
    var _locale = locale || PrimeReact$1.locale;
    try {
      return localeOptions(_locale)[key];
    } catch (error) {
      throw new Error("The ".concat(key, " option is not found in the current locale('").concat(_locale, "')."));
    }
  }

  /**
   * Find an ARIA label in the locale by key.  If options are passed it will replace all options:
   * ```ts
   * const ariaValue = "Page {page}, User {user}, Role {role}";
   * const options = { page: 2, user: "John", role: "Admin" };
   * const result = ariaLabel('yourLabel', { page: 2, user: "John", role: "Admin" })
   * console.log(result); // Output: Page 2, User John, Role Admin
   * ```
   * @param {string} ariaKey key of the ARIA label to look up in locale.
   * @param {any} options JSON options like { page: 2, user: "John", role: "Admin" }
   * @returns the ARIA label with replaced values
   */
  function ariaLabel(ariaKey, options) {
    if (ariaKey.includes('__proto__') || ariaKey.includes('prototype')) {
      throw new Error('Unsafe ariaKey detected');
    }
    var _locale = PrimeReact$1.locale;
    try {
      var _ariaLabel = localeOptions(_locale).aria[ariaKey];
      if (_ariaLabel) {
        for (var key in options) {
          if (options.hasOwnProperty(key)) {
            _ariaLabel = _ariaLabel.replace("{".concat(key, "}"), options[key]);
          }
        }
      }
      return _ariaLabel;
    } catch (error) {
      throw new Error("The ".concat(ariaKey, " option is not found in the current locale('").concat(_locale, "')."));
    }
  }
  function localeOptions(locale) {
    var _locale = locale || PrimeReact$1.locale;
    if (_locale.includes('__proto__') || _locale.includes('prototype')) {
      throw new Error('Unsafe locale detected');
    }
    return locales[_locale];
  }

  var MessageSeverity = Object.freeze({
    SUCCESS: 'success',
    INFO: 'info',
    WARN: 'warn',
    ERROR: 'error',
    SECONDARY: 'secondary',
    CONTRAST: 'contrast'
  });

  var PrimeIcons = Object.freeze({
    ADDRESS_BOOK: 'pi pi-address-book',
    ALIGN_CENTER: 'pi pi-align-center',
    ALIGN_JUSTIFY: 'pi pi-align-justify',
    ALIGN_LEFT: 'pi pi-align-left',
    ALIGN_RIGHT: 'pi pi-align-right',
    AMAZON: 'pi pi-amazon',
    ANDROID: 'pi pi-android',
    ANGLE_DOUBLE_DOWN: 'pi pi-angle-double-down',
    ANGLE_DOUBLE_LEFT: 'pi pi-angle-double-left',
    ANGLE_DOUBLE_RIGHT: 'pi pi-angle-double-right',
    ANGLE_DOUBLE_UP: 'pi pi-angle-double-up',
    ANGLE_DOWN: 'pi pi-angle-down',
    ANGLE_LEFT: 'pi pi-angle-left',
    ANGLE_RIGHT: 'pi pi-angle-right',
    ANGLE_UP: 'pi pi-angle-up',
    APPLE: 'pi pi-apple',
    ARROW_CIRCLE_DOWN: 'pi pi-arrow-circle-down',
    ARROW_CIRCLE_LEFT: 'pi pi-arrow-circle-left',
    ARROW_CIRCLE_RIGHT: 'pi pi-arrow-circle-right',
    ARROW_CIRCLE_UP: 'pi pi-arrow-circle-up',
    ARROW_DOWN_LEFT_AND_ARROW_UP_RIGHT_TO_CENTER: 'pi pi-arrow-down-left-and-arrow-up-right-to-center',
    ARROW_DOWN_LEFT: 'pi pi-arrow-down-left',
    ARROW_DOWN_RIGHT: 'pi pi-arrow-down-right',
    ARROW_DOWN: 'pi pi-arrow-down',
    ARROW_LEFT: 'pi pi-arrow-left',
    ARROW_RIGHT_ARROW_LEFT: 'pi pi-arrow-right-arrow-left',
    ARROW_RIGHT: 'pi pi-arrow-right',
    ARROW_UP_LEFT: 'pi pi-arrow-up-left',
    ARROW_UP_RIGHT_AND_ARROW_DOWN_LEFT_FROM_CENTER: 'pi pi-arrow-up-right-and-arrow-down-left-from-center',
    ARROW_UP_RIGHT: 'pi pi-arrow-up-right',
    ARROW_UP: 'pi pi-arrow-up',
    ARROWS_ALT: 'pi pi-arrows-alt',
    ARROWS_H: 'pi pi-arrows-h',
    ARROWS_V: 'pi pi-arrows-v',
    ASTERISK: 'pi pi-asterisk',
    AT: 'pi pi-at',
    BACKWARD: 'pi pi-backward',
    BAN: 'pi pi-ban',
    BARCODE: 'pi pi-barcode',
    BARS: 'pi pi-bars',
    BELL_SLASH: 'pi pi-bell-slash',
    BELL: 'pi pi-bell',
    BITCOIN: 'pi pi-bitcoin',
    BOLT: 'pi pi-bolt',
    BOOK: 'pi pi-book',
    BOOKMARK_FILL: 'pi pi-bookmark-fill',
    BOOKMARK: 'pi pi-bookmark',
    BOX: 'pi pi-box',
    BRIEFCASE: 'pi pi-briefcase',
    BUILDING_COLUMNS: 'pi pi-building-columns',
    BUILDING: 'pi pi-building',
    BULLSEYE: 'pi pi-bullseye',
    CALCULATOR: 'pi pi-calculator',
    CALENDAR_CLOCK: 'pi pi-calendar-clock',
    CALENDAR_MINUS: 'pi pi-calendar-minus',
    CALENDAR_PLUS: 'pi pi-calendar-plus',
    CALENDAR_TIMES: 'pi pi-calendar-times',
    CALENDAR: 'pi pi-calendar',
    CAMERA: 'pi pi-camera',
    CAR: 'pi pi-car',
    CARET_DOWN: 'pi pi-caret-down',
    CARET_LEFT: 'pi pi-caret-left',
    CARET_RIGHT: 'pi pi-caret-right',
    CARET_UP: 'pi pi-caret-up',
    CART_ARROW_DOWN: 'pi pi-cart-arrow-down',
    CART_MINUS: 'pi pi-cart-minus',
    CART_PLUS: 'pi pi-cart-plus',
    CHART_BAR: 'pi pi-chart-bar',
    CHART_LINE: 'pi pi-chart-line',
    CHART_PIE: 'pi pi-chart-pie',
    CHART_SCATTER: 'pi pi-chart-scatter',
    CHECK_CIRCLE: 'pi pi-check-circle',
    CHECK_SQUARE: 'pi pi-check-square',
    CHECK: 'pi pi-check',
    CHEVRON_CIRCLE_DOWN: 'pi pi-chevron-circle-down',
    CHEVRON_CIRCLE_LEFT: 'pi pi-chevron-circle-left',
    CHEVRON_CIRCLE_RIGHT: 'pi pi-chevron-circle-right',
    CHEVRON_CIRCLE_UP: 'pi pi-chevron-circle-up',
    CHEVRON_DOWN: 'pi pi-chevron-down',
    CHEVRON_LEFT: 'pi pi-chevron-left',
    CHEVRON_RIGHT: 'pi pi-chevron-right',
    CHEVRON_UP: 'pi pi-chevron-up',
    CIRCLE_FILL: 'pi pi-circle-fill',
    CIRCLE_OFF: 'pi pi-circle-off',
    CIRCLE_ON: 'pi pi-circle-on',
    CIRCLE: 'pi pi-circle',
    CLIPBOARD: 'pi pi-clipboard',
    CLOCK: 'pi pi-clock',
    CLONE: 'pi pi-clone',
    CLOUD_DOWNLOAD: 'pi pi-cloud-download',
    CLOUD_UPLOAD: 'pi pi-cloud-upload',
    CLOUD: 'pi pi-cloud',
    CODE: 'pi pi-code',
    COG: 'pi pi-cog',
    COMMENT: 'pi pi-comment',
    COMMENTS: 'pi pi-comments',
    COMPASS: 'pi pi-compass',
    COPY: 'pi pi-copy',
    CREDIT_CARD: 'pi pi-credit-card',
    CROWN: 'pi pi-crown',
    DATABASE: 'pi pi-database',
    DELETE_LEFT: 'pi pi-delete-left',
    DESKTOP: 'pi pi-desktop',
    DIRECTIONS_ALT: 'pi pi-directions-alt',
    DIRECTIONS: 'pi pi-directions',
    DISCORD: 'pi pi-discord',
    DOLLAR: 'pi pi-dollar',
    DOWNLOAD: 'pi pi-download',
    EJECT: 'pi pi-eject',
    ELLIPSIS_H: 'pi pi-ellipsis-h',
    ELLIPSIS_V: 'pi pi-ellipsis-v',
    ENVELOPE: 'pi pi-envelope',
    EQUALS: 'pi pi-equals',
    ERASER: 'pi pi-eraser',
    ETHEREUM: 'pi pi-ethereum',
    EURO: 'pi pi-euro',
    EXCLAMATION_CIRCLE: 'pi pi-exclamation-circle',
    EXCLAMATION_TRIANGLE: 'pi pi-exclamation-triangle',
    EXPAND: 'pi pi-expand',
    EXTERNAL_LINK: 'pi pi-external-link',
    EYE_SLASH: 'pi pi-eye-slash',
    EYE: 'pi pi-eye',
    FACE_SMILE: 'pi pi-face-smile',
    FACEBOOK: 'pi pi-facebook',
    FAST_BACKWARD: 'pi pi-fast-backward',
    FAST_FORWARD: 'pi pi-fast-forward',
    FILE_ARROW_UP: 'pi pi-file-arrow-up',
    FILE_CHECK: 'pi pi-file-check',
    FILE_EDIT: 'pi pi-file-edit',
    FILE_EXCEL: 'pi pi-file-excel',
    FILE_EXPORT: 'pi pi-file-export',
    FILE_IMPORT: 'pi pi-file-import',
    FILE_O: 'pi pi-file-o',
    FILE_PDF: 'pi pi-file-pdf',
    FILE_PLUS: 'pi pi-file-plus',
    FILE_WORD: 'pi pi-file-word',
    FILE: 'pi pi-file',
    FILTER_FILL: 'pi pi-filter-fill',
    FILTER_SLASH: 'pi pi-filter-slash',
    FILTER: 'pi pi-filter',
    FLAG_FILL: 'pi pi-flag-fill',
    FLAG: 'pi pi-flag',
    FOLDER_OPEN: 'pi pi-folder-open',
    FOLDER_PLUS: 'pi pi-folder-plus',
    FOLDER: 'pi pi-folder',
    FORWARD: 'pi pi-forward',
    GAUGE: 'pi pi-gauge',
    GIFT: 'pi pi-gift',
    GITHUB: 'pi pi-github',
    GLOBE: 'pi pi-globe',
    GOOGLE: 'pi pi-google',
    GRADUATION_CAP: 'pi pi-graduation-cap',
    HAMMER: 'pi pi-hammer',
    HASHTAG: 'pi pi-hashtag',
    HEADPHONES: 'pi pi-headphones',
    HEART_FILL: 'pi pi-heart-fill',
    HEART: 'pi pi-heart',
    HISTORY: 'pi pi-history',
    HOME: 'pi pi-home',
    HOURGLASS: 'pi pi-hourglass',
    ID_CARD: 'pi pi-id-card',
    IMAGE: 'pi pi-image',
    IMAGES: 'pi pi-images',
    INBOX: 'pi pi-inbox',
    INDIAN_RUPEE: 'pi pi-indian-rupee',
    INFO_CIRCLE: 'pi pi-info-circle',
    INFO: 'pi pi-info',
    INSTAGRAM: 'pi pi-instagram',
    KEY: 'pi pi-key',
    LANGUAGE: 'pi pi-language',
    LIGHTBULB: 'pi pi-lightbulb',
    LINK: 'pi pi-link',
    LINKEDIN: 'pi pi-linkedin',
    LIST_CHECK: 'pi pi-list-check',
    LIST: 'pi pi-list',
    LOCK_OPEN: 'pi pi-lock-open',
    LOCK: 'pi pi-lock',
    MAP_MARKER: 'pi pi-map-marker',
    MAP: 'pi pi-map',
    MARS: 'pi pi-mars',
    MEGAPHONE: 'pi pi-megaphone',
    MICROCHIP_AI: 'pi pi-microchip-ai',
    MICROCHIP: 'pi pi-microchip',
    MICROPHONE: 'pi pi-microphone',
    MICROSOFT: 'pi pi-microsoft',
    MINUS_CIRCLE: 'pi pi-minus-circle',
    MINUS: 'pi pi-minus',
    MOBILE: 'pi pi-mobile',
    MONEY_BILL: 'pi pi-money-bill',
    MOON: 'pi pi-moon',
    OBJECTS_COLUMN: 'pi pi-objects-column',
    PALETTE: 'pi pi-palette',
    PAPERCLIP: 'pi pi-paperclip',
    PAUSE_CIRCLE: 'pi pi-pause-circle',
    PAUSE: 'pi pi-pause',
    PAYPAL: 'pi pi-paypal',
    PEN_TO_SQUARE: 'pi pi-pen-to-square',
    PENCIL: 'pi pi-pencil',
    PERCENTAGE: 'pi pi-percentage',
    PHONE: 'pi pi-phone',
    PINTEREST: 'pi pi-pinterest',
    PLAY_CIRCLE: 'pi pi-play-circle',
    PLAY: 'pi pi-play',
    PLUS_CIRCLE: 'pi pi-plus-circle',
    PLUS: 'pi pi-plus',
    POUND: 'pi pi-pound',
    POWER_OFF: 'pi pi-power-off',
    PRIME: 'pi pi-prime',
    PRINT: 'pi pi-print',
    QRCODE: 'pi pi-qrcode',
    QUESTION_CIRCLE: 'pi pi-question-circle',
    QUESTION: 'pi pi-question',
    RECEIPT: 'pi pi-receipt',
    REDDIT: 'pi pi-reddit',
    REFRESH: 'pi pi-refresh',
    REPLAY: 'pi pi-replay',
    REPLY: 'pi pi-reply',
    SAVE: 'pi pi-save',
    SEARCH_MINUS: 'pi pi-search-minus',
    SEARCH_PLUS: 'pi pi-search-plus',
    SEARCH: 'pi pi-search',
    SEND: 'pi pi-send',
    SERVER: 'pi pi-server',
    SHARE_ALT: 'pi pi-share-alt',
    SHIELD: 'pi pi-shield',
    SHOP: 'pi pi-shop',
    SHOPPING_BAG: 'pi pi-shopping-bag',
    SHOPPING_CART: 'pi pi-shopping-cart',
    SIGN_IN: 'pi pi-sign-in',
    SIGN_OUT: 'pi pi-sign-out',
    SITEMAP: 'pi pi-sitemap',
    SLACK: 'pi pi-slack',
    SLIDERS_H: 'pi pi-sliders-h',
    SLIDERS_V: 'pi pi-sliders-v',
    SORT_ALPHA_DOWN_ALT: 'pi pi-sort-alpha-down-alt',
    SORT_ALPHA_DOWN: 'pi pi-sort-alpha-down',
    SORT_ALPHA_UP_ALT: 'pi pi-sort-alpha-up-alt',
    SORT_ALPHA_UP: 'pi pi-sort-alpha-up',
    SORT_ALT_SLASH: 'pi pi-sort-alt-slash',
    SORT_ALT: 'pi pi-sort-alt',
    SORT_AMOUNT_DOWN_ALT: 'pi pi-sort-amount-down-alt',
    SORT_AMOUNT_DOWN: 'pi pi-sort-amount-down',
    SORT_AMOUNT_UP_ALT: 'pi pi-sort-amount-up-alt',
    SORT_AMOUNT_UP: 'pi pi-sort-amount-up',
    SORT_DOWN_FILL: 'pi pi-sort-down-fill',
    SORT_DOWN: 'pi pi-sort-down',
    SORT_NUMERIC_DOWN_ALT: 'pi pi-sort-numeric-down-alt',
    SORT_NUMERIC_DOWN: 'pi pi-sort-numeric-down',
    SORT_NUMERIC_UP_ALT: 'pi pi-sort-numeric-up-alt',
    SORT_NUMERIC_UP: 'pi pi-sort-numeric-up',
    SORT_UP_FILL: 'pi pi-sort-up-fill',
    SORT_UP: 'pi pi-sort-up',
    SORT: 'pi pi-sort',
    SPARKLES: 'pi pi-sparkles',
    SPINNER_DOTTED: 'pi pi-spinner-dotted',
    SPINNER: 'pi pi-spinner',
    STAR_FILL: 'pi pi-star-fill',
    STAR_HALF_FILL: 'pi pi-star-half-fill',
    STAR_HALF: 'pi pi-star-half',
    STAR: 'pi pi-star',
    STEP_BACKWARD_ALT: 'pi pi-step-backward-alt',
    STEP_BACKWARD: 'pi pi-step-backward',
    STEP_FORWARD_ALT: 'pi pi-step-forward-alt',
    STEP_FORWARD: 'pi pi-step-forward',
    STOP_CIRCLE: 'pi pi-stop-circle',
    STOP: 'pi pi-stop',
    STOPWATCH: 'pi pi-stopwatch',
    SUN: 'pi pi-sun',
    SYNC: 'pi pi-sync',
    TABLE: 'pi pi-table',
    TABLET: 'pi pi-tablet',
    TAG: 'pi pi-tag',
    TAGS: 'pi pi-tags',
    TELEGRAM: 'pi pi-telegram',
    TH_LARGE: 'pi pi-th-large',
    THUMBS_DOWN_FILL: 'pi pi-thumbs-down-fill',
    THUMBS_DOWN: 'pi pi-thumbs-down',
    THUMBS_UP_FILL: 'pi pi-thumbs-up-fill',
    THUMBS_UP: 'pi pi-thumbs-up',
    THUMBTACK: 'pi pi-thumbtack',
    TICKET: 'pi pi-ticket',
    TIKTOK: 'pi pi-tiktok',
    TIMES_CIRCLE: 'pi pi-times-circle',
    TIMES: 'pi pi-times',
    TRASH: 'pi pi-trash',
    TROPHY: 'pi pi-trophy',
    TRUCK: 'pi pi-truck',
    TURKISH_LIRA: 'pi pi-turkish-lira',
    TWITCH: 'pi pi-twitch',
    TWITTER: 'pi pi-twitter',
    UNDO: 'pi pi-undo',
    UNLOCK: 'pi pi-unlock',
    UPLOAD: 'pi pi-upload',
    USER_EDIT: 'pi pi-user-edit',
    USER_MINUS: 'pi pi-user-minus',
    USER_PLUS: 'pi pi-user-plus',
    USER: 'pi pi-user',
    USERS: 'pi pi-users',
    VENUS: 'pi pi-venus',
    VERIFIED: 'pi pi-verified',
    VIDEO: 'pi pi-video',
    VIMEO: 'pi pi-vimeo',
    VOLUME_DOWN: 'pi pi-volume-down',
    VOLUME_OFF: 'pi pi-volume-off',
    VOLUME_UP: 'pi pi-volume-up',
    WALLET: 'pi pi-wallet',
    WAREHOUSE: 'pi pi-warehouse',
    WAVE_PULSE: 'pi pi-wave-pulse',
    WHATSAPP: 'pi pi-whatsapp',
    WIFI: 'pi pi-wifi',
    WINDOW_MAXIMIZE: 'pi pi-window-maximize',
    WINDOW_MINIMIZE: 'pi pi-window-minimize',
    WRENCH: 'pi pi-wrench',
    YOUTUBE: 'pi pi-youtube'
  });

  var SortOrder = Object.freeze({
    DESC: -1,
    UNSORTED: 0,
    ASC: 1
  });

  var PrimeReactContext = /*#__PURE__*/React__default["default"].createContext();
  var PrimeReactProvider = function PrimeReactProvider(props) {
    var _props$value, _propsValue$ripple, _propsValue$inputStyl, _propsValue$locale, _propsValue$appendTo, _propsValue$styleCont, _propsValue$cssTransi, _propsValue$autoZInde, _propsValue$hideOverl, _propsValue$nonce, _propsValue$nullSortO, _propsValue$zIndex, _propsValue$ptOptions, _propsValue$pt, _propsValue$unstyled, _propsValue$filterMat;
    var propsValue = (_props$value = props.value) !== null && _props$value !== void 0 ? _props$value : {};
    var _useState = React.useState((_propsValue$ripple = propsValue.ripple) !== null && _propsValue$ripple !== void 0 ? _propsValue$ripple : false),
      _useState2 = _slicedToArray(_useState, 2),
      ripple = _useState2[0],
      setRipple = _useState2[1];
    var _useState3 = React.useState((_propsValue$inputStyl = propsValue.inputStyle) !== null && _propsValue$inputStyl !== void 0 ? _propsValue$inputStyl : 'outlined'),
      _useState4 = _slicedToArray(_useState3, 2),
      inputStyle = _useState4[0],
      setInputStyle = _useState4[1];
    var _useState5 = React.useState((_propsValue$locale = propsValue.locale) !== null && _propsValue$locale !== void 0 ? _propsValue$locale : 'en'),
      _useState6 = _slicedToArray(_useState5, 2),
      locale = _useState6[0],
      setLocale = _useState6[1];
    var _useState7 = React.useState((_propsValue$appendTo = propsValue.appendTo) !== null && _propsValue$appendTo !== void 0 ? _propsValue$appendTo : null),
      _useState8 = _slicedToArray(_useState7, 2),
      appendTo = _useState8[0],
      setAppendTo = _useState8[1];
    var _useState9 = React.useState((_propsValue$styleCont = propsValue.styleContainer) !== null && _propsValue$styleCont !== void 0 ? _propsValue$styleCont : null),
      _useState10 = _slicedToArray(_useState9, 2),
      styleContainer = _useState10[0],
      setStyleContainer = _useState10[1];
    var _useState11 = React.useState((_propsValue$cssTransi = propsValue.cssTransition) !== null && _propsValue$cssTransi !== void 0 ? _propsValue$cssTransi : true),
      _useState12 = _slicedToArray(_useState11, 2),
      cssTransition = _useState12[0],
      setCssTransition = _useState12[1];
    var _useState13 = React.useState((_propsValue$autoZInde = propsValue.autoZIndex) !== null && _propsValue$autoZInde !== void 0 ? _propsValue$autoZInde : true),
      _useState14 = _slicedToArray(_useState13, 2),
      autoZIndex = _useState14[0],
      setAutoZIndex = _useState14[1];
    var _useState15 = React.useState((_propsValue$hideOverl = propsValue.hideOverlaysOnDocumentScrolling) !== null && _propsValue$hideOverl !== void 0 ? _propsValue$hideOverl : false),
      _useState16 = _slicedToArray(_useState15, 2),
      hideOverlaysOnDocumentScrolling = _useState16[0],
      setHideOverlaysOnDocumentScrolling = _useState16[1];
    var _useState17 = React.useState((_propsValue$nonce = propsValue.nonce) !== null && _propsValue$nonce !== void 0 ? _propsValue$nonce : null),
      _useState18 = _slicedToArray(_useState17, 2),
      nonce = _useState18[0],
      setNonce = _useState18[1];
    var _useState19 = React.useState((_propsValue$nullSortO = propsValue.nullSortOrder) !== null && _propsValue$nullSortO !== void 0 ? _propsValue$nullSortO : 1),
      _useState20 = _slicedToArray(_useState19, 2),
      nullSortOrder = _useState20[0],
      setNullSortOrder = _useState20[1];
    var _useState21 = React.useState((_propsValue$zIndex = propsValue.zIndex) !== null && _propsValue$zIndex !== void 0 ? _propsValue$zIndex : {
        modal: 1100,
        overlay: 1000,
        menu: 1000,
        tooltip: 1100,
        toast: 1200
      }),
      _useState22 = _slicedToArray(_useState21, 2),
      zIndex = _useState22[0],
      setZIndex = _useState22[1];
    var _useState23 = React.useState((_propsValue$ptOptions = propsValue.ptOptions) !== null && _propsValue$ptOptions !== void 0 ? _propsValue$ptOptions : {
        mergeSections: true,
        mergeProps: true
      }),
      _useState24 = _slicedToArray(_useState23, 2),
      ptOptions = _useState24[0],
      setPtOptions = _useState24[1];
    var _useState25 = React.useState((_propsValue$pt = propsValue.pt) !== null && _propsValue$pt !== void 0 ? _propsValue$pt : undefined),
      _useState26 = _slicedToArray(_useState25, 2),
      pt = _useState26[0],
      setPt = _useState26[1];
    var _useState27 = React.useState((_propsValue$unstyled = propsValue.unstyled) !== null && _propsValue$unstyled !== void 0 ? _propsValue$unstyled : false),
      _useState28 = _slicedToArray(_useState27, 2),
      unstyled = _useState28[0],
      setUnstyled = _useState28[1];
    var _useState29 = React.useState((_propsValue$filterMat = propsValue.filterMatchModeOptions) !== null && _propsValue$filterMat !== void 0 ? _propsValue$filterMat : {
        text: [FilterMatchMode.STARTS_WITH, FilterMatchMode.CONTAINS, FilterMatchMode.NOT_CONTAINS, FilterMatchMode.ENDS_WITH, FilterMatchMode.EQUALS, FilterMatchMode.NOT_EQUALS],
        numeric: [FilterMatchMode.EQUALS, FilterMatchMode.NOT_EQUALS, FilterMatchMode.LESS_THAN, FilterMatchMode.LESS_THAN_OR_EQUAL_TO, FilterMatchMode.GREATER_THAN, FilterMatchMode.GREATER_THAN_OR_EQUAL_TO],
        date: [FilterMatchMode.DATE_IS, FilterMatchMode.DATE_IS_NOT, FilterMatchMode.DATE_BEFORE, FilterMatchMode.DATE_AFTER]
      }),
      _useState30 = _slicedToArray(_useState29, 2),
      filterMatchModeOptions = _useState30[0],
      setFilterMatchModeOptions = _useState30[1];
    var changeTheme = function changeTheme(currentTheme, newTheme, linkElementId, callback) {
      var _linkElement$parentNo;
      var linkElement = document.getElementById(linkElementId);
      if (!linkElement) {
        throw Error("Element with id ".concat(linkElementId, " not found."));
      }
      var newThemeUrl = linkElement.getAttribute('href').replace(currentTheme, newTheme);
      var newLinkElement = document.createElement('link');
      newLinkElement.setAttribute('rel', 'stylesheet');
      newLinkElement.setAttribute('id', linkElementId);
      newLinkElement.setAttribute('href', newThemeUrl);
      newLinkElement.addEventListener('load', function () {
        if (callback) {
          callback();
        }
      });
      (_linkElement$parentNo = linkElement.parentNode) === null || _linkElement$parentNo === void 0 || _linkElement$parentNo.replaceChild(newLinkElement, linkElement);
    };

    /**
     * @deprecated
     */
    React__default["default"].useEffect(function () {
      PrimeReact$1.ripple = ripple;
    }, [ripple]);

    /**
     * @deprecated
     */
    React__default["default"].useEffect(function () {
      PrimeReact$1.inputStyle = inputStyle;
    }, [inputStyle]);

    /**
     * @deprecated
     */
    React__default["default"].useEffect(function () {
      PrimeReact$1.locale = locale;
    }, [locale]);
    var value = {
      changeTheme: changeTheme,
      ripple: ripple,
      setRipple: setRipple,
      inputStyle: inputStyle,
      setInputStyle: setInputStyle,
      locale: locale,
      setLocale: setLocale,
      appendTo: appendTo,
      setAppendTo: setAppendTo,
      styleContainer: styleContainer,
      setStyleContainer: setStyleContainer,
      cssTransition: cssTransition,
      setCssTransition: setCssTransition,
      autoZIndex: autoZIndex,
      setAutoZIndex: setAutoZIndex,
      hideOverlaysOnDocumentScrolling: hideOverlaysOnDocumentScrolling,
      setHideOverlaysOnDocumentScrolling: setHideOverlaysOnDocumentScrolling,
      nonce: nonce,
      setNonce: setNonce,
      nullSortOrder: nullSortOrder,
      setNullSortOrder: setNullSortOrder,
      zIndex: zIndex,
      setZIndex: setZIndex,
      ptOptions: ptOptions,
      setPtOptions: setPtOptions,
      pt: pt,
      setPt: setPt,
      filterMatchModeOptions: filterMatchModeOptions,
      setFilterMatchModeOptions: setFilterMatchModeOptions,
      unstyled: unstyled,
      setUnstyled: setUnstyled
    };
    return /*#__PURE__*/React__default["default"].createElement(PrimeReactContext.Provider, {
      value: value
    }, props.children);
  };

  var PrimeReact = PrimeReact$1;

  var usePrevious = function usePrevious(newValue) {
    var ref = React__namespace.useRef(null);
    React__namespace.useEffect(function () {
      ref.current = newValue;
      return function () {
        ref.current = null;
      };
    }, [newValue]);
    return ref.current;
  };

  /* eslint-disable */
  var useUnmountEffect = function useUnmountEffect(fn) {
    return React__namespace.useEffect(function () {
      return fn;
    }, []);
  };
  /* eslint-enable */

  var useEventListener = function useEventListener(_ref) {
    var _ref$target = _ref.target,
      target = _ref$target === void 0 ? 'document' : _ref$target,
      type = _ref.type,
      listener = _ref.listener,
      options = _ref.options,
      _ref$when = _ref.when,
      when = _ref$when === void 0 ? true : _ref$when;
    var targetRef = React__namespace.useRef(null);
    var listenerRef = React__namespace.useRef(null);
    var prevListener = usePrevious(listener);
    var prevOptions = usePrevious(options);
    var bind = function bind() {
      var bindOptions = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var bindTarget = bindOptions.target;
      if (ObjectUtils.isNotEmpty(bindTarget)) {
        unbind();
        (bindOptions.when || when) && (targetRef.current = DomHandler.getTargetElement(bindTarget));
      }
      if (!listenerRef.current && targetRef.current) {
        listenerRef.current = function (event) {
          return listener && listener(event);
        };
        targetRef.current.addEventListener(type, listenerRef.current, options);
      }
    };
    var unbind = function unbind() {
      if (listenerRef.current) {
        targetRef.current.removeEventListener(type, listenerRef.current, options);
        listenerRef.current = null;
      }
    };
    var dispose = function dispose() {
      unbind();
      // Prevent memory leak by releasing
      prevListener = null;
      prevOptions = null;
    };
    var updateTarget = React__namespace.useCallback(function () {
      if (when) {
        targetRef.current = DomHandler.getTargetElement(target);
      } else {
        unbind();
        targetRef.current = null;
      }
      // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [target, when]);
    React__namespace.useEffect(function () {
      updateTarget();
    }, [updateTarget]);
    React__namespace.useEffect(function () {
      var listenerChanged = "".concat(prevListener) !== "".concat(listener);
      var optionsChanged = prevOptions !== options;
      var listenerExists = listenerRef.current;
      if (listenerExists && (listenerChanged || optionsChanged)) {
        unbind();
        when && bind();
      } else if (!listenerExists) {
        dispose();
      }
      // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [listener, options, when]);
    useUnmountEffect(function () {
      dispose();
    });
    return [bind, unbind];
  };

  var useClickOutside = function useClickOutside(ref, callback) {
    var isOutsideClicked = function isOutsideClicked(event) {
      if (!ref.current || ref.current.contains(event.target)) {
        return;
      }
      callback(event);
    };
    var _useEventListener = useEventListener({
        type: 'mousedown',
        listener: isOutsideClicked
      }),
      _useEventListener2 = _slicedToArray(_useEventListener, 2),
      bindMouseDownListener = _useEventListener2[0],
      unbindMouseDownListener = _useEventListener2[1];
    var _useEventListener3 = useEventListener({
        type: 'touchstart',
        listener: isOutsideClicked
      }),
      _useEventListener4 = _slicedToArray(_useEventListener3, 2),
      bindTouchStartListener = _useEventListener4[0],
      unbindTouchStartListener = _useEventListener4[1];
    React__namespace.useEffect(function () {
      if (!ref.current) {
        return;
      }
      bindMouseDownListener();
      bindTouchStartListener();
      return function () {
        unbindMouseDownListener();
        unbindTouchStartListener();
      };
    });
    return [ref, callback];
  };

  var useCounter = function useCounter() {
    var initialValue = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {
      step: 1
    };
    var _React$useState = React__namespace.useState(initialValue),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      count = _React$useState2[0],
      setCount = _React$useState2[1];
    var increment = function increment() {
      if (options.max && count >= options.max) {
        return;
      }
      setCount(count + options.step);
    };
    var decrement = function decrement() {
      if (options.min || options.min === 0 && count <= options.min) {
        return null;
      }
      setCount(count - options.step);
    };
    var reset = function reset() {
      setCount(0);
    };
    return {
      count: count,
      increment: increment,
      decrement: decrement,
      reset: reset
    };
  };

  var useDebounce = function useDebounce(initialValue, delay) {
    var _React$useState = React__namespace.useState(initialValue),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      inputValue = _React$useState2[0],
      setInputValue = _React$useState2[1];
    var _React$useState3 = React__namespace.useState(initialValue),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      debouncedValue = _React$useState4[0],
      setDebouncedValue = _React$useState4[1];
    var mountedRef = React__namespace.useRef(false);
    var timeoutRef = React__namespace.useRef(null);
    var cancelTimer = function cancelTimer() {
      return window.clearTimeout(timeoutRef.current);
    };
    useMountEffect(function () {
      mountedRef.current = true;
    });
    useUnmountEffect(function () {
      cancelTimer();
    });
    React__namespace.useEffect(function () {
      if (!mountedRef.current) {
        return;
      }
      cancelTimer();
      timeoutRef.current = window.setTimeout(function () {
        setDebouncedValue(inputValue);
      }, delay);
    }, [inputValue, delay]);
    return [inputValue, debouncedValue, setInputValue];
  };

  var groupToDisplayedElements = {};
  var useDisplayOrder = function useDisplayOrder(group) {
    var isVisible = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
    var _React$useState = React__namespace.useState(function () {
        return UniqueComponentId();
      }),
      _React$useState2 = _slicedToArray(_React$useState, 1),
      uid = _React$useState2[0];
    var _React$useState3 = React__namespace.useState(0),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      displayOrder = _React$useState4[0],
      setDisplayOrder = _React$useState4[1];
    React__namespace.useEffect(function () {
      if (isVisible) {
        if (!groupToDisplayedElements[group]) {
          groupToDisplayedElements[group] = [];
        }
        var newDisplayOrder = groupToDisplayedElements[group].push(uid);
        setDisplayOrder(newDisplayOrder);
        return function () {
          delete groupToDisplayedElements[group][newDisplayOrder - 1];

          // Reduce array length, by removing undefined elements at the end of array:
          var lastIndex = groupToDisplayedElements[group].length - 1;
          var lastOrder = ObjectUtils.findLastIndex(groupToDisplayedElements[group], function (el) {
            return el !== undefined;
          });
          if (lastOrder !== lastIndex) {
            groupToDisplayedElements[group].splice(lastOrder + 1);
          }
          setDisplayOrder(undefined);
        };
      }
    }, [group, uid, isVisible]);
    return displayOrder;
  };

  var TYPE_MAP = {
    ico: 'image/x-icon',
    png: 'image/png',
    svg: 'image/svg+xml',
    gif: 'image/gif'
  };
  var useFavicon = function useFavicon() {
    var newIcon = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
    var rel = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'shortcut icon';
    React__namespace.useLayoutEffect(function () {
      if (newIcon) {
        var linkElements = document.querySelectorAll("link[rel*='icon']");
        linkElements.forEach(function (linkEl) {
          document.head.removeChild(linkEl);
        });
        var link = document.createElement('link');
        link.setAttribute('type', TYPE_MAP[newIcon.split('.').pop()]);
        link.setAttribute('rel', rel);
        link.setAttribute('href', newIcon);
        document.head.appendChild(link);
      }
    }, [newIcon, rel]);
  };

  /**
   * Priorities of different components (bigger number handled first)
   */
  var ESC_KEY_HANDLING_PRIORITIES = {
    SIDEBAR: 100,
    SLIDE_MENU: 200,
    DIALOG: 300,
    IMAGE: 400,
    MENU: 500,
    OVERLAY_PANEL: 600,
    PASSWORD: 700,
    CASCADE_SELECT: 800,
    SPLIT_BUTTON: 900,
    SPEED_DIAL: 1000,
    TOOLTIP: 1200
  };

  /**
   * Object, that manages global escape key handling logic
   */
  var globalEscKeyHandlingLogic = {
    /**
     * Mapping from ESC_KEY_HANDLING_PRIORITY to array of related listeners, grouped by priority
     * @example
     * Map<{
     *     [ESC_KEY_HANDLING_PRIORITIES.SIDEBAR]: Map<{
     *         1: () => {...},
     *         2: () => {...}
     *     }>,
     *     [ESC_KEY_HANDLING_PRIORITIES.DIALOG]: Map<{
     *         1: () => {...},
     *         2: () => {...}
     *     }>
     * }>;
     */
    escKeyListeners: new Map(),
    /**
     * Keydown handler (attached to any keydown)
     */
    onGlobalKeyDown: function onGlobalKeyDown(event) {
      // Do nothing if not an "esc" key is pressed:
      if (event.code !== 'Escape') {
        return;
      }
      var escKeyListeners = globalEscKeyHandlingLogic.escKeyListeners;
      var maxPrimaryPriority = Math.max.apply(Math, _toConsumableArray(escKeyListeners.keys()));
      var theMostImportantEscHandlersSet = escKeyListeners.get(maxPrimaryPriority);
      var maxSecondaryPriority = Math.max.apply(Math, _toConsumableArray(theMostImportantEscHandlersSet.keys()));
      var theMostImportantEscHandler = theMostImportantEscHandlersSet.get(maxSecondaryPriority);
      theMostImportantEscHandler(event);
    },
    /**
     * Attach global keydown listener if there are any "esc" key handlers assigned,
     * otherwise detach.
     */
    refreshGlobalKeyDownListener: function refreshGlobalKeyDownListener() {
      var document = DomHandler.getTargetElement('document');
      if (this.escKeyListeners.size > 0) {
        document.addEventListener('keydown', this.onGlobalKeyDown);
      } else {
        document.removeEventListener('keydown', this.onGlobalKeyDown);
      }
    },
    /**
     * Add "Esc" key handler
     */
    addListener: function addListener(callback, _ref) {
      var _this = this;
      var _ref2 = _slicedToArray(_ref, 2),
        primaryPriority = _ref2[0],
        secondaryPriority = _ref2[1];
      var escKeyListeners = this.escKeyListeners;
      if (!escKeyListeners.has(primaryPriority)) {
        escKeyListeners.set(primaryPriority, new Map());
      }
      var primaryPriorityListeners = escKeyListeners.get(primaryPriority);

      // To prevent unexpected override of callback:
      if (primaryPriorityListeners.has(secondaryPriority)) {
        throw new Error("Unexpected: global esc key listener with priority [".concat(primaryPriority, ", ").concat(secondaryPriority, "] already exists."));
      }
      primaryPriorityListeners.set(secondaryPriority, callback);
      this.refreshGlobalKeyDownListener();
      return function () {
        primaryPriorityListeners["delete"](secondaryPriority);
        if (primaryPriorityListeners.size === 0) {
          escKeyListeners["delete"](primaryPriority);
        }
        _this.refreshGlobalKeyDownListener();
      };
    }
  };
  var useGlobalOnEscapeKey = function useGlobalOnEscapeKey(_ref3) {
    var callback = _ref3.callback,
      when = _ref3.when,
      priority = _ref3.priority;
    React.useEffect(function () {
      if (!when) {
        return;
      }
      return globalEscKeyHandlingLogic.addListener(callback, priority);
    }, [callback, when, priority]);
  };

  var useIntersectionObserver = function useIntersectionObserver(ref) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var _React$useState = React__namespace.useState(false),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      isElementVisible = _React$useState2[0],
      setIsElementVisible = _React$useState2[1];
    React__namespace.useEffect(function () {
      if (!ref.current) {
        return;
      }
      var observer = new IntersectionObserver(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 1),
          entry = _ref2[0];
        setIsElementVisible(entry.isIntersecting);
      }, options);
      observer.observe(ref.current);
      return function () {
        observer.disconnect();
      };
    }, [options, ref]);
    return isElementVisible;
  };

  /* eslint-disable */
  var useInterval = function useInterval(fn) {
    var delay = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
    var when = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
    var timeout = React__namespace.useRef(null);
    var savedCallback = React__namespace.useRef(null);
    var clear = React__namespace.useCallback(function () {
      return clearInterval(timeout.current);
    }, [timeout.current]);
    React__namespace.useEffect(function () {
      savedCallback.current = fn;
    });
    React__namespace.useEffect(function () {
      function callback() {
        savedCallback.current();
      }
      if (when) {
        timeout.current = setInterval(callback, delay);
        return clear;
      } else {
        clear();
      }
    }, [delay, when]);
    useUnmountEffect(function () {
      clear();
    });
    return [clear];
  };
  /* eslint-enable */

  var useMatchMedia = function useMatchMedia(query) {
    var when = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
    var _React$useState = React__namespace.useState(false),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      matches = _React$useState2[0],
      setMatches = _React$useState2[1];
    var matchMedia = React__namespace.useRef(null);
    var handleChange = function handleChange(e) {
      return setMatches(e.matches);
    };
    var bind = function bind() {
      return matchMedia.current && matchMedia.current.addEventListener('change', handleChange);
    };
    var unbind = function unbind() {
      return matchMedia.current && matchMedia.current.removeEventListener('change', handleChange) && (matchMedia.current = null);
    };
    React__namespace.useEffect(function () {
      if (when) {
        matchMedia.current = window.matchMedia(query);
        setMatches(matchMedia.current.matches);
        bind();
      }
      return unbind;
    }, [query, when]);
    return matches;
  };
  /* eslint-enable */

  /**
   * Hook to merge properties including custom merge function for things like Tailwind merge.
   */
  var useMergeProps = function useMergeProps() {
    var context = React.useContext(PrimeReactContext);
    return function () {
      for (var _len = arguments.length, props = new Array(_len), _key = 0; _key < _len; _key++) {
        props[_key] = arguments[_key];
      }
      return mergeProps(props, context === null || context === void 0 ? void 0 : context.ptOptions);
    };
  };

  /* eslint-disable */

  /**
   * Custom hook to run a mount effect only once.
   * @param {*} fn the callback function
   * @returns the hook
   */
  var useMountEffect = function useMountEffect(fn) {
    var mounted = React__namespace.useRef(false);
    return React__namespace.useEffect(function () {
      if (!mounted.current) {
        mounted.current = true;
        return fn && fn();
      }
    }, []);
  };
  /* eslint-enable */

  function ownKeys$1_(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1_(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1_(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1_(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var useMouse = function useMouse() {
    var _React$useState = React__namespace.useState({
        x: 0,
        y: 0
      }),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      position = _React$useState2[0],
      setPosition = _React$useState2[1];
    var ref = React__namespace.useRef(null);
    var handleMouseMove = React__namespace.useCallback(function (event) {
      var x;
      var y;
      if (ref.current) {
        var rect = event.currentTarget.getBoundingClientRect();
        x = event.pageX - rect.left - (window.pageXOffset || window.scrollX);
        y = event.pageY - rect.top - (window.pageYOffset || window.scrollY);
      } else {
        x = event.clientX;
        y = event.clientY;
      }
      setPosition({
        x: Math.max(0, Math.round(x)),
        y: Math.max(0, Math.round(y))
      });
    }, []);
    var _useEventListener = useEventListener({
        target: ref,
        type: 'mousemove',
        listener: handleMouseMove
      }),
      _useEventListener2 = _slicedToArray(_useEventListener, 2),
      bindMouseMoveEventListener = _useEventListener2[0],
      unbindMouseMoveEventListener = _useEventListener2[1];
    var _useEventListener3 = useEventListener({
        type: 'mousemove',
        listener: handleMouseMove
      }),
      _useEventListener4 = _slicedToArray(_useEventListener3, 2),
      bindDocumentMoveEventListener = _useEventListener4[0],
      unbindDocumentMoveEventListener = _useEventListener4[1];
    var reset = function reset() {
      return setPosition({
        x: 0,
        y: 0
      });
    };
    React__namespace.useEffect(function () {
      bindMouseMoveEventListener();
      if (!ref.current) {
        bindDocumentMoveEventListener();
      }
      return function () {
        unbindMouseMoveEventListener();

        // eslint-disable-next-line react-hooks/exhaustive-deps
        if (!ref.current) {
          unbindDocumentMoveEventListener();
        }
      };
    }, [bindDocumentMoveEventListener, bindMouseMoveEventListener, unbindDocumentMoveEventListener, unbindMouseMoveEventListener]);
    return _objectSpread$1_(_objectSpread$1_({
      ref: ref
    }, position), {}, {
      reset: reset
    });
  };

  function ownKeys$1Z(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1Z(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1Z(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1Z(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  function useMove(_ref) {
    var _ref$mode = _ref.mode,
      mode = _ref$mode === void 0 ? 'both' : _ref$mode,
      _ref$initialValue = _ref.initialValue,
      initialValue = _ref$initialValue === void 0 ? {
        x: 0,
        y: 0
      } : _ref$initialValue;
    var _React$useState = React__namespace.useState(initialValue),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      positions = _React$useState2[0],
      setPositions = _React$useState2[1];
    var _React$useState3 = React__namespace.useState(false),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      active = _React$useState4[0],
      setActive = _React$useState4[1];
    var isMounted = React__namespace.useRef(false);
    var isSliding = React__namespace.useRef(false);
    var ref = React__namespace.useRef(null);
    var onMouseMove = function onMouseMove(event) {
      return updateMousePosition({
        x: event.clientX,
        y: event.clientY
      });
    };
    var handlePositionChange = function handlePositionChange(_ref2) {
      var clampedX = _ref2.clampedX,
        clampedY = _ref2.clampedY;
      if (mode === 'vertical') {
        setPositions({
          y: 1 - clampedY
        });
      } else if (mode === 'horizontal') {
        setPositions({
          x: clampedX
        });
      } else if (mode === 'both') {
        setPositions({
          x: clampedX,
          y: clampedY
        });
      }
    };
    var onMouseDown = function onMouseDown(event) {
      startScrubbing();
      event.preventDefault();
      onMouseMove(event);
    };
    var stopScrubbing = function stopScrubbing() {
      if (isSliding.current && isMounted.current) {
        isSliding.current = false;
        setActive(false);
        unbindListeners();
      }
    };
    var onTouchMove = function onTouchMove(event) {
      if (event.cancelable) {
        event.preventDefault();
      }
      updateMousePosition({
        x: event.changedTouches[0].clientX,
        y: event.changedTouches[0].clientY
      });
    };
    var onTouchStart = function onTouchStart(event) {
      if (event.cancelable) {
        event.preventDefault();
      }
      startScrubbing();
      onTouchMove(event);
    };
    var _useEventListener = useEventListener({
        type: 'mousemove',
        listener: onMouseMove
      }),
      _useEventListener2 = _slicedToArray(_useEventListener, 2),
      bindDocumentMouseMoveListener = _useEventListener2[0],
      unbindDocumentMouseMoveListener = _useEventListener2[1];
    var _useEventListener3 = useEventListener({
        type: 'mouseup',
        listener: stopScrubbing
      }),
      _useEventListener4 = _slicedToArray(_useEventListener3, 2),
      bindDocumentMouseUpListener = _useEventListener4[0],
      unbindDocumentMouseUpListener = _useEventListener4[1];
    var _useEventListener5 = useEventListener({
        type: 'touchmove',
        listener: onTouchMove
      }),
      _useEventListener6 = _slicedToArray(_useEventListener5, 2),
      bindDocumentTouchMoveListener = _useEventListener6[0],
      unbindDocumentTouchMoveListener = _useEventListener6[1];
    var _useEventListener7 = useEventListener({
        type: 'touchend',
        listener: stopScrubbing
      }),
      _useEventListener8 = _slicedToArray(_useEventListener7, 2),
      bindDocumentTouchEndListener = _useEventListener8[0],
      unbindDocumentTouchEndListener = _useEventListener8[1];
    var _useEventListener9 = useEventListener({
        target: ref,
        type: 'mousedown',
        listener: onMouseDown
      }),
      _useEventListener10 = _slicedToArray(_useEventListener9, 2),
      bindMouseDownListener = _useEventListener10[0],
      unbindMouseDownListener = _useEventListener10[1];
    var _useEventListener11 = useEventListener({
        target: ref,
        type: 'touchstart',
        listener: onTouchStart,
        options: {
          passive: false
        }
      }),
      _useEventListener12 = _slicedToArray(_useEventListener11, 2),
      bindTouchStartListener = _useEventListener12[0],
      unbindTouchStartListener = _useEventListener12[1];
    var clamp = function clamp(value, min, max) {
      return Math.min(Math.max(value, min), max);
    };
    var clampPositions = function clampPositions(_ref3) {
      var x = _ref3.x,
        y = _ref3.y;
      return {
        clampedX: clamp(x, 0, 1),
        clampedY: clamp(y, 0, 1)
      };
    };
    var bindListeners = function bindListeners() {
      bindDocumentMouseMoveListener();
      bindDocumentMouseUpListener();
      bindDocumentTouchMoveListener();
      bindDocumentTouchEndListener();
    };
    var unbindListeners = function unbindListeners() {
      unbindDocumentMouseMoveListener();
      unbindDocumentMouseUpListener();
      unbindDocumentTouchMoveListener();
      unbindDocumentTouchEndListener();
    };
    var reset = function reset() {
      setPositions(initialValue);
    };
    React__namespace.useEffect(function () {
      isMounted.current = true;
    }, []);
    var startScrubbing = function startScrubbing() {
      if (!isSliding.current && isMounted.current) {
        isSliding.current = true;
        setActive(true);
        bindListeners();
      }
    };
    var updateMousePosition = function updateMousePosition(_ref4) {
      var x = _ref4.x,
        y = _ref4.y;
      if (isSliding.current) {
        var rect = ref.current.getBoundingClientRect();
        var _clampPositions = clampPositions({
            x: (x - rect.left) / rect.width,
            y: (y - rect.top) / rect.height
          }),
          clampedX = _clampPositions.clampedX,
          clampedY = _clampPositions.clampedY;
        handlePositionChange({
          clampedX: clampedX,
          clampedY: clampedY
        });
      }
    };
    React__namespace.useEffect(function () {
      if (ref.current) {
        bindMouseDownListener();
        bindTouchStartListener();
      }
      return function () {
        if (ref.current) {
          unbindMouseDownListener();
          unbindTouchStartListener();
        }
      };
    }, [bindMouseDownListener, bindTouchStartListener, positions, unbindMouseDownListener, unbindTouchStartListener]);
    return _objectSpread$1Z(_objectSpread$1Z({
      ref: ref
    }, positions), {}, {
      active: active,
      reset: reset
    });
  }

  var useOverlayScrollListener = function useOverlayScrollListener(_ref) {
    var target = _ref.target,
      listener = _ref.listener,
      options = _ref.options,
      _ref$when = _ref.when,
      when = _ref$when === void 0 ? true : _ref$when;
    var context = React__namespace.useContext(PrimeReactContext);
    var targetRef = React__namespace.useRef(null);
    var listenerRef = React__namespace.useRef(null);
    var scrollableParentsRef = React__namespace.useRef([]);
    var prevListener = usePrevious(listener);
    var prevOptions = usePrevious(options);
    var bind = function bind() {
      var bindOptions = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      if (ObjectUtils.isNotEmpty(bindOptions.target)) {
        unbind();
        (bindOptions.when || when) && (targetRef.current = DomHandler.getTargetElement(bindOptions.target));
      }
      if (!listenerRef.current && targetRef.current) {
        var hideOnScroll = context ? context.hideOverlaysOnDocumentScrolling : PrimeReact.hideOverlaysOnDocumentScrolling;
        var nodes = scrollableParentsRef.current = DomHandler.getScrollableParents(targetRef.current);

        // Ensure window/body is always included as fallback
        if (!nodes.some(function (node) {
          return node === document.body || node === window;
        })) {
          nodes.push(hideOnScroll ? window : document.body);
        }
        listenerRef.current = function (event) {
          return listener && listener(event);
        };
        nodes.forEach(function (node) {
          return node.addEventListener('scroll', listenerRef.current, options);
        });
      }
    };
    var unbind = function unbind() {
      if (listenerRef.current) {
        var nodes = scrollableParentsRef.current;
        nodes.forEach(function (node) {
          return node.removeEventListener('scroll', listenerRef.current, options);
        });
        listenerRef.current = null;
      }
    };
    var dispose = function dispose() {
      unbind();
      // #5927 prevent memory leak by releasing
      scrollableParentsRef.current = null;
      prevListener = null;
      prevOptions = null;
    };
    var updateTarget = React__namespace.useCallback(function () {
      if (when) {
        targetRef.current = DomHandler.getTargetElement(target);
      } else {
        unbind();
        targetRef.current = null;
      }
      // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [target, when]);
    React__namespace.useEffect(function () {
      updateTarget();
    }, [updateTarget]);
    React__namespace.useEffect(function () {
      var listenerChanged = "".concat(prevListener) !== "".concat(listener);
      var optionsChanged = prevOptions !== options;
      var listenerExists = listenerRef.current;
      if (listenerExists && (listenerChanged || optionsChanged)) {
        unbind();
        when && bind();
      } else if (!listenerExists) {
        dispose();
      }
      // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [listener, options, when]);
    useUnmountEffect(function () {
      dispose();
    });
    return [bind, unbind];
  };

  var useResizeListener = function useResizeListener(_ref) {
    var listener = _ref.listener,
      _ref$when = _ref.when,
      when = _ref$when === void 0 ? true : _ref$when;
    return useEventListener({
      target: 'window',
      type: 'resize',
      listener: listener,
      when: when
    });
  };

  var useOverlayListener = function useOverlayListener(_ref) {
    var target = _ref.target,
      overlay = _ref.overlay,
      _listener = _ref.listener,
      _ref$when = _ref.when,
      when = _ref$when === void 0 ? true : _ref$when,
      _ref$type = _ref.type,
      type = _ref$type === void 0 ? 'click' : _ref$type;
    var targetRef = React__namespace.useRef(null);
    var overlayRef = React__namespace.useRef(null);

    /**
     * The parameters of the 'listener' method in the following event handlers;
     * @param {Event} event A click event of the document.
     * @param {string} options.type The custom type to detect event.
     * @param {boolean} options.valid It is controlled by PrimeReact. It is determined whether it is valid or not according to some custom validation.
     */
    var _useEventListener = useEventListener({
        target: 'window',
        type: type,
        listener: function listener(event) {
          _listener && _listener(event, {
            type: 'outside',
            valid: event.which !== 3 && isOutsideClicked(event)
          });
        },
        when: when
      }),
      _useEventListener2 = _slicedToArray(_useEventListener, 2),
      bindDocumentClickListener = _useEventListener2[0],
      unbindDocumentClickListener = _useEventListener2[1];
    var _useResizeListener = useResizeListener({
        listener: function listener(event) {
          _listener && _listener(event, {
            type: 'resize',
            valid: !DomHandler.isTouchDevice()
          });
        },
        when: when
      }),
      _useResizeListener2 = _slicedToArray(_useResizeListener, 2),
      bindWindowResizeListener = _useResizeListener2[0],
      unbindWindowResizeListener = _useResizeListener2[1];
    var _useEventListener3 = useEventListener({
        target: 'window',
        type: 'orientationchange',
        listener: function listener(event) {
          _listener && _listener(event, {
            type: 'orientationchange',
            valid: true
          });
        },
        when: when
      }),
      _useEventListener4 = _slicedToArray(_useEventListener3, 2),
      bindWindowOrientationChangeListener = _useEventListener4[0],
      unbindWindowOrientationChangeListener = _useEventListener4[1];
    var _useOverlayScrollList = useOverlayScrollListener({
        target: target,
        listener: function listener(event) {
          _listener && _listener(event, {
            type: 'scroll',
            valid: true
          });
        },
        when: when
      }),
      _useOverlayScrollList2 = _slicedToArray(_useOverlayScrollList, 2),
      bindOverlayScrollListener = _useOverlayScrollList2[0],
      unbindOverlayScrollListener = _useOverlayScrollList2[1];
    var isOutsideClicked = function isOutsideClicked(event) {
      return targetRef.current && !(targetRef.current.isSameNode(event.target) || targetRef.current.contains(event.target) || overlayRef.current && overlayRef.current.contains(event.target));
    };
    var bind = function bind() {
      bindDocumentClickListener();
      bindWindowResizeListener();
      bindWindowOrientationChangeListener();
      bindOverlayScrollListener();
    };
    var unbind = function unbind() {
      unbindDocumentClickListener();
      unbindWindowResizeListener();
      unbindWindowOrientationChangeListener();
      unbindOverlayScrollListener();
    };
    React__namespace.useEffect(function () {
      if (when) {
        targetRef.current = DomHandler.getTargetElement(target);
        overlayRef.current = DomHandler.getTargetElement(overlay);
      } else {
        unbind();
        targetRef.current = overlayRef.current = null;
      }
    }, [target, overlay, when]);
    useUnmountEffect(function () {
      unbind();
    });
    return [bind, unbind];
  };
  /* eslint-enable */

  /**
   * Hook to wrap around useState that stores the value in the browser local/session storage.
   *
   * @param {any} initialValue the initial value to store
   * @param {string} key the key to store the value in local/session storage
   * @param {string} storage either 'local' or 'session' for what type of storage
   * @returns a stateful value, and a function to update it.
   */
  var useStorage = function useStorage(initialValue, key) {
    var storage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'local';
    // Since the local storage API isn't available in server-rendering environments,
    // we check that typeof window !== 'undefined' to make SSR and SSG work properly.
    var storageAvailable = typeof window !== 'undefined';

    // subscribe to window storage event so changes in one tab to a stored value
    // are properly reflected in all tabs
    var _useEventListener = useEventListener({
        target: 'window',
        type: 'storage',
        listener: function listener(event) {
          var area = storage === 'local' ? window.localStorage : window.sessionStorage;
          if (event.storageArea === area && event.key === key) {
            var newValue = event.newValue ? JSON.parse(event.newValue) : undefined;
            setStoredValue(newValue);
          }
        }
      }),
      _useEventListener2 = _slicedToArray(_useEventListener, 2),
      bindWindowStorageListener = _useEventListener2[0],
      unbindWindowStorageListener = _useEventListener2[1];
    var _React$useState = React__namespace.useState(initialValue),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      storedValue = _React$useState2[0],
      setStoredValue = _React$useState2[1];
    var setValue = function setValue(value) {
      try {
        // Allow value to be a function so we have same API as useState
        var valueToStore = value instanceof Function ? value(storedValue) : value;
        setStoredValue(valueToStore);
        if (storageAvailable) {
          var serializedValue = JSON.stringify(valueToStore);
          storage === 'local' ? window.localStorage.setItem(key, serializedValue) : window.sessionStorage.setItem(key, serializedValue);
        }
      } catch (error) {
        throw new Error("PrimeReact useStorage: Failed to serialize the value at key: ".concat(key));
      }
    };
    React__namespace.useEffect(function () {
      if (!storageAvailable) {
        setStoredValue(initialValue);
      }
      try {
        var item = storage === 'local' ? window.localStorage.getItem(key) : window.sessionStorage.getItem(key);
        setStoredValue(item ? JSON.parse(item) : initialValue);
      } catch (error) {
        // If error also return initialValue
        setStoredValue(initialValue);
      }
      bindWindowStorageListener();
      return function () {
        return unbindWindowStorageListener();
      };
    }, []);
    return [storedValue, setValue];
  };

  /**
   * Hook to wrap around useState that stores the value in the browser local storage.
   *
   * @param {any} initialValue the initial value to store
   * @param {string} key the key to store the value in local storage
   * @returns a stateful value, and a function to update it.
   */
  var useLocalStorage = function useLocalStorage(initialValue, key) {
    return useStorage(initialValue, key, 'local');
  };

  /**
   * Hook to wrap around useState that stores the value in the browser session storage.
   *
   * @param {any} initialValue the initial value to store
   * @param {string} key the key to store the value in session storage
   * @returns a stateful value, and a function to update it.
   */
  var useSessionStorage = function useSessionStorage(initialValue, key) {
    return useStorage(initialValue, key, 'session');
  };
  /* eslint-enable */

  var _id = 0;
  var useStyle = function useStyle(css) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var _useState = React.useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      isLoaded = _useState2[0],
      setIsLoaded = _useState2[1];
    var styleRef = React.useRef(null);
    var context = React.useContext(PrimeReactContext);
    var defaultDocument = DomHandler.isClient() ? window.document : undefined;
    var _options$document = options.document,
      document = _options$document === void 0 ? defaultDocument : _options$document,
      _options$manual = options.manual,
      manual = _options$manual === void 0 ? false : _options$manual,
      _options$name = options.name,
      name = _options$name === void 0 ? "style_".concat(++_id) : _options$name,
      _options$id = options.id,
      id = _options$id === void 0 ? undefined : _options$id,
      _options$media = options.media,
      media = _options$media === void 0 ? undefined : _options$media;
    var getCurrentStyleRef = function getCurrentStyleRef(styleContainer) {
      var existingStyle = styleContainer.querySelector("style[data-primereact-style-id=\"".concat(name, "\"]"));
      if (existingStyle) {
        return existingStyle;
      }
      if (id !== undefined) {
        var existingElement = document.getElementById(id);
        if (existingElement) {
          return existingElement;
        }
      }

      // finally if not found create the new style
      return document.createElement('style');
    };
    var update = function update(newCSS) {
      isLoaded && css !== newCSS && (styleRef.current.textContent = newCSS);
    };
    var load = function load() {
      if (!document || isLoaded) {
        return;
      }
      var styleContainer = (context === null || context === void 0 ? void 0 : context.styleContainer) || document.head;
      styleRef.current = getCurrentStyleRef(styleContainer);
      if (!styleRef.current.isConnected) {
        styleRef.current.type = 'text/css';
        if (id) {
          styleRef.current.id = id;
        }
        if (media) {
          styleRef.current.media = media;
        }
        DomHandler.addNonce(styleRef.current, context && context.nonce || PrimeReact.nonce);
        styleContainer.appendChild(styleRef.current);
        if (name) {
          styleRef.current.setAttribute('data-primereact-style-id', name);
        }
      }
      styleRef.current.textContent = css;
      setIsLoaded(true);
    };
    var unload = function unload() {
      if (!document || !styleRef.current) {
        return;
      }
      DomHandler.removeInlineStyle(styleRef.current);
      setIsLoaded(false);
    };
    React.useEffect(function () {
      if (!manual) {
        load();
      }

      // return () => {if (!manual) unload()}; /* @todo */
      // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [manual]);
    return {
      id: id,
      name: name,
      update: update,
      unload: unload,
      load: load,
      isLoaded: isLoaded
    };
  };

  /* eslint-disable */
  var useTimeout = function useTimeout(fn) {
    var delay = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
    var when = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
    var timeout = React__namespace.useRef(null);
    var savedCallback = React__namespace.useRef(null);
    var clear = React__namespace.useCallback(function () {
      return clearTimeout(timeout.current);
    }, [timeout.current]);
    React__namespace.useEffect(function () {
      savedCallback.current = fn;
    });
    React__namespace.useEffect(function () {
      function callback() {
        savedCallback.current();
      }
      if (when) {
        timeout.current = setTimeout(callback, delay);
        return clear;
      } else {
        clear();
      }
    }, [delay, when]);
    useUnmountEffect(function () {
      clear();
    });
    return [clear];
  };
  /* eslint-enable */

  /* eslint-disable */
  var useUpdateEffect = function useUpdateEffect(fn, deps) {
    var mounted = React__namespace.useRef(false);
    return React__namespace.useEffect(function () {
      if (!mounted.current) {
        mounted.current = true;
        return;
      }
      return fn && fn();
    }, deps);
  };
  /* eslint-enable */

  function ownKeys$1Y(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1Y(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1Y(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1Y(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var baseStyle = "\n.p-hidden-accessible {\n    border: 0;\n    clip: rect(0 0 0 0);\n    height: 1px;\n    margin: -1px;\n    opacity: 0;\n    overflow: hidden;\n    padding: 0;\n    pointer-events: none;\n    position: absolute;\n    white-space: nowrap;\n    width: 1px;\n}\n\n.p-overflow-hidden {\n    overflow: hidden;\n    padding-right: var(--scrollbar-width);\n}\n";
  var buttonStyles = "\n.p-button {\n    margin: 0;\n    display: inline-flex;\n    cursor: pointer;\n    user-select: none;\n    align-items: center;\n    vertical-align: bottom;\n    text-align: center;\n    overflow: hidden;\n    position: relative;\n}\n\n.p-button-label {\n    flex: 1 1 auto;\n}\n\n.p-button-icon-right {\n    order: 1;\n}\n\n.p-button:disabled {\n    cursor: default;\n}\n\n.p-button-icon-only {\n    justify-content: center;\n}\n\n.p-button-icon-only .p-button-label {\n    visibility: hidden;\n    width: 0;\n    flex: 0 0 auto;\n}\n\n.p-button-vertical {\n    flex-direction: column;\n}\n\n.p-button-icon-bottom {\n    order: 2;\n}\n\n.p-button-group .p-button {\n    margin: 0;\n}\n\n.p-button-group .p-button:not(:last-child) {\n    border-right: 0 none;\n}\n\n.p-button-group .p-button:not(:first-of-type):not(:last-of-type) {\n    border-radius: 0;\n}\n\n.p-button-group .p-button:first-of-type {\n    border-top-right-radius: 0;\n    border-bottom-right-radius: 0;\n}\n\n.p-button-group .p-button:last-of-type {\n    border-top-left-radius: 0;\n    border-bottom-left-radius: 0;\n}\n\n.p-button-group .p-button:focus {\n    position: relative;\n    z-index: 1;\n}\n\n.p-button-group-single .p-button:first-of-type {\n    border-top-right-radius: var(--border-radius) !important;\n    border-bottom-right-radius: var(--border-radius) !important;\n}\n\n.p-button-group-single .p-button:last-of-type {\n    border-top-left-radius: var(--border-radius) !important;\n    border-bottom-left-radius: var(--border-radius) !important;\n}\n";
  var inputTextStyles = "\n.p-inputtext {\n    margin: 0;\n}\n\n.p-fluid .p-inputtext {\n    width: 100%;\n}\n\n/* InputGroup */\n.p-inputgroup {\n    display: flex;\n    align-items: stretch;\n    width: 100%;\n}\n\n.p-inputgroup-addon {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n}\n\n.p-inputgroup .p-float-label {\n    display: flex;\n    align-items: stretch;\n    width: 100%;\n}\n\n.p-inputgroup .p-inputtext,\n.p-fluid .p-inputgroup .p-inputtext,\n.p-inputgroup .p-inputwrapper,\n.p-fluid .p-inputgroup .p-input {\n    flex: 1 1 auto;\n    width: 1%;\n}\n\n/* Floating Label */\n.p-float-label {\n    display: block;\n    position: relative;\n}\n\n.p-float-label label {\n    position: absolute;\n    pointer-events: none;\n    top: 50%;\n    margin-top: -0.5rem;\n    transition-property: all;\n    transition-timing-function: ease;\n    line-height: 1;\n}\n\n.p-float-label textarea ~ label,\n.p-float-label .p-mention ~ label {\n    top: 1rem;\n}\n\n.p-float-label input:focus ~ label,\n.p-float-label input:-webkit-autofill ~ label,\n.p-float-label input.p-filled ~ label,\n.p-float-label textarea:focus ~ label,\n.p-float-label textarea.p-filled ~ label,\n.p-float-label .p-inputwrapper-focus ~ label,\n.p-float-label .p-inputwrapper-filled ~ label,\n.p-float-label .p-tooltip-target-wrapper ~ label {\n    top: -0.75rem;\n    font-size: 12px;\n}\n\n.p-float-label .p-placeholder,\n.p-float-label input::placeholder,\n.p-float-label .p-inputtext::placeholder {\n    opacity: 0;\n    transition-property: all;\n    transition-timing-function: ease;\n}\n\n.p-float-label .p-focus .p-placeholder,\n.p-float-label input:focus::placeholder,\n.p-float-label .p-inputtext:focus::placeholder {\n    opacity: 1;\n    transition-property: all;\n    transition-timing-function: ease;\n}\n\n.p-input-icon-left,\n.p-input-icon-right {\n    position: relative;\n    display: inline-block;\n}\n\n.p-input-icon-left > i,\n.p-input-icon-right > i,\n.p-input-icon-left > svg,\n.p-input-icon-right > svg,\n.p-input-icon-left > .p-input-prefix,\n.p-input-icon-right > .p-input-suffix {\n    position: absolute;\n    top: 50%;\n    margin-top: -0.5rem;\n}\n\n.p-fluid .p-input-icon-left,\n.p-fluid .p-input-icon-right {\n    display: block;\n    width: 100%;\n}\n";
  var iconStyles = "\n.p-icon {\n    display: inline-block;\n}\n\n.p-icon-spin {\n    -webkit-animation: p-icon-spin 2s infinite linear;\n    animation: p-icon-spin 2s infinite linear;\n}\n\nsvg.p-icon {\n    pointer-events: auto;\n}\n\nsvg.p-icon g,\n.p-disabled svg.p-icon {\n    pointer-events: none;\n}\n\n@-webkit-keyframes p-icon-spin {\n    0% {\n        -webkit-transform: rotate(0deg);\n        transform: rotate(0deg);\n    }\n    100% {\n        -webkit-transform: rotate(359deg);\n        transform: rotate(359deg);\n    }\n}\n\n@keyframes p-icon-spin {\n    0% {\n        -webkit-transform: rotate(0deg);\n        transform: rotate(0deg);\n    }\n    100% {\n        -webkit-transform: rotate(359deg);\n        transform: rotate(359deg);\n    }\n}\n";
  var commonStyle = "\n@layer primereact {\n    .p-component, .p-component * {\n        box-sizing: border-box;\n    }\n\n    .p-hidden {\n        display: none;\n    }\n\n    .p-hidden-space {\n        visibility: hidden;\n    }\n\n    .p-reset {\n        margin: 0;\n        padding: 0;\n        border: 0;\n        outline: 0;\n        text-decoration: none;\n        font-size: 100%;\n        list-style: none;\n    }\n\n    .p-disabled, .p-disabled * {\n        cursor: default;\n        pointer-events: none;\n        user-select: none;\n    }\n\n    .p-component-overlay {\n        position: fixed;\n        top: 0;\n        left: 0;\n        width: 100%;\n        height: 100%;\n    }\n\n    .p-unselectable-text {\n        user-select: none;\n    }\n\n    .p-scrollbar-measure {\n        width: 100px;\n        height: 100px;\n        overflow: scroll;\n        position: absolute;\n        top: -9999px;\n    }\n\n    @-webkit-keyframes p-fadein {\n      0%   { opacity: 0; }\n      100% { opacity: 1; }\n    }\n    @keyframes p-fadein {\n      0%   { opacity: 0; }\n      100% { opacity: 1; }\n    }\n\n    .p-link {\n        text-align: left;\n        background-color: transparent;\n        margin: 0;\n        padding: 0;\n        border: none;\n        cursor: pointer;\n        user-select: none;\n    }\n\n    .p-link:disabled {\n        cursor: default;\n    }\n\n    /* Non react overlay animations */\n    .p-connected-overlay {\n        opacity: 0;\n        transform: scaleY(0.8);\n        transition: transform .12s cubic-bezier(0, 0, 0.2, 1), opacity .12s cubic-bezier(0, 0, 0.2, 1);\n    }\n\n    .p-connected-overlay-visible {\n        opacity: 1;\n        transform: scaleY(1);\n    }\n\n    .p-connected-overlay-hidden {\n        opacity: 0;\n        transform: scaleY(1);\n        transition: opacity .1s linear;\n    }\n\n    /* React based overlay animations */\n    .p-connected-overlay-enter {\n        opacity: 0;\n        transform: scaleY(0.8);\n    }\n\n    .p-connected-overlay-enter-active {\n        opacity: 1;\n        transform: scaleY(1);\n        transition: transform .12s cubic-bezier(0, 0, 0.2, 1), opacity .12s cubic-bezier(0, 0, 0.2, 1);\n    }\n\n    .p-connected-overlay-enter-done {\n        transform: none;\n    }\n\n    .p-connected-overlay-exit {\n        opacity: 1;\n    }\n\n    .p-connected-overlay-exit-active {\n        opacity: 0;\n        transition: opacity .1s linear;\n    }\n\n    /* Toggleable Content */\n    .p-toggleable-content-enter {\n        max-height: 0;\n    }\n\n    .p-toggleable-content-enter-active {\n        overflow: hidden;\n        max-height: 1000px;\n        transition: max-height 1s ease-in-out;\n    }\n\n    .p-toggleable-content-enter-done {\n        transform: none;\n    }\n\n    .p-toggleable-content-exit {\n        max-height: 1000px;\n    }\n\n    .p-toggleable-content-exit-active {\n        overflow: hidden;\n        max-height: 0;\n        transition: max-height 0.45s cubic-bezier(0, 1, 0, 1);\n    }\n\n    /* @todo Refactor */\n    .p-menu .p-menuitem-link {\n        cursor: pointer;\n        display: flex;\n        align-items: center;\n        text-decoration: none;\n        overflow: hidden;\n        position: relative;\n    }\n\n    ".concat(buttonStyles, "\n    ").concat(inputTextStyles, "\n    ").concat(iconStyles, "\n}\n");
  var ComponentBase = {
    cProps: undefined,
    cParams: undefined,
    cName: undefined,
    defaultProps: {
      pt: undefined,
      ptOptions: undefined,
      unstyled: false
    },
    context: {},
    globalCSS: undefined,
    classes: {},
    styles: '',
    extend: function extend() {
      var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var css = props.css;
      var defaultProps = _objectSpread$1Y(_objectSpread$1Y({}, props.defaultProps), ComponentBase.defaultProps);
      var inlineStyles = {};
      var getProps = function getProps(props) {
        var context = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        ComponentBase.context = context;
        ComponentBase.cProps = props;
        return ObjectUtils.getMergedProps(props, defaultProps);
      };
      var getOtherProps = function getOtherProps(props) {
        return ObjectUtils.getDiffProps(props, defaultProps);
      };
      var getPTValue = function getPTValue() {
        var _ComponentBase$contex;
        var obj = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        var key = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
        var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
        var searchInDefaultPT = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : true;
        // obj either is the passthrough options or has a .pt property.
        if (obj.hasOwnProperty('pt') && obj.pt !== undefined) {
          obj = obj.pt;
        }
        var originalkey = key;
        var isNestedParam = /./g.test(originalkey) && !!params[originalkey.split('.')[0]];
        var fkey = isNestedParam ? ObjectUtils.toFlatCase(originalkey.split('.')[1]) : ObjectUtils.toFlatCase(originalkey);
        var hostName = params.hostName && ObjectUtils.toFlatCase(params.hostName);
        var componentName = hostName || params.props && params.props.__TYPE && ObjectUtils.toFlatCase(params.props.__TYPE) || '';
        var isTransition = fkey === 'transition';
        var datasetPrefix = 'data-pc-';
        var _getHostInstance = function getHostInstance(params) {
          return params !== null && params !== void 0 && params.props ? params.hostName ? params.props.__TYPE === params.hostName ? params.props : _getHostInstance(params.parent) : params.parent : undefined;
        };
        var getPropValue = function getPropValue(name) {
          var _params$props, _getHostInstance2;
          return ((_params$props = params.props) === null || _params$props === void 0 ? void 0 : _params$props[name]) || ((_getHostInstance2 = _getHostInstance(params)) === null || _getHostInstance2 === void 0 ? void 0 : _getHostInstance2[name]);
        };
        ComponentBase.cParams = params;
        ComponentBase.cName = componentName;
        var _ref = getPropValue('ptOptions') || ComponentBase.context.ptOptions || {},
          _ref$mergeSections = _ref.mergeSections,
          mergeSections = _ref$mergeSections === void 0 ? true : _ref$mergeSections,
          _ref$mergeProps = _ref.mergeProps,
          useMergeProps = _ref$mergeProps === void 0 ? false : _ref$mergeProps;
        var getPTClassValue = function getPTClassValue() {
          var value = _getOptionValue.apply(void 0, arguments);
          if (Array.isArray(value)) {
            return {
              className: classNames.apply(void 0, _toConsumableArray(value))
            };
          }
          if (ObjectUtils.isString(value)) {
            return {
              className: value
            };
          }
          if (value !== null && value !== void 0 && value.hasOwnProperty('className') && Array.isArray(value.className)) {
            return {
              className: classNames.apply(void 0, _toConsumableArray(value.className))
            };
          }
          return value;
        };
        var globalPT = searchInDefaultPT ? isNestedParam ? _useGlobalPT(getPTClassValue, originalkey, params) : _useDefaultPT(getPTClassValue, originalkey, params) : undefined;
        var self = isNestedParam ? undefined : _usePT(_getPT(obj, componentName), getPTClassValue, originalkey, params);
        var datasetProps = !isTransition && _objectSpread$1Y(_objectSpread$1Y({}, fkey === 'root' && _defineProperty({}, "".concat(datasetPrefix, "name"), params.props && params.props.__parentMetadata ? ObjectUtils.toFlatCase(params.props.__TYPE) : componentName)), {}, _defineProperty({}, "".concat(datasetPrefix, "section"), fkey));
        return mergeSections || !mergeSections && self ? useMergeProps ? mergeProps([globalPT, self, Object.keys(datasetProps).length ? datasetProps : {}], {
          classNameMergeFunction: (_ComponentBase$contex = ComponentBase.context.ptOptions) === null || _ComponentBase$contex === void 0 ? void 0 : _ComponentBase$contex.classNameMergeFunction
        }) : _objectSpread$1Y(_objectSpread$1Y(_objectSpread$1Y({}, globalPT), self), Object.keys(datasetProps).length ? datasetProps : {}) : _objectSpread$1Y(_objectSpread$1Y({}, self), Object.keys(datasetProps).length ? datasetProps : {});
      };
      var setMetaData = function setMetaData() {
        var metadata = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        var props = metadata.props,
          state = metadata.state;
        var ptm = function ptm() {
          var key = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
          var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
          return getPTValue((props || {}).pt, key, _objectSpread$1Y(_objectSpread$1Y({}, metadata), params));
        };
        var ptmo = function ptmo() {
          var obj = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
          var key = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
          var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
          return getPTValue(obj, key, params, false);
        };
        var isUnstyled = function isUnstyled() {
          return ComponentBase.context.unstyled || PrimeReact.unstyled || props.unstyled;
        };
        var cx = function cx() {
          var key = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
          var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
          return !isUnstyled() ? _getOptionValue(css && css.classes, key, _objectSpread$1Y({
            props: props,
            state: state
          }, params)) : undefined;
        };
        var sx = function sx() {
          var key = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
          var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
          var when = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
          if (when) {
            var _ComponentBase$contex2;
            var self = _getOptionValue(css && css.inlineStyles, key, _objectSpread$1Y({
              props: props,
              state: state
            }, params));
            var base = _getOptionValue(inlineStyles, key, _objectSpread$1Y({
              props: props,
              state: state
            }, params));
            return mergeProps([base, self], {
              classNameMergeFunction: (_ComponentBase$contex2 = ComponentBase.context.ptOptions) === null || _ComponentBase$contex2 === void 0 ? void 0 : _ComponentBase$contex2.classNameMergeFunction
            });
          }
          return undefined;
        };
        return {
          ptm: ptm,
          ptmo: ptmo,
          sx: sx,
          cx: cx,
          isUnstyled: isUnstyled
        };
      };
      return _objectSpread$1Y(_objectSpread$1Y({
        getProps: getProps,
        getOtherProps: getOtherProps,
        setMetaData: setMetaData
      }, props), {}, {
        defaultProps: defaultProps
      });
    }
  };
  var _getOptionValue = function getOptionValue(obj) {
    var key = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
    var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var fKeys = String(ObjectUtils.toFlatCase(key)).split('.');
    var fKey = fKeys.shift();
    var matchedPTOption = ObjectUtils.isNotEmpty(obj) ? Object.keys(obj).find(function (k) {
      return ObjectUtils.toFlatCase(k) === fKey;
    }) : '';
    return fKey ? ObjectUtils.isObject(obj) ? _getOptionValue(ObjectUtils.getItemValue(obj[matchedPTOption], params), fKeys.join('.'), params) : undefined : ObjectUtils.getItemValue(obj, params);
  };
  var _getPT = function _getPT(pt) {
    var key = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
    var callback = arguments.length > 2 ? arguments[2] : undefined;
    var _usept = pt === null || pt === void 0 ? void 0 : pt._usept;
    var getValue = function getValue(value) {
      var _ref3;
      var checkSameKey = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var _value = callback ? callback(value) : value;
      var _key = ObjectUtils.toFlatCase(key);
      return (_ref3 = checkSameKey ? _key !== ComponentBase.cName ? _value === null || _value === void 0 ? void 0 : _value[_key] : undefined : _value === null || _value === void 0 ? void 0 : _value[_key]) !== null && _ref3 !== void 0 ? _ref3 : _value;
    };
    return ObjectUtils.isNotEmpty(_usept) ? {
      _usept: _usept,
      originalValue: getValue(pt.originalValue),
      value: getValue(pt.value)
    } : getValue(pt, true);
  };
  var _usePT = function _usePT(pt, callback, key, params) {
    var fn = function fn(value) {
      return callback(value, key, params);
    };
    if (pt !== null && pt !== void 0 && pt.hasOwnProperty('_usept')) {
      var _ref4 = pt._usept || ComponentBase.context.ptOptions || {},
        _ref4$mergeSections = _ref4.mergeSections,
        mergeSections = _ref4$mergeSections === void 0 ? true : _ref4$mergeSections,
        _ref4$mergeProps = _ref4.mergeProps,
        useMergeProps = _ref4$mergeProps === void 0 ? false : _ref4$mergeProps,
        classNameMergeFunction = _ref4.classNameMergeFunction;
      var originalValue = fn(pt.originalValue);
      var value = fn(pt.value);
      if (originalValue === undefined && value === undefined) {
        return undefined;
      } else if (ObjectUtils.isString(value)) {
        return value;
      } else if (ObjectUtils.isString(originalValue)) {
        return originalValue;
      }
      return mergeSections || !mergeSections && value ? useMergeProps ? mergeProps([originalValue, value], {
        classNameMergeFunction: classNameMergeFunction
      }) : _objectSpread$1Y(_objectSpread$1Y({}, originalValue), value) : value;
    }
    return fn(pt);
  };
  var getGlobalPT = function getGlobalPT() {
    return _getPT(ComponentBase.context.pt || PrimeReact.pt, undefined, function (value) {
      return ObjectUtils.getItemValue(value, ComponentBase.cParams);
    });
  };
  var getDefaultPT = function getDefaultPT() {
    return _getPT(ComponentBase.context.pt || PrimeReact.pt, undefined, function (value) {
      return _getOptionValue(value, ComponentBase.cName, ComponentBase.cParams) || ObjectUtils.getItemValue(value, ComponentBase.cParams);
    });
  };
  var _useGlobalPT = function _useGlobalPT(callback, key, params) {
    return _usePT(getGlobalPT(), callback, key, params);
  };
  var _useDefaultPT = function _useDefaultPT(callback, key, params) {
    return _usePT(getDefaultPT(), callback, key, params);
  };
  var useHandleStyle = function useHandleStyle(styles) {
    var _isUnstyled = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : function () {};
    var config = arguments.length > 2 ? arguments[2] : undefined;
    var name = config.name,
      _config$styled = config.styled,
      styled = _config$styled === void 0 ? false : _config$styled,
      _config$hostName = config.hostName,
      hostName = _config$hostName === void 0 ? '' : _config$hostName;
    var globalCSS = _useGlobalPT(_getOptionValue, 'global.css', ComponentBase.cParams);
    var componentName = ObjectUtils.toFlatCase(name);
    var _useStyle = useStyle(baseStyle, {
        name: 'base',
        manual: true
      }),
      loadBaseStyle = _useStyle.load;
    var _useStyle2 = useStyle(commonStyle, {
        name: 'common',
        manual: true
      }),
      loadCommonStyle = _useStyle2.load;
    var _useStyle3 = useStyle(globalCSS, {
        name: 'global',
        manual: true
      }),
      loadGlobalStyle = _useStyle3.load;
    var _useStyle4 = useStyle(styles, {
        name: name,
        manual: true
      }),
      loadComponentStyle = _useStyle4.load;
    var hook = function hook(hookName) {
      if (!hostName) {
        var selfHook = _usePT(_getPT((ComponentBase.cProps || {}).pt, componentName), _getOptionValue, "hooks.".concat(hookName));
        var defaultHook = _useDefaultPT(_getOptionValue, "hooks.".concat(hookName));
        selfHook === null || selfHook === void 0 || selfHook();
        defaultHook === null || defaultHook === void 0 || defaultHook();
      }
    };
    hook('useMountEffect');
    useMountEffect(function () {
      // Load base and global styles first as they are always needed
      loadBaseStyle();
      loadGlobalStyle();

      // Only load additional styles if component is styled
      if (!_isUnstyled()) {
        // Load common styles shared across components
        loadCommonStyle();

        // Load component-specific styles if not explicitly styled
        if (!styled) {
          loadComponentStyle();
        }
      }
    });
    useUpdateEffect(function () {
      hook('useUpdateEffect');
    });
    useUnmountEffect(function () {
      hook('useUnmountEffect');
    });
  };

  var CSSTransitionBase = {
    defaultProps: {
      __TYPE: 'CSSTransition',
      children: undefined
    },
    getProps: function getProps(props) {
      return ObjectUtils.getMergedProps(props, CSSTransitionBase.defaultProps);
    },
    getOtherProps: function getOtherProps(props) {
      return ObjectUtils.getDiffProps(props, CSSTransitionBase.defaultProps);
    }
  };

  function ownKeys$1X(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1X(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1X(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1X(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var CSSTransition = /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var props = CSSTransitionBase.getProps(inProps);
    var context = React__namespace.useContext(PrimeReactContext);
    var disabled = props.disabled || props.options && props.options.disabled || context && !context.cssTransition || !PrimeReact.cssTransition;
    var onEnter = function onEnter(node, isAppearing) {
      props.onEnter && props.onEnter(node, isAppearing); // component
      props.options && props.options.onEnter && props.options.onEnter(node, isAppearing); // user option
    };
    var onEntering = function onEntering(node, isAppearing) {
      props.onEntering && props.onEntering(node, isAppearing); // component
      props.options && props.options.onEntering && props.options.onEntering(node, isAppearing); // user option
    };
    var onEntered = function onEntered(node, isAppearing) {
      props.onEntered && props.onEntered(node, isAppearing); // component
      props.options && props.options.onEntered && props.options.onEntered(node, isAppearing); // user option
    };
    var onExit = function onExit(node) {
      props.onExit && props.onExit(node); // component
      props.options && props.options.onExit && props.options.onExit(node); // user option
    };
    var onExiting = function onExiting(node) {
      props.onExiting && props.onExiting(node); // component
      props.options && props.options.onExiting && props.options.onExiting(node); // user option
    };
    var onExited = function onExited(node) {
      props.onExited && props.onExited(node); // component
      props.options && props.options.onExited && props.options.onExited(node); // user option
    };
    useUpdateEffect(function () {
      if (disabled) {
        // no animation
        var node = ObjectUtils.getRefElement(props.nodeRef);
        if (props["in"]) {
          onEnter(node, true);
          onEntering(node, true);
          onEntered(node, true);
        } else {
          onExit(node);
          onExiting(node);
          onExited(node);
        }
      }
    }, [props["in"]]);
    if (disabled) {
      return props["in"] ? props.children : null;
    }
    var immutableProps = {
      nodeRef: props.nodeRef,
      "in": props["in"],
      appear: props.appear,
      onEnter: onEnter,
      onEntering: onEntering,
      onEntered: onEntered,
      onExit: onExit,
      onExiting: onExiting,
      onExited: onExited
    };
    var mutableProps = {
      classNames: props.classNames,
      timeout: props.timeout,
      unmountOnExit: props.unmountOnExit
    };
    var mergedProps = _objectSpread$1X(_objectSpread$1X(_objectSpread$1X({}, mutableProps), props.options || {}), immutableProps);
    return /*#__PURE__*/React__namespace.createElement(reactTransitionGroup.CSSTransition, mergedProps, props.children);
  });
  CSSTransition.displayName = 'CSSTransition';

  var IconBase = {
    defaultProps: {
      __TYPE: 'IconBase',
      className: null,
      label: null,
      spin: false
    },
    getProps: function getProps(props) {
      return ObjectUtils.getMergedProps(props, IconBase.defaultProps);
    },
    getOtherProps: function getOtherProps(props) {
      return ObjectUtils.getDiffProps(props, IconBase.defaultProps);
    },
    getPTI: function getPTI(props) {
      var isLabelEmpty = ObjectUtils.isEmpty(props.label);
      var otherProps = IconBase.getOtherProps(props);
      var ptiProps = {
        className: classNames('p-icon', {
          'p-icon-spin': props.spin
        }, props.className),
        role: !isLabelEmpty ? 'img' : undefined,
        'aria-label': !isLabelEmpty ? props.label : undefined,
        'aria-hidden': props.label ? isLabelEmpty : undefined
      };
      return ObjectUtils.getMergedProps(otherProps, ptiProps);
    }
  };

  var ChevronDownIcon = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("path", {
      d: "M7.01744 10.398C6.91269 10.3985 6.8089 10.378 6.71215 10.3379C6.61541 10.2977 6.52766 10.2386 6.45405 10.1641L1.13907 4.84913C1.03306 4.69404 0.985221 4.5065 1.00399 4.31958C1.02276 4.13266 1.10693 3.95838 1.24166 3.82747C1.37639 3.69655 1.55301 3.61742 1.74039 3.60402C1.92777 3.59062 2.11386 3.64382 2.26584 3.75424L7.01744 8.47394L11.769 3.75424C11.9189 3.65709 12.097 3.61306 12.2748 3.62921C12.4527 3.64535 12.6199 3.72073 12.7498 3.84328C12.8797 3.96582 12.9647 4.12842 12.9912 4.30502C13.0177 4.48162 12.9841 4.662 12.8958 4.81724L7.58083 10.1322C7.50996 10.2125 7.42344 10.2775 7.32656 10.3232C7.22968 10.3689 7.12449 10.3944 7.01744 10.398Z",
      fill: "currentColor"
    }));
  }));
  ChevronDownIcon.displayName = 'ChevronDownIcon';

  var ChevronRightIcon = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("path", {
      d: "M4.38708 13C4.28408 13.0005 4.18203 12.9804 4.08691 12.9409C3.99178 12.9014 3.9055 12.8433 3.83313 12.7701C3.68634 12.6231 3.60388 12.4238 3.60388 12.2161C3.60388 12.0084 3.68634 11.8091 3.83313 11.6622L8.50507 6.99022L3.83313 2.31827C3.69467 2.16968 3.61928 1.97313 3.62287 1.77005C3.62645 1.56698 3.70872 1.37322 3.85234 1.22959C3.99596 1.08597 4.18972 1.00371 4.3928 1.00012C4.59588 0.996539 4.79242 1.07192 4.94102 1.21039L10.1669 6.43628C10.3137 6.58325 10.3962 6.78249 10.3962 6.99022C10.3962 7.19795 10.3137 7.39718 10.1669 7.54416L4.94102 12.7701C4.86865 12.8433 4.78237 12.9014 4.68724 12.9409C4.59212 12.9804 4.49007 13.0005 4.38708 13Z",
      fill: "currentColor"
    }));
  }));
  ChevronRightIcon.displayName = 'ChevronRightIcon';

  var classes$1i = {
    root: 'p-accordion p-component',
    accordiontab: {
      root: function root(_ref) {
        var selected = _ref.selected;
        return classNames('p-accordion-tab', {
          'p-accordion-tab-active': selected
        });
      },
      content: 'p-accordion-content',
      header: function header(_ref2) {
        var selected = _ref2.selected,
          getTabProp = _ref2.getTabProp,
          tab = _ref2.tab;
        return classNames('p-accordion-header', {
          'p-highlight': selected,
          'p-disabled': getTabProp(tab, 'disabled')
        });
      },
      headeraction: 'p-accordion-header-link',
      headericon: 'p-accordion-toggle-icon',
      headertitle: 'p-accordion-header-text',
      toggleablecontent: 'p-toggleable-content',
      transition: 'p-toggleable-content'
    }
  };
  var styles$15 = "\n@layer primereact {\n    .p-accordion-header-link {\n        cursor: pointer;\n        display: flex;\n        align-items: center;\n        user-select: none;\n        position: relative;\n        text-decoration: none;\n    }\n    \n    .p-accordion-header-link:focus {\n        z-index: 1;\n    }\n    \n    .p-accordion-header-text {\n        line-height: 1;\n        width: 100%;\n    }\n}\n";
  var AccordionBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'Accordion',
      id: null,
      activeIndex: null,
      className: null,
      style: null,
      multiple: false,
      expandIcon: null,
      collapseIcon: null,
      transitionOptions: null,
      onTabOpen: null,
      onTabClose: null,
      onTabChange: null,
      children: undefined
    },
    css: {
      classes: classes$1i,
      styles: styles$15
    }
  });
  var AccordionTabBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'AccordionTab',
      className: null,
      contentClassName: null,
      contentStyle: null,
      disabled: false,
      header: null,
      headerClassName: null,
      headerStyle: null,
      headerTemplate: null,
      style: null,
      tabIndex: 0,
      children: undefined
    },
    getCProp: function getCProp(tab, name) {
      return ObjectUtils.getComponentProp(tab, name, AccordionTabBase.defaultProps);
    },
    getCProps: function getCProps(tab) {
      return ObjectUtils.getComponentProps(tab, AccordionTabBase.defaultProps);
    },
    getCOtherProps: function getCOtherProps(tab) {
      return ObjectUtils.getComponentDiffProps(tab, AccordionTabBase.defaultProps);
    }
  });

  function ownKeys$1W(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1W(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1W(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1W(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var AccordionTab = function AccordionTab() {};
  var Accordion = /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var mergeProps = useMergeProps();
    var context = React__namespace.useContext(PrimeReactContext);
    var props = AccordionBase.getProps(inProps, context);
    var _React$useState = React__namespace.useState(props.id),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      idState = _React$useState2[0],
      setIdState = _React$useState2[1];
    var _React$useState3 = React__namespace.useState(props.activeIndex),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      activeIndexState = _React$useState4[0],
      setActiveIndexState = _React$useState4[1];
    var elementRef = React__namespace.useRef(null);
    var activeIndex = props.onTabChange ? props.activeIndex : activeIndexState;
    var count = React__namespace.Children.count(props.children);
    var metaData = {
      props: props,
      state: {
        id: idState,
        activeIndex: activeIndexState
      }
    };
    var _AccordionBase$setMet = AccordionBase.setMetaData(_objectSpread$1W({}, metaData)),
      ptm = _AccordionBase$setMet.ptm,
      ptmo = _AccordionBase$setMet.ptmo,
      cx = _AccordionBase$setMet.cx,
      isUnstyled = _AccordionBase$setMet.isUnstyled;
    useHandleStyle(AccordionBase.css.styles, isUnstyled, {
      name: 'accordion'
    });
    var getTabProp = function getTabProp(tab, name) {
      return AccordionTabBase.getCProp(tab, name);
    };
    var getTabPT = function getTabPT(tab, key, index) {
      var tabMetaData = {
        // props: atProps, /* @todo */
        parent: metaData,
        context: {
          index: index,
          count: count,
          first: index === 0,
          last: index === count - 1,
          selected: isSelected(index),
          disabled: getTabProp(tab, 'disabled')
        }
      };
      return mergeProps(ptm("tab.".concat(key), {
        tab: tabMetaData
      }), ptm("accordiontab.".concat(key), {
        accordiontab: tabMetaData
      }), ptm("accordiontab.".concat(key), tabMetaData), ptmo(getTabProp(tab, 'pt'), key, tabMetaData));
    };
    var onTabHeaderClick = function onTabHeaderClick(event, tab, index) {
      changeActiveIndex(event, tab, index);
    };
    var changeActiveIndex = function changeActiveIndex(event, tab, index) {
      if (!getTabProp(tab, 'disabled')) {
        var selected = isSelected(index);
        var newActiveIndex = null;
        if (props.multiple) {
          var indexes = activeIndex || [];
          newActiveIndex = selected ? indexes.filter(function (i) {
            return i !== index;
          }) : [].concat(_toConsumableArray(indexes), [index]);
        } else {
          newActiveIndex = selected ? null : index;
        }
        var callback = selected ? props.onTabClose : props.onTabOpen;
        callback && callback({
          originalEvent: event,
          index: index
        });
        if (props.onTabChange) {
          props.onTabChange({
            originalEvent: event,
            index: newActiveIndex
          });
        } else {
          setActiveIndexState(newActiveIndex);
        }
      }
      event.preventDefault();
    };
    var onTabHeaderKeyDown = function onTabHeaderKeyDown(event, tab, index) {
      switch (event.code) {
        case 'ArrowDown':
          onTabArrowDownKey(event);
          break;
        case 'ArrowUp':
          onTabArrowUpKey(event);
          break;
        case 'Home':
          onTabHomeKey(event);
          break;
        case 'End':
          onTabEndKey(event);
          break;
        case 'Enter':
        case 'NumpadEnter':
        case 'Space':
          onTabEnterKey(event, tab, index);
          break;
      }
    };
    var onTabArrowDownKey = function onTabArrowDownKey(event) {
      var nextHeaderAction = _findNextHeaderAction(event.target.parentElement.parentElement);
      nextHeaderAction ? changeFocusedTab(nextHeaderAction) : onTabHomeKey(event);
      event.preventDefault();
    };
    var onTabArrowUpKey = function onTabArrowUpKey(event) {
      var prevHeaderAction = _findPrevHeaderAction(event.target.parentElement.parentElement);
      prevHeaderAction ? changeFocusedTab(prevHeaderAction) : onTabEndKey(event);
      event.preventDefault();
    };
    var onTabHomeKey = function onTabHomeKey(event) {
      var firstHeaderAction = findFirstHeaderAction();
      changeFocusedTab(firstHeaderAction);
      event.preventDefault();
    };
    var onTabEndKey = function onTabEndKey(event) {
      var lastHeaderAction = findLastHeaderAction();
      changeFocusedTab(lastHeaderAction);
      event.preventDefault();
    };
    var onTabEnterKey = function onTabEnterKey(event, tab, index) {
      changeActiveIndex(event, tab, index);
      event.preventDefault();
    };
    var _findNextHeaderAction = function findNextHeaderAction(tabElement) {
      var selfCheck = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var nextTabElement = selfCheck ? tabElement : tabElement.nextElementSibling;
      var headerElement = DomHandler.findSingle(nextTabElement, '[data-pc-section="header"]');
      return headerElement ? DomHandler.getAttribute(headerElement, 'data-p-disabled') ? _findNextHeaderAction(headerElement.parentElement) : DomHandler.findSingle(headerElement, '[data-pc-section="headeraction"]') : null;
    };
    var _findPrevHeaderAction = function findPrevHeaderAction(tabElement) {
      var selfCheck = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var prevTabElement = selfCheck ? tabElement : tabElement.previousElementSibling;
      var headerElement = DomHandler.findSingle(prevTabElement, '[data-pc-section="header"]');
      return headerElement ? DomHandler.getAttribute(headerElement, 'data-p-disabled') ? _findPrevHeaderAction(headerElement.parentElement) : DomHandler.findSingle(headerElement, '[data-pc-section="headeraction"]') : null;
    };
    var findFirstHeaderAction = function findFirstHeaderAction() {
      return _findNextHeaderAction(elementRef.current.firstElementChild, true);
    };
    var findLastHeaderAction = function findLastHeaderAction() {
      return _findPrevHeaderAction(elementRef.current.lastElementChild, true);
    };
    var changeFocusedTab = function changeFocusedTab(element) {
      if (element) {
        DomHandler.focus(element);
      }
    };
    var isSelected = function isSelected(index) {
      return props.multiple && Array.isArray(activeIndex) ? activeIndex && activeIndex.some(function (i) {
        return i === index;
      }) : activeIndex === index;
    };
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        getElement: function getElement() {
          return elementRef.current;
        }
      };
    });
    useMountEffect(function () {
      if (!idState) {
        setIdState(UniqueComponentId());
      }
    });
    if (!idState) {
      return null;
    }
    var createTabHeader = function createTabHeader(tab, selected, index) {
      var style = _objectSpread$1W(_objectSpread$1W({}, getTabProp(tab, 'style') || {}), getTabProp(tab, 'headerStyle') || {});
      var headerId = idState + '_header_' + index;
      var ariaControls = idState + '_content_' + index;
      var tabIndex = getTabProp(tab, 'disabled') ? -1 : getTabProp(tab, 'tabIndex');
      var headerTitleProps = mergeProps({
        className: cx('accordiontab.headertitle')
      }, getTabPT(tab, 'headertitle', index));
      var tabCProps = AccordionTabBase.getCProps(tab);
      var header = getTabProp(tab, 'headerTemplate') ? ObjectUtils.getJSXElement(getTabProp(tab, 'headerTemplate'), tabCProps) : /*#__PURE__*/React__namespace.createElement("span", headerTitleProps, ObjectUtils.getJSXElement(getTabProp(tab, 'header'), tabCProps));
      var headerIconProps = mergeProps({
        'aria-hidden': 'true',
        className: cx('accordiontab.headericon')
      }, getTabPT(tab, 'headericon', index));
      var icon = selected ? props.collapseIcon || /*#__PURE__*/React__namespace.createElement(ChevronDownIcon, headerIconProps) : props.expandIcon || /*#__PURE__*/React__namespace.createElement(ChevronRightIcon, headerIconProps);
      var toggleIcon = IconUtils.getJSXIcon(icon, _objectSpread$1W({}, headerIconProps), {
        props: props,
        selected: selected
      });
      var headerProps = mergeProps({
        className: classNames(getTabProp(tab, 'headerClassName'), getTabProp(tab, 'className'), cx('accordiontab.header', {
          selected: selected,
          getTabProp: getTabProp,
          tab: tab
        })),
        style: style,
        'data-p-highlight': selected,
        'data-p-disabled': getTabProp(tab, 'disabled')
      }, getTabPT(tab, 'header', index));
      var headerActionProps = mergeProps({
        id: headerId,
        href: '#' + ariaControls,
        className: cx('accordiontab.headeraction'),
        role: 'button',
        tabIndex: tabIndex,
        onClick: function onClick(e) {
          return onTabHeaderClick(e, tab, index);
        },
        onKeyDown: function onKeyDown(e) {
          return onTabHeaderKeyDown(e, tab, index);
        },
        'aria-disabled': getTabProp(tab, 'disabled'),
        'aria-controls': ariaControls,
        'aria-expanded': selected
      }, getTabPT(tab, 'headeraction', index));
      return /*#__PURE__*/React__namespace.createElement("div", headerProps, /*#__PURE__*/React__namespace.createElement("a", headerActionProps, toggleIcon, header));
    };
    var createTabContent = function createTabContent(tab, selected, index) {
      var style = _objectSpread$1W(_objectSpread$1W({}, getTabProp(tab, 'style') || {}), getTabProp(tab, 'contentStyle') || {});
      var contentId = idState + '_content_' + index;
      var ariaLabelledby = idState + '_header_' + index;
      var contentRef = /*#__PURE__*/React__namespace.createRef();
      var toggleableContentProps = mergeProps({
        id: contentId,
        ref: contentRef,
        className: classNames(getTabProp(tab, 'contentClassName'), getTabProp(tab, 'className'), cx('accordiontab.toggleablecontent')),
        style: style,
        role: 'region',
        'aria-labelledby': ariaLabelledby
      }, getTabPT(tab, 'toggleablecontent', index));
      var contentProps = mergeProps({
        className: cx('accordiontab.content')
      }, getTabPT(tab, 'content', index));
      var transitionProps = mergeProps({
        classNames: cx('accordiontab.transition'),
        timeout: {
          enter: 1000,
          exit: 450
        },
        "in": selected,
        unmountOnExit: true,
        options: props.transitionOptions
      }, getTabPT(tab, 'transition', index));
      return /*#__PURE__*/React__namespace.createElement(CSSTransition, _extends({
        nodeRef: contentRef
      }, transitionProps), /*#__PURE__*/React__namespace.createElement("div", toggleableContentProps, /*#__PURE__*/React__namespace.createElement("div", contentProps, getTabProp(tab, 'children'))));
    };
    var createTab = function createTab(tab, index) {
      if (ObjectUtils.isValidChild(tab, 'AccordionTab')) {
        var key = idState + '_' + index;
        var selected = isSelected(index);
        var tabHeader = createTabHeader(tab, selected, index);
        var tabContent = createTabContent(tab, selected, index);
        var _rootProps = mergeProps({
          key: key,
          className: cx('accordiontab.root', {
            selected: selected
          })
        }, AccordionTabBase.getCOtherProps(tab), getTabPT(tab, 'root', index));
        return /*#__PURE__*/React__namespace.createElement("div", _rootProps, tabHeader, tabContent);
      }
      return null;
    };
    var createTabs = function createTabs() {
      return React__namespace.Children.map(props.children, createTab);
    };
    var tabs = createTabs();
    var rootProps = mergeProps({
      className: classNames(props.className, cx('root')),
      style: props.style
    }, AccordionBase.getOtherProps(props), ptm('root'));
    return /*#__PURE__*/React__namespace.createElement("div", _extends({
      id: idState,
      ref: elementRef
    }, rootProps), tabs);
  });
  AccordionTab.displayName = 'AccordionTab';
  Accordion.displayName = 'Accordion';

  var classes$1h = {
    root: function root(_ref) {
      var props = _ref.props;
      return classNames('p-badge p-component', _defineProperty({
        'p-badge-no-gutter': ObjectUtils.isNotEmpty(props.value) && String(props.value).length === 1,
        'p-badge-dot': ObjectUtils.isEmpty(props.value),
        'p-badge-lg': props.size === 'large',
        'p-badge-xl': props.size === 'xlarge'
      }, "p-badge-".concat(props.severity), props.severity !== null));
    }
  };
  var styles$14 = "\n@layer primereact {\n    .p-badge {\n        display: inline-block;\n        border-radius: 10px;\n        text-align: center;\n        padding: 0 .5rem;\n    }\n    \n    .p-overlay-badge {\n        position: relative;\n    }\n    \n    .p-overlay-badge .p-badge {\n        position: absolute;\n        top: 0;\n        right: 0;\n        transform: translate(50%,-50%);\n        transform-origin: 100% 0;\n        margin: 0;\n    }\n    \n    .p-badge-dot {\n        width: .5rem;\n        min-width: .5rem;\n        height: .5rem;\n        border-radius: 50%;\n        padding: 0;\n    }\n    \n    .p-badge-no-gutter {\n        padding: 0;\n        border-radius: 50%;\n    }\n}\n";
  var BadgeBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'Badge',
      __parentMetadata: null,
      value: null,
      severity: null,
      size: null,
      style: null,
      className: null,
      children: undefined
    },
    css: {
      classes: classes$1h,
      styles: styles$14
    }
  });

  function ownKeys$1V(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1V(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1V(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1V(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var Badge = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var mergeProps = useMergeProps();
    var context = React__namespace.useContext(PrimeReactContext);
    var props = BadgeBase.getProps(inProps, context);
    var _BadgeBase$setMetaDat = BadgeBase.setMetaData(_objectSpread$1V({
        props: props
      }, props.__parentMetadata)),
      ptm = _BadgeBase$setMetaDat.ptm,
      cx = _BadgeBase$setMetaDat.cx,
      isUnstyled = _BadgeBase$setMetaDat.isUnstyled;
    useHandleStyle(BadgeBase.css.styles, isUnstyled, {
      name: 'badge'
    });
    var elementRef = React__namespace.useRef(null);
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        getElement: function getElement() {
          return elementRef.current;
        }
      };
    });
    var rootProps = mergeProps({
      ref: elementRef,
      style: props.style,
      className: classNames(props.className, cx('root'))
    }, BadgeBase.getOtherProps(props), ptm('root'));
    return /*#__PURE__*/React__namespace.createElement("span", rootProps, props.value);
  }));
  Badge.displayName = 'Badge';

  var SpinnerIcon = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("path", {
      d: "M6.99701 14C5.85441 13.999 4.72939 13.7186 3.72012 13.1832C2.71084 12.6478 1.84795 11.8737 1.20673 10.9284C0.565504 9.98305 0.165424 8.89526 0.041387 7.75989C-0.0826496 6.62453 0.073125 5.47607 0.495122 4.4147C0.917119 3.35333 1.59252 2.4113 2.46241 1.67077C3.33229 0.930247 4.37024 0.413729 5.4857 0.166275C6.60117 -0.0811796 7.76026 -0.0520535 8.86188 0.251112C9.9635 0.554278 10.9742 1.12227 11.8057 1.90555C11.915 2.01493 11.9764 2.16319 11.9764 2.31778C11.9764 2.47236 11.915 2.62062 11.8057 2.73C11.7521 2.78503 11.688 2.82877 11.6171 2.85864C11.5463 2.8885 11.4702 2.90389 11.3933 2.90389C11.3165 2.90389 11.2404 2.8885 11.1695 2.85864C11.0987 2.82877 11.0346 2.78503 10.9809 2.73C9.9998 1.81273 8.73246 1.26138 7.39226 1.16876C6.05206 1.07615 4.72086 1.44794 3.62279 2.22152C2.52471 2.99511 1.72683 4.12325 1.36345 5.41602C1.00008 6.70879 1.09342 8.08723 1.62775 9.31926C2.16209 10.5513 3.10478 11.5617 4.29713 12.1803C5.48947 12.7989 6.85865 12.988 8.17414 12.7157C9.48963 12.4435 10.6711 11.7264 11.5196 10.6854C12.3681 9.64432 12.8319 8.34282 12.8328 7C12.8328 6.84529 12.8943 6.69692 13.0038 6.58752C13.1132 6.47812 13.2616 6.41667 13.4164 6.41667C13.5712 6.41667 13.7196 6.47812 13.8291 6.58752C13.9385 6.69692 14 6.84529 14 7C14 8.85651 13.2622 10.637 11.9489 11.9497C10.6356 13.2625 8.85432 14 6.99701 14Z",
      fill: "currentColor"
    }));
  }));
  SpinnerIcon.displayName = 'SpinnerIcon';

  var styles$13 = "\n@layer primereact {\n    .p-ripple {\n        overflow: hidden;\n        position: relative;\n    }\n    \n    .p-ink {\n        display: block;\n        position: absolute;\n        background: rgba(255, 255, 255, 0.5);\n        border-radius: 100%;\n        transform: scale(0);\n    }\n    \n    .p-ink-active {\n        animation: ripple 0.4s linear;\n    }\n    \n    .p-ripple-disabled .p-ink {\n        display: none;\n    }\n}\n\n@keyframes ripple {\n    100% {\n        opacity: 0;\n        transform: scale(2.5);\n    }\n}\n\n";
  var classes$1g = {
    root: 'p-ink'
  };
  var RippleBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'Ripple',
      children: undefined
    },
    css: {
      styles: styles$13,
      classes: classes$1g
    },
    getProps: function getProps(props) {
      return ObjectUtils.getMergedProps(props, RippleBase.defaultProps);
    },
    getOtherProps: function getOtherProps(props) {
      return ObjectUtils.getDiffProps(props, RippleBase.defaultProps);
    }
  });

  function ownKeys$1U(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1U(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1U(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1U(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var Ripple = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var _React$useState = React__namespace.useState(false),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      isMounted = _React$useState2[0],
      setMounted = _React$useState2[1];
    var inkRef = React__namespace.useRef(null);
    var targetRef = React__namespace.useRef(null);
    var mergeProps = useMergeProps();
    var context = React__namespace.useContext(PrimeReactContext);
    var props = RippleBase.getProps(inProps, context);
    var isRippleActive = context && context.ripple || PrimeReact.ripple;
    var metaData = {
      props: props
    };
    useStyle(RippleBase.css.styles, {
      name: 'ripple',
      manual: !isRippleActive
    });
    var _RippleBase$setMetaDa = RippleBase.setMetaData(_objectSpread$1U({}, metaData)),
      ptm = _RippleBase$setMetaDa.ptm,
      cx = _RippleBase$setMetaDa.cx;
    var getTarget = function getTarget() {
      return inkRef.current && inkRef.current.parentElement;
    };
    var bindEvents = function bindEvents() {
      if (targetRef.current) {
        targetRef.current.addEventListener('pointerdown', onPointerDown);
      }
    };
    var unbindEvents = function unbindEvents() {
      if (targetRef.current) {
        targetRef.current.removeEventListener('pointerdown', onPointerDown);
      }
    };
    var onPointerDown = function onPointerDown(event) {
      var offset = DomHandler.getOffset(targetRef.current);
      var offsetX = event.pageX - offset.left + document.body.scrollTop - DomHandler.getWidth(inkRef.current) / 2;
      var offsetY = event.pageY - offset.top + document.body.scrollLeft - DomHandler.getHeight(inkRef.current) / 2;
      activateRipple(offsetX, offsetY);
    };
    var activateRipple = function activateRipple(offsetX, offsetY) {
      if (!inkRef.current || getComputedStyle(inkRef.current, null).display === 'none') {
        return;
      }
      DomHandler.removeClass(inkRef.current, 'p-ink-active');
      setDimensions();
      inkRef.current.style.top = offsetY + 'px';
      inkRef.current.style.left = offsetX + 'px';
      DomHandler.addClass(inkRef.current, 'p-ink-active');
    };
    var onAnimationEnd = function onAnimationEnd(event) {
      DomHandler.removeClass(event.currentTarget, 'p-ink-active');
    };
    var setDimensions = function setDimensions() {
      if (inkRef.current && !DomHandler.getHeight(inkRef.current) && !DomHandler.getWidth(inkRef.current)) {
        var d = Math.max(DomHandler.getOuterWidth(targetRef.current), DomHandler.getOuterHeight(targetRef.current));
        inkRef.current.style.height = d + 'px';
        inkRef.current.style.width = d + 'px';
      }
    };
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        getInk: function getInk() {
          return inkRef.current;
        },
        getTarget: function getTarget() {
          return targetRef.current;
        }
      };
    });
    useMountEffect(function () {
      // for App Router in Next.js ^14
      setMounted(true);
    });
    useUpdateEffect(function () {
      if (isMounted && inkRef.current) {
        targetRef.current = getTarget();
        setDimensions();
        bindEvents();
      }
    }, [isMounted]);
    useUpdateEffect(function () {
      if (inkRef.current && !targetRef.current) {
        targetRef.current = getTarget();
        setDimensions();
        bindEvents();
      }
    });
    useUnmountEffect(function () {
      if (inkRef.current) {
        targetRef.current = null;
        unbindEvents();
      }
    });
    if (!isRippleActive) {
      return null;
    }
    var rootProps = mergeProps({
      'aria-hidden': true,
      className: classNames(cx('root'))
    }, RippleBase.getOtherProps(props), ptm('root'));
    return /*#__PURE__*/React__namespace.createElement("span", _extends({
      role: "presentation",
      ref: inkRef
    }, rootProps, {
      onAnimationEnd: onAnimationEnd
    }));
  }));
  Ripple.displayName = 'Ripple';

  var PortalBase = {
    defaultProps: {
      __TYPE: 'Portal',
      element: null,
      appendTo: null,
      visible: false,
      onMounted: null,
      onUnmounted: null,
      children: undefined
    },
    getProps: function getProps(props) {
      return ObjectUtils.getMergedProps(props, PortalBase.defaultProps);
    },
    getOtherProps: function getOtherProps(props) {
      return ObjectUtils.getDiffProps(props, PortalBase.defaultProps);
    }
  };

  var Portal = /*#__PURE__*/React__namespace.memo(function (inProps) {
    var props = PortalBase.getProps(inProps);
    var context = React__namespace.useContext(PrimeReactContext);
    var _React$useState = React__namespace.useState(props.visible && DomHandler.isClient()),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      mountedState = _React$useState2[0],
      setMountedState = _React$useState2[1];
    useMountEffect(function () {
      if (DomHandler.isClient() && !mountedState) {
        setMountedState(true);
        props.onMounted && props.onMounted();
      }
    });
    useUpdateEffect(function () {
      props.onMounted && props.onMounted();
    }, [mountedState]);
    useUnmountEffect(function () {
      props.onUnmounted && props.onUnmounted();
    });
    var element = props.element || props.children;
    if (element && mountedState) {
      var appendTo = props.appendTo || context && context.appendTo || PrimeReact.appendTo;
      if (ObjectUtils.isFunction(appendTo)) {
        appendTo = appendTo();
      }
      if (!appendTo) {
        appendTo = document.body;
      }
      return appendTo === 'self' ? element : /*#__PURE__*/ReactDOM__default["default"].createPortal(element, appendTo);
    }
    return null;
  });
  Portal.displayName = 'Portal';

  var classes$1f = {
    root: function root(_ref) {
      var positionState = _ref.positionState,
        classNameState = _ref.classNameState;
      return classNames('p-tooltip p-component', _defineProperty({}, "p-tooltip-".concat(positionState), true), classNameState);
    },
    arrow: 'p-tooltip-arrow',
    text: 'p-tooltip-text'
  };
  var inlineStyles$m = {
    arrow: function arrow(_ref2) {
      var context = _ref2.context;
      return {
        top: context.bottom ? '0' : context.right || context.left || !context.right && !context.left && !context.top && !context.bottom ? '50%' : null,
        bottom: context.top ? '0' : null,
        left: context.right || !context.right && !context.left && !context.top && !context.bottom ? '0' : context.top || context.bottom ? '50%' : null,
        right: context.left ? '0' : null
      };
    }
  };
  var styles$12 = "\n@layer primereact {\n    .p-tooltip {\n        position: absolute;\n        padding: .25em .5rem;\n        /* #3687: Tooltip prevent scrollbar flickering */\n        top: -9999px;\n        left: -9999px;\n    }\n    \n    .p-tooltip.p-tooltip-right,\n    .p-tooltip.p-tooltip-left {\n        padding: 0 .25rem;\n    }\n    \n    .p-tooltip.p-tooltip-top,\n    .p-tooltip.p-tooltip-bottom {\n        padding:.25em 0;\n    }\n    \n    .p-tooltip .p-tooltip-text {\n       white-space: pre-line;\n       word-break: break-word;\n    }\n    \n    .p-tooltip-arrow {\n        position: absolute;\n        width: 0;\n        height: 0;\n        border-color: transparent;\n        border-style: solid;\n    }\n    \n    .p-tooltip-right .p-tooltip-arrow {\n        top: 50%;\n        left: 0;\n        margin-top: -.25rem;\n        border-width: .25em .25em .25em 0;\n    }\n    \n    .p-tooltip-left .p-tooltip-arrow {\n        top: 50%;\n        right: 0;\n        margin-top: -.25rem;\n        border-width: .25em 0 .25em .25rem;\n    }\n    \n    .p-tooltip.p-tooltip-top {\n        padding: .25em 0;\n    }\n    \n    .p-tooltip-top .p-tooltip-arrow {\n        bottom: 0;\n        left: 50%;\n        margin-left: -.25rem;\n        border-width: .25em .25em 0;\n    }\n    \n    .p-tooltip-bottom .p-tooltip-arrow {\n        top: 0;\n        left: 50%;\n        margin-left: -.25rem;\n        border-width: 0 .25em .25rem;\n    }\n\n    .p-tooltip-target-wrapper {\n        display: inline-flex;\n    }\n}\n";
  var TooltipBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'Tooltip',
      appendTo: null,
      at: null,
      autoHide: true,
      autoZIndex: true,
      baseZIndex: 0,
      className: null,
      closeOnEscape: false,
      content: null,
      disabled: false,
      event: null,
      hideDelay: 0,
      hideEvent: 'mouseleave',
      id: null,
      mouseTrack: false,
      mouseTrackLeft: 5,
      mouseTrackTop: 5,
      my: null,
      onBeforeHide: null,
      onBeforeShow: null,
      onHide: null,
      onShow: null,
      position: 'right',
      showDelay: 0,
      showEvent: 'mouseenter',
      showOnDisabled: false,
      style: null,
      target: null,
      updateDelay: 0,
      children: undefined
    },
    css: {
      classes: classes$1f,
      styles: styles$12,
      inlineStyles: inlineStyles$m
    }
  });

  function ownKeys$1T(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1T(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1T(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1T(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var Tooltip = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var mergeProps = useMergeProps();
    var context = React__namespace.useContext(PrimeReactContext);
    var props = TooltipBase.getProps(inProps, context);
    var _React$useState = React__namespace.useState(false),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      visibleState = _React$useState2[0],
      setVisibleState = _React$useState2[1];
    var _React$useState3 = React__namespace.useState(props.position || 'right'),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      positionState = _React$useState4[0],
      setPositionState = _React$useState4[1];
    var _React$useState5 = React__namespace.useState(''),
      _React$useState6 = _slicedToArray(_React$useState5, 2),
      classNameState = _React$useState6[0],
      setClassNameState = _React$useState6[1];
    var _React$useState7 = React__namespace.useState(false),
      _React$useState8 = _slicedToArray(_React$useState7, 2),
      multipleFocusEvents = _React$useState8[0],
      setMultipleFocusEvents = _React$useState8[1];
    var isCloseOnEscape = visibleState && props.closeOnEscape;
    var overlayDisplayOrder = useDisplayOrder('tooltip', isCloseOnEscape);
    var metaData = {
      props: props,
      state: {
        visible: visibleState,
        position: positionState,
        className: classNameState
      },
      context: {
        right: positionState === 'right',
        left: positionState === 'left',
        top: positionState === 'top',
        bottom: positionState === 'bottom'
      }
    };
    var _TooltipBase$setMetaD = TooltipBase.setMetaData(metaData),
      ptm = _TooltipBase$setMetaD.ptm,
      cx = _TooltipBase$setMetaD.cx,
      sx = _TooltipBase$setMetaD.sx,
      isUnstyled = _TooltipBase$setMetaD.isUnstyled;
    useHandleStyle(TooltipBase.css.styles, isUnstyled, {
      name: 'tooltip'
    });
    useGlobalOnEscapeKey({
      callback: function callback() {
        hide();
      },
      when: isCloseOnEscape,
      priority: [ESC_KEY_HANDLING_PRIORITIES.TOOLTIP, overlayDisplayOrder]
    });
    var elementRef = React__namespace.useRef(null);
    var textRef = React__namespace.useRef(null);
    var currentTargetRef = React__namespace.useRef(null);
    var containerSize = React__namespace.useRef(null);
    var allowHide = React__namespace.useRef(true);
    var timeouts = React__namespace.useRef({});
    var currentMouseEvent = React__namespace.useRef(null);
    var _useResizeListener = useResizeListener({
        listener: function listener(event) {
          !DomHandler.isTouchDevice() && hide(event);
        }
      }),
      _useResizeListener2 = _slicedToArray(_useResizeListener, 2),
      bindWindowResizeListener = _useResizeListener2[0],
      unbindWindowResizeListener = _useResizeListener2[1];
    var _useOverlayScrollList = useOverlayScrollListener({
        target: currentTargetRef.current,
        listener: function listener(event) {
          hide(event);
        },
        when: visibleState
      }),
      _useOverlayScrollList2 = _slicedToArray(_useOverlayScrollList, 2),
      bindOverlayScrollListener = _useOverlayScrollList2[0],
      unbindOverlayScrollListener = _useOverlayScrollList2[1];
    var isTargetContentEmpty = function isTargetContentEmpty(target) {
      return !(props.content || getTargetOption(target, 'tooltip'));
    };
    var isContentEmpty = function isContentEmpty(target) {
      return !(props.content || getTargetOption(target, 'tooltip') || props.children);
    };
    var isMouseTrack = function isMouseTrack(target) {
      return getTargetOption(target, 'mousetrack') || props.mouseTrack;
    };
    var isDisabled = function isDisabled(target) {
      return getTargetOption(target, 'disabled') === 'true' || hasTargetOption(target, 'disabled') || props.disabled;
    };
    var isShowOnDisabled = function isShowOnDisabled(target) {
      return getTargetOption(target, 'showondisabled') || props.showOnDisabled;
    };
    var isAutoHide = function isAutoHide() {
      return getTargetOption(currentTargetRef.current, 'autohide') || props.autoHide;
    };
    var getTargetOption = function getTargetOption(target, option) {
      return hasTargetOption(target, "data-pr-".concat(option)) ? target.getAttribute("data-pr-".concat(option)) : null;
    };
    var hasTargetOption = function hasTargetOption(target, option) {
      return target && target.hasAttribute(option);
    };
    var getEvents = function getEvents(target) {
      var showEvents = [getTargetOption(target, 'showevent') || props.showEvent];
      var hideEvents = [getTargetOption(target, 'hideevent') || props.hideEvent];
      if (isMouseTrack(target)) {
        showEvents = ['mousemove'];
        hideEvents = ['mouseleave'];
      } else {
        var event = getTargetOption(target, 'event') || props.event;
        if (event === 'focus') {
          showEvents = ['focus'];
          hideEvents = ['blur'];
        }
        if (event === 'both') {
          showEvents = ['focus', 'mouseenter'];
          hideEvents = multipleFocusEvents ? ['blur'] : ['mouseleave', 'blur'];
        }
      }
      return {
        showEvents: showEvents,
        hideEvents: hideEvents
      };
    };
    var getPosition = function getPosition(target) {
      return getTargetOption(target, 'position') || positionState;
    };
    var getMouseTrackPosition = function getMouseTrackPosition(target) {
      var top = getTargetOption(target, 'mousetracktop') || props.mouseTrackTop;
      var left = getTargetOption(target, 'mousetrackleft') || props.mouseTrackLeft;
      return {
        top: top,
        left: left
      };
    };
    var updateText = function updateText(target, callback) {
      if (textRef.current) {
        var content = getTargetOption(target, 'tooltip') || props.content;
        if (content) {
          textRef.current.innerHTML = ''; // remove children
          textRef.current.appendChild(document.createTextNode(content));
          callback();
        } else if (props.children) {
          callback();
        }
      }
    };
    var updateTooltipState = function updateTooltipState(position) {
      updateText(currentTargetRef.current, function () {
        var _currentMouseEvent$cu = currentMouseEvent.current,
          x = _currentMouseEvent$cu.pageX,
          y = _currentMouseEvent$cu.pageY;
        if (props.autoZIndex && !ZIndexUtils.get(elementRef.current)) {
          ZIndexUtils.set('tooltip', elementRef.current, context && context.autoZIndex || PrimeReact.autoZIndex, props.baseZIndex || context && context.zIndex.tooltip || PrimeReact.zIndex.tooltip);
        }
        elementRef.current.style.left = '';
        elementRef.current.style.top = '';

        // GitHub #2695 disable pointer events when autohiding
        if (isAutoHide()) {
          elementRef.current.style.pointerEvents = 'none';
        }
        var mouseTrackCheck = isMouseTrack(currentTargetRef.current) || position === 'mouse';
        if (mouseTrackCheck && !containerSize.current || mouseTrackCheck) {
          containerSize.current = {
            width: DomHandler.getOuterWidth(elementRef.current),
            height: DomHandler.getOuterHeight(elementRef.current)
          };
        }
        align(currentTargetRef.current, {
          x: x,
          y: y
        }, position);
      });
    };
    var show = function show(e) {
      if (e.type && e.type === 'focus') setMultipleFocusEvents(true);
      currentTargetRef.current = e.currentTarget;
      var disabled = isDisabled(currentTargetRef.current);
      var empty = isContentEmpty(isShowOnDisabled(currentTargetRef.current) && disabled ? currentTargetRef.current.firstChild : currentTargetRef.current);
      if (empty || disabled) {
        return;
      }
      currentMouseEvent.current = e;
      if (visibleState) {
        applyDelay('updateDelay', updateTooltipState);
      } else {
        // #2653 give the callback a chance to return false and not continue with display
        var success = sendCallback(props.onBeforeShow, {
          originalEvent: e,
          target: currentTargetRef.current
        });
        if (success) {
          applyDelay('showDelay', function () {
            setVisibleState(true);
            sendCallback(props.onShow, {
              originalEvent: e,
              target: currentTargetRef.current
            });
          });
        }
      }
    };
    var hide = function hide(e) {
      if (e && e.type === 'blur') setMultipleFocusEvents(false);
      clearTimeouts();
      if (visibleState) {
        var success = sendCallback(props.onBeforeHide, {
          originalEvent: e,
          target: currentTargetRef.current
        });
        if (success) {
          applyDelay('hideDelay', function () {
            if (!isAutoHide() && allowHide.current === false) {
              return;
            }
            ZIndexUtils.clear(elementRef.current);
            DomHandler.removeClass(elementRef.current, 'p-tooltip-active');
            setVisibleState(false);
            sendCallback(props.onHide, {
              originalEvent: e,
              target: currentTargetRef.current
            });
          });
        }
      } else if (!props.onBeforeHide && !getDelay('hideDelay')) {
        // handles the case when visibleState change from mouseenter was queued and mouseleave handler was called earlier than queued re-render
        setVisibleState(false);
      }
    };
    var align = function align(target, coordinate, position) {
      var left = 0;
      var top = 0;
      var currentPosition = position || positionState;
      if ((isMouseTrack(target) || currentPosition == 'mouse') && coordinate) {
        var _containerSize = {
          width: DomHandler.getOuterWidth(elementRef.current),
          height: DomHandler.getOuterHeight(elementRef.current)
        };
        left = coordinate.x;
        top = coordinate.y;
        var _getMouseTrackPositio = getMouseTrackPosition(target),
          mouseTrackTop = _getMouseTrackPositio.top,
          mouseTrackLeft = _getMouseTrackPositio.left;
        switch (currentPosition) {
          case 'left':
            left = left - (_containerSize.width + mouseTrackLeft);
            top = top - (_containerSize.height / 2 - mouseTrackTop);
            break;
          case 'right':
          case 'mouse':
            left = left + mouseTrackLeft;
            top = top - (_containerSize.height / 2 - mouseTrackTop);
            break;
          case 'top':
            left = left - (_containerSize.width / 2 - mouseTrackLeft);
            top = top - (_containerSize.height + mouseTrackTop);
            break;
          case 'bottom':
            left = left - (_containerSize.width / 2 - mouseTrackLeft);
            top = top + mouseTrackTop;
            break;
        }
        if (left <= 0 || containerSize.current.width > _containerSize.width) {
          elementRef.current.style.left = '0px';
          elementRef.current.style.right = window.innerWidth - _containerSize.width - left + 'px';
        } else {
          elementRef.current.style.right = '';
          elementRef.current.style.left = left + 'px';
        }
        elementRef.current.style.top = top + 'px';
        DomHandler.addClass(elementRef.current, 'p-tooltip-active');
      } else {
        var pos = DomHandler.findCollisionPosition(currentPosition);
        var my = getTargetOption(target, 'my') || props.my || pos.my;
        var at = getTargetOption(target, 'at') || props.at || pos.at;
        elementRef.current.style.padding = '0px';
        DomHandler.flipfitCollision(elementRef.current, target, my, at, function (calculatedPosition) {
          var _calculatedPosition$a = calculatedPosition.at,
            atX = _calculatedPosition$a.x,
            atY = _calculatedPosition$a.y;
          var myX = calculatedPosition.my.x;
          var newPosition = props.at ? atX !== 'center' && atX !== myX ? atX : atY : calculatedPosition.at["".concat(pos.axis)];
          elementRef.current.style.padding = '';
          setPositionState(newPosition);
          updateContainerPosition(newPosition);
          DomHandler.addClass(elementRef.current, 'p-tooltip-active');
        });
      }
    };
    var updateContainerPosition = function updateContainerPosition(position) {
      if (elementRef.current) {
        var style = getComputedStyle(elementRef.current);
        if (position === 'left') {
          elementRef.current.style.left = parseFloat(style.left) - parseFloat(style.paddingLeft) * 2 + 'px';
        } else if (position === 'top') {
          elementRef.current.style.top = parseFloat(style.top) - parseFloat(style.paddingTop) * 2 + 'px';
        }
      }
    };
    var _onMouseEnter = function onMouseEnter() {
      if (!isAutoHide()) {
        allowHide.current = false;
      }
    };
    var _onMouseLeave = function onMouseLeave(e) {
      if (!isAutoHide()) {
        allowHide.current = true;
        hide(e);
      }
    };
    var bindTargetEvent = function bindTargetEvent(target) {
      if (target) {
        var _getEvents = getEvents(target),
          showEvents = _getEvents.showEvents,
          hideEvents = _getEvents.hideEvents;
        var currentTarget = getTarget(target);
        showEvents.forEach(function (event) {
          return currentTarget === null || currentTarget === void 0 ? void 0 : currentTarget.addEventListener(event, show);
        });
        hideEvents.forEach(function (event) {
          return currentTarget === null || currentTarget === void 0 ? void 0 : currentTarget.addEventListener(event, hide);
        });
      }
    };
    var unbindTargetEvent = function unbindTargetEvent(target) {
      if (target) {
        var _getEvents2 = getEvents(target),
          showEvents = _getEvents2.showEvents,
          hideEvents = _getEvents2.hideEvents;
        var currentTarget = getTarget(target);
        showEvents.forEach(function (event) {
          return currentTarget === null || currentTarget === void 0 ? void 0 : currentTarget.removeEventListener(event, show);
        });
        hideEvents.forEach(function (event) {
          return currentTarget === null || currentTarget === void 0 ? void 0 : currentTarget.removeEventListener(event, hide);
        });
      }
    };
    var getDelay = function getDelay(delayProp) {
      return getTargetOption(currentTargetRef.current, delayProp.toLowerCase()) || props[delayProp];
    };
    var applyDelay = function applyDelay(delayProp, callback) {
      clearTimeouts();
      var delay = getDelay(delayProp);
      delay ? timeouts.current["".concat(delayProp)] = setTimeout(function () {
        return callback();
      }, delay) : callback();
    };
    var sendCallback = function sendCallback(callback) {
      if (callback) {
        for (var _len = arguments.length, params = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
          params[_key - 1] = arguments[_key];
        }
        var result = callback.apply(void 0, params);
        if (result === undefined) {
          result = true;
        }
        return result;
      }
      return true;
    };
    var clearTimeouts = function clearTimeouts() {
      Object.values(timeouts.current).forEach(function (t) {
        return clearTimeout(t);
      });
    };
    var getTarget = function getTarget(target) {
      if (target) {
        if (isShowOnDisabled(target)) {
          if (!target.hasWrapper) {
            var wrapper = document.createElement('div');
            var isInputElement = target.nodeName === 'INPUT';
            if (isInputElement) {
              DomHandler.addMultipleClasses(wrapper, 'p-tooltip-target-wrapper p-inputwrapper');
            } else {
              DomHandler.addClass(wrapper, 'p-tooltip-target-wrapper');
            }
            target.parentNode.insertBefore(wrapper, target);
            wrapper.appendChild(target);
            target.hasWrapper = true;
            return wrapper;
          }
          return target.parentElement;
        } else if (target.hasWrapper) {
          var _target$parentElement;
          (_target$parentElement = target.parentElement).replaceWith.apply(_target$parentElement, _toConsumableArray(target.parentElement.childNodes));
          delete target.hasWrapper;
        }
        return target;
      }
      return null;
    };
    var updateTargetEvents = function updateTargetEvents(target) {
      unloadTargetEvents(target);
      loadTargetEvents(target);
    };
    var loadTargetEvents = function loadTargetEvents(target) {
      setTargetEventOperations(target || props.target, bindTargetEvent);
    };
    var unloadTargetEvents = function unloadTargetEvents(target) {
      setTargetEventOperations(target || props.target, unbindTargetEvent);
    };
    var setTargetEventOperations = function setTargetEventOperations(target, operation) {
      target = ObjectUtils.getRefElement(target);
      if (target) {
        if (DomHandler.isElement(target)) {
          operation(target);
        } else {
          var setEvent = function setEvent(target) {
            var element = DomHandler.find(document, target);
            element.forEach(function (el) {
              operation(el);
            });
          };
          if (target instanceof Array) {
            target.forEach(function (t) {
              setEvent(t);
            });
          } else {
            setEvent(target);
          }
        }
      }
    };
    useMountEffect(function () {
      if (visibleState && currentTargetRef.current && isDisabled(currentTargetRef.current)) {
        hide();
      }
    });
    useUpdateEffect(function () {
      loadTargetEvents();
      return function () {
        unloadTargetEvents();
      };
    }, [show, hide, props.target]);
    useUpdateEffect(function () {
      if (visibleState) {
        var position = getPosition(currentTargetRef.current);
        var classname = getTargetOption(currentTargetRef.current, 'classname');
        setPositionState(position);
        setClassNameState(classname);
        updateTooltipState(position);
        bindWindowResizeListener();
        bindOverlayScrollListener();
      } else {
        setPositionState(props.position || 'right');
        setClassNameState('');
        currentTargetRef.current = null;
        containerSize.current = null;
        allowHide.current = true;
      }
      return function () {
        unbindWindowResizeListener();
        unbindOverlayScrollListener();
      };
    }, [visibleState]);
    useUpdateEffect(function () {
      var position = getPosition(currentTargetRef.current);
      if (visibleState && position !== 'mouse') {
        applyDelay('updateDelay', function () {
          updateText(currentTargetRef.current, function () {
            align(currentTargetRef.current);
          });
        });
      }
    }, [props.content]);
    useUnmountEffect(function () {
      hide();
      ZIndexUtils.clear(elementRef.current);
    });
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        updateTargetEvents: updateTargetEvents,
        loadTargetEvents: loadTargetEvents,
        unloadTargetEvents: unloadTargetEvents,
        show: show,
        hide: hide,
        getElement: function getElement() {
          return elementRef.current;
        },
        getTarget: function getTarget() {
          return currentTargetRef.current;
        }
      };
    });
    var createElement = function createElement() {
      var empty = isTargetContentEmpty(currentTargetRef.current);
      var rootProps = mergeProps({
        id: props.id,
        className: classNames(props.className, cx('root', {
          positionState: positionState,
          classNameState: classNameState
        })),
        style: props.style,
        role: 'tooltip',
        'aria-hidden': visibleState,
        onMouseEnter: function onMouseEnter(e) {
          return _onMouseEnter();
        },
        onMouseLeave: function onMouseLeave(e) {
          return _onMouseLeave(e);
        }
      }, TooltipBase.getOtherProps(props), ptm('root'));
      var arrowProps = mergeProps({
        className: cx('arrow'),
        style: sx('arrow', _objectSpread$1T({}, metaData))
      }, ptm('arrow'));
      var textProps = mergeProps({
        className: cx('text')
      }, ptm('text'));
      return /*#__PURE__*/React__namespace.createElement("div", _extends({
        ref: elementRef
      }, rootProps), /*#__PURE__*/React__namespace.createElement("div", arrowProps), /*#__PURE__*/React__namespace.createElement("div", _extends({
        ref: textRef
      }, textProps), empty && props.children));
    };
    if (visibleState) {
      var element = createElement();
      return /*#__PURE__*/React__namespace.createElement(Portal, {
        element: element,
        appendTo: props.appendTo,
        visible: true
      });
    }
    return null;
  }));
  Tooltip.displayName = 'Tooltip';

  var classes$1e = {
    icon: function icon(_ref) {
      var props = _ref.props;
      return classNames('p-button-icon p-c', _defineProperty({}, "p-button-icon-".concat(props.iconPos), props.label));
    },
    loadingIcon: function loadingIcon(_ref2) {
      var props = _ref2.props,
        className = _ref2.className;
      return classNames(className, {
        'p-button-loading-icon': props.loading
      });
    },
    label: 'p-button-label p-c',
    root: function root(_ref3) {
      var props = _ref3.props,
        size = _ref3.size,
        disabled = _ref3.disabled;
      return classNames('p-button p-component', _defineProperty(_defineProperty(_defineProperty(_defineProperty({
        'p-button-icon-only': (props.icon || props.loading) && !props.label && !props.children,
        'p-button-vertical': (props.iconPos === 'top' || props.iconPos === 'bottom') && props.label,
        'p-disabled': disabled,
        'p-button-loading': props.loading,
        'p-button-outlined': props.outlined,
        'p-button-raised': props.raised,
        'p-button-link': props.link,
        'p-button-text': props.text,
        'p-button-rounded': props.rounded,
        'p-button-loading-label-only': props.loading && !props.icon && props.label
      }, "p-button-loading-".concat(props.iconPos), props.loading && props.label), "p-button-".concat(size), size), "p-button-".concat(props.severity), props.severity), 'p-button-plain', props.plain));
    }
  };
  var ButtonBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'Button',
      __parentMetadata: null,
      badge: null,
      badgeClassName: null,
      className: null,
      children: undefined,
      disabled: false,
      icon: null,
      iconPos: 'left',
      label: null,
      link: false,
      loading: false,
      loadingIcon: null,
      outlined: false,
      plain: false,
      raised: false,
      rounded: false,
      severity: null,
      size: null,
      text: false,
      tooltip: null,
      tooltipOptions: null,
      visible: true
    },
    css: {
      classes: classes$1e
    }
  });

  function ownKeys$1S(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1S(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1S(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1S(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var Button = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var mergeProps = useMergeProps();
    var context = React__namespace.useContext(PrimeReactContext);
    var props = ButtonBase.getProps(inProps, context);
    var disabled = props.disabled || props.loading;
    var metaData = _objectSpread$1S(_objectSpread$1S({
      props: props
    }, props.__parentMetadata), {}, {
      context: {
        disabled: disabled
      }
    });
    var _ButtonBase$setMetaDa = ButtonBase.setMetaData(metaData),
      ptm = _ButtonBase$setMetaDa.ptm,
      cx = _ButtonBase$setMetaDa.cx,
      isUnstyled = _ButtonBase$setMetaDa.isUnstyled;
    useHandleStyle(ButtonBase.css.styles, isUnstyled, {
      name: 'button',
      styled: true
    });
    var elementRef = React__namespace.useRef(ref);
    React__namespace.useEffect(function () {
      ObjectUtils.combinedRefs(elementRef, ref);
    }, [elementRef, ref]);
    if (props.visible === false) {
      return null;
    }
    var createIcon = function createIcon() {
      var className = classNames('p-button-icon p-c', _defineProperty({}, "p-button-icon-".concat(props.iconPos), props.label));
      var iconsProps = mergeProps({
        className: cx('icon')
      }, ptm('icon'));
      className = classNames(className, {
        'p-button-loading-icon': props.loading
      });
      var loadingIconProps = mergeProps({
        className: cx('loadingIcon', {
          className: className
        })
      }, ptm('loadingIcon'));
      var icon = props.loading ? props.loadingIcon || /*#__PURE__*/React__namespace.createElement(SpinnerIcon, _extends({}, loadingIconProps, {
        spin: true
      })) : props.icon;
      return IconUtils.getJSXIcon(icon, _objectSpread$1S({}, iconsProps), {
        props: props
      });
    };
    var createLabel = function createLabel() {
      var labelProps = mergeProps({
        className: cx('label')
      }, ptm('label'));
      if (props.label) {
        return /*#__PURE__*/React__namespace.createElement("span", labelProps, props.label);
      }
      return !props.children && !props.label && /*#__PURE__*/React__namespace.createElement("span", _extends({}, labelProps, {
        dangerouslySetInnerHTML: {
          __html: '&nbsp;'
        }
      }));
    };
    var createBadge = function createBadge() {
      if (props.badge) {
        var badgeProps = mergeProps({
          className: classNames(props.badgeClassName),
          value: props.badge,
          unstyled: props.unstyled,
          __parentMetadata: {
            parent: metaData
          }
        }, ptm('badge'));
        return /*#__PURE__*/React__namespace.createElement(Badge, badgeProps, props.badge);
      }
      return null;
    };
    var showTooltip = !disabled || props.tooltipOptions && props.tooltipOptions.showOnDisabled;
    var hasTooltip = ObjectUtils.isNotEmpty(props.tooltip) && showTooltip;
    var sizeMapping = {
      large: 'lg',
      small: 'sm'
    };
    var size = sizeMapping[props.size];
    var icon = createIcon();
    var label = createLabel();
    var badge = createBadge();
    var defaultAriaLabel = props.label ? props.label + (props.badge ? ' ' + props.badge : '') : props['aria-label'];
    var rootProps = mergeProps({
      ref: elementRef,
      'aria-label': defaultAriaLabel,
      'data-pc-autofocus': props.autoFocus,
      className: classNames(props.className, cx('root', {
        size: size,
        disabled: disabled
      })),
      disabled: disabled
    }, ButtonBase.getOtherProps(props), ptm('root'));
    return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, null, /*#__PURE__*/React__namespace.createElement("button", rootProps, icon, label, props.children, badge, /*#__PURE__*/React__namespace.createElement(Ripple, null)), hasTooltip && /*#__PURE__*/React__namespace.createElement(Tooltip, _extends({
      target: elementRef,
      content: props.tooltip,
      pt: ptm('tooltip')
    }, props.tooltipOptions)));
  }));
  Button.displayName = 'Button';

  var TimesCircleIcon = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("path", {
      fillRule: "evenodd",
      clipRule: "evenodd",
      d: "M7 14C5.61553 14 4.26215 13.5895 3.11101 12.8203C1.95987 12.0511 1.06266 10.9579 0.532846 9.67879C0.00303296 8.3997 -0.13559 6.99224 0.134506 5.63437C0.404603 4.2765 1.07129 3.02922 2.05026 2.05026C3.02922 1.07129 4.2765 0.404603 5.63437 0.134506C6.99224 -0.13559 8.3997 0.00303296 9.67879 0.532846C10.9579 1.06266 12.0511 1.95987 12.8203 3.11101C13.5895 4.26215 14 5.61553 14 7C14 8.85652 13.2625 10.637 11.9497 11.9497C10.637 13.2625 8.85652 14 7 14ZM7 1.16667C5.84628 1.16667 4.71846 1.50879 3.75918 2.14976C2.79989 2.79074 2.05222 3.70178 1.61071 4.76768C1.16919 5.83358 1.05367 7.00647 1.27876 8.13803C1.50384 9.26958 2.05941 10.309 2.87521 11.1248C3.69102 11.9406 4.73042 12.4962 5.86198 12.7212C6.99353 12.9463 8.16642 12.8308 9.23232 12.3893C10.2982 11.9478 11.2093 11.2001 11.8502 10.2408C12.4912 9.28154 12.8333 8.15373 12.8333 7C12.8333 5.45291 12.2188 3.96918 11.1248 2.87521C10.0308 1.78125 8.5471 1.16667 7 1.16667ZM4.66662 9.91668C4.58998 9.91704 4.51404 9.90209 4.44325 9.87271C4.37246 9.84333 4.30826 9.8001 4.2544 9.74557C4.14516 9.6362 4.0838 9.48793 4.0838 9.33335C4.0838 9.17876 4.14516 9.0305 4.2544 8.92113L6.17553 7L4.25443 5.07891C4.15139 4.96832 4.09529 4.82207 4.09796 4.67094C4.10063 4.51982 4.16185 4.37563 4.26872 4.26876C4.3756 4.16188 4.51979 4.10066 4.67091 4.09799C4.82204 4.09532 4.96829 4.15142 5.07887 4.25446L6.99997 6.17556L8.92106 4.25446C9.03164 4.15142 9.1779 4.09532 9.32903 4.09799C9.48015 4.10066 9.62434 4.16188 9.73121 4.26876C9.83809 4.37563 9.89931 4.51982 9.90198 4.67094C9.90464 4.82207 9.84855 4.96832 9.74551 5.07891L7.82441 7L9.74554 8.92113C9.85478 9.0305 9.91614 9.17876 9.91614 9.33335C9.91614 9.48793 9.85478 9.6362 9.74554 9.74557C9.69168 9.8001 9.62748 9.84333 9.55669 9.87271C9.4859 9.90209 9.40996 9.91704 9.33332 9.91668C9.25668 9.91704 9.18073 9.90209 9.10995 9.87271C9.03916 9.84333 8.97495 9.8001 8.9211 9.74557L6.99997 7.82444L5.07884 9.74557C5.02499 9.8001 4.96078 9.84333 4.88999 9.87271C4.81921 9.90209 4.74326 9.91704 4.66662 9.91668Z",
      fill: "currentColor"
    }));
  }));
  TimesCircleIcon.displayName = 'TimesCircleIcon';

  var KeyFilter = {
    /* eslint-disable */
    DEFAULT_MASKS: {
      pint: /[\d]/,
      "int": /[\d\-]/,
      pnum: /[\d\.]/,
      money: /[\d\.\s,]/,
      num: /[\d\-\.]/,
      hex: /[0-9a-f]/i,
      email: /[a-z0-9_\.\-@]/i,
      alpha: /[a-z_]/i,
      alphanum: /[a-z0-9_]/i
    },
    /* eslint-enable */getRegex: function getRegex(keyfilter) {
      return KeyFilter.DEFAULT_MASKS[keyfilter] ? KeyFilter.DEFAULT_MASKS[keyfilter] : keyfilter;
    },
    onBeforeInput: function onBeforeInput(e, keyfilter, validateOnly) {
      // android devices must use beforeinput https://stackoverflow.com/questions/36753548/keycode-on-android-is-always-229
      if (validateOnly || !DomHandler.isAndroid()) {
        return;
      }
      this.validateKey(e, e.data, keyfilter);
    },
    onKeyPress: function onKeyPress(e, keyfilter, validateOnly) {
      // non android devices use keydown
      if (validateOnly || DomHandler.isAndroid()) {
        return;
      }
      if (e.ctrlKey || e.altKey || e.metaKey) {
        return;
      }
      this.validateKey(e, e.key, keyfilter);
    },
    onPaste: function onPaste(e, keyfilter, validateOnly) {
      if (validateOnly) {
        return;
      }
      var regex = this.getRegex(keyfilter);
      var clipboard = e.clipboardData.getData('text');

      // loop over each letter pasted and if any fail prevent the paste
      _toConsumableArray(clipboard).forEach(function (c) {
        if (!regex.test(c)) {
          e.preventDefault();
          return false;
        }
      });
    },
    validateKey: function validateKey(e, key, keyfilter) {
      if (key === null || key === undefined) {
        return;
      }

      // some AZERTY keys come in with 2 chars like ´ç if Dead key is pressed first
      var isPrintableKey = key.length <= 2;
      if (!isPrintableKey) {
        return;
      }
      var regex = this.getRegex(keyfilter);
      if (!regex.test(key)) {
        e.preventDefault();
      }
    },
    validate: function validate(e, keyfilter) {
      var value = e.target.value;
      var validatePattern = true;
      var regex = this.getRegex(keyfilter);
      if (value && !regex.test(value)) {
        validatePattern = false;
      }
      return validatePattern;
    }
  };

  var classes$1d = {
    root: function root(_ref) {
      var props = _ref.props,
        isFilled = _ref.isFilled,
        context = _ref.context;
      return classNames('p-inputtext p-component', {
        'p-disabled': props.disabled,
        'p-filled': isFilled,
        'p-invalid': props.invalid,
        'p-variant-filled': props.variant ? props.variant === 'filled' : context && context.inputStyle === 'filled'
      });
    }
  };
  var InputTextBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'InputText',
      __parentMetadata: null,
      children: undefined,
      className: null,
      invalid: false,
      variant: null,
      keyfilter: null,
      onBeforeInput: null,
      onInput: null,
      onKeyDown: null,
      onPaste: null,
      tooltip: null,
      tooltipOptions: null,
      validateOnly: false,
      iconPosition: null
    },
    css: {
      classes: classes$1d
    }
  });

  function ownKeys$1R(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1R(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1R(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1R(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var InputText = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var mergeProps = useMergeProps();
    var context = React__namespace.useContext(PrimeReactContext);
    var props = InputTextBase.getProps(inProps, context);
    var _InputTextBase$setMet = InputTextBase.setMetaData(_objectSpread$1R(_objectSpread$1R({
        props: props
      }, props.__parentMetadata), {}, {
        context: {
          disabled: props.disabled,
          iconPosition: props.iconPosition
        }
      })),
      ptm = _InputTextBase$setMet.ptm,
      cx = _InputTextBase$setMet.cx,
      isUnstyled = _InputTextBase$setMet.isUnstyled;
    useHandleStyle(InputTextBase.css.styles, isUnstyled, {
      name: 'inputtext',
      styled: true
    });
    var elementRef = React__namespace.useRef(ref);
    var onKeyDown = function onKeyDown(event) {
      props.onKeyDown && props.onKeyDown(event);
      if (props.keyfilter) {
        KeyFilter.onKeyPress(event, props.keyfilter, props.validateOnly);
      }
    };
    var onBeforeInput = function onBeforeInput(event) {
      props.onBeforeInput && props.onBeforeInput(event);
      if (props.keyfilter) {
        KeyFilter.onBeforeInput(event, props.keyfilter, props.validateOnly);
      }
    };
    var onInput = function onInput(event) {
      var target = event.target;
      var validatePattern = true;
      if (props.keyfilter && props.validateOnly) {
        validatePattern = KeyFilter.validate(event, props.keyfilter);
      }
      props.onInput && props.onInput(event, validatePattern);

      // for uncontrolled changes
      ObjectUtils.isNotEmpty(target.value) ? DomHandler.addClass(target, 'p-filled') : DomHandler.removeClass(target, 'p-filled');
    };
    var onPaste = function onPaste(event) {
      props.onPaste && props.onPaste(event);
      if (props.keyfilter) {
        KeyFilter.onPaste(event, props.keyfilter, props.validateOnly);
      }
    };
    React__namespace.useEffect(function () {
      ObjectUtils.combinedRefs(elementRef, ref);
    }, [elementRef, ref]);
    var isFilled = React__namespace.useMemo(function () {
      return ObjectUtils.isNotEmpty(props.value) || ObjectUtils.isNotEmpty(props.defaultValue);
    }, [props.value, props.defaultValue]);
    var hasTooltip = ObjectUtils.isNotEmpty(props.tooltip);
    React__namespace.useEffect(function () {
      var _elementRef$current;
      if (isFilled || (_elementRef$current = elementRef.current) !== null && _elementRef$current !== void 0 && _elementRef$current.value) {
        DomHandler.addClass(elementRef.current, 'p-filled');
      } else {
        DomHandler.removeClass(elementRef.current, 'p-filled');
      }
    }, [props.disabled, isFilled]);
    var rootProps = mergeProps({
      className: classNames(props.className, cx('root', {
        context: context,
        isFilled: isFilled
      })),
      onBeforeInput: onBeforeInput,
      onInput: onInput,
      onKeyDown: onKeyDown,
      onPaste: onPaste
    }, InputTextBase.getOtherProps(props), ptm('root'));
    return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, null, /*#__PURE__*/React__namespace.createElement("input", _extends({
      ref: elementRef
    }, rootProps)), hasTooltip && /*#__PURE__*/React__namespace.createElement(Tooltip, _extends({
      target: elementRef,
      content: props.tooltip,
      pt: ptm('tooltip')
    }, props.tooltipOptions)));
  }));
  InputText.displayName = 'InputText';

  var OverlayService = EventBus();

  var classes$1c = {
    root: function root(_ref) {
      var props = _ref.props,
        focusedState = _ref.focusedState;
      return classNames('p-autocomplete p-component p-inputwrapper', {
        'p-autocomplete-dd': props.dropdown,
        'p-autocomplete-multiple': props.multiple,
        'p-inputwrapper-filled': props.value,
        'p-invalid': props.invalid,
        'p-inputwrapper-focus': focusedState
      });
    },
    container: function container(_ref2) {
      var props = _ref2.props,
        context = _ref2.context;
      return classNames('p-autocomplete-multiple-container p-component p-inputtext', {
        'p-disabled': props.disabled,
        'p-variant-filled': props.variant ? props.variant === 'filled' : context && context.inputStyle === 'filled'
      });
    },
    loadingIcon: 'p-autocomplete-loader',
    dropdownButton: 'p-autocomplete-dropdown',
    removeTokenIcon: 'p-autocomplete-token-icon',
    token: 'p-autocomplete-token p-highlight',
    tokenLabel: 'p-autocomplete-token-label',
    inputToken: 'p-autocomplete-input-token',
    input: function input(_ref3) {
      var props = _ref3.props,
        context = _ref3.context;
      return classNames('p-autocomplete-input', {
        'p-autocomplete-dd-input': props.dropdown,
        'p-variant-filled': props.variant ? props.variant === 'filled' : context && context.inputStyle === 'filled'
      });
    },
    panel: function panel(_ref4) {
      var context = _ref4.context;
      return classNames('p-autocomplete-panel p-component', {
        'p-ripple-disabled': context && context.ripple === false || PrimeReact.ripple === false
      });
    },
    listWrapper: 'p-autocomplete-items-wrapper',
    list: function list(_ref5) {
      var virtualScrollerOptions = _ref5.virtualScrollerOptions,
        options = _ref5.options;
      return virtualScrollerOptions ? classNames('p-autocomplete-items', options.className) : 'p-autocomplete-items';
    },
    emptyMessage: 'p-autocomplete-item',
    item: function item(_ref6) {
      var suggestion = _ref6.suggestion,
        optionGroupLabel = _ref6.optionGroupLabel,
        selected = _ref6.selected;
      return optionGroupLabel ? classNames('p-autocomplete-item', {
        'p-disabled': suggestion.disabled
      }, {
        selected: selected
      }) : classNames('p-autocomplete-item', {
        'p-disabled': suggestion.disabled
      }, {
        'p-highlight': selected
      });
    },
    itemGroup: 'p-autocomplete-item-group',
    footer: 'p-autocomplete-footer',
    transition: 'p-connected-overlay'
  };
  var styles$11 = "\n@layer primereact {\n    .p-autocomplete {\n        display: inline-flex;\n        position: relative;\n    }\n    \n    .p-autocomplete-loader {\n        position: absolute;\n        top: 50%;\n        margin-top: -.5rem;\n    }\n    \n    .p-autocomplete-dd .p-autocomplete-input {\n        flex: 1 1 auto;\n        width: 1%;\n    }\n    \n    .p-autocomplete-dd .p-autocomplete-input,\n    .p-autocomplete-dd .p-autocomplete-multiple-container {\n         border-top-right-radius: 0;\n         border-bottom-right-radius: 0;\n     }\n    \n    .p-autocomplete-dd .p-autocomplete-dropdown {\n         border-top-left-radius: 0;\n         border-bottom-left-radius: 0px;\n    }\n    \n    .p-autocomplete .p-autocomplete-panel {\n        min-width: 100%;\n    }\n    \n    .p-autocomplete-panel {\n        position: absolute;\n        top: 0;\n        left: 0;\n    }\n    \n    .p-autocomplete-items {\n        margin: 0;\n        padding: 0;\n        list-style-type: none;\n    }\n    \n    .p-autocomplete-item {\n        cursor: pointer;\n        white-space: nowrap;\n        position: relative;\n        overflow: hidden;\n    }\n    \n    .p-autocomplete-multiple-container {\n        margin: 0;\n        padding: 0;\n        list-style-type: none;\n        cursor: text;\n        overflow: hidden;\n        display: flex;\n        align-items: center;\n        flex-wrap: wrap;\n    }\n    \n    .p-autocomplete-token {\n        cursor: default;\n        display: inline-flex;\n        align-items: center;\n        flex: 0 0 auto;\n    }\n    \n    .p-autocomplete-token-icon {\n        cursor: pointer;\n    }\n    \n    .p-autocomplete-input-token {\n        flex: 1 1 auto;\n        display: inline-flex;\n    }\n    \n    .p-autocomplete-input-token input {\n        border: 0 none;\n        outline: 0 none;\n        background-color: transparent;\n        margin: 0;\n        padding: 0;\n        box-shadow: none;\n        border-radius: 0;\n        width: 100%;\n    }\n    \n    .p-fluid .p-autocomplete {\n        display: flex;\n    }\n    \n    .p-fluid .p-autocomplete-dd .p-autocomplete-input {\n        width: 1%;\n    }\n    \n    .p-autocomplete-items-wrapper {\n        overflow: auto;\n    } \n}\n";
  var AutoCompleteBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'AutoComplete',
      id: null,
      appendTo: null,
      autoFocus: false,
      autoHighlight: false,
      className: null,
      completeMethod: null,
      delay: 300,
      disabled: false,
      dropdown: false,
      dropdownAriaLabel: null,
      dropdownAutoFocus: true,
      dropdownIcon: null,
      dropdownMode: 'blank',
      emptyMessage: null,
      field: null,
      forceSelection: false,
      inputClassName: null,
      inputId: null,
      inputRef: null,
      inputStyle: null,
      variant: null,
      invalid: false,
      itemTemplate: null,
      loadingIcon: null,
      maxLength: null,
      minLength: 1,
      multiple: false,
      name: null,
      onBlur: null,
      onChange: null,
      onClear: null,
      onClick: null,
      onContextMenu: null,
      onDblClick: null,
      onDropdownClick: null,
      onFocus: null,
      onHide: null,
      onKeyPress: null,
      onKeyUp: null,
      onMouseDown: null,
      onSelect: null,
      onShow: null,
      onUnselect: null,
      optionGroupChildren: null,
      optionGroupLabel: null,
      optionGroupTemplate: null,
      panelClassName: null,
      panelFooterTemplate: null,
      panelStyle: null,
      placeholder: null,
      readOnly: false,
      removeTokenIcon: null,
      scrollHeight: '200px',
      selectedItemTemplate: null,
      selectionLimit: null,
      showEmptyMessage: false,
      size: null,
      style: null,
      suggestions: null,
      tabIndex: null,
      tooltip: null,
      tooltipOptions: null,
      transitionOptions: null,
      type: 'text',
      value: null,
      virtualScrollerOptions: null,
      children: undefined
    },
    css: {
      classes: classes$1c,
      styles: styles$11
    }
  });

  var styles$10 = "\n.p-virtualscroller {\n    position: relative;\n    overflow: auto;\n    contain: strict;\n    transform: translateZ(0);\n    will-change: scroll-position;\n    outline: 0 none;\n}\n\n.p-virtualscroller-content {\n    position: absolute;\n    top: 0;\n    left: 0;\n    /*contain: content;*/\n    min-height: 100%;\n    min-width: 100%;\n    will-change: transform;\n}\n\n.p-virtualscroller-spacer {\n    position: absolute;\n    top: 0;\n    left: 0;\n    height: 1px;\n    width: 1px;\n    transform-origin: 0 0;\n    pointer-events: none;\n}\n\n.p-virtualscroller-loader {\n    position: sticky;\n    top: 0;\n    left: 0;\n    width: 100%;\n    height: 100%;\n}\n\n.p-virtualscroller-loader.p-component-overlay {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n}\n\n.p-virtualscroller-loading-icon {\n    font-size: 2rem;\n}\n\n.p-virtualscroller-horizontal > .p-virtualscroller-content {\n    display: flex;\n}\n\n/* Inline */\n.p-virtualscroller-inline .p-virtualscroller-content {\n    position: static;\n}\n";
  var VirtualScrollerBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'VirtualScroller',
      __parentMetadata: null,
      id: null,
      style: null,
      className: null,
      tabIndex: 0,
      items: null,
      itemSize: 0,
      scrollHeight: null,
      scrollWidth: null,
      orientation: 'vertical',
      step: 0,
      numToleratedItems: null,
      delay: 0,
      resizeDelay: 10,
      appendOnly: false,
      inline: false,
      lazy: false,
      disabled: false,
      loaderDisabled: false,
      loadingIcon: null,
      columns: null,
      loading: undefined,
      autoSize: false,
      showSpacer: true,
      showLoader: false,
      loadingTemplate: null,
      loaderIconTemplate: null,
      itemTemplate: null,
      contentTemplate: null,
      onScroll: null,
      onScrollIndexChange: null,
      onLazyLoad: null,
      children: undefined
    },
    css: {
      styles: styles$10
    }
  });

  function ownKeys$1Q(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1Q(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1Q(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1Q(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var VirtualScroller = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var mergeProps = useMergeProps();
    var context = React__namespace.useContext(PrimeReactContext);
    var props = VirtualScrollerBase.getProps(inProps, context);
    var prevProps = usePrevious(inProps) || {};
    var vertical = props.orientation === 'vertical';
    var horizontal = props.orientation === 'horizontal';
    var both = props.orientation === 'both';
    var _React$useState = React__namespace.useState(both ? {
        rows: 0,
        cols: 0
      } : 0),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      firstState = _React$useState2[0],
      setFirstState = _React$useState2[1];
    var _React$useState3 = React__namespace.useState(both ? {
        rows: 0,
        cols: 0
      } : 0),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      lastState = _React$useState4[0],
      setLastState = _React$useState4[1];
    var _React$useState5 = React__namespace.useState(0),
      _React$useState6 = _slicedToArray(_React$useState5, 2),
      pageState = _React$useState6[0],
      setPageState = _React$useState6[1];
    var _React$useState7 = React__namespace.useState(both ? {
        rows: 0,
        cols: 0
      } : 0),
      _React$useState8 = _slicedToArray(_React$useState7, 2),
      numItemsInViewportState = _React$useState8[0],
      setNumItemsInViewportState = _React$useState8[1];
    var _React$useState9 = React__namespace.useState(props.numToleratedItems),
      _React$useState10 = _slicedToArray(_React$useState9, 2),
      numToleratedItemsState = _React$useState10[0],
      setNumToleratedItemsState = _React$useState10[1];
    var _React$useState11 = React__namespace.useState(props.loading || false),
      _React$useState12 = _slicedToArray(_React$useState11, 2),
      loadingState = _React$useState12[0],
      setLoadingState = _React$useState12[1];
    var _React$useState13 = React__namespace.useState([]),
      _React$useState14 = _slicedToArray(_React$useState13, 2),
      loaderArrState = _React$useState14[0],
      setLoaderArrState = _React$useState14[1];
    var _VirtualScrollerBase$ = VirtualScrollerBase.setMetaData({
        props: props,
        state: {
          first: firstState,
          last: lastState,
          page: pageState,
          numItemsInViewport: numItemsInViewportState,
          numToleratedItems: numToleratedItemsState,
          loading: loadingState,
          loaderArr: loaderArrState
        }
      }),
      ptm = _VirtualScrollerBase$.ptm;
    useStyle(VirtualScrollerBase.css.styles, {
      name: 'virtualscroller'
    });
    var elementRef = React__namespace.useRef(null);
    var _contentRef = React__namespace.useRef(null);
    var _spacerRef = React__namespace.useRef(null);
    var _stickyRef = React__namespace.useRef(null);
    var lastScrollPos = React__namespace.useRef(both ? {
      top: 0,
      left: 0
    } : 0);
    var scrollTimeout = React__namespace.useRef(null);
    var resizeTimeout = React__namespace.useRef(null);
    var contentStyle = React__namespace.useRef({});
    var spacerStyle = React__namespace.useRef({});
    var defaultWidth = React__namespace.useRef(null);
    var defaultHeight = React__namespace.useRef(null);
    var defaultContentWidth = React__namespace.useRef(null);
    var defaultContentHeight = React__namespace.useRef(null);
    var isItemRangeChanged = React__namespace.useRef(false);
    var lazyLoadState = React__namespace.useRef(null);
    var viewInitialized = React__namespace.useRef(false);
    var _useResizeListener = useResizeListener({
        listener: function listener(event) {
          return onResize();
        },
        when: !props.disabled
      }),
      _useResizeListener2 = _slicedToArray(_useResizeListener, 1),
      bindWindowResizeListener = _useResizeListener2[0];
    var _useEventListener = useEventListener({
        target: 'window',
        type: 'orientationchange',
        listener: function listener(event) {
          return onResize();
        },
        when: !props.disabled
      }),
      _useEventListener2 = _slicedToArray(_useEventListener, 1),
      bindOrientationChangeListener = _useEventListener2[0];
    var getElementRef = function getElementRef() {
      return elementRef;
    };
    var getPageByFirst = function getPageByFirst(first) {
      return Math.floor((first + numToleratedItemsState * 4) / (props.step || 1));
    };
    var setContentElement = function setContentElement(element) {
      _contentRef.current = element || _contentRef.current || DomHandler.findSingle(elementRef.current, '.p-virtualscroller-content');
    };
    var isPageChanged = function isPageChanged(first) {
      return props.step ? pageState !== getPageByFirst(first) : true;
    };
    var scrollTo = function scrollTo(options) {
      lastScrollPos.current = both ? {
        top: 0,
        left: 0
      } : 0;
      elementRef.current && elementRef.current.scrollTo(options);
    };
    var scrollToIndex = function scrollToIndex(index) {
      var behavior = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'auto';
      var _calculateNumItems = calculateNumItems(),
        numToleratedItems = _calculateNumItems.numToleratedItems;
      var contentPos = getContentPosition();
      var calculateFirst = function calculateFirst() {
        var _index = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
        var _numT = arguments.length > 1 ? arguments[1] : undefined;
        return _index <= _numT ? 0 : _index;
      };
      var calculateCoord = function calculateCoord(_first, _size, _cpos) {
        return _first * _size + _cpos;
      };
      var scrollToItem = function scrollToItem() {
        var left = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
        var top = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
        return scrollTo({
          left: left,
          top: top,
          behavior: behavior
        });
      };
      var newFirst = both ? {
        rows: 0,
        cols: 0
      } : 0;
      var isRangeChanged = false;
      if (both) {
        newFirst = {
          rows: calculateFirst(index[0], numToleratedItems[0]),
          cols: calculateFirst(index[1], numToleratedItems[1])
        };
        scrollToItem(calculateCoord(newFirst.cols, props.itemSize[1], contentPos.left), calculateCoord(newFirst.rows, props.itemSize[0], contentPos.top));
        isRangeChanged = firstState.rows !== newFirst.rows || firstState.cols !== newFirst.cols;
      } else {
        newFirst = calculateFirst(index, numToleratedItems);
        horizontal ? scrollToItem(calculateCoord(newFirst, props.itemSize, contentPos.left), 0) : scrollToItem(0, calculateCoord(newFirst, props.itemSize, contentPos.top));
        isRangeChanged = firstState !== newFirst;
      }
      isItemRangeChanged.current = isRangeChanged;
      setFirstState(newFirst);
    };
    var scrollInView = function scrollInView(index, to) {
      var behavior = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'auto';
      if (to) {
        var _getRenderedRange = getRenderedRange(),
          first = _getRenderedRange.first,
          viewport = _getRenderedRange.viewport;
        var scrollToItem = function scrollToItem() {
          var left = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
          var top = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
          return scrollTo({
            left: left,
            top: top,
            behavior: behavior
          });
        };
        var isToStart = to === 'to-start';
        var isToEnd = to === 'to-end';
        if (isToStart) {
          if (both) {
            if (viewport.first.rows - first.rows > index[0]) {
              scrollToItem(viewport.first.cols * props.itemSize[1], (viewport.first.rows - 1) * props.itemSize[0]);
            } else if (viewport.first.cols - first.cols > index[1]) {
              scrollToItem((viewport.first.cols - 1) * props.itemSize[1], viewport.first.rows * props.itemSize[0]);
            }
          } else if (viewport.first - first > index) {
            var pos = (viewport.first - 1) * props.itemSize;
            horizontal ? scrollToItem(pos, 0) : scrollToItem(0, pos);
          }
        } else if (isToEnd) {
          if (both) {
            if (viewport.last.rows - first.rows <= index[0] + 1) {
              scrollToItem(viewport.first.cols * props.itemSize[1], (viewport.first.rows + 1) * props.itemSize[0]);
            } else if (viewport.last.cols - first.cols <= index[1] + 1) {
              scrollToItem((viewport.first.cols + 1) * props.itemSize[1], viewport.first.rows * props.itemSize[0]);
            }
          } else if (viewport.last - first <= index + 1) {
            var _pos2 = (viewport.first + 1) * props.itemSize;
            horizontal ? scrollToItem(_pos2, 0) : scrollToItem(0, _pos2);
          }
        }
      } else {
        scrollToIndex(index, behavior);
      }
    };
    var getRows = function getRows() {
      return loadingState ? props.loaderDisabled ? loaderArrState : [] : loadedItems();
    };
    var getColumns = function getColumns() {
      if (props.columns && both || horizontal) {
        return loadingState && props.loaderDisabled ? both ? loaderArrState[0] : loaderArrState : props.columns.slice(both ? firstState.cols : firstState, both ? lastState.cols : lastState);
      }
      return props.columns;
    };
    var getRenderedRange = function getRenderedRange() {
      var calculateFirstInViewport = function calculateFirstInViewport(_pos, _size) {
        return Math.floor(_pos / (_size || _pos));
      };
      var firstInViewport = firstState;
      var lastInViewport = 0;
      if (elementRef.current) {
        var _elementRef$current = elementRef.current,
          scrollTop = _elementRef$current.scrollTop,
          scrollLeft = _elementRef$current.scrollLeft;
        if (both) {
          firstInViewport = {
            rows: calculateFirstInViewport(scrollTop, props.itemSize[0]),
            cols: calculateFirstInViewport(scrollLeft, props.itemSize[1])
          };
          lastInViewport = {
            rows: firstInViewport.rows + numItemsInViewportState.rows,
            cols: firstInViewport.cols + numItemsInViewportState.cols
          };
        } else {
          var scrollPos = horizontal ? scrollLeft : scrollTop;
          firstInViewport = calculateFirstInViewport(scrollPos, props.itemSize);
          lastInViewport = firstInViewport + numItemsInViewportState;
        }
      }
      return {
        first: firstState,
        last: lastState,
        viewport: {
          first: firstInViewport,
          last: lastInViewport
        }
      };
    };
    var calculateNumItems = function calculateNumItems() {
      var contentPos = getContentPosition();
      var contentWidth = elementRef.current ? elementRef.current.offsetWidth - contentPos.left : 0;
      var contentHeight = elementRef.current ? elementRef.current.offsetHeight - contentPos.top : 0;
      var calculateNumItemsInViewport = function calculateNumItemsInViewport(_contentSize, _itemSize) {
        return Math.ceil(_contentSize / (_itemSize || _contentSize));
      };
      var calculateNumToleratedItems = function calculateNumToleratedItems(_numItems) {
        return Math.ceil(_numItems / 2);
      };
      var numItemsInViewport = both ? {
        rows: calculateNumItemsInViewport(contentHeight, props.itemSize[0]),
        cols: calculateNumItemsInViewport(contentWidth, props.itemSize[1])
      } : calculateNumItemsInViewport(horizontal ? contentWidth : contentHeight, props.itemSize);
      var numToleratedItems = numToleratedItemsState || (both ? [calculateNumToleratedItems(numItemsInViewport.rows), calculateNumToleratedItems(numItemsInViewport.cols)] : calculateNumToleratedItems(numItemsInViewport));
      return {
        numItemsInViewport: numItemsInViewport,
        numToleratedItems: numToleratedItems
      };
    };
    var calculateOptions = function calculateOptions() {
      var _calculateNumItems2 = calculateNumItems(),
        numItemsInViewport = _calculateNumItems2.numItemsInViewport,
        numToleratedItems = _calculateNumItems2.numToleratedItems;
      var calculateLast = function calculateLast(_first, _num, _numT) {
        var _isCols = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
        return getLast(_first + _num + (_first < _numT ? 2 : 3) * _numT, _isCols);
      };
      var last = both ? {
        rows: calculateLast(firstState.rows, numItemsInViewport.rows, numToleratedItems[0]),
        cols: calculateLast(firstState.cols, numItemsInViewport.cols, numToleratedItems[1], true)
      } : calculateLast(firstState, numItemsInViewport, numToleratedItems);
      setNumItemsInViewportState(numItemsInViewport);
      setNumToleratedItemsState(numToleratedItems);
      setLastState(last);
      if (props.showLoader) {
        setLoaderArrState(both ? Array.from({
          length: numItemsInViewport.rows
        }).map(function () {
          return Array.from({
            length: numItemsInViewport.cols
          });
        }) : Array.from({
          length: numItemsInViewport
        }));
      }
      if (props.lazy) {
        Promise.resolve().then(function () {
          lazyLoadState.current = {
            first: props.step ? both ? {
              rows: 0,
              cols: firstState.cols
            } : 0 : firstState,
            last: Math.min(props.step ? props.step : last, (props.items || []).length)
          };
          props.onLazyLoad && props.onLazyLoad(lazyLoadState.current);
        });
      }
    };
    var calculateAutoSize = function calculateAutoSize(loading) {
      if (props.autoSize && !loading) {
        Promise.resolve().then(function () {
          if (_contentRef.current) {
            _contentRef.current.style.minHeight = _contentRef.current.style.minWidth = 'auto';
            _contentRef.current.style.position = 'relative';
            elementRef.current.style.contain = 'none';

            /*const [contentWidth, contentHeight] = [DomHandler.getWidth(contentRef.current), DomHandler.getHeight(contentRef.current)];
             contentWidth !== defaultContentWidth.current && (elementRef.current.style.width = '');
            contentHeight !== defaultContentHeight.current && (elementRef.current.style.height = '');*/

            var _ref = [DomHandler.getWidth(elementRef.current), DomHandler.getHeight(elementRef.current)],
              width = _ref[0],
              height = _ref[1];
            (both || horizontal) && (elementRef.current.style.width = (width < defaultWidth.current ? width : props.scrollWidth || defaultWidth.current) + 'px');
            (both || vertical) && (elementRef.current.style.height = (height < defaultHeight.current ? height : props.scrollHeight || defaultHeight.current) + 'px');
            _contentRef.current.style.minHeight = _contentRef.current.style.minWidth = '';
            _contentRef.current.style.position = '';
            elementRef.current.style.contain = '';
          }
        });
      }
    };
    var getLast = function getLast() {
      var _ref2;
      var last = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
      var isCols = arguments.length > 1 ? arguments[1] : undefined;
      return props.items ? Math.min(isCols ? ((_ref2 = props.columns || props.items[0]) === null || _ref2 === void 0 ? void 0 : _ref2.length) || 0 : (props.items || []).length, last) : 0;
    };
    var getContentPosition = function getContentPosition() {
      if (_contentRef.current) {
        var style = getComputedStyle(_contentRef.current);
        var left = parseFloat(style.paddingLeft) + Math.max(parseFloat(style.left) || 0, 0);
        var right = parseFloat(style.paddingRight) + Math.max(parseFloat(style.right) || 0, 0);
        var top = parseFloat(style.paddingTop) + Math.max(parseFloat(style.top) || 0, 0);
        var bottom = parseFloat(style.paddingBottom) + Math.max(parseFloat(style.bottom) || 0, 0);
        return {
          left: left,
          right: right,
          top: top,
          bottom: bottom,
          x: left + right,
          y: top + bottom
        };
      }
      return {
        left: 0,
        right: 0,
        top: 0,
        bottom: 0,
        x: 0,
        y: 0
      };
    };
    var setSize = function setSize() {
      if (elementRef.current) {
        var parentElement = elementRef.current.parentElement;
        var width = props.scrollWidth || "".concat(elementRef.current.offsetWidth || parentElement.offsetWidth, "px");
        var height = props.scrollHeight || "".concat(elementRef.current.offsetHeight || parentElement.offsetHeight, "px");
        var setProp = function setProp(_name, _value) {
          return elementRef.current.style[_name] = _value;
        };
        if (both || horizontal) {
          setProp('height', height);
          setProp('width', width);
        } else {
          setProp('height', height);
        }
      }
    };
    var setSpacerSize = function setSpacerSize() {
      var items = props.items;
      if (items) {
        var contentPos = getContentPosition();
        var setProp = function setProp(_name, _value, _size) {
          var _cpos = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
          return spacerStyle.current = _objectSpread$1Q(_objectSpread$1Q({}, spacerStyle.current), _defineProperty({}, "".concat(_name), (_value || []).length * _size + _cpos + 'px'));
        };
        if (both) {
          setProp('height', items, props.itemSize[0], contentPos.y);
          setProp('width', props.columns || items[1], props.itemSize[1], contentPos.x);
        } else {
          horizontal ? setProp('width', props.columns || items, props.itemSize, contentPos.x) : setProp('height', items, props.itemSize, contentPos.y);
        }
      }
    };
    var setContentPosition = function setContentPosition(pos) {
      if (_contentRef.current && !props.appendOnly) {
        var first = pos ? pos.first : firstState;
        var calculateTranslateVal = function calculateTranslateVal(_first, _size) {
          return _first * _size;
        };
        var setTransform = function setTransform() {
          var _x = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
          var _y = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
          _stickyRef.current && (_stickyRef.current.style.top = "-".concat(_y, "px"));
          contentStyle.current = _objectSpread$1Q(_objectSpread$1Q({}, contentStyle.current), {
            transform: "translate3d(".concat(_x, "px, ").concat(_y, "px, 0)")
          });
        };
        if (both) {
          setTransform(calculateTranslateVal(first.cols, props.itemSize[1]), calculateTranslateVal(first.rows, props.itemSize[0]));
        } else {
          var translateVal = calculateTranslateVal(first, props.itemSize);
          horizontal ? setTransform(translateVal, 0) : setTransform(0, translateVal);
        }
      }
    };
    var onScrollPositionChange = function onScrollPositionChange(event) {
      var target = event.target;
      var contentPos = getContentPosition();
      var calculateScrollPos = function calculateScrollPos(_pos, _cpos) {
        return _pos ? _pos > _cpos ? _pos - _cpos : _pos : 0;
      };
      var calculateCurrentIndex = function calculateCurrentIndex(_pos, _size) {
        return Math.floor(_pos / (_size || _pos));
      };
      var calculateTriggerIndex = function calculateTriggerIndex(_currentIndex, _first, _last, _num, _numT, _isScrollDownOrRight) {
        return _currentIndex <= _numT ? _numT : _isScrollDownOrRight ? _last - _num - _numT : _first + _numT - 1;
      };
      var calculateFirst = function calculateFirst(_currentIndex, _triggerIndex, _first, _last, _num, _numT, _isScrollDownOrRight) {
        if (_currentIndex <= _numT) {
          return 0;
        }
        return Math.max(0, _isScrollDownOrRight ? _currentIndex < _triggerIndex ? _first : _currentIndex - _numT : _currentIndex > _triggerIndex ? _first : _currentIndex - 2 * _numT);
      };
      var calculateLast = function calculateLast(_currentIndex, _first, _last, _num, _numT, _isCols) {
        var lastValue = _first + _num + 2 * _numT;
        if (_currentIndex >= _numT) {
          lastValue = lastValue + (_numT + 1);
        }
        return getLast(lastValue, _isCols);
      };
      var scrollTop = calculateScrollPos(target.scrollTop, contentPos.top);
      var scrollLeft = calculateScrollPos(target.scrollLeft, contentPos.left);
      var newFirst = both ? {
        rows: 0,
        cols: 0
      } : 0;
      var newLast = lastState;
      var isRangeChanged = false;
      var newScrollPos = lastScrollPos.current;
      if (both) {
        var isScrollDown = lastScrollPos.current.top <= scrollTop;
        var isScrollRight = lastScrollPos.current.left <= scrollLeft;
        if (!props.appendOnly || props.appendOnly && (isScrollDown || isScrollRight)) {
          var currentIndex = {
            rows: calculateCurrentIndex(scrollTop, props.itemSize[0]),
            cols: calculateCurrentIndex(scrollLeft, props.itemSize[1])
          };
          var triggerIndex = {
            rows: calculateTriggerIndex(currentIndex.rows, firstState.rows, lastState.rows, numItemsInViewportState.rows, numToleratedItemsState[0], isScrollDown),
            cols: calculateTriggerIndex(currentIndex.cols, firstState.cols, lastState.cols, numItemsInViewportState.cols, numToleratedItemsState[1], isScrollRight)
          };
          newFirst = {
            rows: calculateFirst(currentIndex.rows, triggerIndex.rows, firstState.rows, lastState.rows, numItemsInViewportState.rows, numToleratedItemsState[0], isScrollDown),
            cols: calculateFirst(currentIndex.cols, triggerIndex.cols, firstState.cols, lastState.cols, numItemsInViewportState.cols, numToleratedItemsState[1], isScrollRight)
          };
          newLast = {
            rows: calculateLast(currentIndex.rows, newFirst.rows, lastState.rows, numItemsInViewportState.rows, numToleratedItemsState[0]),
            cols: calculateLast(currentIndex.cols, newFirst.cols, lastState.cols, numItemsInViewportState.cols, numToleratedItemsState[1], true)
          };
          isRangeChanged = newFirst.rows !== firstState.rows || newLast.rows !== lastState.rows || newFirst.cols !== firstState.cols || newLast.cols !== lastState.cols || isItemRangeChanged.current;
          newScrollPos = {
            top: scrollTop,
            left: scrollLeft
          };
        }
      } else {
        var scrollPos = horizontal ? scrollLeft : scrollTop;
        var isScrollDownOrRight = lastScrollPos.current <= scrollPos;
        if (!props.appendOnly || props.appendOnly && isScrollDownOrRight) {
          var _currentIndex2 = calculateCurrentIndex(scrollPos, props.itemSize);
          var _triggerIndex2 = calculateTriggerIndex(_currentIndex2, firstState, lastState, numItemsInViewportState, numToleratedItemsState, isScrollDownOrRight);
          newFirst = calculateFirst(_currentIndex2, _triggerIndex2, firstState, lastState, numItemsInViewportState, numToleratedItemsState, isScrollDownOrRight);
          newLast = calculateLast(_currentIndex2, newFirst, lastState, numItemsInViewportState, numToleratedItemsState);
          isRangeChanged = newFirst !== firstState || newLast !== lastState || isItemRangeChanged.current;
          newScrollPos = scrollPos;
        }
      }
      return {
        first: newFirst,
        last: newLast,
        isRangeChanged: isRangeChanged,
        scrollPos: newScrollPos
      };
    };
    var onScrollChange = function onScrollChange(event) {
      var _onScrollPositionChan = onScrollPositionChange(event),
        first = _onScrollPositionChan.first,
        last = _onScrollPositionChan.last,
        isRangeChanged = _onScrollPositionChan.isRangeChanged,
        scrollPos = _onScrollPositionChan.scrollPos;
      if (isRangeChanged) {
        var newState = {
          first: first,
          last: last
        };
        setContentPosition(newState);
        setFirstState(first);
        setLastState(last);
        lastScrollPos.current = scrollPos;
        props.onScrollIndexChange && props.onScrollIndexChange(newState);
        if (props.lazy && isPageChanged(first)) {
          var newLazyLoadState = {
            first: props.step ? Math.min(getPageByFirst(first) * props.step, (props.items || []).length - props.step) : first,
            last: Math.min(props.step ? (getPageByFirst(first) + 1) * props.step : last, (props.items || []).length)
          };
          var isLazyStateChanged = !lazyLoadState.current || lazyLoadState.current.first !== newLazyLoadState.first || lazyLoadState.current.last !== newLazyLoadState.last;
          isLazyStateChanged && props.onLazyLoad && props.onLazyLoad(newLazyLoadState);
          lazyLoadState.current = newLazyLoadState;
        }
      }
    };
    var _onScroll = function onScroll(event) {
      props.onScroll && props.onScroll(event);
      if (props.delay) {
        if (scrollTimeout.current) {
          clearTimeout(scrollTimeout.current);
        }
        if (isPageChanged(firstState)) {
          if (!loadingState && props.showLoader) {
            var _onScrollPositionChan2 = onScrollPositionChange(event),
              isRangeChanged = _onScrollPositionChan2.isRangeChanged;
            var changed = isRangeChanged || (props.step ? isPageChanged(firstState) : false);
            changed && setLoadingState(true);
          }
          scrollTimeout.current = setTimeout(function () {
            onScrollChange(event);
            if (loadingState && props.showLoader && (!props.lazy || props.loading === undefined)) {
              setLoadingState(false);
              setPageState(getPageByFirst(firstState));
            }
          }, props.delay);
        }
      } else {
        onScrollChange(event);
      }
    };
    var onResize = function onResize() {
      if (resizeTimeout.current) {
        clearTimeout(resizeTimeout.current);
      }
      resizeTimeout.current = setTimeout(function () {
        if (elementRef.current) {
          var _ref3 = [DomHandler.getWidth(elementRef.current), DomHandler.getHeight(elementRef.current)],
            width = _ref3[0],
            height = _ref3[1];
          var isDiffWidth = width !== defaultWidth.current,
            isDiffHeight = height !== defaultHeight.current;
          var reinit = both ? isDiffWidth || isDiffHeight : horizontal ? isDiffWidth : vertical ? isDiffHeight : false;
          if (reinit) {
            setNumToleratedItemsState(props.numToleratedItems);
            defaultWidth.current = width;
            defaultHeight.current = height;
            defaultContentWidth.current = DomHandler.getWidth(_contentRef.current);
            defaultContentHeight.current = DomHandler.getHeight(_contentRef.current);
          }
        }
      }, props.resizeDelay);
    };
    var getOptions = function getOptions(renderedIndex) {
      var count = (props.items || []).length;
      var index = both ? firstState.rows + renderedIndex : firstState + renderedIndex;
      return {
        index: index,
        count: count,
        first: index === 0,
        last: index === count - 1,
        even: index % 2 === 0,
        odd: index % 2 !== 0,
        props: props
      };
    };
    var loaderOptions = function loaderOptions(index, extOptions) {
      var count = loaderArrState.length || 0;
      return _objectSpread$1Q({
        index: index,
        count: count,
        first: index === 0,
        last: index === count - 1,
        even: index % 2 === 0,
        odd: index % 2 !== 0,
        props: props
      }, extOptions);
    };
    var loadedItems = function loadedItems() {
      var items = props.items;
      if (items && !loadingState) {
        if (both) {
          return items.slice(props.appendOnly ? 0 : firstState.rows, lastState.rows).map(function (item) {
            return props.columns ? item : item.slice(props.appendOnly ? 0 : firstState.cols, lastState.cols);
          });
        } else if (horizontal && props.columns) {
          return items;
        }
        return items.slice(props.appendOnly ? 0 : firstState, lastState);
      }
      return [];
    };
    var viewInit = function viewInit() {
      if (elementRef.current && isVisible()) {
        setContentElement(_contentRef.current);
        init();
        bindWindowResizeListener();
        bindOrientationChangeListener();
        defaultWidth.current = DomHandler.getWidth(elementRef.current);
        defaultHeight.current = DomHandler.getHeight(elementRef.current);
        defaultContentWidth.current = DomHandler.getWidth(_contentRef.current);
        defaultContentHeight.current = DomHandler.getHeight(_contentRef.current);
      }
    };
    var init = function init() {
      if (!props.disabled && isVisible()) {
        setSize();
        calculateOptions();
        setSpacerSize();
      }
    };
    var isVisible = function isVisible() {
      if (DomHandler.isVisible(elementRef.current)) {
        var rect = elementRef.current.getBoundingClientRect();
        return rect.width > 0 && rect.height > 0;
      }
      return false;
    };
    React__namespace.useEffect(function () {
      if (!viewInitialized.current && isVisible()) {
        viewInit();
        viewInitialized.current = true;
      }
    });
    useUpdateEffect(function () {
      init();
    }, [props.itemSize, props.scrollHeight, props.scrollWidth]);
    useUpdateEffect(function () {
      if (props.numToleratedItems !== numToleratedItemsState) {
        setNumToleratedItemsState(props.numToleratedItems);
      }
    }, [props.numToleratedItems]);
    useUpdateEffect(function () {
      if (props.numToleratedItems === numToleratedItemsState) {
        init(); // reinit after resizing
      }
    }, [numToleratedItemsState]);
    useUpdateEffect(function () {
      // Check if the previous/current rows array exists
      var prevRowsExist = prevProps.items !== undefined && prevProps.items !== null;
      var currentRowsExist = props.items !== undefined && props.items !== null;

      // Get the length of the previous/current rows array, or 0 if it doesn't exist
      var prevRowsLength = prevRowsExist ? prevProps.items.length : 0;
      var currentRowsLength = currentRowsExist ? props.items.length : 0;

      // Check if the length of the rows arrays has changed
      var valuesChanged = prevRowsLength !== currentRowsLength;

      // If both is true, we also need to check the lengths of the first element (assuming it's a matrix)
      if (both && !valuesChanged) {
        // Get the length of the columns or 0
        var prevColumnsLength = prevRowsExist && prevProps.items.length > 0 ? prevProps.items[0].length : 0;
        var currentColumnsLength = currentRowsExist && props.items.length > 0 ? props.items[0].length : 0;

        // Check if the length of the columns has changed
        valuesChanged = prevColumnsLength !== currentColumnsLength;
      }

      // If the previous items array doesn't exist or if any values have changed, call the init function
      if (!prevRowsExist || valuesChanged) {
        init();
      }
      var loading = loadingState;
      if (props.lazy && prevProps.loading !== props.loading && props.loading !== loadingState) {
        setLoadingState(props.loading);
        loading = props.loading;
      }
      calculateAutoSize(loading);
    });
    useUpdateEffect(function () {
      lastScrollPos.current = both ? {
        top: 0,
        left: 0
      } : 0;
    }, [props.orientation]);
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        getElementRef: getElementRef,
        scrollTo: scrollTo,
        scrollToIndex: scrollToIndex,
        scrollInView: scrollInView,
        getRenderedRange: getRenderedRange
      };
    });
    var createLoaderItem = function createLoaderItem(index) {
      var extOptions = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var options = loaderOptions(index, extOptions);
      var content = ObjectUtils.getJSXElement(props.loadingTemplate, options);
      return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, {
        key: index
      }, content);
    };
    var createLoader = function createLoader() {
      var iconClassName = 'p-virtualscroller-loading-icon';
      var loadingIconProps = mergeProps({
        className: iconClassName
      }, ptm('loadingIcon'));
      var icon = props.loadingIcon || /*#__PURE__*/React__namespace.createElement(SpinnerIcon, _extends({}, loadingIconProps, {
        spin: true
      }));
      var loadingIcon = IconUtils.getJSXIcon(icon, _objectSpread$1Q({}, loadingIconProps), {
        props: props
      });
      if (!props.loaderDisabled && props.showLoader && loadingState) {
        var _className = classNames('p-virtualscroller-loader', {
          'p-component-overlay': !props.loadingTemplate
        });
        var _content = loadingIcon;
        if (props.loadingTemplate) {
          _content = loaderArrState.map(function (_, index) {
            return createLoaderItem(index, both && {
              numCols: numItemsInViewportState.cols
            });
          });
        } else if (props.loaderIconTemplate) {
          var defaultContentOptions = {
            iconClassName: iconClassName,
            element: _content,
            props: props
          };
          _content = ObjectUtils.getJSXElement(props.loaderIconTemplate, defaultContentOptions);
        }
        var loaderProps = mergeProps({
          className: _className
        }, ptm('loader'));
        return /*#__PURE__*/React__namespace.createElement("div", loaderProps, _content);
      }
      return null;
    };
    var createSpacer = function createSpacer() {
      if (props.showSpacer) {
        var spacerProps = mergeProps({
          ref: _spacerRef,
          style: spacerStyle.current,
          className: 'p-virtualscroller-spacer'
        }, ptm('spacer'));
        return /*#__PURE__*/React__namespace.createElement("div", spacerProps);
      }
      return null;
    };
    var createItem = function createItem(item, index) {
      var options = getOptions(index);
      var content = ObjectUtils.getJSXElement(props.itemTemplate, item, options);
      return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, {
        key: options.index
      }, content);
    };
    var createItems = function createItems() {
      var items = loadedItems();
      return items.map(createItem);
    };
    var createContent = function createContent() {
      var items = createItems();
      var className = classNames('p-virtualscroller-content', {
        'p-virtualscroller-loading': loadingState
      });
      var contentProps = mergeProps({
        ref: _contentRef,
        style: contentStyle.current,
        className: className
      }, ptm('content'));
      var content = /*#__PURE__*/React__namespace.createElement("div", contentProps, items);
      if (props.contentTemplate) {
        var defaultOptions = {
          style: contentStyle.current,
          className: className,
          spacerStyle: spacerStyle.current,
          contentRef: function contentRef(el) {
            return _contentRef.current = ObjectUtils.getRefElement(el);
          },
          spacerRef: function spacerRef(el) {
            return _spacerRef.current = ObjectUtils.getRefElement(el);
          },
          stickyRef: function stickyRef(el) {
            return _stickyRef.current = ObjectUtils.getRefElement(el);
          },
          items: loadedItems(),
          getItemOptions: function getItemOptions(index) {
            return getOptions(index);
          },
          children: items,
          element: content,
          props: props,
          loading: loadingState,
          getLoaderOptions: function getLoaderOptions(index, ext) {
            return loaderOptions(index, ext);
          },
          loadingTemplate: props.loadingTemplate,
          itemSize: props.itemSize,
          rows: getRows(),
          columns: getColumns(),
          vertical: vertical,
          horizontal: horizontal,
          both: both
        };
        return ObjectUtils.getJSXElement(props.contentTemplate, defaultOptions);
      }
      return content;
    };
    if (props.disabled) {
      var _content2 = ObjectUtils.getJSXElement(props.contentTemplate, {
        items: props.items,
        rows: props.items,
        columns: props.columns
      });
      return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, null, props.children, _content2);
    }
    var className = classNames('p-virtualscroller', {
      'p-virtualscroller-inline': props.inline,
      'p-virtualscroller-both p-both-scroll': both,
      'p-virtualscroller-horizontal p-horizontal-scroll': horizontal
    }, props.className);
    var loader = createLoader();
    var content = createContent();
    var spacer = createSpacer();
    var rootProps = mergeProps({
      ref: elementRef,
      className: className,
      tabIndex: props.tabIndex,
      style: props.style,
      onScroll: function onScroll(e) {
        return _onScroll(e);
      }
    }, VirtualScrollerBase.getOtherProps(props), ptm('root'));
    return /*#__PURE__*/React__namespace.createElement("div", rootProps, content, spacer, loader);
  }));
  VirtualScroller.displayName = 'VirtualScroller';

  function ownKeys$1P(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1P(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1P(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1P(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var AutoCompletePanel = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (props, ref) {
    var mergeProps = useMergeProps();
    var ptm = props.ptm,
      cx = props.cx;
    var context = React__namespace.useContext(PrimeReactContext);
    var _ptm = function _ptm(key, options) {
      return ptm(key, _objectSpread$1P({
        hostName: props.hostName
      }, options));
    };
    var getPTOptions = function getPTOptions(item, key) {
      return _ptm(key, {
        context: {
          selected: props.selectedItem.current === item,
          disabled: item.disabled
        }
      });
    };
    var getOptionGroupRenderKey = function getOptionGroupRenderKey(optionGroup) {
      return ObjectUtils.resolveFieldData(optionGroup, props.optionGroupLabel);
    };
    var getOptionRenderKey = function getOptionRenderKey(option) {
      return ObjectUtils.resolveFieldData(option, props.field);
    };
    var createFooter = function createFooter() {
      if (props.panelFooterTemplate) {
        var content = ObjectUtils.getJSXElement(props.panelFooterTemplate, props, props.onOverlayHide);
        var footerProps = mergeProps({
          className: cx('footer')
        }, _ptm('footer'));
        return /*#__PURE__*/React__namespace.createElement("div", footerProps, content);
      }
      return null;
    };
    var findKeyIndex = function findKeyIndex(array, key, value) {
      return array.findIndex(function (obj) {
        return obj[key] === value;
      });
    };
    var latestKey = React__namespace.useRef({
      key: null,
      index: 0,
      keyIndex: 0
    });
    var createLabelItem = function createLabelItem(item, key, index, labelItemProps) {
      var content = props.optionGroupTemplate ? ObjectUtils.getJSXElement(props.optionGroupTemplate, item, index) : props.getOptionGroupLabel(item) || item;
      var itemGroupProps = mergeProps(_objectSpread$1P({
        index: index,
        className: cx('itemGroup'),
        'data-p-highlight': false
      }, labelItemProps), _ptm('itemGroup'));
      return /*#__PURE__*/React__namespace.createElement("li", _extends({}, itemGroupProps, {
        key: key ? key : null
      }), content);
    };
    var isOptionSelected = function isOptionSelected(item) {
      if (props.selectedItem && props.selectedItem.current && Array.isArray(props.selectedItem.current)) {
        return props.selectedItem.current.some(function (selectedItem) {
          return ObjectUtils.deepEquals(selectedItem, item);
        });
      } else {
        return ObjectUtils.deepEquals(props.selectedItem.current, item);
      }
    };
    var createListItem = function createListItem(item, key, index, listItemProps) {
      var selected = isOptionSelected(item);
      var content = props.itemTemplate ? ObjectUtils.getJSXElement(props.itemTemplate, item, index) : props.field ? ObjectUtils.resolveFieldData(item, props.field) : item;
      var itemProps = mergeProps(_objectSpread$1P({
        index: index,
        role: 'option',
        className: cx('item', {
          optionGroupLabel: props.optionGroupLabel,
          suggestion: item,
          selected: selected
        }),
        onClick: function onClick(e) {
          return props.onItemClick(e, item);
        },
        'aria-selected': selected
      }, listItemProps), getPTOptions(item, 'item'));
      return /*#__PURE__*/React__namespace.createElement("li", _extends({
        key: key
      }, itemProps), content, /*#__PURE__*/React__namespace.createElement(Ripple, null));
    };
    var createGroupChildren = function createGroupChildren(optionGroup, i) {
      var groupChildren = props.getOptionGroupChildren(optionGroup);
      return groupChildren.map(function (item, j) {
        var key = i + '_' + j;
        var itemProps = mergeProps({
          'data-group': i,
          'data-index': j,
          'data-p-disabled': item.disabled
        });
        return createListItem(item, key, j, itemProps);
      });
    };
    var createItem = function createItem(suggestion, index) {
      var scrollerOptions = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
      var style = {
        height: scrollerOptions.props ? scrollerOptions.props.itemSize : undefined
      };
      if (props.optionGroupLabel) {
        if (props.virtualScrollerOptions) {
          var keyIndex = findKeyIndex(props.suggestions, props.optionGroupLabel, suggestion);
          if (keyIndex !== -1) {
            latestKey.current = {
              key: suggestion,
              index: index,
              keyIndex: keyIndex
            };
            var _key = index + '_' + getOptionGroupRenderKey(suggestion);
            return createLabelItem(suggestion, _key, index, {
              style: style
            });
          }
          var _key2 = index + '_' + latestKey.current.keyIndex;
          var _itemProps = mergeProps({
            style: style,
            'data-group': latestKey.current.keyIndex,
            'data-index': index - latestKey.current.index - 1,
            'data-p-disabled': suggestion.disabled
          });
          return createListItem(suggestion, _key2, index, _itemProps);
        }
        var childrenContent = createGroupChildren(suggestion, index);
        var _key3 = index + '_' + getOptionGroupRenderKey(suggestion);
        return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, {
          key: _key3
        }, createLabelItem(suggestion, undefined, index, {
          style: style
        }), childrenContent);
      }
      var key = "".concat(index, "_").concat(ObjectUtils.isObject(suggestion) ? getOptionRenderKey(suggestion) : suggestion);
      var itemProps = mergeProps({
        style: style,
        'data-p-disabled': suggestion.disabled
      }, getPTOptions(suggestion, 'item'));
      return createListItem(suggestion, key, index, itemProps);
    };
    var createItems = function createItems() {
      return props.suggestions ? props.suggestions.map(createItem) : null;
    };
    var flattenGroupedItems = function flattenGroupedItems(items) {
      try {
        return items === null || items === void 0 ? void 0 : items.map(function (item) {
          return [item === null || item === void 0 ? void 0 : item[props === null || props === void 0 ? void 0 : props.optionGroupLabel]].concat(_toConsumableArray(item === null || item === void 0 ? void 0 : item[props === null || props === void 0 ? void 0 : props.optionGroupChildren]));
        }).flat();
      } catch (e) {}
    };
    var createContent = function createContent() {
      if (props.showEmptyMessage && ObjectUtils.isEmpty(props.suggestions)) {
        var emptyMessage = props.emptyMessage || localeOption('emptyMessage');
        var emptyMessageProps = mergeProps({
          className: cx('emptyMessage')
        }, _ptm('emptyMessage'));
        var _listProps = mergeProps({
          className: cx('list')
        }, _ptm('list'));
        return /*#__PURE__*/React__namespace.createElement("ul", _listProps, /*#__PURE__*/React__namespace.createElement("li", emptyMessageProps, emptyMessage));
      }
      if (props.virtualScrollerOptions) {
        var _items = props.suggestions ? props.optionGroupLabel ? flattenGroupedItems(props === null || props === void 0 ? void 0 : props.suggestions) : props.suggestions : null;
        var virtualScrollerProps = _objectSpread$1P(_objectSpread$1P({}, props.virtualScrollerOptions), {
          style: _objectSpread$1P(_objectSpread$1P({}, props.virtualScrollerOptions.style), {
            height: props.scrollHeight
          }),
          autoSize: true,
          items: _items,
          itemTemplate: function itemTemplate(item, options) {
            return item && createItem(item, options.index, options);
          },
          contentTemplate: function contentTemplate(options) {
            var listProps = mergeProps({
              id: props.listId,
              ref: options.contentRef,
              style: options.style,
              className: cx('list', {
                virtualScrollerProps: virtualScrollerProps,
                options: options
              }),
              role: 'listbox'
            }, _ptm('list'));
            return /*#__PURE__*/React__namespace.createElement("ul", listProps, options.children);
          }
        });
        return /*#__PURE__*/React__namespace.createElement(VirtualScroller, _extends({
          ref: props.virtualScrollerRef
        }, virtualScrollerProps, {
          pt: _ptm('virtualScroller'),
          __parentMetadata: {
            parent: props.metaData
          }
        }));
      }
      var items = createItems();
      var listProps = mergeProps({
        id: props.listId,
        className: cx('list'),
        role: 'listbox'
      }, _ptm('list'));
      var listWrapperProps = mergeProps({
        className: cx('listWrapper'),
        style: {
          maxHeight: props.scrollHeight || 'auto'
        }
      }, _ptm('listWrapper'));
      return /*#__PURE__*/React__namespace.createElement("div", listWrapperProps, /*#__PURE__*/React__namespace.createElement("ul", listProps, items));
    };
    var createElement = function createElement() {
      var style = _objectSpread$1P({}, props.panelStyle || {});
      var content = createContent();
      var footer = createFooter();
      var panelProps = mergeProps({
        className: classNames(props.panelClassName, cx('panel', {
          context: context
        })),
        style: style,
        onClick: function onClick(e) {
          return props.onClick(e);
        }
      }, _ptm('panel'));
      var transitionProps = mergeProps({
        classNames: cx('transition'),
        "in": props["in"],
        timeout: {
          enter: 120,
          exit: 100
        },
        options: props.transitionOptions,
        unmountOnExit: true,
        onEnter: props.onEnter,
        onEntering: props.onEntering,
        onEntered: props.onEntered,
        onExit: props.onExit,
        onExited: props.onExited
      }, _ptm('transition'));
      return /*#__PURE__*/React__namespace.createElement(CSSTransition, _extends({
        nodeRef: ref
      }, transitionProps), /*#__PURE__*/React__namespace.createElement("div", _extends({
        ref: ref
      }, panelProps), content, footer));
    };
    var element = createElement();
    return /*#__PURE__*/React__namespace.createElement(Portal, {
      element: element,
      appendTo: props.appendTo
    });
  }));
  AutoCompletePanel.displayName = 'AutoCompletePanel';

  function ownKeys$1O(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1O(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1O(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1O(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var AutoComplete = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var mergeProps = useMergeProps();
    var context = React__namespace.useContext(PrimeReactContext);
    var props = AutoCompleteBase.getProps(inProps, context);
    var _React$useState = React__namespace.useState(props.id),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      idState = _React$useState2[0],
      setIdState = _React$useState2[1];
    var _React$useState3 = React__namespace.useState(false),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      searchingState = _React$useState4[0],
      setSearchingState = _React$useState4[1];
    var _React$useState5 = React__namespace.useState(false),
      _React$useState6 = _slicedToArray(_React$useState5, 2),
      focusedState = _React$useState6[0],
      setFocusedState = _React$useState6[1];
    var _React$useState7 = React__namespace.useState(false),
      _React$useState8 = _slicedToArray(_React$useState7, 2),
      overlayVisibleState = _React$useState8[0],
      setOverlayVisibleState = _React$useState8[1];
    var metaData = {
      props: props,
      state: {
        id: idState,
        searching: searchingState,
        focused: focusedState,
        overlayVisible: overlayVisibleState
      }
    };
    var _AutoCompleteBase$set = AutoCompleteBase.setMetaData(metaData),
      ptm = _AutoCompleteBase$set.ptm,
      cx = _AutoCompleteBase$set.cx,
      sx = _AutoCompleteBase$set.sx,
      isUnstyled = _AutoCompleteBase$set.isUnstyled;
    useHandleStyle(AutoCompleteBase.css.styles, isUnstyled, {
      name: 'autocomplete'
    });
    var elementRef = React__namespace.useRef(null);
    var overlayRef = React__namespace.useRef(null);
    var inputRef = React__namespace.useRef(props.inputRef);
    var multiContainerRef = React__namespace.useRef(null);
    var virtualScrollerRef = React__namespace.useRef(null);
    var timeout = React__namespace.useRef(null);
    var selectedItem = React__namespace.useRef(null);
    var _useOverlayListener = useOverlayListener({
        target: elementRef,
        overlay: overlayRef,
        listener: function listener(event, _ref) {
          var type = _ref.type,
            valid = _ref.valid;
          if (valid) {
            if (type === 'outside') {
              if (!isInputClicked(event)) {
                hide();
              }
            } else if (context.hideOverlaysOnDocumentScrolling) {
              hide();
            } else if (!DomHandler.isDocument(event.target)) {
              alignOverlay();
            }
          }
        },
        when: overlayVisibleState
      }),
      _useOverlayListener2 = _slicedToArray(_useOverlayListener, 2),
      bindOverlayListener = _useOverlayListener2[0],
      unbindOverlayListener = _useOverlayListener2[1];
    var isInputClicked = function isInputClicked(event) {
      return props.multiple ? event.target === multiContainerRef.current || multiContainerRef.current.contains(event.target) : event.target === inputRef.current;
    };
    var onInputChange = function onInputChange(event) {
      //Cancel the search request if user types within the timeout
      if (timeout.current) {
        clearTimeout(timeout.current);
      }
      var query = event.target.value;
      if (!props.multiple) {
        updateModel(event, query);
      }
      if (ObjectUtils.isEmpty(query)) {
        hide();
        props.onClear && props.onClear(event);
      } else if (query.length >= props.minLength) {
        timeout.current = setTimeout(function () {
          search(event, query, 'input');
        }, props.delay);
      } else {
        hide();
      }
    };
    var search = function search(event, query, source) {
      //allow empty string but not undefined or null
      if (query === undefined || query === null) {
        return;
      }

      //do not search blank values on input change
      if (source === 'input' && query.trim().length === 0) {
        return;
      }
      if (props.completeMethod) {
        setSearchingState(true);
        props.completeMethod({
          originalEvent: event,
          query: query
        });
      }
    };
    var selectItem = function selectItem(event, option, preventInputFocus) {
      if (props.multiple) {
        inputRef.current.value = '';

        // allows empty value/selectionlimit and within sectionlimit
        if (!isSelected(option) && isAllowMoreValues()) {
          var newValue = props.value ? [].concat(_toConsumableArray(props.value), [option]) : [option];
          updateModel(event, newValue);
        }
      } else {
        updateInputField(option);
        updateModel(event, option);
      }
      if (props.onSelect) {
        props.onSelect({
          originalEvent: event,
          value: option
        });
      }
      if (!preventInputFocus) {
        DomHandler.focus(inputRef.current);
        hide();
      }
    };
    var updateModel = function updateModel(event, value) {
      if (props.onChange) {
        props.onChange({
          originalEvent: event,
          value: value,
          stopPropagation: function stopPropagation() {
            event.stopPropagation();
          },
          preventDefault: function preventDefault() {
            event.preventDefault();
          },
          target: {
            name: props.name,
            id: idState,
            value: value
          }
        });
      }
      selectedItem.current = ObjectUtils.isNotEmpty(value) ? value : null;
    };
    var formatValue = function formatValue(value) {
      if (ObjectUtils.isEmpty(value)) return '';
      if (typeof value === 'string') return value;
      if (props.selectedItemTemplate) {
        var valueFromTemplate = ObjectUtils.getJSXElement(props.selectedItemTemplate, value);
        return props.multiple || typeof valueFromTemplate === 'string' ? valueFromTemplate : value;
      }
      if (props.field) {
        var _ObjectUtils$resolveF;
        return (_ObjectUtils$resolveF = ObjectUtils.resolveFieldData(value, props.field)) !== null && _ObjectUtils$resolveF !== void 0 ? _ObjectUtils$resolveF : value;
      }
      return value;
    };
    var updateInputField = function updateInputField(value) {
      inputRef.current.value = formatValue(value);
    };
    var show = function show() {
      setOverlayVisibleState(true);
    };
    var hide = function hide() {
      setOverlayVisibleState(false);
      setSearchingState(false);
    };
    var onOverlayEnter = function onOverlayEnter() {
      ZIndexUtils.set('overlay', overlayRef.current, context && context.autoZIndex || PrimeReact.autoZIndex, context && context.zIndex.overlay || PrimeReact.zIndex.overlay);
      DomHandler.addStyles(overlayRef.current, {
        position: 'absolute',
        top: '0',
        left: '0'
      });
      alignOverlay();
    };
    var onOverlayEntering = function onOverlayEntering() {
      if (props.autoHighlight && props.suggestions && props.suggestions.length) {
        autoHighlightFirstOption();
      }
    };
    var autoHighlightFirstOption = function autoHighlightFirstOption() {
      var _getScrollableElement;
      var element = (_getScrollableElement = getScrollableElement()) === null || _getScrollableElement === void 0 || (_getScrollableElement = _getScrollableElement.firstChild) === null || _getScrollableElement === void 0 ? void 0 : _getScrollableElement.firstChild;
      if (element) {
        !isUnstyled() && DomHandler.addClass(element, 'p-highlight');
        element.setAttribute('data-p-highlight', true);
      }
    };
    var onOverlayEntered = function onOverlayEntered() {
      bindOverlayListener();
      props.onShow && props.onShow();
    };
    var onOverlayExit = function onOverlayExit() {
      unbindOverlayListener();
    };
    var onOverlayExited = function onOverlayExited() {
      ZIndexUtils.clear(overlayRef.current);
      props.onHide && props.onHide();
    };
    var alignOverlay = function alignOverlay() {
      var target = props.multiple ? multiContainerRef.current : inputRef.current;
      DomHandler.alignOverlay(overlayRef.current, target, props.appendTo || context && context.appendTo || PrimeReact.appendTo);
    };
    var onPanelClick = function onPanelClick(event) {
      OverlayService.emit('overlay-click', {
        originalEvent: event,
        target: elementRef.current
      });
    };
    var onDropdownClick = function onDropdownClick(event) {
      if (props.dropdownAutoFocus) {
        DomHandler.focus(inputRef.current, props.dropdownAutoFocus);
      }
      if (props.dropdownMode === 'blank') {
        search(event, '', 'dropdown');
      } else if (props.dropdownMode === 'current') {
        search(event, inputRef.current.value, 'dropdown');
      }
      if (props.onDropdownClick) {
        props.onDropdownClick({
          originalEvent: event,
          query: inputRef.current.value
        });
      }
    };
    var removeItem = function removeItem(event, index) {
      if (props.disabled || props.readOnly) {
        return;
      }
      var removedValue = props.value[index];
      var newValue = props.value.filter(function (_, i) {
        return index !== i;
      });
      updateModel(event, newValue);
      if (props.onUnselect) {
        props.onUnselect({
          originalEvent: event,
          value: removedValue
        });
      }
    };
    var onInputKeyDown = function onInputKeyDown(event) {
      if (overlayVisibleState) {
        var highlightItem = DomHandler.findSingle(overlayRef.current, 'li[data-p-highlight="true"]');
        switch (event.which) {
          //down
          case 40:
            if (highlightItem) {
              var nextElement = _findNextItem(highlightItem);
              if (nextElement) {
                !isUnstyled() && DomHandler.addClass(nextElement, 'p-highlight');
                nextElement.setAttribute('data-p-highlight', true);
                !isUnstyled() && DomHandler.removeClass(highlightItem, 'p-highlight');
                highlightItem.setAttribute('data-p-highlight', false);
                DomHandler.scrollInView(getScrollableElement(), nextElement);
              }
            } else {
              highlightItem = DomHandler.findSingle(overlayRef.current, 'li');
              if (DomHandler.getAttribute(highlightItem, 'data-pc-section') === 'itemgroup') {
                highlightItem = _findNextItem(highlightItem);
              }
              if (highlightItem) {
                !isUnstyled() && DomHandler.addClass(highlightItem, 'p-highlight');
                highlightItem.setAttribute('data-p-highlight', true);
              }
            }
            event.preventDefault();
            break;

          //up
          case 38:
            if (highlightItem) {
              var previousElement = _findPrevItem(highlightItem);
              if (previousElement) {
                !isUnstyled() && DomHandler.addClass(previousElement, 'p-highlight');
                previousElement.setAttribute('data-p-highlight', true);
                !isUnstyled() && DomHandler.removeClass(highlightItem, 'p-highlight');
                highlightItem.setAttribute('data-p-highlight', false);
                DomHandler.scrollInView(getScrollableElement(), previousElement);
              }
            }
            event.preventDefault();
            break;

          //enter
          case 13:
            if (highlightItem) {
              selectHighlightItem(event, highlightItem);
              hide();
              event.preventDefault();
            }
            break;

          //escape
          case 27:
            hide();
            event.preventDefault();
            break;

          //tab
          case 9:
            if (highlightItem) {
              selectHighlightItem(event, highlightItem);
            }
            hide();
            break;
        }
      }
      if (props.multiple) {
        switch (event.which) {
          //backspace
          case 8:
            if (props.value && props.value.length && !inputRef.current.value) {
              var removedValue = props.value[props.value.length - 1];
              var newValue = props.value.slice(0, -1);
              updateModel(event, newValue);
              if (props.onUnselect) {
                props.onUnselect({
                  originalEvent: event,
                  value: removedValue
                });
              }
            }
            break;
        }
      }
    };
    var selectHighlightItem = function selectHighlightItem(event, item) {
      if (props.optionGroupLabel) {
        var optionGroup = props.suggestions[item.dataset.group];
        selectItem(event, getOptionGroupChildren(optionGroup)[item.dataset.index]);
      } else {
        selectItem(event, props.suggestions[item.getAttribute('index')]);
      }
    };
    var _findNextItem = function findNextItem(item) {
      var nextItem = item.nextElementSibling;
      return nextItem ? DomHandler.getAttribute(nextItem, 'data-pc-section') === 'itemgroup' ? _findNextItem(nextItem) : nextItem : null;
    };
    var _findPrevItem = function findPrevItem(item) {
      var prevItem = item.previousElementSibling;
      return prevItem ? DomHandler.getAttribute(prevItem, 'data-pc-section') === 'itemgroup' ? _findPrevItem(prevItem) : prevItem : null;
    };
    var onInputFocus = function onInputFocus(event) {
      setFocusedState(true);
      props.onFocus && props.onFocus(event);
    };
    var forceItemSelection = function forceItemSelection(event) {
      if (props.multiple) {
        inputRef.current.value = '';
        return;
      }
      var inputValue = ObjectUtils.trim(event.target.value).toLowerCase();
      var allItems = (props.suggestions || []).flatMap(function (group) {
        return group.items ? group.items : [group];
      });
      var item = allItems.find(function (it) {
        var value = props.field ? ObjectUtils.resolveFieldData(it, props.field) : it;
        var trimmedValue = value ? ObjectUtils.trim(value).toLowerCase() : '';
        return trimmedValue && inputValue === trimmedValue;
      });
      if (item) {
        selectItem(event, item, true);
      } else {
        inputRef.current.value = '';
        updateModel(event, null);
        props.onClear && props.onClear(event);
      }
    };
    var onInputBlur = function onInputBlur(event) {
      setFocusedState(false);
      if (props.forceSelection) {
        forceItemSelection(event);
      }
      props.onBlur && props.onBlur(event);
    };
    var onMultiContainerClick = function onMultiContainerClick(event) {
      DomHandler.focus(inputRef.current);
      props.onClick && props.onClick(event);
    };
    var onMultiInputFocus = function onMultiInputFocus(event) {
      onInputFocus(event);
      !isUnstyled() && DomHandler.addClass(multiContainerRef.current, 'p-focus');
      multiContainerRef.current.setAttribute('data-p-focus', true);
    };
    var onMultiInputBlur = function onMultiInputBlur(event) {
      onInputBlur(event);
      !isUnstyled() && DomHandler.removeClass(multiContainerRef.current, 'p-focus');
      multiContainerRef.current.setAttribute('data-p-focus', false);
    };
    var isSelected = function isSelected(val) {
      return props.value ? props.value.some(function (v) {
        return ObjectUtils.equals(v, val);
      }) : false;
    };
    var getScrollableElement = function getScrollableElement() {
      var _overlayRef$current;
      return overlayRef === null || overlayRef === void 0 || (_overlayRef$current = overlayRef.current) === null || _overlayRef$current === void 0 ? void 0 : _overlayRef$current.firstChild;
    };
    var getOptionGroupLabel = function getOptionGroupLabel(optionGroup) {
      return props.optionGroupLabel ? ObjectUtils.resolveFieldData(optionGroup, props.optionGroupLabel) : optionGroup;
    };
    var getOptionGroupChildren = function getOptionGroupChildren(optionGroup) {
      return ObjectUtils.resolveFieldData(optionGroup, props.optionGroupChildren);
    };
    var isAllowMoreValues = function isAllowMoreValues() {
      return !props.value || !props.selectionLimit || props.value.length < props.selectionLimit;
    };
    React__namespace.useEffect(function () {
      ObjectUtils.combinedRefs(inputRef, props.inputRef);
    }, [inputRef, props.inputRef]);
    React__namespace.useEffect(function () {
      if (ObjectUtils.isNotEmpty(props.value)) {
        selectedItem.current = props.value;
      }
    }, [props.value]);
    useMountEffect(function () {
      if (!idState) {
        setIdState(UniqueComponentId());
      }
      if (props.autoFocus) {
        DomHandler.focus(inputRef.current, props.autoFocus);
      }
      alignOverlay();
    });
    useUpdateEffect(function () {
      if (searchingState && props.autoHighlight && props.suggestions && props.suggestions.length) {
        autoHighlightFirstOption();
      }
    }, [searchingState]);
    useUpdateEffect(function () {
      if (searchingState) {
        ObjectUtils.isNotEmpty(props.suggestions) || props.showEmptyMessage ? show() : hide();
        setSearchingState(false);
      }
    }, [props.suggestions]);
    useUpdateEffect(function () {
      if (inputRef.current && !props.multiple) {
        updateInputField(props.value);
      }
      if (overlayVisibleState) {
        alignOverlay();
      }
    });
    useUnmountEffect(function () {
      if (timeout.current) {
        clearTimeout(timeout.current);
      }
      ZIndexUtils.clear(overlayRef.current);
    });
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        search: search,
        show: show,
        hide: hide,
        focus: function focus() {
          return DomHandler.focus(inputRef.current);
        },
        getElement: function getElement() {
          return elementRef.current;
        },
        getOverlay: function getOverlay() {
          return overlayRef.current;
        },
        getInput: function getInput() {
          return inputRef.current;
        },
        getVirtualScroller: function getVirtualScroller() {
          return virtualScrollerRef.current;
        }
      };
    });
    var createSimpleAutoComplete = function createSimpleAutoComplete() {
      var value = formatValue(props.value);
      var ariaControls = overlayVisibleState ? idState + '_list' : null;
      return /*#__PURE__*/React__namespace.createElement(InputText, _extends({
        ref: inputRef,
        id: props.inputId,
        type: props.type,
        name: props.name,
        defaultValue: value,
        role: "combobox",
        "aria-autocomplete": "list",
        "aria-controls": ariaControls,
        "aria-haspopup": "listbox",
        "aria-expanded": overlayVisibleState,
        className: classNames(props.inputClassName, cx('input', {
          context: context
        })),
        style: props.inputStyle,
        autoComplete: "off",
        readOnly: props.readOnly,
        required: props.required,
        disabled: props.disabled,
        placeholder: props.placeholder,
        size: props.size,
        maxLength: props.maxLength,
        tabIndex: props.tabIndex,
        onBlur: onInputBlur,
        onFocus: onInputFocus,
        onChange: onInputChange,
        onMouseDown: props.onMouseDown,
        onKeyUp: props.onKeyUp,
        onKeyDown: onInputKeyDown,
        onKeyPress: props.onKeyPress,
        onContextMenu: props.onContextMenu,
        onClick: props.onClick,
        onDoubleClick: props.onDblClick,
        pt: ptm('input'),
        unstyled: props.unstyled
      }, ariaProps, {
        __parentMetadata: {
          parent: metaData
        }
      }));
    };
    var onRemoveTokenIconKeyDown = function onRemoveTokenIconKeyDown(event, val) {
      switch (event.code) {
        case 'Space':
        case 'NumpadEnter':
        case 'Enter':
          removeItem(event, val);
          event.preventDefault();
          event.stopPropagation();
          break;
      }
    };
    var createChips = function createChips() {
      if (ObjectUtils.isNotEmpty(props.value)) {
        return props.value.map(function (val, index) {
          var key = index + 'multi-item';
          var removeTokenIconProps = mergeProps({
            className: cx('removeTokenIcon'),
            onClick: function onClick(e) {
              return removeItem(e, index);
            },
            tabIndex: props.tabIndex || '0',
            'aria-label': localeOption('clear'),
            onKeyDown: function onKeyDown(e) {
              return onRemoveTokenIconKeyDown(e, index);
            }
          }, ptm('removeTokenIcon'));
          var icon = props.removeTokenIcon || /*#__PURE__*/React__namespace.createElement(TimesCircleIcon, removeTokenIconProps);
          var removeTokenIcon = !props.disabled && IconUtils.getJSXIcon(icon, _objectSpread$1O({}, removeTokenIconProps), {
            props: props
          });
          var tokenProps = mergeProps({
            className: cx('token')
          }, ptm('token'));
          var tokenLabelProps = mergeProps({
            className: cx('tokenLabel')
          }, ptm('tokenLabel'));
          return /*#__PURE__*/React__namespace.createElement("li", _extends({
            key: key
          }, tokenProps), /*#__PURE__*/React__namespace.createElement("span", tokenLabelProps, formatValue(val)), removeTokenIcon);
        });
      }
      selectedItem.current = null;
      return null;
    };
    var createMultiInput = function createMultiInput(allowMoreValues) {
      var ariaControls = overlayVisibleState ? idState + '_list' : null;
      var inputTokenProps = mergeProps({
        className: cx('inputToken')
      }, ptm('inputToken'));
      var inputProps = mergeProps(_objectSpread$1O({
        id: props.inputId,
        ref: inputRef,
        'aria-autocomplete': 'list',
        'aria-controls': ariaControls,
        'aria-expanded': overlayVisibleState,
        'aria-haspopup': 'listbox',
        autoComplete: 'off',
        className: props.inputClassName,
        disabled: props.disabled,
        maxLength: props.maxLength,
        name: props.name,
        onBlur: onMultiInputBlur,
        onChange: allowMoreValues ? onInputChange : undefined,
        onFocus: onMultiInputFocus,
        onKeyDown: allowMoreValues ? onInputKeyDown : undefined,
        onKeyPress: props.onKeyPress,
        onKeyUp: props.onKeyUp,
        placeholder: allowMoreValues ? props.placeholder : undefined,
        readOnly: props.readOnly || !allowMoreValues,
        required: props.required,
        role: 'combobox',
        style: props.inputStyle,
        tabIndex: props.tabIndex,
        type: props.type
      }, ariaProps), ptm('input'));
      return /*#__PURE__*/React__namespace.createElement("li", inputTokenProps, /*#__PURE__*/React__namespace.createElement("input", inputProps));
    };
    var createMultipleAutoComplete = function createMultipleAutoComplete() {
      var allowMoreValues = isAllowMoreValues();
      var tokens = createChips();
      var input = createMultiInput(allowMoreValues);
      var containerProps = mergeProps({
        ref: multiContainerRef,
        className: cx('container', {
          context: context
        }),
        onClick: allowMoreValues ? onMultiContainerClick : undefined,
        onContextMenu: props.onContextMenu,
        onMouseDown: props.onMouseDown,
        onDoubleClick: props.onDblClick,
        'data-p-focus': focusedState,
        'data-p-disabled': props.disabled
      }, ptm('container'));
      return /*#__PURE__*/React__namespace.createElement("ul", containerProps, tokens, input);
    };
    var createDropdown = function createDropdown() {
      if (props.dropdown) {
        var ariaLabel = props.dropdownAriaLabel || props.placeholder || localeOption('choose');
        return /*#__PURE__*/React__namespace.createElement(Button, {
          type: "button",
          icon: props.dropdownIcon || /*#__PURE__*/React__namespace.createElement(ChevronDownIcon, null),
          className: cx('dropdownButton'),
          disabled: props.disabled,
          onClick: onDropdownClick,
          "aria-label": ariaLabel,
          pt: ptm('dropdownButton'),
          __parentMetadata: {
            parent: metaData
          }
        });
      }
      return null;
    };
    var createLoader = function createLoader() {
      if (searchingState) {
        var loadingIconProps = mergeProps({
          className: cx('loadingIcon')
        }, ptm('loadingIcon'));
        var icon = props.loadingIcon || /*#__PURE__*/React__namespace.createElement(SpinnerIcon, _extends({}, loadingIconProps, {
          spin: true
        }));
        var loaderIcon = IconUtils.getJSXIcon(icon, _objectSpread$1O({}, loadingIconProps), {
          props: props
        });
        return loaderIcon;
      }
      return null;
    };
    var createInput = function createInput() {
      return props.multiple ? createMultipleAutoComplete() : createSimpleAutoComplete();
    };
    var listId = idState + '_list';
    var hasTooltip = ObjectUtils.isNotEmpty(props.tooltip);
    var otherProps = AutoCompleteBase.getOtherProps(props);
    var ariaProps = ObjectUtils.reduceKeys(otherProps, DomHandler.ARIA_PROPS);
    var loader = createLoader();
    var input = createInput();
    var dropdown = createDropdown();
    var rootProps = mergeProps({
      id: idState,
      ref: elementRef,
      style: props.style,
      className: classNames(props.className, cx('root', {
        focusedState: focusedState
      }))
    }, otherProps, ptm('root'));
    return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, null, /*#__PURE__*/React__namespace.createElement("span", rootProps, input, loader, dropdown, /*#__PURE__*/React__namespace.createElement(AutoCompletePanel, _extends({
      hostName: "AutoComplete",
      ref: overlayRef,
      virtualScrollerRef: virtualScrollerRef
    }, props, {
      listId: listId,
      onItemClick: selectItem,
      selectedItem: selectedItem,
      onOverlayHide: hide,
      onClick: onPanelClick,
      getOptionGroupLabel: getOptionGroupLabel,
      getOptionGroupChildren: getOptionGroupChildren,
      "in": overlayVisibleState,
      onEnter: onOverlayEnter,
      onEntering: onOverlayEntering,
      onEntered: onOverlayEntered,
      onExit: onOverlayExit,
      onExited: onOverlayExited,
      ptm: ptm,
      cx: cx,
      sx: sx
    }))), hasTooltip && /*#__PURE__*/React__namespace.createElement(Tooltip, _extends({
      target: elementRef,
      content: props.tooltip,
      pt: ptm('tooltip')
    }, props.tooltipOptions)));
  }));
  AutoComplete.displayName = 'AutoComplete';

  var classes$1b = {
    root: function root(_ref) {
      var props = _ref.props,
        state = _ref.state;
      return classNames('p-avatar p-component', {
        'p-avatar-image': ObjectUtils.isNotEmpty(props.image) && !state.imageFailed,
        'p-avatar-circle': props.shape === 'circle',
        'p-avatar-lg': props.size === 'large',
        'p-avatar-xl': props.size === 'xlarge',
        'p-avatar-clickable': !!props.onClick
      });
    },
    label: 'p-avatar-text',
    icon: 'p-avatar-icon'
  };
  var styles$$ = "\n@layer primereact {\n    .p-avatar {\n        display: inline-flex;\n        align-items: center;\n        justify-content: center;\n        width: 2rem;\n        height: 2rem;\n        font-size: 1rem;\n    }\n    \n    .p-avatar.p-avatar-image {\n        background-color: transparent;\n    }\n    \n    .p-avatar.p-avatar-circle {\n        border-radius: 50%;\n    }\n    \n    .p-avatar.p-avatar-circle img {\n        border-radius: 50%;\n    }\n    \n    .p-avatar .p-avatar-icon {\n        font-size: 1rem;\n    }\n    \n    .p-avatar img {\n        width: 100%;\n        height: 100%;\n    }\n    \n    .p-avatar-clickable {\n        cursor: pointer;\n    }\n}\n";
  var AvatarBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'Avatar',
      className: null,
      icon: null,
      image: null,
      imageAlt: 'avatar',
      imageFallback: 'default',
      label: null,
      onImageError: null,
      shape: 'square',
      size: 'normal',
      style: null,
      template: null,
      children: undefined
    },
    css: {
      classes: classes$1b,
      styles: styles$$
    }
  });

  function ownKeys$1N(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1N(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1N(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1N(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var Avatar = /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var mergeProps = useMergeProps();
    var context = React__namespace.useContext(PrimeReactContext);
    var props = AvatarBase.getProps(inProps, context);
    var elementRef = React__namespace.useRef(null);
    var _React$useState = React__namespace.useState(false),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      imageFailed = _React$useState2[0],
      setImageFailed = _React$useState2[1];
    var _React$useState3 = React__namespace.useState(false),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      nested = _React$useState4[0],
      setNested = _React$useState4[1];
    var _AvatarBase$setMetaDa = AvatarBase.setMetaData({
        props: props,
        state: {
          imageFailed: imageFailed,
          nested: nested
        }
      }),
      ptm = _AvatarBase$setMetaDa.ptm,
      cx = _AvatarBase$setMetaDa.cx,
      isUnstyled = _AvatarBase$setMetaDa.isUnstyled;
    useHandleStyle(AvatarBase.css.styles, isUnstyled, {
      name: 'avatar'
    });
    var createContent = function createContent() {
      if (ObjectUtils.isNotEmpty(props.image) && !imageFailed) {
        var imageProps = mergeProps({
          src: props.image,
          onError: onImageError
        }, ptm('image'));
        return /*#__PURE__*/React__namespace.createElement("img", _extends({
          alt: props.imageAlt
        }, imageProps));
      } else if (props.label) {
        var labelProps = mergeProps({
          className: cx('label')
        }, ptm('label'));
        return /*#__PURE__*/React__namespace.createElement("span", labelProps, props.label);
      } else if (props.icon) {
        var iconProps = mergeProps({
          className: cx('icon')
        }, ptm('icon'));
        return IconUtils.getJSXIcon(props.icon, _objectSpread$1N({}, iconProps), {
          props: props
        });
      }
      return null;
    };
    var onImageError = function onImageError(event) {
      if (props.imageFallback === 'default') {
        if (!props.onImageError) {
          // fallback to label or icon
          setImageFailed(true);
          event.target.src = null;
        }
      } else {
        // try fallback as an image
        event.target.src = props.imageFallback;
      }
      props.onImageError && props.onImageError(event);
    };
    React__namespace.useEffect(function () {
      var nested = DomHandler.isAttributeEquals(elementRef.current.parentElement, 'data-pc-name', 'avatargroup');
      setNested(nested);
    }, []);
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        getElement: function getElement() {
          return elementRef.current;
        }
      };
    });
    var rootProps = mergeProps({
      ref: elementRef,
      style: props.style,
      className: classNames(props.className, cx('root', {
        imageFailed: imageFailed
      }))
    }, AvatarBase.getOtherProps(props), ptm('root'));
    var content = props.template ? ObjectUtils.getJSXElement(props.template, props) : createContent();
    return /*#__PURE__*/React__namespace.createElement("div", rootProps, content, props.children);
  });
  Avatar.displayName = 'Avatar';

  var classes$1a = {
    root: 'p-avatar-group p-component'
  };
  var styles$_ = "\n@layer primereact {\n    .p-avatar-group .p-avatar + .p-avatar {\n        margin-left: -1rem;\n    }\n    \n    .p-avatar-group {\n        display: flex;\n        align-items: center;\n    }\n}\n";
  var AvatarGroupBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'AvatarGroup',
      style: null,
      className: null,
      children: undefined
    },
    css: {
      classes: classes$1a,
      styles: styles$_
    }
  });

  var AvatarGroup = /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var mergeProps = useMergeProps();
    var context = React__namespace.useContext(PrimeReactContext);
    var props = AvatarGroupBase.getProps(inProps, context);
    var _AvatarGroupBase$setM = AvatarGroupBase.setMetaData({
        props: props
      }),
      ptm = _AvatarGroupBase$setM.ptm,
      cx = _AvatarGroupBase$setM.cx,
      isUnstyled = _AvatarGroupBase$setM.isUnstyled;
    useHandleStyle(AvatarGroupBase.css.styles, isUnstyled, {
      name: 'avatargroup'
    });
    var elementRef = React__namespace.useRef(null);
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        getElement: function getElement() {
          return elementRef.current;
        }
      };
    });
    var rootProps = mergeProps({
      ref: elementRef,
      style: props.style,
      className: classNames(props.className, cx('root'))
    }, AvatarGroupBase.getOtherProps(props), ptm('root'));
    return /*#__PURE__*/React__namespace.createElement("div", rootProps, props.children);
  });
  AvatarGroup.displayName = 'AvatarGroup';

  var classes$19 = {
    root: 'p-blockui-container',
    mask: function mask(_ref) {
      var props = _ref.props;
      return classNames('p-blockui p-component-overlay p-component-overlay-enter', {
        'p-blockui-document': props.fullScreen
      });
    }
  };
  var styles$Z = "\n@layer primereact {\n    .p-blockui-container {\n        position: relative;\n    }\n    \n    .p-blockui {\n        opacity: 1;\n        display: flex;\n        align-items: center;\n        justify-content: center;\n    }\n    \n    .p-blockui.p-component-overlay {\n        position: absolute;\n    }\n    \n    .p-blockui-document.p-component-overlay {\n        position: fixed;\n    }\n}\n";
  var BlockUIBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'BlockUI',
      autoZIndex: true,
      baseZIndex: 0,
      blocked: false,
      className: null,
      containerClassName: null,
      containerStyle: null,
      fullScreen: false,
      id: null,
      onBlocked: null,
      onUnblocked: null,
      style: null,
      template: null,
      children: undefined
    },
    css: {
      classes: classes$19,
      styles: styles$Z
    }
  });

  function ownKeys$1M(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1M(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1M(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1M(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var BlockUI = /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var mergeProps = useMergeProps();
    var context = React__namespace.useContext(PrimeReactContext);
    var props = BlockUIBase.getProps(inProps, context);
    var _React$useState = React__namespace.useState(props.blocked),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      visibleState = _React$useState2[0],
      setVisibleState = _React$useState2[1];
    var elementRef = React__namespace.useRef(null);
    var maskRef = React__namespace.useRef(null);
    var activeElementRef = React__namespace.useRef(null);
    var _BlockUIBase$setMetaD = BlockUIBase.setMetaData({
        props: props
      }),
      ptm = _BlockUIBase$setMetaD.ptm,
      cx = _BlockUIBase$setMetaD.cx,
      isUnstyled = _BlockUIBase$setMetaD.isUnstyled;
    useHandleStyle(BlockUIBase.css.styles, isUnstyled, {
      name: 'blockui'
    });
    var block = function block() {
      setVisibleState(true);
      activeElementRef.current = document.activeElement;
    };
    var unblock = function unblock() {
      !isUnstyled() && DomHandler.addClass(maskRef.current, 'p-component-overlay-leave');
      if (DomHandler.hasCSSAnimation(maskRef.current) > 0) {
        maskRef.current.addEventListener('animationend', function () {
          removeMask();
        });
      } else {
        removeMask();
      }
    };
    var removeMask = function removeMask() {
      ZIndexUtils.clear(maskRef.current);
      setVisibleState(false);
      if (props.fullScreen) {
        DomHandler.unblockBodyScroll();
        activeElementRef.current && activeElementRef.current.focus();
      }
      props.onUnblocked && props.onUnblocked();
    };
    var onPortalMounted = function onPortalMounted() {
      if (props.fullScreen) {
        DomHandler.blockBodyScroll();
        activeElementRef.current && activeElementRef.current.blur();
      }
      if (props.autoZIndex) {
        var key = props.fullScreen ? 'modal' : 'overlay';
        ZIndexUtils.set(key, maskRef.current, context && context.autoZIndex || PrimeReact.autoZIndex, props.baseZIndex || context && context.zIndex[key] || PrimeReact.zIndex[key]);
      }
      props.onBlocked && props.onBlocked();
    };
    useMountEffect(function () {
      visibleState && block();
    });
    useUpdateEffect(function () {
      props.blocked ? block() : unblock();
    }, [props.blocked]);
    useUnmountEffect(function () {
      props.fullScreen && DomHandler.unblockBodyScroll();
      ZIndexUtils.clear(maskRef.current);
    });
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        block: block,
        unblock: unblock,
        getElement: function getElement() {
          return elementRef.current;
        }
      };
    });
    var createMask = function createMask() {
      if (visibleState) {
        var appendTo = props.fullScreen ? document.body : 'self';
        var maskProps = mergeProps({
          className: classNames(props.className, cx('mask')),
          style: _objectSpread$1M(_objectSpread$1M({}, props.style), {}, {
            position: props.fullScreen ? 'fixed' : 'absolute',
            top: '0',
            left: '0',
            width: '100%',
            height: '100%'
          })
        }, ptm('mask'));
        var content = props.template ? ObjectUtils.getJSXElement(props.template, props) : null;
        var _mask = /*#__PURE__*/React__namespace.createElement("div", _extends({
          ref: maskRef
        }, maskProps), content);
        return /*#__PURE__*/React__namespace.createElement(Portal, {
          element: _mask,
          appendTo: appendTo,
          onMounted: onPortalMounted
        });
      }
      return null;
    };
    var mask = createMask();
    var rootProps = mergeProps({
      id: props.id,
      ref: elementRef,
      style: props.containerStyle,
      className: classNames(props.containerClassName, cx('root')),
      'aria-busy': props.blocked
    }, BlockUIBase.getOtherProps(props), ptm('root'));
    return /*#__PURE__*/React__namespace.createElement("div", rootProps, props.children, mask);
  });
  BlockUI.displayName = 'BlockUI';

  var classes$18 = {
    icon: 'p-menuitem-icon',
    action: 'p-menuitem-link',
    label: 'p-menuitem-text',
    home: function home(_ref) {
      var _className = _ref._className,
        disabled = _ref.disabled;
      return classNames('p-breadcrumb-home p-menuitem', {
        'p-disabled': disabled
      }, _className);
    },
    separatorIcon: 'p-breadcrumb-chevron',
    separator: 'p-menuitem-separator',
    menuitem: function menuitem(_ref2) {
      var item = _ref2.item;
      return classNames('p-menuitem', item.className, {
        'p-disabled': item.disabled
      });
    },
    menu: 'p-breadcrumb-list',
    root: 'p-breadcrumb p-component'
  };
  var styles$Y = "\n@layer primereact {\n    .p-breadcrumb {\n        overflow-x: auto;\n        display: flex;\n    }\n\n    .p-breadcrumb ol {\n        margin: 0;\n        padding: 0;\n        list-style-type: none;\n        display: flex;\n        align-items: center;\n        flex-wrap: nowrap;\n    }\n\n    .p-breadcrumb .p-menuitem-text {\n        line-height: 1;\n    }\n\n    .p-breadcrumb .p-menuitem-link {\n        text-decoration: none;\n        display: flex;\n        align-items: center;\n    }\n\n    .p-breadcrumb .p-menuitem-separator {\n        display: flex;\n        align-items: center;\n    }\n\n    .p-breadcrumb::-webkit-scrollbar {\n        display: none;\n    }\n}\n";
  var BreadCrumbBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'BreadCrumb',
      id: null,
      model: null,
      home: null,
      separatorIcon: null,
      style: null,
      className: null,
      children: undefined
    },
    css: {
      classes: classes$18,
      styles: styles$Y
    }
  });

  function ownKeys$1L(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1L(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1L(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1L(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var BreadCrumb = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var mergeProps = useMergeProps();
    var context = React__namespace.useContext(PrimeReactContext);
    var props = BreadCrumbBase.getProps(inProps, context);
    var _React$useState = React__namespace.useState(props.id),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      idState = _React$useState2[0],
      setIdState = _React$useState2[1];
    var elementRef = React__namespace.useRef(null);
    var _BreadCrumbBase$setMe = BreadCrumbBase.setMetaData({
        props: props,
        state: {
          id: idState
        }
      }),
      ptm = _BreadCrumbBase$setMe.ptm,
      cx = _BreadCrumbBase$setMe.cx,
      isUnstyled = _BreadCrumbBase$setMe.isUnstyled;
    useHandleStyle(BreadCrumbBase.css.styles, isUnstyled, {
      name: 'breadcrumb'
    });
    var itemClick = function itemClick(event, item) {
      if (item.disabled) {
        event.preventDefault();
        return;
      }
      if (item.command) {
        item.command({
          originalEvent: event,
          item: item
        });
      }
      if (!item.url) {
        event.preventDefault();
        event.stopPropagation();
      }
    };
    var isCurrent = function isCurrent(url) {
      var lastPath = typeof window !== 'undefined' ? window.location.pathname : '';
      return url === lastPath ? 'page' : undefined;
    };
    var createHome = function createHome() {
      var home = props.home;
      if (home) {
        if (home.visible === false) {
          return null;
        }
        var _icon = home.icon,
          target = home.target,
          url = home.url,
          disabled = home.disabled,
          style = home.style,
          _className = home.className,
          template = home.template,
          _label = home.label;
        var iconProps = mergeProps({
          className: cx('icon')
        }, ptm('icon'));
        var icon = IconUtils.getJSXIcon(_icon, _objectSpread$1L({}, iconProps), {
          props: props
        });
        var actionProps = mergeProps({
          href: url || '#',
          className: cx('action'),
          'aria-disabled': disabled,
          'aria-current': isCurrent(url),
          target: target,
          onClick: function onClick(event) {
            return itemClick(event, home);
          }
        }, ptm('action'));
        var labelProps = mergeProps({
          className: cx('label')
        }, ptm('label'));
        var label = _label && /*#__PURE__*/React__namespace.createElement("span", labelProps, _label);
        var content = /*#__PURE__*/React__namespace.createElement("a", actionProps, icon, label);
        if (template) {
          var defaultContentOptions = {
            onClick: function onClick(event) {
              return itemClick(event, home);
            },
            className: 'p-menuitem-link',
            labelClassName: 'p-menuitem-text',
            element: content,
            props: props
          };
          content = ObjectUtils.getJSXElement(template, home, defaultContentOptions);
        }
        var key = idState + '_home';
        var menuitemProps = mergeProps({
          id: key,
          className: cx('home', {
            _className: _className,
            disabled: disabled
          }),
          style: style
        }, ptm('home'));
        return /*#__PURE__*/React__namespace.createElement("li", _extends({}, menuitemProps, {
          key: key
        }), content);
      }
      return null;
    };
    var createSeparator = function createSeparator(index) {
      var key = idState + '_sep_' + index;
      var separatorIconProps = mergeProps({
        className: cx('separatorIcon'),
        'aria-hidden': 'true'
      }, ptm('separatorIcon'));
      var icon = props.separatorIcon || /*#__PURE__*/React__namespace.createElement(ChevronRightIcon, separatorIconProps);
      var separatorIcon = IconUtils.getJSXIcon(icon, _objectSpread$1L({}, separatorIconProps), {
        props: props
      });
      var separatorProps = mergeProps({
        id: key,
        className: cx('separator'),
        role: 'separator'
      }, ptm('separator'));
      return /*#__PURE__*/React__namespace.createElement("li", _extends({}, separatorProps, {
        key: key
      }), separatorIcon);
    };
    var createMenuitem = function createMenuitem(item, index) {
      if (item.visible === false) {
        return null;
      }
      var labelProps = mergeProps({
        className: cx('label')
      }, ptm('label'));
      var label = item.label && /*#__PURE__*/React__namespace.createElement("span", labelProps, item.label);
      var actionProps = mergeProps({
        href: item.url || '#',
        className: cx('action'),
        target: item.target,
        'aria-current': isCurrent(item.url),
        onClick: function onClick(event) {
          return itemClick(event, item);
        },
        'aria-disabled': item.disabled,
        tabIndex: item.disabled ? -1 : undefined
      }, ptm('action'));
      var content = /*#__PURE__*/React__namespace.createElement("a", actionProps, label);
      if (item.template) {
        var defaultContentOptions = {
          onClick: function onClick(event) {
            return itemClick(event, item);
          },
          className: 'p-menuitem-link',
          labelClassName: 'p-menuitem-text',
          element: content,
          props: props
        };
        content = ObjectUtils.getJSXElement(item.template, item, defaultContentOptions);
      }
      var key = item.id || idState + '_' + index;
      var menuitemProps = mergeProps({
        id: key,
        className: cx('menuitem', {
          item: item
        }),
        style: item.style
      }, ptm('menuitem'));
      return /*#__PURE__*/React__namespace.createElement("li", _extends({}, menuitemProps, {
        key: key
      }), content);
    };
    var createMenuitems = function createMenuitems() {
      if (props.model) {
        var _items = props.model.map(function (item, index) {
          if (item.visible === false) {
            return null;
          }
          var menuitem = createMenuitem(item, index);
          var separator = index === props.model.length - 1 ? null : createSeparator(index);
          var key = idState + '_' + index;
          return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, {
            key: key
          }, menuitem, separator);
        });
        return _items;
      }
      return null;
    };
    useMountEffect(function () {
      if (!idState) {
        setIdState(UniqueComponentId());
      }
    });
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        getElement: function getElement() {
          return elementRef.current;
        }
      };
    });
    var home = createHome();
    var items = createMenuitems();
    var separator = createSeparator('home');
    var menuProps = mergeProps({
      className: cx('menu')
    }, ptm('menu'));
    var rootProps = mergeProps({
      id: props.id,
      ref: elementRef,
      className: classNames(props.className, cx('root')),
      style: props.style
    }, BreadCrumbBase.getOtherProps(props), ptm('root'));
    return /*#__PURE__*/React__namespace.createElement("nav", rootProps, /*#__PURE__*/React__namespace.createElement("ol", menuProps, home, home && !!(items !== null && items !== void 0 && items.length) && separator, items));
  }));
  BreadCrumb.displayName = 'BreadCrumb';

  var CalendarIcon = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("path", {
      d: "M10.7838 1.51351H9.83783V0.567568C9.83783 0.417039 9.77804 0.272676 9.6716 0.166237C9.56516 0.0597971 9.42079 0 9.27027 0C9.11974 0 8.97538 0.0597971 8.86894 0.166237C8.7625 0.272676 8.7027 0.417039 8.7027 0.567568V1.51351H5.29729V0.567568C5.29729 0.417039 5.2375 0.272676 5.13106 0.166237C5.02462 0.0597971 4.88025 0 4.72973 0C4.5792 0 4.43484 0.0597971 4.3284 0.166237C4.22196 0.272676 4.16216 0.417039 4.16216 0.567568V1.51351H3.21621C2.66428 1.51351 2.13494 1.73277 1.74467 2.12305C1.35439 2.51333 1.13513 3.04266 1.13513 3.59459V11.9189C1.13513 12.4709 1.35439 13.0002 1.74467 13.3905C2.13494 13.7807 2.66428 14 3.21621 14H10.7838C11.3357 14 11.865 13.7807 12.2553 13.3905C12.6456 13.0002 12.8649 12.4709 12.8649 11.9189V3.59459C12.8649 3.04266 12.6456 2.51333 12.2553 2.12305C11.865 1.73277 11.3357 1.51351 10.7838 1.51351ZM3.21621 2.64865H4.16216V3.59459C4.16216 3.74512 4.22196 3.88949 4.3284 3.99593C4.43484 4.10237 4.5792 4.16216 4.72973 4.16216C4.88025 4.16216 5.02462 4.10237 5.13106 3.99593C5.2375 3.88949 5.29729 3.74512 5.29729 3.59459V2.64865H8.7027V3.59459C8.7027 3.74512 8.7625 3.88949 8.86894 3.99593C8.97538 4.10237 9.11974 4.16216 9.27027 4.16216C9.42079 4.16216 9.56516 4.10237 9.6716 3.99593C9.77804 3.88949 9.83783 3.74512 9.83783 3.59459V2.64865H10.7838C11.0347 2.64865 11.2753 2.74831 11.4527 2.92571C11.6301 3.10311 11.7297 3.34371 11.7297 3.59459V5.67568H2.27027V3.59459C2.27027 3.34371 2.36993 3.10311 2.54733 2.92571C2.72473 2.74831 2.96533 2.64865 3.21621 2.64865ZM10.7838 12.8649H3.21621C2.96533 12.8649 2.72473 12.7652 2.54733 12.5878C2.36993 12.4104 2.27027 12.1698 2.27027 11.9189V6.81081H11.7297V11.9189C11.7297 12.1698 11.6301 12.4104 11.4527 12.5878C11.2753 12.7652 11.0347 12.8649 10.7838 12.8649Z",
      fill: "currentColor"
    }));
  }));
  CalendarIcon.displayName = 'CalendarIcon';

  var ChevronLeftIcon = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("path", {
      d: "M9.61296 13C9.50997 13.0005 9.40792 12.9804 9.3128 12.9409C9.21767 12.9014 9.13139 12.8433 9.05902 12.7701L3.83313 7.54416C3.68634 7.39718 3.60388 7.19795 3.60388 6.99022C3.60388 6.78249 3.68634 6.58325 3.83313 6.43628L9.05902 1.21039C9.20762 1.07192 9.40416 0.996539 9.60724 1.00012C9.81032 1.00371 10.0041 1.08597 10.1477 1.22959C10.2913 1.37322 10.3736 1.56698 10.3772 1.77005C10.3808 1.97313 10.3054 2.16968 10.1669 2.31827L5.49496 6.99022L10.1669 11.6622C10.3137 11.8091 10.3962 12.0084 10.3962 12.2161C10.3962 12.4238 10.3137 12.6231 10.1669 12.7701C10.0945 12.8433 10.0083 12.9014 9.91313 12.9409C9.81801 12.9804 9.71596 13.0005 9.61296 13Z",
      fill: "currentColor"
    }));
  }));
  ChevronLeftIcon.displayName = 'ChevronLeftIcon';

  var ChevronUpIcon = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("path", {
      d: "M12.2097 10.4113C12.1057 10.4118 12.0027 10.3915 11.9067 10.3516C11.8107 10.3118 11.7237 10.2532 11.6506 10.1792L6.93602 5.46461L2.22139 10.1476C2.07272 10.244 1.89599 10.2877 1.71953 10.2717C1.54307 10.2556 1.3771 10.1808 1.24822 10.0593C1.11933 9.93766 1.035 9.77633 1.00874 9.6011C0.982477 9.42587 1.0158 9.2469 1.10338 9.09287L6.37701 3.81923C6.52533 3.6711 6.72639 3.58789 6.93602 3.58789C7.14565 3.58789 7.3467 3.6711 7.49502 3.81923L12.7687 9.09287C12.9168 9.24119 13 9.44225 13 9.65187C13 9.8615 12.9168 10.0626 12.7687 10.2109C12.616 10.3487 12.4151 10.4207 12.2097 10.4113Z",
      fill: "currentColor"
    }));
  }));
  ChevronUpIcon.displayName = 'ChevronUpIcon';

  var styles$X = "\n@layer primereact {\n    .p-calendar {\n        position: relative;\n        display: inline-flex;\n        max-width: 100%;\n    }\n\n    .p-calendar .p-inputtext {\n        flex: 1 1 auto;\n        width: 1%;\n    }\n\n    .p-calendar-w-btn-right .p-inputtext {\n        border-top-right-radius: 0;\n        border-bottom-right-radius: 0;\n    }\n\n    .p-calendar-w-btn-right .p-datepicker-trigger {\n        border-top-left-radius: 0;\n        border-bottom-left-radius: 0;\n    }\n\n    .p-calendar-w-btn-left .p-inputtext {\n        border-top-left-radius: 0;\n        border-bottom-left-radius: 0;\n    }\n\n    .p-calendar-w-btn-left .p-datepicker-trigger {\n        border-top-right-radius: 0;\n        border-bottom-right-radius: 0;\n    }\n\n    /* Fluid */\n    .p-fluid .p-calendar {\n        display: flex;\n    }\n\n    .p-fluid .p-calendar .p-inputtext {\n        width: 1%;\n    }\n\n    /* Datepicker */\n    .p-calendar .p-datepicker {\n        min-width: 100%;\n    }\n\n    .p-datepicker {\n        width: auto;\n        position: absolute;\n        top: 0;\n        left: 0;\n    }\n\n    .p-datepicker-inline {\n        display: inline-block;\n        position: static;\n        overflow-x: auto;\n    }\n\n    /* Header */\n    .p-datepicker-header {\n        display: flex;\n        align-items: center;\n        justify-content: space-between;\n    }\n\n    .p-datepicker-header .p-datepicker-title {\n        margin: 0 auto;\n    }\n\n    .p-datepicker-prev,\n    .p-datepicker-next {\n        cursor: pointer;\n        display: inline-flex;\n        justify-content: center;\n        align-items: center;\n        overflow: hidden;\n        position: relative;\n    }\n\n    /* Multiple Month DatePicker */\n    .p-datepicker-multiple-month .p-datepicker-group-container {\n        display: flex;\n    }\n\n    .p-datepicker-multiple-month .p-datepicker-group-container .p-datepicker-group {\n        flex: 1 1 auto;\n    }\n\n    /* Multiple Month DatePicker */\n    .p-datepicker-multiple-month .p-datepicker-group-container {\n        display: flex;\n    }\n\n    /* DatePicker Table */\n    .p-datepicker table {\n        width: 100%;\n        border-collapse: collapse;\n    }\n\n    .p-datepicker td > span {\n        display: flex;\n        justify-content: center;\n        align-items: center;\n        cursor: pointer;\n        margin: 0 auto;\n        overflow: hidden;\n        position: relative;\n    }\n\n    /* Month Picker */\n    .p-monthpicker-month {\n        width: 33.3%;\n        display: inline-flex;\n        align-items: center;\n        justify-content: center;\n        cursor: pointer;\n        overflow: hidden;\n        position: relative;\n    }\n\n    /*  Button Bar */\n    .p-datepicker-buttonbar {\n        display: flex;\n        justify-content: space-between;\n        align-items: center;\n    }\n\n    /* Time Picker */\n    .p-timepicker {\n        display: flex;\n        justify-content: center;\n        align-items: center;\n    }\n\n    .p-timepicker button {\n        display: flex;\n        align-items: center;\n        justify-content: center;\n        cursor: pointer;\n        overflow: hidden;\n        position: relative;\n    }\n\n    .p-timepicker > div {\n        display: flex;\n        align-items: center;\n        flex-direction: column;\n    }\n\n    /* Touch UI */\n    .p-datepicker-touch-ui,\n    .p-calendar .p-datepicker-touch-ui {\n        position: fixed;\n        top: 50%;\n        left: 50%;\n        min-width: 80vw;\n        transform: translate(-50%, -50%);\n    }\n\n    /* Year Picker */\n    .p-yearpicker-year {\n        width: 50%;\n        display: inline-flex;\n        align-items: center;\n        justify-content: center;\n        cursor: pointer;\n        overflow: hidden;\n        position: relative;\n    }\n}\n";
  var classes$17 = {
    root: function root(_ref) {
      var props = _ref.props,
        focusedState = _ref.focusedState,
        isFilled = _ref.isFilled,
        panelVisible = _ref.panelVisible;
      return classNames('p-calendar p-component p-inputwrapper', _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty({}, "p-calendar-w-btn p-calendar-w-btn-".concat(props.iconPos), props.showIcon), 'p-calendar-disabled', props.disabled), 'p-invalid', props.invalid), 'p-calendar-timeonly', props.timeOnly), 'p-inputwrapper-filled', props.value || isFilled), 'p-inputwrapper-focus', focusedState), 'p-focus', focusedState || panelVisible));
    },
    input: function input(_ref2) {
      var props = _ref2.props,
        context = _ref2.context;
      return classNames('p-inputtext p-component', {
        'p-variant-filled': props.variant ? props.variant === 'filled' : context && context.inputStyle === 'filled'
      });
    },
    dropdownButton: 'p-datepicker-trigger',
    buttonbar: 'p-datepicker-buttonbar',
    todayButton: 'p-button-text',
    clearButton: 'p-button-text',
    footer: 'p-datepicker-footer',
    yearPicker: 'p-yearpicker',
    year: function year(_ref3) {
      var isYearSelected = _ref3.isYearSelected,
        y = _ref3.y,
        isMonthYearDisabled = _ref3.isMonthYearDisabled;
      return classNames('p-yearpicker-year', {
        'p-highlight': isYearSelected(y),
        'p-disabled': isMonthYearDisabled(-1, y)
      });
    },
    monthPicker: 'p-monthpicker',
    month: function month(_ref4) {
      var isMonthSelected = _ref4.isMonthSelected,
        isMonthYearDisabled = _ref4.isMonthYearDisabled,
        i = _ref4.i,
        currentYear = _ref4.currentYear;
      return classNames('p-monthpicker-month', {
        'p-highlight': isMonthSelected(i),
        'p-disabled': isMonthYearDisabled(i, currentYear)
      });
    },
    hourPicker: 'p-hour-picker',
    secondPicker: 'p-second-picker',
    minutePicker: 'p-minute-picker',
    millisecondPicker: 'p-millisecond-picker',
    ampmPicker: 'p-ampm-picker',
    separatorContainer: 'p-separator',
    dayLabel: function dayLabel(_ref5) {
      var className = _ref5.className;
      return className;
    },
    day: function day(_ref6) {
      var date = _ref6.date;
      return classNames({
        'p-datepicker-other-month': date.otherMonth,
        'p-datepicker-today': date.today
      });
    },
    panel: function panel(_ref7) {
      var panelClassName = _ref7.panelClassName;
      return panelClassName;
    },
    previousIcon: 'p-datepicker-prev-icon',
    previousButton: 'p-datepicker-prev',
    nextIcon: 'p-datepicker-next-icon',
    nextButton: 'p-datepicker-next',
    incrementButton: 'p-link',
    decrementButton: 'p-link',
    title: 'p-datepicker-title',
    timePicker: 'p-timepicker',
    monthTitle: 'p-datepicker-month p-link',
    yearTitle: 'p-datepicker-year p-link',
    decadeTitle: 'p-datepicker-decade',
    header: 'p-datepicker-header',
    groupContainer: 'p-datepicker-group-container',
    group: 'p-datepicker-group',
    select: function select(_ref8) {
      var props = _ref8.props;
      return props.monthNavigator && props.view !== 'month' ? 'p-datepicker-month' : props.yearNavigator ? 'p-datepicker-year' : undefined;
    },
    weekHeader: 'p-datepicker-weekheader p-disabled',
    weekNumber: 'p-datepicker-weeknumber',
    weekLabelContainer: 'p-disabled',
    container: 'p-datepicker-calendar-container',
    table: 'p-datepicker-calendar',
    transition: 'p-connected-overlay'
  };
  var CalendarBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'Calendar',
      appendTo: null,
      ariaLabelledBy: null,
      ariaLabel: null,
      autoZIndex: true,
      autoFocus: false,
      baseZIndex: 0,
      className: null,
      clearButtonClassName: 'p-button-secondary',
      dateFormat: null,
      dateTemplate: null,
      decadeTemplate: null,
      decrementIcon: null,
      disabled: false,
      disabledDates: null,
      disabledDays: null,
      enabledDates: null,
      footerTemplate: null,
      formatDateTime: null,
      headerTemplate: null,
      hideOnDateTimeSelect: false,
      hideOnRangeSelection: false,
      hourFormat: '24',
      icon: null,
      iconPos: 'right',
      id: null,
      incrementIcon: null,
      inline: false,
      inputClassName: null,
      inputId: null,
      inputMode: 'none',
      inputRef: null,
      inputStyle: null,
      variant: null,
      invalid: false,
      keepInvalid: false,
      locale: null,
      mask: null,
      maskSlotChar: '_',
      maxDate: null,
      maxDateCount: null,
      minDate: null,
      monthNavigator: false,
      monthNavigatorTemplate: null,
      name: null,
      nextIcon: null,
      numberOfMonths: 1,
      onBlur: null,
      onChange: null,
      onClearButtonClick: null,
      onFocus: null,
      onHide: null,
      onInput: null,
      onMonthChange: null,
      onSelect: null,
      onShow: null,
      onTodayButtonClick: null,
      onViewDateChange: null,
      onVisibleChange: null,
      panelClassName: null,
      panelStyle: null,
      parseDateTime: null,
      placeholder: null,
      prevIcon: null,
      readOnlyInput: false,
      required: false,
      selectOtherMonths: false,
      selectionMode: 'single',
      shortYearCutoff: '+10',
      showButtonBar: false,
      showIcon: false,
      showMillisec: false,
      showMinMaxRange: false,
      showOnFocus: true,
      showOtherMonths: true,
      showSeconds: false,
      showTime: false,
      showWeek: false,
      stepHour: 1,
      stepMillisec: 1,
      stepMinute: 1,
      stepSecond: 1,
      style: null,
      tabIndex: null,
      timeOnly: false,
      todayButtonClassName: 'p-button-secondary',
      tooltip: null,
      tooltipOptions: null,
      touchUI: false,
      transitionOptions: null,
      value: null,
      view: 'date',
      viewDate: null,
      visible: false,
      yearNavigator: false,
      yearNavigatorTemplate: null,
      yearRange: null,
      children: undefined
    },
    css: {
      classes: classes$17,
      styles: styles$X
    }
  });

  var CalendarPanel = /*#__PURE__*/React__namespace.forwardRef(function (props, ref) {
    var cx = props.cx;
    var mergeProps = useMergeProps();
    var createElement = function createElement() {
      var panelProps = mergeProps({
        className: cx('panel', {
          panelClassName: props.className
        }),
        style: props.style,
        role: props.inline ? null : 'dialog',
        id: props.id,
        'aria-label': localeOption('chooseDate', props.locale),
        'aria-modal': props.inline ? null : 'true',
        onClick: props.onClick,
        onMouseUp: props.onMouseUp
      }, props.ptm('panel', {
        hostName: props.hostName
      }));
      var transitionProps = mergeProps({
        classNames: cx('transition'),
        "in": props["in"],
        timeout: {
          enter: 120,
          exit: 100
        },
        options: props.transitionOptions,
        unmountOnExit: true,
        onEnter: props.onEnter,
        onEntered: props.onEntered,
        onExit: props.onExit,
        onExited: props.onExited
      }, props.ptm('transition', {
        hostName: props.hostName
      }));
      return /*#__PURE__*/React__namespace.createElement(CSSTransition, _extends({
        nodeRef: ref
      }, transitionProps), /*#__PURE__*/React__namespace.createElement("div", _extends({
        ref: ref
      }, panelProps), props.children));
    };
    var element = createElement();
    return props.inline ? element : /*#__PURE__*/React__namespace.createElement(Portal, {
      element: element,
      appendTo: props.appendTo
    });
  });
  CalendarPanel.displayName = 'CalendarPanel';

  function ownKeys$1K(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1K(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1K(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1K(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  function _createForOfIteratorHelper$e(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray$e(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t["return"] || t["return"](); } finally { if (u) throw o; } } }; }
  function _unsupportedIterableToArray$e(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray$e(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray$e(r, a) : void 0; } }
  function _arrayLikeToArray$e(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
  var Calendar = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var mergeProps = useMergeProps();
    var context = React__namespace.useContext(PrimeReactContext);
    var props = CalendarBase.getProps(inProps, context);
    var _React$useState = React__namespace.useState(false),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      focusedState = _React$useState2[0],
      setFocusedState = _React$useState2[1];
    var _React$useState3 = React__namespace.useState(false),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      overlayVisibleState = _React$useState4[0],
      setOverlayVisibleState = _React$useState4[1];
    var _React$useState5 = React__namespace.useState(null),
      _React$useState6 = _slicedToArray(_React$useState5, 2),
      viewDateState = _React$useState6[0],
      setViewDateState = _React$useState6[1];
    var _React$useState7 = React__namespace.useState(props.id),
      _React$useState8 = _slicedToArray(_React$useState7, 2),
      idState = _React$useState8[0],
      setIdState = _React$useState8[1];
    var isCloseOnEscape = overlayVisibleState && props.closeOnEscape;
    var overlayDisplayOrder = useDisplayOrder('overlay-panel', isCloseOnEscape);
    var metaData = {
      props: props,
      state: {
        focused: focusedState,
        overlayVisible: overlayVisibleState,
        viewDate: viewDateState
      }
    };
    var _CalendarBase$setMeta = CalendarBase.setMetaData(metaData),
      ptm = _CalendarBase$setMeta.ptm,
      cx = _CalendarBase$setMeta.cx,
      isUnstyled = _CalendarBase$setMeta.isUnstyled;
    useGlobalOnEscapeKey({
      callback: function callback() {
        hide(null, reFocusInputField);
      },
      when: overlayVisibleState && overlayDisplayOrder,
      priority: [ESC_KEY_HANDLING_PRIORITIES.OVERLAY_PANEL, overlayDisplayOrder]
    });
    useHandleStyle(CalendarBase.css.styles, isUnstyled, {
      name: 'calendar'
    });
    var elementRef = React__namespace.useRef(null);
    var overlayRef = React__namespace.useRef(null);
    var inputRef = React__namespace.useRef(props.inputRef);
    var navigation = React__namespace.useRef(null);
    var ignoreFocusFunctionality = React__namespace.useRef(false);
    var timePickerTimer = React__namespace.useRef(null);
    var viewStateChanged = React__namespace.useRef(false);
    var touchUIMask = React__namespace.useRef(null);
    var overlayEventListener = React__namespace.useRef(null);
    var touchUIMaskClickListener = React__namespace.useRef(null);
    var isOverlayClicked = React__namespace.useRef(false);
    var previousButton = React__namespace.useRef(false);
    var nextButton = React__namespace.useRef(false);
    var viewChangedWithKeyDown = React__namespace.useRef(false);
    var onChangeRef = React__namespace.useRef(null);
    var isClearClicked = React__namespace.useRef(false);
    var _React$useState9 = React__namespace.useState('date'),
      _React$useState10 = _slicedToArray(_React$useState9, 2),
      currentView = _React$useState10[0],
      setCurrentView = _React$useState10[1];
    var _React$useState11 = React__namespace.useState(null),
      _React$useState12 = _slicedToArray(_React$useState11, 2),
      currentMonth = _React$useState12[0],
      setCurrentMonth = _React$useState12[1];
    var _React$useState13 = React__namespace.useState(null),
      _React$useState14 = _slicedToArray(_React$useState13, 2),
      currentYear = _React$useState14[0],
      setCurrentYear = _React$useState14[1];
    var _React$useState15 = React__namespace.useState([]),
      _React$useState16 = _slicedToArray(_React$useState15, 2),
      yearOptions = _React$useState16[0],
      setYearOptions = _React$useState16[1];
    var previousValue = usePrevious(props.value);
    var visible = props.inline || (props.onVisibleChange ? props.visible : overlayVisibleState);
    var attributeSelector = UniqueComponentId();
    var panelId = idState + '_panel';
    var _useOverlayListener = useOverlayListener({
        target: elementRef,
        overlay: overlayRef,
        listener: function listener(event, _ref) {
          var type = _ref.type,
            valid = _ref.valid;
          if (valid) {
            if (type === 'outside') {
              if (!isOverlayClicked.current && !isNavIconClicked(event.target)) {
                hide('outside');
              }
            } else if (context.hideOverlaysOnDocumentScrolling) {
              hide();
            } else if (!DomHandler.isDocument(event.target)) {
              alignOverlay();
            }
          }
          isOverlayClicked.current = false;
        },
        when: !(props.touchUI || props.inline) && visible,
        type: 'mousedown'
      }),
      _useOverlayListener2 = _slicedToArray(_useOverlayListener, 2),
      bindOverlayListener = _useOverlayListener2[0],
      unbindOverlayListener = _useOverlayListener2[1];
    var getDateFormat = function getDateFormat() {
      return props.dateFormat || localeOption('dateFormat', props.locale);
    };
    var onInputFocus = function onInputFocus(event) {
      if (ignoreFocusFunctionality.current) {
        setFocusedState(true);
        ignoreFocusFunctionality.current = false;
      } else {
        if (props.showOnFocus && !visible) {
          show();
        }
        setFocusedState(true);
        props.onFocus && props.onFocus(event);
      }
    };
    var onInputBlur = function onInputBlur(event) {
      updateInputfield(props.value);
      props.onBlur && props.onBlur(event);
      setFocusedState(false);
    };
    var onInputKeyDown = function onInputKeyDown(event) {
      switch (event.code) {
        case 'ArrowDown':
          {
            if (!overlayVisibleState) {
              show();
            } else {
              focusToFirstCell();
              event.preventDefault();
            }
            break;
          }
        case 'Escape':
          {
            hide();
            props.touchUI && disableModality();
            break;
          }
        case 'Tab':
          {
            if (overlayRef && overlayRef.current) {
              DomHandler.getFocusableElements(overlayRef.current).forEach(function (el) {
                return el.tabIndex = '-1';
              });
              hide();
              props.touchUI && disableModality();
            }
            break;
          }
      }
    };
    var onUserInput = function onUserInput(event) {
      updateValueOnInput(event, event.target.value);
      props.onInput && props.onInput(event);
    };
    var updateValueOnInput = function updateValueOnInput(event, rawValue, invalidCallback) {
      try {
        var value = parseValueFromString(props.timeOnly ? rawValue.replace('_', '') : rawValue);
        if (isValidSelection(value)) {
          validateDate(value);
          updateModel(event, value);
          var date = value.length ? value[0] : value;
          updateViewDate(event, date);
        }
      } catch (err) {
        //invalid date
        if (invalidCallback) {
          invalidCallback();
        } else {
          var _value = props.keepInvalid ? rawValue : null;
          updateModel(event, _value);
        }
      }
    };
    var onViewDateSelect = function onViewDateSelect(_ref2) {
      var event = _ref2.event,
        date = _ref2.date;
      if (date && props.onSelect) {
        var day = date.getDate();
        var month = date.getMonth();
        var year = date.getFullYear();
        onDateSelect(event, {
          day: day,
          month: month,
          year: year,
          selectable: isSelectable(day, month, year)
        }, null, true);
      }
    };
    var reFocusInputField = function reFocusInputField() {
      if (!props.inline && inputRef.current) {
        ignoreFocusFunctionality.current = true;
        DomHandler.focus(inputRef.current);
      }
    };
    var isValidSelection = function isValidSelection(value) {
      var isValid = true;
      if (isSingleSelection()) {
        if (!(isSelectable(value.getDate(), value.getMonth(), value.getFullYear(), false) && isSelectableTime(value))) {
          isValid = false;
        }
      } else if (value.every(function (v) {
        return isSelectable(v.getDate(), v.getMonth(), v.getFullYear(), false) && isSelectableTime(v);
      })) {
        if (isRangeSelection()) {
          isValid = value.length > 1 && value[1] >= value[0];
        }
      }
      return isValid;
    };
    var onButtonClick = function onButtonClick() {
      visible ? hide() : show();
    };
    var onPrevButtonClick = function onPrevButtonClick(event) {
      navigation.current = {
        backward: true,
        button: true
      };
      navBackward(event);
    };
    var onNextButtonClick = function onNextButtonClick(event) {
      navigation.current = {
        backward: false,
        button: true
      };
      navForward(event);
    };
    var onContainerButtonKeydown = function onContainerButtonKeydown(event) {
      switch (event.code) {
        case 'Tab':
          !props.inline && trapFocus(event);
          break;
        case 'Escape':
          hide(null, reFocusInputField);
          event.preventDefault();
          break;
      }
    };
    var onPickerKeyDown = function onPickerKeyDown(event, type, direction) {
      if (event.key === 'Enter' || event.key === 'Space') {
        onTimePickerElementMouseDown(event, type, direction);
        event.preventDefault();
        return;
      }
      onContainerButtonKeydown(event);
    };
    var onPickerKeyUp = function onPickerKeyUp(event) {
      if (event.key === 'Enter' || event.key === 'Space') {
        onTimePickerElementMouseUp();
        event.preventDefault();
        return;
      }
    };
    var trapFocus = function trapFocus(event) {
      event === null || event === void 0 || event.preventDefault();
      var focusableElements = DomHandler.getFocusableElements(overlayRef.current);
      if (focusableElements && focusableElements.length > 0) {
        if (!document.activeElement) {
          focusableElements[0].focus();
        } else {
          var focusedIndex = focusableElements.indexOf(document.activeElement);
          if (event !== null && event !== void 0 && event.shiftKey) {
            if (focusedIndex === -1 || focusedIndex === 0) {
              focusableElements[focusableElements.length - 1].focus();
            } else {
              focusableElements[focusedIndex - 1].focus();
            }
          } else if (focusedIndex === -1 || focusedIndex === focusableElements.length - 1) {
            focusableElements[0].focus();
          } else {
            focusableElements[focusedIndex + 1].focus();
          }
        }
      }
    };
    var updateFocus = function updateFocus() {
      if (navigation.current) {
        if (navigation.current.button) {
          initFocusableCell();
          if (navigation.current.backward) {
            previousButton.current.focus();
          } else {
            nextButton.current.focus();
          }
        } else {
          var cell;
          if (navigation.current.backward) {
            var cells = DomHandler.find(overlayRef.current, 'table td span:not([data-p-disabled="true"])');
            cell = cells[cells.length - 1];
          } else {
            cell = DomHandler.findSingle(overlayRef.current, 'table td span:not([data-p-disabled="true"])');
          }
          if (cell) {
            cell.tabIndex = '0';
            cell.focus();
          }
        }
        navigation.current = null;
      } else {
        initFocusableCell();
      }
    };
    var initFocusableCell = function initFocusableCell() {
      var cell;
      if (currentView === 'month') {
        var cells = DomHandler.find(overlayRef.current, '[data-pc-section="monthpicker"] [data-pc-section="month"]');
        var selectedCell = DomHandler.findSingle(overlayRef.current, '[data-pc-section="monthpicker"] [data-pc-section="month"][data-p-highlight="true"]');
        cells.forEach(function (cell) {
          return cell.tabIndex = -1;
        });
        cell = selectedCell || cells[0];
      } else {
        cell = DomHandler.findSingle(overlayRef.current, 'span[data-p-highlight="true"]');
        if (!cell) {
          var todayCell = DomHandler.findSingle(overlayRef.current, 'td.p-datepicker-today span:not(.p-disabled)');
          cell = todayCell || DomHandler.findSingle(overlayRef.current, 'table td span:not([data-p-disabled="true"])');
        }
      }
      if (cell) {
        cell.tabIndex = '0';
      }
    };
    var focusToFirstCell = function focusToFirstCell() {
      if (currentView) {
        var cell;
        if (currentView === 'date') {
          cell = DomHandler.findSingle(overlayRef.current, 'span[data-p-highlight="true"]');
          if (!cell) {
            var todayCell = DomHandler.findSingle(overlayRef.current, 'td.p-datepicker-today span:not(.p-disabled)');
            cell = todayCell || DomHandler.findSingle(overlayRef.current, 'table td span:not([data-p-disabled="true"])');
          }
        } else if (currentView === 'month' || currentView === 'year') {
          cell = DomHandler.findSingle(overlayRef.current, 'span[data-p-highlight="true"]');
          if (!cell) {
            cell = DomHandler.findSingle(overlayRef.current, "[data-pc-section=\"".concat(currentView, "picker\"] [data-pc-section=\"").concat(currentView, "\"]:not([data-p-disabled=\"true\"])"));
          }
        }
        if (cell) {
          cell.tabIndex = '0';
          cell && cell.focus();
        }
      }
    };
    var navBackward = function navBackward(event) {
      if (props.disabled) {
        event.preventDefault();
        return;
      }
      var newViewDate = cloneDate(getViewDate());
      newViewDate.setDate(1);
      if (currentView === 'date') {
        if (newViewDate.getMonth() === 0) {
          var newYear = decrementYear();
          newViewDate.setMonth(11);
          newViewDate.setFullYear(newYear);
          props.onMonthChange && props.onMonthChange({
            month: 11,
            year: newYear
          });
          setCurrentMonth(11);
        } else {
          newViewDate.setMonth(newViewDate.getMonth() - 1);
          props.onMonthChange && props.onMonthChange({
            month: currentMonth - 1,
            year: currentYear
          });
          setCurrentMonth(function (prevState) {
            return prevState - 1;
          });
        }
      } else if (currentView === 'month') {
        var _newYear = newViewDate.getFullYear() - 1;
        if (props.yearNavigator) {
          var minYear = parseInt(props.yearRange.split(':')[0], 10);
          if (_newYear < minYear) {
            _newYear = minYear;
          }
        }
        newViewDate.setFullYear(_newYear);
      }
      if (currentView === 'month') {
        newViewDate.setFullYear(decrementYear());
      } else if (currentView === 'year') {
        newViewDate.setFullYear(decrementDecade());
      }
      updateViewDate(event, newViewDate);
      event.preventDefault();
    };
    var navForward = function navForward(event) {
      if (props.disabled) {
        event.preventDefault();
        return;
      }
      var newViewDate = cloneDate(getViewDate());
      newViewDate.setDate(1);
      if (currentView === 'date') {
        if (newViewDate.getMonth() === 11) {
          var newYear = incrementYear();
          newViewDate.setMonth(0);
          newViewDate.setFullYear(newYear);
          props.onMonthChange && props.onMonthChange({
            month: 0,
            year: newYear
          });
          setCurrentMonth(0);
        } else {
          newViewDate.setMonth(newViewDate.getMonth() + 1);
          props.onMonthChange && props.onMonthChange({
            month: currentMonth + 1,
            year: currentYear
          });
          setCurrentMonth(function (prevState) {
            return prevState + 1;
          });
        }
      } else if (currentView === 'month') {
        var _newYear2 = newViewDate.getFullYear() + 1;
        if (props.yearNavigator) {
          var maxYear = parseInt(props.yearRange.split(':')[1], 10);
          if (_newYear2 > maxYear) {
            _newYear2 = maxYear;
          }
        }
        newViewDate.setFullYear(_newYear2);
      }
      if (currentView === 'month') {
        newViewDate.setFullYear(incrementYear());
      } else if (currentView === 'year') {
        newViewDate.setFullYear(incrementDecade());
      }
      updateViewDate(event, newViewDate);
      event.preventDefault();
    };
    var populateYearOptions = function populateYearOptions(start, end) {
      var _yearOptions = [];
      for (var i = start; i <= end; i++) {
        yearOptions.push(i);
      }
      setYearOptions(_yearOptions);
    };
    var decrementYear = function decrementYear() {
      var year = getViewYear();
      var _currentYear = year - 1;
      setCurrentYear(_currentYear);
      if (props.yearNavigator && _currentYear < yearOptions[0]) {
        var difference = yearOptions[yearOptions.length - 1] - yearOptions[0];
        populateYearOptions(yearOptions[0] - difference, yearOptions[yearOptions.length - 1] - difference);
      }
      return _currentYear;
    };
    var incrementYear = function incrementYear() {
      var year = getViewYear();
      var _currentYear = year + 1;
      setCurrentYear(_currentYear);
      if (props.yearNavigator && _currentYear.current > yearOptions[yearOptions.length - 1]) {
        var difference = yearOptions[yearOptions.length - 1] - yearOptions[0];
        populateYearOptions(yearOptions[0] + difference, yearOptions[yearOptions.length - 1] + difference);
      }
      return _currentYear;
    };
    var onMonthDropdownChange = function onMonthDropdownChange(event, value) {
      var currentViewDate = getViewDate();
      var newViewDate = cloneDate(currentViewDate);
      newViewDate.setDate(1);
      newViewDate.setMonth(parseInt(value, 10));
      updateViewDate(event, newViewDate);
    };
    var onYearDropdownChange = function onYearDropdownChange(event, value) {
      var currentViewDate = getViewDate();
      var newViewDate = cloneDate(currentViewDate);
      newViewDate.setFullYear(parseInt(value, 10));
      updateViewDate(event, newViewDate);
    };
    var onTodayButtonClick = function onTodayButtonClick(event) {
      var today = new Date();
      var dateMeta = {
        day: today.getDate(),
        month: today.getMonth(),
        year: today.getFullYear(),
        today: true,
        selectable: true
      };
      var timeMeta = {
        hours: today.getHours(),
        minutes: today.getMinutes(),
        seconds: today.getSeconds(),
        milliseconds: today.getMilliseconds()
      };
      updateViewDate(event, today);
      onDateSelect(event, dateMeta, timeMeta);
      props.onTodayButtonClick && props.onTodayButtonClick(event);
    };
    var onClearButtonClick = function onClearButtonClick(event) {
      isClearClicked.current = true;
      updateModel(event, null);
      updateInputfield(null);
      setCurrentYear(new Date().getFullYear()); // #7581
      hide();
      props.onClearButtonClick && props.onClearButtonClick(event);
    };
    var onPanelClick = function onPanelClick(event) {
      if (!props.inline) {
        OverlayService.emit('overlay-click', {
          originalEvent: event,
          target: elementRef.current
        });
      }
    };
    var onPanelMouseUp = function onPanelMouseUp(event) {
      onPanelClick(event);
    };
    var onTimePickerElementMouseDown = function onTimePickerElementMouseDown(event, type, direction) {
      if (!props.disabled) {
        _repeat(event, null, type, direction);
        event.preventDefault();
      }
    };
    var onTimePickerElementMouseUp = function onTimePickerElementMouseUp() {
      if (!props.disabled) {
        clearTimePickerTimer();
      }
    };
    var onTimePickerElementMouseLeave = function onTimePickerElementMouseLeave() {
      if (!props.disabled) {
        clearTimePickerTimer();
      }
    };
    var _repeat = function repeat(event, interval, type, direction) {
      clearTimePickerTimer();
      timePickerTimer.current = setTimeout(function () {
        _repeat(event, 100, type, direction);
      }, interval || 500);
      switch (type) {
        case 0:
          if (direction === 1) {
            incrementHour(event);
          } else {
            decrementHour(event);
          }
          break;
        case 1:
          if (direction === 1) {
            incrementMinute(event);
          } else {
            decrementMinute(event);
          }
          break;
        case 2:
          if (direction === 1) {
            incrementSecond(event);
          } else {
            decrementSecond(event);
          }
          break;
        case 3:
          if (direction === 1) {
            incrementMilliSecond(event);
          } else {
            decrementMilliSecond(event);
          }
          break;
      }
    };
    var clearTimePickerTimer = function clearTimePickerTimer() {
      if (timePickerTimer.current) {
        clearTimeout(timePickerTimer.current);
      }
    };
    var roundMinutesToStep = function roundMinutesToStep(minutes) {
      if (props.stepMinute) {
        return Math.round(minutes / props.stepMinute) * props.stepMinute;
      }
      return minutes;
    };
    var incrementHour = function incrementHour(event) {
      var currentTime = getCurrentDateTime();
      var currentHour = currentTime.getHours();
      var newHour = currentHour + props.stepHour;
      newHour = newHour >= 24 ? newHour - 24 : newHour;
      if (validateHour(newHour, currentTime)) {
        if (props.maxDate && props.maxDate.toDateString() === currentTime.toDateString() && props.maxDate.getHours() === newHour) {
          if (props.maxDate.getMinutes() < currentTime.getMinutes()) {
            if (props.maxDate.getSeconds() < currentTime.getSeconds()) {
              if (props.maxDate.getMilliseconds() < currentTime.getMilliseconds()) {
                updateTime(event, newHour, props.maxDate.getMinutes(), props.maxDate.getSeconds(), props.maxDate.getMilliseconds());
              } else {
                updateTime(event, newHour, props.maxDate.getMinutes(), props.maxDate.getSeconds(), currentTime.getMilliseconds());
              }
            } else {
              updateTime(event, newHour, props.maxDate.getMinutes(), currentTime.getSeconds(), currentTime.getMilliseconds());
            }
          } else if (props.maxDate.getMinutes() === currentTime.getMinutes()) {
            if (props.maxDate.getSeconds() < currentTime.getSeconds()) {
              if (props.maxDate.getMilliseconds() < currentTime.getMilliseconds()) {
                updateTime(event, newHour, props.maxDate.getMinutes(), props.maxDate.getSeconds(), props.maxDate.getMilliseconds());
              } else {
                updateTime(event, newHour, props.maxDate.getMinutes(), props.maxDate.getSeconds(), currentTime.getMilliseconds());
              }
            } else {
              updateTime(event, newHour, props.maxDate.getMinutes(), currentTime.getSeconds(), currentTime.getMilliseconds());
            }
          } else {
            updateTime(event, newHour, roundMinutesToStep(currentTime.getMinutes()), currentTime.getSeconds(), currentTime.getMilliseconds());
          }
        } else {
          updateTime(event, newHour, roundMinutesToStep(currentTime.getMinutes()), currentTime.getSeconds(), currentTime.getMilliseconds());
        }
      }
      event.preventDefault();
    };
    var decrementHour = function decrementHour(event) {
      var currentTime = getCurrentDateTime();
      var currentHour = currentTime.getHours();
      var newHour = currentHour - props.stepHour;
      newHour = newHour < 0 ? newHour + 24 : newHour;
      if (validateHour(newHour, currentTime)) {
        if (props.minDate && props.minDate.toDateString() === currentTime.toDateString() && props.minDate.getHours() === newHour) {
          if (props.minDate.getMinutes() > currentTime.getMinutes()) {
            if (props.minDate.getSeconds() > currentTime.getSeconds()) {
              if (props.minDate.getMilliseconds() > currentTime.getMilliseconds()) {
                updateTime(event, newHour, props.minDate.getMinutes(), props.minDate.getSeconds(), props.minDate.getMilliseconds());
              } else {
                updateTime(event, newHour, props.minDate.getMinutes(), props.minDate.getSeconds(), currentTime.getMilliseconds());
              }
            } else {
              updateTime(event, newHour, props.minDate.getMinutes(), currentTime.getSeconds(), currentTime.getMilliseconds());
            }
          } else if (props.minDate.getMinutes() === currentTime.getMinutes()) {
            if (props.minDate.getSeconds() > currentTime.getSeconds()) {
              if (props.minDate.getMilliseconds() > currentTime.getMilliseconds()) {
                updateTime(event, newHour, props.minDate.getMinutes(), props.minDate.getSeconds(), props.minDate.getMilliseconds());
              } else {
                updateTime(event, newHour, props.minDate.getMinutes(), props.minDate.getSeconds(), currentTime.getMilliseconds());
              }
            } else {
              updateTime(event, newHour, props.minDate.getMinutes(), currentTime.getSeconds(), currentTime.getMilliseconds());
            }
          } else {
            updateTime(event, newHour, roundMinutesToStep(currentTime.getMinutes()), currentTime.getSeconds(), currentTime.getMilliseconds());
          }
        } else {
          updateTime(event, newHour, roundMinutesToStep(currentTime.getMinutes()), currentTime.getSeconds(), currentTime.getMilliseconds());
        }
      }
      event.preventDefault();
    };
    var doStepMinute = function doStepMinute(currentMinute, step) {
      if (props.stepMinute <= 1) {
        return step ? currentMinute + step : currentMinute;
      }
      if (!step) {
        step = props.stepMinute;
        if (currentMinute % step === 0) {
          return currentMinute;
        }
      }
      return Math.floor((currentMinute + step) / step) * step;
    };
    var incrementMinute = function incrementMinute(event) {
      var currentTime = getCurrentDateTime();
      var currentMinute = currentTime.getMinutes();
      var newMinute = doStepMinute(currentMinute, props.stepMinute);
      newMinute = newMinute > 59 ? newMinute - 60 : newMinute;
      if (validateMinute(newMinute, currentTime)) {
        if (props.maxDate && props.maxDate.toDateString() === currentTime.toDateString() && props.maxDate.getMinutes() === newMinute) {
          if (props.maxDate.getSeconds() < currentTime.getSeconds()) {
            if (props.maxDate.getMilliseconds() < currentTime.getMilliseconds()) {
              updateTime(event, currentTime.getHours(), newMinute, props.maxDate.getSeconds(), props.maxDate.getMilliseconds());
            } else {
              updateTime(event, currentTime.getHours(), newMinute, props.maxDate.getSeconds(), currentTime.getMilliseconds());
            }
          } else {
            updateTime(event, currentTime.getHours(), newMinute, currentTime.getSeconds(), currentTime.getMilliseconds());
          }
        } else {
          updateTime(event, currentTime.getHours(), newMinute, currentTime.getSeconds(), currentTime.getMilliseconds());
        }
      }
      event.preventDefault();
    };
    var decrementMinute = function decrementMinute(event) {
      var currentTime = getCurrentDateTime();
      var currentMinute = currentTime.getMinutes();
      var newMinute = doStepMinute(currentMinute, -props.stepMinute);
      newMinute = newMinute < 0 ? newMinute + 60 : newMinute;
      if (validateMinute(newMinute, currentTime)) {
        if (props.minDate && props.minDate.toDateString() === currentTime.toDateString() && props.minDate.getMinutes() === newMinute) {
          if (props.minDate.getSeconds() > currentTime.getSeconds()) {
            if (props.minDate.getMilliseconds() > currentTime.getMilliseconds()) {
              updateTime(event, currentTime.getHours(), newMinute, props.minDate.getSeconds(), props.minDate.getMilliseconds());
            } else {
              updateTime(event, currentTime.getHours(), newMinute, props.minDate.getSeconds(), currentTime.getMilliseconds());
            }
          } else {
            updateTime(event, currentTime.getHours(), newMinute, currentTime.getSeconds(), currentTime.getMilliseconds());
          }
        } else {
          updateTime(event, currentTime.getHours(), newMinute, currentTime.getSeconds(), currentTime.getMilliseconds());
        }
      }
      event.preventDefault();
    };
    var incrementSecond = function incrementSecond(event) {
      var currentTime = getCurrentDateTime();
      var currentSecond = currentTime.getSeconds();
      var newSecond = currentSecond + props.stepSecond;
      newSecond = newSecond > 59 ? newSecond - 60 : newSecond;
      if (validateSecond(newSecond, currentTime)) {
        if (props.maxDate && props.maxDate.toDateString() === currentTime.toDateString() && props.maxDate.getSeconds() === newSecond) {
          if (props.maxDate.getMilliseconds() < currentTime.getMilliseconds()) {
            updateTime(event, currentTime.getHours(), currentTime.getMinutes(), newSecond, props.maxDate.getMilliseconds());
          } else {
            updateTime(event, currentTime.getHours(), currentTime.getMinutes(), newSecond, currentTime.getMilliseconds());
          }
        } else {
          updateTime(event, currentTime.getHours(), currentTime.getMinutes(), newSecond, currentTime.getMilliseconds());
        }
      }
      event.preventDefault();
    };
    var decrementSecond = function decrementSecond(event) {
      var currentTime = getCurrentDateTime();
      var currentSecond = currentTime.getSeconds();
      var newSecond = currentSecond - props.stepSecond;
      newSecond = newSecond < 0 ? newSecond + 60 : newSecond;
      if (validateSecond(newSecond, currentTime)) {
        if (props.minDate && props.minDate.toDateString() === currentTime.toDateString() && props.minDate.getSeconds() === newSecond) {
          if (props.minDate.getMilliseconds() > currentTime.getMilliseconds()) {
            updateTime(event, currentTime.getHours(), currentTime.getMinutes(), newSecond, props.minDate.getMilliseconds());
          } else {
            updateTime(event, currentTime.getHours(), currentTime.getMinutes(), newSecond, currentTime.getMilliseconds());
          }
        } else {
          updateTime(event, currentTime.getHours(), currentTime.getMinutes(), newSecond, currentTime.getMilliseconds());
        }
      }
      event.preventDefault();
    };
    var incrementMilliSecond = function incrementMilliSecond(event) {
      var currentTime = getCurrentDateTime();
      var currentMillisecond = currentTime.getMilliseconds();
      var newMillisecond = currentMillisecond + props.stepMillisec;
      newMillisecond = newMillisecond > 999 ? newMillisecond - 1000 : newMillisecond;
      if (validateMillisecond(newMillisecond, currentTime)) {
        updateTime(event, currentTime.getHours(), currentTime.getMinutes(), currentTime.getSeconds(), newMillisecond);
      }
      event.preventDefault();
    };
    var decrementMilliSecond = function decrementMilliSecond(event) {
      var currentTime = getCurrentDateTime();
      var currentMillisecond = currentTime.getMilliseconds();
      var newMillisecond = currentMillisecond - props.stepMillisec;
      newMillisecond = newMillisecond < 0 ? newMillisecond + 999 : newMillisecond;
      if (validateMillisecond(newMillisecond, currentTime)) {
        updateTime(event, currentTime.getHours(), currentTime.getMinutes(), currentTime.getSeconds(), newMillisecond);
      }
      event.preventDefault();
    };
    var toggleAmPm = function toggleAmPm(event) {
      var currentTime = getCurrentDateTime();
      var currentHour = currentTime.getHours();
      var newHour = currentHour >= 12 ? currentHour - 12 : currentHour + 12;
      if (validateHour(convertTo24Hour(newHour, currentHour > 11), currentTime)) {
        updateTime(event, newHour, currentTime.getMinutes(), currentTime.getSeconds(), currentTime.getMilliseconds());
      }
      event.preventDefault();
    };
    var getViewDate = function getViewDate(date) {
      var propValue = props.value;
      var viewDate = date || (props.onViewDateChange ? props.viewDate : viewDateState);
      if (Array.isArray(propValue)) {
        propValue = propValue[0];
      }
      return viewDate && isValidDate(viewDate) ? viewDate : propValue && isValidDate(propValue) ? propValue : new Date();
    };
    var getCurrentDateTime = function getCurrentDateTime() {
      if (isSingleSelection()) {
        return props.value && props.value instanceof Date ? cloneDate(props.value) : getViewDate();
      } else if (isMultipleSelection()) {
        if (props.value && props.value.length) {
          return cloneDate(props.value[props.value.length - 1]);
        }
      } else if (isRangeSelection()) {
        if (props.value && props.value.length) {
          var startDate = cloneDate(props.value[0]);
          var endDate = cloneDate(props.value[1]);
          return endDate || startDate;
        }
      }
      return new Date();
    };
    var cloneDate = function cloneDate(date) {
      return isValidDate(date) ? new Date(date.valueOf()) : date;
    };
    var isValidDate = function isValidDate(date) {
      return date instanceof Date && !isNaN(date);
    };
    var convertTo24Hour = function convertTo24Hour(hour, pm) {
      if (props.hourFormat === '12') {
        return hour === 12 ? pm ? 12 : 0 : pm ? hour + 12 : hour;
      }
      return hour;
    };
    var validateHour = function validateHour(hour, value) {
      var valid = true;
      var valueDateString = value ? value.toDateString() : null;
      if (props.minDate && valueDateString && props.minDate.toDateString() === valueDateString) {
        if (props.minDate.getHours() > hour) {
          valid = false;
        }
      }
      if (props.maxDate && valueDateString && props.maxDate.toDateString() === valueDateString) {
        if (props.maxDate.getHours() < hour) {
          valid = false;
        }
      }
      return valid;
    };
    var validateMinute = function validateMinute(minute, value) {
      var valid = true;
      var valueDateString = value ? value.toDateString() : null;
      if (props.minDate && valueDateString && props.minDate.toDateString() === valueDateString) {
        if (value.getHours() === props.minDate.getHours()) {
          if (props.minDate.getMinutes() > minute) {
            valid = false;
          }
        }
      }
      if (props.maxDate && valueDateString && props.maxDate.toDateString() === valueDateString) {
        if (value.getHours() === props.maxDate.getHours()) {
          if (props.maxDate.getMinutes() < minute) {
            valid = false;
          }
        }
      }
      return valid;
    };
    var validateSecond = function validateSecond(second, value) {
      var valid = true;
      var valueDateString = value ? value.toDateString() : null;
      if (props.minDate && valueDateString && props.minDate.toDateString() === valueDateString) {
        if (value.getHours() === props.minDate.getHours() && value.getMinutes() === props.minDate.getMinutes()) {
          if (props.minDate.getSeconds() > second) {
            valid = false;
          }
        }
      }
      if (props.maxDate && valueDateString && props.maxDate.toDateString() === valueDateString) {
        if (value.getHours() === props.maxDate.getHours() && value.getMinutes() === props.maxDate.getMinutes()) {
          if (props.maxDate.getSeconds() < second) {
            valid = false;
          }
        }
      }
      return valid;
    };
    var validateMillisecond = function validateMillisecond(millisecond, value) {
      var valid = true;
      var valueDateString = value ? value.toDateString() : null;
      if (props.minDate && valueDateString && props.minDate.toDateString() === valueDateString) {
        if (value.getHours() === props.minDate.getHours() && value.getSeconds() === props.minDate.getSeconds() && value.getMinutes() === props.minDate.getMinutes()) {
          if (props.minDate.getMilliseconds() > millisecond) {
            valid = false;
          }
        }
      }
      if (props.maxDate && valueDateString && props.maxDate.toDateString() === valueDateString) {
        if (value.getHours() === props.maxDate.getHours() && value.getSeconds() === props.maxDate.getSeconds() && value.getMinutes() === props.maxDate.getMinutes()) {
          if (props.maxDate.getMilliseconds() < millisecond) {
            valid = false;
          }
        }
      }
      return valid;
    };
    var validateDate = function validateDate(value) {
      if (props.yearNavigator) {
        var _ref3 = props.yearRange ? props.yearRange.split(':').map(function (year) {
            return parseInt(year, 10);
          }) : [null, null],
          _ref4 = _slicedToArray(_ref3, 2),
          minRangeYear = _ref4[0],
          maxRangeYear = _ref4[1];
        var viewYear = value.getFullYear();
        var minYear = null;
        var maxYear = null;
        if (minRangeYear !== null) {
          minYear = props.minDate ? Math.max(props.minDate.getFullYear(), minRangeYear) : minRangeYear;
        } else {
          var _props$minDate;
          minYear = ((_props$minDate = props.minDate) === null || _props$minDate === void 0 ? void 0 : _props$minDate.getFullYear()) || minRangeYear;
        }
        if (maxRangeYear !== null) {
          maxYear = props.maxDate ? Math.min(props.maxDate.getFullYear(), maxRangeYear) : maxRangeYear;
        } else {
          var _props$maxDate;
          maxYear = ((_props$maxDate = props.maxDate) === null || _props$maxDate === void 0 ? void 0 : _props$maxDate.getFullYear()) || maxRangeYear;
        }
        if (minYear && minYear > viewYear) viewYear = minYear;
        if (maxYear && maxYear < viewYear) viewYear = maxYear;
        value.setFullYear(viewYear);
      }
      if (renderMonthsNavigator(0)) {
        var viewMonth = value.getMonth();
        var viewMonthWithMinMax = parseInt(isInMinYear(value) && Math.max(props.minDate.getMonth(), viewMonth).toString() || isInMaxYear(value) && Math.min(props.maxDate.getMonth(), viewMonth).toString() || viewMonth);
        value.setMonth(viewMonthWithMinMax);
      }
    };
    var updateTime = function updateTime(event, hour, minute, second, millisecond) {
      var newDateTime = getCurrentDateTime();
      newDateTime.setHours(hour);
      newDateTime.setMinutes(minute);
      newDateTime.setSeconds(second);
      newDateTime.setMilliseconds(millisecond);
      if (isMultipleSelection()) {
        if (props.value && props.value.length) {
          var value = _toConsumableArray(props.value);
          value[value.length - 1] = newDateTime;
          newDateTime = value;
        } else {
          newDateTime = [newDateTime];
        }
      } else if (isRangeSelection()) {
        if (props.value && props.value.length) {
          var startDate = props.value[0];
          var endDate = props.value[1];
          newDateTime = endDate ? [startDate, newDateTime] : [newDateTime, null];
        } else {
          newDateTime = [newDateTime, null];
        }
      }
      updateModel(event, newDateTime);
      if (props.onSelect) {
        props.onSelect({
          originalEvent: event,
          value: newDateTime
        });
      }
      updateInputfield(newDateTime);
    };
    var updateViewDate = function updateViewDate(event, value) {
      validateDate(value);
      if (props.onViewDateChange && event) {
        props.onViewDateChange({
          originalEvent: event,
          value: value
        });
      } else {
        viewStateChanged.current = true;
        setViewDateState(value);
      }
      if (!value) onClearButtonClick(event);
    };
    var setNavigationState = function setNavigationState(newViewDate) {
      if (!newViewDate || !props.showMinMaxRange || props.view !== 'date' || !overlayRef.current) {
        return;
      }
      var navPrev = DomHandler.findSingle(overlayRef.current, '[data-pc-section="previousbutton"]');
      var navNext = DomHandler.findSingle(overlayRef.current, '[data-pc-section="nextbutton"]');
      if (props.disabled) {
        !isUnstyled() && DomHandler.addClass(navPrev, 'p-disabled');
        navPrev.setAttribute('data-p-disabled', true);
        !isUnstyled() && DomHandler.addClass(navNext, 'p-disabled');
        navNext.setAttribute('data-p-disabled', true);
        return;
      }

      // previous (check first day of month at 00:00:00)
      if (props.minDate) {
        var firstDayOfMonth = cloneDate(newViewDate);
        if (firstDayOfMonth.getMonth() === 0) {
          firstDayOfMonth.setMonth(11, 1);
          firstDayOfMonth.setFullYear(firstDayOfMonth.getFullYear() - 1);
        } else {
          firstDayOfMonth.setMonth(firstDayOfMonth.getMonth(), 1);
        }
        firstDayOfMonth.setHours(0);
        firstDayOfMonth.setMinutes(0);
        firstDayOfMonth.setSeconds(0);
        if (props.minDate > firstDayOfMonth) {
          DomHandler.addClass(navPrev, 'p-disabled');
        } else {
          DomHandler.removeClass(navPrev, 'p-disabled');
        }
      }

      // next (check last day of month at 11:59:59)
      if (props.maxDate) {
        var lastDayOfMonth = cloneDate(newViewDate);
        if (lastDayOfMonth.getMonth() === 11) {
          lastDayOfMonth.setMonth(0, 1);
          lastDayOfMonth.setFullYear(lastDayOfMonth.getFullYear() + 1);
        } else {
          lastDayOfMonth.setMonth(lastDayOfMonth.getMonth() + 1, 1);
        }
        lastDayOfMonth.setHours(0);
        lastDayOfMonth.setMinutes(0);
        lastDayOfMonth.setSeconds(0);
        lastDayOfMonth.setSeconds(-1);
        if (props.maxDate < lastDayOfMonth) {
          DomHandler.addClass(navNext, 'p-disabled');
        } else {
          DomHandler.removeClass(navNext, 'p-disabled');
        }
      }
    };
    var onDateCellKeydown = function onDateCellKeydown(event, date, groupIndex) {
      var cellContent = event.currentTarget;
      var cell = cellContent.parentElement;
      var cellIndex = DomHandler.index(cell);
      switch (event.code) {
        case 'ArrowDown':
          {
            cellContent.tabIndex = '-1';
            var nextRow = cell.parentElement.nextElementSibling;
            if (nextRow) {
              var tableRowIndex = DomHandler.index(cell.parentElement);
              var tableRows = Array.from(cell.parentElement.parentElement.children);
              var nextTableRows = tableRows.slice(tableRowIndex + 1);
              var hasNextFocusableDate = nextTableRows.find(function (el) {
                var focusCell = el.children[cellIndex].children[0];
                return !DomHandler.getAttribute(focusCell, 'data-p-disabled');
              });
              if (hasNextFocusableDate) {
                var focusCell = hasNextFocusableDate.children[cellIndex].children[0];
                focusCell.tabIndex = '0';
                focusCell.focus();
              } else {
                navigation.current = {
                  backward: false
                };
                navForward(event);
              }
            } else {
              navigation.current = {
                backward: false
              };
              navForward(event);
            }
            event.preventDefault();
            break;
          }
        case 'ArrowUp':
          {
            cellContent.tabIndex = '-1';
            if (event.altKey) {
              hide(null, reFocusInputField);
            } else {
              var prevRow = cell.parentElement.previousElementSibling;
              if (prevRow) {
                var _tableRowIndex = DomHandler.index(cell.parentElement);
                var _tableRows = Array.from(cell.parentElement.parentElement.children);
                var prevTableRows = _tableRows.slice(0, _tableRowIndex).reverse();
                var _hasNextFocusableDate = prevTableRows.find(function (el) {
                  var focusCell = el.children[cellIndex].children[0];
                  return !DomHandler.getAttribute(focusCell, 'data-p-disabled');
                });
                if (_hasNextFocusableDate) {
                  var _focusCell = _hasNextFocusableDate.children[cellIndex].children[0];
                  _focusCell.tabIndex = '0';
                  _focusCell.focus();
                } else {
                  navigation.current = {
                    backward: true
                  };
                  navBackward(event);
                }
              } else {
                navigation.current = {
                  backward: true
                };
                navBackward(event);
              }
            }
            event.preventDefault();
            break;
          }
        case 'ArrowLeft':
          {
            cellContent.tabIndex = '-1';
            var prevCell = cell.previousElementSibling;
            if (prevCell) {
              var cells = Array.from(cell.parentElement.children);
              var prevCells = cells.slice(0, cellIndex).reverse();
              var _hasNextFocusableDate2 = prevCells.find(function (el) {
                var focusCell = el.children[0];
                return !DomHandler.getAttribute(focusCell, 'data-p-disabled');
              });
              if (_hasNextFocusableDate2) {
                var _focusCell2 = _hasNextFocusableDate2.children[0];
                _focusCell2.tabIndex = '0';
                _focusCell2.focus();
              } else {
                navigateToMonth(true, groupIndex, event);
              }
            } else {
              navigateToMonth(true, groupIndex, event);
            }
            event.preventDefault();
            break;
          }
        case 'ArrowRight':
          {
            cellContent.tabIndex = '-1';
            var nextCell = cell.nextElementSibling;
            if (nextCell) {
              var _cells = Array.from(cell.parentElement.children);
              var nextCells = _cells.slice(cellIndex + 1);
              var _hasNextFocusableDate3 = nextCells.find(function (el) {
                var focusCell = el.children[0];
                return !DomHandler.getAttribute(focusCell, 'data-p-disabled');
              });
              if (_hasNextFocusableDate3) {
                var _focusCell3 = _hasNextFocusableDate3.children[0];
                _focusCell3.tabIndex = '0';
                _focusCell3.focus();
              } else {
                navigateToMonth(false, groupIndex, event);
              }
            } else {
              navigateToMonth(false, groupIndex, event);
            }
            event.preventDefault();
            break;
          }
        case 'Enter':
        case 'NumpadEnter':
        case 'Space':
          {
            onDateSelect(event, date);
            event.preventDefault();
            break;
          }
        case 'Escape':
          {
            hide(null, reFocusInputField);
            event.preventDefault();
            break;
          }
        case 'Tab':
          {
            if (!props.inline) {
              trapFocus(event);
            }
            break;
          }
        case 'Home':
          {
            cellContent.tabIndex = '-1';
            var currentRow = cell.parentElement;
            var _focusCell4 = currentRow.children[0].children[0];
            if (DomHandler.getAttribute(_focusCell4, 'data-p-disabled')) {
              navigateToMonth(groupIndex, true, event);
            } else {
              _focusCell4.tabIndex = '0';
              _focusCell4.focus();
            }
            event.preventDefault();
            break;
          }
        case 'End':
          {
            cellContent.tabIndex = '-1';
            var _currentRow = cell.parentElement;
            var _focusCell5 = _currentRow.children[_currentRow.children.length - 1].children[0];
            if (DomHandler.getAttribute(_focusCell5, 'data-p-disabled')) {
              navigateToMonth(groupIndex, false, event);
            } else {
              _focusCell5.tabIndex = '0';
              _focusCell5.focus();
            }
            event.preventDefault();
            break;
          }
        case 'PageUp':
          {
            cellContent.tabIndex = '-1';
            if (event.shiftKey) {
              navigation.current = {
                backward: true
              };
              navBackward(event);
            } else {
              navigateToMonth(groupIndex, true, event);
            }
            event.preventDefault();
            break;
          }
        case 'PageDown':
          {
            cellContent.tabIndex = '-1';
            if (event.shiftKey) {
              navigation.current = {
                backward: false
              };
              navForward(event);
            } else {
              navigateToMonth(groupIndex, false, event);
            }
            event.preventDefault();
            break;
          }
      }
    };
    var navigateToMonth = function navigateToMonth(prev, groupIndex, event) {
      if (prev) {
        if (props.numberOfMonths === 1 || groupIndex === 0) {
          navigation.current = {
            backward: true
          };
          navBackward(event);
        } else {
          var prevMonthContainer = overlayRef.current.children[0].children[groupIndex - 1];
          var cells = DomHandler.find(prevMonthContainer, 'table td span:not([data-p-disabled="true"])');
          var focusCell = cells[cells.length - 1];
          focusCell.tabIndex = '0';
          focusCell.focus();
        }
      } else if (props.numberOfMonths === 1 || groupIndex === props.numberOfMonths - 1) {
        navigation.current = {
          backward: false
        };
        navForward(event);
      } else {
        var nextMonthContainer = overlayRef.current.children[0].children[groupIndex + 1];
        var _focusCell6 = DomHandler.findSingle(nextMonthContainer, 'table td span:not([data-p-disabled="true"])');
        _focusCell6.tabIndex = '0';
        _focusCell6.focus();
      }
    };
    var onMonthCellKeydown = function onMonthCellKeydown(event, index) {
      var cell = event.currentTarget;
      switch (event.code) {
        //arrows
        case 'ArrowUp':
        case 'ArrowDown':
          {
            cell.tabIndex = '-1';
            var cells = cell.parentElement.children;
            var cellIndex = DomHandler.index(cell);
            var nextCell = cells[event.which === 40 ? cellIndex + 3 : cellIndex - 3];
            if (nextCell) {
              nextCell.tabIndex = '0';
              nextCell.focus();
            }
            event.preventDefault();
            break;
          }
        case 'ArrowLeft':
          {
            cell.tabIndex = '-1';
            var prevCell = cell.previousElementSibling;
            if (prevCell) {
              prevCell.tabIndex = '0';
              prevCell.focus();
            } else {
              navigation.current = {
                backward: true
              };
              navBackward(event);
            }
            event.preventDefault();
            break;
          }
        case 'ArrowRight':
          {
            cell.tabIndex = '-1';
            var _nextCell = cell.nextElementSibling;
            if (_nextCell) {
              _nextCell.tabIndex = '0';
              _nextCell.focus();
            } else {
              navigation.current = {
                backward: false
              };
              navForward(event);
            }
            event.preventDefault();
            break;
          }
        case 'PageUp':
          {
            if (event.shiftKey) {
              return;
            }
            navigation.current = {
              backward: true
            };
            navBackward(event);
            break;
          }
        case 'PageDown':
          {
            if (event.shiftKey) {
              return;
            }
            navigation.current = {
              backward: false
            };
            navForward(event);
            break;
          }
        case 'Enter':
        case 'NumpadEnter':
        case 'Space':
          {
            if (props.view !== 'month') {
              viewChangedWithKeyDown.current = true;
            }
            onMonthSelect(event, index);
            event.preventDefault();
            break;
          }
        case 'Escape':
          {
            hide(null, reFocusInputField);
            event.preventDefault();
            break;
          }
        case 'Tab':
          {
            trapFocus(event);
            break;
          }
      }
    };
    var onYearCellKeydown = function onYearCellKeydown(event, index) {
      var cell = event.currentTarget;
      switch (event.code) {
        //arrows
        case 'ArrowUp':
        case 'ArrowDown':
          {
            cell.tabIndex = '-1';
            var cells = cell.parentElement.children;
            var cellIndex = DomHandler.index(cell);
            var nextCell = cells[event.code === 'ArrowDown' ? cellIndex + 2 : cellIndex - 2];
            if (nextCell) {
              nextCell.tabIndex = '0';
              nextCell.focus();
            }
            event.preventDefault();
            break;
          }
        case 'ArrowLeft':
          {
            cell.tabIndex = '-1';
            var prevCell = cell.previousElementSibling;
            if (prevCell) {
              prevCell.tabIndex = '0';
              prevCell.focus();
            } else {
              navigation.current = {
                backward: true
              };
              navBackward(event);
            }
            event.preventDefault();
            break;
          }
        case 'ArrowRight':
          {
            cell.tabIndex = '-1';
            var _nextCell2 = cell.nextElementSibling;
            if (_nextCell2) {
              _nextCell2.tabIndex = '0';
              _nextCell2.focus();
            } else {
              navigation.current = {
                backward: false
              };
              navForward(event);
            }
            event.preventDefault();
            break;
          }
        case 'PageUp':
          {
            if (event.shiftKey) {
              return;
            }
            navigation.current = {
              backward: true
            };
            navBackward(event);
            break;
          }
        case 'PageDown':
          {
            if (event.shiftKey) {
              return;
            }
            navigation.current = {
              backward: false
            };
            navForward(event);
            break;
          }
        case 'Enter':
        case 'NumpadEnter':
        case 'Space':
          {
            if (props.view !== 'year') {
              viewChangedWithKeyDown.current = true;
            }
            onYearSelect(event, index);
            event.preventDefault();
            break;
          }
        case 'Escape':
          {
            hide(null, reFocusInputField);
            event.preventDefault();
            break;
          }
        case 'Tab':
          {
            trapFocus(event);
            break;
          }
      }
    };
    var onDateSelect = function onDateSelect(event, dateMeta, timeMeta, isUpdateViewDate) {
      if (!event) {
        return;
      }
      if (props.disabled || !dateMeta.selectable) {
        event.preventDefault();
        return;
      }
      DomHandler.find(overlayRef.current, 'table td span:not([data-p-disabled="true"])').forEach(function (cell) {
        return cell.tabIndex = -1;
      });
      event.currentTarget.focus();
      if (isMultipleSelection()) {
        if (isSelected(dateMeta)) {
          var value = props.value.filter(function (date) {
            return !isDateEquals(date, dateMeta);
          });
          updateModel(event, value);
          updateInputfield(value);
        } else if (!props.maxDateCount || !props.value || props.maxDateCount > props.value.length) {
          selectDate(event, dateMeta, timeMeta);
        }
      } else {
        selectDate(event, dateMeta, timeMeta);
      }
      if (!props.inline && isSingleSelection() && (!props.showTime || props.hideOnDateTimeSelect) && !isUpdateViewDate) {
        setTimeout(function () {
          hide('dateselect');
          reFocusInputField();
        }, 100);
        if (touchUIMask.current) {
          disableModality();
        }
      }
      event.preventDefault();
    };
    var selectTime = function selectTime(date, timeMeta) {
      if (props.showTime) {
        var hours;
        var minutes;
        var seconds;
        var milliseconds;
        if (timeMeta) {
          hours = timeMeta.hours;
          minutes = timeMeta.minutes;
          seconds = timeMeta.seconds;
          milliseconds = timeMeta.milliseconds;
        } else {
          var time = getCurrentDateTime();
          var _ref5 = [time.getHours(), time.getMinutes(), time.getSeconds(), time.getMilliseconds()];
          hours = _ref5[0];
          minutes = _ref5[1];
          seconds = _ref5[2];
          milliseconds = _ref5[3];
        }
        date.setHours(hours);
        date.setMinutes(doStepMinute(minutes));
        date.setSeconds(seconds);
        date.setMilliseconds(milliseconds);
      }
    };
    var selectDate = function selectDate(event, dateMeta, timeMeta) {
      var date = new Date(dateMeta.year, dateMeta.month, dateMeta.day);
      selectTime(date, timeMeta);
      if (props.minDate && props.minDate > date) {
        date = props.minDate;
      }
      if (props.maxDate && props.maxDate < date) {
        date = props.maxDate;
      }
      var selectedValues = date;
      if (isSingleSelection()) {
        updateModel(event, date);
      } else if (isMultipleSelection()) {
        selectedValues = props.value ? [].concat(_toConsumableArray(props.value), [date]) : [date];
        updateModel(event, selectedValues);
      } else if (isRangeSelection()) {
        if (props.value && props.value.length) {
          var startDate = props.value[0];
          var endDate = props.value[1];
          if (!endDate) {
            if (date.getTime() >= startDate.getTime()) {
              endDate = date;
            } else {
              endDate = startDate;
              startDate = date;
            }
          } else {
            startDate = date;
            endDate = null;
          }
          selectedValues = [startDate, endDate];
          updateModel(event, selectedValues);
          if (props.hideOnRangeSelection && endDate !== null) {
            setTimeout(function () {
              setOverlayVisibleState(false);
            }, 150);
          }
        } else {
          selectedValues = [date, null];
          updateModel(event, selectedValues);
        }
      }
      if (props.onSelect) {
        props.onSelect({
          originalEvent: event,
          value: date
        });
      }
      updateInputfield(selectedValues);
    };
    var decrementDecade = function decrementDecade() {
      var _currentYear = currentYear - 10;
      setCurrentYear(_currentYear);
      return _currentYear;
    };
    var incrementDecade = function incrementDecade() {
      var _currentYear = currentYear + 10;
      setCurrentYear(_currentYear);
      return _currentYear;
    };
    var switchToMonthView = function switchToMonthView(event) {
      if (event && event.code && (event.code === 'Enter' || event.code === 'NumpadEnter' || event.code === 'Space')) {
        viewChangedWithKeyDown.current = true;
      }
      setCurrentView('month');
      event.preventDefault();
    };
    var switchToYearView = function switchToYearView(event) {
      if (event && event.code && (event.code === 'Enter' || event.code === 'NumpadEnter' || event.code === 'Space')) {
        viewChangedWithKeyDown.current = true;
      }
      setCurrentView('year');
      event.preventDefault();
    };
    var onMonthSelect = function onMonthSelect(event, month) {
      if (props.view === 'month') {
        var year = getViewYear();
        onDateSelect(event, {
          year: year,
          month: month,
          day: 1,
          selectable: true
        });
        event.preventDefault();
      } else {
        setCurrentMonth(month);
        createMonthsMeta(month, currentYear);
        var currentDate = cloneDate(getCurrentDateTime());
        currentDate.setDate(1); // #2948 always set to 1st of month
        currentDate.setMonth(month);
        currentDate.setYear(currentYear);
        setViewDateState(currentDate);
        setCurrentView('date');
        props.onMonthChange && props.onMonthChange({
          month: month + 1,
          year: currentYear
        });
        updateViewDate(event, currentDate);
        onViewDateSelect({
          event: event,
          date: currentDate
        });
      }
    };
    var getViewYear = function getViewYear() {
      return props.yearNavigator ? getViewDate().getFullYear() : currentYear;
    };
    var onYearSelect = function onYearSelect(event, year) {
      if (props.view === 'year') {
        onDateSelect(event, {
          year: year,
          month: 0,
          day: 1,
          selectable: true
        });
      } else {
        setCurrentYear(year);
        setCurrentView('month');
        props.onMonthChange && props.onMonthChange({
          month: currentMonth + 1,
          year: year
        });
      }
    };
    var updateModel = function updateModel(event, value) {
      if (props.onChange) {
        var newValue = cloneDate(value);
        viewStateChanged.current = true;
        onChangeRef.current({
          originalEvent: event,
          value: newValue,
          stopPropagation: function stopPropagation() {
            event === null || event === void 0 || event.stopPropagation();
          },
          preventDefault: function preventDefault() {
            event === null || event === void 0 || event.preventDefault();
          },
          target: {
            name: props.name,
            id: props.id,
            value: newValue
          }
        });
      }
    };
    var show = function show(type) {
      if (props.onVisibleChange) {
        props.onVisibleChange({
          visible: true,
          type: type
        });
      } else {
        setOverlayVisibleState(true);
        overlayEventListener.current = function (e) {
          if (!isOutsideClicked(e) && visible) {
            isOverlayClicked.current = true;
          }
        };
        OverlayService.on('overlay-click', overlayEventListener.current);
      }
    };
    var hide = function hide(type, callback) {
      var _hideCallback = function _hideCallback() {
        viewStateChanged.current = false;
        ignoreFocusFunctionality.current = false;
        isOverlayClicked.current = false;
        callback && callback();
        OverlayService.off('overlay-click', overlayEventListener.current);
        overlayEventListener.current = null;
      };
      props.touchUI && disableModality();
      if (props.onVisibleChange) {
        props.onVisibleChange({
          visible: type !== 'dateselect',
          // false only if selecting a value to close panel
          type: type,
          callback: _hideCallback
        });
      } else {
        setOverlayVisibleState(false);
        _hideCallback();
      }
    };
    var onOverlayEnter = function onOverlayEnter() {
      var styles = props.touchUI ? {
        position: 'fixed',
        top: '50%',
        left: '50%',
        transform: 'translate(-50%, -50%)'
      } : !props.inline ? {
        position: 'absolute',
        top: '0',
        left: '0'
      } : undefined;
      DomHandler.addStyles(overlayRef.current, styles);
      if (props.autoZIndex) {
        var key = props.touchUI ? 'modal' : 'overlay';
        ZIndexUtils.set(key, overlayRef.current, context && context.autoZIndex || PrimeReact.autoZIndex, props.baseZIndex || context && context.zIndex[key] || PrimeReact.zIndex[key]);
      }
      if (!props.touchUI && overlayRef && overlayRef.current && inputRef && inputRef.current && !appendDisabled()) {
        var inputWidth = DomHandler.getOuterWidth(inputRef.current);

        // #5435 must have reasonable width if input is too small
        if (inputWidth < 220) {
          inputWidth = 220;
        }
        if (props.view === 'date') {
          overlayRef.current.style.width = DomHandler.getOuterWidth(overlayRef.current) + 'px';
        } else {
          overlayRef.current.style.width = inputWidth + 'px';
        }

        // #5830 Tailwind does not need a min width it breaks the styling
        if (!isUnstyled()) {
          overlayRef.current.style.minWidth = inputWidth + 'px';
        }
      }
      alignOverlay();
    };
    var onOverlayEntered = function onOverlayEntered() {
      bindOverlayListener();
      props.onShow && props.onShow();
      setFocusedState(false);
    };
    var onOverlayExit = function onOverlayExit() {
      unbindOverlayListener();
    };
    var onOverlayExited = function onOverlayExited() {
      ZIndexUtils.clear(overlayRef.current);
      props.onHide && props.onHide();
    };
    var appendDisabled = function appendDisabled() {
      var appendTo = props.appendTo || context && context.appendTo || PrimeReact.appendTo;
      return appendTo === 'self' || props.inline;
    };
    var alignOverlay = function alignOverlay() {
      if (props.touchUI) {
        enableModality();
      } else if (overlayRef && overlayRef.current && inputRef && inputRef.current) {
        DomHandler.alignOverlay(overlayRef.current, inputRef.current, props.appendTo || context && context.appendTo || PrimeReact.appendTo);
        if (appendDisabled()) {
          DomHandler.relativePosition(overlayRef.current, inputRef.current);
        } else {
          DomHandler.absolutePosition(overlayRef.current, inputRef.current);
        }
      }

      // #6093 Forcibly remove minWidth when in unstyled mode
      if (isUnstyled()) {
        overlayRef.current.style.minWidth = '';
      }
    };
    var enableModality = function enableModality() {
      if (!touchUIMask.current) {
        touchUIMask.current = document.createElement('div');
        touchUIMask.current.style.zIndex = String(ZIndexUtils.get(overlayRef.current) - 1);
        !isUnstyled() && DomHandler.addMultipleClasses(touchUIMask.current, 'p-component-overlay p-datepicker-mask p-datepicker-mask-scrollblocker p-component-overlay-enter');
        touchUIMaskClickListener.current = function () {
          disableModality();
          hide();
        };
        touchUIMask.current.addEventListener('click', touchUIMaskClickListener.current);
        document.body.appendChild(touchUIMask.current);
        DomHandler.blockBodyScroll();
      }
    };
    var disableModality = function disableModality() {
      if (touchUIMask.current) {
        if (isUnstyled) {
          destroyMask();
        } else {
          !isUnstyled() && DomHandler.addClass(touchUIMask.current, 'p-component-overlay-leave');
          if (DomHandler.hasCSSAnimation(touchUIMask.current) > 0) {
            touchUIMask.current.addEventListener('animationend', function () {
              destroyMask();
            });
          } else {
            destroyMask();
          }
        }
      }
    };
    var destroyMask = function destroyMask() {
      if (touchUIMask.current) {
        touchUIMask.current.removeEventListener('click', touchUIMaskClickListener.current);
        touchUIMaskClickListener.current = null;
        document.body.removeChild(touchUIMask.current);
        touchUIMask.current = null;
      }
      var bodyChildren = document.body.children;
      var hasBlockerMasks;
      for (var i = 0; i < bodyChildren.length; i++) {
        var bodyChild = bodyChildren[i];
        if (DomHandler.hasClass(bodyChild, 'p-datepicker-mask-scrollblocker')) {
          hasBlockerMasks = true;
          break;
        }
      }
      if (!hasBlockerMasks) {
        DomHandler.unblockBodyScroll();
      }
    };
    var isOutsideClicked = function isOutsideClicked(event) {
      return elementRef.current && !(elementRef.current.isSameNode(event.target) || isNavIconClicked(event.target) || elementRef.current.contains(event.target) || overlayRef.current && overlayRef.current.contains(event.target));
    };
    var isNavIconClicked = function isNavIconClicked(target) {
      return previousButton.current && (previousButton.current.isSameNode(target) || previousButton.current.contains(target)) || nextButton.current && (nextButton.current.isSameNode(target) || nextButton.current.contains(target));
    };
    var getFirstDayOfMonthIndex = function getFirstDayOfMonthIndex(month, year) {
      var day = new Date();
      day.setDate(1);
      day.setMonth(month);
      day.setFullYear(year);
      var dayIndex = day.getDay() + getSundayIndex();
      return dayIndex >= 7 ? dayIndex - 7 : dayIndex;
    };
    var getDaysCountInMonth = function getDaysCountInMonth(month, year) {
      return 32 - daylightSavingAdjust(new Date(year, month, 32)).getDate();
    };
    var getDaysCountInPrevMonth = function getDaysCountInPrevMonth(month, year) {
      var prev = getPreviousMonthAndYear(month, year);
      return getDaysCountInMonth(prev.month, prev.year);
    };
    var daylightSavingAdjust = function daylightSavingAdjust(date) {
      if (!date) {
        return null;
      }
      date.setHours(date.getHours() > 12 ? date.getHours() + 2 : 0);
      return date;
    };
    var getPreviousMonthAndYear = function getPreviousMonthAndYear(month, year) {
      var m;
      var y;
      if (month === 0) {
        m = 11;
        y = year - 1;
      } else {
        m = month - 1;
        y = year;
      }
      return {
        month: m,
        year: y
      };
    };
    var getNextMonthAndYear = function getNextMonthAndYear(month, year) {
      var m;
      var y;
      if (month === 11) {
        m = 0;
        y = year + 1;
      } else {
        m = month + 1;
        y = year;
      }
      return {
        month: m,
        year: y
      };
    };
    var getSundayIndex = function getSundayIndex() {
      var firstDayOfWeek = localeOption('firstDayOfWeek', props.locale);
      return firstDayOfWeek > 0 ? 7 - firstDayOfWeek : 0;
    };
    var createWeekDaysMeta = function createWeekDaysMeta() {
      var weekDays = [];
      var _localeOptions = localeOptions(props.locale),
        dayIndex = _localeOptions.firstDayOfWeek,
        dayNamesMin = _localeOptions.dayNamesMin;
      for (var i = 0; i < 7; i++) {
        weekDays.push(dayNamesMin[dayIndex]);
        dayIndex = dayIndex === 6 ? 0 : ++dayIndex;
      }
      return weekDays;
    };
    var createMonthsMeta = function createMonthsMeta(month, year) {
      var months = [];
      for (var i = 0; i < props.numberOfMonths; i++) {
        var m = month + i;
        var y = year;
        if (m > 11) {
          m = m % 11 - 1;
          y = year + 1;
        }
        months.push(createMonthMeta(m, y));
      }
      return months;
    };
    var createMonthMeta = function createMonthMeta(month, year) {
      var dates = [];
      var firstDay = getFirstDayOfMonthIndex(month, year);
      var daysLength = getDaysCountInMonth(month, year);
      var prevMonthDaysLength = getDaysCountInPrevMonth(month, year);
      var dayNo = 1;
      var today = new Date();
      var weekNumbers = [];
      var monthRows = Math.ceil((daysLength + firstDay) / 7);
      for (var i = 0; i < monthRows; i++) {
        var week = [];
        if (i === 0) {
          for (var j = prevMonthDaysLength - firstDay + 1; j <= prevMonthDaysLength; j++) {
            var prev = getPreviousMonthAndYear(month, year);
            week.push({
              day: j,
              month: prev.month,
              year: prev.year,
              otherMonth: true,
              today: isToday(today, j, prev.month, prev.year),
              selectable: isSelectable(j, prev.month, prev.year, true)
            });
          }
          var remainingDaysLength = 7 - week.length;
          for (var _j = 0; _j < remainingDaysLength; _j++) {
            week.push({
              day: dayNo,
              month: month,
              year: year,
              today: isToday(today, dayNo, month, year),
              selectable: isSelectable(dayNo, month, year, false)
            });
            dayNo++;
          }
        } else {
          for (var _j2 = 0; _j2 < 7; _j2++) {
            if (dayNo > daysLength) {
              var next = getNextMonthAndYear(month, year);
              week.push({
                day: dayNo - daysLength,
                month: next.month,
                year: next.year,
                otherMonth: true,
                today: isToday(today, dayNo - daysLength, next.month, next.year),
                selectable: isSelectable(dayNo - daysLength, next.month, next.year, true)
              });
            } else {
              week.push({
                day: dayNo,
                month: month,
                year: year,
                today: isToday(today, dayNo, month, year),
                selectable: isSelectable(dayNo, month, year, false)
              });
            }
            dayNo++;
          }
        }
        if (props.showWeek) {
          weekNumbers.push(getWeekNumber(new Date(week[0].year, week[0].month, week[0].day)));
        }
        dates.push(week);
      }
      return {
        month: month,
        year: year,
        dates: dates,
        weekNumbers: weekNumbers
      };
    };
    var getWeekNumber = function getWeekNumber(date) {
      var checkDate = cloneDate(date);
      checkDate.setDate(checkDate.getDate() + 4 - (checkDate.getDay() || 7));
      var time = checkDate.getTime();
      checkDate.setMonth(0);
      checkDate.setDate(1);
      return Math.floor(Math.round((time - checkDate.getTime()) / 86400000) / 7) + 1;
    };
    var isSelectable = function isSelectable(day, month, year, otherMonth) {
      var validMin = true;
      var validMax = true;
      var validDate = true;
      var validDay = true;
      var validMonth = true;
      if (props.minDate) {
        if (props.minDate.getFullYear() > year) {
          validMin = false;
        } else if (props.minDate.getFullYear() === year) {
          if (month > -1 && props.minDate.getMonth() > month) {
            validMin = false;
          } else if (month > -1 && props.minDate.getMonth() === month) {
            if (day > 0 && props.minDate.getDate() > day) {
              validMin = false;
            }
          }
        }
      }
      if (props.maxDate) {
        if (props.maxDate.getFullYear() < year) {
          validMax = false;
        } else if (props.maxDate.getFullYear() === year) {
          if (month > -1 && props.maxDate.getMonth() < month) {
            validMax = false;
          } else if (month > -1 && props.maxDate.getMonth() === month) {
            if (day > 0 && props.maxDate.getDate() < day) {
              validMax = false;
            }
          }
        }
      }
      if (props.disabledDates || props.enabledDates || props.disabledDays) {
        validDay = !isDayDisabled(day, month, year);
      }
      if (props.selectOtherMonths === false && otherMonth) {
        validMonth = false;
      }
      return validMin && validMax && validDate && validDay && validMonth;
    };
    var isSelectableTime = function isSelectableTime(value) {
      var validMin = true;
      var validMax = true;
      if (props.minDate && props.minDate.toDateString() === value.toDateString()) {
        if (props.minDate.getHours() > value.getHours()) {
          validMin = false;
        } else if (props.minDate.getHours() === value.getHours()) {
          if (props.minDate.getMinutes() > value.getMinutes()) {
            validMin = false;
          } else if (props.minDate.getMinutes() === value.getMinutes()) {
            if (props.minDate.getSeconds() > value.getSeconds()) {
              validMin = false;
            } else if (props.minDate.getSeconds() === value.getSeconds()) {
              if (props.minDate.getMilliseconds() > value.getMilliseconds()) {
                validMin = false;
              }
            }
          }
        }
      }
      if (props.maxDate && props.maxDate.toDateString() === value.toDateString()) {
        if (props.maxDate.getHours() < value.getHours()) {
          validMax = false;
        } else if (props.maxDate.getHours() === value.getHours()) {
          if (props.maxDate.getMinutes() < value.getMinutes()) {
            validMax = false;
          } else if (props.maxDate.getMinutes() === value.getMinutes()) {
            if (props.maxDate.getSeconds() < value.getSeconds()) {
              validMax = false;
            } else if (props.maxDate.getSeconds() === value.getSeconds()) {
              if (props.maxDate.getMilliseconds() < value.getMilliseconds()) {
                validMax = false;
              }
            }
          }
        }
      }
      return validMin && validMax;
    };
    var isSelected = function isSelected(dateMeta) {
      if (props.value) {
        if (isSingleSelection()) {
          return isDateEquals(props.value, dateMeta);
        } else if (isMultipleSelection()) {
          var selected = false;
          var _iterator = _createForOfIteratorHelper$e(props.value),
            _step;
          try {
            for (_iterator.s(); !(_step = _iterator.n()).done;) {
              var date = _step.value;
              selected = isDateEquals(date, dateMeta);
              if (selected) {
                break;
              }
            }
          } catch (err) {
            _iterator.e(err);
          } finally {
            _iterator.f();
          }
          return selected;
        } else if (isRangeSelection()) {
          if (props.value[1]) {
            return isDateEquals(props.value[0], dateMeta) || isDateEquals(props.value[1], dateMeta) || isDateBetween(props.value[0], props.value[1], dateMeta);
          }
          return isDateEquals(props.value[0], dateMeta);
        }
      } else {
        return false;
      }
    };
    var isComparable = function isComparable() {
      return props.value != null && typeof props.value !== 'string';
    };
    var isMonthSelected = function isMonthSelected(month) {
      if (!isComparable()) return false;
      if (isMultipleSelection()) {
        return props.value.some(function (v) {
          return v.getMonth() === month && v.getFullYear() === currentYear;
        });
      } else if (isRangeSelection()) {
        var _props$value = _slicedToArray(props.value, 2),
          start = _props$value[0],
          end = _props$value[1];
        var startYear = start ? start.getFullYear() : null;
        var endYear = end ? end.getFullYear() : null;
        var startMonth = start ? start.getMonth() : null;
        var endMonth = end ? end.getMonth() : null;
        if (!end) {
          return startYear === currentYear && startMonth === month;
        } else {
          var currentDate = new Date(currentYear, month, 1);
          var startDate = new Date(startYear, startMonth, 1);
          var endDate = new Date(endYear, endMonth, 1);
          return currentDate >= startDate && currentDate <= endDate;
        }
      } else {
        return props.value.getMonth() === month && props.value.getFullYear() === currentYear;
      }
    };
    var isYearSelected = function isYearSelected(year) {
      if (!isComparable()) return false;
      if (isMultipleSelection()) {
        return props.value.some(function (v) {
          return v.getFullYear() === year;
        });
      } else if (isRangeSelection()) {
        var start = props.value[0] ? props.value[0].getFullYear() : null;
        var end = props.value[1] ? props.value[1].getFullYear() : null;
        return start === year || end === year || start < year && end > year;
      } else {
        return props.value.getFullYear() === year;
      }
    };
    var switchViewButtonDisabled = function switchViewButtonDisabled() {
      return props.numberOfMonths > 1 || props.disabled;
    };
    var isDateEquals = function isDateEquals(value, dateMeta) {
      if (value && value instanceof Date) {
        return value.getDate() === dateMeta.day && value.getMonth() === dateMeta.month && value.getFullYear() === dateMeta.year;
      }
      return false;
    };
    var isDateBetween = function isDateBetween(start, end, dateMeta) {
      var between = false;
      if (start && end) {
        var date = new Date(dateMeta.year, dateMeta.month, dateMeta.day);
        return start.getTime() <= date.getTime() && end.getTime() >= date.getTime();
      }
      return between;
    };
    var isSingleSelection = function isSingleSelection() {
      return props.selectionMode === 'single';
    };
    var isRangeSelection = function isRangeSelection() {
      return props.selectionMode === 'range';
    };
    var isMultipleSelection = function isMultipleSelection() {
      return props.selectionMode === 'multiple';
    };
    var isToday = function isToday(today, day, month, year) {
      return today.getDate() === day && today.getMonth() === month && today.getFullYear() === year;
    };
    var isDayDisabled = function isDayDisabled(day, month, year) {
      var isDisabled = false;

      // first check for disabled dates
      if (props.disabledDates) {
        if (props.disabledDates.some(function (d) {
          return d.getFullYear() === year && d.getMonth() === month && d.getDate() === day;
        })) {
          isDisabled = true;
        }
      }

      // next if not disabled then check for disabled days
      if (!isDisabled && props.disabledDays && currentView === 'date') {
        var weekday = new Date(year, month, day);
        var weekdayNumber = weekday.getDay();
        if (props.disabledDays.indexOf(weekdayNumber) !== -1) {
          isDisabled = true;
        }
      }

      // last check for enabled dates to force dates enabled
      if (props.enabledDates) {
        var isEnabled = props.enabledDates.some(function (d) {
          return d.getFullYear() === year && d.getMonth() === month && d.getDate() === day;
        });
        if (isEnabled) {
          isDisabled = false;
        } else if (!props.disabledDays && !props.disabledDates) {
          // disable other dates when only enabledDates are present
          isDisabled = true;
        }
      }
      return isDisabled;
    };
    var isMonthYearDisabled = function isMonthYearDisabled(month, year) {
      var daysCountInAllMonth = month === -1 ? new Array(12).fill(0).map(function (_, i) {
        return getDaysCountInMonth(i, year);
      }) : [getDaysCountInMonth(month, year)];
      for (var i = 0; i < daysCountInAllMonth.length; i++) {
        var monthDays = daysCountInAllMonth[i];
        var _month = month === -1 ? i : month;
        for (var day = 1; day <= monthDays; day++) {
          var isDateSelectable = isSelectable(day, _month, year);
          if (isDateSelectable) {
            return false;
          }
        }
      }
      return true;
    };
    var updateInputfield = function updateInputfield(value) {
      if (!inputRef.current) {
        return;
      }
      var formattedValue = '';
      if (value) {
        try {
          if (isSingleSelection()) {
            formattedValue = isValidDate(value) ? formatDateTime(value) : props.keepInvalid ? value : '';
          } else if (isMultipleSelection()) {
            for (var i = 0; i < value.length; i++) {
              var selectedValue = value[i];
              var dateAsString = isValidDate(selectedValue) ? formatDateTime(selectedValue) : '';
              formattedValue = formattedValue + dateAsString;
              if (i !== value.length - 1) {
                formattedValue = formattedValue + ', ';
              }
            }
          } else if (isRangeSelection()) {
            if (value && value.length) {
              var startDate = value[0];
              var endDate = value[1];
              formattedValue = isValidDate(startDate) ? formatDateTime(startDate) : '';
              if (endDate) {
                formattedValue = formattedValue + (isValidDate(endDate) ? ' - ' + formatDateTime(endDate) : '');
              }
            }
          }
        } catch (err) {
          formattedValue = value;
        }
      }
      inputRef.current.value = formattedValue;
    };
    var formatDateTime = function formatDateTime(date) {
      if (props.formatDateTime) {
        return props.formatDateTime(date);
      }
      var formattedValue = null;
      if (date) {
        if (props.timeOnly) {
          formattedValue = formatTime(date);
        } else {
          formattedValue = formatDate(date, getDateFormat());
          if (props.showTime) {
            formattedValue = formattedValue + (' ' + formatTime(date));
          }
        }
      }
      return formattedValue;
    };
    var formatDate = function formatDate(date, format) {
      if (!date) {
        return '';
      }
      var iFormat;
      var lookAhead = function lookAhead(match) {
        var matches = iFormat + 1 < format.length && format.charAt(iFormat + 1) === match;
        if (matches) {
          iFormat++;
        }
        return matches;
      };
      var formatNumber = function formatNumber(match, value, len) {
        var num = '' + value;
        if (lookAhead(match)) {
          while (num.length < len) {
            num = '0' + num;
          }
        }
        return num;
      };
      var formatName = function formatName(match, value, shortNames, longNames) {
        return lookAhead(match) ? longNames[value] : shortNames[value];
      };
      var output = '';
      var literal = false;
      var _localeOptions2 = localeOptions(props.locale),
        dayNamesShort = _localeOptions2.dayNamesShort,
        dayNames = _localeOptions2.dayNames,
        monthNamesShort = _localeOptions2.monthNamesShort,
        monthNames = _localeOptions2.monthNames;
      if (date) {
        for (iFormat = 0; iFormat < format.length; iFormat++) {
          if (literal) {
            if (format.charAt(iFormat) === "'" && !lookAhead("'")) {
              literal = false;
            } else {
              output = output + format.charAt(iFormat);
            }
          } else {
            switch (format.charAt(iFormat)) {
              case 'd':
                output = output + formatNumber('d', date.getDate(), 2);
                break;
              case 'D':
                output = output + formatName('D', date.getDay(), dayNamesShort, dayNames);
                break;
              case 'o':
                output = output + formatNumber('o', Math.round((new Date(date.getFullYear(), date.getMonth(), date.getDate()).getTime() - new Date(date.getFullYear(), 0, 0).getTime()) / 86400000), 3);
                break;
              case 'm':
                output = output + formatNumber('m', date.getMonth() + 1, 2);
                break;
              case 'M':
                output = output + formatName('M', date.getMonth(), monthNamesShort, monthNames);
                break;
              case 'y':
                output = output + (lookAhead('y') ? date.getFullYear() : (date.getFullYear() % 100 < 10 ? '0' : '') + date.getFullYear() % 100);
                break;
              case '@':
                output = output + date.getTime();
                break;
              case '!':
                output = output + (date.getTime() * 10000 + ticksTo1970);
                break;
              case "'":
                if (lookAhead("'")) {
                  output = output + "'";
                } else {
                  literal = true;
                }
                break;
              default:
                output = output + format.charAt(iFormat);
            }
          }
        }
      }
      return output;
    };
    var formatTime = function formatTime(date) {
      if (!date) {
        return '';
      }
      var output = '';
      var hours = date.getHours();
      var minutes = date.getMinutes();
      var seconds = date.getSeconds();
      var milliseconds = date.getMilliseconds();
      if (props.hourFormat === '12' && hours > 11 && hours !== 12) {
        hours = hours - 12;
      }
      if (props.hourFormat === '12') {
        output = output + (hours === 0 ? 12 : hours < 10 ? '0' + hours : hours);
      } else {
        output = output + (hours < 10 ? '0' + hours : hours);
      }
      output = output + ':';
      output = output + (minutes < 10 ? '0' + minutes : minutes);
      if (props.showSeconds) {
        output = output + ':';
        output = output + (seconds < 10 ? '0' + seconds : seconds);
      }
      if (props.showMillisec) {
        output = output + '.';
        output = output + (milliseconds < 100 ? (milliseconds < 10 ? '00' : '0') + milliseconds : milliseconds);
      }
      if (props.hourFormat === '12') {
        output = output + (date.getHours() > 11 ? ' PM' : ' AM');
      }
      return output;
    };
    var parseValueFromString = function parseValueFromString(text) {
      if (!text || text.trim().length === 0) {
        return null;
      }
      var value;
      if (isSingleSelection()) {
        value = parseDateTime(text);
      } else if (isMultipleSelection()) {
        var tokens = text.split(',');
        value = [];
        var _iterator2 = _createForOfIteratorHelper$e(tokens),
          _step2;
        try {
          for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
            var token = _step2.value;
            value.push(parseDateTime(token.trim()));
          }
        } catch (err) {
          _iterator2.e(err);
        } finally {
          _iterator2.f();
        }
      } else if (isRangeSelection()) {
        var _tokens = text.split(' - ');
        value = [];
        for (var i = 0; i < _tokens.length; i++) {
          value[i] = parseDateTime(_tokens[i].trim());
        }
      }
      return value;
    };
    var parseDateTime = function parseDateTime(text) {
      if (props.parseDateTime) {
        return props.parseDateTime(text);
      }
      var date;
      if (props.timeOnly) {
        date = new Date();
        var match = text.match(/(\d{1,2}:\d{2}(?::\d{2})?(?:\.\d{1,3})?)\s?(AM|PM)?/i);
        if (match) {
          populateTime(date, match[1], match[2]);
        } else {
          return null;
        }
      } else if (props.showTime) {
        var time12 = /(\d{1,2}:\d{2}(?::\d{2})?(?:\.\d{1,3})?)\s?(AM|PM)/i;
        var time24 = /(\d{1,2}:\d{2}(?::\d{2})?(?:\.\d{1,3})?)$/;
        var _match, datePart, timePart, ampm;
        if (props.hourFormat === '12' && (_match = text.match(time12))) {
          timePart = _match[1];
          ampm = _match[2];
          datePart = text.replace(time12, '').trim();
        } else if (props.hourFormat === '24' && (_match = text.match(time24))) {
          timePart = _match[1];
          datePart = text.replace(time24, '').trim();
        }
        if (datePart && timePart) {
          date = parseDate(datePart, getDateFormat());
          populateTime(date, timePart, ampm);
        } else {
          date = parseDate(text, getDateFormat());
        }
      } else {
        date = parseDate(text, getDateFormat());
      }
      return date;
    };
    var populateTime = function populateTime(value, timeString, ampm) {
      if (props.hourFormat === '12' && ampm !== 'PM' && ampm !== 'AM') {
        throw new Error('Invalid Time');
      }
      var time = parseTime(timeString, ampm);
      value.setHours(time.hour);
      value.setMinutes(time.minute);
      value.setSeconds(time.second);
      value.setMilliseconds(time.millisecond);
    };
    var parseTime = function parseTime(value, ampm) {
      value = props.showMillisec ? value.replace('.', ':') : value;
      var tokens = value.split(':');
      var validTokenLength = props.showSeconds ? 3 : 2;
      validTokenLength = props.showMillisec ? validTokenLength + 1 : validTokenLength;
      if (tokens.length !== validTokenLength || tokens[0].length !== 2 || tokens[1].length !== 2 || props.showSeconds && tokens[2].length !== 2 || props.showMillisec && tokens[3].length !== 3) {
        throw new Error('Invalid time');
      }
      var h = parseInt(tokens[0], 10);
      var m = parseInt(tokens[1], 10);
      var s = props.showSeconds ? parseInt(tokens[2], 10) : null;
      var ms = props.showMillisec ? parseInt(tokens[3], 10) : null;
      if (isNaN(h) || isNaN(m) || h > 23 || m > 59 || props.hourFormat === '12' && h > 12 || props.showSeconds && (isNaN(s) || s > 59) || props.showMillisec && (isNaN(s) || s > 1000)) {
        throw new Error('Invalid time');
      } else {
        if (props.hourFormat === '12') {
          if (h !== 12 && ampm === 'PM') {
            h = h + 12;
          }
          if (h === 12 && ampm === 'AM') {
            h = h - 12;
          }
        }
        return {
          hour: h,
          minute: m,
          second: s,
          millisecond: ms
        };
      }
    };

    // Ported from jquery-ui datepicker parseDate
    var parseDate = function parseDate(value, format) {
      if (format == null || value == null) {
        throw new Error('Invalid arguments');
      }
      value = _typeof(value) === 'object' ? value.toString() : value + '';
      if (value === '') {
        return null;
      }
      var iFormat;
      var dim;
      var extra;
      var iValue = 0;
      var shortYearCutoff = typeof props.shortYearCutoff !== 'string' ? props.shortYearCutoff : new Date().getFullYear() % 100 + parseInt(props.shortYearCutoff, 10);
      var year = -1;
      var month = -1;
      var day = -1;
      var doy = -1;
      var literal = false;
      var date;
      var lookAhead = function lookAhead(match) {
        var matches = iFormat + 1 < format.length && format.charAt(iFormat + 1) === match;
        if (matches) {
          iFormat++;
        }
        return matches;
      };
      var getNumber = function getNumber(match) {
        var isDoubled = lookAhead(match);
        var size = match === '@' ? 14 : match === '!' ? 20 : match === 'y' && isDoubled ? 4 : match === 'o' ? 3 : 2;
        var minSize = match === 'y' ? size : 1;
        var digits = new RegExp('^\\d{' + minSize + ',' + size + '}');
        var num = value.substring(iValue).match(digits);
        if (!num) {
          throw new Error('Missing number at position ' + iValue);
        }
        iValue = iValue + num[0].length;
        return parseInt(num[0], 10);
      };
      var getName = function getName(match, shortNames, longNames) {
        var index = -1;
        var arr = lookAhead(match) ? longNames : shortNames;
        var names = [];
        for (var i = 0; i < arr.length; i++) {
          names.push([i, arr[i]]);
        }
        names.sort(function (a, b) {
          return -(a[1].length - b[1].length);
        });
        for (var _i = 0; _i < names.length; _i++) {
          var name = names[_i][1];
          if (value.substr(iValue, name.length).toLowerCase() === name.toLowerCase()) {
            index = names[_i][0];
            iValue = iValue + name.length;
            break;
          }
        }
        if (index !== -1) {
          return index + 1;
        }
        throw new Error('Unknown name at position ' + iValue);
      };
      var checkLiteral = function checkLiteral() {
        if (value.charAt(iValue) !== format.charAt(iFormat)) {
          throw new Error('Unexpected literal at position ' + iValue);
        }
        iValue++;
      };
      if (props.view === 'month') {
        day = 1;
      }
      if (props.view === 'year') {
        day = 1;
        month = 1;
      }
      var _localeOptions3 = localeOptions(props.locale),
        dayNamesShort = _localeOptions3.dayNamesShort,
        dayNames = _localeOptions3.dayNames,
        monthNamesShort = _localeOptions3.monthNamesShort,
        monthNames = _localeOptions3.monthNames;
      for (iFormat = 0; iFormat < format.length; iFormat++) {
        if (literal) {
          if (format.charAt(iFormat) === "'" && !lookAhead("'")) {
            literal = false;
          } else {
            checkLiteral();
          }
        } else {
          switch (format.charAt(iFormat)) {
            case 'd':
              day = getNumber('d');
              break;
            case 'D':
              getName('D', dayNamesShort, dayNames);
              break;
            case 'o':
              doy = getNumber('o');
              break;
            case 'm':
              month = getNumber('m');
              break;
            case 'M':
              month = getName('M', monthNamesShort, monthNames);
              break;
            case 'y':
              year = getNumber('y');
              break;
            case '@':
              date = new Date(getNumber('@'));
              year = date.getFullYear();
              month = date.getMonth() + 1;
              day = date.getDate();
              break;
            case '!':
              date = new Date((getNumber('!') - ticksTo1970) / 10000);
              year = date.getFullYear();
              month = date.getMonth() + 1;
              day = date.getDate();
              break;
            case "'":
              if (lookAhead("'")) {
                checkLiteral();
              } else {
                literal = true;
              }
              break;
            default:
              checkLiteral();
          }
        }
      }
      if (iValue < value.length) {
        extra = value.substr(iValue);
        if (!/^\s+/.test(extra)) {
          throw new Error('Extra/unparsed characters found in date: ' + extra);
        }
      }
      if (year === -1) {
        year = new Date().getFullYear();
      } else if (year < 100) {
        year = year + (new Date().getFullYear() - new Date().getFullYear() % 100 + (year <= shortYearCutoff ? 0 : -100));
      }
      if (doy > -1) {
        month = 1;
        day = doy;
        do {
          dim = getDaysCountInMonth(year, month - 1);
          if (day <= dim) {
            break;
          }
          month++;
          day = day - dim;
        } while (true);
      }
      date = daylightSavingAdjust(new Date(year, month - 1, day));
      if (date.getFullYear() !== year || date.getMonth() + 1 !== month || date.getDate() !== day) {
        throw new Error('Invalid date'); // E.g. 31/02/00
      }
      return date;
    };
    var isInMinYear = function isInMinYear(viewDate) {
      return props.minDate && props.minDate.getFullYear() === viewDate.getFullYear();
    };
    var isInMaxYear = function isInMaxYear(viewDate) {
      return props.maxDate && props.maxDate.getFullYear() === viewDate.getFullYear();
    };
    React__namespace.useEffect(function () {
      ObjectUtils.combinedRefs(inputRef, props.inputRef);
    }, [inputRef, props.inputRef]);
    useMountEffect(function () {
      var viewDate = getViewDate(props.viewDate);
      validateDate(viewDate);
      setViewDateState(viewDate);
      setCurrentMonth(viewDate.getMonth());
      setCurrentYear(viewDate.getFullYear());
      setCurrentView(props.view);
      if (!idState) {
        var uniqueId = UniqueComponentId();
        !idState && setIdState(uniqueId);
      }
      if (props.inline) {
        overlayRef && overlayRef.current.setAttribute(attributeSelector, '');
        if (!props.disabled) {
          initFocusableCell();
          if (props.numberOfMonths === 1) {
            overlayRef.current.style.width = DomHandler.getOuterWidth(overlayRef.current) + 'px';
          }
        }
      }
      if (props.value) {
        updateInputfield(props.value);
        setValue(props.value);
      }
      if (props.autoFocus) {
        // delay showing until rendered so `alignPanel()` method aligns the popup in the right location
        setTimeout(function () {
          return DomHandler.focus(inputRef.current, props.autoFocus);
        }, 200);
      }
    });
    React__namespace.useEffect(function () {
      // see https://github.com/primefaces/primereact/issues/4030
      onChangeRef.current = props.onChange;
    }, [props.onChange]);
    React__namespace.useEffect(function () {
      var unbindMaskEvents = null;
      if (props.mask) {
        unbindMaskEvents = mask(inputRef.current, {
          mask: props.mask,
          slotChar: props.maskSlotChar,
          readOnly: props.readOnlyInput || props.disabled,
          onChange: function onChange(e) {
            updateValueOnInput(e.originalEvent, e.value, function () {
              return false;
            });
          },
          onBlur: function onBlur(e) {
            updateValueOnInput(e, e.target.value);
          }
        }).unbindEvents;
      }
      return function () {
        props.mask && unbindMaskEvents && unbindMaskEvents();
      };
      // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [props.disabled, props.mask, props.readOnlyInput]);
    useUpdateEffect(function () {
      if (viewChangedWithKeyDown.current) {
        setCurrentView(props.view);
      }
      viewChangedWithKeyDown.current = false;
    }, [props.view]);
    useUpdateEffect(function () {
      if (visible && !props.inline) {
        focusToFirstCell();
      }
    }, [visible, currentView, props.inline]);
    useUpdateEffect(function () {
      if (!props.onViewDateChange && !viewStateChanged.current) {
        setValue(props.value);
      }
      if (props.viewDate) {
        var date = getViewDate(props.viewDate);
        updateViewDate(null, date);
        onViewDateSelect({
          event: null,
          date: date
        });
      }
    }, [props.onViewDateChange, props.value, props.viewDate]);
    useUpdateEffect(function () {
      if (overlayVisibleState || props.visible) {
        // Github #5529
        setTimeout(function () {
          alignOverlay();
        });
      }
    }, [currentView, overlayVisibleState, props.visible]);
    useUpdateEffect(function () {
      var newDate = props.value;
      if (previousValue !== newDate) {
        var isInputFocused = document.activeElement === inputRef.current;

        // Do not update value in input if user types something in it:
        if (!isInputFocused) {
          updateInputfield(newDate);
        }

        // #3516 view date not updated when value set programatically
        if (!newDate) return;
        var viewDate = newDate;
        if (isMultipleSelection()) {
          if (newDate.length) {
            viewDate = newDate[newDate.length - 1];
          }
        } else if (isRangeSelection()) {
          if (newDate.length) {
            var startDate = newDate[0];
            var endDate = newDate[1];
            viewDate = endDate || startDate;
          }
        }
        if (viewDate instanceof Date) {
          validateDate(viewDate);
          setViewDateState(viewDate);
          setCurrentMonth(viewDate.getMonth());
          setCurrentYear(viewDate.getFullYear());
        }
      }
    }, [props.value, visible]);
    useUpdateEffect(function () {
      updateInputfield(props.value);
    }, [props.dateFormat, props.hourFormat, props.timeOnly, props.showSeconds, props.showMillisec, props.showTime, props.locale]);
    useUpdateEffect(function () {
      if (overlayRef.current) {
        setNavigationState(viewDateState);
        updateFocus();
      }
    });
    useUnmountEffect(function () {
      if (touchUIMask.current) {
        disableModality();
        touchUIMask.current = null;
      }
      ZIndexUtils.clear(overlayRef.current);
    });
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        show: show,
        hide: hide,
        getCurrentDateTime: getCurrentDateTime,
        getViewDate: getViewDate,
        updateViewDate: updateViewDate,
        focus: function focus() {
          return DomHandler.focus(inputRef.current);
        },
        getElement: function getElement() {
          return elementRef.current;
        },
        getOverlay: function getOverlay() {
          return overlayRef.current;
        },
        getInput: function getInput() {
          return inputRef.current;
        }
      };
    });
    var setValue = function setValue(propValue) {
      if (Array.isArray(propValue)) {
        propValue = propValue[0];
      }
      var prevPropValue = previousValue;
      if (Array.isArray(prevPropValue)) {
        prevPropValue = prevPropValue[0];
      }
      var viewDate = props.viewDate && isValidDate(props.viewDate) ? props.viewDate : propValue && isValidDate(propValue) ? propValue : new Date();
      if (isClearClicked.current && props.showTime) {
        viewDate.setHours(0, 0, 0);
        isClearClicked.current = false;
      }
      if (!prevPropValue && propValue || propValue && propValue instanceof Date && prevPropValue instanceof Date && propValue.getTime() !== prevPropValue.getTime()) {
        validateDate(viewDate);
      }
      setViewDateState(viewDate);
      viewStateChanged.current = true;
    };
    var createBackwardNavigator = function createBackwardNavigator(isVisible) {
      var navigatorProps = isVisible ? {
        onClick: onPrevButtonClick,
        onKeyDown: function onKeyDown(e) {
          return onContainerButtonKeydown(e);
        }
      } : {
        style: {
          visibility: 'hidden'
        }
      };
      var previousIconProps = mergeProps({
        className: cx('previousIcon')
      }, ptm('previousIcon'));
      var icon = props.prevIcon || /*#__PURE__*/React__namespace.createElement(ChevronLeftIcon, previousIconProps);
      var backwardNavigatorIcon = IconUtils.getJSXIcon(icon, _objectSpread$1K({}, previousIconProps), {
        props: props
      });
      var _localeOptions4 = localeOptions(props.locale),
        prevDecade = _localeOptions4.prevDecade,
        prevYear = _localeOptions4.prevYear,
        prevMonth = _localeOptions4.prevMonth;
      var previousButtonLabel = currentView === 'year' ? prevDecade : currentView === 'month' ? prevYear : prevMonth;
      var previousButtonProps = mergeProps(_objectSpread$1K({
        type: 'button',
        className: cx('previousButton'),
        'aria-label': previousButtonLabel
      }, navigatorProps), ptm('previousButton'));
      return /*#__PURE__*/React__namespace.createElement("button", _extends({
        ref: previousButton
      }, previousButtonProps), backwardNavigatorIcon, /*#__PURE__*/React__namespace.createElement(Ripple, null));
    };
    var createForwardNavigator = function createForwardNavigator(isVisible) {
      var navigatorProps = isVisible ? {
        onClick: onNextButtonClick,
        onKeyDown: function onKeyDown(e) {
          return onContainerButtonKeydown(e);
        }
      } : {
        style: {
          visibility: 'hidden'
        }
      };
      var nextIconProps = mergeProps({
        className: cx('nextIcon')
      }, ptm('nextIcon'));
      var icon = props.nextIcon || /*#__PURE__*/React__namespace.createElement(ChevronRightIcon, nextIconProps);
      var forwardNavigatorIcon = IconUtils.getJSXIcon(icon, _objectSpread$1K({}, nextIconProps), {
        props: props
      });
      var _localeOptions5 = localeOptions(props.locale),
        nextDecade = _localeOptions5.nextDecade,
        nextYear = _localeOptions5.nextYear,
        nextMonth = _localeOptions5.nextMonth;
      var nextButtonLabel = currentView === 'year' ? nextDecade : currentView === 'month' ? nextYear : nextMonth;
      var nextButtonProps = mergeProps(_objectSpread$1K({
        type: 'button',
        className: cx('nextButton'),
        'aria-label': nextButtonLabel
      }, navigatorProps), ptm('nextButton'));
      return /*#__PURE__*/React__namespace.createElement("button", _extends({
        ref: nextButton
      }, nextButtonProps), forwardNavigatorIcon, /*#__PURE__*/React__namespace.createElement(Ripple, null));
    };
    var renderMonthsNavigator = function renderMonthsNavigator(index) {
      return props.monthNavigator && props.view !== 'month' && (props.numberOfMonths === 1 || index === 0);
    };
    var createTitleMonthElement = function createTitleMonthElement(month, monthIndex) {
      var monthNames = localeOption('monthNames', props.locale);
      if (renderMonthsNavigator(monthIndex)) {
        var viewDate = getViewDate();
        var viewMonth = viewDate.getMonth();
        var displayedMonthOptions = monthNames.map(function (month, index) {
          return (!isInMinYear(viewDate) || index >= props.minDate.getMonth()) && (!isInMaxYear(viewDate) || index <= props.maxDate.getMonth()) ? {
            label: month,
            value: index,
            index: index
          } : null;
        }).filter(function (option) {
          return !!option;
        });
        var displayedMonthNames = displayedMonthOptions.map(function (option) {
          return option.label;
        });
        var selectProps = mergeProps({
          className: cx('select'),
          onChange: function onChange(e) {
            return onMonthDropdownChange(e, e.target.value);
          },
          value: viewMonth
        }, ptm('select'));
        var _content = /*#__PURE__*/React__namespace.createElement("select", selectProps, displayedMonthOptions.map(function (option) {
          var optionProps = mergeProps({
            value: option.value
          }, ptm('option'));
          return /*#__PURE__*/React__namespace.createElement("option", _extends({}, optionProps, {
            key: option.label
          }), option.label);
        }));
        if (props.monthNavigatorTemplate) {
          var defaultContentOptions = {
            onChange: onMonthDropdownChange,
            className: 'p-datepicker-month',
            value: viewMonth,
            names: displayedMonthNames,
            options: displayedMonthOptions,
            element: _content,
            props: props
          };
          return ObjectUtils.getJSXElement(props.monthNavigatorTemplate, defaultContentOptions);
        }
        return _content;
      }
      var monthTitleProps = mergeProps({
        className: cx('monthTitle'),
        onKeyDown: onContainerButtonKeydown,
        'aria-label': localeOption('chooseMonth', props.locale),
        onClick: switchToMonthView,
        disabled: switchViewButtonDisabled()
      }, ptm('monthTitle'));
      return currentView === 'date' && /*#__PURE__*/React__namespace.createElement("button", monthTitleProps, monthNames[month]);
    };
    var createTitleYearElement = function createTitleYearElement(metaYear) {
      var viewDate = getViewDate();
      var viewYear = viewDate.getFullYear();
      var displayYear = props.numberOfMonths > 1 || props.yearNavigator ? metaYear : currentYear;
      if (props.yearNavigator) {
        var _yearOptions2 = [];
        if (props.yearRange) {
          var years = props.yearRange.split(':');
          var yearStart = parseInt(years[0], 10);
          var yearEnd = parseInt(years[1], 10);
          for (var i = yearStart; i <= yearEnd; i++) {
            _yearOptions2.push(i);
          }
        } else {
          var base = viewYear - viewYear % 10;
          for (var _i2 = 0; _i2 < 10; _i2++) {
            _yearOptions2.push(base + _i2);
          }
        }
        var displayedYearNames = _yearOptions2.filter(function (year) {
          return !(props.minDate && props.minDate.getFullYear() > year) && !(props.maxDate && props.maxDate.getFullYear() < year);
        });
        var selectProps = mergeProps({
          className: cx('select'),
          onChange: function onChange(e) {
            return onYearDropdownChange(e, e.target.value);
          },
          value: displayYear
        }, ptm('select'));
        var _content2 = /*#__PURE__*/React__namespace.createElement("select", selectProps, displayedYearNames.map(function (year) {
          var optionProps = mergeProps({
            value: year
          }, ptm('option'));
          return /*#__PURE__*/React__namespace.createElement("option", _extends({}, optionProps, {
            key: year
          }), year);
        }));
        if (props.yearNavigatorTemplate) {
          var options = displayedYearNames.map(function (name, i) {
            return {
              label: name,
              value: name,
              index: i
            };
          });
          var defaultContentOptions = {
            onChange: onYearDropdownChange,
            className: 'p-datepicker-year',
            value: viewYear,
            names: displayedYearNames,
            options: options,
            element: _content2,
            props: props
          };
          return ObjectUtils.getJSXElement(props.yearNavigatorTemplate, defaultContentOptions);
        }
        return _content2;
      }
      var yearTitleProps = mergeProps({
        className: cx('yearTitle'),
        'aria-label': localeOption('chooseYear', props.locale),
        onClick: function onClick(e) {
          return switchToYearView(e);
        },
        disabled: switchViewButtonDisabled()
      }, ptm('yearTitle'));
      return currentView !== 'year' && /*#__PURE__*/React__namespace.createElement("button", yearTitleProps, displayYear);
    };
    var createTitleDecadeElement = function createTitleDecadeElement() {
      var years = yearPickerValues();
      var decadeTitleProps = mergeProps({
        className: cx('decadeTitle')
      }, ptm('decadeTitle'));
      if (currentView === 'year') {
        var decadeTitleTextProps = mergeProps(ptm('decadeTitleText'));
        return /*#__PURE__*/React__namespace.createElement("span", decadeTitleProps, props.decadeTemplate ? props.decadeTemplate(years) : /*#__PURE__*/React__namespace.createElement("span", decadeTitleTextProps, "".concat(yearPickerValues()[0], " - ").concat(yearPickerValues()[yearPickerValues().length - 1])));
      }
      return null;
    };
    var createTitle = function createTitle(monthMetaData, index) {
      var month = createTitleMonthElement(monthMetaData.month, index);
      var year = createTitleYearElement(monthMetaData.year);
      var decade = createTitleDecadeElement();
      var titleProps = mergeProps({
        className: cx('title')
      }, ptm('title'));
      var showMonthAfterYear = localeOption('showMonthAfterYear', props.locale);
      return /*#__PURE__*/React__namespace.createElement("div", titleProps, showMonthAfterYear ? year : month, showMonthAfterYear ? month : year, decade);
    };
    var createDayNames = function createDayNames(weekDays) {
      var weekDayProps = mergeProps(ptm('weekDay'));
      var tableHeaderCellProps = mergeProps({
        scope: 'col'
      }, ptm('tableHeaderCell'));
      var dayNames = weekDays.map(function (weekDay, index) {
        return /*#__PURE__*/React__namespace.createElement("th", _extends({}, tableHeaderCellProps, {
          key: "".concat(weekDay, "-").concat(index)
        }), /*#__PURE__*/React__namespace.createElement("span", weekDayProps, weekDay));
      });
      if (props.showWeek) {
        var weekHeaderProps = mergeProps({
          scope: 'col',
          className: cx('weekHeader'),
          'data-p-disabled': props.showWeek
        }, ptm('weekHeader', {
          context: {
            disabled: props.showWeek
          }
        }));
        var weekLabel = mergeProps(ptm('weekLabel'));
        var weekHeader = /*#__PURE__*/React__namespace.createElement("th", _extends({}, weekHeaderProps, {
          key: "wn"
        }), /*#__PURE__*/React__namespace.createElement("span", weekLabel, localeOption('weekHeader', props.locale)));
        return [weekHeader].concat(_toConsumableArray(dayNames));
      }
      return dayNames;
    };
    var createDateCellContent = function createDateCellContent(date, className, groupIndex) {
      var content = props.dateTemplate ? props.dateTemplate(date) : date.day;
      var selected = isSelected(date);
      var dayLabelProps = mergeProps({
        className: cx('dayLabel', {
          className: className
        }),
        'aria-selected': selected,
        'aria-disabled': !date.selectable,
        onMouseDown: function onMouseDown(e) {
          return e.preventDefault();
        },
        onClick: function onClick(e) {
          return onDateSelect(e, date);
        },
        onKeyDown: function onKeyDown(e) {
          return onDateCellKeydown(e, date, groupIndex);
        },
        'data-p-highlight': selected,
        'data-p-disabled': !date.selectable
      }, ptm('dayLabel', {
        context: {
          selected: selected,
          disabled: !date.selectable
        }
      }));
      return /*#__PURE__*/React__namespace.createElement("span", dayLabelProps, content, selected && /*#__PURE__*/React__namespace.createElement("div", {
        "aria-live": "polite",
        className: "p-hidden-accessible",
        "data-p-hidden-accessible": true,
        pt: ptm('hiddenSelectedDay')
      }));
    };
    var createWeek = function createWeek(weekDates, weekNumber, groupIndex) {
      var week = weekDates.map(function (date) {
        var selected = isSelected(date);
        var dateClassName = classNames({
          'p-highlight': selected,
          'p-disabled': !date.selectable
        });
        var content = date.otherMonth && !props.showOtherMonths ? null : createDateCellContent(date, dateClassName, groupIndex);
        var formattedValue = formatDate(new Date(date.year, date.month, date.day), getDateFormat());
        var dayProps = mergeProps({
          className: cx('day', {
            date: date
          }),
          'aria-label': formattedValue,
          'data-p-today': date.today,
          'data-p-other-month': date.otherMonth,
          'data-p-day': date.day,
          'data-p-month': date.month,
          'data-p-year': date.year
        }, ptm('day', {
          context: {
            date: date,
            today: date.today,
            otherMonth: date.otherMonth
          }
        }));
        return /*#__PURE__*/React__namespace.createElement("td", _extends({}, dayProps, {
          key: date.day
        }), content);
      });
      if (props.showWeek) {
        var weekNumberProps = mergeProps({
          className: cx('weekNumber')
        }, ptm('weekNumber'));
        var weekLabelContainerProps = mergeProps({
          className: cx('weekLabelContainer'),
          'data-p-disabled': props.showWeek
        }, ptm('weekLabelContainer', {
          context: {
            disabled: props.showWeek
          }
        }));
        var weekNumberCell = /*#__PURE__*/React__namespace.createElement("td", _extends({}, weekNumberProps, {
          key: 'wn' + weekNumber
        }), /*#__PURE__*/React__namespace.createElement("span", weekLabelContainerProps, weekNumber));
        return [weekNumberCell].concat(_toConsumableArray(week));
      }
      return week;
    };
    var createDates = function createDates(monthMetaData, groupIndex) {
      var tableBodyRowProps = mergeProps(ptm('tableBodyRowProps'));
      return monthMetaData.dates.map(function (weekDates, index) {
        return /*#__PURE__*/React__namespace.createElement("tr", _extends({}, tableBodyRowProps, {
          key: index
        }), createWeek(weekDates, monthMetaData.weekNumbers[index], groupIndex));
      });
    };
    var createDateViewGrid = function createDateViewGrid(monthMetaData, weekDays, groupIndex) {
      var dayNames = createDayNames(weekDays);
      var dates = createDates(monthMetaData, groupIndex);
      var containerProps = mergeProps({
        className: cx('container')
      }, ptm('container'));
      var tableProps = mergeProps({
        role: 'grid',
        className: cx('table')
      }, ptm('table'));
      var tableHeaderProps = mergeProps(ptm('tableHeader'));
      var tableHeaderRowProps = mergeProps(ptm('tableHeaderRow'));
      var tableBodyProps = mergeProps(ptm('tableBody'));
      return currentView === 'date' && /*#__PURE__*/React__namespace.createElement("div", _extends({}, containerProps, {
        key: UniqueComponentId('calendar_container_')
      }), /*#__PURE__*/React__namespace.createElement("table", tableProps, /*#__PURE__*/React__namespace.createElement("thead", tableHeaderProps, /*#__PURE__*/React__namespace.createElement("tr", tableHeaderRowProps, dayNames)), /*#__PURE__*/React__namespace.createElement("tbody", tableBodyProps, dates)));
    };
    var createMonth = function createMonth(monthMetaData, index) {
      var weekDays = createWeekDaysMeta();
      var backwardNavigator = createBackwardNavigator(index === 0);
      var forwardNavigator = createForwardNavigator(props.numberOfMonths === 1 || index === props.numberOfMonths - 1);
      var title = createTitle(monthMetaData, index);
      var dateViewGrid = createDateViewGrid(monthMetaData, weekDays, index);
      var header = props.headerTemplate ? props.headerTemplate() : null;
      var monthKey = monthMetaData.month + '-' + monthMetaData.year;
      var groupProps = mergeProps({
        className: cx('group')
      }, ptm('group'));
      var headerProps = mergeProps({
        className: cx('header')
      }, ptm('header'));
      return /*#__PURE__*/React__namespace.createElement("div", _extends({}, groupProps, {
        key: monthKey
      }), /*#__PURE__*/React__namespace.createElement("div", _extends({}, headerProps, {
        key: index
      }), header, backwardNavigator, title, forwardNavigator), dateViewGrid);
    };
    var createMonths = function createMonths(monthsMetaData) {
      var groups = monthsMetaData.map(createMonth);
      var groupContainerProps = mergeProps({
        className: cx('groupContainer')
      }, ptm('groupContainer'));
      return /*#__PURE__*/React__namespace.createElement("div", groupContainerProps, groups);
    };
    var createDateView = function createDateView() {
      var viewDate = getViewDate();
      var monthsMetaData = createMonthsMeta(viewDate.getMonth(), viewDate.getFullYear());
      var months = createMonths(monthsMetaData);
      return months;
    };
    var monthPickerValues = function monthPickerValues() {
      var monthPickerValues = [];
      var monthNamesShort = localeOption('monthNamesShort', props.locale);
      for (var i = 0; i <= 11; i++) {
        monthPickerValues.push(monthNamesShort[i]);
      }
      return monthPickerValues;
    };
    var yearPickerValues = function yearPickerValues() {
      var yearPickerValues = [];
      var base = currentYear - currentYear % 10;
      for (var i = 0; i < 10; i++) {
        yearPickerValues.push(base + i);
      }
      return yearPickerValues;
    };
    var createMonthYearView = function createMonthYearView() {
      var backwardNavigator = createBackwardNavigator(true);
      var forwardNavigator = createForwardNavigator(true);
      var yearElement = createTitleYearElement(getViewDate().getFullYear());
      var decade = createTitleDecadeElement();
      var groupContainerProps = mergeProps({
        className: cx('groupContainer')
      }, ptm('groupContainer'));
      var groupProps = mergeProps({
        className: cx('group')
      }, ptm('group'));
      var headerProps = mergeProps({
        className: cx('header')
      }, ptm('header'));
      var titleProps = mergeProps({
        className: cx('title')
      }, ptm('title'));
      return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, null, /*#__PURE__*/React__namespace.createElement("div", groupContainerProps, /*#__PURE__*/React__namespace.createElement("div", groupProps, /*#__PURE__*/React__namespace.createElement("div", headerProps, backwardNavigator, /*#__PURE__*/React__namespace.createElement("div", titleProps, yearElement, decade), forwardNavigator))));
    };
    var createDatePicker = function createDatePicker() {
      if (!props.timeOnly) {
        if (props.view === 'date') {
          return createDateView();
        }
        return createMonthYearView();
      }
      return null;
    };
    var incrementIconProps = mergeProps(ptm('incrementIcon'));
    var decrementIconProps = mergeProps(ptm('decrementIcon'));
    var incrementIcon = IconUtils.getJSXIcon(props.incrementIcon || /*#__PURE__*/React__namespace.createElement(ChevronUpIcon, incrementIconProps), _objectSpread$1K({}, incrementIconProps), {
      props: props
    });
    var decrementIcon = IconUtils.getJSXIcon(props.decrementIcon || /*#__PURE__*/React__namespace.createElement(ChevronDownIcon, decrementIconProps), _objectSpread$1K({}, decrementIconProps), {
      props: props
    });
    var createHourPicker = function createHourPicker() {
      var currentTime = getCurrentDateTime();
      var minute = doStepMinute(currentTime.getMinutes());
      var hour = currentTime.getHours();

      // #3770 account for step minutes rolling to next hour
      hour = minute > 59 ? hour + 1 : hour;
      if (props.hourFormat === '12') {
        if (hour === 0) {
          hour = 12;
        } else if (hour > 11 && hour !== 12) {
          hour = hour - 12;
        }
      }
      var hourProps = mergeProps(ptm('hour'));
      var _localeOptions6 = localeOptions(props.locale),
        nextHour = _localeOptions6.nextHour,
        prevHour = _localeOptions6.prevHour;
      var hourDisplay = hour < 10 ? '0' + hour : hour;
      var hourPickerProps = mergeProps({
        className: cx('hourPicker')
      }, ptm('hourPicker'));
      var incrementButtonProps = mergeProps({
        type: 'button',
        className: cx('incrementButton'),
        'aria-label': nextHour,
        onMouseDown: function onMouseDown(e) {
          return onTimePickerElementMouseDown(e, 0, 1);
        },
        onMouseUp: onTimePickerElementMouseUp,
        onMouseLeave: onTimePickerElementMouseLeave,
        onKeyDown: function onKeyDown(e) {
          return onPickerKeyDown(e, 0, 1);
        },
        onKeyUp: onPickerKeyUp
      }, ptm('incrementButton'));
      var decrementButtonProps = mergeProps({
        type: 'button',
        className: cx('decrementButton'),
        'aria-label': prevHour,
        onMouseDown: function onMouseDown(e) {
          return onTimePickerElementMouseDown(e, 0, -1);
        },
        onMouseUp: onTimePickerElementMouseUp,
        onMouseLeave: onTimePickerElementMouseLeave,
        onKeyDown: function onKeyDown(e) {
          return onPickerKeyDown(e, 0, -1);
        },
        onKeyUp: onPickerKeyUp
      }, ptm('decrementButton'));
      return /*#__PURE__*/React__namespace.createElement("div", hourPickerProps, /*#__PURE__*/React__namespace.createElement("button", incrementButtonProps, incrementIcon, /*#__PURE__*/React__namespace.createElement(Ripple, null)), /*#__PURE__*/React__namespace.createElement("span", hourProps, hourDisplay), /*#__PURE__*/React__namespace.createElement("button", decrementButtonProps, decrementIcon, /*#__PURE__*/React__namespace.createElement(Ripple, null)));
    };
    var createMinutePicker = function createMinutePicker() {
      var currentTime = getCurrentDateTime();
      var minute = doStepMinute(currentTime.getMinutes());
      minute = minute > 59 ? minute - 60 : minute;
      var minuteProps = mergeProps(ptm('minute'));
      var _localeOptions7 = localeOptions(props.locale),
        nextMinute = _localeOptions7.nextMinute,
        prevMinute = _localeOptions7.prevMinute;
      var minuteDisplay = minute < 10 ? '0' + minute : minute;
      var minutePickerProps = mergeProps({
        className: cx('minutePicker')
      }, ptm('minutePicker'));
      var incrementButtonProps = mergeProps({
        type: 'button',
        className: cx('incrementButton'),
        'aria-label': nextMinute,
        onMouseDown: function onMouseDown(e) {
          return onTimePickerElementMouseDown(e, 1, 1);
        },
        onMouseUp: onTimePickerElementMouseUp,
        onMouseLeave: onTimePickerElementMouseLeave,
        onKeyDown: function onKeyDown(e) {
          return onPickerKeyDown(e, 1, 1);
        },
        onKeyUp: onPickerKeyUp
      }, ptm('incrementButton'));
      var decrementButtonProps = mergeProps({
        type: 'button',
        className: cx('decrementButton'),
        'aria-label': prevMinute,
        onMouseDown: function onMouseDown(e) {
          return onTimePickerElementMouseDown(e, 1, -1);
        },
        onMouseUp: onTimePickerElementMouseUp,
        onMouseLeave: onTimePickerElementMouseLeave,
        onKeyDown: function onKeyDown(e) {
          return onPickerKeyDown(e, 1, -1);
        },
        onKeyUp: onPickerKeyUp
      }, ptm('decrementButton'));
      return /*#__PURE__*/React__namespace.createElement("div", minutePickerProps, /*#__PURE__*/React__namespace.createElement("button", incrementButtonProps, incrementIcon, /*#__PURE__*/React__namespace.createElement(Ripple, null)), /*#__PURE__*/React__namespace.createElement("span", minuteProps, minuteDisplay), /*#__PURE__*/React__namespace.createElement("button", decrementButtonProps, decrementIcon, /*#__PURE__*/React__namespace.createElement(Ripple, null)));
    };
    var createSecondPicker = function createSecondPicker() {
      if (props.showSeconds) {
        var currentTime = getCurrentDateTime();
        var _localeOptions8 = localeOptions(props.locale),
          nextSecond = _localeOptions8.nextSecond,
          prevSecond = _localeOptions8.prevSecond;
        var secondProps = mergeProps(ptm('second'));
        var second = currentTime.getSeconds();
        var secondDisplay = second < 10 ? '0' + second : second;
        var secondPickerProps = mergeProps({
          className: cx('secondPicker')
        }, ptm('secondPicker'));
        var incrementButtonProps = mergeProps({
          type: 'button',
          className: cx('incrementButton'),
          'aria-label': nextSecond,
          onMouseDown: function onMouseDown(e) {
            return onTimePickerElementMouseDown(e, 2, 1);
          },
          onMouseUp: onTimePickerElementMouseUp,
          onMouseLeave: onTimePickerElementMouseLeave,
          onKeyDown: function onKeyDown(e) {
            return onPickerKeyDown(e, 2, 1);
          },
          onKeyUp: onPickerKeyUp
        }, ptm('incrementButton'));
        var decrementButtonProps = mergeProps({
          type: 'button',
          className: cx('decrementButton'),
          'aria-label': prevSecond,
          onMouseDown: function onMouseDown(e) {
            return onTimePickerElementMouseDown(e, 2, -1);
          },
          onMouseUp: onTimePickerElementMouseUp,
          onMouseLeave: onTimePickerElementMouseLeave,
          onKeyDown: function onKeyDown(e) {
            return onPickerKeyDown(e, 2, -1);
          },
          onKeyUp: onPickerKeyUp
        }, ptm('decrementButton'));
        return /*#__PURE__*/React__namespace.createElement("div", secondPickerProps, /*#__PURE__*/React__namespace.createElement("button", incrementButtonProps, incrementIcon, /*#__PURE__*/React__namespace.createElement(Ripple, null)), /*#__PURE__*/React__namespace.createElement("span", secondProps, secondDisplay), /*#__PURE__*/React__namespace.createElement("button", decrementButtonProps, decrementIcon, /*#__PURE__*/React__namespace.createElement(Ripple, null)));
      }
      return null;
    };
    var createMiliSecondPicker = function createMiliSecondPicker() {
      if (props.showMillisec) {
        var currentTime = getCurrentDateTime();
        var _localeOptions9 = localeOptions(props.locale),
          nextMilliSecond = _localeOptions9.nextMilliSecond,
          prevMilliSecond = _localeOptions9.prevMilliSecond;
        var millisecondProps = mergeProps(ptm('millisecond'));
        var millisecond = currentTime.getMilliseconds();
        var millisecondDisplay = millisecond < 100 ? (millisecond < 10 ? '00' : '0') + millisecond : millisecond;
        var millisecondPickerProps = mergeProps({
          className: cx('millisecondPicker')
        }, ptm('millisecondPicker'));
        var incrementButtonProps = mergeProps({
          type: 'button',
          className: cx('incrementButton'),
          'aria-label': nextMilliSecond,
          onMouseDown: function onMouseDown(e) {
            return onTimePickerElementMouseDown(e, 3, 1);
          },
          onMouseUp: onTimePickerElementMouseUp,
          onMouseLeave: onTimePickerElementMouseLeave,
          onKeyDown: function onKeyDown(e) {
            return onPickerKeyDown(e, 3, 1);
          },
          onKeyUp: onPickerKeyUp
        }, ptm('incrementButton'));
        var decrementButtonProps = mergeProps({
          type: 'button',
          className: cx('decrementButton'),
          'aria-label': prevMilliSecond,
          onMouseDown: function onMouseDown(e) {
            return onTimePickerElementMouseDown(e, 3, -1);
          },
          onMouseUp: onTimePickerElementMouseUp,
          onMouseLeave: onTimePickerElementMouseLeave,
          onKeyDown: function onKeyDown(e) {
            return onPickerKeyDown(e, 3, -1);
          },
          onKeyUp: onPickerKeyUp
        }, ptm('decrementButton'));
        return /*#__PURE__*/React__namespace.createElement("div", millisecondPickerProps, /*#__PURE__*/React__namespace.createElement("button", incrementButtonProps, incrementIcon, /*#__PURE__*/React__namespace.createElement(Ripple, null)), /*#__PURE__*/React__namespace.createElement("span", millisecondProps, millisecondDisplay), /*#__PURE__*/React__namespace.createElement("button", decrementButtonProps, decrementIcon, /*#__PURE__*/React__namespace.createElement(Ripple, null)));
      }
      return null;
    };
    var createAmPmPicker = function createAmPmPicker() {
      if (props.hourFormat === '12') {
        var currentTime = getCurrentDateTime();
        var _localeOptions10 = localeOptions(props.locale),
          am = _localeOptions10.am,
          pm = _localeOptions10.pm;
        var hour = currentTime.getHours();
        var display = hour > 11 ? 'PM' : 'AM';
        var ampmProps = mergeProps(ptm('ampm'));
        var ampmPickerProps = mergeProps({
          className: cx('ampmPicker')
        }, ptm('ampmPicker'));
        var incrementButtonProps = mergeProps({
          type: 'button',
          className: cx('incrementButton'),
          'aria-label': am,
          onClick: function onClick(e) {
            return toggleAmPm(e);
          }
        }, ptm('incrementButton'));
        var decrementButtonProps = mergeProps({
          type: 'button',
          className: cx('decrementButton'),
          'aria-label': pm,
          onClick: function onClick(e) {
            return toggleAmPm(e);
          }
        }, ptm('decrementButton'));
        return /*#__PURE__*/React__namespace.createElement("div", ampmPickerProps, /*#__PURE__*/React__namespace.createElement("button", incrementButtonProps, incrementIcon, /*#__PURE__*/React__namespace.createElement(Ripple, null)), /*#__PURE__*/React__namespace.createElement("span", ampmProps, display), /*#__PURE__*/React__namespace.createElement("button", decrementButtonProps, decrementIcon, /*#__PURE__*/React__namespace.createElement(Ripple, null)));
      }
      return null;
    };
    var createSeparator = function createSeparator(separator) {
      var separatorContainerProps = mergeProps({
        className: cx('separatorContainer')
      }, ptm('separatorContainer'));
      var separatorProps = mergeProps(ptm('separator'));
      return /*#__PURE__*/React__namespace.createElement("div", separatorContainerProps, /*#__PURE__*/React__namespace.createElement("span", separatorProps, separator));
    };
    var createTimePicker = function createTimePicker() {
      if ((props.showTime || props.timeOnly) && currentView === 'date') {
        var timePickerProps = mergeProps({
          className: cx('timePicker')
        }, ptm('timePicker'));
        return /*#__PURE__*/React__namespace.createElement("div", timePickerProps, createHourPicker(), createSeparator(':'), createMinutePicker(), props.showSeconds && createSeparator(':'), createSecondPicker(), props.showMillisec && createSeparator('.'), createMiliSecondPicker(), props.hourFormat === '12' && createSeparator(':'), createAmPmPicker());
      }
      return null;
    };
    var createInputElement = function createInputElement() {
      if (!props.inline) {
        return /*#__PURE__*/React__namespace.createElement(InputText, {
          ref: inputRef,
          id: props.inputId,
          name: props.name,
          type: "text",
          role: "combobox",
          className: classNames(props.inputClassName, cx('input', {
            context: context
          })),
          style: props.inputStyle,
          readOnly: props.readOnlyInput,
          disabled: props.disabled,
          required: props.required,
          autoComplete: "off",
          placeholder: props.placeholder,
          tabIndex: props.tabIndex,
          onInput: onUserInput,
          onFocus: onInputFocus,
          onBlur: onInputBlur,
          onKeyDown: onInputKeyDown,
          "aria-expanded": overlayVisibleState,
          "aria-autocomplete": "none",
          "aria-haspopup": "dialog",
          "aria-controls": panelId,
          "aria-labelledby": props.ariaLabelledBy,
          "aria-label": props.ariaLabel,
          inputMode: props.inputMode,
          tooltip: props.tooltip,
          tooltipOptions: props.tooltipOptions,
          pt: ptm('input'),
          unstyled: props.unstyled,
          __parentMetadata: {
            parent: metaData
          }
        });
      }
      return null;
    };
    var createButton = function createButton() {
      if (props.showIcon) {
        return /*#__PURE__*/React__namespace.createElement(Button, {
          type: "button",
          icon: props.icon || /*#__PURE__*/React__namespace.createElement(CalendarIcon, null),
          onClick: onButtonClick,
          tabIndex: "-1",
          disabled: props.disabled,
          "aria-haspopup": "dialog",
          "aria-label": localeOption('chooseDate', props.locale),
          "aria-expanded": overlayVisibleState,
          "aria-controls": panelId,
          className: cx('dropdownButton'),
          pt: ptm('dropdownButton'),
          __parentMetadata: {
            parent: metaData
          }
        });
      }
      return null;
    };
    var createContent = function createContent() {
      var input = createInputElement();
      var button = createButton();
      if (props.iconPos === 'left') {
        return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, null, button, input);
      }
      return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, null, input, button);
    };
    var isPastMaxDateWithBuffer = function isPastMaxDateWithBuffer() {
      var bufferInSeconds = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 10;
      var now = new Date();
      var maxDate = props.maxDate;
      return maxDate < now && Math.abs((now.getTime() - maxDate.getTime()) / 1000) > bufferInSeconds;
    };
    var createButtonBar = function createButtonBar() {
      if (props.showButtonBar) {
        var _localeOptions11 = localeOptions(props.locale),
          today = _localeOptions11.today,
          clear = _localeOptions11.clear,
          now = _localeOptions11.now;
        var nowDate = new Date();
        var isHidden = props.minDate && props.minDate > nowDate || props.maxDate && isPastMaxDateWithBuffer();
        var buttonbarProps = mergeProps({
          className: cx('buttonbar')
        }, ptm('buttonbar'));
        return /*#__PURE__*/React__namespace.createElement("div", buttonbarProps, /*#__PURE__*/React__namespace.createElement(Button, {
          type: "button",
          label: props.showTime ? now : today,
          onClick: onTodayButtonClick,
          onKeyDown: function onKeyDown(e) {
            return onContainerButtonKeydown(e);
          },
          className: classNames(props.todayButtonClassName, cx('todayButton')),
          pt: ptm('todayButton'),
          style: isHidden ? {
            visibility: 'hidden'
          } : undefined
        }), /*#__PURE__*/React__namespace.createElement(Button, {
          type: "button",
          label: clear,
          onClick: onClearButtonClick,
          onKeyDown: function onKeyDown(e) {
            return onContainerButtonKeydown(e);
          },
          className: classNames(props.clearButtonClassName, cx('clearButton')),
          pt: ptm('clearButton')
        }));
      }
      return null;
    };
    var createFooter = function createFooter() {
      if (props.footerTemplate) {
        var _content3 = props.footerTemplate();
        var footerProps = mergeProps({
          className: cx('footer')
        }, ptm('footer'));
        return /*#__PURE__*/React__namespace.createElement("div", footerProps, _content3);
      }
      return null;
    };
    var createMonthPicker = function createMonthPicker() {
      if (currentView === 'month') {
        var monthPickerProps = mergeProps({
          className: cx('monthPicker')
        }, ptm('monthPicker'));
        return /*#__PURE__*/React__namespace.createElement("div", monthPickerProps, monthPickerValues().map(function (m, i) {
          var selected = isMonthSelected(i);
          var monthProps = mergeProps({
            className: cx('month', {
              isMonthSelected: isMonthSelected,
              isMonthYearDisabled: isMonthYearDisabled,
              i: i,
              currentYear: currentYear
            }),
            onClick: function onClick(event) {
              return onMonthSelect(event, i);
            },
            onKeyDown: function onKeyDown(event) {
              return onMonthCellKeydown(event, i);
            },
            'data-p-disabled': isMonthYearDisabled(i, currentYear),
            'data-p-highlight': selected
          }, ptm('month', {
            context: {
              month: m,
              monthIndex: i,
              selected: selected,
              disabled: isMonthYearDisabled(i, currentYear)
            }
          }));
          return /*#__PURE__*/React__namespace.createElement("span", _extends({}, monthProps, {
            key: "month".concat(i + 1)
          }), m, selected && /*#__PURE__*/React__namespace.createElement("div", {
            "aria-live": "polite",
            className: "p-hidden-accessible",
            "data-p-hidden-accessible": true,
            pt: ptm('hiddenMonth')
          }, m));
        }));
      }
      return null;
    };
    var createYearPicker = function createYearPicker() {
      if (currentView === 'year') {
        var yearPickerProps = mergeProps({
          className: cx('yearPicker')
        }, ptm('yearPicker'));
        return /*#__PURE__*/React__namespace.createElement("div", yearPickerProps, yearPickerValues().map(function (y, i) {
          var selected = isYearSelected(y);
          var yearProps = mergeProps({
            className: cx('year', {
              isYearSelected: isYearSelected,
              isMonthYearDisabled: isMonthYearDisabled,
              y: y
            }),
            onClick: function onClick(event) {
              return onYearSelect(event, y);
            },
            onKeyDown: function onKeyDown(event) {
              return onYearCellKeydown(event, y);
            },
            'data-p-highlight': isYearSelected(y),
            'data-p-disabled': isMonthYearDisabled(-1, y)
          }, ptm('year', {
            context: {
              year: y,
              yearIndex: i,
              selected: selected,
              disabled: isMonthYearDisabled(-1, y)
            }
          }));
          return /*#__PURE__*/React__namespace.createElement("span", _extends({}, yearProps, {
            key: "year".concat(i + 1)
          }), y, selected && /*#__PURE__*/React__namespace.createElement("div", {
            "aria-live": "polite",
            className: "p-hidden-accessible",
            "data-p-hidden-accessible": true,
            pt: ptm('hiddenYear')
          }, y));
        }));
      }
      return null;
    };
    var panelClassName = classNames('p-datepicker p-component', props.panelClassName, {
      'p-datepicker-inline': props.inline,
      'p-disabled': props.disabled,
      'p-datepicker-timeonly': props.timeOnly,
      'p-datepicker-multiple-month': props.numberOfMonths > 1,
      'p-datepicker-monthpicker': currentView === 'month',
      'p-datepicker-touch-ui': props.touchUI,
      'p-input-filled': context && context.inputStyle === 'filled' || PrimeReact.inputStyle === 'filled',
      'p-ripple-disabled': context && context.ripple === false || PrimeReact.ripple === false
    });
    var content = createContent();
    var datePicker = createDatePicker();
    var timePicker = createTimePicker();
    var buttonBar = createButtonBar();
    var footer = createFooter();
    var monthPicker = createMonthPicker();
    var yearPicker = createYearPicker();
    var isFilled = DomHandler.hasClass(inputRef.current, 'p-filled') && inputRef.current.value !== '';
    var rootProps = mergeProps({
      id: props.id,
      className: classNames(props.className, cx('root', {
        focusedState: focusedState,
        isFilled: isFilled,
        panelVisible: visible
      })),
      style: props.style
    }, CalendarBase.getOtherProps(props), ptm('root'));
    return /*#__PURE__*/React__namespace.createElement("span", _extends({
      ref: elementRef
    }, rootProps), content, /*#__PURE__*/React__namespace.createElement(CalendarPanel, {
      hostName: "Calendar",
      id: panelId,
      locale: props.locale,
      ref: overlayRef,
      className: panelClassName,
      style: props.panelStyle,
      appendTo: props.appendTo,
      inline: props.inline,
      onClick: onPanelClick,
      onMouseUp: onPanelMouseUp,
      "in": visible,
      onEnter: onOverlayEnter,
      onEntered: onOverlayEntered,
      onExit: onOverlayExit,
      onExited: onOverlayExited,
      transitionOptions: props.transitionOptions,
      ptm: ptm,
      cx: cx
    }, datePicker, timePicker, monthPicker, yearPicker, buttonBar, footer));
  }));
  Calendar.displayName = 'Calendar';

  var classes$16 = {
    root: 'p-card p-component',
    header: 'p-card-header',
    title: 'p-card-title',
    subTitle: 'p-card-subtitle',
    content: 'p-card-content',
    footer: 'p-card-footer',
    body: 'p-card-body'
  };
  var styles$W = "\n@layer primereact {\n    .p-card-header img {\n        width: 100%;\n    }\n}\n";
  var CardBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'Card',
      id: null,
      header: null,
      footer: null,
      title: null,
      subTitle: null,
      style: null,
      className: null,
      children: undefined
    },
    css: {
      classes: classes$16,
      styles: styles$W
    }
  });

  var Card = /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var mergeProps = useMergeProps();
    var context = React__namespace.useContext(PrimeReactContext);
    var props = CardBase.getProps(inProps, context);
    var elementRef = React__namespace.useRef(ref);
    var _CardBase$setMetaData = CardBase.setMetaData({
        props: props
      }),
      ptm = _CardBase$setMetaData.ptm,
      cx = _CardBase$setMetaData.cx,
      isUnstyled = _CardBase$setMetaData.isUnstyled;
    useHandleStyle(CardBase.css.styles, isUnstyled, {
      name: 'card'
    });
    var createHeader = function createHeader() {
      var headerProps = mergeProps({
        className: cx('header')
      }, ptm('header'));
      if (props.header) {
        return /*#__PURE__*/React__namespace.createElement("div", headerProps, ObjectUtils.getJSXElement(props.header, props));
      }
      return null;
    };
    var createBody = function createBody() {
      var titleProps = mergeProps({
        className: cx('title')
      }, ptm('title'));
      var title = props.title && /*#__PURE__*/React__namespace.createElement("div", titleProps, ObjectUtils.getJSXElement(props.title, props));
      var subTitleProps = mergeProps({
        className: cx('subTitle')
      }, ptm('subTitle'));
      var subTitle = props.subTitle && /*#__PURE__*/React__namespace.createElement("div", subTitleProps, ObjectUtils.getJSXElement(props.subTitle, props));
      var contentProps = mergeProps({
        className: cx('content')
      }, ptm('content'));
      var children = props.children && /*#__PURE__*/React__namespace.createElement("div", contentProps, props.children);
      var footerProps = mergeProps({
        className: cx('footer')
      }, ptm('footer'));
      var footer = props.footer && /*#__PURE__*/React__namespace.createElement("div", footerProps, ObjectUtils.getJSXElement(props.footer, props));
      var bodyProps = mergeProps({
        className: cx('body')
      }, ptm('body'));
      return /*#__PURE__*/React__namespace.createElement("div", bodyProps, title, subTitle, children, footer);
    };
    React__namespace.useEffect(function () {
      ObjectUtils.combinedRefs(elementRef, ref);
    }, [elementRef, ref]);
    var rootProps = mergeProps({
      id: props.id,
      ref: elementRef,
      style: props.style,
      className: classNames(props.className, cx('root'))
    }, CardBase.getOtherProps(props), ptm('root'));
    var header = createHeader();
    var body = createBody();
    return /*#__PURE__*/React__namespace.createElement("div", rootProps, header, body);
  });
  Card.displayName = 'Card';

  var styles$V = "\n@layer primereact {\n    .p-carousel {\n        display: flex;\n        flex-direction: column;\n    }\n    \n    .p-carousel-content {\n        display: flex;\n        flex-direction: column;\n        overflow: auto;\n    }\n    \n    .p-carousel-prev,\n    .p-carousel-next {\n        align-self: center;\n        flex-grow: 0;\n        flex-shrink: 0;\n        display: flex;\n        justify-content: center;\n        align-items: center;\n        overflow: hidden;\n        position: relative;\n    }\n    \n    .p-carousel-container {\n        display: flex;\n        flex-direction: row;\n    }\n    \n    .p-carousel-items-content {\n        overflow: hidden;\n        width: 100%;\n    }\n    \n    .p-carousel-items-container {\n        display: flex;\n        flex-direction: row;\n    }\n    \n    .p-carousel-indicators {\n        display: flex;\n        flex-direction: row;\n        justify-content: center;\n        flex-wrap: wrap;\n    }\n    \n    .p-carousel-indicator > button {\n        display: flex;\n        align-items: center;\n        justify-content: center;\n    }\n    \n    /* Vertical */\n    .p-carousel-vertical .p-carousel-container {\n        flex-direction: column;\n    }\n    \n    .p-carousel-vertical .p-carousel-items-container {\n        flex-direction: column;\n        height: 100%;\n    }\n    \n    /* Keyboard Support */\n    .p-items-hidden .p-carousel-item {\n        visibility: hidden;\n    }\n    \n    .p-items-hidden .p-carousel-item.p-carousel-item-active {\n        visibility: visible;\n    }\n}\n";
  var classes$15 = {
    root: function root(_ref) {
      var isVertical = _ref.isVertical;
      return classNames('p-carousel p-component', {
        'p-carousel-vertical': isVertical,
        'p-carousel-horizontal': !isVertical
      });
    },
    container: 'p-carousel-container',
    content: 'p-carousel-content',
    indicators: 'p-carousel-indicators p-reset',
    header: 'p-carousel-header',
    footer: 'p-carousel-footer',
    itemsContainer: 'p-carousel-items-container',
    itemsContent: 'p-carousel-items-content',
    previousButton: function previousButton(_ref2) {
      var isDisabled = _ref2.isDisabled;
      return classNames('p-carousel-prev p-link', {
        'p-disabled': isDisabled
      });
    },
    previousButtonIcon: 'p-carousel-prev-icon',
    nextButton: function nextButton(_ref3) {
      var isDisabled = _ref3.isDisabled;
      return classNames('p-carousel-next p-link', {
        'p-disabled': isDisabled
      });
    },
    nextButtonIcon: 'p-carousel-next-icon',
    indicator: function indicator(_ref4) {
      var isActive = _ref4.isActive;
      return classNames('p-carousel-indicator', {
        'p-highlight': isActive
      });
    },
    indicatorButton: 'p-link',
    itemCloned: function itemCloned(_ref5) {
      var props = _ref5.itemProps;
      return classNames(props.className, 'p-carousel-item', {
        'p-carousel-item-active': props.active,
        'p-carousel-item-start': props.start,
        'p-carousel-item-end': props.end
      });
    },
    item: function item(_ref6) {
      var props = _ref6.itemProps;
      return classNames(props.className, 'p-carousel-item', {
        'p-carousel-item-active': props.active,
        'p-carousel-item-start': props.start,
        'p-carousel-item-end': props.end
      });
    }
  };
  var inlineStyles$l = {
    itemsContent: function itemsContent(_ref7) {
      var height = _ref7.height;
      return {
        height: height
      };
    }
  };
  var CarouselBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'Carousel',
      id: null,
      value: null,
      page: 0,
      header: null,
      footer: null,
      style: null,
      className: null,
      itemTemplate: null,
      circular: false,
      showIndicators: true,
      showNavigators: true,
      autoplayInterval: 0,
      numVisible: 1,
      numScroll: 1,
      prevIcon: null,
      nextIcon: null,
      responsiveOptions: null,
      orientation: 'horizontal',
      verticalViewPortHeight: '300px',
      contentClassName: null,
      containerClassName: null,
      indicatorsContentClassName: null,
      onPageChange: null,
      children: undefined
    },
    css: {
      classes: classes$15,
      styles: styles$V,
      inlineStyles: inlineStyles$l
    }
  });

  function ownKeys$1J(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1J(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1J(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1J(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var CarouselItem = /*#__PURE__*/React__namespace.memo(function (props) {
    var mergeProps = useMergeProps();
    var ptm = props.ptm,
      cx = props.cx;
    var key = props.className && props.className === 'p-carousel-item-cloned' ? 'itemCloned' : 'item';
    var content = props.template(props.item);
    var itemClonedProps = mergeProps({
      className: cx(key, {
        itemProps: props
      }),
      role: props.role,
      'aria-roledescription': props.ariaRoledescription,
      'aria-label': props.ariaLabel,
      'aria-hidden': props.ariaHidden,
      'data-p-carousel-item-active': props.active,
      'data-p-carousel-item-start': props.start,
      'data-p-carousel-item-end': props.end
    }, ptm(key));
    return /*#__PURE__*/React__namespace.createElement("div", itemClonedProps, content);
  });
  var Carousel = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var mergeProps = useMergeProps();
    var context = React__namespace.useContext(PrimeReactContext);
    var props = CarouselBase.getProps(inProps, context);
    var _React$useState = React__namespace.useState(props.numVisible),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      numVisibleState = _React$useState2[0],
      setNumVisibleState = _React$useState2[1];
    var _React$useState3 = React__namespace.useState(props.numScroll),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      numScrollState = _React$useState4[0],
      setNumScrollState = _React$useState4[1];
    var _React$useState5 = React__namespace.useState(props.page * props.numScroll * -1),
      _React$useState6 = _slicedToArray(_React$useState5, 2),
      totalShiftedItemsState = _React$useState6[0],
      setTotalShiftedItemsState = _React$useState6[1];
    var _React$useState7 = React__namespace.useState(props.page),
      _React$useState8 = _slicedToArray(_React$useState7, 2),
      pageState = _React$useState8[0],
      setPageState = _React$useState8[1];
    var _CarouselBase$setMeta = CarouselBase.setMetaData({
        props: props,
        state: {
          numVisible: numVisibleState,
          numScroll: numScrollState,
          totalShiftedItems: totalShiftedItemsState,
          page: pageState
        }
      }),
      ptm = _CarouselBase$setMeta.ptm,
      cx = _CarouselBase$setMeta.cx,
      sx = _CarouselBase$setMeta.sx,
      isUnstyled = _CarouselBase$setMeta.isUnstyled;
    useHandleStyle(CarouselBase.css.styles, isUnstyled, {
      name: 'carousel'
    });
    var elementRef = React__namespace.useRef(null);
    var itemsContainerRef = React__namespace.useRef(null);
    var remainingItems = React__namespace.useRef(0);
    var allowAutoplay = React__namespace.useRef(!!props.autoplayInterval);
    var attributeSelector = React__namespace.useRef('');
    var swipeThreshold = React__namespace.useRef(20);
    var startPos = React__namespace.useRef(null);
    var interval = React__namespace.useRef(null);
    var carouselStyle = React__namespace.useRef(null);
    var indicatorContent = React__namespace.useRef(null);
    var isRemainingItemsAdded = React__namespace.useRef(false);
    var responsiveOptions = React__namespace.useRef(null);
    var prevNumScroll = usePrevious(numScrollState);
    var prevNumVisible = usePrevious(numVisibleState);
    var prevValue = usePrevious(props.value);
    var prevPage = usePrevious(props.page);
    var isVertical = props.orientation === 'vertical';
    var circular = props.circular || !!props.autoplayInterval;
    var isCircular = circular && props.value && props.value.length >= numVisibleState;
    var totalIndicators = props.value ? Math.max(Math.ceil((props.value.length - numVisibleState) / numScrollState) + 1, 0) : 0;
    var isAutoplay = totalIndicators && props.autoplayInterval && allowAutoplay.current;
    var isControlled = props.onPageChange && !isAutoplay;
    var currentPage = isControlled ? props.page : pageState;
    var _useResizeListener = useResizeListener({
        listener: function listener() {
          calculatePosition();
        },
        when: props.responsiveOptions
      }),
      _useResizeListener2 = _slicedToArray(_useResizeListener, 1),
      bindWindowResizeListener = _useResizeListener2[0];
    var step = function step(dir, page) {
      var totalShiftedItems = totalShiftedItemsState;
      if (page != null) {
        totalShiftedItems = numScrollState * page * -1;
        if (isCircular) {
          totalShiftedItems = totalShiftedItems - numVisibleState;
        }
        isRemainingItemsAdded.current = false;
      } else {
        totalShiftedItems = totalShiftedItems + numScrollState * dir;
        if (isRemainingItemsAdded.current) {
          totalShiftedItems = totalShiftedItems + (remainingItems.current - numScrollState * dir);
          isRemainingItemsAdded.current = false;
        }
        var originalShiftedItems = isCircular ? totalShiftedItems + numVisibleState : totalShiftedItems;
        page = Math.abs(Math.floor(originalShiftedItems / numScrollState));
      }
      if (isCircular && pageState === totalIndicators - 1 && dir === -1) {
        totalShiftedItems = -1 * (props.value.length + numVisibleState);
        page = 0;
      } else if (isCircular && pageState === 0 && dir === 1) {
        totalShiftedItems = 0;
        page = totalIndicators - 1;
      } else if (page === totalIndicators - 1 && remainingItems.current > 0) {
        totalShiftedItems = totalShiftedItems + (remainingItems.current * -1 - numScrollState * dir);
        isRemainingItemsAdded.current = true;
      }
      if (itemsContainerRef.current) {
        !isUnstyled() && DomHandler.removeClass(itemsContainerRef.current, 'p-items-hidden');
        changePosition(totalShiftedItems);
        itemsContainerRef.current.style.transition = 'transform 500ms ease 0s';
      }
      changePage(page);
      setTotalShiftedItemsState(totalShiftedItems);
    };
    var calculatePosition = function calculatePosition() {
      if (itemsContainerRef.current && responsiveOptions.current) {
        var windowWidth = window.innerWidth;
        var matchedResponsiveData = {
          numVisible: props.numVisible,
          numScroll: props.numScroll
        };
        for (var i = 0; i < responsiveOptions.current.length; i++) {
          var res = responsiveOptions.current[i];
          if (parseInt(res.breakpoint, 10) >= windowWidth) {
            matchedResponsiveData = res;
          }
        }
        if (numScrollState !== matchedResponsiveData.numScroll) {
          var page = Math.floor(currentPage * numScrollState / matchedResponsiveData.numScroll);
          var totalShiftedItems = matchedResponsiveData.numScroll * page * -1;
          if (isCircular) {
            totalShiftedItems = totalShiftedItems - matchedResponsiveData.numVisible;
          }
          setTotalShiftedItemsState(totalShiftedItems);
          setNumScrollState(matchedResponsiveData.numScroll);
          changePage(page);
        }
        if (numVisibleState !== matchedResponsiveData.numVisible) {
          setNumVisibleState(matchedResponsiveData.numVisible);
        }
      }
    };
    var navBackward = function navBackward(e, page) {
      if (circular || currentPage !== 0) {
        step(1, page);
      }
      allowAutoplay.current = false;
      if (e.cancelable) {
        e.preventDefault();
      }
    };
    var navForward = function navForward(e, page) {
      if (circular || currentPage < totalIndicators - 1) {
        step(-1, page);
      }
      allowAutoplay.current = false;
      if (e.cancelable) {
        e.preventDefault();
      }
    };
    var onIndicatorClick = function onIndicatorClick(e, page) {
      if (page > currentPage) {
        navForward(e, page);
      } else if (page < currentPage) {
        navBackward(e, page);
      }
    };
    var onTransitionEnd = function onTransitionEnd(e) {
      if (itemsContainerRef.current && e.propertyName === 'transform') {
        DomHandler.addClass(itemsContainerRef.current, 'p-items-hidden');
        itemsContainerRef.current.style.transition = '';
        if ((pageState === 0 || pageState === totalIndicators - 1) && isCircular) {
          changePosition(totalShiftedItemsState);
        }
      }
    };
    var _onTouchStart = function onTouchStart(e) {
      var touchobj = e.changedTouches[0];
      startPos.current = {
        x: touchobj.pageX,
        y: touchobj.pageY
      };
    };
    var _onTouchMove = function onTouchMove(e) {
      if (e.cancelable) {
        e.preventDefault();
      }
    };
    var _onTouchEnd = function onTouchEnd(e) {
      var touchobj = e.changedTouches[0];
      if (isVertical) {
        changePageOnTouch(e, touchobj.pageY - startPos.current.y);
      } else {
        changePageOnTouch(e, touchobj.pageX - startPos.current.x);
      }
    };
    var changePageOnTouch = function changePageOnTouch(e, diff) {
      if (Math.abs(diff) > swipeThreshold.current) {
        if (diff < 0) {
          // left
          navForward(e);
        } else {
          // right
          navBackward(e);
        }
      }
    };
    var onIndicatorKeydown = function onIndicatorKeydown(event) {
      switch (event.code) {
        case 'ArrowRight':
          onRightKey();
          break;
        case 'ArrowLeft':
          onLeftKey();
          break;
        case 'Home':
          onHomeKey();
          event.preventDefault();
          break;
        case 'End':
          onEndKey();
          event.preventDefault();
          break;
        case 'ArrowUp':
        case 'ArrowDown':
          event.preventDefault();
          break;
        case 'Tab':
          onTabKey();
          break;
      }
    };
    var onRightKey = function onRightKey() {
      var indicators = _toConsumableArray(DomHandler.find(indicatorContent.current, '[data-pc-section="indicator"]'));
      var activeIndex = findFocusedIndicatorIndex();
      changedFocusedIndicator(activeIndex, activeIndex + 1 === indicators.length ? indicators.length - 1 : activeIndex + 1);
    };
    var onLeftKey = function onLeftKey() {
      var activeIndex = findFocusedIndicatorIndex();
      changedFocusedIndicator(activeIndex, activeIndex - 1 <= 0 ? 0 : activeIndex - 1);
    };
    var onHomeKey = function onHomeKey() {
      var activeIndex = findFocusedIndicatorIndex();
      changedFocusedIndicator(activeIndex, 0);
    };
    var onEndKey = function onEndKey() {
      var indicators = _toConsumableArray(DomHandler.find(indicatorContent.current, '[data-pc-section="indicator"]r'));
      var activeIndex = findFocusedIndicatorIndex();
      changedFocusedIndicator(activeIndex, indicators.length - 1);
    };
    var onTabKey = function onTabKey() {
      var indicators = _toConsumableArray(DomHandler.find(indicatorContent.current, '[data-pc-section="indicator"]'));
      var highlightedIndex = indicators.findIndex(function (ind) {
        return DomHandler.getAttribute(ind, 'data-p-highlight') === true;
      });
      var activeIndicator = DomHandler.findSingle(indicatorContent.current, '[data-pc-section="indicator"] > button[tabindex="0"]');
      var activeIndex = indicators.findIndex(function (ind) {
        return ind === activeIndicator.parentElement;
      });
      indicators[activeIndex].children[0].tabIndex = '-1';
      indicators[highlightedIndex].children[0].tabIndex = '0';
    };
    var findFocusedIndicatorIndex = function findFocusedIndicatorIndex() {
      var indicators = _toConsumableArray(DomHandler.find(indicatorContent.current, '[data-pc-section="indicator"]'));
      var activeIndicator = DomHandler.findSingle(indicatorContent.current, '[data-pc-section="indicator"] > button[tabindex="0"]');
      return indicators.findIndex(function (ind) {
        return ind === activeIndicator.parentElement;
      });
    };
    var changedFocusedIndicator = function changedFocusedIndicator(prevInd, nextInd) {
      var indicators = _toConsumableArray(DomHandler.find(indicatorContent.current, '[data-pc-section="indicator"]'));
      indicators[prevInd].children[0].tabIndex = '-1';
      indicators[nextInd].children[0].tabIndex = '0';
      indicators[nextInd].children[0].focus();
    };
    var startAutoplay = function startAutoplay() {
      if (props.autoplayInterval > 0) {
        interval.current = setInterval(function () {
          if (pageState === totalIndicators - 1) {
            step(-1, 0);
          } else {
            step(-1, pageState + 1);
          }
        }, props.autoplayInterval);
      }
    };
    var stopAutoplay = function stopAutoplay() {
      if (interval.current) {
        clearInterval(interval.current);
      }
    };
    var createStyle = function createStyle() {
      if (!carouselStyle.current) {
        carouselStyle.current = DomHandler.createInlineStyle(context && context.nonce || PrimeReact.nonce, context && context.styleContainer);
      }
      var innerHTML = "\n            .p-carousel[".concat(attributeSelector.current, "] .p-carousel-item {\n                flex: 1 0 ").concat(100 / numVisibleState, "%\n            }\n        ");
      if (props.responsiveOptions) {
        var comparator = ObjectUtils.localeComparator(context && context.locale || PrimeReact.locale);
        responsiveOptions.current = _toConsumableArray(props.responsiveOptions);
        responsiveOptions.current.sort(function (data1, data2) {
          var value1 = data1.breakpoint;
          var value2 = data2.breakpoint;
          return ObjectUtils.sort(value1, value2, -1, comparator, context && context.nullSortOrder || PrimeReact.nullSortOrder);
        });
        for (var i = 0; i < responsiveOptions.current.length; i++) {
          var res = responsiveOptions.current[i];
          innerHTML = innerHTML + "\n                    @media screen and (max-width: ".concat(res.breakpoint, ") {\n                        .p-carousel[").concat(attributeSelector.current, "] .p-carousel-item {\n                            flex: 1 0 ").concat(100 / res.numVisible, "%\n                        }\n                    }\n                ");
        }
        calculatePosition();
      }
      carouselStyle.current.innerHTML = innerHTML;
    };
    var destroyStyle = function destroyStyle() {
      carouselStyle.current = DomHandler.removeInlineStyle(carouselStyle.current);
    };
    var changePosition = function changePosition(totalShiftedItems) {
      if (itemsContainerRef.current) {
        itemsContainerRef.current.style.transform = isVertical ? "translate3d(0, ".concat(totalShiftedItems * (100 / numVisibleState), "%, 0)") : "translate3d(".concat(totalShiftedItems * (100 / numVisibleState), "%, 0, 0)");
      }
    };
    var changePage = function changePage(page) {
      !isControlled && setPageState(page);
      props.onPageChange && props.onPageChange({
        page: page
      });
    };
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        startAutoplay: startAutoplay,
        stopAutoplay: stopAutoplay,
        getElement: function getElement() {
          return elementRef.current;
        }
      };
    });
    useMountEffect(function () {
      if (elementRef.current) {
        attributeSelector.current = UniqueComponentId();
        elementRef.current.setAttribute(attributeSelector.current, '');
      }
      if (!carouselStyle.current) {
        calculatePosition();
        changePosition(totalShiftedItemsState);
        bindWindowResizeListener();
      }
    });
    useUpdateEffect(function () {
      var stateChanged = false;
      var totalShiftedItems = totalShiftedItemsState;
      createStyle();
      if (props.autoplayInterval) {
        stopAutoplay();
      }
      if (prevNumScroll !== numScrollState || prevNumVisible !== numVisibleState || props.value && prevValue && prevValue.length !== props.value.length) {
        remainingItems.current = (props.value.length - numVisibleState) % numScrollState;
        var page = currentPage;
        if (totalIndicators !== 0 && page >= totalIndicators) {
          page = totalIndicators - 1;
          changePage(page);
          stateChanged = true;
        }
        totalShiftedItems = page * numScrollState * -1;
        if (isCircular) {
          totalShiftedItems = totalShiftedItems - numVisibleState;
        }
        if (page === totalIndicators - 1 && remainingItems.current > 0) {
          totalShiftedItems = totalShiftedItems + (-1 * remainingItems.current + numScrollState);
          isRemainingItemsAdded.current = true;
        } else {
          isRemainingItemsAdded.current = false;
        }
        if (totalShiftedItems !== totalShiftedItemsState) {
          setTotalShiftedItemsState(totalShiftedItems);
          stateChanged = true;
        }
        changePosition(totalShiftedItems);
      }
      if (isCircular) {
        if (pageState === 0) {
          totalShiftedItems = -1 * numVisibleState;
        } else if (totalShiftedItems === 0) {
          totalShiftedItems = -1 * props.value.length;
          if (remainingItems.current > 0) {
            isRemainingItemsAdded.current = true;
          }
        }
        if (totalShiftedItems !== totalShiftedItemsState) {
          setTotalShiftedItemsState(totalShiftedItems);
          stateChanged = true;
        }
      }
      if (prevPage !== props.page) {
        if (props.page > prevPage && props.page <= totalIndicators - 1) {
          step(-1, props.page);
        } else if (props.page < prevPage) {
          step(1, props.page);
        }
      }
      if (!stateChanged && isAutoplay) {
        startAutoplay();
      }
      return function () {
        if (props.autoplayInterval) {
          stopAutoplay();
        }
        destroyStyle();
      };
    });
    var ariaSlideNumber = function ariaSlideNumber(value) {
      return ariaLabel('slideNumber', {
        slideNumber: value
      });
    };
    var createItems = function createItems() {
      if (props.value && props.value.length) {
        var clonedItemsForStarting = null;
        var clonedItemsForFinishing = null;
        if (isCircular) {
          var clonedElements = null;
          clonedElements = props.value.slice(-1 * numVisibleState);
          clonedItemsForStarting = clonedElements.map(function (item, index) {
            var isActive = totalShiftedItemsState * -1 === props.value.length + numVisibleState;
            var start = index === 0;
            var end = index === clonedElements.length - 1;
            var key = index + '_scloned';
            return /*#__PURE__*/React__namespace.createElement(CarouselItem, {
              key: key,
              className: "p-carousel-item-cloned",
              template: props.itemTemplate,
              item: item,
              active: isActive,
              start: start,
              end: end,
              ptm: ptm,
              cx: cx
            });
          });
          clonedElements = props.value.slice(0, numVisibleState);
          clonedItemsForFinishing = clonedElements.map(function (item, index) {
            var isActive = totalShiftedItemsState === 0;
            var start = index === 0;
            var end = index === clonedElements.length - 1;
            var key = index + '_fcloned';
            return /*#__PURE__*/React__namespace.createElement(CarouselItem, {
              key: key,
              className: "p-carousel-item-cloned",
              template: props.itemTemplate,
              item: item,
              active: isActive,
              start: start,
              end: end,
              ptm: ptm,
              cx: cx
            });
          });
        }
        var items = props.value.map(function (item, index) {
          var firstIndex = isCircular ? -1 * (totalShiftedItemsState + numVisibleState) : totalShiftedItemsState * -1;
          var lastIndex = firstIndex + numVisibleState - 1;
          var isActive = firstIndex <= index && lastIndex >= index;
          var start = firstIndex === index;
          var end = lastIndex === index;
          var ariaHidden = firstIndex > index || lastIndex < index ? true : undefined;
          var ariaLabel = ariaSlideNumber(index);
          var ariaRoledescription = localeOption('aria') ? localeOption('aria').slide : undefined;
          return /*#__PURE__*/React__namespace.createElement(CarouselItem, {
            key: index,
            template: props.itemTemplate,
            item: item,
            active: isActive,
            start: start,
            ariaHidden: ariaHidden,
            ariaLabel: ariaLabel,
            ariaRoledescription: ariaRoledescription,
            role: "group",
            end: end,
            ptm: ptm,
            cx: cx
          });
        });
        return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, null, clonedItemsForStarting, items, clonedItemsForFinishing);
      }
    };
    var createHeader = function createHeader() {
      if (props.header) {
        var headerProps = mergeProps({
          className: cx('header')
        }, ptm('header'));
        return /*#__PURE__*/React__namespace.createElement("div", headerProps, props.header);
      }
      return null;
    };
    var createFooter = function createFooter() {
      if (props.footer) {
        var footerProps = mergeProps({
          className: cx('footer')
        }, ptm('footer'));
        return /*#__PURE__*/React__namespace.createElement("div", footerProps, props.footer);
      }
      return null;
    };
    var createContent = function createContent() {
      var items = createItems();
      var height = isVertical ? props.verticalViewPortHeight : 'auto';
      var backwardNavigator = createBackwardNavigator();
      var forwardNavigator = createForwardNavigator();
      var itemsContentProps = mergeProps({
        className: cx('itemsContent'),
        style: sx('itemsContent', {
          height: height
        }),
        onTouchStart: function onTouchStart(e) {
          return _onTouchStart(e);
        },
        onTouchMove: function onTouchMove(e) {
          return _onTouchMove(e);
        },
        onTouchEnd: function onTouchEnd(e) {
          return _onTouchEnd(e);
        }
      }, ptm('itemsContent'));
      var containerProps = mergeProps({
        className: classNames(props.containerClassName, cx('container')),
        'aria-live': allowAutoplay.current ? 'polite' : 'off'
      }, ptm('container'));
      var itemsContainerProps = mergeProps({
        className: cx('itemsContainer'),
        onTransitionEnd: onTransitionEnd
      }, ptm('itemsContainer'));
      return /*#__PURE__*/React__namespace.createElement("div", containerProps, backwardNavigator, /*#__PURE__*/React__namespace.createElement("div", itemsContentProps, /*#__PURE__*/React__namespace.createElement("div", _extends({
        ref: itemsContainerRef
      }, itemsContainerProps), items)), forwardNavigator);
    };
    var createBackwardNavigator = function createBackwardNavigator() {
      if (props.showNavigators) {
        var isDisabled = (!circular || props.value && props.value.length < numVisibleState) && currentPage === 0;
        var previousButtonIconProps = mergeProps({
          className: cx('previousButtonIcon')
        }, ptm('previousButtonIcon'));
        var icon = isVertical ? props.prevIcon || /*#__PURE__*/React__namespace.createElement(ChevronUpIcon, previousButtonIconProps) : props.prevIcon || /*#__PURE__*/React__namespace.createElement(ChevronLeftIcon, previousButtonIconProps);
        var backwardNavigatorIcon = IconUtils.getJSXIcon(icon, _objectSpread$1J({}, previousButtonIconProps), {
          props: props
        });
        var previousButtonProps = mergeProps({
          type: 'button',
          className: cx('previousButton', {
            isDisabled: isDisabled
          }),
          onClick: function onClick(e) {
            return navBackward(e);
          },
          disabled: isDisabled,
          'aria-label': localeOption('aria') ? localeOption('aria').prevPageLabel : undefined,
          'data-pc-group-section': 'navigator'
        }, ptm('previousButton'));
        return /*#__PURE__*/React__namespace.createElement("button", previousButtonProps, backwardNavigatorIcon, /*#__PURE__*/React__namespace.createElement(Ripple, null));
      }
      return null;
    };
    var createForwardNavigator = function createForwardNavigator() {
      if (props.showNavigators) {
        var isDisabled = (!circular || props.value && props.value.length < numVisibleState) && (currentPage === totalIndicators - 1 || totalIndicators === 0);
        var nextButtonIconProps = mergeProps({
          className: cx('nextButtonIcon')
        }, ptm('nextButtonIcon'));
        var icon = isVertical ? props.nextIcon || /*#__PURE__*/React__namespace.createElement(ChevronDownIcon, nextButtonIconProps) : props.nextIcon || /*#__PURE__*/React__namespace.createElement(ChevronRightIcon, nextButtonIconProps);
        var forwardNavigatorIcon = IconUtils.getJSXIcon(icon, _objectSpread$1J({}, nextButtonIconProps), {
          props: props
        });
        var nextButtonProps = mergeProps({
          type: 'button',
          className: cx('nextButton', {
            isDisabled: isDisabled
          }),
          onClick: function onClick(e) {
            return navForward(e);
          },
          disabled: isDisabled,
          'aria-label': localeOption('aria') ? localeOption('aria').nextPageLabel : undefined,
          'data-pc-group-section': 'navigator'
        }, ptm('nextButton'));
        return /*#__PURE__*/React__namespace.createElement("button", nextButtonProps, forwardNavigatorIcon, /*#__PURE__*/React__namespace.createElement(Ripple, null));
      }
      return null;
    };
    var ariaPageLabel = function ariaPageLabel(value) {
      return ariaLabel('pageLabel', {
        page: value
      });
    };
    var createIndicator = function createIndicator(index) {
      var isActive = currentPage === index;
      var getPTOptions = function getPTOptions(key) {
        return ptm(key, {
          context: {
            active: isActive
          }
        });
      };
      var key = 'carousel-indicator-' + index;
      var indicatorProps = mergeProps({
        className: cx('indicator', {
          isActive: isActive
        }),
        'data-p-highlight': isActive
      }, getPTOptions('indicator'));
      var indicatorButtonProps = mergeProps({
        type: 'button',
        className: cx('indicatorButton'),
        tabIndex: currentPage === index ? '0' : '-1',
        onClick: function onClick(e) {
          return onIndicatorClick(e, index);
        },
        'aria-label': ariaPageLabel(index + 1),
        'aria-current': currentPage === index ? 'page' : undefined
      }, getPTOptions('indicatorButton'));
      return /*#__PURE__*/React__namespace.createElement("li", _extends({}, indicatorProps, {
        key: key
      }), /*#__PURE__*/React__namespace.createElement("button", indicatorButtonProps, /*#__PURE__*/React__namespace.createElement(Ripple, null)));
    };
    var createIndicators = function createIndicators() {
      if (props.showIndicators) {
        var _indicators = [];
        for (var i = 0; i < totalIndicators; i++) {
          _indicators.push(createIndicator(i));
        }
        var indicatorsProps = mergeProps({
          ref: indicatorContent,
          className: classNames(props.indicatorsContentClassName, cx('indicators')),
          onKeyDown: onIndicatorKeydown
        }, ptm('indicators'));
        return /*#__PURE__*/React__namespace.createElement("ul", indicatorsProps, _indicators);
      }
      return null;
    };
    var content = createContent();
    var indicators = createIndicators();
    var header = createHeader();
    var footer = createFooter();
    var rootProps = mergeProps({
      id: props.id,
      ref: elementRef,
      className: classNames(props.className, cx('root', {
        isVertical: isVertical
      })),
      style: props.style,
      role: 'region'
    }, CarouselBase.getOtherProps(props), ptm('root'));
    var contentProps = mergeProps({
      className: classNames(props.contentClassName, cx('content'))
    }, ptm('content'));
    return /*#__PURE__*/React__namespace.createElement("div", rootProps, header, /*#__PURE__*/React__namespace.createElement("div", contentProps, content, indicators), footer);
  }));
  CarouselItem.displayName = 'CarouselItem';
  Carousel.displayName = 'Carousel';

  var TimesIcon = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("path", {
      d: "M8.01186 7.00933L12.27 2.75116C12.341 2.68501 12.398 2.60524 12.4375 2.51661C12.4769 2.42798 12.4982 2.3323 12.4999 2.23529C12.5016 2.13827 12.4838 2.0419 12.4474 1.95194C12.4111 1.86197 12.357 1.78024 12.2884 1.71163C12.2198 1.64302 12.138 1.58893 12.0481 1.55259C11.9581 1.51625 11.8617 1.4984 11.7647 1.50011C11.6677 1.50182 11.572 1.52306 11.4834 1.56255C11.3948 1.60204 11.315 1.65898 11.2488 1.72997L6.99067 5.98814L2.7325 1.72997C2.59553 1.60234 2.41437 1.53286 2.22718 1.53616C2.03999 1.53946 1.8614 1.61529 1.72901 1.74767C1.59663 1.88006 1.5208 2.05865 1.5175 2.24584C1.5142 2.43303 1.58368 2.61419 1.71131 2.75116L5.96948 7.00933L1.71131 11.2675C1.576 11.403 1.5 11.5866 1.5 11.7781C1.5 11.9696 1.576 12.1532 1.71131 12.2887C1.84679 12.424 2.03043 12.5 2.2219 12.5C2.41338 12.5 2.59702 12.424 2.7325 12.2887L6.99067 8.03052L11.2488 12.2887C11.3843 12.424 11.568 12.5 11.7594 12.5C11.9509 12.5 12.1346 12.424 12.27 12.2887C12.4053 12.1532 12.4813 11.9696 12.4813 11.7781C12.4813 11.5866 12.4053 11.403 12.27 11.2675L8.01186 7.00933Z",
      fill: "currentColor"
    }));
  }));
  TimesIcon.displayName = 'TimesIcon';

  var classes$14 = {
    root: function root(_ref) {
      var props = _ref.props,
        focusedState = _ref.focusedState,
        overlayVisibleState = _ref.overlayVisibleState,
        context = _ref.context;
      return classNames('p-cascadeselect p-component p-inputwrapper', {
        'p-disabled': props.disabled,
        'p-invalid': props.invalid,
        'p-variant-filled': props.variant ? props.variant === 'filled' : context && context.inputStyle === 'filled',
        'p-focus': focusedState,
        'p-inputwrapper-filled': props.value,
        'p-inputwrapper-focus': focusedState || overlayVisibleState
      });
    },
    label: function label(_ref2) {
      var props = _ref2.props,
        _label = _ref2.label;
      return classNames('p-cascadeselect-label ', {
        'p-placeholder': _label === props.placeholder,
        'p-cascadeselect-label-empty': !props.value && _label === 'p-emptylabel'
      });
    },
    list: 'p-cascadeselect-panel p-cascadeselect-items',
    sublistWrapper: 'p-cascadeselect-sublist-wrapper',
    sublist: 'p-cascadeselect-panel p-cascadeselect-items p-cascadeselect-sublist',
    item: function item(_ref3) {
      _ref3.option;
        var isGroup = _ref3.isGroup,
        isSelected = _ref3.isSelected;
      return classNames('p-cascadeselect-item', {
        'p-cascadeselect-item-group': isGroup,
        'p-cascadeselect-item-active p-highlight': isSelected
      });
    },
    dropdownIcon: 'p-cascadeselect-trigger-icon',
    clearIcon: 'p-cascadeselect-clear-icon p-clickable',
    loadingIcon: 'p-cascadeselect-trigger-icon',
    dropdownButton: 'p-cascadeselect-trigger',
    loadingButton: 'p-cascadeselect-trigger',
    wrapper: 'p-cascadeselect-items-wrapper',
    panel: 'p-cascadeselect-panel p-component',
    content: 'p-cascadeselect-item-content',
    optionGroupIcon: 'p-cascadeselect-group-icon',
    text: 'p-cascadeselect-item-text',
    transition: 'p-connected-overlay'
  };
  var styles$U = "\n@layer primereact {\n    .p-cascadeselect {\n        display: inline-flex;\n        cursor: pointer;\n        position: relative;\n        user-select: none;\n    }\n    \n    .p-cascadeselect-trigger {\n        display: flex;\n        align-items: center;\n        justify-content: center;\n        flex-shrink: 0;\n    }\n    \n    .p-cascadeselect-label {\n        display: block;\n        white-space: nowrap;\n        overflow: hidden;\n        flex: 1 1 auto;\n        width: 1%;\n        text-overflow: ellipsis;\n        cursor: pointer;\n    }\n    \n    .p-cascadeselect-label-empty {\n        overflow: hidden;\n        visibility: hidden;\n    }\n    \n    .p-cascadeselect .p-cascadeselect-panel {\n        min-width: 100%;\n    }\n    \n    .p-cascadeselect-item {\n        cursor: pointer;\n        font-weight: normal;\n        white-space: nowrap;\n    }\n    \n    .p-cascadeselect-item-content {\n        display: flex;\n        align-items: center;\n        overflow: hidden;\n        position: relative;\n    }\n    \n    .p-cascadeselect-group-icon {\n        margin-left: auto;\n    }\n    \n    .p-cascadeselect-items {\n        margin: 0;\n        padding: 0;\n        list-style-type: none;\n        min-width: 100%;\n    }\n    \n    .p-fluid .p-cascadeselect {\n        display: flex;\n    }\n    \n    .p-fluid .p-cascadeselect .p-cascadeselect-label {\n        width: 1%;\n    }\n    \n    .p-cascadeselect-sublist-wrapper {\n        position: absolute;\n        min-width: 100%;\n        z-index: 1;\n        display: none;\n    }\n    \n    .p-cascadeselect-item-active {\n        overflow: visible;\n    }\n    \n    .p-cascadeselect-item-active > .p-cascadeselect-sublist-wrapper {\n        display: block;\n        left: 100%;\n        top: 0;\n    }\n    .p-cascadeselect-clear-icon {\n        position: absolute;\n        top: 50%;\n        margin-top: -.5rem;\n        right: 3rem;\n    }\n}\n";
  var CascadeSelectBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'CascadeSelect',
      appendTo: null,
      ariaLabelledBy: null,
      autoFocus: false,
      breakpoint: undefined,
      className: null,
      dataKey: null,
      disabled: false,
      loadingIcon: null,
      dropdownIcon: null,
      loading: false,
      id: null,
      inputId: null,
      inputRef: null,
      invalid: false,
      variant: null,
      itemTemplate: null,
      name: null,
      onBeforeHide: null,
      onBeforeShow: null,
      onChange: null,
      onGroupChange: null,
      onHide: null,
      onShow: null,
      optionGroupChildren: null,
      optionGroupIcon: null,
      optionGroupLabel: null,
      optionLabel: null,
      optionValue: null,
      options: null,
      panelClassName: null,
      panelStyle: null,
      placeholder: null,
      scrollHeight: '400px',
      style: null,
      tabIndex: null,
      transitionOptions: null,
      value: null,
      children: undefined
    },
    css: {
      classes: classes$14,
      styles: styles$U
    }
  });

  var AngleRightIcon = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("path", {
      d: "M5.25 11.1728C5.14929 11.1694 5.05033 11.1455 4.9592 11.1025C4.86806 11.0595 4.78666 10.9984 4.72 10.9228C4.57955 10.7822 4.50066 10.5916 4.50066 10.3928C4.50066 10.1941 4.57955 10.0035 4.72 9.86283L7.72 6.86283L4.72 3.86283C4.66067 3.71882 4.64765 3.55991 4.68275 3.40816C4.71785 3.25642 4.79932 3.11936 4.91585 3.01602C5.03238 2.91268 5.17819 2.84819 5.33305 2.83149C5.4879 2.81479 5.64411 2.84671 5.78 2.92283L9.28 6.42283C9.42045 6.56346 9.49934 6.75408 9.49934 6.95283C9.49934 7.15158 9.42045 7.34221 9.28 7.48283L5.78 10.9228C5.71333 10.9984 5.63193 11.0595 5.5408 11.1025C5.44966 11.1455 5.35071 11.1694 5.25 11.1728Z",
      fill: "currentColor"
    }));
  }));
  AngleRightIcon.displayName = 'AngleRightIcon';

  function ownKeys$1I(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1I(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1I(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1I(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var CascadeSelectSub = /*#__PURE__*/React__namespace.memo(function (props) {
    var mergeProps = useMergeProps();
    var _React$useState = React__namespace.useState(null),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      activeOptionState = _React$useState2[0],
      setActiveOptionState = _React$useState2[1];
    var elementRef = React__namespace.useRef(null);
    var context = React__namespace.useContext(PrimeReactContext);
    var ptm = props.ptm,
      cx = props.cx;
    var getPTOptions = function getPTOptions(key, options) {
      return ptm(key, {
        hostName: props.hostName,
        state: _objectSpread$1I({}, options)
      });
    };
    var position = function position() {
      var parentItem = elementRef.current.parentElement.parentElement;
      var containerOffset = DomHandler.getOffset(parentItem);
      var viewport = DomHandler.getViewport();
      var sublistWidth = elementRef.current.offsetParent ? elementRef.current.offsetWidth : DomHandler.getHiddenElementOuterWidth(element);
      var itemOuterWidth = DomHandler.getOuterWidth(parentItem.children[0]);
      if (parseInt(containerOffset.left, 10) + itemOuterWidth + sublistWidth > viewport.width - DomHandler.calculateScrollbarWidth()) {
        elementRef.current.parentElement.style.left = '-100%';
      }
    };
    var onOptionSelect = function onOptionSelect(event) {
      props.onOptionSelect && props.onOptionSelect(event);
    };
    var _onKeyDown = function onKeyDown(event, option) {
      var listItem = event.currentTarget.parentElement;
      switch (event.key) {
        case 'Down':
        case 'ArrowDown':
          var nextItem = _findNextItem(listItem);
          if (nextItem) {
            nextItem.children[0].focus();
          }
          break;
        case 'Up':
        case 'ArrowUp':
          var prevItem = _findPrevItem(listItem);
          if (prevItem) {
            prevItem.children[0].focus();
          }
          break;
        case 'Right':
        case 'ArrowRight':
          if (isOptionGroup(option)) {
            if (activeOptionState === option) {
              listItem.children[1].children[0].children[0].focus();
            } else {
              setActiveOptionState(option);
            }
          }
          break;
        case 'Left':
        case 'ArrowLeft':
          setActiveOptionState(null);
          var parentList = event.currentTarget.parentElement.parentElement.previousElementSibling;
          if (parentList) {
            parentList.focus();
          }
          break;
        case 'Enter':
          onOptionClick(event, option);
          break;
        case 'Tab':
        case 'Escape':
          if (props.onPanelHide) {
            props.onPanelHide();
            event.preventDefault();
          }
          break;
      }
      event.preventDefault();
    };
    var _findNextItem = function findNextItem(item) {
      var nextItem = item.nextElementSibling;
      return nextItem ? DomHandler.hasClass(nextItem, 'p-disabled') || !DomHandler.hasClass(nextItem, 'p-cascadeselect-item') ? _findNextItem(nextItem) : nextItem : null;
    };
    var _findPrevItem = function findPrevItem(item) {
      var prevItem = item.previousElementSibling;
      return prevItem ? DomHandler.hasClass(prevItem, 'p-disabled') || !DomHandler.hasClass(prevItem, 'p-cascadeselect-item') ? _findPrevItem(prevItem) : prevItem : null;
    };
    var onOptionClick = function onOptionClick(event, option) {
      if (isOptionGroup(option)) {
        setActiveOptionState(function (prevActiveOption) {
          return prevActiveOption === option ? null : option;
        });
        if (props.onOptionGroupSelect) {
          props.onOptionGroupSelect({
            originalEvent: event,
            value: option
          });
        }
      } else if (props.onOptionSelect) {
        props.onOptionSelect({
          originalEvent: event,
          value: getOptionValue(option)
        });
      }
    };
    var onOptionGroupSelect = function onOptionGroupSelect(event) {
      props.onOptionGroupSelect && props.onOptionGroupSelect(event);
    };
    var getOptionLabel = function getOptionLabel(option) {
      return props.optionLabel ? ObjectUtils.resolveFieldData(option, props.optionLabel) : option;
    };
    var getOptionValue = function getOptionValue(option) {
      return props.optionValue ? ObjectUtils.resolveFieldData(option, props.optionValue) : option;
    };
    var getOptionGroupLabel = function getOptionGroupLabel(optionGroup) {
      return props.optionGroupLabel ? ObjectUtils.resolveFieldData(optionGroup, props.optionGroupLabel) : null;
    };
    var getOptionGroupChildren = function getOptionGroupChildren(optionGroup) {
      return ObjectUtils.resolveFieldData(optionGroup, props.optionGroupChildren[props.level]);
    };
    var isOptionGroup = function isOptionGroup(option) {
      return Object.prototype.hasOwnProperty.call(option, props.optionGroupChildren[props.level]);
    };
    var getOptionLabelToRender = function getOptionLabelToRender(option) {
      return isOptionGroup(option) ? getOptionGroupLabel(option) : getOptionLabel(option);
    };
    useMountEffect(function () {
      if (props.selectionPath && props.options && !props.dirty) {
        var activeOption = props.options.find(function (o) {
          return props.selectionPath.includes(o);
        });
        activeOption && setActiveOptionState(activeOption);
      }
      if (!props.root) {
        position();
      }
    });
    useUpdateEffect(function () {
      if (!props.parentActive) {
        setActiveOptionState(null);
      }
    }, [props.parentActive]);
    var createSubmenu = function createSubmenu(option) {
      if (isOptionGroup(option) && activeOptionState === option) {
        var options = getOptionGroupChildren(option);
        var parentActive = activeOptionState === option;
        var level = props.level + 1;
        return /*#__PURE__*/React__namespace.createElement(CascadeSelectSub, {
          hostName: props.hostName,
          options: options,
          className: cx('sublist'),
          selectionPath: props.selectionPath,
          optionLabel: props.optionLabel,
          optionValue: props.optionValue,
          level: level,
          onOptionSelect: onOptionSelect,
          onOptionGroupSelect: onOptionGroupSelect,
          parentActive: parentActive,
          optionGroupLabel: props.optionGroupLabel,
          optionGroupChildren: props.optionGroupChildren,
          dirty: props.dirty,
          template: props.template,
          onPanelHide: props.onPanelHide,
          ptm: ptm,
          cx: cx
        });
      }
      return null;
    };
    var createOption = function createOption(option, index) {
      var submenu = createSubmenu(option);
      var textProps = mergeProps({
        className: cx('text')
      }, getPTOptions('text'));
      var content = props.template ? ObjectUtils.getJSXElement(props.template, getOptionValue(option)) : /*#__PURE__*/React__namespace.createElement("span", textProps, getOptionLabelToRender(option));
      var optionGroupIconProps = mergeProps({
        className: cx('optionGroupIcon')
      }, getPTOptions('optionGroupIcon'));
      var icon = props.optionGroupIcon || /*#__PURE__*/React__namespace.createElement(AngleRightIcon, optionGroupIconProps);
      var optionGroup = isOptionGroup(option) && IconUtils.getJSXIcon(icon, _objectSpread$1I({}, optionGroupIconProps), {
        props: props
      });
      var key = getOptionLabelToRender(option) + '_' + index;
      var contentProps = mergeProps({
        className: cx('content'),
        onClick: function onClick(event) {
          return onOptionClick(event, option);
        },
        tabIndex: 0,
        onKeyDown: function onKeyDown(event) {
          return _onKeyDown(event, option);
        }
      }, getPTOptions('content'));
      var isSelected = activeOptionState === option;
      var isGroup = isOptionGroup(option);
      var itemProps = mergeProps({
        className: classNames(option.className, cx('item', {
          option: option,
          isGroup: isGroup,
          isSelected: isSelected
        })),
        style: option.style,
        role: 'none',
        'data-p-item-group': isGroup,
        'data-p-highlight': isSelected
      }, getPTOptions('item', {
        selected: isSelected,
        group: isGroup
      }));
      return /*#__PURE__*/React__namespace.createElement("li", _extends({
        key: key
      }, itemProps), /*#__PURE__*/React__namespace.createElement("div", contentProps, content, optionGroup, /*#__PURE__*/React__namespace.createElement(Ripple, null)), submenu);
    };
    var createMenu = function createMenu() {
      return props.options ? props.options.map(createOption) : null;
    };
    var createList = function createList() {
      var listProps = mergeProps({
        ref: elementRef,
        className: cx(props.level === 0 ? 'list' : 'sublist', {
          context: context
        }),
        role: 'listbox',
        'aria-orientation': 'horizontal'
      }, props.level === 0 ? getPTOptions('list') : getPTOptions('sublist'));
      var submenu = createMenu();
      return /*#__PURE__*/React__namespace.createElement("ul", listProps, submenu);
    };
    var createElement = function createElement() {
      var list = createList();
      var listWrapperProps = mergeProps({
        className: cx('sublistWrapper')
      }, getPTOptions('sublistWrapper'));
      return props.level === 0 ? list : /*#__PURE__*/React__namespace.createElement("div", listWrapperProps, list);
    };
    var element = createElement();
    return element;
  });

  function _createForOfIteratorHelper$d(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray$d(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t["return"] || t["return"](); } finally { if (u) throw o; } } }; }
  function _unsupportedIterableToArray$d(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray$d(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray$d(r, a) : void 0; } }
  function _arrayLikeToArray$d(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
  function ownKeys$1H(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1H(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1H(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1H(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var CascadeSelect = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var mergeProps = useMergeProps();
    var context = React__namespace.useContext(PrimeReactContext);
    var props = CascadeSelectBase.getProps(inProps, context);
    var _React$useState = React__namespace.useState(false),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      focusedState = _React$useState2[0],
      setFocusedState = _React$useState2[1];
    var _React$useState3 = React__namespace.useState(false),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      overlayVisibleState = _React$useState4[0],
      setOverlayVisibleState = _React$useState4[1];
    var _React$useState5 = React__namespace.useState(null),
      _React$useState6 = _slicedToArray(_React$useState5, 2),
      attributeSelectorState = _React$useState6[0],
      setAttributeSelectorState = _React$useState6[1];
    var _CascadeSelectBase$se = CascadeSelectBase.setMetaData({
        props: props,
        state: {
          focused: focusedState,
          overlayVisible: overlayVisibleState,
          attributeSelector: attributeSelectorState
        },
        context: _objectSpread$1H({}, context)
      }),
      ptm = _CascadeSelectBase$se.ptm,
      cx = _CascadeSelectBase$se.cx,
      isUnstyled = _CascadeSelectBase$se.isUnstyled;
    useHandleStyle(CascadeSelectBase.css.styles, isUnstyled, {
      name: 'cascadeselect'
    });
    var elementRef = React__namespace.useRef(null);
    var overlayRef = React__namespace.useRef(null);
    var inputRef = React__namespace.useRef(null);
    var labelRef = React__namespace.useRef(null);
    var styleElementRef = React__namespace.useRef(null);
    var dirty = React__namespace.useRef(false);
    var selectionPath = React__namespace.useRef(null);
    var selfChange = React__namespace.useRef(null);
    var _useOverlayListener = useOverlayListener({
        target: elementRef,
        overlay: overlayRef,
        listener: function listener(event, _ref) {
          var valid = _ref.valid,
            type = _ref.type;
          if (valid) {
            if (context.hideOverlaysOnDocumentScrolling || type === 'outside') {
              hide();
            } else if (!DomHandler.isDocument(event.target)) {
              alignOverlay();
            }
          }
        },
        when: overlayVisibleState
      }),
      _useOverlayListener2 = _slicedToArray(_useOverlayListener, 2),
      bindOverlayListener = _useOverlayListener2[0],
      unbindOverlayListener = _useOverlayListener2[1];
    var cascadeSelectOverlayDisplayOrder = useDisplayOrder('cascade-select', overlayVisibleState);
    useGlobalOnEscapeKey({
      callback: function callback() {
        hide();
      },
      when: overlayVisibleState && cascadeSelectOverlayDisplayOrder,
      priority: [ESC_KEY_HANDLING_PRIORITIES.CASCADE_SELECT, cascadeSelectOverlayDisplayOrder]
    });
    var onOptionSelect = function onOptionSelect(event) {
      if (props.onChange) {
        selfChange.current = true;
        props.onChange({
          originalEvent: event,
          value: event.value
        });
      }
      updateSelectionPath();
      hide();
      DomHandler.focus(inputRef.current);
    };
    var onOptionGroupSelect = function onOptionGroupSelect(event) {
      dirty.current = true;
      props.onGroupChange && props.onGroupChange(event);
    };
    var getOptionLabel = function getOptionLabel(option) {
      var label = props.optionLabel ? ObjectUtils.resolveFieldData(option, props.optionLabel) : option;
      return label || option;
    };
    var getOptionValue = function getOptionValue(option) {
      return props.optionValue ? ObjectUtils.resolveFieldData(option, props.optionValue) : option;
    };
    var getOptionGroupChildren = function getOptionGroupChildren(optionGroup, level) {
      return ObjectUtils.resolveFieldData(optionGroup, props.optionGroupChildren[level]);
    };
    var isOptionGroup = function isOptionGroup(option, level) {
      return Object.prototype.hasOwnProperty.call(option, props.optionGroupChildren[level]);
    };
    var updateSelectionPath = function updateSelectionPath() {
      var path;
      if (props.value != null && props.options) {
        var _iterator = _createForOfIteratorHelper$d(props.options),
          _step;
        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var option = _step.value;
            path = _findModelOptionInGroup(option, 0);
            if (path) {
              break;
            }
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }
      }
      selectionPath.current = path;
    };
    var _findModelOptionInGroup = function findModelOptionInGroup(option, level) {
      if (isOptionGroup(option, level)) {
        var selectedOption;
        var _iterator2 = _createForOfIteratorHelper$d(getOptionGroupChildren(option, level)),
          _step2;
        try {
          for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
            var childOption = _step2.value;
            selectedOption = _findModelOptionInGroup(childOption, level + 1);
            if (selectedOption) {
              selectedOption.unshift(option);
              return selectedOption;
            }
          }
        } catch (err) {
          _iterator2.e(err);
        } finally {
          _iterator2.f();
        }
      } else if (ObjectUtils.equals(props.value, getOptionValue(option), props.dataKey)) {
        return [option];
      }
      return null;
    };
    var _onClick = function onClick(event) {
      if (props.disabled || props.loading) {
        return;
      }
      if (!overlayRef.current || !overlayRef.current.contains(event.target)) {
        DomHandler.focus(inputRef.current);
        overlayVisibleState ? hide() : show();
      }
    };
    var onInputFocus = function onInputFocus() {
      setFocusedState(true);
    };
    var onInputBlur = function onInputBlur() {
      setFocusedState(false);
    };
    var onInputKeyDown = function onInputKeyDown(event) {
      switch (event.which) {
        //down
        case 40:
          if (overlayVisibleState) {
            DomHandler.findSingle(overlayRef.current, '[data-pc-section="item"]').children[0].focus();
          } else if (event.altKey && props.options && props.options.length) {
            show();
          }
          event.preventDefault();
          break;

        //space
        case 32:
          overlayVisibleState ? hide() : show();
          event.preventDefault();
          break;

        //tab
        case 9:
          hide();
          break;
      }
    };
    var onPanelClick = function onPanelClick(event) {
      OverlayService.emit('overlay-click', {
        originalEvent: event,
        target: elementRef.current
      });
    };
    var show = function show() {
      props.onBeforeShow && props.onBeforeShow();
      setOverlayVisibleState(true);
    };
    var hide = function hide() {
      props.onBeforeHide && props.onBeforeHide();
      setOverlayVisibleState(false);
      DomHandler.focus(inputRef.current);
    };
    var onOverlayEnter = function onOverlayEnter() {
      ZIndexUtils.set('overlay', overlayRef.current, context && context.autoZIndex || PrimeReact.autoZIndex, context && context.zIndex.overlay || PrimeReact.zIndex.overlay);
      DomHandler.addStyles(overlayRef.current, {
        position: 'absolute',
        top: '0',
        left: '0'
      });
      alignOverlay();
      if (attributeSelectorState && props.breakpoint) {
        overlayRef.current.setAttribute(attributeSelectorState + '_panel', '');
        createStyle();
      }
    };
    var onOverlayEntered = function onOverlayEntered() {
      bindOverlayListener();
      props.onShow && props.onShow();
    };
    var onOverlayExit = function onOverlayExit() {
      unbindOverlayListener();
      dirty.current = false;
    };
    var onOverlayExited = function onOverlayExited() {
      ZIndexUtils.clear(overlayRef.current);
      props.onHide && props.onHide();
      destroyStyle();
    };
    var alignOverlay = function alignOverlay() {
      DomHandler.alignOverlay(overlayRef.current, labelRef.current.parentElement, props.appendTo || context && context.appendTo || PrimeReact.appendTo);
    };
    var createStyle = function createStyle() {
      if (!styleElementRef.current) {
        styleElementRef.current = DomHandler.createInlineStyle(context && context.nonce || PrimeReact.nonce, context && context.styleContainer);
        var selector = "".concat(attributeSelectorState, "_panel");
        var innerHTML = "\n@media screen and (max-width: ".concat(props.breakpoint, ") {\n    .p-cascadeselect-panel[").concat(selector, "] .p-cascadeselect-items-wrapper > ul {\n        max-height: ").concat(props.scrollHeight, ";\n        overflow: ").concat(props.scrollHeight ? 'auto' : '', ";\n    }\n\n    .p-cascadeselect-panel[").concat(selector, "] .p-cascadeselect-sublist-wrapper {\n        position:relative;\n        left:0 !important;\n    }\n\n    .p-cascadeselect-panel[").concat(selector, "] .p-cascadeselect-sublist {\n        overflow: hidden !important;\n    }\n\n    .p-cascadeselect-panel[").concat(selector, "] .p-cascadeselect-item-active  .p-cascadeselect-sublist {\n        left: 0;\n        box-shadow: none;\n        border-radius: 0;\n        padding: 0 0 0 calc(var(--inline-spacing) * 2); /* @todo */\n    }\n\n    .p-cascadeselect-panel[").concat(selector, "] .p-cascadeselect-group-icon:before {\n        content: \"\\e930\";\n    }\n}\n");
        styleElementRef.current.innerHTML = innerHTML;
      }
    };
    var destroyStyle = function destroyStyle() {
      styleElementRef.current = DomHandler.removeInlineStyle(styleElementRef.current);
    };
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        getElement: function getElement() {
          return elementRef.current;
        },
        getOverlay: function getOverlay() {
          return overlayRef.current;
        },
        getInput: function getInput() {
          return inputRef.current;
        },
        getLabel: function getLabel() {
          return labelRef.current;
        },
        focus: function focus() {
          return DomHandler.focus(inputRef.current);
        }
      };
    });
    useMountEffect(function () {
      if (props.breakpoint) {
        !attributeSelectorState && setAttributeSelectorState(UniqueComponentId());
      }
      if (props.autoFocus) {
        DomHandler.focus(inputRef.current, props.autoFocus);
      }
      alignOverlay();
    });
    React__namespace.useEffect(function () {
      ObjectUtils.combinedRefs(inputRef, props.inputRef);
    }, [inputRef, props.inputRef]);
    useUpdateEffect(function () {
      updateSelectionPath();
    }, [props.value]);
    useUnmountEffect(function () {
      ZIndexUtils.clear(overlayRef.current);
    });
    var createKeyboardHelper = function createKeyboardHelper() {
      var value = props.value ? getOptionLabel(props.value) : undefined;
      var hiddenSelectedMessageProps = mergeProps({
        className: 'p-hidden-accessible'
      }, ptm('hiddenSelectedMessage'));
      var inputProps = mergeProps(_objectSpread$1H({
        ref: inputRef,
        type: 'text',
        id: props.inputId,
        name: props.name,
        defaultValue: value,
        readOnly: true,
        disabled: props.disabled,
        onFocus: onInputFocus,
        onBlur: onInputBlur,
        onKeyDown: function onKeyDown(e) {
          return onInputKeyDown(e);
        },
        tabIndex: props.tabIndex,
        'aria-haspopup': 'listbox'
      }, ariaProps), ptm('input'));
      return /*#__PURE__*/React__namespace.createElement("div", hiddenSelectedMessageProps, /*#__PURE__*/React__namespace.createElement("input", inputProps));
    };
    var clear = function clear(event) {
      if (props.onChange) {
        selfChange.current = true;
        props.onChange({
          originalEvent: event,
          value: undefined,
          stopPropagation: function stopPropagation() {
            event === null || event === void 0 || event.stopPropagation();
          },
          preventDefault: function preventDefault() {
            event === null || event === void 0 || event.preventDefault();
          },
          target: {
            name: props.name,
            id: props.id,
            value: undefined
          }
        });
      }
    };
    var onClearIconKeyDown = function onClearIconKeyDown(event) {
      if (event.key === 'Enter' || event.code === 'Space') {
        clear(event);
        event.preventDefault();
      }
    };
    var createClearIcon = function createClearIcon() {
      if (props.value != null && props.showClear && !props.disabled) {
        var clearIconProps = mergeProps({
          className: cx('clearIcon'),
          onPointerUp: clear,
          tabIndex: props.tabIndex || '0',
          onKeyDown: onClearIconKeyDown,
          'aria-label': localeOption('clear')
        }, ptm('clearIcon'));
        var icon = props.clearIcon || /*#__PURE__*/React__namespace.createElement(TimesIcon, clearIconProps);
        return IconUtils.getJSXIcon(icon, _objectSpread$1H({}, clearIconProps), {
          props: props
        });
      }
      return null;
    };
    var createLabel = function createLabel() {
      var label = props.value ? getOptionLabel(props.value) : props.placeholder || 'p-emptylabel';
      var labelProps = mergeProps({
        ref: labelRef,
        className: cx('label', {
          label: label
        })
      }, ptm('label', {
        context: _objectSpread$1H({
          label: label
        }, context)
      }));
      return /*#__PURE__*/React__namespace.createElement("span", labelProps, label);
    };
    var createLoadingIcon = function createLoadingIcon() {
      var loadingIconProps = mergeProps({
        className: cx('loadingIcon')
      }, ptm('loadingIcon'));
      var icon = props.loadingIcon || /*#__PURE__*/React__namespace.createElement(SpinnerIcon, {
        spin: true
      });
      var loadingIcon = IconUtils.getJSXIcon(icon, _objectSpread$1H({}, loadingIconProps), {
        props: props
      });
      var loadingButtonProps = mergeProps({
        className: cx('loadingButton'),
        role: 'button',
        'aria-haspopup': 'listbox',
        'aria-expanded': overlayVisibleState
      }, ptm('dropdownButton'));
      return /*#__PURE__*/React__namespace.createElement("div", loadingButtonProps, loadingIcon);
    };
    var createDropdownIcon = function createDropdownIcon() {
      var dropdownIconProps = mergeProps({
        className: cx('dropdownIcon')
      }, ptm('dropdownIcon'));
      var icon = props.dropdownIcon || /*#__PURE__*/React__namespace.createElement(ChevronDownIcon, dropdownIconProps);
      var dropdownIcon = IconUtils.getJSXIcon(icon, _objectSpread$1H({}, dropdownIconProps), {
        props: props
      });
      var dropdownButtonProps = mergeProps({
        className: cx('dropdownButton'),
        role: 'button',
        'aria-haspopup': 'listbox',
        'aria-expanded': overlayVisibleState
      }, ptm('dropdownButton'));
      return /*#__PURE__*/React__namespace.createElement("div", dropdownButtonProps, dropdownIcon);
    };
    var wrapperProps = mergeProps({
      className: cx('wrapper')
    }, ptm('wrapper'));
    var panelProps = mergeProps({
      ref: overlayRef,
      className: classNames(props.panelClassName, cx('panel')),
      style: props.panelStyle,
      onClick: function onClick(e) {
        return onPanelClick(e);
      }
    }, ptm('panel'));
    var createOverlay = function createOverlay() {
      var transitionProps = mergeProps({
        classNames: cx('transition'),
        "in": overlayVisibleState,
        timeout: {
          enter: 120,
          exit: 100
        },
        options: props.transitionOptions,
        unmountOnExit: true,
        onEnter: onOverlayEnter,
        onEntered: onOverlayEntered,
        onExit: onOverlayExit,
        onExited: onOverlayExited
      }, ptm('transition'));
      var overlay = /*#__PURE__*/React__namespace.createElement(CSSTransition, _extends({
        nodeRef: overlayRef
      }, transitionProps), /*#__PURE__*/React__namespace.createElement("div", panelProps, /*#__PURE__*/React__namespace.createElement("div", wrapperProps, /*#__PURE__*/React__namespace.createElement(CascadeSelectSub, {
        hostName: "CascadeSelect",
        options: props.options,
        selectionPath: selectionPath.current,
        optionGroupIcon: props.optionGroupIcon,
        optionLabel: props.optionLabel,
        optionValue: props.optionValue,
        parentActive: props.value != null,
        level: 0,
        optionGroupLabel: props.optionGroupLabel,
        optionGroupChildren: props.optionGroupChildren,
        onOptionSelect: onOptionSelect,
        onOptionGroupSelect: onOptionGroupSelect,
        root: true,
        template: props.itemTemplate,
        onPanelHide: hide,
        ptm: ptm,
        cx: cx
      }))));
      return /*#__PURE__*/React__namespace.createElement(Portal, {
        element: overlay,
        appendTo: props.appendTo
      });
    };
    var createElement = function createElement() {
      var keyboardHelper = createKeyboardHelper();
      var labelElement = createLabel();
      var clearIcon = createClearIcon();
      var dropdownIcon = props.loading ? createLoadingIcon() : createDropdownIcon();
      var overlay = createOverlay();
      var rootProps = mergeProps({
        id: props.id,
        ref: elementRef,
        className: classNames(props.className, cx('root', {
          focusedState: focusedState,
          overlayVisibleState: overlayVisibleState,
          context: context
        })),
        style: props.style,
        onClick: function onClick(e) {
          return _onClick(e);
        }
      }, otherProps, ptm('root'));
      return /*#__PURE__*/React__namespace.createElement("div", rootProps, keyboardHelper, labelElement, clearIcon, dropdownIcon, overlay);
    };
    var otherProps = CascadeSelectBase.getOtherProps(props);
    ObjectUtils.reduceKeys(otherProps, DomHandler.DATA_PROPS);
    var ariaProps = ObjectUtils.reduceKeys(otherProps, DomHandler.ARIA_PROPS);
    var element = createElement();
    return element;
  }));
  CascadeSelect.displayName = 'CascadeSelect';

  var ChartBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'Chart',
      id: null,
      type: null,
      data: null,
      options: null,
      plugins: null,
      width: null,
      height: null,
      style: null,
      className: null,
      children: undefined
    },
    css: {
      classes: {
        root: 'p-chart'
      },
      inlineStyles: {
        root: function root(_ref) {
          var props = _ref.props;
          return Object.assign({
            width: props.width,
            height: props.height
          }, props.style);
        }
      },
      styles: "\n        @layer primereact {\n            .p-chart {\n                position: relative\n            }\n        }\n        "
    }
  });

  // GitHub #3059 wrapper if loaded by script tag
  var ChartJS = function () {
    try {
      return Chart;
    } catch (_unused) {
      return null;
    }
  }();
  var PrimeReactChart = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var mergeProps = useMergeProps();
    var context = React__namespace.useContext(PrimeReactContext);
    var props = ChartBase.getProps(inProps, context);
    var _ChartBase$setMetaDat = ChartBase.setMetaData({
        props: props
      }),
      ptm = _ChartBase$setMetaDat.ptm,
      cx = _ChartBase$setMetaDat.cx,
      sx = _ChartBase$setMetaDat.sx,
      isUnstyled = _ChartBase$setMetaDat.isUnstyled;
    useHandleStyle(ChartBase.css.styles, isUnstyled, {
      name: 'chart'
    });
    var elementRef = React__namespace.useRef(null);
    var chartRef = React__namespace.useRef(null);
    var canvasRef = React__namespace.useRef(null);
    var initChart = function initChart() {
      destroyChart();
      var configuration = {
        type: props.type,
        data: props.data,
        options: props.options,
        plugins: props.plugins
      };
      if (ChartJS) {
        // GitHub #3059 loaded by script only
        chartRef.current = new ChartJS(canvasRef.current, configuration);
      } else {
        import('chart.js/auto').then(function (module) {
          destroyChart();

          // In case that the Chart component has been unmounted during asynchronous loading of ChartJS,
          // the canvasRef will not be available anymore, and no Chart should be created.
          if (!canvasRef.current) {
            return;
          }
          if (module) {
            if (module["default"]) {
              // WebPack
              chartRef.current = new module["default"](canvasRef.current, configuration);
            } else {
              // ParcelJS
              chartRef.current = new module(canvasRef.current, configuration);
            }
          }
        });
      }
    };
    var destroyChart = function destroyChart() {
      if (chartRef.current) {
        chartRef.current.destroy();
        chartRef.current = null;
      }
    };
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        getCanvas: function getCanvas() {
          return canvasRef.current;
        },
        getChart: function getChart() {
          return chartRef.current;
        },
        getBase64Image: function getBase64Image() {
          return chartRef.current.toBase64Image();
        },
        getElement: function getElement() {
          return elementRef.current;
        },
        generateLegend: function generateLegend() {
          return chartRef.current && chartRef.current.generateLegend();
        },
        refresh: function refresh() {
          return chartRef.current && chartRef.current.update();
        }
      };
    });
    React__namespace.useEffect(function () {
      initChart();
    });
    useUnmountEffect(function () {
      destroyChart();
    });
    var title = props.options && props.options.plugins && props.options.plugins.title && props.options.plugins.title.text;
    var ariaLabel = props.ariaLabel || title;
    var rootProps = mergeProps({
      id: props.id,
      ref: elementRef,
      style: sx('root'),
      className: classNames(props.className, cx('root'))
    }, ChartBase.getOtherProps(props), ptm('root'));
    var canvasProps = mergeProps({
      ref: canvasRef,
      width: props.width,
      height: props.height,
      role: 'img',
      'aria-label': ariaLabel
    }, ptm('canvas'));
    return /*#__PURE__*/React__namespace.createElement("div", rootProps, /*#__PURE__*/React__namespace.createElement("canvas", canvasProps));
  }), function (prevProps, nextProps) {
    return prevProps.data === nextProps.data && prevProps.options === nextProps.options && prevProps.type === nextProps.type;
  });
  PrimeReactChart.displayName = 'Chart';

  var CheckIcon = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("path", {
      d: "M4.86199 11.5948C4.78717 11.5923 4.71366 11.5745 4.64596 11.5426C4.57826 11.5107 4.51779 11.4652 4.46827 11.4091L0.753985 7.69483C0.683167 7.64891 0.623706 7.58751 0.580092 7.51525C0.536478 7.44299 0.509851 7.36177 0.502221 7.27771C0.49459 7.19366 0.506156 7.10897 0.536046 7.03004C0.565935 6.95111 0.613367 6.88 0.674759 6.82208C0.736151 6.76416 0.8099 6.72095 0.890436 6.69571C0.970973 6.67046 1.05619 6.66385 1.13966 6.67635C1.22313 6.68886 1.30266 6.72017 1.37226 6.76792C1.44186 6.81567 1.4997 6.8786 1.54141 6.95197L4.86199 10.2503L12.6397 2.49483C12.7444 2.42694 12.8689 2.39617 12.9932 2.40745C13.1174 2.41873 13.2343 2.47141 13.3251 2.55705C13.4159 2.64268 13.4753 2.75632 13.4938 2.87973C13.5123 3.00315 13.4888 3.1292 13.4271 3.23768L5.2557 11.4091C5.20618 11.4652 5.14571 11.5107 5.07801 11.5426C5.01031 11.5745 4.9368 11.5923 4.86199 11.5948Z",
      fill: "currentColor"
    }));
  }));
  CheckIcon.displayName = 'CheckIcon';

  var classes$13 = {
    box: 'p-checkbox-box',
    input: 'p-checkbox-input',
    icon: 'p-checkbox-icon',
    root: function root(_ref) {
      var props = _ref.props,
        checked = _ref.checked,
        context = _ref.context;
      return classNames('p-checkbox p-component', {
        'p-highlight': checked,
        'p-disabled': props.disabled,
        'p-invalid': props.invalid,
        'p-variant-filled': props.variant ? props.variant === 'filled' : context && context.inputStyle === 'filled'
      });
    }
  };
  var CheckboxBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'Checkbox',
      autoFocus: false,
      checked: false,
      className: null,
      disabled: false,
      falseValue: false,
      icon: null,
      id: null,
      inputId: null,
      inputRef: null,
      invalid: false,
      variant: null,
      name: null,
      onChange: null,
      onContextMenu: null,
      onMouseDown: null,
      readOnly: false,
      required: false,
      style: null,
      tabIndex: null,
      tooltip: null,
      tooltipOptions: null,
      trueValue: true,
      value: null,
      children: undefined
    },
    css: {
      classes: classes$13
    }
  });

  function ownKeys$1G(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1G(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1G(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1G(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var Checkbox = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var mergeProps = useMergeProps();
    var context = React__namespace.useContext(PrimeReactContext);
    var props = CheckboxBase.getProps(inProps, context);
    var _React$useState = React__namespace.useState(false),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      focusedState = _React$useState2[0],
      setFocusedState = _React$useState2[1];
    var _CheckboxBase$setMeta = CheckboxBase.setMetaData({
        props: props,
        state: {
          focused: focusedState
        },
        context: {
          checked: props.checked === props.trueValue,
          disabled: props.disabled
        }
      }),
      ptm = _CheckboxBase$setMeta.ptm,
      cx = _CheckboxBase$setMeta.cx,
      isUnstyled = _CheckboxBase$setMeta.isUnstyled;
    useHandleStyle(CheckboxBase.css.styles, isUnstyled, {
      name: 'checkbox'
    });
    var elementRef = React__namespace.useRef(null);
    var inputRef = React__namespace.useRef(props.inputRef);
    var isChecked = function isChecked() {
      return props.checked === props.trueValue;
    };
    var _onChange = function onChange(event) {
      if (props.disabled || props.readOnly) {
        return;
      }
      if (props.onChange) {
        var _props$onChange;
        var _checked = isChecked();
        var value = _checked ? props.falseValue : props.trueValue;
        var eventData = {
          originalEvent: event,
          value: props.value,
          checked: value,
          stopPropagation: function stopPropagation() {
            event === null || event === void 0 || event.stopPropagation();
          },
          preventDefault: function preventDefault() {
            event === null || event === void 0 || event.preventDefault();
          },
          target: {
            type: 'checkbox',
            name: props.name,
            id: props.id,
            value: props.value,
            checked: value
          }
        };
        props === null || props === void 0 || (_props$onChange = props.onChange) === null || _props$onChange === void 0 || _props$onChange.call(props, eventData);

        // do not continue if the user defined click wants to prevent
        if (event.defaultPrevented) {
          return;
        }
        DomHandler.focus(inputRef.current);
      }
    };
    var _onFocus = function onFocus(event) {
      var _props$onFocus;
      setFocusedState(true);
      props === null || props === void 0 || (_props$onFocus = props.onFocus) === null || _props$onFocus === void 0 || _props$onFocus.call(props, event);
    };
    var _onBlur = function onBlur(event) {
      var _props$onBlur;
      setFocusedState(false);
      props === null || props === void 0 || (_props$onBlur = props.onBlur) === null || _props$onBlur === void 0 || _props$onBlur.call(props, event);
    };
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        focus: function focus() {
          return DomHandler.focus(inputRef.current);
        },
        getElement: function getElement() {
          return elementRef.current;
        },
        getInput: function getInput() {
          return inputRef.current;
        }
      };
    });
    React__namespace.useEffect(function () {
      ObjectUtils.combinedRefs(inputRef, props.inputRef);
    }, [inputRef, props.inputRef]);
    useUpdateEffect(function () {
      inputRef.current.checked = isChecked();
    }, [props.checked, props.trueValue]);
    useMountEffect(function () {
      if (props.autoFocus) {
        DomHandler.focus(inputRef.current, props.autoFocus);
      }
    });
    var checked = isChecked();
    var hasTooltip = ObjectUtils.isNotEmpty(props.tooltip);
    var otherProps = CheckboxBase.getOtherProps(props);
    var rootProps = mergeProps({
      id: props.id,
      className: classNames(props.className, cx('root', {
        checked: checked,
        context: context
      })),
      style: props.style,
      'data-p-highlight': checked,
      'data-p-disabled': props.disabled,
      onContextMenu: props.onContextMenu,
      onMouseDown: props.onMouseDown
    }, otherProps, ptm('root'));
    var createInputElement = function createInputElement() {
      var ariaProps = ObjectUtils.reduceKeys(otherProps, DomHandler.ARIA_PROPS);
      var inputProps = mergeProps(_objectSpread$1G({
        id: props.inputId,
        type: 'checkbox',
        className: cx('input'),
        name: props.name,
        tabIndex: props.tabIndex,
        onFocus: function onFocus(e) {
          return _onFocus(e);
        },
        onBlur: function onBlur(e) {
          return _onBlur(e);
        },
        onChange: function onChange(e) {
          return _onChange(e);
        },
        disabled: props.disabled,
        readOnly: props.readOnly,
        required: props.required,
        'aria-invalid': props.invalid,
        checked: checked
      }, ariaProps), ptm('input'));
      return /*#__PURE__*/React__namespace.createElement("input", _extends({
        ref: inputRef
      }, inputProps));
    };
    var createBoxElement = function createBoxElement() {
      var iconProps = mergeProps({
        className: cx('icon')
      }, ptm('icon'));
      var boxProps = mergeProps({
        className: cx('box', {
          checked: checked
        }),
        'data-p-highlight': checked,
        'data-p-disabled': props.disabled
      }, ptm('box'));
      var icon = checked ? props.icon || /*#__PURE__*/React__namespace.createElement(CheckIcon, iconProps) : null;
      var checkboxIcon = IconUtils.getJSXIcon(icon, _objectSpread$1G({}, iconProps), {
        props: props,
        checked: checked
      });
      return /*#__PURE__*/React__namespace.createElement("div", boxProps, checkboxIcon);
    };
    return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, null, /*#__PURE__*/React__namespace.createElement("div", _extends({
      ref: elementRef
    }, rootProps), createInputElement(), createBoxElement()), hasTooltip && /*#__PURE__*/React__namespace.createElement(Tooltip, _extends({
      target: elementRef,
      content: props.tooltip,
      pt: ptm('tooltip')
    }, props.tooltipOptions)));
  }));
  Checkbox.displayName = 'Checkbox';

  var classes$12 = {
    root: function root(_ref) {
      var props = _ref.props;
      return classNames('p-chip p-component', {
        'p-chip-image': props.image != null
      });
    },
    removeIcon: 'p-chip-remove-icon',
    icon: 'p-chip-icon',
    label: 'p-chip-text'
  };
  var styles$T = "\n@layer primereact {\n    .p-chip {\n        display: inline-flex;\n        align-items: center;\n    }\n    \n    .p-chip-text {\n        line-height: 1.5;\n    }\n    \n    .p-chip-icon.pi {\n        line-height: 1.5;\n    }\n    \n    .p-chip .p-chip-remove-icon {\n        line-height: 1.5;\n        cursor: pointer;\n    }\n    \n    .p-chip img {\n        border-radius: 50%;\n    }\n}\n";
  var ChipBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'Chip',
      label: null,
      icon: null,
      image: null,
      removable: false,
      removeIcon: null,
      className: null,
      style: null,
      template: null,
      imageAlt: 'chip',
      onImageError: null,
      onRemove: null,
      children: undefined
    },
    css: {
      classes: classes$12,
      styles: styles$T
    }
  });

  function ownKeys$1F(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1F(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1F(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1F(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var Chip = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var mergeProps = useMergeProps();
    var context = React__namespace.useContext(PrimeReactContext);
    var props = ChipBase.getProps(inProps, context);
    var elementRef = React__namespace.useRef(null);
    var _React$useState = React__namespace.useState(true),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      visibleState = _React$useState2[0],
      setVisibleState = _React$useState2[1];
    var _React$useState3 = React__namespace.useState(props.id),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      idState = _React$useState4[0],
      setIdState = _React$useState4[1];
    var _ChipBase$setMetaData = ChipBase.setMetaData({
        props: props
      }),
      ptm = _ChipBase$setMetaData.ptm,
      cx = _ChipBase$setMetaData.cx,
      isUnstyled = _ChipBase$setMetaData.isUnstyled;
    useHandleStyle(ChipBase.css.styles, isUnstyled, {
      name: 'chip'
    });
    var onKeyDown = function onKeyDown(event) {
      if (event.code === 'Enter' || event.code === 'NumpadEnter' || event.code === 'Backspace') {
        close(event);
      }
    };
    var close = function close(event) {
      var result = true;
      if (props.onRemove) {
        event.stopPropagation();
        result = props.onRemove({
          originalEvent: event,
          value: props.label || props.image || props.icon
        });
      }
      if (result !== false) {
        setVisibleState(false);
      }
    };
    var createContent = function createContent() {
      var content = [];
      var removeIconProps = mergeProps({
        role: 'button',
        tabIndex: 0,
        className: cx('removeIcon'),
        onClick: close,
        onKeyDown: onKeyDown
      }, ptm('removeIcon'));
      var icon = props.removeIcon || /*#__PURE__*/React__namespace.createElement(TimesCircleIcon, _extends({}, removeIconProps, {
        key: "".concat(idState, "-removeIcon")
      }));
      if (props.image) {
        var imageProps = mergeProps({
          src: props.image,
          onError: props.onImageError
        }, ptm('image'));
        content.push(/*#__PURE__*/React__namespace.createElement("img", _extends({
          alt: props.imageAlt
        }, imageProps, {
          key: "".concat(idState, "-image")
        })));
      } else if (props.icon) {
        var chipIconProps = mergeProps({
          className: cx('icon')
        }, ptm('icon'));
        content.push(IconUtils.getJSXIcon(props.icon, _objectSpread$1F({}, chipIconProps), {
          props: props
        }));
      }
      if (props.label) {
        var labelProps = mergeProps({
          className: cx('label')
        }, ptm('label'));
        content.push(/*#__PURE__*/React__namespace.createElement("span", _extends({}, labelProps, {
          key: UniqueComponentId('label')
        }), props.label));
      }
      if (props.removable) {
        content.push(IconUtils.getJSXIcon(icon, _objectSpread$1F({}, removeIconProps), {
          props: props
        }));
      }
      return content;
    };
    var createElement = function createElement() {
      var content = props.template ? ObjectUtils.getJSXElement(props.template, props) : createContent();
      var rootProps = mergeProps({
        ref: elementRef,
        style: props.style,
        className: classNames(props.className, cx('root')),
        'aria-label': props.label
      }, ChipBase.getOtherProps(props), ptm('root'));
      return /*#__PURE__*/React__namespace.createElement("div", _extends({}, rootProps, {
        key: UniqueComponentId('chip')
      }), content);
    };
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        getVisible: function getVisible() {
          return visibleState;
        },
        setVisible: function setVisible(visible) {
          return setVisibleState(visible);
        },
        getElement: function getElement() {
          return elementRef.current;
        }
      };
    });
    useMountEffect(function () {
      if (!idState) {
        setIdState(UniqueComponentId());
      }
    });
    if (!idState) {
      return null;
    }
    return visibleState && createElement();
  }));
  Chip.displayName = 'Chip';

  var styles$S = "\n@layer primereact {\n    .p-chips {\n        display: inline-flex;\n    }\n    \n    .p-chips-multiple-container {\n        margin: 0;\n        padding: 0;\n        list-style-type: none;\n        cursor: text;\n        overflow: hidden;\n        display: flex;\n        align-items: center;\n        flex-wrap: wrap;\n    }\n    \n    .p-chips-token {\n        cursor: default;\n        display: inline-flex;\n        align-items: center;\n        flex: 0 0 auto;\n    }\n    \n    .p-chips-input-token {\n        flex: 1 1 auto;\n        display: inline-flex;\n    }\n    \n    .p-chips-token-icon {\n        cursor: pointer;\n    }\n    \n    .p-chips-input-token input {\n        border: 0 none;\n        outline: 0 none;\n        background-color: transparent;\n        margin: 0;\n        padding: 0;\n        box-shadow: none;\n        border-radius: 0;\n        width: 100%;\n    }\n    \n    .p-fluid .p-chips {\n        display: flex;\n    }\n    \n    .p-chips-icon-left,\n    .p-chips-icon-right {\n        position: relative;\n        display: inline-block;\n    }\n    \n    .p-chips-icon-left > i,\n    .p-chips-icon-right > i,\n    .p-chips-icon-left > svg,\n    .p-chips-icon-right > svg,\n    .p-chips-icon-left > .p-chips-prefix,\n    .p-chips-icon-right > .p-chips-suffix {\n        position: absolute;\n        top: 50%;\n        margin-top: -0.5rem;\n    }\n    \n    .p-fluid .p-chips-icon-left,\n    .p-fluid .p-chips-icon-right {\n        display: block;\n        width: 100%;\n    }\n}\n";
  var classes$11 = {
    removeTokenIcon: 'p-chips-token-icon',
    label: 'p-chips-token-label',
    token: function token(_ref) {
      var focusedIndex = _ref.focusedIndex,
        index = _ref.index;
      return classNames('p-chips-token', {
        'p-focus': focusedIndex === index
      });
    },
    inputToken: 'p-chips-input-token',
    container: function container(_ref2) {
      var props = _ref2.props,
        context = _ref2.context;
      return classNames('p-inputtext p-chips-multiple-container', {
        'p-variant-filled': props.variant ? props.variant === 'filled' : context && context.inputStyle === 'filled'
      });
    },
    root: function root(_ref3) {
      var isFilled = _ref3.isFilled,
        focusedState = _ref3.focusedState,
        disabled = _ref3.disabled,
        invalid = _ref3.invalid;
      return classNames('p-chips p-component p-inputwrapper', {
        'p-inputwrapper-filled': isFilled,
        'p-inputwrapper-focus': focusedState,
        'p-disabled': disabled,
        'p-invalid': invalid,
        'p-focus': focusedState
      });
    }
  };
  var ChipsBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'Chips',
      addOnBlur: null,
      allowDuplicate: true,
      ariaLabelledBy: null,
      autoFocus: false,
      className: null,
      disabled: null,
      id: null,
      inputId: null,
      inputRef: null,
      invalid: false,
      variant: null,
      itemTemplate: null,
      keyfilter: null,
      max: null,
      name: null,
      onAdd: null,
      onBlur: null,
      onChange: null,
      onFocus: null,
      onKeyDown: null,
      onRemove: null,
      placeholder: null,
      readOnly: false,
      removable: true,
      removeIcon: null,
      separator: null,
      style: null,
      tooltip: null,
      tooltipOptions: null,
      value: null,
      children: undefined
    },
    css: {
      classes: classes$11,
      styles: styles$S
    }
  });

  function ownKeys$1E(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1E(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1E(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1E(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var Chips = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var mergeProps = useMergeProps();
    var context = React__namespace.useContext(PrimeReactContext);
    var props = ChipsBase.getProps(inProps, context);
    var _React$useState = React__namespace.useState(false),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      focusedState = _React$useState2[0],
      setFocusedState = _React$useState2[1];
    var _React$useState3 = React__namespace.useState(null),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      focusedIndex = _React$useState4[0],
      setFocusedIndex = _React$useState4[1];
    var _ChipsBase$setMetaDat = ChipsBase.setMetaData({
        props: props,
        state: {
          focused: focusedState
        }
      }),
      ptm = _ChipsBase$setMetaDat.ptm,
      cx = _ChipsBase$setMetaDat.cx,
      isUnstyled = _ChipsBase$setMetaDat.isUnstyled;
    useHandleStyle(ChipsBase.css.styles, isUnstyled, {
      name: 'chips'
    });
    var elementRef = React__namespace.useRef(null);
    var listRef = React__namespace.useRef(null);
    var inputRef = React__namespace.useRef(props.inputRef);
    var removeItem = function removeItem(event, index) {
      if (props.disabled || props.readOnly) {
        return;
      }
      var values = _toConsumableArray(props.value);
      var removedItem = values.splice(index, 1)[0];
      if (!isRemovable(removedItem, index)) {
        return;
      }
      if (props.onRemove) {
        props.onRemove({
          originalEvent: event,
          value: removedItem
        });
      }
      if (props.onChange) {
        props.onChange({
          originalEvent: event,
          value: values,
          stopPropagation: function stopPropagation() {
            event === null || event === void 0 || event.stopPropagation();
          },
          preventDefault: function preventDefault() {
            event === null || event === void 0 || event.preventDefault();
          },
          target: {
            name: props.name,
            id: props.id,
            value: values
          }
        });
      }
    };
    var addItem = function addItem(event, item, preventDefault) {
      if (item && item.trim().length) {
        var values = props.value ? _toConsumableArray(props.value) : [];
        if (props.allowDuplicate || values.indexOf(item) === -1) {
          var allowAddition = true;
          if (props.onAdd) {
            allowAddition = props.onAdd({
              originalEvent: event,
              value: item
            });
          }
          if (allowAddition !== false) {
            values.push(item);
          }
        }
        updateInput(event, values, preventDefault);
      }
    };
    var onWrapperClick = function onWrapperClick() {
      DomHandler.focus(inputRef.current);
    };
    var onContainerKeyDown = function onContainerKeyDown(event) {
      switch (event.code) {
        case 'ArrowLeft':
          onArrowLeftKeyOn();
          break;
        case 'ArrowRight':
          onArrowRightKeyOn();
          break;
        case 'Backspace':
          onBackspaceKeyOn(event);
          break;
      }
    };
    var onArrowLeftKeyOn = function onArrowLeftKeyOn() {
      var focusIndex = focusedIndex;
      if (inputRef.current.value.length === 0 && props.value && props.value.length > 0) {
        focusIndex = focusIndex === null ? props.value.length - 1 : focusIndex - 1;
        if (focusIndex < 0) {
          focusIndex = 0;
        }
      }
      setFocusedIndex(focusIndex);
    };
    var onArrowRightKeyOn = function onArrowRightKeyOn() {
      var focusIndex = focusedIndex;
      if (inputRef.current.value.length === 0 && props.value && props.value.length > 0) {
        if (focusIndex === props.value.length - 1) {
          focusIndex = null;
          inputRef.current.focus();
        } else {
          focusIndex++;
        }
      }
      setFocusedIndex(focusIndex);
    };
    var onBackspaceKeyOn = function onBackspaceKeyOn(event) {
      if (focusedIndex !== null) {
        removeItem(event, focusedIndex);
      }
    };
    var _onKeyDown = function onKeyDown(event) {
      var inputValue = event.target.value;
      var values = props.value || [];
      props.onKeyDown && props.onKeyDown(event);
      if (event.defaultPrevented) {
        return;
      }
      switch (event.key) {
        case 'Backspace':
          if (inputValue.length === 0 && values.length > 0) {
            removeItem(event, values.length - 1);
          }
          break;
        case 'Enter':
          if (inputValue && inputValue.trim().length && (!props.max || props.max > values.length)) {
            addItem(event, inputValue, true);
          }
          break;
        case 'ArrowLeft':
          if (inputValue.length === 0 && values && values.length > 0) {
            DomHandler.focus(listRef.current);
          }
          break;
        case 'ArrowRight':
          event.stopPropagation();
          break;
        default:
          if (props.keyfilter) {
            KeyFilter.onKeyPress(event, props.keyfilter);
          }
          if (isMaxedOut()) {
            event.preventDefault();
          }
          break;
      }
    };
    var updateInput = function updateInput(event, items, preventDefault) {
      if (props.onChange) {
        props.onChange({
          originalEvent: event,
          value: items,
          stopPropagation: function stopPropagation() {
            event === null || event === void 0 || event.stopPropagation();
          },
          preventDefault: function preventDefault() {
            event === null || event === void 0 || event.preventDefault();
          },
          target: {
            name: props.name,
            id: props.id,
            value: items
          }
        });
      }
      inputRef.current.value = '';
      preventDefault && event.preventDefault();
    };
    var _onChange = function onChange(event) {
      var _event$target$value;
      var value = (_event$target$value = event.target.value) === null || _event$target$value === void 0 ? void 0 : _event$target$value.trim();
      if (value === props.separator) {
        inputRef.current.value = '';
        return;
      }
      if (props.separator && value.endsWith(props.separator)) {
        var trimmedValue = value.slice(0, -1);
        addItem(event, trimmedValue);
      }
    };
    var _onPaste = function onPaste(event) {
      if (props.separator) {
        var separator = props.separator.replace('\\n', '\n').replace('\\r', '\r').replace('\\t', '\t');
        var pastedData = (event.clipboardData || window.clipboardData).getData('Text');
        if (props.keyfilter) {
          KeyFilter.onPaste(event, props.keyfilter);
        }
        if (pastedData) {
          var values = props.value || [];
          var pastedValues = pastedData.split(separator);
          pastedValues = pastedValues.filter(function (val) {
            return (props.allowDuplicate || values.indexOf(val) === -1) && val.trim().length;
          });
          values = [].concat(_toConsumableArray(values), _toConsumableArray(pastedValues));
          updateInput(event, values, true);
        }
      }
    };
    var onContainerFocus = function onContainerFocus() {
      setFocusedState(true);
    };
    var onContainerBlur = function onContainerBlur() {
      setFocusedIndex(-1);
      setFocusedState(false);
    };
    var _onFocus = function onFocus(event) {
      setFocusedState(true);
      setFocusedIndex(null);
      props.onFocus && props.onFocus(event);
    };
    var _onBlur = function onBlur(event) {
      if (props.addOnBlur) {
        var inputValue = event.target.value;
        var values = props.value || [];
        if (inputValue && inputValue.trim().length && (!props.max || props.max > values.length)) {
          addItem(event, inputValue, true);
        }
      }
      setFocusedState(false);
      props.onBlur && props.onBlur(event);
    };
    var isMaxedOut = function isMaxedOut() {
      return props.max && props.value && props.max === props.value.length;
    };
    var currentValue = inputRef.current && inputRef.current.value;
    var isFilled = React__namespace.useMemo(function () {
      return ObjectUtils.isNotEmpty(props.value) || ObjectUtils.isNotEmpty(currentValue);
    }, [props.value, currentValue]);
    var isRemovable = function isRemovable(value, index) {
      return ObjectUtils.getPropValue(props.removable, {
        value: value,
        index: index,
        props: props
      });
    };
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        focus: function focus() {
          return DomHandler.focus(inputRef.current);
        },
        getElement: function getElement() {
          return elementRef.current;
        },
        getInput: function getInput() {
          return inputRef.current;
        }
      };
    });
    React__namespace.useEffect(function () {
      ObjectUtils.combinedRefs(inputRef, props.inputRef);
    }, [inputRef, props.inputRef]);
    useMountEffect(function () {
      if (props.autoFocus) {
        DomHandler.focus(inputRef.current, props.autoFocus);
      }
    });
    var focusedOptionId = function focusedOptionId() {
      return focusedIndex !== null ? "".concat(props.inputId, "_chips_item_").concat(focusedIndex) : null;
    };
    var createRemoveIcon = function createRemoveIcon(value, index) {
      if (!props.disabled && !props.readOnly && isRemovable(value, index)) {
        var iconProps = mergeProps({
          className: cx('removeTokenIcon'),
          onClick: function onClick(event) {
            return removeItem(event, index);
          },
          'aria-hidden': 'true'
        }, ptm('removeTokenIcon'));
        var icon = props.removeIcon || /*#__PURE__*/React__namespace.createElement(TimesCircleIcon, _extends({}, iconProps, {
          key: "".concat(index, "_icon")
        }));
        var removeIcon = IconUtils.getJSXIcon(icon, _objectSpread$1E({}, iconProps), {
          props: props
        });
        return removeIcon;
      }
      return null;
    };
    var createItem = function createItem(value, index) {
      var content = props.itemTemplate ? props.itemTemplate(value) : value;
      var labelProps = mergeProps({
        className: cx('label')
      }, ptm('label'));
      var label = /*#__PURE__*/React__namespace.createElement("span", _extends({}, labelProps, {
        key: "".concat(index, "_").concat(value, "_span")
      }), content);
      var icon = createRemoveIcon(value, index);
      var tokenProps = mergeProps({
        id: props.inputId + '_chips_item_' + index,
        role: 'option',
        'aria-label': value,
        className: cx('token', {
          focusedIndex: focusedIndex,
          index: index
        }),
        'aria-selected': true,
        'aria-setsize': props.value.length,
        'aria-posinset': index + 1,
        'data-p-highlight': true,
        'data-p-focused': focusedIndex === index
      }, ptm('token'));
      return /*#__PURE__*/React__namespace.createElement("li", _extends({}, tokenProps, {
        key: "".concat(index, "_").concat(value)
      }), label, icon);
    };
    var createInput = function createInput() {
      var inputTokenProps = mergeProps({
        className: cx('inputToken')
      }, ptm('inputToken'));
      var inputProps = mergeProps(_objectSpread$1E({
        id: props.inputId,
        ref: inputRef,
        placeholder: props.placeholder,
        type: 'text',
        enterKeyHint: 'enter',
        name: props.name,
        disabled: props.disabled || isMaxedOut(),
        onKeyDown: function onKeyDown(e) {
          return _onKeyDown(e);
        },
        onChange: function onChange(e) {
          return _onChange(e);
        },
        onPaste: function onPaste(e) {
          return _onPaste(e);
        },
        onFocus: function onFocus(e) {
          return _onFocus(e);
        },
        onBlur: function onBlur(e) {
          return _onBlur(e);
        },
        readOnly: props.readOnly
      }, ariaProps), ptm('input'));
      return /*#__PURE__*/React__namespace.createElement("li", _extends({}, inputTokenProps, {
        key: props.inputId + '_chips_input'
      }), /*#__PURE__*/React__namespace.createElement("input", inputProps));
    };
    var createItems = function createItems() {
      return props.value ? props.value.map(createItem) : null;
    };
    var createList = function createList() {
      var items = createItems();
      var input = createInput();
      var containerProps = mergeProps({
        ref: listRef,
        className: cx('container', {
          context: context
        }),
        onClick: function onClick(e) {
          return onWrapperClick();
        },
        onKeyDown: function onKeyDown(e) {
          return onContainerKeyDown(e);
        },
        tabIndex: -1,
        role: 'listbox',
        'aria-orientation': 'horizontal',
        'aria-labelledby': props.ariaLabelledby,
        'aria-label': props.ariaLabel,
        'aria-activedescendant': focusedState ? focusedOptionId() : undefined,
        'data-p-disabled': props.disabled,
        'data-p-focus': focusedState,
        onFocus: onContainerFocus,
        onBlur: onContainerBlur
      }, ptm('container'));
      return /*#__PURE__*/React__namespace.createElement("ul", containerProps, items, input);
    };
    var hasTooltip = ObjectUtils.isNotEmpty(props.tooltip);
    var otherProps = ChipsBase.getOtherProps(props);
    var ariaProps = ObjectUtils.reduceKeys(otherProps, DomHandler.ARIA_PROPS);
    var list = createList();
    var rootProps = mergeProps({
      id: props.id,
      ref: elementRef,
      className: classNames(props.className, cx('root', {
        isFilled: isFilled,
        focusedState: focusedState,
        disabled: props.disabled,
        invalid: props.invalid
      })),
      style: props.style
    }, ptm('root'));
    return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, null, /*#__PURE__*/React__namespace.createElement("div", _extends({}, rootProps, {
      key: "chips"
    }), list), hasTooltip && /*#__PURE__*/React__namespace.createElement(Tooltip, _extends({
      target: inputRef,
      content: props.tooltip,
      pt: ptm('tooltip')
    }, props.tooltipOptions)));
  }));
  Chips.displayName = 'Chips';

  var classes$10 = {
    root: function root(_ref) {
      var props = _ref.props;
      return classNames('p-colorpicker p-component', {
        'p-colorpicker-overlay': !props.inline
      });
    },
    input: function input(_ref2) {
      var props = _ref2.props;
      return classNames('p-colorpicker-preview p-inputtext', props.inputClassName, {
        'p-disabled': props.disabled
      });
    },
    panel: function panel(_ref3) {
      var panelProps = _ref3.panelProps,
        context = _ref3.context;
      return classNames('p-colorpicker-panel', panelProps.panelClassName, {
        'p-colorpicker-overlay-panel': !panelProps.inline,
        'p-disabled': panelProps.disabled,
        'p-input-filled': context && context.inputStyle === 'filled' || PrimeReact.inputStyle === 'filled',
        'p-ripple-disabled': context && context.ripple === false || PrimeReact.ripple === false
      });
    },
    content: 'p-colorpicker-content',
    hueHandle: 'p-colorpicker-hue-handle',
    hue: 'p-colorpicker-hue',
    colorHandle: 'p-colorpicker-color-handle',
    color: 'p-colorpicker-color',
    selector: 'p-colorpicker-color-selector',
    transition: 'p-connected-overlay'
  };
  var styles$R = "\n@layer primereact {\n    .p-colorpicker {\n        display: inline-block;\n    }\n    \n    .p-colorpicker-dragging {\n        cursor: pointer;\n    }\n    \n    .p-colorpicker-overlay {\n        position: relative;\n    }\n    \n    .p-colorpicker-panel {\n        position: relative;\n        width: 193px;\n        height: 166px;\n    }\n    \n    .p-colorpicker-overlay-panel {\n        position: absolute;\n        top: 0;\n        left: 0;\n    }\n    \n    .p-colorpicker-preview {\n        cursor: pointer;\n    }\n    \n    .p-colorpicker-panel .p-colorpicker-content {\n        position: relative;\n    }\n    \n    .p-colorpicker-panel .p-colorpicker-color-selector {\n        width: 150px;\n        height: 150px;\n        top: 8px;\n        left: 8px;\n        position: absolute;\n    }\n    \n    .p-colorpicker-panel .p-colorpicker-color {\n        width: 150px;\n        height: 150px;\n    }\n    \n    .p-colorpicker-panel .p-colorpicker-color-handle {\n        position: absolute;\n        top: 0px;\n        left: 150px;\n        border-radius: 100%;\n        width: 10px;\n        height: 10px;\n        border-width: 1px;\n        border-style: solid;\n        margin: -5px 0 0 -5px;\n        cursor: pointer;\n        opacity: 0.85;\n    }\n    \n    .p-colorpicker-panel .p-colorpicker-hue {\n        width: 17px;\n        height: 150px;\n        top: 8px;\n        left: 167px;\n        position: absolute;\n        opacity: 0.85;\n    }\n    \n    .p-colorpicker-panel .p-colorpicker-hue-handle {\n        position: absolute;\n        top: 150px;\n        left: 0px;\n        width: 21px;\n        margin-left: -2px;\n        margin-top: -5px;\n        height: 10px;\n        border-width: 2px;\n        border-style: solid;\n        opacity: 0.85;\n        cursor: pointer;\n    }\n    \n    .p-colorpicker-panel .p-colorpicker-color {\n        background: linear-gradient(to top, #000 0%, rgb(0 0 0 / 0) 100%), linear-gradient(to right, #fff 0%, rgb(255 255 255 / 0) 100%)\n    }\n    .p-colorpicker-panel .p-colorpicker-hue {\n        background: linear-gradient(0deg, red 0, #ff0 17%, #0f0 33%, #0ff 50%, #00f 67%, #f0f 83%, red)\n    }\n}\n";
  var ColorPickerBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'ColorPicker',
      appendTo: null,
      autoFocus: false,
      children: undefined,
      className: null,
      defaultColor: 'ff0000',
      disabled: false,
      format: 'hex',
      id: null,
      inline: false,
      inputClassName: null,
      inputId: null,
      inputRef: null,
      inputStyle: null,
      onChange: null,
      onHide: null,
      onShow: null,
      panelClassName: null,
      panelStyle: null,
      style: null,
      tabIndex: null,
      tooltip: null,
      tooltipOptions: null,
      transitionOptions: null,
      value: null
    },
    css: {
      classes: classes$10,
      styles: styles$R
    }
  });

  var ColorPickerPanel = /*#__PURE__*/React__namespace.forwardRef(function (props, ref) {
    var mergeProps = useMergeProps();
    var context = React__namespace.useContext(PrimeReactContext);
    var ptm = props.ptm,
      cx = props.cx;
    var createElement = function createElement() {
      var panelProps = mergeProps({
        className: cx('panel', {
          panelProps: props,
          context: context
        }),
        style: props.panelStyle,
        onClick: props.onClick
      }, ptm('panel', {
        hostName: props.hostName
      }));
      var transitionProps = mergeProps({
        classNames: cx('transition'),
        "in": props["in"],
        timeout: {
          enter: 120,
          exit: 100
        },
        options: props.transitionOptions,
        unmountOnExit: true,
        onEnter: props.onEnter,
        onEntered: props.onEntered,
        onExit: props.onExit,
        onExited: props.onExited
      }, ptm('transition', {
        hostName: props.hostName
      }));
      return /*#__PURE__*/React__namespace.createElement(CSSTransition, _extends({
        nodeRef: ref
      }, transitionProps), /*#__PURE__*/React__namespace.createElement("div", _extends({
        ref: ref
      }, panelProps), props.children));
    };
    var element = createElement();
    return props.inline ? element : /*#__PURE__*/React__namespace.createElement(Portal, {
      element: element,
      appendTo: props.appendTo
    });
  });
  ColorPickerPanel.displayName = 'ColorPickerPanel';

  function ownKeys$1D(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1D(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1D(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1D(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var ColorPicker = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var mergeProps = useMergeProps();
    var context = React__namespace.useContext(PrimeReactContext);
    var props = ColorPickerBase.getProps(inProps, context);
    var _React$useState = React__namespace.useState(false),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      overlayVisibleState = _React$useState2[0],
      setOverlayVisibleState = _React$useState2[1];
    var _ColorPickerBase$setM = ColorPickerBase.setMetaData({
        props: props,
        state: {
          overlayVisible: overlayVisibleState
        }
      }),
      ptm = _ColorPickerBase$setM.ptm,
      cx = _ColorPickerBase$setM.cx,
      isUnstyled = _ColorPickerBase$setM.isUnstyled;
    var isCloseOnEscape = overlayVisibleState && props.closeOnEscape;
    var overlayDisplayOrder = useDisplayOrder('overlay-panel', isCloseOnEscape);
    useHandleStyle(ColorPickerBase.css.styles, isUnstyled, {
      name: 'colorpicker'
    });
    useGlobalOnEscapeKey({
      callback: function callback() {
        hide();
      },
      when: overlayVisibleState && overlayDisplayOrder,
      priority: [ESC_KEY_HANDLING_PRIORITIES.OVERLAY_PANEL, overlayDisplayOrder]
    });
    var elementRef = React__namespace.useRef(null);
    var overlayRef = React__namespace.useRef(null);
    var inputRef = React__namespace.useRef(props.inputRef);
    var colorSelectorRef = React__namespace.useRef(null);
    var colorHandleRef = React__namespace.useRef(null);
    var hueHandleRef = React__namespace.useRef(null);
    var hueViewRef = React__namespace.useRef(null);
    var hueDragging = React__namespace.useRef(false);
    var hsbValue = React__namespace.useRef(null);
    var colorDragging = React__namespace.useRef(false);
    var _useOverlayListener = useOverlayListener({
        target: elementRef,
        overlay: overlayRef,
        listener: function listener(event, _ref) {
          var valid = _ref.valid,
            type = _ref.type;
          if (valid) {
            if (context.hideOverlaysOnDocumentScrolling || type === 'outside') {
              hide();
            } else if (!DomHandler.isDocument(event.target)) {
              alignOverlay();
            }
          }
        },
        when: overlayVisibleState
      }),
      _useOverlayListener2 = _slicedToArray(_useOverlayListener, 2),
      bindOverlayListener = _useOverlayListener2[0],
      unbindOverlayListener = _useOverlayListener2[1];
    var _useEventListener = useEventListener({
        type: 'mousemove',
        listener: function listener(event) {
          colorDragging.current && pickColor(event);
          hueDragging.current && pickHue(event);
        }
      }),
      _useEventListener2 = _slicedToArray(_useEventListener, 2),
      bindDocumentMouseMoveListener = _useEventListener2[0],
      unbindDocumentMouseMoveListener = _useEventListener2[1];
    var _useEventListener3 = useEventListener({
        type: 'mouseup',
        listener: function listener() {
          colorDragging.current = hueDragging.current = false;
          DomHandler.removeClass(elementRef.current, 'p-colorpicker-dragging');
          unbindDocumentMouseMoveListener();
          unbindDocumentMouseUpListener();
        }
      }),
      _useEventListener4 = _slicedToArray(_useEventListener3, 2),
      bindDocumentMouseUpListener = _useEventListener4[0],
      unbindDocumentMouseUpListener = _useEventListener4[1];
    var onPanelClick = function onPanelClick(event) {
      if (!props.inline) {
        OverlayService.emit('overlay-click', {
          originalEvent: event,
          target: elementRef.current
        });
      }
    };
    var onHueMousedown = function onHueMousedown(event) {
      if (props.disabled) {
        return;
      }
      bindDragListeners();
      onHueDragStart(event);
    };
    var onHueDragStart = function onHueDragStart(event) {
      if (props.disabled) {
        return;
      }
      hueDragging.current = true;
      pickHue(event);
      !isUnstyled && DomHandler.addClass(elementRef.current, 'p-colorpicker-dragging');
      event.preventDefault();
    };
    var getPositionY = function getPositionY(event) {
      if (event.pageY !== undefined) return event.pageY;else if (event.changedTouches !== undefined) return event.changedTouches[0].pageY;else return 0;
    };
    var pickHue = function pickHue(event) {
      var top = hueViewRef.current.getBoundingClientRect().top + (window.scrollY || document.documentElement.scrollTop || document.body.scrollTop || 0);
      var yPos = getPositionY(event);
      var hue = Math.floor(360 * (150 - Math.max(0, Math.min(150, yPos - top))) / 150);
      hsbValue.current = validateHSB({
        h: hue,
        s: hsbValue.current.s,
        b: hsbValue.current.b
      });
      updateColorSelector();
      updateHue();
      updateModel();
    };
    var onColorMousedown = function onColorMousedown(event) {
      if (props.disabled) {
        return;
      }
      bindDragListeners();
      onColorDragStart(event);
    };
    var onColorDragStart = function onColorDragStart(event) {
      if (props.disabled) {
        return;
      }
      colorDragging.current = true;
      pickColor(event);
      !isUnstyled && DomHandler.addClass(elementRef.current, 'p-colorpicker-dragging');
      event.preventDefault();
    };
    var onDrag = function onDrag(event) {
      if (colorDragging.current) {
        pickColor(event);
        event.preventDefault();
      }
      if (hueDragging.current) {
        pickHue(event);
        event.preventDefault();
      }
    };
    var onDragEnd = function onDragEnd() {
      colorDragging.current = false;
      hueDragging.current = false;
      !isUnstyled && DomHandler.removeClass(elementRef.current, 'p-colorpicker-dragging');
      unbindDragListeners();
    };
    var bindDragListeners = function bindDragListeners() {
      bindDocumentMouseMoveListener();
      bindDocumentMouseUpListener();
    };
    var unbindDragListeners = function unbindDragListeners() {
      unbindDocumentMouseMoveListener();
      unbindDocumentMouseUpListener();
    };
    var pickColor = function pickColor(event) {
      var rect = colorSelectorRef.current.getBoundingClientRect();
      var top = rect.top + (window.pageYOffset || document.documentElement.scrollTop || document.body.scrollTop || 0);
      var left = rect.left + document.body.scrollLeft;
      var saturation = Math.floor(100 * Math.max(0, Math.min(150, (event.pageX || event.changedTouches[0].pageX) - left)) / 150);
      var brightness = Math.floor(100 * (150 - Math.max(0, Math.min(150, (event.pageY || event.changedTouches[0].pageY) - top))) / 150);
      hsbValue.current = validateHSB({
        h: hsbValue.current.h,
        s: saturation,
        b: brightness
      });
      updateColorHandle();
      updateInput();
      updateModel();
    };
    var updateModel = function updateModel() {
      switch (props.format) {
        case 'hex':
          onChange(HSBtoHEX(hsbValue.current));
          break;
        case 'rgb':
          onChange(HSBtoRGB(hsbValue.current));
          break;
        case 'hsb':
          onChange(hsbValue.current);
          break;
      }
    };
    var toHSB = function toHSB(value) {
      var hsb;
      if (value) {
        switch (props.format) {
          case 'hex':
            hsb = HEXtoHSB(value);
            break;
          case 'rgb':
            hsb = RGBtoHSB(value);
            break;
          case 'hsb':
            hsb = value;
            break;
        }
      } else {
        hsb = HEXtoHSB(props.defaultColor);
      }
      return hsb;
    };
    var updateHSBValue = function updateHSBValue(value) {
      hsbValue.current = toHSB(value);
    };
    var onChange = function onChange(value) {
      if (props.onChange) {
        props.onChange({
          value: value,
          stopPropagation: function stopPropagation() {},
          preventDefault: function preventDefault() {},
          target: {
            name: props.name,
            id: props.id,
            value: value
          }
        });
      }
    };
    var updateColorSelector = function updateColorSelector() {
      if (colorSelectorRef.current) {
        var newHsbValue = validateHSB({
          h: hsbValue.current.h,
          s: 100,
          b: 100
        });
        colorSelectorRef.current.style.backgroundColor = '#' + HSBtoHEX(newHsbValue);
      }
    };
    var updateColorHandle = function updateColorHandle() {
      if (colorHandleRef.current) {
        colorHandleRef.current.style.left = Math.floor(150 * hsbValue.current.s / 100) + 'px';
        colorHandleRef.current.style.top = Math.floor(150 * (100 - hsbValue.current.b) / 100) + 'px';
      }
    };
    var updateHue = function updateHue() {
      if (hueHandleRef.current) {
        hueHandleRef.current.style.top = Math.floor(150 - 150 * hsbValue.current.h / 360) + 'px';
      }
    };
    var updateInput = function updateInput() {
      if (inputRef.current) {
        inputRef.current.style.backgroundColor = '#' + HSBtoHEX(hsbValue.current);
      }
    };
    var show = function show() {
      setOverlayVisibleState(true);
    };
    var hide = function hide() {
      setOverlayVisibleState(false);
    };
    var onOverlayEnter = function onOverlayEnter() {
      var styles = !props.inline ? {
        position: 'absolute',
        top: '0',
        left: '0'
      } : undefined;
      ZIndexUtils.set('overlay', overlayRef.current, context && context.autoZIndex || PrimeReact.autoZIndex, context && context.zIndex.overlay || PrimeReact.zIndex.overlay);
      DomHandler.addStyles(overlayRef.current, styles);
      alignOverlay();
    };
    var onOverlayEntered = function onOverlayEntered() {
      bindOverlayListener();
      props.onShow && props.onShow();
    };
    var onOverlayExit = function onOverlayExit() {
      unbindOverlayListener();
    };
    var onOverlayExited = function onOverlayExited() {
      ZIndexUtils.clear(overlayRef.current);
      props.onHide && props.onHide();
    };
    var onInputClick = function onInputClick() {
      togglePanel();
    };
    var togglePanel = function togglePanel() {
      overlayVisibleState ? hide() : show();
    };
    var onInputKeydown = function onInputKeydown(event) {
      switch (event.which) {
        //space
        case 32:
          togglePanel();
          event.preventDefault();
          break;

        //escape and tab
        case 27:
        case 9:
          hide();
          break;
      }
    };
    var validateHSB = function validateHSB(hsb) {
      return {
        h: Math.min(360, Math.max(0, hsb.h)),
        s: Math.min(100, Math.max(0, hsb.s)),
        b: Math.min(100, Math.max(0, hsb.b))
      };
    };
    var HEXtoRGB = function HEXtoRGB(hex) {
      var hexValue = parseInt(hex.indexOf('#') > -1 ? hex.substring(1) : hex, 16);
      return {
        r: hexValue >> 16,
        g: (hexValue & 0x00ff00) >> 8,
        b: hexValue & 0x0000ff
      };
    };
    var HEXtoHSB = function HEXtoHSB(hex) {
      return RGBtoHSB(HEXtoRGB(hex));
    };
    var RGBtoHSB = function RGBtoHSB(rgb) {
      var hsb = {
        h: 0,
        s: 0,
        b: 0
      };
      var min = Math.min(rgb.r, rgb.g, rgb.b);
      var max = Math.max(rgb.r, rgb.g, rgb.b);
      var delta = max - min;
      hsb.b = max;
      hsb.s = max !== 0 ? 255 * delta / max : 0;
      if (hsb.s !== 0) {
        if (rgb.r === max) {
          hsb.h = (rgb.g - rgb.b) / delta;
        } else if (rgb.g === max) {
          hsb.h = 2 + (rgb.b - rgb.r) / delta;
        } else {
          hsb.h = 4 + (rgb.r - rgb.g) / delta;
        }
      } else {
        hsb.h = -1;
      }
      hsb.h = hsb.h * 60;
      if (hsb.h < 0) {
        hsb.h = hsb.h + 360;
      }
      hsb.s = hsb.s * (100 / 255);
      hsb.b = hsb.b * (100 / 255);
      return hsb;
    };
    var HSBtoRGB = function HSBtoRGB(hsb) {
      var rgb = {
        r: null,
        g: null,
        b: null
      };
      var h = Math.round(hsb.h);
      var s = Math.round(hsb.s * 255 / 100);
      var v = Math.round(hsb.b * 255 / 100);
      if (s === 0) {
        rgb = {
          r: v,
          g: v,
          b: v
        };
      } else {
        var t1 = v;
        var t2 = (255 - s) * v / 255;
        var t3 = (t1 - t2) * (h % 60) / 60;
        if (h === 360) {
          h = 0;
        }
        if (h < 60) {
          rgb.r = t1;
          rgb.b = t2;
          rgb.g = t2 + t3;
        } else if (h < 120) {
          rgb.g = t1;
          rgb.b = t2;
          rgb.r = t1 - t3;
        } else if (h < 180) {
          rgb.g = t1;
          rgb.r = t2;
          rgb.b = t2 + t3;
        } else if (h < 240) {
          rgb.b = t1;
          rgb.r = t2;
          rgb.g = t1 - t3;
        } else if (h < 300) {
          rgb.b = t1;
          rgb.g = t2;
          rgb.r = t2 + t3;
        } else if (h < 360) {
          rgb.r = t1;
          rgb.g = t2;
          rgb.b = t1 - t3;
        } else {
          rgb.r = 0;
          rgb.g = 0;
          rgb.b = 0;
        }
      }
      return {
        r: Math.round(rgb.r),
        g: Math.round(rgb.g),
        b: Math.round(rgb.b)
      };
    };
    var RGBtoHEX = function RGBtoHEX(rgb) {
      var hex = [rgb.r.toString(16), rgb.g.toString(16), rgb.b.toString(16)];
      for (var key in hex) {
        if (hex[key].length === 1) {
          hex[key] = '0' + hex[key];
        }
      }
      return hex.join('');
    };
    var HSBtoHEX = function HSBtoHEX(hsb) {
      return RGBtoHEX(HSBtoRGB(hsb));
    };
    var updateUI = function updateUI() {
      updateHue();
      updateColorHandle();
      updateInput();
      updateColorSelector();
    };
    var alignOverlay = function alignOverlay() {
      if (inputRef.current) {
        DomHandler.alignOverlay(overlayRef.current, inputRef.current.parentElement, props.appendTo || context && context.appendTo || PrimeReact.appendTo);
      }
    };
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        show: show,
        hide: hide,
        focus: function focus() {
          return DomHandler.focus(inputRef.current);
        },
        getElement: function getElement() {
          return elementRef.current;
        },
        getOverlay: function getOverlay() {
          return overlayRef.current;
        },
        getInput: function getInput() {
          return inputRef.current;
        }
      };
    });
    React__namespace.useEffect(function () {
      ObjectUtils.combinedRefs(inputRef, props.inputRef);
    }, [inputRef, props.inputRef]);
    useMountEffect(function () {
      updateHSBValue(props.value);
      updateUI();
      if (props.autoFocus) {
        DomHandler.focus(inputRef.current, props.autoFocus);
      }
      alignOverlay();
    });
    useUpdateEffect(function () {
      if (!colorDragging.current && !hueDragging.current) {
        updateHSBValue(props.value);
      }
    }, [props.value]);
    useUpdateEffect(function () {
      updateUI();
    });
    useUnmountEffect(function () {
      ZIndexUtils.clear(overlayRef.current);
    });
    var createColorSelector = function createColorSelector() {
      var selectorProps = mergeProps({
        ref: colorSelectorRef,
        className: cx('selector'),
        onMouseDown: function onMouseDown(e) {
          return onColorMousedown(e);
        },
        onTouchStart: function onTouchStart(e) {
          return onColorDragStart(e);
        },
        onTouchMove: function onTouchMove(e) {
          return onDrag(e);
        },
        onTouchEnd: onDragEnd
      }, ptm('selector'));
      var colorProps = mergeProps({
        className: cx('color')
      }, ptm('color'));
      var colorHandlerProps = mergeProps({
        ref: colorHandleRef,
        className: cx('colorHandle')
      }, ptm('colorHandle'));
      return /*#__PURE__*/React__namespace.createElement("div", selectorProps, /*#__PURE__*/React__namespace.createElement("div", colorProps, /*#__PURE__*/React__namespace.createElement("div", colorHandlerProps)));
    };
    var createHue = function createHue() {
      var hueProps = mergeProps({
        className: cx('hue'),
        onMouseDown: function onMouseDown(e) {
          return onHueMousedown(e);
        },
        onTouchStart: function onTouchStart(e) {
          return onHueDragStart(e);
        },
        onTouchMove: function onTouchMove(e) {
          return onDrag(e);
        },
        onTouchEnd: onDragEnd
      }, ptm('hue'));
      var hueHandlerProps = mergeProps({
        className: cx('hueHandle')
      }, ptm('hueHandle'));
      return /*#__PURE__*/React__namespace.createElement("div", _extends({
        ref: hueViewRef
      }, hueProps), /*#__PURE__*/React__namespace.createElement("div", _extends({
        ref: hueHandleRef
      }, hueHandlerProps)));
    };
    var createContent = function createContent() {
      var colorSelector = createColorSelector();
      var hue = createHue();
      var contentProps = mergeProps({
        className: cx('content')
      }, ptm('content'));
      return /*#__PURE__*/React__namespace.createElement("div", contentProps, colorSelector, hue);
    };
    var createInput = function createInput() {
      if (!props.inline) {
        var inputProps = ColorPickerBase.getOtherProps(props);
        var _inputProps = mergeProps(_objectSpread$1D({
          ref: inputRef,
          type: 'text',
          readOnly: true,
          className: cx('input'),
          style: props.inputStyle,
          id: props.inputId,
          tabIndex: props.tabIndex,
          disabled: props.disabled,
          onClick: onInputClick,
          onKeyDown: onInputKeydown
        }, inputProps), ptm('input'));
        return /*#__PURE__*/React__namespace.createElement("input", _inputProps);
      }
      return null;
    };
    var hasTooltip = ObjectUtils.isNotEmpty(props.tooltip);
    var content = createContent();
    var input = createInput();
    var rootProps = mergeProps({
      id: props.id,
      ref: elementRef,
      style: props.style,
      className: classNames(props.className, cx('root'))
    }, ColorPickerBase.getOtherProps(props), ptm('root'));
    return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, null, /*#__PURE__*/React__namespace.createElement("div", rootProps, input, /*#__PURE__*/React__namespace.createElement(ColorPickerPanel, {
      hostName: "ColorPicker",
      ref: overlayRef,
      appendTo: props.appendTo,
      inline: props.inline,
      disabled: props.disabled,
      panelStyle: props.panelStyle,
      panelClassName: props.panelClassName,
      onClick: onPanelClick,
      "in": props.inline || overlayVisibleState,
      onEnter: onOverlayEnter,
      onEntered: onOverlayEntered,
      onExit: onOverlayExit,
      onExited: onOverlayExited,
      transitionOptions: props.transitionOptions,
      ptm: ptm,
      cx: cx
    }, content)), hasTooltip && /*#__PURE__*/React__namespace.createElement(Tooltip, _extends({
      target: elementRef,
      content: props.tooltip,
      pt: ptm('tooltip')
    }, props.tooltipOptions)));
  }));
  ColorPicker.displayName = 'ColorPicker';

  var Column = function Column() {};
  //@todo Pass Parent MetaData

  Column.displayName = 'Column';

  var ColumnGroup = function ColumnGroup() {};
  ColumnGroup.displayName = 'ColumnGroup';

  var styles$Q = '';
  var FocusTrapBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'FocusTrap',
      children: undefined
    },
    css: {
      styles: styles$Q
    },
    getProps: function getProps(props) {
      return ObjectUtils.getMergedProps(props, FocusTrapBase.defaultProps);
    },
    getOtherProps: function getOtherProps(props) {
      return ObjectUtils.getDiffProps(props, FocusTrapBase.defaultProps);
    }
  });

  function ownKeys$1C(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1C(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1C(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1C(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var FocusTrap = /*#__PURE__*/React__default["default"].memo(/*#__PURE__*/React__default["default"].forwardRef(function (inProps, ref) {
    var targetRef = React__default["default"].useRef(null);
    var firstFocusableElementRef = React__default["default"].useRef(null);
    var lastFocusableElementRef = React__default["default"].useRef(null);
    var context = React__default["default"].useContext(PrimeReactContext);
    var props = FocusTrapBase.getProps(inProps, context);
    var metaData = {
      props: props
    };
    useStyle(FocusTrapBase.css.styles, {
      name: 'focustrap'
    });
    var _FocusTrapBase$setMet = FocusTrapBase.setMetaData(_objectSpread$1C({}, metaData));
      _FocusTrapBase$setMet.ptm;
    React__default["default"].useImperativeHandle(ref, function () {
      return {
        props: props,
        getInk: function getInk() {
          return firstFocusableElementRef.current;
        },
        getTarget: function getTarget() {
          return targetRef.current;
        }
      };
    });
    useMountEffect(function () {
      if (!props.disabled) {
        targetRef.current = getTarget();
        setAutoFocus(targetRef.current);
      }
    });
    var getTarget = function getTarget() {
      return firstFocusableElementRef.current && firstFocusableElementRef.current.parentElement;
    };

    /**
     * This method sets the auto focus on the first focusable element within the target element.
     * It first tries to find a focusable element using the autoFocusSelector. If no such element is found,
     * it then tries to find a focusable element using the firstFocusableSelector.
     * If the autoFocus prop is set to true and a focusable element is found, it sets the focus on that element.
     *
     * @param {HTMLElement} target - The target element within which to find a focusable element.
     */
    var setAutoFocus = function setAutoFocus(target) {
      var _ref = props || {},
        _ref$autoFocusSelecto = _ref.autoFocusSelector,
        autoFocusSelector = _ref$autoFocusSelecto === void 0 ? '' : _ref$autoFocusSelecto,
        _ref$firstFocusableSe = _ref.firstFocusableSelector,
        firstFocusableSelector = _ref$firstFocusableSe === void 0 ? '' : _ref$firstFocusableSe,
        _ref$autoFocus = _ref.autoFocus,
        autoFocus = _ref$autoFocus === void 0 ? false : _ref$autoFocus;
      var defaultAutoFocusSelector = "".concat(getComputedSelector(autoFocusSelector));
      var computedAutoFocusSelector = "[autofocus]".concat(defaultAutoFocusSelector, ", [data-pc-autofocus='true']").concat(defaultAutoFocusSelector);
      var focusableElement = DomHandler.getFirstFocusableElement(target, computedAutoFocusSelector);
      autoFocus && !focusableElement && (focusableElement = DomHandler.getFirstFocusableElement(target, getComputedSelector(firstFocusableSelector)));
      DomHandler.focus(focusableElement);
    };
    var getComputedSelector = function getComputedSelector(selector) {
      return ":not(.p-hidden-focusable):not([data-p-hidden-focusable=\"true\"])".concat(selector !== null && selector !== void 0 ? selector : '');
    };
    var onFirstHiddenElementFocus = function onFirstHiddenElementFocus(event) {
      var _targetRef$current;
      var currentTarget = event.currentTarget,
        relatedTarget = event.relatedTarget;
      var focusableElement = relatedTarget === currentTarget.$_pfocustrap_lasthiddenfocusableelement || !((_targetRef$current = targetRef.current) !== null && _targetRef$current !== void 0 && _targetRef$current.contains(relatedTarget)) ? DomHandler.getFirstFocusableElement(currentTarget.parentElement, getComputedSelector(currentTarget.$_pfocustrap_focusableselector)) : currentTarget.$_pfocustrap_lasthiddenfocusableelement;
      DomHandler.focus(focusableElement);
    };
    var onLastHiddenElementFocus = function onLastHiddenElementFocus(event) {
      var _targetRef$current2;
      var currentTarget = event.currentTarget,
        relatedTarget = event.relatedTarget;
      var focusableElement = relatedTarget === currentTarget.$_pfocustrap_firsthiddenfocusableelement || !((_targetRef$current2 = targetRef.current) !== null && _targetRef$current2 !== void 0 && _targetRef$current2.contains(relatedTarget)) ? DomHandler.getLastFocusableElement(currentTarget.parentElement, getComputedSelector(currentTarget.$_pfocustrap_focusableselector)) : currentTarget.$_pfocustrap_firsthiddenfocusableelement;
      DomHandler.focus(focusableElement);
    };
    var createHiddenFocusableElements = function createHiddenFocusableElements() {
      var _ref2 = props || {},
        _ref2$tabIndex = _ref2.tabIndex,
        tabIndex = _ref2$tabIndex === void 0 ? 0 : _ref2$tabIndex;
      var createFocusableElement = function createFocusableElement(inRef, onFocus, section) {
        return /*#__PURE__*/React__default["default"].createElement("span", {
          ref: inRef,
          className: 'p-hidden-accessible p-hidden-focusable',
          tabIndex: tabIndex,
          role: 'presentation',
          "aria-hidden": true,
          "data-p-hidden-accessible": true,
          "data-p-hidden-focusable": true,
          onFocus: onFocus,
          "data-pc-section": section
        });
      };
      var firstFocusableElement = createFocusableElement(firstFocusableElementRef, onFirstHiddenElementFocus, 'firstfocusableelement');
      var lastFocusableElement = createFocusableElement(lastFocusableElementRef, onLastHiddenElementFocus, 'lastfocusableelement');
      if (firstFocusableElementRef.current && lastFocusableElementRef.current) {
        firstFocusableElementRef.current.$_pfocustrap_lasthiddenfocusableelement = lastFocusableElementRef.current;
        lastFocusableElementRef.current.$_pfocustrap_firsthiddenfocusableelement = firstFocusableElementRef.current;
      }
      return /*#__PURE__*/React__default["default"].createElement(React__default["default"].Fragment, null, firstFocusableElement, props.children, lastFocusableElement);
    };
    return createHiddenFocusableElements();
  }));
  var FocusTrap$1 = FocusTrap;

  var WindowMaximizeIcon = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("path", {
      fillRule: "evenodd",
      clipRule: "evenodd",
      d: "M7 14H11.8C12.3835 14 12.9431 13.7682 13.3556 13.3556C13.7682 12.9431 14 12.3835 14 11.8V2.2C14 1.61652 13.7682 1.05694 13.3556 0.644365C12.9431 0.231785 12.3835 0 11.8 0H2.2C1.61652 0 1.05694 0.231785 0.644365 0.644365C0.231785 1.05694 0 1.61652 0 2.2V7C0 7.15913 0.063214 7.31174 0.175736 7.42426C0.288258 7.53679 0.44087 7.6 0.6 7.6C0.75913 7.6 0.911742 7.53679 1.02426 7.42426C1.13679 7.31174 1.2 7.15913 1.2 7V2.2C1.2 1.93478 1.30536 1.68043 1.49289 1.49289C1.68043 1.30536 1.93478 1.2 2.2 1.2H11.8C12.0652 1.2 12.3196 1.30536 12.5071 1.49289C12.6946 1.68043 12.8 1.93478 12.8 2.2V11.8C12.8 12.0652 12.6946 12.3196 12.5071 12.5071C12.3196 12.6946 12.0652 12.8 11.8 12.8H7C6.84087 12.8 6.68826 12.8632 6.57574 12.9757C6.46321 13.0883 6.4 13.2409 6.4 13.4C6.4 13.5591 6.46321 13.7117 6.57574 13.8243C6.68826 13.9368 6.84087 14 7 14ZM9.77805 7.42192C9.89013 7.534 10.0415 7.59788 10.2 7.59995C10.3585 7.59788 10.5099 7.534 10.622 7.42192C10.7341 7.30985 10.798 7.15844 10.8 6.99995V3.94242C10.8066 3.90505 10.8096 3.86689 10.8089 3.82843C10.8079 3.77159 10.7988 3.7157 10.7824 3.6623C10.756 3.55552 10.701 3.45698 10.622 3.37798C10.5099 3.2659 10.3585 3.20202 10.2 3.19995H7.00002C6.84089 3.19995 6.68828 3.26317 6.57576 3.37569C6.46324 3.48821 6.40002 3.64082 6.40002 3.79995C6.40002 3.95908 6.46324 4.11169 6.57576 4.22422C6.68828 4.33674 6.84089 4.39995 7.00002 4.39995H8.80006L6.19997 7.00005C6.10158 7.11005 6.04718 7.25246 6.04718 7.40005C6.04718 7.54763 6.10158 7.69004 6.19997 7.80005C6.30202 7.91645 6.44561 7.98824 6.59997 8.00005C6.75432 7.98824 6.89791 7.91645 6.99997 7.80005L9.60002 5.26841V6.99995C9.6021 7.15844 9.66598 7.30985 9.77805 7.42192ZM1.4 14H3.8C4.17066 13.9979 4.52553 13.8498 4.78763 13.5877C5.04973 13.3256 5.1979 12.9707 5.2 12.6V10.2C5.1979 9.82939 5.04973 9.47452 4.78763 9.21242C4.52553 8.95032 4.17066 8.80215 3.8 8.80005H1.4C1.02934 8.80215 0.674468 8.95032 0.412371 9.21242C0.150274 9.47452 0.00210008 9.82939 0 10.2V12.6C0.00210008 12.9707 0.150274 13.3256 0.412371 13.5877C0.674468 13.8498 1.02934 13.9979 1.4 14ZM1.25858 10.0586C1.29609 10.0211 1.34696 10 1.4 10H3.8C3.85304 10 3.90391 10.0211 3.94142 10.0586C3.97893 10.0961 4 10.147 4 10.2V12.6C4 12.6531 3.97893 12.704 3.94142 12.7415C3.90391 12.779 3.85304 12.8 3.8 12.8H1.4C1.34696 12.8 1.29609 12.779 1.25858 12.7415C1.22107 12.704 1.2 12.6531 1.2 12.6V10.2C1.2 10.147 1.22107 10.0961 1.25858 10.0586Z",
      fill: "currentColor"
    }));
  }));
  WindowMaximizeIcon.displayName = 'WindowMaximizeIcon';

  var WindowMinimizeIcon = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("path", {
      fillRule: "evenodd",
      clipRule: "evenodd",
      d: "M11.8 0H2.2C1.61652 0 1.05694 0.231785 0.644365 0.644365C0.231785 1.05694 0 1.61652 0 2.2V7C0 7.15913 0.063214 7.31174 0.175736 7.42426C0.288258 7.53679 0.44087 7.6 0.6 7.6C0.75913 7.6 0.911742 7.53679 1.02426 7.42426C1.13679 7.31174 1.2 7.15913 1.2 7V2.2C1.2 1.93478 1.30536 1.68043 1.49289 1.49289C1.68043 1.30536 1.93478 1.2 2.2 1.2H11.8C12.0652 1.2 12.3196 1.30536 12.5071 1.49289C12.6946 1.68043 12.8 1.93478 12.8 2.2V11.8C12.8 12.0652 12.6946 12.3196 12.5071 12.5071C12.3196 12.6946 12.0652 12.8 11.8 12.8H7C6.84087 12.8 6.68826 12.8632 6.57574 12.9757C6.46321 13.0883 6.4 13.2409 6.4 13.4C6.4 13.5591 6.46321 13.7117 6.57574 13.8243C6.68826 13.9368 6.84087 14 7 14H11.8C12.3835 14 12.9431 13.7682 13.3556 13.3556C13.7682 12.9431 14 12.3835 14 11.8V2.2C14 1.61652 13.7682 1.05694 13.3556 0.644365C12.9431 0.231785 12.3835 0 11.8 0ZM6.368 7.952C6.44137 7.98326 6.52025 7.99958 6.6 8H9.8C9.95913 8 10.1117 7.93678 10.2243 7.82426C10.3368 7.71174 10.4 7.55913 10.4 7.4C10.4 7.24087 10.3368 7.08826 10.2243 6.97574C10.1117 6.86321 9.95913 6.8 9.8 6.8H8.048L10.624 4.224C10.73 4.11026 10.7877 3.95982 10.7849 3.80438C10.7822 3.64894 10.7192 3.50063 10.6093 3.3907C10.4994 3.28077 10.3511 3.2178 10.1956 3.21506C10.0402 3.21232 9.88974 3.27002 9.776 3.376L7.2 5.952V4.2C7.2 4.04087 7.13679 3.88826 7.02426 3.77574C6.91174 3.66321 6.75913 3.6 6.6 3.6C6.44087 3.6 6.28826 3.66321 6.17574 3.77574C6.06321 3.88826 6 4.04087 6 4.2V7.4C6.00042 7.47975 6.01674 7.55862 6.048 7.632C6.07656 7.70442 6.11971 7.7702 6.17475 7.82524C6.2298 7.88029 6.29558 7.92344 6.368 7.952ZM1.4 8.80005H3.8C4.17066 8.80215 4.52553 8.95032 4.78763 9.21242C5.04973 9.47452 5.1979 9.82939 5.2 10.2V12.6C5.1979 12.9707 5.04973 13.3256 4.78763 13.5877C4.52553 13.8498 4.17066 13.9979 3.8 14H1.4C1.02934 13.9979 0.674468 13.8498 0.412371 13.5877C0.150274 13.3256 0.00210008 12.9707 0 12.6V10.2C0.00210008 9.82939 0.150274 9.47452 0.412371 9.21242C0.674468 8.95032 1.02934 8.80215 1.4 8.80005ZM3.94142 12.7415C3.97893 12.704 4 12.6531 4 12.6V10.2C4 10.147 3.97893 10.0961 3.94142 10.0586C3.90391 10.0211 3.85304 10 3.8 10H1.4C1.34696 10 1.29609 10.0211 1.25858 10.0586C1.22107 10.0961 1.2 10.147 1.2 10.2V12.6C1.2 12.6531 1.22107 12.704 1.25858 12.7415C1.29609 12.779 1.34696 12.8 1.4 12.8H3.8C3.85304 12.8 3.90391 12.779 3.94142 12.7415Z",
      fill: "currentColor"
    }));
  }));
  WindowMinimizeIcon.displayName = 'WindowMinimizeIcon';

  function ownKeys$1B(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1B(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1B(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1B(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var classes$$ = {
    closeButtonIcon: 'p-dialog-header-close-icon',
    closeButton: 'p-dialog-header-icon p-dialog-header-close p-link',
    maximizableIcon: 'p-dialog-header-maximize-icon',
    maximizableButton: 'p-dialog-header-icon p-dialog-header-maximize p-link',
    header: function header(_ref) {
      var props = _ref.props;
      return classNames('p-dialog-header', props.headerClassName);
    },
    headerTitle: 'p-dialog-title',
    headerIcons: 'p-dialog-header-icons',
    content: function content(_ref2) {
      var props = _ref2.props;
      return classNames('p-dialog-content', props.contentClassName);
    },
    footer: function footer(_ref3) {
      var props = _ref3.props;
      return classNames('p-dialog-footer', props.footerClassName);
    },
    mask: function mask(_ref4) {
      var props = _ref4.props,
        maskVisibleState = _ref4.maskVisibleState;
      var positions = ['center', 'left', 'right', 'top', 'top-left', 'top-right', 'bottom', 'bottom-left', 'bottom-right'];
      var pos = positions.find(function (item) {
        return item === props.position || item.replace('-', '') === props.position;
      });
      return classNames('p-dialog-mask', pos ? "p-dialog-".concat(pos) : '', {
        'p-component-overlay p-component-overlay-enter': props.modal,
        'p-dialog-visible': maskVisibleState,
        'p-dialog-draggable': props.draggable,
        'p-dialog-resizable': props.resizable
      }, props.maskClassName);
    },
    root: function root(_ref5) {
      var props = _ref5.props,
        maximized = _ref5.maximized,
        context = _ref5.context;
      return classNames('p-dialog p-component', {
        'p-dialog-rtl': props.rtl,
        'p-dialog-maximized': maximized,
        'p-dialog-default': !maximized,
        'p-input-filled': context && context.inputStyle === 'filled' || PrimeReact.inputStyle === 'filled',
        'p-ripple-disabled': context && context.ripple === false || PrimeReact.ripple === false
      });
    },
    transition: 'p-dialog'
  };
  var styles$P = "\n@layer primereact {\n    .p-dialog-mask {\n        background-color: transparent;\n        transition-property: background-color;\n    }\n\n    .p-dialog-visible {\n        display: flex;\n    }\n\n    .p-dialog-mask.p-component-overlay {\n        pointer-events: auto;\n    }\n\n    .p-dialog {\n        display: flex;\n        flex-direction: column;\n        pointer-events: auto;\n        max-height: 90%;\n        transform: scale(1);\n        position: relative;\n    }\n\n    .p-dialog-content {\n        overflow-y: auto;\n        flex-grow: 1;\n    }\n\n    .p-dialog-header {\n        display: flex;\n        align-items: center;\n        flex-shrink: 0;\n    }\n\n    .p-dialog-footer {\n        flex-shrink: 0;\n    }\n\n    .p-dialog .p-dialog-header-icons {\n        display: flex;\n        align-items: center;\n        align-self: flex-start;\n        flex-shrink: 0;\n    }\n\n    .p-dialog .p-dialog-header-icon {\n        display: flex;\n        align-items: center;\n        justify-content: center;\n        overflow: hidden;\n        position: relative;\n    }\n\n    .p-dialog .p-dialog-title {\n        flex-grow: 1;\n    }\n\n    /* Fluid */\n    .p-fluid .p-dialog-footer .p-button {\n        width: auto;\n    }\n\n    /* Animation */\n    /* Center */\n    .p-dialog-enter {\n        opacity: 0;\n        transform: scale(0.7);\n    }\n\n    .p-dialog-enter-active {\n        opacity: 1;\n        transform: scale(1);\n        transition: all 150ms cubic-bezier(0, 0, 0.2, 1);\n    }\n\n    .p-dialog-enter-done {\n        transform: none;\n    }\n\n    .p-dialog-exit-active {\n        opacity: 0;\n        transform: scale(0.7);\n        transition: all 150ms cubic-bezier(0.4, 0, 0.2, 1);\n    }\n\n    /* Top, Bottom, Left, Right, Top* and Bottom* */\n    .p-dialog-top .p-dialog,\n    .p-dialog-bottom .p-dialog,\n    .p-dialog-left .p-dialog,\n    .p-dialog-right .p-dialog,\n    .p-dialog-top-left .p-dialog,\n    .p-dialog-top-right .p-dialog,\n    .p-dialog-bottom-left .p-dialog,\n    .p-dialog-bottom-right .p-dialog {\n        margin: 0.75em;\n    }\n\n    .p-dialog-top .p-dialog-enter,\n    .p-dialog-top .p-dialog-exit-active {\n        transform: translate3d(0px, -100%, 0px);\n    }\n\n    .p-dialog-bottom .p-dialog-enter,\n    .p-dialog-bottom .p-dialog-exit-active {\n        transform: translate3d(0px, 100%, 0px);\n    }\n\n    .p-dialog-left .p-dialog-enter,\n    .p-dialog-left .p-dialog-exit-active,\n    .p-dialog-top-left .p-dialog-enter,\n    .p-dialog-top-left .p-dialog-exit-active,\n    .p-dialog-bottom-left .p-dialog-enter,\n    .p-dialog-bottom-left .p-dialog-exit-active {\n        transform: translate3d(-100%, 0px, 0px);\n    }\n\n    .p-dialog-right .p-dialog-enter,\n    .p-dialog-right .p-dialog-exit-active,\n    .p-dialog-top-right .p-dialog-enter,\n    .p-dialog-top-right .p-dialog-exit-active,\n    .p-dialog-bottom-right .p-dialog-enter,\n    .p-dialog-bottom-right .p-dialog-exit-active {\n        transform: translate3d(100%, 0px, 0px);\n    }\n\n    .p-dialog-top .p-dialog-enter-active,\n    .p-dialog-bottom .p-dialog-enter-active,\n    .p-dialog-left .p-dialog-enter-active,\n    .p-dialog-top-left .p-dialog-enter-active,\n    .p-dialog-bottom-left .p-dialog-enter-active,\n    .p-dialog-right .p-dialog-enter-active,\n    .p-dialog-top-right .p-dialog-enter-active,\n    .p-dialog-bottom-right .p-dialog-enter-active {\n        transform: translate3d(0px, 0px, 0px);\n        transition: all 0.3s ease-out;\n    }\n\n    .p-dialog-top .p-dialog-exit-active,\n    .p-dialog-bottom .p-dialog-exit-active,\n    .p-dialog-left .p-dialog-exit-active,\n    .p-dialog-top-left .p-dialog-exit-active,\n    .p-dialog-bottom-left .p-dialog-exit-active,\n    .p-dialog-right .p-dialog-exit-active,\n    .p-dialog-top-right .p-dialog-exit-active,\n    .p-dialog-bottom-right .p-dialog-exit-active {\n        transition: all 0.3s ease-out;\n    }\n\n    /* Maximize */\n    .p-dialog-maximized {\n        transition: none;\n        transform: none;\n        margin: 0;\n        width: 100vw !important;\n        height: 100vh !important;\n        max-height: 100%;\n        top: 0px !important;\n        left: 0px !important;\n    }\n\n    .p-dialog-maximized .p-dialog-content {\n        flex-grow: 1;\n    }\n\n    .p-confirm-dialog .p-dialog-content {\n        display: flex;\n        align-items: center;\n    }\n\n    /* Resizable */\n    .p-dialog .p-resizable-handle {\n        position: absolute;\n        font-size: 0.1px;\n        display: block;\n        cursor: se-resize;\n        width: 12px;\n        height: 12px;\n        right: 1px;\n        bottom: 1px;\n    }\n\n    .p-dialog-draggable .p-dialog-header {\n        cursor: move;\n    }\n}\n";
  var inlineStyles$k = {
    mask: function mask(_ref6) {
      var props = _ref6.props;
      return _objectSpread$1B({
        position: 'fixed',
        height: '100%',
        width: '100%',
        left: 0,
        top: 0,
        display: 'flex',
        justifyContent: props.position === 'left' || props.position === 'top-left' || props.position === 'bottom-left' ? 'flex-start' : props.position === 'right' || props.position === 'top-right' || props.position === 'bottom-right' ? 'flex-end' : 'center',
        alignItems: props.position === 'top' || props.position === 'top-left' || props.position === 'top-right' ? 'flex-start' : props.position === 'bottom' || props.position === 'bottom-left' || props.position === 'bottom-right' ? 'flex-end' : 'center',
        pointerEvents: !props.modal && 'none'
      }, props.maskStyle);
    }
  };
  var DialogBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'Dialog',
      __parentMetadata: null,
      appendTo: null,
      ariaCloseIconLabel: null,
      baseZIndex: 0,
      blockScroll: false,
      breakpoints: null,
      className: null,
      closable: true,
      closeIcon: null,
      closeOnEscape: true,
      content: null,
      contentClassName: null,
      contentStyle: null,
      dismissableMask: false,
      draggable: true,
      focusOnShow: true,
      footer: null,
      footerClassName: null,
      header: null,
      headerClassName: null,
      headerStyle: null,
      icons: null,
      id: null,
      keepInViewport: true,
      maskClassName: null,
      maskStyle: null,
      maximizable: false,
      maximizeIcon: null,
      maximized: false,
      minX: 0,
      minY: 0,
      minimizeIcon: null,
      modal: true,
      onClick: null,
      onDrag: null,
      onDragEnd: null,
      onDragStart: null,
      onHide: null,
      onMaskClick: null,
      onMaximize: null,
      onResize: null,
      onResizeEnd: null,
      onResizeStart: null,
      onShow: null,
      position: 'center',
      resizable: true,
      rtl: false,
      showHeader: true,
      showCloseIcon: true,
      style: null,
      transitionOptions: null,
      visible: false,
      children: undefined
    },
    css: {
      classes: classes$$,
      styles: styles$P,
      inlineStyles: inlineStyles$k
    }
  });

  function ownKeys$1A(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1A(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1A(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1A(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var Dialog = /*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var mergeProps = useMergeProps();
    var context = React__namespace.useContext(PrimeReactContext);
    var props = DialogBase.getProps(inProps, context);
    var uniqueId = props.id ? props.id : UniqueComponentId();
    var _React$useState = React__namespace.useState(uniqueId),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      idState = _React$useState2[0];
      _React$useState2[1];
    var _React$useState3 = React__namespace.useState(false),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      maskVisibleState = _React$useState4[0],
      setMaskVisibleState = _React$useState4[1];
    var _React$useState5 = React__namespace.useState(false),
      _React$useState6 = _slicedToArray(_React$useState5, 2),
      visibleState = _React$useState6[0],
      setVisibleState = _React$useState6[1];
    var _React$useState7 = React__namespace.useState(props.maximized),
      _React$useState8 = _slicedToArray(_React$useState7, 2),
      maximizedState = _React$useState8[0],
      setMaximizedState = _React$useState8[1];
    var dialogRef = React__namespace.useRef(null);
    var maskRef = React__namespace.useRef(null);
    var pointerRef = React__namespace.useRef(null);
    var contentRef = React__namespace.useRef(null);
    var headerRef = React__namespace.useRef(null);
    var footerRef = React__namespace.useRef(null);
    var closeRef = React__namespace.useRef(null);
    var dragging = React__namespace.useRef(false);
    var resizing = React__namespace.useRef(false);
    var lastPageX = React__namespace.useRef(null);
    var lastPageY = React__namespace.useRef(null);
    var styleElement = React__namespace.useRef(null);
    var attributeSelector = React__namespace.useRef(uniqueId);
    var focusElementOnHide = React__namespace.useRef(null);
    var maximized = props.onMaximize ? props.maximized : maximizedState;
    var shouldBlockScroll = visibleState && (props.blockScroll || props.maximizable && maximized);
    var isCloseOnEscape = props.closable && props.closeOnEscape && visibleState;
    var displayOrder = useDisplayOrder('dialog', isCloseOnEscape);
    var _DialogBase$setMetaDa = DialogBase.setMetaData(_objectSpread$1A(_objectSpread$1A({
        props: props
      }, props.__parentMetadata), {}, {
        state: {
          id: idState,
          maximized: maximized,
          containerVisible: maskVisibleState
        }
      })),
      ptm = _DialogBase$setMetaDa.ptm,
      cx = _DialogBase$setMetaDa.cx,
      sx = _DialogBase$setMetaDa.sx,
      isUnstyled = _DialogBase$setMetaDa.isUnstyled;
    useHandleStyle(DialogBase.css.styles, isUnstyled, {
      name: 'dialog'
    });
    useGlobalOnEscapeKey({
      callback: function callback(event) {
        onClose(event);
      },
      when: isCloseOnEscape && displayOrder,
      priority: [ESC_KEY_HANDLING_PRIORITIES.DIALOG, displayOrder]
    });
    var _useEventListener = useEventListener({
        type: 'mousemove',
        target: function target() {
          return window.document;
        },
        listener: function listener(event) {
          return onResize(event);
        }
      }),
      _useEventListener2 = _slicedToArray(_useEventListener, 2),
      bindDocumentResizeListener = _useEventListener2[0],
      unbindDocumentResizeListener = _useEventListener2[1];
    var _useEventListener3 = useEventListener({
        type: 'mouseup',
        target: function target() {
          return window.document;
        },
        listener: function listener(event) {
          return onResizeEnd(event);
        }
      }),
      _useEventListener4 = _slicedToArray(_useEventListener3, 2),
      bindDocumentResizeEndListener = _useEventListener4[0],
      unbindDocumentResizEndListener = _useEventListener4[1];
    var _useEventListener5 = useEventListener({
        type: 'mousemove',
        target: function target() {
          return window.document;
        },
        listener: function listener(event) {
          return onDrag(event);
        }
      }),
      _useEventListener6 = _slicedToArray(_useEventListener5, 2),
      bindDocumentDragListener = _useEventListener6[0],
      unbindDocumentDragListener = _useEventListener6[1];
    var _useEventListener7 = useEventListener({
        type: 'mouseup',
        target: function target() {
          return window.document;
        },
        listener: function listener(event) {
          return onDragEnd(event);
        }
      }),
      _useEventListener8 = _slicedToArray(_useEventListener7, 2),
      bindDocumentDragEndListener = _useEventListener8[0],
      unbindDocumentDragEndListener = _useEventListener8[1];
    var onClose = function onClose(event) {
      props.onHide(event);
      event.preventDefault();
    };
    var focus = function focus() {
      var activeElement = document.activeElement;
      var isActiveElementInDialog = activeElement && dialogRef.current && dialogRef.current.contains(activeElement);
      if (!isActiveElementInDialog && props.closable && props.showCloseIcon && props.showHeader && closeRef.current) {
        closeRef.current.focus();
      }
    };
    var onDialogPointerDown = function onDialogPointerDown(event) {
      pointerRef.current = event.target;
      props.onPointerDown && props.onPointerDown(event);
    };
    var onMaskPointerUp = function onMaskPointerUp(event) {
      if (props.dismissableMask && props.modal && maskRef.current === event.target && !pointerRef.current) {
        onClose(event);
      }
      props.onMaskClick && props.onMaskClick(event);
      pointerRef.current = null;
    };
    var toggleMaximize = function toggleMaximize(event) {
      if (props.onMaximize) {
        props.onMaximize({
          originalEvent: event,
          maximized: !maximized
        });
      } else {
        setMaximizedState(function (prevMaximized) {
          return !prevMaximized;
        });
      }
      event.preventDefault();
    };
    var onDragStart = function onDragStart(event) {
      if (DomHandler.hasClass(event.target, 'p-dialog-header-icon') || DomHandler.hasClass(event.target.parentElement, 'p-dialog-header-icon')) {
        return;
      }
      if (props.draggable) {
        dragging.current = true;
        lastPageX.current = event.pageX;
        lastPageY.current = event.pageY;
        DomHandler.addClass(document.body, 'p-unselectable-text');
        props.onDragStart && props.onDragStart(event);
      }
    };
    var onDrag = function onDrag(event) {
      if (dragging.current) {
        var width = DomHandler.getOuterWidth(dialogRef.current);
        var height = DomHandler.getOuterHeight(dialogRef.current);
        var deltaX = event.pageX - lastPageX.current;
        var deltaY = event.pageY - lastPageY.current;
        var offset = dialogRef.current.getBoundingClientRect();
        var leftPos = offset.left + deltaX;
        var topPos = offset.top + deltaY;
        var viewport = DomHandler.getViewport();
        var computedStyle = getComputedStyle(dialogRef.current);
        var leftMargin = parseFloat(computedStyle.marginLeft);
        var topMargin = parseFloat(computedStyle.marginTop);
        dialogRef.current.style.position = 'fixed';
        if (props.keepInViewport) {
          if (leftPos >= props.minX && leftPos + width < viewport.width) {
            lastPageX.current = event.pageX;
            dialogRef.current.style.left = leftPos - leftMargin + 'px';
          }
          if (topPos >= props.minY && topPos + height < viewport.height) {
            lastPageY.current = event.pageY;
            dialogRef.current.style.top = topPos - topMargin + 'px';
          }
        } else {
          lastPageX.current = event.pageX;
          dialogRef.current.style.left = leftPos - leftMargin + 'px';
          lastPageY.current = event.pageY;
          dialogRef.current.style.top = topPos - topMargin + 'px';
        }
        props.onDrag && props.onDrag(event);
      }
    };
    var onDragEnd = function onDragEnd(event) {
      if (dragging.current) {
        dragging.current = false;
        DomHandler.removeClass(document.body, 'p-unselectable-text');
        props.onDragEnd && props.onDragEnd(event);
      }
    };
    var onResizeStart = function onResizeStart(event) {
      if (props.resizable) {
        resizing.current = true;
        lastPageX.current = event.pageX;
        lastPageY.current = event.pageY;
        DomHandler.addClass(document.body, 'p-unselectable-text');
        props.onResizeStart && props.onResizeStart(event);
      }
    };
    var convertToPx = function convertToPx(value, property, viewport) {
      !viewport && (viewport = DomHandler.getViewport());
      var val = parseInt(value);
      if (/^(\d+|(\.\d+))(\.\d+)?%$/.test(value)) {
        return val * (viewport[property] / 100);
      }
      return val;
    };
    var onResize = function onResize(event) {
      if (resizing.current) {
        var deltaX = event.pageX - lastPageX.current;
        var deltaY = event.pageY - lastPageY.current;
        var width = DomHandler.getOuterWidth(dialogRef.current);
        var height = DomHandler.getOuterHeight(dialogRef.current);
        var offset = dialogRef.current.getBoundingClientRect();
        var viewport = DomHandler.getViewport();
        var hasBeenDragged = !parseInt(dialogRef.current.style.top) || !parseInt(dialogRef.current.style.left);
        var minWidth = convertToPx(dialogRef.current.style.minWidth, 'width', viewport);
        var minHeight = convertToPx(dialogRef.current.style.minHeight, 'height', viewport);
        var newWidth = width + deltaX;
        var newHeight = height + deltaY;
        if (hasBeenDragged) {
          newWidth = newWidth + deltaX;
          newHeight = newHeight + deltaY;
        }
        if ((!minWidth || newWidth > minWidth) && offset.left + newWidth < viewport.width) {
          dialogRef.current.style.width = newWidth + 'px';
        }
        if ((!minHeight || newHeight > minHeight) && offset.top + newHeight < viewport.height) {
          dialogRef.current.style.height = newHeight + 'px';
        }
        lastPageX.current = event.pageX;
        lastPageY.current = event.pageY;
        props.onResize && props.onResize(event);
      }
    };
    var onResizeEnd = function onResizeEnd(event) {
      if (resizing.current) {
        resizing.current = false;
        DomHandler.removeClass(document.body, 'p-unselectable-text');
        props.onResizeEnd && props.onResizeEnd(event);
      }
    };
    var resetPosition = function resetPosition() {
      dialogRef.current.style.position = '';
      dialogRef.current.style.left = '';
      dialogRef.current.style.top = '';
      dialogRef.current.style.margin = '';
    };
    var onEnter = function onEnter() {
      dialogRef.current.setAttribute(attributeSelector.current, '');
    };
    var onEntered = function onEntered() {
      props.onShow && props.onShow();
      if (props.focusOnShow) {
        focus();
      }
      enableDocumentSettings();
    };
    var onExiting = function onExiting() {
      if (props.modal) {
        !isUnstyled() && DomHandler.addClass(maskRef.current, 'p-component-overlay-leave');
      }
    };
    var onExited = function onExited() {
      dragging.current = false;
      ZIndexUtils.clear(maskRef.current);
      setMaskVisibleState(false);
      disableDocumentSettings();

      // return focus to element before dialog was open
      DomHandler.focus(focusElementOnHide.current);
      focusElementOnHide.current = null;
    };
    var enableDocumentSettings = function enableDocumentSettings() {
      bindGlobalListeners();
    };
    var disableDocumentSettings = function disableDocumentSettings() {
      unbindGlobalListeners();
    };
    var updateScrollBlocker = function updateScrollBlocker() {
      // Scroll should be unblocked if there is at least one dialog that blocks scrolling:
      var isThereAnyDialogThatBlocksScrolling = document.primeDialogParams && document.primeDialogParams.some(function (i) {
        return i.hasBlockScroll;
      });
      if (isThereAnyDialogThatBlocksScrolling) {
        DomHandler.blockBodyScroll();
      } else {
        DomHandler.unblockBodyScroll();
      }
    };
    var updateGlobalDialogsRegistry = function updateGlobalDialogsRegistry(isMounted) {
      // Update current dialog info in global registry if it is mounted and visible:
      if (isMounted && visibleState) {
        var newParam = {
          id: idState,
          hasBlockScroll: shouldBlockScroll
        };

        // Create registry if not yet created:
        if (!document.primeDialogParams) {
          document.primeDialogParams = [];
        }
        var currentDialogIndexInRegistry = document.primeDialogParams.findIndex(function (dialogInRegistry) {
          return dialogInRegistry.id === idState;
        });
        if (currentDialogIndexInRegistry === -1) {
          document.primeDialogParams = [].concat(_toConsumableArray(document.primeDialogParams), [newParam]);
        } else {
          document.primeDialogParams = document.primeDialogParams.toSpliced(currentDialogIndexInRegistry, 1, newParam);
        }
      }
      // Or remove it from global registry if unmounted or invisible:
      else {
        document.primeDialogParams = document.primeDialogParams && document.primeDialogParams.filter(function (param) {
          return param.id !== idState;
        });
      }

      // Always update scroll blocker after dialog registry - this way we ensure that
      // p-overflow-hidden class is properly added/removed:
      updateScrollBlocker();
    };
    var bindGlobalListeners = function bindGlobalListeners() {
      if (props.draggable) {
        bindDocumentDragListener();
        bindDocumentDragEndListener();
      }
      if (props.resizable) {
        bindDocumentResizeListener();
        bindDocumentResizeEndListener();
      }
    };
    var unbindGlobalListeners = function unbindGlobalListeners() {
      unbindDocumentDragListener();
      unbindDocumentDragEndListener();
      unbindDocumentResizeListener();
      unbindDocumentResizEndListener();
    };
    var createStyle = function createStyle() {
      styleElement.current = DomHandler.createInlineStyle(context && context.nonce || PrimeReact.nonce, context && context.styleContainer);
      var innerHTML = '';
      for (var breakpoint in props.breakpoints) {
        innerHTML = innerHTML + "\n                @media screen and (max-width: ".concat(breakpoint, ") {\n                     [data-pc-name=\"dialog\"][").concat(attributeSelector.current, "] {\n                        width: ").concat(props.breakpoints[breakpoint], " !important;\n                    }\n                }\n            ");
      }
      styleElement.current.innerHTML = innerHTML;
    };
    var destroyStyle = function destroyStyle() {
      styleElement.current = DomHandler.removeInlineStyle(styleElement.current);
    };
    useMountEffect(function () {
      updateGlobalDialogsRegistry(true);
      if (props.visible) {
        setMaskVisibleState(true);
      }
    });
    React__namespace.useEffect(function () {
      if (props.breakpoints) {
        createStyle();
      }
      return function () {
        destroyStyle();
      };
      // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [props.breakpoints]);
    useUpdateEffect(function () {
      if (props.visible && !maskVisibleState) {
        setMaskVisibleState(true);
      }
      if (props.visible !== visibleState && maskVisibleState) {
        setVisibleState(props.visible);
      }
      if (props.visible) {
        // Remember the focused element before we opened the dialog
        // so we can return focus to it once we close the dialog.
        focusElementOnHide.current = document.activeElement;
      }
    }, [props.visible, maskVisibleState]);
    useUpdateEffect(function () {
      if (maskVisibleState) {
        ZIndexUtils.set('modal', maskRef.current, context && context.autoZIndex || PrimeReact.autoZIndex, props.baseZIndex || context && context.zIndex.modal || PrimeReact.zIndex.modal);
        setVisibleState(true);
      }
    }, [maskVisibleState]);
    useUpdateEffect(function () {
      updateGlobalDialogsRegistry(true);
    }, [shouldBlockScroll, visibleState]);
    useUnmountEffect(function () {
      disableDocumentSettings();
      updateGlobalDialogsRegistry(false);
      DomHandler.removeInlineStyle(styleElement.current);
      ZIndexUtils.clear(maskRef.current);
    });
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        resetPosition: resetPosition,
        getElement: function getElement() {
          return dialogRef.current;
        },
        getMask: function getMask() {
          return maskRef.current;
        },
        getContent: function getContent() {
          return contentRef.current;
        },
        getHeader: function getHeader() {
          return headerRef.current;
        },
        getFooter: function getFooter() {
          return footerRef.current;
        },
        getCloseButton: function getCloseButton() {
          return closeRef.current;
        }
      };
    });
    var createCloseIcon = function createCloseIcon() {
      if (props.closable && props.showCloseIcon) {
        var labelAria = props.ariaCloseIconLabel || ariaLabel('close');
        var closeButtonIconProps = mergeProps({
          className: cx('closeButtonIcon'),
          'aria-hidden': true
        }, ptm('closeButtonIcon'));
        var icon = props.closeIcon || /*#__PURE__*/React__namespace.createElement(TimesIcon, closeButtonIconProps);
        var headerCloseIcon = IconUtils.getJSXIcon(icon, _objectSpread$1A({}, closeButtonIconProps), {
          props: props
        });
        var closeButtonProps = mergeProps({
          ref: closeRef,
          type: 'button',
          className: cx('closeButton'),
          'aria-label': labelAria,
          onClick: onClose,
          onKeyDown: function onKeyDown(ev) {
            if (ev.key !== 'Escape') {
              ev.stopPropagation();
            }
          }
        }, ptm('closeButton'));
        return /*#__PURE__*/React__namespace.createElement("button", closeButtonProps, headerCloseIcon, /*#__PURE__*/React__namespace.createElement(Ripple, null));
      }
      return null;
    };
    var createMaximizeIcon = function createMaximizeIcon() {
      var icon;
      var maximizableIconProps = mergeProps({
        className: cx('maximizableIcon')
      }, ptm('maximizableIcon'));
      if (!maximized) {
        icon = props.maximizeIcon || /*#__PURE__*/React__namespace.createElement(WindowMaximizeIcon, maximizableIconProps);
      } else {
        icon = props.minimizeIcon || /*#__PURE__*/React__namespace.createElement(WindowMinimizeIcon, maximizableIconProps);
      }
      var toggleIcon = IconUtils.getJSXIcon(icon, maximizableIconProps, {
        props: props
      });
      if (props.maximizable) {
        var maximizableButtonProps = mergeProps({
          type: 'button',
          className: cx('maximizableButton'),
          onClick: toggleMaximize
        }, ptm('maximizableButton'));
        return /*#__PURE__*/React__namespace.createElement("button", maximizableButtonProps, toggleIcon, /*#__PURE__*/React__namespace.createElement(Ripple, null));
      }
      return null;
    };
    var createHeader = function createHeader() {
      if (props.showHeader) {
        var closeIcon = createCloseIcon();
        var maximizeIcon = createMaximizeIcon();
        var icons = ObjectUtils.getJSXElement(props.icons, props);
        var header = ObjectUtils.getJSXElement(props.header, props);
        var headerId = idState + '_header';
        var headerProps = mergeProps({
          ref: headerRef,
          style: props.headerStyle,
          className: cx('header'),
          onMouseDown: onDragStart
        }, ptm('header'));
        var headerTitleProps = mergeProps({
          id: headerId,
          className: cx('headerTitle')
        }, ptm('headerTitle'));
        var headerIconsProps = mergeProps({
          className: cx('headerIcons')
        }, ptm('headerIcons'));
        return /*#__PURE__*/React__namespace.createElement("div", headerProps, /*#__PURE__*/React__namespace.createElement("div", headerTitleProps, header), /*#__PURE__*/React__namespace.createElement("div", headerIconsProps, icons, maximizeIcon, closeIcon));
      }
      return null;
    };
    var createContent = function createContent() {
      var contentId = idState + '_content';
      var contentProps = mergeProps({
        id: contentId,
        ref: contentRef,
        style: props.contentStyle,
        className: cx('content')
      }, ptm('content'));
      return /*#__PURE__*/React__namespace.createElement("div", contentProps, props.children);
    };
    var createFooter = function createFooter() {
      var footer = ObjectUtils.getJSXElement(props.footer, props);
      var footerProps = mergeProps({
        ref: footerRef,
        className: cx('footer')
      }, ptm('footer'));
      return footer && /*#__PURE__*/React__namespace.createElement("div", footerProps, footer);
    };
    var createResizer = function createResizer() {
      if (props.resizable) {
        return /*#__PURE__*/React__namespace.createElement("span", {
          className: "p-resizable-handle",
          style: {
            zIndex: 90
          },
          onMouseDown: onResizeStart
        });
      }
      return null;
    };
    var createTemplateElement = function createTemplateElement() {
      var _props$children;
      var messageProps = {
        header: props.header,
        content: props.message,
        message: props === null || props === void 0 || (_props$children = props.children) === null || _props$children === void 0 || (_props$children = _props$children[1]) === null || _props$children === void 0 || (_props$children = _props$children.props) === null || _props$children === void 0 ? void 0 : _props$children.children
      };
      var templateElementProps = {
        headerRef: headerRef,
        contentRef: contentRef,
        footerRef: footerRef,
        closeRef: closeRef,
        hide: onClose,
        message: messageProps
      };
      return ObjectUtils.getJSXElement(inProps.content, templateElementProps);
    };
    var createElement = function createElement() {
      var header = createHeader();
      var content = createContent();
      var footer = createFooter();
      var resizer = createResizer();
      return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, null, header, content, footer, resizer);
    };
    var createDialog = function createDialog() {
      var headerId = idState + '_header';
      var contentId = idState + '_content';
      var transitionTimeout = {
        enter: props.position === 'center' ? 150 : 300,
        exit: props.position === 'center' ? 150 : 300
      };
      var maskProps = mergeProps({
        ref: maskRef,
        style: sx('mask'),
        className: cx('mask'),
        onPointerUp: onMaskPointerUp
      }, ptm('mask'));
      var rootProps = mergeProps({
        ref: dialogRef,
        id: idState,
        className: classNames(props.className, cx('root', {
          props: props,
          maximized: maximized,
          context: context
        })),
        style: props.style,
        onClick: props.onClick,
        role: 'dialog',
        'aria-labelledby': headerId,
        'aria-describedby': contentId,
        'aria-modal': props.modal,
        onPointerDown: onDialogPointerDown
      }, DialogBase.getOtherProps(props), ptm('root'));
      var transitionProps = mergeProps({
        classNames: cx('transition'),
        timeout: transitionTimeout,
        "in": visibleState,
        options: props.transitionOptions,
        unmountOnExit: true,
        onEnter: onEnter,
        onEntered: onEntered,
        onExiting: onExiting,
        onExited: onExited
      }, ptm('transition'));
      var contentElement = null;
      if (inProps !== null && inProps !== void 0 && inProps.content) {
        contentElement = createTemplateElement();
      } else {
        contentElement = createElement();
      }
      var rootElement = /*#__PURE__*/React__namespace.createElement("div", maskProps, /*#__PURE__*/React__namespace.createElement(CSSTransition, _extends({
        nodeRef: dialogRef
      }, transitionProps), /*#__PURE__*/React__namespace.createElement("div", rootProps, /*#__PURE__*/React__namespace.createElement(FocusTrap$1, {
        autoFocus: props.focusOnShow
      }, contentElement))));
      return /*#__PURE__*/React__namespace.createElement(Portal, {
        element: rootElement,
        appendTo: props.appendTo,
        visible: true
      });
    };
    return maskVisibleState && createDialog();
  });
  Dialog.displayName = 'Dialog';

  var classes$_ = {
    root: 'p-confirm-dialog',
    message: 'p-confirm-dialog-message',
    icon: 'p-confirm-dialog-icon',
    acceptButton: 'p-confirm-dialog-accept',
    rejectButton: function rejectButton(_ref) {
      var getPropValue = _ref.getPropValue;
      return classNames('p-confirm-dialog-reject', {
        'p-button-text': !getPropValue('rejectClassName')
      });
    }
  };
  var ConfirmDialogBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'ConfirmDialog',
      accept: null,
      acceptClassName: null,
      acceptIcon: null,
      acceptLabel: null,
      appendTo: null,
      breakpoints: null,
      children: undefined,
      className: null,
      content: null,
      defaultFocus: 'accept',
      footer: null,
      icon: null,
      message: null,
      onHide: null,
      reject: null,
      rejectClassName: null,
      rejectIcon: null,
      rejectLabel: null,
      tagKey: undefined,
      visible: undefined
    },
    css: {
      classes: classes$_
    }
  });

  function ownKeys$1z(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1z(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1z(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1z(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var confirmDialog = function confirmDialog() {
    var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    props = _objectSpread$1z(_objectSpread$1z({}, props), {
      visible: props.visible === undefined ? true : props.visible
    });
    props.visible && OverlayService.emit('confirm-dialog', props);
    var show = function show() {
      var updatedProps = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      OverlayService.emit('confirm-dialog', _objectSpread$1z(_objectSpread$1z(_objectSpread$1z({}, props), updatedProps), {
        visible: true
      }));
    };
    var hide = function hide() {
      OverlayService.emit('confirm-dialog', {
        visible: false
      });
    };
    return {
      show: show,
      hide: hide
    };
  };
  var ConfirmDialog = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var mergeProps = useMergeProps();
    var context = React__namespace.useContext(PrimeReactContext);
    var props = ConfirmDialogBase.getProps(inProps, context);
    var _React$useState = React__namespace.useState(props.visible),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      visibleState = _React$useState2[0],
      setVisibleState = _React$useState2[1];
    var _React$useState3 = React__namespace.useState(false),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      reshowState = _React$useState4[0],
      setReshowState = _React$useState4[1];
    var confirmProps = React__namespace.useRef(null);
    var isCallbackExecuting = React__namespace.useRef(false);
    var focusElementOnHide = React__namespace.useRef(null);
    var getCurrentProps = function getCurrentProps() {
      var group = props.group;
      if (confirmProps.current) {
        group = confirmProps.current.group;
      }
      return Object.assign({}, props, confirmProps.current, {
        group: group
      });
    };
    var getPropValue = function getPropValue(key) {
      return getCurrentProps()[key];
    };
    var callbackFromProp = function callbackFromProp(key) {
      for (var _len = arguments.length, param = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        param[_key - 1] = arguments[_key];
      }
      return ObjectUtils.getPropValue(getPropValue(key), param);
    };
    var acceptLabel = getPropValue('acceptLabel') || localeOption('accept');
    var rejectLabel = getPropValue('rejectLabel') || localeOption('reject');
    var metaData = {
      props: props,
      state: {
        visible: visibleState
      }
    };
    var _ConfirmDialogBase$se = ConfirmDialogBase.setMetaData(metaData),
      ptm = _ConfirmDialogBase$se.ptm,
      cx = _ConfirmDialogBase$se.cx,
      isUnstyled = _ConfirmDialogBase$se.isUnstyled;
    useHandleStyle(ConfirmDialogBase.css.styles, isUnstyled, {
      name: 'confirmdialog'
    });
    var accept = function accept() {
      if (!isCallbackExecuting.current) {
        isCallbackExecuting.current = true;
        callbackFromProp('accept');
        hide('accept');
      }
    };
    var reject = function reject() {
      if (!isCallbackExecuting.current) {
        isCallbackExecuting.current = true;
        callbackFromProp('reject');
        hide('reject');
      }
    };
    var show = function show() {
      var currentProps = getCurrentProps();
      if (currentProps.group === props.group) {
        setVisibleState(true);
        isCallbackExecuting.current = false;

        // Remember the focused element before we opened the dialog
        // so we can return focus to it once we close the dialog.
        focusElementOnHide.current = document.activeElement;
      }
    };
    var hide = function hide() {
      var result = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'cancel';
      if (visibleState) {
        if (typeof result !== 'string') {
          result = 'cancel';
        }
        setVisibleState(false);
        callbackFromProp('onHide', result);
        DomHandler.focus(focusElementOnHide.current);
        focusElementOnHide.current = null;
      }
    };
    var confirm = function confirm(updatedProps) {
      if (updatedProps.tagKey === props.tagKey) {
        var isVisibleChanged = visibleState !== updatedProps.visible;
        var targetChanged = getPropValue('target') !== updatedProps.target;
        if (targetChanged && !props.target) {
          hide();
          confirmProps.current = updatedProps;
          setReshowState(true);
        } else if (isVisibleChanged) {
          confirmProps.current = updatedProps;
          updatedProps.visible ? show() : hide();
        }
      }
    };
    React__namespace.useEffect(function () {
      props.visible ? show() : hide();
      // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [props.visible]);
    React__namespace.useEffect(function () {
      if (!props.target && !props.message) {
        OverlayService.on('confirm-dialog', confirm);
      }
      return function () {
        OverlayService.off('confirm-dialog', confirm);
      };
      // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [props.target]);
    useUpdateEffect(function () {
      reshowState && show();
    }, [reshowState]);
    useUnmountEffect(function () {
      OverlayService.off('confirm-dialog', confirm);
    });
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        confirm: confirm
      };
    });
    var createFooter = function createFooter() {
      var defaultFocus = getPropValue('defaultFocus');
      var acceptClassName = classNames('p-confirm-dialog-accept', getPropValue('acceptClassName'));
      var rejectClassName = classNames('p-confirm-dialog-reject', {
        'p-button-text': !getPropValue('rejectClassName')
      }, getPropValue('rejectClassName'));
      var rejectButtonProps = mergeProps({
        label: rejectLabel,
        autoFocus: defaultFocus === 'reject',
        icon: getPropValue('rejectIcon'),
        className: classNames(getPropValue('rejectClassName'), cx('rejectButton', {
          getPropValue: getPropValue
        })),
        onClick: reject,
        pt: ptm('rejectButton'),
        unstyled: props.unstyled,
        __parentMetadata: {
          parent: metaData
        }
      }, ptm('rejectButton'));
      var acceptButtonProps = mergeProps({
        label: acceptLabel,
        autoFocus: defaultFocus === undefined || defaultFocus === 'accept',
        icon: getPropValue('acceptIcon'),
        className: classNames(getPropValue('acceptClassName'), cx('acceptButton')),
        onClick: accept,
        pt: ptm('acceptButton'),
        unstyled: props.unstyled,
        __parentMetadata: {
          parent: metaData
        }
      }, ptm('acceptButton'));
      var content = /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, null, /*#__PURE__*/React__namespace.createElement(Button, rejectButtonProps), /*#__PURE__*/React__namespace.createElement(Button, acceptButtonProps));
      if (getPropValue('footer')) {
        var defaultContentOptions = {
          accept: accept,
          reject: reject,
          acceptClassName: acceptClassName,
          rejectClassName: rejectClassName,
          acceptLabel: acceptLabel,
          rejectLabel: rejectLabel,
          element: content,
          props: getCurrentProps()
        };
        return ObjectUtils.getJSXElement(getPropValue('footer'), defaultContentOptions);
      }
      return content;
    };
    var createElement = function createElement() {
      var currentProps = getCurrentProps();
      var message = ObjectUtils.getJSXElement(getPropValue('message'), currentProps);
      var iconProps = mergeProps({
        className: cx('icon')
      }, ptm('icon'));
      var icon = IconUtils.getJSXIcon(getPropValue('icon'), _objectSpread$1z({}, iconProps), {
        props: currentProps
      });
      var footer = createFooter();
      var messageProps = mergeProps({
        className: cx('message')
      }, ptm('message'));
      var rootProps = mergeProps({
        visible: visibleState,
        className: classNames(getPropValue('className'), cx('root')),
        footer: footer,
        onHide: hide,
        breakpoints: getPropValue('breakpoints'),
        pt: currentProps.pt,
        unstyled: props.unstyled,
        appendTo: getPropValue('appendTo'),
        __parentMetadata: {
          parent: metaData
        }
      }, ConfirmDialogBase.getOtherProps(currentProps));
      return /*#__PURE__*/React__namespace.createElement(Dialog, _extends({}, rootProps, {
        content: inProps === null || inProps === void 0 ? void 0 : inProps.content
      }), icon, /*#__PURE__*/React__namespace.createElement("span", messageProps, message));
    };
    var element = createElement();
    return /*#__PURE__*/React__namespace.createElement(Portal, {
      element: element,
      appendTo: getPropValue('appendTo')
    });
  }));
  ConfirmDialog.displayName = 'ConfirmDialog';

  var styles$O = "\n@layer primereact {\n   .p-confirm-popup {\n        margin-top: 10px;       \n    }\n\n    .p-confirm-popup-flipped {\n        margin-top: -10px;\n    }\n    \n    .p-confirm-popup:after, .p-confirm-popup:before {\n        bottom: 100%;\n        left: calc(var(--overlayArrowLeft, 0) + 1.25rem);\n        content: \" \";\n        height: 0;\n        width: 0;\n        position: absolute;\n        pointer-events: none;\n    }\n    \n    .p-confirm-popup:after {\n        border-width: 8px;\n        margin-left: -8px;\n    }\n    \n    .p-confirm-popup:before {\n        border-width: 10px;\n        margin-left: -10px;\n    }\n    \n    .p-confirm-popup-flipped:after, .p-confirm-popup-flipped:before {\n        bottom: auto;\n        top: 100%;\n    }\n    \n    .p-confirm-popup.p-confirm-popup-flipped:after {\n        border-bottom-color: transparent;\n    }\n    \n    .p-confirm-popup.p-confirm-popup-flipped:before {\n        border-bottom-color: transparent\n    }\n    \n    .p-confirm-popup .p-confirm-popup-content {\n        display: flex;\n        align-items: center;\n    }\n}\n";
  var classes$Z = {
    root: function root(_ref) {
      var context = _ref.context,
        getPropValue = _ref.getPropValue;
      return classNames('p-confirm-popup p-component', getPropValue('className'), {
        'p-input-filled': context && context.inputStyle === 'filled' || PrimeReact.inputStyle === 'filled',
        'p-ripple-disabled': context && context.ripple === false || PrimeReact.ripple === false
      });
    },
    acceptButton: function acceptButton(_ref2) {
      var getPropValue = _ref2.getPropValue;
      return classNames('p-confirm-popup-accept p-button-sm', getPropValue('acceptClassName'));
    },
    rejectButton: function rejectButton(_ref3) {
      var getPropValue = _ref3.getPropValue;
      return classNames('p-confirm-popup-reject p-button-sm', {
        'p-button-text': !getPropValue('rejectClassName')
      }, getPropValue('rejectClassName'));
    },
    content: 'p-confirm-popup-content',
    icon: 'p-confirm-popup-icon',
    message: 'p-confirm-popup-message',
    footer: 'p-confirm-popup-footer',
    transition: 'p-connected-overlay'
  };
  var ConfirmPopupBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'ConfirmPopup',
      accept: null,
      acceptClassName: null,
      acceptIcon: null,
      acceptLabel: null,
      appendTo: null,
      children: undefined,
      className: null,
      closeOnEscape: true,
      content: null,
      defaultFocus: 'accept',
      dismissable: true,
      footer: null,
      icon: null,
      message: null,
      onHide: null,
      onShow: null,
      reject: null,
      rejectClassName: null,
      rejectIcon: null,
      rejectLabel: null,
      style: null,
      tagKey: undefined,
      target: null,
      transitionOptions: null,
      visible: false
    },
    css: {
      classes: classes$Z,
      styles: styles$O
    }
  });

  function ownKeys$1y(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1y(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1y(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1y(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var confirmPopup = function confirmPopup() {
    var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    props = _objectSpread$1y(_objectSpread$1y({}, props), {
      visible: props.visible === undefined ? true : props.visible
    });
    props.visible && OverlayService.emit('confirm-popup', props);
    var show = function show() {
      var updatedProps = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      OverlayService.emit('confirm-popup', _objectSpread$1y(_objectSpread$1y(_objectSpread$1y({}, props), updatedProps), {
        visible: true
      }));
    };
    var hide = function hide() {
      OverlayService.emit('confirm-popup', {
        visible: false
      });
    };
    return {
      show: show,
      hide: hide
    };
  };
  var ConfirmPopup = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var mergeProps = useMergeProps();
    var context = React__namespace.useContext(PrimeReactContext);
    var props = ConfirmPopupBase.getProps(inProps, context);
    var _React$useState = React__namespace.useState(props.visible),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      visibleState = _React$useState2[0],
      setVisibleState = _React$useState2[1];
    var _React$useState3 = React__namespace.useState(false),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      reshowState = _React$useState4[0],
      setReshowState = _React$useState4[1];
    var metaData = {
      props: props,
      state: {
        visible: visibleState,
        reshow: reshowState
      }
    };
    var _ConfirmPopupBase$set = ConfirmPopupBase.setMetaData(metaData),
      ptm = _ConfirmPopupBase$set.ptm,
      cx = _ConfirmPopupBase$set.cx,
      isUnstyled = _ConfirmPopupBase$set.isUnstyled;
    useHandleStyle(ConfirmPopupBase.css.styles, isUnstyled, {
      name: 'confirmpopup'
    });
    var overlayRef = React__namespace.useRef(null);
    var acceptBtnRef = React__namespace.useRef(null);
    var rejectBtnRef = React__namespace.useRef(null);
    var isPanelClicked = React__namespace.useRef(false);
    var overlayEventListener = React__namespace.useRef(null);
    var confirmProps = React__namespace.useRef(null);
    var focusElementOnHide = React__namespace.useRef(null);
    var isCallbackExecuting = React__namespace.useRef(false);
    var getCurrentProps = function getCurrentProps() {
      return confirmProps.current || props;
    };
    var getPropValue = function getPropValue(key) {
      return (confirmProps.current || props)[key];
    };
    var callbackFromProp = function callbackFromProp(key) {
      for (var _len = arguments.length, param = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        param[_key - 1] = arguments[_key];
      }
      return ObjectUtils.getPropValue(getPropValue(key), param);
    };
    var acceptLabel = getPropValue('acceptLabel') || localeOption('accept');
    var rejectLabel = getPropValue('rejectLabel') || localeOption('reject');
    var isCloseOnEscape = props.dismissable && props.closeOnEscape && visibleState;
    var displayOrder = useDisplayOrder('dialog', isCloseOnEscape);
    useGlobalOnEscapeKey({
      callback: function callback() {
        hide('hide');
      },
      when: isCloseOnEscape && displayOrder,
      priority: [ESC_KEY_HANDLING_PRIORITIES.DIALOG, displayOrder]
    });
    var _useOverlayListener = useOverlayListener({
        target: getPropValue('target'),
        overlay: overlayRef,
        listener: function listener(event, _ref) {
          var type = _ref.type,
            valid = _ref.valid;
          if (valid) {
            if (type === 'outside') {
              if (props.dismissable && !isPanelClicked.current) {
                hide('hide');
              }
              isPanelClicked.current = false;
            } else if (context.hideOverlaysOnDocumentScrolling) {
              hide('hide');
            } else if (!DomHandler.isDocument(event.target)) {
              align();
            }
          }
        },
        when: visibleState
      }),
      _useOverlayListener2 = _slicedToArray(_useOverlayListener, 2),
      bindOverlayListener = _useOverlayListener2[0],
      unbindOverlayListener = _useOverlayListener2[1];
    var onPanelClick = function onPanelClick(event) {
      isPanelClicked.current = true;
      OverlayService.emit('overlay-click', {
        originalEvent: event,
        target: getPropValue('target')
      });
    };
    var accept = function accept() {
      if (!isCallbackExecuting.current) {
        isCallbackExecuting.current = true;
        callbackFromProp('accept');
        hide('accept');
      }
    };
    var reject = function reject() {
      if (!isCallbackExecuting.current) {
        isCallbackExecuting.current = true;
        callbackFromProp('reject');
        hide('reject');
      }
    };
    var show = function show() {
      var currentProps = getCurrentProps();
      setReshowState(false);
      if (currentProps.group === props.group) {
        setVisibleState(true);
        isCallbackExecuting.current = false;
        overlayEventListener.current = function (e) {
          !isOutsideClicked(e.target) && (isPanelClicked.current = true);
        };
        OverlayService.on('overlay-click', overlayEventListener.current);

        // Remember the focused element before we opened the dialog
        // so we can return focus to it once we close the dialog.
        focusElementOnHide.current = document.activeElement;
      }
    };
    var hide = function hide(result) {
      setVisibleState(false);
      OverlayService.off('overlay-click', overlayEventListener.current);
      overlayEventListener.current = null;
      if (result) {
        callbackFromProp('onHide', result);
      }
      DomHandler.focus(focusElementOnHide.current);
      focusElementOnHide.current = null;
    };
    var onEnter = function onEnter() {
      ZIndexUtils.set('overlay', overlayRef.current, context && context.autoZIndex || PrimeReact.autoZIndex, context && context.zIndex.overlay || PrimeReact.zIndex.overlay);
      DomHandler.addStyles(overlayRef.current, {
        position: 'absolute',
        top: '0',
        left: '0'
      });
      align();
    };
    var onEntered = function onEntered() {
      bindOverlayListener();
      var defaultFocus = getPropValue('defaultFocus');
      if (defaultFocus === undefined || defaultFocus === 'accept') {
        acceptBtnRef.current && acceptBtnRef.current.focus();
      }
      if (defaultFocus === 'reject') {
        rejectBtnRef.current && rejectBtnRef.current.focus();
      }
      callbackFromProp('onShow');
    };
    var onExit = function onExit() {
      unbindOverlayListener();
    };
    var onExited = function onExited() {
      ZIndexUtils.clear(overlayRef.current);
      isPanelClicked.current = false;
    };
    var align = function align() {
      if (getPropValue('target')) {
        DomHandler.absolutePosition(overlayRef.current, getPropValue('target'));
        var containerOffset = DomHandler.getOffset(overlayRef.current);
        var targetOffset = DomHandler.getOffset(getPropValue('target'));
        var arrowLeft = 0;
        if (containerOffset.left < targetOffset.left) {
          arrowLeft = targetOffset.left - containerOffset.left;
        }
        overlayRef.current.style.setProperty('--overlayArrowLeft', "".concat(arrowLeft, "px"));
        if (containerOffset.top < targetOffset.top) {
          !isUnstyled() && DomHandler.addClass(overlayRef.current, 'p-confirm-popup-flipped');
        }
      }
    };
    var isOutsideClicked = function isOutsideClicked(target) {
      return overlayRef && overlayRef.current && !(overlayRef.current.isSameNode(target) || overlayRef.current.contains(target));
    };
    var confirm = function confirm(updatedProps) {
      if (updatedProps.tagKey === props.tagKey) {
        var isVisibleChanged = visibleState !== updatedProps.visible;
        var targetChanged = getPropValue('target') !== updatedProps.target;
        if (targetChanged && !props.target) {
          hide();
          confirmProps.current = updatedProps;
          setReshowState(true);
        } else if (isVisibleChanged) {
          confirmProps.current = updatedProps;
          updatedProps.visible ? show() : hide();
        }
      }
    };
    React__namespace.useEffect(function () {
      props.visible ? show() : hide();
      // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [props.visible]);
    React__namespace.useEffect(function () {
      if (!props.target && !props.message) {
        OverlayService.on('confirm-popup', confirm);
      }
      return function () {
        OverlayService.off('confirm-popup', confirm);
      };
      // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [props.target]);
    useUpdateEffect(function () {
      reshowState && show();
    }, [reshowState]);
    useUnmountEffect(function () {
      if (overlayEventListener.current) {
        OverlayService.off('overlay-click', overlayEventListener.current);
        overlayEventListener.current = null;
      }
      OverlayService.off('confirm-popup', confirm);
      ZIndexUtils.clear(overlayRef.current);
    });
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        confirm: confirm
      };
    });
    var createContent = function createContent() {
      var currentProps = getCurrentProps();
      var message = ObjectUtils.getJSXElement(getPropValue('message'), currentProps);
      var iconProps = mergeProps({
        className: cx('icon')
      }, ptm('icon'));
      var icon = IconUtils.getJSXIcon(getPropValue('icon'), _objectSpread$1y({}, iconProps), {
        props: currentProps
      });
      var messageProps = mergeProps({
        className: cx('message')
      }, ptm('message'));
      var contentProps = mergeProps({
        className: cx('content')
      }, ptm('content'));
      return /*#__PURE__*/React__namespace.createElement("div", contentProps, icon, /*#__PURE__*/React__namespace.createElement("span", messageProps, message));
    };
    var createFooter = function createFooter() {
      var acceptClassName = classNames('p-confirm-popup-accept p-button-sm', getPropValue('acceptClassName'));
      var rejectClassName = classNames('p-confirm-popup-reject p-button-sm', {
        'p-button-text': !getPropValue('rejectClassName')
      }, getPropValue('rejectClassName'));
      var footerProps = mergeProps({
        className: cx('footer')
      }, ptm('footer'));
      var rejectButtonProps = mergeProps({
        ref: rejectBtnRef,
        label: rejectLabel,
        icon: getPropValue('rejectIcon'),
        className: cx('rejectButton', {
          getPropValue: getPropValue
        }),
        onClick: reject,
        pt: ptm('rejectButton'),
        unstyled: props.unstyled,
        __parentMetadata: {
          parent: metaData
        }
      });
      var acceptButtonProps = mergeProps({
        ref: acceptBtnRef,
        label: acceptLabel,
        icon: getPropValue('acceptIcon'),
        className: cx('acceptButton', {
          getPropValue: getPropValue
        }),
        onClick: accept,
        pt: ptm('acceptButton'),
        unstyled: props.unstyled,
        __parentMetadata: {
          parent: metaData
        }
      });
      var content = /*#__PURE__*/React__namespace.createElement("div", footerProps, /*#__PURE__*/React__namespace.createElement(Button, rejectButtonProps), /*#__PURE__*/React__namespace.createElement(Button, acceptButtonProps));
      if (getPropValue('footer')) {
        var defaultContentOptions = {
          accept: accept,
          reject: reject,
          className: 'p-confirm-popup-footer',
          acceptClassName: acceptClassName,
          rejectClassName: rejectClassName,
          acceptLabel: acceptLabel,
          rejectLabel: rejectLabel,
          element: content,
          props: getCurrentProps()
        };
        return ObjectUtils.getJSXElement(getPropValue('footer'), defaultContentOptions);
      }
      return content;
    };
    var rootProps = mergeProps({
      ref: overlayRef,
      id: getPropValue('id'),
      className: classNames(props.className, cx('root', {
        context: context,
        getPropValue: getPropValue
      })),
      style: getPropValue('style'),
      onClick: onPanelClick
    }, ConfirmPopupBase.getOtherProps(props), ptm('root'));
    var transitionProps = mergeProps({
      classNames: cx('transition'),
      "in": visibleState,
      timeout: {
        enter: 120,
        exit: 100
      },
      options: getPropValue('transitionOptions'),
      unmountOnExit: true,
      onEnter: onEnter,
      onEntered: onEntered,
      onExit: onExit,
      onExited: onExited
    }, ptm('transition'));
    var createTemplateElement = function createTemplateElement() {
      var currentProps = getCurrentProps();
      var message = ObjectUtils.getJSXElement(getPropValue('message'), currentProps);
      var templateElementProps = {
        message: message,
        acceptBtnRef: acceptBtnRef,
        rejectBtnRef: rejectBtnRef,
        hide: hide
      };
      return /*#__PURE__*/React__namespace.createElement(CSSTransition, _extends({
        nodeRef: overlayRef
      }, transitionProps), /*#__PURE__*/React__namespace.createElement("div", rootProps, ObjectUtils.getJSXElement(inProps.content, templateElementProps)));
    };
    var createElement = function createElement() {
      var content = createContent();
      var footer = createFooter();
      return /*#__PURE__*/React__namespace.createElement(CSSTransition, _extends({
        nodeRef: overlayRef
      }, transitionProps), /*#__PURE__*/React__namespace.createElement("div", rootProps, content, footer));
    };
    var element = inProps !== null && inProps !== void 0 && inProps.content ? createTemplateElement() : createElement();
    return /*#__PURE__*/React__namespace.createElement(Portal, {
      element: element,
      appendTo: getPropValue('appendTo'),
      visible: getPropValue('visible')
    });
  }));
  ConfirmPopup.displayName = 'ConfirmPopup';

  var styles$N = "\n@layer primereact {\n    .p-contextmenu ul {\n        margin: 0;\n        padding: 0;\n        list-style: none;\n    }\n\n    .p-contextmenu .p-submenu-list {\n        position: absolute;\n        min-width: 100%;\n        z-index: 1;\n    }\n\n    .p-contextmenu .p-menuitem-link {\n        cursor: pointer;\n        display: flex;\n        align-items: center;\n        text-decoration: none;\n        overflow: hidden;\n        position: relative;\n    }\n\n    .p-contextmenu .p-menuitem-text {\n        line-height: 1;\n    }\n\n    .p-contextmenu .p-menuitem {\n        position: relative;\n    }\n\n    .p-contextmenu .p-menuitem-link .p-submenu-icon {\n        margin-left: auto;\n    }\n\n    .p-contextmenu-enter {\n        opacity: 0;\n    }\n\n    .p-contextmenu-enter-active {\n        opacity: 1;\n        transition: opacity 250ms;\n    }\n}\n";
  var classes$Y = {
    root: function root(_ref) {
      var context = _ref.context;
      return classNames('p-contextmenu p-component', {
        'p-input-filled': context && context.inputStyle === 'filled' || PrimeReact.inputStyle === 'filled',
        'p-ripple-disabled': context && context.ripple === false || PrimeReact.ripple === false
      });
    },
    menu: function menu(_ref2) {
      var props = _ref2.menuProps;
      return classNames({
        ' p-contextmenu-root-list': props.root,
        'p-submenu-list': !props.root
      });
    },
    menuitem: function menuitem(_ref3) {
      var item = _ref3.item,
        active = _ref3.active,
        focused = _ref3.focused,
        disabled = _ref3.disabled;
      return classNames('p-menuitem', {
        'p-menuitem-active p-highlight': active,
        'p-focus': focused,
        'p-disabled': disabled
      }, item.className);
    },
    action: function action(_ref4) {
      var item = _ref4.item;
      return classNames('p-menuitem-link', {
        'p-disabled': item.disabled
      });
    },
    content: 'p-menuitem-content',
    icon: 'p-menuitem-icon',
    submenuIcon: 'p-submenu-icon',
    label: 'p-menuitem-text',
    separator: 'p-menuitem-separator',
    transition: 'p-contextmenu',
    submenuTransition: 'p-contextmenusub'
  };
  var ContextMenuBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'ContextMenu',
      id: null,
      ariaLabel: null,
      ariaLabelledby: null,
      model: null,
      style: null,
      className: null,
      global: false,
      autoZIndex: true,
      baseZIndex: 0,
      tabIndex: 0,
      breakpoint: undefined,
      scrollHeight: '400px',
      appendTo: null,
      transitionOptions: null,
      onFocus: null,
      onBlur: null,
      onShow: null,
      onHide: null,
      submenuIcon: null,
      children: undefined
    },
    css: {
      classes: classes$Y,
      styles: styles$N
    }
  });

  function ownKeys$1x(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1x(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1x(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1x(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var ContextMenuSub = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (props, ref) {
    var mergeProps = useMergeProps();
    var submenuRef = React__namespace.useRef(null);
    var active = props.root || !props.resetMenu;
    var ptm = props.ptm,
      cx = props.cx;
    var getPTOptions = function getPTOptions(processedItem, key, index) {
      return ptm(key, {
        hostName: props.hostName,
        context: {
          active: isItemActive(processedItem),
          focused: isItemFocused(processedItem),
          disabled: isItemDisabled(processedItem),
          index: index
        }
      });
    };
    var onItemMouseEnter = function onItemMouseEnter(event, item) {
      if (item.disabled || props.isMobileMode) {
        event.preventDefault();
        return;
      }
      props.onItemMouseEnter({
        originalEvent: event,
        processedItem: item
      });
    };
    var onItemClick = function onItemClick(event, processedItem) {
      var item = processedItem.item;
      if (item.disabled) {
        event.preventDefault();
        return;
      }
      if (item.command) {
        item.command({
          originalEvent: event,
          item: item
        });
      }
      props.onItemClick({
        originalEvent: event,
        processedItem: processedItem,
        isFocus: true
      });
      if (!item.items) {
        props.onLeafClick(event);
      }
      if (!item.url) {
        event.preventDefault();
        event.stopPropagation();
      }
    };
    var position = function position() {
      if (!props.isMobileMode) {
        var parentItem = submenuRef.current.parentElement;
        var containerOffset = DomHandler.getOffset(parentItem);
        var viewport = DomHandler.getViewport();
        var sublistWidth = submenuRef.current.offsetParent ? submenuRef.current.offsetWidth : DomHandler.getHiddenElementOuterWidth(submenuRef.current);
        var itemOuterWidth = DomHandler.getOuterWidth(parentItem.children[0]);
        var top = parseInt(containerOffset.top, 10) + submenuRef.current.offsetHeight - DomHandler.getWindowScrollTop();
        if (top > viewport.height) {
          submenuRef.current.style.top = viewport.height - top + 'px';
        } else {
          submenuRef.current.style.top = '0px';
        }
        if (parseInt(containerOffset.left, 10) + itemOuterWidth + sublistWidth > viewport.width - DomHandler.calculateScrollbarWidth()) {
          submenuRef.current.style.left = -1 * sublistWidth + 'px';
        } else {
          submenuRef.current.style.left = itemOuterWidth + 'px';
        }
      }
    };
    var onEnter = function onEnter() {
      position();
    };
    useUpdateEffect(function () {
      active && position();
    });
    var getItemId = function getItemId(processedItem) {
      return "".concat(props.menuId, "_").concat(processedItem.key);
    };
    var getItemProp = function getItemProp(processedItem, name, params) {
      return processedItem && processedItem.item ? ObjectUtils.getItemValue(processedItem.item[name], params) : undefined;
    };
    var isItemActive = function isItemActive(processedItem) {
      return props.activeItemPath && props.activeItemPath.some(function (path) {
        return path.key === processedItem.key;
      });
    };
    var isItemVisible = function isItemVisible(processedItem) {
      return getItemProp(processedItem, 'visible') !== false;
    };
    var isItemDisabled = function isItemDisabled(processedItem) {
      return getItemProp(processedItem, 'disabled');
    };
    var isItemFocused = function isItemFocused(processedItem) {
      return props.focusedItemId === getItemId(processedItem);
    };
    var isItemGroup = function isItemGroup(processedItem) {
      return ObjectUtils.isNotEmpty(processedItem.items);
    };
    var getAriaSetSize = function getAriaSetSize() {
      return props.model.filter(function (processedItem) {
        return isItemVisible(processedItem) && !getItemProp(processedItem, 'separator');
      }).length;
    };
    var getAriaPosInset = function getAriaPosInset(index) {
      return index - props.model.slice(0, index).filter(function (processedItem) {
        return isItemVisible(processedItem) && getItemProp(processedItem, 'separator');
      }).length + 1;
    };
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        getElement: function getElement() {
          return submenuRef.current;
        }
      };
    });
    var createSeparator = function createSeparator(index) {
      var key = props.id + '_separator_' + index;
      var separatorProps = mergeProps({
        id: key,
        key: key,
        className: cx('separator'),
        role: 'separator'
      }, ptm('separator', {
        hostName: props.hostName
      }));
      return /*#__PURE__*/React__namespace.createElement("li", separatorProps);
    };
    var createSubmenu = function createSubmenu(item, index) {
      if (isItemGroup(item)) {
        return /*#__PURE__*/React__namespace.createElement(ContextMenuSub, {
          id: props.id + '_' + index,
          role: "menu",
          menuId: props.menuId,
          focusedItemId: props.focusedItemId,
          activeItemPath: props.activeItemPath,
          level: props.level + 1,
          hostName: props.hostName,
          ariaLabelledby: getItemId(item),
          menuProps: props.menuProps,
          model: item.items,
          resetMenu: !isItemActive(item),
          onLeafClick: props.onLeafClick,
          onItemClick: props.onItemClick,
          onItemMouseEnter: props.onItemMouseEnter,
          isMobileMode: props.isMobileMode,
          submenuIcon: props.submenuIcon,
          ptm: ptm,
          cx: cx
        });
      }
      return null;
    };
    var createMenuItem = function createMenuItem(processedItem, index) {
      if (!isItemVisible(processedItem)) {
        return null;
      }
      var item = processedItem.item;
      var active = isItemActive(processedItem);
      var disabled = isItemDisabled(processedItem);
      var focused = isItemFocused(processedItem);
      var isGroup = isItemGroup(processedItem);
      var key = getItemId(processedItem);
      var iconProps = mergeProps({
        className: cx('icon')
      }, getPTOptions(processedItem, 'icon', index));
      var icon = IconUtils.getJSXIcon(item.icon, _objectSpread$1x({}, iconProps), {
        props: props.menuProps
      });
      var submenuIconProps = mergeProps({
        className: cx('submenuIcon')
      }, getPTOptions(processedItem, 'submenuIcon', index));
      var labelProps = mergeProps({
        className: cx('label')
      }, getPTOptions(processedItem, 'label', index));
      var items = getItemProp(processedItem, 'items');
      var submenuIcon = items && IconUtils.getJSXIcon(props.submenuIcon || /*#__PURE__*/React__namespace.createElement(AngleRightIcon, submenuIconProps), _objectSpread$1x({}, submenuIconProps), {
        props: props.menuProps
      });
      var label = item.label && /*#__PURE__*/React__namespace.createElement("span", labelProps, item.label);
      var submenu = createSubmenu(processedItem, index);
      var actionProps = mergeProps({
        href: item.url || '#',
        tabIndex: -1,
        className: cx('action', {
          item: item
        }),
        target: item.target
      }, getPTOptions(processedItem, 'action', index));
      var content = /*#__PURE__*/React__namespace.createElement("a", actionProps, icon, label, submenuIcon, /*#__PURE__*/React__namespace.createElement(Ripple, null));
      if (item.template) {
        var defaultContentOptions = {
          className: 'p-menuitem-link',
          labelClassName: 'p-menuitem-text',
          iconClassName: 'p-menuitem-icon',
          submenuIconClassName: cx('submenuIcon'),
          element: content,
          props: props,
          active: active
        };
        content = ObjectUtils.getJSXElement(item.template, item, defaultContentOptions);
      }
      var contentProps = mergeProps({
        onClick: function onClick(event) {
          return onItemClick(event, processedItem);
        },
        onMouseEnter: function onMouseEnter(event) {
          return onItemMouseEnter(event, processedItem);
        },
        className: cx('content')
      }, getPTOptions(processedItem, 'content', index));
      var menuitemProps = mergeProps(_defineProperty({
        id: key,
        key: key,
        role: 'menuitem',
        'aria-label': item.label,
        'aria-disabled': disabled,
        'aria-expanded': isGroup ? active : undefined,
        'aria-haspopup': isGroup && !item.url ? 'menu' : undefined,
        'aria-level': props.level + 1,
        'aria-setsize': getAriaSetSize(),
        'aria-posinset': getAriaPosInset(index),
        'data-p-highlight': active,
        'data-p-focused': focused,
        'data-p-disabled': disabled,
        className: cx('menuitem', {
          item: item,
          active: active,
          focused: focused,
          disabled: isItemDisabled(item)
        }),
        style: item.style
      }, "key", key), getPTOptions(processedItem, 'menuitem', index));
      return /*#__PURE__*/React__namespace.createElement("li", menuitemProps, /*#__PURE__*/React__namespace.createElement("div", contentProps, content), submenu);
    };
    var createItem = function createItem(processedItem, index) {
      if (processedItem.visible === false) {
        return null;
      }
      return processedItem.separator ? createSeparator(index) : createMenuItem(processedItem, index);
    };
    var createMenu = function createMenu() {
      return props.model ? props.model.map(createItem) : null;
    };
    var submenu = createMenu();
    var menuProps = mergeProps({
      className: cx('menu', {
        menuProps: props
      }),
      onFocus: props.onFocus,
      onBlur: props.onBlur,
      onKeyDown: props.onKeyDown,
      'aria-label': props.ariaLabel,
      'aria-labelledby': props.ariaLabelledby,
      'aria-orientation': 'vertical',
      'aria-activedescendant': props.ariaActivedescendant,
      tabIndex: props.tabIndex,
      role: props.role
    }, ptm('menu', {
      hostName: props.hostName
    }));
    var transitionProps = mergeProps({
      classNames: cx('submenuTransition'),
      "in": active,
      timeout: {
        enter: 0,
        exit: 0
      },
      unmountOnExit: true,
      onEnter: onEnter
    }, ptm('menu.transition', {
      hostName: props.hostName
    }));
    return /*#__PURE__*/React__namespace.createElement(CSSTransition, _extends({
      nodeRef: submenuRef
    }, transitionProps), /*#__PURE__*/React__namespace.createElement("ul", _extends({
      ref: submenuRef
    }, menuProps), submenu));
  }));
  ContextMenuSub.displayName = 'ContextMenuSub';

  function ownKeys$1w(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1w(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1w(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1w(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var ContextMenu = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var mergeProps = useMergeProps();
    var context = React__namespace.useContext(PrimeReactContext);
    var props = ContextMenuBase.getProps(inProps, context);
    var _React$useState = React__namespace.useState(props.id),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      idState = _React$useState2[0],
      setIdState = _React$useState2[1];
    var _React$useState3 = React__namespace.useState(false),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      visibleState = _React$useState4[0],
      setVisibleState = _React$useState4[1];
    var _React$useState5 = React__namespace.useState(false),
      _React$useState6 = _slicedToArray(_React$useState5, 2),
      reshowState = _React$useState6[0],
      setReshowState = _React$useState6[1];
    var _React$useState7 = React__namespace.useState(false),
      _React$useState8 = _slicedToArray(_React$useState7, 2),
      resetMenuState = _React$useState8[0],
      setResetMenuState = _React$useState8[1];
    var _React$useState9 = React__namespace.useState(null),
      _React$useState10 = _slicedToArray(_React$useState9, 2),
      attributeSelectorState = _React$useState10[0],
      setAttributeSelectorState = _React$useState10[1];
    var _React$useState11 = React__namespace.useState(false),
      _React$useState12 = _slicedToArray(_React$useState11, 2),
      focused = _React$useState12[0],
      setFocused = _React$useState12[1];
    var _React$useState13 = React__namespace.useState(false),
      _React$useState14 = _slicedToArray(_React$useState13, 2),
      focusTrigger = _React$useState14[0],
      setFocusTrigger = _React$useState14[1];
    var _React$useState15 = React__namespace.useState({
        index: -1,
        level: 0,
        parentKey: ''
      }),
      _React$useState16 = _slicedToArray(_React$useState15, 2),
      focusedItemInfo = _React$useState16[0],
      setFocusedItemInfo = _React$useState16[1];
    var _React$useState17 = React__namespace.useState(''),
      _React$useState18 = _slicedToArray(_React$useState17, 2),
      activeItemPath = _React$useState18[0],
      setActiveItemPath = _React$useState18[1];
    var _React$useState19 = React__namespace.useState([]),
      _React$useState20 = _slicedToArray(_React$useState19, 2),
      processedItems = _React$useState20[0],
      setProcessedItems = _React$useState20[1];
    var _React$useState21 = React__namespace.useState([]),
      _React$useState22 = _slicedToArray(_React$useState21, 2),
      visibleItems = _React$useState22[0],
      setVisibleItems = _React$useState22[1];
    var _React$useState23 = React__namespace.useState(null),
      _React$useState24 = _slicedToArray(_React$useState23, 2),
      focusedItemId = _React$useState24[0],
      setFocusedItemId = _React$useState24[1];
    var _ContextMenuBase$setM = ContextMenuBase.setMetaData({
        props: props,
        state: {
          id: idState,
          visible: visibleState,
          reshow: reshowState,
          resetMenu: resetMenuState,
          attributeSelector: attributeSelectorState
        }
      }),
      ptm = _ContextMenuBase$setM.ptm,
      cx = _ContextMenuBase$setM.cx,
      isUnstyled = _ContextMenuBase$setM.isUnstyled;
    useHandleStyle(ContextMenuBase.css.styles, isUnstyled, {
      name: 'contextmenu'
    });
    var menuRef = React__namespace.useRef(null);
    var listRef = React__namespace.useRef(null);
    var currentEvent = React__namespace.useRef(null);
    var searchValue = React__namespace.useRef('');
    var searchTimeout = React__namespace.useRef(null);
    var styleElementRef = React__namespace.useRef(null);
    var isMobileMode = useMatchMedia("screen and (max-width: ".concat(props.breakpoint, ")"), !!props.breakpoint);
    var _useEventListener = useEventListener({
        type: 'click',
        listener: function listener(event) {
          if (isOutsideClicked(event) && event.button !== 2) {
            hide(event);
            setResetMenuState(true);
          }
        }
      }),
      _useEventListener2 = _slicedToArray(_useEventListener, 2),
      bindDocumentClickListener = _useEventListener2[0],
      unbindDocumentClickListener = _useEventListener2[1];
    var _useEventListener3 = useEventListener({
        type: 'contextmenu',
        when: props.global,
        listener: function listener(event) {
          show(event);
        }
      }),
      _useEventListener4 = _slicedToArray(_useEventListener3, 1),
      bindDocumentContextMenuListener = _useEventListener4[0];
    var _useResizeListener = useResizeListener({
        listener: function listener(event) {
          if (visibleState && !DomHandler.isTouchDevice()) {
            hide(event);
          }
        }
      }),
      _useResizeListener2 = _slicedToArray(_useResizeListener, 2),
      bindDocumentResizeListener = _useResizeListener2[0],
      unbindDocumentResizeListener = _useResizeListener2[1];
    var createStyle = function createStyle() {
      if (!styleElementRef.current) {
        styleElementRef.current = DomHandler.createInlineStyle(context && context.nonce || PrimeReact.nonce, context && context.styleContainer);
        var selector = "".concat(attributeSelectorState);
        var innerHTML = "\n@media screen and (max-width: ".concat(props.breakpoint, ") {\n    .p-contextmenu[").concat(selector, "] > ul {\n        max-height: ").concat(props.scrollHeight, ";\n        overflow: ").concat(props.scrollHeight ? 'auto' : '', ";\n    }\n\n    .p-contextmenu[").concat(selector, "] .p-submenu-list {\n        position: relative;\n    }\n\n    .p-contextmenu[").concat(selector, "] .p-menuitem-active > .p-submenu-list {\n        left: 0;\n        box-shadow: none;\n        border-radius: 0;\n        padding: 0 0 0 calc(var(--inline-spacing) * 2); /* @todo */\n    }\n\n    .p-contextmenu[").concat(selector, "] .p-menuitem-active > .p-menuitem-link > .p-submenu-icon {\n        transform: rotate(-180deg);\n    }\n\n    .p-contextmenu[").concat(selector, "] .p-submenu-icon:before {\n        content: \"\\e930\";\n    }\n}\n");
        styleElementRef.current.innerHTML = innerHTML;
      }
    };
    var destroyStyle = function destroyStyle() {
      styleElementRef.current = DomHandler.removeInlineStyle(styleElementRef.current);
    };
    var onMenuClick = function onMenuClick() {
      setResetMenuState(false);
    };
    var onMenuMouseEnter = function onMenuMouseEnter() {
      setResetMenuState(false);
    };
    var show = function show(event) {
      setActiveItemPath([]);
      setFocusedItemInfo({
        index: -1,
        level: 0,
        parentKey: ''
      });
      event.stopPropagation();
      event.preventDefault();
      currentEvent.current = event;
      if (visibleState) {
        setReshowState(true);
      } else {
        setVisibleState(true);
        props.onShow && props.onShow(currentEvent.current);
      }
      Promise.resolve().then(function () {
        listRef.current && DomHandler.focus(listRef.current.getElement());
      });
    };
    var hide = function hide(event) {
      currentEvent.current = event;
      setVisibleState(false);
      setReshowState(false);
      setActiveItemPath([]);
      setFocusedItemInfo({
        index: -1,
        level: 0,
        parentKey: ''
      });
      props.onHide && props.onHide(currentEvent.current);
    };
    var onEnter = function onEnter() {
      DomHandler.addStyles(menuRef.current, {
        position: 'absolute'
      });
      if (props.autoZIndex) {
        ZIndexUtils.set('menu', menuRef.current, context && context.autoZIndex || PrimeReact.autoZIndex, props.baseZIndex || context && context.zIndex.menu || PrimeReact.zIndex.menu);
      }
      position(currentEvent.current);
      if (attributeSelectorState && props.breakpoint) {
        menuRef.current.setAttribute(attributeSelectorState, '');
        createStyle();
      }
    };
    var onEntered = function onEntered() {
      bindDocumentListeners();
    };
    var onExit = function onExit() {
      unbindDocumentListeners();
      ZIndexUtils.clear(menuRef.current);
    };
    var onExited = function onExited() {
      ZIndexUtils.clear(menuRef.current);
      destroyStyle();
    };
    var position = function position(event) {
      if (event) {
        var left = event.pageX + 1;
        var top = event.pageY + 1;
        var width = menuRef.current.offsetParent ? menuRef.current.offsetWidth : DomHandler.getHiddenElementOuterWidth(menuRef.current);
        var height = menuRef.current.offsetParent ? menuRef.current.offsetHeight : DomHandler.getHiddenElementOuterHeight(menuRef.current);
        var viewport = DomHandler.getViewport();

        //flip
        if (left + width - document.body.scrollLeft > viewport.width) {
          left = left - width;
        }

        //flip
        if (top + height - document.body.scrollTop > viewport.height) {
          top = top - height;
        }

        //fit
        if (left < document.body.scrollLeft) {
          left = document.body.scrollLeft;
        }

        //fit
        if (top < document.body.scrollTop) {
          top = document.body.scrollTop;
        }
        menuRef.current.style.left = left + 'px';
        menuRef.current.style.top = top + 'px';
      }
    };
    var createProcessedItems = React__namespace.useCallback(function (items, level) {
      var parent = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
      var parentKey = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : '';
      var processedItems = [];
      items && items.forEach(function (item, index) {
        var key = (parentKey !== '' ? parentKey + '_' : '') + index;
        var newItem = {
          item: item,
          index: index,
          level: level,
          separator: item.separator,
          key: key,
          parent: parent,
          parentKey: parentKey
        };
        newItem.items = createProcessedItems(item.items, level + 1, newItem, key);
        processedItems.push(newItem);
      });
      return processedItems;
    }, []);
    var onLeafClick = function onLeafClick(event) {
      setResetMenuState(true);
      hide(event);
      event.stopPropagation();
    };
    var isOutsideClicked = function isOutsideClicked(event) {
      return menuRef && menuRef.current && !(menuRef.current.isSameNode(event.target) || menuRef.current.contains(event.target));
    };
    var bindDocumentListeners = function bindDocumentListeners() {
      bindDocumentResizeListener();
      bindDocumentClickListener();
    };
    var unbindDocumentListeners = function unbindDocumentListeners() {
      unbindDocumentResizeListener();
      unbindDocumentClickListener();
    };
    useMountEffect(function () {
      var uniqueId = UniqueComponentId();
      !idState && setIdState(uniqueId);
      if (props.global) {
        bindDocumentContextMenuListener();
      }
      if (props.breakpoint) {
        !attributeSelectorState && setAttributeSelectorState(uniqueId);
      }
    });
    useUpdateEffect(function () {
      props.global && bindDocumentContextMenuListener();
    }, [props.global]);
    useUpdateEffect(function () {
      if (attributeSelectorState && menuRef.current) {
        menuRef.current.setAttribute(attributeSelectorState, '');
        createStyle();
      }
      return function () {
        destroyStyle();
      };
    }, [attributeSelectorState, props.breakpoint]);
    useUpdateEffect(function () {
      if (visibleState) {
        setVisibleState(false);
        setReshowState(false);
        setResetMenuState(true);
      } else if (!reshowState && !visibleState && resetMenuState) {
        show(currentEvent.current);
      }
    }, [reshowState]);
    React__namespace.useEffect(function () {
      var itemsToProcess = props.model || [];
      var processed = createProcessedItems(itemsToProcess, 0, null, '');
      setProcessedItems(processed);
    }, [props.model, createProcessedItems]);
    useUpdateEffect(function () {
      var _focusedItemId = focusedItemInfo.index !== -1 ? "".concat(idState).concat(ObjectUtils.isNotEmpty(focusedItemInfo.parentKey) ? '_' + focusedItemInfo.parentKey : '', "_").concat(focusedItemInfo.index) : null;
      setFocusedItemId(_focusedItemId);
    }, [focusedItemInfo]);
    useUpdateEffect(function () {
      var processedItem = activeItemPath && activeItemPath.find(function (p) {
        return p.key === focusedItemInfo.parentKey;
      });
      var _visibleItems = processedItem ? processedItem.items : processedItems;
      setVisibleItems(_visibleItems);
    }, [activeItemPath, focusedItemInfo]);
    useUpdateEffect(function () {
      if (focusTrigger) {
        var itemIndex = focusedItemInfo.index !== -1 ? findNextItemIndex(focusedItemInfo.index) : findFirstFocusedItemIndex();
        changeFocusedItemIndex(itemIndex);
        setActiveItemPath(activeItemPath.filter(function (p) {
          return p.parentKey !== focusedItemInfo.parentKey;
        }));
        setFocusTrigger(false);
      }
    }, [focusTrigger]);
    useUnmountEffect(function () {
      ZIndexUtils.clear(menuRef.current);
    });
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        show: show,
        hide: hide,
        getElement: function getElement() {
          return menuRef.current;
        }
      };
    });
    var onFocus = function onFocus(event) {
      setFocused(true);
      setFocusedItemInfo(focusedItemInfo.index !== -1 ? focusedItemInfo : {
        index: -1,
        level: 0,
        parentKey: ''
      });
      props.onFocus && props.onFocus(event);
    };
    var onBlur = function onBlur(event) {
      setFocused(false);
      setFocusedItemInfo({
        index: -1,
        level: 0,
        parentKey: ''
      });
      searchValue.current = '';
      searchValue.current = '';
      props.onBlur && props.onBlur(event);
    };
    var onKeyDown = function onKeyDown(event) {
      var metaKey = event.metaKey || event.ctrlKey;
      switch (event.code) {
        case 'ArrowDown':
          onArrowDownKey(event);
          break;
        case 'ArrowUp':
          onArrowUpKey(event);
          break;
        case 'ArrowLeft':
          onArrowLeftKey(event);
          break;
        case 'ArrowRight':
          onArrowRightKey(event);
          break;
        case 'Home':
          onHomeKey(event);
          break;
        case 'End':
          onEndKey(event);
          break;
        case 'Space':
          onSpaceKey(event);
          break;
        case 'Enter':
        case 'NumpadEnter':
          onEnterKey(event);
          break;
        case 'Escape':
          onEscapeKey(event);
          break;
        case 'Tab':
          onTabKey(event);
          break;
        case 'PageDown':
        case 'PageUp':
        case 'Backspace':
        case 'ShiftLeft':
        case 'ShiftRight':
          // NOOP
          break;
        default:
          if (!metaKey && ObjectUtils.isPrintableCharacter(event.key)) {
            searchItems(event, event.key);
          }
          break;
      }
    };
    var onItemChange = function onItemChange(event) {
      var processedItem = event.processedItem,
        isFocus = event.isFocus,
        _event$updateState = event.updateState,
        updateState = _event$updateState === void 0 ? true : _event$updateState;
      if (ObjectUtils.isEmpty(processedItem)) {
        return;
      }
      var index = processedItem.index,
        key = processedItem.key,
        level = processedItem.level,
        parentKey = processedItem.parentKey,
        items = processedItem.items;
      var grouped = ObjectUtils.isNotEmpty(items);
      var _activeItemPath = activeItemPath.filter(function (p) {
        return p.parentKey !== parentKey && p.parentKey !== key;
      });
      if (grouped && updateState) {
        _activeItemPath.push(processedItem);
        setVisibleState(true);
      }
      setFocusedItemInfo({
        index: index,
        level: level,
        parentKey: parentKey
      });
      setActiveItemPath(_activeItemPath);
      isFocus && DomHandler.focus(listRef.current.getElement());
    };
    var onItemClick = function onItemClick(event) {
      var processedItem = event.processedItem;
      var grouped = isProccessedItemGroup(processedItem);
      var selected = isSelected(processedItem);
      if (selected) {
        var index = processedItem.index,
          key = processedItem.key,
          level = processedItem.level,
          parentKey = processedItem.parentKey;
        setActiveItemPath(activeItemPath.filter(function (p) {
          return key !== p.key && key.startsWith(p.key);
        }));
        setFocusedItemInfo({
          index: index,
          level: level,
          parentKey: parentKey
        });
        DomHandler.focus(listRef.current.getElement());
      } else {
        grouped ? onItemChange(event) : hide();
      }
    };
    var onItemMouseEnter = function onItemMouseEnter(event) {
      onItemChange(event);
    };
    var onArrowDownKey = function onArrowDownKey(event) {
      var itemIndex = focusedItemInfo.index !== -1 ? findNextItemIndex(focusedItemInfo.index) : findFirstFocusedItemIndex();
      changeFocusedItemIndex(itemIndex);
      event.preventDefault();
    };
    var onArrowUpKey = function onArrowUpKey(event) {
      if (event.altKey) {
        if (focusedItemInfo.index !== -1) {
          var processedItem = visibleItems[focusedItemInfo.index];
          var grouped = isProccessedItemGroup(processedItem);
          !grouped && onItemChange({
            originalEvent: event,
            processedItem: processedItem
          });
        }
        event.preventDefault();
      } else {
        var itemIndex = focusedItemInfo.index !== -1 ? findPrevItemIndex(focusedItemInfo.index) : findLastFocusedItemIndex();
        changeFocusedItemIndex(itemIndex);
        event.preventDefault();
      }
    };
    var onArrowLeftKey = function onArrowLeftKey(event) {
      var processedItem = visibleItems[focusedItemInfo.index];
      var parentItem = activeItemPath.find(function (p) {
        return p.key === processedItem.parentKey;
      });
      var root = ObjectUtils.isEmpty(processedItem.parent);
      if (!root) {
        setFocusedItemInfo({
          index: -1,
          parentKey: parentItem ? parentItem.parentKey : ''
        });
        searchValue.current = '';
        setTimeout(function () {
          return setFocusTrigger(true);
        }, 0);
      }
      event.preventDefault();
    };
    var onArrowRightKey = function onArrowRightKey(event) {
      var processedItem = visibleItems[focusedItemInfo.index];
      var grouped = isProccessedItemGroup(processedItem);
      if (grouped) {
        onItemChange({
          originalEvent: event,
          processedItem: processedItem
        });
        setFocusedItemInfo({
          index: -1,
          parentKey: processedItem.key
        });
        searchValue.current = '';
        setTimeout(function () {
          return setFocusTrigger(true);
        }, 0);
      }
      event.preventDefault();
    };
    var onHomeKey = function onHomeKey(event) {
      changeFocusedItemIndex(findFirstItemIndex());
      event.preventDefault();
    };
    var onEndKey = function onEndKey(event) {
      changeFocusedItemIndex(findLastItemIndex());
      event.preventDefault();
    };
    var onEnterKey = function onEnterKey(event) {
      if (focusedItemInfo.index !== -1) {
        var _element = DomHandler.findSingle(listRef.current.getElement(), "li[id=\"".concat("".concat(focusedItemId), "\"]"));
        var anchorElement = _element && DomHandler.findSingle(_element, 'a[data-pc-section="action"]');
        anchorElement ? anchorElement.click() : _element && _element.click();
        var processedItem = visibleItems[focusedItemInfo.index];
        var grouped = isProccessedItemGroup(processedItem);
        !grouped && setFocusedItemInfo(_objectSpread$1w(_objectSpread$1w({}, focusedItemInfo), {}, {
          index: findFirstFocusedItemIndex()
        }));
      }
      event.preventDefault();
    };
    var onSpaceKey = function onSpaceKey(event) {
      onEnterKey(event);
    };
    var onEscapeKey = function onEscapeKey(event) {
      hide();
      setFocusedItemInfo({
        focusedItemInfo: focusedItemInfo,
        index: findFirstFocusedItemIndex()
      });
      event.preventDefault();
    };
    var onTabKey = function onTabKey(event) {
      if (focusedItemInfo.index !== -1) {
        var processedItem = visibleItems[focusedItemInfo.index];
        var grouped = isProccessedItemGroup(processedItem);
        !grouped && onItemChange({
          originalEvent: event,
          processedItem: processedItem
        });
      }
      hide();
    };
    var searchItems = function searchItems(event, _char) {
      searchValue.current = searchValue.current || '' + _char;
      var itemIndex = -1;
      var matched = false;
      if (focusedItemInfo.index !== -1) {
        itemIndex = visibleItems.slice(focusedItemInfo.index).findIndex(function (processedItem) {
          return isItemMatched(processedItem);
        });
        itemIndex = itemIndex === -1 ? visibleItems.slice(0, focusedItemInfo.index).findIndex(function (processedItem) {
          return isItemMatched(processedItem);
        }) : itemIndex + focusedItemInfo.index;
      } else {
        itemIndex = visibleItems.findIndex(function (processedItem) {
          return isItemMatched(processedItem);
        });
      }
      if (itemIndex !== -1) {
        matched = true;
      }
      if (itemIndex === -1 && focusedItemInfo.index === -1) {
        itemIndex = findFirstFocusedItemIndex();
      }
      if (itemIndex !== -1) {
        changeFocusedItemIndex(itemIndex);
      }
      if (searchTimeout.current) {
        clearTimeout(searchTimeout.current);
      }
      searchTimeout.current = setTimeout(function () {
        searchValue.current = '';
        searchTimeout.current = null;
      }, 500);
      return matched;
    };
    var changeFocusedItemIndex = function changeFocusedItemIndex(index) {
      if (focusedItemInfo.index !== index) {
        setFocusedItemInfo(_objectSpread$1w(_objectSpread$1w({}, focusedItemInfo), {}, {
          index: index
        }));
        scrollInView();
      }
    };
    var scrollInView = function scrollInView() {
      var index = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : -1;
      var _id = index !== -1 ? "".concat(idState, "_").concat(index) : focusedItemId;
      var element = DomHandler.findSingle(listRef.current.getElement(), "li[id=\"".concat(_id, "\"]"));
      if (element) {
        element.scrollIntoView && element.scrollIntoView({
          block: 'nearest',
          inline: 'start'
        });
      }
    };
    var getItemProp = function getItemProp(item, name) {
      return item ? ObjectUtils.getItemValue(item[name]) : undefined;
    };
    var getItemLabel = function getItemLabel(item) {
      return getItemProp(item, 'label');
    };
    var getProccessedItemLabel = function getProccessedItemLabel(processedItem) {
      return processedItem ? getItemLabel(processedItem.item) : undefined;
    };
    var isProccessedItemGroup = function isProccessedItemGroup(processedItem) {
      return processedItem && ObjectUtils.isNotEmpty(processedItem.items);
    };
    var isItemDisabled = function isItemDisabled(item) {
      return getItemProp(item, 'disabled');
    };
    var isItemSeparator = function isItemSeparator(item) {
      return getItemProp(item, 'separator');
    };
    var isValidItem = function isValidItem(processedItem) {
      return !!processedItem && !isItemDisabled(processedItem.item) && !isItemSeparator(processedItem.item);
    };
    var isItemMatched = function isItemMatched(processedItem) {
      return isValidItem(processedItem) && getProccessedItemLabel(processedItem).toLocaleLowerCase().startsWith(searchValue.current.toLocaleLowerCase());
    };
    var findNextItemIndex = function findNextItemIndex(index) {
      var matchedItemIndex = index < visibleItems.length - 1 ? visibleItems.slice(index + 1).findIndex(function (processedItem) {
        return isValidItem(processedItem);
      }) : -1;
      return matchedItemIndex > -1 ? matchedItemIndex + index + 1 : index;
    };
    var findPrevItemIndex = function findPrevItemIndex(index) {
      var matchedItemIndex = index > 0 ? ObjectUtils.findLastIndex(visibleItems.slice(0, index), function (processedItem) {
        return isValidItem(processedItem);
      }) : -1;
      return matchedItemIndex > -1 ? matchedItemIndex : index;
    };
    var isSelected = function isSelected(processedItem) {
      return activeItemPath && activeItemPath.some(function (p) {
        return p.key === processedItem.key;
      });
    };
    var isValidSelectedItem = function isValidSelectedItem(processedItem) {
      return isValidItem(processedItem) && isSelected(processedItem);
    };
    var findFirstItemIndex = function findFirstItemIndex() {
      return visibleItems.findIndex(function (processedItem) {
        return isValidItem(processedItem);
      });
    };
    var findLastItemIndex = function findLastItemIndex() {
      return ObjectUtils.findLastIndex(visibleItems, function (processedItem) {
        return isValidItem(processedItem);
      });
    };
    var findFirstFocusedItemIndex = function findFirstFocusedItemIndex() {
      var selectedIndex = findSelectedItemIndex();
      return selectedIndex < 0 ? findFirstItemIndex() : selectedIndex;
    };
    var findLastFocusedItemIndex = function findLastFocusedItemIndex() {
      var selectedIndex = findSelectedItemIndex();
      return selectedIndex < 0 ? findLastItemIndex() : selectedIndex;
    };
    var findSelectedItemIndex = function findSelectedItemIndex() {
      return visibleItems.findIndex(function (processedItem) {
        return isValidSelectedItem(processedItem);
      });
    };
    var createContextMenu = function createContextMenu() {
      var rootProps = mergeProps({
        id: props.id,
        className: classNames(props.className, cx('root', {
          context: context
        })),
        style: props.style,
        onClick: function onClick(e) {
          return onMenuClick();
        },
        onMouseEnter: function onMouseEnter(e) {
          return onMenuMouseEnter();
        }
      }, ContextMenuBase.getOtherProps(props), ptm('root'));
      var transitionProps = mergeProps({
        classNames: cx('transition'),
        "in": visibleState,
        timeout: {
          enter: 250,
          exit: 0
        },
        options: props.transitionOptions,
        unmountOnExit: true,
        onEnter: onEnter,
        onEntered: onEntered,
        onExit: onExit,
        onExited: onExited
      }, ptm('transition'));
      return /*#__PURE__*/React__namespace.createElement(CSSTransition, _extends({
        nodeRef: menuRef
      }, transitionProps), /*#__PURE__*/React__namespace.createElement("div", _extends({
        ref: menuRef
      }, rootProps), /*#__PURE__*/React__namespace.createElement(ContextMenuSub, {
        ref: listRef,
        ariaLabel: props.ariaLabel,
        ariaLabelledby: props.ariaLabelledby,
        activeItemPath: activeItemPath,
        hostName: "ContextMenu",
        id: idState + '_list',
        role: "menubar",
        tabIndex: props.tabIndex || 0,
        ariaActivedescendant: focused ? focusedItemId : undefined,
        menuId: idState,
        focusedItemId: focused ? focusedItemId : undefined,
        menuProps: props,
        model: processedItems,
        level: 0,
        root: true,
        onItemClick: onItemClick,
        onItemMouseEnter: onItemMouseEnter,
        onFocus: onFocus,
        onBlur: onBlur,
        onKeyDown: onKeyDown,
        resetMenu: resetMenuState,
        onLeafClick: onLeafClick,
        isMobileMode: isMobileMode,
        submenuIcon: props.submenuIcon,
        ptm: ptm,
        cx: cx
      })));
    };
    var element = createContextMenu();
    return /*#__PURE__*/React__namespace.createElement(Portal, {
      element: element,
      appendTo: props.appendTo
    });
  }));
  ContextMenu.displayName = 'ContextMenu';

  var classes$X = {
    header: 'p-datascroller-header',
    footer: 'p-datascroller-footer',
    content: 'p-datascroller-content',
    list: 'p-datascroller-list',
    root: function root(_ref) {
      var props = _ref.props;
      return classNames('p-datascroller p-component', {
        'p-datascroller-inline': props.inline
      });
    }
  };
  var styles$M = "\n@layer primereact {\n    .p-datascroller .p-datascroller-header {\n        text-align: center;\n        padding: .5em .75em;\n        border-bottom: 0 none;\n    }\n    \n    .p-datascroller .p-datascroller-footer {\n        text-align: center;\n        padding: .25em .625em;\n        border-top: 0px none;\n    }\n    \n    .p-datascroller .p-datascroller-content {\n        padding: .25em .625em;\n    }\n    \n    .p-datascroller-inline .p-datascroller-content {\n        overflow: auto;\n    }\n    \n    .p-datascroller .p-datascroller-list {\n        list-style-type: none; \n        margin: 0;\n        padding: 0;\n    }\n}\n";
  var inlineStyles$j = {
    content: function content(_ref2) {
      var props = _ref2.props;
      return {
        maxHeight: props.scrollHeight
      };
    }
  };
  var DataScrollerBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'DataScroller',
      id: null,
      value: null,
      rows: 0,
      inline: false,
      scrollHeight: null,
      loader: false,
      buffer: 0.9,
      style: null,
      className: null,
      onLazyLoad: null,
      emptyMessage: null,
      itemTemplate: null,
      header: null,
      footer: null,
      lazy: false,
      children: undefined
    },
    css: {
      classes: classes$X,
      styles: styles$M,
      inlineStyles: inlineStyles$j
    }
  });

  var DataScroller = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var mergeProps = useMergeProps();
    var context = React__namespace.useContext(PrimeReactContext);
    var props = DataScrollerBase.getProps(inProps, context);
    var _React$useState = React__namespace.useState([]),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      dataToRenderState = _React$useState2[0],
      setDataToRenderState = _React$useState2[1];
    var _DataScrollerBase$set = DataScrollerBase.setMetaData({
        props: props
      }),
      ptm = _DataScrollerBase$set.ptm,
      cx = _DataScrollerBase$set.cx,
      sx = _DataScrollerBase$set.sx,
      isUnstyled = _DataScrollerBase$set.isUnstyled;
    useHandleStyle(DataScrollerBase.css.styles, isUnstyled, {
      name: 'datascroller'
    });
    var elementRef = React__namespace.useRef(null);
    var contentRef = React__namespace.useRef(null);
    var value = React__namespace.useRef(props.value);
    var dataToRender = React__namespace.useRef([]);
    var first = React__namespace.useRef(0);
    var scrollFunction = React__namespace.useRef(null);
    var handleDataChange = function handleDataChange() {
      if (props.lazy) {
        dataToRender.current = value.current;
        setDataToRenderState(_toConsumableArray(dataToRender.current));
      } else {
        load();
      }
    };
    var load = function load() {
      if (props.lazy) {
        if (props.onLazyLoad) {
          props.onLazyLoad(createLazyLoadMetadata());
        }
        first.current = first.current + props.rows;
      } else if (value.current) {
        for (var i = first.current; i < first.current + props.rows; i++) {
          if (i >= value.current.length) {
            break;
          }
          dataToRender.current.push(value.current[i]);
        }
        if (value.current.length !== 0) {
          first.current = first.current + props.rows;
        }
        setDataToRenderState(_toConsumableArray(dataToRender.current));
      }
    };
    var reset = function reset() {
      first.current = 0;
      dataToRender.current = [];
      setDataToRenderState(_toConsumableArray(dataToRender.current));
      load();
    };
    var createLazyLoadMetadata = function createLazyLoadMetadata() {
      return {
        first: first.current,
        rows: props.rows
      };
    };
    var bindScrollListener = function bindScrollListener() {
      if (props.inline) {
        scrollFunction.current = function () {
          var scrollTop = contentRef.current.scrollTop;
          var scrollHeight = contentRef.current.scrollHeight;
          var viewportHeight = contentRef.current.clientHeight;
          if (scrollTop >= scrollHeight * props.buffer - viewportHeight) {
            load();
          }
        };
        contentRef.current.addEventListener('scroll', scrollFunction.current);
      } else {
        scrollFunction.current = function () {
          var docBody = document.body;
          var docElement = document.documentElement;
          var scrollTop = window.pageYOffset || document.documentElement.scrollTop;
          var winHeight = docElement.clientHeight;
          var docHeight = Math.max(docBody.scrollHeight, docBody.offsetHeight, winHeight, docElement.scrollHeight, docElement.offsetHeight);
          if (scrollTop >= docHeight * props.buffer - winHeight) {
            load();
          }
        };
        window.addEventListener('scroll', scrollFunction.current);
      }
    };
    var unbindScrollListener = function unbindScrollListener() {
      if (scrollFunction.current) {
        if (props.inline && contentRef.current) {
          contentRef.current.removeEventListener('scroll', scrollFunction.current);
        } else if (!props.loader) {
          window.removeEventListener('scroll', scrollFunction.current);
        }
      }
      scrollFunction.current = null;
    };
    useMountEffect(function () {
      load();
      if (!props.loader) {
        bindScrollListener();
      }
    });
    useUpdateEffect(function () {
      if (props.value) {
        value.current = props.value;
        if (!props.lazy) {
          first.current = 0;
        }
        dataToRender.current = [];
        handleDataChange();
      }
    }, [props.value]);
    useUpdateEffect(function () {
      if (props.loader) {
        unbindScrollListener();
      } else {
        bindScrollListener();
      }
    }, [props.loader]);
    useUnmountEffect(function () {
      if (scrollFunction.current) {
        unbindScrollListener();
      }
    });
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        load: load,
        reset: reset,
        getElement: function getElement() {
          return elementRef.current;
        },
        getContent: function getContent() {
          return contentRef.current;
        }
      };
    });
    var createHeader = function createHeader() {
      var headerProps = mergeProps({
        className: cx('header')
      }, ptm('header'));
      if (props.header) {
        return /*#__PURE__*/React__namespace.createElement("div", headerProps, props.header);
      }
      return null;
    };
    var createFooter = function createFooter() {
      var footerProps = mergeProps({
        className: cx('footer')
      }, ptm('footer'));
      if (props.footer) {
        return /*#__PURE__*/React__namespace.createElement("div", footerProps, props.footer);
      }
      return null;
    };
    var createItem = function createItem(_value, index) {
      var itemProps = ptm('item');
      var content = props.itemTemplate ? props.itemTemplate(_value) : _value;
      return /*#__PURE__*/React__namespace.createElement("li", _extends({}, itemProps, {
        key: index + '_datascrollitem'
      }), content);
    };
    var createEmptyMessage = function createEmptyMessage() {
      var emptyMessageProps = mergeProps(ptm('emptyMessage'));
      var content = ObjectUtils.getJSXElement(props.emptyMessage, props) || localeOption('emptyMessage');
      return /*#__PURE__*/React__namespace.createElement("li", emptyMessageProps, content);
    };
    var createContent = function createContent() {
      var contentProps = mergeProps({
        ref: contentRef,
        className: cx('content'),
        style: sx('content')
      }, ptm('content'));
      var listProps = mergeProps({
        className: cx('list')
      }, ptm('list'));
      var content = ObjectUtils.isNotEmpty(dataToRenderState) ? dataToRenderState.map(createItem) : createEmptyMessage();
      return /*#__PURE__*/React__namespace.createElement("div", contentProps, /*#__PURE__*/React__namespace.createElement("ul", listProps, content));
    };
    var header = createHeader();
    var footer = createFooter();
    var content = createContent();
    var rootProps = mergeProps({
      id: props.id,
      ref: elementRef,
      className: classNames(props.className, cx('root'))
    }, DataScrollerBase.getOtherProps(props), ptm('root'));
    return /*#__PURE__*/React__namespace.createElement("div", rootProps, header, content, footer);
  }));
  DataScroller.displayName = 'DataScroller';

  var getStorage = function getStorage(stateStorageProp) {
    switch (stateStorageProp) {
      case 'local':
        return window.localStorage;
      case 'session':
        return window.sessionStorage;
      case 'custom':
        return null;
      default:
        throw new Error(stateStorageProp + ' is not a valid value for the state storage, supported values are "local", "session" and "custom".');
    }
  };

  var ColumnBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'Column',
      align: null,
      alignFrozen: 'left',
      alignHeader: null,
      body: null,
      bodyClassName: null,
      bodyStyle: null,
      cellEditValidateOnClose: false,
      cellEditValidator: null,
      cellEditValidatorEvent: 'click',
      className: null,
      colSpan: null,
      columnKey: null,
      dataType: 'text',
      editor: null,
      excludeGlobalFilter: false,
      expander: false,
      exportField: null,
      exportable: true,
      field: null,
      filter: false,
      filterApply: null,
      filterClear: null,
      filterElement: null,
      filterField: null,
      filterFooter: null,
      filterFunction: null,
      filterHeader: null,
      filterHeaderClassName: null,
      filterHeaderStyle: null,
      filterMatchMode: null,
      filterMatchModeOptions: null,
      filterMaxLength: null,
      filterMenuClassName: null,
      filterMenuStyle: null,
      filterPlaceholder: null,
      filterType: 'text',
      footer: null,
      footerClassName: null,
      footerStyle: null,
      frozen: false,
      header: null,
      headerClassName: null,
      headerStyle: null,
      headerTooltip: null,
      headerTooltipOptions: null,
      hidden: false,
      maxConstraints: 2,
      onBeforeCellEditHide: null,
      onBeforeCellEditShow: null,
      onCellEditCancel: null,
      onCellEditComplete: null,
      onCellEditInit: null,
      onFilterApplyClick: null,
      onFilterClear: null,
      onFilterConstraintAdd: null,
      onFilterConstraintRemove: null,
      onFilterMatchModeChange: null,
      onFilterOperatorChange: null,
      reorderable: true,
      resizeable: true,
      rowEditor: false,
      rowReorder: false,
      rowReorderIcon: null,
      rowSpan: null,
      selectionMode: null,
      showAddButton: true,
      showApplyButton: true,
      showClearButton: true,
      showFilterMatchModes: true,
      showFilterMenu: true,
      showFilterMenuOptions: true,
      showFilterOperator: true,
      sortField: null,
      sortFunction: null,
      sortable: false,
      sortableDisabled: false,
      style: null,
      children: undefined
    },
    getCProp: function getCProp(column, name) {
      return ObjectUtils.getComponentProp(column, name, ColumnBase.defaultProps);
    },
    getCProps: function getCProps(column) {
      return ObjectUtils.getComponentProps(column, ColumnBase.defaultProps);
    },
    getCOtherProps: function getCOtherProps(column) {
      return ObjectUtils.getComponentDiffProps(column, ColumnBase.defaultProps);
    }
  });

  var ArrowDownIcon = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("path", {
      fillRule: "evenodd",
      clipRule: "evenodd",
      d: "M6.99994 14C6.91097 14.0004 6.82281 13.983 6.74064 13.9489C6.65843 13.9148 6.58387 13.8646 6.52133 13.8013L1.10198 8.38193C0.982318 8.25351 0.917175 8.08367 0.920272 7.90817C0.923368 7.73267 0.994462 7.56523 1.11858 7.44111C1.24269 7.317 1.41014 7.2459 1.58563 7.2428C1.76113 7.23971 1.93098 7.30485 2.0594 7.42451L6.32263 11.6877V0.677419C6.32263 0.497756 6.394 0.325452 6.52104 0.198411C6.64808 0.0713706 6.82039 0 7.00005 0C7.17971 0 7.35202 0.0713706 7.47906 0.198411C7.6061 0.325452 7.67747 0.497756 7.67747 0.677419V11.6877L11.9407 7.42451C12.0691 7.30485 12.2389 7.23971 12.4144 7.2428C12.5899 7.2459 12.7574 7.317 12.8815 7.44111C13.0056 7.56523 13.0767 7.73267 13.0798 7.90817C13.0829 8.08367 13.0178 8.25351 12.8981 8.38193L7.47875 13.8013C7.41621 13.8646 7.34164 13.9148 7.25944 13.9489C7.17727 13.983 7.08912 14.0004 7.00015 14C7.00012 14 7.00009 14 7.00005 14C7.00001 14 6.99998 14 6.99994 14Z",
      fill: "currentColor"
    }));
  }));
  ArrowDownIcon.displayName = 'ArrowDownIcon';

  var ArrowUpIcon = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("path", {
      fillRule: "evenodd",
      clipRule: "evenodd",
      d: "M6.51551 13.799C6.64205 13.9255 6.813 13.9977 6.99193 14C7.17087 13.9977 7.34182 13.9255 7.46835 13.799C7.59489 13.6725 7.66701 13.5015 7.66935 13.3226V2.31233L11.9326 6.57554C11.9951 6.63887 12.0697 6.68907 12.1519 6.72319C12.2341 6.75731 12.3223 6.77467 12.4113 6.77425C12.5003 6.77467 12.5885 6.75731 12.6707 6.72319C12.7529 6.68907 12.8274 6.63887 12.89 6.57554C13.0168 6.44853 13.0881 6.27635 13.0881 6.09683C13.0881 5.91732 13.0168 5.74514 12.89 5.61812L7.48846 0.216594C7.48274 0.210436 7.4769 0.204374 7.47094 0.198411C7.3439 0.0713707 7.1716 0 6.99193 0C6.81227 0 6.63997 0.0713707 6.51293 0.198411C6.50704 0.204296 6.50128 0.210278 6.49563 0.216354L1.09386 5.61812C0.974201 5.74654 0.909057 5.91639 0.912154 6.09189C0.91525 6.26738 0.986345 6.43483 1.11046 6.55894C1.23457 6.68306 1.40202 6.75415 1.57752 6.75725C1.75302 6.76035 1.92286 6.6952 2.05128 6.57554L6.31451 2.31231V13.3226C6.31685 13.5015 6.38898 13.6725 6.51551 13.799Z",
      fill: "currentColor"
    }));
  }));
  ArrowUpIcon.displayName = 'ArrowUpIcon';

  var classes$W = {
    root: 'p-paginator p-component',
    left: 'p-paginator-left-content',
    end: 'p-paginator-right-content',
    firstPageIcon: 'p-paginator-icon',
    firstPageButton: function firstPageButton(_ref) {
      var disabled = _ref.disabled;
      return classNames('p-paginator-first p-paginator-element p-link', {
        'p-disabled': disabled
      });
    },
    prevPageIcon: 'p-paginator-icon',
    prevPageButton: function prevPageButton(_ref2) {
      var disabled = _ref2.disabled;
      return classNames('p-paginator-prev p-paginator-element p-link', {
        'p-disabled': disabled
      });
    },
    nextPageIcon: 'p-paginator-icon',
    nextPageButton: function nextPageButton(_ref3) {
      var disabled = _ref3.disabled;
      return classNames('p-paginator-next p-paginator-element p-link', {
        'p-disabled': disabled
      });
    },
    lastPageIcon: 'p-paginator-icon',
    lastPageButton: function lastPageButton(_ref4) {
      var disabled = _ref4.disabled;
      return classNames('p-paginator-last p-paginator-element p-link', {
        'p-disabled': disabled
      });
    },
    pageButton: function pageButton(_ref5) {
      var pageLink = _ref5.pageLink,
        startPageInView = _ref5.startPageInView,
        endPageInView = _ref5.endPageInView,
        page = _ref5.page;
      return classNames('p-paginator-page p-paginator-element p-link', {
        'p-paginator-page-start': pageLink === startPageInView,
        'p-paginator-page-end': pageLink === endPageInView,
        'p-highlight': pageLink - 1 === page
      });
    },
    pages: 'p-paginator-pages'
  };
  var styles$L = "\n@layer primereact {\n    .p-paginator {\n        display: flex;\n        align-items: center;\n        justify-content: center;\n        flex-wrap: wrap;\n    }\n    \n    .p-paginator-left-content {\n        margin-right: auto;\n    }\n    \n    .p-paginator-right-content {\n        margin-left: auto;\n    }\n    \n    .p-paginator-page,\n    .p-paginator-next,\n    .p-paginator-last,\n    .p-paginator-first,\n    .p-paginator-prev,\n    .p-paginator-current {\n        cursor: pointer;\n        display: inline-flex;\n        align-items: center;\n        justify-content: center;\n        line-height: 1;\n        user-select: none;\n        overflow: hidden;\n        position: relative;\n    }\n    \n    .p-paginator-element:focus {\n        z-index: 1;\n        position: relative;\n    }\n}\n";
  var PaginatorBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'Paginator',
      __parentMetadata: null,
      totalRecords: 0,
      rows: 0,
      first: 0,
      pageLinkSize: 5,
      rowsPerPageOptions: null,
      alwaysShow: true,
      style: null,
      className: null,
      template: 'FirstPageLink PrevPageLink PageLinks NextPageLink LastPageLink RowsPerPageDropdown',
      onPageChange: null,
      leftContent: null,
      rightContent: null,
      dropdownAppendTo: null,
      currentPageReportTemplate: '({currentPage} of {totalPages})',
      children: undefined
    },
    css: {
      classes: classes$W,
      styles: styles$L
    }
  });
  var CurrentPageReportBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'CurrentPageReport',
      pageCount: null,
      page: null,
      first: null,
      rows: null,
      totalRecords: null,
      reportTemplate: '({currentPage} of {totalPages})',
      template: null,
      children: undefined
    }
  });
  var FirstPageLinkBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'FirstPageLink',
      disabled: false,
      onClick: null,
      template: null,
      firstPageLinkIcon: null,
      children: undefined
    }
  });
  var JumpToPageInputBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'JumpToPageInput',
      page: null,
      rows: null,
      pageCount: null,
      disabled: false,
      template: null,
      onChange: null,
      children: undefined,
      metaData: null,
      ptm: null
    }
  });
  var LastPageLinkBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'LastPageLink',
      disabled: false,
      onClick: null,
      template: null,
      lastPageLinkIcon: null,
      children: undefined
    }
  });
  var NextPageLinkBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'NextPageLink',
      disabled: false,
      onClick: null,
      template: null,
      nextPageLinkIcon: null,
      children: undefined
    }
  });
  var PageLinksBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'PageLinks',
      value: null,
      page: null,
      rows: null,
      pageCount: null,
      links: null,
      template: null,
      children: undefined
    }
  });
  var PrevPageLinkBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'PrevPageLink',
      disabled: false,
      onClick: null,
      template: null,
      prevPageLinkIcon: null,
      children: undefined
    }
  });
  var RowsPerPageDropdownBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'RowsPerPageDropdown',
      options: null,
      value: null,
      page: null,
      pageCount: null,
      totalRecords: 0,
      appendTo: null,
      onChange: null,
      template: null,
      disabled: false,
      children: undefined
    }
  });

  function ownKeys$1v(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1v(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1v(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1v(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var CurrentPageReport = /*#__PURE__*/React__namespace.memo(function (inProps) {
    var mergeProps = useMergeProps();
    var context = React__namespace.useContext(PrimeReactContext);
    var props = CurrentPageReportBase.getProps(inProps, context);
    var report = {
      currentPage: props.page + 1,
      totalPages: props.totalPages,
      first: Math.min(props.first + 1, props.totalRecords),
      last: Math.min(props.first + props.rows, props.totalRecords),
      rows: props.rows,
      totalRecords: props.totalRecords
    };
    var text = props.reportTemplate.replace('{currentPage}', report.currentPage).replace('{totalPages}', report.totalPages).replace('{first}', report.first).replace('{last}', report.last).replace('{rows}', report.rows).replace('{totalRecords}', report.totalRecords);
    var currentProps = mergeProps({
      'aria-live': 'polite',
      className: 'p-paginator-current'
    }, props.ptm('current', {
      hostName: props.hostName
    }));
    var element = /*#__PURE__*/React__namespace.createElement("span", currentProps, text);
    if (props.template) {
      var defaultOptions = _objectSpread$1v(_objectSpread$1v({}, report), {
        ariaLive: 'polite',
        className: 'p-paginator-current',
        element: element,
        props: props
      });
      return ObjectUtils.getJSXElement(props.template, defaultOptions);
    }
    return element;
  });
  CurrentPageReport.displayName = 'CurrentPageReport';

  var AngleDoubleLeftIcon = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("path", {
      fillRule: "evenodd",
      clipRule: "evenodd",
      d: "M5.71602 11.164C5.80782 11.2021 5.9063 11.2215 6.00569 11.221C6.20216 11.2301 6.39427 11.1612 6.54025 11.0294C6.68191 10.8875 6.76148 10.6953 6.76148 10.4948C6.76148 10.2943 6.68191 10.1021 6.54025 9.96024L3.51441 6.9344L6.54025 3.90855C6.624 3.76126 6.65587 3.59011 6.63076 3.42254C6.60564 3.25498 6.525 3.10069 6.40175 2.98442C6.2785 2.86815 6.11978 2.79662 5.95104 2.7813C5.78229 2.76598 5.61329 2.80776 5.47112 2.89994L1.97123 6.39983C1.82957 6.54167 1.75 6.73393 1.75 6.9344C1.75 7.13486 1.82957 7.32712 1.97123 7.46896L5.47112 10.9991C5.54096 11.0698 5.62422 11.1259 5.71602 11.164ZM11.0488 10.9689C11.1775 11.1156 11.3585 11.2061 11.5531 11.221C11.7477 11.2061 11.9288 11.1156 12.0574 10.9689C12.1815 10.8302 12.25 10.6506 12.25 10.4645C12.25 10.2785 12.1815 10.0989 12.0574 9.96024L9.03158 6.93439L12.0574 3.90855C12.1248 3.76739 12.1468 3.60881 12.1204 3.45463C12.0939 3.30045 12.0203 3.15826 11.9097 3.04765C11.7991 2.93703 11.6569 2.86343 11.5027 2.83698C11.3486 2.81053 11.19 2.83252 11.0488 2.89994L7.51865 6.36957C7.37699 6.51141 7.29742 6.70367 7.29742 6.90414C7.29742 7.1046 7.37699 7.29686 7.51865 7.4387L11.0488 10.9689Z",
      fill: "currentColor"
    }));
  }));
  AngleDoubleLeftIcon.displayName = 'AngleDoubleLeftIcon';

  function ownKeys$1u(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1u(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1u(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1u(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var FirstPageLink = /*#__PURE__*/React__namespace.memo(function (inProps) {
    var mergeProps = useMergeProps();
    var context = React__namespace.useContext(PrimeReactContext);
    var props = FirstPageLinkBase.getProps(inProps, context);
    var ptm = props.ptm,
      cx = props.cx;
    var getPTOptions = function getPTOptions(key) {
      return ptm(key, {
        hostName: props.hostName,
        context: {
          disabled: props.disabled
        }
      });
    };
    var className = classNames('p-paginator-first p-paginator-element p-link', {
      'p-disabled': props.disabled
    });
    var iconClassName = 'p-paginator-icon';
    var firstPageIconProps = mergeProps({
      className: cx('firstPageIcon')
    }, getPTOptions('firstPageIcon'));
    var icon = props.firstPageLinkIcon || /*#__PURE__*/React__namespace.createElement(AngleDoubleLeftIcon, firstPageIconProps);
    var firstPageLinkIcon = IconUtils.getJSXIcon(icon, _objectSpread$1u({}, firstPageIconProps), {
      props: props
    });
    var firstPageButtonProps = mergeProps({
      type: 'button',
      className: cx('firstPageButton', {
        disabled: props.disabled
      }),
      onClick: props.onClick,
      disabled: props.disabled,
      'aria-label': ariaLabel('firstPageLabel')
    }, getPTOptions('firstPageButton'));
    var element = /*#__PURE__*/React__namespace.createElement("button", firstPageButtonProps, firstPageLinkIcon, /*#__PURE__*/React__namespace.createElement(Ripple, null));
    if (props.template) {
      var defaultOptions = {
        onClick: props.onClick,
        className: className,
        iconClassName: iconClassName,
        disabled: props.disabled,
        element: element,
        props: props
      };
      return ObjectUtils.getJSXElement(props.template, defaultOptions);
    }
    return element;
  });
  FirstPageLink.displayName = 'FirstPageLink';

  var AngleDownIcon = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("path", {
      d: "M3.58659 4.5007C3.68513 4.50023 3.78277 4.51945 3.87379 4.55723C3.9648 4.59501 4.04735 4.65058 4.11659 4.7207L7.11659 7.7207L10.1166 4.7207C10.2619 4.65055 10.4259 4.62911 10.5843 4.65956C10.7427 4.69002 10.8871 4.77074 10.996 4.88976C11.1049 5.00877 11.1726 5.15973 11.1889 5.32022C11.2052 5.48072 11.1693 5.6422 11.0866 5.7807L7.58659 9.2807C7.44597 9.42115 7.25534 9.50004 7.05659 9.50004C6.85784 9.50004 6.66722 9.42115 6.52659 9.2807L3.02659 5.7807C2.88614 5.64007 2.80725 5.44945 2.80725 5.2507C2.80725 5.05195 2.88614 4.86132 3.02659 4.7207C3.09932 4.64685 3.18675 4.58911 3.28322 4.55121C3.37969 4.51331 3.48305 4.4961 3.58659 4.5007Z",
      fill: "currentColor"
    }));
  }));
  AngleDownIcon.displayName = 'AngleDownIcon';

  var AngleUpIcon = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("path", {
      d: "M10.4134 9.49931C10.3148 9.49977 10.2172 9.48055 10.1262 9.44278C10.0352 9.405 9.95263 9.34942 9.88338 9.27931L6.88338 6.27931L3.88338 9.27931C3.73811 9.34946 3.57409 9.3709 3.41567 9.34044C3.25724 9.30999 3.11286 9.22926 3.00395 9.11025C2.89504 8.99124 2.82741 8.84028 2.8111 8.67978C2.79478 8.51928 2.83065 8.35781 2.91338 8.21931L6.41338 4.71931C6.55401 4.57886 6.74463 4.49997 6.94338 4.49997C7.14213 4.49997 7.33276 4.57886 7.47338 4.71931L10.9734 8.21931C11.1138 8.35994 11.1927 8.55056 11.1927 8.74931C11.1927 8.94806 11.1138 9.13868 10.9734 9.27931C10.9007 9.35315 10.8132 9.41089 10.7168 9.44879C10.6203 9.48669 10.5169 9.5039 10.4134 9.49931Z",
      fill: "currentColor"
    }));
  }));
  AngleUpIcon.displayName = 'AngleUpIcon';

  var classes$V = {
    root: function root(_ref) {
      var props = _ref.props,
        focusedState = _ref.focusedState,
        stacked = _ref.stacked,
        horizontal = _ref.horizontal,
        vertical = _ref.vertical;
      return classNames('p-inputnumber p-component p-inputwrapper', {
        'p-inputwrapper-filled': props.value != null && props.value.toString().length > 0,
        'p-inputwrapper-focus': focusedState,
        'p-inputnumber-buttons-stacked': stacked,
        'p-inputnumber-buttons-horizontal': horizontal,
        'p-inputnumber-buttons-vertical': vertical,
        'p-invalid': props.invalid
      });
    },
    input: function input(_ref2) {
      var props = _ref2.props,
        context = _ref2.context;
      return classNames('p-inputnumber-input', {
        'p-variant-filled': props.variant ? props.variant === 'filled' : context && context.inputStyle === 'filled'
      });
    },
    buttonGroup: 'p-inputnumber-button-group',
    incrementButton: function incrementButton(_ref3) {
      var props = _ref3.props;
      return classNames('p-inputnumber-button p-inputnumber-button-up p-button p-button-icon-only p-component', {
        'p-disabled': props.disabled
      });
    },
    incrementIcon: 'p-button-icon',
    decrementButton: function decrementButton(_ref4) {
      var props = _ref4.props;
      return classNames('p-inputnumber-button p-inputnumber-button-down p-button p-button-icon-only p-component', {
        'p-disabled': props.disabled
      });
    },
    decrementIcon: 'p-button-icon'
  };
  var styles$K = "\n@layer primereact {\n    .p-inputnumber {\n        display: inline-flex;\n    }\n    \n    .p-inputnumber-button {\n        display: flex;\n        align-items: center;\n        justify-content: center;\n        flex: 0 0 auto;\n    }\n    \n    .p-inputnumber-buttons-stacked .p-button.p-inputnumber-button .p-button-label,\n    .p-inputnumber-buttons-horizontal .p-button.p-inputnumber-button .p-button-label {\n        display: none;\n    }\n    \n    .p-inputnumber-buttons-stacked .p-button.p-inputnumber-button-up {\n        border-top-left-radius: 0;\n        border-bottom-left-radius: 0;\n        border-bottom-right-radius: 0;\n        padding: 0;\n    }\n    \n    .p-inputnumber-buttons-stacked .p-inputnumber-input {\n        border-top-right-radius: 0;\n        border-bottom-right-radius: 0;\n    }\n    \n    .p-inputnumber-buttons-stacked .p-button.p-inputnumber-button-down {\n        border-top-left-radius: 0;\n        border-top-right-radius: 0;\n        border-bottom-left-radius: 0;\n        padding: 0;\n    }\n    \n    .p-inputnumber-buttons-stacked .p-inputnumber-button-group {\n        display: flex;\n        flex-direction: column;\n    }\n    \n    .p-inputnumber-buttons-stacked .p-inputnumber-button-group .p-button.p-inputnumber-button {\n        flex: 1 1 auto;\n    }\n    \n    .p-inputnumber-buttons-horizontal .p-button.p-inputnumber-button-up {\n        order: 3;\n        border-top-left-radius: 0;\n        border-bottom-left-radius: 0;\n    }\n    \n    .p-inputnumber-buttons-horizontal .p-inputnumber-input {\n        order: 2;\n        border-radius: 0;\n    }\n    \n    .p-inputnumber-buttons-horizontal .p-button.p-inputnumber-button-down {\n        order: 1;\n        border-top-right-radius: 0;\n        border-bottom-right-radius: 0;\n    }\n    \n    .p-inputnumber-buttons-vertical {\n        flex-direction: column;\n    }\n    \n    .p-inputnumber-buttons-vertical .p-button.p-inputnumber-button-up {\n        order: 1;\n        border-bottom-left-radius: 0;\n        border-bottom-right-radius: 0;\n        width: 100%;\n    }\n    \n    .p-inputnumber-buttons-vertical .p-inputnumber-input {\n        order: 2;\n        border-radius: 0;\n        text-align: center;\n    }\n    \n    .p-inputnumber-buttons-vertical .p-button.p-inputnumber-button-down {\n        order: 3;\n        border-top-left-radius: 0;\n        border-top-right-radius: 0;\n        width: 100%;\n    }\n    \n    .p-inputnumber-input {\n        flex: 1 1 auto;\n    }\n    \n    .p-fluid .p-inputnumber {\n        width: 100%;\n    }\n    \n    .p-fluid .p-inputnumber .p-inputnumber-input {\n        width: 1%;\n    }\n    \n    .p-fluid .p-inputnumber-buttons-vertical .p-inputnumber-input {\n        width: 100%;\n    }\n}\n";
  var InputNumberBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'InputNumber',
      __parentMetadata: null,
      allowEmpty: true,
      ariaLabelledBy: null,
      autoFocus: false,
      buttonLayout: 'stacked',
      className: null,
      currency: undefined,
      currencyDisplay: undefined,
      decrementButtonClassName: null,
      decrementButtonIcon: null,
      disabled: false,
      format: true,
      id: null,
      incrementButtonClassName: null,
      incrementButtonIcon: null,
      inputClassName: null,
      inputId: null,
      inputMode: null,
      inputRef: null,
      inputStyle: null,
      invalid: false,
      variant: null,
      locale: undefined,
      localeMatcher: undefined,
      max: null,
      maxFractionDigits: undefined,
      maxLength: null,
      min: null,
      minFractionDigits: undefined,
      mode: 'decimal',
      name: null,
      onBlur: null,
      onChange: null,
      onFocus: null,
      onKeyDown: null,
      onKeyUp: null,
      onValueChange: null,
      pattern: null,
      placeholder: null,
      prefix: null,
      readOnly: false,
      required: false,
      roundingMode: undefined,
      showButtons: false,
      size: null,
      step: 1,
      style: null,
      suffix: null,
      tabIndex: null,
      tooltip: null,
      tooltipOptions: null,
      type: 'text',
      useGrouping: true,
      value: null,
      children: undefined
    },
    css: {
      classes: classes$V,
      styles: styles$K
    }
  });

  function ownKeys$1t(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1t(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1t(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1t(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var InputNumber = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var mergeProps = useMergeProps();
    var context = React__namespace.useContext(PrimeReactContext);
    var props = InputNumberBase.getProps(inProps, context);
    var _React$useState = React__namespace.useState(false),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      focusedState = _React$useState2[0],
      setFocusedState = _React$useState2[1];
    var metaData = _objectSpread$1t(_objectSpread$1t({
      props: props
    }, props.__parentMetadata), {}, {
      state: {
        focused: focusedState
      }
    });
    var _InputNumberBase$setM = InputNumberBase.setMetaData(metaData),
      ptm = _InputNumberBase$setM.ptm,
      cx = _InputNumberBase$setM.cx,
      isUnstyled = _InputNumberBase$setM.isUnstyled;
    useHandleStyle(InputNumberBase.css.styles, isUnstyled, {
      name: 'inputnumber'
    });
    var elementRef = React__namespace.useRef(null);
    var inputRef = React__namespace.useRef(null);
    var timer = React__namespace.useRef(null);
    var lastValue = React__namespace.useRef(null);
    var numberFormat = React__namespace.useRef(null);
    var groupChar = React__namespace.useRef(null);
    var prefixChar = React__namespace.useRef(null);
    var suffixChar = React__namespace.useRef(null);
    var isSpecialChar = React__namespace.useRef(null);
    var _numeral = React__namespace.useRef(null);
    var _group = React__namespace.useRef(null);
    var _minusSign = React__namespace.useRef(null);
    var _currency = React__namespace.useRef(null);
    var _decimal = React__namespace.useRef(null);
    var _decimalSeparator = React__namespace.useRef(null);
    var _suffix = React__namespace.useRef(null);
    var _prefix = React__namespace.useRef(null);
    var _index = React__namespace.useRef(null);
    var isFocusedByClick = React__namespace.useRef(false);
    var _locale = props.locale || context && context.locale || PrimeReact.locale;
    var stacked = props.showButtons && props.buttonLayout === 'stacked';
    var horizontal = props.showButtons && props.buttonLayout === 'horizontal';
    var vertical = props.showButtons && props.buttonLayout === 'vertical';
    var inputMode = props.inputMode || (props.mode === 'decimal' && !props.minFractionDigits && !props.maxFractionDigits ? 'numeric' : 'decimal');
    var getOptions = function getOptions() {
      var _props$minFractionDig, _props$maxFractionDig;
      return {
        localeMatcher: props.localeMatcher,
        style: props.mode,
        currency: props.currency,
        currencyDisplay: props.currencyDisplay,
        useGrouping: props.useGrouping,
        minimumFractionDigits: (_props$minFractionDig = props.minFractionDigits) !== null && _props$minFractionDig !== void 0 ? _props$minFractionDig : undefined,
        maximumFractionDigits: (_props$maxFractionDig = props.maxFractionDigits) !== null && _props$maxFractionDig !== void 0 ? _props$maxFractionDig : undefined,
        roundingMode: props.roundingMode
      };
    };
    var constructParser = function constructParser() {
      numberFormat.current = new Intl.NumberFormat(_locale, getOptions());
      var numerals = _toConsumableArray(new Intl.NumberFormat(_locale, {
        useGrouping: false
      }).format(9876543210)).reverse();
      var index = new Map(numerals.map(function (d, i) {
        return [d, i];
      }));
      _numeral.current = new RegExp("[".concat(numerals.join(''), "]"), 'g');
      _group.current = getGroupingExpression(); // regular expression /[,]/g, /[.]/g
      _minusSign.current = getMinusSignExpression(); // regular expression /[-]/g
      _currency.current = getCurrencyExpression(); // regular expression for currency (e.g. /[$]/g, /[€]/g, /[]/g and more)
      _decimal.current = getDecimalExpression(); // regular expression /[,]/g, /[.]/g, /[]/g
      _decimalSeparator.current = getDecimalSeparator(); // current decimal separator  '.', ','
      _suffix.current = getSuffixExpression(); // regular expression for suffix (e.g. /℃/g)
      _prefix.current = getPrefixExpression(); // regular expression for prefix (e.g. /\ days/g)
      _index.current = function (d) {
        return index.get(d);
      };
    };
    var escapeRegExp = function escapeRegExp(text) {
      return text.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, '\\$&');
    };

    /**
     * get decimal separator in current locale
     */
    var getDecimalSeparator = function getDecimalSeparator() {
      return new Intl.NumberFormat(_locale, {
        useGrouping: false
      }).format(1.1).trim().replace(_numeral.current, '');
    };
    var getDecimalExpression = function getDecimalExpression() {
      var formatter = new Intl.NumberFormat(_locale, _objectSpread$1t(_objectSpread$1t({}, getOptions()), {}, {
        useGrouping: false
      }));
      return new RegExp("[".concat(formatter.format(1.1).replace(_currency.current, '').trim().replace(_numeral.current, ''), "]"), 'g');
    };
    var getGroupingExpression = function getGroupingExpression() {
      var formatter = new Intl.NumberFormat(_locale, {
        useGrouping: true
      });
      groupChar.current = formatter.format(1000000).trim().replace(_numeral.current, '').charAt(0);
      return new RegExp("[".concat(groupChar.current, "]"), 'g');
    };
    var getMinusSignExpression = function getMinusSignExpression() {
      var formatter = new Intl.NumberFormat(_locale, {
        useGrouping: false
      });
      return new RegExp("[".concat(formatter.format(-1).trim().replace(_numeral.current, ''), "]"), 'g');
    };
    var getCurrencyExpression = function getCurrencyExpression() {
      if (props.currency) {
        var formatter = new Intl.NumberFormat(_locale, {
          style: 'currency',
          currency: props.currency,
          currencyDisplay: props.currencyDisplay,
          minimumFractionDigits: 0,
          maximumFractionDigits: 0,
          roundingMode: props.roundingMode
        });
        return new RegExp("[".concat(formatter.format(1).replace(/\s/g, '').replace(_numeral.current, '').replace(_group.current, ''), "]"), 'g');
      }
      return new RegExp('[]', 'g');
    };
    var getPrefixExpression = function getPrefixExpression() {
      if (props.prefix) {
        prefixChar.current = props.prefix;
      } else {
        var formatter = new Intl.NumberFormat(_locale, {
          style: props.mode,
          currency: props.currency,
          currencyDisplay: props.currencyDisplay
        });
        prefixChar.current = formatter.format(1).split('1')[0];
      }
      return new RegExp("".concat(escapeRegExp(prefixChar.current || '')), 'g');
    };
    var getSuffixExpression = function getSuffixExpression() {
      if (props.suffix) {
        suffixChar.current = props.suffix;
      } else {
        var formatter = new Intl.NumberFormat(_locale, {
          style: props.mode,
          currency: props.currency,
          currencyDisplay: props.currencyDisplay,
          minimumFractionDigits: 0,
          maximumFractionDigits: 0,
          roundingMode: props.roundingMode
        });
        suffixChar.current = formatter.format(1).split('1')[1];
      }
      return new RegExp("".concat(escapeRegExp(suffixChar.current || '')), 'g');
    };
    var formatValue = function formatValue(value) {
      if (value != null) {
        if (value === '-') {
          // Minus sign
          return value;
        }
        if (props.format) {
          var formatter = new Intl.NumberFormat(_locale, getOptions());
          var _formattedValue = formatter.format(value);
          if (props.prefix) {
            _formattedValue = props.prefix + _formattedValue;
          }
          if (props.suffix) {
            _formattedValue = _formattedValue + props.suffix;
          }
          return _formattedValue;
        }
        return value.toString();
      }
      return '';
    };
    var parseValue = function parseValue(text) {
      var filteredText = text.replace(_suffix.current, '').replace(_prefix.current, '').trim().replace(/\s/g, '').replace(_currency.current, '').replace(_group.current, '').replace(_minusSign.current, '-').replace(_decimal.current, '.').replace(_numeral.current, _index.current);
      if (filteredText) {
        if (filteredText === '-') {
          // Minus sign
          return filteredText;
        }
        var parsedValue = +filteredText;
        return isNaN(parsedValue) ? null : parsedValue;
      }
      return null;
    };
    var _repeat = function repeat(event, interval, dir) {
      var i = interval || 500;
      clearTimer();
      timer.current = setTimeout(function () {
        _repeat(event, 40, dir);
      }, i);
      spin(event, dir);
    };
    var spin = function spin(event, dir) {
      if (inputRef.current) {
        var step = props.step * dir;
        var currentValue = parseValue(inputRef.current.value) || 0;
        var newValue = validateValue(currentValue + step);
        if (props.maxLength && props.maxLength < formatValue(newValue).length) {
          return;
        }

        // #3913 onChange should be called before onValueChange
        handleOnChange(event, currentValue, newValue);
        // touch devices trigger the keyboard to display because of setSelectionRange
        !DomHandler.isTouchDevice() && updateInput(newValue, null, 'spin');
        updateModel(event, newValue);
      }
    };
    var onUpButtonMouseDown = function onUpButtonMouseDown(event) {
      if (!props.disabled && !props.readOnly) {
        if (!DomHandler.isTouchDevice()) {
          DomHandler.focus(inputRef.current, props.autoFocus);
        }
        _repeat(event, null, 1);
        event.preventDefault();
      }
    };
    var onUpButtonMouseUp = function onUpButtonMouseUp() {
      if (!props.disabled && !props.readOnly) {
        clearTimer();
      }
    };
    var onUpButtonMouseLeave = function onUpButtonMouseLeave() {
      if (!props.disabled && !props.readOnly) {
        clearTimer();
      }
    };
    var onUpButtonKeyUp = function onUpButtonKeyUp() {
      if (!props.disabled && !props.readOnly) {
        clearTimer();
      }
    };
    var onUpButtonKeyDown = function onUpButtonKeyDown(event) {
      if (!props.disabled && !props.readOnly && (event.keyCode === 32 || event.keyCode === 13)) {
        _repeat(event, null, 1);
      }
    };
    var onDownButtonMouseDown = function onDownButtonMouseDown(event) {
      if (!props.disabled && !props.readOnly) {
        if (!DomHandler.isTouchDevice()) {
          DomHandler.focus(inputRef.current, props.autoFocus);
        }
        _repeat(event, null, -1);
        event.preventDefault();
      }
    };
    var onDownButtonMouseUp = function onDownButtonMouseUp() {
      if (!props.disabled && !props.readOnly) {
        clearTimer();
      }
    };
    var onDownButtonMouseLeave = function onDownButtonMouseLeave() {
      if (!props.disabled && !props.readOnly) {
        clearTimer();
      }
    };
    var onDownButtonKeyUp = function onDownButtonKeyUp() {
      if (!props.disabled && !props.readOnly) {
        clearTimer();
      }
    };
    var onDownButtonKeyDown = function onDownButtonKeyDown(event) {
      if (!props.disabled && !props.readOnly && (event.keyCode === 32 || event.keyCode === 13)) {
        _repeat(event, null, -1);
      }
    };
    var onInput = function onInput(event) {
      if (props.disabled || props.readOnly) {
        return;
      }
      if (isSpecialChar.current) {
        event.target.value = lastValue.current;
        isSpecialChar.current = false;
      }
      if (DomHandler.isAndroid()) {
        return;
      }

      // #6324 Chrome is allowing accent-dead characters through...
      var inputType = event.nativeEvent.inputType;
      var data = event.nativeEvent.data;
      if (inputType === 'insertText' && /\D/.test(data)) {
        event.target.value = lastValue.current;
      }
    };
    var onInputAndroidKey = function onInputAndroidKey(event) {
      if (!DomHandler.isAndroid() || props.disabled || props.readOnly) {
        return;
      }
      if (props.onKeyUp) {
        props.onKeyUp(event);

        // do not continue if the user defined event wants to prevent
        if (event.defaultPrevented) {
          return;
        }
      }
      var code = event.which || event.keyCode;
      if (code !== 13) {
        // to submit a form
        event.preventDefault();
      }
      var _char = String.fromCharCode(code);
      var _isDecimalSign = isDecimalSign(_char);
      var _isMinusSign = isMinusSign(_char);
      if (48 <= code && code <= 57 || _isMinusSign || _isDecimalSign) {
        insert(event, _char, {
          isDecimalSign: _isDecimalSign,
          isMinusSign: _isMinusSign
        });
      } else {
        updateValue(event, event.target.value, null, 'delete-single');
      }
    };
    var onInputKeyDown = function onInputKeyDown(event) {
      if (props.disabled || props.readOnly) {
        return;
      }
      if (event.altKey || event.ctrlKey || event.metaKey) {
        // #7039 Treat cut as normal character
        if (event.key.toLowerCase() === 'x' && (event.ctrlKey || event.metaKey)) {
          isSpecialChar.current = false;
        } else {
          isSpecialChar.current = true;
        }
        return;
      }
      if (props.onKeyDown) {
        props.onKeyDown(event);

        // Do not continue if the user-defined event wants to prevent
        if (event.defaultPrevented) {
          return;
        }
      }
      lastValue.current = event.target.value;

      // Android is handled specially in onInputAndroidKey
      if (DomHandler.isAndroid()) {
        return;
      }
      var selectionStart = event.target.selectionStart;
      var selectionEnd = event.target.selectionEnd;
      var inputValue = event.target.value;
      var newValueStr = null;
      switch (event.code) {
        //up
        case 'ArrowUp':
          spin(event, 1);
          event.preventDefault();
          break;

        //down
        case 'ArrowDown':
          spin(event, -1);
          event.preventDefault();
          break;

        //left
        case 'ArrowLeft':
          if (!isNumeralChar(inputValue.charAt(selectionStart - 1))) {
            event.preventDefault();
          }
          break;

        //right
        case 'ArrowRight':
          if (!isNumeralChar(inputValue.charAt(selectionStart))) {
            event.preventDefault();
          }
          break;

        //enter and tab
        case 'Tab':
        case 'Enter':
        case 'NumpadEnter':
          newValueStr = validateValue(parseValue(inputValue));
          inputRef.current.value = formatValue(newValueStr);
          inputRef.current.setAttribute('aria-valuenow', newValueStr);
          updateModel(event, newValueStr);
          break;

        //backspace
        case 'Backspace':
          event.preventDefault();
          if (selectionStart === selectionEnd) {
            var deleteChar = inputValue.charAt(selectionStart - 1);
            if (isNumeralChar(deleteChar)) {
              var _getDecimalCharIndexe = getDecimalCharIndexes(inputValue),
                decimalCharIndex = _getDecimalCharIndexe.decimalCharIndex,
                decimalCharIndexWithoutPrefix = _getDecimalCharIndexe.decimalCharIndexWithoutPrefix;
              var decimalLength = getDecimalLength(inputValue);
              if (_group.current.test(deleteChar)) {
                _group.current.lastIndex = 0;
                newValueStr = inputValue.slice(0, selectionStart - 2) + inputValue.slice(selectionStart - 1);
              } else if (_decimal.current.test(deleteChar)) {
                _decimal.current.lastIndex = 0;
                if (decimalLength) {
                  inputRef.current.setSelectionRange(selectionStart - 1, selectionStart - 1);
                } else {
                  newValueStr = inputValue.slice(0, selectionStart - 1) + inputValue.slice(selectionStart);
                }
              } else if (decimalCharIndex > 0 && selectionStart > decimalCharIndex) {
                var insertedText = isDecimalMode() && (props.minFractionDigits || 0) < decimalLength ? '' : '0';
                newValueStr = inputValue.slice(0, selectionStart - 1) + insertedText + inputValue.slice(selectionStart);
              } else if (decimalCharIndexWithoutPrefix === 1) {
                newValueStr = inputValue.slice(0, selectionStart - 1) + '0' + inputValue.slice(selectionStart);
                newValueStr = parseValue(newValueStr) > 0 ? newValueStr : '';
              } else {
                newValueStr = inputValue.slice(0, selectionStart - 1) + inputValue.slice(selectionStart);
              }
            } else if (_currency.current.test(deleteChar)) {
              var _getCharIndexes = getCharIndexes(inputValue),
                minusCharIndex = _getCharIndexes.minusCharIndex,
                currencyCharIndex = _getCharIndexes.currencyCharIndex;
              if (minusCharIndex === currencyCharIndex - 1) {
                newValueStr = inputValue.slice(0, minusCharIndex) + inputValue.slice(selectionStart);
              }
            }
            updateValue(event, newValueStr, null, 'delete-single');
          } else {
            newValueStr = deleteRange(inputValue, selectionStart, selectionEnd);
            updateValue(event, newValueStr, null, 'delete-range');
          }
          break;

        // del
        case 'Delete':
          event.preventDefault();
          if (selectionStart === selectionEnd) {
            var _deleteChar = inputValue.charAt(selectionStart);
            var _getDecimalCharIndexe2 = getDecimalCharIndexes(inputValue),
              _decimalCharIndex = _getDecimalCharIndexe2.decimalCharIndex,
              _decimalCharIndexWithoutPrefix = _getDecimalCharIndexe2.decimalCharIndexWithoutPrefix;
            if (isNumeralChar(_deleteChar)) {
              var _decimalLength = getDecimalLength(inputValue);
              if (_group.current.test(_deleteChar)) {
                _group.current.lastIndex = 0;
                newValueStr = inputValue.slice(0, selectionStart) + inputValue.slice(selectionStart + 2);
              } else if (_decimal.current.test(_deleteChar)) {
                _decimal.current.lastIndex = 0;
                if (_decimalLength) {
                  inputRef.current.setSelectionRange(selectionStart + 1, selectionStart + 1);
                } else {
                  newValueStr = inputValue.slice(0, selectionStart) + inputValue.slice(selectionStart + 1);
                }
              } else if (_decimalCharIndex > 0 && selectionStart > _decimalCharIndex) {
                var _insertedText = isDecimalMode() && (props.minFractionDigits || 0) < _decimalLength ? '' : '0';
                newValueStr = inputValue.slice(0, selectionStart) + _insertedText + inputValue.slice(selectionStart + 1);
              } else if (_decimalCharIndexWithoutPrefix === 1) {
                newValueStr = inputValue.slice(0, selectionStart) + '0' + inputValue.slice(selectionStart + 1);
                newValueStr = parseValue(newValueStr) > 0 ? newValueStr : '';
              } else {
                newValueStr = inputValue.slice(0, selectionStart) + inputValue.slice(selectionStart + 1);
              }
            }
            updateValue(event, newValueStr, null, 'delete-back-single');
          } else {
            newValueStr = deleteRange(inputValue, selectionStart, selectionEnd);
            updateValue(event, newValueStr, null, 'delete-range');
          }
          break;
        case 'End':
          event.preventDefault();
          if (!ObjectUtils.isEmpty(props.max)) {
            updateModel(event, props.max);
          }
          break;
        case 'Home':
          event.preventDefault();
          if (!ObjectUtils.isEmpty(props.min)) {
            updateModel(event, props.min);
          }
          break;
        default:
          event.preventDefault();
          var _char2 = event.key;
          if (_char2) {
            // get decimal separator in current locale
            if (_char2 === '.') {
              _char2 = _decimalSeparator.current;
            }
            var _isDecimalSign = isDecimalSign(_char2);
            var _isMinusSign = isMinusSign(_char2);
            if (Number(_char2) >= 0 && Number(_char2) <= 9 || _isMinusSign || _isDecimalSign) {
              insert(event, _char2, {
                isDecimalSign: _isDecimalSign,
                isMinusSign: _isMinusSign
              });
            }
          }
          break;
      }
    };
    var onPaste = function onPaste(event) {
      event.preventDefault();
      if (props.disabled || props.readOnly) {
        return;
      }
      var data = (event.clipboardData || window.clipboardData).getData('Text');
      if (data) {
        var filteredData = parseValue(data);
        if (filteredData != null) {
          if (isFloat(filteredData)) {
            var _formattedValue2 = formatValue(filteredData);
            inputRef.current.value = _formattedValue2;
            updateModel(event, filteredData);
          } else {
            insert(event, filteredData.toString());
          }
        }
      }
    };
    var allowMinusSign = function allowMinusSign() {
      return ObjectUtils.isEmpty(props.min) || props.min < 0;
    };
    var isMinusSign = function isMinusSign(_char3) {
      if (_minusSign.current.test(_char3) || _char3 === '-') {
        _minusSign.current.lastIndex = 0;
        return true;
      }
      return false;
    };
    var replaceDecimalSeparator = function replaceDecimalSeparator(val) {
      if (isFloat(val)) {
        return val.toString().replace(/\.(?=[^.]*$)/, _decimalSeparator.current);
      }
      return val;
    };
    var isDecimalSign = function isDecimalSign(_char4) {
      if (_decimal.current.test(_char4) || isFloat(_char4)) {
        _decimal.current.lastIndex = 0;
        return true;
      }
      return false;
    };
    var isDecimalMode = function isDecimalMode() {
      return props.mode === 'decimal';
    };
    var isFloat = function isFloat(val) {
      var formatter = new Intl.NumberFormat(_locale, getOptions());
      var parseVal = parseValue(formatter.format(val));
      if (parseVal === null) {
        return false;
      }
      return parseVal % 1 !== 0;
    };
    var getDecimalCharIndexes = function getDecimalCharIndexes(val) {
      var decimalCharIndex = val.search(_decimal.current);
      _decimal.current.lastIndex = 0;
      var filteredVal = val.replace(_prefix.current, '').trim().replace(/\s/g, '').replace(_currency.current, '');
      var decimalCharIndexWithoutPrefix = filteredVal.search(_decimal.current);
      _decimal.current.lastIndex = 0;
      return {
        decimalCharIndex: decimalCharIndex,
        decimalCharIndexWithoutPrefix: decimalCharIndexWithoutPrefix
      };
    };
    var getCharIndexes = function getCharIndexes(val) {
      var decimalCharIndex = val.search(_decimal.current);
      _decimal.current.lastIndex = 0;
      var minusCharIndex = val.search(_minusSign.current);
      _minusSign.current.lastIndex = 0;
      var suffixCharIndex = val.search(_suffix.current);
      _suffix.current.lastIndex = 0;
      var currencyCharIndex = val.search(_currency.current);
      if (currencyCharIndex === 0 && prefixChar.current && prefixChar.current.length > 1) {
        currencyCharIndex = prefixChar.current.trim().length;
      }
      _currency.current.lastIndex = 0;
      return {
        decimalCharIndex: decimalCharIndex,
        minusCharIndex: minusCharIndex,
        suffixCharIndex: suffixCharIndex,
        currencyCharIndex: currencyCharIndex
      };
    };
    var insert = function insert(event, text) {
      var sign = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {
        isDecimalSign: false,
        isMinusSign: false
      };
      var minusCharIndexOnText = text.search(_minusSign.current);
      _minusSign.current.lastIndex = 0;
      if (!allowMinusSign() && minusCharIndexOnText !== -1) {
        return;
      }
      var selectionStart = inputRef.current.selectionStart;
      var selectionEnd = inputRef.current.selectionEnd;
      var inputValue = inputRef.current.value.trim();
      var _getCharIndexes2 = getCharIndexes(inputValue),
        decimalCharIndex = _getCharIndexes2.decimalCharIndex,
        minusCharIndex = _getCharIndexes2.minusCharIndex,
        suffixCharIndex = _getCharIndexes2.suffixCharIndex,
        currencyCharIndex = _getCharIndexes2.currencyCharIndex;
      var maxFractionDigits = numberFormat.current.resolvedOptions().maximumFractionDigits;
      var hasBoundOrAffix = props.min || props.max || props.suffix || props.prefix; //only exception
      var newValueStr;
      if (sign.isMinusSign) {
        var isNewMinusSign = minusCharIndex === -1;

        // #6522 - Selected negative value can't be overwritten with a minus ('-') symbol
        if (selectionStart === 0 || selectionStart === currencyCharIndex + 1) {
          newValueStr = inputValue;
          if (isNewMinusSign || selectionEnd !== 0) {
            newValueStr = insertText(inputValue, text, 0, selectionEnd);
          }
          updateValue(event, newValueStr, text, 'insert');
        }
      } else if (sign.isDecimalSign) {
        if (decimalCharIndex > 0 && selectionStart === decimalCharIndex) {
          updateValue(event, inputValue, text, 'insert');
        } else if (decimalCharIndex > selectionStart && decimalCharIndex < selectionEnd) {
          newValueStr = insertText(inputValue, text, selectionStart, selectionEnd);
          updateValue(event, newValueStr, text, 'insert');
        } else if (decimalCharIndex === -1 && (maxFractionDigits || props.maxFractionDigits)) {
          var allowedDecimal = inputMode !== 'numeric' || inputMode === 'numeric' && hasBoundOrAffix;
          if (allowedDecimal) {
            newValueStr = insertText(inputValue, text, selectionStart, selectionEnd);
            updateValue(event, newValueStr, text, 'insert');
          }
        }
      } else {
        var operation = selectionStart !== selectionEnd ? 'range-insert' : 'insert';
        if (decimalCharIndex > 0 && selectionStart > decimalCharIndex) {
          if (selectionStart + text.length - (decimalCharIndex + 1) <= maxFractionDigits) {
            var charIndex = currencyCharIndex >= selectionStart ? currencyCharIndex - 1 : suffixCharIndex >= selectionStart ? suffixCharIndex : inputValue.length;
            newValueStr = inputValue.slice(0, selectionStart) + text + inputValue.slice(selectionStart + text.length, charIndex) + inputValue.slice(charIndex);
            updateValue(event, newValueStr, text, operation);
          }
        } else {
          newValueStr = insertText(inputValue, text, selectionStart, selectionEnd);
          updateValue(event, newValueStr, text, operation);
        }
      }
    };
    var replaceSuffix = function replaceSuffix(value) {
      return value ? value.replace(_suffix.current, '').trim().replace(/\s/g, '').replace(_currency.current, '') : value;
    };
    var insertText = function insertText(value, text, start, end) {
      var textSplit = isDecimalSign(text) ? text : text.split(_decimal.current);
      if (textSplit.length === 2) {
        var decimalCharIndex = value.slice(start, end).search(_decimal.current);
        _decimal.current.lastIndex = 0;
        return decimalCharIndex > 0 ? value.slice(0, start) + formatValue(text) + replaceSuffix(value).slice(end) : value || formatValue(text);
      } else if (isDecimalSign(text) && value.length === 0) {
        return formatValue('0.');
      } else if (end - start === value.length) {
        return formatValue(text);
      } else if (start === 0) {
        var suffix = ObjectUtils.isLetter(value[end]) ? end - 1 : end;
        return text + value.slice(suffix);
      } else if (end === value.length) {
        return value.slice(0, start) + text;
      }
      var selectionValue = value.slice(start, end);
      // Fix: if the suffix starts with a space, the input will be cleared after pasting
      var space = /\s$/.test(selectionValue) ? ' ' : '';
      return value.slice(0, start) + text + space + value.slice(end);
    };
    var deleteRange = function deleteRange(value, start, end) {
      var newValueStr;
      if (end - start === value.length) {
        newValueStr = '';
      } else if (start === 0) {
        newValueStr = value.slice(end);
      } else if (end === value.length) {
        newValueStr = value.slice(0, start);
      } else {
        newValueStr = value.slice(0, start) + value.slice(end);
      }
      return newValueStr;
    };
    var initCursor = function initCursor() {
      var selectionStart = inputRef.current.selectionStart;
      var inputValue = inputRef.current.value;
      var valueLength = inputValue.length;
      var index = null;

      // remove prefix
      var prefixLength = (prefixChar.current || '').length;
      inputValue = inputValue.replace(_prefix.current, '');
      selectionStart = selectionStart - prefixLength;
      var _char5 = inputValue.charAt(selectionStart);
      if (isNumeralChar(_char5)) {
        return selectionStart + prefixLength;
      }

      //left
      var i = selectionStart - 1;
      while (i >= 0) {
        _char5 = inputValue.charAt(i);
        if (isNumeralChar(_char5)) {
          index = i + prefixLength;
          break;
        } else {
          i--;
        }
      }
      if (index !== null) {
        inputRef.current.setSelectionRange(index + 1, index + 1);
      } else {
        i = selectionStart;
        while (i < valueLength) {
          _char5 = inputValue.charAt(i);
          if (isNumeralChar(_char5)) {
            index = i + prefixLength;
            break;
          } else {
            i++;
          }
        }
        if (index !== null) {
          inputRef.current.setSelectionRange(index, index);
        }
      }
      return index || 0;
    };
    var onInputPointerDown = function onInputPointerDown() {
      isFocusedByClick.current = true;
    };
    var onInputClick = function onInputClick() {
      initCursor();
    };
    var isNumeralChar = function isNumeralChar(_char6) {
      if (_char6.length === 1 && (_numeral.current.test(_char6) || _decimal.current.test(_char6) || _group.current.test(_char6) || _minusSign.current.test(_char6))) {
        resetRegex();
        return true;
      }
      return false;
    };
    var resetRegex = function resetRegex() {
      _numeral.current.lastIndex = 0;
      _decimal.current.lastIndex = 0;
      _group.current.lastIndex = 0;
      _minusSign.current.lastIndex = 0;
    };
    var updateValue = function updateValue(event, valueStr, insertedValueStr, operation) {
      var currentValue = inputRef.current.value;
      var newValue = null;
      if (valueStr != null) {
        newValue = evaluateEmpty(parseValue(valueStr));
        updateInput(newValue, insertedValueStr, operation, valueStr);
        handleOnChange(event, currentValue, newValue);
      }
    };
    var evaluateEmpty = function evaluateEmpty(newValue) {
      return !newValue && !props.allowEmpty ? props.min || 0 : newValue;
    };
    var handleOnChange = function handleOnChange(event, currentValue, newValue) {
      if (props.onChange && isValueChanged(currentValue, newValue)) {
        props.onChange({
          originalEvent: event,
          value: newValue
        });
      }
    };
    var isValueChanged = function isValueChanged(currentValue, newValue) {
      if (newValue === null && currentValue !== null) {
        return true;
      }
      if (newValue != null) {
        var parsedCurrentValue = typeof currentValue === 'string' ? parseValue(currentValue) : currentValue;
        return newValue !== parsedCurrentValue;
      }
      return false;
    };
    var validateValue = function validateValue(value) {
      if (value === '-') {
        return null;
      }
      return validateValueByLimit(value);
    };
    var validateValueByLimit = function validateValueByLimit(value) {
      if (ObjectUtils.isEmpty(value)) {
        return null;
      }
      if (props.min !== null && value < props.min) {
        return props.min;
      }
      if (props.max !== null && value > props.max) {
        return props.max;
      }
      return value;
    };
    var updateInput = function updateInput(value, insertedValueStr, operation, valueStr) {
      insertedValueStr = insertedValueStr || '';
      var inputEl = inputRef.current;
      var inputValue = inputEl.value;
      var newValue = formatValue(value);
      var currentLength = inputValue.length;
      if (newValue !== valueStr) {
        newValue = concatValues(newValue, valueStr);
      }
      if (currentLength === 0) {
        inputEl.value = newValue;
        inputEl.setSelectionRange(0, 0);
        var index = initCursor();
        var selectionEnd = index + insertedValueStr.length + (isDecimalSign(insertedValueStr) ? 1 : 0);
        inputEl.setSelectionRange(selectionEnd, selectionEnd);
      } else {
        var selectionStart = inputEl.selectionStart;
        var _selectionEnd = inputEl.selectionEnd;
        if (props.maxLength && props.maxLength < newValue.length) {
          return;
        }
        inputEl.value = newValue;
        var newLength = newValue.length;
        if (operation === 'range-insert') {
          var startValue = parseValue((inputValue || '').slice(0, selectionStart));
          var startValueStr = startValue !== null ? startValue.toString() : '';
          var startExpr = startValueStr.split('').join("(".concat(groupChar.current, ")?"));
          var sRegex = new RegExp(startExpr, 'g');
          sRegex.test(newValue);
          var tExpr = insertedValueStr.split('').join("(".concat(groupChar.current, ")?"));
          var tRegex = new RegExp(tExpr, 'g');
          tRegex.test(newValue.slice(sRegex.lastIndex));
          _selectionEnd = sRegex.lastIndex + tRegex.lastIndex;
          inputEl.setSelectionRange(_selectionEnd, _selectionEnd);
        } else if (newLength === currentLength) {
          if (operation === 'insert' || operation === 'delete-back-single') {
            var newSelectionEnd = _selectionEnd;
            if (insertedValueStr === '0') {
              newSelectionEnd = _selectionEnd + 1;
            } else {
              newSelectionEnd = newSelectionEnd + Number(isDecimalSign(value) || isDecimalSign(insertedValueStr));
            }
            inputEl.setSelectionRange(newSelectionEnd, newSelectionEnd);
          } else if (operation === 'delete-single') {
            inputEl.setSelectionRange(_selectionEnd - 1, _selectionEnd - 1);
          } else if (operation === 'delete-range' || operation === 'spin') {
            inputEl.setSelectionRange(_selectionEnd, _selectionEnd);
          }
        } else if (operation === 'delete-back-single') {
          var prevChar = inputValue.charAt(_selectionEnd - 1);
          var nextChar = inputValue.charAt(_selectionEnd);
          var diff = currentLength - newLength;
          var isGroupChar = _group.current.test(nextChar);
          if (isGroupChar && diff === 1) {
            _selectionEnd = _selectionEnd + 1;
          } else if (!isGroupChar && isNumeralChar(prevChar)) {
            _selectionEnd = _selectionEnd + (-1 * diff + 1);
          }
          _group.current.lastIndex = 0;
          inputEl.setSelectionRange(_selectionEnd, _selectionEnd);
        } else if (inputValue === '-' && operation === 'insert') {
          inputEl.setSelectionRange(0, 0);
          var _index2 = initCursor();
          var _selectionEnd2 = _index2 + insertedValueStr.length + 1;
          inputEl.setSelectionRange(_selectionEnd2, _selectionEnd2);
        } else {
          _selectionEnd = _selectionEnd + (newLength - currentLength);
          inputEl.setSelectionRange(_selectionEnd, _selectionEnd);
        }
      }
      inputEl.setAttribute('aria-valuenow', value);
    };
    var updateInputValue = function updateInputValue(newValue) {
      newValue = evaluateEmpty(newValue);
      var inputEl = inputRef.current;
      var value = inputEl.value;
      var _formattedValue = formattedValue(newValue);
      if (value !== _formattedValue) {
        inputEl.value = _formattedValue;
        inputEl.setAttribute('aria-valuenow', newValue);
      }
    };
    var formattedValue = function formattedValue(val) {
      return formatValue(evaluateEmpty(val));
    };
    var concatValues = function concatValues(val1, val2) {
      if (val1 && val2) {
        var decimalCharIndex = val2.search(_decimal.current);
        _decimal.current.lastIndex = 0;
        var newVal1 = replaceDecimalSeparator(val1).split(_decimal.current)[0].replace(_suffix.current, '').trim();
        return decimalCharIndex !== -1 ? newVal1 + val2.slice(decimalCharIndex) : val1;
      }
      return val1;
    };
    var getDecimalLength = function getDecimalLength(value) {
      if (value) {
        var valueSplit = value.split(_decimal.current);
        if (valueSplit.length === 2) {
          return replaceSuffix(valueSplit[1]).length;
        }
      }
      return 0;
    };
    var updateModel = function updateModel(event, value) {
      if (props.onValueChange) {
        props.onValueChange({
          originalEvent: event,
          value: value,
          stopPropagation: function stopPropagation() {
            event === null || event === void 0 || event.stopPropagation();
          },
          preventDefault: function preventDefault() {
            event === null || event === void 0 || event.preventDefault();
          },
          target: {
            name: props.name,
            id: props.id,
            value: value
          }
        });
      }
    };
    var onInputFocus = function onInputFocus(event) {
      setFocusedState(true);
      props.onFocus && props.onFocus(event);
      if ((props.suffix || props.currency || props.prefix) && inputRef.current && !isFocusedByClick.current) {
        // GitHub #1866,#5537
        var inputValue = inputRef.current.value;
        var prefixLength = (prefixChar.current || '').length;
        var suffixLength = (suffixChar.current || '').length;
        var end = inputValue.length === 0 ? 0 : inputValue.length - suffixLength;
        inputRef.current.setSelectionRange(prefixLength, end);
      }
    };
    var onInputBlur = function onInputBlur(event) {
      setFocusedState(false);
      isFocusedByClick.current = false;
      if (inputRef.current) {
        var currentValue = inputRef.current.value;
        if (isValueChanged(currentValue, props.value)) {
          var newValue = validateValue(parseValue(currentValue));
          updateInputValue(newValue);
          updateModel(event, newValue);
        }
      }
      props.onBlur && props.onBlur(event);
    };
    var clearTimer = function clearTimer() {
      if (timer.current) {
        clearInterval(timer.current);
      }
    };
    var changeValue = function changeValue() {
      var val = validateValueByLimit(props.value);
      updateInputValue(props.format ? val : replaceDecimalSeparator(val));
      var newValue = validateValue(props.value);
      if (props.value !== null && props.value !== newValue) {
        updateModel(null, newValue);
      }
    };
    var getFormatter = function getFormatter() {
      return numberFormat.current;
    };
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        focus: function focus() {
          return DomHandler.focus(inputRef.current);
        },
        getFormatter: getFormatter,
        getElement: function getElement() {
          return elementRef.current;
        },
        getInput: function getInput() {
          return inputRef.current;
        }
      };
    });
    React__namespace.useEffect(function () {
      ObjectUtils.combinedRefs(inputRef, props.inputRef);
    }, [inputRef, props.inputRef]);
    useUnmountEffect(function () {
      clearTimer();
    });
    useMountEffect(function () {
      constructParser();
      var newValue = validateValue(props.value);
      if (props.value !== null && props.value !== newValue) {
        updateModel(null, newValue);
      }
    });
    useUpdateEffect(function () {
      constructParser();
      changeValue();
    }, [_locale, props.locale, props.localeMatcher, props.mode, props.currency, props.currencyDisplay, props.useGrouping, props.minFractionDigits, props.maxFractionDigits, props.suffix, props.prefix]);
    useUpdateEffect(function () {
      changeValue();
    }, [props.value]);
    useUpdateEffect(function () {
      // #5245 prevent infinite loop
      if (props.disabled) {
        clearTimer();
      }
    }, [props.disabled]);
    var createInputElement = function createInputElement() {
      var className = classNames(props.inputClassName, cx('input', {
        context: context
      }));
      var valueToRender = formattedValue(props.value);
      return /*#__PURE__*/React__namespace.createElement(InputText, _extends({
        ref: inputRef,
        id: props.inputId,
        style: props.inputStyle,
        role: "spinbutton",
        className: className,
        defaultValue: valueToRender,
        type: props.type,
        size: props.size,
        tabIndex: props.tabIndex,
        inputMode: inputMode,
        maxLength: props.maxLength,
        disabled: props.disabled,
        required: props.required,
        pattern: props.pattern,
        placeholder: props.placeholder,
        readOnly: props.readOnly,
        name: props.name,
        autoFocus: props.autoFocus,
        onKeyDown: onInputKeyDown,
        onKeyPress: onInputAndroidKey,
        onInput: onInput,
        onClick: onInputClick,
        onPointerDown: onInputPointerDown,
        onBlur: onInputBlur,
        onFocus: onInputFocus,
        onPaste: onPaste,
        min: props.min,
        max: props.max,
        "aria-valuemin": props.min,
        "aria-valuemax": props.max,
        "aria-valuenow": props.value
      }, ariaProps, dataProps, {
        pt: ptm('input'),
        unstyled: props.unstyled,
        __parentMetadata: {
          parent: metaData
        }
      }));
    };
    var createUpButton = function createUpButton() {
      var incrementIconProps = mergeProps({
        className: cx('incrementIcon')
      }, ptm('incrementIcon'));
      var icon = props.incrementButtonIcon || /*#__PURE__*/React__namespace.createElement(AngleUpIcon, incrementIconProps);
      var upButton = IconUtils.getJSXIcon(icon, _objectSpread$1t({}, incrementIconProps), {
        props: props
      });
      var incrementButtonProps = mergeProps({
        type: 'button',
        className: classNames(props.incrementButtonClassName, cx('incrementButton')),
        onPointerLeave: onUpButtonMouseLeave,
        onPointerDown: function onPointerDown(e) {
          return onUpButtonMouseDown(e);
        },
        onPointerUp: onUpButtonMouseUp,
        onKeyDown: function onKeyDown(e) {
          return onUpButtonKeyDown(e);
        },
        onKeyUp: onUpButtonKeyUp,
        disabled: props.disabled,
        tabIndex: -1,
        'aria-hidden': true
      }, ptm('incrementButton'));
      return /*#__PURE__*/React__namespace.createElement("button", incrementButtonProps, upButton, /*#__PURE__*/React__namespace.createElement(Ripple, null));
    };
    var createDownButton = function createDownButton() {
      var decrementIconProps = mergeProps({
        className: cx('decrementIcon')
      }, ptm('decrementIcon'));
      var icon = props.decrementButtonIcon || /*#__PURE__*/React__namespace.createElement(AngleDownIcon, decrementIconProps);
      var downButton = IconUtils.getJSXIcon(icon, _objectSpread$1t({}, decrementIconProps), {
        props: props
      });
      var decrementButtonProps = mergeProps({
        type: 'button',
        className: classNames(props.decrementButtonClassName, cx('decrementButton')),
        onPointerLeave: onDownButtonMouseLeave,
        onPointerDown: function onPointerDown(e) {
          return onDownButtonMouseDown(e);
        },
        onPointerUp: onDownButtonMouseUp,
        onKeyDown: function onKeyDown(e) {
          return onDownButtonKeyDown(e);
        },
        onKeyUp: onDownButtonKeyUp,
        disabled: props.disabled,
        tabIndex: -1,
        'aria-hidden': true
      }, ptm('decrementButton'));
      return /*#__PURE__*/React__namespace.createElement("button", decrementButtonProps, downButton, /*#__PURE__*/React__namespace.createElement(Ripple, null));
    };
    var createButtonGroup = function createButtonGroup() {
      var upButton = props.showButtons && createUpButton();
      var downButton = props.showButtons && createDownButton();
      var buttonGroupProps = mergeProps({
        className: cx('buttonGroup')
      }, ptm('buttonGroup'));
      if (stacked) {
        return /*#__PURE__*/React__namespace.createElement("span", buttonGroupProps, upButton, downButton);
      }
      return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, null, upButton, downButton);
    };
    var hasTooltip = ObjectUtils.isNotEmpty(props.tooltip);
    var otherProps = InputNumberBase.getOtherProps(props);
    var dataProps = ObjectUtils.reduceKeys(otherProps, DomHandler.DATA_PROPS);
    var ariaProps = ObjectUtils.reduceKeys(otherProps, DomHandler.ARIA_PROPS);
    var inputElement = createInputElement();
    var buttonGroup = createButtonGroup();
    var rootProps = mergeProps({
      id: props.id,
      className: classNames(props.className, cx('root', {
        focusedState: focusedState,
        stacked: stacked,
        horizontal: horizontal,
        vertical: vertical
      })),
      style: props.style
    }, otherProps, ptm('root'));
    return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, null, /*#__PURE__*/React__namespace.createElement("span", _extends({
      ref: elementRef
    }, rootProps), inputElement, buttonGroup), hasTooltip && /*#__PURE__*/React__namespace.createElement(Tooltip, _extends({
      target: elementRef,
      content: props.tooltip,
      pt: ptm('tooltip')
    }, props.tooltipOptions)));
  }));
  InputNumber.displayName = 'InputNumber';

  var JumpToPageInput = /*#__PURE__*/React__namespace.memo(function (inProps) {
    useMergeProps();
    var context = React__namespace.useContext(PrimeReactContext);
    var props = JumpToPageInputBase.getProps(inProps, context);
    var ariaLabelValue = ariaLabel('jumpToPageInputLabel');
    var onChange = function onChange(event) {
      if (props.onChange) {
        props.onChange(props.rows * (event.value - 1), props.rows);
      }
    };
    var value = props.totalPages > 0 ? props.page + 1 : 0;
    var element = /*#__PURE__*/React__namespace.createElement(InputNumber, {
      value: value,
      onChange: onChange,
      className: "p-paginator-page-input",
      disabled: props.disabled,
      pt: props.ptm('JTPInput'),
      unstyled: props.unstyled,
      __parentMetadata: {
        parent: props.metaData
      },
      "aria-label": ariaLabelValue
    });
    if (props.template) {
      var defaultOptions = {
        value: value,
        onChange: onChange,
        disabled: props.disabled,
        className: 'p-paginator-page-input',
        'aria-label': ariaLabelValue,
        element: element,
        props: props
      };
      return ObjectUtils.getJSXElement(props.template, defaultOptions);
    }
    return element;
  });
  JumpToPageInput.displayName = 'JumpToPageInput';

  var AngleDoubleRightIcon = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("path", {
      fillRule: "evenodd",
      clipRule: "evenodd",
      d: "M7.68757 11.1451C7.7791 11.1831 7.8773 11.2024 7.9764 11.2019C8.07769 11.1985 8.17721 11.1745 8.26886 11.1312C8.36052 11.088 8.44238 11.0265 8.50943 10.9505L12.0294 7.49085C12.1707 7.34942 12.25 7.15771 12.25 6.95782C12.25 6.75794 12.1707 6.56622 12.0294 6.42479L8.50943 2.90479C8.37014 2.82159 8.20774 2.78551 8.04633 2.80192C7.88491 2.81833 7.73309 2.88635 7.6134 2.99588C7.4937 3.10541 7.41252 3.25061 7.38189 3.40994C7.35126 3.56927 7.37282 3.73423 7.44337 3.88033L10.4605 6.89748L7.44337 9.91463C7.30212 10.0561 7.22278 10.2478 7.22278 10.4477C7.22278 10.6475 7.30212 10.8393 7.44337 10.9807C7.51301 11.0512 7.59603 11.1071 7.68757 11.1451ZM1.94207 10.9505C2.07037 11.0968 2.25089 11.1871 2.44493 11.2019C2.63898 11.1871 2.81949 11.0968 2.94779 10.9505L6.46779 7.49085C6.60905 7.34942 6.68839 7.15771 6.68839 6.95782C6.68839 6.75793 6.60905 6.56622 6.46779 6.42479L2.94779 2.90479C2.80704 2.83757 2.6489 2.81563 2.49517 2.84201C2.34143 2.86839 2.19965 2.94178 2.08936 3.05207C1.97906 3.16237 1.90567 3.30415 1.8793 3.45788C1.85292 3.61162 1.87485 3.76975 1.94207 3.9105L4.95922 6.92765L1.94207 9.9448C1.81838 10.0831 1.75 10.2621 1.75 10.4477C1.75 10.6332 1.81838 10.8122 1.94207 10.9505Z",
      fill: "currentColor"
    }));
  }));
  AngleDoubleRightIcon.displayName = 'AngleDoubleRightIcon';

  function ownKeys$1s(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1s(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1s(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1s(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var LastPageLink = /*#__PURE__*/React__namespace.memo(function (inProps) {
    var mergeProps = useMergeProps();
    var context = React__namespace.useContext(PrimeReactContext);
    var props = LastPageLinkBase.getProps(inProps, context);
    var ptm = props.ptm,
      cx = props.cx;
    var getPTOptions = function getPTOptions(key) {
      return ptm(key, {
        hostName: props.hostName,
        context: {
          disabled: props.disabled
        }
      });
    };
    var className = classNames('p-paginator-last p-paginator-element p-link', {
      'p-disabled': props.disabled
    });
    var iconClassName = 'p-paginator-icon';
    var lastPageIconProps = mergeProps({
      className: cx('lastPageIcon')
    }, getPTOptions('lastPageIcon'));
    var icon = props.lastPageLinkIcon || /*#__PURE__*/React__namespace.createElement(AngleDoubleRightIcon, lastPageIconProps);
    var lastPageLinkIcon = IconUtils.getJSXIcon(icon, _objectSpread$1s({}, lastPageIconProps), {
      props: props
    });
    var lastPageButtonProps = mergeProps({
      type: 'button',
      className: cx('lastPageButton', {
        disabled: props.disabled
      }),
      onClick: props.onClick,
      disabled: props.disabled,
      'aria-label': ariaLabel('lastPageLabel')
    }, getPTOptions('lastPageButton'));
    var element = /*#__PURE__*/React__namespace.createElement("button", lastPageButtonProps, lastPageLinkIcon, /*#__PURE__*/React__namespace.createElement(Ripple, null));
    if (props.template) {
      var defaultOptions = {
        onClick: props.onClick,
        className: className,
        iconClassName: iconClassName,
        disabled: props.disabled,
        element: element,
        props: props
      };
      return ObjectUtils.getJSXElement(props.template, defaultOptions);
    }
    return element;
  });
  LastPageLink.displayName = 'LastPageLink';

  function ownKeys$1r(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1r(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1r(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1r(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var NextPageLink = /*#__PURE__*/React__namespace.memo(function (inProps) {
    var mergeProps = useMergeProps();
    var context = React__namespace.useContext(PrimeReactContext);
    var props = NextPageLinkBase.getProps(inProps, context);
    var ptm = props.ptm,
      cx = props.cx;
    var getPTOptions = function getPTOptions(key) {
      return ptm(key, {
        hostName: props.hostName,
        context: {
          disabled: props.disabled
        }
      });
    };
    var className = classNames('p-paginator-next p-paginator-element p-link', {
      'p-disabled': props.disabled
    });
    var iconClassName = 'p-paginator-icon';
    var nextPageIconProps = mergeProps({
      className: cx('nextPageIcon')
    }, getPTOptions('nextPageIcon'));
    var icon = props.nextPageLinkIcon || /*#__PURE__*/React__namespace.createElement(AngleRightIcon, nextPageIconProps);
    var nextPageLinkIcon = IconUtils.getJSXIcon(icon, _objectSpread$1r({}, nextPageIconProps), {
      props: props
    });
    var nextPageButtonProps = mergeProps({
      type: 'button',
      className: cx('nextPageButton', {
        disabled: props.disabled
      }),
      onClick: props.onClick,
      disabled: props.disabled,
      'aria-label': ariaLabel('nextPageLabel')
    }, getPTOptions('nextPageButton'));
    var element = /*#__PURE__*/React__namespace.createElement("button", nextPageButtonProps, nextPageLinkIcon, /*#__PURE__*/React__namespace.createElement(Ripple, null));
    if (props.template) {
      var defaultOptions = {
        onClick: props.onClick,
        className: className,
        iconClassName: iconClassName,
        disabled: props.disabled,
        element: element,
        nextPageLinkIcon: nextPageLinkIcon,
        props: props
      };
      return ObjectUtils.getJSXElement(props.template, defaultOptions);
    }
    return element;
  });
  NextPageLink.displayName = 'NextPageLink';

  var PageLinks = /*#__PURE__*/React__namespace.memo(function (inProps) {
    var mergeProps = useMergeProps();
    var context = React__namespace.useContext(PrimeReactContext);
    var props = PageLinksBase.getProps(inProps, context);
    var ptm = props.ptm,
      cx = props.cx;
    var getPTOptions = function getPTOptions(pageLink, key) {
      return ptm(key, {
        hostName: props.hostName,
        context: {
          active: pageLink - 1 === props.page
        }
      });
    };
    var onPageLinkClick = function onPageLinkClick(event, pageLink) {
      if (props.onClick) {
        props.onClick({
          originalEvent: event,
          value: pageLink
        });
      }
      event.preventDefault();
    };
    var elements;
    if (props.value) {
      var startPageInView = props.value[0];
      var endPageInView = props.value[props.value.length - 1];
      elements = props.value.map(function (pageLink) {
        var className = classNames('p-paginator-page p-paginator-element p-link', {
          'p-paginator-page-start': pageLink === startPageInView,
          'p-paginator-page-end': pageLink === endPageInView,
          'p-highlight': pageLink - 1 === props.page
        });
        var pageButtonProps = mergeProps({
          type: 'button',
          onClick: function onClick(e) {
            return onPageLinkClick(e, pageLink);
          },
          className: cx('pageButton', {
            pageLink: pageLink,
            startPageInView: startPageInView,
            endPageInView: endPageInView,
            page: props.page
          }),
          disabled: props.disabled,
          'aria-label': ariaLabel('pageLabel', {
            page: pageLink
          }),
          'aria-current': pageLink - 1 === props.page ? 'true' : undefined
        }, getPTOptions(pageLink, 'pageButton'));
        var element = /*#__PURE__*/React__namespace.createElement("button", pageButtonProps, pageLink, /*#__PURE__*/React__namespace.createElement(Ripple, null));
        if (props.template) {
          var defaultOptions = {
            onClick: function onClick(e) {
              return onPageLinkClick(e, pageLink);
            },
            className: className,
            view: {
              startPage: startPageInView - 1,
              endPage: endPageInView - 1
            },
            page: pageLink - 1,
            currentPage: props.page,
            totalPages: props.totalPages,
            ariaLabel: ariaLabel('pageLabel', {
              page: pageLink
            }),
            ariaCurrent: pageLink - 1 === props.page ? 'true' : undefined,
            element: element,
            props: props
          };
          element = ObjectUtils.getJSXElement(props.template, defaultOptions);
        }
        return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, {
          key: pageLink
        }, element);
      });
    }
    var pagesProps = mergeProps({
      className: cx('pages')
    }, ptm('pages', {
      hostName: props.hostName
    }));
    return /*#__PURE__*/React__namespace.createElement("span", pagesProps, elements);
  });
  PageLinks.displayName = 'PageLinks';

  var AngleLeftIcon = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("path", {
      d: "M8.75 11.185C8.65146 11.1854 8.55381 11.1662 8.4628 11.1284C8.37179 11.0906 8.28924 11.0351 8.22 10.965L4.72 7.46496C4.57955 7.32433 4.50066 7.13371 4.50066 6.93496C4.50066 6.73621 4.57955 6.54558 4.72 6.40496L8.22 2.93496C8.36095 2.84357 8.52851 2.80215 8.69582 2.81733C8.86312 2.83252 9.02048 2.90344 9.14268 3.01872C9.26487 3.134 9.34483 3.28696 9.36973 3.4531C9.39463 3.61924 9.36303 3.78892 9.28 3.93496L6.28 6.93496L9.28 9.93496C9.42045 10.0756 9.49934 10.2662 9.49934 10.465C9.49934 10.6637 9.42045 10.8543 9.28 10.995C9.13526 11.1257 8.9448 11.1939 8.75 11.185Z",
      fill: "currentColor"
    }));
  }));
  AngleLeftIcon.displayName = 'AngleLeftIcon';

  function ownKeys$1q(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1q(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1q(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1q(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var PrevPageLink = /*#__PURE__*/React__namespace.memo(function (inProps) {
    var mergeProps = useMergeProps();
    var context = React__namespace.useContext(PrimeReactContext);
    var props = PrevPageLinkBase.getProps(inProps, context);
    var ptm = props.ptm,
      cx = props.cx;
    var getPTOptions = function getPTOptions(key) {
      return ptm(key, {
        hostName: props.hostName,
        context: {
          disabled: props.disabled
        }
      });
    };
    var className = classNames('p-paginator-prev p-paginator-element p-link', {
      'p-disabled': props.disabled
    });
    var iconClassName = 'p-paginator-icon';
    var prevPageIconProps = mergeProps({
      className: cx('prevPageIcon')
    }, getPTOptions('prevPageIcon'));
    var icon = props.prevPageLinkIcon || /*#__PURE__*/React__namespace.createElement(AngleLeftIcon, prevPageIconProps);
    var prevPageLinkIcon = IconUtils.getJSXIcon(icon, _objectSpread$1q({}, prevPageIconProps), {
      props: props
    });
    var prevPageButtonProps = mergeProps({
      type: 'button',
      className: cx('prevPageButton', {
        disabled: props.disabled
      }),
      onClick: props.onClick,
      disabled: props.disabled,
      'aria-label': ariaLabel('prevPageLabel')
    }, getPTOptions('prevPageButton'));
    var element = /*#__PURE__*/React__namespace.createElement("button", prevPageButtonProps, prevPageLinkIcon, /*#__PURE__*/React__namespace.createElement(Ripple, null));
    if (props.template) {
      var defaultOptions = {
        onClick: props.onClick,
        className: className,
        iconClassName: iconClassName,
        disabled: props.disabled,
        element: element,
        props: props
      };
      return ObjectUtils.getJSXElement(props.template, defaultOptions);
    }
    return element;
  });
  PrevPageLink.displayName = 'PrevPageLink';

  function ownKeys$1p(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1p(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1p(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1p(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var classes$U = {
    root: function root(_ref) {
      var props = _ref.props,
        focusedState = _ref.focusedState,
        overlayVisibleState = _ref.overlayVisibleState,
        context = _ref.context;
      return classNames('p-dropdown p-component p-inputwrapper', {
        'p-disabled': props.disabled,
        'p-invalid': props.invalid,
        'p-focus': focusedState,
        'p-variant-filled': props.variant ? props.variant === 'filled' : context && context.inputStyle === 'filled',
        'p-dropdown-clearable': props.showClear && !props.disabled,
        'p-inputwrapper-filled': ObjectUtils.isNotEmpty(props.value),
        'p-inputwrapper-focus': focusedState || overlayVisibleState
      });
    },
    input: function input(_ref2) {
      var props = _ref2.props,
        label = _ref2.label;
      return props.editable ? 'p-dropdown-label p-inputtext' : classNames('p-dropdown-label p-inputtext', {
        'p-placeholder': label === null && props.placeholder,
        'p-dropdown-label-empty': label === null && !props.placeholder
      });
    },
    trigger: 'p-dropdown-trigger',
    emptyMessage: 'p-dropdown-empty-message',
    itemGroup: function itemGroup(_ref3) {
      var optionGroupLabel = _ref3.optionGroupLabel;
      return classNames('p-dropdown-item-group', {
        'p-dropdown-item-empty': !optionGroupLabel || optionGroupLabel.length === 0
      });
    },
    itemGroupLabel: 'p-dropdown-item-group-label',
    dropdownIcon: 'p-dropdown-trigger-icon p-clickable',
    loadingIcon: 'p-dropdown-trigger-icon p-clickable',
    clearIcon: 'p-dropdown-clear-icon p-clickable',
    filterIcon: 'p-dropdown-filter-icon',
    filterClearIcon: 'p-dropdown-filter-clear-icon',
    filterContainer: function filterContainer(_ref4) {
      var clearIcon = _ref4.clearIcon;
      return classNames('p-dropdown-filter-container', {
        'p-dropdown-clearable-filter': !!clearIcon
      });
    },
    filterInput: function filterInput(_ref5) {
      var props = _ref5.props,
        context = _ref5.context;
      return classNames('p-dropdown-filter p-inputtext p-component', {
        'p-variant-filled': props.variant ? props.variant === 'filled' : context && context.inputStyle === 'filled'
      });
    },
    list: function list(_ref6) {
      var virtualScrollerOptions = _ref6.virtualScrollerOptions;
      return virtualScrollerOptions ? 'p-dropdown-items' : 'p-dropdown-items';
    },
    panel: function panel(_ref7) {
      var context = _ref7.context;
      return classNames('p-dropdown-panel p-component', {
        'p-input-filled': context && context.inputStyle === 'filled' || PrimeReact.inputStyle === 'filled',
        'p-ripple-disabled': context && context.ripple === false || PrimeReact.ripple === false
      });
    },
    item: function item(_ref8) {
      var selected = _ref8.selected,
        disabled = _ref8.disabled,
        label = _ref8.label,
        index = _ref8.index,
        focusedOptionIndex = _ref8.focusedOptionIndex,
        highlightOnSelect = _ref8.highlightOnSelect;
      return classNames('p-dropdown-item', {
        'p-highlight': selected && highlightOnSelect,
        'p-disabled': disabled,
        'p-focus': index === focusedOptionIndex,
        'p-dropdown-item-empty': !label || label.length === 0
      });
    },
    itemLabel: 'p-dropdown-item-label',
    checkIcon: 'p-dropdown-check-icon',
    blankIcon: 'p-dropdown-blank-icon',
    wrapper: 'p-dropdown-items-wrapper',
    header: 'p-dropdown-header',
    footer: 'p-dropdown-footer',
    transition: 'p-connected-overlay'
  };
  var styles$J = "\n@layer primereact {\n    .p-dropdown {\n        display: inline-flex;\n        cursor: pointer;\n        position: relative;\n        user-select: none;\n    }\n    \n    .p-dropdown-trigger {\n        display: flex;\n        align-items: center;\n        justify-content: center;\n        flex-shrink: 0;\n    }\n    \n    .p-dropdown-label {\n        display: block;\n        white-space: nowrap;\n        overflow: hidden;\n        flex: 1 1 auto;\n        width: 1%;\n        text-overflow: ellipsis;\n        cursor: pointer;\n    }\n    \n    .p-dropdown-label-empty {\n        overflow: hidden;\n        visibility: hidden;\n    }\n    \n    input.p-dropdown-label  {\n        cursor: default;\n    }\n    \n    .p-dropdown .p-dropdown-panel {\n        min-width: 100%;\n    }\n    \n    .p-dropdown-panel {\n        position: absolute;\n        top: 0;\n        left: 0;\n    }\n    \n    .p-dropdown-items-wrapper {\n        overflow: auto;\n    }\n    \n    .p-dropdown-item {\n        cursor: pointer;\n        font-weight: normal;\n        white-space: nowrap;\n        position: relative;\n        overflow: hidden;\n    }\n    \n    .p-dropdown-items {\n        margin: 0;\n        padding: 0;\n        list-style-type: none;\n    }\n    \n    .p-dropdown-filter {\n        width: 100%;\n    }\n    \n    .p-dropdown-filter-container {\n        position: relative;\n    }\n    \n    .p-dropdown-clear-icon,\n    .p-dropdown-filter-icon,\n    .p-dropdown-filter-clear-icon {\n        position: absolute;\n        top: 50%;\n        margin-top: -.5rem;\n        right: 2rem;\n    }\n    \n    .p-fluid .p-dropdown {\n        display: flex;\n    }\n    \n    .p-fluid .p-dropdown .p-dropdown-label {\n        width: 1%;\n    }\n}\n";
  var inlineStyles$i = {
    wrapper: function wrapper(_ref9) {
      var props = _ref9.props;
      return {
        maxHeight: props.scrollHeight || 'auto'
      };
    },
    panel: function panel(_ref10) {
      var props = _ref10.props;
      return _objectSpread$1p({}, props.panelStyle);
    }
  };
  var DropdownBase = ComponentBase.extend({
    defaultProps: {
      __TYPE: 'Dropdown',
      __parentMetadata: null,
      appendTo: null,
      ariaLabel: null,
      ariaLabelledBy: null,
      autoFocus: false,
      autoOptionFocus: false,
      checkmark: false,
      children: undefined,
      className: null,
      clearIcon: null,
      collapseIcon: null,
      dataKey: null,
      disabled: false,
      dropdownIcon: null,
      editable: false,
      emptyFilterMessage: null,
      emptyMessage: null,
      filter: false,
      filterBy: null,
      filterClearIcon: null,
      filterDelay: 300,
      filterIcon: null,
      filterInputAutoFocus: false,
      filterLocale: undefined,
      filterMatchMode: 'contains',
      filterPlaceholder: null,
      filterTemplate: null,
      focusInputRef: null,
      focusOnHover: true,
      highlightOnSelect: true,
      id: null,
      inputId: null,
      inputRef: null,
      invalid: false,
      itemTemplate: null,
      loading: false,
      loadingIcon: null,
      maxLength: null,
      name: null,
      onBlur: null,
      onChange: null,
      onClick: null,
      onContextMenu: null,
      onFilter: null,
      onFocus: null,
      onHide: null,
      onMouseDown: null,
      onShow: null,
      optionDisabled: null,
      optionGroupChildren: 'items',
      optionGroupLabel: null,
      optionGroupTemplate: null,
      optionLabel: null,
      options: null,
      optionValue: null,
      panelClassName: null,
      panelFooterTemplate: null,
      panelStyle: null,
      placeholder: null,
      required: false,
      resetFilterOnHide: false,
      scrollHeight: '200px',
      selectOnFocus: false,
      showClear: false,
      showFilterClear: false,
      showOnFocus: false,
      style: null,
      tabIndex: null,
      tooltip: null,
      tooltipOptions: null,
      transitionOptions: null,
      useOptionAsValue: false,
      value: null,
      valueTemplate: null,
      variant: null,
      virtualScrollerOptions: null
    },
    css: {
      classes: classes$U,
      styles: styles$J,
      inlineStyles: inlineStyles$i
    }
  });

  var SearchIcon = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("path", {
      fillRule: "evenodd",
      clipRule: "evenodd",
      d: "M2.67602 11.0265C3.6661 11.688 4.83011 12.0411 6.02086 12.0411C6.81149 12.0411 7.59438 11.8854 8.32483 11.5828C8.87005 11.357 9.37808 11.0526 9.83317 10.6803L12.9769 13.8241C13.0323 13.8801 13.0983 13.9245 13.171 13.9548C13.2438 13.985 13.3219 14.0003 13.4007 14C13.4795 14.0003 13.5575 13.985 13.6303 13.9548C13.7031 13.9245 13.7691 13.8801 13.8244 13.8241C13.9367 13.7116 13.9998 13.5592 13.9998 13.4003C13.9998 13.2414 13.9367 13.089 13.8244 12.9765L10.6807 9.8328C11.053 9.37773 11.3573 8.86972 11.5831 8.32452C11.8857 7.59408 12.0414 6.81119 12.0414 6.02056C12.0414 4.8298 11.6883 3.66579 11.0268 2.67572C10.3652 1.68564 9.42494 0.913972 8.32483 0.45829C7.22472 0.00260857 6.01418 -0.116618 4.84631 0.115686C3.67844 0.34799 2.60568 0.921393 1.76369 1.76338C0.921698 2.60537 0.348296 3.67813 0.115991 4.84601C-0.116313 6.01388 0.00291375 7.22441 0.458595 8.32452C0.914277 9.42464 1.68595 10.3649 2.67602 11.0265ZM3.35565 2.0158C4.14456 1.48867 5.07206 1.20731 6.02086 1.20731C7.29317 1.20731 8.51338 1.71274 9.41304 2.6124C10.3127 3.51206 10.8181 4.73226 10.8181 6.00457C10.8181 6.95337 10.5368 7.88088 10.0096 8.66978C9.48251 9.45868 8.73328 10.0736 7.85669 10.4367C6.98011 10.7997 6.01554 10.8947 5.08496 10.7096C4.15439 10.5245 3.2996 10.0676 2.62869 9.39674C1.95778 8.72583 1.50089 7.87104 1.31579 6.94046C1.13068 6.00989 1.22568 5.04532 1.58878 4.16874C1.95187 3.29215 2.56675 2.54292 3.35565 2.0158Z",
      fill: "currentColor"
    }));
  }));
  SearchIcon.displayName = 'SearchIcon';

  var BlankIcon = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var pti = IconBase.getPTI(inProps);
    return /*#__PURE__*/React__namespace.createElement("svg", _extends({
      ref: ref,
      width: "14",
      height: "14",
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, pti), /*#__PURE__*/React__namespace.createElement("rect", {
      width: "1",
      height: "1",
      fill: "currentColor",
      fillOpacity: "0"
    }));
  }));
  BlankIcon.displayName = 'BlankIcon';

  var DropdownItem = /*#__PURE__*/React__namespace.memo(function (props) {
    var mergeProps = useMergeProps();
    var ptm = props.ptm,
      cx = props.cx,
      selected = props.selected,
      disabled = props.disabled,
      option = props.option,
      label = props.label,
      index = props.index,
      focusedOptionIndex = props.focusedOptionIndex,
      ariaSetSize = props.ariaSetSize,
      checkmark = props.checkmark,
      highlightOnSelect = props.highlightOnSelect,
      onInputKeyDown = props.onInputKeyDown;
    var getPTOptions = function getPTOptions(key) {
      return ptm(key, {
        context: {
          selected: selected,
          disabled: disabled,
          focused: index === focusedOptionIndex
        }
      });
    };
    var _onClick = function onClick(event, i) {
      if (props.onClick) {
        props.onClick({
          originalEvent: event,
          option: option
        });
      }
    };
    var content = props.template ? ObjectUtils.getJSXElement(props.template, props.option) : props.label;
    var itemProps = mergeProps({
      id: "dropdownItem_".concat(index),
      role: 'option',
      className: classNames(option.className, cx('item', {
        selected: selected,
        disabled: disabled,
        label: label,
        index: index,
        focusedOptionIndex: focusedOptionIndex,
        highlightOnSelect: highlightOnSelect
      })),
      style: props.style,
      tabIndex: 0,
      onClick: function onClick(e) {
        return _onClick(e);
      },
      onKeyDown: function onKeyDown(e) {
        return onInputKeyDown(e);
      },
      onMouseMove: function onMouseMove(e) {
        return props === null || props === void 0 ? void 0 : props.onMouseMove(e, index);
      },
      'aria-setsize': ariaSetSize,
      'aria-posinset': index + 1,
      'aria-label': label,
      'aria-selected': selected,
      'data-p-highlight': selected,
      'data-p-focused': focusedOptionIndex === index,
      'data-p-disabled': disabled
    }, getPTOptions('item'));
    var itemGroupLabelProps = mergeProps({
      className: cx('itemLabel')
    }, getPTOptions('itemLabel'));
    var iconRenderer = function iconRenderer() {
      if (selected) {
        var checkIconProps = mergeProps({
          className: cx('checkIcon')
        }, getPTOptions('checkIcon'));
        return /*#__PURE__*/React__namespace.createElement(CheckIcon, checkIconProps);
      }
      var blankIconProps = mergeProps({
        className: cx('blankIcon')
      }, getPTOptions('blankIcon'));
      return /*#__PURE__*/React__namespace.createElement(BlankIcon, blankIconProps);
    };
    return /*#__PURE__*/React__namespace.createElement("li", _extends({
      key: props.label
    }, itemProps), checkmark && iconRenderer(), /*#__PURE__*/React__namespace.createElement("span", itemGroupLabelProps, content), /*#__PURE__*/React__namespace.createElement(Ripple, null));
  });
  DropdownItem.displayName = 'DropdownItem';

  function ownKeys$1o(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1o(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1o(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1o(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var DropdownPanel = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (props, ref) {
    var mergeProps = useMergeProps();
    var ptm = props.ptm,
      cx = props.cx,
      sx = props.sx;
    var context = React__namespace.useContext(PrimeReactContext);
    var filterInputRef = React__namespace.useRef(null);
    var isEmptyFilter = !(props.visibleOptions && props.visibleOptions.length) && props.hasFilter;
    var ariaSetSize = props.visibleOptions ? props.visibleOptions.length : 0;
    var filterOptions = {
      filter: function filter(e) {
        return onFilterInputChange(e);
      },
      reset: function reset() {
        return props.resetFilter();
      }
    };
    var getPTOptions = function getPTOptions(key, options) {
      return ptm(key, _objectSpread$1o({
        hostName: props.hostName
      }, options));
    };
    var onEnter = function onEnter() {
      props.onEnter(function () {
        if (props.virtualScrollerRef.current) {
          var selectedIndex = props.getSelectedOptionIndex();
          if (selectedIndex !== -1) {
            setTimeout(function () {
              return props.virtualScrollerRef.current.scrollToIndex(selectedIndex);
            }, 0);
          }
        }
      });
    };
    var onEntered = function onEntered() {
      props.onEntered(function () {
        if (props.filter && props.filterInputAutoFocus) {
          DomHandler.focus(filterInputRef.current, false);
        }
      });
    };
    var onFilterInputChange = function onFilterInputChange(event) {
      props.onFilterInputChange && props.onFilterInputChange(event);
    };
    var createFooter = function createFooter() {
      if (props.panelFooterTemplate) {
        var content = ObjectUtils.getJSXElement(props.panelFooterTemplate, props, props.onOverlayHide);
        var footerProps = mergeProps({
          className: cx('footer')
        }, getPTOptions('footer'));
        return /*#__PURE__*/React__namespace.createElement("div", footerProps, content);
      }
      return null;
    };
    var changeFocusedItemOnHover = function changeFocusedItemOnHover(event, index) {
      if (props.focusOnHover) {
        var _props$changeFocusedO;
        props === null || props === void 0 || (_props$changeFocusedO = props.changeFocusedOptionIndex) === null || _props$changeFocusedO === void 0 || _props$changeFocusedO.call(props, event, index);
      }
    };
    var createEmptyMessage = function createEmptyMessage(emptyMessage, isFilter) {
      var message = ObjectUtils.getJSXElement(emptyMessage, props) || localeOption(isFilter ? 'emptyFilterMessage' : 'emptyMessage');
      var emptyMessageProps = mergeProps({
        className: cx('emptyMessage')
      }, getPTOptions('emptyMessage'));
      return /*#__PURE__*/React__namespace.createElement("li", emptyMessageProps, message);
    };
    var createItem = function createItem(option, index) {
      var scrollerOptions = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
      var style = {
        height: scrollerOptions.props ? scrollerOptions.props.itemSize : undefined
      };
      style = _objectSpread$1o(_objectSpread$1o({}, style), option.style);
      if (option.group && props.optionGroupLabel) {
        var optionGroupLabel = props.optionGroupLabel;
        var groupContent = props.optionGroupTemplate ? ObjectUtils.getJSXElement(props.optionGroupTemplate, option, index) : props.getOptionGroupLabel(option);
        var key = index + '_' + props.getOptionGroupRenderKey(option);
        var itemGroupProps = mergeProps({
          className: cx('itemGroup', {
            optionGroupLabel: optionGroupLabel
          }),
          style: style,
          'data-p-highlight': props.selected
        }, getPTOptions('itemGroup'));
        var itemGroupLabelProps = mergeProps({
          className: cx('itemGroupLabel')
        }, getPTOptions('itemGroupLabel'));
        return /*#__PURE__*/React__namespace.createElement("li", _extends({
          key: key
        }, itemGroupProps), /*#__PURE__*/React__namespace.createElement("span", itemGroupLabelProps, groupContent));
      }
      var optionKey = props.getOptionRenderKey(option) + '_' + index;
      var optionLabel = props.getOptionLabel(option);
      var disabled = props.isOptionDisabled(option);
      return /*#__PURE__*/React__namespace.createElement(DropdownItem, {
        key: optionKey,
        label: optionLabel,
        index: index,
        focusedOptionIndex: props.focusedOptionIndex,
        option: option,
        ariaSetSize: ariaSetSize,
        onInputKeyDown: props.onInputKeyDown,
        style: style,
        template: props.itemTemplate,
        selected: props.isSelected(option),
        highlightOnSelect: props.highlightOnSelect,
        disabled: disabled,
        onClick: props.onOptionClick,
        onMouseMove: changeFocusedItemOnHover,
        ptm: ptm,
        cx: cx,
        checkmark: props.checkmark
      });
    };
    var createItems = function createItems() {
      if (ObjectUtils.isNotEmpty(props.visibleOptions)) {
        return props.visibleOptions.map(createItem);
      } else if (props.hasFilter) {
        return createEmptyMessage(props.emptyFilterMessage, true);
      }
      return createEmptyMessage(props.emptyMessage);
    };
    var createFilterClearIcon = function createFilterClearIcon() {
      if (props.showFilterClear && props.filterValue) {
        var ariaLabelFilterClear = localeOption('clear');
        var clearIconProps = mergeProps({
          className: cx('filterClearIcon'),
          'aria-label': ariaLabelFilterClear,
          onClick: function onClick() {
            return props.onFilterClearIconClick(function () {
              return DomHandler.focus(filterInputRef.current);
            });
          }
        }, getPTOptions('filterClearIcon'));
        var icon = props.filterClearIcon || /*#__PURE__*/React__namespace.createElement(TimesIcon, clearIconProps);
        var filterClearIcon = IconUtils.getJSXIcon(icon, _objectSpread$1o({}, clearIconProps), {
          props: props
        });
        return filterClearIcon;
      }
      return null;
    };
    var createFilter = function createFilter() {
      if (props.filter) {
        var clearIcon = createFilterClearIcon();
        var filterIconProps = mergeProps({
          className: cx('filterIcon')
        }, getPTOptions('filterIcon'));
        var icon = props.filterIcon || /*#__PURE__*/React__namespace.createElement(SearchIcon, filterIconProps);
        var filterIcon = IconUtils.getJSXIcon(icon, _objectSpread$1o({}, filterIconProps), {
          props: props
        });
        var filterContainerProps = mergeProps({
          className: cx('filterContainer', {
            clearIcon: clearIcon
          })
        }, getPTOptions('filterContainer'));
        var filterInputProps = mergeProps({
          ref: filterInputRef,
          type: 'text',
          autoComplete: 'off',
          className: cx('filterInput', {
            context: context
          }),
          placeholder: props.filterPlaceholder,
          onKeyDown: props.onFilterInputKeyDown,
          onChange: function onChange(e) {
            return onFilterInputChange(e);
          },
          value: props.filterValue
        }, getPTOptions('filterInput'));
        var content = /*#__PURE__*/React__namespace.createElement("div", filterContainerProps, /*#__PURE__*/React__namespace.createElement("input", filterInputProps), clearIcon, filterIcon);
        if (props.filterTemplate) {
          var defaultContentOptions = {
            className: classNames('p-dropdown-filter-container', {
              'p-dropdown-clearable-filter': !!clearIcon
            }),
            element: content,
            filterOptions: filterOptions,
            filterInputKeyDown: props.onFilterInputKeyDown,
            filterInputChange: onFilterInputChange,
            filterIconClassName: 'p-dropdown-filter-icon',
            clearIcon: clearIcon,
            props: props
          };
          content = ObjectUtils.getJSXElement(props.filterTemplate, defaultContentOptions);
        }
        var headerProps = mergeProps({
          className: cx('header')
        }, getPTOptions('header'));
        return /*#__PURE__*/React__namespace.createElement("div", headerProps, content);
      }
      return null;
    };
    var createContent = function createContent() {
      if (props.virtualScrollerOptions) {
        var virtualScrollerProps = _objectSpread$1o(_objectSpread$1o({}, props.virtualScrollerOptions), {
          style: _objectSpread$1o(_objectSpread$1o({}, props.virtualScrollerOptions.style), {
            height: props.scrollHeight
          }),
          className: classNames('p-dropdown-items-wrapper', props.virtualScrollerOptions.className),
          items: props.visibleOptions,
          autoSize: true,
          onLazyLoad: function onLazyLoad(event) {
            return props.virtualScrollerOptions.onLazyLoad(_objectSpread$1o(_objectSpread$1o({}, event), {
              filter: props.filterValue
            }));
          },
          itemTemplate: function itemTemplate(item, options) {
            return item && createItem(item, options.index, options);
          },
          contentTemplate: function contentTemplate(options) {
            var emptyMessage = props.hasFilter ? props.emptyFilterMessage : props.emptyMessage;
            var content = isEmptyFilter ? createEmptyMessage(emptyMessage) : options.children;
            var listProps = mergeProps({
              ref: options.contentRef,
              style: options.style,
              className: classNames(options.className, cx('list', {
                virtualScrollerProps: props.virtualScrollerOptions
              })),
              role: 'listbox',
              'aria-label': ariaLabel('listLabel')
            }, getPTOptions('list'));
            return /*#__PURE__*/React__namespace.createElement("ul", listProps, content);
          }
        });
        return /*#__PURE__*/React__namespace.createElement(VirtualScroller, _extends({
          ref: props.virtualScrollerRef
        }, virtualScrollerProps, {
          pt: ptm('virtualScroller')
        }));
      }
      var items = createItems();
      var wrapperProps = mergeProps({
        className: cx('wrapper'),
        style: sx('wrapper')
      }, getPTOptions('wrapper'));
      var listProps = mergeProps({
        className: cx('list'),
        role: 'listbox',
        'aria-label': ariaLabel('listLabel')
      }, getPTOptions('list'));
      return /*#__PURE__*/React__namespace.createElement("div", wrapperProps, /*#__PURE__*/React__namespace.createElement("ul", listProps, items));
    };
    var createElement = function createElement() {
      var filter = createFilter();
      var content = createContent();
      var footer = createFooter();
      var panelProps = mergeProps({
        className: classNames(props.panelClassName, cx('panel', {
          context: context
        })),
        style: sx('panel'),
        onClick: props.onClick
      }, getPTOptions('panel'));
      var transitionProps = mergeProps({
        classNames: cx('transition'),
        "in": props["in"],
        timeout: {
          enter: 120,
          exit: 100
        },
        options: props.transitionOptions,
        unmountOnExit: true,
        onEnter: onEnter,
        onEntered: onEntered,
        onExit: props.onExit,
        onExited: props.onExited
      }, getPTOptions('transition'));
      return /*#__PURE__*/React__namespace.createElement(CSSTransition, _extends({
        nodeRef: ref
      }, transitionProps), /*#__PURE__*/React__namespace.createElement("div", _extends({
        ref: ref
      }, panelProps), props.firstFocusableElement, filter, content, footer, props.lastFocusableElement));
    };
    var element = createElement();
    return /*#__PURE__*/React__namespace.createElement(Portal, {
      element: element,
      appendTo: props.appendTo
    });
  }));
  DropdownPanel.displayName = 'DropdownPanel';

  function _createForOfIteratorHelper$c(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray$c(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t["return"] || t["return"](); } finally { if (u) throw o; } } }; }
  function _unsupportedIterableToArray$c(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray$c(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray$c(r, a) : void 0; } }
  function _arrayLikeToArray$c(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
  function ownKeys$1n(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1n(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1n(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1n(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var Dropdown = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var mergeProps = useMergeProps();
    var context = React__namespace.useContext(PrimeReactContext);
    var props = DropdownBase.getProps(inProps, context);
    var _useDebounce = useDebounce('', props.filterDelay || 0),
      _useDebounce2 = _slicedToArray(_useDebounce, 3),
      filterValue = _useDebounce2[0],
      filterState = _useDebounce2[1],
      setFilterState = _useDebounce2[2];
    var _React$useState = React__namespace.useState(false),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      focusedState = _React$useState2[0],
      setFocusedState = _React$useState2[1];
    var _React$useState3 = React__namespace.useState(-1),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      focusedOptionIndex = _React$useState4[0],
      setFocusedOptionIndex = _React$useState4[1];
    var _React$useState5 = React__namespace.useState(false),
      _React$useState6 = _slicedToArray(_React$useState5, 2),
      overlayVisibleState = _React$useState6[0],
      setOverlayVisibleState = _React$useState6[1];
    var clickedRef = React__namespace.useRef(false);
    var elementRef = React__namespace.useRef(null);
    var overlayRef = React__namespace.useRef(null);
    var firstHiddenFocusableElementOnOverlay = React__namespace.useRef(null);
    var lastHiddenFocusableElementOnOverlay = React__namespace.useRef(null);
    var inputRef = React__namespace.useRef(props.inputRef);
    var focusInputRef = React__namespace.useRef(props.focusInputRef);
    var virtualScrollerRef = React__namespace.useRef(null);
    var searchTimeout = React__namespace.useRef(null);
    var searchValue = React__namespace.useRef(null);
    var isLazy = props.virtualScrollerOptions && props.virtualScrollerOptions.lazy;
    var hasFilter = ObjectUtils.isNotEmpty(filterState);
    var appendTo = props.appendTo || context && context.appendTo || PrimeReact.appendTo;
    var _DropdownBase$setMeta = DropdownBase.setMetaData(_objectSpread$1n(_objectSpread$1n({
        props: props
      }, props.__parentMetadata), {}, {
        state: {
          filter: filterState,
          focused: focusedState,
          overlayVisible: overlayVisibleState
        }
      })),
      ptm = _DropdownBase$setMeta.ptm,
      cx = _DropdownBase$setMeta.cx,
      sx = _DropdownBase$setMeta.sx,
      isUnstyled = _DropdownBase$setMeta.isUnstyled;
    useHandleStyle(DropdownBase.css.styles, isUnstyled, {
      name: 'dropdown'
    });
    var _useOverlayListener = useOverlayListener({
        target: elementRef,
        overlay: overlayRef,
        listener: function listener(event, _ref) {
          var type = _ref.type,
            valid = _ref.valid;
          if (valid) {
            if (type === 'outside') {
              if (!isClearClicked(event)) {
                hide();
              }
            } else if (context.hideOverlaysOnDocumentScrolling) {
              hide();
            } else if (!DomHandler.isDocument(event.target)) {
              alignOverlay();
            }
          }
        },
        when: overlayVisibleState
      }),
      _useOverlayListener2 = _slicedToArray(_useOverlayListener, 2),
      bindOverlayListener = _useOverlayListener2[0],
      unbindOverlayListener = _useOverlayListener2[1];
    var flatOptions = function flatOptions(options) {
      return (options || []).reduce(function (result, option, index) {
        result.push(_objectSpread$1n(_objectSpread$1n({}, option), {}, {
          group: true,
          index: index
        }));
        var optionGroupChildren = getOptionGroupChildren(option);
        optionGroupChildren && optionGroupChildren.forEach(function (o) {
          return result.push(o);
        });
        return result;
      }, []);
    };
    var getVisibleOptions = function getVisibleOptions() {
      var options = props.optionGroupLabel ? flatOptions(props.options) : props.options;
      if (hasFilter && !isLazy) {
        var _filterValue = filterState.trim().toLocaleLowerCase(props.filterLocale);
        var searchFields = props.filterBy ? props.filterBy.split(',') : [props.optionLabel || 'label'];
        if (props.optionGroupLabel) {
          var filteredGroups = [];
          var _iterator = _createForOfIteratorHelper$c(props.options),
            _step;
          try {
            for (_iterator.s(); !(_step = _iterator.n()).done;) {
              var optgroup = _step.value;
              var filteredSubOptions = FilterService.filter(getOptionGroupChildren(optgroup), searchFields, _filterValue, props.filterMatchMode, props.filterLocale);
              if (filteredSubOptions && filteredSubOptions.length) {
                filteredGroups.push(_objectSpread$1n(_objectSpread$1n({}, optgroup), _defineProperty({}, "".concat(props.optionGroupChildren), filteredSubOptions)));
              }
            }
          } catch (err) {
            _iterator.e(err);
          } finally {
            _iterator.f();
          }
          return flatOptions(filteredGroups);
        }
        return FilterService.filter(options, searchFields, _filterValue, props.filterMatchMode, props.filterLocale);
      }
      return options;
    };
    var onFirstHiddenFocus = function onFirstHiddenFocus(event) {
      var focusableEl = event.relatedTarget === focusInputRef.current ? DomHandler.getFirstFocusableElement(overlayRef.current, ':not([data-p-hidden-focusable="true"])') : focusInputRef.current;
      DomHandler.focus(focusableEl);
    };
    var onLastHiddenFocus = function onLastHiddenFocus(event) {
      var focusableEl = event.relatedTarget === focusInputRef.current ? DomHandler.getLastFocusableElement(overlayRef.current, ':not([data-p-hidden-focusable="true"])') : focusInputRef.current;
      DomHandler.focus(focusableEl);
    };
    var isClearClicked = function isClearClicked(event) {
      return DomHandler.isAttributeEquals(event.target, 'data-pc-section', 'clearicon') || DomHandler.isAttributeEquals(event.target.parentElement || event.target, 'data-pc-section', 'filterclearicon');
    };
    var _onClick = function onClick(event) {
      if (props.disabled || props.loading) {
        return;
      }
      props.onClick && props.onClick(event);

      // do not continue if the user defined click wants to prevent it
      if (event.defaultPrevented) {
        return;
      }
      if (isClearClicked(event) || event.target.tagName === 'INPUT') {
        return;
      } else if (!overlayRef.current || !(overlayRef.current && overlayRef.current.contains(event.target))) {
        DomHandler.focus(focusInputRef.current);
        overlayVisibleState ? hide() : show();
      }
      event.preventDefault();
      clickedRef.current = true;
    };
    var onInputFocus = function onInputFocus(event) {
      if (props.showOnFocus && !overlayVisibleState) {
        show();
      }
      setFocusedState(true);
      props.onFocus && props.onFocus(event);
    };
    var onInputBlur = function onInputBlur(event) {
      setFocusedState(false);
      if (props.onBlur) {
        setTimeout(function () {
          var currentValue = inputRef.current ? inputRef.current.value : undefined;
          props.onBlur({
            originalEvent: event.originalEvent,
            value: currentValue,
            stopPropagation: function stopPropagation() {
              event.originalEvent.stopPropagation();
            },
            preventDefault: function preventDefault() {
              event.originalEvent.preventDefault();
            },
            target: {
              name: props.name,
              id: props.id,
              value: currentValue
            }
          });
        }, 200);
      }
    };
    var onOptionSelect = function onOptionSelect(event, option) {
      var isHide = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
      selectItem({
        originalEvent: event,
        option: option
      });
      if (isHide) {
        hide();
        DomHandler.focus(focusInputRef.current);
      }
    };
    var onPanelClick = function onPanelClick(event) {
      OverlayService.emit('overlay-click', {
        originalEvent: event,
        target: elementRef.current
      });
    };
    var onInputKeyDown = function onInputKeyDown(event) {
      if (props.disabled) {
        event.preventDefault();
        return;
      }
      var code = DomHandler.isAndroid() ? event.key : event.code;
      switch (code) {
        case 'ArrowDown':
          onArrowDownKey(event);
          break;
        case 'ArrowUp':
          onArrowUpKey(event);
          break;
        case 'ArrowLeft':
        case 'ArrowRight':
          onArrowLeftKey(event, props.editable);
          break;
        case 'Home':
          onHomeKey(event);
          break;
        case 'End':
          onEndKey(event);
          break;
        case 'PageDown':
          onPageDownKey(event);
          break;
        case 'PageUp':
          onPageUpKey(event);
          break;
        case 'Space':
          onSpaceKey(event, props.editable);
          break;
        case 'NumpadEnter':
        case 'Enter':
          onEnterKey(event);
          break;
        case 'Escape':
          onEscapeKey(event);
          break;
        case 'Tab':
          onTabKey(event);
          break;
        case 'Backspace':
          onBackspaceKey(event, props.editable);
          break;
        case 'ShiftLeft':
        case 'ShiftRight':
          //NOOP
          break;
        default:
          var metaKey = event.metaKey || event.ctrlKey || event.altKey;

          // Only handle printable characters when no meta keys are pressed
          if (!metaKey && ObjectUtils.isPrintableCharacter(event.key)) {
            !overlayVisibleState && !props.editable && show();
            !props.editable && searchOptions(event, event.key);
          }
          break;
      }
      clickedRef.current = false;
    };
    var onFilterInputKeyDown = function onFilterInputKeyDown(event) {
      switch (event.code) {
        case 'ArrowDown':
          onArrowDownKey(event);
          break;
        case 'ArrowUp':
          onArrowUpKey(event);
          break;
        case 'ArrowLeft':
        case 'ArrowRight':
          onArrowLeftKey(event, true);
          break;
        case 'Enter':
        case 'NumpadEnter':
          onEnterKey(event);
          event.preventDefault();
          break;
        case 'Escape':
          onEscapeKey(event);
          break;
      }
    };
    var hasFocusableElements = function hasFocusableElements() {
      return DomHandler.getFocusableElements(overlayRef.current, ':not([data-p-hidden-focusable="true"])').length > 0;
    };
    var isOptionMatched = function isOptionMatched(option) {
      var _getOptionLabel;
      return isValidOption(option) && ((_getOptionLabel = getOptionLabel(option)) === null || _getOptionLabel === void 0 ? void 0 : _getOptionLabel.toLocaleLowerCase(props.filterLocale).startsWith(searchValue.current.toLocaleLowerCase(props.filterLocale)));
    };
    var isValidOption = function isValidOption(option) {
      return ObjectUtils.isNotEmpty(option) && !(isOptionDisabled(option) || isOptionGroup(option));
    };
    var hasSelectedOption = function hasSelectedOption() {
      return ObjectUtils.isNotEmpty(props.value);
    };
    var isValidSelectedOption = function isValidSelectedOption(option) {
      return isValidOption(option) && isSelected(option);
    };
    var findSelectedOptionIndex = function findSelectedOptionIndex() {
      return hasSelectedOption ? visibleOptions.findIndex(function (option) {
        return isValidSelectedOption(option);
      }) : -1;
    };
    var findFirstFocusedOptionIndex = function findFirstFocusedOptionIndex() {
      var selectedIndex = findSelectedOptionIndex();
      return selectedIndex < 0 ? findFirstOptionIndex() : selectedIndex;
    };
    var searchOptions = function searchOptions(event, _char) {
      searchValue.current = (searchValue.current || '') + _char;
      var optionIndex = -1;
      var matched = false;
      if (ObjectUtils.isNotEmpty(searchValue.current)) {
        if (focusedOptionIndex !== -1) {
          optionIndex = visibleOptions.slice(focusedOptionIndex).findIndex(function (option) {
            return isOptionMatched(option);
          });
          optionIndex = optionIndex === -1 ? visibleOptions.slice(0, focusedOptionIndex).findIndex(function (option) {
            return isOptionMatched(option);
          }) : optionIndex + focusedOptionIndex;
        } else {
          optionIndex = visibleOptions.findIndex(function (option) {
            return isOptionMatched(option);
          });
        }
        if (optionIndex !== -1) {
          matched = true;
        }
        if (optionIndex === -1 && focusedOptionIndex === -1) {
          optionIndex = findFirstFocusedOptionIndex();
        }
        if (optionIndex !== -1) {
          changeFocusedOptionIndex(event, optionIndex);
        }
      }
      if (searchTimeout.current) {
        clearTimeout(searchTimeout.current);
      }
      searchTimeout.current = setTimeout(function () {
        searchValue.current = '';
        searchTimeout.current = null;
      }, 500);
      return matched;
    };
    var findLastFocusedOptionIndex = function findLastFocusedOptionIndex() {
      var selectedIndex = findSelectedOptionIndex();
      return selectedIndex < 0 ? findLastOptionIndex() : selectedIndex;
    };
    var findFirstOptionIndex = function findFirstOptionIndex() {
      return visibleOptions.findIndex(function (option) {
        return isValidOption(option);
      });
    };
    var findLastOptionIndex = function findLastOptionIndex() {
      return ObjectUtils.findLastIndex(visibleOptions, function (option) {
        return isValidOption(option);
      });
    };
    var findNextOptionIndex = function findNextOptionIndex(index) {
      var matchedOptionIndex = index < visibleOptions.length - 1 ? visibleOptions.slice(index + 1).findIndex(function (option) {
        return isValidOption(option);
      }) : -1;
      return matchedOptionIndex > -1 ? matchedOptionIndex + index + 1 : index;
    };
    var findPrevOptionIndex = function findPrevOptionIndex(index) {
      var matchedOptionIndex = index > 0 ? ObjectUtils.findLastIndex(visibleOptions.slice(0, index), function (option) {
        return isValidOption(option);
      }) : -1;
      return matchedOptionIndex > -1 ? matchedOptionIndex : index;
    };
    var changeFocusedOptionIndex = function changeFocusedOptionIndex(event, index) {
      if (focusedOptionIndex !== index) {
        setFocusedOptionIndex(index);
        focusOnItem(index);
        if (props.selectOnFocus) {
          onOptionSelect(event, visibleOptions[index], false);
        }
      }
    };
    var focusOnItem = function focusOnItem(index) {
      var focusedItem = DomHandler.findSingle(overlayRef.current, "li[id=\"dropdownItem_".concat(index, "\"]"));
      focusedItem && focusedItem.focus();
    };
    var onArrowDownKey = function onArrowDownKey(event) {
      if (!overlayVisibleState) {
        show();
        props.editable && changeFocusedOptionIndex(event, findSelectedOptionIndex());
      } else {
        var optionIndex = focusedOptionIndex !== -1 ? findNextOptionIndex(focusedOptionIndex) : clickedRef.current ? findFirstOptionIndex() : findFirstFocusedOptionIndex();
        changeFocusedOptionIndex(event, optionIndex);
      }
      event.preventDefault();
    };
    var onArrowUpKey = function onArrowUpKey(event) {
      var pressedInInputText = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      if (event.altKey && !pressedInInputText) {
        if (focusedOptionIndex !== -1) {
          onOptionSelect(event, visibleOptions[focusedOptionIndex]);
        }
        state.overlayVisible && hide();
        event.preventDefault();
      } else {
        var optionIndex = focusedOptionIndex !== -1 ? findPrevOptionIndex(focusedOptionIndex) : clickedRef.current ? findLastOptionIndex() : findLastFocusedOptionIndex();
        changeFocusedOptionIndex(event, optionIndex);
        !overlayVisibleState && show();
        event.preventDefault();
      }
    };
    var onArrowLeftKey = function onArrowLeftKey(event) {
      var pressedInInputText = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      pressedInInputText && setFocusedOptionIndex(-1);
    };
    var onHomeKey = function onHomeKey(event) {
      var pressedInInputText = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      if (pressedInInputText) {
        event.currentTarget.setSelectionRange(0, 0);
        setFocusedOptionIndex(-1);
      } else {
        changeFocusedOptionIndex(event, findFirstOptionIndex());
        !overlayVisibleState && show();
      }
      event.preventDefault();
    };
    var onEndKey = function onEndKey(event) {
      var pressedInInputText = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      if (pressedInInputText) {
        var target = event.currentTarget;
        var len = target.value.length;
        target.setSelectionRange(len, len);
        setFocusedOptionIndex(-1);
      } else {
        changeFocusedOptionIndex(event, findLastOptionIndex());
        !overlayVisibleState && show();
      }
      event.preventDefault();
    };
    var onPageUpKey = function onPageUpKey(event) {
      event.preventDefault();
    };
    var onPageDownKey = function onPageDownKey(event) {
      event.preventDefault();
    };
    var onSpaceKey = function onSpaceKey(event) {
      var pressedInInputText = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      !pressedInInputText && onEnterKey(event);
    };
    var onEnterKey = function onEnterKey(event) {
      event.preventDefault();
      if (!overlayVisibleState) {
        setFocusedOptionIndex(-1);
        onArrowDownKey(event);
      } else {
        if (focusedOptionIndex === -1) {
          return;
        }
        var focusedOption = visibleOptions[focusedOptionIndex];
        var optionValue = getOptionValue(focusedOption);
        if (optionValue == null || optionValue == undefined) {
          hide();
          resetFilter();
          updateEditableLabel(selectedOption);
          return;
        }
        onOptionSelect(event, focusedOption);
      }
    };
    var onEscapeKey = function onEscapeKey(event) {
      overlayVisibleState && hide();
      event.preventDefault();
    };
    var onTabKey = function onTabKey(event) {
      var pressedInInputText = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      if (!pressedInInputText) {
        if (overlayVisibleState && !hasFocusableElements()) {
          DomHandler.focus(firstHiddenFocusableElementOnOverlay.current);
          event.preventDefault();
        } else {
          if (focusedOptionIndex !== -1) {
            onOptionSelect(event, visibleOptions[focusedOptionIndex]);
          }
          overlayVisibleState && hide();
        }
      }
    };
    var onBackspaceKey = function onBackspaceKey(event) {
      var pressedInInputText = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      if (event && pressedInInputText) {
        !overlayVisibleState && show();
      }
    };
    var findInArray = function findInArray(visibleOptions, searchText) {
      if (!searchText || !(visibleOptions !== null && visibleOptions !== void 0 && visibleOptions.length)) return -1;
      var normalizedSearch = searchText.toLocaleLowerCase();
      var exactMatch = visibleOptions.findIndex(function (item) {
        return getOptionLabel(item).toLocaleLowerCase() === normalizedSearch;
      });
      if (exactMatch !== -1) return exactMatch;
      return visibleOptions.findIndex(function (item) {
        return getOptionLabel(item).toLocaleLowerCase().startsWith(normalizedSearch);
      });
    };
    var onEditableInputChange = function onEditableInputChange(event) {
      !overlayVisibleState && show();
      var searchIndex = null;
      if (event.target.value && visibleOptions) {
        searchIndex = findInArray(visibleOptions, event.target.value);
      }
      setFocusedOptionIndex(searchIndex);
      if (props.onChange) {
        props.onChange({
          originalEvent: event.originalEvent,
          value: event.target.value,
          stopPropagation: function stopPropagation() {
            event.originalEvent.stopPropagation();
          },
          preventDefault: function preventDefault() {
            event.originalEvent.preventDefault();
          },
          target: {
            name: props.name,
            id: props.id,
            value: event.target.value
          }
        });
      }
    };
    var onEditableInputFocus = function onEditableInputFocus(event) {
      setFocusedState(true);
      hide();
      props.onFocus && props.onFocus(event);
    };
    var onOptionClick = function onOptionClick(event) {
      var option = event.option;
      if (!option.disabled) {
        selectItem(event);
        DomHandler.focus(focusInputRef.current);
      }
      hide();
    };
    var onFilterInputChange = function onFilterInputChange(event) {
      var filter = event.target.value;
      setFilterState(filter);
      if (props.onFilter) {
        props.onFilter({
          originalEvent: event,
          filter: filter
        });
      }
    };
    var onFilterClearIconClick = function onFilterClearIconClick(callback) {
      resetFilter(callback);
    };
    var resetFilter = function resetFilter(callback) {
      setFilterState('');
      props.onFilter && props.onFilter({
        filter: ''
      });
      callback && callback();
    };
    var clear = function clear(event) {
      if (props.onChange) {
        props.onChange({
          originalEvent: event,
          value: undefined,
          stopPropagation: function stopPropagation() {
            event === null || event === void 0 || event.stopPropagation();
          },
          preventDefault: function preventDefault() {
            event === null || event === void 0 || event.preventDefault();
          },
          target: {
            name: props.name,
            id: props.id,
            value: undefined
          }
        });
      }
      if (props.filter) {
        resetFilter();
      }
      updateEditableLabel();
      setFocusedOptionIndex(-1);
    };
    var selectItem = function selectItem(event) {
      if (selectedOption !== event.option) {
        updateEditableLabel(event.option);
        setFocusedOptionIndex(-1);
        var optionValue = getOptionValue(event.option);
        var selectedOptionIndex = findOptionIndexInList(event.option, visibleOptions);
        if (props.onChange) {
          props.onChange({
            originalEvent: event.originalEvent,
            value: optionValue,
            stopPropagation: function stopPropagation() {
              event.originalEvent.stopPropagation();
            },
            preventDefault: function preventDefault() {
              event.originalEvent.preventDefault();
            },
            target: {
              name: props.name,
              id: props.id,
              value: optionValue
            }
          });
        }
        changeFocusedOptionIndex(event.originalEvent, selectedOptionIndex);
      }
    };
    var getSelectedOptionIndex = function getSelectedOptionIndex(options) {
      options = options || visibleOptions;
      if (options) {
        if (props.optionGroupLabel) {
          for (var i = 0; i < options.length; i++) {
            var selectedOptionIndex = findOptionIndexInList(props.value, getOptionGroupChildren(options[i]));
            if (selectedOptionIndex !== -1) {
              return {
                group: i,
                option: selectedOptionIndex
              };
            }
          }
        } else {
          return findOptionIndexInList(props.value, options);
        }
      }
      return -1;
    };
    var equalityKey = function equalityKey() {
      return props.optionValue ? null : props.dataKey;
    };
    var findOptionIndexInList = function findOptionIndexInList(value, list) {
      var key = equalityKey();
      return list.findIndex(function (item) {
        return ObjectUtils.equals(value, getOptionValue(item), key);
      });
    };
    var isSelected = function isSelected(option) {
      return ObjectUtils.equals(props.value, getOptionValue(option), equalityKey());
    };
    var show = function show() {
      setFocusedOptionIndex(focusedOptionIndex !== -1 ? focusedOptionIndex : props.autoOptionFocus ? findFirstFocusedOptionIndex() : props.editable ? -1 : findSelectedOptionIndex());
      setOverlayVisibleState(true);
    };
    var hide = function hide() {
      setOverlayVisibleState(false);
      clickedRef.current = false;
    };
    var onFocus = function onFocus() {
      if (props.editable && !overlayVisibleState && clickedRef.current === false) {
        DomHandler.focus(inputRef.current);
      }
    };
    var onOverlayEnter = function onOverlayEnter(callback) {
      ZIndexUtils.set('overlay', overlayRef.current, context && context.autoZIndex || PrimeReact.autoZIndex, context && context.zIndex.overlay || PrimeReact.zIndex.overlay);
      DomHandler.addStyles(overlayRef.current, {
        position: 'absolute',
        top: '0',
        left: '0'
      });
      alignOverlay();
      callback && callback();
    };
    var onOverlayEntered = function onOverlayEntered(callback) {
      callback && callback();
      bindOverlayListener();
      props.onShow && props.onShow();
    };
    var onOverlayExit = function onOverlayExit() {
      unbindOverlayListener();
    };
    var onOverlayExited = function onOverlayExited() {
      if (props.filter && props.resetFilterOnHide) {
        resetFilter();
      }
      ZIndexUtils.clear(overlayRef.current);
      props.onHide && props.onHide();
    };
    var alignOverlay = function alignOverlay() {
      DomHandler.alignOverlay(overlayRef.current, inputRef.current.parentElement, props.appendTo || context && context.appendTo || PrimeReact.appendTo);
    };
    var scrollInView = function scrollInView() {
      var focusedItem = DomHandler.findSingle(overlayRef.current, 'li[data-p-focused="true"]');
      if (focusedItem && focusedItem.scrollIntoView) {
        focusedItem.scrollIntoView({
          block: 'nearest',
          inline: 'nearest'
        });
      } else {
        var highlightItem = DomHandler.findSingle(overlayRef.current, 'li[data-p-highlight="true"]');
        if (highlightItem && highlightItem.scrollIntoView) {
          highlightItem.scrollIntoView({
            block: 'nearest',
            inline: 'nearest'
          });
        }
      }
    };
    var updateEditableLabel = function updateEditableLabel(option) {
      if (inputRef.current) {
        inputRef.current.value = option ? getOptionLabel(option) : props.value || '';

        // #1413 NVDA screenreader
        if (focusInputRef.current) {
          focusInputRef.current.value = inputRef.current.value;
        }
      }
    };
    var getOptionLabel = function getOptionLabel(option) {
      if (ObjectUtils.isScalar(option)) {
        return "".concat(option);
      }
      var optionLabel = props.optionLabel ? ObjectUtils.resolveFieldData(option, props.optionLabel) : option['label'];
      return "".concat(optionLabel);
    };
    var getOptionValue = function getOptionValue(option) {
      if (props.useOptionAsValue) {
        return option;
      }
      var optionValue = props.optionValue ? ObjectUtils.resolveFieldData(option, props.optionValue) : option ? option['value'] : ObjectUtils.resolveFieldData(option, 'value');
      return props.optionValue || ObjectUtils.isNotEmpty(optionValue) ? optionValue : option;
    };
    var getOptionRenderKey = function getOptionRenderKey(option) {
      return props.dataKey ? ObjectUtils.resolveFieldData(option, props.dataKey) : getOptionLabel(option);
    };
    var isOptionGroup = function isOptionGroup(option) {
      return props.optionGroupLabel && option.group;
    };
    var isOptionDisabled = function isOptionDisabled(option) {
      if (props.optionDisabled) {
        return ObjectUtils.isFunction(props.optionDisabled) ? props.optionDisabled(option) : ObjectUtils.resolveFieldData(option, props.optionDisabled);
      }
      return option && option.disabled !== undefined ? option.disabled : false;
    };
    var getOptionGroupRenderKey = function getOptionGroupRenderKey(optionGroup) {
      return ObjectUtils.resolveFieldData(optionGroup, props.optionGroupLabel);
    };
    var getOptionGroupLabel = function getOptionGroupLabel(optionGroup) {
      return ObjectUtils.resolveFieldData(optionGroup, props.optionGroupLabel);
    };
    var getOptionGroupChildren = function getOptionGroupChildren(optionGroup) {
      return ObjectUtils.resolveFieldData(optionGroup, props.optionGroupChildren);
    };
    var updateInputField = function updateInputField() {
      if (props.editable && inputRef.current) {
        var label = selectedOption ? getOptionLabel(selectedOption) : null;
        var value = label || props.value || '';
        inputRef.current.value = value;

        // #1413 NVDA screenreader
        if (focusInputRef.current) {
          focusInputRef.current.value = value;
        }
      }
    };
    var getSelectedOption = function getSelectedOption() {
      var index = getSelectedOptionIndex(props.options);
      return index !== -1 ? props.optionGroupLabel ? getOptionGroupChildren(props.options[index.group])[index.option] : props.options[index] : null;
    };
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        show: show,
        hide: hide,
        clear: clear,
        focus: function focus() {
          return DomHandler.focus(focusInputRef.current);
        },
        getElement: function getElement() {
          return elementRef.current;
        },
        getOverlay: function getOverlay() {
          return overlayRef.current;
        },
        getInput: function getInput() {
          return inputRef.current;
        },
        getFocusInput: function getFocusInput() {
          return focusInputRef.current;
        },
        getVirtualScroller: function getVirtualScroller() {
          return virtualScrollerRef.current;
        }
      };
    });
    React__namespace.useEffect(function () {
      ObjectUtils.combinedRefs(inputRef, props.inputRef);
      ObjectUtils.combinedRefs(focusInputRef, props.focusInputRef);
    }, [inputRef, props.inputRef, focusInputRef, props.focusInputRef]);
    useMountEffect(function () {
      if (props.autoFocus) {
        DomHandler.focus(focusInputRef.current, props.autoFocus);
      }
      alignOverlay();
    });
    useUpdateEffect(function () {
      if (overlayVisibleState && (props.value || focusedOptionIndex >= 0)) {
        scrollInView();
      }
    }, [overlayVisibleState, props.value, focusedOptionIndex]);
    useUpdateEffect(function () {
      if (overlayVisibleState && filterState && props.filter) {
        alignOverlay();
      }
    }, [overlayVisibleState, filterState, props.filter]);
    useUpdateEffect(function () {
      virtualScrollerRef.current && virtualScrollerRef.current.scrollInView(0);
    }, [filterState]);
    useUpdateEffect(function () {
      updateInputField();
      if (inputRef.current) {
        inputRef.current.selectedIndex = 1;
      }
    });
    useUnmountEffect(function () {
      ZIndexUtils.clear(overlayRef.current);
    });
    var createHiddenSelect = function createHiddenSelect() {
      var option = {
        value: '',
        label: props.placeholder
      };
      if (selectedOption) {
        var optionValue = getOptionValue(selectedOption);
        option = {
          value: _typeof(optionValue) === 'object' ? props.options.findIndex(function (o) {
            return o === optionValue;
          }) : optionValue,
          label: getOptionLabel(selectedOption)
        };
      }
      var hiddenSelectedMessageProps = mergeProps({
        className: 'p-hidden-accessible p-dropdown-hidden-select'
      }, ptm('hiddenSelectedMessage'));
      var selectProps = mergeProps({
        ref: inputRef,
        required: props.required,
        defaultValue: option.value,
        name: props.name,
        tabIndex: -1
      }, ptm('select'));
      var optionProps = mergeProps({
        value: option.value
      }, ptm('option'));
      return /*#__PURE__*/React__namespace.createElement("div", hiddenSelectedMessageProps, /*#__PURE__*/React__namespace.createElement("select", selectProps, /*#__PURE__*/React__namespace.createElement("option", optionProps, option.label)));
    };
    var createKeyboardHelper = function createKeyboardHelper() {
      var value = ObjectUtils.isNotEmpty(selectedOption) ? getOptionLabel(selectedOption) : null;
      if (props.editable) {
        value = value || props.value || '';
      }
      var hiddenSelectedMessageProps = mergeProps({
        className: 'p-hidden-accessible'
      }, ptm('hiddenSelectedMessage'));
      var inputProps = mergeProps(_objectSpread$1n({
        ref: focusInputRef,
        id: props.inputId,
        defaultValue: value,
        type: 'text',
        readOnly: true,
        'aria-haspopup': 'listbox',
        onFocus: onInputFocus,
        onBlur: onInputBlur,
        onKeyDown: onInputKeyDown,
        disabled: props.disabled,
        tabIndex: !props.disabled ? props.tabIndex || 0 : -1
      }, ariaProps), ptm('input'));
      return /*#__PURE__*/React__namespace.createElement("div", hiddenSelectedMessageProps, /*#__PURE__*/React__namespace.createElement("input", inputProps));
    };
    var createLabel = function createLabel() {
      var label = ObjectUtils.isNotEmpty(selectedOption) ? getOptionLabel(selectedOption) : null;
      if (props.editable) {
        var value = label || props.value || '';
        var _inputProps = mergeProps(_objectSpread$1n({
          ref: inputRef,
          type: 'text',
          defaultValue: value,
          className: cx('input', {
            label: label
          }),
          disabled: props.disabled,
          placeholder: props.placeholder,
          maxLength: props.maxLength,
          onInput: onEditableInputChange,
          onFocus: onEditableInputFocus,
          onKeyDown: onInputKeyDown,
          onBlur: onInputBlur,
          tabIndex: !props.disabled ? props.tabIndex || 0 : -1,
          'aria-haspopup': 'listbox'
        }, ariaProps), ptm('input'));
        return /*#__PURE__*/React__namespace.createElement("input", _inputProps);
      }
      var content = props.valueTemplate ? ObjectUtils.getJSXElement(props.valueTemplate, selectedOption, props) : label || props.placeholder || props.emptyMessage || /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, null, "\xA0");
      var inputProps = mergeProps({
        ref: inputRef,
        className: cx('input', {
          label: label
        }),
        tabIndex: '-1'
      }, ptm('input'));
      return /*#__PURE__*/React__namespace.createElement("span", inputProps, content);
    };
    var onClearIconKeyDown = function onClearIconKeyDown(event) {
      if (event.key === 'Enter' || event.code === 'Space') {
        clear(event);
        event.preventDefault();
      }
    };
    var createClearIcon = function createClearIcon() {
      if (props.value != null && props.showClear && !props.disabled && !ObjectUtils.isEmpty(props.options)) {
        var clearIconProps = mergeProps({
          className: cx('clearIcon'),
          onPointerUp: clear,
          tabIndex: props.editable ? -1 : props.tabIndex || '0',
          onKeyDown: onClearIconKeyDown,
          'aria-label': localeOption('clear')
        }, ptm('clearIcon'));
        var icon = props.clearIcon || /*#__PURE__*/React__namespace.createElement(TimesIcon, clearIconProps);
        return IconUtils.getJSXIcon(icon, _objectSpread$1n({}, clearIconProps), {
          props: props
        });
      }
      return null;
    };
    var createLoadingIcon = function createLoadingIcon() {
      var loadingIconProps = mergeProps({
        className: cx('loadingIcon'),
        'data-pr-overlay-visible': overlayVisibleState
      }, ptm('loadingIcon'));
      var icon = props.loadingIcon || /*#__PURE__*/React__namespace.createElement(SpinnerIcon, {
        spin: true
      });
      var loadingIcon = IconUtils.getJSXIcon(icon, _objectSpread$1n({}, loadingIconProps), {
        props: props
      });
      var ariaLabel = props.placeholder || props.ariaLabel;
      var loadingButtonProps = mergeProps({
        className: cx('trigger'),
        role: 'button',
        'aria-haspopup': 'listbox',
        'aria-expanded': overlayVisibleState,
        'aria-label': ariaLabel
      }, ptm('trigger'));
      return /*#__PURE__*/React__namespace.createElement("div", loadingButtonProps, loadingIcon);
    };
    var createDropdownIcon = function createDropdownIcon() {
      var dropdownIconProps = mergeProps({
        className: cx('dropdownIcon'),
        'data-pr-overlay-visible': overlayVisibleState
      }, ptm('dropdownIcon'));
      var icon = !overlayVisibleState ? props.dropdownIcon || /*#__PURE__*/React__namespace.createElement(ChevronDownIcon, dropdownIconProps) : props.collapseIcon || /*#__PURE__*/React__namespace.createElement(ChevronUpIcon, dropdownIconProps);
      var dropdownIcon = IconUtils.getJSXIcon(icon, _objectSpread$1n({}, dropdownIconProps), {
        props: props
      });
      var ariaLabel = props.placeholder || props.ariaLabel;
      var triggerProps = mergeProps({
        className: cx('trigger'),
        role: 'button',
        'aria-haspopup': 'listbox',
        'aria-expanded': overlayVisibleState,
        'aria-label': ariaLabel
      }, ptm('trigger'));
      return /*#__PURE__*/React__namespace.createElement("div", triggerProps, dropdownIcon);
    };
    var visibleOptions = getVisibleOptions();
    var selectedOption = getSelectedOption();
    var hasTooltip = ObjectUtils.isNotEmpty(props.tooltip);
    var otherProps = DropdownBase.getOtherProps(props);
    var ariaProps = ObjectUtils.reduceKeys(otherProps, DomHandler.ARIA_PROPS);
    var hiddenSelect = createHiddenSelect();
    var keyboardHelper = createKeyboardHelper();
    var labelElement = createLabel();
    var dropdownIcon = props.loading ? createLoadingIcon() : createDropdownIcon();
    var clearIcon = createClearIcon();
    var rootProps = mergeProps({
      id: props.id,
      ref: elementRef,
      className: classNames(props.className, cx('root', {
        context: context,
        focusedState: focusedState,
        overlayVisibleState: overlayVisibleState
      })),
      style: props.style,
      onClick: function onClick(e) {
        return _onClick(e);
      },
      onMouseDown: props.onMouseDown,
      onContextMenu: props.onContextMenu,
      onFocus: onFocus,
      'data-p-disabled': props.disabled,
      'data-p-focus': focusedState,
      'aria-activedescendant': focusedState ? "dropdownItem_".concat(focusedOptionIndex) : undefined
    }, otherProps, ptm('root'));
    var firstHiddenFocusableElementProps = mergeProps({
      ref: firstHiddenFocusableElementOnOverlay,
      role: 'presentation',
      className: 'p-hidden-accessible p-hidden-focusable',
      tabIndex: '0',
      onFocus: onFirstHiddenFocus,
      'data-p-hidden-accessible': true,
      'data-p-hidden-focusable': true
    }, ptm('hiddenFirstFocusableEl'));
    var lastHiddenFocusableElementProps = mergeProps({
      ref: lastHiddenFocusableElementOnOverlay,
      role: 'presentation',
      className: 'p-hidden-accessible p-hidden-focusable',
      tabIndex: '0',
      onFocus: onLastHiddenFocus,
      'data-p-hidden-accessible': true,
      'data-p-hidden-focusable': true
    }, ptm('hiddenLastFocusableEl'));
    return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, null, /*#__PURE__*/React__namespace.createElement("div", rootProps, keyboardHelper, hiddenSelect, labelElement, clearIcon, dropdownIcon, /*#__PURE__*/React__namespace.createElement(DropdownPanel, _extends({
      hostName: "Dropdown",
      ref: overlayRef,
      visibleOptions: visibleOptions,
      virtualScrollerRef: virtualScrollerRef
    }, props, {
      appendTo: appendTo,
      cx: cx,
      filterValue: filterValue,
      focusedOptionIndex: focusedOptionIndex,
      getOptionGroupChildren: getOptionGroupChildren,
      getOptionGroupLabel: getOptionGroupLabel,
      getOptionGroupRenderKey: getOptionGroupRenderKey,
      getOptionLabel: getOptionLabel,
      getOptionRenderKey: getOptionRenderKey,
      getSelectedOptionIndex: getSelectedOptionIndex,
      hasFilter: hasFilter,
      "in": overlayVisibleState,
      isOptionDisabled: isOptionDisabled,
      isSelected: isSelected,
      onOverlayHide: hide,
      onClick: onPanelClick,
      onEnter: onOverlayEnter,
      onEntered: onOverlayEntered,
      onExit: onOverlayExit,
      onExited: onOverlayExited,
      onFilterClearIconClick: onFilterClearIconClick,
      onFilterInputChange: onFilterInputChange,
      onFilterInputKeyDown: onFilterInputKeyDown,
      onOptionClick: onOptionClick,
      onInputKeyDown: onInputKeyDown,
      ptm: ptm,
      resetFilter: resetFilter,
      changeFocusedOptionIndex: changeFocusedOptionIndex,
      firstFocusableElement: /*#__PURE__*/React__namespace.createElement("span", firstHiddenFocusableElementProps),
      lastFocusableElement: /*#__PURE__*/React__namespace.createElement("span", lastHiddenFocusableElementProps),
      sx: sx
    }))), hasTooltip && /*#__PURE__*/React__namespace.createElement(Tooltip, _extends({
      target: elementRef,
      content: props.tooltip,
      pt: ptm('tooltip')
    }, props.tooltipOptions)));
  }));
  Dropdown.displayName = 'Dropdown';

  var RowsPerPageDropdown = /*#__PURE__*/React__namespace.memo(function (inProps) {
    useMergeProps();
    var context = React__namespace.useContext(PrimeReactContext);
    var props = RowsPerPageDropdownBase.getProps(inProps, context);
    var hasOptions = props.options && props.options.length > 0;
    var options = hasOptions ? props.options.map(function (opt) {
      return {
        label: String(opt),
        value: opt
      };
    }) : [];
    var placeholderValue = localeOption('choose');
    var ariaLabelValue = ariaLabel('jumpToPageDropdownLabel');
    var element = hasOptions ? /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, null, /*#__PURE__*/React__namespace.createElement(Dropdown, {
      value: props.value,
      options: options,
      onChange: props.onChange,
      appendTo: props.appendTo,
      disabled: props.disabled,
      placeholder: placeholderValue,
      "aria-label": ariaLabelValue,
      pt: props.ptm('RPPDropdown'),
      unstyled: props.unstyled,
      __parentMetadata: {
        parent: props.metaData
      }
    })) : null;
    if (props.template) {
      var defaultOptions = {
        value: props.value,
        options: options,
        onChange: props.onChange,
        appendTo: props.appendTo,
        currentPage: props.page,
        totalPages: props.pageCount,
        totalRecords: props.totalRecords,
        disabled: props.disabled,
        ariaLabel: ariaLabelValue,
        element: element,
        props: props
      };
      return ObjectUtils.getJSXElement(props.template, defaultOptions);
    }
    return element;
  });
  RowsPerPageDropdown.displayName = 'RowsPerPageDropdown';

  function ownKeys$1m(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
  function _objectSpread$1m(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1m(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1m(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
  var Paginator = /*#__PURE__*/React__namespace.memo(/*#__PURE__*/React__namespace.forwardRef(function (inProps, ref) {
    var mergeProps = useMergeProps();
    var context = React__namespace.useContext(PrimeReactContext);
    var props = PaginatorBase.getProps(inProps, context);
    var metaData = _objectSpread$1m({
      props: props
    }, props.__parentMetadata);
    var _PaginatorBase$setMet = PaginatorBase.setMetaData(metaData),
      ptm = _PaginatorBase$setMet.ptm,
      cx = _PaginatorBase$setMet.cx,
      isUnstyled = _PaginatorBase$setMet.isUnstyled;
    useHandleStyle(PaginatorBase.css.styles, isUnstyled, {
      name: 'paginator'
    });
    var elementRef = React__namespace.useRef(null);
    var page = Math.floor(props.first / props.rows);
    var totalPages = Math.ceil(props.totalRecords / props.rows);
    var isFirstPage = page === 0;
    var isLastPage = page === totalPages - 1;
    var isEmpty = totalPages === 0;
    var calculatePageLinkBoundaries = function calculatePageLinkBoundaries() {
      var numberOfPages = totalPages;
      var visiblePages = Math.min(props.pageLinkSize, numberOfPages);

      //calculate range, keep current in middle if necessary
      var start = Math.max(0, Math.ceil(page - visiblePages / 2));
      var end = Math.min(numberOfPages - 1, start + visiblePages - 1);

      //check when approaching to last page
      var delta = props.pageLinkSize - (end - start + 1);
      start = Math.max(0, start - delta);
      return [start, end];
    };
    var updatePageLinks = function updatePageLinks() {
      var pageLinks = [];
      var boundaries = calculatePageLinkBoundaries();
      var start = boundaries[0];
      var end = boundaries[1];
      for (var i = start; i <= end; i++) {
        pageLinks.push(i + 1);
      }
      return pageLinks;
    };
    var changePage = function changePage(first, rows) {
      var pc = totalPages;
      var p = Math.floor(first / rows);
      if (p >= 0 && p < pc) {
        var newPageState = {
          first: first,
          rows: rows,
          page: p,
          totalPages: pc
        };
        if (props.onPageChange) {
          props.onPageChange(newPageState);
        }
      }
    };
    var changePageToFirst = function changePageToFirst(event) {
      changePage(0, props.rows);
      event.preventDefault();
    };
    var changePageToPrev = function changePageToPrev(event) {
      changePage(props.first - props.rows, props.rows);
      event.preventDefault();
    };
    var onPageLinkClick = function onPageLinkClick(event) {
      changePage((event.value - 1) * props.rows, props.rows);
    };
    var changePageToNext = function changePageToNext(event) {
      changePage(props.first + props.rows, props.rows);
      event.preventDefault();
    };
    var changePageToLast = function changePageToLast(event) {
      changePage((totalPages - 1) * props.rows, props.rows);
      event.preventDefault();
    };
    var onRowsChange = function onRowsChange(event) {
      var rows = event.value;
      changePage(0, rows);
    };
    React__namespace.useImperativeHandle(ref, function () {
      return {
        props: props,
        getElement: function getElement() {
          return elementRef.current;
        }
      };
    });
    useUpdateEffect(function () {
      if (page > 0 && props.first >= props.totalRecords) {
        changePage((totalPages - 1) * props.rows, props.rows);
      }
    }, [props.totalRecords]);
    var createElement = function createElement(key, template) {
      var element;
      switch (key) {
        case 'FirstPageLink':
          element = /*#__PURE__*/React__namespace.createElement(FirstPageLink, {
            hostName: "Paginator",
            key: key,
            page: page,
            totalPages: totalPages,
            totalRecords: props.totalRecords,
            rows: props.rows,
            onClick: changePageToFirst,
            disabled: isFirstPage || isEmpty,
            template: template,
            firstPageLinkIcon: props.firstPageLinkIcon,
            ptm: ptm,
            cx: cx
          });
          break;
        case 'PrevPageLink':
          element = /*#__PURE__*/React__namespace.createElem