'use client';
import * as React from 'react';
import PrimeReact, { PrimeReactContext } from 'primereact/api';
import { useMergeProps, useStyle, useMountEffect, useUpdateEffect, useUnmountEffect } from 'primereact/hooks';
import { ObjectUtils, classNames, DomHandler } from 'primereact/utils';
import { ComponentBase } from 'primereact/componentbase';

function _extends() {
  return _extends = Object.assign ? Object.assign.bind() : function (n) {
    for (var e = 1; e < arguments.length; e++) {
      var t = arguments[e];
      for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]);
    }
    return n;
  }, _extends.apply(null, arguments);
}

function _typeof(o) {
  "@babel/helpers - typeof";

  return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) {
    return typeof o;
  } : function (o) {
    return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o;
  }, _typeof(o);
}

function toPrimitive(t, r) {
  if ("object" != _typeof(t) || !t) return t;
  var e = t[Symbol.toPrimitive];
  if (void 0 !== e) {
    var i = e.call(t, r || "default");
    if ("object" != _typeof(i)) return i;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return ("string" === r ? String : Number)(t);
}

function toPropertyKey(t) {
  var i = toPrimitive(t, "string");
  return "symbol" == _typeof(i) ? i : i + "";
}

function _defineProperty(e, r, t) {
  return (r = toPropertyKey(r)) in e ? Object.defineProperty(e, r, {
    value: t,
    enumerable: !0,
    configurable: !0,
    writable: !0
  }) : e[r] = t, e;
}

function _arrayWithHoles(r) {
  if (Array.isArray(r)) return r;
}

function _iterableToArrayLimit(r, l) {
  var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"];
  if (null != t) {
    var e,
      n,
      i,
      u,
      a = [],
      f = !0,
      o = !1;
    try {
      if (i = (t = t.call(r)).next, 0 === l) {
        if (Object(t) !== t) return;
        f = !1;
      } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0);
    } catch (r) {
      o = !0, n = r;
    } finally {
      try {
        if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return;
      } finally {
        if (o) throw n;
      }
    }
    return a;
  }
}

function _arrayLikeToArray(r, a) {
  (null == a || a > r.length) && (a = r.length);
  for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e];
  return n;
}

function _unsupportedIterableToArray(r, a) {
  if (r) {
    if ("string" == typeof r) return _arrayLikeToArray(r, a);
    var t = {}.toString.call(r).slice(8, -1);
    return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0;
  }
}

function _nonIterableRest() {
  throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}

function _slicedToArray(r, e) {
  return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest();
}

var styles = "\n@layer primereact {\n    .p-ripple {\n        overflow: hidden;\n        position: relative;\n    }\n    \n    .p-ink {\n        display: block;\n        position: absolute;\n        background: rgba(255, 255, 255, 0.5);\n        border-radius: 100%;\n        transform: scale(0);\n    }\n    \n    .p-ink-active {\n        animation: ripple 0.4s linear;\n    }\n    \n    .p-ripple-disabled .p-ink {\n        display: none;\n    }\n}\n\n@keyframes ripple {\n    100% {\n        opacity: 0;\n        transform: scale(2.5);\n    }\n}\n\n";
var classes = {
  root: 'p-ink'
};
var RippleBase = ComponentBase.extend({
  defaultProps: {
    __TYPE: 'Ripple',
    children: undefined
  },
  css: {
    styles: styles,
    classes: classes
  },
  getProps: function getProps(props) {
    return ObjectUtils.getMergedProps(props, RippleBase.defaultProps);
  },
  getOtherProps: function getOtherProps(props) {
    return ObjectUtils.getDiffProps(props, RippleBase.defaultProps);
  }
});

function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var Ripple = /*#__PURE__*/React.memo(/*#__PURE__*/React.forwardRef(function (inProps, ref) {
  var _React$useState = React.useState(false),
    _React$useState2 = _slicedToArray(_React$useState, 2),
    isMounted = _React$useState2[0],
    setMounted = _React$useState2[1];
  var inkRef = React.useRef(null);
  var targetRef = React.useRef(null);
  var mergeProps = useMergeProps();
  var context = React.useContext(PrimeReactContext);
  var props = RippleBase.getProps(inProps, context);
  var isRippleActive = context && context.ripple || PrimeReact.ripple;
  var metaData = {
    props: props
  };
  useStyle(RippleBase.css.styles, {
    name: 'ripple',
    manual: !isRippleActive
  });
  var _RippleBase$setMetaDa = RippleBase.setMetaData(_objectSpread({}, metaData)),
    ptm = _RippleBase$setMetaDa.ptm,
    cx = _RippleBase$setMetaDa.cx;
  var getTarget = function getTarget() {
    return inkRef.current && inkRef.current.parentElement;
  };
  var bindEvents = function bindEvents() {
    if (targetRef.current) {
      targetRef.current.addEventListener('pointerdown', onPointerDown);
    }
  };
  var unbindEvents = function unbindEvents() {
    if (targetRef.current) {
      targetRef.current.removeEventListener('pointerdown', onPointerDown);
    }
  };
  var onPointerDown = function onPointerDown(event) {
    var offset = DomHandler.getOffset(targetRef.current);
    var offsetX = event.pageX - offset.left + document.body.scrollTop - DomHandler.getWidth(inkRef.current) / 2;
    var offsetY = event.pageY - offset.top + document.body.scrollLeft - DomHandler.getHeight(inkRef.current) / 2;
    activateRipple(offsetX, offsetY);
  };
  var activateRipple = function activateRipple(offsetX, offsetY) {
    if (!inkRef.current || getComputedStyle(inkRef.current, null).display === 'none') {
      return;
    }
    DomHandler.removeClass(inkRef.current, 'p-ink-active');
    setDimensions();
    inkRef.current.style.top = offsetY + 'px';
    inkRef.current.style.left = offsetX + 'px';
    DomHandler.addClass(inkRef.current, 'p-ink-active');
  };
  var onAnimationEnd = function onAnimationEnd(event) {
    DomHandler.removeClass(event.currentTarget, 'p-ink-active');
  };
  var setDimensions = function setDimensions() {
    if (inkRef.current && !DomHandler.getHeight(inkRef.current) && !DomHandler.getWidth(inkRef.current)) {
      var d = Math.max(DomHandler.getOuterWidth(targetRef.current), DomHandler.getOuterHeight(targetRef.current));
      inkRef.current.style.height = d + 'px';
      inkRef.current.style.width = d + 'px';
    }
  };
  React.useImperativeHandle(ref, function () {
    return {
      props: props,
      getInk: function getInk() {
        return inkRef.current;
      },
      getTarget: function getTarget() {
        return targetRef.current;
      }
    };
  });
  useMountEffect(function () {
    // for App Router in Next.js ^14
    setMounted(true);
  });
  useUpdateEffect(function () {
    if (isMounted && inkRef.current) {
      targetRef.current = getTarget();
      setDimensions();
      bindEvents();
    }
  }, [isMounted]);
  useUpdateEffect(function () {
    if (inkRef.current && !targetRef.current) {
      targetRef.current = getTarget();
      setDimensions();
      bindEvents();
    }
  });
  useUnmountEffect(function () {
    if (inkRef.current) {
      targetRef.current = null;
      unbindEvents();
    }
  });
  if (!isRippleActive) {
    return null;
  }
  var rootProps = mergeProps({
    'aria-hidden': true,
    className: classNames(cx('root'))
  }, RippleBase.getOtherProps(props), ptm('root'));
  return /*#__PURE__*/React.createElement("span", _extends({
    role: "presentation",
    ref: inkRef
  }, rootProps, {
    onAnimationEnd: onAnimationEnd
  }));
}));
Ripple.displayName = 'Ripple';

export { Ripple };
