"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BodyCell = void 0;

var _react = _interopRequireWildcard(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _ObjectUtils = _interopRequireDefault(require("../utils/ObjectUtils"));

var _DomHandler = _interopRequireDefault(require("../utils/DomHandler"));

var _RowRadioButton = require("./RowRadioButton");

var _RowCheckbox = require("./RowCheckbox");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function () { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BodyCell = /*#__PURE__*/function (_Component) {
  _inherits(BodyCell, _Component);

  var _super = _createSuper(BodyCell);

  function BodyCell(props) {
    var _this;

    _classCallCheck(this, BodyCell);

    _this = _super.call(this, props);
    _this.state = {
      editing: _this.props.editing
    };
    _this.onExpanderClick = _this.onExpanderClick.bind(_assertThisInitialized(_this));
    _this.onClick = _this.onClick.bind(_assertThisInitialized(_this));
    _this.onBlur = _this.onBlur.bind(_assertThisInitialized(_this));
    _this.onKeyDown = _this.onKeyDown.bind(_assertThisInitialized(_this));
    _this.onEditorFocus = _this.onEditorFocus.bind(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(BodyCell, [{
    key: "onExpanderClick",
    value: function onExpanderClick(event) {
      if (this.props.onRowToggle) {
        this.props.onRowToggle({
          originalEvent: event,
          data: this.props.rowData
        });
      }

      event.preventDefault();
    }
  }, {
    key: "onKeyDown",
    value: function onKeyDown(event) {
      if (this.props.editMode !== 'row') {
        if (event.which === 13 || event.which === 9) {
          // tab || enter
          this.switchCellToViewMode(true);
        }

        if (event.which === 27) // escape
          {
            this.switchCellToViewMode(false);
          }
      }
    }
  }, {
    key: "onClick",
    value: function onClick() {
      if (this.props.editMode !== 'row') {
        this.editingCellClick = true;

        if (this.props.editor && !this.state.editing) {
          this.setState({
            editing: true
          });

          if (this.props.editorValidatorEvent === 'click') {
            this.bindDocumentEditListener();
          }
        }
      }
    }
  }, {
    key: "onBlur",
    value: function onBlur() {
      if (this.props.editMode !== 'row' && this.state.editing && this.props.editorValidatorEvent === 'blur') {
        this.switchCellToViewMode(true);
      }
    }
  }, {
    key: "onEditorFocus",
    value: function onEditorFocus(event) {
      this.onClick(event);
    }
  }, {
    key: "bindDocumentEditListener",
    value: function bindDocumentEditListener() {
      var _this2 = this;

      if (!this.documentEditListener) {
        this.documentEditListener = function (event) {
          if (!_this2.editingCellClick) {
            _this2.switchCellToViewMode(true);
          }

          _this2.editingCellClick = false;
        };

        this.editingCellClick = false;
        document.addEventListener('click', this.documentEditListener);
      }
    }
  }, {
    key: "closeCell",
    value: function closeCell() {
      var _this3 = this;

      /* When using the 'tab' key, the focus event of the next cell is not called in IE. */
      setTimeout(function () {
        _this3.setState({
          editing: false
        });
      }, 1);
      this.unbindDocumentEditListener();
    }
  }, {
    key: "switchCellToViewMode",
    value: function switchCellToViewMode(submit) {
      if (this.props.editorValidator && submit) {
        var valid = this.props.editorValidator(this.props);

        if (valid) {
          if (this.props.onEditorSubmit) {
            this.props.onEditorSubmit(this.props);
          }

          this.closeCell();
        } // as per previous version if not valid and another editor is open, keep invalid data editor open.

      } else {
        if (submit && this.props.onEditorSubmit) {
          this.props.onEditorSubmit(this.props);
        } else if (this.props.onEditorCancel) {
          this.props.onEditorCancel(this.props);
        }

        this.closeCell();
      }
    }
  }, {
    key: "unbindDocumentEditListener",
    value: function unbindDocumentEditListener() {
      if (this.documentEditListener) {
        document.removeEventListener('click', this.documentEditListener);
        this.documentEditListener = null;
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      var _this4 = this;

      if (this.props.editMode !== 'row' && this.container && this.props.editor) {
        clearTimeout(this.tabindexTimeout);

        if (this.state.editing) {
          var focusable = _DomHandler.default.findSingle(this.container, 'input');

          if (focusable && document.activeElement !== focusable && !focusable.hasAttribute('data-isCellEditing')) {
            focusable.setAttribute('data-isCellEditing', true);
            focusable.focus();
          }

          this.keyHelper.tabIndex = -1;
        } else {
          this.tabindexTimeout = setTimeout(function () {
            if (_this4.keyHelper) {
              _this4.keyHelper.setAttribute('tabindex', 0);
            }
          }, 50);
        }
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.unbindDocumentEditListener();
    }
  }, {
    key: "render",
    value: function render() {
      var _this5 = this;

      var content, header, editorKeyHelper;
      var cellClassName = (0, _classnames.default)(this.props.bodyClassName || this.props.className, {
        'p-selection-column': this.props.selectionMode,
        'p-editable-column': this.props.editor,
        'p-cell-editing': this.state.editing && this.props.editor
      });

      if (this.props.expander) {
        var iconClassName = (0, _classnames.default)('p-row-toggler-icon pi pi-fw p-clickable', {
          'pi-chevron-down': this.props.expanded,
          'pi-chevron-right': !this.props.expanded
        });
        content = /*#__PURE__*/_react.default.createElement("button", {
          type: "button",
          onClick: this.onExpanderClick,
          className: "p-row-toggler p-link"
        }, /*#__PURE__*/_react.default.createElement("span", {
          className: iconClassName
        }));
      } else if (this.props.selectionMode) {
        var showSelection = true;

        if (this.props.showSelectionElement) {
          showSelection = this.props.showSelectionElement(this.props.rowData);
        }

        if (showSelection) {
          if (this.props.selectionMode === 'single') content = /*#__PURE__*/_react.default.createElement(_RowRadioButton.RowRadioButton, {
            onClick: this.props.onRadioClick,
            rowData: this.props.rowData,
            selected: this.props.selected
          });else content = /*#__PURE__*/_react.default.createElement(_RowCheckbox.RowCheckbox, {
            onClick: this.props.onCheckboxClick,
            rowData: this.props.rowData,
            selected: this.props.selected
          });
        }
      } else if (this.props.rowReorder) {
        var showReorder = true;

        if (this.props.showRowReorderElement) {
          showReorder = this.props.showRowReorderElement(this.props.rowData);
        }

        if (showReorder) {
          var reorderIcon = (0, _classnames.default)('p-table-reorderablerow-handle', this.props.rowReorderIcon);
          content = /*#__PURE__*/_react.default.createElement("i", {
            className: reorderIcon
          });
        }
      } else if (this.props.rowEditor) {
        if (this.state.editing) {
          content = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("button", {
            type: "button",
            onClick: this.props.onRowEditSave,
            className: "p-row-editor-save p-link"
          }, /*#__PURE__*/_react.default.createElement("span", {
            className: "p-row-editor-save-icon pi pi-fw pi-check p-clickable"
          })), /*#__PURE__*/_react.default.createElement("button", {
            type: "button",
            onClick: this.props.onRowEditCancel,
            className: "p-row-editor-cancel p-link"
          }, /*#__PURE__*/_react.default.createElement("span", {
            className: "p-row-editor-cancel-icon pi pi-fw pi-times p-clickable"
          })));
        } else {
          content = /*#__PURE__*/_react.default.createElement("button", {
            type: "button",
            onClick: this.props.onRowEditInit,
            className: "p-row-editor-init p-link"
          }, /*#__PURE__*/_react.default.createElement("span", {
            className: "p-row-editor-init-icon pi pi-fw pi-pencil p-clickable"
          }));
        }
      } else {
        if (this.state.editing && this.props.editor) {
          content = this.props.editor(this.props);
        } else {
          if (this.props.body) content = this.props.body(this.props.rowData, this.props);else content = _ObjectUtils.default.resolveFieldData(this.props.rowData, this.props.field);
        }
      }

      if (this.props.responsive) {
        header = /*#__PURE__*/_react.default.createElement("span", {
          className: "p-column-title"
        }, this.props.header);
      }

      if (this.props.editMode !== 'row') {
        /* eslint-disable */
        editorKeyHelper = this.props.editor && /*#__PURE__*/_react.default.createElement("a", {
          tabIndex: "0",
          ref: function ref(el) {
            _this5.keyHelper = el;
          },
          className: "p-cell-editor-key-helper p-hidden-accessible",
          onFocus: this.onEditorFocus
        }, /*#__PURE__*/_react.default.createElement("span", null));
        /* eslint-enable */
      }

      return /*#__PURE__*/_react.default.createElement("td", {
        ref: function ref(el) {
          _this5.container = el;
        },
        className: cellClassName,
        style: this.props.bodyStyle || this.props.style,
        onClick: this.onClick,
        onKeyDown: this.onKeyDown,
        rowSpan: this.props.rowSpan,
        onBlur: this.onBlur
      }, header, editorKeyHelper, content);
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, prevState) {
      if (nextProps.editMode === 'row' && nextProps.editing !== prevState.editing) {
        return {
          editing: nextProps.editing
        };
      }

      return null;
    }
  }]);

  return BodyCell;
}(_react.Component);

exports.BodyCell = BodyCell;